#ifndef _ALPHATAB64_
#define _ALPHATAB64_

/*-- Defines nx064[a][b][c][d] where
       a = number of slices - 1
       b = alpha index
       c = FWHM index
       d = pval index
     Value is the cluster count significant,
     at the chosen alpha level, for the given simulation --*/

#define NALPH 3
#define NPVAL 32
#define NFWHM 21
#define NZMAX 30
static float alpha01_nx064_nz01_fwhm000[32] = {
 1.96,1.97,1.98,1.98,1.98,1.98,1.99,1.99,1.99,1.99,
 1.99,1.99,1.99,2.00,2.31,2.59,2.75,2.82,2.90,2.94,
 2.96,2.98,2.99,3.16,3.41,3.75,3.89,3.99,4.55,4.83,
 5.34,5.95};
static float alpha01_nx064_nz01_fwhm025[32] = {
 1.96,1.97,1.98,1.98,1.98,1.98,1.99,1.99,1.99,1.99,
 1.99,1.99,1.99,2.00,2.31,2.59,2.75,2.82,2.90,2.94,
 2.96,2.98,2.99,3.16,3.41,3.75,3.89,3.99,4.55,4.83,
 5.34,5.95};
static float alpha01_nx064_nz01_fwhm050[32] = {
 1.96,1.97,1.98,1.98,1.98,1.99,1.99,1.99,1.99,1.99,
 1.99,1.99,1.99,2.04,2.38,2.64,2.77,2.84,2.91,2.95,
 2.97,2.99,3.00,3.28,3.51,3.79,3.92,4.04,4.62,4.86,
 5.49,5.97};
static float alpha01_nx064_nz01_fwhm075[32] = {
 1.96,1.97,1.98,1.98,1.98,1.99,1.99,1.99,1.99,1.99,
 2.00,2.00,2.00,2.42,2.64,2.77,2.85,2.89,2.95,2.97,
 2.99,3.23,3.47,3.64,3.74,3.92,4.00,4.59,4.87,5.01,
 5.89,6.60};
static float alpha01_nx064_nz01_fwhm100[32] = {
 1.97,1.97,1.98,1.98,1.99,1.99,1.99,1.99,2.00,2.24,
 2.44,2.54,2.61,2.76,2.84,2.90,2.94,2.97,3.00,3.44,
 3.67,3.79,3.88,3.95,3.99,4.55,4.78,4.99,5.66,6.00,
 6.90,7.73};
static float alpha01_nx064_nz01_fwhm125[32] = {
 1.97,1.98,1.98,1.99,1.99,2.00,2.39,2.60,2.71,2.78,
 2.82,2.85,2.88,2.93,2.96,3.00,3.42,3.66,3.89,3.98,
 4.38,4.60,4.76,4.89,4.95,5.62,5.92,6.57,6.98,7.68,
 8.84,10.02};
static float alpha01_nx064_nz01_fwhm150[32] = {
 1.99,2.00,2.23,2.49,2.67,2.75,2.85,2.91,2.95,2.97,
 2.99,3.12,3.31,3.67,3.84,3.98,4.40,4.63,4.92,5.25,
 5.64,5.89,6.01,6.41,6.70,7.34,7.88,8.76,9.74,10.70,
 12.36,13.88};
static float alpha01_nx064_nz01_fwhm175[32] = {
 2.55,2.74,2.81,2.88,2.94,2.99,3.38,3.63,3.79,3.95,
 4.05,4.27,4.43,4.74,4.94,5.36,5.71,5.92,6.59,6.99,
 7.59,7.91,8.43,8.74,8.97,10.07,11.28,12.26,13.59,14.94,
 17.55,19.80};
static float alpha01_nx064_nz01_fwhm200[32] = {
 2.87,2.95,3.14,3.47,3.71,3.90,4.25,4.62,4.83,4.95,
 5.14,5.46,5.60,5.93,6.37,6.73,7.26,7.75,8.52,9.10,
 9.81,10.49,11.08,11.56,11.93,13.65,14.80,16.32,18.28,19.85,
 23.45,27.67};
static float alpha01_nx064_nz01_fwhm225[32] = {
 3.36,3.68,3.88,4.18,4.50,4.75,4.99,5.54,5.76,5.94,
 6.23,6.56,6.78,7.43,7.86,8.35,9.02,9.59,10.66,11.63,
 12.51,13.03,13.78,14.50,15.36,17.11,18.70,20.61,23.31,25.89,
 30.85,35.75};
static float alpha01_nx064_nz01_fwhm250[32] = {
 3.91,4.36,4.59,4.84,5.00,5.44,5.95,6.52,6.90,7.22,
 7.51,7.73,7.97,8.68,9.40,10.10,10.80,11.50,12.66,13.86,
 15.05,15.86,16.68,17.52,18.37,20.69,22.66,25.50,28.74,32.11,
 37.62,42.79};
static float alpha01_nx064_nz01_fwhm275[32] = {
 4.48,4.77,4.97,5.47,5.86,6.31,6.91,7.48,7.81,8.24,
 8.63,8.94,9.43,10.28,10.75,11.48,12.48,13.32,15.10,16.34,
 17.61,18.68,19.69,20.69,21.59,24.53,27.04,30.27,33.86,37.60,
 44.00,51.07};
static float alpha01_nx064_nz01_fwhm300[32] = {
 4.85,5.30,5.64,5.99,6.65,7.10,7.81,8.43,8.93,9.23,
 9.84,10.19,10.58,11.29,12.03,13.25,14.33,15.52,17.31,18.94,
 20.30,21.37,22.61,23.50,24.65,28.08,31.12,34.67,39.24,42.67,
 51.50,60.17};
static float alpha01_nx064_nz01_fwhm325[32] = {
 5.29,5.84,6.20,6.82,7.30,7.84,8.68,9.18,9.84,10.38,
 10.78,11.18,11.68,12.80,14.00,15.10,16.32,17.56,19.35,21.41,
 22.68,24.05,25.46,26.83,28.10,31.91,35.35,39.07,44.12,49.30,
 58.56,68.90};
static float alpha01_nx064_nz01_fwhm350[32] = {
 5.65,6.34,6.86,7.39,7.91,8.43,9.46,10.25,10.80,11.27,
 11.90,12.55,12.90,14.33,15.55,16.79,18.08,19.38,21.61,23.48,
 25.32,26.81,28.39,29.77,31.37,35.22,39.29,44.00,49.67,55.70,
 66.29,76.62};
static float alpha01_nx064_nz01_fwhm375[32] = {
 6.10,6.64,7.32,7.86,8.45,9.08,10.31,10.91,11.78,12.61,
 13.10,13.65,14.12,15.42,16.60,18.23,19.69,21.09,23.58,25.81,
 27.75,29.95,31.53,32.87,34.68,39.17,43.38,49.00,55.69,61.30,
 73.40,85.17};
static float alpha01_nx064_nz01_fwhm400[32] = {
 6.35,7.09,7.66,8.29,9.19,9.87,10.88,11.86,12.67,13.47,
 13.93,14.68,15.09,16.62,18.18,19.62,21.29,22.81,25.59,28.22,
 30.22,32.74,34.59,36.00,37.47,42.70,47.79,54.21,61.08,67.67,
 80.20,93.38};
static float alpha01_nx064_nz01_fwhm425[32] = {
 6.62,7.38,8.09,8.84,9.91,10.52,11.66,12.62,13.58,14.22,
 14.83,15.62,16.18,18.00,19.45,21.15,22.96,24.78,28.11,30.55,
 32.93,35.12,37.31,39.00,41.06,46.70,52.33,59.27,66.40,73.30,
 87.57,102.14};
static float alpha01_nx064_nz01_fwhm450[32] = {
 6.93,7.74,8.44,9.28,10.32,10.98,12.36,13.38,14.10,14.88,
 15.90,16.63,17.43,19.15,20.76,22.82,24.65,26.89,30.11,33.00,
 35.62,38.05,40.11,42.44,44.35,51.40,56.85,63.23,71.57,80.14,
 95.80,111.00};
static float alpha01_nx064_nz01_fwhm475[32] = {
 7.08,8.00,8.90,9.91,10.75,11.59,13.10,13.90,15.20,16.00,
 17.04,18.00,18.64,20.52,22.37,24.39,26.89,28.65,32.38,35.25,
 38.30,40.95,42.91,45.50,47.71,55.20,60.89,68.00,76.89,86.20,
 102.50,120.36};
static float alpha01_nx064_nz01_fwhm500[32] = {
 7.29,8.34,9.22,10.16,11.23,12.13,13.73,14.95,15.97,17.24,
 18.18,18.76,19.79,21.96,23.96,26.40,28.72,30.62,34.50,37.70,
 40.84,43.86,45.94,48.14,51.44,58.30,64.83,73.43,82.50,92.40,
 109.83,125.62};
static float *alpha01_nx064_nz01[21] = {
 alpha01_nx064_nz01_fwhm000, alpha01_nx064_nz01_fwhm025, alpha01_nx064_nz01_fwhm050, 
 alpha01_nx064_nz01_fwhm075, alpha01_nx064_nz01_fwhm100, alpha01_nx064_nz01_fwhm125, 
 alpha01_nx064_nz01_fwhm150, alpha01_nx064_nz01_fwhm175, alpha01_nx064_nz01_fwhm200, 
 alpha01_nx064_nz01_fwhm225, alpha01_nx064_nz01_fwhm250, alpha01_nx064_nz01_fwhm275, 
 alpha01_nx064_nz01_fwhm300, alpha01_nx064_nz01_fwhm325, alpha01_nx064_nz01_fwhm350, 
 alpha01_nx064_nz01_fwhm375, alpha01_nx064_nz01_fwhm400, alpha01_nx064_nz01_fwhm425, 
 alpha01_nx064_nz01_fwhm450, alpha01_nx064_nz01_fwhm475, alpha01_nx064_nz01_fwhm500} ;

static float alpha05_nx064_nz01_fwhm000[32] = {
 1.82,1.86,1.88,1.90,1.91,1.92,1.93,1.94,1.94,1.95,
 1.95,1.95,1.95,1.96,1.96,1.97,1.99,2.09,2.48,2.66,
 2.76,2.83,2.87,2.90,2.93,2.98,3.26,3.64,3.85,3.97,
 4.63,4.96};
static float alpha05_nx064_nz01_fwhm025[32] = {
 1.82,1.86,1.88,1.90,1.91,1.92,1.93,1.94,1.94,1.95,
 1.95,1.95,1.95,1.96,1.96,1.97,1.99,2.10,2.48,2.66,
 2.76,2.83,2.87,2.90,2.93,2.98,3.26,3.64,3.85,3.97,
 4.63,4.96};
static float alpha05_nx064_nz01_fwhm050[32] = {
 1.82,1.86,1.88,1.90,1.91,1.92,1.93,1.94,1.94,1.95,
 1.95,1.95,1.95,1.96,1.97,1.98,1.99,2.16,2.52,2.69,
 2.78,2.84,2.88,2.91,2.94,2.99,3.36,3.69,3.88,3.99,
 4.70,4.99};
static float alpha05_nx064_nz01_fwhm075[32] = {
 1.82,1.86,1.88,1.90,1.91,1.92,1.93,1.94,1.94,1.95,
 1.95,1.95,1.96,1.97,1.98,1.99,2.19,2.42,2.66,2.78,
 2.85,2.90,2.93,2.95,2.97,3.31,3.64,3.85,3.98,4.45,
 4.91,5.59};
static float alpha05_nx064_nz01_fwhm100[32] = {
 1.82,1.86,1.88,1.90,1.91,1.92,1.94,1.94,1.95,1.96,
 1.96,1.97,1.97,1.99,2.15,2.42,2.60,2.71,2.84,2.91,
 2.95,2.98,3.08,3.35,3.52,3.80,3.93,4.31,4.74,4.96,
 5.81,6.49};
static float alpha05_nx064_nz01_fwhm125[32] = {
 1.82,1.86,1.88,1.90,1.92,1.93,1.95,1.97,1.98,1.99,
 2.02,2.17,2.30,2.53,2.67,2.79,2.87,2.92,2.99,3.37,
 3.62,3.77,3.87,3.94,4.00,4.61,4.87,5.38,5.84,6.38,
 7.26,8.32};
static float alpha05_nx064_nz01_fwhm150[32] = {
 1.83,1.87,1.90,1.93,1.95,1.97,2.04,2.34,2.49,2.59,
 2.67,2.73,2.78,2.88,2.95,3.13,3.48,3.69,3.93,4.22,
 4.55,4.77,4.92,5.11,5.40,5.90,6.50,7.03,7.86,8.63,
 9.92,11.45};
static float alpha05_nx064_nz01_fwhm175[32] = {
 1.87,1.93,1.96,2.04,2.26,2.45,2.66,2.78,2.86,2.93,
 2.97,3.09,3.29,3.64,3.84,4.04,4.48,4.72,5.12,5.61,
 5.90,6.21,6.58,6.85,7.16,7.98,8.77,9.70,10.86,11.95,
 14.14,16.22};
static float alpha05_nx064_nz01_fwhm200[32] = {
 1.93,2.02,2.27,2.50,2.67,2.79,2.96,3.25,3.53,3.72,
 3.86,3.99,4.19,4.60,4.85,5.22,5.63,5.94,6.65,7.13,
 7.70,8.18,8.64,8.97,9.48,10.62,11.70,12.92,14.48,16.02,
 18.90,21.88};
static float alpha05_nx064_nz01_fwhm225[32] = {
 1.99,2.33,2.56,2.76,2.93,3.10,3.66,3.96,4.23,4.50,
 4.69,4.84,4.94,5.49,5.86,6.34,6.87,7.34,8.14,8.91,
 9.62,10.15,10.78,11.35,11.84,13.33,14.72,16.32,18.30,20.29,
 24.15,28.05};
static float alpha05_nx064_nz01_fwhm250[32] = {
 2.19,2.52,2.74,2.97,3.41,3.71,4.18,4.55,4.81,5.02,
 5.33,5.60,5.82,6.39,6.85,7.42,8.01,8.67,9.72,10.62,
 11.44,12.23,12.89,13.61,14.19,15.95,17.65,19.70,22.27,24.73,
 29.58,34.40};
static float alpha05_nx064_nz01_fwhm275[32] = {
 2.29,2.67,2.92,3.36,3.79,4.08,4.61,4.94,5.33,5.68,
 5.97,6.28,6.55,7.25,7.83,8.51,9.32,9.99,11.23,12.30,
 13.19,14.17,14.91,15.76,16.50,18.72,20.74,23.32,26.34,29.27,
 34.91,40.30};
static float alpha05_nx064_nz01_fwhm300[32] = {
 2.33,2.77,3.09,3.62,4.09,4.45,4.86,5.37,5.82,6.25,
 6.63,6.93,7.28,8.04,8.76,9.57,10.47,11.32,12.68,13.94,
 15.15,16.02,17.03,17.98,18.86,21.44,23.89,26.94,30.24,33.43,
 39.96,46.31};
static float alpha05_nx064_nz01_fwhm325[32] = {
 2.33,2.80,3.31,3.84,4.31,4.63,5.14,5.76,6.33,6.78,
 7.17,7.61,7.91,8.81,9.60,10.57,11.62,12.53,14.18,15.50,
 16.79,17.94,19.07,20.17,21.29,24.31,26.87,30.01,34.00,37.80,
 45.32,52.53};
static float alpha05_nx064_nz01_fwhm350[32] = {
 2.33,2.80,3.34,3.89,4.42,4.75,5.49,6.16,6.79,7.27,
 7.74,8.10,8.54,9.58,10.48,11.54,12.74,13.75,15.58,17.16,
 18.72,20.09,21.27,22.52,23.70,26.86,29.75,33.39,37.68,42.29,
 50.29,58.29};
static float alpha05_nx064_nz01_fwhm375[32] = {
 2.33,2.80,3.34,3.90,4.48,4.92,5.85,6.57,7.14,7.65,
 8.14,8.67,9.12,10.31,11.33,12.51,13.79,14.99,16.96,18.89,
 20.51,21.89,23.31,24.67,25.89,29.35,32.72,36.90,41.50,46.25,
 55.43,64.42};
static float alpha05_nx064_nz01_fwhm400[32] = {
 2.33,2.80,3.34,3.92,4.58,5.11,6.03,6.80,7.49,8.05,
 8.69,9.28,9.68,11.00,12.05,13.50,14.87,16.08,18.42,20.31,
 22.21,23.80,25.26,26.88,28.28,31.99,35.36,40.00,45.33,50.45,
 60.27,70.25};
static float alpha05_nx064_nz01_fwhm425[32] = {
 2.33,2.80,3.34,3.95,4.60,5.16,6.23,7.00,7.80,8.51,
 9.27,9.79,10.26,11.62,12.84,14.37,15.79,17.34,19.79,21.98,
 23.86,25.62,27.43,28.90,30.51,34.48,38.30,43.29,48.94,54.79,
 65.34,76.16};
static float alpha05_nx064_nz01_fwhm450[32] = {
 2.33,2.80,3.34,3.95,4.65,5.29,6.37,7.31,8.12,8.97,
 9.65,10.23,10.77,12.31,13.69,15.09,16.89,18.43,21.05,23.34,
 25.52,27.53,29.47,30.91,32.45,36.88,40.92,46.36,52.70,58.77,
 70.45,82.26};
static float alpha05_nx064_nz01_fwhm475[32] = {
 2.33,2.80,3.34,3.95,4.65,5.31,6.57,7.57,8.49,9.24,
 9.98,10.68,11.21,12.92,14.32,16.10,17.88,19.40,22.38,24.75,
 27.15,29.14,31.11,32.81,34.46,39.39,43.91,49.77,56.03,62.54,
 76.21,88.23};
static float alpha05_nx064_nz01_fwhm500[32] = {
 2.33,2.80,3.34,3.95,4.65,5.31,6.58,7.75,8.70,9.55,
 10.36,11.09,11.71,13.56,15.00,16.96,18.71,20.41,23.59,26.30,
 28.67,30.94,32.88,34.92,36.55,41.94,46.74,52.63,59.74,67.34,
 81.24,93.87};
static float *alpha05_nx064_nz01[21] = {
 alpha05_nx064_nz01_fwhm000, alpha05_nx064_nz01_fwhm025, alpha05_nx064_nz01_fwhm050, 
 alpha05_nx064_nz01_fwhm075, alpha05_nx064_nz01_fwhm100, alpha05_nx064_nz01_fwhm125, 
 alpha05_nx064_nz01_fwhm150, alpha05_nx064_nz01_fwhm175, alpha05_nx064_nz01_fwhm200, 
 alpha05_nx064_nz01_fwhm225, alpha05_nx064_nz01_fwhm250, alpha05_nx064_nz01_fwhm275, 
 alpha05_nx064_nz01_fwhm300, alpha05_nx064_nz01_fwhm325, alpha05_nx064_nz01_fwhm350, 
 alpha05_nx064_nz01_fwhm375, alpha05_nx064_nz01_fwhm400, alpha05_nx064_nz01_fwhm425, 
 alpha05_nx064_nz01_fwhm450, alpha05_nx064_nz01_fwhm475, alpha05_nx064_nz01_fwhm500} ;

static float alpha10_nx064_nz01_fwhm000[32] = {
 1.64,1.71,1.75,1.79,1.82,1.84,1.86,1.88,1.88,1.89,
 1.89,1.90,1.90,1.91,1.91,1.92,1.94,1.95,2.00,2.31,
 2.51,2.64,2.72,2.77,2.82,2.90,2.95,3.22,3.62,3.82,
 4.11,4.71};
static float alpha10_nx064_nz01_fwhm025[32] = {
 1.64,1.71,1.75,1.79,1.82,1.84,1.86,1.88,1.88,1.89,
 1.89,1.90,1.90,1.91,1.91,1.92,1.94,1.95,2.00,2.31,
 2.51,2.64,2.72,2.77,2.82,2.90,2.95,3.22,3.62,3.82,
 4.11,4.71};
static float alpha10_nx064_nz01_fwhm050[32] = {
 1.64,1.71,1.75,1.79,1.82,1.84,1.86,1.88,1.88,1.89,
 1.90,1.90,1.90,1.91,1.91,1.93,1.94,1.96,2.04,2.36,
 2.55,2.66,2.74,2.79,2.83,2.91,2.97,3.30,3.66,3.84,
 4.25,4.76};
static float alpha10_nx064_nz01_fwhm075[32] = {
 1.64,1.71,1.75,1.79,1.82,1.84,1.86,1.88,1.89,1.89,
 1.90,1.90,1.91,1.91,1.92,1.94,1.96,1.98,2.30,2.54,
 2.67,2.76,2.81,2.85,2.88,2.96,3.19,3.59,3.82,3.96,
 4.62,4.98};
static float alpha10_nx064_nz01_fwhm100[32] = {
 1.64,1.71,1.76,1.79,1.82,1.84,1.87,1.88,1.89,1.90,
 1.91,1.91,1.92,1.94,1.96,1.98,2.17,2.40,2.64,2.76,
 2.83,2.88,2.92,2.96,2.99,3.47,3.72,3.91,4.30,4.68,
 5.26,5.88};
static float alpha10_nx064_nz01_fwhm125[32] = {
 1.64,1.71,1.76,1.79,1.83,1.85,1.88,1.90,1.92,1.93,
 1.94,1.95,1.97,2.04,2.31,2.53,2.68,2.76,2.88,2.95,
 3.08,3.37,3.56,3.69,3.79,4.00,4.47,4.85,5.31,5.79,
 6.65,7.55};
static float alpha10_nx064_nz01_fwhm150[32] = {
 1.64,1.71,1.76,1.81,1.85,1.88,1.93,1.96,1.99,2.13,
 2.27,2.39,2.48,2.66,2.77,2.87,2.96,3.15,3.59,3.80,
 3.95,4.20,4.47,4.67,4.82,5.34,5.81,6.41,7.06,7.76,
 8.95,10.29};
static float alpha10_nx064_nz01_fwhm175[32] = {
 1.64,1.74,1.81,1.87,1.92,1.97,2.18,2.40,2.55,2.66,
 2.74,2.80,2.86,2.99,3.34,3.63,3.86,4.03,4.57,4.89,
 5.21,5.56,5.80,6.02,6.40,7.08,7.81,8.69,9.71,10.72,
 12.61,14.45};
static float alpha10_nx064_nz01_fwhm200[32] = {
 1.64,1.77,1.86,1.95,2.11,2.31,2.60,2.76,2.88,2.97,
 3.18,3.38,3.54,3.87,4.18,4.56,4.85,5.17,5.78,6.27,
 6.73,7.16,7.59,7.92,8.31,9.37,10.33,11.51,12.80,14.14,
 16.81,19.39};
static float alpha10_nx064_nz01_fwhm225[32] = {
 1.64,1.78,1.92,2.08,2.36,2.57,2.86,3.09,3.42,3.68,
 3.88,4.04,4.23,4.67,4.96,5.43,5.87,6.34,7.03,7.74,
 8.34,8.88,9.40,9.87,10.35,11.65,12.87,14.34,16.16,17.95,
 21.36,24.56};
static float alpha10_nx064_nz01_fwhm250[32] = {
 1.64,1.78,1.95,2.25,2.56,2.76,3.17,3.59,3.91,4.19,
 4.45,4.64,4.79,5.30,5.77,6.24,6.82,7.41,8.33,9.16,
 9.84,10.53,11.15,11.75,12.37,13.84,15.33,17.28,19.53,21.66,
 25.85,29.98};
static float alpha10_nx064_nz01_fwhm275[32] = {
 1.64,1.78,1.95,2.33,2.67,2.92,3.53,3.97,4.31,4.59,
 4.81,4.98,5.28,5.90,6.52,7.08,7.79,8.47,9.55,10.48,
 11.28,12.06,12.83,13.58,14.22,16.12,17.85,20.13,22.74,25.31,
 30.30,35.09};
static float alpha10_nx064_nz01_fwhm300[32] = {
 1.64,1.78,1.95,2.36,2.73,3.06,3.75,4.23,4.58,4.86,
 5.17,5.50,5.80,6.56,7.17,7.86,8.72,9.47,10.66,11.74,
 12.67,13.63,14.52,15.34,16.13,18.31,20.26,23.02,26.11,29.05,
 34.70,40.40};
static float alpha10_nx064_nz01_fwhm325[32] = {
 1.64,1.78,1.95,2.36,2.76,3.17,3.92,4.40,4.79,5.12,
 5.56,5.92,6.28,7.04,7.77,8.65,9.55,10.38,11.68,12.93,
 14.07,15.22,16.15,17.09,18.04,20.47,22.93,25.88,29.30,32.64,
 39.14,45.47};
static float alpha10_nx064_nz01_fwhm350[32] = {
 1.64,1.78,1.95,2.36,2.76,3.17,3.97,4.50,4.95,5.44,
 5.88,6.28,6.58,7.57,8.41,9.31,10.31,11.22,12.81,14.18,
 15.56,16.80,17.86,18.91,19.81,22.77,25.44,28.59,32.40,36.15,
 43.48,50.21};
static float alpha10_nx064_nz01_fwhm375[32] = {
 1.64,1.78,1.95,2.36,2.76,3.17,4.02,4.61,5.13,5.65,
 6.13,6.54,6.91,7.95,8.87,9.96,11.09,12.13,13.89,15.47,
 16.95,18.20,19.44,20.60,21.69,24.79,27.71,31.28,35.56,39.85,
 47.52,55.18};
static float alpha10_nx064_nz01_fwhm400[32] = {
 1.64,1.78,1.95,2.36,2.76,3.17,4.03,4.69,5.28,5.85,
 6.34,6.77,7.25,8.33,9.42,10.62,11.89,12.99,14.94,16.67,
 18.18,19.57,20.88,22.17,23.54,26.87,30.08,34.02,38.80,43.21,
 51.89,60.37};
static float alpha10_nx064_nz01_fwhm425[32] = {
 1.64,1.78,1.95,2.36,2.76,3.17,4.03,4.69,5.38,6.00,
 6.56,6.98,7.52,8.76,9.88,11.19,12.65,13.91,15.96,17.81,
 19.49,21.11,22.48,23.84,25.19,28.96,32.41,36.81,41.84,46.73,
 56.20,64.99};
static float alpha10_nx064_nz01_fwhm450[32] = {
 1.64,1.78,1.95,2.36,2.76,3.17,4.03,4.69,5.41,6.13,
 6.70,7.22,7.72,9.11,10.33,11.69,13.30,14.61,16.79,18.86,
 20.77,22.44,23.94,25.52,27.04,31.03,34.92,39.52,44.84,50.08,
 60.01,69.69};
static float alpha10_nx064_nz01_fwhm475[32] = {
 1.64,1.78,1.95,2.36,2.76,3.17,4.03,4.69,5.41,6.13,
 6.79,7.34,7.93,9.49,10.78,12.15,13.83,15.25,17.84,19.91,
 21.79,23.74,25.45,27.10,28.80,33.00,36.92,42.01,47.69,53.03,
 63.90,74.64};
static float alpha10_nx064_nz01_fwhm500[32] = {
 1.64,1.78,1.95,2.36,2.76,3.17,4.03,4.69,5.41,6.13,
 6.79,7.49,8.14,9.79,11.02,12.70,14.42,16.05,18.75,20.92,
 23.07,24.98,26.93,28.70,30.45,35.02,39.15,44.46,50.55,56.23,
 67.96,79.57};
static float *alpha10_nx064_nz01[21] = {
 alpha10_nx064_nz01_fwhm000, alpha10_nx064_nz01_fwhm025, alpha10_nx064_nz01_fwhm050, 
 alpha10_nx064_nz01_fwhm075, alpha10_nx064_nz01_fwhm100, alpha10_nx064_nz01_fwhm125, 
 alpha10_nx064_nz01_fwhm150, alpha10_nx064_nz01_fwhm175, alpha10_nx064_nz01_fwhm200, 
 alpha10_nx064_nz01_fwhm225, alpha10_nx064_nz01_fwhm250, alpha10_nx064_nz01_fwhm275, 
 alpha10_nx064_nz01_fwhm300, alpha10_nx064_nz01_fwhm325, alpha10_nx064_nz01_fwhm350, 
 alpha10_nx064_nz01_fwhm375, alpha10_nx064_nz01_fwhm400, alpha10_nx064_nz01_fwhm425, 
 alpha10_nx064_nz01_fwhm450, alpha10_nx064_nz01_fwhm475, alpha10_nx064_nz01_fwhm500} ;

static float **nx064_nz01[3] = {
  alpha01_nx064_nz01 , alpha05_nx064_nz01 , alpha10_nx064_nz01 };

static float alpha01_nx064_nz02_fwhm000[32] = {
 1.98,1.98,1.99,1.99,1.99,1.99,1.99,1.99,2.00,2.00,
 2.00,2.17,2.32,2.62,2.75,2.85,2.90,2.93,2.97,2.99,
 3.18,3.51,3.67,3.78,3.86,3.97,4.38,4.81,4.99,5.61,
 6.29,7.15};
static float alpha01_nx064_nz02_fwhm025[32] = {
 1.98,1.98,1.99,1.99,1.99,1.99,1.99,1.99,2.00,2.00,
 2.00,2.17,2.32,2.62,2.75,2.85,2.90,2.93,2.97,2.99,
 3.18,3.51,3.67,3.78,3.86,3.97,4.38,4.81,4.99,5.61,
 6.29,7.15};
static float alpha01_nx064_nz02_fwhm050[32] = {
 1.98,1.98,1.99,1.99,1.99,1.99,1.99,1.99,2.00,2.00,
 2.04,2.26,2.41,2.67,2.78,2.87,2.92,2.94,2.98,3.00,
 3.33,3.59,3.73,3.83,3.89,3.99,4.51,4.86,5.17,5.70,
 6.51,7.48};
static float alpha01_nx064_nz02_fwhm075[32] = {
 1.98,1.98,1.99,1.99,1.99,1.99,1.99,2.00,2.12,2.37,
 2.52,2.61,2.68,2.81,2.88,2.93,2.96,2.98,3.14,3.53,
 3.71,3.84,3.92,3.96,3.99,4.60,4.89,5.17,5.80,6.27,
 7.30,8.39};
static float alpha01_nx064_nz02_fwhm100[32] = {
 1.98,1.99,1.99,1.99,2.00,2.19,2.52,2.66,2.76,2.81,
 2.85,2.88,2.91,2.95,2.98,3.02,3.41,3.59,3.86,3.96,
 4.09,4.47,4.69,4.84,4.92,5.54,5.94,6.61,7.23,7.94,
 9.42,10.89};
static float alpha01_nx064_nz02_fwhm125[32] = {
 2.24,2.40,2.57,2.68,2.78,2.84,2.91,2.95,2.98,3.00,
 3.26,3.41,3.55,3.79,3.91,3.99,4.34,4.66,4.97,5.47,
 5.78,5.98,6.42,6.73,6.94,7.74,8.55,9.58,10.61,11.75,
 13.76,15.87};
static float alpha01_nx064_nz02_fwhm150[32] = {
 2.83,2.91,2.96,3.04,3.39,3.66,3.82,3.92,4.14,4.40,
 4.60,4.75,4.85,5.14,5.59,5.96,6.51,6.86,7.62,8.26,
 8.78,9.29,9.79,10.29,10.69,12.06,13.33,14.80,16.41,18.29,
 21.81,25.43};
static float alpha01_nx064_nz02_fwhm175[32] = {
 3.60,3.84,4.09,4.41,4.76,4.93,5.45,5.86,6.17,6.56,
 6.82,6.99,7.29,7.88,8.54,9.02,9.71,10.36,11.49,12.35,
 13.03,13.97,14.86,15.60,16.31,18.24,20.05,22.72,25.58,28.25,
 34.13,40.21};
static float alpha01_nx064_nz02_fwhm200[32] = {
 4.42,4.81,5.06,5.52,5.94,6.40,7.07,7.59,7.97,8.41,
 8.76,8.99,9.45,10.23,10.92,11.69,12.71,13.71,15.16,16.50,
 17.73,18.88,19.91,21.00,22.23,25.28,27.69,31.45,35.61,39.36,
 47.68,54.38};
static float alpha01_nx064_nz02_fwhm225[32] = {
 5.15,5.68,6.20,6.74,7.40,7.96,8.70,9.17,9.82,10.25,
 10.68,11.21,11.68,12.70,13.88,14.75,15.90,17.25,19.00,20.95,
 22.31,24.07,25.69,27.08,28.65,32.30,36.00,40.38,45.60,50.50,
 60.15,69.86};
static float alpha01_nx064_nz02_fwhm250[32] = {
 6.02,6.73,7.29,8.02,8.72,9.08,10.15,11.05,11.92,12.34,
 12.95,13.57,14.08,15.37,16.70,17.96,19.29,20.87,23.50,25.96,
 28.16,29.85,31.54,33.12,34.84,39.54,43.25,49.10,55.33,61.85,
 73.79,87.56};
static float alpha01_nx064_nz02_fwhm275[32] = {
 6.74,7.46,8.15,9.20,9.98,10.75,11.83,12.66,13.49,14.48,
 15.00,15.79,16.45,18.03,19.46,21.21,23.05,24.61,27.61,30.31,
 32.61,34.75,36.81,38.95,40.87,46.00,51.58,58.21,65.46,73.10,
 87.92,103.50};
static float alpha01_nx064_nz02_fwhm300[32] = {
 7.44,8.41,9.28,10.23,11.12,11.85,13.00,14.46,15.40,16.41,
 17.31,18.00,18.66,20.33,22.08,24.16,25.81,28.19,31.27,34.31,
 37.23,39.50,42.20,45.18,47.29,53.12,59.27,67.15,75.50,84.22,
 102.71,120.00};
static float alpha01_nx064_nz02_fwhm325[32] = {
 8.22,9.31,10.07,10.97,12.20,13.13,14.56,15.88,17.23,18.33,
 19.18,19.89,20.89,22.81,24.38,26.50,29.00,31.44,35.53,39.00,
 41.94,44.86,47.67,50.36,53.38,60.33,67.00,75.33,84.88,95.12,
 115.00,136.00};
static float alpha01_nx064_nz02_fwhm350[32] = {
 8.65,9.72,10.74,11.92,13.18,14.15,15.96,17.62,18.85,20.12,
 21.24,21.89,22.65,24.75,27.12,29.38,32.50,35.14,39.59,43.33,
 47.00,50.64,53.71,56.71,58.93,66.92,74.36,83.60,94.88,106.33,
 128.40,150.25};
static float alpha01_nx064_nz02_fwhm375[32] = {
 9.24,10.42,11.44,12.59,14.00,14.96,17.30,19.00,20.50,21.65,
 22.72,23.43,24.24,27.06,29.52,32.22,35.69,38.12,43.86,48.46,
 52.11,55.30,58.80,61.92,65.27,73.93,82.29,92.60,105.00,116.92,
 141.60,165.80};
static float alpha01_nx064_nz02_fwhm400[32] = {
 9.82,10.80,11.90,13.11,14.75,16.23,18.57,20.06,21.69,22.96,
 23.93,25.31,26.43,29.21,32.25,35.44,38.81,42.14,47.72,51.94,
 56.60,60.75,63.83,68.00,71.29,81.33,89.29,101.50,115.25,128.33,
 153.86,183.50};
static float alpha01_nx064_nz02_fwhm425[32] = {
 9.96,11.22,12.52,14.07,15.81,17.12,19.27,21.43,23.42,24.94,
 26.12,27.36,28.56,32.31,35.27,38.67,42.00,45.64,51.21,56.75,
 61.62,65.62,69.54,72.71,77.17,88.00,97.44,109.67,124.00,138.50,
 169.00,199.43};
static float alpha01_nx064_nz02_fwhm450[32] = {
 10.43,11.77,13.19,15.07,16.86,18.29,20.55,23.05,24.77,25.95,
 28.20,29.46,30.67,35.07,37.85,41.08,45.24,48.86,55.22,60.44,
 65.38,70.14,75.00,79.25,83.11,95.00,105.10,117.40,133.62,151.33,
 182.33,213.60};
static float alpha01_nx064_nz02_fwhm475[32] = {
 10.86,12.35,14.06,15.95,17.61,19.24,21.84,24.14,25.94,28.10,
 30.15,31.70,33.50,37.33,40.36,44.17,48.33,52.00,59.09,65.56,
 70.29,76.29,80.67,84.40,88.57,101.25,112.11,126.50,146.00,162.33,
 195.80,231.50};
static float alpha01_nx064_nz02_fwhm500[32] = {
 11.14,12.95,14.56,16.77,18.41,20.27,23.21,25.92,27.91,30.25,
 32.10,34.00,36.00,39.50,43.09,46.70,51.33,54.82,63.00,69.08,
 75.22,80.67,85.11,89.73,94.33,107.44,119.40,136.14,154.20,173.20,
 207.40,249.00};
static float *alpha01_nx064_nz02[21] = {
 alpha01_nx064_nz02_fwhm000, alpha01_nx064_nz02_fwhm025, alpha01_nx064_nz02_fwhm050, 
 alpha01_nx064_nz02_fwhm075, alpha01_nx064_nz02_fwhm100, alpha01_nx064_nz02_fwhm125, 
 alpha01_nx064_nz02_fwhm150, alpha01_nx064_nz02_fwhm175, alpha01_nx064_nz02_fwhm200, 
 alpha01_nx064_nz02_fwhm225, alpha01_nx064_nz02_fwhm250, alpha01_nx064_nz02_fwhm275, 
 alpha01_nx064_nz02_fwhm300, alpha01_nx064_nz02_fwhm325, alpha01_nx064_nz02_fwhm350, 
 alpha01_nx064_nz02_fwhm375, alpha01_nx064_nz02_fwhm400, alpha01_nx064_nz02_fwhm425, 
 alpha01_nx064_nz02_fwhm450, alpha01_nx064_nz02_fwhm475, alpha01_nx064_nz02_fwhm500} ;

static float alpha05_nx064_nz02_fwhm000[32] = {
 1.90,1.91,1.92,1.93,1.94,1.94,1.95,1.95,1.95,1.96,
 1.96,1.96,1.96,1.97,1.99,2.20,2.47,2.62,2.79,2.87,
 2.91,2.94,2.96,2.98,3.10,3.60,3.82,3.96,4.43,4.78,
 5.45,5.99};
static float alpha05_nx064_nz02_fwhm025[32] = {
 1.90,1.91,1.92,1.93,1.94,1.94,1.95,1.95,1.95,1.96,
 1.96,1.96,1.96,1.97,1.99,2.20,2.47,2.62,2.79,2.87,
 2.91,2.94,2.96,2.98,3.10,3.60,3.82,3.96,4.43,4.78,
 5.45,5.99};
static float alpha05_nx064_nz02_fwhm050[32] = {
 1.90,1.91,1.92,1.93,1.94,1.94,1.95,1.95,1.95,1.96,
 1.96,1.96,1.97,1.98,1.99,2.28,2.53,2.65,2.81,2.88,
 2.92,2.95,2.97,3.00,3.24,3.66,3.85,3.98,4.54,4.84,
 5.59,6.25};
static float alpha05_nx064_nz02_fwhm075[32] = {
 1.90,1.91,1.92,1.93,1.94,1.95,1.95,1.96,1.96,1.96,
 1.97,1.97,1.98,2.02,2.34,2.55,2.71,2.79,2.89,2.94,
 2.97,3.00,3.32,3.51,3.65,3.87,3.99,4.53,4.88,5.31,
 6.06,6.98};
static float alpha05_nx064_nz02_fwhm100[32] = {
 1.90,1.92,1.93,1.94,1.95,1.96,1.97,1.98,1.99,2.00,
 2.18,2.32,2.43,2.64,2.76,2.84,2.90,2.93,3.00,3.46,
 3.68,3.80,3.89,3.96,4.02,4.66,4.92,5.50,5.96,6.68,
 7.79,8.94};
static float alpha05_nx064_nz02_fwhm125[32] = {
 1.92,1.94,1.95,1.97,1.99,2.10,2.40,2.58,2.69,2.76,
 2.81,2.85,2.89,2.96,3.03,3.41,3.65,3.81,3.98,4.47,
 4.76,4.93,5.18,5.48,5.70,6.32,6.91,7.76,8.67,9.59,
 11.38,13.15};
static float alpha05_nx064_nz02_fwhm150[32] = {
 1.99,2.25,2.44,2.61,2.73,2.82,2.93,3.00,3.28,3.45,
 3.60,3.71,3.81,4.02,4.40,4.72,4.97,5.43,5.95,6.54,
 6.93,7.42,7.84,8.26,8.63,9.70,10.75,11.98,13.57,14.99,
 17.98,20.96};
static float alpha05_nx064_nz02_fwhm175[32] = {
 2.65,2.79,2.90,3.00,3.40,3.63,3.93,4.33,4.61,4.79,
 4.93,5.05,5.31,5.86,6.36,6.85,7.46,7.94,8.84,9.66,
 10.37,11.08,11.71,12.25,12.85,14.57,16.24,18.09,20.52,22.83,
 27.02,31.98};
static float alpha05_nx064_nz02_fwhm200[32] = {
 2.79,2.97,3.38,3.70,4.00,4.36,4.81,5.22,5.64,5.92,
 6.24,6.57,6.82,7.60,8.20,8.87,9.64,10.34,11.65,12.74,
 13.75,14.75,15.74,16.61,17.35,19.70,21.81,24.63,27.85,31.16,
 37.30,43.72};
static float alpha05_nx064_nz02_fwhm225[32] = {
 2.95,3.46,3.85,4.21,4.68,5.04,5.75,6.34,6.84,7.33,
 7.74,8.13,8.50,9.32,10.07,10.95,12.06,12.96,14.57,16.06,
 17.38,18.74,19.88,21.00,22.05,25.15,27.91,31.33,35.59,39.72,
 48.00,55.66};
static float alpha05_nx064_nz02_fwhm250[32] = {
 3.19,3.77,4.20,4.72,5.25,5.83,6.67,7.41,8.06,8.58,
 8.96,9.41,9.86,10.92,11.85,13.01,14.32,15.48,17.60,19.48,
 20.90,22.55,23.89,25.28,26.50,30.38,33.72,38.22,43.10,48.25,
 57.89,68.36};
static float alpha05_nx064_nz02_fwhm275[32] = {
 3.40,4.01,4.54,5.13,5.84,6.44,7.51,8.31,8.89,9.63,
 10.18,10.69,11.15,12.51,13.77,15.02,16.61,17.96,20.46,22.47,
 24.37,26.10,27.85,29.51,31.24,35.49,39.49,44.61,50.65,56.69,
 68.44,80.07};
static float alpha05_nx064_nz02_fwhm300[32] = {
 3.57,4.23,4.78,5.48,6.17,6.95,8.08,9.09,9.85,10.58,
 11.30,11.85,12.47,14.09,15.48,16.99,18.85,20.40,22.97,25.53,
 27.89,29.89,31.91,33.74,35.53,40.34,44.95,50.94,58.09,64.87,
 78.22,91.75};
static float alpha05_nx064_nz02_fwhm325[32] = {
 3.70,4.46,4.94,5.72,6.59,7.41,8.66,9.82,10.74,11.54,
 12.28,12.97,13.72,15.59,17.12,18.97,20.95,22.61,25.84,28.66,
 31.23,33.55,35.67,37.67,39.57,45.51,51.09,57.49,65.49,73.12,
 88.30,102.61};
static float alpha05_nx064_nz02_fwhm350[32] = {
 3.72,4.57,5.10,5.98,6.90,7.69,9.22,10.46,11.54,12.51,
 13.36,14.24,14.98,16.92,18.57,20.65,23.00,25.07,28.52,31.61,
 34.26,36.94,39.23,41.61,43.87,50.55,56.69,63.56,72.73,81.24,
 97.41,113.75};
static float alpha05_nx064_nz02_fwhm375[32] = {
 3.75,4.58,5.25,6.09,7.21,8.18,9.64,10.99,12.24,13.34,
 14.38,15.25,16.04,18.12,20.15,22.49,24.89,27.03,30.93,34.44,
 37.52,40.36,43.17,45.88,48.25,55.40,61.72,70.07,79.43,88.90,
 106.60,125.57};
static float alpha05_nx064_nz02_fwhm400[32] = {
 3.75,4.62,5.34,6.42,7.44,8.44,10.14,11.72,12.91,13.99,
 15.19,16.13,16.88,19.23,21.57,23.95,26.71,29.13,33.31,37.31,
 40.78,43.80,46.63,49.67,52.22,60.12,66.84,75.76,86.38,96.60,
 116.58,138.35};
static float alpha05_nx064_nz02_fwhm425[32] = {
 3.75,4.62,5.41,6.48,7.56,8.65,10.51,12.13,13.45,14.69,
 15.87,16.88,17.82,20.60,22.82,25.53,28.46,30.90,35.81,40.13,
 43.63,47.25,50.14,53.22,56.10,64.40,72.41,81.75,93.23,104.83,
 127.29,151.47};
static float alpha05_nx064_nz02_fwhm450[32] = {
 3.75,4.62,5.42,6.57,7.72,8.83,10.79,12.42,13.89,15.16,
 16.41,17.53,18.58,21.60,24.11,26.98,29.98,33.11,38.20,42.74,
 46.78,49.89,53.58,56.94,60.18,69.33,77.21,88.18,101.17,113.18,
 137.71,162.17};
static float alpha05_nx064_nz02_fwhm475[32] = {
 3.75,4.62,5.42,6.57,7.72,8.83,10.91,12.65,14.26,15.84,
 17.12,18.25,19.50,22.45,25.23,28.25,31.87,35.19,40.55,45.14,
 49.41,53.17,56.92,60.61,63.89,73.86,82.75,94.10,108.00,120.96,
 147.85,173.27};
static float alpha05_nx064_nz02_fwhm500[32] = {
 3.75,4.62,5.42,6.57,7.73,8.85,11.19,12.97,14.71,16.16,
 17.39,18.85,20.27,23.32,26.15,29.47,33.46,36.76,42.72,47.77,
 52.17,56.45,60.06,63.92,68.00,78.22,88.19,100.45,114.58,129.08,
 156.95,184.00};
static float *alpha05_nx064_nz02[21] = {
 alpha05_nx064_nz02_fwhm000, alpha05_nx064_nz02_fwhm025, alpha05_nx064_nz02_fwhm050, 
 alpha05_nx064_nz02_fwhm075, alpha05_nx064_nz02_fwhm100, alpha05_nx064_nz02_fwhm125, 
 alpha05_nx064_nz02_fwhm150, alpha05_nx064_nz02_fwhm175, alpha05_nx064_nz02_fwhm200, 
 alpha05_nx064_nz02_fwhm225, alpha05_nx064_nz02_fwhm250, alpha05_nx064_nz02_fwhm275, 
 alpha05_nx064_nz02_fwhm300, alpha05_nx064_nz02_fwhm325, alpha05_nx064_nz02_fwhm350, 
 alpha05_nx064_nz02_fwhm375, alpha05_nx064_nz02_fwhm400, alpha05_nx064_nz02_fwhm425, 
 alpha05_nx064_nz02_fwhm450, alpha05_nx064_nz02_fwhm475, alpha05_nx064_nz02_fwhm500} ;

static float alpha10_nx064_nz02_fwhm000[32] = {
 1.79,1.82,1.84,1.86,1.88,1.88,1.89,1.90,1.90,1.91,
 1.91,1.91,1.91,1.92,1.94,1.96,1.99,2.23,2.56,2.71,
 2.79,2.84,2.88,2.91,2.94,3.14,3.55,3.80,3.96,4.40,
 4.94,5.68};
static float alpha10_nx064_nz02_fwhm025[32] = {
 1.79,1.82,1.84,1.86,1.88,1.88,1.89,1.90,1.90,1.91,
 1.91,1.91,1.91,1.92,1.94,1.96,1.99,2.23,2.56,2.71,
 2.79,2.84,2.88,2.91,2.94,3.14,3.55,3.80,3.96,4.40,
 4.94,5.68};
static float alpha10_nx064_nz02_fwhm050[32] = {
 1.79,1.82,1.84,1.86,1.88,1.88,1.89,1.90,1.90,1.91,
 1.91,1.91,1.92,1.93,1.94,1.97,2.05,2.29,2.60,2.73,
 2.81,2.86,2.89,2.92,2.95,3.26,3.62,3.84,3.99,4.52,
 4.99,5.79};
static float alpha10_nx064_nz02_fwhm075[32] = {
 1.79,1.83,1.85,1.86,1.88,1.89,1.90,1.90,1.91,1.91,
 1.92,1.92,1.93,1.95,1.97,2.08,2.39,2.56,2.74,2.83,
 2.88,2.92,2.96,3.00,3.23,3.64,3.84,3.98,4.58,4.88,
 5.71,6.49};
static float alpha10_nx064_nz02_fwhm100[32] = {
 1.79,1.83,1.85,1.87,1.88,1.90,1.91,1.92,1.94,1.95,
 1.96,1.97,1.98,2.26,2.49,2.63,2.75,2.82,2.91,2.98,
 3.26,3.50,3.65,3.77,3.85,4.13,4.61,4.93,5.57,5.97,
 7.01,8.11};
static float alpha10_nx064_nz02_fwhm125[32] = {
 1.81,1.84,1.87,1.90,1.92,1.94,1.98,2.12,2.32,2.46,
 2.56,2.63,2.69,2.81,2.88,2.96,3.16,3.44,3.75,3.93,
 4.21,4.53,4.74,4.89,5.02,5.72,6.25,6.93,7.81,8.66,
 10.30,11.92};
static float alpha10_nx064_nz02_fwhm150[32] = {
 1.86,1.92,1.97,2.12,2.34,2.50,2.70,2.80,2.89,2.94,
 2.99,3.13,3.29,3.64,3.84,4.09,4.49,4.78,5.28,5.77,
 6.16,6.59,6.90,7.31,7.68,8.65,9.55,10.75,12.06,13.44,
 16.19,18.81};
static float alpha10_nx064_nz02_fwhm175[32] = {
 2.09,2.36,2.53,2.69,2.84,2.93,3.23,3.59,3.83,4.03,
 4.29,4.46,4.62,4.94,5.40,5.90,6.46,6.89,7.78,8.51,
 9.10,9.75,10.30,10.83,11.40,12.97,14.37,16.19,18.24,20.27,
 24.28,28.53};
static float alpha10_nx064_nz02_fwhm200[32] = {
 2.11,2.45,2.68,2.86,3.05,3.40,3.88,4.30,4.64,4.87,
 5.12,5.44,5.68,6.39,6.93,7.67,8.37,8.92,10.08,11.05,
 12.00,12.85,13.67,14.44,15.19,17.29,19.15,21.65,24.64,27.47,
 33.02,38.75};
static float alpha10_nx064_nz02_fwhm225[32] = {
 2.14,2.54,2.79,3.05,3.51,3.88,4.51,4.95,5.46,5.87,
 6.25,6.61,6.88,7.85,8.50,9.26,10.22,11.00,12.55,13.82,
 14.99,16.16,17.17,18.17,19.13,21.82,24.40,27.50,31.30,35.02,
 42.06,49.36};
static float alpha10_nx064_nz02_fwhm250[32] = {
 2.17,2.59,2.90,3.39,3.84,4.33,5.01,5.71,6.25,6.74,
 7.21,7.68,8.03,8.96,9.86,10.97,12.05,13.15,14.92,16.50,
 17.99,19.36,20.62,21.84,23.09,26.32,29.44,33.19,37.82,42.29,
 50.75,59.61};
static float alpha10_nx064_nz02_fwhm275[32] = {
 2.17,2.64,2.97,3.58,4.15,4.65,5.47,6.25,6.85,7.54,
 8.06,8.55,8.94,10.15,11.26,12.55,13.85,15.01,17.19,19.07,
 20.87,22.49,24.05,25.43,26.80,30.70,34.26,38.88,44.02,49.14,
 59.38,69.89};
static float alpha10_nx064_nz02_fwhm300[32] = {
 2.17,2.64,3.04,3.72,4.35,4.86,5.81,6.65,7.45,8.14,
 8.72,9.29,9.90,11.25,12.46,13.89,15.59,17.03,19.51,21.63,
 23.56,25.50,27.13,28.92,30.47,34.93,38.99,44.10,50.30,56.05,
 68.10,80.18};
static float alpha10_nx064_nz02_fwhm325[32] = {
 2.17,2.64,3.04,3.74,4.46,4.96,6.10,7.05,7.86,8.61,
 9.39,10.06,10.66,12.25,13.66,15.35,17.17,18.70,21.58,23.99,
 26.36,28.42,30.39,32.37,33.95,39.06,43.61,49.53,56.20,63.02,
 76.62,90.00};
static float alpha10_nx064_nz02_fwhm350[32] = {
 2.17,2.64,3.04,3.78,4.51,5.05,6.27,7.32,8.26,9.06,
 9.87,10.62,11.35,13.21,14.77,16.53,18.48,20.39,23.60,26.45,
 28.86,31.25,33.41,35.52,37.42,43.06,48.13,54.25,62.03,69.89,
 84.75,99.92};
static float alpha10_nx064_nz02_fwhm375[32] = {
 2.17,2.64,3.04,3.78,4.54,5.11,6.38,7.47,8.50,9.43,
 10.34,11.21,11.85,14.01,15.77,17.68,19.94,22.02,25.53,28.58,
 31.34,34.14,36.30,38.55,40.76,46.82,52.17,59.40,67.80,76.28,
 92.75,109.09};
static float alpha10_nx064_nz02_fwhm400[32] = {
 2.17,2.64,3.04,3.78,4.54,5.11,6.46,7.66,8.79,9.81,
 10.69,11.56,12.41,14.77,16.59,18.81,21.46,23.51,27.33,30.65,
 33.74,36.58,39.10,41.57,44.02,50.46,56.56,64.37,73.78,83.05,
 101.33,119.30};
static float alpha10_nx064_nz02_fwhm425[32] = {
 2.17,2.64,3.04,3.78,4.54,5.12,6.52,7.81,8.95,10.07,
 11.05,12.03,12.83,15.42,17.47,19.70,22.53,24.84,29.07,32.67,
 35.96,39.02,41.82,44.64,46.96,54.10,61.13,69.32,79.70,89.70,
 109.02,128.12};
static float alpha10_nx064_nz02_fwhm450[32] = {
 2.17,2.64,3.04,3.78,4.54,5.12,6.53,7.94,9.19,10.37,
 11.44,12.36,13.36,16.11,18.31,20.82,23.62,26.10,30.54,34.54,
 37.98,41.30,44.40,47.18,49.96,57.79,65.32,74.29,85.74,96.23,
 116.67,138.58};
static float alpha10_nx064_nz02_fwhm475[32] = {
 2.17,2.64,3.04,3.78,4.54,5.12,6.54,7.96,9.31,10.51,
 11.59,12.67,13.75,16.57,18.94,21.67,24.50,27.21,32.04,36.42,
 40.16,43.69,46.88,50.26,53.22,61.64,69.54,79.65,91.24,102.45,
 124.56,148.50};
static float alpha10_nx064_nz02_fwhm500[32] = {
 2.17,2.64,3.04,3.78,4.54,5.12,6.54,7.96,9.34,10.60,
 11.76,12.96,14.11,16.85,19.28,22.11,25.46,28.32,33.59,38.09,
 42.10,45.96,49.69,53.10,56.11,65.28,73.83,84.26,96.73,108.21,
 133.17,157.29};
static float *alpha10_nx064_nz02[21] = {
 alpha10_nx064_nz02_fwhm000, alpha10_nx064_nz02_fwhm025, alpha10_nx064_nz02_fwhm050, 
 alpha10_nx064_nz02_fwhm075, alpha10_nx064_nz02_fwhm100, alpha10_nx064_nz02_fwhm125, 
 alpha10_nx064_nz02_fwhm150, alpha10_nx064_nz02_fwhm175, alpha10_nx064_nz02_fwhm200, 
 alpha10_nx064_nz02_fwhm225, alpha10_nx064_nz02_fwhm250, alpha10_nx064_nz02_fwhm275, 
 alpha10_nx064_nz02_fwhm300, alpha10_nx064_nz02_fwhm325, alpha10_nx064_nz02_fwhm350, 
 alpha10_nx064_nz02_fwhm375, alpha10_nx064_nz02_fwhm400, alpha10_nx064_nz02_fwhm425, 
 alpha10_nx064_nz02_fwhm450, alpha10_nx064_nz02_fwhm475, alpha10_nx064_nz02_fwhm500} ;

static float **nx064_nz02[3] = {
  alpha01_nx064_nz02 , alpha05_nx064_nz02 , alpha10_nx064_nz02 };

static float alpha01_nx064_nz03_fwhm000[32] = {
 1.98,1.99,1.99,1.99,1.99,1.99,1.99,2.00,2.00,2.17,
 2.32,2.47,2.58,2.76,2.84,2.90,2.94,2.96,2.99,3.15,
 3.54,3.72,3.83,3.90,3.94,4.22,4.71,4.96,5.65,5.94,
 6.93,7.88};
static float alpha01_nx064_nz03_fwhm025[32] = {
 1.98,1.99,1.99,1.99,1.99,1.99,1.99,2.00,2.00,2.17,
 2.32,2.47,2.58,2.76,2.84,2.90,2.94,2.96,2.99,3.15,
 3.54,3.72,3.83,3.90,3.94,4.22,4.71,4.96,5.65,5.94,
 6.93,7.88};
static float alpha01_nx064_nz03_fwhm050[32] = {
 1.98,1.99,1.99,1.99,1.99,1.99,1.99,2.00,2.08,2.25,
 2.42,2.54,2.64,2.79,2.86,2.91,2.94,2.97,2.99,3.26,
 3.62,3.77,3.87,3.92,3.96,4.36,4.79,4.99,5.74,6.00,
 7.02,8.00};
static float alpha01_nx064_nz03_fwhm075[32] = {
 1.98,1.99,1.99,1.99,1.99,2.00,2.00,2.24,2.44,2.58,
 2.68,2.75,2.79,2.87,2.92,2.95,2.97,2.99,3.46,3.72,
 3.85,3.92,3.97,4.00,4.35,4.83,5.10,5.72,6.23,6.83,
 7.95,9.11};
static float alpha01_nx064_nz03_fwhm100[32] = {
 1.99,1.99,1.99,2.00,2.13,2.34,2.62,2.73,2.81,2.86,
 2.89,2.92,2.93,2.97,2.99,3.33,3.62,3.78,3.92,4.00,
 4.52,4.77,4.89,4.96,5.21,5.84,6.35,6.94,7.84,8.74,
 10.32,11.98};
static float alpha01_nx064_nz03_fwhm125[32] = {
 2.16,2.43,2.59,2.71,2.80,2.86,2.93,2.97,2.99,3.12,
 3.41,3.56,3.67,3.84,3.94,4.12,4.58,4.84,5.30,5.73,
 5.94,6.41,6.76,6.98,7.45,8.39,9.26,10.34,11.74,13.00,
 15.99,18.86};
static float alpha01_nx064_nz03_fwhm150[32] = {
 2.83,2.91,2.96,3.11,3.48,3.66,3.86,3.99,4.31,4.56,
 4.75,4.84,4.95,5.53,5.80,6.32,6.78,7.29,8.09,8.79,
 9.45,10.15,10.82,11.60,12.20,13.80,15.44,17.16,19.80,22.06,
 27.32,32.40};
static float alpha01_nx064_nz03_fwhm175[32] = {
 3.74,3.96,4.24,4.61,4.87,5.00,5.69,6.20,6.61,6.89,
 7.22,7.59,7.81,8.58,9.33,10.15,11.05,12.00,13.36,14.48,
 15.80,16.82,17.84,18.89,19.74,22.81,25.30,28.36,32.85,36.57,
 45.06,54.73};
static float alpha01_nx064_nz03_fwhm200[32] = {
 5.12,5.81,6.19,6.74,7.34,7.81,8.67,9.44,10.05,10.69,
 11.18,11.59,12.10,13.03,14.25,15.46,17.03,17.98,19.94,22.03,
 23.50,24.91,26.71,28.11,29.76,33.81,38.00,43.00,49.64,55.95,
 67.58,79.46};
static float alpha01_nx064_nz03_fwhm225[32] = {
 7.31,7.98,8.76,9.42,10.44,11.18,12.08,13.00,14.11,14.78,
 15.47,16.09,16.71,18.22,19.59,21.00,22.84,24.58,27.33,29.81,
 32.29,35.05,37.12,39.32,41.47,46.88,52.14,58.69,67.07,75.10,
 91.38,107.89};
static float alpha01_nx064_nz03_fwhm250[32] = {
 9.46,10.53,11.44,12.36,13.24,13.97,15.32,16.61,17.71,18.71,
 19.61,20.29,21.08,22.88,24.50,26.52,29.22,31.53,35.37,38.89,
 41.75,44.50,46.79,49.17,51.92,58.88,66.57,75.88,85.67,95.43,
 114.11,133.57};
static float alpha01_nx064_nz03_fwhm275[32] = {
 11.46,12.37,13.16,14.33,15.54,16.55,18.59,20.09,21.38,22.26,
 23.17,24.24,25.09,27.18,29.63,32.25,35.38,37.87,42.20,46.44,
 50.54,54.00,57.31,60.71,63.38,72.33,80.25,91.24,103.27,113.50,
 135.86,158.20};
static float alpha01_nx064_nz03_fwhm300[32] = {
 12.56,13.81,15.00,16.75,18.00,19.05,21.33,22.83,24.19,25.21,
 26.92,28.00,29.55,32.21,34.71,37.88,41.17,44.40,49.85,54.92,
 59.50,63.69,67.14,70.54,74.54,85.71,94.00,105.20,117.00,130.00,
 156.00,181.57};
static float alpha01_nx064_nz03_fwhm325[32] = {
 13.64,15.39,17.00,18.47,19.73,21.37,23.65,25.85,27.50,29.25,
 30.41,31.88,33.31,36.56,39.65,43.46,47.25,50.58,57.52,62.93,
 67.73,72.10,76.71,81.29,84.69,96.88,106.50,118.83,133.00,148.67,
 179.00,204.60};
static float alpha01_nx064_nz03_fwhm350[32] = {
 15.22,17.06,18.52,20.11,21.66,23.38,27.04,28.70,30.52,32.44,
 33.75,35.44,36.60,40.89,44.25,48.57,52.62,57.38,64.62,70.36,
 76.43,81.13,85.82,89.92,95.33,107.80,118.43,131.17,148.50,165.00,
 195.00,225.50};
static float alpha01_nx064_nz03_fwhm375[32] = {
 15.77,18.33,19.38,21.26,23.82,25.25,29.41,30.93,33.35,35.50,
 36.88,39.05,40.40,45.62,49.60,54.15,59.11,63.54,70.33,77.50,
 83.43,90.00,94.60,99.50,104.00,118.38,129.80,144.75,164.00,184.50,
 217.25,252.00};
static float alpha01_nx064_nz03_fwhm400[32] = {
 16.89,18.70,21.14,23.25,25.00,27.65,30.81,33.60,36.24,39.00,
 40.11,42.56,44.53,49.80,54.36,59.43,64.60,69.10,76.83,85.25,
 92.00,97.60,103.00,108.60,114.20,129.17,142.67,161.00,182.00,202.33,
 239.25,279.00};
static float alpha01_nx064_nz03_fwhm425[32] = {
 18.23,19.57,21.73,24.69,27.45,29.88,33.50,36.50,39.38,42.16,
 44.00,46.82,48.95,54.54,59.14,64.40,69.53,75.29,84.00,93.00,
 99.44,105.12,111.22,117.83,124.60,138.00,154.00,173.33,198.25,219.00,
 262.67,302.33};
static float alpha01_nx064_nz03_fwhm450[32] = {
 18.52,21.29,24.26,25.86,29.00,31.30,35.33,39.58,42.55,45.67,
 48.59,51.00,52.11,58.40,63.77,69.17,75.50,80.00,89.88,98.50,
 105.50,113.00,121.00,127.60,133.00,149.00,166.00,189.29,211.75,236.00,
 279.50,324.00};
static float alpha01_nx064_nz03_fwhm475[32] = {
 19.78,23.00,25.00,28.00,30.77,33.38,38.50,42.31,45.73,48.73,
 51.38,54.00,56.80,62.33,67.33,73.88,80.50,85.55,96.56,105.50,
 113.50,121.20,130.00,135.00,142.60,160.17,179.40,201.33,228.67,252.25,
 303.00,352.00};
static float alpha01_nx064_nz03_fwhm500[32] = {
 20.25,24.07,26.83,29.00,33.00,35.00,40.67,45.29,48.53,51.56,
 54.64,57.67,60.12,66.80,71.40,78.20,84.50,91.22,102.00,111.75,
 119.62,129.80,136.00,144.00,152.00,174.00,192.00,217.00,243.00,273.00,
 326.67,378.75};
static float *alpha01_nx064_nz03[21] = {
 alpha01_nx064_nz03_fwhm000, alpha01_nx064_nz03_fwhm025, alpha01_nx064_nz03_fwhm050, 
 alpha01_nx064_nz03_fwhm075, alpha01_nx064_nz03_fwhm100, alpha01_nx064_nz03_fwhm125, 
 alpha01_nx064_nz03_fwhm150, alpha01_nx064_nz03_fwhm175, alpha01_nx064_nz03_fwhm200, 
 alpha01_nx064_nz03_fwhm225, alpha01_nx064_nz03_fwhm250, alpha01_nx064_nz03_fwhm275, 
 alpha01_nx064_nz03_fwhm300, alpha01_nx064_nz03_fwhm325, alpha01_nx064_nz03_fwhm350, 
 alpha01_nx064_nz03_fwhm375, alpha01_nx064_nz03_fwhm400, alpha01_nx064_nz03_fwhm425, 
 alpha01_nx064_nz03_fwhm450, alpha01_nx064_nz03_fwhm475, alpha01_nx064_nz03_fwhm500} ;

static float alpha05_nx064_nz03_fwhm000[32] = {
 1.92,1.93,1.94,1.94,1.95,1.95,1.95,1.96,1.96,1.96,
 1.96,1.97,1.97,1.99,2.19,2.46,2.65,2.75,2.86,2.91,
 2.95,2.97,3.01,3.34,3.51,3.80,3.93,4.27,4.78,4.99,
 5.90,6.75};
static float alpha05_nx064_nz03_fwhm025[32] = {
 1.92,1.93,1.94,1.94,1.95,1.95,1.95,1.96,1.96,1.96,
 1.96,1.97,1.97,1.99,2.19,2.46,2.65,2.75,2.86,2.91,
 2.95,2.97,3.01,3.34,3.51,3.80,3.93,4.27,4.78,4.99,
 5.90,6.75};
static float alpha05_nx064_nz03_fwhm050[32] = {
 1.92,1.93,1.94,1.94,1.95,1.95,1.95,1.96,1.96,1.96,
 1.97,1.97,1.98,2.00,2.26,2.53,2.68,2.77,2.87,2.92,
 2.96,2.98,3.19,3.43,3.59,3.83,3.96,4.42,4.84,5.15,
 5.97,6.88};
static float alpha05_nx064_nz03_fwhm075[32] = {
 1.92,1.93,1.94,1.94,1.95,1.95,1.96,1.96,1.97,1.97,
 1.98,1.99,2.00,2.33,2.56,2.70,2.79,2.86,2.93,2.97,
 3.10,3.41,3.61,3.73,3.81,3.96,4.43,4.83,5.28,5.81,
 6.77,7.80};
static float alpha05_nx064_nz03_fwhm100[32] = {
 1.92,1.94,1.94,1.95,1.96,1.96,1.97,1.99,2.00,2.23,
 2.40,2.50,2.58,2.74,2.83,2.89,2.94,2.98,3.37,3.64,
 3.81,3.91,3.97,4.19,4.47,4.88,5.32,5.87,6.58,7.21,
 8.65,10.10};
static float alpha05_nx064_nz03_fwhm125[32] = {
 1.94,1.95,1.96,1.98,1.99,2.16,2.48,2.63,2.73,2.80,
 2.85,2.89,2.92,2.98,3.25,3.55,3.76,3.89,4.25,4.68,
 4.91,5.22,5.56,5.78,5.95,6.78,7.55,8.47,9.57,10.77,
 12.96,15.57};
static float alpha05_nx064_nz03_fwhm150[32] = {
 1.99,2.25,2.46,2.62,2.75,2.83,2.93,3.08,3.38,3.57,
 3.71,3.81,3.88,4.20,4.58,4.90,5.32,5.73,6.35,6.97,
 7.61,8.05,8.62,8.98,9.52,10.89,12.17,13.84,15.83,17.79,
 21.78,26.06};
static float alpha05_nx064_nz03_fwhm175[32] = {
 2.69,2.85,2.96,3.21,3.55,3.78,4.10,4.49,4.80,4.98,
 5.32,5.58,5.80,6.45,6.97,7.69,8.45,8.99,10.21,11.35,
 12.25,13.09,13.91,14.74,15.58,17.71,19.81,22.49,25.71,29.00,
 36.00,43.18};
static float alpha05_nx064_nz03_fwhm200[32] = {
 3.29,3.70,3.98,4.41,4.84,5.22,5.87,6.53,7.00,7.50,
 7.87,8.37,8.74,9.66,10.59,11.56,12.64,13.62,15.25,16.79,
 18.22,19.50,20.75,22.12,23.22,26.65,29.72,33.93,38.54,43.49,
 53.27,63.39};
static float alpha05_nx064_nz03_fwhm225[32] = {
 4.01,4.64,5.20,5.84,6.52,7.02,8.01,8.80,9.64,10.23,
 10.85,11.42,11.85,13.06,14.21,15.59,17.02,18.46,20.75,22.96,
 24.76,26.67,28.39,30.07,31.77,36.33,40.23,45.42,52.34,58.84,
 71.40,84.52};
static float alpha05_nx064_nz03_fwhm250[32] = {
 4.81,5.71,6.39,6.97,8.00,8.78,10.12,11.20,12.15,12.79,
 13.39,14.08,14.70,16.47,17.88,19.67,21.52,23.19,26.21,28.77,
 31.28,33.76,36.08,37.95,39.93,45.35,50.95,58.12,65.61,73.57,
 89.00,104.27};
static float alpha05_nx064_nz03_fwhm275[32] = {
 5.36,6.38,7.14,8.24,9.41,10.39,12.14,12.93,14.09,15.06,
 15.90,16.85,17.58,19.54,21.31,23.51,25.66,27.58,31.41,34.86,
 38.01,40.56,43.27,45.53,47.88,54.71,61.59,68.98,78.24,87.59,
 105.46,123.00};
static float alpha05_nx064_nz03_fwhm300[32] = {
 5.76,6.83,8.03,9.45,10.88,12.06,13.03,14.94,15.94,17.23,
 18.30,18.96,20.05,22.17,24.42,26.99,29.84,31.95,36.43,40.42,
 43.69,47.04,50.24,53.00,55.71,63.42,70.58,79.21,89.92,100.68,
 121.48,139.73};
static float alpha05_nx064_nz03_fwhm325[32] = {
 5.99,6.97,8.81,9.95,12.01,12.56,14.66,15.99,17.90,18.82,
 20.04,21.31,22.04,24.76,27.57,30.33,33.55,36.45,41.45,45.75,
 49.38,53.37,56.64,60.05,63.12,71.41,79.32,89.81,102.06,114.00,
 134.90,156.58};
static float alpha05_nx064_nz03_fwhm350[32] = {
 6.08,6.99,9.11,10.66,12.35,12.85,15.48,17.85,18.84,20.79,
 21.64,23.27,24.36,27.60,30.39,33.57,37.12,40.29,45.70,50.83,
 54.87,59.05,62.69,66.33,69.76,78.97,88.19,99.85,113.73,125.40,
 148.73,172.68};
static float alpha05_nx064_nz03_fwhm375[32] = {
 6.08,6.99,9.14,10.87,12.51,13.81,16.21,18.65,20.65,21.76,
 23.94,24.81,26.57,30.15,33.30,36.67,40.59,44.39,50.47,55.42,
 60.02,63.91,69.00,72.53,76.00,86.92,97.29,109.08,123.77,137.38,
 163.11,189.20};
static float alpha05_nx064_nz03_fwhm400[32] = {
 6.08,6.99,9.14,11.42,12.68,14.57,17.64,19.11,21.65,24.03,
 24.87,27.16,27.94,32.92,36.04,39.55,44.30,48.10,54.56,60.15,
 65.95,70.20,74.65,79.33,83.66,94.41,105.66,118.89,134.23,149.26,
 178.28,207.00};
static float alpha05_nx064_nz03_fwhm425[32] = {
 6.08,6.99,9.14,11.42,12.73,15.00,18.17,20.86,22.86,24.71,
 27.12,28.42,30.52,34.33,37.96,42.46,47.45,51.41,57.98,65.00,
 70.36,75.88,81.45,85.55,90.36,102.52,114.06,128.10,145.28,161.18,
 193.33,225.90};
static float alpha05_nx064_nz03_fwhm450[32] = {
 6.08,6.99,9.14,11.42,12.77,15.22,18.55,21.41,24.22,26.21,
 28.07,30.48,32.27,36.45,40.48,45.25,49.85,54.58,62.59,69.49,
 75.57,81.30,86.33,91.60,96.50,108.75,121.52,138.42,156.21,173.11,
 208.88,246.10};
static float alpha05_nx064_nz03_fwhm475[32] = {
 6.08,6.99,9.14,11.42,12.78,15.28,18.79,21.98,24.81,27.59,
 30.02,31.79,33.53,38.47,42.61,47.73,52.77,57.84,66.47,73.53,
 80.37,86.05,92.24,97.29,102.46,117.21,131.00,147.47,166.33,185.60,
 225.92,266.11};
static float alpha05_nx064_nz03_fwhm500[32] = {
 6.08,6.99,9.14,11.42,12.78,15.40,19.04,22.89,25.75,28.55,
 30.85,33.17,34.61,39.92,44.33,49.78,55.83,60.98,69.94,78.22,
 84.78,91.23,97.33,102.79,108.27,124.38,138.63,156.24,178.00,198.62,
 243.80,282.50};
static float *alpha05_nx064_nz03[21] = {
 alpha05_nx064_nz03_fwhm000, alpha05_nx064_nz03_fwhm025, alpha05_nx064_nz03_fwhm050, 
 alpha05_nx064_nz03_fwhm075, alpha05_nx064_nz03_fwhm100, alpha05_nx064_nz03_fwhm125, 
 alpha05_nx064_nz03_fwhm150, alpha05_nx064_nz03_fwhm175, alpha05_nx064_nz03_fwhm200, 
 alpha05_nx064_nz03_fwhm225, alpha05_nx064_nz03_fwhm250, alpha05_nx064_nz03_fwhm275, 
 alpha05_nx064_nz03_fwhm300, alpha05_nx064_nz03_fwhm325, alpha05_nx064_nz03_fwhm350, 
 alpha05_nx064_nz03_fwhm375, alpha05_nx064_nz03_fwhm400, alpha05_nx064_nz03_fwhm425, 
 alpha05_nx064_nz03_fwhm450, alpha05_nx064_nz03_fwhm475, alpha05_nx064_nz03_fwhm500} ;

static float alpha10_nx064_nz03_fwhm000[32] = {
 1.84,1.86,1.87,1.88,1.89,1.90,1.90,1.91,1.91,1.91,
 1.91,1.92,1.92,1.94,1.96,1.99,2.29,2.48,2.70,2.80,
 2.86,2.90,2.93,2.97,3.00,3.53,3.76,3.93,4.39,4.78,
 5.52,6.15};
static float alpha10_nx064_nz03_fwhm025[32] = {
 1.84,1.86,1.87,1.88,1.89,1.90,1.90,1.91,1.91,1.91,
 1.91,1.92,1.92,1.94,1.96,1.99,2.29,2.48,2.70,2.80,
 2.86,2.90,2.93,2.97,3.00,3.53,3.76,3.93,4.39,4.78,
 5.52,6.15};
static float alpha10_nx064_nz03_fwhm050[32] = {
 1.84,1.86,1.87,1.88,1.89,1.90,1.90,1.91,1.91,1.91,
 1.92,1.92,1.93,1.94,1.97,2.05,2.35,2.53,2.72,2.81,
 2.87,2.91,2.95,2.98,3.11,3.59,3.81,3.96,4.50,4.84,
 5.64,6.39};
static float alpha10_nx064_nz03_fwhm075[32] = {
 1.84,1.86,1.88,1.89,1.89,1.90,1.91,1.91,1.92,1.92,
 1.93,1.94,1.94,1.97,2.10,2.38,2.57,2.69,2.82,2.89,
 2.94,2.98,3.16,3.38,3.55,3.81,3.96,4.47,4.87,5.34,
 6.16,7.06};
static float alpha10_nx064_nz03_fwhm100[32] = {
 1.84,1.87,1.88,1.89,1.90,1.91,1.92,1.93,1.95,1.96,
 1.98,2.00,2.13,2.45,2.61,2.73,2.82,2.88,2.96,3.20,
 3.51,3.69,3.80,3.89,3.96,4.54,4.86,5.39,5.94,6.64,
 7.86,9.16};
static float alpha10_nx064_nz03_fwhm125[32] = {
 1.85,1.88,1.90,1.92,1.93,1.95,1.99,2.22,2.41,2.54,
 2.63,2.70,2.75,2.86,2.92,3.00,3.36,3.60,3.86,4.09,
 4.51,4.77,4.93,5.17,5.47,6.07,6.79,7.65,8.65,9.72,
 11.76,13.96};
static float alpha10_nx064_nz03_fwhm150[32] = {
 1.90,1.94,1.98,2.12,2.38,2.53,2.70,2.83,2.92,2.98,
 3.14,3.33,3.47,3.76,3.94,4.34,4.72,4.96,5.66,6.13,
 6.74,7.17,7.66,8.01,8.50,9.68,10.82,12.38,14.19,15.94,
 19.63,23.32};
static float alpha10_nx064_nz03_fwhm175[32] = {
 2.13,2.42,2.60,2.76,2.90,3.00,3.49,3.78,3.97,4.30,
 4.54,4.73,4.90,5.52,5.95,6.62,7.27,7.85,8.91,9.83,
 10.72,11.51,12.30,12.97,13.69,15.71,17.60,19.93,22.93,25.85,
 31.83,38.17};
static float alpha10_nx064_nz03_fwhm200[32] = {
 2.61,2.84,3.04,3.46,3.83,4.13,4.76,5.24,5.72,6.07,
 6.51,6.83,7.16,8.03,8.81,9.72,10.79,11.68,13.21,14.59,
 15.82,17.02,18.17,19.26,20.27,23.23,26.10,29.77,33.99,38.22,
 46.75,55.73};
static float alpha10_nx064_nz03_fwhm225[32] = {
 2.85,3.31,3.77,4.22,4.79,5.28,6.12,6.82,7.51,8.17,
 8.69,9.17,9.66,10.91,12.05,13.17,14.59,15.68,17.76,19.59,
 21.42,23.02,24.59,26.06,27.50,31.54,35.23,40.00,45.56,51.13,
 62.43,73.60};
static float alpha10_nx064_nz03_fwhm250[32] = {
 2.96,3.65,4.18,4.89,5.66,6.29,7.43,8.55,9.44,10.19,
 10.89,11.58,12.11,13.66,14.96,16.42,18.10,19.53,22.25,24.79,
 26.95,29.07,30.85,32.67,34.54,39.64,44.12,50.15,57.08,64.12,
 76.87,90.87};
static float alpha10_nx064_nz03_fwhm275[32] = {
 3.01,3.74,4.40,5.46,6.38,7.12,8.73,9.92,11.09,11.98,
 12.62,13.24,14.03,15.84,17.58,19.22,21.39,23.18,26.48,29.43,
 32.21,34.71,36.89,39.14,41.23,47.05,52.60,59.40,67.72,75.45,
 90.97,106.60};
static float alpha10_nx064_nz03_fwhm300[32] = {
 3.01,3.74,4.43,5.74,6.66,7.63,9.57,11.19,12.27,12.90,
 13.99,14.96,15.73,18.06,19.64,21.91,24.42,26.75,30.41,34.05,
 37.03,39.77,42.41,44.95,47.35,53.97,60.53,68.41,77.47,86.71,
 104.36,121.50};
static float alpha10_nx064_nz03_fwhm325[32] = {
 3.01,3.74,4.43,5.75,6.69,8.03,10.08,12.11,12.87,14.29,
 15.37,16.19,17.44,19.87,21.86,24.50,27.35,30.02,34.15,38.28,
 41.49,45.00,48.06,50.72,53.50,60.93,67.85,76.49,86.78,97.55,
 117.23,137.00};
static float alpha10_nx064_nz03_fwhm350[32] = {
 3.01,3.74,4.43,5.75,6.69,8.24,10.81,12.50,13.78,15.34,
 16.52,18.04,18.67,21.63,24.10,26.97,30.23,33.10,37.85,42.20,
 45.89,49.50,52.76,56.00,58.88,66.94,75.26,84.46,96.87,108.18,
 129.85,151.11};
static float alpha10_nx064_nz03_fwhm375[32] = {
 3.01,3.74,4.43,5.75,6.69,8.52,11.21,12.65,14.73,15.94,
 18.10,18.72,20.02,23.33,25.68,29.02,33.01,36.02,41.43,45.69,
 50.08,53.70,57.41,60.70,63.86,73.29,81.96,93.04,106.57,118.15,
 141.70,164.89};
static float alpha10_nx064_nz03_fwhm400[32] = {
 3.01,3.74,4.43,5.75,6.69,8.52,11.35,12.83,15.33,16.93,
 18.43,19.33,21.22,24.56,27.51,30.81,34.85,38.40,44.30,48.78,
 53.94,57.85,61.97,65.96,69.56,79.61,89.63,102.04,115.36,128.52,
 153.86,178.50};
static float alpha10_nx064_nz03_fwhm425[32] = {
 3.01,3.74,4.43,5.75,6.69,8.52,11.35,12.91,15.44,17.50,
 18.79,21.06,21.78,25.48,29.02,33.07,36.69,40.68,46.76,52.27,
 57.72,62.74,66.54,70.57,75.12,86.11,96.77,109.45,124.66,138.70,
 165.90,192.42};
static float alpha10_nx064_nz03_fwhm450[32] = {
 3.01,3.74,4.43,5.75,6.69,8.52,11.35,12.91,15.67,18.11,
 19.42,21.50,22.90,27.13,30.37,34.02,39.17,42.73,49.12,55.94,
 61.48,66.60,71.18,75.94,80.07,92.55,103.70,117.67,133.26,148.85,
 177.97,208.86};
static float alpha10_nx064_nz03_fwhm475[32] = {
 3.01,3.74,4.43,5.75,6.69,8.52,11.35,12.91,15.74,18.23,
 19.89,21.73,23.45,27.57,31.28,35.75,40.44,45.23,52.37,60.00,
 65.20,70.67,75.74,81.06,85.35,98.58,110.96,125.53,141.94,158.67,
 191.63,224.06};
static float alpha10_nx064_nz03_fwhm500[32] = {
 3.01,3.74,4.43,5.75,6.69,8.52,11.35,12.91,15.74,18.23,
 19.89,21.91,24.03,28.30,32.91,36.94,42.52,47.13,55.37,62.69,
 69.22,75.06,80.71,85.43,90.53,105.21,116.82,132.31,150.86,168.05,
 204.14,238.17};
static float *alpha10_nx064_nz03[21] = {
 alpha10_nx064_nz03_fwhm000, alpha10_nx064_nz03_fwhm025, alpha10_nx064_nz03_fwhm050, 
 alpha10_nx064_nz03_fwhm075, alpha10_nx064_nz03_fwhm100, alpha10_nx064_nz03_fwhm125, 
 alpha10_nx064_nz03_fwhm150, alpha10_nx064_nz03_fwhm175, alpha10_nx064_nz03_fwhm200, 
 alpha10_nx064_nz03_fwhm225, alpha10_nx064_nz03_fwhm250, alpha10_nx064_nz03_fwhm275, 
 alpha10_nx064_nz03_fwhm300, alpha10_nx064_nz03_fwhm325, alpha10_nx064_nz03_fwhm350, 
 alpha10_nx064_nz03_fwhm375, alpha10_nx064_nz03_fwhm400, alpha10_nx064_nz03_fwhm425, 
 alpha10_nx064_nz03_fwhm450, alpha10_nx064_nz03_fwhm475, alpha10_nx064_nz03_fwhm500} ;

static float **nx064_nz03[3] = {
  alpha01_nx064_nz03 , alpha05_nx064_nz03 , alpha10_nx064_nz03 };

static float alpha01_nx064_nz04_fwhm000[32] = {
 1.99,1.99,1.99,1.99,1.99,1.99,2.00,2.00,2.12,2.28,
 2.46,2.58,2.66,2.81,2.89,2.93,2.96,2.97,3.00,3.43,
 3.69,3.83,3.89,3.94,3.97,4.48,4.83,5.07,5.77,6.19,
 7.20,8.42};
static float alpha01_nx064_nz04_fwhm025[32] = {
 1.99,1.99,1.99,1.99,1.99,1.99,2.00,2.00,2.12,2.28,
 2.46,2.58,2.66,2.81,2.89,2.93,2.96,2.97,3.00,3.43,
 3.69,3.83,3.89,3.94,3.97,4.48,4.83,5.07,5.77,6.19,
 7.20,8.42};
static float alpha01_nx064_nz04_fwhm050[32] = {
 1.99,1.99,1.99,1.99,1.99,1.99,2.00,2.00,2.17,2.36,
 2.53,2.64,2.70,2.84,2.90,2.94,2.96,2.98,3.10,3.52,
 3.75,3.87,3.92,3.96,3.98,4.58,4.89,5.27,5.86,6.41,
 7.47,8.68};
static float alpha01_nx064_nz04_fwhm075[32] = {
 1.99,1.99,1.99,1.99,1.99,2.00,2.00,2.36,2.54,2.66,
 2.75,2.80,2.84,2.91,2.94,2.97,2.99,3.08,3.61,3.82,
 3.91,3.96,4.00,4.30,4.55,4.90,5.32,5.86,6.59,6.99,
 8.54,9.68};
static float alpha01_nx064_nz04_fwhm100[32] = {
 1.99,1.99,2.00,2.00,2.28,2.46,2.67,2.79,2.85,2.89,
 2.91,2.93,2.95,2.98,3.00,3.42,3.70,3.83,3.96,4.20,
 4.60,4.81,4.93,5.12,5.47,5.97,6.71,7.29,8.00,8.95,
 10.92,12.79};
static float alpha01_nx064_nz04_fwhm125[32] = {
 2.24,2.49,2.64,2.76,2.83,2.88,2.94,2.98,2.99,3.23,
 3.48,3.59,3.69,3.88,3.96,4.24,4.66,4.90,5.37,5.84,
 6.22,6.65,6.88,7.09,7.53,8.49,9.36,10.72,12.22,13.73,
 16.89,20.26};
static float alpha01_nx064_nz04_fwhm150[32] = {
 2.89,2.95,2.99,3.26,3.55,3.73,3.93,4.19,4.48,4.68,
 4.83,4.92,5.07,5.63,5.93,6.41,6.79,7.31,8.21,8.95,
 9.77,10.38,10.95,11.68,12.28,13.99,16.03,18.27,21.21,23.80,
 29.64,36.32};
static float alpha01_nx064_nz04_fwhm175[32] = {
 3.85,4.13,4.48,4.75,4.98,5.32,5.83,6.24,6.66,6.91,
 7.24,7.60,7.79,8.59,9.10,10.07,10.95,11.85,13.27,14.68,
 15.96,17.15,18.25,19.68,21.16,24.09,27.25,30.82,35.61,40.52,
 50.33,60.70};
static float alpha01_nx064_nz04_fwhm200[32] = {
 5.35,5.85,6.25,6.79,7.21,7.64,8.49,9.09,9.75,10.37,
 10.89,11.40,11.74,12.92,14.30,15.49,16.74,18.29,20.83,22.85,
 25.18,27.18,29.15,30.70,32.39,37.06,41.60,48.06,54.75,62.25,
 77.89,95.20};
static float alpha01_nx064_nz04_fwhm225[32] = {
 7.11,7.82,8.51,8.92,9.84,10.53,12.14,13.32,14.17,15.00,
 15.72,16.40,16.98,18.77,20.18,22.18,23.92,26.00,29.69,33.13,
 35.72,38.25,41.41,42.95,45.21,51.92,58.67,67.00,77.29,86.50,
 107.17,129.62};
static float alpha01_nx064_nz04_fwhm250[32] = {
 9.14,10.16,11.00,12.21,13.61,14.59,16.41,17.81,19.16,19.93,
 20.67,21.46,22.50,24.91,27.00,29.40,31.95,34.47,39.47,43.33,
 46.64,50.56,54.23,57.45,60.50,69.17,77.00,87.29,99.00,111.64,
 137.33,163.86};
static float alpha01_nx064_nz04_fwhm275[32] = {
 11.43,13.38,14.48,15.82,17.29,18.50,20.26,21.68,23.11,24.45,
 25.75,27.29,28.24,31.14,33.80,37.12,40.53,43.77,50.00,54.81,
 59.62,63.27,67.10,70.50,74.67,84.30,94.44,109.00,122.57,136.57,
 168.50,199.50};
static float alpha01_nx064_nz04_fwhm300[32] = {
 14.43,16.20,17.25,18.80,20.31,22.20,24.18,26.50,28.45,29.90,
 31.50,32.90,34.55,38.27,41.50,46.00,49.91,53.93,59.56,65.56,
 71.43,75.88,79.88,84.40,88.11,102.12,113.50,129.00,147.00,164.33,
 198.50,239.75};
static float alpha01_nx064_nz04_fwhm325[32] = {
 16.80,18.67,20.07,21.80,24.20,25.93,29.29,31.88,34.19,36.31,
 38.18,40.00,41.38,46.00,50.00,54.43,58.36,62.45,71.00,76.67,
 82.25,87.60,94.00,99.25,104.00,118.71,132.75,150.00,169.67,189.25,
 230.86,277.50};
static float alpha01_nx064_nz04_fwhm350[32] = {
 18.60,21.23,23.45,26.00,28.28,29.93,34.17,37.23,39.80,42.21,
 43.79,45.75,47.60,52.82,56.73,61.00,67.00,71.86,81.17,86.78,
 95.60,102.30,107.86,114.40,120.80,137.60,151.00,166.75,190.00,212.50,
 266.00,313.00};
static float alpha01_nx064_nz04_fwhm375[32] = {
 21.44,24.47,26.64,28.62,31.38,34.12,38.14,41.62,44.27,47.12,
 49.44,51.55,53.60,58.67,63.43,68.17,74.88,80.88,90.67,100.40,
 108.43,115.75,122.50,129.50,135.20,152.33,166.33,187.00,213.33,240.50,
 293.20,347.20};
static float alpha01_nx064_nz04_fwhm400[32] = {
 24.00,26.73,29.00,32.11,34.60,37.50,41.80,45.00,48.33,51.20,
 54.00,56.00,58.90,64.33,69.30,75.80,83.00,89.00,101.00,110.12,
 119.38,127.25,134.00,141.43,147.25,166.00,183.00,206.00,235.00,266.50,
 322.00,380.00};
static float alpha01_nx064_nz04_fwhm425[32] = {
 25.70,28.75,31.33,34.86,38.00,41.00,45.00,48.67,52.33,55.38,
 58.80,61.40,63.71,70.00,76.00,83.14,91.00,97.60,109.80,121.00,
 129.80,139.11,146.33,152.80,160.00,179.00,199.00,224.20,262.00,292.50,
 352.80,415.00};
static float alpha01_nx064_nz04_fwhm450[32] = {
 27.50,31.00,33.29,36.83,40.45,43.00,48.20,52.33,56.50,60.12,
 63.20,65.67,68.80,75.67,81.75,90.25,99.00,105.50,118.67,130.00,
 140.67,149.75,157.14,165.75,172.00,192.33,214.75,245.00,282.00,318.00,
 385.50,448.00};
static float alpha01_nx064_nz04_fwhm475[32] = {
 28.17,32.08,35.00,39.11,42.25,45.50,51.89,56.67,60.25,64.25,
 67.20,70.00,73.33,81.67,88.75,97.25,106.20,113.67,127.00,138.83,
 150.50,158.83,167.50,175.33,182.50,209.00,233.00,266.00,307.00,341.50,
 410.80,477.00};
static float alpha01_nx064_nz04_fwhm500[32] = {
 29.33,33.00,36.50,40.50,45.17,48.83,54.50,59.50,63.56,68.29,
 71.83,75.50,78.00,87.17,94.60,104.00,113.60,120.60,134.80,149.25,
 158.25,169.33,178.43,188.83,198.50,225.50,252.00,285.50,328.00,366.50,
 436.25,512.00};
static float *alpha01_nx064_nz04[21] = {
 alpha01_nx064_nz04_fwhm000, alpha01_nx064_nz04_fwhm025, alpha01_nx064_nz04_fwhm050, 
 alpha01_nx064_nz04_fwhm075, alpha01_nx064_nz04_fwhm100, alpha01_nx064_nz04_fwhm125, 
 alpha01_nx064_nz04_fwhm150, alpha01_nx064_nz04_fwhm175, alpha01_nx064_nz04_fwhm200, 
 alpha01_nx064_nz04_fwhm225, alpha01_nx064_nz04_fwhm250, alpha01_nx064_nz04_fwhm275, 
 alpha01_nx064_nz04_fwhm300, alpha01_nx064_nz04_fwhm325, alpha01_nx064_nz04_fwhm350, 
 alpha01_nx064_nz04_fwhm375, alpha01_nx064_nz04_fwhm400, alpha01_nx064_nz04_fwhm425, 
 alpha01_nx064_nz04_fwhm450, alpha01_nx064_nz04_fwhm475, alpha01_nx064_nz04_fwhm500} ;

static float alpha05_nx064_nz04_fwhm000[32] = {
 1.93,1.94,1.94,1.95,1.95,1.95,1.96,1.96,1.96,1.96,
 1.97,1.97,1.98,2.01,2.39,2.60,2.74,2.81,2.90,2.94,
 2.97,3.00,3.30,3.51,3.64,3.87,3.98,4.56,4.89,5.34,
 6.21,7.00};
static float alpha05_nx064_nz04_fwhm025[32] = {
 1.93,1.94,1.94,1.95,1.95,1.95,1.96,1.96,1.96,1.96,
 1.97,1.97,1.98,2.01,2.39,2.60,2.74,2.81,2.90,2.94,
 2.97,3.00,3.30,3.51,3.64,3.87,3.98,4.56,4.89,5.34,
 6.21,7.00};
static float alpha05_nx064_nz04_fwhm050[32] = {
 1.93,1.94,1.94,1.95,1.95,1.95,1.96,1.96,1.96,1.96,
 1.97,1.98,1.98,2.14,2.46,2.64,2.76,2.83,2.91,2.95,
 2.98,3.14,3.42,3.57,3.70,3.90,4.04,4.65,4.94,5.51,
 6.42,7.35};
static float alpha05_nx064_nz04_fwhm075[32] = {
 1.93,1.94,1.94,1.95,1.95,1.96,1.96,1.97,1.97,1.98,
 1.99,2.00,2.14,2.48,2.65,2.77,2.85,2.90,2.95,2.99,
 3.32,3.57,3.71,3.81,3.87,4.07,4.63,4.93,5.59,5.98,
 7.08,8.18};
static float alpha05_nx064_nz04_fwhm100[32] = {
 1.93,1.94,1.95,1.96,1.96,1.97,1.98,1.99,2.21,2.38,
 2.50,2.60,2.67,2.79,2.86,2.92,2.96,2.99,3.50,3.74,
 3.87,3.95,4.12,4.42,4.63,4.97,5.61,6.07,6.85,7.64,
 9.00,10.67};
static float alpha05_nx064_nz04_fwhm125[32] = {
 1.95,1.96,1.97,1.99,2.08,2.32,2.57,2.70,2.78,2.83,
 2.88,2.91,2.93,2.99,3.32,3.63,3.83,3.94,4.42,4.80,
 4.99,5.44,5.74,5.93,6.24,6.94,7.78,8.78,9.93,11.22,
 13.70,16.56};
static float alpha05_nx064_nz04_fwhm150[32] = {
 2.11,2.40,2.55,2.70,2.80,2.88,2.97,3.24,3.50,3.67,
 3.79,3.87,3.94,4.39,4.70,4.94,5.43,5.83,6.52,7.05,
 7.70,8.24,8.79,9.34,9.83,11.24,12.59,14.44,16.72,18.97,
 23.59,28.61};
static float alpha05_nx064_nz04_fwhm175[32] = {
 2.78,2.91,3.00,3.40,3.68,3.88,4.22,4.62,4.86,5.07,
 5.44,5.67,5.88,6.53,6.98,7.71,8.43,9.10,10.32,11.37,
 12.42,13.34,14.29,15.21,16.11,18.60,20.90,23.99,27.97,31.94,
 39.88,48.67};
static float alpha05_nx064_nz04_fwhm200[32] = {
 3.55,3.89,4.19,4.59,4.94,5.34,5.92,6.55,6.91,7.40,
 7.85,8.21,8.55,9.55,10.43,11.30,12.44,13.58,15.50,17.24,
 18.90,20.42,21.75,23.26,24.66,28.44,32.19,37.13,42.59,48.34,
 60.29,73.00};
static float alpha05_nx064_nz04_fwhm225[32] = {
 4.45,4.92,5.37,5.95,6.54,7.02,7.96,8.68,9.36,9.98,
 10.60,11.11,11.62,13.00,14.27,15.84,17.54,19.07,21.73,24.28,
 26.52,28.49,30.58,32.62,34.38,39.72,44.78,51.28,59.06,66.98,
 83.00,100.35};
static float alpha05_nx064_nz04_fwhm250[32] = {
 5.06,5.83,6.50,7.16,7.96,8.66,9.78,10.87,11.89,12.70,
 13.51,14.19,14.92,16.95,18.52,20.66,22.82,24.87,28.44,31.51,
 34.44,37.49,40.09,42.70,44.82,51.58,57.69,65.55,75.85,85.96,
 106.45,127.52};
static float alpha05_nx064_nz04_fwhm275[32] = {
 5.76,6.75,7.53,8.40,9.28,10.28,11.91,13.37,14.59,15.73,
 16.67,17.68,18.64,21.16,23.07,25.85,28.66,30.98,35.72,39.58,
 43.06,46.32,49.05,52.33,54.96,62.91,70.24,81.35,93.47,105.25,
 129.96,155.92};
static float alpha05_nx064_nz04_fwhm300[32] = {
 6.27,7.49,8.46,9.63,10.85,11.99,14.13,15.83,17.22,18.84,
 20.11,21.39,22.60,25.72,27.89,31.06,34.51,37.23,42.49,46.98,
 51.30,55.12,58.68,62.03,65.19,75.33,85.00,97.00,111.75,125.64,
 153.81,184.33};
static float alpha05_nx064_nz04_fwhm325[32] = {
 6.72,8.17,9.23,10.76,12.38,13.93,16.28,18.32,20.42,21.92,
 23.53,24.93,26.29,29.74,32.83,36.25,39.87,43.45,49.35,54.48,
 58.95,64.00,68.22,72.38,76.30,88.26,99.43,112.40,129.06,145.68,
 177.40,210.11};
static float alpha05_nx064_nz04_fwhm350[32] = {
 6.97,8.68,10.19,11.86,13.74,15.57,18.34,20.69,22.79,24.92,
 26.84,28.45,29.95,33.83,37.16,40.91,45.26,49.20,56.00,62.22,
 67.86,72.89,77.64,82.15,87.43,100.54,112.50,127.65,146.28,164.12,
 200.80,236.46};
static float alpha05_nx064_nz04_fwhm375[32] = {
 7.07,8.91,10.71,12.80,15.08,16.77,20.12,22.90,25.49,27.70,
 29.67,31.41,33.09,37.42,41.00,45.59,50.68,55.34,62.96,69.48,
 75.88,81.92,87.80,93.14,97.86,112.20,125.48,142.27,163.20,184.31,
 222.64,262.50};
static float alpha05_nx064_nz04_fwhm400[32] = {
 7.07,8.91,10.90,13.35,16.22,18.27,21.74,25.12,27.96,30.17,
 32.26,34.36,36.00,41.00,45.09,50.42,56.17,60.87,69.29,76.97,
 84.56,90.64,96.20,101.85,108.03,123.42,137.93,157.38,180.73,202.58,
 244.15,287.00};
static float alpha05_nx064_nz04_fwhm425[32] = {
 7.07,8.91,11.18,14.17,16.64,19.16,23.43,26.92,29.58,31.92,
 34.63,36.54,38.82,44.53,49.20,55.00,60.67,66.36,75.56,84.12,
 91.50,97.88,104.94,111.30,117.67,134.56,151.95,172.79,196.35,219.00,
 264.10,312.00};
static float alpha05_nx064_nz04_fwhm450[32] = {
 7.07,8.91,11.60,14.55,17.06,19.79,24.34,27.95,31.10,34.19,
 36.50,39.33,41.51,47.58,52.72,58.53,65.48,71.14,81.57,90.50,
 98.55,105.83,113.08,119.94,126.25,145.86,163.82,185.00,212.17,237.29,
 284.56,333.29};
static float alpha05_nx064_nz04_fwhm475[32] = {
 7.07,8.91,11.60,14.55,17.17,20.11,24.74,29.00,32.50,36.11,
 38.70,40.97,43.49,50.04,55.54,62.38,69.64,76.12,87.41,96.65,
 105.21,113.27,120.85,128.42,135.33,155.59,175.25,199.64,227.67,254.58,
 303.29,357.17};
static float alpha05_nx064_nz04_fwhm500[32] = {
 7.07,8.91,11.60,14.55,17.20,20.34,24.97,29.91,33.90,37.00,
 40.56,43.23,45.69,52.42,58.52,66.60,74.00,80.43,91.89,102.73,
 111.75,121.20,129.73,137.47,145.00,166.38,186.83,212.88,242.78,270.50,
 323.14,382.86};
static float *alpha05_nx064_nz04[21] = {
 alpha05_nx064_nz04_fwhm000, alpha05_nx064_nz04_fwhm025, alpha05_nx064_nz04_fwhm050, 
 alpha05_nx064_nz04_fwhm075, alpha05_nx064_nz04_fwhm100, alpha05_nx064_nz04_fwhm125, 
 alpha05_nx064_nz04_fwhm150, alpha05_nx064_nz04_fwhm175, alpha05_nx064_nz04_fwhm200, 
 alpha05_nx064_nz04_fwhm225, alpha05_nx064_nz04_fwhm250, alpha05_nx064_nz04_fwhm275, 
 alpha05_nx064_nz04_fwhm300, alpha05_nx064_nz04_fwhm325, alpha05_nx064_nz04_fwhm350, 
 alpha05_nx064_nz04_fwhm375, alpha05_nx064_nz04_fwhm400, alpha05_nx064_nz04_fwhm425, 
 alpha05_nx064_nz04_fwhm450, alpha05_nx064_nz04_fwhm475, alpha05_nx064_nz04_fwhm500} ;

static float alpha10_nx064_nz04_fwhm000[32] = {
 1.86,1.88,1.89,1.89,1.90,1.90,1.90,1.91,1.91,1.91,
 1.92,1.92,1.93,1.95,1.98,2.20,2.47,2.62,2.78,2.85,
 2.90,2.93,2.96,3.00,3.23,3.66,3.85,4.01,4.63,4.90,
 5.79,6.63};
static float alpha10_nx064_nz04_fwhm025[32] = {
 1.86,1.88,1.89,1.89,1.90,1.90,1.90,1.91,1.91,1.91,
 1.92,1.92,1.93,1.95,1.98,2.20,2.47,2.62,2.78,2.85,
 2.90,2.93,2.96,3.00,3.23,3.66,3.85,4.01,4.63,4.90,
 5.79,6.63};
static float alpha10_nx064_nz04_fwhm050[32] = {
 1.86,1.88,1.89,1.89,1.90,1.90,1.91,1.91,1.91,1.91,
 1.92,1.93,1.93,1.96,1.99,2.27,2.52,2.65,2.80,2.86,
 2.91,2.95,2.98,3.10,3.34,3.71,3.88,4.18,4.70,4.96,
 5.88,6.78};
static float alpha10_nx064_nz04_fwhm075[32] = {
 1.86,1.88,1.89,1.89,1.90,1.90,1.91,1.91,1.92,1.93,
 1.94,1.94,1.96,2.00,2.29,2.53,2.68,2.77,2.86,2.92,
 2.96,3.08,3.36,3.54,3.67,3.89,4.11,4.68,4.98,5.65,
 6.63,7.59};
static float alpha10_nx064_nz04_fwhm100[32] = {
 1.86,1.88,1.89,1.90,1.91,1.92,1.93,1.94,1.96,1.98,
 2.00,2.19,2.32,2.56,2.69,2.79,2.86,2.91,2.99,3.39,
 3.63,3.77,3.87,3.95,4.08,4.70,4.98,5.68,6.29,6.92,
 8.35,9.74};
static float alpha10_nx064_nz04_fwhm125[32] = {
 1.87,1.90,1.91,1.93,1.95,1.97,2.10,2.35,2.51,2.61,
 2.69,2.75,2.79,2.88,2.95,3.14,3.50,3.69,3.93,4.31,
 4.65,4.87,5.09,5.44,5.70,6.38,6.98,7.91,8.97,10.14,
 12.37,14.84};
static float alpha10_nx064_nz04_fwhm150[32] = {
 1.93,1.97,2.01,2.30,2.49,2.63,2.78,2.89,2.96,3.07,
 3.30,3.45,3.58,3.85,4.00,4.48,4.81,5.09,5.77,6.34,
 6.83,7.38,7.84,8.34,8.79,9.97,11.20,12.84,14.93,16.93,
 21.12,25.70};
static float alpha10_nx064_nz04_fwhm175[32] = {
 2.35,2.58,2.73,2.86,2.98,3.24,3.64,3.88,4.13,4.44,
 4.67,4.83,4.98,5.60,6.00,6.67,7.30,7.86,8.95,9.91,
 10.85,11.76,12.58,13.38,14.12,16.42,18.51,21.25,24.72,28.39,
 35.51,43.05};
static float alpha10_nx064_nz04_fwhm200[32] = {
 2.80,2.99,3.33,3.69,4.00,4.40,4.86,5.33,5.76,6.12,
 6.52,6.82,7.12,7.98,8.76,9.63,10.70,11.68,13.38,14.92,
 16.36,17.68,18.91,20.17,21.41,24.93,28.21,32.43,37.49,42.65,
 53.18,64.36};
static float alpha10_nx064_nz04_fwhm225[32] = {
 3.22,3.74,4.13,4.59,4.99,5.52,6.31,6.95,7.56,8.08,
 8.57,9.02,9.50,10.78,11.89,13.22,14.69,16.03,18.55,20.68,
 22.58,24.53,26.32,28.03,29.59,34.44,38.84,44.34,51.05,58.01,
 72.18,87.24};
static float alpha10_nx064_nz04_fwhm250[32] = {
 3.62,4.26,4.72,5.35,5.99,6.62,7.68,8.61,9.36,10.11,
 10.85,11.51,12.15,13.68,15.12,17.02,18.97,20.72,24.06,26.78,
 29.44,31.83,34.17,36.34,38.32,44.22,49.51,56.77,65.43,74.44,
 92.15,111.08};
static float alpha10_nx064_nz04_fwhm275[32] = {
 3.82,4.54,5.13,5.96,6.85,7.61,8.87,10.11,11.22,12.17,
 13.05,13.82,14.61,16.88,18.76,20.96,23.44,25.67,29.65,33.06,
 36.03,39.01,41.77,44.54,47.01,54.27,60.83,69.79,80.74,90.95,
 112.90,135.46};
static float alpha10_nx064_nz04_fwhm300[32] = {
 3.90,4.75,5.52,6.50,7.55,8.49,10.14,11.65,13.03,14.30,
 15.35,16.36,17.35,19.88,22.05,24.82,27.93,30.60,35.19,39.28,
 43.04,46.43,49.72,52.91,56.00,64.48,72.69,83.26,95.60,107.83,
 132.87,158.32};
static float alpha10_nx064_nz04_fwhm325[32] = {
 3.90,4.75,5.69,6.87,8.09,9.24,11.34,12.99,14.69,15.99,
 17.39,18.65,19.86,22.77,25.52,28.69,32.18,35.18,40.79,45.59,
 49.63,54.08,57.62,60.92,64.66,75.27,84.53,95.64,110.39,124.40,
 152.31,181.64};
static float alpha10_nx064_nz04_fwhm350[32] = {
 3.90,4.75,5.69,6.87,8.37,9.64,12.13,14.39,16.22,17.79,
 19.23,20.67,22.12,25.59,28.65,32.24,36.40,40.00,46.28,51.37,
 56.51,61.07,65.40,69.35,73.72,85.32,95.12,108.58,124.61,140.32,
 172.83,204.40};
static float alpha10_nx064_nz04_fwhm375[32] = {
 3.90,4.75,5.69,6.87,8.41,9.96,12.76,15.23,17.17,19.11,
 20.84,22.60,24.00,27.89,31.56,35.64,40.19,44.28,51.34,57.19,
 62.87,67.96,73.10,77.79,82.21,94.41,105.90,120.78,138.92,157.63,
 192.29,225.53};
static float alpha10_nx064_nz04_fwhm400[32] = {
 3.90,4.75,5.69,6.87,8.41,9.96,12.97,15.83,18.12,20.32,
 22.38,24.18,25.72,30.54,34.19,38.78,43.90,48.36,55.81,62.62,
 68.76,74.65,79.82,85.13,90.24,103.85,116.67,133.11,153.26,173.28,
 209.38,245.00};
static float alpha10_nx064_nz04_fwhm425[32] = {
 3.90,4.75,5.69,6.87,8.41,9.96,13.15,16.14,18.84,21.31,
 23.55,25.41,27.54,32.52,36.75,41.69,47.28,52.12,60.00,67.74,
 74.39,80.71,86.92,92.56,98.20,113.09,126.69,145.17,167.17,186.89,
 225.59,265.17};
static float alpha10_nx064_nz04_fwhm450[32] = {
 3.90,4.75,5.69,6.87,8.41,9.96,13.31,16.56,19.22,21.93,
 24.32,26.78,29.02,34.00,38.70,44.39,50.25,55.57,64.33,72.44,
 79.95,86.68,93.47,99.77,106.06,121.71,137.19,156.73,179.81,201.00,
 241.69,283.64};
static float alpha10_nx064_nz04_fwhm475[32] = {
 3.90,4.75,5.69,6.87,8.41,9.96,13.31,16.56,19.80,22.62,
 25.11,27.58,29.89,35.76,40.65,46.49,53.05,58.45,68.59,77.38,
 85.37,92.59,99.91,106.97,113.25,130.96,147.12,167.29,191.35,214.00,
 258.44,303.60};
static float alpha10_nx064_nz04_fwhm500[32] = {
 3.90,4.75,5.69,6.87,8.41,9.96,13.31,16.56,19.80,22.83,
 25.87,28.50,30.93,37.07,41.88,48.69,55.55,61.61,72.00,81.80,
 90.49,99.00,106.25,113.44,120.44,138.89,156.30,177.64,203.80,228.40,
 275.36,322.60};
static float *alpha10_nx064_nz04[21] = {
 alpha10_nx064_nz04_fwhm000, alpha10_nx064_nz04_fwhm025, alpha10_nx064_nz04_fwhm050, 
 alpha10_nx064_nz04_fwhm075, alpha10_nx064_nz04_fwhm100, alpha10_nx064_nz04_fwhm125, 
 alpha10_nx064_nz04_fwhm150, alpha10_nx064_nz04_fwhm175, alpha10_nx064_nz04_fwhm200, 
 alpha10_nx064_nz04_fwhm225, alpha10_nx064_nz04_fwhm250, alpha10_nx064_nz04_fwhm275, 
 alpha10_nx064_nz04_fwhm300, alpha10_nx064_nz04_fwhm325, alpha10_nx064_nz04_fwhm350, 
 alpha10_nx064_nz04_fwhm375, alpha10_nx064_nz04_fwhm400, alpha10_nx064_nz04_fwhm425, 
 alpha10_nx064_nz04_fwhm450, alpha10_nx064_nz04_fwhm475, alpha10_nx064_nz04_fwhm500} ;

static float **nx064_nz04[3] = {
  alpha01_nx064_nz04 , alpha05_nx064_nz04 , alpha10_nx064_nz04 };

static float alpha01_nx064_nz05_fwhm000[32] = {
 1.99,1.99,1.99,1.99,1.99,1.99,2.00,2.09,2.32,2.51,
 2.65,2.73,2.77,2.86,2.92,2.95,2.97,2.98,3.22,3.59,
 3.77,3.87,3.93,3.97,4.01,4.68,4.90,5.35,5.88,6.42,
 7.62,8.77};
static float alpha01_nx064_nz05_fwhm025[32] = {
 1.99,1.99,1.99,1.99,1.99,1.99,2.00,2.09,2.32,2.51,
 2.65,2.73,2.77,2.86,2.92,2.95,2.97,2.98,3.22,3.59,
 3.77,3.87,3.93,3.97,4.01,4.68,4.90,5.35,5.88,6.42,
 7.62,8.77};
static float alpha01_nx064_nz05_fwhm050[32] = {
 1.99,1.99,1.99,1.99,1.99,1.99,2.00,2.18,2.42,2.60,
 2.70,2.76,2.80,2.88,2.93,2.95,2.98,2.99,3.32,3.67,
 3.81,3.91,3.95,3.98,4.18,4.76,4.94,5.52,5.93,6.61,
 7.79,8.91};
static float alpha01_nx064_nz05_fwhm075[32] = {
 1.99,1.99,1.99,1.99,2.00,2.00,2.28,2.55,2.68,2.76,
 2.82,2.86,2.88,2.93,2.96,2.98,3.00,3.33,3.70,3.86,
 3.95,3.99,4.30,4.56,4.72,4.96,5.56,5.95,6.73,7.43,
 8.72,10.15};
static float alpha01_nx064_nz05_fwhm100[32] = {
 1.99,2.00,2.00,2.15,2.45,2.62,2.77,2.85,2.89,2.92,
 2.94,2.96,2.97,2.99,3.25,3.60,3.79,3.89,3.99,4.43,
 4.71,4.88,4.99,5.34,5.62,6.06,6.79,7.62,8.46,9.37,
 11.28,13.41};
static float alpha01_nx064_nz05_fwhm125[32] = {
 2.44,2.65,2.74,2.82,2.89,2.92,2.97,3.00,3.27,3.47,
 3.63,3.75,3.80,3.92,4.05,4.47,4.80,4.94,5.52,5.88,
 6.37,6.77,6.95,7.39,7.77,8.73,9.92,11.32,12.71,14.14,
 17.45,21.14};
static float alpha01_nx064_nz05_fwhm150[32] = {
 2.93,2.98,3.11,3.48,3.72,3.85,3.97,4.31,4.60,4.77,
 4.87,4.95,5.16,5.70,5.94,6.49,6.89,7.42,8.21,9.07,
 9.86,10.67,11.32,11.91,12.61,14.45,15.95,18.69,21.65,24.52,
 30.73,37.59};
static float alpha01_nx064_nz05_fwhm175[32] = {
 4.00,4.44,4.71,4.90,5.17,5.55,5.93,6.57,6.84,7.10,
 7.44,7.74,7.95,8.81,9.49,10.25,11.29,12.15,13.60,15.09,
 16.62,17.71,19.06,20.07,21.14,24.33,27.27,31.32,36.79,41.60,
 53.57,66.00};
static float alpha01_nx064_nz05_fwhm200[32] = {
 5.83,6.35,6.76,7.30,7.80,8.20,8.83,9.58,10.21,10.74,
 11.12,11.62,11.96,13.38,14.38,15.69,17.33,18.46,20.66,22.92,
 25.12,27.06,28.52,30.80,32.43,37.60,42.71,48.88,57.64,67.60,
 86.33,106.10};
static float alpha01_nx064_nz05_fwhm225[32] = {
 7.84,8.67,9.07,9.76,10.32,10.94,12.00,12.73,13.70,14.63,
 15.31,15.89,16.56,18.41,20.10,21.81,23.71,25.61,29.27,32.46,
 35.72,38.81,41.18,43.52,46.59,54.00,61.73,72.00,84.00,94.40,
 118.90,144.57};
static float alpha01_nx064_nz05_fwhm250[32] = {
 9.62,10.37,11.21,11.98,12.86,13.82,15.31,16.60,17.88,18.79,
 19.83,20.92,21.67,23.93,26.00,28.57,31.71,34.29,38.91,43.47,
 47.57,51.38,54.92,58.81,62.73,72.71,82.17,94.17,107.89,123.17,
 152.80,185.50};
static float alpha01_nx064_nz05_fwhm275[32] = {
 11.34,12.51,13.40,14.69,15.70,16.84,18.74,20.68,22.00,23.67,
 25.05,26.07,27.50,30.16,32.95,36.24,40.36,43.75,50.00,55.91,
 61.50,66.00,70.50,75.57,80.00,91.29,102.17,116.00,133.80,153.00,
 189.50,230.75};
static float alpha01_nx064_nz05_fwhm300[32] = {
 13.14,14.68,16.00,17.38,18.59,20.17,22.95,24.79,26.67,28.42,
 30.19,32.00,33.47,37.60,40.64,45.00,50.00,54.00,61.50,67.67,
 73.50,79.50,85.14,90.86,95.73,110.88,124.00,140.75,162.75,183.60,
 227.00,273.80};
static float alpha01_nx064_nz05_fwhm325[32] = {
 15.21,16.87,18.06,20.00,21.96,23.84,26.82,29.92,31.84,34.43,
 36.60,38.21,39.71,44.70,48.55,54.33,59.17,63.57,72.00,80.44,
 88.29,95.50,102.12,107.80,114.57,130.60,146.50,166.75,190.50,215.40,
 263.33,310.00};
static float alpha01_nx064_nz05_fwhm350[32] = {
 16.90,19.00,20.78,23.47,25.67,27.80,31.67,34.88,37.86,40.29,
 42.27,44.91,46.38,51.57,56.92,62.60,69.00,74.86,85.14,95.00,
 103.83,111.50,118.70,125.40,131.50,151.00,168.83,193.67,219.20,245.50,
 297.33,355.50};
static float alpha01_nx064_nz05_fwhm375[32] = {
 18.79,21.64,24.33,26.50,29.33,32.06,36.88,40.23,43.10,46.31,
 49.10,51.33,53.40,60.12,66.25,72.67,79.70,87.00,98.78,109.25,
 119.00,126.75,136.00,143.22,151.25,173.62,192.33,218.00,246.25,274.33,
 333.33,401.60};
static float alpha01_nx064_nz05_fwhm400[32] = {
 21.83,24.90,27.40,30.18,33.40,36.00,41.29,45.33,49.14,52.67,
 56.00,58.89,61.89,69.83,75.40,83.25,91.00,98.25,111.00,121.50,
 133.57,144.10,152.00,162.25,170.75,194.60,213.60,241.20,275.25,307.50,
 372.00,451.67};
static float alpha01_nx064_nz05_fwhm425[32] = {
 23.45,27.00,30.36,33.14,37.00,40.18,46.50,51.69,56.38,59.43,
 64.57,67.38,70.00,76.90,84.67,92.60,101.00,108.75,122.75,137.00,
 148.40,159.67,169.50,179.50,188.60,215.00,237.50,266.67,302.50,339.67,
 412.67,494.50};
static float alpha01_nx064_nz05_fwhm450[32] = {
 26.20,29.75,33.23,37.27,41.20,45.00,52.30,58.60,63.33,66.67,
 70.22,73.70,76.89,85.50,94.00,101.25,111.71,120.50,137.25,151.25,
 162.50,175.33,186.00,195.67,206.00,234.00,259.00,291.50,332.50,372.00,
 457.00,540.00};
static float alpha01_nx064_nz05_fwhm475[32] = {
 28.25,32.75,36.75,40.83,45.89,50.80,57.67,63.50,68.29,72.50,
 76.29,79.83,84.11,93.00,100.71,110.50,121.50,132.80,150.17,165.00,
 178.00,191.60,202.00,213.25,223.17,253.25,278.50,317.00,361.00,406.50,
 492.67,583.00};
static float alpha01_nx064_nz05_fwhm500[32] = {
 30.00,35.50,40.17,45.00,49.78,54.36,61.60,67.75,73.25,77.56,
 81.86,86.25,90.80,100.00,107.80,118.80,132.50,143.00,161.50,178.67,
 191.25,204.00,217.57,229.40,239.00,270.33,302.00,341.50,388.50,437.00,
 528.00,619.50};
static float *alpha01_nx064_nz05[21] = {
 alpha01_nx064_nz05_fwhm000, alpha01_nx064_nz05_fwhm025, alpha01_nx064_nz05_fwhm050, 
 alpha01_nx064_nz05_fwhm075, alpha01_nx064_nz05_fwhm100, alpha01_nx064_nz05_fwhm125, 
 alpha01_nx064_nz05_fwhm150, alpha01_nx064_nz05_fwhm175, alpha01_nx064_nz05_fwhm200, 
 alpha01_nx064_nz05_fwhm225, alpha01_nx064_nz05_fwhm250, alpha01_nx064_nz05_fwhm275, 
 alpha01_nx064_nz05_fwhm300, alpha01_nx064_nz05_fwhm325, alpha01_nx064_nz05_fwhm350, 
 alpha01_nx064_nz05_fwhm375, alpha01_nx064_nz05_fwhm400, alpha01_nx064_nz05_fwhm425, 
 alpha01_nx064_nz05_fwhm450, alpha01_nx064_nz05_fwhm475, alpha01_nx064_nz05_fwhm500} ;

static float alpha05_nx064_nz05_fwhm000[32] = {
 1.94,1.94,1.95,1.95,1.95,1.95,1.96,1.96,1.96,1.97,
 1.98,1.99,1.99,2.30,2.55,2.70,2.80,2.86,2.92,2.96,
 2.99,3.24,3.49,3.65,3.76,3.93,4.15,4.70,4.97,5.57,
 6.46,7.39};
static float alpha05_nx064_nz05_fwhm025[32] = {
 1.94,1.94,1.95,1.95,1.95,1.95,1.96,1.96,1.96,1.97,
 1.98,1.99,1.99,2.30,2.55,2.70,2.80,2.86,2.92,2.96,
 2.99,3.24,3.49,3.65,3.76,3.93,4.15,4.70,4.97,5.57,
 6.46,7.39};
static float alpha05_nx064_nz05_fwhm050[32] = {
 1.94,1.94,1.95,1.95,1.95,1.95,1.96,1.96,1.97,1.97,
 1.98,1.99,2.00,2.39,2.59,2.73,2.82,2.87,2.93,2.97,
 3.00,3.36,3.57,3.71,3.79,3.96,4.30,4.77,5.04,5.69,
 6.65,7.63};
static float alpha05_nx064_nz05_fwhm075[32] = {
 1.94,1.94,1.95,1.95,1.96,1.96,1.96,1.97,1.98,1.99,
 2.08,2.25,2.37,2.62,2.73,2.83,2.89,2.92,2.97,3.19,
 3.52,3.69,3.81,3.88,3.94,4.37,4.76,5.00,5.75,6.20,
 7.38,8.58};
static float alpha05_nx064_nz05_fwhm100[32] = {
 1.94,1.95,1.95,1.96,1.97,1.98,1.99,2.18,2.39,2.53,
 2.62,2.70,2.74,2.84,2.90,2.94,2.98,3.23,3.64,3.82,
 3.92,3.99,4.35,4.60,4.76,5.16,5.75,6.28,6.98,7.87,
 9.48,11.26};
static float alpha05_nx064_nz05_fwhm125[32] = {
 1.96,1.97,1.98,2.02,2.31,2.47,2.67,2.78,2.85,2.89,
 2.92,2.95,2.97,3.25,3.55,3.75,3.90,4.00,4.61,4.87,
 5.21,5.61,5.84,6.04,6.44,7.23,7.99,9.08,10.44,11.77,
 14.53,17.49};
static float alpha05_nx064_nz05_fwhm150[32] = {
 2.34,2.56,2.68,2.79,2.88,2.95,3.19,3.48,3.65,3.80,
 3.90,3.97,4.10,4.55,4.82,5.10,5.63,5.92,6.69,7.38,
 7.94,8.60,9.06,9.70,10.12,11.69,13.10,15.07,17.57,19.88,
 25.26,30.58};
static float alpha05_nx064_nz05_fwhm175[32] = {
 2.92,3.12,3.43,3.70,3.92,4.14,4.57,4.84,5.04,5.42,
 5.72,5.93,6.16,6.83,7.34,7.93,8.77,9.46,10.67,11.84,
 12.88,13.85,14.81,15.79,16.67,19.36,21.99,25.40,29.67,34.08,
 43.06,52.76};
static float alpha05_nx064_nz05_fwhm200[32] = {
 3.93,4.37,4.68,4.96,5.44,5.82,6.53,6.95,7.52,7.89,
 8.30,8.69,8.98,9.96,10.87,11.88,13.07,13.97,15.94,17.78,
 19.45,20.97,22.73,24.07,25.58,29.83,33.77,38.99,45.64,52.76,
 67.17,82.46};
static float alpha05_nx064_nz05_fwhm225[32] = {
 4.95,5.58,6.05,6.63,7.30,7.74,8.66,9.33,10.00,10.67,
 11.13,11.73,12.19,13.54,14.72,16.21,17.83,19.43,22.35,25.03,
 27.47,29.67,31.82,33.82,35.88,41.65,47.40,54.98,64.20,73.09,
 93.52,113.67};
static float alpha05_nx064_nz05_fwhm250[32] = {
 6.04,6.79,7.36,8.11,8.83,9.37,10.50,11.54,12.51,13.30,
 14.01,14.79,15.41,17.16,18.79,20.83,23.12,25.36,29.24,32.49,
 35.68,38.61,41.31,44.15,46.70,54.88,62.32,71.92,83.26,95.87,
 120.00,144.88};
static float alpha05_nx064_nz05_fwhm275[32] = {
 6.93,7.79,8.48,9.16,10.25,10.99,12.47,13.69,14.86,15.92,
 16.92,17.87,18.84,21.31,23.41,25.94,29.03,31.45,36.21,40.45,
 44.57,48.33,51.85,55.30,58.85,68.23,77.58,88.91,103.17,118.23,
 146.20,177.47};
static float alpha05_nx064_nz05_fwhm300[32] = {
 7.60,8.57,9.42,10.39,11.60,12.65,14.51,16.05,17.42,18.73,
 19.96,21.04,22.19,25.42,27.94,31.12,34.63,37.88,43.58,48.93,
 53.83,58.36,62.68,66.90,71.19,82.50,93.47,106.84,123.93,141.06,
 173.90,210.36};
static float alpha05_nx064_nz05_fwhm325[32] = {
 8.17,9.34,10.29,11.61,13.02,14.09,16.30,18.15,19.99,21.61,
 23.10,24.48,25.93,29.70,33.03,36.65,41.05,44.96,52.03,58.39,
 63.87,69.30,74.32,78.97,83.71,96.93,109.61,124.76,144.23,163.62,
 201.76,243.08};
static float alpha05_nx064_nz05_fwhm350[32] = {
 8.45,9.77,10.99,12.41,14.01,15.51,18.23,20.70,22.79,24.78,
 26.61,28.37,29.94,34.46,37.98,42.80,48.00,52.52,60.58,68.09,
 74.10,80.00,85.75,91.42,97.12,111.35,125.56,143.47,165.08,186.53,
 230.22,276.60};
static float alpha05_nx064_nz05_fwhm375[32] = {
 8.54,10.22,11.67,13.41,15.30,17.23,20.34,23.28,25.85,28.09,
 30.32,32.14,33.96,39.28,43.72,49.29,55.14,60.20,69.58,77.64,
 84.76,90.97,97.96,104.21,109.44,125.92,142.29,161.65,186.50,211.08,
 259.75,309.80};
static float alpha05_nx064_nz05_fwhm400[32] = {
 8.66,10.50,12.38,14.07,16.68,18.77,22.33,25.91,28.62,31.36,
 33.90,36.17,38.17,44.28,49.34,55.38,61.84,67.69,78.08,86.96,
 95.25,103.00,109.35,115.89,122.08,141.14,158.44,181.00,208.18,234.00,
 287.64,342.25};
static float alpha05_nx064_nz05_fwhm425[32] = {
 8.66,10.52,12.60,15.29,18.00,20.39,24.67,28.63,31.84,35.07,
 37.65,40.30,42.70,49.23,54.65,61.40,68.76,75.00,86.06,96.50,
 105.06,113.33,120.93,128.50,135.94,156.40,174.75,199.60,229.46,258.00,
 316.50,372.75};
static float alpha05_nx064_nz05_fwhm450[32] = {
 8.66,10.85,13.34,16.00,18.84,21.65,26.47,30.68,34.55,38.21,
 41.12,44.39,46.92,53.79,59.91,66.92,74.78,82.06,94.37,105.00,
 115.00,124.45,132.85,140.75,148.20,170.46,191.40,218.46,251.67,283.00,
 342.67,406.86};
static float alpha05_nx064_nz05_fwhm475[32] = {
 8.66,10.85,13.34,16.44,19.50,22.61,28.00,32.69,37.12,40.59,
 44.15,47.21,49.95,57.94,64.41,72.35,80.88,88.42,102.21,114.08,
 124.64,134.65,144.07,153.10,160.82,184.33,208.88,236.73,272.67,305.50,
 370.00,435.00};
static float alpha05_nx064_nz05_fwhm500[32] = {
 8.66,10.85,13.38,16.56,20.15,23.35,29.28,34.53,39.38,43.17,
 46.94,50.09,53.52,61.53,68.50,77.87,87.17,95.39,109.44,123.13,
 134.07,145.00,154.50,163.69,173.10,198.92,223.50,256.08,293.62,328.00,
 396.50,465.67};
static float *alpha05_nx064_nz05[21] = {
 alpha05_nx064_nz05_fwhm000, alpha05_nx064_nz05_fwhm025, alpha05_nx064_nz05_fwhm050, 
 alpha05_nx064_nz05_fwhm075, alpha05_nx064_nz05_fwhm100, alpha05_nx064_nz05_fwhm125, 
 alpha05_nx064_nz05_fwhm150, alpha05_nx064_nz05_fwhm175, alpha05_nx064_nz05_fwhm200, 
 alpha05_nx064_nz05_fwhm225, alpha05_nx064_nz05_fwhm250, alpha05_nx064_nz05_fwhm275, 
 alpha05_nx064_nz05_fwhm300, alpha05_nx064_nz05_fwhm325, alpha05_nx064_nz05_fwhm350, 
 alpha05_nx064_nz05_fwhm375, alpha05_nx064_nz05_fwhm400, alpha05_nx064_nz05_fwhm425, 
 alpha05_nx064_nz05_fwhm450, alpha05_nx064_nz05_fwhm475, alpha05_nx064_nz05_fwhm500} ;

static float alpha10_nx064_nz05_fwhm000[32] = {
 1.88,1.89,1.89,1.90,1.90,1.90,1.91,1.91,1.91,1.92,
 1.93,1.93,1.94,1.97,2.09,2.39,2.59,2.70,2.82,2.88,
 2.92,2.96,2.99,3.25,3.45,3.77,3.91,4.27,4.76,4.99,
 5.91,6.82};
static float alpha10_nx064_nz05_fwhm025[32] = {
 1.88,1.89,1.89,1.90,1.90,1.90,1.91,1.91,1.91,1.92,
 1.93,1.93,1.94,1.97,2.09,2.39,2.59,2.70,2.82,2.88,
 2.92,2.96,2.99,3.25,3.45,3.77,3.91,4.27,4.76,4.99,
 5.91,6.82};
static float alpha10_nx064_nz05_fwhm050[32] = {
 1.88,1.89,1.89,1.90,1.90,1.90,1.91,1.91,1.92,1.92,
 1.93,1.94,1.95,1.98,2.17,2.45,2.63,2.73,2.84,2.89,
 2.93,2.97,3.10,3.36,3.52,3.81,3.94,4.40,4.82,5.18,
 5.99,6.94};
static float alpha10_nx064_nz05_fwhm075[32] = {
 1.88,1.89,1.89,1.90,1.90,1.91,1.91,1.92,1.93,1.94,
 1.95,1.96,1.98,2.23,2.46,2.63,2.75,2.82,2.89,2.95,
 3.00,3.32,3.54,3.67,3.77,3.95,4.36,4.80,5.26,5.79,
 6.80,7.86};
static float alpha10_nx064_nz05_fwhm100[32] = {
 1.88,1.89,1.90,1.91,1.92,1.92,1.94,1.96,1.98,2.05,
 2.23,2.37,2.46,2.65,2.76,2.84,2.90,2.95,3.22,3.55,
 3.73,3.85,3.94,4.04,4.35,4.82,5.23,5.81,6.51,7.21,
 8.66,10.28};
static float alpha10_nx064_nz05_fwhm125[32] = {
 1.89,1.91,1.93,1.95,1.97,1.99,2.31,2.51,2.63,2.71,
 2.77,2.82,2.85,2.93,3.00,3.37,3.65,3.80,4.00,4.48,
 4.79,4.97,5.33,5.62,5.83,6.61,7.30,8.24,9.44,10.64,
 13.03,15.75};
static float alpha10_nx064_nz05_fwhm150[32] = {
 1.96,2.05,2.27,2.47,2.63,2.74,2.88,2.96,3.07,3.34,
 3.52,3.65,3.74,3.94,4.27,4.66,4.93,5.35,5.94,6.61,
 7.09,7.68,8.12,8.64,9.01,10.47,11.75,13.47,15.74,17.92,
 22.54,27.41};
static float alpha10_nx064_nz05_fwhm175[32] = {
 2.58,2.76,2.88,2.99,3.35,3.59,3.88,4.18,4.47,4.70,
 4.89,5.08,5.37,5.91,6.45,6.95,7.69,8.26,9.38,10.44,
 11.38,12.24,13.09,14.00,14.83,17.18,19.50,22.49,26.38,30.25,
 38.31,47.10};
static float alpha10_nx064_nz05_fwhm200[32] = {
 3.11,3.53,3.80,4.11,4.52,4.81,5.41,5.89,6.35,6.71,
 7.04,7.42,7.74,8.57,9.32,10.24,11.25,12.20,13.92,15.57,
 17.02,18.35,19.76,21.07,22.39,26.22,29.79,34.66,40.48,46.04,
 58.44,72.59};
static float alpha10_nx064_nz05_fwhm225[32] = {
 3.90,4.38,4.74,5.14,5.77,6.26,7.02,7.75,8.34,8.79,
 9.25,9.75,10.19,11.41,12.51,13.78,15.24,16.64,19.07,21.27,
 23.38,25.28,27.25,29.30,31.22,36.63,41.48,48.04,56.08,64.40,
 81.37,99.23};
static float alpha10_nx064_nz05_fwhm250[32] = {
 4.43,4.96,5.56,6.20,6.94,7.60,8.56,9.36,10.13,10.85,
 11.54,12.14,12.69,14.28,15.67,17.36,19.25,21.09,24.43,27.52,
 30.35,32.97,35.55,37.94,40.51,47.29,53.63,61.88,72.37,83.04,
 104.00,126.75};
static float alpha10_nx064_nz05_fwhm275[32] = {
 4.81,5.52,6.24,7.04,7.90,8.63,9.83,10.93,11.83,12.73,
 13.56,14.37,15.07,17.04,18.81,21.09,23.49,25.87,30.22,33.91,
 37.53,41.01,44.20,47.20,50.11,58.16,66.41,77.04,89.57,102.14,
 126.67,153.87};
static float alpha10_nx064_nz05_fwhm300[32] = {
 5.02,5.95,6.81,7.73,8.69,9.49,10.98,12.27,13.52,14.57,
 15.57,16.42,17.39,19.97,22.23,24.96,28.36,31.22,36.28,40.94,
 45.16,48.99,52.81,56.61,60.23,70.55,79.71,91.84,107.03,121.12,
 150.96,182.04};
static float alpha10_nx064_nz05_fwhm325[32] = {
 5.02,6.16,7.15,8.24,9.28,10.33,11.93,13.59,14.96,16.41,
 17.62,18.82,19.85,23.10,25.94,29.29,33.02,36.51,42.59,47.94,
 53.28,57.78,62.30,66.84,70.86,82.24,93.35,107.82,124.18,140.90,
 174.12,209.57};
static float alpha10_nx064_nz05_fwhm350[32] = {
 5.02,6.16,7.26,8.48,9.73,10.85,12.88,14.81,16.57,18.12,
 19.66,21.06,22.46,26.25,29.52,33.59,37.81,41.73,49.28,55.40,
 60.91,66.61,71.84,76.95,81.59,94.64,107.71,122.78,141.84,161.00,
 198.45,238.25};
static float alpha10_nx064_nz05_fwhm375[32] = {
 5.02,6.16,7.26,8.59,10.02,11.24,13.68,16.04,18.02,19.87,
 21.74,23.42,25.04,29.25,33.17,37.59,42.77,47.57,55.68,62.92,
 69.46,75.74,81.64,86.89,92.53,107.07,121.06,138.38,159.74,181.35,
 223.70,267.23};
static float alpha10_nx064_nz05_fwhm400[32] = {
 5.02,6.16,7.26,8.59,10.02,11.55,14.49,17.02,19.28,21.51,
 23.73,25.84,27.49,32.37,36.73,42.02,47.67,53.11,62.19,70.37,
 77.72,84.73,90.91,96.85,102.97,119.15,134.33,154.00,177.90,200.83,
 248.07,296.00};
static float alpha10_nx064_nz05_fwhm425[32] = {
 5.02,6.16,7.26,8.59,10.02,11.60,14.85,17.77,20.67,23.18,
 25.64,27.80,29.77,35.53,40.34,46.29,52.50,58.17,68.20,77.50,
 85.90,93.19,100.58,107.43,113.54,130.97,147.77,169.39,195.85,221.14,
 271.94,322.40};
static float alpha10_nx064_nz05_fwhm450[32] = {
 5.02,6.16,7.26,8.59,10.02,11.60,15.27,18.58,21.66,24.50,
 27.04,29.61,32.08,38.26,43.69,50.39,57.11,63.41,74.72,84.29,
 93.59,102.03,109.68,116.79,123.32,142.57,160.38,184.25,213.12,240.54,
 295.68,348.44};
static float alpha10_nx064_nz05_fwhm475[32] = {
 5.02,6.16,7.26,8.59,10.02,11.60,15.27,19.13,22.60,25.68,
 28.45,31.20,33.71,41.17,47.39,54.67,62.05,68.61,80.61,90.79,
 101.00,109.55,118.06,125.30,132.29,154.07,174.17,199.69,230.89,259.50,
 318.00,373.67};
static float alpha10_nx064_nz05_fwhm500[32] = {
 5.02,6.16,7.26,8.59,10.02,11.60,15.27,19.52,23.12,26.50,
 29.70,32.81,35.51,43.29,50.07,57.87,65.97,73.27,86.06,97.11,
 107.74,117.22,125.83,134.24,142.59,165.61,187.22,214.91,247.00,278.11,
 339.57,397.17};
static float *alpha10_nx064_nz05[21] = {
 alpha10_nx064_nz05_fwhm000, alpha10_nx064_nz05_fwhm025, alpha10_nx064_nz05_fwhm050, 
 alpha10_nx064_nz05_fwhm075, alpha10_nx064_nz05_fwhm100, alpha10_nx064_nz05_fwhm125, 
 alpha10_nx064_nz05_fwhm150, alpha10_nx064_nz05_fwhm175, alpha10_nx064_nz05_fwhm200, 
 alpha10_nx064_nz05_fwhm225, alpha10_nx064_nz05_fwhm250, alpha10_nx064_nz05_fwhm275, 
 alpha10_nx064_nz05_fwhm300, alpha10_nx064_nz05_fwhm325, alpha10_nx064_nz05_fwhm350, 
 alpha10_nx064_nz05_fwhm375, alpha10_nx064_nz05_fwhm400, alpha10_nx064_nz05_fwhm425, 
 alpha10_nx064_nz05_fwhm450, alpha10_nx064_nz05_fwhm475, alpha10_nx064_nz05_fwhm500} ;

static float **nx064_nz05[3] = {
  alpha01_nx064_nz05 , alpha05_nx064_nz05 , alpha10_nx064_nz05 };

static float alpha01_nx064_nz06_fwhm000[32] = {
 1.99,1.99,1.99,1.99,1.99,1.99,2.00,2.12,2.43,2.59,
 2.70,2.76,2.80,2.88,2.92,2.95,2.98,2.99,3.34,3.67,
 3.82,3.89,3.95,3.98,4.12,4.75,4.95,5.58,5.92,6.62,
 7.74,8.89};
static float alpha01_nx064_nz06_fwhm025[32] = {
 1.99,1.99,1.99,1.99,1.99,1.99,2.00,2.12,2.43,2.59,
 2.70,2.76,2.80,2.88,2.92,2.95,2.98,2.99,3.34,3.67,
 3.82,3.89,3.95,3.98,4.12,4.75,4.95,5.58,5.92,6.62,
 7.74,8.89};
static float alpha01_nx064_nz06_fwhm050[32] = {
 1.99,1.99,1.99,1.99,1.99,1.99,2.00,2.24,2.49,2.64,
 2.73,2.78,2.82,2.89,2.93,2.96,2.98,3.00,3.45,3.72,
 3.85,3.92,3.96,4.00,4.33,4.82,4.99,5.66,5.98,6.75,
 7.87,9.14};
static float alpha01_nx064_nz06_fwhm075[32] = {
 1.99,1.99,1.99,1.99,2.00,2.00,2.33,2.58,2.71,2.78,
 2.84,2.87,2.89,2.94,2.96,2.98,3.06,3.46,3.75,3.89,
 3.96,4.07,4.44,4.66,4.80,4.99,5.66,5.98,6.83,7.47,
 8.91,10.43};
static float alpha01_nx064_nz06_fwhm100[32] = {
 1.99,2.00,2.00,2.20,2.48,2.62,2.78,2.85,2.90,2.93,
 2.95,2.96,2.97,3.00,3.35,3.66,3.84,3.92,4.11,4.58,
 4.80,4.94,5.18,5.52,5.72,6.21,6.86,7.66,8.62,9.58,
 11.67,13.79};
static float alpha01_nx064_nz06_fwhm125[32] = {
 2.48,2.64,2.77,2.85,2.91,2.95,2.98,3.06,3.35,3.57,
 3.69,3.77,3.84,3.98,4.22,4.62,4.83,4.96,5.62,6.00,
 6.58,6.84,7.13,7.61,7.87,8.92,9.84,10.98,12.85,14.62,
 17.78,21.45};
static float alpha01_nx064_nz06_fwhm150[32] = {
 2.96,3.12,3.37,3.63,3.81,3.92,4.14,4.49,4.71,4.85,
 4.93,5.08,5.31,5.79,6.23,6.78,7.28,7.72,8.53,9.43,
 10.02,10.78,11.46,12.35,12.92,14.90,16.68,19.19,22.30,25.18,
 31.29,39.00};
static float alpha01_nx064_nz06_fwhm175[32] = {
 4.32,4.67,4.82,5.07,5.52,5.77,6.25,6.72,7.00,7.52,
 7.89,8.14,8.38,9.12,9.88,10.64,11.65,12.46,13.97,15.69,
 17.02,18.45,19.56,20.74,22.07,25.32,28.89,32.94,38.45,44.85,
 57.40,71.38};
static float alpha01_nx064_nz06_fwhm200[32] = {
 6.11,6.70,7.02,7.66,8.05,8.57,9.45,10.00,10.61,11.14,
 11.72,12.13,12.53,13.80,15.09,16.48,17.87,19.32,21.77,24.29,
 26.41,28.59,30.75,32.91,35.11,40.52,46.14,52.67,62.17,71.57,
 90.27,111.71};
static float alpha01_nx064_nz06_fwhm225[32] = {
 8.38,9.02,9.62,10.34,10.99,11.74,12.78,13.78,14.72,15.52,
 16.33,16.91,17.61,19.42,21.13,23.06,25.42,27.28,31.17,34.88,
 38.06,41.18,44.06,47.20,49.20,56.73,65.12,75.00,86.75,99.67,
 124.50,157.00};
static float alpha01_nx064_nz06_fwhm250[32] = {
 10.39,11.34,12.34,13.18,13.95,14.88,16.39,17.96,18.97,19.97,
 21.25,22.05,22.82,25.64,27.93,30.61,33.58,36.31,40.94,46.58,
 51.28,54.17,57.92,61.58,65.10,74.50,84.90,97.67,114.40,128.70,
 165.14,204.50};
static float alpha01_nx064_nz06_fwhm275[32] = {
 12.63,13.73,15.03,16.21,17.28,18.09,20.37,22.06,24.00,25.31,
 26.29,27.46,29.09,32.20,35.00,38.00,42.29,45.22,52.38,57.44,
 61.80,67.50,72.00,76.67,81.62,95.25,107.57,122.40,142.71,161.50,
 205.80,255.50};
static float alpha01_nx064_nz06_fwhm300[32] = {
 14.88,16.30,17.37,18.83,21.21,22.40,24.31,26.31,28.15,29.80,
 31.38,32.93,34.44,38.14,41.75,45.80,50.78,55.23,63.08,69.71,
 76.78,83.00,89.17,95.25,99.43,114.67,130.60,148.17,170.60,196.00,
 250.50,303.40};
static float alpha01_nx064_nz06_fwhm325[32] = {
 17.21,18.65,20.07,22.00,23.82,25.44,28.53,30.60,33.00,34.85,
 36.50,38.30,40.45,45.56,50.10,55.50,60.70,65.85,75.33,83.67,
 91.62,98.43,105.11,112.33,119.33,136.60,152.00,174.50,206.00,234.25,
 291.67,348.33};
static float alpha01_nx064_nz06_fwhm350[32] = {
 19.12,21.27,22.88,24.94,26.82,29.11,32.27,35.40,37.80,40.14,
 43.57,45.75,48.00,53.18,58.50,63.89,70.75,76.57,89.00,97.50,
 106.60,115.14,123.33,131.00,137.89,157.14,178.60,210.50,239.00,268.60,
 334.00,406.33};
static float alpha01_nx064_nz06_fwhm375[32] = {
 21.00,23.43,25.33,27.62,29.90,32.21,36.00,40.62,44.31,46.89,
 49.92,52.11,54.50,61.00,66.90,73.75,81.75,89.78,101.25,111.60,
 123.67,132.50,140.50,148.67,158.00,182.50,210.00,236.33,270.57,310.00,
 382.00,468.00};
static float alpha01_nx064_nz06_fwhm400[32] = {
 23.54,25.94,28.27,30.57,33.44,36.38,41.33,45.64,49.89,52.89,
 55.40,58.90,62.00,69.62,76.80,85.10,94.00,101.55,114.50,129.00,
 138.67,150.00,159.33,169.75,179.50,206.67,233.75,265.00,310.33,348.00,
 430.50,520.00};
static float alpha01_nx064_nz06_fwhm425[32] = {
 25.43,28.38,31.00,33.45,37.25,40.10,46.27,51.27,56.00,59.14,
 63.75,67.25,70.00,78.83,86.57,96.29,105.00,114.83,130.00,142.50,
 154.00,166.75,179.67,192.00,203.50,234.67,260.75,300.00,347.50,389.00,
 483.00,568.00};
static float alpha01_nx064_nz06_fwhm450[32] = {
 26.62,30.45,33.55,37.20,41.17,45.20,51.80,57.67,61.71,66.50,
 70.83,74.75,78.00,88.56,97.43,107.75,118.40,128.00,143.67,156.67,
 171.17,187.50,201.00,214.00,227.50,259.00,291.33,334.00,383.50,431.00,
 527.00,616.67};
static float alpha01_nx064_nz06_fwhm475[32] = {
 28.57,32.50,36.44,40.89,45.56,50.33,57.14,61.91,68.50,73.75,
 78.33,83.20,87.20,98.33,106.75,119.00,130.00,139.00,155.67,174.00,
 191.00,207.67,223.00,237.17,247.00,287.67,320.00,364.50,417.00,472.00,
 572.00,669.50};
static float alpha01_nx064_nz06_fwhm500[32] = {
 30.00,35.22,39.86,44.27,49.62,54.50,60.43,68.67,76.17,81.17,
 86.00,91.00,96.00,106.75,116.75,129.00,141.67,152.00,172.00,191.67,
 212.33,228.00,240.20,257.00,272.00,313.00,349.00,399.00,453.33,511.00,
 613.33,726.00};
static float *alpha01_nx064_nz06[21] = {
 alpha01_nx064_nz06_fwhm000, alpha01_nx064_nz06_fwhm025, alpha01_nx064_nz06_fwhm050, 
 alpha01_nx064_nz06_fwhm075, alpha01_nx064_nz06_fwhm100, alpha01_nx064_nz06_fwhm125, 
 alpha01_nx064_nz06_fwhm150, alpha01_nx064_nz06_fwhm175, alpha01_nx064_nz06_fwhm200, 
 alpha01_nx064_nz06_fwhm225, alpha01_nx064_nz06_fwhm250, alpha01_nx064_nz06_fwhm275, 
 alpha01_nx064_nz06_fwhm300, alpha01_nx064_nz06_fwhm325, alpha01_nx064_nz06_fwhm350, 
 alpha01_nx064_nz06_fwhm375, alpha01_nx064_nz06_fwhm400, alpha01_nx064_nz06_fwhm425, 
 alpha01_nx064_nz06_fwhm450, alpha01_nx064_nz06_fwhm475, alpha01_nx064_nz06_fwhm500} ;

static float alpha05_nx064_nz06_fwhm000[32] = {
 1.94,1.95,1.95,1.95,1.95,1.95,1.96,1.96,1.97,1.97,
 1.98,1.99,2.00,2.40,2.57,2.73,2.83,2.88,2.94,2.97,
 3.00,3.37,3.58,3.72,3.80,3.95,4.35,4.79,5.03,5.70,
 6.65,7.62};
static float alpha05_nx064_nz06_fwhm025[32] = {
 1.94,1.95,1.95,1.95,1.95,1.95,1.96,1.96,1.97,1.97,
 1.98,1.99,2.00,2.40,2.57,2.73,2.83,2.88,2.94,2.97,
 3.00,3.37,3.58,3.72,3.80,3.95,4.35,4.79,5.03,5.70,
 6.65,7.62};
static float alpha05_nx064_nz06_fwhm050[32] = {
 1.94,1.95,1.95,1.95,1.95,1.95,1.96,1.96,1.97,1.98,
 1.99,1.99,2.10,2.45,2.62,2.76,2.84,2.89,2.94,2.98,
 3.15,3.47,3.64,3.76,3.84,3.98,4.48,4.84,5.25,5.80,
 6.79,7.81};
static float alpha05_nx064_nz06_fwhm075[32] = {
 1.94,1.95,1.95,1.95,1.96,1.96,1.96,1.97,1.98,2.00,
 2.17,2.34,2.43,2.65,2.76,2.85,2.90,2.94,2.98,3.30,
 3.59,3.75,3.85,3.91,3.96,4.51,4.83,5.20,5.82,6.38,
 7.57,8.80};
static float alpha05_nx064_nz06_fwhm100[32] = {
 1.95,1.95,1.96,1.96,1.97,1.98,1.99,2.23,2.45,2.59,
 2.67,2.74,2.78,2.86,2.91,2.96,3.00,3.35,3.70,3.87,
 3.95,4.18,4.51,4.70,4.83,5.31,5.82,6.49,7.22,7.95,
 9.71,11.45};
static float alpha05_nx064_nz06_fwhm125[32] = {
 1.96,1.97,1.99,2.10,2.38,2.54,2.72,2.81,2.87,2.91,
 2.94,2.96,2.98,3.36,3.62,3.80,3.93,4.10,4.68,4.93,
 5.36,5.69,5.91,6.28,6.61,7.42,8.11,9.24,10.65,11.92,
 14.73,17.81};
static float alpha05_nx064_nz06_fwhm150[32] = {
 2.45,2.64,2.75,2.85,2.92,2.97,3.27,3.55,3.73,3.85,
 3.94,4.02,4.22,4.65,4.90,5.31,5.79,6.09,6.85,7.54,
 8.07,8.72,9.29,9.83,10.35,11.81,13.34,15.47,17.87,20.68,
 26.31,32.33};
static float alpha05_nx064_nz06_fwhm175[32] = {
 2.98,3.30,3.58,3.81,3.98,4.28,4.70,4.98,5.37,5.66,
 5.91,6.17,6.46,6.98,7.66,8.35,9.04,9.74,10.93,12.06,
 13.26,14.32,15.36,16.38,17.34,20.04,22.98,26.51,30.98,35.29,
 45.60,57.38};
static float alpha05_nx064_nz06_fwhm200[32] = {
 4.15,4.63,4.89,5.35,5.83,6.25,6.90,7.47,7.89,8.32,
 8.75,9.11,9.50,10.51,11.42,12.52,13.61,14.75,16.82,18.67,
 20.45,22.16,23.78,25.24,26.74,31.07,35.26,40.95,48.49,55.66,
 71.50,88.77};
static float alpha05_nx064_nz06_fwhm225[32] = {
 5.54,6.10,6.66,7.25,7.88,8.40,9.31,10.15,10.85,11.50,
 11.96,12.54,13.11,14.50,15.72,17.18,18.90,20.54,23.36,25.94,
 28.55,30.67,32.92,35.13,37.16,43.44,49.87,57.79,67.95,78.22,
 99.30,123.10};
static float alpha05_nx064_nz06_fwhm250[32] = {
 6.89,7.73,8.39,9.05,9.95,10.58,11.76,12.71,13.59,14.47,
 15.05,15.82,16.57,18.47,20.00,22.00,24.48,26.37,30.03,33.55,
 36.87,40.20,43.08,45.76,48.68,57.18,65.60,76.00,88.92,101.89,
 127.95,157.00};
static float alpha05_nx064_nz06_fwhm275[32] = {
 8.08,9.02,9.87,10.74,11.57,12.45,13.90,15.18,16.28,17.30,
 18.25,19.11,20.01,22.43,24.40,27.13,29.84,32.49,37.23,41.89,
 46.12,50.22,53.88,57.82,61.38,72.06,81.57,94.40,109.89,124.95,
 157.21,192.71};
static float alpha05_nx064_nz06_fwhm300[32] = {
 9.02,10.11,10.97,12.04,13.07,14.13,16.00,17.51,18.97,20.03,
 21.31,22.42,23.52,26.30,29.03,32.30,35.74,38.98,45.52,50.93,
 55.96,61.05,65.73,70.19,74.47,86.69,97.69,113.27,130.91,150.63,
 189.60,231.22};
static float alpha05_nx064_nz06_fwhm325[32] = {
 9.75,11.01,12.14,13.25,14.70,15.77,18.09,19.73,21.39,22.99,
 24.42,25.71,27.16,30.69,34.00,37.46,42.05,46.18,53.89,60.09,
 66.08,71.71,76.94,82.41,86.92,100.81,114.35,132.38,155.55,177.17,
 221.60,268.82};
static float alpha05_nx064_nz06_fwhm350[32] = {
 10.50,11.84,12.90,14.38,15.90,17.55,19.88,22.08,24.15,25.89,
 27.78,29.42,30.95,35.25,38.73,43.18,48.69,53.64,61.88,68.69,
 76.07,82.68,88.50,94.43,100.76,116.79,132.70,153.29,178.79,203.95,
 255.50,309.29};
static float alpha05_nx064_nz06_fwhm375[32] = {
 11.01,12.44,13.77,15.52,17.23,19.19,21.90,24.49,27.00,29.02,
 30.79,32.86,34.66,39.61,44.05,49.28,54.94,60.43,70.04,78.75,
 86.68,93.95,101.18,108.24,115.12,134.16,150.80,174.16,202.64,232.07,
 289.89,346.80};
static float alpha05_nx064_nz06_fwhm400[32] = {
 11.21,12.95,14.65,16.60,18.57,20.42,23.79,26.65,29.30,31.65,
 34.24,36.36,38.50,44.13,48.97,54.84,61.56,67.73,78.88,88.67,
 97.89,106.90,114.69,122.18,129.28,150.47,169.78,196.43,227.91,259.57,
 324.00,389.00};
static float alpha05_nx064_nz06_fwhm425[32] = {
 11.40,13.55,15.13,17.39,19.76,21.68,25.76,28.84,31.73,34.59,
 37.32,39.76,42.38,48.39,54.54,60.86,68.79,75.72,88.17,99.33,
 109.50,119.48,127.60,135.93,144.29,166.75,189.46,218.00,253.82,288.80,
 357.60,431.17};
static float alpha05_nx064_nz06_fwhm450[32] = {
 11.44,13.77,15.56,18.18,20.76,23.34,27.24,30.95,34.47,37.67,
 40.61,43.41,45.97,53.67,60.07,67.53,75.87,83.72,97.74,109.25,
 120.50,130.84,141.00,150.47,159.00,184.35,209.25,240.57,279.33,316.83,
 389.00,469.50};
static float alpha05_nx064_nz06_fwhm475[32] = {
 11.44,13.77,15.81,18.68,21.52,23.91,28.59,32.76,36.71,40.25,
 43.77,46.94,50.04,57.85,65.23,73.86,84.00,92.73,107.24,120.36,
 132.62,143.33,154.50,163.73,172.73,202.30,229.08,263.90,303.89,346.33,
 427.17,504.60};
static float alpha05_nx064_nz06_fwhm500[32] = {
 11.44,13.77,15.83,18.88,22.03,24.97,30.07,35.04,39.25,43.74,
 47.31,50.88,54.00,62.46,70.72,80.65,91.00,100.44,117.00,130.92,
 143.79,155.50,166.50,178.14,189.00,219.25,250.15,286.73,331.25,373.75,
 459.00,542.40};
static float *alpha05_nx064_nz06[21] = {
 alpha05_nx064_nz06_fwhm000, alpha05_nx064_nz06_fwhm025, alpha05_nx064_nz06_fwhm050, 
 alpha05_nx064_nz06_fwhm075, alpha05_nx064_nz06_fwhm100, alpha05_nx064_nz06_fwhm125, 
 alpha05_nx064_nz06_fwhm150, alpha05_nx064_nz06_fwhm175, alpha05_nx064_nz06_fwhm200, 
 alpha05_nx064_nz06_fwhm225, alpha05_nx064_nz06_fwhm250, alpha05_nx064_nz06_fwhm275, 
 alpha05_nx064_nz06_fwhm300, alpha05_nx064_nz06_fwhm325, alpha05_nx064_nz06_fwhm350, 
 alpha05_nx064_nz06_fwhm375, alpha05_nx064_nz06_fwhm400, alpha05_nx064_nz06_fwhm425, 
 alpha05_nx064_nz06_fwhm450, alpha05_nx064_nz06_fwhm475, alpha05_nx064_nz06_fwhm500} ;

static float alpha10_nx064_nz06_fwhm000[32] = {
 1.88,1.89,1.90,1.90,1.90,1.90,1.91,1.91,1.92,1.92,
 1.93,1.94,1.95,1.98,2.14,2.45,2.64,2.74,2.84,2.90,
 2.94,2.97,3.12,3.39,3.55,3.82,3.95,4.43,4.83,5.20,
 6.00,6.94};
static float alpha10_nx064_nz06_fwhm025[32] = {
 1.88,1.89,1.90,1.90,1.90,1.90,1.91,1.91,1.92,1.92,
 1.93,1.94,1.95,1.98,2.14,2.45,2.64,2.74,2.84,2.90,
 2.94,2.97,3.12,3.39,3.55,3.82,3.95,4.43,4.83,5.20,
 6.00,6.94};
static float alpha10_nx064_nz06_fwhm050[32] = {
 1.88,1.89,1.90,1.90,1.90,1.90,1.91,1.91,1.92,1.93,
 1.93,1.94,1.95,1.99,2.23,2.50,2.67,2.76,2.86,2.91,
 2.95,2.99,3.24,3.47,3.62,3.85,3.98,4.54,4.88,5.37,
 6.24,7.14};
static float alpha10_nx064_nz06_fwhm075[32] = {
 1.88,1.89,1.90,1.90,1.90,1.91,1.91,1.92,1.93,1.94,
 1.96,1.97,1.99,2.28,2.52,2.68,2.78,2.84,2.91,2.96,
 3.13,3.44,3.62,3.74,3.82,3.99,4.50,4.86,5.41,5.87,
 6.91,7.99};
static float alpha10_nx064_nz06_fwhm100[32] = {
 1.89,1.90,1.90,1.91,1.92,1.92,1.94,1.96,1.99,2.16,
 2.33,2.45,2.54,2.70,2.79,2.86,2.92,2.97,3.32,3.63,
 3.79,3.89,3.98,4.24,4.48,4.88,5.36,5.90,6.68,7.39,
 8.88,10.53};
static float alpha10_nx064_nz06_fwhm125[32] = {
 1.90,1.92,1.93,1.95,1.98,2.04,2.40,2.56,2.67,2.75,
 2.80,2.84,2.88,2.95,3.10,3.45,3.70,3.84,4.15,4.60,
 4.85,5.04,5.46,5.75,5.93,6.75,7.46,8.43,9.65,10.84,
 13.41,16.13};
static float alpha10_nx064_nz06_fwhm150[32] = {
 1.98,2.18,2.39,2.57,2.70,2.79,2.90,2.98,3.21,3.44,
 3.60,3.71,3.80,3.99,4.41,4.75,5.03,5.52,6.05,6.72,
 7.24,7.81,8.34,8.82,9.28,10.68,11.99,13.82,16.03,18.45,
 23.50,28.96};
static float alpha10_nx064_nz06_fwhm175[32] = {
 2.69,2.83,2.94,3.18,3.50,3.69,3.97,4.37,4.67,4.86,
 5.05,5.35,5.59,6.09,6.67,7.30,7.94,8.62,9.72,10.76,
 11.71,12.66,13.51,14.38,15.24,17.72,20.16,23.61,27.40,31.53,
 40.45,50.44};
static float alpha10_nx064_nz06_fwhm200[32] = {
 3.37,3.77,4.02,4.47,4.83,5.08,5.79,6.29,6.74,7.10,
 7.51,7.85,8.19,9.03,9.84,10.83,11.91,12.85,14.60,16.29,
 17.78,19.31,20.73,22.18,23.50,27.21,30.97,35.83,42.40,49.23,
 62.90,77.59};
static float alpha10_nx064_nz06_fwhm225[32] = {
 4.35,4.83,5.30,5.79,6.41,6.86,7.74,8.46,9.01,9.62,
 10.13,10.63,11.07,12.34,13.43,14.77,16.28,17.65,20.11,22.47,
 24.53,26.73,28.62,30.49,32.30,37.79,42.95,50.38,59.35,68.63,
 88.20,107.93};
static float alpha10_nx064_nz06_fwhm250[32] = {
 5.16,5.90,6.54,7.14,7.89,8.55,9.54,10.45,11.29,12.00,
 12.67,13.30,13.93,15.57,16.96,18.74,20.76,22.51,25.75,28.84,
 31.59,34.31,36.87,39.56,42.06,49.29,56.55,66.19,77.74,89.13,
 112.41,138.38};
static float alpha10_nx064_nz06_fwhm275[32] = {
 5.94,6.85,7.58,8.34,9.08,9.85,11.14,12.36,13.34,14.18,
 15.04,15.80,16.56,18.59,20.43,22.52,25.08,27.38,31.60,35.44,
 38.94,42.52,45.93,49.33,52.85,61.68,70.53,81.82,95.12,109.22,
 138.46,169.86};
static float alpha10_nx064_nz06_fwhm300[32] = {
 6.50,7.46,8.29,9.17,10.25,11.05,12.63,13.92,15.14,16.31,
 17.29,18.26,19.10,21.56,23.85,26.68,29.69,32.50,37.78,42.42,
 46.96,51.46,55.53,59.51,63.00,73.98,84.12,97.40,114.44,130.95,
 164.49,200.14};
static float alpha10_nx064_nz06_fwhm325[32] = {
 6.79,7.94,8.85,9.87,11.04,12.16,13.96,15.56,16.83,18.31,
 19.53,20.58,21.63,24.82,27.43,30.66,34.26,37.72,44.01,49.54,
 55.17,59.89,64.72,69.30,73.81,86.61,98.35,114.03,133.43,152.03,
 190.74,232.90};
static float alpha10_nx064_nz06_fwhm350[32] = {
 6.83,8.08,9.21,10.46,11.93,13.05,15.26,17.01,18.72,20.20,
 21.66,22.94,24.30,27.65,30.80,34.74,38.93,43.06,50.36,56.92,
 63.27,69.14,74.84,80.10,85.24,99.50,113.68,131.10,152.12,173.82,
 218.12,265.18};
static float alpha10_nx064_nz06_fwhm375[32] = {
 6.83,8.18,9.35,10.80,12.49,13.80,16.29,18.29,20.17,22.07,
 23.61,25.13,26.66,30.66,34.35,38.59,43.82,48.56,57.06,65.04,
 72.24,78.72,84.81,91.00,96.43,112.98,128.67,148.23,172.50,196.18,
 246.50,297.56};
static float alpha10_nx064_nz06_fwhm400[32] = {
 6.83,8.18,9.44,10.96,12.77,14.31,17.02,19.42,21.57,23.58,
 25.51,27.29,28.89,33.66,37.90,43.00,49.25,54.46,64.29,72.91,
 80.84,87.97,94.77,101.71,108.66,126.90,144.24,166.96,193.25,220.72,
 275.05,332.00};
static float alpha10_nx064_nz06_fwhm425[32] = {
 6.83,8.18,9.44,11.02,12.96,14.69,17.72,20.44,22.91,25.26,
 27.20,29.26,31.11,36.74,41.93,47.80,54.16,59.98,71.09,80.77,
 89.48,97.43,105.33,112.92,120.37,140.56,160.52,184.75,214.69,244.83,
 302.80,365.86};
static float alpha10_nx064_nz06_fwhm450[32] = {
 6.83,8.18,9.44,11.02,12.96,14.78,18.13,21.14,23.86,26.56,
 28.98,31.40,33.45,39.77,45.37,51.80,58.64,65.24,77.53,88.26,
 97.89,106.74,116.29,124.36,132.65,156.39,176.82,203.08,235.69,267.60,
 331.92,399.33};
static float alpha10_nx064_nz06_fwhm475[32] = {
 6.83,8.18,9.44,11.02,12.96,14.78,18.40,21.72,24.70,27.67,
 30.42,32.83,35.69,42.50,48.47,55.44,63.58,70.89,84.32,96.36,
 106.95,116.91,127.08,136.94,146.46,170.30,192.88,221.91,256.65,290.38,
 361.07,432.33};
static float alpha10_nx064_nz06_fwhm500[32] = {
 6.83,8.18,9.44,11.02,12.96,14.78,18.49,22.20,25.65,28.89,
 31.98,34.55,37.47,44.90,51.11,58.88,68.05,77.09,91.65,103.94,
 116.19,127.95,138.88,149.25,158.91,184.58,208.67,240.38,277.62,314.44,
 388.46,466.25};
static float *alpha10_nx064_nz06[21] = {
 alpha10_nx064_nz06_fwhm000, alpha10_nx064_nz06_fwhm025, alpha10_nx064_nz06_fwhm050, 
 alpha10_nx064_nz06_fwhm075, alpha10_nx064_nz06_fwhm100, alpha10_nx064_nz06_fwhm125, 
 alpha10_nx064_nz06_fwhm150, alpha10_nx064_nz06_fwhm175, alpha10_nx064_nz06_fwhm200, 
 alpha10_nx064_nz06_fwhm225, alpha10_nx064_nz06_fwhm250, alpha10_nx064_nz06_fwhm275, 
 alpha10_nx064_nz06_fwhm300, alpha10_nx064_nz06_fwhm325, alpha10_nx064_nz06_fwhm350, 
 alpha10_nx064_nz06_fwhm375, alpha10_nx064_nz06_fwhm400, alpha10_nx064_nz06_fwhm425, 
 alpha10_nx064_nz06_fwhm450, alpha10_nx064_nz06_fwhm475, alpha10_nx064_nz06_fwhm500} ;

static float **nx064_nz06[3] = {
  alpha01_nx064_nz06 , alpha05_nx064_nz06 , alpha10_nx064_nz06 };

static float alpha01_nx064_nz07_fwhm000[32] = {
 1.99,1.99,1.99,1.99,1.99,2.00,2.06,2.38,2.57,2.67,
 2.75,2.80,2.84,2.91,2.94,2.97,2.98,2.99,3.44,3.73,
 3.85,3.93,3.97,4.00,4.35,4.81,4.97,5.58,5.99,6.74,
 7.88,9.00};
static float alpha01_nx064_nz07_fwhm025[32] = {
 1.99,1.99,1.99,1.99,1.99,2.00,2.06,2.38,2.57,2.67,
 2.75,2.80,2.84,2.91,2.94,2.97,2.98,2.99,3.44,3.73,
 3.85,3.93,3.97,4.00,4.35,4.81,4.97,5.58,5.99,6.74,
 7.88,9.00};
static float alpha01_nx064_nz07_fwhm050[32] = {
 1.99,1.99,1.99,1.99,1.99,2.00,2.16,2.46,2.62,2.72,
 2.78,2.82,2.86,2.92,2.95,2.97,2.99,3.00,3.54,3.78,
 3.88,3.94,3.98,4.21,4.48,4.86,5.05,5.72,6.19,6.86,
 7.99,9.32};
static float alpha01_nx064_nz07_fwhm075[32] = {
 1.99,1.99,1.99,2.00,2.00,2.23,2.54,2.68,2.78,2.83,
 2.87,2.89,2.92,2.96,2.98,2.99,3.11,3.53,3.81,3.92,
 3.97,4.26,4.55,4.73,4.85,5.24,5.74,6.11,6.91,7.71,
 9.00,10.61};
static float alpha01_nx064_nz07_fwhm100[32] = {
 2.00,2.00,2.18,2.46,2.63,2.72,2.84,2.89,2.92,2.95,
 2.96,2.97,2.98,3.14,3.51,3.71,3.85,3.93,4.22,4.70,
 4.87,5.05,5.41,5.62,5.83,6.39,6.92,7.80,8.86,9.80,
 11.89,13.98};
static float alpha01_nx064_nz07_fwhm125[32] = {
 2.62,2.75,2.83,2.88,2.92,2.95,2.98,3.04,3.42,3.61,
 3.72,3.79,3.85,3.98,4.29,4.65,4.89,5.10,5.76,6.02,
 6.57,6.90,7.35,7.75,8.19,9.26,10.10,11.62,13.36,14.84,
 18.50,22.96};
static float alpha01_nx064_nz07_fwhm150[32] = {
 2.97,3.01,3.43,3.66,3.81,3.89,4.16,4.57,4.78,4.93,
 5.07,5.35,5.53,5.90,6.34,6.82,7.48,7.93,8.85,9.66,
 10.22,11.10,11.77,12.57,12.99,14.96,17.05,19.84,22.93,26.39,
 33.74,42.22};
static float alpha01_nx064_nz07_fwhm175[32] = {
 4.48,4.77,4.95,5.34,5.74,5.98,6.59,6.98,7.44,7.79,
 7.98,8.47,8.72,9.47,10.03,10.86,11.75,12.58,14.27,15.96,
 17.48,18.84,20.07,21.24,22.58,26.37,29.60,34.32,40.69,47.27,
 59.57,74.22};
static float alpha01_nx064_nz07_fwhm200[32] = {
 6.63,7.07,7.61,7.97,8.46,8.87,9.67,10.27,10.95,11.62,
 12.12,12.56,12.96,14.29,15.42,16.95,18.55,19.85,22.71,25.04,
 27.39,29.35,31.44,33.50,35.17,41.00,46.89,54.79,63.50,73.33,
 93.88,120.14};
static float alpha01_nx064_nz07_fwhm225[32] = {
 8.94,9.58,10.14,10.95,11.66,12.49,13.49,14.43,15.33,16.41,
 17.11,17.81,18.57,20.08,21.79,23.66,25.89,27.97,32.24,35.28,
 38.67,41.94,44.68,47.50,49.95,58.75,66.71,77.00,91.50,104.00,
 138.40,172.44};
static float alpha01_nx064_nz07_fwhm250[32] = {
 11.36,12.22,12.98,13.85,14.84,15.84,17.58,19.09,20.10,21.05,
 22.11,22.90,24.00,26.83,29.08,31.36,34.35,37.28,41.79,47.00,
 51.08,55.00,58.50,62.11,65.68,77.42,88.83,102.44,120.90,141.22,
 181.00,223.40};
static float alpha01_nx064_nz07_fwhm275[32] = {
 13.44,14.59,15.73,17.11,18.44,19.68,21.50,23.12,25.00,26.73,
 28.36,29.35,30.46,33.00,35.82,38.67,42.47,45.88,52.27,58.00,
 63.75,70.07,74.82,79.33,84.69,98.86,111.78,131.25,155.20,177.75,
 229.25,283.00};
static float alpha01_nx064_nz07_fwhm300[32] = {
 15.77,17.50,18.69,20.33,22.00,23.13,25.65,27.79,29.77,31.43,
 32.69,34.24,35.92,39.29,42.73,46.50,51.46,56.14,63.38,71.57,
 79.00,85.75,91.67,97.20,103.00,122.50,140.00,159.67,186.25,217.00,
 276.50,345.00};
static float alpha01_nx064_nz07_fwhm325[32] = {
 18.50,20.14,21.25,22.77,24.63,26.29,29.57,32.32,34.10,36.39,
 38.21,39.89,41.38,46.36,50.59,55.36,61.00,66.73,75.33,84.67,
 93.88,102.00,109.60,117.33,124.25,144.33,164.50,189.50,222.33,255.50,
 329.00,395.80};
static float alpha01_nx064_nz07_fwhm350[32] = {
 20.12,22.00,24.05,25.79,28.20,30.00,33.79,36.29,39.08,41.44,
 44.00,46.36,48.55,53.17,58.70,64.40,70.92,76.17,88.82,100.67,
 110.29,118.33,126.00,136.67,144.00,168.14,193.25,223.00,261.00,301.33,
 374.00,445.25};
static float alpha01_nx064_nz07_fwhm375[32] = {
 22.23,24.70,26.11,28.80,31.83,33.58,37.82,41.38,44.64,47.17,
 49.75,52.17,54.62,60.64,66.33,73.36,82.00,89.29,102.80,114.33,
 126.00,137.00,148.00,156.90,166.75,196.00,223.33,257.33,301.60,343.00,
 420.00,502.67};
static float alpha01_nx064_nz07_fwhm400[32] = {
 24.64,27.18,29.46,32.46,35.09,38.00,43.00,45.91,49.50,52.67,
 55.62,58.50,61.55,69.14,75.67,83.75,93.20,101.44,117.25,131.83,
 145.57,158.50,171.00,181.50,192.50,222.33,253.29,292.00,337.00,381.00,
 469.00,570.50};
static float alpha01_nx064_nz07_fwhm425[32] = {
 26.77,29.93,32.50,35.67,39.21,42.14,46.50,51.00,55.50,59.50,
 62.56,65.50,68.60,77.33,85.88,95.38,105.50,115.00,133.00,149.00,
 164.25,180.00,191.33,203.00,213.67,248.00,285.00,327.50,373.50,422.00,
 524.00,627.50};
static float alpha01_nx064_nz07_fwhm450[32] = {
 29.00,32.80,35.30,38.67,42.50,45.67,51.33,55.80,61.50,65.00,
 68.82,73.00,77.29,86.00,95.67,107.00,118.33,128.71,149.60,168.75,
 183.75,198.75,214.50,225.67,238.00,278.33,314.50,361.40,409.50,467.00,
 572.50,688.00};
static float alpha01_nx064_nz07_fwhm475[32] = {
 31.43,34.78,37.56,41.44,45.40,49.20,55.80,61.50,67.40,71.80,
 76.86,81.71,85.78,96.80,107.33,118.50,133.00,145.50,167.00,187.00,
 206.00,220.67,236.50,250.00,268.00,304.00,346.00,395.00,450.00,511.00,
 622.50,744.00};
static float alpha01_nx064_nz07_fwhm500[32] = {
 32.56,36.50,40.12,44.36,48.75,53.00,60.80,67.75,74.00,80.00,
 84.50,89.67,94.20,106.50,117.83,132.25,146.75,160.60,185.50,204.50,
 226.00,244.33,260.00,277.00,287.60,334.25,374.00,430.00,488.33,551.00,
 672.00,801.00};
static float *alpha01_nx064_nz07[21] = {
 alpha01_nx064_nz07_fwhm000, alpha01_nx064_nz07_fwhm025, alpha01_nx064_nz07_fwhm050, 
 alpha01_nx064_nz07_fwhm075, alpha01_nx064_nz07_fwhm100, alpha01_nx064_nz07_fwhm125, 
 alpha01_nx064_nz07_fwhm150, alpha01_nx064_nz07_fwhm175, alpha01_nx064_nz07_fwhm200, 
 alpha01_nx064_nz07_fwhm225, alpha01_nx064_nz07_fwhm250, alpha01_nx064_nz07_fwhm275, 
 alpha01_nx064_nz07_fwhm300, alpha01_nx064_nz07_fwhm325, alpha01_nx064_nz07_fwhm350, 
 alpha01_nx064_nz07_fwhm375, alpha01_nx064_nz07_fwhm400, alpha01_nx064_nz07_fwhm425, 
 alpha01_nx064_nz07_fwhm450, alpha01_nx064_nz07_fwhm475, alpha01_nx064_nz07_fwhm500} ;

static float alpha05_nx064_nz07_fwhm000[32] = {
 1.95,1.95,1.95,1.95,1.95,1.96,1.96,1.97,1.97,1.98,
 1.99,2.00,2.17,2.50,2.67,2.78,2.85,2.90,2.95,2.98,
 3.14,3.46,3.65,3.76,3.84,3.97,4.44,4.83,5.27,5.79,
 6.78,7.78};
static float alpha05_nx064_nz07_fwhm025[32] = {
 1.95,1.95,1.95,1.95,1.95,1.96,1.96,1.97,1.97,1.98,
 1.99,2.00,2.17,2.50,2.67,2.78,2.85,2.90,2.95,2.98,
 3.14,3.46,3.65,3.76,3.84,3.97,4.44,4.83,5.27,5.79,
 6.78,7.78};
static float alpha05_nx064_nz07_fwhm050[32] = {
 1.95,1.95,1.95,1.95,1.95,1.96,1.96,1.97,1.98,1.98,
 1.99,2.09,2.27,2.56,2.70,2.80,2.87,2.91,2.95,2.99,
 3.27,3.55,3.70,3.80,3.87,3.99,4.56,4.89,5.43,5.88,
 6.88,7.94};
static float alpha05_nx064_nz07_fwhm075[32] = {
 1.95,1.95,1.95,1.96,1.96,1.96,1.97,1.98,1.99,2.14,
 2.30,2.43,2.55,2.72,2.81,2.87,2.92,2.95,2.99,3.40,
 3.64,3.79,3.88,3.94,3.98,4.59,4.89,5.39,5.91,6.56,
 7.74,8.95};
static float alpha05_nx064_nz07_fwhm100[32] = {
 1.95,1.96,1.96,1.97,1.98,1.98,2.15,2.40,2.56,2.66,
 2.73,2.78,2.81,2.89,2.93,2.97,3.03,3.42,3.76,3.90,
 3.98,4.35,4.61,4.77,4.90,5.50,5.90,6.64,7.44,8.24,
 9.96,11.81};
static float alpha05_nx064_nz07_fwhm125[32] = {
 1.97,1.99,2.04,2.31,2.49,2.61,2.76,2.84,2.89,2.93,
 2.96,2.98,3.00,3.44,3.66,3.84,3.96,4.27,4.76,5.00,
 5.51,5.81,5.99,6.42,6.71,7.60,8.43,9.63,10.89,12.36,
 15.37,18.70};
static float alpha05_nx064_nz07_fwhm150[32] = {
 2.53,2.68,2.78,2.87,2.93,2.98,3.35,3.62,3.78,3.89,
 3.98,4.18,4.37,4.75,4.96,5.49,5.89,6.37,7.04,7.78,
 8.42,8.93,9.56,10.06,10.67,12.34,13.85,15.96,18.52,21.31,
 26.94,33.57};
static float alpha05_nx064_nz07_fwhm175[32] = {
 3.05,3.48,3.71,3.90,4.21,4.50,4.85,5.24,5.64,5.87,
 6.13,6.44,6.68,7.27,7.86,8.54,9.32,10.00,11.27,12.61,
 13.73,14.84,15.92,16.94,18.01,20.76,23.54,27.22,31.85,36.75,
 47.50,59.51};
static float alpha05_nx064_nz07_fwhm200[32] = {
 4.52,4.84,5.19,5.68,6.08,6.53,7.21,7.76,8.29,8.74,
 9.13,9.53,9.87,10.85,11.73,12.80,14.19,15.40,17.52,19.40,
 21.17,22.85,24.41,25.95,27.44,31.85,36.61,42.93,50.34,58.16,
 75.09,94.29};
static float alpha05_nx064_nz07_fwhm225[32] = {
 5.91,6.57,7.01,7.72,8.28,8.81,9.70,10.53,11.27,11.91,
 12.48,12.98,13.56,15.02,16.26,17.87,19.61,21.32,24.10,26.91,
 29.29,32.01,34.46,36.57,38.70,45.08,52.18,59.88,70.95,81.72,
 106.57,133.70};
static float alpha05_nx064_nz07_fwhm250[32] = {
 7.41,8.21,8.79,9.51,10.33,10.98,12.16,13.18,14.13,15.10,
 15.96,16.75,17.39,19.15,20.86,22.97,25.22,27.42,31.29,34.75,
 38.16,41.42,44.49,47.73,50.58,59.37,67.74,78.82,94.43,109.38,
 139.75,172.62};
static float alpha05_nx064_nz07_fwhm275[32] = {
 8.76,9.62,10.41,11.35,12.32,13.11,14.69,16.05,17.22,18.25,
 19.17,20.10,20.91,23.33,25.76,28.07,31.00,33.65,38.64,43.28,
 47.73,51.71,55.78,59.72,63.26,74.42,85.40,100.17,118.73,135.36,
 172.00,212.57};
static float alpha05_nx064_nz07_fwhm300[32] = {
 9.85,10.91,11.88,12.97,14.23,15.32,17.12,18.72,19.91,21.25,
 22.44,23.58,24.67,27.51,30.18,33.45,37.34,40.59,46.73,52.11,
 57.90,62.81,67.31,72.28,76.97,91.00,104.56,121.23,141.82,161.67,
 205.36,257.25};
static float alpha05_nx064_nz07_fwhm325[32] = {
 10.83,12.02,13.26,14.57,15.85,17.14,19.34,20.98,22.84,24.53,
 25.85,27.21,28.52,32.19,35.33,39.35,43.45,47.34,54.53,61.61,
 68.42,74.81,80.50,85.95,91.46,107.25,123.24,143.05,167.41,191.39,
 242.62,300.90};
static float alpha05_nx064_nz07_fwhm350[32] = {
 11.75,13.25,14.46,15.80,17.55,19.01,21.43,23.60,25.65,27.60,
 29.35,30.87,32.52,36.65,40.29,44.82,49.58,54.67,63.12,71.90,
 79.72,86.43,93.36,99.91,106.00,125.57,142.50,165.06,192.47,219.94,
 281.40,344.80};
static float alpha05_nx064_nz07_fwhm375[32] = {
 12.44,13.98,15.41,17.12,19.06,20.68,23.51,26.31,28.42,30.79,
 32.83,34.61,36.22,41.00,45.33,50.37,56.53,62.57,72.77,81.90,
 90.56,98.53,107.00,114.21,122.04,142.28,162.95,187.92,219.58,251.82,
 318.22,385.40};
static float alpha05_nx064_nz07_fwhm400[32] = {
 12.94,14.79,16.58,18.28,20.27,22.32,25.55,28.42,31.00,33.55,
 35.72,37.80,39.97,45.67,50.73,57.26,64.20,70.81,82.19,92.74,
 101.80,111.35,121.31,129.12,137.00,161.92,182.88,212.75,248.29,282.62,
 354.82,428.78};
static float alpha05_nx064_nz07_fwhm425[32] = {
 13.46,15.58,16.97,19.12,21.65,23.86,27.35,30.82,33.77,36.39,
 38.92,41.38,43.65,50.80,56.56,63.59,71.83,79.12,91.78,103.62,
 114.44,124.91,134.56,144.75,153.80,181.18,204.75,236.93,275.44,314.50,
 395.56,474.00};
static float alpha05_nx064_nz07_fwhm450[32] = {
 13.56,15.76,17.84,20.10,23.09,24.99,29.22,32.94,36.22,39.25,
 42.42,45.32,48.35,55.59,62.44,70.64,79.20,86.78,101.38,114.50,
 127.21,138.42,148.90,160.50,171.08,201.17,227.38,261.00,303.83,346.60,
 431.75,518.25};
static float alpha05_nx064_nz07_fwhm475[32] = {
 13.56,16.04,18.22,20.94,23.52,26.21,31.26,35.31,39.26,42.93,
 46.29,49.71,52.68,60.52,68.12,76.87,86.41,95.12,111.81,125.92,
 139.62,152.00,164.73,177.82,188.94,220.55,249.75,287.14,334.33,382.20,
 469.86,562.20};
static float alpha05_nx064_nz07_fwhm500[32] = {
 13.56,16.33,18.62,21.54,24.58,27.76,33.07,37.84,42.38,46.52,
 49.93,53.76,56.48,65.45,73.18,83.58,93.74,103.85,121.69,137.44,
 152.56,168.06,181.00,193.91,206.83,241.00,271.86,314.20,366.00,415.50,
 509.00,608.80};
static float *alpha05_nx064_nz07[21] = {
 alpha05_nx064_nz07_fwhm000, alpha05_nx064_nz07_fwhm025, alpha05_nx064_nz07_fwhm050, 
 alpha05_nx064_nz07_fwhm075, alpha05_nx064_nz07_fwhm100, alpha05_nx064_nz07_fwhm125, 
 alpha05_nx064_nz07_fwhm150, alpha05_nx064_nz07_fwhm175, alpha05_nx064_nz07_fwhm200, 
 alpha05_nx064_nz07_fwhm225, alpha05_nx064_nz07_fwhm250, alpha05_nx064_nz07_fwhm275, 
 alpha05_nx064_nz07_fwhm300, alpha05_nx064_nz07_fwhm325, alpha05_nx064_nz07_fwhm350, 
 alpha05_nx064_nz07_fwhm375, alpha05_nx064_nz07_fwhm400, alpha05_nx064_nz07_fwhm425, 
 alpha05_nx064_nz07_fwhm450, alpha05_nx064_nz07_fwhm475, alpha05_nx064_nz07_fwhm500} ;

static float alpha10_nx064_nz07_fwhm000[32] = {
 1.89,1.90,1.90,1.90,1.90,1.91,1.91,1.91,1.92,1.93,
 1.94,1.95,1.96,2.00,2.33,2.55,2.69,2.78,2.86,2.91,
 2.95,2.99,3.25,3.46,3.62,3.85,3.97,4.52,4.89,5.37,
 6.23,7.13};
static float alpha10_nx064_nz07_fwhm025[32] = {
 1.89,1.90,1.90,1.90,1.90,1.91,1.91,1.91,1.92,1.93,
 1.94,1.95,1.96,2.00,2.33,2.55,2.69,2.78,2.86,2.91,
 2.95,2.99,3.25,3.46,3.62,3.85,3.97,4.52,4.89,5.37,
 6.23,7.13};
static float alpha10_nx064_nz07_fwhm050[32] = {
 1.89,1.90,1.90,1.90,1.90,1.91,1.91,1.92,1.92,1.93,
 1.94,1.95,1.97,2.11,2.39,2.59,2.72,2.79,2.88,2.92,
 2.96,3.05,3.34,3.54,3.68,3.88,4.00,4.62,4.94,5.52,
 6.43,7.41};
static float alpha10_nx064_nz07_fwhm075[32] = {
 1.89,1.90,1.90,1.90,1.91,1.91,1.92,1.93,1.94,1.96,
 1.97,1.99,2.08,2.44,2.60,2.72,2.81,2.86,2.93,2.98,
 3.23,3.52,3.67,3.78,3.85,4.04,4.61,4.92,5.58,5.95,
 7.04,8.33};
static float alpha10_nx064_nz07_fwhm100[32] = {
 1.89,1.90,1.91,1.92,1.92,1.93,1.96,1.98,2.09,2.30,
 2.43,2.53,2.60,2.75,2.82,2.88,2.93,2.98,3.43,3.69,
 3.83,3.93,4.05,4.37,4.59,4.95,5.52,5.98,6.80,7.61,
 9.10,10.80};
static float alpha10_nx064_nz07_fwhm125[32] = {
 1.91,1.93,1.95,1.97,2.00,2.20,2.47,2.63,2.72,2.79,
 2.84,2.87,2.90,2.97,3.20,3.54,3.77,3.89,4.28,4.70,
 4.93,5.28,5.61,5.83,5.99,6.85,7.66,8.70,9.93,11.22,
 13.97,16.88};
static float alpha10_nx064_nz07_fwhm150[32] = {
 2.00,2.28,2.47,2.62,2.74,2.82,2.93,3.00,3.31,3.52,
 3.67,3.78,3.86,4.16,4.53,4.85,5.27,5.68,6.35,6.92,
 7.54,7.96,8.60,9.04,9.57,11.02,12.53,14.29,16.66,19.02,
 24.30,30.10};
static float alpha10_nx064_nz07_fwhm175[32] = {
 2.75,2.90,3.00,3.36,3.65,3.82,4.15,4.57,4.84,5.04,
 5.35,5.59,5.79,6.38,6.89,7.54,8.15,8.81,9.98,11.15,
 12.21,13.13,14.05,14.96,15.86,18.47,20.85,24.26,28.38,32.86,
 42.31,52.86};
static float alpha10_nx064_nz07_fwhm200[32] = {
 3.68,3.95,4.31,4.69,5.02,5.43,5.98,6.59,7.00,7.50,
 7.87,8.21,8.53,9.40,10.19,11.14,12.31,13.38,15.32,16.91,
 18.48,19.99,21.50,22.88,24.20,28.07,32.18,37.69,44.41,51.55,
 66.61,83.28};
static float alpha10_nx064_nz07_fwhm225[32] = {
 4.68,5.13,5.67,6.20,6.79,7.31,8.16,8.83,9.53,10.07,
 10.62,11.01,11.54,12.80,13.94,15.33,16.86,18.37,20.94,23.30,
 25.54,27.75,29.84,31.85,33.77,39.67,45.40,52.63,62.34,72.23,
 93.44,117.18};
static float alpha10_nx064_nz07_fwhm250[32] = {
 5.71,6.42,6.99,7.77,8.48,9.03,10.12,10.98,11.85,12.60,
 13.35,13.94,14.62,16.34,17.87,19.70,21.56,23.38,26.77,30.02,
 32.94,35.76,38.55,41.33,43.86,51.69,59.33,69.15,82.00,94.67,
 121.71,151.53};
static float alpha10_nx064_nz07_fwhm275[32] = {
 6.63,7.52,8.28,8.95,9.88,10.65,11.97,13.18,14.27,15.16,
 16.13,16.90,17.71,19.65,21.46,23.66,26.23,28.66,32.94,37.14,
 40.98,44.54,48.01,51.68,54.92,64.46,74.28,86.55,101.80,117.14,
 149.94,185.70};
static float alpha10_nx064_nz07_fwhm300[32] = {
 7.41,8.41,9.23,10.16,11.19,12.18,13.84,15.21,16.39,17.49,
 18.56,19.52,20.48,22.93,25.24,27.89,31.13,33.97,39.52,44.29,
 49.22,53.60,57.87,62.26,66.24,78.14,89.49,104.13,122.14,140.72,
 179.41,221.33};
static float alpha10_nx064_nz07_fwhm325[32] = {
 8.00,9.03,10.03,11.21,12.41,13.52,15.34,16.98,18.50,19.90,
 21.09,22.10,23.23,26.35,29.04,32.49,36.18,39.61,45.97,51.93,
 57.55,62.78,68.12,73.34,77.93,91.52,104.67,122.42,144.12,164.10,
 208.58,256.16};
static float alpha10_nx064_nz07_fwhm350[32] = {
 8.36,9.57,10.67,11.98,13.45,14.67,16.83,18.72,20.41,21.91,
 23.40,24.76,26.08,29.62,32.85,36.88,41.29,45.20,52.86,59.36,
 66.06,72.47,78.51,84.03,89.78,105.80,121.35,141.00,165.05,189.16,
 239.29,293.81};
static float alpha10_nx064_nz07_fwhm375[32] = {
 8.54,9.97,11.21,12.60,14.14,15.53,17.92,20.11,22.14,23.96,
 25.74,27.35,28.79,33.04,36.94,41.47,46.41,50.90,59.27,67.23,
 74.76,82.33,89.05,95.81,102.24,120.39,137.41,159.38,186.75,214.75,
 270.82,331.33};
static float alpha10_nx064_nz07_fwhm400[32] = {
 8.54,10.03,11.42,13.01,14.73,16.28,19.08,21.58,23.93,25.99,
 28.00,29.85,31.58,36.51,40.49,45.42,50.94,56.44,66.33,75.67,
 84.37,92.55,99.87,107.48,114.86,135.67,154.29,177.86,210.50,240.50,
 303.40,370.30};
static float alpha10_nx064_nz07_fwhm425[32] = {
 8.54,10.03,11.42,13.26,15.26,16.85,20.02,23.00,25.60,27.98,
 30.27,32.40,34.33,39.22,43.52,49.20,55.96,62.27,73.79,84.23,
 93.97,102.58,110.72,119.85,128.00,150.54,170.43,198.83,233.25,266.94,
 336.40,408.00};
static float alpha10_nx064_nz07_fwhm450[32] = {
 8.54,10.03,11.42,13.35,15.41,17.33,20.98,24.32,27.13,29.69,
 32.10,34.11,36.29,41.69,46.88,53.69,61.41,68.29,81.26,92.59,
 103.00,113.23,122.67,132.16,140.42,164.60,188.53,219.79,256.19,292.83,
 368.63,448.86};
static float alpha10_nx064_nz07_fwhm475[32] = {
 8.54,10.03,11.42,13.35,15.55,17.77,21.67,25.33,28.26,31.19,
 33.50,35.82,38.15,44.46,50.27,57.80,66.14,74.29,88.30,101.32,
 112.62,123.62,134.36,143.82,153.28,180.13,207.05,240.20,280.52,320.17,
 402.62,487.80};
static float alpha10_nx064_nz07_fwhm500[32] = {
 8.54,10.03,11.42,13.35,15.55,17.77,21.80,25.56,28.98,31.98,
 34.86,37.52,39.88,47.04,53.30,62.03,71.59,80.27,95.56,109.39,
 122.37,134.25,145.33,156.11,167.40,196.95,226.27,261.50,304.00,348.44,
 440.00,526.25};
static float *alpha10_nx064_nz07[21] = {
 alpha10_nx064_nz07_fwhm000, alpha10_nx064_nz07_fwhm025, alpha10_nx064_nz07_fwhm050, 
 alpha10_nx064_nz07_fwhm075, alpha10_nx064_nz07_fwhm100, alpha10_nx064_nz07_fwhm125, 
 alpha10_nx064_nz07_fwhm150, alpha10_nx064_nz07_fwhm175, alpha10_nx064_nz07_fwhm200, 
 alpha10_nx064_nz07_fwhm225, alpha10_nx064_nz07_fwhm250, alpha10_nx064_nz07_fwhm275, 
 alpha10_nx064_nz07_fwhm300, alpha10_nx064_nz07_fwhm325, alpha10_nx064_nz07_fwhm350, 
 alpha10_nx064_nz07_fwhm375, alpha10_nx064_nz07_fwhm400, alpha10_nx064_nz07_fwhm425, 
 alpha10_nx064_nz07_fwhm450, alpha10_nx064_nz07_fwhm475, alpha10_nx064_nz07_fwhm500} ;

static float **nx064_nz07[3] = {
  alpha01_nx064_nz07 , alpha05_nx064_nz07 , alpha10_nx064_nz07 };

static float alpha01_nx064_nz08_fwhm000[32] = {
 1.99,1.99,1.99,1.99,1.99,2.00,2.16,2.44,2.61,2.71,
 2.77,2.82,2.86,2.91,2.95,2.97,2.98,2.99,3.48,3.78,
 3.89,3.95,3.99,4.21,4.50,4.89,5.00,5.78,6.29,6.83,
 7.88,9.15};
static float alpha01_nx064_nz08_fwhm025[32] = {
 1.99,1.99,1.99,1.99,1.99,2.00,2.16,2.44,2.61,2.71,
 2.77,2.82,2.86,2.91,2.95,2.97,2.98,2.99,3.48,3.78,
 3.89,3.95,3.99,4.21,4.50,4.89,5.00,5.78,6.29,6.83,
 7.88,9.15};
static float alpha01_nx064_nz08_fwhm050[32] = {
 1.99,1.99,1.99,1.99,1.99,2.00,2.29,2.52,2.65,2.74,
 2.80,2.85,2.87,2.92,2.95,2.97,2.99,3.01,3.58,3.82,
 3.91,3.97,4.00,4.40,4.62,4.93,5.26,5.85,6.47,6.89,
 8.07,9.50};
static float alpha01_nx064_nz08_fwhm075[32] = {
 1.99,1.99,1.99,2.00,2.00,2.26,2.54,2.71,2.79,2.85,
 2.88,2.91,2.92,2.96,2.98,2.99,3.18,3.54,3.85,3.96,
 4.09,4.45,4.63,4.79,4.89,5.42,5.86,6.42,6.93,7.79,
 9.25,10.83};
static float alpha01_nx064_nz08_fwhm100[32] = {
 2.00,2.00,2.24,2.44,2.64,2.73,2.85,2.90,2.93,2.95,
 2.97,2.98,2.99,3.17,3.55,3.77,3.90,3.97,4.44,4.75,
 4.90,5.03,5.45,5.72,5.86,6.52,6.97,7.93,8.96,9.88,
 12.18,14.49};
static float alpha01_nx064_nz08_fwhm125[32] = {
 2.63,2.74,2.82,2.88,2.93,2.96,3.00,3.30,3.56,3.70,
 3.79,3.86,3.90,4.00,4.45,4.77,4.93,5.16,5.80,6.08,
 6.69,6.99,7.47,7.84,8.16,9.35,10.35,11.71,13.45,15.12,
 18.94,22.84};
static float alpha01_nx064_nz08_fwhm150[32] = {
 2.98,3.22,3.55,3.73,3.88,3.96,4.37,4.66,4.84,4.96,
 5.15,5.39,5.63,5.94,6.42,6.89,7.50,7.88,8.89,9.77,
 10.60,11.30,11.93,12.72,13.38,15.49,17.30,20.00,23.55,27.07,
 34.50,42.81};
static float alpha01_nx064_nz08_fwhm175[32] = {
 4.55,4.81,4.95,5.35,5.78,5.99,6.67,6.98,7.47,7.84,
 8.21,8.51,8.82,9.69,10.44,11.29,12.32,13.19,14.92,16.52,
 17.95,19.19,20.62,21.78,22.97,26.88,30.35,34.86,40.58,47.14,
 61.55,78.60};
static float alpha01_nx064_nz08_fwhm200[32] = {
 6.80,7.32,7.79,8.22,8.81,9.31,10.11,10.91,11.61,11.99,
 12.61,13.21,13.66,14.93,16.31,17.70,19.42,20.42,23.32,25.83,
 28.20,30.48,32.29,34.58,36.32,41.80,47.81,55.90,66.67,77.25,
 100.78,128.25};
static float alpha01_nx064_nz08_fwhm225[32] = {
 9.63,10.35,10.80,11.51,12.23,12.94,14.23,15.36,16.32,17.04,
 18.00,18.74,19.45,21.31,22.75,24.70,27.30,29.58,33.50,36.88,
 39.74,42.82,46.38,49.33,52.25,60.54,68.61,79.45,95.29,110.69,
 142.86,180.00};
static float alpha01_nx064_nz08_fwhm250[32] = {
 12.22,13.07,13.89,15.03,16.18,16.90,18.72,20.18,21.42,22.83,
 23.81,24.62,25.62,28.15,30.43,33.00,35.78,38.78,44.14,48.73,
 53.80,57.91,62.08,65.47,68.82,79.69,92.30,107.00,126.00,144.50,
 185.86,231.50};
static float alpha01_nx064_nz08_fwhm275[32] = {
 14.86,16.14,17.23,18.47,19.83,21.10,23.27,25.00,26.79,28.35,
 29.92,31.12,32.20,35.00,38.58,41.47,45.08,48.53,55.06,61.10,
 67.25,72.69,78.50,82.91,87.38,101.75,116.33,134.00,156.17,181.00,
 230.86,290.43};
static float alpha01_nx064_nz08_fwhm300[32] = {
 17.78,19.60,21.00,22.20,23.79,25.32,27.88,30.04,31.83,33.86,
 35.47,37.05,38.35,42.60,46.15,49.42,54.60,59.64,67.40,75.30,
 81.75,88.43,95.22,100.00,107.00,124.00,141.25,161.67,193.00,219.00,
 280.67,351.33};
static float alpha01_nx064_nz08_fwhm325[32] = {
 20.89,22.70,24.09,25.74,27.55,28.82,32.24,34.54,37.31,39.52,
 41.38,43.56,45.10,49.85,54.22,59.22,65.45,70.00,80.56,88.57,
 97.78,104.86,112.50,121.09,126.20,147.50,168.00,192.75,226.00,260.00,
 330.00,407.00};
static float alpha01_nx064_nz08_fwhm350[32] = {
 23.39,25.17,26.95,29.00,31.47,33.71,36.91,39.82,42.50,45.57,
 47.43,49.75,51.78,57.60,62.70,69.50,75.92,82.40,93.83,103.77,
 113.43,122.10,130.57,139.40,146.00,171.67,194.80,225.00,264.33,301.25,
 381.80,478.00};
static float alpha01_nx064_nz08_fwhm375[32] = {
 25.56,28.12,29.93,32.65,35.00,38.00,41.58,45.53,48.11,50.60,
 53.56,56.38,59.12,66.50,73.00,79.50,87.25,93.86,106.33,117.75,
 127.86,138.33,150.00,159.67,170.00,195.50,224.83,259.75,298.00,344.00,
 439.50,545.00};
static float alpha01_nx064_nz08_fwhm400[32] = {
 28.11,30.81,33.08,36.00,39.20,42.27,46.79,50.44,54.21,57.57,
 60.90,64.80,67.83,74.88,81.55,90.22,98.50,106.17,119.60,133.25,
 145.62,158.75,170.20,181.50,192.00,224.67,254.50,289.75,331.50,387.00,
 493.33,602.00};
static float alpha01_nx064_nz08_fwhm425[32] = {
 30.33,33.57,36.56,39.75,43.42,46.00,51.73,57.38,61.56,65.11,
 69.25,72.22,74.64,83.25,91.00,100.18,109.67,118.75,134.00,152.00,
 165.71,180.50,192.00,206.00,216.60,249.67,281.00,320.67,374.50,429.33,
 550.50,682.00};
static float alpha01_nx064_nz08_fwhm450[32] = {
 32.83,36.45,40.00,43.12,47.69,51.38,57.00,62.86,67.38,70.91,
 75.56,78.89,82.42,92.43,101.00,110.40,121.40,132.57,153.00,169.00,
 185.50,199.50,214.33,228.75,241.00,276.00,312.00,354.00,416.00,481.00,
 612.67,751.00};
static float alpha01_nx064_nz08_fwhm475[32] = {
 35.78,39.67,43.50,47.50,52.13,55.58,61.70,67.80,73.20,77.43,
 81.33,86.00,89.50,102.25,110.00,122.00,136.67,148.50,169.22,187.40,
 205.00,222.00,237.00,250.00,264.33,304.33,343.67,395.00,462.00,534.00,
 672.67,818.00};
static float alpha01_nx064_nz08_fwhm500[32] = {
 37.78,42.50,45.69,50.86,55.67,59.40,66.70,73.00,79.25,83.25,
 88.40,93.33,98.33,110.20,122.00,136.33,149.75,161.83,184.40,205.50,
 223.25,242.00,255.50,272.50,289.50,332.00,374.50,435.67,513.00,586.67,
 737.00,897.50};
static float *alpha01_nx064_nz08[21] = {
 alpha01_nx064_nz08_fwhm000, alpha01_nx064_nz08_fwhm025, alpha01_nx064_nz08_fwhm050, 
 alpha01_nx064_nz08_fwhm075, alpha01_nx064_nz08_fwhm100, alpha01_nx064_nz08_fwhm125, 
 alpha01_nx064_nz08_fwhm150, alpha01_nx064_nz08_fwhm175, alpha01_nx064_nz08_fwhm200, 
 alpha01_nx064_nz08_fwhm225, alpha01_nx064_nz08_fwhm250, alpha01_nx064_nz08_fwhm275, 
 alpha01_nx064_nz08_fwhm300, alpha01_nx064_nz08_fwhm325, alpha01_nx064_nz08_fwhm350, 
 alpha01_nx064_nz08_fwhm375, alpha01_nx064_nz08_fwhm400, alpha01_nx064_nz08_fwhm425, 
 alpha01_nx064_nz08_fwhm450, alpha01_nx064_nz08_fwhm475, alpha01_nx064_nz08_fwhm500} ;

static float alpha05_nx064_nz08_fwhm000[32] = {
 1.95,1.95,1.95,1.95,1.95,1.96,1.96,1.97,1.97,1.98,
 1.99,2.11,2.27,2.56,2.70,2.80,2.87,2.91,2.95,2.99,
 3.29,3.55,3.72,3.81,3.88,4.00,4.56,4.90,5.41,5.87,
 6.85,7.88};
static float alpha05_nx064_nz08_fwhm025[32] = {
 1.95,1.95,1.95,1.95,1.95,1.96,1.96,1.97,1.97,1.98,
 1.99,2.11,2.27,2.56,2.70,2.80,2.87,2.91,2.95,2.99,
 3.29,3.55,3.72,3.81,3.88,4.00,4.56,4.90,5.41,5.87,
 6.85,7.88};
static float alpha05_nx064_nz08_fwhm050[32] = {
 1.95,1.95,1.95,1.95,1.95,1.96,1.96,1.97,1.98,1.99,
 2.00,2.22,2.35,2.61,2.73,2.82,2.88,2.92,2.96,3.00,
 3.39,3.63,3.77,3.85,3.90,4.19,4.66,4.94,5.55,5.94,
 6.95,8.05};
static float alpha05_nx064_nz08_fwhm075[32] = {
 1.95,1.95,1.95,1.96,1.96,1.96,1.97,1.98,2.00,2.24,
 2.39,2.51,2.59,2.75,2.82,2.89,2.92,2.95,3.04,3.52,
 3.73,3.85,3.91,3.96,4.05,4.69,4.93,5.50,5.95,6.67,
 7.85,9.17};
static float alpha05_nx064_nz08_fwhm100[32] = {
 1.95,1.96,1.96,1.97,1.98,1.99,2.20,2.44,2.59,2.68,
 2.75,2.80,2.83,2.90,2.94,2.98,3.20,3.52,3.81,3.93,
 4.04,4.46,4.66,4.82,4.92,5.55,5.95,6.73,7.56,8.41,
 10.08,12.04};
static float alpha05_nx064_nz08_fwhm125[32] = {
 1.97,1.99,2.02,2.32,2.51,2.65,2.78,2.86,2.91,2.94,
 2.97,2.99,3.07,3.52,3.73,3.89,3.99,4.38,4.81,5.00,
 5.54,5.85,6.14,6.56,6.80,7.73,8.58,9.73,11.13,12.66,
 15.71,19.00};
static float alpha05_nx064_nz08_fwhm150[32] = {
 2.58,2.72,2.81,2.90,2.97,3.00,3.44,3.69,3.84,3.93,
 4.02,4.27,4.47,4.81,4.99,5.56,5.93,6.45,7.18,7.89,
 8.54,9.09,9.78,10.33,10.90,12.56,14.18,16.30,18.96,21.81,
 27.81,34.77};
static float alpha05_nx064_nz08_fwhm175[32] = {
 3.19,3.57,3.78,3.95,4.30,4.57,4.94,5.39,5.76,6.00,
 6.31,6.57,6.80,7.47,7.99,8.75,9.60,10.31,11.65,12.83,
 14.08,15.20,16.31,17.32,18.37,21.35,24.20,27.91,32.87,38.15,
 49.49,62.40};
static float alpha05_nx064_nz08_fwhm200[32] = {
 4.69,5.09,5.50,5.85,6.31,6.72,7.42,7.95,8.56,8.97,
 9.47,9.89,10.33,11.43,12.31,13.51,14.73,15.87,18.11,19.99,
 21.89,23.65,25.29,26.84,28.51,33.43,37.94,43.98,52.57,60.87,
 79.23,100.14};
static float alpha05_nx064_nz08_fwhm225[32] = {
 6.37,7.02,7.52,8.12,8.78,9.30,10.33,11.13,11.91,12.61,
 13.20,13.79,14.38,15.88,17.28,18.82,20.76,22.38,25.45,28.05,
 30.76,33.42,35.91,38.14,40.50,47.24,53.89,63.24,74.56,86.00,
 113.08,141.73};
static float alpha05_nx064_nz08_fwhm250[32] = {
 8.08,8.87,9.45,10.28,11.20,11.91,13.21,14.37,15.31,16.14,
 17.18,17.94,18.61,20.65,22.36,24.64,26.94,29.14,33.27,37.04,
 40.48,43.78,46.83,49.96,52.87,62.07,70.73,82.77,97.80,113.40,
 148.06,184.92};
static float alpha05_nx064_nz08_fwhm275[32] = {
 9.65,10.69,11.54,12.49,13.58,14.57,16.13,17.60,18.77,20.00,
 20.95,22.08,23.03,25.57,27.70,30.31,33.23,36.06,41.37,46.00,
 50.33,54.21,58.09,62.22,66.20,77.79,88.38,103.16,122.19,142.24,
 182.79,228.15};
static float alpha05_nx064_nz08_fwhm300[32] = {
 11.13,12.31,13.34,14.56,15.93,16.92,18.88,20.65,22.16,23.51,
 24.85,26.08,27.12,30.20,32.95,36.20,39.69,43.27,49.72,54.98,
 60.59,65.17,70.27,74.82,79.82,93.59,107.55,124.55,147.79,170.05,
 219.19,275.07};
static float alpha05_nx064_nz08_fwhm325[32] = {
 12.37,13.80,15.12,16.52,17.98,19.26,21.55,23.53,25.34,26.88,
 28.44,29.94,31.25,35.12,38.21,42.17,46.67,50.65,57.56,64.47,
 71.00,77.10,82.96,89.00,94.39,110.25,126.69,146.95,172.78,200.59,
 257.50,319.71};
static float alpha05_nx064_nz08_fwhm350[32] = {
 13.50,15.18,16.60,18.28,19.92,21.67,24.42,26.52,28.65,30.52,
 32.32,34.10,35.67,39.88,43.88,48.24,53.61,58.05,66.65,74.73,
 82.35,89.84,96.43,102.65,108.93,128.25,145.67,171.06,200.90,231.47,
 295.00,364.00};
static float alpha05_nx064_nz08_fwhm375[32] = {
 14.51,16.50,18.14,19.84,21.94,23.64,26.98,29.44,31.55,33.87,
 36.02,37.71,39.36,44.68,49.34,54.50,60.29,66.23,76.07,84.88,
 93.37,101.27,109.25,117.24,124.86,146.20,166.62,194.50,228.30,263.21,
 335.00,410.17};
static float alpha05_nx064_nz08_fwhm400[32] = {
 15.37,17.29,19.00,21.29,23.49,25.71,29.15,31.91,35.17,37.21,
 39.56,41.74,43.75,49.48,54.58,60.56,67.83,74.29,84.93,95.19,
 104.69,113.47,123.08,131.82,139.67,164.13,188.70,218.36,256.57,296.80,
 378.10,455.08};
static float alpha05_nx064_nz08_fwhm425[32] = {
 15.71,18.02,20.06,22.51,25.17,27.36,31.16,34.72,37.95,40.73,
 43.28,45.47,47.92,54.15,59.56,66.72,74.24,81.58,94.46,105.42,
 116.00,126.46,136.50,147.00,156.33,183.88,210.33,244.44,286.33,330.70,
 418.14,508.44};
static float alpha05_nx064_nz08_fwhm450[32] = {
 16.36,18.90,20.98,23.61,26.50,28.93,33.29,37.16,40.42,43.64,
 46.39,48.92,51.62,58.48,65.17,72.90,81.63,89.56,103.31,116.53,
 128.58,140.20,151.38,162.87,172.81,204.11,232.83,269.91,318.00,367.00,
 462.00,557.40};
static float alpha05_nx064_nz08_fwhm475[32] = {
 16.45,19.38,21.88,24.43,27.38,29.93,35.09,39.44,43.38,46.67,
 49.72,52.79,55.67,63.38,70.42,79.22,88.36,96.50,112.62,127.94,
 140.69,153.47,166.92,178.75,190.92,223.22,256.14,298.29,350.38,401.00,
 501.80,604.33};
static float alpha05_nx064_nz08_fwhm500[32] = {
 16.56,19.50,21.92,25.09,28.52,31.43,36.89,41.83,45.96,49.52,
 53.27,56.84,59.68,68.50,75.80,85.06,95.33,103.77,123.67,138.80,
 153.76,169.09,181.84,195.00,208.71,244.43,280.80,327.43,382.00,436.12,
 541.38,656.12};
static float *alpha05_nx064_nz08[21] = {
 alpha05_nx064_nz08_fwhm000, alpha05_nx064_nz08_fwhm025, alpha05_nx064_nz08_fwhm050, 
 alpha05_nx064_nz08_fwhm075, alpha05_nx064_nz08_fwhm100, alpha05_nx064_nz08_fwhm125, 
 alpha05_nx064_nz08_fwhm150, alpha05_nx064_nz08_fwhm175, alpha05_nx064_nz08_fwhm200, 
 alpha05_nx064_nz08_fwhm225, alpha05_nx064_nz08_fwhm250, alpha05_nx064_nz08_fwhm275, 
 alpha05_nx064_nz08_fwhm300, alpha05_nx064_nz08_fwhm325, alpha05_nx064_nz08_fwhm350, 
 alpha05_nx064_nz08_fwhm375, alpha05_nx064_nz08_fwhm400, alpha05_nx064_nz08_fwhm425, 
 alpha05_nx064_nz08_fwhm450, alpha05_nx064_nz08_fwhm475, alpha05_nx064_nz08_fwhm500} ;

static float alpha10_nx064_nz08_fwhm000[32] = {
 1.89,1.90,1.90,1.90,1.90,1.91,1.91,1.92,1.92,1.93,
 1.94,1.95,1.97,2.11,2.40,2.59,2.72,2.80,2.88,2.92,
 2.96,3.05,3.38,3.56,3.68,3.89,4.01,4.64,4.93,5.50,
 6.38,7.33};
static float alpha10_nx064_nz08_fwhm025[32] = {
 1.89,1.90,1.90,1.90,1.90,1.91,1.91,1.92,1.92,1.93,
 1.94,1.95,1.97,2.11,2.40,2.59,2.72,2.80,2.88,2.92,
 2.96,3.05,3.38,3.56,3.68,3.89,4.01,4.64,4.93,5.50,
 6.38,7.33};
static float alpha10_nx064_nz08_fwhm050[32] = {
 1.89,1.90,1.90,1.90,1.90,1.91,1.91,1.92,1.93,1.94,
 1.95,1.96,1.97,2.21,2.46,2.63,2.75,2.82,2.89,2.94,
 2.98,3.21,3.47,3.63,3.73,3.92,4.20,4.71,4.98,5.62,
 6.55,7.55};
static float alpha10_nx064_nz08_fwhm075[32] = {
 1.89,1.90,1.90,1.90,1.91,1.91,1.92,1.93,1.95,1.96,
 1.98,2.01,2.18,2.48,2.63,2.75,2.82,2.87,2.94,3.00,
 3.39,3.62,3.73,3.83,3.89,4.24,4.69,4.96,5.64,6.02,
 7.22,8.50};
static float alpha10_nx064_nz08_fwhm100[32] = {
 1.90,1.91,1.91,1.92,1.93,1.93,1.96,1.99,2.16,2.34,
 2.48,2.57,2.64,2.76,2.84,2.90,2.95,3.00,3.52,3.75,
 3.87,3.97,4.17,4.46,4.65,4.97,5.60,6.10,6.89,7.72,
 9.32,10.99};
static float alpha10_nx064_nz08_fwhm125[32] = {
 1.92,1.93,1.95,1.97,2.00,2.25,2.52,2.67,2.76,2.81,
 2.86,2.89,2.92,2.99,3.33,3.62,3.81,3.92,4.40,4.74,
 4.94,5.34,5.69,5.90,6.15,6.95,7.79,8.84,10.12,11.50,
 14.18,17.16};
static float alpha10_nx064_nz08_fwhm150[32] = {
 2.08,2.34,2.52,2.67,2.79,2.85,2.95,3.15,3.43,3.61,
 3.73,3.83,3.91,4.28,4.63,4.91,5.35,5.76,6.46,6.99,
 7.68,8.22,8.78,9.26,9.79,11.28,12.74,14.65,16.94,19.60,
 24.94,30.89};
static float alpha10_nx064_nz08_fwhm175[32] = {
 2.81,2.94,3.15,3.47,3.72,3.88,4.31,4.69,4.91,5.19,
 5.50,5.73,5.89,6.56,7.00,7.72,8.47,9.07,10.30,11.41,
 12.41,13.55,14.51,15.40,16.29,18.97,21.59,24.97,29.27,33.92,
 44.09,55.65};
static float alpha10_nx064_nz08_fwhm200[32] = {
 3.80,4.21,4.58,4.88,5.29,5.67,6.31,6.82,7.30,7.75,
 8.13,8.56,8.88,9.85,10.68,11.74,12.87,13.86,15.87,17.60,
 19.24,20.82,22.26,23.75,25.12,29.37,33.56,39.09,46.34,53.66,
 70.26,88.89};
static float alpha10_nx064_nz08_fwhm225[32] = {
 4.96,5.58,6.04,6.58,7.12,7.74,8.65,9.31,10.01,10.65,
 11.20,11.74,12.27,13.66,14.79,16.24,17.82,19.42,22.12,24.65,
 26.87,29.09,31.22,33.34,35.45,41.47,47.31,55.34,65.51,76.20,
 99.36,124.80};
static float alpha10_nx064_nz08_fwhm250[32] = {
 6.14,6.90,7.60,8.28,9.05,9.76,10.87,11.85,12.81,13.58,
 14.40,14.96,15.71,17.46,19.10,20.91,23.02,24.90,28.65,31.99,
 35.09,37.96,40.90,43.71,46.33,54.20,61.68,72.53,86.03,99.77,
 129.15,161.86};
static float alpha10_nx064_nz08_fwhm275[32] = {
 7.31,8.17,8.87,9.76,10.75,11.61,13.04,14.35,15.48,16.42,
 17.40,18.27,19.14,21.32,23.29,25.82,28.42,30.83,35.31,39.55,
 43.31,46.85,50.36,53.90,57.56,67.02,77.16,90.22,107.08,123.94,
 160.40,199.71};
static float alpha10_nx064_nz08_fwhm300[32] = {
 8.31,9.30,10.10,11.18,12.41,13.44,15.24,16.69,18.11,19.43,
 20.50,21.61,22.53,25.23,27.64,30.44,33.65,36.63,42.09,47.09,
 51.52,55.97,60.25,64.62,68.84,81.29,93.25,109.09,129.33,149.65,
 191.85,238.11};
static float alpha10_nx064_nz08_fwhm325[32] = {
 9.00,10.32,11.45,12.70,13.98,15.11,17.28,19.06,20.74,22.08,
 23.45,24.74,25.92,28.97,31.61,35.26,38.96,42.73,48.77,54.51,
 60.40,65.58,70.92,75.98,80.75,95.32,109.74,128.26,151.39,174.86,
 223.84,277.82};
static float alpha10_nx064_nz08_fwhm350[32] = {
 9.72,11.30,12.58,13.81,15.38,16.73,19.08,21.14,23.13,24.71,
 26.24,27.68,28.95,32.61,35.82,39.70,44.16,48.22,55.66,62.73,
 68.89,75.12,81.00,86.84,92.87,109.79,126.12,147.84,173.81,201.26,
 256.50,318.29};
static float alpha10_nx064_nz08_fwhm375[32] = {
 10.28,11.89,13.24,14.74,16.41,18.01,20.69,22.99,25.10,27.19,
 28.95,30.57,32.01,36.08,39.78,44.20,49.19,53.98,62.42,70.30,
 77.94,85.05,92.19,98.68,105.37,124.73,143.83,168.14,198.20,227.95,
 290.15,356.54};
static float alpha10_nx064_nz08_fwhm400[32] = {
 10.36,12.11,13.65,15.37,17.36,19.21,22.13,24.80,27.13,29.25,
 31.25,33.00,34.76,39.49,43.33,48.59,54.43,59.76,69.05,78.56,
 87.14,95.23,102.97,110.96,118.11,141.04,162.19,189.14,221.83,254.47,
 323.44,393.31};
static float alpha10_nx064_nz08_fwhm425[32] = {
 10.36,12.21,13.92,15.75,18.30,20.27,23.44,26.20,28.98,31.16,
 33.44,35.18,37.12,42.28,46.97,52.84,59.65,65.28,76.57,86.54,
 96.44,105.59,114.60,123.48,131.73,157.11,179.90,209.47,244.26,281.95,
 357.70,432.89};
static float alpha10_nx064_nz08_fwhm450[32] = {
 10.36,12.21,13.92,16.04,18.38,20.33,24.24,27.52,30.45,32.87,
 35.49,37.53,39.66,45.62,50.63,57.45,64.55,71.18,84.16,95.52,
 106.12,116.67,126.04,136.33,145.84,173.25,197.58,229.35,269.94,312.35,
 391.88,473.10};
static float alpha10_nx064_nz08_fwhm475[32] = {
 10.36,12.21,13.92,16.12,18.53,20.78,25.13,28.69,32.18,34.63,
 37.17,39.78,41.93,48.23,54.43,61.28,69.67,77.34,91.45,103.93,
 115.43,126.62,138.19,149.25,159.83,188.67,215.39,252.00,296.46,340.91,
 426.40,515.00};
static float alpha10_nx064_nz08_fwhm500[32] = {
 10.36,12.21,13.92,16.12,18.61,21.25,25.63,29.42,33.07,35.93,
 38.76,41.62,44.25,51.49,57.76,65.60,74.87,83.42,98.70,112.46,
 125.06,138.36,150.59,161.88,172.70,204.61,234.75,275.92,324.36,369.71,
 461.78,558.25};
static float *alpha10_nx064_nz08[21] = {
 alpha10_nx064_nz08_fwhm000, alpha10_nx064_nz08_fwhm025, alpha10_nx064_nz08_fwhm050, 
 alpha10_nx064_nz08_fwhm075, alpha10_nx064_nz08_fwhm100, alpha10_nx064_nz08_fwhm125, 
 alpha10_nx064_nz08_fwhm150, alpha10_nx064_nz08_fwhm175, alpha10_nx064_nz08_fwhm200, 
 alpha10_nx064_nz08_fwhm225, alpha10_nx064_nz08_fwhm250, alpha10_nx064_nz08_fwhm275, 
 alpha10_nx064_nz08_fwhm300, alpha10_nx064_nz08_fwhm325, alpha10_nx064_nz08_fwhm350, 
 alpha10_nx064_nz08_fwhm375, alpha10_nx064_nz08_fwhm400, alpha10_nx064_nz08_fwhm425, 
 alpha10_nx064_nz08_fwhm450, alpha10_nx064_nz08_fwhm475, alpha10_nx064_nz08_fwhm500} ;

static float **nx064_nz08[3] = {
  alpha01_nx064_nz08 , alpha05_nx064_nz08 , alpha10_nx064_nz08 };

static float alpha01_nx064_nz09_fwhm000[32] = {
 1.99,1.99,1.99,1.99,1.99,2.00,2.22,2.48,2.63,2.73,
 2.79,2.84,2.87,2.92,2.95,2.97,2.99,3.05,3.64,3.84,
 3.91,3.97,4.00,4.31,4.54,4.87,5.21,5.77,6.29,6.89,
 7.99,9.38};
static float alpha01_nx064_nz09_fwhm025[32] = {
 1.99,1.99,1.99,1.99,1.99,2.00,2.22,2.48,2.63,2.73,
 2.79,2.84,2.87,2.92,2.95,2.97,2.99,3.05,3.64,3.84,
 3.91,3.97,4.00,4.31,4.54,4.87,5.21,5.77,6.29,6.89,
 7.99,9.38};
static float alpha01_nx064_nz09_fwhm050[32] = {
 1.99,1.99,1.99,1.99,2.00,2.00,2.32,2.55,2.67,2.76,
 2.81,2.86,2.89,2.93,2.96,2.98,2.99,3.25,3.71,3.87,
 3.94,3.98,4.18,4.45,4.63,4.93,5.38,5.85,6.52,6.97,
 8.31,9.69};
static float alpha01_nx064_nz09_fwhm075[32] = {
 1.99,1.99,1.99,2.00,2.00,2.29,2.58,2.73,2.81,2.86,
 2.89,2.92,2.93,2.97,2.99,3.01,3.48,3.69,3.88,3.97,
 4.08,4.43,4.65,4.82,4.90,5.46,5.90,6.54,6.98,7.85,
 9.45,11.07};
static float alpha01_nx064_nz09_fwhm100[32] = {
 2.00,2.00,2.16,2.49,2.68,2.76,2.86,2.91,2.94,2.96,
 2.97,2.99,3.00,3.42,3.66,3.82,3.92,3.97,4.43,4.73,
 4.92,5.09,5.52,5.73,5.89,6.64,7.06,7.90,8.92,10.08,
 12.30,14.49};
static float alpha01_nx064_nz09_fwhm125[32] = {
 2.67,2.78,2.85,2.90,2.94,2.96,3.07,3.41,3.61,3.74,
 3.82,3.88,3.93,4.05,4.43,4.74,4.92,5.18,5.83,6.20,
 6.67,6.94,7.50,7.88,8.31,9.42,10.54,11.94,13.78,15.28,
 19.03,23.58};
static float alpha01_nx064_nz09_fwhm150[32] = {
 2.99,3.32,3.52,3.71,3.86,3.95,4.38,4.62,4.81,4.92,
 5.09,5.44,5.64,5.99,6.52,6.94,7.55,8.03,8.95,9.83,
 10.61,11.39,11.98,12.71,13.42,15.44,17.27,20.15,23.44,26.98,
 35.32,43.44};
static float alpha01_nx064_nz09_fwhm175[32] = {
 4.64,4.89,5.07,5.46,5.80,5.98,6.71,7.10,7.52,7.86,
 8.21,8.61,8.86,9.76,10.52,11.35,12.33,13.29,14.99,16.60,
 18.03,19.50,20.79,22.22,23.35,27.42,30.90,36.10,42.71,49.09,
 64.24,79.93};
static float alpha01_nx064_nz09_fwhm200[32] = {
 6.80,7.40,7.80,8.33,8.98,9.64,10.51,11.13,11.86,12.48,
 12.86,13.34,13.81,15.27,16.43,17.79,19.51,20.92,23.79,26.24,
 28.78,30.87,33.14,35.50,37.62,44.21,50.12,58.36,68.92,80.67,
 104.27,133.80};
static float alpha01_nx064_nz09_fwhm225[32] = {
 9.70,10.55,11.34,11.89,12.65,13.32,14.74,15.73,16.80,17.63,
 18.47,19.26,19.96,21.79,23.52,25.54,28.00,30.32,34.32,37.37,
 41.29,44.80,48.20,51.31,55.00,62.94,71.92,85.00,100.50,116.50,
 151.67,191.00};
static float alpha01_nx064_nz09_fwhm250[32] = {
 12.72,13.89,14.66,15.61,16.81,17.94,19.61,21.23,22.36,23.61,
 24.75,25.82,26.62,29.21,31.07,33.57,36.64,39.92,46.17,51.23,
 55.00,59.39,64.00,67.63,72.00,84.75,98.18,113.83,133.62,156.00,
 202.00,254.33};
static float alpha01_nx064_nz09_fwhm275[32] = {
 15.90,17.00,18.22,19.73,21.09,22.70,24.43,26.19,28.00,29.20,
 30.82,32.10,33.22,36.42,39.31,43.38,47.37,50.94,57.78,63.60,
 69.22,75.40,80.89,86.29,91.25,108.17,124.25,144.43,168.67,200.00,
 253.25,315.60};
static float alpha01_nx064_nz09_fwhm300[32] = {
 19.00,20.57,21.85,23.41,25.00,26.75,28.95,31.71,34.00,35.83,
 37.65,39.13,40.87,45.07,48.47,52.43,57.25,61.92,69.82,78.15,
 84.38,90.50,98.80,105.83,112.67,133.60,153.20,177.50,208.00,242.75,
 305.00,378.33};
static float alpha01_nx064_nz09_fwhm325[32] = {
 21.79,23.86,25.27,27.52,29.44,31.36,34.68,37.38,39.69,42.42,
 44.50,45.58,47.54,52.33,56.70,62.20,68.10,72.70,83.25,92.00,
 100.80,110.40,118.57,127.12,134.40,159.50,181.60,209.00,249.17,284.00,
 358.50,449.00};
static float alpha01_nx064_nz09_fwhm350[32] = {
 24.74,27.10,29.38,31.58,34.44,36.22,39.87,42.92,45.82,49.00,
 51.22,52.88,55.00,61.64,65.93,72.10,79.00,85.50,98.00,108.50,
 117.75,129.60,139.22,147.50,158.00,186.33,210.40,246.75,290.00,326.00,
 412.00,517.25};
static float alpha01_nx064_nz09_fwhm375[32] = {
 27.93,30.67,33.20,35.91,38.92,40.90,44.64,48.57,51.43,54.38,
 57.50,60.50,63.00,69.29,75.00,81.88,90.62,99.14,111.62,122.50,
 135.67,150.14,159.78,172.50,183.00,212.50,242.00,281.40,326.00,373.67,
 479.00,583.80};
static float alpha01_nx064_nz09_fwhm400[32] = {
 31.12,34.20,37.08,40.30,43.09,45.64,49.67,54.38,57.71,61.20,
 64.50,67.00,69.38,76.73,84.75,93.67,103.12,110.33,125.50,141.50,
 156.33,171.17,184.00,195.75,206.80,241.50,274.00,315.80,370.25,423.33,
 532.75,650.00};
static float alpha01_nx064_nz09_fwhm425[32] = {
 34.20,37.75,39.83,43.29,47.00,49.83,55.17,59.70,63.17,67.78,
 70.25,73.89,77.17,87.67,95.40,104.00,114.50,124.14,144.00,160.00,
 176.67,191.83,205.00,217.50,232.00,270.67,309.00,353.33,415.50,472.00,
 595.50,717.50};
static float alpha01_nx064_nz09_fwhm450[32] = {
 37.09,40.27,43.33,47.25,51.12,55.33,60.75,65.44,69.86,73.88,
 78.40,82.60,86.43,96.75,105.33,115.00,127.00,138.57,160.50,181.00,
 197.00,211.75,228.00,244.00,258.00,297.50,340.00,392.00,458.50,523.50,
 654.00,796.50};
static float alpha01_nx064_nz09_fwhm475[32] = {
 38.70,43.00,46.44,50.86,55.88,58.75,65.25,70.75,76.40,81.00,
 85.62,91.33,94.88,106.50,115.67,125.50,139.33,153.00,179.33,198.00,
 217.67,237.33,251.75,266.50,281.00,332.00,374.50,433.00,503.00,571.50,
 711.00,867.00};
static float alpha01_nx064_nz09_fwhm500[32] = {
 41.30,46.30,50.20,54.43,58.77,63.00,71.25,79.00,84.33,90.00,
 94.25,99.00,103.75,115.00,125.75,138.67,153.17,169.00,196.00,219.00,
 241.00,259.33,275.50,292.50,310.50,363.33,406.75,474.00,550.00,617.50,
 765.00,928.00};
static float *alpha01_nx064_nz09[21] = {
 alpha01_nx064_nz09_fwhm000, alpha01_nx064_nz09_fwhm025, alpha01_nx064_nz09_fwhm050, 
 alpha01_nx064_nz09_fwhm075, alpha01_nx064_nz09_fwhm100, alpha01_nx064_nz09_fwhm125, 
 alpha01_nx064_nz09_fwhm150, alpha01_nx064_nz09_fwhm175, alpha01_nx064_nz09_fwhm200, 
 alpha01_nx064_nz09_fwhm225, alpha01_nx064_nz09_fwhm250, alpha01_nx064_nz09_fwhm275, 
 alpha01_nx064_nz09_fwhm300, alpha01_nx064_nz09_fwhm325, alpha01_nx064_nz09_fwhm350, 
 alpha01_nx064_nz09_fwhm375, alpha01_nx064_nz09_fwhm400, alpha01_nx064_nz09_fwhm425, 
 alpha01_nx064_nz09_fwhm450, alpha01_nx064_nz09_fwhm475, alpha01_nx064_nz09_fwhm500} ;

static float alpha05_nx064_nz09_fwhm000[32] = {
 1.95,1.95,1.95,1.95,1.95,1.96,1.96,1.97,1.98,1.99,
 2.00,2.18,2.34,2.60,2.73,2.82,2.88,2.92,2.97,3.05,
 3.41,3.63,3.76,3.84,3.90,4.04,4.65,4.92,5.51,5.92,
 6.94,7.96};
static float alpha05_nx064_nz09_fwhm025[32] = {
 1.95,1.95,1.95,1.95,1.95,1.96,1.96,1.97,1.98,1.99,
 2.00,2.18,2.34,2.60,2.73,2.82,2.88,2.92,2.97,3.05,
 3.41,3.63,3.76,3.84,3.90,4.04,4.65,4.92,5.51,5.92,
 6.94,7.96};
static float alpha05_nx064_nz09_fwhm050[32] = {
 1.95,1.95,1.95,1.95,1.96,1.96,1.96,1.97,1.98,1.99,
 2.06,2.28,2.41,2.64,2.76,2.84,2.90,2.93,2.98,3.20,
 3.50,3.69,3.80,3.87,3.93,4.27,4.72,4.95,5.65,5.97,
 7.11,8.21};
static float alpha05_nx064_nz09_fwhm075[32] = {
 1.95,1.95,1.95,1.96,1.96,1.96,1.97,1.99,2.06,2.30,
 2.45,2.56,2.63,2.78,2.85,2.90,2.94,2.97,3.25,3.60,
 3.76,3.86,3.93,3.98,4.18,4.74,4.96,5.61,6.00,6.78,
 7.94,9.34};
static float alpha05_nx064_nz09_fwhm100[32] = {
 1.95,1.96,1.96,1.97,1.98,1.99,2.28,2.50,2.64,2.73,
 2.79,2.83,2.86,2.92,2.96,2.99,3.35,3.59,3.83,3.94,
 4.11,4.52,4.73,4.86,4.96,5.66,6.00,6.81,7.66,8.52,
 10.33,12.32};
static float alpha05_nx064_nz09_fwhm125[32] = {
 1.98,1.99,2.19,2.42,2.59,2.69,2.81,2.88,2.93,2.96,
 2.98,3.06,3.27,3.59,3.76,3.90,4.00,4.45,4.87,5.21,
 5.64,5.89,6.24,6.63,6.86,7.79,8.73,9.88,11.31,12.81,
 15.83,19.35};
static float alpha05_nx064_nz09_fwhm150[32] = {
 2.64,2.77,2.84,2.91,2.97,3.11,3.52,3.74,3.87,3.95,
 4.06,4.35,4.53,4.86,5.19,5.66,5.99,6.56,7.29,7.96,
 8.68,9.28,9.91,10.45,10.91,12.61,14.23,16.54,19.28,22.17,
 28.40,35.64};
static float alpha05_nx064_nz09_fwhm175[32] = {
 3.35,3.67,3.84,4.00,4.40,4.66,4.99,5.50,5.84,6.08,
 6.39,6.68,6.90,7.65,8.24,8.89,9.68,10.43,11.78,13.07,
 14.36,15.50,16.49,17.61,18.71,21.74,24.77,28.82,33.88,39.19,
 51.10,64.54};
static float alpha05_nx064_nz09_fwhm200[32] = {
 4.74,5.07,5.52,5.94,6.52,6.88,7.65,8.20,8.77,9.22,
 9.74,10.10,10.54,11.59,12.52,13.78,15.15,16.38,18.59,20.57,
 22.55,24.35,26.09,27.55,29.31,34.52,39.31,45.64,54.23,62.83,
 82.34,105.00};
static float alpha05_nx064_nz09_fwhm225[32] = {
 6.63,7.18,7.78,8.42,9.02,9.67,10.69,11.51,12.25,12.91,
 13.64,14.32,14.88,16.42,17.87,19.61,21.39,23.06,26.41,29.28,
 32.22,34.64,37.17,39.38,41.82,48.93,55.93,65.08,77.34,90.20,
 116.45,147.69};
static float alpha05_nx064_nz09_fwhm250[32] = {
 8.55,9.24,9.98,10.84,11.76,12.54,13.87,14.95,16.05,16.95,
 17.71,18.55,19.29,21.43,23.24,25.47,28.03,30.24,34.54,38.34,
 42.04,45.41,48.80,52.22,55.24,65.19,74.26,86.74,102.04,118.47,
 154.33,194.09};
static float alpha05_nx064_nz09_fwhm275[32] = {
 10.28,11.33,12.14,13.22,14.29,15.29,16.85,18.28,19.61,20.84,
 21.85,22.77,23.75,26.46,28.68,31.71,34.91,37.86,43.25,48.20,
 52.66,57.50,61.58,65.95,70.32,81.64,93.13,108.94,127.70,148.31,
 191.06,240.43};
static float alpha05_nx064_nz09_fwhm300[32] = {
 11.90,13.21,14.20,15.50,16.78,17.90,20.00,21.73,23.45,25.00,
 26.43,27.71,28.83,31.95,34.87,38.59,42.57,46.02,52.22,58.33,
 64.05,69.73,75.04,80.00,84.05,99.65,113.12,130.93,154.80,179.43,
 234.00,291.08};
static float alpha05_nx064_nz09_fwhm325[32] = {
 13.61,15.04,16.30,17.68,19.21,20.68,23.27,25.41,27.49,29.28,
 30.83,32.21,33.62,37.51,41.39,45.21,49.70,53.70,61.50,69.00,
 75.40,82.06,88.15,94.28,100.50,116.16,133.04,155.44,182.33,211.44,
 275.14,341.50};
static float alpha05_nx064_nz09_fwhm350[32] = {
 15.00,16.61,17.96,19.71,21.69,23.41,26.54,28.95,31.25,33.26,
 35.25,36.82,38.57,43.12,46.88,51.45,56.76,61.81,71.33,79.33,
 87.08,95.22,101.71,108.18,115.50,135.44,153.70,179.00,212.62,248.67,
 317.71,392.00};
static float alpha05_nx064_nz09_fwhm375[32] = {
 16.30,18.20,19.89,21.88,24.07,26.20,29.51,32.29,34.78,37.14,
 39.17,41.39,43.14,47.96,52.49,57.80,64.48,69.97,80.59,89.95,
 98.96,107.38,115.62,124.06,132.28,154.38,176.47,207.06,244.40,283.22,
 358.62,445.50};
static float alpha05_nx064_nz09_fwhm400[32] = {
 17.56,19.64,21.63,23.89,26.30,28.58,32.37,35.32,38.12,40.82,
 43.28,45.46,47.42,52.98,57.95,64.07,71.70,78.05,90.21,101.32,
 111.36,122.00,131.21,139.88,148.21,174.32,200.89,232.38,275.22,317.08,
 403.17,492.40};
static float alpha05_nx064_nz09_fwhm425[32] = {
 18.42,20.96,22.96,25.58,28.28,30.83,34.98,38.50,41.79,44.63,
 47.17,49.40,51.48,58.11,63.75,71.00,78.78,87.18,100.58,113.07,
 124.71,135.71,145.94,157.25,166.56,194.00,224.00,259.90,305.30,352.27,
 448.57,547.00};
static float alpha05_nx064_nz09_fwhm450[32] = {
 18.85,21.60,24.15,26.83,29.87,32.75,36.89,41.06,44.40,47.51,
 50.37,53.16,55.66,63.31,69.71,78.21,88.04,95.88,111.21,124.84,
 137.62,148.93,160.09,173.30,184.43,215.62,248.00,287.67,337.89,390.22,
 492.33,599.83};
static float alpha05_nx064_nz09_fwhm475[32] = {
 19.38,22.49,25.17,28.03,31.27,34.35,38.94,43.65,47.40,50.81,
 54.17,57.21,60.57,68.94,76.63,85.75,95.50,104.83,121.68,136.40,
 151.28,164.44,177.60,189.94,201.88,240.00,273.57,317.73,368.67,427.00,
 535.67,655.71};
static float alpha05_nx064_nz09_fwhm500[32] = {
 19.48,22.76,25.62,28.67,32.49,35.88,41.22,45.88,50.41,54.38,
 58.06,61.54,65.08,74.38,82.47,91.81,103.44,113.80,131.67,148.33,
 163.73,178.60,193.86,207.25,220.33,260.00,296.71,344.33,403.44,465.43,
 581.00,709.80};
static float *alpha05_nx064_nz09[21] = {
 alpha05_nx064_nz09_fwhm000, alpha05_nx064_nz09_fwhm025, alpha05_nx064_nz09_fwhm050, 
 alpha05_nx064_nz09_fwhm075, alpha05_nx064_nz09_fwhm100, alpha05_nx064_nz09_fwhm125, 
 alpha05_nx064_nz09_fwhm150, alpha05_nx064_nz09_fwhm175, alpha05_nx064_nz09_fwhm200, 
 alpha05_nx064_nz09_fwhm225, alpha05_nx064_nz09_fwhm250, alpha05_nx064_nz09_fwhm275, 
 alpha05_nx064_nz09_fwhm300, alpha05_nx064_nz09_fwhm325, alpha05_nx064_nz09_fwhm350, 
 alpha05_nx064_nz09_fwhm375, alpha05_nx064_nz09_fwhm400, alpha05_nx064_nz09_fwhm425, 
 alpha05_nx064_nz09_fwhm450, alpha05_nx064_nz09_fwhm475, alpha05_nx064_nz09_fwhm500} ;

static float alpha10_nx064_nz09_fwhm000[32] = {
 1.90,1.90,1.90,1.90,1.90,1.91,1.91,1.92,1.93,1.93,
 1.94,1.96,1.97,2.20,2.45,2.63,2.75,2.82,2.89,2.94,
 2.98,3.21,3.46,3.62,3.73,3.90,4.18,4.69,4.97,5.61,
 6.53,7.49};
static float alpha10_nx064_nz09_fwhm025[32] = {
 1.90,1.90,1.90,1.90,1.90,1.91,1.91,1.92,1.93,1.93,
 1.94,1.96,1.97,2.20,2.45,2.63,2.75,2.82,2.89,2.94,
 2.98,3.21,3.46,3.62,3.73,3.90,4.18,4.69,4.97,5.61,
 6.53,7.49};
static float alpha10_nx064_nz09_fwhm050[32] = {
 1.90,1.90,1.90,1.90,1.91,1.91,1.91,1.92,1.93,1.94,
 1.95,1.97,1.98,2.27,2.50,2.67,2.78,2.84,2.91,2.95,
 2.99,3.32,3.54,3.68,3.77,3.94,4.31,4.76,5.10,5.71,
 6.69,7.67};
static float alpha10_nx064_nz09_fwhm075[32] = {
 1.90,1.90,1.90,1.91,1.91,1.91,1.92,1.93,1.95,1.97,
 1.99,2.11,2.25,2.54,2.68,2.78,2.85,2.90,2.96,3.13,
 3.46,3.65,3.77,3.85,3.91,4.35,4.74,5.00,5.74,6.23,
 7.41,8.64};
static float alpha10_nx064_nz09_fwhm100[32] = {
 1.90,1.91,1.91,1.92,1.93,1.94,1.97,2.00,2.27,2.43,
 2.55,2.63,2.69,2.80,2.86,2.92,2.97,3.10,3.57,3.77,
 3.89,3.99,4.30,4.56,4.73,5.07,5.70,6.28,6.96,7.80,
 9.47,11.26};
static float alpha10_nx064_nz09_fwhm125[32] = {
 1.92,1.94,1.96,1.98,2.15,2.35,2.58,2.71,2.78,2.84,
 2.88,2.91,2.94,3.07,3.40,3.66,3.83,3.95,4.50,4.81,
 5.01,5.46,5.75,5.96,6.31,6.99,7.88,8.94,10.29,11.67,
 14.41,17.71};
static float alpha10_nx064_nz09_fwhm150[32] = {
 2.19,2.44,2.58,2.71,2.81,2.88,2.98,3.28,3.51,3.66,
 3.77,3.87,3.94,4.40,4.72,4.97,5.49,5.84,6.59,7.17,
 7.78,8.34,8.88,9.43,9.93,11.41,12.91,14.89,17.46,20.01,
 25.57,31.92};
static float alpha10_nx064_nz09_fwhm175[32] = {
 2.86,2.98,3.26,3.54,3.78,3.96,4.44,4.76,4.97,5.32,
 5.58,5.80,5.97,6.68,7.18,7.85,8.59,9.24,10.47,11.59,
 12.73,13.75,14.68,15.66,16.57,19.45,22.12,25.76,30.28,34.90,
 45.25,57.40};
static float alpha10_nx064_nz09_fwhm200[32] = {
 3.90,4.30,4.63,4.93,5.43,5.80,6.49,6.96,7.50,7.93,
 8.38,8.71,8.99,9.97,10.86,11.94,13.15,14.21,16.28,18.14,
 19.82,21.46,22.99,24.53,25.91,30.55,34.90,40.51,47.81,55.30,
 72.36,92.22};
static float alpha10_nx064_nz09_fwhm225[32] = {
 5.26,5.80,6.34,6.90,7.54,8.03,8.89,9.68,10.33,10.94,
 11.56,12.07,12.64,14.10,15.34,16.86,18.62,20.12,22.96,25.61,
 28.01,30.32,32.58,34.76,37.02,42.96,48.93,57.15,67.80,78.78,
 103.11,130.36};
static float alpha10_nx064_nz09_fwhm250[32] = {
 6.75,7.45,8.04,8.77,9.56,10.27,11.37,12.44,13.39,14.26,
 15.05,15.76,16.57,18.42,20.02,21.99,24.26,26.20,30.03,33.37,
 36.60,39.75,42.46,45.30,48.27,56.58,64.57,75.47,90.06,104.20,
 134.95,168.69};
static float alpha10_nx064_nz09_fwhm275[32] = {
 7.97,8.89,9.70,10.63,11.64,12.48,14.03,15.45,16.55,17.59,
 18.61,19.38,20.11,22.51,24.65,27.31,30.20,32.77,37.31,41.60,
 45.56,49.40,53.18,56.75,60.41,70.72,80.95,94.81,111.50,129.07,
 166.86,211.05};
static float alpha10_nx064_nz09_fwhm300[32] = {
 9.25,10.30,11.28,12.42,13.60,14.67,16.45,18.00,19.35,20.69,
 21.89,23.03,23.98,26.91,29.42,32.70,35.95,38.92,44.44,49.78,
 54.63,59.40,63.75,68.12,72.74,85.40,97.74,113.78,134.17,155.46,
 201.65,251.47};
static float alpha10_nx064_nz09_fwhm325[32] = {
 10.31,11.58,12.66,13.95,15.39,16.70,18.89,20.56,22.27,23.88,
 25.27,26.58,27.86,31.12,34.00,37.64,41.69,45.42,51.97,58.08,
 63.86,69.72,75.25,80.57,85.29,100.07,114.54,134.00,158.00,182.35,
 236.14,296.90};
static float alpha10_nx064_nz09_fwhm350[32] = {
 11.11,12.60,13.96,15.49,17.07,18.57,21.00,23.28,25.13,26.94,
 28.69,30.01,31.34,35.22,38.62,42.72,47.43,51.53,59.64,66.75,
 73.59,80.15,86.31,92.43,98.18,115.49,131.85,154.24,181.52,210.41,
 271.19,339.38};
static float alpha10_nx064_nz09_fwhm375[32] = {
 11.83,13.63,15.21,16.77,18.56,20.13,23.14,25.50,27.67,29.60,
 31.41,33.08,34.59,39.09,43.02,47.72,53.06,58.26,67.25,75.33,
 83.35,91.00,97.60,104.61,111.62,130.41,150.10,175.16,206.90,239.80,
 309.20,382.15};
static float alpha10_nx064_nz09_fwhm400[32] = {
 12.39,14.27,16.00,17.75,19.71,21.55,24.61,27.48,30.02,32.19,
 34.32,36.00,37.88,43.27,47.61,53.02,59.15,64.69,74.98,84.38,
 93.42,101.54,109.21,117.03,124.33,146.62,168.24,195.53,232.39,268.79,
 345.47,423.22};
static float alpha10_nx064_nz09_fwhm425[32] = {
 12.61,14.67,16.38,18.43,20.61,22.73,26.48,29.50,32.13,34.66,
 37.03,39.36,41.37,47.23,52.08,58.10,64.75,71.36,82.86,93.26,
 103.08,111.73,120.88,129.62,138.44,163.06,186.41,217.71,259.15,300.30,
 382.78,469.60};
static float alpha10_nx064_nz09_fwhm450[32] = {
 12.62,14.79,16.79,19.10,21.66,23.88,27.67,31.15,34.07,37.08,
 39.66,42.02,44.27,50.70,56.13,62.90,70.55,77.57,89.57,101.12,
 112.25,122.48,132.54,142.05,152.38,179.05,206.00,241.31,286.58,331.09,
 420.70,512.17};
static float alpha10_nx064_nz09_fwhm475[32] = {
 12.62,14.83,16.98,19.39,22.12,24.62,28.92,32.67,36.03,39.16,
 41.73,44.60,47.12,54.12,59.94,67.41,75.78,83.44,97.32,109.41,
 121.76,133.57,144.71,155.80,165.56,196.46,226.12,264.60,312.92,361.08,
 457.10,557.25};
static float alpha10_nx064_nz09_fwhm500[32] = {
 12.62,14.83,16.98,19.52,22.65,25.19,29.87,33.98,37.72,40.82,
 43.86,46.68,49.39,56.86,63.44,71.26,81.07,89.25,104.58,117.74,
 131.75,144.00,156.73,167.61,179.47,213.86,246.00,287.85,341.27,390.53,
 494.75,603.33};
static float *alpha10_nx064_nz09[21] = {
 alpha10_nx064_nz09_fwhm000, alpha10_nx064_nz09_fwhm025, alpha10_nx064_nz09_fwhm050, 
 alpha10_nx064_nz09_fwhm075, alpha10_nx064_nz09_fwhm100, alpha10_nx064_nz09_fwhm125, 
 alpha10_nx064_nz09_fwhm150, alpha10_nx064_nz09_fwhm175, alpha10_nx064_nz09_fwhm200, 
 alpha10_nx064_nz09_fwhm225, alpha10_nx064_nz09_fwhm250, alpha10_nx064_nz09_fwhm275, 
 alpha10_nx064_nz09_fwhm300, alpha10_nx064_nz09_fwhm325, alpha10_nx064_nz09_fwhm350, 
 alpha10_nx064_nz09_fwhm375, alpha10_nx064_nz09_fwhm400, alpha10_nx064_nz09_fwhm425, 
 alpha10_nx064_nz09_fwhm450, alpha10_nx064_nz09_fwhm475, alpha10_nx064_nz09_fwhm500} ;

static float **nx064_nz09[3] = {
  alpha01_nx064_nz09 , alpha05_nx064_nz09 , alpha10_nx064_nz09 };

static float alpha01_nx064_nz10_fwhm000[32] = {
 1.99,1.99,1.99,1.99,2.00,2.00,2.36,2.59,2.70,2.78,
 2.83,2.86,2.89,2.93,2.96,2.98,2.99,3.13,3.64,3.83,
 3.91,3.97,4.00,4.30,4.53,4.89,5.16,5.80,6.44,6.98,
 8.28,9.49};
static float alpha01_nx064_nz10_fwhm025[32] = {
 1.99,1.99,1.99,1.99,2.00,2.00,2.36,2.59,2.70,2.78,
 2.83,2.86,2.89,2.93,2.96,2.98,2.99,3.13,3.64,3.83,
 3.91,3.97,4.00,4.30,4.53,4.89,5.16,5.80,6.44,6.98,
 8.28,9.49};
static float alpha01_nx064_nz10_fwhm050[32] = {
 1.99,1.99,1.99,2.00,2.00,2.07,2.43,2.63,2.73,2.80,
 2.85,2.88,2.90,2.94,2.96,2.98,3.00,3.29,3.69,3.85,
 3.94,3.98,4.11,4.45,4.65,4.94,5.36,5.87,6.58,7.17,
 8.56,9.76};
static float alpha01_nx064_nz10_fwhm075[32] = {
 1.99,1.99,2.00,2.00,2.26,2.45,2.66,2.78,2.84,2.88,
 2.91,2.93,2.94,2.97,2.99,3.06,3.49,3.69,3.89,3.96,
 4.05,4.47,4.69,4.82,4.92,5.44,5.85,6.50,7.27,7.95,
 9.50,11.11};
static float alpha01_nx064_nz10_fwhm100[32] = {
 2.00,2.17,2.42,2.60,2.72,2.80,2.88,2.92,2.95,2.96,
 2.98,2.99,3.00,3.45,3.69,3.82,3.92,3.98,4.47,4.77,
 4.94,5.14,5.54,5.77,5.90,6.62,7.22,7.99,9.18,10.13,
 12.44,14.57};
static float alpha01_nx064_nz10_fwhm125[32] = {
 2.71,2.81,2.87,2.92,2.95,2.97,3.03,3.40,3.60,3.74,
 3.83,3.88,3.92,4.13,4.53,4.79,4.96,5.36,5.85,6.42,
 6.87,7.28,7.67,7.96,8.46,9.55,10.52,11.97,13.67,15.53,
 19.36,23.63};
static float alpha01_nx064_nz10_fwhm150[32] = {
 2.99,3.37,3.60,3.80,3.91,3.98,4.36,4.69,4.84,4.96,
 5.23,5.50,5.68,6.01,6.60,7.00,7.74,8.19,9.00,9.86,
 10.72,11.48,12.02,13.04,13.93,16.00,17.98,20.50,24.03,28.00,
 35.62,44.62};
static float alpha01_nx064_nz10_fwhm175[32] = {
 4.71,4.90,5.12,5.60,5.94,6.37,6.93,7.34,7.72,8.09,
 8.47,8.74,8.97,9.95,10.70,11.48,12.58,13.49,15.35,16.88,
 18.06,19.41,20.75,22.04,23.76,27.29,31.00,36.33,42.95,49.90,
 65.00,84.12};
static float alpha01_nx064_nz10_fwhm200[32] = {
 6.96,7.52,7.92,8.54,9.07,9.66,10.51,11.08,11.90,12.57,
 12.94,13.49,13.89,15.04,16.43,17.95,19.57,20.98,24.23,26.92,
 29.35,31.69,33.70,36.23,38.20,44.50,51.67,60.07,70.08,82.08,
 109.14,142.43};
static float alpha01_nx064_nz10_fwhm225[32] = {
 9.84,10.52,11.00,11.91,12.68,13.56,14.86,15.95,16.82,17.82,
 18.70,19.62,20.33,22.30,24.14,26.36,28.53,30.85,35.35,38.86,
 42.73,45.85,49.12,52.65,55.60,65.43,74.27,86.67,103.38,119.86,
 158.33,203.00};
static float alpha01_nx064_nz10_fwhm250[32] = {
 12.90,14.00,14.74,15.95,17.12,18.17,19.96,21.24,22.56,23.85,
 25.08,26.19,26.93,30.29,32.58,35.50,39.00,41.47,47.21,52.53,
 57.53,62.08,65.93,71.00,75.00,85.75,98.11,116.78,139.33,162.00,
 212.33,264.50};
static float alpha01_nx064_nz10_fwhm275[32] = {
 16.09,17.64,18.68,19.83,20.95,22.71,25.18,27.12,29.16,31.04,
 32.61,33.68,34.76,38.05,41.06,44.38,49.14,53.42,60.33,67.25,
 72.60,79.11,83.62,89.10,94.45,110.50,126.83,149.00,176.12,205.75,
 273.00,332.67};
static float alpha01_nx064_nz10_fwhm300[32] = {
 19.65,21.12,22.29,24.41,26.33,27.86,30.76,33.19,34.90,36.75,
 39.05,40.38,42.08,46.10,50.00,54.64,59.54,64.42,73.25,79.85,
 87.89,94.67,101.50,107.00,115.00,134.25,155.50,183.14,217.00,251.00,
 323.00,401.00};
static float alpha01_nx064_nz10_fwhm325[32] = {
 23.13,24.91,26.83,29.00,30.94,32.95,36.08,39.27,41.38,43.42,
 45.18,47.36,49.47,54.57,59.00,64.50,69.92,75.50,85.78,95.73,
 103.50,112.69,121.17,129.20,137.33,162.33,190.00,219.17,254.00,292.75,
 383.00,474.00};
static float alpha01_nx064_nz10_fwhm350[32] = {
 26.23,28.94,31.07,33.08,35.33,37.55,40.91,44.62,47.73,50.33,
 53.00,55.09,56.92,63.36,68.43,74.50,82.50,89.33,100.67,113.40,
 122.33,132.50,143.29,155.17,162.83,191.33,217.67,250.33,293.00,340.00,
 445.00,552.00};
static float alpha01_nx064_nz10_fwhm375[32] = {
 30.09,32.86,34.85,37.11,39.94,42.70,47.27,51.20,55.27,57.38,
 60.00,62.73,65.00,72.40,77.92,86.43,95.25,103.57,116.60,129.80,
 142.88,154.50,164.67,176.50,186.50,217.40,248.00,289.00,334.00,393.00,
 509.00,624.50};
static float alpha01_nx064_nz10_fwhm400[32] = {
 33.45,36.00,37.90,41.31,45.31,48.38,53.50,57.62,61.17,64.56,
 67.75,70.50,73.00,81.83,89.29,98.00,108.17,116.62,133.00,148.00,
 162.00,176.33,187.00,199.33,209.50,247.50,284.00,327.00,390.00,450.00,
 570.00,696.00};
static float alpha01_nx064_nz10_fwhm425[32] = {
 36.08,39.17,42.23,46.08,50.08,53.57,59.17,63.75,66.92,71.67,
 75.12,78.60,81.92,91.30,99.20,109.17,121.00,131.22,149.67,167.00,
 180.33,196.00,209.50,225.33,236.00,279.00,315.33,371.00,435.50,495.67,
 631.00,764.50};
static float alpha01_nx064_nz10_fwhm450[32] = {
 39.12,42.90,46.11,49.73,54.67,58.44,64.62,69.46,74.89,78.89,
 83.40,87.57,91.00,101.25,109.67,120.20,134.00,144.71,163.50,182.50,
 202.33,218.00,233.33,248.00,262.33,308.00,353.33,410.00,478.00,550.33,
 691.50,844.00};
static float alpha01_nx064_nz10_fwhm475[32] = {
 42.40,46.00,50.12,54.20,58.44,62.75,70.20,76.25,81.50,87.50,
 91.75,96.20,102.00,110.25,118.86,132.67,146.20,158.00,181.00,203.00,
 222.33,239.60,256.75,276.00,292.00,341.75,391.33,449.00,524.00,606.00,
 763.50,922.00};
static float alpha01_nx064_nz10_fwhm500[32] = {
 45.60,49.50,53.25,57.57,62.88,67.89,75.50,82.75,90.00,94.40,
 99.75,104.12,106.90,118.50,129.00,143.50,160.17,173.00,197.33,222.00,
 245.00,261.00,282.50,303.00,317.67,377.00,427.33,494.50,571.67,662.00,
 820.00,992.50};
static float *alpha01_nx064_nz10[21] = {
 alpha01_nx064_nz10_fwhm000, alpha01_nx064_nz10_fwhm025, alpha01_nx064_nz10_fwhm050, 
 alpha01_nx064_nz10_fwhm075, alpha01_nx064_nz10_fwhm100, alpha01_nx064_nz10_fwhm125, 
 alpha01_nx064_nz10_fwhm150, alpha01_nx064_nz10_fwhm175, alpha01_nx064_nz10_fwhm200, 
 alpha01_nx064_nz10_fwhm225, alpha01_nx064_nz10_fwhm250, alpha01_nx064_nz10_fwhm275, 
 alpha01_nx064_nz10_fwhm300, alpha01_nx064_nz10_fwhm325, alpha01_nx064_nz10_fwhm350, 
 alpha01_nx064_nz10_fwhm375, alpha01_nx064_nz10_fwhm400, alpha01_nx064_nz10_fwhm425, 
 alpha01_nx064_nz10_fwhm450, alpha01_nx064_nz10_fwhm475, alpha01_nx064_nz10_fwhm500} ;

static float alpha05_nx064_nz10_fwhm000[32] = {
 1.95,1.95,1.95,1.95,1.96,1.96,1.97,1.97,1.98,1.99,
 2.15,2.32,2.44,2.65,2.77,2.84,2.90,2.93,2.97,3.02,
 3.45,3.65,3.78,3.85,3.91,4.10,4.65,4.93,5.56,5.95,
 6.99,8.07};
static float alpha05_nx064_nz10_fwhm025[32] = {
 1.95,1.95,1.95,1.95,1.96,1.96,1.97,1.97,1.98,1.99,
 2.15,2.32,2.44,2.65,2.77,2.84,2.90,2.93,2.97,3.02,
 3.45,3.65,3.78,3.85,3.91,4.10,4.65,4.93,5.56,5.95,
 6.99,8.07};
static float alpha05_nx064_nz10_fwhm050[32] = {
 1.95,1.95,1.95,1.95,1.96,1.96,1.97,1.98,1.99,2.00,
 2.25,2.39,2.50,2.69,2.79,2.86,2.91,2.94,2.97,3.16,
 3.53,3.71,3.81,3.88,3.93,4.29,4.72,4.98,5.67,6.04,
 7.26,8.40};
static float alpha05_nx064_nz10_fwhm075[32] = {
 1.95,1.95,1.96,1.96,1.96,1.97,1.98,1.99,2.20,2.41,
 2.53,2.62,2.68,2.80,2.87,2.91,2.95,2.97,3.28,3.62,
 3.78,3.87,3.94,3.98,4.17,4.75,4.97,5.63,6.09,6.85,
 8.01,9.46};
static float alpha05_nx064_nz10_fwhm100[32] = {
 1.96,1.96,1.97,1.97,1.98,2.00,2.37,2.57,2.68,2.76,
 2.81,2.84,2.87,2.93,2.96,3.00,3.38,3.62,3.84,3.95,
 4.21,4.55,4.75,4.88,4.98,5.69,6.06,6.89,7.79,8.67,
 10.49,12.40};
static float alpha05_nx064_nz10_fwhm125[32] = {
 1.98,2.00,2.26,2.47,2.62,2.72,2.83,2.89,2.93,2.96,
 2.99,3.11,3.30,3.63,3.79,3.92,4.13,4.51,4.88,5.25,
 5.71,5.93,6.33,6.70,6.94,7.89,8.84,9.95,11.47,12.89,
 15.99,19.52};
static float alpha05_nx064_nz10_fwhm150[32] = {
 2.66,2.79,2.86,2.93,2.99,3.24,3.57,3.76,3.89,3.98,
 4.18,4.40,4.58,4.90,5.26,5.70,6.13,6.64,7.42,8.09,
 8.78,9.43,9.96,10.64,11.12,12.89,14.50,16.73,19.52,22.48,
 28.81,36.03};
static float alpha05_nx064_nz10_fwhm175[32] = {
 3.39,3.69,3.89,4.17,4.54,4.75,5.12,5.61,5.91,6.22,
 6.57,6.81,6.98,7.78,8.38,9.10,9.91,10.73,12.04,13.30,
 14.47,15.69,16.67,17.77,18.77,21.92,25.08,29.14,34.69,40.14,
 52.27,67.12};
static float alpha05_nx064_nz10_fwhm200[32] = {
 4.85,5.35,5.76,6.20,6.71,7.09,7.84,8.43,8.89,9.47,
 9.93,10.38,10.77,11.80,12.78,13.94,15.32,16.52,18.82,20.66,
 22.61,24.55,26.43,28.24,29.94,34.97,40.26,47.38,55.75,64.91,
 85.32,110.15};
static float alpha05_nx064_nz10_fwhm225[32] = {
 6.79,7.42,7.93,8.54,9.24,9.82,10.81,11.71,12.55,13.26,
 13.85,14.45,14.97,16.57,18.05,19.74,21.56,23.38,26.57,29.89,
 32.67,35.41,38.20,40.66,43.19,51.00,57.80,67.33,79.97,94.27,
 124.00,157.33};
static float alpha05_nx064_nz10_fwhm250[32] = {
 8.64,9.45,10.13,10.96,11.84,12.67,13.98,15.17,16.21,17.20,
 18.12,18.90,19.62,21.72,23.69,26.09,28.71,31.21,35.58,39.55,
 43.65,47.48,50.79,53.94,57.26,66.59,76.30,89.64,106.75,124.06,
 162.60,204.81};
static float alpha05_nx064_nz10_fwhm275[32] = {
 10.47,11.53,12.44,13.46,14.50,15.51,17.29,18.84,20.10,21.45,
 22.60,23.70,24.75,27.33,29.65,32.90,35.92,39.34,45.12,49.90,
 54.81,59.07,63.23,67.39,71.50,84.32,97.13,113.08,133.70,156.00,
 203.70,256.80};
static float alpha05_nx064_nz10_fwhm300[32] = {
 12.30,13.61,14.72,15.99,17.36,18.61,20.95,22.67,24.22,25.68,
 27.10,28.37,29.69,33.02,36.04,39.65,43.65,47.42,54.16,60.39,
 65.82,71.26,77.10,81.96,87.33,102.39,117.06,136.18,162.68,190.64,
 245.26,310.00};
static float alpha05_nx064_nz10_fwhm325[32] = {
 14.26,15.77,16.97,18.62,20.29,21.76,24.02,26.36,28.41,30.28,
 31.89,33.40,34.91,38.84,42.56,46.77,51.55,55.70,63.95,71.17,
 78.16,84.61,91.03,97.25,103.73,120.77,138.82,163.54,193.38,224.46,
 289.29,362.64};
static float alpha05_nx064_nz10_fwhm350[32] = {
 16.03,17.69,19.16,20.94,22.99,24.59,27.66,30.41,32.56,34.75,
 36.67,38.32,40.17,44.96,48.88,53.86,59.47,64.42,73.96,82.48,
 90.77,98.36,105.55,112.90,119.88,141.19,162.14,188.27,222.87,258.50,
 333.90,414.75};
static float alpha05_nx064_nz10_fwhm375[32] = {
 17.43,19.49,21.17,23.44,25.76,27.78,31.25,34.12,36.87,39.25,
 41.38,43.14,45.32,50.75,55.49,61.10,67.50,73.54,84.14,94.05,
 103.60,111.96,120.53,128.73,136.53,161.40,184.62,214.86,255.50,294.85,
 380.22,475.00};
static float alpha05_nx064_nz10_fwhm400[32] = {
 18.85,21.20,23.20,25.63,28.14,30.46,34.68,37.80,40.78,43.41,
 46.09,48.27,50.32,56.46,62.12,68.23,75.64,82.52,94.44,105.26,
 115.12,125.36,135.29,145.75,155.71,182.00,208.50,243.38,289.67,329.12,
 426.00,529.00};
static float alpha05_nx064_nz10_fwhm425[32] = {
 20.31,22.75,25.15,27.66,30.68,32.94,37.42,41.08,44.33,47.49,
 50.30,52.85,55.21,62.27,68.30,75.12,83.39,90.81,104.76,116.65,
 128.54,140.54,151.21,162.47,172.45,202.45,232.68,273.80,320.80,368.83,
 473.40,590.33};
static float alpha05_nx064_nz10_fwhm450[32] = {
 21.12,24.18,26.60,29.79,32.97,35.51,39.86,44.22,47.79,51.52,
 54.28,57.62,60.16,67.53,74.15,82.39,91.68,99.86,114.42,128.92,
 142.29,155.73,168.23,180.00,191.14,225.73,260.00,302.88,355.20,410.00,
 524.57,649.17};
static float alpha05_nx064_nz10_fwhm475[32] = {
 22.03,25.46,28.22,31.61,35.00,37.86,42.58,47.21,51.06,55.16,
 58.49,61.77,64.55,72.67,80.32,89.56,98.79,107.93,125.94,141.67,
 157.07,171.20,185.11,198.50,211.00,249.10,286.20,333.20,390.62,453.00,
 578.17,703.12};
static float alpha05_nx064_nz10_fwhm500[32] = {
 22.94,26.38,29.50,32.85,36.26,39.46,45.38,50.08,54.71,58.57,
 62.04,65.44,69.09,77.96,86.75,95.95,107.33,116.87,136.85,155.60,
 172.70,187.46,202.38,215.83,229.82,271.00,312.29,363.10,430.43,494.75,
 623.67,759.00};
static float *alpha05_nx064_nz10[21] = {
 alpha05_nx064_nz10_fwhm000, alpha05_nx064_nz10_fwhm025, alpha05_nx064_nz10_fwhm050, 
 alpha05_nx064_nz10_fwhm075, alpha05_nx064_nz10_fwhm100, alpha05_nx064_nz10_fwhm125, 
 alpha05_nx064_nz10_fwhm150, alpha05_nx064_nz10_fwhm175, alpha05_nx064_nz10_fwhm200, 
 alpha05_nx064_nz10_fwhm225, alpha05_nx064_nz10_fwhm250, alpha05_nx064_nz10_fwhm275, 
 alpha05_nx064_nz10_fwhm300, alpha05_nx064_nz10_fwhm325, alpha05_nx064_nz10_fwhm350, 
 alpha05_nx064_nz10_fwhm375, alpha05_nx064_nz10_fwhm400, alpha05_nx064_nz10_fwhm425, 
 alpha05_nx064_nz10_fwhm450, alpha05_nx064_nz10_fwhm475, alpha05_nx064_nz10_fwhm500} ;

static float alpha10_nx064_nz10_fwhm000[32] = {
 1.90,1.90,1.90,1.90,1.91,1.91,1.91,1.92,1.93,1.94,
 1.96,1.97,1.99,2.30,2.52,2.68,2.78,2.84,2.90,2.94,
 2.99,3.26,3.50,3.65,3.75,3.91,4.19,4.71,4.99,5.65,
 6.61,7.59};
static float alpha10_nx064_nz10_fwhm025[32] = {
 1.90,1.90,1.90,1.90,1.91,1.91,1.91,1.92,1.93,1.94,
 1.96,1.97,1.99,2.30,2.52,2.68,2.78,2.84,2.90,2.94,
 2.99,3.26,3.50,3.65,3.75,3.91,4.19,4.71,4.99,5.65,
 6.61,7.59};
static float alpha10_nx064_nz10_fwhm050[32] = {
 1.90,1.90,1.90,1.90,1.91,1.91,1.92,1.92,1.93,1.95,
 1.96,1.98,2.00,2.37,2.56,2.71,2.80,2.85,2.91,2.95,
 3.02,3.36,3.58,3.70,3.78,3.94,4.33,4.79,5.15,5.75,
 6.75,7.78};
static float alpha10_nx064_nz10_fwhm075[32] = {
 1.90,1.90,1.91,1.91,1.91,1.92,1.93,1.94,1.96,1.98,
 2.06,2.23,2.36,2.59,2.71,2.80,2.86,2.90,2.96,3.18,
 3.50,3.67,3.79,3.86,3.92,4.36,4.76,5.08,5.77,6.34,
 7.53,8.74};
static float alpha10_nx064_nz10_fwhm100[32] = {
 1.90,1.91,1.92,1.92,1.93,1.95,1.98,2.13,2.35,2.50,
 2.60,2.66,2.72,2.82,2.88,2.92,2.97,3.17,3.60,3.79,
 3.91,3.99,4.35,4.59,4.75,5.17,5.74,6.38,7.11,7.91,
 9.61,11.42};
static float alpha10_nx064_nz10_fwhm125[32] = {
 1.93,1.94,1.96,1.99,2.22,2.41,2.62,2.74,2.80,2.85,
 2.90,2.92,2.95,3.16,3.46,3.70,3.86,3.97,4.52,4.83,
 5.10,5.52,5.79,5.99,6.41,7.19,8.00,9.03,10.47,11.78,
 14.67,17.88};
static float alpha10_nx064_nz10_fwhm150[32] = {
 2.24,2.50,2.63,2.75,2.84,2.90,2.99,3.33,3.55,3.71,
 3.81,3.89,3.97,4.46,4.75,4.98,5.56,5.88,6.67,7.28,
 7.89,8.50,8.98,9.62,10.08,11.67,13.07,15.07,17.64,20.31,
 25.94,32.48};
static float alpha10_nx064_nz10_fwhm175[32] = {
 2.88,3.00,3.33,3.64,3.87,4.03,4.54,4.83,5.05,5.44,
 5.72,5.92,6.16,6.82,7.38,7.99,8.79,9.51,10.73,11.83,
 12.88,13.95,14.87,15.89,16.72,19.56,22.50,25.92,30.85,35.91,
 46.77,59.80};
static float alpha10_nx064_nz10_fwhm200[32] = {
 4.00,4.44,4.77,5.16,5.63,5.99,6.66,7.19,7.73,8.14,
 8.61,8.95,9.32,10.29,11.18,12.22,13.43,14.52,16.54,18.27,
 19.97,21.75,23.42,24.82,26.47,30.86,35.48,41.56,49.38,57.79,
 75.54,96.48};
static float alpha10_nx064_nz10_fwhm225[32] = {
 5.38,5.97,6.51,7.04,7.73,8.27,9.15,9.90,10.67,11.30,
 11.86,12.44,12.91,14.30,15.63,17.20,18.82,20.36,23.29,25.88,
 28.52,30.87,33.22,35.49,37.72,44.37,50.77,59.23,70.95,82.29,
 108.58,138.76};
static float alpha10_nx064_nz10_fwhm250[32] = {
 6.91,7.72,8.35,9.06,9.87,10.56,11.76,12.78,13.72,14.57,
 15.30,16.05,16.73,18.62,20.28,22.33,24.51,26.63,30.57,34.09,
 37.41,40.57,43.75,46.85,49.76,58.23,66.71,78.53,93.06,109.21,
 143.48,179.96};
static float alpha10_nx064_nz10_fwhm275[32] = {
 8.34,9.18,10.00,10.93,11.91,12.77,14.26,15.61,16.86,17.88,
 18.89,19.83,20.64,23.07,25.22,27.71,30.55,33.14,38.21,42.65,
 46.84,50.93,54.74,58.63,62.38,73.42,84.33,98.56,117.40,136.02,
 177.76,225.52};
static float alpha10_nx064_nz10_fwhm300[32] = {
 9.50,10.63,11.61,12.75,13.93,14.96,16.97,18.55,20.07,21.20,
 22.38,23.56,24.71,27.71,30.09,33.18,36.79,40.33,46.28,51.84,
 56.66,61.70,66.31,71.06,75.43,88.67,101.73,118.82,140.63,163.65,
 213.96,267.43};
static float alpha10_nx064_nz10_fwhm325[32] = {
 10.64,11.88,13.02,14.34,15.80,17.14,19.38,21.43,23.06,24.65,
 26.27,27.55,28.75,32.17,35.24,39.00,43.25,47.09,54.38,60.84,
 66.57,72.27,78.16,83.57,89.10,104.31,119.54,139.35,165.71,193.27,
 250.22,313.53};
static float alpha10_nx064_nz10_fwhm350[32] = {
 11.49,13.04,14.39,16.01,17.71,19.28,21.82,24.05,26.14,28.02,
 29.60,31.21,32.59,36.53,40.18,44.65,49.64,54.21,62.34,69.88,
 76.96,83.51,90.11,96.11,102.45,120.36,137.72,161.25,192.15,222.00,
 288.08,359.88};
static float alpha10_nx064_nz10_fwhm375[32] = {
 12.42,14.12,15.77,17.40,19.46,21.15,24.02,26.80,29.15,30.98,
 32.93,34.76,36.57,41.42,45.39,50.23,56.03,61.00,70.63,79.43,
 87.42,94.71,101.95,109.27,116.29,136.95,156.62,183.94,218.75,252.47,
 327.44,408.23};
static float alpha10_nx064_nz10_fwhm400[32] = {
 13.05,15.06,16.80,19.01,20.94,22.90,26.43,29.20,31.82,34.14,
 36.21,38.32,40.38,45.58,50.00,56.08,62.40,68.18,79.17,89.09,
 98.08,106.39,114.90,122.46,130.60,153.94,176.93,207.43,244.27,283.71,
 367.30,452.20};
static float alpha10_nx064_nz10_fwhm425[32] = {
 13.57,15.85,17.74,20.00,22.35,24.52,28.31,31.43,34.42,37.08,
 39.60,41.96,44.09,50.08,55.20,61.59,68.67,75.19,87.25,98.06,
 107.87,117.50,126.76,136.07,144.68,171.66,197.76,229.75,272.94,316.62,
 407.18,501.10};
static float alpha10_nx064_nz10_fwhm450[32] = {
 14.06,16.53,18.50,21.06,23.60,25.86,29.89,33.63,37.02,40.06,
 42.61,45.09,47.50,54.00,59.74,66.59,75.15,81.98,95.52,107.79,
 118.64,129.25,139.15,149.60,159.80,190.06,217.76,253.50,301.29,350.29,
 448.50,550.00};
static float alpha10_nx064_nz10_fwhm475[32] = {
 14.06,16.72,18.96,21.59,24.38,26.78,31.56,35.78,39.35,42.45,
 45.39,48.03,50.45,57.62,64.04,71.61,81.00,88.97,103.21,116.08,
 128.83,140.63,152.67,164.13,174.40,207.53,238.61,279.70,331.50,383.82,
 489.56,601.00};
static float alpha10_nx064_nz10_fwhm500[32] = {
 14.06,16.72,19.08,21.86,25.16,27.87,32.89,37.25,41.06,44.38,
 47.56,50.59,53.20,61.10,68.10,76.72,86.34,95.08,110.81,125.52,
 139.86,152.77,165.68,177.90,189.47,225.80,262.17,305.45,362.88,417.75,
 532.75,649.25};
static float *alpha10_nx064_nz10[21] = {
 alpha10_nx064_nz10_fwhm000, alpha10_nx064_nz10_fwhm025, alpha10_nx064_nz10_fwhm050, 
 alpha10_nx064_nz10_fwhm075, alpha10_nx064_nz10_fwhm100, alpha10_nx064_nz10_fwhm125, 
 alpha10_nx064_nz10_fwhm150, alpha10_nx064_nz10_fwhm175, alpha10_nx064_nz10_fwhm200, 
 alpha10_nx064_nz10_fwhm225, alpha10_nx064_nz10_fwhm250, alpha10_nx064_nz10_fwhm275, 
 alpha10_nx064_nz10_fwhm300, alpha10_nx064_nz10_fwhm325, alpha10_nx064_nz10_fwhm350, 
 alpha10_nx064_nz10_fwhm375, alpha10_nx064_nz10_fwhm400, alpha10_nx064_nz10_fwhm425, 
 alpha10_nx064_nz10_fwhm450, alpha10_nx064_nz10_fwhm475, alpha10_nx064_nz10_fwhm500} ;

static float **nx064_nz10[3] = {
  alpha01_nx064_nz10 , alpha05_nx064_nz10 , alpha10_nx064_nz10 };

static float alpha01_nx064_nz11_fwhm000[32] = {
 1.99,1.99,1.99,1.99,2.00,2.00,2.42,2.63,2.76,2.81,
 2.86,2.88,2.90,2.95,2.97,2.98,3.00,3.31,3.71,3.85,
 3.93,3.97,4.00,4.41,4.62,4.91,5.23,5.86,6.54,6.99,
 8.09,9.58};
static float alpha01_nx064_nz11_fwhm025[32] = {
 1.99,1.99,1.99,1.99,2.00,2.00,2.42,2.63,2.76,2.81,
 2.86,2.88,2.90,2.95,2.97,2.98,3.00,3.31,3.71,3.85,
 3.93,3.97,4.00,4.41,4.62,4.91,5.23,5.86,6.54,6.99,
 8.09,9.58};
static float alpha01_nx064_nz11_fwhm050[32] = {
 1.99,1.99,1.99,2.00,2.00,2.03,2.47,2.68,2.79,2.84,
 2.87,2.90,2.92,2.95,2.97,2.99,3.03,3.43,3.76,3.88,
 3.94,3.98,4.24,4.53,4.69,4.95,5.44,5.94,6.71,7.13,
 8.50,9.81};
static float alpha01_nx064_nz11_fwhm075[32] = {
 1.99,1.99,2.00,2.00,2.25,2.48,2.72,2.82,2.86,2.90,
 2.92,2.94,2.95,2.98,2.99,3.22,3.56,3.74,3.90,3.97,
 4.11,4.53,4.75,4.86,4.94,5.52,5.95,6.67,7.33,7.94,
 9.56,11.21};
static float alpha01_nx064_nz11_fwhm100[32] = {
 2.00,2.17,2.42,2.62,2.76,2.83,2.90,2.93,2.96,2.97,
 2.98,3.00,3.18,3.53,3.70,3.84,3.94,3.98,4.52,4.82,
 4.96,5.34,5.65,5.86,5.98,6.77,7.29,8.07,9.15,10.27,
 12.41,14.91};
static float alpha01_nx064_nz11_fwhm125[32] = {
 2.74,2.83,2.88,2.93,2.96,2.98,3.17,3.49,3.68,3.79,
 3.85,3.92,3.96,4.26,4.63,4.86,5.00,5.48,5.87,6.36,
 6.84,7.16,7.65,7.96,8.52,9.65,10.71,12.04,14.04,15.89,
 19.64,24.25};
static float alpha01_nx064_nz11_fwhm150[32] = {
 3.13,3.47,3.66,3.81,3.94,4.02,4.50,4.78,4.92,5.00,
 5.36,5.53,5.72,6.01,6.63,6.97,7.74,8.19,9.07,9.95,
 10.76,11.56,12.28,13.28,13.94,15.90,17.95,20.61,24.38,27.87,
 36.14,44.88};
static float alpha01_nx064_nz11_fwhm175[32] = {
 4.76,4.96,5.31,5.66,5.95,6.37,6.88,7.34,7.80,8.14,
 8.49,8.77,8.94,9.93,10.67,11.46,12.56,13.44,15.25,17.07,
 18.65,19.76,21.48,22.69,24.18,27.87,32.04,37.11,43.89,51.59,
 67.20,86.73};
static float alpha01_nx064_nz11_fwhm200[32] = {
 6.99,7.67,7.95,8.65,9.06,9.62,10.60,11.28,11.95,12.62,
 13.11,13.78,14.23,15.78,17.00,18.56,20.30,21.71,24.66,27.70,
 30.05,32.46,34.80,36.95,39.18,45.88,52.50,61.71,73.08,85.40,
 113.71,143.75};
static float alpha01_nx064_nz11_fwhm225[32] = {
 9.98,10.79,11.55,12.34,13.26,14.03,15.15,16.44,17.42,18.36,
 19.29,19.95,20.89,22.88,25.12,27.71,29.90,32.08,36.21,39.83,
 43.75,47.20,50.85,54.25,57.30,68.00,77.22,88.89,106.80,123.60,
 165.00,210.00};
static float alpha01_nx064_nz11_fwhm250[32] = {
 13.26,14.38,15.54,16.56,17.71,19.03,20.57,22.68,24.15,25.28,
 26.47,27.46,28.69,31.18,34.06,36.95,40.42,42.95,48.86,54.47,
 59.67,63.56,67.90,71.79,76.86,89.92,104.44,120.44,143.67,165.00,
 218.33,285.33};
static float alpha01_nx064_nz11_fwhm275[32] = {
 16.79,18.12,19.67,21.25,22.50,24.00,26.50,28.63,30.53,32.07,
 33.56,35.10,36.12,40.00,43.07,46.93,51.09,54.11,62.67,69.50,
 76.38,81.90,88.00,94.33,100.00,115.33,132.80,153.71,181.88,210.20,
 284.00,357.00};
static float alpha01_nx064_nz11_fwhm300[32] = {
 20.48,22.13,23.58,25.88,27.65,29.31,32.15,34.65,36.71,38.80,
 40.91,43.10,44.57,48.73,52.08,57.00,61.73,66.88,76.83,85.71,
 93.17,99.86,107.25,114.40,121.00,141.50,162.43,187.80,221.67,256.00,
 349.00,433.50};
static float alpha01_nx064_nz11_fwhm325[32] = {
 24.08,26.67,28.45,30.79,32.90,35.21,38.57,41.45,43.92,45.88,
 48.12,50.36,52.20,57.17,61.50,67.90,74.50,80.42,90.20,100.20,
 110.00,119.17,127.67,136.00,143.80,168.75,193.00,223.67,263.50,307.00,
 407.50,509.00};
static float alpha01_nx064_nz11_fwhm350[32] = {
 28.26,30.78,33.23,35.53,38.09,40.29,44.15,47.67,51.00,52.88,
 55.83,58.83,60.14,66.75,72.56,78.00,85.67,93.40,106.00,118.67,
 130.00,138.60,147.50,157.50,166.71,195.40,226.50,263.67,309.00,366.33,
 462.75,595.00};
static float alpha01_nx064_nz11_fwhm375[32] = {
 31.84,34.40,36.42,39.80,42.92,45.25,50.00,54.00,58.10,60.80,
 63.78,66.50,69.00,74.93,81.67,90.86,99.33,107.50,121.00,133.88,
 145.80,159.50,170.00,183.25,193.50,227.25,261.33,301.40,354.50,421.00,
 531.00,673.50};
static float alpha01_nx064_nz11_fwhm400[32] = {
 34.27,38.25,41.25,43.82,47.50,50.55,56.17,60.86,64.86,68.00,
 71.67,75.12,77.75,85.33,93.25,102.00,111.75,119.50,137.50,151.67,
 167.75,181.25,195.33,207.80,220.75,260.00,296.75,340.00,408.00,471.67,
 603.00,753.00};
static float alpha01_nx064_nz11_fwhm425[32] = {
 38.67,41.92,44.79,48.38,52.80,55.71,62.14,66.44,71.33,75.33,
 80.00,84.29,87.25,96.25,103.57,113.50,124.00,136.00,155.00,172.83,
 188.50,205.25,219.67,234.00,249.33,293.33,331.00,383.50,457.00,525.00,
 674.50,834.00};
static float alpha01_nx064_nz11_fwhm450[32] = {
 41.50,45.10,48.50,52.69,57.00,61.00,67.40,73.60,79.00,83.67,
 88.14,92.17,95.67,105.33,113.67,125.25,139.67,150.40,171.00,190.00,
 210.60,227.75,244.67,263.00,276.75,319.67,366.67,423.00,506.50,580.00,
 746.50,924.00};
static float alpha01_nx064_nz11_fwhm475[32] = {
 44.62,49.14,52.89,57.17,62.08,67.00,73.71,81.14,85.67,90.75,
 95.22,100.17,104.80,116.00,125.40,139.50,152.67,164.60,188.00,212.50,
 231.00,250.00,268.00,285.00,301.00,357.00,401.25,469.00,558.00,635.00,
 813.00,1011.00};
static float alpha01_nx064_nz11_fwhm500[32] = {
 47.83,52.57,56.30,61.80,67.00,71.75,79.25,86.00,93.17,99.00,
 104.75,109.33,112.50,124.78,137.00,151.00,165.60,177.86,206.00,229.00,
 251.40,269.00,292.67,313.00,334.33,386.50,441.00,510.50,611.00,698.50,
 888.50,1092.00};
static float *alpha01_nx064_nz11[21] = {
 alpha01_nx064_nz11_fwhm000, alpha01_nx064_nz11_fwhm025, alpha01_nx064_nz11_fwhm050, 
 alpha01_nx064_nz11_fwhm075, alpha01_nx064_nz11_fwhm100, alpha01_nx064_nz11_fwhm125, 
 alpha01_nx064_nz11_fwhm150, alpha01_nx064_nz11_fwhm175, alpha01_nx064_nz11_fwhm200, 
 alpha01_nx064_nz11_fwhm225, alpha01_nx064_nz11_fwhm250, alpha01_nx064_nz11_fwhm275, 
 alpha01_nx064_nz11_fwhm300, alpha01_nx064_nz11_fwhm325, alpha01_nx064_nz11_fwhm350, 
 alpha01_nx064_nz11_fwhm375, alpha01_nx064_nz11_fwhm400, alpha01_nx064_nz11_fwhm425, 
 alpha01_nx064_nz11_fwhm450, alpha01_nx064_nz11_fwhm475, alpha01_nx064_nz11_fwhm500} ;

static float alpha05_nx064_nz11_fwhm000[32] = {
 1.95,1.95,1.95,1.95,1.96,1.96,1.97,1.98,1.99,2.05,
 2.28,2.40,2.50,2.70,2.79,2.86,2.91,2.94,2.98,3.15,
 3.50,3.69,3.80,3.87,3.93,4.25,4.70,4.96,5.66,6.00,
 7.00,8.25};
static float alpha05_nx064_nz11_fwhm025[32] = {
 1.95,1.95,1.95,1.95,1.96,1.96,1.97,1.98,1.99,2.05,
 2.28,2.40,2.50,2.70,2.79,2.86,2.91,2.94,2.98,3.15,
 3.50,3.69,3.80,3.87,3.93,4.25,4.70,4.96,5.66,6.00,
 7.00,8.25};
static float alpha05_nx064_nz11_fwhm050[32] = {
 1.95,1.95,1.95,1.96,1.96,1.96,1.97,1.98,2.00,2.17,
 2.35,2.46,2.56,2.73,2.81,2.87,2.92,2.95,2.98,3.29,
 3.57,3.73,3.84,3.90,3.95,4.40,4.77,5.00,5.77,6.20,
 7.30,8.53};
static float alpha05_nx064_nz11_fwhm075[32] = {
 1.95,1.95,1.96,1.96,1.96,1.97,1.98,2.09,2.31,2.47,
 2.58,2.66,2.72,2.82,2.88,2.92,2.95,2.98,3.33,3.64,
 3.80,3.89,3.96,4.03,4.33,4.79,5.00,5.72,6.26,6.88,
 8.14,9.60};
static float alpha05_nx064_nz11_fwhm100[32] = {
 1.96,1.96,1.97,1.98,1.99,2.11,2.44,2.61,2.72,2.78,
 2.83,2.86,2.89,2.94,2.97,3.00,3.44,3.65,3.87,3.97,
 4.32,4.64,4.81,4.91,4.99,5.77,6.18,6.91,7.82,8.69,
 10.59,12.55};
static float alpha05_nx064_nz11_fwhm125[32] = {
 1.99,2.07,2.32,2.52,2.66,2.75,2.85,2.91,2.95,2.98,
 3.00,3.21,3.38,3.67,3.84,3.94,4.21,4.57,4.90,5.36,
 5.75,5.96,6.39,6.72,6.95,7.91,8.87,9.98,11.65,13.08,
 16.47,20.00};
static float alpha05_nx064_nz11_fwhm150[32] = {
 2.71,2.82,2.89,2.94,3.00,3.27,3.62,3.80,3.92,4.01,
 4.28,4.49,4.65,4.92,5.37,5.79,6.23,6.69,7.48,8.21,
 8.86,9.52,10.05,10.75,11.31,12.99,14.75,17.01,20.01,22.99,
 29.57,36.94};
static float alpha05_nx064_nz11_fwhm175[32] = {
 3.52,3.80,3.96,4.28,4.61,4.81,5.21,5.69,5.95,6.32,
 6.64,6.88,7.12,7.82,8.49,9.19,9.95,10.80,12.10,13.52,
 14.79,16.00,17.18,18.09,19.12,22.47,25.74,29.96,35.27,41.23,
 53.74,68.60};
static float alpha05_nx064_nz11_fwhm200[32] = {
 4.95,5.51,5.85,6.36,6.81,7.26,7.99,8.61,9.10,9.67,
 10.05,10.51,10.88,12.09,13.01,14.22,15.62,16.91,19.36,21.55,
 23.51,25.35,27.05,28.73,30.39,35.84,41.30,48.45,57.06,66.38,
 87.34,112.77};
static float alpha05_nx064_nz11_fwhm225[32] = {
 7.06,7.72,8.22,8.82,9.48,9.98,11.11,12.04,12.85,13.60,
 14.24,14.90,15.49,17.07,18.54,20.37,22.53,24.29,27.60,30.79,
 33.67,36.37,39.20,41.85,44.59,52.34,59.39,69.69,83.21,96.50,
 126.77,164.88};
static float alpha05_nx064_nz11_fwhm250[32] = {
 9.09,9.93,10.57,11.39,12.32,13.10,14.51,15.83,16.86,17.80,
 18.87,19.61,20.51,22.79,24.95,27.19,29.70,32.32,36.80,41.06,
 45.09,48.73,52.37,56.02,59.35,69.49,79.65,92.83,109.81,126.83,
 168.36,214.56};
static float alpha05_nx064_nz11_fwhm275[32] = {
 10.99,12.12,13.04,14.08,15.24,16.28,18.12,19.77,21.12,22.59,
 23.72,24.79,25.81,28.72,31.29,34.46,37.72,40.61,46.54,51.83,
 56.93,61.83,66.85,71.31,75.70,88.00,100.36,117.04,138.15,161.94,
 212.86,267.23};
static float alpha05_nx064_nz11_fwhm300[32] = {
 13.01,14.28,15.46,16.78,18.30,19.57,21.79,23.83,25.57,27.12,
 28.55,29.86,31.34,34.55,37.85,41.49,45.48,49.83,57.49,63.97,
 69.62,75.53,80.58,86.05,91.48,106.95,121.94,142.71,169.11,195.71,
 255.71,322.14};
static float alpha05_nx064_nz11_fwhm325[32] = {
 14.95,16.54,17.88,19.49,21.28,22.88,25.57,27.90,29.70,31.75,
 33.54,35.24,37.03,41.07,44.71,49.26,54.63,59.56,67.91,75.39,
 82.20,88.50,94.97,102.04,107.78,126.77,144.60,168.79,198.94,232.44,
 300.25,381.67};
static float alpha05_nx064_nz11_fwhm350[32] = {
 16.96,18.84,20.39,22.07,24.39,26.02,29.08,31.94,34.53,36.64,
 38.54,40.57,42.22,47.13,51.81,57.17,63.14,69.02,78.30,86.28,
 94.91,102.85,110.71,118.71,126.38,146.78,167.65,196.47,232.86,268.17,
 348.67,439.60};
static float alpha05_nx064_nz11_fwhm375[32] = {
 18.69,20.87,22.78,24.70,27.26,29.43,33.04,35.92,38.92,41.43,
 43.76,46.08,47.97,53.84,59.20,65.38,71.74,77.27,88.66,98.38,
 108.28,117.42,126.63,134.81,143.14,167.90,193.50,224.67,264.42,307.85,
 398.75,504.80};
static float alpha05_nx064_nz11_fwhm400[32] = {
 20.36,22.73,25.05,27.51,30.07,32.43,36.85,40.31,43.57,46.70,
 49.03,51.61,54.03,60.68,66.20,72.57,79.92,86.50,99.11,110.72,
 121.71,132.38,142.64,151.79,162.32,190.22,216.78,252.67,300.00,347.00,
 451.71,564.50};
static float alpha05_nx064_nz11_fwhm425[32] = {
 21.77,24.81,27.26,30.14,33.08,35.92,40.35,44.44,48.03,50.97,
 53.97,56.96,59.83,66.59,72.75,80.15,88.61,96.19,110.11,123.64,
 135.75,147.29,159.25,170.31,181.41,212.78,242.57,283.20,335.33,389.00,
 507.00,626.67};
static float alpha05_nx064_nz11_fwhm450[32] = {
 23.43,26.70,29.20,32.43,35.55,38.45,43.62,48.25,52.00,55.38,
 58.93,62.21,64.72,72.56,79.62,87.95,96.67,104.91,121.42,135.74,
 150.50,163.43,176.73,188.50,199.92,235.67,269.20,313.00,373.50,435.20,
 558.33,684.60};
static float alpha05_nx064_nz11_fwhm475[32] = {
 24.56,28.10,30.93,34.15,37.83,40.90,46.85,51.88,55.76,59.83,
 63.56,67.22,70.12,78.60,85.74,95.39,105.69,115.75,133.30,149.29,
 164.83,179.44,192.83,205.10,219.27,258.82,297.33,348.14,414.00,479.29,
 607.57,746.11};
static float alpha05_nx064_nz11_fwhm500[32] = {
 25.62,29.27,32.29,36.16,40.26,44.00,49.98,55.26,60.08,64.46,
 68.00,71.63,75.23,83.87,92.59,102.79,114.32,124.56,144.44,161.85,
 178.38,195.07,210.00,224.67,240.55,283.53,326.50,381.67,450.25,520.33,
 661.00,810.00};
static float *alpha05_nx064_nz11[21] = {
 alpha05_nx064_nz11_fwhm000, alpha05_nx064_nz11_fwhm025, alpha05_nx064_nz11_fwhm050, 
 alpha05_nx064_nz11_fwhm075, alpha05_nx064_nz11_fwhm100, alpha05_nx064_nz11_fwhm125, 
 alpha05_nx064_nz11_fwhm150, alpha05_nx064_nz11_fwhm175, alpha05_nx064_nz11_fwhm200, 
 alpha05_nx064_nz11_fwhm225, alpha05_nx064_nz11_fwhm250, alpha05_nx064_nz11_fwhm275, 
 alpha05_nx064_nz11_fwhm300, alpha05_nx064_nz11_fwhm325, alpha05_nx064_nz11_fwhm350, 
 alpha05_nx064_nz11_fwhm375, alpha05_nx064_nz11_fwhm400, alpha05_nx064_nz11_fwhm425, 
 alpha05_nx064_nz11_fwhm450, alpha05_nx064_nz11_fwhm475, alpha05_nx064_nz11_fwhm500} ;

static float alpha10_nx064_nz11_fwhm000[32] = {
 1.90,1.90,1.90,1.90,1.91,1.91,1.92,1.92,1.94,1.95,
 1.97,1.98,2.00,2.39,2.57,2.71,2.80,2.85,2.91,2.95,
 3.00,3.33,3.54,3.69,3.78,3.94,4.31,4.76,5.12,5.73,
 6.67,7.71};
static float alpha10_nx064_nz11_fwhm025[32] = {
 1.90,1.90,1.90,1.90,1.91,1.91,1.92,1.92,1.94,1.95,
 1.97,1.98,2.00,2.39,2.57,2.71,2.80,2.85,2.91,2.95,
 3.00,3.33,3.54,3.69,3.78,3.94,4.31,4.76,5.12,5.73,
 6.67,7.71};
static float alpha10_nx064_nz11_fwhm050[32] = {
 1.90,1.90,1.90,1.90,1.91,1.91,1.92,1.93,1.94,1.96,
 1.97,1.99,2.11,2.44,2.61,2.73,2.82,2.86,2.92,2.96,
 3.10,3.42,3.61,3.73,3.81,3.96,4.43,4.82,5.32,5.82,
 6.80,7.86};
static float alpha10_nx064_nz11_fwhm075[32] = {
 1.90,1.90,1.90,1.91,1.91,1.92,1.93,1.95,1.97,1.99,
 2.16,2.30,2.42,2.63,2.74,2.82,2.87,2.91,2.97,3.23,
 3.54,3.71,3.82,3.89,3.95,4.46,4.82,5.22,5.83,6.43,
 7.63,8.85};
static float alpha10_nx064_nz11_fwhm100[32] = {
 1.90,1.91,1.92,1.92,1.94,1.95,1.99,2.20,2.41,2.54,
 2.63,2.69,2.74,2.84,2.89,2.93,2.98,3.24,3.65,3.82,
 3.94,4.13,4.46,4.65,4.79,5.27,5.79,6.45,7.18,7.94,
 9.72,11.59};
static float alpha10_nx064_nz11_fwhm125[32] = {
 1.93,1.95,1.97,2.01,2.30,2.47,2.66,2.76,2.83,2.87,
 2.91,2.94,2.96,3.23,3.54,3.74,3.89,3.99,4.58,4.88,
 5.20,5.59,5.83,6.05,6.47,7.20,8.03,9.18,10.62,11.95,
 14.90,18.18};
static float alpha10_nx064_nz11_fwhm150[32] = {
 2.33,2.54,2.67,2.77,2.86,2.92,3.05,3.40,3.61,3.75,
 3.85,3.93,4.00,4.51,4.81,5.14,5.65,5.94,6.72,7.40,
 7.97,8.59,9.12,9.66,10.16,11.76,13.31,15.44,18.13,20.78,
 26.69,33.39};
static float alpha10_nx064_nz11_fwhm175[32] = {
 2.92,3.17,3.46,3.71,3.91,4.14,4.60,4.88,5.18,5.51,
 5.78,5.96,6.23,6.85,7.48,8.11,8.87,9.63,10.88,12.02,
 13.15,14.20,15.23,16.24,17.18,20.05,22.97,26.72,31.57,36.76,
 48.06,61.09};
static float alpha10_nx064_nz11_fwhm200[32] = {
 4.12,4.58,4.85,5.26,5.71,6.06,6.78,7.32,7.84,8.30,
 8.73,9.11,9.51,10.52,11.43,12.47,13.70,14.79,16.78,18.74,
 20.55,22.27,23.81,25.47,27.08,31.81,36.60,42.95,50.77,59.17,
 77.79,99.54};
static float alpha10_nx064_nz11_fwhm225[32] = {
 5.66,6.27,6.77,7.36,7.98,8.55,9.45,10.25,10.95,11.57,
 12.16,12.74,13.30,14.72,15.98,17.53,19.31,21.05,24.19,26.82,
 29.46,31.87,34.21,36.68,38.86,45.84,52.51,61.32,73.18,85.45,
 112.31,143.58};
static float alpha10_nx064_nz11_fwhm250[32] = {
 7.27,8.06,8.65,9.40,10.21,10.93,12.07,13.11,14.18,15.01,
 15.85,16.59,17.36,19.25,21.11,23.18,25.55,27.87,31.76,35.67,
 39.00,42.29,45.43,48.60,51.64,60.70,69.96,81.65,96.23,112.35,
 147.41,189.46};
static float alpha10_nx064_nz11_fwhm275[32] = {
 8.70,9.60,10.48,11.41,12.47,13.36,14.81,16.39,17.53,18.71,
 19.72,20.64,21.56,24.07,26.40,29.01,32.10,34.87,40.06,44.71,
 48.88,52.86,57.00,61.04,64.76,76.54,87.42,101.56,121.05,141.79,
 185.21,233.35};
static float alpha10_nx064_nz11_fwhm300[32] = {
 10.03,11.22,12.27,13.42,14.71,15.80,17.84,19.46,21.00,22.35,
 23.55,24.85,25.97,28.93,31.61,35.04,38.65,42.08,48.40,53.79,
 59.23,64.34,68.95,73.62,78.54,91.88,105.28,123.57,147.15,171.47,
 222.62,278.83};
static float alpha10_nx064_nz11_fwhm325[32] = {
 11.31,12.66,13.81,15.29,16.93,18.18,20.53,22.55,24.39,25.96,
 27.47,28.92,30.30,33.91,37.12,40.95,45.18,49.03,56.59,63.40,
 69.14,75.33,81.20,87.10,92.50,108.90,124.75,147.00,174.68,201.38,
 259.43,326.79};
static float alpha10_nx064_nz11_fwhm350[32] = {
 12.48,14.04,15.52,17.14,18.98,20.48,23.15,25.59,27.66,29.66,
 31.38,32.94,34.64,39.00,42.56,46.74,52.03,56.98,65.09,72.86,
 80.29,87.25,94.00,100.50,106.58,126.41,145.61,170.59,201.40,231.75,
 298.78,375.00};
static float alpha10_nx064_nz11_fwhm375[32] = {
 13.42,15.17,16.97,18.92,20.85,22.60,25.92,28.54,30.98,33.23,
 35.18,37.18,38.92,43.62,47.80,52.99,59.04,64.31,73.62,83.21,
 91.70,99.46,107.13,114.69,122.42,144.69,166.20,194.58,228.43,262.72,
 338.81,426.44};
static float alpha10_nx064_nz11_fwhm400[32] = {
 14.36,16.44,18.30,20.32,22.68,24.80,28.29,31.47,34.23,36.68,
 38.85,40.87,42.95,48.29,53.27,59.05,65.86,71.66,82.78,93.16,
 102.47,111.54,120.96,129.42,137.59,162.80,187.00,217.95,254.96,295.50,
 382.83,475.75};
static float alpha10_nx064_nz11_fwhm425[32] = {
 15.33,17.51,19.61,21.84,24.40,26.85,30.68,34.23,37.22,39.81,
 42.51,44.85,47.14,53.07,58.59,65.04,72.40,79.14,91.84,102.89,
 113.84,124.22,134.64,144.29,153.86,180.96,207.07,241.44,284.67,328.94,
 426.56,527.33};
static float alpha10_nx064_nz11_fwhm450[32] = {
 15.84,18.44,20.58,23.08,25.79,28.33,32.94,36.90,40.24,43.15,
 46.02,48.37,50.80,57.77,63.74,71.06,78.94,86.69,100.20,113.00,
 125.63,137.32,149.23,158.37,168.92,199.27,226.88,265.53,313.73,365.40,
 468.43,579.67};
static float alpha10_nx064_nz11_fwhm475[32] = {
 16.17,18.87,21.44,24.16,26.99,30.24,35.05,39.30,42.77,46.19,
 49.60,52.49,55.11,62.43,68.69,77.18,85.78,94.03,109.41,124.15,
 137.38,149.94,162.05,172.50,183.88,216.81,250.07,292.21,344.50,399.80,
 511.75,637.75};
static float alpha10_nx064_nz11_fwhm500[32] = {
 16.17,19.11,21.91,24.86,28.37,31.33,36.69,41.00,45.26,48.90,
 52.00,55.49,58.50,66.20,73.69,82.48,92.39,101.25,119.03,134.33,
 149.19,162.59,175.52,187.29,200.42,236.00,273.21,317.93,375.88,435.18,
 555.71,694.40};
static float *alpha10_nx064_nz11[21] = {
 alpha10_nx064_nz11_fwhm000, alpha10_nx064_nz11_fwhm025, alpha10_nx064_nz11_fwhm050, 
 alpha10_nx064_nz11_fwhm075, alpha10_nx064_nz11_fwhm100, alpha10_nx064_nz11_fwhm125, 
 alpha10_nx064_nz11_fwhm150, alpha10_nx064_nz11_fwhm175, alpha10_nx064_nz11_fwhm200, 
 alpha10_nx064_nz11_fwhm225, alpha10_nx064_nz11_fwhm250, alpha10_nx064_nz11_fwhm275, 
 alpha10_nx064_nz11_fwhm300, alpha10_nx064_nz11_fwhm325, alpha10_nx064_nz11_fwhm350, 
 alpha10_nx064_nz11_fwhm375, alpha10_nx064_nz11_fwhm400, alpha10_nx064_nz11_fwhm425, 
 alpha10_nx064_nz11_fwhm450, alpha10_nx064_nz11_fwhm475, alpha10_nx064_nz11_fwhm500} ;

static float **nx064_nz11[3] = {
  alpha01_nx064_nz11 , alpha05_nx064_nz11 , alpha10_nx064_nz11 };

static float alpha01_nx064_nz12_fwhm000[32] = {
 1.99,1.99,1.99,1.99,2.00,2.01,2.40,2.65,2.75,2.81,
 2.86,2.89,2.91,2.94,2.97,2.98,3.00,3.24,3.69,3.86,
 3.94,3.98,4.10,4.41,4.64,4.92,5.35,5.87,6.60,7.10,
 8.46,9.65};
static float alpha01_nx064_nz12_fwhm025[32] = {
 1.99,1.99,1.99,1.99,2.00,2.01,2.40,2.65,2.75,2.81,
 2.86,2.89,2.91,2.94,2.97,2.98,3.00,3.24,3.69,3.86,
 3.94,3.98,4.10,4.41,4.64,4.92,5.35,5.87,6.60,7.10,
 8.46,9.65};
static float alpha01_nx064_nz12_fwhm050[32] = {
 1.99,1.99,1.99,2.00,2.00,2.07,2.50,2.70,2.78,2.83,
 2.87,2.90,2.92,2.95,2.97,2.99,3.00,3.41,3.75,3.89,
 3.96,3.99,4.25,4.55,4.72,4.96,5.54,5.93,6.73,7.41,
 8.68,9.84};
static float alpha01_nx064_nz12_fwhm075[32] = {
 1.99,1.99,2.00,2.03,2.32,2.53,2.73,2.81,2.87,2.90,
 2.93,2.94,2.95,2.98,2.99,3.12,3.56,3.74,3.92,3.98,
 4.18,4.57,4.77,4.88,4.95,5.56,5.92,6.69,7.49,8.08,
 9.68,11.27};
static float alpha01_nx064_nz12_fwhm100[32] = {
 2.00,2.25,2.51,2.67,2.77,2.83,2.90,2.93,2.96,2.97,
 2.98,2.99,3.00,3.47,3.72,3.87,3.95,3.98,4.51,4.83,
 4.97,5.34,5.66,5.82,5.96,6.77,7.43,8.36,9.32,10.43,
 12.67,15.18};
static float alpha01_nx064_nz12_fwhm125[32] = {
 2.76,2.84,2.89,2.92,2.96,2.98,3.00,3.44,3.66,3.78,
 3.86,3.91,3.95,4.17,4.59,4.85,4.99,5.54,5.96,6.54,
 6.90,7.36,7.84,8.28,8.68,9.78,10.83,12.32,14.04,16.12,
 20.05,25.27};
static float alpha01_nx064_nz12_fwhm150[32] = {
 3.05,3.45,3.69,3.83,3.93,4.07,4.62,4.84,4.99,5.32,
 5.57,5.74,5.87,6.38,6.80,7.28,7.90,8.54,9.43,10.35,
 11.25,11.82,12.60,13.33,13.97,16.38,18.37,21.21,24.86,28.71,
 37.31,46.64};
static float alpha01_nx064_nz12_fwhm175[32] = {
 4.83,5.00,5.48,5.82,6.22,6.55,7.14,7.68,8.03,8.53,
 8.81,8.99,9.49,10.33,10.99,11.80,12.80,13.83,15.64,17.20,
 18.70,20.27,21.71,22.98,24.52,28.66,32.88,38.11,44.82,51.50,
 69.30,89.60};
static float alpha01_nx064_nz12_fwhm200[32] = {
 7.24,7.81,8.25,8.81,9.26,9.87,10.80,11.64,12.27,12.98,
 13.60,14.11,14.65,16.19,17.48,19.22,20.86,22.70,25.56,28.52,
 30.80,33.17,35.45,37.79,39.84,46.43,53.07,62.18,74.58,89.20,
 117.33,149.00};
static float alpha01_nx064_nz12_fwhm225[32] = {
 10.05,10.83,11.84,12.67,13.60,14.32,15.66,16.86,18.11,18.93,
 20.00,20.73,21.48,23.90,25.90,27.96,30.27,32.65,36.85,40.58,
 44.21,47.82,51.00,55.00,58.00,68.44,78.14,93.50,111.44,127.50,
 169.00,216.25};
static float alpha01_nx064_nz12_fwhm250[32] = {
 13.69,15.03,15.77,16.95,18.22,19.22,20.76,22.54,23.91,25.11,
 26.48,27.30,28.38,31.55,34.17,37.25,40.77,43.80,50.00,55.33,
 60.62,65.50,70.36,75.30,79.86,94.50,106.67,124.29,147.60,173.40,
 223.50,292.33};
static float alpha01_nx064_nz12_fwhm275[32] = {
 17.37,18.78,19.91,21.10,22.59,23.86,26.32,28.39,30.29,32.08,
 33.68,35.00,36.54,40.36,43.54,47.88,52.27,56.55,64.00,70.25,
 77.67,83.75,88.70,94.33,101.50,118.67,135.00,159.17,186.67,215.75,
 285.67,367.00};
static float alpha01_nx064_nz12_fwhm300[32] = {
 20.93,22.62,24.42,26.06,28.09,29.75,32.52,35.19,37.59,39.73,
 41.62,43.53,45.46,49.92,54.07,57.88,63.43,68.75,77.29,86.10,
 94.67,101.60,111.12,117.40,123.67,144.14,166.62,193.00,227.86,264.50,
 347.00,439.60};
static float alpha01_nx064_nz12_fwhm325[32] = {
 24.89,27.18,28.82,30.76,32.81,35.25,38.78,42.15,45.09,47.27,
 49.75,52.08,53.50,58.75,63.12,69.14,75.71,82.00,92.40,103.67,
 113.14,121.29,129.00,138.00,148.40,172.67,197.00,230.00,269.80,316.00,
 410.25,519.00};
static float alpha01_nx064_nz12_fwhm350[32] = {
 28.69,30.88,33.23,35.57,38.77,40.73,45.00,48.59,51.46,54.30,
 57.00,59.22,61.33,67.71,74.38,81.25,89.00,95.42,109.40,121.20,
 131.50,141.00,152.33,164.00,173.83,202.25,232.33,270.75,317.75,371.33,
 475.00,587.50};
static float alpha01_nx064_nz12_fwhm375[32] = {
 32.00,34.94,37.44,40.36,43.67,46.30,50.40,54.67,58.27,61.44,
 64.17,67.88,70.50,78.00,84.50,92.62,102.17,110.00,125.80,139.00,
 153.00,164.00,175.50,188.50,198.33,232.25,265.00,309.50,365.67,420.33,
 538.50,670.00};
static float alpha01_nx064_nz12_fwhm400[32] = {
 35.73,39.17,42.30,45.42,49.09,52.22,56.88,62.14,66.86,70.00,
 73.60,77.00,80.25,88.44,96.75,105.50,114.00,125.25,141.14,156.29,
 171.67,186.33,202.00,215.00,227.00,266.67,305.00,348.60,408.50,474.00,
 600.00,764.00};
static float alpha01_nx064_nz12_fwhm425[32] = {
 40.00,44.00,46.89,50.00,53.93,58.44,64.00,70.40,75.09,78.82,
 82.57,86.40,89.86,99.67,108.25,117.20,128.86,139.80,160.12,176.67,
 196.67,213.00,228.00,241.40,254.00,299.50,337.33,387.00,460.00,530.00,
 675.50,854.00};
static float alpha01_nx064_nz12_fwhm450[32] = {
 43.29,47.80,51.00,55.67,59.75,64.56,71.75,77.25,83.00,88.29,
 91.71,96.00,99.67,110.00,120.00,131.00,145.00,156.50,176.80,199.33,
 217.00,236.67,252.50,268.50,285.67,332.00,371.00,434.33,507.50,579.00,
 755.00,955.00};
static float alpha01_nx064_nz12_fwhm475[32] = {
 47.17,50.73,55.55,60.20,65.88,70.20,77.29,84.40,90.50,96.00,
 100.83,104.50,108.67,120.67,130.33,144.50,159.00,173.25,196.25,218.50,
 240.80,258.80,277.00,295.67,316.33,364.50,408.75,480.33,563.00,655.00,
 836.00,1040.50};
static float alpha01_nx064_nz12_fwhm500[32] = {
 49.50,55.50,59.36,64.71,70.80,74.67,83.75,91.50,97.40,103.50,
 108.71,113.50,117.86,131.14,143.50,157.50,173.50,187.33,213.40,240.50,
 261.50,285.00,302.67,323.50,340.50,397.75,455.50,527.00,624.00,714.00,
 917.00,1136.00};
static float *alpha01_nx064_nz12[21] = {
 alpha01_nx064_nz12_fwhm000, alpha01_nx064_nz12_fwhm025, alpha01_nx064_nz12_fwhm050, 
 alpha01_nx064_nz12_fwhm075, alpha01_nx064_nz12_fwhm100, alpha01_nx064_nz12_fwhm125, 
 alpha01_nx064_nz12_fwhm150, alpha01_nx064_nz12_fwhm175, alpha01_nx064_nz12_fwhm200, 
 alpha01_nx064_nz12_fwhm225, alpha01_nx064_nz12_fwhm250, alpha01_nx064_nz12_fwhm275, 
 alpha01_nx064_nz12_fwhm300, alpha01_nx064_nz12_fwhm325, alpha01_nx064_nz12_fwhm350, 
 alpha01_nx064_nz12_fwhm375, alpha01_nx064_nz12_fwhm400, alpha01_nx064_nz12_fwhm425, 
 alpha01_nx064_nz12_fwhm450, alpha01_nx064_nz12_fwhm475, alpha01_nx064_nz12_fwhm500} ;

static float alpha05_nx064_nz12_fwhm000[32] = {
 1.95,1.95,1.95,1.95,1.96,1.96,1.97,1.98,1.99,2.05,
 2.28,2.43,2.53,2.71,2.80,2.87,2.91,2.94,2.98,3.17,
 3.55,3.72,3.82,3.88,3.93,4.28,4.74,4.98,5.70,6.09,
 7.14,8.36};
static float alpha05_nx064_nz12_fwhm025[32] = {
 1.95,1.95,1.95,1.95,1.96,1.96,1.97,1.98,1.99,2.05,
 2.28,2.43,2.53,2.71,2.80,2.87,2.91,2.94,2.98,3.17,
 3.55,3.72,3.82,3.88,3.93,4.28,4.74,4.98,5.70,6.09,
 7.14,8.36};
static float alpha05_nx064_nz12_fwhm050[32] = {
 1.95,1.95,1.95,1.96,1.96,1.96,1.97,1.98,1.99,2.16,
 2.36,2.48,2.58,2.74,2.82,2.88,2.92,2.95,2.98,3.31,
 3.62,3.76,3.85,3.91,3.95,4.43,4.81,5.10,5.79,6.34,
 7.42,8.60};
static float alpha05_nx064_nz12_fwhm075[32] = {
 1.95,1.95,1.96,1.96,1.96,1.97,1.99,2.05,2.32,2.48,
 2.60,2.68,2.73,2.83,2.88,2.92,2.96,2.98,3.38,3.69,
 3.82,3.90,3.96,4.03,4.35,4.82,5.08,5.76,6.37,6.93,
 8.27,9.63};
static float alpha05_nx064_nz12_fwhm100[32] = {
 1.96,1.96,1.97,1.98,1.99,2.15,2.46,2.62,2.72,2.79,
 2.83,2.86,2.89,2.94,2.97,3.10,3.49,3.68,3.87,3.98,
 4.37,4.66,4.82,4.93,5.08,5.78,6.31,6.94,7.92,8.82,
 10.71,12.66};
static float alpha05_nx064_nz12_fwhm125[32] = {
 1.99,2.13,2.37,2.55,2.68,2.77,2.85,2.91,2.95,2.98,
 3.01,3.25,3.39,3.69,3.84,3.96,4.33,4.65,4.95,5.42,
 5.79,6.04,6.54,6.83,7.13,8.08,9.00,10.19,11.73,13.23,
 16.71,20.48};
static float alpha05_nx064_nz12_fwhm150[32] = {
 2.72,2.82,2.90,2.95,3.05,3.37,3.68,3.85,3.96,4.18,
 4.43,4.60,4.73,4.98,5.46,5.83,6.32,6.80,7.61,8.34,
 8.98,9.66,10.29,10.91,11.59,13.36,15.05,17.35,20.35,23.49,
 30.14,37.62};
static float alpha05_nx064_nz12_fwhm175[32] = {
 3.60,3.84,4.00,4.37,4.67,4.86,5.35,5.75,6.04,6.46,
 6.75,6.95,7.26,7.94,8.63,9.41,10.25,11.00,12.51,13.82,
 15.08,16.26,17.42,18.58,19.63,22.91,26.14,30.50,35.69,41.75,
 55.50,70.21};
static float alpha05_nx064_nz12_fwhm200[32] = {
 5.13,5.69,6.09,6.56,6.95,7.45,8.18,8.81,9.37,9.85,
 10.39,10.81,11.24,12.35,13.35,14.62,15.99,17.30,19.64,21.74,
 23.58,25.59,27.43,29.40,31.29,36.41,41.96,49.15,58.54,68.28,
 90.56,116.77};
static float alpha05_nx064_nz12_fwhm225[32] = {
 7.28,7.94,8.44,9.04,9.74,10.34,11.46,12.32,13.19,13.89,
 14.66,15.26,15.83,17.54,19.08,20.66,22.63,24.64,27.96,31.00,
 34.08,36.94,40.07,42.53,45.20,52.91,60.83,71.13,85.13,99.52,
 130.89,170.08};
static float alpha05_nx064_nz12_fwhm250[32] = {
 9.29,10.16,10.90,11.82,12.79,13.58,15.03,16.27,17.33,18.41,
 19.37,20.18,20.93,23.29,25.29,27.61,30.37,32.70,37.49,41.67,
 45.85,49.64,53.36,57.00,60.52,71.17,81.38,95.18,113.29,132.05,
 177.92,227.36};
static float alpha05_nx064_nz12_fwhm275[32] = {
 11.47,12.52,13.47,14.65,15.88,16.81,18.82,20.41,21.79,23.06,
 24.23,25.36,26.43,29.31,31.86,34.89,38.38,41.56,47.61,52.74,
 57.82,62.78,67.28,72.43,76.70,90.17,102.52,120.67,143.75,168.06,
 222.17,283.44};
static float alpha05_nx064_nz12_fwhm300[32] = {
 13.50,14.81,15.93,17.33,19.00,20.35,22.55,24.64,26.27,27.78,
 29.45,30.83,32.10,35.60,38.76,42.55,46.81,50.59,57.92,64.53,
 70.74,76.52,82.10,87.56,92.85,109.50,125.65,147.69,175.35,203.70,
 268.00,341.33};
static float alpha05_nx064_nz12_fwhm325[32] = {
 15.44,17.08,18.60,20.27,21.91,23.58,26.35,28.81,30.96,33.05,
 34.63,36.47,37.90,41.96,45.65,49.90,55.05,59.85,68.81,76.42,
 83.37,90.52,97.16,103.48,110.30,130.59,149.27,174.69,207.43,243.25,
 317.54,403.60};
static float alpha05_nx064_nz12_fwhm350[32] = {
 17.66,19.47,21.00,23.02,25.34,27.23,30.35,33.09,35.67,37.80,
 39.91,41.79,43.42,48.39,52.71,58.03,63.93,69.30,79.21,87.74,
 96.33,104.55,113.00,120.63,129.00,152.38,174.47,202.67,241.67,281.64,
 366.50,464.62};
static float alpha05_nx064_nz12_fwhm375[32] = {
 19.64,21.83,23.77,25.85,28.23,30.38,34.08,37.24,39.92,42.80,
 45.05,47.21,49.23,54.63,59.69,65.63,72.50,78.71,89.61,100.52,
 110.82,120.47,130.85,139.91,148.42,174.40,199.56,232.55,277.33,322.58,
 418.17,524.43};
static float alpha05_nx064_nz12_fwhm400[32] = {
 21.33,23.98,26.14,28.61,31.32,33.74,38.04,41.37,44.43,47.43,
 50.13,52.59,54.83,61.38,66.90,73.63,81.26,87.96,101.58,114.21,
 125.64,136.65,147.76,157.57,168.40,197.00,225.57,263.78,313.00,363.67,
 470.00,588.80};
static float alpha05_nx064_nz12_fwhm425[32] = {
 23.37,26.02,28.71,31.38,34.47,36.93,41.43,45.49,48.94,52.22,
 55.21,58.08,60.96,68.10,74.22,80.91,89.80,98.17,113.64,127.76,
 140.68,153.33,165.55,177.33,187.62,220.31,252.88,297.38,351.44,405.60,
 520.57,657.67};
static float alpha05_nx064_nz12_fwhm450[32] = {
 24.80,27.79,30.49,33.75,36.92,39.74,45.15,49.72,53.61,57.20,
 60.28,63.37,66.19,74.05,80.55,89.73,99.45,108.75,125.57,141.12,
 155.86,169.90,183.89,195.55,207.79,244.22,280.86,330.30,389.00,447.67,
 579.40,719.80};
static float alpha05_nx064_nz12_fwhm475[32] = {
 25.72,29.31,32.11,35.67,39.50,42.81,48.34,53.05,57.63,60.96,
 64.73,68.22,71.42,80.09,87.56,97.38,108.95,119.17,137.72,155.20,
 171.57,186.56,200.44,214.14,227.00,269.33,309.25,362.78,425.50,491.67,
 631.00,784.60};
static float alpha05_nx064_nz12_fwhm500[32] = {
 26.82,30.59,33.89,37.44,42.00,45.35,51.50,56.61,60.86,65.50,
 69.50,73.42,76.92,86.26,94.57,106.06,118.64,130.15,149.93,169.00,
 185.64,201.56,218.15,233.00,248.67,296.82,336.90,394.22,465.17,539.67,
 690.80,850.00};
static float *alpha05_nx064_nz12[21] = {
 alpha05_nx064_nz12_fwhm000, alpha05_nx064_nz12_fwhm025, alpha05_nx064_nz12_fwhm050, 
 alpha05_nx064_nz12_fwhm075, alpha05_nx064_nz12_fwhm100, alpha05_nx064_nz12_fwhm125, 
 alpha05_nx064_nz12_fwhm150, alpha05_nx064_nz12_fwhm175, alpha05_nx064_nz12_fwhm200, 
 alpha05_nx064_nz12_fwhm225, alpha05_nx064_nz12_fwhm250, alpha05_nx064_nz12_fwhm275, 
 alpha05_nx064_nz12_fwhm300, alpha05_nx064_nz12_fwhm325, alpha05_nx064_nz12_fwhm350, 
 alpha05_nx064_nz12_fwhm375, alpha05_nx064_nz12_fwhm400, alpha05_nx064_nz12_fwhm425, 
 alpha05_nx064_nz12_fwhm450, alpha05_nx064_nz12_fwhm475, alpha05_nx064_nz12_fwhm500} ;

static float alpha10_nx064_nz12_fwhm000[32] = {
 1.90,1.90,1.90,1.90,1.91,1.91,1.92,1.93,1.94,1.95,
 1.97,1.99,2.05,2.41,2.59,2.72,2.81,2.86,2.91,2.95,
 3.05,3.39,3.58,3.70,3.79,3.94,4.36,4.80,5.22,5.77,
 6.73,7.77};
static float alpha10_nx064_nz12_fwhm025[32] = {
 1.90,1.90,1.90,1.90,1.91,1.91,1.92,1.93,1.94,1.95,
 1.97,1.99,2.05,2.41,2.59,2.72,2.81,2.86,2.91,2.95,
 3.05,3.39,3.58,3.70,3.79,3.94,4.36,4.80,5.22,5.77,
 6.73,7.77};
static float alpha10_nx064_nz12_fwhm050[32] = {
 1.90,1.90,1.90,1.91,1.91,1.91,1.92,1.93,1.94,1.96,
 1.98,1.99,2.15,2.47,2.63,2.75,2.82,2.87,2.92,2.97,
 3.20,3.47,3.64,3.75,3.83,3.97,4.49,4.86,5.38,5.86,
 6.86,7.92};
static float alpha10_nx064_nz12_fwhm075[32] = {
 1.90,1.90,1.91,1.91,1.91,1.92,1.93,1.95,1.97,2.00,
 2.20,2.34,2.45,2.64,2.75,2.83,2.88,2.91,2.97,3.32,
 3.58,3.74,3.83,3.90,3.95,4.51,4.84,5.31,5.88,6.52,
 7.70,8.89};
static float alpha10_nx064_nz12_fwhm100[32] = {
 1.91,1.91,1.92,1.93,1.94,1.96,1.99,2.24,2.44,2.56,
 2.65,2.70,2.75,2.84,2.89,2.94,2.99,3.30,3.67,3.85,
 3.95,4.19,4.49,4.69,4.82,5.33,5.83,6.53,7.35,8.12,
 9.84,11.67};
static float alpha10_nx064_nz12_fwhm125[32] = {
 1.94,1.95,1.98,2.08,2.34,2.50,2.67,2.77,2.83,2.88,
 2.91,2.94,2.97,3.27,3.55,3.77,3.92,4.11,4.66,4.91,
 5.27,5.66,5.91,6.22,6.61,7.48,8.27,9.35,10.71,12.12,
 15.16,18.62};
static float alpha10_nx064_nz12_fwhm150[32] = {
 2.36,2.57,2.70,2.79,2.88,2.94,3.15,3.47,3.67,3.80,
 3.90,3.98,4.17,4.61,4.86,5.19,5.69,6.02,6.82,7.54,
 8.13,8.72,9.29,9.84,10.42,12.04,13.65,15.70,18.43,21.19,
 27.29,33.81};
static float alpha10_nx064_nz12_fwhm175[32] = {
 2.96,3.28,3.54,3.76,3.96,4.25,4.69,4.95,5.35,5.65,
 5.87,6.11,6.40,6.97,7.62,8.30,9.09,9.84,11.16,12.39,
 13.48,14.54,15.57,16.58,17.54,20.49,23.26,27.30,32.26,37.17,
 48.98,62.69};
static float alpha10_nx064_nz12_fwhm200[32] = {
 4.32,4.72,4.97,5.47,5.90,6.35,7.01,7.62,8.10,8.60,
 9.00,9.42,9.76,10.79,11.68,12.81,13.97,15.12,17.37,19.20,
 21.04,22.84,24.52,26.01,27.69,32.46,37.14,43.47,51.66,60.18,
 79.92,103.00};
static float alpha10_nx064_nz12_fwhm225[32] = {
 5.87,6.55,6.98,7.64,8.26,8.73,9.69,10.53,11.26,11.89,
 12.53,13.04,13.60,15.13,16.48,17.97,19.77,21.54,24.40,27.31,
 30.13,32.62,35.05,37.42,39.85,46.57,53.47,62.66,74.91,87.71,
 115.37,148.72};
static float alpha10_nx064_nz12_fwhm250[32] = {
 7.60,8.36,8.93,9.74,10.56,11.24,12.54,13.64,14.67,15.57,
 16.35,17.02,17.81,19.89,21.60,23.65,26.19,28.44,32.44,36.10,
 39.70,43.15,46.19,49.53,52.60,61.83,71.14,83.51,99.59,116.04,
 153.50,198.00};
static float alpha10_nx064_nz12_fwhm275[32] = {
 9.00,10.00,10.85,11.84,12.92,13.94,15.52,16.90,18.15,19.26,
 20.23,21.22,22.11,24.60,26.87,29.62,32.66,35.67,40.91,45.34,
 49.73,54.14,58.24,62.27,66.31,77.92,88.96,104.81,124.51,146.10,
 193.46,245.85};
static float alpha10_nx064_nz12_fwhm300[32] = {
 10.58,11.76,12.84,14.05,15.27,16.44,18.44,19.95,21.62,22.96,
 24.25,25.38,26.55,29.75,32.56,35.90,39.51,43.05,49.30,55.08,
 60.65,65.74,70.85,75.65,79.97,94.42,108.30,127.52,152.00,177.95,
 233.58,294.71};
static float alpha10_nx064_nz12_fwhm325[32] = {
 11.94,13.37,14.51,15.97,17.58,18.95,21.25,23.32,25.19,26.83,
 28.32,29.78,31.13,34.85,38.24,42.10,46.90,50.74,58.27,65.26,
 71.65,77.62,83.35,88.82,94.47,111.71,128.40,150.31,180.07,210.89,
 274.67,344.18};
static float alpha10_nx064_nz12_fwhm350[32] = {
 13.21,14.78,16.32,17.97,19.78,21.34,24.28,26.73,28.78,30.74,
 32.51,34.28,35.72,40.25,44.03,48.51,53.61,58.30,67.10,74.64,
 82.13,89.20,96.10,103.15,109.65,130.41,149.46,175.68,209.52,243.45,
 316.30,398.00};
static float alpha10_nx064_nz12_fwhm375[32] = {
 14.51,16.34,17.81,19.94,22.05,23.92,27.11,29.89,32.45,34.64,
 36.70,38.60,40.36,44.97,49.27,54.34,60.15,65.82,75.57,84.54,
 93.05,101.43,110.07,118.17,126.21,148.15,171.47,201.95,237.25,277.00,
 357.75,451.82};
static float alpha10_nx064_nz12_fwhm400[32] = {
 15.52,17.56,19.61,21.81,24.10,26.03,29.78,32.81,35.53,38.05,
 40.16,42.31,44.42,49.71,54.41,60.38,67.15,72.90,84.60,95.00,
 104.65,114.42,123.91,133.50,141.82,168.48,192.67,226.19,267.10,312.38,
 402.45,503.50};
static float alpha10_nx064_nz12_fwhm425[32] = {
 16.44,18.83,21.02,23.37,25.91,28.20,32.01,35.34,38.47,41.13,
 43.74,46.26,48.46,54.45,59.80,66.48,74.28,80.88,94.29,106.03,
 117.03,127.48,138.07,148.61,159.00,186.97,213.91,252.18,297.62,345.12,
 446.45,553.29};
static float alpha10_nx064_nz12_fwhm450[32] = {
 17.28,19.82,21.67,24.50,27.31,29.89,34.44,38.18,41.39,44.44,
 47.26,49.83,52.30,59.15,64.84,72.63,81.06,89.13,103.65,117.00,
 129.28,141.41,153.03,164.55,175.24,205.81,237.17,276.81,328.00,381.56,
 487.38,607.50};
static float alpha10_nx064_nz12_fwhm475[32] = {
 17.45,20.13,22.39,25.38,28.50,31.37,36.28,40.40,44.11,47.61,
 50.67,53.10,55.96,63.42,70.41,78.97,88.54,97.37,113.57,128.21,
 141.58,154.81,167.89,180.05,191.84,226.10,258.33,302.00,360.33,416.00,
 530.30,664.78};
static float alpha10_nx064_nz12_fwhm500[32] = {
 17.58,20.47,23.31,26.44,29.49,32.68,38.08,42.59,46.59,50.04,
 53.42,56.56,59.68,68.50,75.78,85.36,96.15,105.82,123.14,139.32,
 154.65,169.06,182.61,196.15,208.08,246.30,282.23,329.50,391.50,454.25,
 579.88,719.00};
static float *alpha10_nx064_nz12[21] = {
 alpha10_nx064_nz12_fwhm000, alpha10_nx064_nz12_fwhm025, alpha10_nx064_nz12_fwhm050, 
 alpha10_nx064_nz12_fwhm075, alpha10_nx064_nz12_fwhm100, alpha10_nx064_nz12_fwhm125, 
 alpha10_nx064_nz12_fwhm150, alpha10_nx064_nz12_fwhm175, alpha10_nx064_nz12_fwhm200, 
 alpha10_nx064_nz12_fwhm225, alpha10_nx064_nz12_fwhm250, alpha10_nx064_nz12_fwhm275, 
 alpha10_nx064_nz12_fwhm300, alpha10_nx064_nz12_fwhm325, alpha10_nx064_nz12_fwhm350, 
 alpha10_nx064_nz12_fwhm375, alpha10_nx064_nz12_fwhm400, alpha10_nx064_nz12_fwhm425, 
 alpha10_nx064_nz12_fwhm450, alpha10_nx064_nz12_fwhm475, alpha10_nx064_nz12_fwhm500} ;

static float **nx064_nz12[3] = {
  alpha01_nx064_nz12 , alpha05_nx064_nz12 , alpha10_nx064_nz12 };

static float alpha01_nx064_nz13_fwhm000[32] = {
 1.99,1.99,1.99,1.99,2.00,2.05,2.44,2.65,2.75,2.82,
 2.86,2.89,2.92,2.95,2.97,2.98,3.00,3.30,3.75,3.88,
 3.94,3.98,4.19,4.51,4.69,4.95,5.48,5.91,6.59,7.10,
 8.42,9.75};
static float alpha01_nx064_nz13_fwhm025[32] = {
 1.99,1.99,1.99,1.99,2.00,2.05,2.44,2.65,2.75,2.82,
 2.86,2.89,2.92,2.95,2.97,2.98,3.00,3.30,3.75,3.88,
 3.94,3.98,4.19,4.51,4.69,4.95,5.48,5.91,6.59,7.10,
 8.42,9.75};
static float alpha01_nx064_nz13_fwhm050[32] = {
 1.99,1.99,1.99,2.00,2.00,2.15,2.50,2.69,2.78,2.84,
 2.88,2.91,2.92,2.96,2.97,2.99,3.08,3.44,3.78,3.90,
 3.96,4.00,4.38,4.60,4.78,4.99,5.65,5.96,6.76,7.32,
 8.64,9.94};
static float alpha01_nx064_nz13_fwhm075[32] = {
 1.99,1.99,2.00,2.03,2.34,2.51,2.72,2.82,2.87,2.91,
 2.93,2.94,2.95,2.98,2.99,3.26,3.61,3.77,3.92,3.99,
 4.34,4.64,4.82,4.91,4.98,5.68,5.96,6.70,7.43,7.96,
 9.77,11.45};
static float alpha01_nx064_nz13_fwhm100[32] = {
 2.00,2.31,2.51,2.66,2.77,2.84,2.90,2.94,2.96,2.97,
 2.99,2.99,3.12,3.53,3.74,3.87,3.96,4.01,4.68,4.89,
 5.00,5.41,5.67,5.85,5.96,6.77,7.48,8.21,9.39,10.51,
 12.73,14.98};
static float alpha01_nx064_nz13_fwhm125[32] = {
 2.77,2.86,2.90,2.94,2.96,2.98,3.21,3.56,3.73,3.82,
 3.88,3.92,3.96,4.34,4.66,4.87,4.99,5.52,5.92,6.50,
 6.92,7.33,7.76,8.06,8.61,9.78,10.86,12.20,14.02,16.02,
 19.84,24.64};
static float alpha01_nx064_nz13_fwhm150[32] = {
 3.19,3.53,3.68,3.85,3.96,4.12,4.54,4.82,4.96,5.18,
 5.50,5.67,5.85,6.30,6.79,7.22,7.82,8.38,9.26,10.25,
 11.02,11.92,12.75,13.63,14.31,16.25,18.57,21.41,25.44,29.48,
 37.29,47.15};
static float alpha01_nx064_nz13_fwhm175[32] = {
 4.82,5.00,5.41,5.73,5.97,6.44,6.93,7.55,7.90,8.43,
 8.70,8.98,9.40,10.17,10.99,12.10,13.24,14.19,15.95,17.62,
 18.95,20.55,21.94,23.40,24.87,29.28,33.30,38.65,45.29,52.88,
 69.45,88.50};
static float alpha01_nx064_nz13_fwhm200[32] = {
 7.41,7.95,8.58,9.02,9.74,10.29,10.95,11.91,12.60,13.26,
 13.80,14.36,15.03,16.58,17.77,19.27,20.95,22.85,25.62,28.00,
 31.18,33.77,36.05,38.29,40.39,47.11,53.36,61.92,74.40,86.89,
 113.50,150.11};
static float alpha01_nx064_nz13_fwhm225[32] = {
 10.76,11.43,12.26,13.00,14.00,14.74,16.24,17.27,18.21,19.22,
 20.24,20.97,21.86,23.91,25.52,27.79,30.00,32.62,36.57,40.82,
 44.56,47.81,51.36,55.00,58.19,68.28,77.33,92.57,109.50,127.38,
 166.80,220.75};
static float alpha01_nx064_nz13_fwhm250[32] = {
 14.52,15.35,16.29,17.54,18.73,19.68,21.52,23.04,24.18,25.30,
 26.55,27.44,28.40,31.14,33.62,36.86,40.25,43.55,49.25,55.08,
 60.14,65.20,69.89,74.73,79.10,93.38,106.33,122.25,146.43,170.80,
 226.40,294.00};
static float alpha01_nx064_nz13_fwhm275[32] = {
 17.88,19.33,20.44,21.68,23.00,24.53,26.59,28.17,29.97,31.92,
 33.54,35.18,36.46,40.00,43.31,47.12,52.13,56.43,64.67,71.40,
 78.00,83.62,89.33,95.62,102.12,119.20,137.57,157.75,186.00,220.00,
 293.50,372.00};
static float alpha01_nx064_nz13_fwhm300[32] = {
 21.00,22.80,24.27,26.05,27.71,29.67,32.86,35.36,37.56,39.37,
 41.29,43.31,45.60,50.27,54.00,59.42,65.38,71.29,80.23,88.33,
 96.17,103.88,110.80,118.67,126.67,147.25,165.50,194.43,232.00,271.00,
 356.50,454.50};
static float alpha01_nx064_nz13_fwhm325[32] = {
 25.06,27.12,29.00,31.28,33.71,35.71,39.75,43.22,45.27,48.10,
 50.56,52.80,55.42,61.25,66.46,72.00,77.92,84.43,95.17,105.12,
 115.50,125.00,132.60,141.17,150.00,175.25,201.17,234.50,280.33,320.67,
 423.00,535.40};
static float alpha01_nx064_nz13_fwhm350[32] = {
 29.15,31.81,34.33,37.00,39.91,41.70,46.64,50.12,53.73,57.12,
 59.88,62.45,65.00,71.27,76.91,83.67,91.40,98.50,109.86,122.50,
 134.20,146.20,155.83,166.67,176.20,203.67,234.33,276.67,327.40,379.00,
 499.00,609.50};
static float alpha01_nx064_nz13_fwhm375[32] = {
 33.85,36.67,39.33,42.43,45.67,48.40,53.20,57.50,61.80,65.20,
 68.75,72.25,74.25,81.22,87.75,96.00,103.67,111.40,126.33,143.29,
 154.80,168.33,181.00,190.00,201.00,235.25,272.00,319.50,378.00,439.00,
 567.75,692.80};
static float alpha01_nx064_nz13_fwhm400[32] = {
 38.00,41.25,44.20,47.78,51.50,54.78,60.67,65.40,70.00,72.75,
 76.88,79.62,83.00,91.73,98.33,107.40,117.40,126.50,144.50,162.00,
 175.33,189.80,203.33,215.00,230.00,270.80,316.00,364.67,431.50,500.00,
 640.00,773.67};
static float alpha01_nx064_nz13_fwhm425[32] = {
 42.17,45.91,48.90,53.00,57.00,60.75,66.20,72.50,77.50,80.75,
 85.33,89.80,93.43,102.00,110.25,120.50,130.20,142.57,163.33,180.67,
 196.50,211.50,228.00,245.50,262.50,309.50,353.25,410.50,486.00,563.50,
 699.00,848.00};
static float alpha01_nx064_nz13_fwhm450[32] = {
 46.25,50.50,54.12,58.67,62.50,66.67,73.33,80.10,86.25,91.00,
 95.00,98.29,102.75,113.00,122.17,131.75,146.00,158.80,179.62,198.75,
 220.00,240.00,259.00,277.00,294.50,342.83,395.33,460.00,532.00,618.00,
 767.00,940.00};
static float alpha01_nx064_nz13_fwhm475[32] = {
 50.62,55.80,59.67,64.80,70.40,73.88,81.71,88.50,93.67,100.00,
 104.78,109.14,113.25,122.91,132.33,146.50,161.17,174.17,199.17,225.17,
 245.00,268.33,289.33,306.00,324.00,383.00,435.00,499.33,592.75,667.00,
 835.00,1052.00};
static float alpha01_nx064_nz13_fwhm500[32] = {
 55.14,60.67,66.00,71.22,76.29,81.00,89.00,96.40,102.83,108.75,
 113.60,118.00,123.00,134.80,146.40,160.80,175.75,191.25,218.33,246.33,
 270.33,292.50,314.50,336.25,357.00,421.00,478.50,548.50,642.00,722.67,
 913.00,1147.00};
static float *alpha01_nx064_nz13[21] = {
 alpha01_nx064_nz13_fwhm000, alpha01_nx064_nz13_fwhm025, alpha01_nx064_nz13_fwhm050, 
 alpha01_nx064_nz13_fwhm075, alpha01_nx064_nz13_fwhm100, alpha01_nx064_nz13_fwhm125, 
 alpha01_nx064_nz13_fwhm150, alpha01_nx064_nz13_fwhm175, alpha01_nx064_nz13_fwhm200, 
 alpha01_nx064_nz13_fwhm225, alpha01_nx064_nz13_fwhm250, alpha01_nx064_nz13_fwhm275, 
 alpha01_nx064_nz13_fwhm300, alpha01_nx064_nz13_fwhm325, alpha01_nx064_nz13_fwhm350, 
 alpha01_nx064_nz13_fwhm375, alpha01_nx064_nz13_fwhm400, alpha01_nx064_nz13_fwhm425, 
 alpha01_nx064_nz13_fwhm450, alpha01_nx064_nz13_fwhm475, alpha01_nx064_nz13_fwhm500} ;

static float alpha05_nx064_nz13_fwhm000[32] = {
 1.95,1.95,1.95,1.95,1.96,1.96,1.97,1.98,1.99,2.10,
 2.30,2.46,2.56,2.74,2.82,2.88,2.92,2.94,2.98,3.25,
 3.56,3.73,3.83,3.90,3.94,4.39,4.77,5.00,5.72,6.06,
 7.23,8.43};
static float alpha05_nx064_nz13_fwhm025[32] = {
 1.95,1.95,1.95,1.95,1.96,1.96,1.97,1.98,1.99,2.10,
 2.30,2.46,2.56,2.74,2.82,2.88,2.92,2.94,2.98,3.25,
 3.56,3.73,3.83,3.90,3.94,4.39,4.77,5.00,5.72,6.06,
 7.23,8.43};
static float alpha05_nx064_nz13_fwhm050[32] = {
 1.95,1.95,1.95,1.96,1.96,1.96,1.97,1.98,2.00,2.18,
 2.39,2.52,2.61,2.76,2.83,2.89,2.93,2.95,2.99,3.36,
 3.64,3.78,3.87,3.92,3.97,4.51,4.84,5.19,5.81,6.31,
 7.46,8.69};
static float alpha05_nx064_nz13_fwhm075[32] = {
 1.95,1.95,1.96,1.96,1.96,1.97,1.99,2.07,2.35,2.54,
 2.63,2.70,2.75,2.85,2.89,2.93,2.96,2.99,3.44,3.71,
 3.84,3.92,3.97,4.16,4.44,4.86,5.17,5.78,6.38,6.93,
 8.36,9.79};
static float alpha05_nx064_nz13_fwhm100[32] = {
 1.96,1.96,1.97,1.98,1.99,2.18,2.49,2.66,2.75,2.81,
 2.85,2.88,2.90,2.95,2.98,3.19,3.55,3.72,3.91,4.00,
 4.47,4.71,4.85,4.94,5.15,5.82,6.38,6.97,7.90,8.88,
 10.89,12.91};
static float alpha05_nx064_nz13_fwhm125[32] = {
 1.99,2.20,2.42,2.58,2.71,2.79,2.87,2.92,2.96,2.99,
 3.12,3.31,3.47,3.73,3.86,3.97,4.38,4.68,4.97,5.50,
 5.84,6.08,6.56,6.83,7.09,8.11,9.06,10.41,11.80,13.45,
 16.71,20.51};
static float alpha05_nx064_nz13_fwhm150[32] = {
 2.74,2.85,2.90,2.96,3.13,3.40,3.70,3.86,3.97,4.19,
 4.44,4.61,4.75,5.07,5.54,5.88,6.38,6.83,7.66,8.43,
 9.04,9.75,10.33,10.95,11.61,13.36,15.01,17.49,20.48,23.68,
 30.20,38.21};
static float alpha05_nx064_nz13_fwhm175[32] = {
 3.61,3.86,3.99,4.38,4.71,4.92,5.43,5.83,6.16,6.55,
 6.80,6.99,7.35,7.99,8.68,9.54,10.42,11.19,12.61,13.89,
 15.07,16.39,17.56,18.76,19.95,22.99,26.48,30.90,36.32,42.62,
 56.41,71.82};
static float alpha05_nx064_nz13_fwhm200[32] = {
 5.30,5.75,6.12,6.60,6.97,7.51,8.31,8.90,9.48,10.04,
 10.53,10.94,11.43,12.53,13.56,14.73,16.33,17.63,20.02,22.29,
 24.30,26.32,28.14,29.95,31.79,37.29,42.42,49.72,58.94,69.62,
 92.36,118.84};
static float alpha05_nx064_nz13_fwhm225[32] = {
 7.43,8.13,8.66,9.26,9.99,10.67,11.79,12.73,13.59,14.28,
 14.95,15.67,16.30,18.06,19.50,21.41,23.39,25.15,28.61,31.96,
 34.73,37.64,40.29,42.96,45.50,53.34,61.39,72.51,86.15,100.39,
 133.71,172.93};
static float alpha05_nx064_nz13_fwhm250[32] = {
 9.67,10.55,11.28,12.12,13.14,13.96,15.47,16.74,17.81,18.90,
 19.82,20.73,21.51,23.77,25.80,28.17,30.85,33.46,38.18,42.48,
 46.51,50.09,53.65,57.42,60.62,71.56,82.32,96.95,114.59,134.78,
 179.25,229.55};
static float alpha05_nx064_nz13_fwhm275[32] = {
 11.80,12.99,13.96,15.15,16.45,17.47,19.31,21.01,22.41,23.79,
 24.79,25.92,27.01,29.93,32.64,35.66,39.31,42.54,48.48,53.63,
 58.70,63.63,68.15,73.04,77.80,91.29,104.44,121.14,144.62,169.07,
 225.08,288.00};
static float alpha05_nx064_nz13_fwhm300[32] = {
 14.30,15.60,16.78,18.10,19.62,20.88,23.28,25.34,27.13,28.75,
 30.23,31.76,33.00,36.59,39.73,43.79,47.78,51.78,58.74,65.21,
 71.50,77.41,83.14,88.68,94.52,110.58,126.11,148.55,177.05,207.20,
 273.00,347.33};
static float alpha05_nx064_nz13_fwhm325[32] = {
 16.57,18.14,19.48,21.09,23.05,24.70,27.38,29.90,32.00,33.97,
 35.70,37.25,38.87,43.20,47.02,51.21,56.27,60.57,70.07,77.32,
 84.42,91.71,98.30,105.29,112.08,131.37,151.15,177.23,210.80,245.60,
 325.44,412.33};
static float alpha05_nx064_nz13_fwhm350[32] = {
 18.65,20.61,22.28,24.39,26.60,28.36,31.53,34.37,36.79,38.91,
 40.80,42.85,44.60,49.34,53.80,58.83,65.24,70.77,80.55,89.89,
 98.95,107.17,114.87,122.30,130.30,153.50,176.45,206.29,246.12,286.40,
 374.20,471.56};
static float alpha05_nx064_nz13_fwhm375[32] = {
 20.80,23.00,24.94,27.16,29.56,31.68,35.57,38.71,41.20,43.74,
 46.20,48.43,50.47,56.03,60.75,66.84,73.91,80.34,92.00,103.22,
 112.74,122.12,131.21,140.83,149.86,176.14,202.41,236.62,282.00,328.92,
 425.00,534.00};
static float alpha05_nx064_nz13_fwhm400[32] = {
 22.80,25.28,27.37,29.93,32.78,35.05,39.24,42.71,45.79,48.53,
 51.00,53.53,55.74,62.41,68.17,75.08,83.31,90.42,104.36,116.19,
 127.69,138.50,148.90,159.23,171.45,200.73,230.06,268.43,318.57,373.25,
 479.75,601.67};
static float alpha05_nx064_nz13_fwhm425[32] = {
 24.55,27.33,29.65,32.58,35.70,38.49,43.05,46.78,50.34,53.47,
 56.51,59.37,61.97,69.46,76.05,83.86,92.89,100.75,116.21,129.00,
 142.57,156.27,168.00,180.56,191.27,224.77,258.89,301.00,358.83,412.83,
 533.67,666.00};
static float alpha05_nx064_nz13_fwhm450[32] = {
 26.00,29.14,31.92,35.09,38.41,41.38,46.45,50.79,55.20,58.61,
 62.05,65.14,68.34,76.39,83.43,92.73,102.47,112.00,128.24,144.42,
 159.00,172.75,186.27,199.43,212.50,249.42,286.36,333.09,396.00,456.00,
 590.80,727.33};
static float alpha05_nx064_nz13_fwhm475[32] = {
 27.44,31.24,34.25,37.74,41.12,44.24,50.26,55.50,59.71,63.92,
 67.10,71.21,74.27,83.42,91.48,100.96,111.81,122.52,141.55,159.22,
 174.82,190.36,206.08,219.79,233.83,275.22,313.36,367.50,434.38,501.20,
 646.50,799.00};
static float alpha05_nx064_nz13_fwhm500[32] = {
 28.94,32.76,36.00,39.82,43.75,47.34,53.65,59.96,64.24,68.36,
 72.70,76.25,80.27,90.33,99.07,110.13,122.50,133.24,155.00,173.71,
 192.17,209.43,225.30,240.10,255.00,299.45,342.00,401.88,474.50,548.00,
 698.50,871.33};
static float *alpha05_nx064_nz13[21] = {
 alpha05_nx064_nz13_fwhm000, alpha05_nx064_nz13_fwhm025, alpha05_nx064_nz13_fwhm050, 
 alpha05_nx064_nz13_fwhm075, alpha05_nx064_nz13_fwhm100, alpha05_nx064_nz13_fwhm125, 
 alpha05_nx064_nz13_fwhm150, alpha05_nx064_nz13_fwhm175, alpha05_nx064_nz13_fwhm200, 
 alpha05_nx064_nz13_fwhm225, alpha05_nx064_nz13_fwhm250, alpha05_nx064_nz13_fwhm275, 
 alpha05_nx064_nz13_fwhm300, alpha05_nx064_nz13_fwhm325, alpha05_nx064_nz13_fwhm350, 
 alpha05_nx064_nz13_fwhm375, alpha05_nx064_nz13_fwhm400, alpha05_nx064_nz13_fwhm425, 
 alpha05_nx064_nz13_fwhm450, alpha05_nx064_nz13_fwhm475, alpha05_nx064_nz13_fwhm500} ;

static float alpha10_nx064_nz13_fwhm000[32] = {
 1.90,1.90,1.90,1.90,1.91,1.91,1.92,1.93,1.94,1.95,
 1.97,1.99,2.11,2.47,2.63,2.74,2.82,2.87,2.92,2.96,
 3.10,3.42,3.62,3.74,3.81,3.96,4.42,4.82,5.27,5.78,
 6.78,7.81};
static float alpha10_nx064_nz13_fwhm025[32] = {
 1.90,1.90,1.90,1.90,1.91,1.91,1.92,1.93,1.94,1.95,
 1.97,1.99,2.11,2.47,2.63,2.74,2.82,2.87,2.92,2.96,
 3.10,3.42,3.62,3.74,3.81,3.96,4.42,4.82,5.27,5.78,
 6.78,7.81};
static float alpha10_nx064_nz13_fwhm050[32] = {
 1.90,1.90,1.90,1.91,1.91,1.91,1.92,1.93,1.94,1.96,
 1.98,2.04,2.21,2.52,2.66,2.77,2.84,2.88,2.93,2.97,
 3.24,3.51,3.67,3.77,3.85,3.99,4.55,4.88,5.42,5.87,
 6.89,7.96};
static float alpha10_nx064_nz13_fwhm075[32] = {
 1.90,1.90,1.91,1.91,1.91,1.92,1.93,1.95,1.97,2.07,
 2.26,2.40,2.50,2.68,2.77,2.84,2.89,2.92,2.98,3.36,
 3.62,3.76,3.85,3.92,3.97,4.57,4.87,5.36,5.89,6.55,
 7.76,8.96};
static float alpha10_nx064_nz13_fwhm100[32] = {
 1.91,1.91,1.92,1.93,1.94,1.96,2.00,2.31,2.49,2.60,
 2.68,2.74,2.78,2.85,2.90,2.95,3.04,3.37,3.72,3.87,
 3.97,4.29,4.55,4.72,4.85,5.43,5.87,6.56,7.36,8.17,
 9.98,11.85};
static float alpha10_nx064_nz13_fwhm125[32] = {
 1.94,1.96,1.98,2.14,2.38,2.54,2.70,2.79,2.85,2.90,
 2.93,2.95,2.98,3.34,3.59,3.79,3.94,4.18,4.70,4.94,
 5.37,5.71,5.93,6.29,6.62,7.52,8.36,9.52,10.81,12.31,
 15.26,18.74};
static float alpha10_nx064_nz13_fwhm150[32] = {
 2.40,2.60,2.71,2.81,2.89,2.95,3.22,3.52,3.70,3.82,
 3.91,3.99,4.19,4.68,4.92,5.35,5.77,6.11,6.85,7.59,
 8.20,8.80,9.38,9.88,10.48,12.05,13.68,15.79,18.46,21.25,
 27.35,34.35};
static float alpha10_nx064_nz13_fwhm175[32] = {
 2.96,3.30,3.57,3.79,3.98,4.31,4.75,4.98,5.42,5.73,
 5.93,6.21,6.50,7.08,7.68,8.38,9.17,9.87,11.14,12.41,
 13.56,14.65,15.64,16.66,17.70,20.70,23.63,27.45,32.57,38.11,
 50.00,64.26};
static float alpha10_nx064_nz13_fwhm200[32] = {
 4.40,4.80,5.13,5.59,5.96,6.40,7.02,7.69,8.19,8.66,
 9.06,9.51,9.86,10.86,11.84,12.94,14.21,15.38,17.56,19.53,
 21.49,23.18,24.87,26.65,28.29,33.07,37.85,44.29,52.44,61.74,
 81.84,105.65};
static float alpha10_nx064_nz13_fwhm225[32] = {
 5.95,6.63,7.18,7.79,8.44,8.91,9.88,10.70,11.52,12.19,
 12.84,13.48,14.05,15.59,16.85,18.49,20.40,21.97,25.18,28.04,
 30.57,33.23,35.68,38.00,40.35,47.46,54.20,63.87,75.97,89.32,
 118.96,152.69};
static float alpha10_nx064_nz13_fwhm250[32] = {
 7.86,8.65,9.30,10.01,10.87,11.73,12.92,14.12,15.09,16.08,
 16.89,17.68,18.42,20.55,22.22,24.36,26.70,29.11,33.07,36.95,
 40.37,43.87,47.04,50.46,53.66,62.81,72.24,84.98,102.26,118.94,
 156.90,202.48};
static float alpha10_nx064_nz13_fwhm275[32] = {
 9.50,10.50,11.37,12.34,13.40,14.37,16.09,17.56,18.79,19.90,
 20.96,22.04,22.91,25.46,27.80,30.46,33.59,36.21,41.46,46.32,
 50.79,54.94,59.16,63.21,67.10,79.34,91.37,107.94,128.19,149.20,
 197.83,252.22};
static float alpha10_nx064_nz13_fwhm300[32] = {
 11.10,12.37,13.45,14.61,15.95,17.06,19.16,21.02,22.56,23.83,
 25.25,26.43,27.61,30.70,33.42,36.63,40.48,44.11,50.23,55.83,
 61.42,66.78,71.80,76.67,81.76,96.69,111.03,130.40,154.19,180.10,
 238.09,302.24};
static float alpha10_nx064_nz13_fwhm325[32] = {
 12.69,14.18,15.37,16.81,18.46,19.87,22.42,24.34,26.21,27.98,
 29.42,30.81,32.27,35.93,39.23,43.17,47.38,51.39,59.21,65.97,
 72.50,78.98,85.04,91.60,97.67,115.08,131.96,153.74,182.80,212.90,
 279.61,356.21};
static float alpha10_nx064_nz13_fwhm350[32] = {
 14.11,15.88,17.34,19.01,20.90,22.60,25.28,27.81,29.87,31.83,
 33.71,35.43,36.99,41.20,45.01,49.58,54.49,59.46,68.40,76.88,
 84.39,91.71,99.36,106.72,113.82,133.19,152.88,178.10,211.73,246.94,
 321.50,408.64};
static float alpha10_nx064_nz13_fwhm375[32] = {
 15.57,17.44,19.09,21.05,23.09,24.99,28.23,31.02,33.59,35.69,
 37.66,39.81,41.72,46.48,50.82,55.94,62.35,68.12,78.17,87.62,
 97.34,105.41,113.64,121.65,129.45,151.92,174.09,203.68,242.50,279.94,
 366.47,460.07};
static float alpha10_nx064_nz13_fwhm400[32] = {
 16.66,18.79,20.60,22.65,25.05,27.20,31.06,34.13,36.95,39.64,
 41.83,43.99,46.13,51.83,56.79,62.94,69.98,76.47,87.80,99.51,
 109.33,118.95,128.09,136.70,145.38,170.71,196.08,230.90,272.67,314.27,
 410.67,515.57};
static float alpha10_nx064_nz13_fwhm425[32] = {
 17.53,19.86,21.87,24.36,27.03,29.39,33.72,37.12,40.29,43.16,
 46.01,48.39,50.72,57.26,63.02,69.81,77.55,84.83,98.21,110.52,
 121.65,131.91,143.03,152.27,162.44,190.95,219.43,257.47,302.67,350.58,
 456.00,571.33};
static float alpha10_nx064_nz13_fwhm450[32] = {
 18.16,20.73,23.08,25.63,28.90,31.56,36.42,40.28,43.69,46.75,
 49.84,52.76,55.53,62.48,68.95,76.64,85.32,93.57,108.25,121.37,
 134.04,146.32,157.48,168.00,178.58,211.38,243.00,282.33,333.29,385.60,
 505.64,630.00};
static float alpha10_nx064_nz13_fwhm475[32] = {
 18.58,21.43,24.04,27.23,30.67,33.69,38.80,43.06,46.72,50.17,
 53.41,56.57,59.47,67.42,74.79,83.11,92.48,101.43,117.95,132.33,
 146.13,159.09,171.00,183.50,195.95,232.19,265.25,309.92,366.42,424.80,
 550.44,686.09};
static float alpha10_nx064_nz13_fwhm500[32] = {
 18.94,22.11,24.95,28.38,32.20,35.36,40.78,45.49,49.53,53.37,
 56.98,60.52,63.80,72.78,80.18,88.91,99.61,109.35,126.33,142.50,
 158.00,172.58,186.31,199.67,212.43,251.93,288.00,337.78,398.65,466.30,
 600.43,743.00};
static float *alpha10_nx064_nz13[21] = {
 alpha10_nx064_nz13_fwhm000, alpha10_nx064_nz13_fwhm025, alpha10_nx064_nz13_fwhm050, 
 alpha10_nx064_nz13_fwhm075, alpha10_nx064_nz13_fwhm100, alpha10_nx064_nz13_fwhm125, 
 alpha10_nx064_nz13_fwhm150, alpha10_nx064_nz13_fwhm175, alpha10_nx064_nz13_fwhm200, 
 alpha10_nx064_nz13_fwhm225, alpha10_nx064_nz13_fwhm250, alpha10_nx064_nz13_fwhm275, 
 alpha10_nx064_nz13_fwhm300, alpha10_nx064_nz13_fwhm325, alpha10_nx064_nz13_fwhm350, 
 alpha10_nx064_nz13_fwhm375, alpha10_nx064_nz13_fwhm400, alpha10_nx064_nz13_fwhm425, 
 alpha10_nx064_nz13_fwhm450, alpha10_nx064_nz13_fwhm475, alpha10_nx064_nz13_fwhm500} ;

static float **nx064_nz13[3] = {
  alpha01_nx064_nz13 , alpha05_nx064_nz13 , alpha10_nx064_nz13 };

static float alpha01_nx064_nz14_fwhm000[32] = {
 1.99,1.99,1.99,2.00,2.00,2.15,2.50,2.70,2.79,2.84,
 2.88,2.90,2.92,2.95,2.97,2.98,3.00,3.40,3.75,3.88,
 3.94,3.98,4.12,4.47,4.69,4.95,5.46,5.91,6.62,7.01,
 8.45,9.80};
static float alpha01_nx064_nz14_fwhm025[32] = {
 1.99,1.99,1.99,2.00,2.00,2.15,2.50,2.70,2.79,2.84,
 2.88,2.90,2.92,2.95,2.97,2.98,3.00,3.40,3.75,3.88,
 3.94,3.98,4.12,4.47,4.69,4.95,5.46,5.91,6.62,7.01,
 8.45,9.80};
static float alpha01_nx064_nz14_fwhm050[32] = {
 1.99,1.99,1.99,2.00,2.03,2.22,2.58,2.74,2.81,2.86,
 2.89,2.91,2.93,2.96,2.97,2.99,3.09,3.50,3.79,3.91,
 3.96,3.99,4.34,4.62,4.76,4.98,5.62,5.96,6.76,7.26,
 8.63,9.98};
static float alpha01_nx064_nz14_fwhm075[32] = {
 1.99,2.00,2.00,2.12,2.40,2.59,2.75,2.84,2.88,2.91,
 2.93,2.95,2.96,2.98,2.99,3.29,3.63,3.79,3.92,3.98,
 4.29,4.63,4.79,4.90,4.98,5.70,5.95,6.76,7.42,8.13,
 9.72,11.60};
static float alpha01_nx064_nz14_fwhm100[32] = {
 2.04,2.37,2.57,2.68,2.79,2.85,2.91,2.94,2.96,2.98,
 2.99,2.99,3.00,3.50,3.73,3.88,3.95,4.01,4.64,4.91,
 4.99,5.48,5.74,5.91,6.02,6.86,7.55,8.39,9.39,10.59,
 12.87,15.65};
static float alpha01_nx064_nz14_fwhm125[32] = {
 2.78,2.86,2.90,2.93,2.97,2.98,3.27,3.56,3.74,3.82,
 3.89,3.94,3.97,4.32,4.63,4.90,5.19,5.58,5.96,6.61,
 7.06,7.55,7.86,8.22,8.62,9.84,10.93,12.42,14.32,16.00,
 20.52,25.31};
static float alpha01_nx064_nz14_fwhm150[32] = {
 3.15,3.53,3.72,3.84,3.97,4.18,4.57,4.83,4.94,5.21,
 5.53,5.72,5.86,6.30,6.79,7.25,7.82,8.41,9.36,10.26,
 11.16,11.96,12.68,13.43,14.27,16.61,18.78,21.55,24.91,28.90,
 37.68,46.62};
static float alpha01_nx064_nz14_fwhm175[32] = {
 4.78,5.07,5.49,5.83,6.06,6.48,6.96,7.52,7.94,8.30,
 8.65,8.97,9.36,10.21,11.00,11.96,12.98,14.12,15.90,17.51,
 19.07,20.36,21.54,22.97,24.42,28.67,32.63,38.43,45.38,53.28,
 70.62,90.70};
static float alpha01_nx064_nz14_fwhm200[32] = {
 7.28,7.84,8.38,8.95,9.61,10.02,11.00,11.74,12.51,13.22,
 13.78,14.38,14.92,16.23,17.41,18.96,20.83,22.54,25.67,28.30,
 30.85,33.26,35.82,38.52,40.69,47.50,53.88,62.90,76.21,91.00,
 120.20,154.20};
static float alpha01_nx064_nz14_fwhm225[32] = {
 10.45,11.36,12.00,12.91,13.74,14.54,15.83,16.91,17.98,18.98,
 20.06,20.90,21.66,23.94,25.70,28.43,31.11,33.63,37.81,42.17,
 45.90,49.50,52.53,56.17,59.82,69.89,81.14,94.88,113.91,135.17,
 172.80,226.00};
static float alpha01_nx064_nz14_fwhm250[32] = {
 13.96,15.26,15.98,17.34,18.33,19.44,21.52,23.33,24.85,26.24,
 27.31,28.39,29.60,32.71,35.75,38.88,42.56,45.65,51.73,56.74,
 61.82,66.75,71.44,77.00,81.93,94.71,109.67,128.33,153.50,176.50,
 235.50,306.50};
static float alpha01_nx064_nz14_fwhm275[32] = {
 17.93,19.39,20.79,22.61,24.29,25.70,27.81,30.19,32.06,33.77,
 35.54,37.08,38.65,42.13,45.55,49.77,54.12,58.50,66.17,73.88,
 81.67,88.22,94.00,99.20,104.50,121.44,138.83,164.33,190.50,227.33,
 301.67,391.50};
static float alpha01_nx064_nz14_fwhm300[32] = {
 22.47,24.84,26.09,27.93,29.53,31.21,33.88,37.20,39.50,42.00,
 43.79,45.75,47.59,52.07,56.00,60.14,66.60,73.14,83.50,91.82,
 99.29,105.90,113.00,120.43,127.38,149.00,169.00,198.80,240.33,279.00,
 372.75,466.40};
static float alpha01_nx064_nz14_fwhm325[32] = {
 26.89,29.18,31.00,33.08,35.17,37.25,41.20,45.10,48.50,50.78,
 52.80,54.56,56.50,62.10,67.70,73.86,80.75,87.15,98.00,107.50,
 116.50,126.60,133.43,142.67,151.00,177.00,203.67,240.00,285.00,337.00,
 438.00,563.00};
static float alpha01_nx064_nz14_fwhm350[32] = {
 31.15,33.71,35.71,38.55,41.71,44.60,48.71,52.39,55.58,58.71,
 61.57,64.00,66.50,73.20,78.33,86.00,93.55,100.25,113.67,124.88,
 135.86,145.56,155.83,168.00,177.25,207.00,243.00,284.00,339.00,396.50,
 516.00,654.40};
static float alpha01_nx064_nz14_fwhm375[32] = {
 35.78,38.56,41.44,44.75,47.50,50.58,55.86,59.82,64.00,67.67,
 69.90,73.45,76.36,83.64,90.33,98.33,106.29,115.25,128.43,142.22,
 155.17,169.00,181.83,193.00,206.00,244.67,277.33,325.00,391.50,455.00,
 582.50,736.50};
static float alpha01_nx064_nz14_fwhm400[32] = {
 40.22,43.44,46.40,50.08,54.60,58.17,63.44,67.10,70.88,75.44,
 79.50,82.33,85.45,93.25,102.08,110.57,119.90,128.40,146.83,163.33,
 181.00,194.67,208.00,221.50,236.50,276.00,317.67,373.00,447.50,517.00,
 663.50,835.00};
static float alpha01_nx064_nz14_fwhm425[32] = {
 44.18,48.36,52.00,56.14,60.42,63.67,69.33,75.00,79.22,83.71,
 87.43,91.80,95.33,104.50,113.00,122.25,133.00,144.50,165.80,186.33,
 204.20,220.00,235.00,252.00,267.00,315.00,361.50,425.67,500.50,577.00,
 743.33,924.50};
static float alpha01_nx064_nz14_fwhm450[32] = {
 48.25,53.60,56.75,60.71,65.75,70.12,77.00,82.86,87.17,92.00,
 96.88,101.75,106.33,116.50,123.88,135.00,149.75,160.75,186.00,207.00,
 226.50,245.00,264.25,280.00,300.33,360.00,407.00,474.00,556.25,637.00,
 819.00,1019.00};
static float alpha01_nx064_nz14_fwhm475[32] = {
 53.14,58.20,62.20,66.33,71.57,75.75,82.92,90.00,97.00,102.20,
 107.33,111.75,116.67,127.38,138.14,151.20,165.33,179.33,207.60,232.50,
 254.33,274.67,294.00,314.00,337.60,393.67,449.00,524.50,602.50,703.00,
 908.00,1134.00};
static float alpha01_nx064_nz14_fwhm500[32] = {
 57.12,62.00,66.57,71.67,77.17,81.88,91.14,98.38,104.29,110.00,
 117.57,122.60,127.17,140.43,152.00,168.00,183.20,197.67,230.00,256.25,
 278.33,300.00,326.00,351.00,374.00,428.33,501.00,570.50,663.67,765.00,
 999.00,1236.00};
static float *alpha01_nx064_nz14[21] = {
 alpha01_nx064_nz14_fwhm000, alpha01_nx064_nz14_fwhm025, alpha01_nx064_nz14_fwhm050, 
 alpha01_nx064_nz14_fwhm075, alpha01_nx064_nz14_fwhm100, alpha01_nx064_nz14_fwhm125, 
 alpha01_nx064_nz14_fwhm150, alpha01_nx064_nz14_fwhm175, alpha01_nx064_nz14_fwhm200, 
 alpha01_nx064_nz14_fwhm225, alpha01_nx064_nz14_fwhm250, alpha01_nx064_nz14_fwhm275, 
 alpha01_nx064_nz14_fwhm300, alpha01_nx064_nz14_fwhm325, alpha01_nx064_nz14_fwhm350, 
 alpha01_nx064_nz14_fwhm375, alpha01_nx064_nz14_fwhm400, alpha01_nx064_nz14_fwhm425, 
 alpha01_nx064_nz14_fwhm450, alpha01_nx064_nz14_fwhm475, alpha01_nx064_nz14_fwhm500} ;

static float alpha05_nx064_nz14_fwhm000[32] = {
 1.95,1.95,1.95,1.96,1.96,1.96,1.97,1.98,2.00,2.21,
 2.37,2.49,2.57,2.74,2.82,2.88,2.92,2.95,2.99,3.31,
 3.60,3.76,3.85,3.90,3.95,4.42,4.79,4.99,5.75,6.13,
 7.34,8.47};
static float alpha05_nx064_nz14_fwhm025[32] = {
 1.95,1.95,1.95,1.96,1.96,1.96,1.97,1.98,2.00,2.21,
 2.37,2.49,2.57,2.74,2.82,2.88,2.92,2.95,2.99,3.31,
 3.60,3.76,3.85,3.90,3.95,4.42,4.79,4.99,5.75,6.13,
 7.34,8.47};
static float alpha05_nx064_nz14_fwhm050[32] = {
 1.95,1.95,1.95,1.96,1.96,1.96,1.97,1.99,2.06,2.29,
 2.43,2.54,2.62,2.76,2.84,2.89,2.93,2.96,2.99,3.42,
 3.67,3.80,3.88,3.93,3.97,4.55,4.85,5.21,5.84,6.37,
 7.57,8.68};
static float alpha05_nx064_nz14_fwhm075[32] = {
 1.95,1.95,1.96,1.96,1.97,1.97,1.99,2.17,2.40,2.55,
 2.64,2.71,2.76,2.85,2.90,2.94,2.97,2.99,3.47,3.73,
 3.85,3.92,3.97,4.16,4.48,4.87,5.20,5.82,6.45,6.98,
 8.34,9.84};
static float alpha05_nx064_nz14_fwhm100[32] = {
 1.96,1.97,1.97,1.98,2.00,2.23,2.53,2.66,2.76,2.81,
 2.85,2.88,2.90,2.95,2.98,3.20,3.54,3.73,3.91,4.01,
 4.47,4.73,4.87,4.97,5.23,5.86,6.44,7.03,7.97,8.91,
 10.96,12.98};
static float alpha05_nx064_nz14_fwhm125[32] = {
 1.99,2.24,2.42,2.59,2.72,2.79,2.88,2.93,2.96,2.99,
 3.09,3.32,3.45,3.73,3.86,3.98,4.42,4.71,4.98,5.55,
 5.87,6.24,6.66,6.92,7.30,8.26,9.06,10.50,11.96,13.59,
 16.91,20.69};
static float alpha05_nx064_nz14_fwhm150[32] = {
 2.76,2.86,2.92,2.97,3.17,3.42,3.71,3.88,3.98,4.26,
 4.50,4.67,4.79,5.08,5.56,5.91,6.46,6.87,7.74,8.53,
 9.25,9.89,10.50,11.10,11.76,13.61,15.42,17.74,20.71,24.08,
 30.71,38.71};
static float alpha05_nx064_nz14_fwhm175[32] = {
 3.64,3.87,4.02,4.43,4.72,4.92,5.48,5.88,6.28,6.61,
 6.91,7.20,7.49,8.16,8.79,9.58,10.52,11.30,12.76,14.01,
 15.33,16.61,17.70,18.87,19.93,23.45,26.71,31.33,37.10,43.00,
 56.86,73.33};
static float alpha05_nx064_nz14_fwhm200[32] = {
 5.32,5.81,6.23,6.71,7.19,7.64,8.35,8.93,9.59,10.07,
 10.64,11.06,11.53,12.69,13.72,14.91,16.36,17.75,20.28,22.40,
 24.55,26.51,28.50,30.24,32.08,37.86,43.40,50.56,60.19,70.67,
 95.30,122.37};
static float alpha05_nx064_nz14_fwhm225[32] = {
 7.50,8.22,8.77,9.40,10.12,10.76,11.83,12.82,13.68,14.49,
 15.14,15.89,16.48,18.23,19.81,21.77,23.88,25.73,29.21,32.38,
 35.41,38.49,41.40,43.96,46.83,54.76,62.47,74.22,88.91,104.36,
 138.18,179.62};
static float alpha05_nx064_nz14_fwhm250[32] = {
 9.82,10.63,11.43,12.27,13.25,14.27,15.71,17.03,18.21,19.18,
 20.13,21.17,21.85,24.37,26.46,29.08,31.69,34.24,38.81,43.34,
 47.55,51.40,55.49,59.07,62.96,74.05,85.86,100.39,118.65,139.47,
 184.21,234.67};
static float alpha05_nx064_nz14_fwhm275[32] = {
 12.11,13.25,14.33,15.51,16.55,17.64,19.73,21.36,22.75,23.97,
 25.44,26.68,27.74,30.72,33.33,36.57,40.07,43.39,49.78,55.57,
 60.76,65.77,70.57,75.46,80.23,94.58,108.46,125.95,149.74,175.08,
 229.44,300.33};
static float alpha05_nx064_nz14_fwhm300[32] = {
 14.50,15.90,17.08,18.53,20.15,21.44,23.83,25.79,27.67,29.41,
 30.93,32.50,33.95,37.19,40.65,44.67,49.09,53.39,61.60,68.00,
 74.14,80.62,87.23,92.62,98.38,114.58,131.32,154.57,183.42,211.91,
 280.86,363.62};
static float alpha05_nx064_nz14_fwhm325[32] = {
 16.85,18.53,19.87,21.50,23.50,25.03,28.11,30.57,32.77,34.56,
 36.56,38.31,40.05,44.65,48.37,53.39,58.95,64.24,72.72,81.23,
 89.00,96.25,103.43,110.75,116.89,136.82,157.53,182.33,215.95,254.73,
 332.25,425.69};
static float alpha05_nx064_nz14_fwhm350[32] = {
 19.07,21.06,22.80,24.91,27.11,29.07,32.42,35.42,38.25,40.44,
 42.72,44.62,46.61,51.72,56.68,62.51,68.29,74.32,85.18,95.05,
 104.06,112.42,121.38,128.94,136.90,160.50,182.24,212.60,253.67,295.73,
 384.33,489.40};
static float alpha05_nx064_nz14_fwhm375[32] = {
 21.56,23.64,25.63,27.98,30.69,32.86,36.84,40.42,43.27,46.00,
 48.60,51.14,53.49,59.27,64.59,70.68,78.20,85.18,97.48,108.31,
 119.83,129.78,139.25,148.31,157.00,183.38,209.57,244.50,289.36,336.12,
 441.67,555.00};
static float alpha05_nx064_nz14_fwhm400[32] = {
 23.95,26.46,28.64,31.55,34.39,36.78,41.44,45.00,48.63,51.77,
 54.93,57.54,59.94,66.94,72.77,79.93,88.56,95.90,110.00,123.39,
 135.42,146.18,156.79,166.57,176.93,207.10,236.91,277.83,329.44,379.83,
 492.00,621.80};
static float alpha05_nx064_nz14_fwhm425[32] = {
 25.90,29.12,31.62,34.55,37.55,40.61,45.44,50.00,54.07,57.50,
 60.68,64.00,66.74,74.07,80.92,89.42,99.00,107.14,123.00,137.64,
 150.69,163.00,175.33,186.33,198.11,232.17,263.87,310.90,366.00,425.33,
 549.80,690.33};
static float alpha05_nx064_nz14_fwhm450[32] = {
 27.79,31.07,34.03,37.33,41.06,44.41,50.11,54.74,59.22,62.93,
 66.74,70.10,73.00,81.92,89.52,97.96,109.10,117.95,135.87,152.21,
 166.38,180.82,193.00,207.33,220.67,258.12,295.56,345.60,408.38,471.50,
 612.17,761.20};
static float alpha05_nx064_nz14_fwhm475[32] = {
 29.30,33.32,36.53,40.59,44.88,48.22,54.11,59.56,64.00,68.47,
 72.70,76.39,80.14,89.41,97.71,107.95,118.45,129.23,149.00,165.93,
 183.22,199.75,214.38,227.93,242.90,285.77,326.00,381.00,448.43,519.00,
 673.33,837.00};
static float alpha05_nx064_nz14_fwhm500[32] = {
 31.31,35.60,38.86,43.54,47.50,51.19,58.07,64.13,69.23,73.68,
 78.26,82.19,85.73,96.92,105.87,116.67,129.20,140.86,162.25,181.63,
 200.06,217.00,234.50,250.60,266.50,311.80,357.00,415.00,489.40,569.20,
 737.00,919.25};
static float *alpha05_nx064_nz14[21] = {
 alpha05_nx064_nz14_fwhm000, alpha05_nx064_nz14_fwhm025, alpha05_nx064_nz14_fwhm050, 
 alpha05_nx064_nz14_fwhm075, alpha05_nx064_nz14_fwhm100, alpha05_nx064_nz14_fwhm125, 
 alpha05_nx064_nz14_fwhm150, alpha05_nx064_nz14_fwhm175, alpha05_nx064_nz14_fwhm200, 
 alpha05_nx064_nz14_fwhm225, alpha05_nx064_nz14_fwhm250, alpha05_nx064_nz14_fwhm275, 
 alpha05_nx064_nz14_fwhm300, alpha05_nx064_nz14_fwhm325, alpha05_nx064_nz14_fwhm350, 
 alpha05_nx064_nz14_fwhm375, alpha05_nx064_nz14_fwhm400, alpha05_nx064_nz14_fwhm425, 
 alpha05_nx064_nz14_fwhm450, alpha05_nx064_nz14_fwhm475, alpha05_nx064_nz14_fwhm500} ;

static float alpha10_nx064_nz14_fwhm000[32] = {
 1.90,1.90,1.90,1.90,1.91,1.91,1.92,1.93,1.94,1.96,
 1.98,2.00,2.14,2.47,2.63,2.75,2.83,2.87,2.93,2.97,
 3.17,3.48,3.65,3.75,3.83,3.97,4.48,4.83,5.31,5.82,
 6.82,7.84};
static float alpha10_nx064_nz14_fwhm025[32] = {
 1.90,1.90,1.90,1.90,1.91,1.91,1.92,1.93,1.94,1.96,
 1.98,2.00,2.14,2.47,2.63,2.75,2.83,2.87,2.93,2.97,
 3.17,3.48,3.65,3.75,3.83,3.97,4.48,4.83,5.31,5.82,
 6.83,7.84};
static float alpha10_nx064_nz14_fwhm050[32] = {
 1.90,1.90,1.90,1.91,1.91,1.91,1.92,1.94,1.95,1.97,
 1.99,2.07,2.24,2.52,2.67,2.77,2.84,2.88,2.93,2.98,
 3.30,3.55,3.70,3.79,3.86,4.00,4.58,4.89,5.48,5.90,
 6.95,7.96};
static float alpha10_nx064_nz14_fwhm075[32] = {
 1.90,1.90,1.91,1.91,1.92,1.92,1.94,1.96,1.98,2.09,
 2.27,2.41,2.51,2.68,2.78,2.85,2.90,2.93,2.99,3.41,
 3.64,3.78,3.86,3.92,3.98,4.61,4.88,5.41,5.92,6.61,
 7.78,9.07};
static float alpha10_nx064_nz14_fwhm100[32] = {
 1.91,1.91,1.92,1.93,1.94,1.96,2.05,2.32,2.50,2.61,
 2.69,2.74,2.78,2.86,2.90,2.95,3.03,3.39,3.72,3.88,
 3.98,4.31,4.58,4.76,4.88,5.47,5.90,6.65,7.48,8.29,
 10.06,11.97};
static float alpha10_nx064_nz14_fwhm125[32] = {
 1.94,1.96,1.98,2.15,2.41,2.55,2.72,2.80,2.86,2.90,
 2.93,2.96,2.98,3.35,3.61,3.80,3.95,4.23,4.72,4.96,
 5.43,5.76,5.97,6.39,6.72,7.62,8.43,9.62,10.95,12.48,
 15.54,18.88};
static float alpha10_nx064_nz14_fwhm150[32] = {
 2.45,2.62,2.73,2.82,2.90,2.95,3.24,3.53,3.71,3.84,
 3.94,4.06,4.27,4.68,4.91,5.36,5.81,6.19,6.94,7.71,
 8.36,8.89,9.49,10.02,10.64,12.28,13.91,15.99,18.67,21.68,
 27.80,34.74};
static float alpha10_nx064_nz14_fwhm175[32] = {
 2.98,3.35,3.60,3.81,3.99,4.33,4.77,5.07,5.51,5.79,
 6.00,6.36,6.62,7.24,7.81,8.53,9.34,9.98,11.39,12.54,
 13.67,14.78,15.77,16.86,17.89,21.01,24.08,28.01,33.23,38.71,
 50.85,64.94};
static float alpha10_nx064_nz14_fwhm200[32] = {
 4.47,4.83,5.16,5.65,6.05,6.51,7.16,7.77,8.31,8.79,
 9.23,9.63,9.99,10.97,11.95,13.07,14.39,15.57,17.74,19.79,
 21.67,23.57,25.29,26.96,28.65,33.63,38.60,45.44,54.03,62.83,
 83.38,108.53};
static float alpha10_nx064_nz14_fwhm225[32] = {
 6.11,6.75,7.33,7.93,8.58,9.05,10.07,10.90,11.64,12.29,
 12.89,13.51,14.04,15.68,17.00,18.78,20.68,22.39,25.58,28.49,
 31.21,33.82,36.41,38.92,41.35,48.77,55.43,65.01,77.89,91.48,
 121.89,159.16};
static float alpha10_nx064_nz14_fwhm250[32] = {
 7.94,8.70,9.37,10.18,11.01,11.75,13.07,14.26,15.31,16.23,
 17.18,17.90,18.75,20.86,22.62,24.93,27.29,29.55,33.81,37.70,
 41.41,44.99,48.37,51.67,54.99,64.62,74.11,87.54,104.31,122.28,
 162.39,208.84};
static float alpha10_nx064_nz14_fwhm275[32] = {
 9.56,10.64,11.50,12.48,13.55,14.54,16.20,17.78,19.02,20.25,
 21.43,22.52,23.52,26.15,28.37,31.13,34.20,37.26,42.74,47.83,
 52.52,57.08,61.38,65.23,69.52,81.78,94.47,110.43,131.70,153.86,
 202.22,260.57};
static float alpha10_nx064_nz14_fwhm300[32] = {
 11.17,12.49,13.56,14.77,16.01,17.33,19.51,21.20,22.94,24.39,
 25.72,27.02,28.29,31.48,34.40,38.02,41.89,45.56,52.11,58.25,
 64.05,69.46,74.88,79.93,85.18,100.28,115.34,134.41,159.71,185.58,
 245.28,315.35};
static float alpha10_nx064_nz14_fwhm325[32] = {
 12.79,14.29,15.56,17.06,18.71,20.13,22.76,24.90,26.87,28.68,
 30.20,31.78,33.23,37.30,40.62,44.79,49.37,53.86,61.62,69.33,
 75.97,82.96,89.29,95.63,101.38,118.65,135.10,159.30,188.50,220.96,
 288.47,367.36};
static float alpha10_nx064_nz14_fwhm350[32] = {
 14.42,16.15,17.54,19.21,21.11,22.85,25.84,28.52,30.75,32.89,
 34.79,36.49,38.26,42.84,46.69,51.40,57.05,62.09,71.84,80.31,
 88.63,96.23,103.22,110.37,116.86,138.62,157.50,184.15,218.29,254.20,
 333.56,424.89};
static float alpha10_nx064_nz14_fwhm375[32] = {
 15.77,17.84,19.50,21.47,23.69,25.82,28.99,32.14,34.71,37.04,
 39.29,41.29,43.19,48.32,52.74,58.71,65.47,71.32,82.00,91.57,
 100.78,109.34,117.78,126.29,134.17,157.30,180.21,210.14,250.22,290.79,
 378.62,479.70};
static float alpha10_nx064_nz14_fwhm400[32] = {
 17.11,19.35,21.22,23.68,26.06,28.41,32.10,35.57,38.47,41.16,
 43.67,45.98,48.12,54.45,59.91,66.25,73.39,80.41,92.28,103.36,
 113.19,122.91,132.68,141.88,150.56,176.80,202.40,238.05,280.65,326.77,
 426.50,537.31};
static float alpha10_nx064_nz14_fwhm425[32] = {
 18.21,20.80,22.98,25.64,28.25,30.76,34.99,39.00,42.29,45.48,
 48.45,50.98,53.68,60.08,66.37,72.98,81.80,88.68,102.71,114.71,
 126.28,137.08,148.10,158.35,168.00,196.87,225.77,264.36,313.21,362.20,
 473.62,594.25};
static float alpha10_nx064_nz14_fwhm450[32] = {
 19.23,22.21,24.45,27.35,30.38,33.06,38.29,42.45,46.15,49.49,
 52.65,55.55,58.36,65.82,72.26,79.93,89.48,97.97,113.03,126.47,
 139.38,151.90,163.00,174.75,185.31,218.56,249.58,291.69,346.17,400.80,
 520.40,652.60};
static float alpha10_nx064_nz14_fwhm475[32] = {
 20.36,23.14,25.83,29.25,32.51,35.83,41.20,45.67,49.86,53.68,
 57.16,60.16,63.05,71.35,78.74,87.39,97.71,106.70,123.08,139.11,
 153.20,165.61,177.96,190.43,203.61,239.00,274.29,320.29,377.60,437.29,
 567.92,712.17};
static float alpha10_nx064_nz14_fwhm500[32] = {
 20.71,24.10,27.27,30.91,34.65,38.14,43.65,48.63,53.33,57.33,
 61.07,64.61,67.95,77.16,85.18,94.43,105.23,115.21,134.65,150.94,
 166.09,180.03,193.48,207.74,221.35,260.08,297.40,348.46,410.33,476.75,
 617.88,772.60};
static float *alpha10_nx064_nz14[21] = {
 alpha10_nx064_nz14_fwhm000, alpha10_nx064_nz14_fwhm025, alpha10_nx064_nz14_fwhm050, 
 alpha10_nx064_nz14_fwhm075, alpha10_nx064_nz14_fwhm100, alpha10_nx064_nz14_fwhm125, 
 alpha10_nx064_nz14_fwhm150, alpha10_nx064_nz14_fwhm175, alpha10_nx064_nz14_fwhm200, 
 alpha10_nx064_nz14_fwhm225, alpha10_nx064_nz14_fwhm250, alpha10_nx064_nz14_fwhm275, 
 alpha10_nx064_nz14_fwhm300, alpha10_nx064_nz14_fwhm325, alpha10_nx064_nz14_fwhm350, 
 alpha10_nx064_nz14_fwhm375, alpha10_nx064_nz14_fwhm400, alpha10_nx064_nz14_fwhm425, 
 alpha10_nx064_nz14_fwhm450, alpha10_nx064_nz14_fwhm475, alpha10_nx064_nz14_fwhm500} ;

static float **nx064_nz14[3] = {
  alpha01_nx064_nz14 , alpha05_nx064_nz14 , alpha10_nx064_nz14 };

static float alpha01_nx064_nz15_fwhm000[32] = {
 1.99,1.99,1.99,2.00,2.00,2.27,2.59,2.73,2.81,2.85,
 2.88,2.91,2.93,2.96,2.97,2.99,3.00,3.41,3.76,3.90,
 3.97,4.00,4.28,4.55,4.73,4.96,5.52,5.95,6.69,7.07,
 8.61,9.91};
static float alpha01_nx064_nz15_fwhm025[32] = {
 1.99,1.99,1.99,2.00,2.00,2.27,2.59,2.73,2.81,2.85,
 2.88,2.91,2.93,2.96,2.97,2.99,3.00,3.41,3.76,3.90,
 3.97,4.00,4.28,4.55,4.73,4.96,5.52,5.95,6.69,7.07,
 8.61,9.91};
static float alpha01_nx064_nz15_fwhm050[32] = {
 1.99,1.99,1.99,2.00,2.07,2.35,2.65,2.76,2.82,2.87,
 2.90,2.92,2.93,2.96,2.98,2.99,3.06,3.54,3.82,3.93,
 3.98,4.09,4.44,4.64,4.79,4.99,5.67,5.99,6.81,7.42,
 8.76,10.09};
static float alpha01_nx064_nz15_fwhm075[32] = {
 1.99,2.00,2.00,2.18,2.50,2.65,2.78,2.85,2.90,2.92,
 2.94,2.95,2.96,2.98,2.99,3.25,3.64,3.81,3.94,3.99,
 4.38,4.66,4.83,4.92,4.99,5.69,5.99,6.75,7.50,8.16,
 9.85,11.50};
static float alpha01_nx064_nz15_fwhm100[32] = {
 2.14,2.42,2.60,2.73,2.82,2.87,2.92,2.95,2.97,2.98,
 2.99,2.99,3.11,3.56,3.79,3.90,3.96,4.13,4.65,4.87,
 4.99,5.50,5.74,5.89,6.01,6.85,7.56,8.43,9.54,10.67,
 12.84,15.32};
static float alpha01_nx064_nz15_fwhm125[32] = {
 2.80,2.87,2.91,2.95,2.97,2.99,3.27,3.59,3.76,3.84,
 3.89,3.94,3.97,4.32,4.69,4.89,5.05,5.58,5.98,6.59,
 6.95,7.50,7.88,8.27,8.79,9.84,10.96,12.58,14.44,16.54,
 20.86,25.47};
static float alpha01_nx064_nz15_fwhm150[32] = {
 3.30,3.56,3.73,3.87,3.97,4.19,4.64,4.85,4.99,5.32,
 5.59,5.77,5.90,6.46,6.81,7.42,7.88,8.48,9.55,10.44,
 11.11,11.91,12.67,13.41,14.11,16.52,18.76,21.67,25.63,29.87,
 38.54,48.81};
static float alpha01_nx064_nz15_fwhm175[32] = {
 4.89,5.08,5.61,5.94,6.36,6.64,7.12,7.59,7.93,8.40,
 8.77,8.98,9.34,10.38,11.16,11.97,13.16,14.16,15.88,17.65,
 19.22,20.78,22.76,24.15,25.43,29.96,33.95,39.77,46.29,54.62,
 72.58,92.64};
static float alpha01_nx064_nz15_fwhm200[32] = {
 7.48,8.04,8.53,8.88,9.66,10.17,11.13,11.96,12.70,13.40,
 14.02,14.55,15.00,16.46,17.88,19.51,21.53,23.41,26.60,29.30,
 31.78,34.38,37.10,39.70,41.75,49.29,56.10,65.45,77.44,91.25,
 122.80,158.00};
static float alpha01_nx064_nz15_fwhm225[32] = {
 10.79,11.65,12.35,13.15,14.09,14.94,16.38,17.50,18.58,19.79,
 20.83,21.59,22.39,24.80,26.63,29.25,31.93,34.58,38.88,43.14,
 47.14,50.96,54.53,58.10,61.71,72.14,82.88,96.67,115.40,135.00,
 184.25,234.25};
static float alpha01_nx064_nz15_fwhm250[32] = {
 14.67,15.74,16.64,17.84,19.05,20.21,22.20,24.12,25.29,26.96,
 28.06,29.25,30.69,33.42,36.45,39.71,43.40,46.36,52.62,58.43,
 63.50,67.80,72.90,78.10,82.21,97.00,111.60,132.33,156.80,186.00,
 240.00,308.00};
static float alpha01_nx064_nz15_fwhm275[32] = {
 18.75,19.93,21.24,23.06,24.30,25.81,28.68,30.88,33.27,34.89,
 36.56,38.06,39.55,43.27,46.60,51.44,55.50,59.43,67.67,74.62,
 80.92,88.58,94.56,101.11,106.71,126.20,143.50,168.25,199.50,232.00,
 301.33,394.50};
static float alpha01_nx064_nz15_fwhm300[32] = {
 22.81,24.62,26.50,28.50,30.50,32.72,36.33,39.31,41.25,43.46,
 45.17,47.27,49.00,53.77,57.50,63.00,68.45,73.33,83.55,92.57,
 101.73,108.12,115.88,123.20,133.17,153.89,176.33,205.20,240.75,282.25,
 377.40,481.25};
static float alpha01_nx064_nz15_fwhm325[32] = {
 27.79,30.25,32.44,34.78,37.57,40.00,43.75,46.60,49.20,52.00,
 54.18,56.45,58.40,64.73,69.67,75.38,82.50,89.17,100.50,109.78,
 119.83,129.88,140.40,150.71,159.20,184.25,209.00,243.29,296.50,341.00,
 446.00,580.00};
static float alpha01_nx064_nz15_fwhm350[32] = {
 32.94,35.75,38.45,41.08,44.21,46.50,50.36,54.82,58.20,61.33,
 64.17,66.25,68.89,75.00,81.89,89.57,96.62,104.00,116.67,130.00,
 142.25,153.40,164.25,177.33,185.20,216.00,243.50,285.50,340.00,398.00,
 525.00,683.40};
static float alpha01_nx064_nz15_fwhm375[32] = {
 37.85,40.87,44.23,47.10,50.67,53.25,58.56,63.11,66.50,69.88,
 72.55,75.82,79.12,86.80,92.75,101.20,110.75,118.33,135.75,149.50,
 163.50,176.33,191.00,203.75,215.00,248.67,280.80,332.00,390.67,459.00,
 607.00,771.00};
static float alpha01_nx064_nz15_fwhm400[32] = {
 43.00,46.44,49.56,53.18,56.75,59.88,64.50,70.44,75.10,78.88,
 83.00,85.89,89.00,97.50,105.80,115.67,126.50,136.36,152.50,169.80,
 187.00,202.33,219.00,232.00,243.40,282.00,322.50,378.00,448.00,524.00,
 685.33,871.00};
static float alpha01_nx064_nz15_fwhm425[32] = {
 47.30,51.00,54.38,58.30,63.44,66.89,73.50,78.80,84.38,88.67,
 92.67,96.67,100.00,110.40,120.00,129.67,141.00,152.00,175.00,193.00,
 213.33,230.00,246.40,260.50,275.00,317.33,364.50,427.80,505.00,589.67,
 765.50,985.00};
static float alpha01_nx064_nz15_fwhm450[32] = {
 51.36,56.25,60.62,64.50,69.43,74.25,82.00,88.00,93.55,98.50,
 103.00,107.00,111.50,121.17,129.60,143.50,156.00,172.00,196.75,220.40,
 239.50,256.67,273.00,288.80,309.50,358.00,412.00,484.00,561.00,664.00,
 868.00,1088.67};
static float alpha01_nx064_nz15_fwhm475[32] = {
 57.08,61.71,66.17,71.33,76.33,81.60,89.62,96.50,102.00,107.50,
 112.67,117.29,120.75,131.78,145.33,159.00,177.00,193.40,219.50,245.50,
 265.00,283.57,305.00,323.00,342.50,398.33,457.00,526.67,623.00,731.33,
 962.00,1205.00};
static float alpha01_nx064_nz15_fwhm500[32] = {
 61.60,67.00,71.00,78.00,84.00,88.50,96.57,104.33,110.75,117.25,
 122.25,127.00,131.50,146.67,161.50,178.50,195.67,212.67,242.40,266.75,
 290.00,312.50,333.00,354.67,376.00,436.00,494.00,580.67,690.00,813.50,
 1052.00,1290.33};
static float *alpha01_nx064_nz15[21] = {
 alpha01_nx064_nz15_fwhm000, alpha01_nx064_nz15_fwhm025, alpha01_nx064_nz15_fwhm050, 
 alpha01_nx064_nz15_fwhm075, alpha01_nx064_nz15_fwhm100, alpha01_nx064_nz15_fwhm125, 
 alpha01_nx064_nz15_fwhm150, alpha01_nx064_nz15_fwhm175, alpha01_nx064_nz15_fwhm200, 
 alpha01_nx064_nz15_fwhm225, alpha01_nx064_nz15_fwhm250, alpha01_nx064_nz15_fwhm275, 
 alpha01_nx064_nz15_fwhm300, alpha01_nx064_nz15_fwhm325, alpha01_nx064_nz15_fwhm350, 
 alpha01_nx064_nz15_fwhm375, alpha01_nx064_nz15_fwhm400, alpha01_nx064_nz15_fwhm425, 
 alpha01_nx064_nz15_fwhm450, alpha01_nx064_nz15_fwhm475, alpha01_nx064_nz15_fwhm500} ;

static float alpha05_nx064_nz15_fwhm000[32] = {
 1.95,1.95,1.95,1.96,1.96,1.96,1.97,1.99,2.03,2.25,
 2.41,2.53,2.61,2.76,2.84,2.89,2.93,2.95,2.99,3.34,
 3.63,3.78,3.86,3.91,3.96,4.46,4.82,5.17,5.79,6.26,
 7.38,8.59};
static float alpha05_nx064_nz15_fwhm025[32] = {
 1.95,1.95,1.95,1.96,1.96,1.96,1.97,1.99,2.03,2.25,
 2.41,2.53,2.61,2.76,2.84,2.89,2.93,2.95,2.99,3.34,
 3.63,3.78,3.86,3.91,3.96,4.46,4.82,5.17,5.79,6.26,
 7.38,8.59};
static float alpha05_nx064_nz15_fwhm050[32] = {
 1.95,1.95,1.95,1.96,1.96,1.96,1.98,1.99,2.11,2.33,
 2.47,2.57,2.65,2.79,2.85,2.90,2.93,2.96,3.00,3.45,
 3.69,3.81,3.89,3.94,3.98,4.57,4.87,5.34,5.87,6.46,
 7.58,8.78};
static float alpha05_nx064_nz15_fwhm075[32] = {
 1.95,1.96,1.96,1.96,1.97,1.98,1.99,2.25,2.46,2.59,
 2.67,2.74,2.78,2.86,2.90,2.94,2.97,2.99,3.51,3.74,
 3.86,3.93,3.98,4.25,4.53,4.88,5.30,5.84,6.51,6.99,
 8.54,9.90};
static float alpha05_nx064_nz15_fwhm100[32] = {
 1.96,1.97,1.97,1.99,2.05,2.28,2.56,2.70,2.78,2.83,
 2.86,2.89,2.91,2.95,2.98,3.28,3.59,3.75,3.91,4.03,
 4.47,4.73,4.88,4.97,5.26,5.88,6.47,7.06,7.99,8.97,
 10.95,13.02};
static float alpha05_nx064_nz15_fwhm125[32] = {
 2.00,2.27,2.47,2.62,2.74,2.81,2.89,2.93,2.97,2.99,
 3.18,3.38,3.53,3.76,3.89,3.99,4.43,4.69,4.97,5.57,
 5.88,6.25,6.68,6.94,7.38,8.27,9.23,10.46,11.97,13.69,
 17.11,21.14};
static float alpha05_nx064_nz15_fwhm150[32] = {
 2.77,2.87,2.92,2.98,3.20,3.45,3.74,3.90,3.99,4.32,
 4.53,4.68,4.80,5.11,5.61,5.95,6.54,6.92,7.81,8.55,
 9.25,9.89,10.55,11.16,11.83,13.69,15.52,17.87,20.92,24.21,
 31.43,39.52};
static float alpha05_nx064_nz15_fwhm175[32] = {
 3.71,3.92,4.14,4.52,4.81,4.98,5.57,5.89,6.30,6.64,
 6.87,7.17,7.50,8.20,8.89,9.68,10.57,11.38,12.81,14.09,
 15.43,16.77,17.94,18.98,20.16,23.71,27.20,31.99,37.49,43.81,
 57.67,75.27};
static float alpha05_nx064_nz15_fwhm200[32] = {
 5.35,5.81,6.24,6.75,7.28,7.76,8.52,9.11,9.74,10.22,
 10.71,11.18,11.59,12.81,13.87,15.08,16.57,17.77,20.14,22.43,
 24.49,26.73,28.80,30.88,32.94,38.65,44.37,52.09,61.95,72.74,
 96.12,124.33};
static float alpha05_nx064_nz15_fwhm225[32] = {
 7.63,8.24,8.83,9.59,10.27,10.93,11.95,12.87,13.76,14.64,
 15.31,15.92,16.55,18.25,19.77,21.67,23.74,25.68,29.55,32.95,
 36.20,39.16,41.97,45.18,48.24,56.43,64.87,75.98,90.51,105.95,
 141.83,184.16};
static float alpha05_nx064_nz15_fwhm250[32] = {
 9.88,10.79,11.60,12.43,13.32,14.26,15.90,17.13,18.30,19.33,
 20.31,21.23,22.11,24.48,26.57,29.15,31.96,34.68,39.62,44.53,
 48.84,52.91,56.78,60.78,64.68,76.11,86.97,102.26,121.83,142.12,
 188.00,244.60};
static float alpha05_nx064_nz15_fwhm275[32] = {
 12.26,13.51,14.57,15.64,16.85,17.87,19.88,21.55,23.16,24.51,
 25.83,26.99,28.00,30.94,33.69,37.10,40.88,44.65,51.02,56.79,
 62.16,67.45,72.89,77.44,82.52,97.20,110.70,129.30,154.89,179.08,
 237.69,309.44};
static float alpha05_nx064_nz15_fwhm300[32] = {
 14.71,16.17,17.40,18.80,20.47,21.94,24.23,26.37,28.34,29.91,
 31.41,32.87,34.36,38.20,41.62,45.76,50.05,54.60,62.54,69.72,
 76.77,83.06,89.28,95.50,101.56,118.15,135.29,157.70,188.17,221.14,
 289.91,375.20};
static float alpha05_nx064_nz15_fwhm325[32] = {
 17.25,19.04,20.47,22.34,24.40,25.94,28.98,31.39,33.79,35.84,
 37.89,39.46,41.15,45.93,49.91,54.76,60.40,65.75,75.43,83.72,
 91.52,99.19,106.35,114.00,120.67,140.11,160.21,188.00,223.45,260.40,
 345.80,437.25};
static float alpha05_nx064_nz15_fwhm350[32] = {
 19.75,21.77,23.69,26.05,28.19,30.18,33.58,36.80,39.52,41.85,
 44.22,46.27,48.15,53.62,58.47,64.07,71.10,77.59,87.58,97.32,
 106.71,115.65,123.57,131.55,139.54,163.15,185.75,218.90,261.36,303.00,
 402.08,512.33};
static float alpha05_nx064_nz15_fwhm375[32] = {
 22.31,24.89,26.91,29.56,32.10,34.39,38.83,42.27,44.95,47.81,
 50.50,52.79,55.24,61.28,66.79,73.52,81.00,87.75,100.17,111.57,
 121.08,130.91,141.06,151.00,160.00,186.94,214.50,252.09,299.44,350.25,
 455.25,580.83};
static float alpha05_nx064_nz15_fwhm400[32] = {
 25.00,27.77,30.19,32.90,35.96,38.76,43.42,47.26,50.68,54.16,
 57.22,59.70,62.14,68.70,75.29,82.96,91.25,98.84,112.31,125.38,
 137.05,147.69,158.71,170.62,182.00,212.27,242.73,287.78,339.38,398.11,
 513.40,651.50};
static float alpha05_nx064_nz15_fwhm425[32] = {
 27.59,30.79,33.45,37.10,39.85,42.66,48.31,52.54,56.62,60.14,
 63.43,66.27,68.90,76.87,83.60,92.00,101.56,110.45,126.11,139.38,
 152.00,165.91,179.00,190.47,202.75,237.64,274.67,321.20,380.33,443.00,
 572.00,724.67};
static float alpha05_nx064_nz15_fwhm450[32] = {
 29.98,33.66,36.53,39.74,43.56,46.94,52.77,58.00,62.19,65.81,
 69.58,72.96,76.00,84.86,92.72,100.96,112.25,122.29,138.80,154.36,
 170.00,184.69,198.31,211.60,225.38,265.86,304.83,360.73,423.71,491.10,
 632.83,805.50};
static float alpha05_nx064_nz15_fwhm475[32] = {
 32.39,35.95,39.41,43.24,47.46,50.81,56.93,62.36,67.09,71.43,
 75.70,79.75,83.24,92.88,100.80,110.94,123.04,133.64,152.50,170.30,
 187.64,203.20,219.53,234.17,248.00,293.40,339.12,394.80,467.00,539.50,
 692.67,887.40};
static float alpha05_nx064_nz15_fwhm500[32] = {
 34.39,38.54,42.21,46.30,50.94,54.77,61.46,67.17,72.78,77.32,
 81.48,86.24,90.00,100.39,109.16,120.87,134.16,146.15,165.43,185.56,
 205.38,222.25,239.67,257.17,273.33,323.25,370.50,431.00,511.67,588.75,
 759.67,963.50};
static float *alpha05_nx064_nz15[21] = {
 alpha05_nx064_nz15_fwhm000, alpha05_nx064_nz15_fwhm025, alpha05_nx064_nz15_fwhm050, 
 alpha05_nx064_nz15_fwhm075, alpha05_nx064_nz15_fwhm100, alpha05_nx064_nz15_fwhm125, 
 alpha05_nx064_nz15_fwhm150, alpha05_nx064_nz15_fwhm175, alpha05_nx064_nz15_fwhm200, 
 alpha05_nx064_nz15_fwhm225, alpha05_nx064_nz15_fwhm250, alpha05_nx064_nz15_fwhm275, 
 alpha05_nx064_nz15_fwhm300, alpha05_nx064_nz15_fwhm325, alpha05_nx064_nz15_fwhm350, 
 alpha05_nx064_nz15_fwhm375, alpha05_nx064_nz15_fwhm400, alpha05_nx064_nz15_fwhm425, 
 alpha05_nx064_nz15_fwhm450, alpha05_nx064_nz15_fwhm475, alpha05_nx064_nz15_fwhm500} ;

static float alpha10_nx064_nz15_fwhm000[32] = {
 1.90,1.90,1.90,1.91,1.91,1.91,1.92,1.93,1.95,1.96,
 1.98,2.05,2.21,2.52,2.66,2.77,2.84,2.88,2.93,2.97,
 3.21,3.50,3.66,3.77,3.84,3.98,4.53,4.88,5.39,5.85,
 6.85,7.91};
static float alpha10_nx064_nz15_fwhm025[32] = {
 1.90,1.90,1.90,1.91,1.91,1.91,1.92,1.93,1.95,1.96,
 1.98,2.05,2.21,2.52,2.66,2.77,2.84,2.88,2.93,2.97,
 3.21,3.50,3.66,3.77,3.84,3.98,4.53,4.88,5.39,5.85,
 6.85,7.91};
static float alpha10_nx064_nz15_fwhm050[32] = {
 1.90,1.90,1.90,1.91,1.91,1.91,1.93,1.94,1.95,1.97,
 1.99,2.14,2.29,2.57,2.69,2.79,2.85,2.89,2.94,2.99,
 3.33,3.57,3.72,3.80,3.87,4.05,4.62,4.92,5.53,5.93,
 6.95,8.10};
static float alpha10_nx064_nz15_fwhm075[32] = {
 1.90,1.91,1.91,1.91,1.92,1.93,1.94,1.96,1.99,2.17,
 2.34,2.46,2.55,2.71,2.79,2.85,2.90,2.93,3.00,3.43,
 3.66,3.79,3.87,3.94,3.99,4.63,4.91,5.48,5.95,6.67,
 7.86,9.18};
static float alpha10_nx064_nz15_fwhm100[32] = {
 1.91,1.92,1.92,1.93,1.95,1.97,2.10,2.38,2.54,2.64,
 2.71,2.76,2.79,2.87,2.91,2.96,3.12,3.43,3.74,3.89,
 3.98,4.32,4.60,4.77,4.88,5.51,5.92,6.68,7.51,8.38,
 10.09,11.98};
static float alpha10_nx064_nz15_fwhm125[32] = {
 1.94,1.97,1.99,2.22,2.44,2.59,2.74,2.81,2.87,2.91,
 2.94,2.97,3.00,3.42,3.65,3.82,3.95,4.19,4.72,4.97,
 5.45,5.77,5.98,6.44,6.76,7.61,8.50,9.61,10.92,12.50,
 15.71,19.21};
static float alpha10_nx064_nz15_fwhm150[32] = {
 2.45,2.64,2.74,2.83,2.91,2.96,3.27,3.58,3.74,3.86,
 3.95,4.08,4.28,4.70,4.94,5.43,5.84,6.28,6.98,7.72,
 8.39,8.93,9.59,10.17,10.74,12.46,13.99,16.27,19.02,21.91,
 28.29,35.69};
static float alpha10_nx064_nz15_fwhm175[32] = {
 2.99,3.38,3.63,3.85,4.11,4.43,4.82,5.14,5.55,5.81,
 5.99,6.33,6.59,7.30,7.86,8.61,9.43,10.14,11.50,12.67,
 13.85,14.98,16.22,17.18,18.16,21.28,24.48,28.52,33.97,39.37,
 51.68,66.93};
static float alpha10_nx064_nz15_fwhm200[32] = {
 4.52,4.88,5.27,5.69,6.15,6.59,7.31,7.90,8.44,8.87,
 9.34,9.75,10.10,11.20,12.17,13.30,14.71,15.83,17.90,19.86,
 21.77,23.69,25.50,27.19,28.98,34.19,39.19,45.93,55.02,64.66,
 86.03,111.41};
static float alpha10_nx064_nz15_fwhm225[32] = {
 6.22,6.86,7.44,8.05,8.67,9.19,10.14,11.06,11.83,12.58,
 13.22,13.81,14.39,15.93,17.18,18.85,20.76,22.50,25.74,28.81,
 31.56,34.29,36.95,39.35,42.07,49.84,57.28,67.28,80.54,94.06,
 125.65,161.29};
static float alpha10_nx064_nz15_fwhm250[32] = {
 8.11,8.83,9.56,10.35,11.25,12.00,13.26,14.54,15.52,16.48,
 17.35,18.18,18.96,21.07,22.85,25.04,27.60,30.10,34.60,38.54,
 42.35,45.84,49.54,53.17,56.62,66.58,76.52,90.36,107.57,125.77,
 165.05,215.45};
static float alpha10_nx064_nz15_fwhm275[32] = {
 9.82,10.87,11.72,12.73,13.81,14.86,16.60,18.07,19.41,20.68,
 21.79,22.81,23.73,26.27,28.85,31.83,35.14,38.05,43.77,49.02,
 53.64,58.22,62.97,67.18,71.53,84.21,96.19,113.46,135.07,156.93,
 208.00,269.57};
static float alpha10_nx064_nz15_fwhm300[32] = {
 11.68,12.94,14.03,15.33,16.69,17.91,19.92,21.75,23.37,24.84,
 26.25,27.58,28.92,32.14,35.07,38.80,42.81,46.61,53.64,59.86,
 65.77,71.31,76.97,82.02,87.19,102.47,117.31,137.47,163.15,191.61,
 252.64,324.00};
static float alpha10_nx064_nz15_fwhm325[32] = {
 13.55,15.01,16.23,17.74,19.44,20.84,23.40,25.48,27.65,29.45,
 31.09,32.74,34.29,38.18,41.68,46.20,51.03,55.45,63.53,70.99,
 77.84,84.48,90.94,97.26,103.41,121.55,139.10,163.50,193.64,226.50,
 297.40,382.54};
static float alpha10_nx064_nz15_fwhm350[32] = {
 15.18,16.97,18.44,20.10,22.26,23.97,26.99,29.57,31.85,34.11,
 36.20,38.12,39.77,44.43,48.50,53.31,59.14,64.58,74.07,82.57,
 90.45,98.54,105.69,113.32,120.78,140.71,160.67,187.88,223.58,263.22,
 346.54,441.80};
static float alpha10_nx064_nz15_fwhm375[32] = {
 16.87,19.02,20.69,22.79,25.07,27.15,30.73,33.54,36.33,38.87,
 41.04,43.16,45.05,50.49,55.23,60.87,67.76,73.62,84.66,94.72,
 103.46,112.58,121.12,129.61,137.26,160.00,182.94,214.47,258.74,302.30,
 394.65,498.44};
static float alpha10_nx064_nz15_fwhm400[32] = {
 18.35,20.82,22.84,25.19,27.87,30.16,33.91,37.51,40.51,43.08,
 45.96,48.32,50.67,56.56,62.02,68.48,75.96,82.60,95.32,106.11,
 116.59,126.70,136.14,145.62,154.36,180.72,207.27,245.70,292.39,341.21,
 441.56,559.50};
static float alpha10_nx064_nz15_fwhm425[32] = {
 19.82,22.60,24.74,27.61,30.45,32.98,37.21,41.21,44.31,47.44,
 50.36,53.06,55.34,62.34,68.31,75.76,84.32,91.87,105.38,117.68,
 130.32,140.76,151.79,161.72,172.03,202.08,232.31,274.47,327.50,379.25,
 491.67,619.22};
static float alpha10_nx064_nz15_fwhm450[32] = {
 21.14,24.07,26.64,29.54,32.61,35.24,40.31,44.50,48.24,51.90,
 54.90,57.93,60.82,68.73,74.92,83.37,92.71,101.30,116.27,129.94,
 142.77,155.04,167.25,179.00,191.00,224.95,258.33,305.58,360.17,420.38,
 541.00,679.33};
static float alpha10_nx064_nz15_fwhm475[32] = {
 22.21,25.37,28.11,31.25,34.60,37.88,43.20,48.28,52.33,56.16,
 59.68,62.90,65.97,74.38,81.69,90.67,101.00,110.33,126.89,142.46,
 156.35,169.92,184.57,197.07,209.60,246.86,286.21,334.62,396.00,459.70,
 595.25,742.33};
static float alpha10_nx064_nz15_fwhm500[32] = {
 23.08,26.25,29.26,32.76,36.60,40.31,46.36,51.30,56.03,60.45,
 64.08,67.52,70.52,80.39,88.72,97.78,109.03,119.71,138.18,154.92,
 170.76,186.00,200.56,215.00,229.25,270.67,311.57,365.33,431.00,501.07,
 647.00,806.67};
static float *alpha10_nx064_nz15[21] = {
 alpha10_nx064_nz15_fwhm000, alpha10_nx064_nz15_fwhm025, alpha10_nx064_nz15_fwhm050, 
 alpha10_nx064_nz15_fwhm075, alpha10_nx064_nz15_fwhm100, alpha10_nx064_nz15_fwhm125, 
 alpha10_nx064_nz15_fwhm150, alpha10_nx064_nz15_fwhm175, alpha10_nx064_nz15_fwhm200, 
 alpha10_nx064_nz15_fwhm225, alpha10_nx064_nz15_fwhm250, alpha10_nx064_nz15_fwhm275, 
 alpha10_nx064_nz15_fwhm300, alpha10_nx064_nz15_fwhm325, alpha10_nx064_nz15_fwhm350, 
 alpha10_nx064_nz15_fwhm375, alpha10_nx064_nz15_fwhm400, alpha10_nx064_nz15_fwhm425, 
 alpha10_nx064_nz15_fwhm450, alpha10_nx064_nz15_fwhm475, alpha10_nx064_nz15_fwhm500} ;

static float **nx064_nz15[3] = {
  alpha01_nx064_nz15 , alpha05_nx064_nz15 , alpha10_nx064_nz15 };

static float alpha01_nx064_nz16_fwhm000[32] = {
 1.99,1.99,1.99,2.00,2.00,2.19,2.54,2.69,2.79,2.85,
 2.89,2.91,2.93,2.96,2.98,2.99,3.18,3.51,3.80,3.90,
 3.96,3.99,4.32,4.60,4.78,4.98,5.56,5.97,6.69,7.24,
 8.52,9.86};
static float alpha01_nx064_nz16_fwhm025[32] = {
 1.99,1.99,1.99,2.00,2.00,2.19,2.54,2.69,2.79,2.85,
 2.89,2.91,2.93,2.96,2.98,2.99,3.18,3.51,3.80,3.90,
 3.96,3.99,4.32,4.60,4.78,4.98,5.56,5.97,6.69,7.24,
 8.52,9.86};
static float alpha01_nx064_nz16_fwhm050[32] = {
 1.99,1.99,1.99,2.00,2.07,2.32,2.59,2.73,2.82,2.87,
 2.90,2.92,2.94,2.97,2.98,2.99,3.34,3.61,3.83,3.92,
 3.97,4.00,4.47,4.70,4.83,5.14,5.69,6.09,6.82,7.46,
 8.74,10.00};
static float alpha01_nx064_nz16_fwhm075[32] = {
 1.99,2.00,2.00,2.20,2.42,2.60,2.77,2.85,2.90,2.93,
 2.94,2.96,2.97,2.99,3.00,3.44,3.70,3.82,3.93,3.99,
 4.40,4.70,4.84,4.94,5.01,5.77,6.12,6.76,7.57,8.09,
 9.81,11.65};
static float alpha01_nx064_nz16_fwhm100[32] = {
 2.12,2.40,2.57,2.73,2.82,2.87,2.93,2.95,2.98,2.99,
 2.99,3.12,3.28,3.64,3.79,3.89,3.96,4.03,4.67,4.91,
 5.05,5.52,5.77,5.93,6.15,6.86,7.53,8.41,9.54,10.55,
 12.91,15.52};
static float alpha01_nx064_nz16_fwhm125[32] = {
 2.81,2.88,2.92,2.96,2.98,3.00,3.42,3.64,3.76,3.84,
 3.89,3.94,3.96,4.36,4.67,4.90,5.12,5.60,5.98,6.65,
 6.94,7.45,7.84,8.18,8.66,9.93,11.00,12.61,14.49,16.21,
 20.71,24.96};
static float alpha01_nx064_nz16_fwhm150[32] = {
 3.28,3.59,3.76,3.88,3.96,4.12,4.66,4.86,4.97,5.27,
 5.55,5.72,5.87,6.33,6.81,7.39,7.91,8.52,9.59,10.39,
 11.28,11.93,12.80,13.71,14.40,16.50,18.70,21.96,25.70,29.91,
 38.17,48.74};
static float alpha01_nx064_nz16_fwhm175[32] = {
 4.87,5.19,5.61,5.88,6.26,6.66,7.16,7.69,8.09,8.56,
 8.90,9.22,9.54,10.24,11.10,12.23,13.43,14.27,16.18,17.82,
 19.60,21.33,22.66,24.34,25.72,29.97,34.04,39.53,47.23,55.07,
 71.91,95.43};
static float alpha01_nx064_nz16_fwhm200[32] = {
 7.58,8.18,8.64,9.09,9.73,10.42,11.37,12.23,12.82,13.67,
 14.21,14.76,15.20,16.64,17.95,19.77,21.86,23.30,26.45,29.29,
 31.85,34.54,36.74,39.44,41.71,48.54,56.08,65.50,79.12,91.80,
 122.86,159.33};
static float alpha01_nx064_nz16_fwhm225[32] = {
 10.89,11.88,12.64,13.34,14.21,15.14,16.76,18.03,19.25,20.44,
 21.00,22.18,22.94,24.85,26.91,29.17,31.36,34.25,39.00,43.25,
 47.26,51.09,54.87,58.67,61.86,72.11,83.83,97.77,116.33,136.20,
 185.22,244.00};
static float alpha01_nx064_nz16_fwhm250[32] = {
 14.79,15.93,17.12,18.22,19.65,20.71,22.85,24.42,25.74,26.88,
 28.05,29.15,29.90,33.35,36.41,39.73,43.78,47.50,53.40,58.41,
 63.83,68.91,74.11,79.00,84.33,98.73,113.40,132.12,160.00,186.29,
 254.00,325.00};
static float alpha01_nx064_nz16_fwhm275[32] = {
 19.00,20.59,21.85,23.29,24.81,26.05,28.43,30.76,32.63,34.20,
 35.93,37.75,39.30,43.71,47.58,51.61,55.53,60.27,67.50,75.75,
 83.60,90.33,96.50,101.57,108.17,125.40,145.00,170.67,202.44,236.50,
 318.50,415.00};
static float alpha01_nx064_nz16_fwhm300[32] = {
 22.85,24.81,26.36,28.35,30.41,32.15,35.33,38.30,41.09,43.42,
 46.00,47.77,49.30,54.31,58.00,63.44,68.94,74.83,84.50,93.83,
 101.57,109.56,118.17,125.67,133.50,155.80,177.00,205.40,250.67,294.00,
 395.00,523.50};
static float alpha01_nx064_nz16_fwhm325[32] = {
 27.47,29.76,31.47,33.75,36.80,38.93,43.50,47.25,49.86,52.30,
 54.29,56.58,58.87,64.43,69.40,76.33,83.33,89.20,101.80,112.14,
 122.22,132.00,141.29,151.80,159.83,187.83,214.60,251.83,299.40,354.00,
 473.50,618.00};
static float alpha01_nx064_nz16_fwhm350[32] = {
 32.33,35.09,37.69,40.60,43.42,46.42,51.09,54.90,58.00,60.64,
 63.67,66.80,68.91,76.50,82.00,89.80,98.33,105.67,118.62,131.67,
 143.57,155.50,166.50,179.00,190.40,222.43,251.67,294.00,350.25,421.50,
 553.00,707.00};
static float alpha01_nx064_nz16_fwhm375[32] = {
 37.73,41.00,43.14,46.86,50.62,53.20,57.89,62.62,67.20,70.50,
 73.50,77.00,79.00,87.67,96.00,103.25,112.27,121.00,136.40,152.25,
 166.50,181.50,196.00,206.00,219.25,254.67,292.67,345.00,416.00,488.50,
 646.00,814.00};
static float alpha01_nx064_nz16_fwhm400[32] = {
 42.20,46.11,48.88,52.73,56.18,59.50,65.83,71.38,75.75,79.75,
 83.67,87.29,90.50,99.33,108.12,117.00,128.25,137.67,157.50,174.00,
 190.67,208.33,221.80,236.40,251.50,294.75,339.00,396.50,472.00,556.50,
 727.00,917.00};
static float alpha01_nx064_nz16_fwhm425[32] = {
 46.82,50.50,54.44,58.56,63.12,67.75,74.36,80.38,85.00,89.40,
 93.75,97.14,101.60,112.40,121.00,132.12,143.50,155.60,178.00,197.80,
 218.50,235.50,255.00,271.33,287.50,337.50,385.80,449.00,532.67,625.00,
 803.00,1009.50};
static float alpha01_nx064_nz16_fwhm450[32] = {
 50.85,56.45,60.70,64.78,69.89,74.33,81.00,87.75,93.20,98.71,
 103.67,108.00,113.50,124.60,134.25,146.00,161.25,176.20,199.00,227.00,
 247.50,268.00,287.33,305.00,323.00,376.67,431.00,506.00,597.00,696.00,
 892.50,1114.00};
static float alpha01_nx064_nz16_fwhm475[32] = {
 56.50,61.33,65.00,70.57,76.00,81.88,89.38,96.33,102.67,110.17,
 114.80,120.12,124.60,138.25,149.20,163.80,182.00,199.00,228.50,253.33,
 276.75,296.75,319.00,340.00,360.25,418.00,477.50,556.67,656.00,760.00,
 973.00,1233.00};
static float alpha01_nx064_nz16_fwhm500[32] = {
 60.60,66.00,69.80,76.00,82.50,87.14,96.00,105.33,112.75,118.50,
 124.40,130.60,136.00,152.00,165.80,184.00,205.50,221.00,251.50,278.00,
 302.14,324.50,350.00,373.67,393.20,457.00,525.00,615.00,722.50,827.50,
 1059.00,1336.00};
static float *alpha01_nx064_nz16[21] = {
 alpha01_nx064_nz16_fwhm000, alpha01_nx064_nz16_fwhm025, alpha01_nx064_nz16_fwhm050, 
 alpha01_nx064_nz16_fwhm075, alpha01_nx064_nz16_fwhm100, alpha01_nx064_nz16_fwhm125, 
 alpha01_nx064_nz16_fwhm150, alpha01_nx064_nz16_fwhm175, alpha01_nx064_nz16_fwhm200, 
 alpha01_nx064_nz16_fwhm225, alpha01_nx064_nz16_fwhm250, alpha01_nx064_nz16_fwhm275, 
 alpha01_nx064_nz16_fwhm300, alpha01_nx064_nz16_fwhm325, alpha01_nx064_nz16_fwhm350, 
 alpha01_nx064_nz16_fwhm375, alpha01_nx064_nz16_fwhm400, alpha01_nx064_nz16_fwhm425, 
 alpha01_nx064_nz16_fwhm450, alpha01_nx064_nz16_fwhm475, alpha01_nx064_nz16_fwhm500} ;

static float alpha05_nx064_nz16_fwhm000[32] = {
 1.95,1.95,1.95,1.96,1.96,1.96,1.97,1.98,2.00,2.20,
 2.40,2.53,2.62,2.77,2.85,2.90,2.94,2.96,2.99,3.41,
 3.67,3.79,3.87,3.93,3.97,4.54,4.83,5.17,5.81,6.34,
 7.44,8.59};
static float alpha05_nx064_nz16_fwhm025[32] = {
 1.95,1.95,1.95,1.96,1.96,1.96,1.97,1.98,2.00,2.20,
 2.40,2.53,2.62,2.77,2.85,2.90,2.94,2.96,2.99,3.41,
 3.67,3.79,3.87,3.93,3.97,4.54,4.83,5.17,5.81,6.34,
 7.44,8.59};
static float alpha05_nx064_nz16_fwhm050[32] = {
 1.95,1.95,1.95,1.96,1.96,1.96,1.97,1.99,2.04,2.30,
 2.47,2.58,2.66,2.80,2.86,2.91,2.94,2.97,3.07,3.49,
 3.72,3.82,3.90,3.95,3.99,4.64,4.88,5.36,5.89,6.52,
 7.64,8.80};
static float alpha05_nx064_nz16_fwhm075[32] = {
 1.95,1.96,1.96,1.96,1.97,1.97,1.99,2.20,2.44,2.60,
 2.69,2.75,2.79,2.87,2.91,2.95,2.98,3.02,3.53,3.76,
 3.88,3.94,3.99,4.32,4.56,4.91,5.36,5.85,6.58,7.10,
 8.51,9.92};
static float alpha05_nx064_nz16_fwhm100[32] = {
 1.96,1.97,1.97,1.99,2.06,2.31,2.58,2.72,2.80,2.85,
 2.88,2.90,2.92,2.96,2.99,3.31,3.61,3.77,3.92,4.07,
 4.53,4.76,4.89,4.99,5.36,5.91,6.53,7.16,8.07,8.96,
 10.95,13.17};
static float alpha05_nx064_nz16_fwhm125[32] = {
 2.01,2.33,2.52,2.67,2.77,2.83,2.90,2.94,2.97,3.02,
 3.26,3.44,3.56,3.78,3.89,3.99,4.47,4.74,5.01,5.65,
 5.90,6.29,6.70,6.92,7.31,8.25,9.28,10.55,12.11,13.76,
 17.20,20.99};
static float alpha05_nx064_nz16_fwhm150[32] = {
 2.80,2.88,2.94,2.99,3.31,3.52,3.78,3.92,4.03,4.35,
 4.56,4.71,4.81,5.12,5.60,5.93,6.50,6.90,7.79,8.55,
 9.27,9.89,10.57,11.19,11.82,13.68,15.50,17.88,20.99,24.39,
 31.72,39.60};
static float alpha05_nx064_nz16_fwhm175[32] = {
 3.70,3.90,4.14,4.53,4.80,4.96,5.61,5.95,6.38,6.70,
 6.92,7.23,7.50,8.21,8.85,9.69,10.58,11.37,12.88,14.31,
 15.67,16.91,18.15,19.29,20.46,23.91,27.45,31.98,37.98,44.30,
 58.10,74.88};
static float alpha05_nx064_nz16_fwhm200[32] = {
 5.47,6.00,6.42,6.83,7.26,7.72,8.54,9.15,9.75,10.31,
 10.83,11.26,11.75,12.99,14.15,15.42,16.96,18.38,20.71,22.89,
 25.01,26.94,29.04,30.97,33.09,38.72,44.69,52.27,62.41,72.73,
 97.91,126.19};
static float alpha05_nx064_nz16_fwhm225[32] = {
 7.83,8.52,9.05,9.74,10.52,11.11,12.34,13.33,14.14,14.96,
 15.70,16.38,17.13,18.99,20.36,22.30,24.50,26.46,29.80,33.20,
 36.37,39.71,42.70,45.67,48.62,57.00,65.40,75.98,91.47,106.79,
 143.74,189.25};
static float alpha05_nx064_nz16_fwhm250[32] = {
 10.36,11.16,11.99,12.84,13.90,14.82,16.46,17.83,19.00,20.04,
 20.98,21.95,22.78,25.15,27.40,29.95,32.72,35.37,40.56,44.77,
 49.48,53.30,57.42,61.35,65.26,75.97,87.41,103.25,123.15,145.46,
 197.00,250.50};
static float alpha05_nx064_nz16_fwhm275[32] = {
 12.82,13.97,14.98,16.21,17.59,18.77,20.64,22.31,23.87,25.23,
 26.63,27.84,28.87,31.90,34.75,38.03,41.65,45.40,51.60,57.12,
 62.82,67.85,73.04,77.85,82.77,97.34,112.25,131.96,159.52,186.73,
 248.17,318.25};
static float alpha05_nx064_nz16_fwhm300[32] = {
 15.39,16.93,18.23,19.61,21.18,22.64,24.94,27.20,29.11,30.86,
 32.45,33.83,35.19,38.86,42.29,46.51,51.18,55.38,63.00,70.15,
 77.05,83.00,89.19,96.03,102.40,120.00,138.64,163.93,195.58,227.12,
 301.55,386.60};
static float alpha05_nx064_nz16_fwhm325[32] = {
 18.01,19.72,21.19,22.83,24.84,26.58,29.58,31.97,33.95,36.17,
 38.11,39.69,41.43,46.15,50.17,55.17,60.78,66.11,75.11,83.83,
 92.13,99.95,107.42,114.65,121.57,143.93,165.72,194.81,232.36,269.08,
 354.22,459.38};
static float alpha05_nx064_nz16_fwhm350[32] = {
 20.54,22.52,24.24,26.13,28.42,30.53,33.82,36.85,39.56,41.83,
 43.93,46.02,47.94,53.45,58.45,64.24,70.70,76.68,88.00,98.12,
 106.82,116.76,125.63,134.22,142.67,167.75,194.93,228.41,268.87,312.25,
 413.78,528.20};
static float alpha05_nx064_nz16_fwhm375[32] = {
 22.85,24.89,27.17,29.60,32.20,34.57,38.57,41.81,44.73,47.64,
 49.98,52.52,54.79,60.89,66.83,73.50,81.19,88.06,100.93,112.19,
 123.71,133.78,144.38,154.47,165.21,195.00,223.91,260.86,308.67,359.44,
 472.00,602.60};
static float alpha05_nx064_nz16_fwhm400[32] = {
 25.04,27.83,30.13,33.02,36.04,38.69,42.95,47.11,50.36,53.82,
 56.44,58.97,61.62,69.17,75.73,83.32,92.00,100.52,114.65,128.05,
 140.88,152.29,164.83,177.43,187.80,221.88,253.67,293.43,348.38,407.00,
 532.25,674.75};
static float alpha05_nx064_nz16_fwhm425[32] = {
 27.23,30.52,33.27,36.32,39.63,42.55,47.58,52.12,56.07,59.85,
 63.07,66.33,69.28,77.40,84.86,93.56,103.58,112.53,128.79,143.90,
 157.68,172.11,186.64,199.62,211.64,248.36,283.27,331.00,389.80,457.20,
 590.20,757.29};
static float alpha05_nx064_nz16_fwhm450[32] = {
 29.86,33.16,36.06,39.30,42.84,46.39,52.22,57.34,61.63,65.88,
 69.80,73.36,76.81,85.78,94.15,103.83,115.07,124.52,142.64,158.97,
 176.92,192.21,206.90,222.62,235.88,275.60,315.73,368.67,433.00,504.00,
 658.50,833.33};
static float alpha05_nx064_nz16_fwhm475[32] = {
 31.84,35.67,39.08,42.58,46.61,50.71,56.95,62.57,67.31,71.87,
 76.69,81.00,84.83,94.88,103.82,114.50,126.40,137.56,157.94,176.93,
 195.56,212.73,228.50,243.83,258.79,305.11,347.50,404.17,477.00,550.57,
 721.33,916.50};
static float alpha05_nx064_nz16_fwhm500[32] = {
 33.71,37.89,41.90,46.04,50.61,54.77,61.67,67.67,73.53,78.87,
 84.11,88.43,91.95,103.33,112.71,124.44,137.91,150.77,173.29,194.55,
 214.33,232.42,250.60,268.00,285.58,334.42,379.00,440.67,524.57,605.00,
 790.00,990.33};
static float *alpha05_nx064_nz16[21] = {
 alpha05_nx064_nz16_fwhm000, alpha05_nx064_nz16_fwhm025, alpha05_nx064_nz16_fwhm050, 
 alpha05_nx064_nz16_fwhm075, alpha05_nx064_nz16_fwhm100, alpha05_nx064_nz16_fwhm125, 
 alpha05_nx064_nz16_fwhm150, alpha05_nx064_nz16_fwhm175, alpha05_nx064_nz16_fwhm200, 
 alpha05_nx064_nz16_fwhm225, alpha05_nx064_nz16_fwhm250, alpha05_nx064_nz16_fwhm275, 
 alpha05_nx064_nz16_fwhm300, alpha05_nx064_nz16_fwhm325, alpha05_nx064_nz16_fwhm350, 
 alpha05_nx064_nz16_fwhm375, alpha05_nx064_nz16_fwhm400, alpha05_nx064_nz16_fwhm425, 
 alpha05_nx064_nz16_fwhm450, alpha05_nx064_nz16_fwhm475, alpha05_nx064_nz16_fwhm500} ;

static float alpha10_nx064_nz16_fwhm000[32] = {
 1.90,1.90,1.90,1.90,1.91,1.91,1.92,1.93,1.94,1.96,
 1.98,2.05,2.23,2.54,2.68,2.79,2.85,2.89,2.94,2.98,
 3.30,3.54,3.69,3.79,3.86,4.00,4.56,4.88,5.41,5.88,
 6.88,7.92};
static float alpha10_nx064_nz16_fwhm025[32] = {
 1.90,1.90,1.90,1.90,1.91,1.91,1.92,1.93,1.94,1.96,
 1.98,2.05,2.23,2.54,2.68,2.79,2.85,2.89,2.94,2.98,
 3.30,3.54,3.69,3.79,3.86,4.00,4.56,4.88,5.41,5.88,
 6.88,7.92};
static float alpha10_nx064_nz16_fwhm050[32] = {
 1.90,1.90,1.90,1.91,1.91,1.91,1.92,1.93,1.95,1.97,
 1.99,2.16,2.32,2.58,2.71,2.80,2.86,2.90,2.95,2.99,
 3.40,3.61,3.74,3.83,3.89,4.18,4.64,4.93,5.56,5.95,
 6.98,8.14};
static float alpha10_nx064_nz16_fwhm075[32] = {
 1.90,1.90,1.91,1.91,1.92,1.92,1.94,1.96,1.99,2.19,
 2.37,2.49,2.58,2.73,2.81,2.87,2.91,2.94,3.04,3.48,
 3.69,3.81,3.89,3.95,4.02,4.67,4.92,5.49,5.98,6.72,
 7.87,9.24};
static float alpha10_nx064_nz16_fwhm100[32] = {
 1.91,1.92,1.92,1.93,1.95,1.97,2.15,2.42,2.58,2.67,
 2.74,2.78,2.81,2.88,2.92,2.96,3.17,3.48,3.76,3.90,
 3.99,4.38,4.63,4.79,4.91,5.56,5.95,6.72,7.59,8.39,
 10.11,12.11};
static float alpha10_nx064_nz16_fwhm125[32] = {
 1.95,1.97,2.01,2.31,2.50,2.63,2.76,2.83,2.88,2.92,
 2.95,2.98,3.05,3.46,3.67,3.83,3.96,4.30,4.77,5.02,
 5.51,5.81,6.03,6.45,6.75,7.66,8.54,9.67,11.04,12.59,
 15.83,19.17};
static float alpha10_nx064_nz16_fwhm150[32] = {
 2.52,2.68,2.78,2.86,2.93,2.99,3.36,3.61,3.77,3.88,
 3.97,4.18,4.37,4.74,4.96,5.45,5.85,6.29,7.00,7.75,
 8.43,8.97,9.62,10.16,10.77,12.45,14.08,16.31,19.02,22.01,
 28.57,35.81};
static float alpha10_nx064_nz16_fwhm175[32] = {
 3.02,3.43,3.68,3.88,4.13,4.46,4.87,5.24,5.61,5.87,
 6.10,6.40,6.64,7.30,7.87,8.64,9.41,10.15,11.55,12.78,
 14.08,15.19,16.28,17.32,18.39,21.54,24.57,28.77,33.96,39.71,
 51.93,67.05};
static float alpha10_nx064_nz16_fwhm200[32] = {
 4.57,4.92,5.32,5.76,6.18,6.61,7.30,7.89,8.52,8.96,
 9.47,9.86,10.30,11.38,12.38,13.55,14.84,15.96,18.36,20.32,
 22.24,24.08,25.89,27.68,29.29,34.46,39.72,46.44,55.41,65.17,
 86.86,112.07};
static float alpha10_nx064_nz16_fwhm225[32] = {
 6.38,6.94,7.55,8.17,8.84,9.42,10.45,11.33,12.09,12.86,
 13.52,14.02,14.67,16.30,17.68,19.44,21.29,22.97,26.30,29.29,
 32.06,34.67,37.41,40.09,42.74,50.20,57.51,67.71,81.26,94.92,
 127.17,166.61};
static float alpha10_nx064_nz16_fwhm250[32] = {
 8.37,9.15,9.88,10.71,11.62,12.38,13.75,14.95,16.03,17.00,
 17.94,18.71,19.50,21.70,23.55,25.78,28.33,30.64,35.12,39.27,
 43.01,46.37,50.19,53.89,57.26,67.03,77.53,90.91,108.25,127.56,
 172.06,221.70};
static float alpha10_nx064_nz16_fwhm275[32] = {
 10.28,11.33,12.29,13.29,14.38,15.43,17.28,18.81,20.15,21.40,
 22.64,23.58,24.49,27.02,29.50,32.51,35.67,38.80,44.26,49.38,
 54.42,59.14,63.87,68.34,72.83,85.57,98.17,115.27,137.68,162.35,
 216.54,277.45};
static float alpha10_nx064_nz16_fwhm300[32] = {
 12.18,13.54,14.66,15.94,17.34,18.59,20.79,22.68,24.31,25.74,
 27.09,28.37,29.61,32.80,35.73,39.36,43.37,47.12,54.31,60.77,
 66.64,72.08,78.02,83.42,89.06,104.40,120.15,141.48,169.81,198.82,
 261.20,337.00};
static float alpha10_nx064_nz16_fwhm325[32] = {
 14.19,15.64,16.95,18.45,20.18,21.71,24.30,26.44,28.38,30.07,
 31.74,33.25,34.65,38.79,42.54,46.92,51.69,56.20,64.38,72.19,
 79.27,86.29,93.21,99.50,105.58,124.50,143.32,169.61,202.27,234.80,
 309.27,394.80};
static float alpha10_nx064_nz16_fwhm350[32] = {
 15.90,17.81,19.26,21.08,22.92,24.68,27.72,30.14,32.54,34.63,
 36.66,38.52,40.27,45.24,49.29,54.19,60.03,65.50,75.17,83.82,
 92.21,100.52,108.39,115.97,122.97,145.21,167.96,196.76,235.23,272.31,
 356.25,453.00};
static float alpha10_nx064_nz16_fwhm375[32] = {
 17.63,19.69,21.47,23.46,25.63,27.65,31.14,34.21,36.99,39.46,
 41.79,44.12,45.78,51.31,55.89,61.87,68.47,74.42,85.59,96.37,
 106.07,115.50,124.59,133.00,141.82,166.56,191.35,224.14,266.57,308.79,
 405.45,516.43};
static float alpha10_nx064_nz16_fwhm400[32] = {
 19.17,21.56,23.40,25.83,28.35,30.66,34.71,38.13,41.12,43.96,
 46.53,49.13,51.14,57.53,62.89,69.67,76.88,83.88,96.72,108.55,
 120.13,130.62,140.40,149.93,159.83,188.10,216.21,252.25,298.94,349.95,
 457.20,585.67};
static float alpha10_nx064_nz16_fwhm425[32] = {
 20.35,23.09,25.29,28.02,30.73,33.49,38.01,41.91,45.09,48.26,
 51.16,54.02,56.90,63.94,69.77,76.85,85.55,93.35,107.93,121.24,
 133.64,145.30,157.14,167.62,178.37,209.86,241.26,282.69,333.07,390.70,
 509.44,644.75};
static float alpha10_nx064_nz16_fwhm450[32] = {
 21.58,24.70,27.20,30.23,33.21,36.14,41.19,45.51,49.31,52.79,
 56.38,59.00,61.84,69.78,76.23,84.83,94.51,103.29,119.76,133.92,
 148.20,160.06,172.27,184.71,196.86,233.31,267.92,313.22,371.40,433.67,
 560.20,705.80};
static float alpha10_nx064_nz16_fwhm475[32] = {
 22.86,26.11,28.76,32.03,35.34,38.52,43.95,48.81,53.11,57.21,
 60.49,63.88,67.16,75.24,83.33,92.72,103.45,113.28,131.09,146.62,
 161.00,175.85,190.10,204.05,217.71,256.80,295.27,343.50,409.00,474.00,
 614.83,769.50};
static float alpha10_nx064_nz16_fwhm500[32] = {
 24.01,27.20,30.14,33.53,37.47,41.00,47.19,52.35,57.12,61.10,
 64.88,68.27,71.79,81.66,90.14,100.48,111.98,123.63,142.04,159.77,
 176.24,192.68,207.90,222.53,237.81,280.70,319.80,377.33,447.31,517.31,
 663.83,839.00};
static float *alpha10_nx064_nz16[21] = {
 alpha10_nx064_nz16_fwhm000, alpha10_nx064_nz16_fwhm025, alpha10_nx064_nz16_fwhm050, 
 alpha10_nx064_nz16_fwhm075, alpha10_nx064_nz16_fwhm100, alpha10_nx064_nz16_fwhm125, 
 alpha10_nx064_nz16_fwhm150, alpha10_nx064_nz16_fwhm175, alpha10_nx064_nz16_fwhm200, 
 alpha10_nx064_nz16_fwhm225, alpha10_nx064_nz16_fwhm250, alpha10_nx064_nz16_fwhm275, 
 alpha10_nx064_nz16_fwhm300, alpha10_nx064_nz16_fwhm325, alpha10_nx064_nz16_fwhm350, 
 alpha10_nx064_nz16_fwhm375, alpha10_nx064_nz16_fwhm400, alpha10_nx064_nz16_fwhm425, 
 alpha10_nx064_nz16_fwhm450, alpha10_nx064_nz16_fwhm475, alpha10_nx064_nz16_fwhm500} ;

static float **nx064_nz16[3] = {
  alpha01_nx064_nz16 , alpha05_nx064_nz16 , alpha10_nx064_nz16 };

static float alpha01_nx064_nz17_fwhm000[32] = {
 1.99,1.99,1.99,2.00,2.00,2.23,2.57,2.73,2.81,2.86,
 2.89,2.91,2.93,2.96,2.98,2.99,3.15,3.52,3.81,3.91,
 3.96,4.08,4.41,4.63,4.77,4.96,5.60,5.97,6.78,7.35,
 8.69,10.00};
static float alpha01_nx064_nz17_fwhm025[32] = {
 1.99,1.99,1.99,2.00,2.00,2.23,2.57,2.73,2.81,2.86,
 2.89,2.91,2.93,2.96,2.98,2.99,3.15,3.52,3.81,3.91,
 3.96,4.08,4.41,4.63,4.77,4.96,5.60,5.97,6.78,7.35,
 8.69,10.00};
static float alpha01_nx064_nz17_fwhm050[32] = {
 1.99,1.99,1.99,2.00,2.07,2.33,2.64,2.76,2.83,2.88,
 2.90,2.92,2.94,2.97,2.98,3.00,3.31,3.60,3.85,3.93,
 3.98,4.24,4.50,4.72,4.82,4.99,5.74,6.04,6.91,7.61,
 8.84,10.39};
static float alpha01_nx064_nz17_fwhm075[32] = {
 1.99,1.99,2.00,2.22,2.46,2.63,2.78,2.86,2.90,2.93,
 2.94,2.96,2.97,2.99,3.00,3.40,3.70,3.84,3.94,4.00,
 4.46,4.71,4.85,4.93,4.99,5.78,6.21,6.85,7.64,8.44,
 9.90,11.87};
static float alpha01_nx064_nz17_fwhm100[32] = {
 2.09,2.44,2.61,2.75,2.82,2.87,2.92,2.95,2.97,2.98,
 2.99,3.00,3.24,3.61,3.80,3.90,3.97,4.11,4.72,4.91,
 5.10,5.55,5.82,5.97,6.33,6.94,7.69,8.64,9.78,10.79,
 13.20,15.66};
static float alpha01_nx064_nz17_fwhm125[32] = {
 2.82,2.88,2.92,2.95,2.98,2.99,3.38,3.61,3.77,3.86,
 3.91,3.95,3.99,4.41,4.73,4.93,5.18,5.62,5.99,6.77,
 7.13,7.72,7.98,8.53,8.86,10.00,11.03,12.58,14.55,16.43,
 20.80,25.39};
static float alpha01_nx064_nz17_fwhm150[32] = {
 3.36,3.62,3.76,3.88,3.95,4.13,4.62,4.90,5.01,5.39,
 5.60,5.80,5.92,6.50,6.88,7.50,7.95,8.61,9.70,10.59,
 11.48,12.30,12.94,13.83,14.58,16.67,18.83,21.74,25.53,29.81,
 38.60,48.94};
static float alpha01_nx064_nz17_fwhm175[32] = {
 4.85,5.24,5.62,5.90,6.27,6.67,7.16,7.70,8.19,8.66,
 8.93,9.27,9.57,10.31,11.07,12.10,13.39,14.34,16.05,17.70,
 19.36,20.84,22.49,23.64,25.24,29.25,33.32,38.73,46.96,55.57,
 72.47,96.62};
static float alpha01_nx064_nz17_fwhm200[32] = {
 7.60,7.99,8.69,9.33,9.85,10.25,11.23,11.95,12.69,13.27,
 13.84,14.32,14.92,16.60,17.82,19.42,20.97,22.85,25.30,28.07,
 31.08,33.90,36.67,39.11,41.37,48.77,56.00,65.62,78.91,92.12,
 124.33,165.22};
static float alpha01_nx064_nz17_fwhm225[32] = {
 10.74,11.59,12.35,13.19,14.12,14.81,16.30,17.49,18.39,19.26,
 20.14,20.93,21.62,23.47,25.40,28.09,30.96,33.25,37.95,41.95,
 46.42,51.00,54.50,57.67,61.31,72.22,83.75,97.93,117.40,138.88,
 186.00,248.50};
static float alpha01_nx064_nz17_fwhm250[32] = {
 14.47,15.58,16.58,17.65,18.67,19.69,21.70,23.29,24.61,25.90,
 27.16,28.25,29.25,31.96,35.20,38.79,42.50,46.07,53.00,59.09,
 65.18,69.11,73.50,78.69,84.18,98.50,114.00,132.00,159.00,189.17,
 256.50,337.00};
static float alpha01_nx064_nz17_fwhm275[32] = {
 18.20,19.62,20.87,22.22,23.82,25.28,27.73,29.75,31.74,33.52,
 35.25,36.86,38.44,42.79,46.24,50.83,56.18,60.33,67.87,75.36,
 81.64,88.25,95.80,101.77,108.67,126.67,145.67,173.00,207.00,244.67,
 326.33,424.67};
static float alpha01_nx064_nz17_fwhm300[32] = {
 22.39,24.28,25.70,27.89,29.87,31.60,34.64,37.50,40.40,42.27,
 44.41,46.18,47.72,53.20,57.56,62.90,68.67,73.64,83.71,92.60,
 101.73,110.00,117.78,125.50,133.50,156.80,180.38,213.75,253.80,304.50,
 396.80,518.00};
static float alpha01_nx064_nz17_fwhm325[32] = {
 27.38,29.44,31.13,33.69,36.00,38.38,41.80,45.15,48.38,51.20,
 53.58,55.93,58.43,63.79,69.10,74.90,82.78,89.56,101.29,112.75,
 124.50,133.20,142.67,151.67,162.00,188.00,216.50,255.00,310.67,358.00,
 476.67,616.00};
static float alpha01_nx064_nz17_fwhm350[32] = {
 31.70,34.56,36.83,40.31,42.70,45.43,49.60,53.93,57.38,60.33,
 63.09,65.90,68.50,74.75,81.50,88.12,97.50,106.33,120.60,132.60,
 145.67,156.80,168.00,180.25,188.67,221.67,255.25,306.00,360.80,416.80,
 545.67,709.00};
static float alpha01_nx064_nz17_fwhm375[32] = {
 37.07,40.41,43.38,46.64,49.60,52.45,57.92,62.27,66.27,69.14,
 72.71,76.00,78.89,86.50,94.00,103.12,112.89,122.67,140.00,153.67,
 166.80,179.67,193.50,205.20,215.71,253.50,298.86,352.50,417.00,477.67,
 627.50,799.00};
static float alpha01_nx064_nz17_fwhm400[32] = {
 42.50,46.37,49.00,52.46,56.20,59.70,65.67,71.20,75.00,78.83,
 82.22,86.00,89.44,100.00,109.18,118.50,130.00,140.00,157.80,174.67,
 190.67,203.62,219.00,235.33,247.00,294.67,342.50,401.67,472.67,547.00,
 705.00,903.00};
static float alpha01_nx064_nz17_fwhm425[32] = {
 46.67,51.18,54.67,59.00,62.80,66.50,73.33,79.00,83.86,88.67,
 93.00,96.67,101.40,111.67,121.86,133.50,145.00,155.00,177.62,197.67,
 217.00,233.50,250.00,268.00,284.00,339.00,388.00,452.00,531.00,614.50,
 797.00,1022.00};
static float alpha01_nx064_nz17_fwhm450[32] = {
 50.92,55.78,59.89,64.14,69.00,74.17,81.33,87.20,93.33,98.67,
 102.78,107.67,112.40,124.00,135.33,146.50,163.00,177.00,201.20,223.00,
 241.33,261.75,282.00,299.00,319.00,378.67,437.00,501.50,593.00,682.67,
 890.00,1150.00};
static float alpha01_nx064_nz17_fwhm475[32] = {
 56.00,60.00,65.45,71.22,75.75,80.20,87.80,96.00,103.00,108.40,
 113.80,118.80,123.56,136.00,148.75,166.00,182.25,196.00,222.62,247.33,
 268.00,293.00,315.00,339.00,359.00,423.00,482.00,553.00,656.00,770.00,
 990.50,1258.50};
static float alpha01_nx064_nz17_fwhm500[32] = {
 59.75,66.20,72.00,77.00,81.50,86.50,95.83,104.25,110.90,117.67,
 124.00,128.83,134.25,150.00,166.00,180.50,198.60,215.00,242.00,271.67,
 301.50,326.50,351.50,373.33,400.33,465.50,525.00,612.00,723.00,838.33,
 1107.50,1372.67};
static float *alpha01_nx064_nz17[21] = {
 alpha01_nx064_nz17_fwhm000, alpha01_nx064_nz17_fwhm025, alpha01_nx064_nz17_fwhm050, 
 alpha01_nx064_nz17_fwhm075, alpha01_nx064_nz17_fwhm100, alpha01_nx064_nz17_fwhm125, 
 alpha01_nx064_nz17_fwhm150, alpha01_nx064_nz17_fwhm175, alpha01_nx064_nz17_fwhm200, 
 alpha01_nx064_nz17_fwhm225, alpha01_nx064_nz17_fwhm250, alpha01_nx064_nz17_fwhm275, 
 alpha01_nx064_nz17_fwhm300, alpha01_nx064_nz17_fwhm325, alpha01_nx064_nz17_fwhm350, 
 alpha01_nx064_nz17_fwhm375, alpha01_nx064_nz17_fwhm400, alpha01_nx064_nz17_fwhm425, 
 alpha01_nx064_nz17_fwhm450, alpha01_nx064_nz17_fwhm475, alpha01_nx064_nz17_fwhm500} ;

static float alpha05_nx064_nz17_fwhm000[32] = {
 1.95,1.95,1.95,1.96,1.96,1.96,1.97,1.99,2.04,2.30,
 2.45,2.55,2.64,2.78,2.85,2.90,2.94,2.96,3.00,3.44,
 3.68,3.81,3.88,3.93,3.97,4.53,4.85,5.25,5.85,6.40,
 7.54,8.70};
static float alpha05_nx064_nz17_fwhm025[32] = {
 1.95,1.95,1.95,1.96,1.96,1.96,1.97,1.99,2.04,2.30,
 2.45,2.55,2.64,2.78,2.85,2.90,2.94,2.96,3.00,3.44,
 3.69,3.81,3.88,3.93,3.97,4.53,4.85,5.25,5.85,6.40,
 7.54,8.70};
static float alpha05_nx064_nz17_fwhm050[32] = {
 1.95,1.95,1.95,1.96,1.96,1.96,1.98,1.99,2.15,2.37,
 2.51,2.61,2.68,2.81,2.87,2.91,2.94,2.97,3.12,3.54,
 3.73,3.84,3.91,3.96,3.99,4.64,4.90,5.41,5.93,6.59,
 7.73,8.87};
static float alpha05_nx064_nz17_fwhm075[32] = {
 1.95,1.95,1.96,1.96,1.97,1.98,2.00,2.28,2.49,2.62,
 2.70,2.76,2.80,2.88,2.92,2.95,2.98,3.06,3.57,3.78,
 3.88,3.95,4.00,4.35,4.59,4.91,5.41,5.90,6.62,7.19,
 8.64,10.00};
static float alpha05_nx064_nz17_fwhm100[32] = {
 1.96,1.97,1.98,1.99,2.10,2.33,2.60,2.72,2.80,2.85,
 2.88,2.90,2.92,2.96,2.99,3.34,3.62,3.78,3.94,4.21,
 4.58,4.78,4.91,5.03,5.42,5.93,6.60,7.34,8.29,9.22,
 11.19,13.32};
static float alpha05_nx064_nz17_fwhm125[32] = {
 2.05,2.36,2.53,2.66,2.77,2.83,2.90,2.94,2.97,3.00,
 3.26,3.45,3.58,3.79,3.91,4.00,4.51,4.75,5.07,5.67,
 5.95,6.46,6.82,7.13,7.53,8.47,9.40,10.65,12.26,13.87,
 17.43,21.36};
static float alpha05_nx064_nz17_fwhm150[32] = {
 2.80,2.89,2.94,2.99,3.33,3.53,3.77,3.91,4.00,4.34,
 4.55,4.72,4.84,5.21,5.68,6.04,6.63,6.98,7.90,8.70,
 9.42,10.00,10.72,11.40,11.94,13.82,15.70,18.07,21.41,24.52,
 31.89,40.02};
static float alpha05_nx064_nz17_fwhm175[32] = {
 3.73,3.92,4.24,4.57,4.82,4.99,5.63,5.99,6.45,6.76,
 6.99,7.31,7.60,8.28,8.91,9.73,10.67,11.54,13.09,14.57,
 15.78,16.96,18.21,19.26,20.36,23.82,27.46,32.09,38.30,44.84,
 59.26,76.31};
static float alpha05_nx064_nz17_fwhm200[32] = {
 5.47,5.93,6.43,6.84,7.36,7.77,8.55,9.20,9.76,10.30,
 10.80,11.42,11.79,12.97,14.05,15.35,16.74,18.10,20.49,22.92,
 25.02,27.11,29.25,31.35,33.22,38.97,44.79,52.82,63.05,74.24,
 98.60,129.90};
static float alpha05_nx064_nz17_fwhm225[32] = {
 7.86,8.52,8.98,9.69,10.50,11.14,12.21,13.23,14.07,14.88,
 15.63,16.26,16.88,18.69,20.25,22.16,24.23,26.19,29.93,33.33,
 36.72,39.84,42.79,45.60,48.61,56.93,65.82,78.00,92.91,109.79,
 146.47,193.10};
static float alpha05_nx064_nz17_fwhm250[32] = {
 10.30,11.01,11.90,12.86,13.88,14.78,16.35,17.52,18.70,19.78,
 20.97,21.69,22.55,24.83,26.98,29.70,32.55,35.44,40.63,45.07,
 49.40,53.58,57.28,61.53,65.32,77.57,89.19,104.76,125.87,147.87,
 198.00,260.50};
static float alpha05_nx064_nz17_fwhm275[32] = {
 12.81,14.11,14.98,16.28,17.58,18.52,20.52,22.08,23.66,24.99,
 25.97,27.41,28.44,31.67,34.42,37.81,41.71,45.14,51.30,57.41,
 63.22,68.60,74.32,79.47,84.38,98.81,114.32,134.12,159.86,188.09,
 251.76,327.11};
static float alpha05_nx064_nz17_fwhm300[32] = {
 15.57,17.00,18.16,19.38,20.98,22.34,24.60,26.73,28.60,30.34,
 32.04,33.51,35.08,39.02,42.36,46.61,50.93,55.12,63.30,70.94,
 78.26,84.68,91.10,97.53,103.91,121.87,140.36,164.50,196.12,229.79,
 305.78,397.75};
static float alpha05_nx064_nz17_fwhm325[32] = {
 17.91,19.62,21.04,22.71,24.56,26.25,29.31,31.91,34.09,36.16,
 38.02,40.02,41.61,46.22,50.30,55.36,61.11,67.05,76.29,84.77,
 93.11,101.04,108.65,116.59,124.61,145.88,168.73,196.58,233.85,274.00,
 364.14,471.25};
static float alpha05_nx064_nz17_fwhm350[32] = {
 20.45,22.37,24.19,26.18,28.58,30.49,34.19,37.19,39.85,42.52,
 44.64,46.46,48.67,53.86,58.83,65.10,71.62,78.00,88.62,99.35,
 109.07,119.24,128.27,137.45,145.64,171.85,195.00,228.64,272.64,320.73,
 424.62,543.33};
static float alpha05_nx064_nz17_fwhm375[32] = {
 22.86,25.53,27.56,30.08,32.90,35.43,39.13,42.64,45.48,48.24,
 50.79,53.32,55.69,61.97,68.08,74.76,82.46,89.36,102.95,115.35,
 126.62,137.21,148.04,158.33,167.55,195.59,223.67,264.00,314.90,369.44,
 483.90,615.50};
static float alpha05_nx064_nz17_fwhm400[32] = {
 25.73,28.70,31.02,33.67,36.91,39.60,44.29,48.17,51.44,54.43,
 57.61,60.28,63.09,70.48,76.78,84.30,93.19,101.81,117.00,130.80,
 144.29,155.93,167.28,178.36,189.11,223.08,255.33,301.67,357.17,417.40,
 543.88,690.50};
static float alpha05_nx064_nz17_fwhm425[32] = {
 28.39,31.80,34.31,37.48,41.00,43.97,49.15,53.07,56.85,60.61,
 64.37,67.48,70.31,78.85,85.78,94.67,105.00,114.40,131.69,147.07,
 161.11,174.00,187.08,200.56,213.14,250.33,287.08,335.25,401.20,468.00,
 610.50,773.67};
static float alpha05_nx064_nz17_fwhm450[32] = {
 30.73,34.25,37.45,40.67,44.77,48.09,53.46,58.36,62.67,67.18,
 71.08,74.38,77.84,87.20,95.56,105.62,116.84,127.19,146.00,162.60,
 179.33,193.64,208.90,222.73,237.00,278.22,319.20,373.00,442.67,516.00,
 670.00,848.40};
static float alpha05_nx064_nz17_fwhm475[32] = {
 32.83,36.89,40.10,43.88,48.12,51.79,58.33,63.62,68.84,73.38,
 77.68,81.65,85.45,96.40,105.50,116.71,129.00,140.12,161.23,180.62,
 197.62,214.00,228.75,244.67,260.62,307.70,352.60,412.10,487.75,569.33,
 738.00,928.17};
static float alpha05_nx064_nz17_fwhm500[32] = {
 35.17,39.08,43.00,47.43,51.50,55.82,62.83,69.00,74.69,80.00,
 84.93,89.55,93.68,105.35,115.42,127.41,141.08,153.29,176.70,196.93,
 216.71,233.40,250.25,268.11,286.00,336.00,386.67,449.83,535.14,620.33,
 802.50,1014.20};
static float *alpha05_nx064_nz17[21] = {
 alpha05_nx064_nz17_fwhm000, alpha05_nx064_nz17_fwhm025, alpha05_nx064_nz17_fwhm050, 
 alpha05_nx064_nz17_fwhm075, alpha05_nx064_nz17_fwhm100, alpha05_nx064_nz17_fwhm125, 
 alpha05_nx064_nz17_fwhm150, alpha05_nx064_nz17_fwhm175, alpha05_nx064_nz17_fwhm200, 
 alpha05_nx064_nz17_fwhm225, alpha05_nx064_nz17_fwhm250, alpha05_nx064_nz17_fwhm275, 
 alpha05_nx064_nz17_fwhm300, alpha05_nx064_nz17_fwhm325, alpha05_nx064_nz17_fwhm350, 
 alpha05_nx064_nz17_fwhm375, alpha05_nx064_nz17_fwhm400, alpha05_nx064_nz17_fwhm425, 
 alpha05_nx064_nz17_fwhm450, alpha05_nx064_nz17_fwhm475, alpha05_nx064_nz17_fwhm500} ;

static float alpha10_nx064_nz17_fwhm000[32] = {
 1.90,1.90,1.90,1.90,1.91,1.91,1.92,1.93,1.95,1.97,
 1.99,2.11,2.28,2.56,2.70,2.79,2.86,2.89,2.94,2.99,
 3.33,3.57,3.71,3.80,3.87,4.00,4.59,4.90,5.51,5.91,
 6.92,7.98};
static float alpha10_nx064_nz17_fwhm025[32] = {
 1.90,1.90,1.90,1.90,1.91,1.91,1.92,1.93,1.95,1.97,
 1.99,2.11,2.28,2.56,2.70,2.79,2.86,2.89,2.94,2.99,
 3.34,3.57,3.71,3.80,3.87,4.00,4.59,4.90,5.51,5.91,
 6.92,7.98};
static float alpha10_nx064_nz17_fwhm050[32] = {
 1.90,1.90,1.90,1.91,1.91,1.91,1.93,1.94,1.96,1.98,
 2.01,2.21,2.36,2.61,2.73,2.81,2.87,2.90,2.95,3.04,
 3.43,3.63,3.75,3.84,3.90,4.21,4.68,4.94,5.64,5.98,
 7.05,8.26};
static float alpha10_nx064_nz17_fwhm075[32] = {
 1.90,1.90,1.91,1.91,1.92,1.92,1.94,1.97,2.00,2.23,
 2.39,2.51,2.59,2.74,2.81,2.87,2.91,2.94,3.10,3.51,
 3.70,3.83,3.90,3.96,4.10,4.68,4.94,5.58,6.00,6.74,
 7.93,9.36};
static float alpha10_nx064_nz17_fwhm100[32] = {
 1.91,1.92,1.92,1.94,1.95,1.97,2.19,2.44,2.58,2.68,
 2.74,2.78,2.82,2.88,2.93,2.97,3.20,3.50,3.78,3.92,
 4.05,4.43,4.66,4.82,4.93,5.60,5.98,6.80,7.69,8.55,
 10.32,12.27};
static float alpha10_nx064_nz17_fwhm125[32] = {
 1.95,1.98,2.03,2.30,2.51,2.63,2.76,2.83,2.88,2.92,
 2.95,2.98,3.08,3.49,3.69,3.85,3.98,4.34,4.79,5.06,
 5.57,5.86,6.18,6.58,6.85,7.76,8.63,9.76,11.22,12.73,
 15.94,19.52};
static float alpha10_nx064_nz17_fwhm150[32] = {
 2.52,2.69,2.78,2.87,2.94,2.99,3.38,3.63,3.78,3.88,
 3.96,4.15,4.37,4.75,4.98,5.52,5.91,6.39,7.12,7.85,
 8.53,9.13,9.73,10.32,10.89,12.59,14.24,16.48,19.29,22.33,
 28.84,36.28};
static float alpha10_nx064_nz17_fwhm175[32] = {
 3.11,3.46,3.71,3.91,4.21,4.50,4.88,5.27,5.64,5.89,
 6.17,6.48,6.73,7.40,7.96,8.69,9.50,10.26,11.70,12.95,
 14.14,15.25,16.31,17.46,18.49,21.62,24.79,28.94,34.38,40.34,
 53.25,67.93};
static float alpha10_nx064_nz17_fwhm200[32] = {
 4.60,4.93,5.34,5.78,6.24,6.68,7.43,8.00,8.57,8.99,
 9.48,9.86,10.28,11.44,12.42,13.55,14.88,16.04,18.24,20.43,
 22.29,24.18,25.96,27.78,29.46,34.65,40.19,47.34,56.52,66.31,
 88.23,114.52};
static float alpha10_nx064_nz17_fwhm225[32] = {
 6.45,6.99,7.60,8.26,8.89,9.48,10.54,11.45,12.21,12.86,
 13.52,14.13,14.75,16.25,17.78,19.45,21.24,23.00,26.28,29.46,
 32.42,35.11,37.77,40.46,43.23,50.69,58.32,69.20,82.56,97.48,
 129.98,169.64};
static float alpha10_nx064_nz17_fwhm250[32] = {
 8.46,9.19,9.95,10.76,11.69,12.48,13.86,15.00,16.03,17.00,
 17.84,18.69,19.42,21.60,23.44,25.78,28.50,30.87,35.50,39.53,
 43.51,47.34,50.87,54.41,57.98,68.26,78.72,92.26,110.81,130.50,
 173.50,228.28};
static float alpha10_nx064_nz17_fwhm275[32] = {
 10.27,11.42,12.26,13.34,14.44,15.45,17.17,18.72,19.98,20.99,
 22.18,23.29,24.36,27.11,29.66,32.47,35.82,39.06,44.61,50.02,
 54.93,59.64,64.39,69.11,73.51,86.16,99.24,117.40,140.21,164.90,
 219.29,286.00};
static float alpha10_nx064_nz17_fwhm300[32] = {
 12.22,13.51,14.60,15.89,17.18,18.42,20.59,22.42,24.14,25.65,
 26.99,28.35,29.52,32.95,35.89,39.58,43.73,47.66,54.76,61.08,
 67.37,73.13,78.38,83.64,89.61,105.78,121.60,142.37,170.83,199.97,
 266.73,344.58};
static float alpha10_nx064_nz17_fwhm325[32] = {
 14.01,15.55,16.87,18.37,20.09,21.60,24.11,26.36,28.31,29.98,
 31.62,33.26,34.69,38.77,42.49,46.86,51.81,56.53,65.20,72.59,
 79.61,86.58,93.20,99.57,106.28,125.34,144.33,169.77,203.00,237.55,
 316.22,404.29};
static float alpha10_nx064_nz17_fwhm350[32] = {
 15.72,17.53,19.13,20.95,22.82,24.49,27.62,30.02,32.43,34.49,
 36.52,38.33,40.08,45.07,49.30,54.32,60.30,65.89,75.69,84.80,
 92.77,100.92,108.53,116.58,123.72,147.04,168.20,197.80,235.85,276.70,
 368.27,468.11};
static float alpha10_nx064_nz17_fwhm375[32] = {
 17.38,19.48,21.22,23.29,25.55,27.59,30.93,33.88,36.61,39.13,
 41.46,43.49,45.65,51.30,56.38,62.09,68.92,75.08,86.51,97.16,
 106.48,115.48,124.83,134.29,142.80,168.48,193.09,227.64,269.57,318.69,
 418.44,532.00};
static float alpha10_nx064_nz17_fwhm400[32] = {
 19.07,21.25,23.38,25.60,28.24,30.51,34.37,37.85,41.03,43.85,
 46.57,49.31,51.68,57.58,63.05,70.17,77.73,84.87,97.55,109.80,
 120.84,131.45,142.47,151.81,161.62,191.55,220.38,256.88,306.60,360.00,
 468.36,596.57};
static float alpha10_nx064_nz17_fwhm425[32] = {
 20.43,23.16,25.25,28.04,30.97,33.53,38.15,42.20,45.74,48.83,
 51.75,54.58,57.12,64.16,70.61,77.87,86.74,94.78,109.44,122.91,
 135.68,148.04,159.60,170.43,181.68,214.45,246.14,288.06,344.64,402.33,
 523.38,663.50};
static float alpha10_nx064_nz17_fwhm450[32] = {
 21.99,24.72,27.35,30.52,33.73,36.45,41.57,46.31,50.04,53.68,
 56.98,59.75,62.47,70.33,77.57,86.57,96.21,105.21,121.26,136.81,
 150.52,164.15,176.63,190.05,202.50,238.11,272.65,318.69,380.38,444.80,
 576.90,727.25};
static float alpha10_nx064_nz17_fwhm475[32] = {
 23.10,26.38,29.09,32.65,36.20,39.34,44.98,49.75,54.31,58.00,
 61.38,64.88,68.14,77.18,85.24,94.57,105.28,115.17,133.70,150.56,
 165.47,180.22,194.95,208.84,222.23,261.47,298.85,350.33,419.11,487.62,
 630.56,796.62};
static float alpha10_nx064_nz17_fwhm500[32] = {
 24.22,27.85,31.00,34.63,38.56,42.21,48.04,53.27,58.10,62.43,
 66.50,69.92,73.65,83.73,92.35,102.85,114.30,126.08,146.15,163.93,
 180.71,197.30,212.60,228.36,241.83,283.78,325.45,384.83,458.17,531.80,
 685.00,867.43};
static float *alpha10_nx064_nz17[21] = {
 alpha10_nx064_nz17_fwhm000, alpha10_nx064_nz17_fwhm025, alpha10_nx064_nz17_fwhm050, 
 alpha10_nx064_nz17_fwhm075, alpha10_nx064_nz17_fwhm100, alpha10_nx064_nz17_fwhm125, 
 alpha10_nx064_nz17_fwhm150, alpha10_nx064_nz17_fwhm175, alpha10_nx064_nz17_fwhm200, 
 alpha10_nx064_nz17_fwhm225, alpha10_nx064_nz17_fwhm250, alpha10_nx064_nz17_fwhm275, 
 alpha10_nx064_nz17_fwhm300, alpha10_nx064_nz17_fwhm325, alpha10_nx064_nz17_fwhm350, 
 alpha10_nx064_nz17_fwhm375, alpha10_nx064_nz17_fwhm400, alpha10_nx064_nz17_fwhm425, 
 alpha10_nx064_nz17_fwhm450, alpha10_nx064_nz17_fwhm475, alpha10_nx064_nz17_fwhm500} ;

static float **nx064_nz17[3] = {
  alpha01_nx064_nz17 , alpha05_nx064_nz17 , alpha10_nx064_nz17 };

static float alpha01_nx064_nz18_fwhm000[32] = {
 1.99,1.99,1.99,2.00,2.00,2.28,2.61,2.76,2.83,2.88,
 2.90,2.92,2.94,2.96,2.98,2.99,3.20,3.56,3.81,3.92,
 3.97,4.00,4.39,4.64,4.78,4.97,5.58,5.95,6.80,7.47,
 8.65,9.94};
static float alpha01_nx064_nz18_fwhm025[32] = {
 1.99,1.99,1.99,2.00,2.00,2.28,2.61,2.76,2.83,2.88,
 2.90,2.92,2.94,2.96,2.98,2.99,3.20,3.56,3.81,3.92,
 3.97,4.00,4.39,4.64,4.78,4.97,5.58,5.95,6.80,7.47,
 8.65,9.94};
static float alpha01_nx064_nz18_fwhm050[32] = {
 1.99,1.99,1.99,2.00,2.12,2.39,2.66,2.79,2.85,2.89,
 2.91,2.93,2.94,2.97,2.98,3.00,3.34,3.65,3.84,3.94,
 3.98,4.11,4.51,4.72,4.83,4.99,5.70,6.07,6.89,7.69,
 8.85,10.24};
static float alpha01_nx064_nz18_fwhm075[32] = {
 1.99,2.00,2.00,2.27,2.51,2.66,2.81,2.88,2.91,2.93,
 2.95,2.96,2.97,2.99,3.00,3.46,3.72,3.84,3.95,4.00,
 4.47,4.73,4.85,4.94,5.00,5.78,6.08,6.88,7.78,8.47,
 9.97,11.67};
static float alpha01_nx064_nz18_fwhm100[32] = {
 2.19,2.48,2.64,2.77,2.85,2.90,2.94,2.96,2.98,2.99,
 3.00,3.06,3.34,3.66,3.81,3.91,3.98,4.21,4.73,4.94,
 5.24,5.61,5.83,5.95,6.28,6.96,7.83,8.55,9.76,10.83,
 13.34,15.73};
static float alpha01_nx064_nz18_fwhm125[32] = {
 2.83,2.90,2.94,2.97,2.99,3.12,3.47,3.67,3.80,3.87,
 3.93,3.96,4.00,4.51,4.75,4.94,5.32,5.68,6.11,6.81,
 7.32,7.75,8.04,8.62,8.90,10.14,11.23,12.77,14.71,16.58,
 20.75,26.25};
static float alpha01_nx064_nz18_fwhm150[32] = {
 3.49,3.73,3.86,3.94,4.00,4.40,4.74,4.89,5.06,5.45,
 5.74,5.88,5.95,6.60,6.93,7.68,8.30,8.81,9.80,10.75,
 11.56,12.36,13.11,13.81,14.53,16.95,19.28,22.27,25.96,30.10,
 38.82,49.80};
static float alpha01_nx064_nz18_fwhm175[32] = {
 4.96,5.41,5.72,6.00,6.49,6.79,7.31,7.94,8.43,8.76,
 9.05,9.49,9.72,10.56,11.42,12.47,13.47,14.33,15.97,17.84,
 19.49,20.95,22.46,23.89,25.46,30.22,34.35,39.84,48.29,56.00,
 73.80,94.78};
static float alpha01_nx064_nz18_fwhm200[32] = {
 7.77,8.41,8.81,9.37,9.97,10.55,11.57,12.23,12.83,13.63,
 14.14,14.80,15.37,16.64,17.95,19.65,21.47,23.11,26.30,29.31,
 31.70,34.43,36.89,39.94,42.43,49.46,56.08,66.10,79.00,93.33,
 125.00,167.89};
static float alpha01_nx064_nz18_fwhm225[32] = {
 10.97,11.76,12.48,13.29,14.21,15.03,16.52,17.84,18.90,19.81,
 20.60,21.37,22.25,24.13,25.91,28.45,30.97,34.16,39.06,43.47,
 46.92,50.90,55.11,58.58,62.33,72.69,83.11,98.67,118.86,141.57,
 186.67,250.75};
static float alpha01_nx064_nz18_fwhm250[32] = {
 14.66,15.85,16.94,17.94,18.91,20.00,21.97,23.55,24.89,26.40,
 27.54,28.76,29.77,32.92,36.00,39.79,42.95,46.85,53.83,59.75,
 65.00,69.59,74.55,79.82,85.00,98.83,114.25,136.43,162.33,189.67,
 258.83,343.67};
static float alpha01_nx064_nz18_fwhm275[32] = {
 18.52,19.89,21.20,22.52,24.36,25.71,28.28,30.45,32.58,34.44,
 36.00,37.47,39.06,43.40,47.07,51.71,56.80,61.22,69.50,76.64,
 83.56,89.83,96.60,102.80,109.40,128.67,148.33,174.25,213.00,251.67,
 338.67,439.50};
static float alpha01_nx064_nz18_fwhm300[32] = {
 22.68,24.60,26.34,28.30,30.47,32.38,35.55,38.38,40.58,42.86,
 44.78,47.06,48.80,53.87,59.30,64.29,70.00,75.75,85.50,94.83,
 104.25,113.43,122.12,129.88,138.00,161.00,183.43,220.67,265.67,310.60,
 411.00,534.50};
static float alpha01_nx064_nz18_fwhm325[32] = {
 27.64,30.00,31.94,34.47,37.05,39.29,42.69,45.92,48.85,52.00,
 54.28,56.45,58.57,64.50,71.00,77.70,84.45,91.17,103.14,115.50,
 127.44,137.50,147.00,156.33,165.40,195.20,226.29,268.00,314.67,367.50,
 490.75,640.00};
static float alpha01_nx064_nz18_fwhm350[32] = {
 33.19,35.50,37.75,40.00,43.32,45.70,49.90,54.40,58.07,60.58,
 63.78,67.11,69.40,77.38,83.78,91.00,100.00,108.27,123.00,136.00,
 147.67,161.20,173.17,183.33,197.00,232.40,266.50,308.25,368.00,428.00,
 566.00,748.67};
static float alpha01_nx064_nz18_fwhm375[32] = {
 37.56,40.12,43.53,46.44,49.79,52.59,58.38,63.12,67.25,71.62,
 75.00,79.22,82.00,89.12,96.62,105.56,115.50,124.38,139.57,156.40,
 171.00,187.00,203.33,218.00,230.00,268.00,305.00,355.50,424.60,497.33,
 662.00,861.00};
static float alpha01_nx064_nz18_fwhm400[32] = {
 42.82,46.13,48.82,52.50,57.00,60.70,66.62,72.00,77.11,80.75,
 84.88,89.00,92.56,101.60,109.50,120.40,130.25,141.57,159.60,178.67,
 199.33,214.33,229.75,245.67,262.50,307.00,352.50,410.00,487.50,559.33,
 754.00,967.00};
static float alpha01_nx064_nz18_fwhm425[32] = {
 47.92,52.00,55.85,60.00,64.40,68.00,75.29,81.40,87.00,91.33,
 96.25,99.86,104.00,114.20,123.33,134.00,146.83,158.00,184.00,205.50,
 227.00,246.00,262.00,279.00,297.00,350.50,396.00,469.00,540.50,640.67,
 849.50,1089.50};
static float alpha01_nx064_nz18_fwhm450[32] = {
 53.60,58.80,62.00,65.83,71.86,76.17,84.20,90.67,96.67,102.14,
 106.00,111.20,114.83,127.14,137.71,149.00,165.50,178.00,208.50,234.00,
 254.50,276.00,294.00,316.00,335.50,389.50,449.00,516.00,615.00,715.00,
 955.00,1214.00};
static float alpha01_nx064_nz18_fwhm475[32] = {
 59.00,63.86,68.67,73.67,79.25,83.83,93.33,100.67,107.25,112.83,
 117.30,122.17,127.75,140.33,152.33,167.50,185.00,203.00,234.50,261.00,
 284.00,308.67,328.50,349.00,371.25,436.00,493.00,572.00,675.00,799.50,
 1061.00,1316.00};
static float alpha01_nx064_nz18_fwhm500[32] = {
 64.38,69.67,75.00,80.00,86.40,92.33,101.75,110.17,117.00,123.00,
 128.75,136.00,140.33,154.50,169.67,185.50,207.00,227.00,260.50,287.00,
 312.60,337.00,360.50,383.67,410.00,477.00,541.33,631.00,749.00,889.67,
 1152.00,1424.00};
static float *alpha01_nx064_nz18[21] = {
 alpha01_nx064_nz18_fwhm000, alpha01_nx064_nz18_fwhm025, alpha01_nx064_nz18_fwhm050, 
 alpha01_nx064_nz18_fwhm075, alpha01_nx064_nz18_fwhm100, alpha01_nx064_nz18_fwhm125, 
 alpha01_nx064_nz18_fwhm150, alpha01_nx064_nz18_fwhm175, alpha01_nx064_nz18_fwhm200, 
 alpha01_nx064_nz18_fwhm225, alpha01_nx064_nz18_fwhm250, alpha01_nx064_nz18_fwhm275, 
 alpha01_nx064_nz18_fwhm300, alpha01_nx064_nz18_fwhm325, alpha01_nx064_nz18_fwhm350, 
 alpha01_nx064_nz18_fwhm375, alpha01_nx064_nz18_fwhm400, alpha01_nx064_nz18_fwhm425, 
 alpha01_nx064_nz18_fwhm450, alpha01_nx064_nz18_fwhm475, alpha01_nx064_nz18_fwhm500} ;

static float alpha05_nx064_nz18_fwhm000[32] = {
 1.95,1.95,1.95,1.96,1.96,1.96,1.98,1.99,2.15,2.38,
 2.51,2.61,2.67,2.80,2.86,2.91,2.94,2.96,3.00,3.46,
 3.70,3.82,3.89,3.94,3.98,4.58,4.85,5.20,5.87,6.44,
 7.56,8.71};
static float alpha05_nx064_nz18_fwhm025[32] = {
 1.95,1.95,1.95,1.96,1.96,1.96,1.98,1.99,2.15,2.38,
 2.51,2.61,2.67,2.80,2.86,2.91,2.94,2.96,3.00,3.46,
 3.70,3.82,3.89,3.94,3.98,4.58,4.85,5.20,5.87,6.44,
 7.56,8.71};
static float alpha05_nx064_nz18_fwhm050[32] = {
 1.95,1.95,1.95,1.96,1.96,1.97,1.98,2.00,2.26,2.44,
 2.56,2.64,2.70,2.82,2.88,2.92,2.95,2.97,3.11,3.55,
 3.74,3.85,3.91,3.96,3.99,4.65,4.90,5.42,5.94,6.61,
 7.74,8.90};
static float alpha05_nx064_nz18_fwhm075[32] = {
 1.95,1.96,1.96,1.96,1.97,1.98,2.06,2.38,2.54,2.65,
 2.72,2.78,2.81,2.88,2.92,2.95,2.98,3.06,3.59,3.80,
 3.89,3.95,4.00,4.36,4.61,4.92,5.42,5.91,6.68,7.30,
 8.69,9.99};
static float alpha05_nx064_nz18_fwhm100[32] = {
 1.96,1.97,1.98,1.99,2.21,2.43,2.65,2.76,2.82,2.86,
 2.89,2.91,2.93,2.97,2.99,3.36,3.65,3.79,3.94,4.24,
 4.60,4.80,4.92,5.05,5.39,5.93,6.68,7.41,8.33,9.23,
 11.23,13.40};
static float alpha05_nx064_nz18_fwhm125[32] = {
 2.08,2.40,2.57,2.70,2.79,2.85,2.91,2.95,2.98,3.03,
 3.29,3.47,3.60,3.81,3.92,4.09,4.57,4.78,5.15,5.72,
 5.98,6.51,6.83,7.13,7.55,8.58,9.47,10.76,12.40,13.92,
 17.54,21.59};
static float alpha05_nx064_nz18_fwhm150[32] = {
 2.83,2.91,2.96,3.09,3.38,3.59,3.82,3.95,4.18,4.43,
 4.63,4.78,4.89,5.35,5.73,6.13,6.74,7.12,7.98,8.82,
 9.52,10.14,10.84,11.52,12.07,13.99,15.83,18.28,21.59,24.95,
 32.07,40.74};
static float alpha05_nx064_nz18_fwhm175[32] = {
 3.83,4.00,4.37,4.67,4.89,5.17,5.71,6.03,6.52,6.85,
 7.16,7.48,7.71,8.45,9.08,9.87,10.82,11.66,13.15,14.61,
 15.92,17.24,18.47,19.75,20.87,24.36,27.91,32.62,38.99,45.46,
 59.98,77.45};
static float alpha05_nx064_nz18_fwhm200[32] = {
 5.62,6.09,6.55,6.97,7.58,7.94,8.74,9.36,9.98,10.54,
 10.93,11.47,11.89,13.20,14.29,15.65,17.06,18.51,20.99,23.31,
 25.55,27.51,29.57,31.71,33.68,39.74,45.77,53.73,63.59,75.30,
 100.72,132.14};
static float alpha05_nx064_nz18_fwhm225[32] = {
 7.95,8.68,9.25,9.88,10.66,11.34,12.44,13.41,14.23,15.01,
 15.85,16.52,17.21,18.96,20.54,22.62,24.78,26.99,30.58,34.00,
 37.27,40.43,43.56,46.43,49.19,57.78,67.15,78.90,94.97,111.62,
 149.22,194.22};
static float alpha05_nx064_nz18_fwhm250[32] = {
 10.45,11.35,12.14,13.03,13.98,14.91,16.53,17.82,19.09,20.29,
 21.29,22.24,23.21,25.76,27.90,30.39,33.54,35.92,41.04,45.45,
 50.05,54.48,58.80,62.79,66.47,78.55,91.26,107.82,127.71,150.11,
 201.69,266.20};
static float alpha05_nx064_nz18_fwhm275[32] = {
 13.01,14.18,15.23,16.42,17.79,18.93,21.04,22.69,24.38,25.84,
 27.15,28.32,29.45,32.57,35.32,38.71,42.32,45.60,52.64,58.73,
 64.39,69.74,74.96,80.44,85.47,100.84,116.35,136.65,162.89,191.47,
 257.33,334.33};
static float alpha05_nx064_nz18_fwhm300[32] = {
 15.69,17.19,18.44,19.99,21.58,23.14,25.42,27.51,29.54,31.19,
 32.82,34.57,35.92,39.53,43.15,47.28,52.37,56.83,64.94,72.03,
 79.23,86.28,93.43,99.47,105.13,124.29,142.43,167.40,200.46,236.40,
 313.88,411.40};
static float alpha05_nx064_nz18_fwhm325[32] = {
 18.36,20.03,21.60,23.38,25.38,27.06,29.92,32.75,35.14,37.26,
 39.12,41.00,42.77,47.17,51.52,56.70,62.03,67.52,77.33,87.31,
 96.03,103.28,111.37,118.82,126.24,148.17,170.67,200.07,239.62,282.00,
 373.60,489.50};
static float alpha05_nx064_nz18_fwhm350[32] = {
 20.88,23.02,24.75,26.97,29.33,31.50,35.13,38.31,41.19,43.56,
 45.67,47.74,49.60,55.07,60.26,66.54,73.52,80.07,91.73,102.43,
 112.53,121.65,130.89,139.50,148.33,173.75,198.80,235.09,282.57,328.08,
 437.88,569.25};
static float alpha05_nx064_nz18_fwhm375[32] = {
 23.71,26.23,28.37,30.98,33.82,36.42,40.17,43.45,46.49,49.14,
 52.00,54.51,57.22,63.96,69.68,76.42,84.88,92.33,105.82,118.00,
 129.12,139.67,151.56,161.83,171.15,199.50,230.70,273.00,323.38,377.57,
 502.75,642.50};
static float alpha05_nx064_nz18_fwhm400[32] = {
 26.47,29.35,31.68,34.91,37.82,40.42,45.23,48.94,52.72,56.21,
 59.49,62.71,65.37,72.47,79.29,87.57,96.24,105.54,120.28,133.13,
 146.58,159.29,171.38,182.53,194.42,229.08,263.45,309.75,368.33,428.20,
 565.20,721.25};
static float alpha05_nx064_nz18_fwhm425[32] = {
 29.06,32.35,35.13,38.39,41.86,44.95,50.07,55.00,59.08,63.17,
 66.57,69.96,72.93,80.92,89.00,97.79,109.16,118.27,134.71,149.62,
 165.11,178.71,191.69,205.67,217.89,256.50,295.91,347.70,412.67,479.71,
 629.33,806.50};
static float alpha05_nx064_nz18_fwhm450[32] = {
 31.53,35.00,38.31,41.76,45.70,49.55,55.74,60.75,65.36,69.65,
 73.46,77.24,80.48,89.73,98.39,108.71,120.29,130.57,149.71,167.60,
 182.57,198.00,214.64,229.09,243.50,287.60,330.88,386.40,457.71,531.33,
 693.75,885.00};
static float alpha05_nx064_nz18_fwhm475[32] = {
 34.20,38.34,41.51,45.42,50.22,54.18,60.68,66.04,71.00,76.07,
 80.33,84.28,87.83,97.96,107.86,119.58,132.06,143.50,164.73,183.55,
 201.50,219.32,236.50,253.38,269.33,316.50,365.60,425.89,501.40,583.62,
 767.00,970.50};
static float alpha05_nx064_nz18_fwhm500[32] = {
 36.74,40.85,44.54,49.38,54.00,58.24,64.96,71.53,76.89,82.43,
 87.17,91.40,95.38,107.45,117.71,129.75,144.67,158.06,180.21,199.90,
 221.00,240.50,260.00,278.73,295.29,349.57,398.80,465.33,549.50,639.67,
 836.50,1048.00};
static float *alpha05_nx064_nz18[21] = {
 alpha05_nx064_nz18_fwhm000, alpha05_nx064_nz18_fwhm025, alpha05_nx064_nz18_fwhm050, 
 alpha05_nx064_nz18_fwhm075, alpha05_nx064_nz18_fwhm100, alpha05_nx064_nz18_fwhm125, 
 alpha05_nx064_nz18_fwhm150, alpha05_nx064_nz18_fwhm175, alpha05_nx064_nz18_fwhm200, 
 alpha05_nx064_nz18_fwhm225, alpha05_nx064_nz18_fwhm250, alpha05_nx064_nz18_fwhm275, 
 alpha05_nx064_nz18_fwhm300, alpha05_nx064_nz18_fwhm325, alpha05_nx064_nz18_fwhm350, 
 alpha05_nx064_nz18_fwhm375, alpha05_nx064_nz18_fwhm400, alpha05_nx064_nz18_fwhm425, 
 alpha05_nx064_nz18_fwhm450, alpha05_nx064_nz18_fwhm475, alpha05_nx064_nz18_fwhm500} ;

static float alpha10_nx064_nz18_fwhm000[32] = {
 1.90,1.90,1.90,1.91,1.91,1.91,1.92,1.94,1.96,1.98,
 2.02,2.21,2.34,2.59,2.71,2.80,2.86,2.90,2.94,2.99,
 3.37,3.59,3.73,3.81,3.87,4.08,4.59,4.90,5.53,5.92,
 6.95,7.99};
static float alpha10_nx064_nz18_fwhm025[32] = {
 1.90,1.90,1.90,1.91,1.91,1.91,1.92,1.94,1.96,1.98,
 2.02,2.21,2.34,2.59,2.71,2.80,2.86,2.90,2.94,2.99,
 3.37,3.59,3.73,3.81,3.87,4.08,4.59,4.90,5.53,5.92,
 6.95,8.00};
static float alpha10_nx064_nz18_fwhm050[32] = {
 1.90,1.90,1.90,1.91,1.91,1.92,1.93,1.94,1.96,1.99,
 2.12,2.28,2.40,2.63,2.74,2.82,2.87,2.91,2.95,3.07,
 3.45,3.65,3.76,3.84,3.90,4.21,4.68,4.95,5.65,5.99,
 7.18,8.32};
static float alpha10_nx064_nz18_fwhm075[32] = {
 1.90,1.91,1.91,1.91,1.92,1.93,1.95,1.98,2.08,2.29,
 2.44,2.54,2.62,2.75,2.82,2.87,2.92,2.95,3.13,3.54,
 3.72,3.83,3.90,3.96,4.13,4.71,4.95,5.59,6.04,6.80,
 7.98,9.37};
static float alpha10_nx064_nz18_fwhm100[32] = {
 1.91,1.92,1.93,1.94,1.96,1.99,2.28,2.50,2.62,2.70,
 2.75,2.79,2.83,2.89,2.93,2.97,3.24,3.52,3.79,3.92,
 4.07,4.46,4.69,4.83,4.93,5.62,6.02,6.83,7.72,8.58,
 10.40,12.33};
static float alpha10_nx064_nz18_fwhm125[32] = {
 1.95,1.98,2.11,2.36,2.54,2.66,2.78,2.85,2.89,2.92,
 2.95,2.98,3.10,3.52,3.72,3.87,3.99,4.40,4.81,5.12,
 5.61,5.89,6.23,6.61,6.87,7.82,8.70,9.85,11.33,12.81,
 15.98,19.71};
static float alpha10_nx064_nz18_fwhm150[32] = {
 2.57,2.71,2.80,2.88,2.95,3.00,3.44,3.67,3.82,3.92,
 3.99,4.24,4.43,4.81,5.05,5.60,5.96,6.48,7.25,7.91,
 8.61,9.12,9.83,10.47,10.96,12.72,14.42,16.65,19.46,22.61,
 29.06,36.74};
static float alpha10_nx064_nz18_fwhm175[32] = {
 3.27,3.58,3.78,3.97,4.32,4.60,4.94,5.38,5.71,5.94,
 6.28,6.59,6.79,7.47,8.04,8.82,9.68,10.41,11.81,13.10,
 14.33,15.46,16.65,17.75,18.80,22.06,25.17,29.32,34.91,40.74,
 53.98,69.52};
static float alpha10_nx064_nz18_fwhm200[32] = {
 4.73,5.12,5.54,5.94,6.46,6.84,7.57,8.17,8.70,9.17,
 9.66,10.04,10.49,11.60,12.59,13.74,15.15,16.39,18.64,20.73,
 22.79,24.61,26.40,28.05,30.01,35.44,40.87,48.17,57.18,67.03,
 89.98,117.71};
static float alpha10_nx064_nz18_fwhm225[32] = {
 6.60,7.26,7.84,8.40,8.99,9.64,10.71,11.63,12.38,13.10,
 13.77,14.34,14.97,16.55,18.05,19.90,21.83,23.63,26.97,29.95,
 32.97,36.02,38.80,41.45,44.10,51.57,59.45,69.56,83.64,98.82,
 132.91,172.50};
static float alpha10_nx064_nz18_fwhm250[32] = {
 8.57,9.41,10.06,10.91,11.84,12.69,14.10,15.26,16.36,17.37,
 18.22,19.07,19.90,22.18,24.03,26.50,29.01,31.55,36.01,40.15,
 44.08,48.03,51.59,55.09,58.76,69.04,79.72,94.39,112.67,132.88,
 177.12,234.00};
static float alpha10_nx064_nz18_fwhm275[32] = {
 10.55,11.62,12.53,13.62,14.81,15.73,17.55,19.15,20.60,21.83,
 23.02,24.07,25.08,27.85,30.19,33.22,36.88,40.14,45.58,51.03,
 56.13,60.86,65.29,70.29,74.41,87.79,101.76,119.79,143.56,168.90,
 225.29,293.65};
static float alpha10_nx064_nz18_fwhm300[32] = {
 12.62,13.86,14.93,16.18,17.62,18.91,21.14,23.13,24.82,26.41,
 27.84,29.14,30.42,33.83,37.04,40.87,44.73,48.82,56.00,62.14,
 68.40,74.33,79.88,85.86,91.10,107.82,124.05,147.07,176.00,206.55,
 273.44,352.57};
static float alpha10_nx064_nz18_fwhm325[32] = {
 14.49,16.01,17.39,18.97,20.67,22.33,24.86,27.15,29.21,31.09,
 32.85,34.34,35.94,40.18,43.90,47.96,53.22,57.76,66.05,73.91,
 81.30,88.37,95.39,102.97,109.70,129.37,148.61,174.89,208.30,244.33,
 324.31,420.14};
static float alpha10_nx064_nz18_fwhm350[32] = {
 16.46,18.35,19.88,21.70,23.75,25.59,28.60,31.23,33.56,35.77,
 37.91,39.86,41.61,46.45,50.76,55.95,61.80,67.13,77.15,86.30,
 95.44,104.27,112.33,120.22,128.13,150.49,173.24,203.31,243.47,284.47,
 376.33,489.38};
static float alpha10_nx064_nz18_fwhm375[32] = {
 18.31,20.39,22.24,24.35,26.60,28.69,32.08,35.09,37.89,40.65,
 42.99,45.08,47.09,52.59,58.02,63.94,70.90,77.43,89.12,99.76,
 109.45,119.12,127.89,137.27,146.11,172.81,198.86,233.48,278.36,328.56,
 431.89,552.14};
static float alpha10_nx064_nz18_fwhm400[32] = {
 19.98,22.38,24.26,26.83,29.38,31.70,35.69,39.34,42.62,45.62,
 48.26,50.57,53.03,59.59,65.19,72.17,80.51,87.38,101.05,112.83,
 124.05,134.21,144.81,155.16,165.67,195.64,225.33,264.62,316.43,369.36,
 485.50,621.44};
static float alpha10_nx064_nz18_fwhm425[32] = {
 21.46,24.13,26.56,29.10,32.15,34.85,39.79,43.51,46.96,50.31,
 53.32,56.30,58.98,66.30,72.80,80.78,90.20,97.84,112.59,125.91,
 138.96,150.97,162.50,174.25,185.86,219.48,252.61,295.42,352.14,413.30,
 542.75,689.20};
static float alpha10_nx064_nz18_fwhm450[32] = {
 22.77,25.90,28.51,31.59,35.13,38.21,42.78,47.53,51.54,55.35,
 58.83,61.86,64.96,72.92,80.42,89.50,99.21,108.33,124.58,139.17,
 153.97,166.97,181.33,193.95,206.69,243.14,278.08,328.29,391.88,457.83,
 597.40,756.88};
static float alpha10_nx064_nz18_fwhm475[32] = {
 24.27,27.52,30.44,33.98,37.58,40.65,46.42,51.65,56.34,60.62,
 64.50,67.74,70.85,80.14,88.09,97.85,108.67,118.21,136.32,153.13,
 169.22,184.45,199.00,213.71,227.92,266.68,306.67,362.42,431.25,502.25,
 651.75,826.12};
static float alpha10_nx064_nz18_fwhm500[32] = {
 25.42,29.03,32.10,35.87,39.80,43.66,50.37,56.11,60.78,65.24,
 69.18,73.06,76.54,87.00,95.82,106.26,118.22,128.87,148.53,168.00,
 185.11,201.78,219.06,233.36,247.07,292.64,337.00,397.00,471.29,547.12,
 714.00,899.83};
static float *alpha10_nx064_nz18[21] = {
 alpha10_nx064_nz18_fwhm000, alpha10_nx064_nz18_fwhm025, alpha10_nx064_nz18_fwhm050, 
 alpha10_nx064_nz18_fwhm075, alpha10_nx064_nz18_fwhm100, alpha10_nx064_nz18_fwhm125, 
 alpha10_nx064_nz18_fwhm150, alpha10_nx064_nz18_fwhm175, alpha10_nx064_nz18_fwhm200, 
 alpha10_nx064_nz18_fwhm225, alpha10_nx064_nz18_fwhm250, alpha10_nx064_nz18_fwhm275, 
 alpha10_nx064_nz18_fwhm300, alpha10_nx064_nz18_fwhm325, alpha10_nx064_nz18_fwhm350, 
 alpha10_nx064_nz18_fwhm375, alpha10_nx064_nz18_fwhm400, alpha10_nx064_nz18_fwhm425, 
 alpha10_nx064_nz18_fwhm450, alpha10_nx064_nz18_fwhm475, alpha10_nx064_nz18_fwhm500} ;

static float **nx064_nz18[3] = {
  alpha01_nx064_nz18 , alpha05_nx064_nz18 , alpha10_nx064_nz18 };

static float alpha01_nx064_nz19_fwhm000[32] = {
 1.99,1.99,1.99,1.99,2.00,2.29,2.62,2.76,2.84,2.88,
 2.91,2.93,2.94,2.97,2.98,2.99,3.01,3.48,3.81,3.92,
 3.97,4.00,4.48,4.69,4.83,5.00,5.63,5.96,6.81,7.46,
 8.81,9.99};
static float alpha01_nx064_nz19_fwhm025[32] = {
 1.99,1.99,1.99,1.99,2.00,2.29,2.62,2.76,2.84,2.88,
 2.91,2.93,2.94,2.97,2.98,2.99,3.01,3.48,3.81,3.92,
 3.97,4.00,4.48,4.69,4.83,5.00,5.63,5.96,6.81,7.46,
 8.81,9.99};
static float alpha01_nx064_nz19_fwhm050[32] = {
 1.99,1.99,1.99,2.00,2.11,2.42,2.68,2.79,2.86,2.89,
 2.92,2.94,2.95,2.97,2.98,2.99,3.26,3.58,3.84,3.94,
 3.98,4.27,4.59,4.77,4.88,5.19,5.73,6.11,6.90,7.66,
 8.97,10.44};
static float alpha01_nx064_nz19_fwhm075[32] = {
 1.99,2.00,2.00,2.25,2.52,2.67,2.82,2.88,2.91,2.94,
 2.95,2.96,2.97,2.98,2.99,3.37,3.70,3.84,3.95,4.00,
 4.55,4.76,4.88,4.96,5.13,5.78,6.20,6.90,7.74,8.57,
 10.06,11.97};
static float alpha01_nx064_nz19_fwhm100[32] = {
 2.16,2.45,2.65,2.78,2.85,2.89,2.93,2.96,2.97,2.98,
 2.99,3.00,3.24,3.65,3.82,3.92,3.98,4.26,4.75,4.92,
 5.12,5.61,5.81,5.95,6.23,6.98,7.77,8.71,9.76,10.88,
 13.33,16.04};
static float alpha01_nx064_nz19_fwhm125[32] = {
 2.82,2.88,2.92,2.96,2.98,3.00,3.44,3.67,3.82,3.89,
 3.93,3.96,3.99,4.51,4.78,4.94,5.31,5.73,6.17,6.76,
 7.26,7.75,7.97,8.56,8.85,10.07,11.25,12.84,15.00,16.86,
 21.23,25.79};
static float alpha01_nx064_nz19_fwhm150[32] = {
 3.45,3.68,3.81,3.91,3.99,4.31,4.75,4.92,5.06,5.43,
 5.73,5.89,5.99,6.59,6.88,7.52,8.08,8.71,9.74,10.76,
 11.60,12.44,13.34,14.08,14.93,17.00,19.11,22.39,25.95,29.94,
 38.56,49.61};
static float alpha01_nx064_nz19_fwhm175[32] = {
 4.93,5.33,5.68,5.98,6.39,6.80,7.37,7.83,8.22,8.72,
 9.00,9.45,9.84,10.82,11.61,12.64,13.66,14.70,16.52,18.31,
 20.18,21.70,22.86,24.51,25.69,30.23,34.41,40.00,48.11,56.00,
 75.00,96.29};
static float alpha01_nx064_nz19_fwhm200[32] = {
 7.74,8.30,8.77,9.43,9.95,10.63,11.70,12.45,13.03,13.78,
 14.40,15.03,15.56,16.86,18.39,19.84,21.82,23.47,26.50,29.48,
 32.16,35.00,37.50,40.23,42.62,50.19,56.62,68.33,80.70,95.00,
 129.60,166.83};
static float alpha01_nx064_nz19_fwhm225[32] = {
 11.31,12.18,12.87,13.85,14.60,15.52,16.90,18.26,19.19,20.27,
 21.24,22.03,22.90,25.16,26.94,29.40,31.76,34.44,39.17,43.87,
 47.74,51.88,55.62,59.64,62.92,74.36,85.75,99.90,120.20,142.45,
 191.33,253.75};
static float alpha01_nx064_nz19_fwhm250[32] = {
 15.00,16.32,17.35,18.50,19.79,20.61,22.95,24.65,25.93,27.50,
 28.69,29.81,30.74,33.78,36.81,40.26,43.90,47.31,53.40,59.47,
 64.85,70.30,74.90,80.62,85.75,100.57,116.55,136.17,161.83,193.90,
 265.67,356.20};
static float alpha01_nx064_nz19_fwhm275[32] = {
 19.35,20.71,22.05,23.45,25.28,26.68,29.42,31.33,33.35,35.22,
 37.08,38.52,40.06,43.73,46.95,51.40,55.86,60.20,68.55,76.50,
 83.88,90.92,99.00,105.33,112.00,131.89,150.83,177.00,213.00,254.33,
 345.67,443.00};
static float alpha01_nx064_nz19_fwhm300[32] = {
 24.00,25.89,27.43,29.29,31.57,33.38,36.50,39.54,41.50,43.77,
 45.68,47.39,49.36,54.09,58.36,63.76,70.40,76.64,87.50,97.15,
 105.43,115.27,124.57,132.00,139.78,163.25,186.50,221.00,269.00,317.25,
 419.20,542.50};
static float alpha01_nx064_nz19_fwhm325[32] = {
 28.46,30.68,32.75,35.17,38.07,40.33,43.72,46.50,50.00,52.71,
 54.76,57.00,59.80,65.90,71.36,78.33,85.60,92.88,105.11,116.89,
 128.17,138.40,147.88,158.43,167.20,197.75,228.75,269.60,322.00,380.33,
 500.00,654.50};
static float alpha01_nx064_nz19_fwhm350[32] = {
 33.50,36.15,38.00,41.11,44.33,46.73,51.40,55.18,58.91,62.10,
 64.93,67.62,70.57,77.50,84.69,93.17,102.00,109.75,125.00,137.33,
 150.60,162.00,175.25,187.50,200.60,239.00,273.00,319.67,388.67,446.00,
 584.00,764.50};
static float alpha01_nx064_nz19_fwhm375[32] = {
 38.29,41.50,44.17,47.50,51.18,53.76,59.55,64.50,68.59,72.14,
 75.71,79.64,83.00,91.50,98.89,108.12,118.67,127.88,144.17,158.83,
 175.50,189.00,206.17,220.75,233.50,277.67,316.25,371.00,447.00,515.25,
 672.00,875.50};
static float alpha01_nx064_nz19_fwhm400[32] = {
 43.53,47.58,50.91,54.14,58.62,62.30,69.00,73.43,79.17,84.00,
 88.12,91.75,94.75,106.33,114.50,124.17,134.67,145.17,165.25,182.00,
 200.20,220.50,237.50,253.50,269.67,314.50,361.00,421.00,505.00,583.33,
 771.33,988.00};
static float alpha01_nx064_nz19_fwhm425[32] = {
 48.89,53.33,57.25,62.25,66.09,70.33,77.78,83.00,89.00,95.44,
 100.20,104.00,108.50,118.50,127.56,139.00,151.50,164.17,187.67,211.00,
 230.00,248.50,269.12,288.00,306.00,356.50,410.67,480.00,563.00,655.50,
 866.00,1111.00};
static float alpha01_nx064_nz19_fwhm450[32] = {
 54.78,59.67,63.60,68.00,73.00,77.56,87.14,95.17,101.11,106.25,
 110.60,116.30,119.83,131.60,142.33,155.33,172.75,186.50,214.00,237.25,
 258.00,282.00,299.83,321.00,337.67,401.50,458.00,532.00,622.50,739.33,
 965.00,1225.00};
static float alpha01_nx064_nz19_fwhm475[32] = {
 60.25,65.88,69.78,74.80,81.00,86.83,98.20,105.33,111.67,117.00,
 122.12,126.80,132.38,147.25,160.40,174.83,194.00,209.00,237.00,261.00,
 288.00,312.00,333.67,360.00,383.00,446.00,509.00,591.00,702.00,816.00,
 1068.00,1342.50};
static float alpha01_nx064_nz19_fwhm500[32] = {
 65.60,71.71,76.73,83.00,91.80,97.20,105.78,113.57,121.43,128.75,
 134.70,140.80,147.00,164.00,176.80,194.67,214.67,230.00,262.00,289.25,
 318.25,345.50,376.33,397.50,422.00,490.00,563.00,652.00,774.00,885.50,
 1174.33,1455.50};
static float *alpha01_nx064_nz19[21] = {
 alpha01_nx064_nz19_fwhm000, alpha01_nx064_nz19_fwhm025, alpha01_nx064_nz19_fwhm050, 
 alpha01_nx064_nz19_fwhm075, alpha01_nx064_nz19_fwhm100, alpha01_nx064_nz19_fwhm125, 
 alpha01_nx064_nz19_fwhm150, alpha01_nx064_nz19_fwhm175, alpha01_nx064_nz19_fwhm200, 
 alpha01_nx064_nz19_fwhm225, alpha01_nx064_nz19_fwhm250, alpha01_nx064_nz19_fwhm275, 
 alpha01_nx064_nz19_fwhm300, alpha01_nx064_nz19_fwhm325, alpha01_nx064_nz19_fwhm350, 
 alpha01_nx064_nz19_fwhm375, alpha01_nx064_nz19_fwhm400, alpha01_nx064_nz19_fwhm425, 
 alpha01_nx064_nz19_fwhm450, alpha01_nx064_nz19_fwhm475, alpha01_nx064_nz19_fwhm500} ;

static float alpha05_nx064_nz19_fwhm000[32] = {
 1.95,1.95,1.95,1.95,1.96,1.96,1.98,1.99,2.18,2.39,
 2.53,2.62,2.69,2.81,2.87,2.91,2.94,2.96,3.00,3.48,
 3.70,3.82,3.89,3.94,3.98,4.61,4.87,5.30,5.88,6.51,
 7.64,8.78};
static float alpha05_nx064_nz19_fwhm025[32] = {
 1.95,1.95,1.95,1.95,1.96,1.96,1.98,1.99,2.18,2.39,
 2.53,2.62,2.69,2.81,2.87,2.91,2.94,2.96,3.00,3.48,
 3.70,3.82,3.89,3.94,3.98,4.61,4.87,5.30,5.88,6.51,
 7.64,8.78};
static float alpha05_nx064_nz19_fwhm050[32] = {
 1.95,1.95,1.95,1.96,1.96,1.97,1.98,2.00,2.27,2.47,
 2.58,2.66,2.72,2.83,2.88,2.92,2.95,2.97,3.14,3.56,
 3.75,3.86,3.92,3.97,4.05,4.70,4.91,5.46,5.95,6.66,
 7.80,8.95};
static float alpha05_nx064_nz19_fwhm075[32] = {
 1.95,1.95,1.96,1.96,1.97,1.98,2.08,2.39,2.56,2.67,
 2.73,2.78,2.82,2.89,2.92,2.95,2.98,3.11,3.60,3.80,
 3.90,3.96,4.13,4.44,4.65,4.93,5.46,5.93,6.71,7.34,
 8.74,10.15};
static float alpha05_nx064_nz19_fwhm100[32] = {
 1.96,1.97,1.98,1.99,2.21,2.42,2.64,2.75,2.82,2.86,
 2.89,2.91,2.93,2.97,3.00,3.41,3.67,3.81,3.95,4.29,
 4.63,4.82,4.93,5.09,5.44,5.95,6.68,7.41,8.35,9.29,
 11.32,13.53};
static float alpha05_nx064_nz19_fwhm125[32] = {
 2.05,2.38,2.55,2.69,2.79,2.85,2.92,2.96,2.99,3.15,
 3.36,3.53,3.64,3.82,3.94,4.19,4.58,4.81,5.14,5.71,
 5.97,6.47,6.82,7.07,7.54,8.60,9.53,10.77,12.48,14.04,
 17.70,21.71};
static float alpha05_nx064_nz19_fwhm150[32] = {
 2.83,2.91,2.95,3.00,3.38,3.59,3.83,3.95,4.16,4.47,
 4.66,4.79,4.89,5.32,5.74,6.13,6.71,7.07,7.93,8.74,
 9.51,10.13,10.90,11.61,12.22,14.08,15.95,18.56,21.68,24.86,
 31.95,40.76};
static float alpha05_nx064_nz19_fwhm175[32] = {
 3.81,4.02,4.36,4.64,4.88,5.09,5.69,6.00,6.49,6.79,
 7.04,7.44,7.69,8.45,9.00,9.88,10.85,11.72,13.28,14.75,
 16.02,17.37,18.53,19.73,20.87,24.30,27.91,32.52,38.62,45.46,
 59.81,77.81};
static float alpha05_nx064_nz19_fwhm200[32] = {
 5.61,5.98,6.52,6.92,7.50,7.96,8.78,9.42,9.98,10.61,
 11.04,11.57,12.03,13.31,14.39,15.70,17.17,18.58,21.07,23.34,
 25.55,27.73,30.02,32.00,34.19,40.38,46.22,54.29,64.37,76.05,
 102.26,134.67};
static float alpha05_nx064_nz19_fwhm225[32] = {
 7.97,8.73,9.33,9.99,10.75,11.47,12.64,13.55,14.36,15.19,
 15.95,16.72,17.36,19.23,20.80,22.88,25.06,27.29,31.16,35.01,
 37.98,41.15,44.20,47.21,50.02,58.72,67.39,79.86,95.97,113.26,
 152.96,200.27};
static float alpha05_nx064_nz19_fwhm250[32] = {
 10.62,11.59,12.31,13.28,14.29,15.15,16.77,18.12,19.29,20.43,
 21.43,22.54,23.54,25.91,28.23,30.96,33.97,36.83,42.12,46.76,
 51.03,55.38,59.53,63.60,67.65,79.27,91.30,107.89,130.23,154.73,
 209.45,273.70};
static float alpha05_nx064_nz19_fwhm275[32] = {
 13.37,14.56,15.58,16.69,18.05,19.37,21.41,23.22,24.73,26.34,
 27.67,28.89,30.05,33.32,36.07,39.68,43.55,47.33,53.76,59.69,
 65.19,70.34,75.93,81.32,86.45,102.32,118.06,138.87,166.90,198.00,
 267.00,350.29};
static float alpha05_nx064_nz19_fwhm300[32] = {
 16.16,17.71,18.92,20.46,22.05,23.67,26.10,28.37,30.40,32.09,
 33.65,35.35,36.72,40.82,44.35,48.76,53.49,58.10,66.03,73.28,
 80.58,87.23,94.38,100.62,106.59,125.88,146.39,173.00,207.11,243.10,
 327.75,425.00};
static float alpha05_nx064_nz19_fwhm325[32] = {
 18.92,20.70,22.14,24.07,26.14,27.88,30.98,33.55,36.02,38.22,
 40.12,41.94,44.00,48.78,52.96,58.24,63.81,69.00,79.03,87.89,
 96.85,104.83,112.96,120.95,128.65,153.13,175.40,206.55,246.85,288.77,
 385.25,498.75};
static float alpha05_nx064_nz19_fwhm350[32] = {
 21.71,23.81,25.61,27.78,30.00,32.27,36.22,39.32,42.36,44.77,
 47.03,49.29,51.21,56.63,61.86,67.77,74.38,81.14,92.61,103.36,
 113.65,123.18,133.73,143.60,152.29,179.89,206.33,243.22,288.11,336.40,
 448.33,579.22};
static float alpha05_nx064_nz19_fwhm375[32] = {
 24.70,27.12,29.14,32.00,34.92,37.39,41.57,45.02,48.17,51.28,
 53.73,56.46,58.63,65.25,70.92,77.69,86.39,93.80,107.53,120.44,
 131.13,143.53,155.35,165.89,177.88,209.32,239.79,280.25,328.83,389.11,
 516.75,658.00};
static float alpha05_nx064_nz19_fwhm400[32] = {
 27.64,30.65,33.09,36.11,39.30,41.76,46.72,50.86,54.46,57.79,
 61.11,63.95,66.65,74.00,81.00,89.00,98.94,107.38,122.88,138.00,
 152.25,165.20,178.00,190.56,203.06,238.00,271.50,317.25,375.71,443.57,
 579.62,748.00};
static float alpha05_nx064_nz19_fwhm425[32] = {
 30.38,33.91,36.60,40.14,43.41,46.62,52.07,56.81,61.07,64.18,
 68.32,71.39,74.48,82.65,90.88,100.75,111.68,120.67,139.57,155.69,
 171.18,186.00,200.00,213.54,226.71,266.36,304.80,357.45,424.50,495.38,
 655.67,828.50};
static float alpha05_nx064_nz19_fwhm450[32] = {
 33.40,37.15,40.25,43.96,47.90,51.38,57.36,62.62,67.12,71.27,
 75.44,79.00,82.55,92.89,102.08,112.28,124.07,136.06,156.07,173.31,
 190.33,206.33,220.67,237.75,252.62,295.85,340.00,398.17,470.80,548.00,
 723.00,920.50};
static float alpha05_nx064_nz19_fwhm475[32] = {
 36.21,40.07,43.67,47.47,52.00,56.04,62.94,67.89,73.79,78.69,
 82.87,87.18,91.47,103.05,112.30,124.00,137.50,149.07,170.36,190.42,
 208.92,227.62,245.91,261.92,278.40,326.80,376.60,438.38,522.57,607.50,
 795.00,1008.80};
static float alpha05_nx064_nz19_fwhm500[32] = {
 38.19,42.71,46.17,51.36,56.32,60.60,68.10,74.08,79.94,85.38,
 90.41,95.75,100.50,112.24,123.50,136.00,150.50,163.00,187.33,208.10,
 229.77,248.82,269.50,287.56,306.25,360.00,414.00,486.50,572.20,669.25,
 869.50,1095.17};
static float *alpha05_nx064_nz19[21] = {
 alpha05_nx064_nz19_fwhm000, alpha05_nx064_nz19_fwhm025, alpha05_nx064_nz19_fwhm050, 
 alpha05_nx064_nz19_fwhm075, alpha05_nx064_nz19_fwhm100, alpha05_nx064_nz19_fwhm125, 
 alpha05_nx064_nz19_fwhm150, alpha05_nx064_nz19_fwhm175, alpha05_nx064_nz19_fwhm200, 
 alpha05_nx064_nz19_fwhm225, alpha05_nx064_nz19_fwhm250, alpha05_nx064_nz19_fwhm275, 
 alpha05_nx064_nz19_fwhm300, alpha05_nx064_nz19_fwhm325, alpha05_nx064_nz19_fwhm350, 
 alpha05_nx064_nz19_fwhm375, alpha05_nx064_nz19_fwhm400, alpha05_nx064_nz19_fwhm425, 
 alpha05_nx064_nz19_fwhm450, alpha05_nx064_nz19_fwhm475, alpha05_nx064_nz19_fwhm500} ;

static float alpha10_nx064_nz19_fwhm000[32] = {
 1.90,1.90,1.90,1.90,1.91,1.91,1.92,1.94,1.96,1.98,
 2.06,2.24,2.38,2.60,2.73,2.81,2.86,2.89,2.94,2.99,
 3.36,3.59,3.73,3.82,3.88,4.12,4.63,4.92,5.55,5.95,
 6.98,8.14};
static float alpha10_nx064_nz19_fwhm025[32] = {
 1.90,1.90,1.90,1.90,1.91,1.91,1.92,1.94,1.96,1.98,
 2.06,2.24,2.38,2.60,2.73,2.81,2.86,2.89,2.94,2.99,
 3.36,3.59,3.73,3.82,3.88,4.12,4.63,4.92,5.55,5.95,
 6.98,8.14};
static float alpha10_nx064_nz19_fwhm050[32] = {
 1.90,1.90,1.90,1.91,1.91,1.92,1.93,1.95,1.97,1.99,
 2.15,2.33,2.43,2.64,2.75,2.82,2.87,2.90,2.95,3.09,
 3.45,3.66,3.77,3.85,3.91,4.30,4.71,4.96,5.68,6.05,
 7.22,8.43};
static float alpha10_nx064_nz19_fwhm075[32] = {
 1.90,1.90,1.91,1.91,1.92,1.93,1.95,1.98,2.11,2.33,
 2.46,2.56,2.64,2.76,2.83,2.88,2.91,2.95,3.16,3.54,
 3.74,3.84,3.92,3.97,4.20,4.73,4.96,5.62,6.14,6.83,
 8.00,9.50};
static float alpha10_nx064_nz19_fwhm100[32] = {
 1.91,1.92,1.93,1.94,1.96,1.99,2.27,2.49,2.63,2.70,
 2.76,2.80,2.83,2.89,2.93,2.98,3.29,3.56,3.81,3.94,
 4.16,4.51,4.71,4.85,4.95,5.65,6.03,6.83,7.73,8.64,
 10.47,12.51};
static float alpha10_nx064_nz19_fwhm125[32] = {
 1.95,1.98,2.10,2.36,2.55,2.66,2.78,2.86,2.90,2.94,
 2.97,3.00,3.20,3.55,3.74,3.89,4.01,4.43,4.82,5.13,
 5.62,5.88,6.22,6.61,6.87,7.86,8.75,9.87,11.38,12.90,
 16.20,19.85};
static float alpha10_nx064_nz19_fwhm150[32] = {
 2.58,2.72,2.81,2.88,2.95,3.02,3.47,3.69,3.83,3.94,
 4.07,4.31,4.48,4.81,5.09,5.61,5.98,6.49,7.20,7.88,
 8.62,9.21,9.86,10.51,11.06,12.82,14.54,16.80,19.65,22.62,
 28.98,36.80};
static float alpha10_nx064_nz19_fwhm175[32] = {
 3.24,3.58,3.79,3.96,4.33,4.59,4.93,5.36,5.71,5.95,
 6.30,6.58,6.78,7.50,7.98,8.81,9.67,10.48,11.87,13.13,
 14.42,15.60,16.71,17.76,18.87,21.98,25.22,29.26,34.89,40.85,
 53.90,69.68};
static float alpha10_nx064_nz19_fwhm200[32] = {
 4.74,5.05,5.51,5.93,6.39,6.81,7.61,8.15,8.72,9.14,
 9.62,10.00,10.52,11.61,12.59,13.83,15.19,16.34,18.63,20.75,
 22.77,24.83,26.63,28.51,30.32,35.82,41.08,48.41,57.78,67.60,
 91.13,118.76};
static float alpha10_nx064_nz19_fwhm225[32] = {
 6.64,7.26,7.86,8.46,9.00,9.67,10.70,11.62,12.41,13.15,
 13.82,14.47,15.06,16.72,18.09,19.76,21.76,23.78,27.16,30.48,
 33.50,36.39,39.27,42.01,44.64,52.43,60.17,70.52,84.56,100.44,
 135.09,177.08};
static float alpha10_nx064_nz19_fwhm250[32] = {
 8.67,9.54,10.21,11.07,12.06,12.85,14.22,15.46,16.51,17.51,
 18.45,19.23,20.10,22.34,24.44,26.90,29.64,32.26,36.99,41.25,
 45.22,49.18,52.97,56.37,59.85,70.36,80.88,95.53,114.76,136.32,
 182.45,239.72};
static float alpha10_nx064_nz19_fwhm275[32] = {
 10.86,11.92,12.82,13.83,15.08,16.15,17.92,19.39,20.85,22.19,
 23.28,24.43,25.56,28.44,31.01,34.34,37.79,41.03,46.82,52.16,
 57.35,62.09,67.15,71.65,76.12,89.57,103.38,122.16,146.57,173.31,
 232.48,303.05};
static float alpha10_nx064_nz19_fwhm300[32] = {
 12.83,14.23,15.42,16.86,18.34,19.58,21.70,23.68,25.44,27.06,
 28.49,29.93,31.30,34.83,37.88,41.66,45.85,49.93,57.38,63.82,
 69.89,75.98,81.81,87.68,93.32,110.26,126.80,149.36,180.50,210.67,
 279.75,366.15};
static float alpha10_nx064_nz19_fwhm325[32] = {
 15.11,16.72,18.11,19.74,21.43,22.97,25.71,27.92,30.07,32.01,
 33.76,35.52,37.07,41.08,44.91,49.58,54.63,59.10,67.90,75.76,
 83.41,91.10,98.20,105.41,112.17,132.41,152.90,180.12,213.90,250.36,
 331.00,431.67};
static float alpha10_nx064_nz19_fwhm350[32] = {
 17.15,19.10,20.69,22.55,24.57,26.38,29.50,32.35,34.94,37.08,
 39.11,41.21,43.03,47.78,52.24,57.32,63.10,69.03,79.08,88.69,
 97.98,106.89,115.22,123.49,131.87,155.44,179.05,210.10,249.59,290.41,
 387.18,500.00};
static float alpha10_nx064_nz19_fwhm375[32] = {
 19.08,21.22,23.07,25.37,27.75,29.74,33.33,36.42,39.28,42.08,
 44.52,46.58,48.75,54.20,59.05,65.10,72.57,79.40,91.28,102.63,
 112.91,123.15,133.06,141.94,151.29,178.57,206.00,239.62,284.00,333.94,
 441.75,565.00};
static float alpha10_nx064_nz19_fwhm400[32] = {
 20.80,23.31,25.52,27.87,30.74,33.08,37.08,40.86,44.04,46.88,
 49.58,52.07,54.34,60.96,66.71,74.19,82.20,89.81,103.86,116.23,
 128.44,139.28,150.55,161.07,171.41,203.22,231.24,271.50,323.75,379.36,
 500.46,637.38};
static float alpha10_nx064_nz19_fwhm425[32] = {
 22.53,25.42,27.71,30.53,33.62,36.33,41.10,45.09,48.77,51.98,
 55.11,57.79,60.31,68.19,74.73,82.53,92.05,100.90,116.44,130.62,
 143.24,155.45,167.64,179.68,191.58,225.33,260.06,305.25,364.67,426.33,
 558.00,713.29};
static float alpha10_nx064_nz19_fwhm450[32] = {
 24.05,27.24,29.93,33.10,36.60,39.63,44.63,49.14,53.34,56.98,
 60.25,63.47,66.62,74.64,82.39,92.15,102.13,111.45,129.09,143.84,
 158.27,172.46,185.94,199.41,211.72,251.93,290.08,339.75,402.86,471.27,
 613.58,781.20};
static float alpha10_nx064_nz19_fwhm475[32] = {
 25.70,28.82,31.83,35.26,39.24,42.43,48.27,53.21,57.78,62.08,
 65.78,69.17,72.47,82.11,90.94,100.43,111.95,122.00,140.90,157.67,
 174.77,190.10,205.83,220.87,235.00,278.53,318.00,374.45,445.00,518.09,
 677.17,854.20};
static float alpha10_nx064_nz19_fwhm500[32] = {
 26.81,30.82,34.12,37.60,41.68,45.09,51.92,57.53,62.67,67.15,
 71.24,75.20,79.21,89.08,98.50,109.50,121.67,132.24,153.81,173.20,
 192.28,208.57,225.94,243.00,258.58,303.50,347.60,409.00,485.33,568.71,
 734.00,928.00};
static float *alpha10_nx064_nz19[21] = {
 alpha10_nx064_nz19_fwhm000, alpha10_nx064_nz19_fwhm025, alpha10_nx064_nz19_fwhm050, 
 alpha10_nx064_nz19_fwhm075, alpha10_nx064_nz19_fwhm100, alpha10_nx064_nz19_fwhm125, 
 alpha10_nx064_nz19_fwhm150, alpha10_nx064_nz19_fwhm175, alpha10_nx064_nz19_fwhm200, 
 alpha10_nx064_nz19_fwhm225, alpha10_nx064_nz19_fwhm250, alpha10_nx064_nz19_fwhm275, 
 alpha10_nx064_nz19_fwhm300, alpha10_nx064_nz19_fwhm325, alpha10_nx064_nz19_fwhm350, 
 alpha10_nx064_nz19_fwhm375, alpha10_nx064_nz19_fwhm400, alpha10_nx064_nz19_fwhm425, 
 alpha10_nx064_nz19_fwhm450, alpha10_nx064_nz19_fwhm475, alpha10_nx064_nz19_fwhm500} ;

static float **nx064_nz19[3] = {
  alpha01_nx064_nz19 , alpha05_nx064_nz19 , alpha10_nx064_nz19 };

static float alpha01_nx064_nz20_fwhm000[32] = {
 1.99,1.99,1.99,2.00,2.11,2.37,2.67,2.80,2.86,2.90,
 2.92,2.93,2.95,2.97,2.98,2.99,3.18,3.55,3.82,3.93,
 3.97,4.00,4.44,4.67,4.81,4.99,5.69,6.04,6.82,7.53,
 8.80,10.16};
static float alpha01_nx064_nz20_fwhm025[32] = {
 1.99,1.99,1.99,2.00,2.11,2.37,2.67,2.80,2.86,2.90,
 2.92,2.93,2.95,2.97,2.98,2.99,3.18,3.55,3.82,3.93,
 3.97,4.00,4.44,4.67,4.81,4.99,5.69,6.04,6.82,7.53,
 8.80,10.16};
static float alpha01_nx064_nz20_fwhm050[32] = {
 1.99,1.99,2.00,2.00,2.23,2.45,2.72,2.82,2.87,2.91,
 2.93,2.94,2.95,2.97,2.99,3.00,3.31,3.62,3.85,3.94,
 3.98,4.20,4.56,4.75,4.86,5.24,5.79,6.26,6.93,7.68,
 8.97,10.52};
static float alpha01_nx064_nz20_fwhm075[32] = {
 1.99,2.00,2.04,2.39,2.58,2.71,2.84,2.89,2.93,2.95,
 2.96,2.97,2.98,2.99,3.00,3.46,3.71,3.83,3.95,4.00,
 4.53,4.77,4.90,4.97,5.18,5.84,6.27,6.93,7.78,8.57,
 10.09,11.94};
static float alpha01_nx064_nz20_fwhm100[32] = {
 2.28,2.55,2.69,2.78,2.86,2.90,2.94,2.97,2.98,2.99,
 3.00,3.18,3.36,3.67,3.81,3.92,3.98,4.18,4.76,4.95,
 5.36,5.71,5.88,6.11,6.51,7.00,7.84,8.76,9.81,10.91,
 13.45,15.97};
static float alpha01_nx064_nz20_fwhm125[32] = {
 2.84,2.90,2.94,2.96,2.98,3.00,3.55,3.73,3.83,3.90,
 3.93,3.97,4.00,4.60,4.83,4.98,5.43,5.79,6.41,6.87,
 7.36,7.83,8.13,8.65,8.94,10.17,11.41,12.85,14.85,16.87,
 21.27,25.84};
static float alpha01_nx064_nz20_fwhm150[32] = {
 3.53,3.76,3.86,3.94,4.18,4.41,4.82,4.99,5.27,5.61,
 5.82,5.96,6.18,6.68,7.08,7.74,8.28,8.88,9.93,10.79,
 11.68,12.59,13.45,14.07,14.90,17.30,19.34,22.42,26.14,30.58,
 39.31,49.94};
static float alpha01_nx064_nz20_fwhm175[32] = {
 4.99,5.55,5.83,6.16,6.53,6.84,7.55,7.96,8.52,8.87,
 9.33,9.66,9.87,10.77,11.67,12.60,13.80,14.75,16.89,18.71,
 20.47,22.11,23.65,24.90,26.24,30.29,33.94,39.94,47.86,57.36,
 76.84,101.25};
static float alpha01_nx064_nz20_fwhm200[32] = {
 7.82,8.41,8.88,9.54,10.11,10.64,11.67,12.60,13.30,14.03,
 14.75,15.19,15.93,17.35,18.86,20.39,22.27,23.86,26.74,29.80,
 32.47,35.00,37.58,39.83,42.38,50.60,59.14,69.67,82.56,97.80,
 132.67,175.00};
static float alpha01_nx064_nz20_fwhm225[32] = {
 11.19,12.02,12.83,13.83,14.69,15.65,17.12,18.45,19.53,20.42,
 21.39,22.00,23.11,25.38,27.33,29.86,32.39,34.83,39.79,43.83,
 48.60,52.68,56.78,60.56,64.56,75.18,87.57,102.71,122.75,146.75,
 196.83,266.50};
static float alpha01_nx064_nz20_fwhm250[32] = {
 15.38,16.63,17.44,18.83,20.13,21.32,23.65,24.88,26.42,27.84,
 28.83,30.00,31.24,34.19,37.27,40.59,44.33,48.07,54.67,60.09,
 65.90,71.69,76.89,82.50,87.36,102.75,118.90,140.75,170.00,197.25,
 268.33,356.67};
static float alpha01_nx064_nz20_fwhm275[32] = {
 19.75,21.25,22.54,24.25,25.88,27.43,29.62,31.80,33.83,35.75,
 37.73,39.56,41.23,44.74,48.00,51.81,57.00,61.40,70.31,78.47,
 85.43,92.00,99.70,106.00,112.33,132.57,151.75,181.00,215.33,260.00,
 346.00,454.33};
static float alpha01_nx064_nz20_fwhm300[32] = {
 24.20,26.36,28.06,29.89,31.58,33.63,37.35,39.71,42.69,45.06,
 46.82,48.86,49.83,55.38,59.44,65.45,72.20,78.60,88.00,97.45,
 106.11,114.67,122.50,130.75,139.50,167.11,190.00,223.75,269.00,317.00,
 427.00,553.33};
static float alpha01_nx064_nz20_fwhm325[32] = {
 29.53,31.50,34.06,36.43,38.50,40.73,44.21,48.17,50.81,53.64,
 55.93,58.75,61.33,67.33,72.62,79.00,87.00,93.08,105.00,117.00,
 128.25,138.83,149.75,161.33,169.20,200.25,229.00,269.80,322.75,374.00,
 511.00,659.50};
static float alpha01_nx064_nz20_fwhm350[32] = {
 34.75,37.38,39.67,42.25,45.08,47.78,52.50,56.83,60.00,63.30,
 66.54,69.43,72.33,79.25,85.67,93.64,102.64,110.33,124.83,138.50,
 150.78,163.33,176.50,189.00,200.60,238.00,273.67,318.00,377.50,444.75,
 589.00,763.50};
static float alpha01_nx064_nz20_fwhm375[32] = {
 39.11,42.50,44.86,48.55,51.70,55.07,60.44,64.57,69.38,73.00,
 76.80,80.38,83.29,92.33,99.83,108.70,119.20,128.00,144.83,159.50,
 175.60,192.00,208.17,222.50,237.86,279.25,318.33,365.00,438.75,508.50,
 683.50,888.00};
static float alpha01_nx064_nz20_fwhm400[32] = {
 44.18,48.17,51.17,54.46,58.78,62.45,68.67,74.29,78.90,83.50,
 87.43,91.40,94.75,106.40,113.33,124.00,135.67,146.20,164.33,184.75,
 202.50,223.33,239.50,255.25,271.60,319.00,361.00,422.00,496.50,591.00,
 780.25,984.50};
static float alpha01_nx064_nz20_fwhm425[32] = {
 49.00,53.91,57.18,61.44,66.12,70.11,76.57,82.62,89.00,95.00,
 99.43,104.50,108.33,119.00,128.20,139.00,151.50,164.00,187.67,211.00,
 235.17,255.67,273.75,291.00,310.40,353.00,409.00,475.00,569.00,668.00,
 880.50,1102.00};
static float alpha01_nx064_nz20_fwhm450[32] = {
 54.12,59.18,62.75,67.86,72.88,76.80,85.90,93.50,100.00,106.30,
 111.27,115.86,120.50,132.50,142.80,155.40,171.67,185.20,215.25,242.33,
 264.67,283.80,302.50,321.33,340.33,400.00,457.33,535.00,643.50,740.50,
 982.50,1226.00};
static float alpha01_nx064_nz20_fwhm475[32] = {
 59.50,64.60,69.60,75.25,81.50,86.33,96.00,102.90,111.09,116.50,
 122.25,128.20,133.44,147.80,159.33,174.67,192.40,209.50,240.00,267.00,
 290.00,311.75,335.00,357.25,379.25,444.00,509.50,597.00,708.00,816.67,
 1067.00,1346.50};
static float alpha01_nx064_nz20_fwhm500[32] = {
 65.33,71.83,78.00,83.00,90.50,95.58,105.80,113.40,122.00,129.50,
 136.25,142.00,148.29,162.88,176.80,194.00,213.50,232.75,264.00,292.80,
 321.00,343.33,366.00,395.50,419.50,489.00,562.00,666.00,778.00,898.50,
 1156.00,1473.50};
static float *alpha01_nx064_nz20[21] = {
 alpha01_nx064_nz20_fwhm000, alpha01_nx064_nz20_fwhm025, alpha01_nx064_nz20_fwhm050, 
 alpha01_nx064_nz20_fwhm075, alpha01_nx064_nz20_fwhm100, alpha01_nx064_nz20_fwhm125, 
 alpha01_nx064_nz20_fwhm150, alpha01_nx064_nz20_fwhm175, alpha01_nx064_nz20_fwhm200, 
 alpha01_nx064_nz20_fwhm225, alpha01_nx064_nz20_fwhm250, alpha01_nx064_nz20_fwhm275, 
 alpha01_nx064_nz20_fwhm300, alpha01_nx064_nz20_fwhm325, alpha01_nx064_nz20_fwhm350, 
 alpha01_nx064_nz20_fwhm375, alpha01_nx064_nz20_fwhm400, alpha01_nx064_nz20_fwhm425, 
 alpha01_nx064_nz20_fwhm450, alpha01_nx064_nz20_fwhm475, alpha01_nx064_nz20_fwhm500} ;

static float alpha05_nx064_nz20_fwhm000[32] = {
 1.95,1.95,1.95,1.96,1.96,1.97,1.98,2.00,2.28,2.45,
 2.56,2.64,2.71,2.82,2.87,2.91,2.94,2.96,3.03,3.52,
 3.73,3.83,3.90,3.95,3.99,4.64,4.90,5.40,5.89,6.52,
 7.67,8.84};
static float alpha05_nx064_nz20_fwhm025[32] = {
 1.95,1.95,1.95,1.96,1.96,1.97,1.98,2.00,2.28,2.45,
 2.56,2.64,2.71,2.82,2.87,2.91,2.94,2.96,3.03,3.52,
 3.73,3.83,3.90,3.95,3.99,4.64,4.90,5.40,5.89,6.52,
 7.67,8.84};
static float alpha05_nx064_nz20_fwhm050[32] = {
 1.95,1.95,1.95,1.96,1.96,1.97,1.98,2.10,2.35,2.51,
 2.61,2.68,2.74,2.83,2.89,2.92,2.95,2.97,3.19,3.59,
 3.77,3.86,3.92,3.97,4.08,4.73,4.94,5.54,5.96,6.67,
 7.83,8.98};
static float alpha05_nx064_nz20_fwhm075[32] = {
 1.95,1.96,1.96,1.97,1.97,1.98,2.16,2.44,2.60,2.69,
 2.75,2.80,2.83,2.89,2.93,2.95,2.98,3.10,3.62,3.81,
 3.91,3.97,4.19,4.50,4.68,4.95,5.52,5.93,6.71,7.40,
 8.77,10.31};
static float alpha05_nx064_nz20_fwhm100[32] = {
 1.96,1.97,1.98,1.99,2.25,2.45,2.67,2.78,2.83,2.87,
 2.90,2.92,2.93,2.97,3.00,3.42,3.69,3.82,3.96,4.33,
 4.68,4.86,4.96,5.25,5.55,5.98,6.74,7.48,8.39,9.34,
 11.40,13.61};
static float alpha05_nx064_nz20_fwhm125[32] = {
 2.13,2.44,2.59,2.71,2.80,2.86,2.93,2.97,2.99,3.22,
 3.41,3.56,3.67,3.85,3.95,4.28,4.63,4.83,5.30,5.77,
 6.10,6.57,6.88,7.20,7.63,8.57,9.52,10.82,12.46,14.22,
 17.82,21.74};
static float alpha05_nx064_nz20_fwhm150[32] = {
 2.85,2.93,2.98,3.20,3.48,3.66,3.86,3.98,4.29,4.56,
 4.73,4.85,4.94,5.41,5.79,6.16,6.76,7.14,7.97,8.85,
 9.60,10.32,10.94,11.61,12.21,14.10,15.95,18.43,21.60,24.97,
 32.76,41.21};
static float alpha05_nx064_nz20_fwhm175[32] = {
 3.85,4.08,4.44,4.72,4.94,5.26,5.76,6.10,6.63,6.92,
 7.26,7.57,7.83,8.62,9.37,10.11,10.97,11.82,13.35,14.73,
 16.18,17.44,18.71,19.93,21.16,24.78,28.29,33.16,39.85,46.90,
 61.89,79.37};
static float alpha05_nx064_nz20_fwhm200[32] = {
 5.78,6.22,6.67,7.08,7.66,8.02,8.83,9.51,10.09,10.70,
 11.22,11.69,12.04,13.32,14.42,15.81,17.39,18.75,21.42,23.81,
 26.06,28.23,30.40,32.52,34.65,40.96,47.29,55.48,65.88,77.59,
 104.44,136.78};
static float alpha05_nx064_nz20_fwhm225[32] = {
 8.11,8.76,9.38,9.99,10.79,11.41,12.63,13.66,14.57,15.41,
 16.13,16.86,17.61,19.44,21.07,23.03,25.48,27.73,31.68,35.17,
 38.67,41.90,45.13,48.05,50.92,59.96,68.87,80.88,98.09,115.79,
 155.48,204.33};
static float alpha05_nx064_nz20_fwhm250[32] = {
 10.62,11.61,12.41,13.38,14.41,15.43,17.02,18.37,19.69,20.92,
 21.97,22.90,23.98,26.33,28.69,31.54,34.59,37.31,42.58,47.04,
 51.67,56.14,60.50,64.92,69.21,81.35,93.87,110.65,132.86,156.14,
 210.25,274.90};
static float alpha05_nx064_nz20_fwhm275[32] = {
 13.37,14.63,15.70,17.01,18.56,19.70,21.80,23.61,25.22,26.62,
 27.88,29.12,30.45,33.61,36.52,39.96,43.73,47.27,54.53,60.83,
 66.81,72.20,77.77,83.44,89.21,103.92,119.33,141.11,169.63,198.68,
 263.94,349.75};
static float alpha05_nx064_nz20_fwhm300[32] = {
 16.31,17.85,19.12,20.79,22.56,24.08,26.51,28.70,30.61,32.59,
 34.20,35.75,37.38,41.11,44.79,48.98,54.27,59.22,67.06,74.69,
 82.48,89.22,95.88,102.39,108.41,127.10,147.57,174.80,207.82,243.67,
 328.75,427.60};
static float alpha05_nx064_nz20_fwhm325[32] = {
 19.29,21.09,22.73,24.63,26.65,28.40,31.64,34.33,36.60,38.71,
 40.80,42.72,44.67,49.41,53.87,58.84,64.78,70.42,80.53,89.50,
 98.50,106.22,113.96,121.91,130.50,155.35,178.35,209.11,247.65,289.93,
 391.50,508.40};
static float alpha05_nx064_nz20_fwhm350[32] = {
 21.89,24.36,26.29,28.68,30.97,32.97,36.78,39.95,42.69,45.21,
 47.69,50.03,51.93,57.73,62.76,69.07,76.35,82.74,94.69,105.07,
 115.52,126.15,136.12,145.64,155.70,181.64,208.54,242.45,290.00,341.67,
 448.75,588.25};
static float alpha05_nx064_nz20_fwhm375[32] = {
 24.94,27.67,29.80,32.23,35.05,37.81,42.20,45.65,49.30,51.95,
 54.97,57.63,59.88,66.61,73.03,80.33,88.11,95.71,109.63,122.07,
 134.05,146.89,157.60,168.29,178.35,208.83,239.67,282.14,334.75,387.14,
 517.60,675.67};
static float alpha05_nx064_nz20_fwhm400[32] = {
 27.88,30.83,33.47,36.32,39.88,42.80,47.66,52.08,55.65,59.12,
 62.12,65.47,68.25,76.07,83.11,90.64,100.81,109.14,124.20,139.00,
 153.57,165.61,178.60,189.76,203.00,237.94,272.20,319.55,376.00,439.40,
 584.00,758.33};
static float alpha05_nx064_nz20_fwhm425[32] = {
 31.33,34.54,37.36,40.80,44.27,47.66,53.19,57.92,62.33,66.21,
 69.65,72.88,76.23,85.04,92.84,102.30,113.28,123.11,140.26,156.89,
 172.35,187.06,200.92,214.83,227.10,266.91,306.11,357.60,421.83,490.20,
 658.00,840.00};
static float alpha05_nx064_nz20_fwhm450[32] = {
 34.06,37.56,40.76,45.02,48.92,52.27,58.69,64.07,68.71,73.12,
 77.23,81.38,85.07,94.41,103.29,114.13,125.56,137.00,157.13,174.71,
 191.50,207.53,223.33,238.69,254.69,299.00,342.60,398.43,470.17,549.67,
 733.00,931.25};
static float alpha05_nx064_nz20_fwhm475[32] = {
 36.88,40.84,44.17,48.30,52.75,57.50,64.05,70.32,76.21,80.88,
 85.70,89.85,93.79,104.57,114.18,125.71,139.00,151.35,172.60,191.82,
 210.85,229.67,248.40,266.12,283.43,330.20,376.70,441.29,524.20,609.00,
 802.50,1022.25};
static float alpha05_nx064_nz20_fwhm500[32] = {
 39.22,43.76,47.40,52.43,57.96,62.13,70.22,77.52,83.09,88.50,
 93.38,98.10,101.96,114.00,125.29,138.00,152.47,165.23,189.53,211.45,
 232.88,252.83,272.67,291.73,309.82,361.67,414.80,485.50,574.25,667.33,
 877.00,1106.20};
static float *alpha05_nx064_nz20[21] = {
 alpha05_nx064_nz20_fwhm000, alpha05_nx064_nz20_fwhm025, alpha05_nx064_nz20_fwhm050, 
 alpha05_nx064_nz20_fwhm075, alpha05_nx064_nz20_fwhm100, alpha05_nx064_nz20_fwhm125, 
 alpha05_nx064_nz20_fwhm150, alpha05_nx064_nz20_fwhm175, alpha05_nx064_nz20_fwhm200, 
 alpha05_nx064_nz20_fwhm225, alpha05_nx064_nz20_fwhm250, alpha05_nx064_nz20_fwhm275, 
 alpha05_nx064_nz20_fwhm300, alpha05_nx064_nz20_fwhm325, alpha05_nx064_nz20_fwhm350, 
 alpha05_nx064_nz20_fwhm375, alpha05_nx064_nz20_fwhm400, alpha05_nx064_nz20_fwhm425, 
 alpha05_nx064_nz20_fwhm450, alpha05_nx064_nz20_fwhm475, alpha05_nx064_nz20_fwhm500} ;

static float alpha10_nx064_nz20_fwhm000[32] = {
 1.90,1.90,1.90,1.91,1.91,1.91,1.93,1.95,1.97,1.99,
 2.12,2.28,2.40,2.63,2.74,2.82,2.87,2.90,2.95,3.02,
 3.42,3.62,3.75,3.83,3.89,4.20,4.67,4.94,5.60,5.95,
 7.00,8.17};
static float alpha10_nx064_nz20_fwhm025[32] = {
 1.90,1.90,1.90,1.91,1.91,1.91,1.93,1.95,1.97,1.99,
 2.12,2.28,2.40,2.63,2.74,2.82,2.87,2.90,2.95,3.02,
 3.42,3.62,3.75,3.83,3.89,4.20,4.67,4.94,5.60,5.95,
 7.00,8.17};
static float alpha10_nx064_nz20_fwhm050[32] = {
 1.90,1.90,1.90,1.91,1.91,1.92,1.93,1.95,1.97,2.00,
 2.21,2.35,2.47,2.66,2.76,2.83,2.88,2.91,2.96,3.16,
 3.50,3.68,3.79,3.86,3.92,4.36,4.74,4.99,5.71,6.06,
 7.29,8.45};
static float alpha10_nx064_nz20_fwhm075[32] = {
 1.90,1.91,1.91,1.91,1.92,1.93,1.96,1.99,2.18,2.38,
 2.50,2.59,2.65,2.77,2.84,2.88,2.92,2.95,3.22,3.58,
 3.75,3.86,3.93,3.99,4.27,4.76,4.98,5.65,6.14,6.85,
 8.03,9.58};
static float alpha10_nx064_nz20_fwhm100[32] = {
 1.91,1.92,1.93,1.94,1.96,1.99,2.34,2.54,2.65,2.72,
 2.77,2.81,2.84,2.90,2.94,2.98,3.33,3.57,3.83,3.95,
 4.23,4.56,4.75,4.88,4.98,5.70,6.16,6.88,7.78,8.68,
 10.54,12.57};
static float alpha10_nx064_nz20_fwhm125[32] = {
 1.95,1.99,2.16,2.40,2.57,2.68,2.80,2.87,2.91,2.94,
 2.97,3.05,3.25,3.59,3.76,3.91,4.10,4.48,4.86,5.25,
 5.69,5.93,6.34,6.68,6.92,7.84,8.74,9.89,11.47,12.99,
 16.31,19.87};
static float alpha10_nx064_nz20_fwhm150[32] = {
 2.61,2.75,2.83,2.91,2.97,3.16,3.52,3.73,3.86,3.96,
 4.17,4.40,4.56,4.86,5.17,5.65,5.99,6.53,7.28,7.97,
 8.71,9.37,9.94,10.58,11.12,12.87,14.61,16.81,19.74,22.83,
 29.41,37.47};
static float alpha10_nx064_nz20_fwhm175[32] = {
 3.32,3.64,3.83,3.99,4.39,4.66,4.96,5.42,5.79,6.07,
 6.43,6.69,6.90,7.64,8.30,8.93,9.82,10.58,11.92,13.24,
 14.43,15.63,16.80,17.95,19.05,22.37,25.56,29.94,35.79,41.72,
 55.32,71.53};
static float alpha10_nx064_nz20_fwhm200[32] = {
 4.80,5.22,5.65,5.99,6.56,6.94,7.71,8.30,8.84,9.39,
 9.80,10.25,10.68,11.69,12.71,13.86,15.31,16.66,18.93,21.15,
 23.25,25.28,27.16,29.10,30.97,36.45,41.86,49.45,59.03,69.42,
 92.70,121.44};
static float alpha10_nx064_nz20_fwhm225[32] = {
 6.75,7.43,7.92,8.53,9.17,9.77,10.82,11.74,12.55,13.27,
 13.93,14.64,15.24,16.86,18.38,20.13,22.45,24.31,28.03,31.13,
 33.99,36.95,39.90,42.53,45.10,52.99,60.97,71.96,86.57,102.03,
 136.90,180.93};
static float alpha10_nx064_nz20_fwhm250[32] = {
 8.78,9.64,10.35,11.15,12.09,12.86,14.36,15.53,16.60,17.66,
 18.65,19.59,20.38,22.84,24.87,27.50,30.19,32.75,37.38,41.63,
 45.77,49.53,53.41,57.27,60.97,71.38,82.58,97.07,117.24,137.35,
 185.20,244.73};
static float alpha10_nx064_nz20_fwhm275[32] = {
 10.92,12.00,12.95,14.05,15.17,16.20,18.15,19.68,21.26,22.55,
 23.80,24.90,26.06,29.05,31.65,34.68,38.37,41.57,47.60,52.82,
 58.23,63.25,68.17,72.92,77.68,91.22,105.20,124.30,148.76,176.26,
 235.06,307.60};
static float alpha10_nx064_nz20_fwhm300[32] = {
 13.09,14.40,15.53,16.92,18.40,19.80,22.09,24.17,25.89,27.57,
 29.02,30.51,31.91,35.44,38.71,42.60,46.84,50.82,58.29,64.96,
 71.75,77.58,83.29,89.05,94.96,112.80,129.76,153.50,183.10,215.73,
 287.21,373.84};
static float alpha10_nx064_nz20_fwhm325[32] = {
 15.18,16.83,18.17,19.93,21.74,23.40,26.17,28.58,30.68,32.60,
 34.39,36.00,37.76,41.97,45.77,50.46,55.78,61.03,69.48,77.44,
 84.93,92.52,99.84,106.74,114.38,134.71,155.74,182.14,217.30,254.60,
 341.46,438.33};
static float alpha10_nx064_nz20_fwhm350[32] = {
 17.35,19.27,20.85,22.91,25.10,26.89,30.04,32.81,35.31,37.69,
 39.90,41.95,43.85,48.86,53.29,58.82,65.09,70.81,81.19,90.36,
 99.57,108.78,117.14,125.85,133.82,157.97,181.37,211.67,252.83,297.29,
 392.53,508.50};
static float alpha10_nx064_nz20_fwhm375[32] = {
 19.36,21.49,23.55,25.71,28.27,30.45,34.10,37.51,40.46,43.10,
 45.55,47.84,49.84,55.93,61.01,67.68,74.87,81.42,93.23,104.11,
 115.22,125.39,135.29,144.12,153.44,180.48,205.72,242.96,291.05,340.08,
 450.00,580.00};
static float alpha10_nx064_nz20_fwhm400[32] = {
 21.39,24.04,26.12,28.61,31.33,33.79,38.29,41.99,45.48,48.50,
 51.07,53.74,56.35,63.00,69.32,76.55,84.70,92.06,105.43,118.66,
 130.62,142.12,153.04,163.61,173.59,202.80,233.81,275.85,328.85,383.40,
 507.15,649.10};
static float alpha10_nx064_nz20_fwhm425[32] = {
 23.32,26.13,28.68,31.41,34.65,37.45,42.63,46.53,50.32,53.95,
 57.11,60.04,62.95,70.44,77.55,85.32,94.61,102.95,118.52,132.60,
 146.82,159.15,171.22,183.23,194.53,228.16,262.86,308.17,366.80,426.50,
 568.64,724.88};
static float alpha10_nx064_nz20_fwhm450[32] = {
 25.18,28.34,31.31,34.55,38.10,41.26,46.48,51.46,55.63,59.49,
 63.00,66.16,69.49,77.81,85.30,94.42,104.96,114.09,131.59,147.57,
 162.71,176.64,189.50,203.50,217.00,254.88,291.73,342.21,404.59,474.67,
 628.80,802.17};
static float alpha10_nx064_nz20_fwhm475[32] = {
 26.93,30.72,33.93,37.44,41.40,44.74,50.51,55.91,60.62,64.76,
 68.70,72.44,75.64,84.77,93.38,103.86,115.47,125.22,144.44,162.17,
 178.60,193.58,209.69,224.18,238.29,281.00,321.70,376.40,448.15,523.22,
 689.38,874.83};
static float alpha10_nx064_nz20_fwhm500[32] = {
 28.37,32.62,35.97,39.81,44.26,48.02,54.64,60.32,65.17,69.91,
 74.10,78.21,81.95,92.75,102.32,113.22,125.38,136.48,157.79,177.06,
 195.59,212.64,229.70,245.87,261.44,307.00,353.08,411.42,490.30,575.45,
 748.50,958.50};
static float *alpha10_nx064_nz20[21] = {
 alpha10_nx064_nz20_fwhm000, alpha10_nx064_nz20_fwhm025, alpha10_nx064_nz20_fwhm050, 
 alpha10_nx064_nz20_fwhm075, alpha10_nx064_nz20_fwhm100, alpha10_nx064_nz20_fwhm125, 
 alpha10_nx064_nz20_fwhm150, alpha10_nx064_nz20_fwhm175, alpha10_nx064_nz20_fwhm200, 
 alpha10_nx064_nz20_fwhm225, alpha10_nx064_nz20_fwhm250, alpha10_nx064_nz20_fwhm275, 
 alpha10_nx064_nz20_fwhm300, alpha10_nx064_nz20_fwhm325, alpha10_nx064_nz20_fwhm350, 
 alpha10_nx064_nz20_fwhm375, alpha10_nx064_nz20_fwhm400, alpha10_nx064_nz20_fwhm425, 
 alpha10_nx064_nz20_fwhm450, alpha10_nx064_nz20_fwhm475, alpha10_nx064_nz20_fwhm500} ;

static float **nx064_nz20[3] = {
  alpha01_nx064_nz20 , alpha05_nx064_nz20 , alpha10_nx064_nz20 };

static float alpha01_nx064_nz21_fwhm000[32] = {
 1.99,1.99,2.00,2.00,2.22,2.45,2.70,2.80,2.86,2.90,
 2.92,2.94,2.95,2.97,2.98,2.99,3.17,3.52,3.82,3.92,
 3.98,4.11,4.50,4.69,4.82,5.03,5.75,5.99,6.88,7.62,
 8.88,10.15};
static float alpha01_nx064_nz21_fwhm025[32] = {
 1.99,1.99,2.00,2.00,2.22,2.45,2.70,2.80,2.86,2.90,
 2.92,2.94,2.95,2.97,2.98,2.99,3.17,3.52,3.82,3.92,
 3.98,4.11,4.50,4.69,4.82,5.03,5.75,5.99,6.88,7.62,
 8.88,10.15};
static float alpha01_nx064_nz21_fwhm050[32] = {
 1.99,1.99,2.00,2.00,2.31,2.54,2.73,2.82,2.87,2.91,
 2.93,2.94,2.96,2.98,2.99,2.99,3.31,3.61,3.86,3.94,
 3.99,4.32,4.59,4.78,4.88,5.32,5.83,6.35,6.97,7.80,
 8.99,10.54};
static float alpha01_nx064_nz21_fwhm075[32] = {
 1.99,2.00,2.07,2.42,2.63,2.73,2.84,2.89,2.93,2.95,
 2.96,2.97,2.98,2.99,3.00,3.42,3.72,3.85,3.95,4.00,
 4.56,4.79,4.91,4.97,5.17,5.86,6.35,6.94,7.86,8.68,
 10.14,11.91};
static float alpha01_nx064_nz21_fwhm100[32] = {
 2.30,2.58,2.72,2.80,2.87,2.91,2.95,2.97,2.98,2.99,
 3.00,3.08,3.31,3.67,3.82,3.92,3.98,4.35,4.79,4.95,
 5.21,5.67,5.88,6.02,6.41,7.00,7.85,8.78,9.89,11.00,
 13.47,16.14};
static float alpha01_nx064_nz21_fwhm125[32] = {
 2.86,2.91,2.94,2.96,2.98,3.00,3.46,3.70,3.82,3.90,
 3.93,3.97,3.99,4.59,4.82,4.97,5.44,5.78,6.30,6.83,
 7.20,7.74,8.13,8.69,8.99,10.29,11.43,12.93,15.00,16.78,
 21.06,25.87};
static float alpha01_nx064_nz21_fwhm150[32] = {
 3.50,3.74,3.85,3.95,4.25,4.50,4.87,4.99,5.36,5.63,
 5.84,5.94,6.01,6.69,7.00,7.71,8.28,8.82,9.78,10.69,
 11.64,12.53,13.25,13.88,14.73,17.16,19.53,22.70,26.39,30.79,
 40.43,50.65};
static float alpha01_nx064_nz21_fwhm175[32] = {
 5.11,5.57,5.80,6.06,6.59,6.85,7.53,7.93,8.37,8.78,
 9.14,9.57,9.83,10.78,11.68,12.82,13.85,14.82,16.73,18.33,
 20.31,21.87,23.47,25.06,26.36,30.23,35.00,41.35,48.77,57.81,
 76.67,100.08};
static float alpha01_nx064_nz21_fwhm200[32] = {
 7.85,8.35,8.80,9.36,9.95,10.67,11.64,12.47,13.19,13.97,
 14.63,15.18,15.73,17.39,18.45,20.00,21.98,24.18,26.85,29.77,
 32.46,35.24,37.55,40.27,43.00,51.50,59.33,70.00,83.17,95.78,
 131.78,174.75};
static float alpha01_nx064_nz21_fwhm225[32] = {
 11.23,12.12,12.91,13.74,14.74,15.78,17.17,18.32,19.10,19.96,
 21.12,22.13,23.00,25.23,27.08,30.06,32.83,35.54,39.92,44.88,
 49.31,53.69,57.55,61.56,65.12,76.56,86.75,104.00,124.38,147.25,
 200.86,266.00};
static float alpha01_nx064_nz21_fwhm250[32] = {
 15.28,16.39,17.38,18.76,19.64,20.80,22.88,24.64,26.48,27.92,
 29.21,30.57,31.74,34.65,38.11,41.65,45.27,50.00,56.73,62.82,
 68.44,74.00,79.33,84.50,88.62,104.29,118.77,142.00,171.29,203.50,
 273.14,358.00};
static float alpha01_nx064_nz21_fwhm275[32] = {
 19.19,21.13,22.23,23.87,25.79,27.36,30.30,32.44,34.82,36.75,
 38.38,40.39,41.92,46.38,50.39,55.00,59.50,64.22,73.58,80.76,
 88.09,94.60,101.80,109.12,115.20,135.80,159.00,188.10,219.50,259.17,
 345.25,457.75};
static float alpha01_nx064_nz21_fwhm300[32] = {
 24.29,26.08,28.28,30.47,33.00,34.64,38.05,40.94,43.50,46.50,
 48.42,50.73,52.73,58.30,63.17,68.88,75.56,80.86,91.00,100.67,
 111.00,120.00,127.67,137.00,143.80,171.20,196.25,229.12,269.50,318.25,
 426.33,566.00};
static float alpha01_nx064_nz21_fwhm325[32] = {
 29.59,32.40,34.27,36.86,38.86,41.61,46.82,50.53,54.12,56.69,
 59.82,62.31,64.62,71.20,76.00,83.00,90.75,97.33,109.75,123.50,
 135.00,143.86,155.00,164.67,174.60,205.00,236.75,276.60,328.20,385.67,
 516.00,681.00};
static float alpha01_nx064_nz21_fwhm350[32] = {
 35.40,38.08,40.33,43.58,46.85,50.29,55.73,60.18,64.12,67.29,
 70.30,72.75,75.56,83.17,89.71,97.20,105.33,116.00,131.50,144.00,
 157.25,169.33,182.00,194.75,208.33,242.33,278.80,323.00,386.00,447.00,
 613.00,791.00};
static float alpha01_nx064_nz21_fwhm375[32] = {
 40.89,45.75,48.69,51.64,55.33,58.44,64.00,68.91,73.22,77.57,
 81.10,84.33,87.57,97.43,104.00,113.40,123.75,133.00,150.25,166.67,
 182.50,198.00,211.25,226.00,239.00,280.33,320.67,374.25,443.75,529.50,
 704.00,900.50};
static float alpha01_nx064_nz21_fwhm400[32] = {
 47.33,51.73,54.90,58.58,62.44,66.00,73.25,78.80,83.40,89.11,
 92.20,95.67,99.25,109.00,118.00,128.67,140.60,152.00,174.00,191.00,
 207.00,226.80,241.00,257.67,272.50,318.80,365.50,427.33,511.00,602.50,
 786.00,1011.00};
static float alpha01_nx064_nz21_fwhm425[32] = {
 53.58,57.00,61.12,65.25,69.83,74.40,82.60,89.00,93.50,98.50,
 103.29,107.14,110.67,123.50,133.83,146.00,159.50,170.75,196.40,217.50,
 237.40,253.50,272.00,292.33,309.50,359.50,413.17,484.50,579.00,676.50,
 881.00,1140.00};
static float alpha01_nx064_nz21_fwhm450[32] = {
 58.80,64.14,68.50,73.00,78.25,83.50,91.14,97.50,103.50,109.80,
 116.50,120.57,124.71,137.25,148.67,163.60,179.17,192.80,217.80,241.50,
 262.67,285.00,308.50,327.00,345.50,401.50,461.33,542.50,639.00,753.50,
 985.00,1281.00};
static float alpha01_nx064_nz21_fwhm475[32] = {
 64.60,70.00,74.75,80.75,86.00,91.00,99.67,108.00,114.00,120.50,
 127.67,132.50,140.00,153.55,165.80,179.83,197.00,212.50,240.50,268.00,
 294.00,316.25,336.50,362.00,386.00,451.00,519.00,605.00,706.00,823.00,
 1091.00,1390.00};
static float alpha01_nx064_nz21_fwhm500[32] = {
 70.00,76.50,82.00,87.43,93.57,99.25,110.00,119.00,126.00,132.67,
 139.75,146.71,151.50,166.67,182.00,199.33,217.00,235.33,265.33,294.00,
 325.00,351.00,375.60,399.67,424.80,494.00,572.00,662.00,793.00,900.50,
 1195.00,1531.00};
static float *alpha01_nx064_nz21[21] = {
 alpha01_nx064_nz21_fwhm000, alpha01_nx064_nz21_fwhm025, alpha01_nx064_nz21_fwhm050, 
 alpha01_nx064_nz21_fwhm075, alpha01_nx064_nz21_fwhm100, alpha01_nx064_nz21_fwhm125, 
 alpha01_nx064_nz21_fwhm150, alpha01_nx064_nz21_fwhm175, alpha01_nx064_nz21_fwhm200, 
 alpha01_nx064_nz21_fwhm225, alpha01_nx064_nz21_fwhm250, alpha01_nx064_nz21_fwhm275, 
 alpha01_nx064_nz21_fwhm300, alpha01_nx064_nz21_fwhm325, alpha01_nx064_nz21_fwhm350, 
 alpha01_nx064_nz21_fwhm375, alpha01_nx064_nz21_fwhm400, alpha01_nx064_nz21_fwhm425, 
 alpha01_nx064_nz21_fwhm450, alpha01_nx064_nz21_fwhm475, alpha01_nx064_nz21_fwhm500} ;

static float alpha05_nx064_nz21_fwhm000[32] = {
 1.95,1.95,1.95,1.96,1.96,1.97,1.98,2.00,2.27,2.46,
 2.58,2.66,2.72,2.83,2.88,2.92,2.94,2.96,3.05,3.54,
 3.74,3.84,3.91,3.95,3.99,4.65,4.92,5.41,5.92,6.59,
 7.71,8.87};
static float alpha05_nx064_nz21_fwhm025[32] = {
 1.95,1.95,1.95,1.96,1.96,1.97,1.98,2.00,2.27,2.46,
 2.58,2.66,2.72,2.83,2.88,2.92,2.94,2.96,3.05,3.54,
 3.74,3.84,3.91,3.95,3.99,4.65,4.92,5.41,5.92,6.59,
 7.71,8.87};
static float alpha05_nx064_nz21_fwhm050[32] = {
 1.95,1.95,1.96,1.96,1.96,1.97,1.99,2.08,2.35,2.52,
 2.62,2.70,2.75,2.84,2.89,2.92,2.95,2.97,3.21,3.61,
 3.78,3.87,3.93,3.97,4.10,4.74,4.96,5.57,5.99,6.74,
 7.88,9.08};
static float alpha05_nx064_nz21_fwhm075[32] = {
 1.95,1.96,1.96,1.97,1.98,1.99,2.18,2.44,2.60,2.70,
 2.76,2.81,2.84,2.90,2.93,2.95,2.98,3.17,3.63,3.82,
 3.91,3.97,4.19,4.50,4.68,4.96,5.57,5.96,6.77,7.45,
 8.87,10.37};
static float alpha05_nx064_nz21_fwhm100[32] = {
 1.96,1.97,1.98,2.00,2.30,2.50,2.68,2.79,2.84,2.88,
 2.90,2.92,2.94,2.97,3.00,3.44,3.70,3.83,3.96,4.34,
 4.67,4.86,4.97,5.31,5.59,6.03,6.77,7.54,8.51,9.45,
 11.47,13.73};
static float alpha05_nx064_nz21_fwhm125[32] = {
 2.24,2.48,2.62,2.73,2.81,2.86,2.92,2.96,2.99,3.23,
 3.41,3.55,3.65,3.85,3.95,4.21,4.64,4.84,5.33,5.79,
 6.05,6.58,6.90,7.31,7.65,8.71,9.66,10.90,12.66,14.31,
 17.85,21.87};
static float alpha05_nx064_nz21_fwhm150[32] = {
 2.85,2.92,2.97,3.14,3.47,3.65,3.88,3.99,4.31,4.54,
 4.72,4.84,4.93,5.43,5.79,6.17,6.78,7.23,8.07,8.90,
 9.70,10.39,11.02,11.72,12.42,14.31,16.12,18.62,21.88,25.31,
 32.71,41.28};
static float alpha05_nx064_nz21_fwhm175[32] = {
 3.87,4.14,4.46,4.75,4.96,5.28,5.78,6.14,6.59,6.91,
 7.29,7.64,7.87,8.66,9.33,9.97,10.96,11.85,13.47,14.91,
 16.31,17.62,18.84,19.97,21.11,24.82,28.55,33.11,39.37,46.40,
 61.60,79.69};
static float alpha05_nx064_nz21_fwhm200[32] = {
 5.72,6.22,6.66,7.18,7.71,8.19,8.91,9.59,10.14,10.73,
 11.27,11.71,12.14,13.52,14.56,15.93,17.50,18.85,21.54,23.93,
 26.12,28.28,30.54,32.57,34.60,40.64,46.72,54.94,66.06,77.21,
 104.63,137.04};
static float alpha05_nx064_nz21_fwhm225[32] = {
 8.26,8.88,9.49,10.11,10.88,11.59,12.76,13.75,14.63,15.51,
 16.28,16.95,17.68,19.61,21.10,23.15,25.54,27.65,31.51,34.98,
 38.55,41.74,44.92,47.86,50.93,60.57,69.30,81.74,97.75,114.86,
 155.43,205.62};
static float alpha05_nx064_nz21_fwhm250[32] = {
 10.74,11.76,12.52,13.49,14.66,15.58,17.18,18.56,19.88,20.95,
 21.98,22.99,23.90,26.45,28.77,31.77,34.75,37.63,42.58,47.60,
 52.30,56.68,60.98,65.16,69.33,81.51,93.59,110.80,133.17,157.46,
 212.18,279.93};
static float alpha05_nx064_nz21_fwhm275[32] = {
 13.60,14.80,15.82,17.12,18.53,19.84,22.15,23.81,25.47,26.78,
 28.17,29.47,30.75,34.00,36.77,40.28,44.53,47.98,54.92,61.24,
 67.03,72.88,78.38,83.70,89.29,105.15,120.60,141.77,170.18,202.82,
 271.56,353.67};
static float alpha05_nx064_nz21_fwhm300[32] = {
 16.65,18.17,19.55,21.15,23.06,24.50,26.99,29.15,31.31,33.05,
 34.68,36.35,37.77,41.87,45.76,49.77,54.58,59.16,67.83,75.56,
 83.42,90.30,96.97,103.44,109.97,129.38,149.35,176.09,211.72,247.50,
 331.60,433.80};
static float alpha05_nx064_nz21_fwhm325[32] = {
 19.67,21.69,23.37,25.35,27.30,29.40,32.41,35.00,37.37,39.55,
 41.59,43.51,45.16,50.26,54.57,59.89,65.81,70.96,81.24,90.66,
 99.62,108.21,116.19,124.45,132.44,155.22,179.88,211.43,251.50,295.73,
 397.00,513.80};
static float alpha05_nx064_nz21_fwhm350[32] = {
 22.84,25.20,27.29,29.46,31.89,33.93,37.78,40.88,43.68,46.10,
 48.59,50.95,53.32,58.83,64.05,70.46,77.27,83.50,95.97,107.24,
 117.94,127.42,137.25,146.81,156.00,183.21,210.00,245.19,295.08,346.00,
 463.44,600.40};
static float alpha05_nx064_nz21_fwhm375[32] = {
 26.05,28.77,31.09,33.50,36.22,38.70,42.92,46.68,50.38,53.42,
 56.32,58.85,60.98,67.72,73.97,80.77,89.45,97.53,111.60,124.18,
 135.89,147.88,158.53,168.88,178.90,211.17,241.20,284.50,340.00,399.12,
 527.14,688.50};
static float alpha05_nx064_nz21_fwhm400[32] = {
 29.23,32.09,34.58,37.32,40.42,43.23,48.50,53.18,56.88,60.39,
 63.21,66.36,69.35,77.31,84.35,93.03,102.32,111.67,126.91,141.82,
 155.14,167.55,181.20,192.53,203.86,239.88,275.14,324.44,385.20,456.14,
 600.60,770.33};
static float alpha05_nx064_nz21_fwhm425[32] = {
 31.93,35.31,38.19,41.52,44.91,48.47,54.06,58.90,63.34,67.38,
 71.31,74.81,78.21,87.29,94.68,103.95,114.86,124.19,143.46,159.00,
 175.00,188.70,202.85,216.50,230.00,271.88,310.71,362.00,436.00,514.25,
 675.67,862.33};
static float alpha05_nx064_nz21_fwhm450[32] = {
 35.04,38.81,41.95,45.65,49.93,53.74,59.97,65.81,70.67,75.21,
 79.33,83.22,86.59,96.39,105.53,116.26,128.72,139.00,159.40,177.89,
 193.62,210.59,225.94,241.40,256.00,303.73,347.25,406.78,489.67,571.00,
 749.80,955.17};
static float alpha05_nx064_nz21_fwhm475[32] = {
 37.93,42.62,46.16,50.62,55.17,59.11,66.00,72.22,78.20,82.67,
 87.66,91.69,95.52,107.11,116.55,127.69,140.56,153.56,175.29,196.30,
 215.10,232.71,249.92,266.45,285.00,335.00,382.80,453.67,543.50,630.33,
 823.00,1048.67};
static float alpha05_nx064_nz21_fwhm500[32] = {
 41.35,45.93,49.90,54.26,59.56,63.93,72.50,78.91,85.41,90.48,
 95.38,99.61,104.29,116.80,126.62,139.76,153.78,167.40,192.83,215.81,
 235.06,255.85,276.08,295.17,312.50,367.00,425.83,502.75,594.33,692.00,
 894.33,1144.67};
static float *alpha05_nx064_nz21[21] = {
 alpha05_nx064_nz21_fwhm000, alpha05_nx064_nz21_fwhm025, alpha05_nx064_nz21_fwhm050, 
 alpha05_nx064_nz21_fwhm075, alpha05_nx064_nz21_fwhm100, alpha05_nx064_nz21_fwhm125, 
 alpha05_nx064_nz21_fwhm150, alpha05_nx064_nz21_fwhm175, alpha05_nx064_nz21_fwhm200, 
 alpha05_nx064_nz21_fwhm225, alpha05_nx064_nz21_fwhm250, alpha05_nx064_nz21_fwhm275, 
 alpha05_nx064_nz21_fwhm300, alpha05_nx064_nz21_fwhm325, alpha05_nx064_nz21_fwhm350, 
 alpha05_nx064_nz21_fwhm375, alpha05_nx064_nz21_fwhm400, alpha05_nx064_nz21_fwhm425, 
 alpha05_nx064_nz21_fwhm450, alpha05_nx064_nz21_fwhm475, alpha05_nx064_nz21_fwhm500} ;

static float alpha10_nx064_nz21_fwhm000[32] = {
 1.90,1.90,1.90,1.91,1.91,1.92,1.93,1.95,1.97,1.99,
 2.15,2.31,2.44,2.64,2.75,2.82,2.87,2.90,2.95,3.05,
 3.44,3.64,3.77,3.84,3.90,4.21,4.70,4.95,5.63,5.98,
 7.03,8.29};
static float alpha10_nx064_nz21_fwhm025[32] = {
 1.90,1.90,1.90,1.91,1.91,1.92,1.93,1.95,1.97,1.99,
 2.15,2.31,2.44,2.64,2.75,2.82,2.87,2.90,2.95,3.05,
 3.44,3.64,3.77,3.84,3.90,4.21,4.70,4.95,5.63,5.98,
 7.03,8.29};
static float alpha10_nx064_nz21_fwhm050[32] = {
 1.90,1.90,1.91,1.91,1.91,1.92,1.93,1.95,1.97,2.03,
 2.23,2.39,2.49,2.68,2.77,2.83,2.88,2.91,2.96,3.20,
 3.51,3.70,3.80,3.87,3.92,4.37,4.77,4.99,5.74,6.20,
 7.33,8.54};
static float alpha10_nx064_nz21_fwhm075[32] = {
 1.90,1.91,1.91,1.92,1.92,1.94,1.96,1.99,2.20,2.40,
 2.52,2.61,2.67,2.78,2.84,2.88,2.92,2.95,3.22,3.59,
 3.77,3.86,3.93,3.99,4.27,4.78,5.00,5.70,6.26,6.87,
 8.25,9.64};
static float alpha10_nx064_nz21_fwhm100[32] = {
 1.91,1.92,1.93,1.95,1.97,2.00,2.35,2.55,2.67,2.73,
 2.78,2.82,2.84,2.90,2.94,2.98,3.35,3.60,3.83,3.95,
 4.23,4.57,4.77,4.90,5.00,5.74,6.24,6.91,7.84,8.76,
 10.62,12.66};
static float alpha10_nx064_nz21_fwhm125[32] = {
 1.96,1.99,2.21,2.44,2.60,2.70,2.80,2.87,2.91,2.95,
 2.97,3.03,3.23,3.59,3.77,3.90,4.11,4.50,4.88,5.29,
 5.71,5.96,6.42,6.74,6.95,7.94,8.86,9.96,11.62,13.12,
 16.45,20.10};
static float alpha10_nx064_nz21_fwhm150[32] = {
 2.62,2.75,2.83,2.90,2.97,3.13,3.54,3.74,3.87,3.96,
 4.14,4.37,4.55,4.87,5.21,5.68,6.04,6.59,7.38,8.02,
 8.80,9.44,9.98,10.67,11.29,12.95,14.73,16.95,19.87,23.04,
 29.91,37.61};
static float alpha10_nx064_nz21_fwhm175[32] = {
 3.35,3.65,3.84,4.01,4.42,4.66,5.00,5.47,5.78,6.00,
 6.43,6.72,6.92,7.71,8.30,8.96,9.80,10.60,12.02,13.41,
 14.58,15.77,16.90,17.94,19.10,22.46,25.74,30.05,35.68,41.97,
 55.49,71.01};
static float alpha10_nx064_nz21_fwhm200[32] = {
 4.80,5.26,5.67,6.10,6.63,6.97,7.76,8.40,8.90,9.43,
 9.85,10.29,10.72,11.89,12.86,14.07,15.48,16.75,19.07,21.29,
 23.30,25.38,27.21,29.07,31.00,36.66,41.97,49.22,59.03,69.31,
 93.22,122.79};
static float alpha10_nx064_nz21_fwhm225[32] = {
 6.83,7.54,8.12,8.69,9.33,9.89,10.92,11.79,12.64,13.46,
 14.17,14.75,15.35,17.02,18.52,20.28,22.34,24.17,27.76,30.95,
 34.06,36.86,39.77,42.60,45.33,53.38,61.64,72.53,87.42,102.40,
 138.42,182.49};
static float alpha10_nx064_nz21_fwhm250[32] = {
 8.90,9.73,10.42,11.27,12.31,13.06,14.53,15.78,16.94,17.92,
 18.89,19.72,20.64,22.91,24.89,27.19,29.93,32.64,37.42,41.77,
 46.03,50.02,53.75,57.15,61.11,72.10,83.18,98.56,117.75,139.50,
 187.36,245.77};
static float alpha10_nx064_nz21_fwhm275[32] = {
 10.92,11.99,13.08,14.29,15.43,16.58,18.47,20.01,21.46,22.69,
 23.84,24.87,25.97,28.83,31.42,34.75,38.21,41.73,47.51,53.20,
 58.87,63.80,68.80,73.70,78.32,92.50,106.10,125.86,150.79,177.21,
 237.44,309.71};
static float alpha10_nx064_nz21_fwhm300[32] = {
 13.29,14.71,15.88,17.21,18.72,19.96,22.19,24.19,25.92,27.54,
 29.10,30.41,31.75,35.38,38.71,42.48,47.05,51.20,58.96,65.61,
 72.62,78.47,84.64,90.79,96.26,113.51,130.41,153.63,183.86,216.71,
 289.76,375.00};
static float alpha10_nx064_nz21_fwhm325[32] = {
 15.57,17.25,18.62,20.11,21.95,23.60,26.34,28.81,30.93,32.79,
 34.70,36.36,37.91,42.12,46.13,51.17,56.41,61.43,70.28,78.56,
 86.40,93.67,101.10,108.28,114.87,134.76,155.79,183.42,218.55,256.88,
 343.88,446.30};
static float alpha10_nx064_nz21_fwhm350[32] = {
 17.75,19.51,21.35,23.31,25.51,27.32,30.62,33.41,35.78,38.21,
 40.22,42.30,44.10,49.36,53.89,59.47,65.89,71.49,81.98,91.85,
 101.05,109.31,117.74,125.88,133.62,158.00,182.46,214.09,255.70,299.33,
 399.67,516.73};
static float alpha10_nx064_nz21_fwhm375[32] = {
 19.86,22.28,24.22,26.39,28.78,30.97,34.78,38.04,40.81,43.63,
 46.16,48.50,50.50,56.37,61.67,68.23,75.41,82.17,94.80,105.03,
 115.82,125.61,135.22,144.60,154.10,182.67,209.82,246.00,293.40,343.59,
 457.00,589.29};
static float alpha10_nx064_nz21_fwhm400[32] = {
 21.97,24.60,26.66,29.29,32.11,34.67,38.88,42.88,46.14,49.25,
 52.06,54.67,57.12,63.69,70.20,77.69,85.98,93.32,107.08,119.92,
 131.54,142.07,153.92,164.72,175.50,207.24,237.89,279.84,332.38,388.53,
 515.14,663.67};
static float alpha10_nx064_nz21_fwhm425[32] = {
 23.96,26.85,29.22,32.26,35.50,38.17,43.40,47.52,51.40,54.92,
 58.24,61.18,64.06,71.75,78.86,86.71,96.47,104.39,120.06,134.38,
 147.31,160.36,173.31,184.73,197.07,231.15,267.18,311.81,372.55,436.91,
 578.18,743.91};
static float alpha10_nx064_nz21_fwhm450[32] = {
 25.89,28.99,31.82,35.29,38.93,42.19,47.71,52.56,56.77,60.75,
 64.40,67.81,70.58,79.28,86.56,95.95,106.88,116.09,133.16,149.00,
 163.86,178.39,191.94,205.84,218.82,257.57,295.87,347.73,413.57,484.33,
 637.14,820.43};
static float alpha10_nx064_nz21_fwhm475[32] = {
 27.57,31.07,34.23,38.10,42.04,45.64,52.06,57.49,62.17,66.60,
 70.26,73.76,77.36,86.70,95.08,105.41,117.15,127.83,146.71,164.14,
 180.37,196.86,211.62,225.67,240.91,285.85,326.61,384.86,458.91,534.00,
 703.50,892.50};
static float alpha10_nx064_nz21_fwhm500[32] = {
 29.16,33.21,36.66,40.73,45.23,49.09,55.88,62.00,67.27,71.93,
 76.24,79.93,83.78,94.22,103.76,115.10,128.00,139.40,160.31,178.82,
 197.46,215.45,232.35,249.81,265.77,312.07,360.47,422.14,502.83,587.50,
 765.33,970.20};
static float *alpha10_nx064_nz21[21] = {
 alpha10_nx064_nz21_fwhm000, alpha10_nx064_nz21_fwhm025, alpha10_nx064_nz21_fwhm050, 
 alpha10_nx064_nz21_fwhm075, alpha10_nx064_nz21_fwhm100, alpha10_nx064_nz21_fwhm125, 
 alpha10_nx064_nz21_fwhm150, alpha10_nx064_nz21_fwhm175, alpha10_nx064_nz21_fwhm200, 
 alpha10_nx064_nz21_fwhm225, alpha10_nx064_nz21_fwhm250, alpha10_nx064_nz21_fwhm275, 
 alpha10_nx064_nz21_fwhm300, alpha10_nx064_nz21_fwhm325, alpha10_nx064_nz21_fwhm350, 
 alpha10_nx064_nz21_fwhm375, alpha10_nx064_nz21_fwhm400, alpha10_nx064_nz21_fwhm425, 
 alpha10_nx064_nz21_fwhm450, alpha10_nx064_nz21_fwhm475, alpha10_nx064_nz21_fwhm500} ;

static float **nx064_nz21[3] = {
  alpha01_nx064_nz21 , alpha05_nx064_nz21 , alpha10_nx064_nz21 };

static float alpha01_nx064_nz22_fwhm000[32] = {
 1.99,1.99,2.00,2.00,2.26,2.47,2.68,2.80,2.86,2.90,
 2.92,2.94,2.95,2.97,2.98,3.00,3.34,3.64,3.86,3.94,
 3.98,4.16,4.54,4.75,4.86,5.09,5.71,6.00,6.84,7.54,
 8.83,10.35};
static float alpha01_nx064_nz22_fwhm025[32] = {
 1.99,1.99,2.00,2.00,2.26,2.47,2.68,2.80,2.86,2.90,
 2.92,2.94,2.95,2.97,2.98,3.00,3.35,3.64,3.86,3.94,
 3.98,4.17,4.54,4.75,4.86,5.09,5.71,6.00,6.84,7.54,
 8.83,10.35};
static float alpha01_nx064_nz22_fwhm050[32] = {
 1.99,1.99,2.00,2.07,2.34,2.52,2.73,2.82,2.88,2.91,
 2.93,2.95,2.96,2.98,2.99,3.00,3.51,3.70,3.89,3.96,
 3.99,4.34,4.66,4.82,4.89,5.33,5.80,6.31,6.93,7.73,
 8.97,10.70};
static float alpha01_nx064_nz22_fwhm075[32] = {
 1.99,2.00,2.18,2.45,2.62,2.72,2.84,2.90,2.93,2.95,
 2.96,2.97,2.98,2.99,3.15,3.61,3.79,3.89,3.97,4.22,
 4.61,4.80,4.91,4.98,5.25,5.85,6.26,6.91,7.81,8.62,
 10.34,11.99};
static float alpha01_nx064_nz22_fwhm100[32] = {
 2.38,2.61,2.72,2.81,2.87,2.91,2.95,2.97,2.98,3.00,
 3.12,3.36,3.52,3.75,3.87,3.95,4.00,4.38,4.81,4.97,
 5.38,5.71,5.87,5.97,6.35,7.06,7.88,8.80,9.93,11.04,
 13.57,15.93};
static float alpha01_nx064_nz22_fwhm125[32] = {
 2.87,2.92,2.95,2.98,2.99,3.17,3.56,3.73,3.84,3.93,
 3.97,3.99,4.14,4.57,4.79,4.95,5.43,5.76,6.22,6.84,
 7.37,7.80,8.23,8.78,9.17,10.38,11.67,13.17,15.06,17.02,
 21.39,26.29};
static float alpha01_nx064_nz22_fwhm150[32] = {
 3.46,3.68,3.81,3.92,4.01,4.46,4.78,4.93,5.22,5.56,
 5.79,5.92,6.08,6.67,7.11,7.65,8.22,8.90,9.96,10.98,
 11.86,12.65,13.64,14.45,15.21,17.72,19.75,23.04,26.94,31.00,
 40.95,51.27};
static float alpha01_nx064_nz22_fwhm175[32] = {
 5.02,5.53,5.83,6.17,6.55,6.92,7.57,7.98,8.48,8.84,
 9.38,9.71,9.95,10.84,11.77,12.82,13.97,14.92,16.89,18.86,
 20.38,22.09,24.00,25.63,27.08,31.54,36.00,41.24,49.81,57.79,
 76.38,98.60};
static float alpha01_nx064_nz22_fwhm200[32] = {
 7.98,8.63,9.15,9.65,10.20,10.82,11.87,12.71,13.29,14.05,
 14.65,15.22,15.87,17.41,18.77,20.62,22.57,24.25,27.70,30.79,
 33.73,36.10,39.09,41.19,43.71,51.79,58.94,69.60,82.38,97.00,
 130.56,177.25};
static float alpha01_nx064_nz22_fwhm225[32] = {
 11.56,12.38,12.98,13.89,15.11,16.00,17.47,18.55,19.91,20.82,
 21.92,22.84,23.77,25.86,28.25,31.32,33.90,36.77,40.83,45.11,
 49.18,53.29,56.83,61.08,64.33,75.20,87.58,102.50,124.20,146.60,
 201.75,275.25};
static float alpha01_nx064_nz22_fwhm250[32] = {
 15.61,17.10,18.38,19.44,20.77,21.69,23.65,25.46,27.17,28.59,
 29.95,31.29,32.47,35.80,38.56,41.60,44.94,49.07,55.44,60.72,
 66.25,71.64,77.80,83.10,88.75,104.08,120.11,140.50,169.33,206.50,
 279.50,375.86};
static float alpha01_nx064_nz22_fwhm275[32] = {
 20.27,22.00,23.24,24.69,26.90,28.40,31.00,33.00,35.50,37.00,
 38.73,40.06,41.21,45.00,48.50,53.08,58.00,62.50,70.90,79.08,
 87.20,94.00,101.00,106.70,114.00,134.40,152.00,182.88,222.00,264.43,
 365.67,474.50};
static float alpha01_nx064_nz22_fwhm300[32] = {
 25.29,27.43,28.83,31.08,33.31,35.06,38.20,40.22,42.50,44.50,
 46.87,48.80,50.83,55.79,60.77,65.67,73.13,78.42,88.67,98.67,
 108.40,118.17,126.60,135.20,142.14,166.00,192.00,228.67,278.00,333.00,
 444.67,572.67};
static float alpha01_nx064_nz22_fwhm325[32] = {
 30.56,32.87,34.82,37.27,39.36,41.33,44.92,48.50,51.18,53.89,
 57.00,59.40,61.50,67.95,73.83,80.00,88.00,94.78,107.86,120.83,
 131.33,142.25,152.17,161.17,171.00,201.80,234.00,277.83,338.00,394.57,
 520.00,692.00};
static float alpha01_nx064_nz22_fwhm350[32] = {
 36.00,39.00,40.76,43.57,46.50,49.30,53.64,57.18,61.00,64.33,
 68.06,70.67,73.45,80.91,87.50,95.25,103.40,111.60,128.20,141.00,
 153.60,166.43,178.00,191.33,203.00,241.00,277.33,332.50,396.25,467.20,
 618.00,817.00};
static float alpha01_nx064_nz22_fwhm375[32] = {
 40.83,44.25,47.00,50.33,53.70,57.25,62.55,67.00,71.14,74.71,
 78.62,81.89,85.25,93.38,101.33,109.50,120.00,129.67,147.75,164.57,
 178.00,196.00,209.67,226.67,241.00,281.00,325.50,385.67,459.00,537.00,
 725.00,931.00};
static float alpha01_nx064_nz22_fwhm400[32] = {
 46.38,49.88,53.29,57.78,61.71,65.25,71.00,76.38,80.67,84.91,
 89.29,93.58,97.67,106.11,114.83,125.50,139.50,149.67,171.50,191.00,
 209.33,227.00,244.25,259.33,275.50,322.00,375.00,439.60,525.00,618.00,
 813.00,1053.00};
static float alpha01_nx064_nz22_fwhm425[32] = {
 51.88,56.50,60.38,64.25,69.00,72.57,79.75,85.25,91.25,97.00,
 100.29,105.14,109.14,120.17,131.67,145.00,158.88,171.33,196.25,218.50,
 238.80,257.33,277.00,295.33,315.00,365.50,422.80,491.50,597.33,703.33,
 911.00,1182.00};
static float alpha01_nx064_nz22_fwhm450[32] = {
 58.10,61.83,66.25,70.86,75.78,80.00,88.78,95.40,101.56,107.62,
 112.25,118.00,122.83,136.25,149.80,163.20,179.50,194.00,218.67,245.00,
 270.20,289.33,309.33,329.50,352.00,415.40,470.50,560.00,672.00,785.00,
 1026.00,1330.00};
static float alpha01_nx064_nz22_fwhm475[32] = {
 62.33,67.38,72.00,78.20,83.80,89.00,97.60,104.60,112.67,119.50,
 126.60,133.17,139.29,154.17,167.50,183.00,199.00,213.33,246.00,273.25,
 300.00,319.80,346.50,371.50,393.50,460.00,529.00,618.00,747.00,862.50,
 1142.00,1451.80};
static float alpha01_nx064_nz22_fwhm500[32] = {
 67.00,73.86,79.86,85.50,91.67,97.50,107.80,116.75,125.33,133.75,
 140.80,147.25,154.40,169.00,185.00,200.00,220.00,240.50,271.00,301.00,
 331.50,362.00,385.67,410.00,435.00,509.00,585.00,687.00,824.00,953.00,
 1258.50,1568.00};
static float *alpha01_nx064_nz22[21] = {
 alpha01_nx064_nz22_fwhm000, alpha01_nx064_nz22_fwhm025, alpha01_nx064_nz22_fwhm050, 
 alpha01_nx064_nz22_fwhm075, alpha01_nx064_nz22_fwhm100, alpha01_nx064_nz22_fwhm125, 
 alpha01_nx064_nz22_fwhm150, alpha01_nx064_nz22_fwhm175, alpha01_nx064_nz22_fwhm200, 
 alpha01_nx064_nz22_fwhm225, alpha01_nx064_nz22_fwhm250, alpha01_nx064_nz22_fwhm275, 
 alpha01_nx064_nz22_fwhm300, alpha01_nx064_nz22_fwhm325, alpha01_nx064_nz22_fwhm350, 
 alpha01_nx064_nz22_fwhm375, alpha01_nx064_nz22_fwhm400, alpha01_nx064_nz22_fwhm425, 
 alpha01_nx064_nz22_fwhm450, alpha01_nx064_nz22_fwhm475, alpha01_nx064_nz22_fwhm500} ;

static float alpha05_nx064_nz22_fwhm000[32] = {
 1.95,1.95,1.95,1.96,1.96,1.97,1.98,2.00,2.30,2.49,
 2.59,2.67,2.73,2.83,2.88,2.92,2.95,2.97,3.22,3.58,
 3.77,3.86,3.92,3.96,4.00,4.67,4.91,5.43,5.91,6.56,
 7.70,8.87};
static float alpha05_nx064_nz22_fwhm025[32] = {
 1.95,1.95,1.96,1.96,1.96,1.97,1.98,2.00,2.30,2.49,
 2.59,2.67,2.73,2.83,2.88,2.92,2.95,2.97,3.22,3.58,
 3.77,3.86,3.92,3.96,4.00,4.67,4.91,5.43,5.91,6.56,
 7.70,8.87};
static float alpha05_nx064_nz22_fwhm050[32] = {
 1.95,1.95,1.96,1.96,1.96,1.97,1.99,2.11,2.38,2.54,
 2.63,2.70,2.76,2.85,2.89,2.93,2.96,2.98,3.33,3.65,
 3.80,3.88,3.94,3.98,4.14,4.75,4.95,5.59,5.96,6.70,
 7.85,9.12};
static float alpha05_nx064_nz22_fwhm075[32] = {
 1.95,1.96,1.96,1.97,1.98,1.99,2.21,2.47,2.61,2.71,
 2.77,2.81,2.85,2.90,2.93,2.96,2.99,3.29,3.69,3.84,
 3.92,3.98,4.20,4.52,4.71,4.97,5.56,5.95,6.77,7.46,
 8.86,10.43};
static float alpha05_nx064_nz22_fwhm100[32] = {
 1.97,1.98,1.98,2.02,2.33,2.51,2.69,2.79,2.85,2.89,
 2.91,2.93,2.95,2.98,3.13,3.52,3.74,3.85,3.97,4.37,
 4.69,4.87,4.97,5.31,5.58,5.98,6.76,7.56,8.54,9.55,
 11.56,13.71};
static float alpha05_nx064_nz22_fwhm125[32] = {
 2.28,2.52,2.65,2.76,2.83,2.88,2.93,2.97,3.00,3.27,
 3.47,3.60,3.70,3.86,3.95,4.26,4.66,4.86,5.37,5.78,
 6.08,6.62,6.92,7.33,7.70,8.77,9.83,11.08,12.76,14.36,
 17.91,21.87};
static float alpha05_nx064_nz22_fwhm150[32] = {
 2.86,2.92,2.97,3.15,3.47,3.67,3.87,3.98,4.28,4.54,
 4.72,4.83,4.92,5.42,5.80,6.21,6.81,7.32,8.15,9.00,
 9.81,10.49,11.19,11.87,12.58,14.39,16.26,18.87,22.13,25.50,
 33.56,42.59};
static float alpha05_nx064_nz22_fwhm175[32] = {
 3.85,4.09,4.46,4.74,4.95,5.28,5.78,6.17,6.64,6.95,
 7.33,7.67,7.89,8.73,9.39,10.21,11.11,11.97,13.60,14.96,
 16.49,17.86,19.27,20.55,21.73,25.46,29.21,34.29,40.52,47.15,
 61.75,81.11};
static float alpha05_nx064_nz22_fwhm200[32] = {
 5.81,6.28,6.72,7.15,7.73,8.19,8.95,9.69,10.32,10.90,
 11.43,11.94,12.45,13.68,14.73,16.19,17.75,19.28,22.14,24.57,
 26.88,29.27,31.25,33.42,35.37,41.55,47.30,55.22,65.62,77.84,
 104.91,140.19};
static float alpha05_nx064_nz22_fwhm225[32] = {
 8.29,8.90,9.62,10.32,11.01,11.74,12.88,13.96,14.95,15.82,
 16.55,17.37,18.14,20.15,21.85,23.87,26.00,28.24,32.04,35.78,
 39.04,42.33,45.32,48.51,51.11,59.63,68.78,82.05,98.85,117.83,
 159.00,209.73};
static float alpha05_nx064_nz22_fwhm250[32] = {
 10.94,11.93,12.77,13.76,14.86,15.87,17.54,18.85,20.14,21.41,
 22.54,23.48,24.48,26.89,29.28,31.98,35.20,37.83,43.13,47.74,
 52.17,56.56,61.11,65.12,69.48,82.11,94.96,111.74,134.88,160.62,
 216.75,287.82};
static float alpha05_nx064_nz22_fwhm275[32] = {
 13.87,15.15,16.19,17.45,18.88,19.98,22.25,23.94,25.58,26.98,
 28.32,29.82,31.13,34.38,37.04,40.48,44.44,48.20,54.98,61.05,
 67.26,73.06,78.64,84.60,90.20,106.09,122.20,144.86,174.30,206.17,
 279.33,365.80};
static float alpha05_nx064_nz22_fwhm300[32] = {
 16.78,18.33,19.73,21.37,23.10,24.51,27.04,29.45,31.42,33.28,
 34.88,36.54,37.89,41.80,45.30,49.86,54.72,59.64,67.58,75.98,
 84.00,91.57,98.38,104.95,111.61,131.00,151.62,179.20,214.75,253.17,
 341.20,450.67};
static float alpha05_nx064_nz22_fwhm325[32] = {
 19.86,21.86,23.38,25.30,27.18,28.93,32.40,34.81,37.30,39.42,
 41.44,43.27,44.98,49.96,54.36,59.86,66.55,72.55,82.54,92.26,
 101.35,109.45,117.50,125.50,133.25,158.75,182.54,216.14,258.07,302.67,
 406.50,532.75};
static float alpha05_nx064_nz22_fwhm350[32] = {
 22.89,24.95,27.04,29.36,31.65,33.78,37.32,40.35,43.21,45.75,
 48.20,50.29,52.45,58.87,64.57,70.97,78.36,84.70,97.19,107.96,
 118.18,127.60,137.88,148.71,158.50,186.86,214.95,251.93,301.17,352.37,
 474.67,620.20};
static float alpha05_nx064_nz22_fwhm375[32] = {
 25.75,28.48,30.73,33.53,36.00,38.52,42.98,46.73,50.09,53.27,
 56.00,59.02,61.20,67.97,74.42,81.84,89.94,97.69,112.10,124.69,
 137.44,149.89,161.88,173.50,185.21,217.33,248.64,290.91,346.44,408.40,
 544.29,709.60};
static float alpha05_nx064_nz22_fwhm400[32] = {
 29.12,32.20,34.38,37.29,40.57,43.53,48.72,52.88,56.74,60.28,
 63.38,66.55,69.03,77.37,84.53,92.58,102.70,111.86,128.56,143.83,
 157.86,171.50,184.81,197.64,211.18,247.10,282.71,332.00,396.62,465.60,
 617.60,797.86};
static float alpha05_nx064_nz22_fwhm425[32] = {
 32.02,35.28,38.09,41.66,45.68,48.79,54.15,58.74,63.33,67.26,
 71.00,74.86,78.14,87.29,95.35,104.76,116.59,126.74,144.91,161.75,
 177.65,192.89,207.92,222.25,236.56,278.67,319.11,375.78,447.62,524.25,
 691.00,887.67};
static float alpha05_nx064_nz22_fwhm450[32] = {
 35.03,38.79,42.33,45.74,49.67,53.24,59.84,65.58,70.81,75.37,
 79.67,83.35,87.35,97.41,107.08,117.79,130.11,141.42,161.07,180.10,
 197.71,215.56,232.00,248.71,265.36,312.33,357.67,420.71,499.71,585.14,
 766.00,981.50};
static float alpha05_nx064_nz22_fwhm475[32] = {
 38.08,42.05,45.73,49.91,54.40,59.00,66.25,72.83,78.11,82.83,
 87.90,92.33,95.97,108.14,117.78,130.50,143.73,155.27,177.60,198.12,
 219.17,239.27,258.07,276.10,293.56,345.43,394.80,464.60,554.00,643.33,
 845.00,1072.40};
static float alpha05_nx064_nz22_fwhm500[32] = {
 40.70,45.29,49.53,54.24,59.38,64.06,72.43,79.40,85.36,90.75,
 96.20,101.07,106.47,118.40,129.38,142.62,157.22,170.00,195.08,218.80,
 241.29,263.50,282.75,302.20,323.00,379.75,436.40,510.50,605.00,704.71,
 916.00,1174.33};
static float *alpha05_nx064_nz22[21] = {
 alpha05_nx064_nz22_fwhm000, alpha05_nx064_nz22_fwhm025, alpha05_nx064_nz22_fwhm050, 
 alpha05_nx064_nz22_fwhm075, alpha05_nx064_nz22_fwhm100, alpha05_nx064_nz22_fwhm125, 
 alpha05_nx064_nz22_fwhm150, alpha05_nx064_nz22_fwhm175, alpha05_nx064_nz22_fwhm200, 
 alpha05_nx064_nz22_fwhm225, alpha05_nx064_nz22_fwhm250, alpha05_nx064_nz22_fwhm275, 
 alpha05_nx064_nz22_fwhm300, alpha05_nx064_nz22_fwhm325, alpha05_nx064_nz22_fwhm350, 
 alpha05_nx064_nz22_fwhm375, alpha05_nx064_nz22_fwhm400, alpha05_nx064_nz22_fwhm425, 
 alpha05_nx064_nz22_fwhm450, alpha05_nx064_nz22_fwhm475, alpha05_nx064_nz22_fwhm500} ;

static float alpha10_nx064_nz22_fwhm000[32] = {
 1.90,1.90,1.90,1.91,1.91,1.92,1.93,1.95,1.97,2.00,
 2.18,2.33,2.45,2.66,2.76,2.83,2.88,2.91,2.96,3.13,
 3.49,3.68,3.78,3.86,3.91,4.25,4.70,4.96,5.64,5.98,
 7.08,8.28};
static float alpha10_nx064_nz22_fwhm025[32] = {
 1.90,1.90,1.90,1.91,1.91,1.92,1.93,1.95,1.97,2.00,
 2.18,2.33,2.45,2.66,2.76,2.83,2.88,2.91,2.96,3.13,
 3.49,3.68,3.78,3.86,3.91,4.25,4.70,4.96,5.64,5.98,
 7.08,8.28};
static float alpha10_nx064_nz22_fwhm050[32] = {
 1.90,1.90,1.91,1.91,1.91,1.92,1.93,1.95,1.98,2.07,
 2.26,2.40,2.51,2.69,2.78,2.84,2.89,2.92,2.97,3.26,
 3.56,3.72,3.82,3.89,3.93,4.40,4.77,5.02,5.73,6.14,
 7.36,8.56};
static float alpha10_nx064_nz22_fwhm075[32] = {
 1.90,1.91,1.91,1.92,1.92,1.93,1.96,1.99,2.22,2.41,
 2.53,2.62,2.68,2.79,2.85,2.90,2.93,2.96,3.33,3.63,
 3.78,3.87,3.93,3.99,4.31,4.79,4.99,5.68,6.23,6.89,
 8.22,9.69};
static float alpha10_nx064_nz22_fwhm100[32] = {
 1.91,1.92,1.93,1.95,1.97,2.01,2.38,2.57,2.68,2.75,
 2.80,2.83,2.86,2.91,2.95,3.00,3.42,3.63,3.84,3.95,
 4.25,4.59,4.78,4.90,5.00,5.72,6.20,6.92,7.86,8.81,
 10.67,12.68};
static float alpha10_nx064_nz22_fwhm125[32] = {
 1.97,2.01,2.27,2.48,2.62,2.71,2.82,2.87,2.92,2.95,
 2.98,3.12,3.32,3.62,3.78,3.91,4.16,4.53,4.89,5.31,
 5.71,5.95,6.40,6.74,6.97,7.96,8.94,10.13,11.70,13.20,
 16.48,20.15};
static float alpha10_nx064_nz22_fwhm150[32] = {
 2.64,2.76,2.83,2.91,2.97,3.18,3.55,3.75,3.87,3.97,
 4.18,4.40,4.56,4.87,5.22,5.70,6.12,6.65,7.44,8.10,
 8.86,9.52,10.15,10.79,11.41,13.05,14.80,17.15,20.11,23.29,
 30.33,38.33};
static float alpha10_nx064_nz22_fwhm175[32] = {
 3.35,3.66,3.85,4.07,4.46,4.69,4.99,5.49,5.82,6.15,
 6.50,6.76,6.96,7.76,8.38,9.08,9.97,10.77,12.17,13.52,
 14.74,15.98,17.15,18.30,19.52,22.67,26.19,30.69,36.46,42.59,
 55.89,71.87};
static float alpha10_nx064_nz22_fwhm200[32] = {
 4.82,5.22,5.66,6.08,6.66,7.00,7.81,8.43,8.92,9.51,
 9.95,10.44,10.86,11.91,12.99,14.20,15.65,16.96,19.50,21.72,
 23.85,25.71,27.63,29.65,31.59,37.02,42.51,49.77,59.05,69.35,
 94.24,124.29};
static float alpha10_nx064_nz22_fwhm225[32] = {
 6.90,7.56,8.11,8.74,9.39,10.02,11.04,11.99,12.85,13.64,
 14.32,15.00,15.62,17.27,18.82,20.70,22.77,24.74,28.36,31.54,
 34.70,37.70,40.48,43.17,45.84,53.68,61.47,72.74,87.26,104.39,
 141.36,185.97};
static float alpha10_nx064_nz22_fwhm250[32] = {
 8.96,9.90,10.66,11.52,12.44,13.25,14.71,16.13,17.19,18.16,
 19.19,19.96,20.86,23.24,25.28,27.73,30.58,33.29,37.92,42.30,
 46.25,50.09,53.98,57.78,61.47,72.30,83.90,99.53,119.84,141.92,
 191.22,251.83};
static float alpha10_nx064_nz22_fwhm275[32] = {
 11.14,12.32,13.23,14.41,15.60,16.69,18.69,20.29,21.73,22.98,
 24.32,25.48,26.58,29.50,32.22,35.36,38.82,41.92,47.97,53.46,
 59.00,63.83,68.82,74.14,78.89,93.25,107.52,127.42,153.54,181.45,
 243.23,320.75};
static float alpha10_nx064_nz22_fwhm300[32] = {
 13.46,14.85,15.98,17.33,18.83,20.28,22.79,24.64,26.43,28.05,
 29.60,31.05,32.36,35.95,38.86,42.90,47.17,51.26,58.93,66.17,
 72.58,78.96,85.22,91.20,97.56,114.68,132.81,157.53,188.82,221.65,
 298.84,390.75};
static float alpha10_nx064_nz22_fwhm325[32] = {
 15.70,17.29,18.74,20.45,22.34,23.79,26.57,29.03,31.30,33.30,
 34.94,36.53,38.22,42.67,46.48,51.09,56.29,61.52,70.75,79.11,
 87.04,94.36,102.07,109.45,116.07,138.03,159.07,188.33,225.46,263.89,
 354.08,460.43};
static float alpha10_nx064_nz22_fwhm350[32] = {
 18.06,19.97,21.57,23.46,25.63,27.52,30.77,33.60,35.99,38.41,
 40.63,42.67,44.36,49.49,53.95,59.66,65.97,71.85,82.75,92.60,
 101.51,110.78,119.51,127.89,136.57,162.06,188.12,220.33,262.47,308.65,
 411.86,534.00};
static float alpha10_nx064_nz22_fwhm375[32] = {
 20.04,22.30,24.21,26.43,28.85,30.94,34.95,38.16,41.20,43.75,
 46.24,48.45,50.36,56.67,62.10,68.67,75.69,82.58,95.04,106.91,
 118.00,128.42,138.47,148.65,158.84,187.29,215.35,252.88,301.25,355.00,
 470.82,608.00};
static float alpha10_nx064_nz22_fwhm400[32] = {
 22.19,24.53,26.70,29.19,32.22,34.69,39.23,43.00,46.36,49.19,
 51.86,54.72,57.38,64.31,70.29,77.66,86.03,94.14,108.88,121.87,
 134.28,146.38,158.35,169.13,179.97,212.40,244.75,285.81,341.50,403.44,
 533.88,683.12};
static float alpha10_nx064_nz22_fwhm425[32] = {
 23.86,26.89,29.40,32.43,35.77,38.59,43.75,47.75,51.40,54.98,
 58.47,61.43,64.10,71.71,79.14,87.15,97.14,106.52,122.37,137.80,
 152.04,165.15,178.10,190.44,201.88,238.41,272.47,320.67,384.62,451.78,
 595.25,757.29};
static float alpha10_nx064_nz22_fwhm450[32] = {
 26.00,29.22,32.02,35.47,39.22,42.34,47.94,52.66,56.92,60.54,
 63.71,67.23,70.47,79.67,87.63,97.17,108.79,118.45,136.72,153.73,
 168.67,183.84,197.50,211.48,225.00,265.23,304.93,360.17,428.92,501.38,
 657.00,833.50};
static float alpha10_nx064_nz22_fwhm475[32] = {
 27.79,31.50,34.66,38.50,42.37,45.95,52.11,57.20,61.52,65.81,
 70.31,74.34,77.68,87.31,96.40,107.33,119.66,130.44,151.13,168.86,
 185.92,202.88,218.57,233.60,247.95,292.00,336.90,397.42,472.29,551.60,
 717.33,913.50};
static float alpha10_nx064_nz22_fwhm500[32] = {
 29.58,33.62,36.98,41.09,45.38,49.19,55.51,61.50,66.98,71.39,
 76.26,80.40,84.34,95.61,105.89,117.20,130.52,143.00,164.00,184.80,
 203.35,222.06,239.76,256.14,272.00,320.44,369.78,434.67,514.40,601.88,
 779.38,994.40};
static float *alpha10_nx064_nz22[21] = {
 alpha10_nx064_nz22_fwhm000, alpha10_nx064_nz22_fwhm025, alpha10_nx064_nz22_fwhm050, 
 alpha10_nx064_nz22_fwhm075, alpha10_nx064_nz22_fwhm100, alpha10_nx064_nz22_fwhm125, 
 alpha10_nx064_nz22_fwhm150, alpha10_nx064_nz22_fwhm175, alpha10_nx064_nz22_fwhm200, 
 alpha10_nx064_nz22_fwhm225, alpha10_nx064_nz22_fwhm250, alpha10_nx064_nz22_fwhm275, 
 alpha10_nx064_nz22_fwhm300, alpha10_nx064_nz22_fwhm325, alpha10_nx064_nz22_fwhm350, 
 alpha10_nx064_nz22_fwhm375, alpha10_nx064_nz22_fwhm400, alpha10_nx064_nz22_fwhm425, 
 alpha10_nx064_nz22_fwhm450, alpha10_nx064_nz22_fwhm475, alpha10_nx064_nz22_fwhm500} ;

static float **nx064_nz22[3] = {
  alpha01_nx064_nz22 , alpha05_nx064_nz22 , alpha10_nx064_nz22 };

static float alpha01_nx064_nz23_fwhm000[32] = {
 1.99,1.99,2.00,2.00,2.17,2.44,2.69,2.80,2.86,2.90,
 2.92,2.94,2.95,2.97,2.98,3.00,3.29,3.64,3.86,3.94,
 3.99,4.35,4.62,4.78,4.87,5.15,5.75,6.02,6.83,7.51,
 8.80,10.23};
static float alpha01_nx064_nz23_fwhm025[32] = {
 1.99,1.99,2.00,2.00,2.17,2.44,2.69,2.80,2.86,2.90,
 2.92,2.94,2.95,2.97,2.98,3.00,3.30,3.64,3.86,3.94,
 3.99,4.35,4.62,4.78,4.87,5.15,5.75,6.03,6.83,7.51,
 8.80,10.23};
static float alpha01_nx064_nz23_fwhm050[32] = {
 1.99,1.99,2.00,2.00,2.29,2.53,2.73,2.82,2.87,2.91,
 2.93,2.95,2.96,2.98,2.99,3.00,3.45,3.71,3.89,3.96,
 4.00,4.49,4.71,4.83,4.91,5.32,5.84,6.34,6.91,7.75,
 8.93,10.61};
static float alpha01_nx064_nz23_fwhm075[32] = {
 1.99,2.00,2.12,2.44,2.63,2.74,2.84,2.90,2.93,2.95,
 2.96,2.97,2.98,2.99,3.12,3.54,3.78,3.88,3.97,4.30,
 4.67,4.83,4.93,4.99,5.26,5.88,6.31,6.91,7.78,8.56,
 10.20,11.99};
static float alpha01_nx064_nz23_fwhm100[32] = {
 2.42,2.63,2.73,2.82,2.88,2.91,2.95,2.97,2.99,2.99,
 3.07,3.31,3.46,3.73,3.85,3.94,4.05,4.49,4.82,4.96,
 5.34,5.72,5.91,6.01,6.42,7.05,7.81,8.72,9.81,10.93,
 13.39,16.18};
static float alpha01_nx064_nz23_fwhm125[32] = {
 2.88,2.92,2.95,2.97,2.99,3.00,3.55,3.72,3.84,3.91,
 3.96,3.98,4.15,4.62,4.83,4.97,5.51,5.81,6.28,6.82,
 7.22,7.75,8.09,8.64,8.95,10.31,11.57,13.02,14.94,16.94,
 21.72,26.38};
static float alpha01_nx064_nz23_fwhm150[32] = {
 3.45,3.70,3.86,3.97,4.21,4.51,4.83,4.97,5.30,5.60,
 5.78,5.92,6.07,6.72,6.99,7.68,8.20,8.82,9.99,10.96,
 11.84,12.70,13.57,14.37,14.94,17.43,19.77,22.76,27.13,31.25,
 40.39,51.81};
static float alpha01_nx064_nz23_fwhm175[32] = {
 4.98,5.56,5.88,6.23,6.64,6.92,7.62,7.97,8.70,9.02,
 9.42,9.70,9.95,10.85,11.73,12.78,13.78,14.76,16.82,18.60,
 20.60,22.18,23.75,25.74,27.08,31.52,36.05,41.93,50.33,58.00,
 78.92,100.70};
static float alpha01_nx064_nz23_fwhm200[32] = {
 8.02,8.58,8.96,9.60,10.26,10.84,11.74,12.48,13.36,13.93,
 14.65,15.18,15.73,17.58,18.95,20.62,22.97,24.72,28.08,31.39,
 34.17,36.76,39.21,42.00,45.07,51.89,60.42,71.18,85.18,98.50,
 133.75,178.33};
static float alpha01_nx064_nz23_fwhm225[32] = {
 11.63,12.33,13.00,13.91,14.98,16.06,17.47,18.64,19.65,20.73,
 21.88,23.09,23.85,26.46,28.53,31.18,34.32,37.17,41.73,46.24,
 50.29,54.91,58.58,62.89,66.71,78.88,89.57,105.80,127.00,149.40,
 205.60,265.50};
static float alpha01_nx064_nz23_fwhm250[32] = {
 15.79,17.07,18.10,19.72,20.74,21.94,24.25,26.12,27.76,29.11,
 30.50,31.57,32.58,36.32,39.40,42.86,46.27,49.92,56.50,63.10,
 69.00,74.93,81.33,87.12,92.14,106.62,121.50,144.67,175.00,206.50,
 274.83,365.33};
static float alpha01_nx064_nz23_fwhm275[32] = {
 20.63,22.57,23.60,25.05,26.86,28.61,31.18,33.80,36.07,38.12,
 39.78,41.50,42.93,47.33,50.89,55.44,60.78,65.33,75.00,82.20,
 89.83,97.82,104.60,110.77,116.83,138.00,158.83,191.00,225.00,267.67,
 355.25,481.00};
static float alpha01_nx064_nz23_fwhm300[32] = {
 25.88,28.00,29.27,31.57,34.00,35.93,39.80,42.50,45.21,47.72,
 49.93,51.64,52.83,58.73,63.27,69.00,75.57,81.60,92.09,102.00,
 112.71,121.00,129.60,139.33,147.50,173.50,200.50,234.00,275.00,331.00,
 443.00,575.00};
static float alpha01_nx064_nz23_fwhm325[32] = {
 31.25,34.11,35.84,38.47,41.45,43.47,47.46,50.70,54.14,57.22,
 59.80,62.44,63.90,71.12,77.00,84.50,91.60,98.70,111.00,124.55,
 136.14,147.00,158.50,170.25,179.57,207.00,238.50,281.00,340.00,395.50,
 535.00,704.00};
static float alpha01_nx064_nz23_fwhm350[32] = {
 36.31,39.77,42.40,44.53,47.82,50.67,55.56,60.00,63.62,67.00,
 70.00,73.73,76.12,84.00,90.70,98.29,108.17,115.44,132.60,147.00,
 162.00,174.50,186.75,199.00,210.50,245.33,282.00,334.00,396.67,466.00,
 627.67,834.00};
static float alpha01_nx064_nz23_fwhm375[32] = {
 42.42,46.00,48.46,51.64,55.25,59.08,65.56,70.62,74.73,78.36,
 81.62,85.67,89.00,97.43,105.60,116.00,126.17,136.20,155.40,172.00,
 184.86,199.80,216.00,228.86,243.00,283.67,326.00,385.67,457.00,537.00,
 733.00,952.25};
static float alpha01_nx064_nz23_fwhm400[32] = {
 48.33,52.20,55.78,60.23,64.80,68.75,74.67,80.30,85.88,89.88,
 94.00,98.50,102.12,113.71,122.30,132.83,145.00,156.80,177.00,195.25,
 211.83,229.75,244.75,263.00,277.86,323.75,369.67,437.50,528.67,614.00,
 816.00,1068.00};
static float alpha01_nx064_nz23_fwhm425[32] = {
 55.33,59.62,63.00,67.38,73.11,77.25,84.40,91.25,96.33,101.33,
 107.25,112.12,116.38,128.25,137.00,149.67,163.60,177.17,201.12,220.60,
 240.50,262.00,282.50,299.17,316.33,367.25,420.00,492.33,591.00,687.00,
 929.00,1213.00};
static float alpha01_nx064_nz23_fwhm450[32] = {
 61.44,66.00,71.08,76.50,82.50,86.25,93.75,100.83,108.33,115.00,
 120.75,125.33,129.20,141.75,153.00,166.50,181.43,198.00,224.00,247.60,
 270.40,294.33,316.00,335.50,355.00,414.50,473.50,551.83,656.00,775.00,
 1034.67,1354.00};
static float alpha01_nx064_nz23_fwhm475[32] = {
 67.62,74.20,80.00,84.00,90.17,94.33,104.11,112.00,119.60,126.20,
 132.17,137.00,141.00,158.00,170.25,187.25,202.75,218.60,247.00,277.00,
 301.86,327.00,348.00,370.00,391.50,463.00,519.00,613.50,720.00,864.67,
 1142.00,1461.50};
static float alpha01_nx064_nz23_fwhm500[32] = {
 74.33,80.60,86.20,92.14,98.50,103.83,114.75,122.50,131.00,137.40,
 145.00,151.71,159.00,174.75,189.50,203.80,221.00,239.20,275.50,307.00,
 330.50,357.00,383.00,412.00,436.50,507.00,565.00,673.50,809.00,951.00,
 1260.00,1610.00};
static float *alpha01_nx064_nz23[21] = {
 alpha01_nx064_nz23_fwhm000, alpha01_nx064_nz23_fwhm025, alpha01_nx064_nz23_fwhm050, 
 alpha01_nx064_nz23_fwhm075, alpha01_nx064_nz23_fwhm100, alpha01_nx064_nz23_fwhm125, 
 alpha01_nx064_nz23_fwhm150, alpha01_nx064_nz23_fwhm175, alpha01_nx064_nz23_fwhm200, 
 alpha01_nx064_nz23_fwhm225, alpha01_nx064_nz23_fwhm250, alpha01_nx064_nz23_fwhm275, 
 alpha01_nx064_nz23_fwhm300, alpha01_nx064_nz23_fwhm325, alpha01_nx064_nz23_fwhm350, 
 alpha01_nx064_nz23_fwhm375, alpha01_nx064_nz23_fwhm400, alpha01_nx064_nz23_fwhm425, 
 alpha01_nx064_nz23_fwhm450, alpha01_nx064_nz23_fwhm475, alpha01_nx064_nz23_fwhm500} ;

static float alpha05_nx064_nz23_fwhm000[32] = {
 1.95,1.95,1.96,1.96,1.96,1.97,1.98,2.00,2.29,2.48,
 2.60,2.68,2.74,2.84,2.89,2.92,2.95,2.97,3.22,3.59,
 3.78,3.87,3.93,3.97,4.06,4.70,4.92,5.46,5.91,6.57,
 7.74,8.87};
static float alpha05_nx064_nz23_fwhm025[32] = {
 1.95,1.95,1.96,1.96,1.96,1.97,1.98,2.00,2.29,2.49,
 2.60,2.68,2.74,2.84,2.89,2.92,2.95,2.97,3.22,3.59,
 3.78,3.87,3.93,3.97,4.06,4.70,4.92,5.46,5.91,6.57,
 7.74,8.87};
static float alpha05_nx064_nz23_fwhm050[32] = {
 1.95,1.95,1.96,1.96,1.96,1.97,1.99,2.12,2.36,2.55,
 2.65,2.72,2.77,2.85,2.90,2.93,2.96,2.98,3.35,3.66,
 3.81,3.90,3.95,3.99,4.26,4.77,4.96,5.60,5.98,6.73,
 7.86,9.08};
static float alpha05_nx064_nz23_fwhm075[32] = {
 1.95,1.96,1.96,1.97,1.98,1.99,2.21,2.48,2.63,2.72,
 2.78,2.82,2.85,2.91,2.94,2.96,2.99,3.30,3.69,3.86,
 3.94,3.99,4.31,4.58,4.73,4.98,5.58,5.96,6.77,7.49,
 8.85,10.41};
static float alpha05_nx064_nz23_fwhm100[32] = {
 1.97,1.98,1.99,2.06,2.36,2.53,2.71,2.80,2.86,2.89,
 2.91,2.93,2.95,2.98,3.13,3.53,3.75,3.87,3.98,4.41,
 4.72,4.87,4.97,5.29,5.60,6.05,6.78,7.57,8.55,9.46,
 11.48,13.74};
static float alpha05_nx064_nz23_fwhm125[32] = {
 2.32,2.54,2.66,2.76,2.83,2.87,2.94,2.97,3.02,3.29,
 3.48,3.61,3.71,3.87,3.97,4.32,4.69,4.89,5.36,5.82,
 6.18,6.64,6.91,7.32,7.70,8.69,9.68,10.95,12.70,14.41,
 18.01,22.20};
static float alpha05_nx064_nz23_fwhm150[32] = {
 2.86,2.93,2.98,3.27,3.53,3.70,3.89,4.01,4.36,4.60,
 4.75,4.87,4.95,5.51,5.85,6.32,6.83,7.31,8.14,8.92,
 9.70,10.40,11.11,11.82,12.55,14.39,16.35,18.97,22.28,25.66,
 33.21,42.11};
static float alpha05_nx064_nz23_fwhm175[32] = {
 3.90,4.17,4.52,4.79,4.97,5.36,5.84,6.27,6.69,6.97,
 7.39,7.70,7.90,8.70,9.34,10.16,11.03,11.90,13.64,15.03,
 16.55,17.80,19.10,20.51,21.78,25.44,28.94,34.22,40.83,47.68,
 63.06,82.38};
static float alpha05_nx064_nz23_fwhm200[32] = {
 5.84,6.40,6.80,7.32,7.82,8.29,9.00,9.75,10.37,10.91,
 11.40,11.86,12.38,13.62,14.79,16.23,17.79,19.39,21.90,24.57,
 27.04,29.12,31.34,33.47,35.66,41.56,47.99,56.91,68.02,80.56,
 107.61,141.46};
static float alpha05_nx064_nz23_fwhm225[32] = {
 8.39,9.03,9.66,10.40,11.21,11.86,13.06,14.11,15.08,15.87,
 16.79,17.47,18.24,20.13,21.80,23.96,26.28,28.63,32.45,35.96,
 39.50,42.87,46.26,49.43,52.31,61.91,71.22,84.66,100.52,119.58,
 162.12,214.77};
static float alpha05_nx064_nz23_fwhm250[32] = {
 11.20,12.31,13.12,14.01,15.17,16.18,17.77,19.25,20.52,21.77,
 22.85,24.00,24.86,27.41,29.62,32.27,35.30,38.24,43.91,48.60,
 53.38,57.72,62.24,66.87,71.16,84.00,97.35,114.91,138.86,164.06,
 220.92,286.71};
static float alpha05_nx064_nz23_fwhm275[32] = {
 14.26,15.51,16.77,18.06,19.47,20.75,22.84,24.65,26.04,27.73,
 29.13,30.42,31.44,34.58,37.64,41.12,45.10,48.97,55.98,62.40,
 68.61,74.83,81.03,86.65,92.63,108.89,125.39,149.33,177.24,209.43,
 277.64,370.25};
static float alpha05_nx064_nz23_fwhm300[32] = {
 17.50,19.04,20.36,22.04,23.65,25.16,27.82,29.83,31.92,33.89,
 35.31,36.88,38.43,42.71,46.67,51.04,56.22,60.98,69.73,78.11,
 85.59,93.24,100.73,107.34,114.67,135.17,155.06,182.94,217.55,258.43,
 344.10,451.20};
static float alpha05_nx064_nz23_fwhm325[32] = {
 20.54,22.40,24.02,26.03,27.89,29.77,32.87,35.80,38.38,40.68,
 42.85,44.84,46.61,51.50,55.85,61.35,67.62,73.45,84.07,94.32,
 104.23,112.67,121.18,129.04,136.81,161.45,186.47,219.25,262.14,308.22,
 411.57,538.50};
static float alpha05_nx064_nz23_fwhm350[32] = {
 23.98,26.04,27.96,30.09,32.70,34.87,39.06,42.14,44.88,47.55,
 50.02,52.22,54.57,60.30,66.00,72.39,79.96,86.90,99.64,110.87,
 122.09,132.15,142.29,151.77,160.94,190.67,218.69,256.70,306.62,359.08,
 476.75,622.89};
static float alpha05_nx064_nz23_fwhm375[32] = {
 27.09,29.74,32.28,34.79,37.56,40.21,44.61,48.34,51.62,54.70,
 57.74,60.40,63.00,70.00,76.12,84.31,93.20,100.79,114.70,128.40,
 140.45,151.88,163.94,174.94,185.07,219.50,251.22,295.67,351.20,410.88,
 551.11,707.25};
static float alpha05_nx064_nz23_fwhm400[32] = {
 30.62,33.76,36.07,39.17,42.56,45.63,50.46,54.57,57.98,61.67,
 65.09,68.61,71.84,79.85,87.31,96.11,105.62,114.74,130.85,145.42,
 159.36,173.21,185.45,198.47,211.62,248.94,286.22,335.50,397.88,464.17,
 620.67,803.50};
static float alpha05_nx064_nz23_fwhm425[32] = {
 33.96,37.03,39.93,43.40,47.28,50.54,56.17,60.88,65.73,70.13,
 74.20,77.55,80.90,89.80,98.06,107.79,118.71,128.95,146.61,164.21,
 179.14,194.44,209.11,224.57,239.22,279.78,323.00,376.38,447.14,523.90,
 698.67,904.33};
static float alpha05_nx064_nz23_fwhm450[32] = {
 36.84,40.97,44.15,47.80,52.13,55.39,62.21,68.08,73.48,78.19,
 82.33,86.19,89.85,100.05,109.24,119.50,131.87,143.29,163.53,181.33,
 200.53,217.18,234.50,250.08,266.20,312.60,359.92,420.33,502.00,587.71,
 778.25,1011.20};
static float alpha05_nx064_nz23_fwhm475[32] = {
 39.89,44.13,48.06,52.29,57.04,61.27,68.52,74.61,79.97,85.75,
 90.35,94.58,98.90,110.00,120.40,132.59,144.88,157.17,179.79,201.29,
 221.67,241.18,259.33,276.50,293.70,346.50,397.40,465.33,555.50,646.60,
 859.83,1098.20};
static float alpha05_nx064_nz23_fwhm500[32] = {
 43.15,48.20,52.03,56.91,61.71,65.96,74.00,80.57,86.89,92.64,
 97.94,102.70,107.67,121.00,131.29,143.38,159.08,172.10,198.74,222.00,
 243.75,264.80,284.00,303.23,321.36,380.40,435.17,513.80,608.00,707.17,
 939.60,1204.00};
static float *alpha05_nx064_nz23[21] = {
 alpha05_nx064_nz23_fwhm000, alpha05_nx064_nz23_fwhm025, alpha05_nx064_nz23_fwhm050, 
 alpha05_nx064_nz23_fwhm075, alpha05_nx064_nz23_fwhm100, alpha05_nx064_nz23_fwhm125, 
 alpha05_nx064_nz23_fwhm150, alpha05_nx064_nz23_fwhm175, alpha05_nx064_nz23_fwhm200, 
 alpha05_nx064_nz23_fwhm225, alpha05_nx064_nz23_fwhm250, alpha05_nx064_nz23_fwhm275, 
 alpha05_nx064_nz23_fwhm300, alpha05_nx064_nz23_fwhm325, alpha05_nx064_nz23_fwhm350, 
 alpha05_nx064_nz23_fwhm375, alpha05_nx064_nz23_fwhm400, alpha05_nx064_nz23_fwhm425, 
 alpha05_nx064_nz23_fwhm450, alpha05_nx064_nz23_fwhm475, alpha05_nx064_nz23_fwhm500} ;

static float alpha10_nx064_nz23_fwhm000[32] = {
 1.90,1.90,1.90,1.91,1.91,1.92,1.93,1.95,1.97,2.00,
 2.20,2.36,2.47,2.67,2.77,2.84,2.88,2.91,2.96,3.15,
 3.52,3.70,3.80,3.87,3.92,4.32,4.72,4.96,5.64,5.98,
 7.15,8.33};
static float alpha10_nx064_nz23_fwhm025[32] = {
 1.90,1.90,1.90,1.91,1.91,1.92,1.93,1.95,1.97,2.00,
 2.20,2.36,2.47,2.67,2.77,2.84,2.88,2.91,2.96,3.15,
 3.52,3.70,3.80,3.87,3.92,4.32,4.72,4.96,5.64,5.98,
 7.15,8.33};
static float alpha10_nx064_nz23_fwhm050[32] = {
 1.90,1.90,1.91,1.91,1.91,1.92,1.93,1.95,1.98,2.10,
 2.29,2.43,2.53,2.70,2.79,2.85,2.89,2.92,2.97,3.28,
 3.59,3.74,3.83,3.89,3.94,4.45,4.78,5.06,5.75,6.21,
 7.38,8.58};
static float alpha10_nx064_nz23_fwhm075[32] = {
 1.90,1.91,1.91,1.92,1.92,1.94,1.96,2.00,2.26,2.44,
 2.56,2.63,2.69,2.80,2.85,2.89,2.93,2.97,3.34,3.66,
 3.80,3.89,3.95,4.07,4.36,4.80,5.00,5.71,6.27,6.91,
 8.25,9.70};
static float alpha10_nx064_nz23_fwhm100[32] = {
 1.92,1.92,1.93,1.95,1.98,2.06,2.41,2.58,2.69,2.76,
 2.80,2.83,2.86,2.91,2.95,3.01,3.43,3.66,3.86,3.96,
 4.32,4.61,4.78,4.90,5.02,5.76,6.25,6.94,7.88,8.76,
 10.66,12.74};
static float alpha10_nx064_nz23_fwhm125[32] = {
 1.97,2.05,2.30,2.49,2.63,2.72,2.82,2.88,2.92,2.96,
 2.99,3.14,3.32,3.64,3.80,3.93,4.21,4.57,4.90,5.37,
 5.76,5.99,6.45,6.77,7.00,7.92,8.87,10.03,11.66,13.19,
 16.57,20.38};
static float alpha10_nx064_nz23_fwhm150[32] = {
 2.65,2.77,2.85,2.93,2.99,3.24,3.59,3.77,3.90,3.98,
 4.23,4.44,4.60,4.90,5.27,5.74,6.19,6.67,7.45,8.04,
 8.78,9.44,10.04,10.73,11.37,13.08,14.84,17.29,20.29,23.35,
 30.22,38.01};
static float alpha10_nx064_nz23_fwhm175[32] = {
 3.41,3.69,3.88,4.12,4.49,4.73,5.04,5.56,5.87,6.19,
 6.53,6.78,6.97,7.75,8.36,9.06,9.92,10.74,12.22,13.56,
 14.84,16.17,17.28,18.37,19.56,22.85,26.04,30.77,36.50,42.84,
 57.16,73.78};
static float alpha10_nx064_nz23_fwhm200[32] = {
 4.89,5.38,5.76,6.22,6.71,7.10,7.87,8.49,8.97,9.57,
 9.97,10.48,10.86,11.95,13.10,14.36,15.74,17.08,19.55,21.76,
 23.82,25.91,27.88,29.73,31.74,37.27,43.15,50.97,61.00,71.50,
 95.98,125.80};
static float alpha10_nx064_nz23_fwhm225[32] = {
 6.94,7.64,8.15,8.80,9.48,10.09,11.15,12.11,12.93,13.74,
 14.43,15.06,15.73,17.48,18.98,20.80,22.92,25.02,28.65,31.84,
 34.96,37.87,40.96,43.80,46.70,54.87,63.10,74.85,89.73,106.22,
 143.05,188.97};
static float alpha10_nx064_nz23_fwhm250[32] = {
 9.12,9.99,10.75,11.68,12.60,13.49,14.93,16.30,17.37,18.37,
 19.45,20.32,21.14,23.52,25.58,28.23,30.99,33.58,38.36,42.94,
 47.13,51.19,55.07,59.04,62.72,74.10,85.67,101.35,121.49,143.82,
 194.24,255.36};
static float alpha10_nx064_nz23_fwhm275[32] = {
 11.50,12.62,13.61,14.73,15.90,16.92,18.87,20.67,22.13,23.41,
 24.62,25.82,26.85,29.98,32.52,35.76,39.29,42.68,48.77,54.60,
 59.92,65.44,70.78,75.61,80.48,95.11,109.85,129.91,155.17,184.31,
 246.12,323.24};
static float alpha10_nx064_nz23_fwhm300[32] = {
 13.69,15.06,16.27,17.78,19.38,20.73,23.14,25.06,26.87,28.44,
 29.96,31.41,32.87,36.45,39.76,43.68,48.03,52.33,60.18,67.22,
 73.78,80.62,86.92,93.30,99.42,117.68,135.77,159.90,190.42,223.88,
 299.39,393.89};
static float alpha10_nx064_nz23_fwhm325[32] = {
 16.03,17.78,19.27,20.95,22.79,24.37,27.38,29.87,31.89,33.84,
 35.62,37.19,38.82,43.31,47.34,52.14,57.61,62.63,72.07,80.57,
 88.78,96.73,104.53,111.93,118.92,140.82,161.39,190.59,227.28,267.00,
 357.88,469.62};
static float alpha10_nx064_nz23_fwhm350[32] = {
 18.52,20.35,22.22,24.24,26.41,28.17,31.73,34.50,36.96,39.31,
 41.56,43.69,45.60,50.55,55.51,61.32,67.69,73.60,84.39,94.82,
 104.42,113.65,122.18,131.06,139.10,163.75,189.18,221.79,266.00,311.17,
 417.36,542.30};
static float alpha10_nx064_nz23_fwhm375[32] = {
 20.87,23.23,25.05,27.38,29.91,32.25,36.05,39.32,42.26,44.94,
 47.75,50.28,52.38,58.41,63.76,70.30,78.07,85.14,97.57,109.50,
 120.26,130.48,140.26,149.75,159.42,188.61,216.89,255.80,304.95,356.67,
 478.07,618.75};
static float alpha10_nx064_nz23_fwhm400[32] = {
 23.08,25.62,27.89,30.62,33.57,36.03,40.29,44.37,47.78,50.84,
 53.76,56.46,59.26,66.33,72.54,80.07,88.68,96.42,110.29,123.91,
 136.03,147.48,158.52,170.29,181.16,214.95,246.79,290.31,344.50,406.06,
 539.60,697.10};
static float alpha10_nx064_nz23_fwhm425[32] = {
 25.25,28.14,30.79,33.60,36.81,39.74,44.92,49.25,53.20,56.75,
 59.93,63.16,65.81,74.00,81.12,89.55,98.74,107.29,123.71,138.68,
 152.21,165.77,179.00,192.60,204.46,241.43,277.33,324.36,388.73,454.10,
 601.17,776.50};
static float alpha10_nx064_nz23_fwhm450[32] = {
 26.90,30.26,33.25,36.61,40.30,43.64,49.57,54.00,58.53,62.33,
 65.88,69.37,72.57,81.39,88.73,97.87,109.08,119.04,137.54,154.00,
 170.03,184.75,199.57,213.06,227.82,268.94,308.00,362.17,432.89,503.29,
 667.33,853.80};
static float alpha10_nx064_nz23_fwhm475[32] = {
 28.74,32.38,35.75,39.63,43.75,46.94,53.40,58.49,63.49,67.95,
 71.97,75.86,79.26,88.66,97.17,107.71,120.00,130.86,151.07,170.09,
 187.19,204.00,219.47,236.63,251.80,296.69,341.00,398.60,475.00,555.00,
 735.33,933.60};
static float alpha10_nx064_nz23_fwhm500[32] = {
 30.40,34.69,38.27,42.32,46.48,50.47,57.32,63.44,68.85,73.63,
 78.14,82.33,86.00,96.60,105.74,117.30,131.11,143.43,164.91,185.65,
 204.90,223.90,241.40,258.86,275.70,324.33,372.89,437.23,518.00,609.56,
 801.40,1025.40};
static float *alpha10_nx064_nz23[21] = {
 alpha10_nx064_nz23_fwhm000, alpha10_nx064_nz23_fwhm025, alpha10_nx064_nz23_fwhm050, 
 alpha10_nx064_nz23_fwhm075, alpha10_nx064_nz23_fwhm100, alpha10_nx064_nz23_fwhm125, 
 alpha10_nx064_nz23_fwhm150, alpha10_nx064_nz23_fwhm175, alpha10_nx064_nz23_fwhm200, 
 alpha10_nx064_nz23_fwhm225, alpha10_nx064_nz23_fwhm250, alpha10_nx064_nz23_fwhm275, 
 alpha10_nx064_nz23_fwhm300, alpha10_nx064_nz23_fwhm325, alpha10_nx064_nz23_fwhm350, 
 alpha10_nx064_nz23_fwhm375, alpha10_nx064_nz23_fwhm400, alpha10_nx064_nz23_fwhm425, 
 alpha10_nx064_nz23_fwhm450, alpha10_nx064_nz23_fwhm475, alpha10_nx064_nz23_fwhm500} ;

static float **nx064_nz23[3] = {
  alpha01_nx064_nz23 , alpha05_nx064_nz23 , alpha10_nx064_nz23 };

static float alpha01_nx064_nz24_fwhm000[32] = {
 1.99,1.99,2.00,2.00,2.32,2.52,2.72,2.82,2.87,2.91,
 2.93,2.94,2.95,2.97,2.98,3.00,3.35,3.64,3.86,3.94,
 3.99,4.29,4.62,4.77,4.87,5.10,5.75,6.17,6.90,7.65,
 8.91,10.47};
static float alpha01_nx064_nz24_fwhm025[32] = {
 1.99,1.99,2.00,2.00,2.32,2.52,2.72,2.82,2.87,2.91,
 2.93,2.94,2.95,2.97,2.98,3.00,3.35,3.64,3.86,3.94,
 3.99,4.29,4.62,4.77,4.87,5.10,5.76,6.17,6.90,7.65,
 8.91,10.47};
static float alpha01_nx064_nz24_fwhm050[32] = {
 1.99,1.99,2.00,2.06,2.42,2.57,2.74,2.84,2.89,2.92,
 2.94,2.95,2.96,2.98,2.99,3.00,3.45,3.72,3.89,3.96,
 4.00,4.46,4.69,4.82,4.90,5.37,5.84,6.41,6.95,7.78,
 9.16,10.75};
static float alpha01_nx064_nz24_fwhm075[32] = {
 1.99,2.00,2.19,2.48,2.64,2.75,2.86,2.91,2.93,2.95,
 2.96,2.97,2.98,2.99,3.02,3.57,3.79,3.88,3.97,4.24,
 4.64,4.81,4.92,4.99,5.31,5.89,6.32,6.96,7.87,8.69,
 10.43,12.06};
static float alpha01_nx064_nz24_fwhm100[32] = {
 2.35,2.60,2.74,2.83,2.88,2.92,2.95,2.97,2.98,2.99,
 3.00,3.24,3.40,3.72,3.86,3.94,3.99,4.37,4.80,4.98,
 5.48,5.77,5.93,6.08,6.50,7.23,7.89,8.83,9.94,11.21,
 13.55,16.07};
static float alpha01_nx064_nz24_fwhm125[32] = {
 2.88,2.92,2.95,2.97,2.99,3.12,3.56,3.73,3.83,3.90,
 3.94,3.98,4.10,4.62,4.87,4.98,5.52,5.82,6.40,6.82,
 7.34,7.86,8.21,8.73,8.95,10.15,11.48,13.05,14.93,17.17,
 21.58,27.00};
static float alpha01_nx064_nz24_fwhm150[32] = {
 3.47,3.74,3.86,3.97,4.30,4.58,4.88,4.99,5.39,5.68,
 5.84,5.95,6.19,6.70,7.01,7.69,8.26,8.84,9.87,10.86,
 11.93,12.80,13.68,14.25,15.08,17.55,19.54,22.86,27.18,31.42,
 40.92,52.14};
static float alpha01_nx064_nz24_fwhm175[32] = {
 5.05,5.56,5.82,6.10,6.58,6.82,7.56,7.97,8.48,8.85,
 9.26,9.66,9.93,10.97,11.79,12.87,14.02,15.08,16.95,18.74,
 20.34,21.83,23.55,25.03,26.56,31.04,35.59,41.45,49.06,58.10,
 78.00,103.00};
static float alpha01_nx064_nz24_fwhm200[32] = {
 7.98,8.73,9.08,9.71,10.46,10.91,11.94,12.69,13.51,14.34,
 14.98,15.66,16.26,17.60,18.75,20.26,22.38,24.29,27.64,31.04,
 33.52,36.44,38.85,41.24,43.72,51.50,59.00,69.92,84.55,100.55,
 135.80,179.25};
static float alpha01_nx064_nz24_fwhm225[32] = {
 11.67,12.50,13.37,14.24,15.14,15.91,17.39,18.67,20.00,21.20,
 21.97,22.93,23.77,26.33,28.46,30.89,33.89,36.71,41.32,45.92,
 49.87,53.59,57.08,61.71,65.70,77.55,89.83,106.00,129.83,155.22,
 213.00,278.50};
static float alpha01_nx064_nz24_fwhm250[32] = {
 15.91,17.17,18.21,19.36,20.85,22.22,24.45,25.93,27.59,29.17,
 30.44,31.65,32.95,36.31,39.45,42.17,46.21,49.43,56.00,62.75,
 68.43,73.83,79.76,85.73,91.62,108.10,125.67,149.29,179.80,211.67,
 286.00,386.00};
static float alpha01_nx064_nz24_fwhm275[32] = {
 20.65,22.17,23.62,25.20,27.06,28.75,31.25,33.93,35.67,37.55,
 39.50,41.05,42.15,46.57,49.91,54.15,59.86,65.14,73.78,82.00,
 91.00,98.50,105.80,113.80,120.71,142.86,164.00,192.45,232.50,269.50,
 374.00,491.00};
static float alpha01_nx064_nz24_fwhm300[32] = {
 25.48,27.43,29.32,31.17,33.53,35.24,38.25,40.96,44.00,46.40,
 48.25,51.00,53.18,59.09,63.00,70.00,76.25,83.67,94.00,106.12,
 115.12,123.50,133.00,142.00,151.00,178.40,204.25,234.60,280.00,341.00,
 458.00,615.67};
static float alpha01_nx064_nz24_fwhm325[32] = {
 30.22,32.75,34.75,37.13,40.17,42.33,46.92,50.73,54.17,57.38,
 59.57,62.25,64.20,71.29,77.50,83.67,91.56,100.38,115.00,127.29,
 138.83,150.00,160.25,171.00,181.60,212.00,240.80,285.67,344.50,401.75,
 556.50,745.00};
static float alpha01_nx064_nz24_fwhm350[32] = {
 36.00,38.73,41.90,44.82,47.56,51.00,55.89,60.00,63.86,66.43,
 69.54,72.88,75.80,84.00,92.00,100.80,110.43,118.14,135.25,150.00,
 163.33,175.20,190.00,203.50,214.60,248.33,284.00,334.33,407.00,481.67,
 659.80,864.00};
static float alpha01_nx064_nz24_fwhm375[32] = {
 41.60,45.25,48.25,51.89,56.20,58.67,63.67,68.20,73.00,78.71,
 81.67,84.71,88.62,97.88,106.33,116.33,126.50,137.33,155.00,172.83,
 188.00,203.00,220.67,234.00,248.29,288.75,329.00,393.80,470.00,558.00,
 743.00,996.00};
static float alpha01_nx064_nz24_fwhm400[32] = {
 47.20,50.78,54.57,59.50,62.60,66.67,73.38,78.82,84.38,88.57,
 93.00,97.78,101.57,112.00,122.50,133.50,144.67,154.86,178.33,195.83,
 216.50,233.00,250.67,269.00,283.00,333.50,383.00,444.33,534.00,632.00,
 853.00,1105.50};
static float alpha01_nx064_nz24_fwhm425[32] = {
 53.33,58.67,62.00,65.71,70.78,76.25,83.33,89.25,95.33,100.33,
 104.70,110.33,115.00,127.29,137.00,148.86,164.00,177.00,201.67,225.20,
 246.00,264.60,284.50,304.50,322.00,380.50,431.75,510.67,601.00,707.00,
 949.50,1274.00};
static float alpha01_nx064_nz24_fwhm450[32] = {
 60.25,65.33,68.80,74.75,79.75,84.60,92.14,100.00,106.57,112.75,
 117.71,123.30,128.33,141.50,152.86,166.50,182.25,197.33,226.00,252.25,
 274.00,299.00,317.00,339.00,360.50,428.00,485.00,567.00,676.00,805.00,
 1063.00,1386.00};
static float alpha01_nx064_nz24_fwhm475[32] = {
 65.88,72.25,76.40,81.75,88.43,94.10,102.50,110.33,116.17,123.33,
 129.80,137.14,142.75,156.71,169.67,185.75,203.67,222.25,253.50,278.00,
 303.75,330.00,353.50,378.50,401.00,473.00,539.67,630.00,759.00,893.00,
 1198.67,1540.00};
static float alpha01_nx064_nz24_fwhm500[32] = {
 72.00,77.67,83.00,90.00,96.33,102.20,111.57,120.38,128.50,137.50,
 143.50,149.50,156.00,172.75,187.33,205.00,225.50,243.60,276.33,306.00,
 334.67,362.67,386.00,416.50,443.50,521.00,595.00,708.00,847.00,980.00,
 1305.00,1710.00};
static float *alpha01_nx064_nz24[21] = {
 alpha01_nx064_nz24_fwhm000, alpha01_nx064_nz24_fwhm025, alpha01_nx064_nz24_fwhm050, 
 alpha01_nx064_nz24_fwhm075, alpha01_nx064_nz24_fwhm100, alpha01_nx064_nz24_fwhm125, 
 alpha01_nx064_nz24_fwhm150, alpha01_nx064_nz24_fwhm175, alpha01_nx064_nz24_fwhm200, 
 alpha01_nx064_nz24_fwhm225, alpha01_nx064_nz24_fwhm250, alpha01_nx064_nz24_fwhm275, 
 alpha01_nx064_nz24_fwhm300, alpha01_nx064_nz24_fwhm325, alpha01_nx064_nz24_fwhm350, 
 alpha01_nx064_nz24_fwhm375, alpha01_nx064_nz24_fwhm400, alpha01_nx064_nz24_fwhm425, 
 alpha01_nx064_nz24_fwhm450, alpha01_nx064_nz24_fwhm475, alpha01_nx064_nz24_fwhm500} ;

static float alpha05_nx064_nz24_fwhm000[32] = {
 1.95,1.95,1.95,1.96,1.96,1.97,1.98,2.07,2.37,2.53,
 2.63,2.70,2.75,2.84,2.89,2.93,2.95,2.97,3.21,3.61,
 3.78,3.87,3.94,3.98,4.12,4.70,4.93,5.52,5.94,6.65,
 7.78,8.95};
static float alpha05_nx064_nz24_fwhm025[32] = {
 1.95,1.95,1.95,1.96,1.96,1.97,1.98,2.07,2.37,2.53,
 2.63,2.70,2.75,2.84,2.89,2.93,2.95,2.97,3.21,3.61,
 3.78,3.87,3.94,3.98,4.12,4.70,4.93,5.52,5.94,6.65,
 7.78,8.95};
static float alpha05_nx064_nz24_fwhm050[32] = {
 1.95,1.95,1.96,1.96,1.97,1.97,1.99,2.20,2.45,2.58,
 2.66,2.73,2.78,2.86,2.90,2.93,2.96,2.98,3.33,3.67,
 3.82,3.90,3.95,3.99,4.28,4.77,4.98,5.64,5.99,6.77,
 7.91,9.22};
static float alpha05_nx064_nz24_fwhm075[32] = {
 1.95,1.96,1.96,1.97,1.98,1.99,2.29,2.52,2.66,2.74,
 2.79,2.83,2.86,2.91,2.93,2.96,2.99,3.30,3.69,3.85,
 3.94,3.99,4.33,4.58,4.73,4.99,5.61,5.98,6.83,7.55,
 8.91,10.45};
static float alpha05_nx064_nz24_fwhm100[32] = {
 1.96,1.97,1.99,2.11,2.38,2.55,2.72,2.81,2.86,2.89,
 2.91,2.93,2.94,2.98,3.15,3.53,3.74,3.86,3.98,4.45,
 4.73,4.89,4.99,5.35,5.62,6.09,6.82,7.62,8.61,9.58,
 11.59,13.80};
static float alpha05_nx064_nz24_fwhm125[32] = {
 2.34,2.55,2.67,2.77,2.84,2.88,2.94,2.97,3.00,3.28,
 3.47,3.62,3.71,3.87,3.97,4.32,4.69,4.88,5.42,5.84,
 6.19,6.67,6.96,7.43,7.74,8.75,9.71,10.96,12.73,14.43,
 18.30,22.38};
static float alpha05_nx064_nz24_fwhm150[32] = {
 2.87,2.94,2.98,3.23,3.53,3.71,3.89,4.00,4.37,4.62,
 4.77,4.88,4.97,5.50,5.86,6.38,6.85,7.35,8.15,8.93,
 9.72,10.46,11.12,11.88,12.57,14.53,16.49,19.00,22.55,26.03,
 33.77,42.86};
static float alpha05_nx064_nz24_fwhm175[32] = {
 3.90,4.27,4.57,4.82,5.01,5.40,5.87,6.33,6.70,6.95,
 7.38,7.70,7.94,8.74,9.44,10.25,11.24,12.06,13.75,15.20,
 16.60,17.94,19.22,20.59,21.84,25.49,29.30,34.14,40.80,47.71,
 63.18,83.20};
static float alpha05_nx064_nz24_fwhm200[32] = {
 5.89,6.41,6.82,7.28,7.81,8.35,9.11,9.85,10.52,11.05,
 11.58,12.10,12.57,13.79,15.01,16.39,17.94,19.29,21.99,24.47,
 26.83,29.11,31.26,33.42,35.56,41.73,47.90,56.96,68.57,80.95,
 109.18,144.64};
static float alpha05_nx064_nz24_fwhm225[32] = {
 8.34,9.04,9.84,10.55,11.34,11.98,13.22,14.30,15.25,16.05,
 16.84,17.51,18.17,20.09,21.74,23.73,25.98,28.20,32.26,35.74,
 39.47,42.64,46.00,49.20,52.04,61.68,71.64,85.02,101.69,121.60,
 164.58,220.50};
static float alpha05_nx064_nz24_fwhm250[32] = {
 11.19,12.33,13.13,14.17,15.20,16.19,17.86,19.09,20.43,21.39,
 22.53,23.47,24.38,26.94,29.44,32.22,35.34,38.40,43.62,49.12,
 53.83,58.41,63.30,67.94,71.70,84.95,98.43,117.40,140.76,165.23,
 227.23,299.40};
static float alpha05_nx064_nz24_fwhm275[32] = {
 14.28,15.66,16.66,17.83,19.10,20.41,22.62,24.41,26.00,27.40,
 28.82,30.11,31.37,34.73,38.02,41.54,45.84,49.78,56.55,63.08,
 69.24,75.14,81.38,86.84,92.58,109.03,127.03,150.95,181.79,214.27,
 290.75,383.00};
static float alpha05_nx064_nz24_fwhm300[32] = {
 17.34,18.73,20.18,21.92,23.54,25.07,27.59,29.98,32.12,33.84,
 35.87,37.32,38.84,43.31,46.82,51.43,56.35,61.05,69.59,77.89,
 85.17,92.54,99.89,107.28,114.40,135.80,157.75,187.72,224.42,265.85,
 356.50,467.56};
static float alpha05_nx064_nz24_fwhm325[32] = {
 20.44,22.43,24.05,25.99,28.14,29.98,33.15,35.96,38.52,40.85,
 42.73,44.64,46.49,51.73,56.14,61.19,67.18,73.00,83.45,92.85,
 102.22,111.45,120.25,128.86,138.12,165.67,190.94,224.89,267.80,316.33,
 422.20,556.80};
static float alpha05_nx064_nz24_fwhm350[32] = {
 23.64,25.95,27.89,30.25,32.82,35.18,38.85,41.89,44.81,47.21,
 50.16,52.25,54.08,59.89,65.32,71.59,79.28,85.59,98.32,110.56,
 121.94,133.27,143.71,155.20,165.50,195.65,224.43,262.71,313.00,367.75,
 496.20,642.00};
static float alpha05_nx064_nz24_fwhm375[32] = {
 26.77,29.57,31.93,34.60,37.59,39.72,44.24,47.95,51.32,54.16,
 56.76,59.59,62.03,69.14,75.36,83.04,91.55,99.29,115.07,129.67,
 142.86,154.80,167.00,179.54,191.92,225.17,256.32,301.50,359.50,426.25,
 567.25,735.17};
static float alpha05_nx064_nz24_fwhm400[32] = {
 30.17,33.22,35.78,38.75,41.83,44.83,50.09,54.42,57.84,61.24,
 64.71,68.12,71.08,78.96,86.29,94.38,104.81,114.80,132.57,147.61,
 162.62,177.50,192.30,205.70,218.71,255.29,292.67,345.00,410.86,481.38,
 642.00,823.80};
static float alpha05_nx064_nz24_fwhm425[32] = {
 33.54,36.86,39.68,43.26,47.00,50.45,56.11,61.15,65.46,69.25,
 73.11,76.67,79.94,88.65,97.43,107.45,118.75,130.32,149.00,167.54,
 185.06,200.85,216.22,231.12,245.00,286.93,329.82,386.90,462.14,541.40,
 713.83,922.50};
static float alpha05_nx064_nz24_fwhm450[32] = {
 36.80,41.00,43.92,47.71,51.90,55.70,62.21,67.52,72.71,77.22,
 81.25,85.36,88.80,99.75,109.36,120.79,133.78,145.17,167.43,187.23,
 204.92,223.20,240.29,257.78,273.78,322.00,369.09,431.00,514.17,607.50,
 792.50,1021.67};
static float alpha05_nx064_nz24_fwhm475[32] = {
 39.62,44.17,47.64,51.81,56.63,60.52,67.87,74.13,80.00,85.26,
 90.25,94.40,98.69,110.69,120.71,133.08,148.38,161.69,185.15,206.80,
 227.00,246.50,266.50,284.00,302.50,354.91,407.17,478.89,571.33,665.25,
 875.33,1126.00};
static float alpha05_nx064_nz24_fwhm500[32] = {
 42.53,47.26,51.20,55.87,61.27,65.84,74.14,81.38,87.58,92.94,
 98.07,103.53,108.44,121.59,132.80,148.15,162.70,176.87,202.85,227.00,
 250.40,271.82,292.57,312.33,331.83,390.14,447.20,526.43,623.67,726.00,
 953.00,1235.50};
static float *alpha05_nx064_nz24[21] = {
 alpha05_nx064_nz24_fwhm000, alpha05_nx064_nz24_fwhm025, alpha05_nx064_nz24_fwhm050, 
 alpha05_nx064_nz24_fwhm075, alpha05_nx064_nz24_fwhm100, alpha05_nx064_nz24_fwhm125, 
 alpha05_nx064_nz24_fwhm150, alpha05_nx064_nz24_fwhm175, alpha05_nx064_nz24_fwhm200, 
 alpha05_nx064_nz24_fwhm225, alpha05_nx064_nz24_fwhm250, alpha05_nx064_nz24_fwhm275, 
 alpha05_nx064_nz24_fwhm300, alpha05_nx064_nz24_fwhm325, alpha05_nx064_nz24_fwhm350, 
 alpha05_nx064_nz24_fwhm375, alpha05_nx064_nz24_fwhm400, alpha05_nx064_nz24_fwhm425, 
 alpha05_nx064_nz24_fwhm450, alpha05_nx064_nz24_fwhm475, alpha05_nx064_nz24_fwhm500} ;

static float alpha10_nx064_nz24_fwhm000[32] = {
 1.90,1.90,1.90,1.91,1.91,1.92,1.93,1.95,1.98,2.07,
 2.27,2.40,2.50,2.68,2.77,2.84,2.88,2.91,2.96,3.19,
 3.53,3.70,3.81,3.87,3.93,4.32,4.74,4.98,5.68,6.03,
 7.22,8.38};
static float alpha10_nx064_nz24_fwhm025[32] = {
 1.90,1.90,1.90,1.91,1.91,1.92,1.93,1.95,1.98,2.07,
 2.27,2.40,2.50,2.68,2.77,2.84,2.88,2.91,2.96,3.19,
 3.53,3.70,3.81,3.87,3.93,4.32,4.74,4.98,5.68,6.03,
 7.22,8.38};
static float alpha10_nx064_nz24_fwhm050[32] = {
 1.90,1.90,1.91,1.91,1.92,1.92,1.94,1.96,1.99,2.16,
 2.33,2.46,2.55,2.71,2.79,2.85,2.89,2.92,2.97,3.30,
 3.59,3.74,3.84,3.90,3.95,4.45,4.81,5.13,5.77,6.28,
 7.46,8.63};
static float alpha10_nx064_nz24_fwhm075[32] = {
 1.90,1.91,1.91,1.92,1.93,1.94,1.97,2.04,2.31,2.47,
 2.58,2.65,2.70,2.80,2.85,2.90,2.93,2.97,3.35,3.66,
 3.80,3.89,3.95,4.07,4.36,4.82,5.07,5.73,6.34,6.94,
 8.32,9.73};
static float alpha10_nx064_nz24_fwhm100[32] = {
 1.91,1.92,1.94,1.95,1.98,2.09,2.44,2.60,2.70,2.76,
 2.81,2.84,2.86,2.91,2.95,3.02,3.44,3.65,3.86,3.97,
 4.33,4.62,4.80,4.92,5.06,5.78,6.32,6.97,7.90,8.83,
 10.69,12.81};
static float alpha10_nx064_nz24_fwhm125[32] = {
 1.97,2.09,2.32,2.51,2.65,2.73,2.83,2.88,2.92,2.96,
 2.99,3.16,3.34,3.64,3.81,3.93,4.21,4.56,4.91,5.40,
 5.76,5.99,6.49,6.81,7.01,7.97,8.91,10.15,11.73,13.25,
 16.70,20.52};
static float alpha10_nx064_nz24_fwhm150[32] = {
 2.66,2.78,2.85,2.92,2.99,3.23,3.59,3.78,3.90,3.99,
 4.24,4.45,4.62,4.90,5.30,5.77,6.21,6.70,7.47,8.10,
 8.84,9.52,10.11,10.79,11.41,13.21,14.96,17.39,20.48,23.70,
 30.61,38.59};
static float alpha10_nx064_nz24_fwhm175[32] = {
 3.41,3.72,3.91,4.17,4.52,4.75,5.12,5.57,5.88,6.22,
 6.54,6.79,6.98,7.77,8.41,9.15,9.99,10.83,12.34,13.69,
 14.93,16.10,17.38,18.56,19.70,23.02,26.46,30.98,37.02,43.18,
 57.06,74.30};
static float alpha10_nx064_nz24_fwhm200[32] = {
 4.89,5.38,5.78,6.19,6.72,7.11,7.89,8.57,9.08,9.66,
 10.12,10.61,10.95,12.13,13.16,14.50,15.88,17.15,19.56,21.80,
 23.90,25.86,27.70,29.76,31.68,37.42,42.99,50.88,61.38,72.32,
 97.41,128.50};
static float alpha10_nx064_nz24_fwhm225[32] = {
 6.94,7.67,8.24,8.89,9.66,10.32,11.35,12.20,13.00,13.86,
 14.61,15.29,15.87,17.57,19.10,20.85,22.96,24.94,28.45,31.68,
 34.79,37.79,40.71,43.50,46.26,55.13,63.61,75.33,90.55,107.50,
 145.74,193.46};
static float alpha10_nx064_nz24_fwhm250[32] = {
 9.23,10.11,10.89,11.81,12.78,13.67,15.03,16.33,17.41,18.51,
 19.43,20.33,21.08,23.42,25.53,27.92,30.77,33.37,38.13,42.89,
 47.22,51.19,54.99,59.08,63.00,74.64,86.69,102.82,123.60,146.00,
 198.71,262.35};
static float alpha10_nx064_nz24_fwhm275[32] = {
 11.61,12.73,13.73,14.86,15.96,17.10,18.88,20.57,22.11,23.33,
 24.65,25.73,26.77,29.88,32.43,35.71,39.34,42.86,49.03,54.73,
 60.13,65.63,70.74,75.90,80.95,95.92,110.69,131.41,158.70,187.94,
 253.92,332.50};
static float alpha10_nx064_nz24_fwhm300[32] = {
 13.91,15.30,16.56,18.01,19.38,20.76,23.09,25.00,26.91,28.60,
 30.16,31.69,32.87,36.65,39.78,43.86,48.40,52.69,60.17,67.58,
 74.25,80.81,87.88,94.00,100.28,118.32,136.72,162.90,196.35,231.64,
 310.00,404.00};
static float alpha10_nx064_nz24_fwhm325[32] = {
 16.20,17.88,19.33,21.05,22.87,24.49,27.40,29.74,31.81,33.99,
 35.80,37.51,39.24,43.66,47.69,52.29,57.74,62.88,72.09,80.82,
 89.06,97.35,105.12,112.61,120.17,142.08,164.66,195.06,234.58,275.17,
 368.46,482.40};
static float alpha10_nx064_nz24_fwhm350[32] = {
 18.51,20.60,22.17,24.31,26.31,28.25,31.71,34.60,37.35,39.62,
 41.85,43.76,45.55,50.84,55.40,60.97,67.21,73.31,84.46,94.95,
 104.87,114.09,123.03,132.16,141.04,167.81,193.39,228.00,274.36,321.71,
 427.62,554.25};
static float alpha10_nx064_nz24_fwhm375[32] = {
 20.89,23.05,25.05,27.51,29.99,32.21,35.96,39.41,42.47,45.14,
 47.59,49.91,52.27,57.93,63.10,70.07,77.52,84.36,97.80,109.55,
 121.43,131.93,142.22,153.40,163.82,193.65,222.73,263.61,314.83,369.40,
 491.70,630.60};
static float alpha10_nx064_nz24_fwhm400[32] = {
 22.96,25.66,27.72,30.31,33.47,36.07,40.40,44.39,47.65,50.56,
 53.25,56.04,58.49,65.44,72.11,79.61,88.36,96.42,111.07,124.96,
 138.00,150.89,162.75,174.46,186.27,220.07,253.75,298.83,356.10,418.38,
 552.12,709.86};
static float alpha10_nx064_nz24_fwhm425[32] = {
 25.21,27.95,30.62,33.55,36.87,39.64,44.59,48.77,52.52,55.98,
 59.13,62.33,65.28,73.45,80.67,89.44,99.23,108.43,125.49,141.12,
 155.65,169.55,183.44,195.65,208.70,247.42,284.93,332.90,398.50,469.90,
 614.14,792.12};
static float alpha10_nx064_nz24_fwhm450[32] = {
 27.11,30.19,32.90,36.50,40.08,43.35,48.94,53.31,57.88,61.90,
 65.27,69.17,72.53,81.44,89.42,99.44,110.20,121.07,140.17,157.33,
 173.17,188.90,203.90,218.83,232.60,275.42,316.06,371.83,443.00,519.38,
 679.86,867.00};
static float alpha10_nx064_nz24_fwhm475[32] = {
 28.94,32.27,35.62,39.50,43.66,46.88,53.09,58.33,63.36,67.83,
 72.00,75.92,79.51,89.56,98.70,109.72,122.71,133.38,154.06,172.56,
 191.09,208.00,225.13,239.96,256.24,303.86,349.83,409.20,489.08,568.20,
 745.71,951.00};
static float alpha10_nx064_nz24_fwhm500[32] = {
 30.70,34.77,38.16,42.34,46.93,50.37,57.43,63.51,68.67,74.21,
 78.43,82.76,87.16,97.77,107.93,120.25,133.23,145.82,168.14,190.39,
 208.89,227.87,245.75,264.29,281.47,332.67,383.25,449.83,532.50,621.67,
 814.67,1041.75};
static float *alpha10_nx064_nz24[21] = {
 alpha10_nx064_nz24_fwhm000, alpha10_nx064_nz24_fwhm025, alpha10_nx064_nz24_fwhm050, 
 alpha10_nx064_nz24_fwhm075, alpha10_nx064_nz24_fwhm100, alpha10_nx064_nz24_fwhm125, 
 alpha10_nx064_nz24_fwhm150, alpha10_nx064_nz24_fwhm175, alpha10_nx064_nz24_fwhm200, 
 alpha10_nx064_nz24_fwhm225, alpha10_nx064_nz24_fwhm250, alpha10_nx064_nz24_fwhm275, 
 alpha10_nx064_nz24_fwhm300, alpha10_nx064_nz24_fwhm325, alpha10_nx064_nz24_fwhm350, 
 alpha10_nx064_nz24_fwhm375, alpha10_nx064_nz24_fwhm400, alpha10_nx064_nz24_fwhm425, 
 alpha10_nx064_nz24_fwhm450, alpha10_nx064_nz24_fwhm475, alpha10_nx064_nz24_fwhm500} ;

static float **nx064_nz24[3] = {
  alpha01_nx064_nz24 , alpha05_nx064_nz24 , alpha10_nx064_nz24 };

static float alpha01_nx064_nz25_fwhm000[32] = {
 1.99,1.99,2.00,2.00,2.28,2.47,2.71,2.81,2.87,2.91,
 2.93,2.94,2.96,2.98,2.99,3.00,3.44,3.69,3.87,3.96,
 3.99,4.43,4.64,4.78,4.87,5.18,5.78,6.25,6.91,7.63,
 8.90,10.26};
static float alpha01_nx064_nz25_fwhm025[32] = {
 1.99,1.99,2.00,2.00,2.28,2.47,2.71,2.81,2.87,2.91,
 2.93,2.94,2.96,2.98,2.99,3.00,3.44,3.69,3.87,3.96,
 3.99,4.43,4.64,4.78,4.87,5.18,5.78,6.25,6.91,7.63,
 8.90,10.26};
static float alpha01_nx064_nz25_fwhm050[32] = {
 1.99,2.00,2.00,2.06,2.38,2.55,2.75,2.84,2.89,2.92,
 2.94,2.95,2.96,2.98,2.99,3.12,3.55,3.74,3.90,3.97,
 4.12,4.53,4.72,4.83,4.91,5.40,5.86,6.40,6.98,7.77,
 9.10,10.62};
static float alpha01_nx064_nz25_fwhm075[32] = {
 2.00,2.00,2.24,2.45,2.64,2.75,2.86,2.91,2.94,2.95,
 2.97,2.98,2.98,3.00,3.28,3.61,3.80,3.90,3.98,4.33,
 4.67,4.84,4.92,4.99,5.36,5.88,6.44,6.96,7.85,8.67,
 10.35,12.00};
static float alpha01_nx064_nz25_fwhm100[32] = {
 2.44,2.62,2.74,2.82,2.88,2.92,2.96,2.97,2.99,2.99,
 3.08,3.33,3.51,3.77,3.88,3.96,4.06,4.47,4.82,4.98,
 5.47,5.77,5.92,6.16,6.52,7.05,7.87,8.81,9.87,10.98,
 13.43,16.16};
static float alpha01_nx064_nz25_fwhm125[32] = {
 2.88,2.93,2.95,2.98,2.99,3.20,3.59,3.76,3.86,3.93,
 3.97,4.04,4.31,4.70,4.86,4.98,5.53,5.81,6.49,6.89,
 7.32,7.81,8.22,8.74,8.98,10.20,11.48,13.12,14.94,17.00,
 21.83,26.84};
static float alpha01_nx064_nz25_fwhm150[32] = {
 3.57,3.80,3.90,3.99,4.34,4.53,4.81,4.95,5.35,5.60,
 5.83,5.94,6.20,6.70,7.12,7.76,8.44,8.93,9.90,10.82,
 11.74,12.58,13.37,14.25,15.06,17.45,19.90,22.92,27.19,31.59,
 41.00,52.14};
static float alpha01_nx064_nz25_fwhm175[32] = {
 5.05,5.59,5.83,6.25,6.65,6.90,7.59,7.96,8.53,8.86,
 9.32,9.71,9.97,10.87,11.71,12.83,14.02,14.98,17.06,18.80,
 20.29,21.92,23.58,25.18,26.83,31.21,36.23,42.21,49.78,59.06,
 78.71,102.75};
static float alpha01_nx064_nz25_fwhm200[32] = {
 8.11,8.75,9.06,9.77,10.45,10.86,11.94,12.76,13.55,14.07,
 14.88,15.42,16.03,17.72,19.29,20.89,22.83,24.79,27.96,31.23,
 34.31,37.50,39.80,42.07,44.73,52.86,60.43,69.75,84.91,100.81,
 137.50,179.67};
static float alpha01_nx064_nz25_fwhm225[32] = {
 11.62,12.48,13.30,14.40,15.31,16.18,17.81,19.21,20.33,21.38,
 22.31,23.16,24.07,26.26,28.27,31.15,33.96,36.73,41.75,45.90,
 50.07,54.70,58.31,61.87,66.46,77.30,89.56,107.17,129.00,154.73,
 206.67,270.20};
static float alpha01_nx064_nz25_fwhm250[32] = {
 16.15,17.44,18.45,19.60,20.96,22.39,24.44,26.38,27.71,29.35,
 30.87,32.05,33.35,36.20,39.44,42.37,46.31,49.61,56.09,62.64,
 69.17,75.67,82.00,87.62,93.22,110.00,125.46,148.47,177.11,209.00,
 279.00,389.00};
static float alpha01_nx064_nz25_fwhm275[32] = {
 20.84,22.44,23.65,25.33,27.27,28.86,31.64,33.65,35.33,37.50,
 39.36,40.88,42.48,47.11,50.55,54.92,59.92,65.14,75.27,83.83,
 91.62,100.25,107.83,114.83,122.12,142.83,163.50,191.80,229.67,267.00,
 374.00,496.50};
static float alpha01_nx064_nz25_fwhm300[32] = {
 25.53,27.42,29.07,30.88,33.46,35.31,39.06,41.55,44.35,46.85,
 49.50,51.92,54.12,58.50,63.15,69.30,76.64,83.38,93.89,104.71,
 116.11,124.67,135.11,144.00,151.86,178.00,201.75,237.00,287.50,334.33,
 463.00,612.00};
static float alpha01_nx064_nz25_fwhm325[32] = {
 31.17,33.43,35.43,37.93,40.67,43.38,47.80,51.50,54.67,57.60,
 60.38,62.00,65.30,71.88,79.00,86.25,94.33,101.50,116.00,128.00,
 140.00,150.33,160.67,170.33,180.71,212.25,243.40,286.50,346.17,412.33,
 552.50,732.67};
static float alpha01_nx064_nz25_fwhm350[32] = {
 36.89,39.00,42.44,45.40,48.75,51.67,58.00,61.60,65.17,69.00,
 72.40,75.40,78.27,87.11,93.50,102.67,113.00,121.67,137.40,150.00,
 163.00,175.70,189.00,201.00,214.33,252.00,289.00,341.67,415.00,489.00,
 651.00,858.00};
static float alpha01_nx064_nz25_fwhm375[32] = {
 43.00,46.25,49.55,53.20,57.25,61.11,67.54,71.75,76.00,81.14,
 86.33,89.33,93.33,103.17,111.33,121.20,130.91,141.71,159.12,174.50,
 189.00,205.67,220.50,237.00,250.78,293.40,339.00,399.00,481.33,567.00,
 740.50,982.50};
static float alpha01_nx064_nz25_fwhm400[32] = {
 49.00,53.71,57.00,61.80,66.80,70.50,77.50,84.33,90.00,95.00,
 99.00,103.00,107.00,117.33,127.14,138.27,149.43,160.25,181.00,200.33,
 220.57,238.00,253.86,269.00,287.00,338.00,393.00,461.00,545.00,645.50,
 854.50,1119.50};
static float alpha01_nx064_nz25_fwhm425[32] = {
 55.83,60.70,66.00,71.30,76.00,80.33,88.67,95.67,102.38,107.60,
 112.40,117.00,121.33,133.33,142.50,154.60,167.67,180.67,204.75,229.00,
 249.33,267.00,286.17,308.20,327.12,383.67,439.67,515.50,620.00,726.00,
 964.50,1249.00};
static float alpha01_nx064_nz25_fwhm450[32] = {
 63.80,70.00,74.25,78.50,85.83,91.50,100.00,107.50,114.33,121.00,
 126.29,131.00,135.67,147.71,158.60,171.17,186.62,202.50,231.25,254.75,
 279.33,301.00,322.75,345.67,365.50,431.00,494.50,578.50,693.50,821.00,
 1084.00,1391.00};
static float alpha01_nx064_nz25_fwhm475[32] = {
 70.67,76.60,82.50,89.33,95.56,101.33,110.25,118.67,125.60,132.00,
 138.29,144.33,149.50,163.00,174.75,190.20,209.00,226.00,255.00,283.50,
 309.00,338.00,360.67,383.67,408.00,481.33,551.00,653.00,770.00,914.00,
 1200.00,1527.00};
static float alpha01_nx064_nz25_fwhm500[32] = {
 78.12,85.00,91.25,97.50,104.67,109.38,120.80,130.00,139.00,145.00,
 150.62,156.38,163.40,179.67,193.00,210.86,232.75,250.50,281.67,311.50,
 340.00,369.67,396.50,426.67,451.00,528.00,606.50,714.50,857.00,1004.00,
 1318.00,1686.00};
static float *alpha01_nx064_nz25[21] = {
 alpha01_nx064_nz25_fwhm000, alpha01_nx064_nz25_fwhm025, alpha01_nx064_nz25_fwhm050, 
 alpha01_nx064_nz25_fwhm075, alpha01_nx064_nz25_fwhm100, alpha01_nx064_nz25_fwhm125, 
 alpha01_nx064_nz25_fwhm150, alpha01_nx064_nz25_fwhm175, alpha01_nx064_nz25_fwhm200, 
 alpha01_nx064_nz25_fwhm225, alpha01_nx064_nz25_fwhm250, alpha01_nx064_nz25_fwhm275, 
 alpha01_nx064_nz25_fwhm300, alpha01_nx064_nz25_fwhm325, alpha01_nx064_nz25_fwhm350, 
 alpha01_nx064_nz25_fwhm375, alpha01_nx064_nz25_fwhm400, alpha01_nx064_nz25_fwhm425, 
 alpha01_nx064_nz25_fwhm450, alpha01_nx064_nz25_fwhm475, alpha01_nx064_nz25_fwhm500} ;

static float alpha05_nx064_nz25_fwhm000[32] = {
 1.95,1.95,1.96,1.96,1.96,1.97,1.98,2.05,2.34,2.51,
 2.63,2.70,2.75,2.85,2.90,2.93,2.96,2.98,3.25,3.62,
 3.79,3.89,3.94,3.98,4.13,4.73,4.94,5.52,5.97,6.67,
 7.79,8.91};
static float alpha05_nx064_nz25_fwhm025[32] = {
 1.95,1.95,1.96,1.96,1.96,1.97,1.98,2.05,2.34,2.51,
 2.63,2.70,2.75,2.85,2.90,2.93,2.96,2.98,3.25,3.62,
 3.79,3.89,3.94,3.98,4.13,4.73,4.94,5.52,5.97,6.67,
 7.79,8.91};
static float alpha05_nx064_nz25_fwhm050[32] = {
 1.95,1.96,1.96,1.96,1.97,1.97,1.99,2.17,2.42,2.57,
 2.66,2.73,2.78,2.86,2.91,2.94,2.96,2.98,3.37,3.68,
 3.83,3.91,3.96,3.99,4.30,4.79,4.97,5.63,6.10,6.79,
 7.92,9.21};
static float alpha05_nx064_nz25_fwhm075[32] = {
 1.96,1.96,1.96,1.97,1.98,1.99,2.26,2.51,2.65,2.73,
 2.80,2.83,2.86,2.91,2.94,2.97,2.99,3.35,3.71,3.86,
 3.94,4.00,4.35,4.59,4.75,4.99,5.62,5.99,6.84,7.55,
 8.90,10.47};
static float alpha05_nx064_nz25_fwhm100[32] = {
 1.97,1.98,1.99,2.06,2.36,2.54,2.72,2.81,2.86,2.89,
 2.92,2.94,2.95,2.98,3.21,3.57,3.77,3.87,3.98,4.45,
 4.75,4.89,4.99,5.36,5.63,6.15,6.81,7.61,8.58,9.58,
 11.63,13.86};
static float alpha05_nx064_nz25_fwhm125[32] = {
 2.31,2.53,2.67,2.77,2.84,2.89,2.94,2.97,3.02,3.32,
 3.52,3.64,3.74,3.89,3.97,4.37,4.71,4.89,5.44,5.84,
 6.17,6.66,6.94,7.40,7.73,8.76,9.80,11.04,12.76,14.47,
 18.27,22.53};
static float alpha05_nx064_nz25_fwhm150[32] = {
 2.88,2.95,2.99,3.28,3.57,3.71,3.89,4.00,4.40,4.63,
 4.78,4.88,4.97,5.51,5.87,6.34,6.85,7.37,8.20,8.95,
 9.78,10.53,11.21,11.91,12.65,14.54,16.45,19.04,22.39,25.76,
 33.81,42.70};
static float alpha05_nx064_nz25_fwhm175[32] = {
 3.91,4.19,4.52,4.77,5.00,5.42,5.89,6.30,6.70,6.98,
 7.38,7.70,7.98,8.72,9.46,10.37,11.28,12.15,13.78,15.24,
 16.56,17.92,19.38,20.64,21.91,25.65,29.38,34.62,40.99,48.47,
 64.42,84.24};
static float alpha05_nx064_nz25_fwhm200[32] = {
 5.81,6.34,6.80,7.30,7.84,8.30,9.00,9.80,10.46,10.98,
 11.57,12.00,12.50,13.75,14.92,16.43,18.00,19.48,22.19,24.65,
 26.99,29.34,31.65,33.95,36.04,42.48,48.63,57.26,69.21,81.94,
 110.26,144.50};
static float alpha05_nx064_nz25_fwhm225[32] = {
 8.48,9.16,9.73,10.45,11.21,11.88,13.14,14.20,15.17,16.01,
 16.80,17.62,18.36,20.28,22.04,24.15,26.44,28.50,32.63,36.43,
 40.11,43.52,46.80,50.19,53.37,62.84,72.18,85.20,103.30,123.00,
 165.47,218.64};
static float alpha05_nx064_nz25_fwhm250[32] = {
 11.22,12.18,13.02,13.99,15.18,16.20,17.90,19.38,20.64,21.80,
 22.94,23.82,24.73,27.69,30.06,32.71,35.96,39.21,44.65,49.71,
 54.62,59.30,63.84,68.16,72.39,85.38,99.39,117.62,141.74,166.84,
 224.47,297.64};
static float alpha05_nx064_nz25_fwhm275[32] = {
 14.25,15.64,16.74,18.11,19.54,20.77,23.14,24.89,26.67,28.14,
 29.69,30.97,32.11,35.42,38.47,42.02,46.17,50.40,57.10,63.61,
 69.67,75.90,82.14,88.30,94.07,110.63,127.74,152.95,182.00,213.12,
 288.57,382.86};
static float alpha05_nx064_nz25_fwhm300[32] = {
 17.47,19.16,20.59,22.33,24.00,25.51,28.27,30.59,32.59,34.46,
 36.38,37.78,39.25,43.37,47.03,51.67,57.10,61.74,70.65,78.97,
 86.79,94.55,102.24,109.06,116.50,138.29,160.13,187.55,224.50,262.15,
 356.00,470.67};
static float alpha05_nx064_nz25_fwhm325[32] = {
 20.76,22.81,24.42,26.39,28.45,30.30,33.64,36.46,38.98,41.22,
 43.26,45.10,46.94,52.06,56.70,62.06,68.43,74.20,85.20,95.03,
 105.25,114.93,123.76,132.26,141.25,167.00,191.00,224.62,267.90,313.11,
 423.40,560.75};
static float alpha05_nx064_nz25_fwhm350[32] = {
 24.18,26.43,28.37,30.61,33.23,35.61,39.31,42.58,45.50,48.19,
 50.62,53.09,55.35,61.50,66.87,73.56,81.16,87.77,101.12,113.59,
 124.67,135.50,145.27,155.85,166.64,195.73,224.08,261.50,315.12,369.50,
 494.50,648.29};
static float alpha05_nx064_nz25_fwhm375[32] = {
 27.37,30.04,32.38,35.02,37.89,40.55,45.24,49.32,52.86,55.58,
 58.57,61.19,63.76,71.10,77.52,85.26,94.10,102.60,117.73,131.20,
 143.58,157.57,169.33,180.93,192.88,224.56,258.06,305.86,364.86,426.80,
 574.00,749.00};
static float alpha05_nx064_nz25_fwhm400[32] = {
 30.69,33.95,36.60,39.88,43.39,46.58,51.59,55.68,59.56,63.03,
 66.12,69.65,72.61,81.19,89.00,97.85,108.20,117.20,134.53,150.31,
 165.12,179.43,193.80,206.00,219.56,255.88,294.17,346.75,413.33,484.75,
 646.60,837.50};
static float alpha05_nx064_nz25_fwhm425[32] = {
 34.33,38.07,41.37,44.64,48.26,51.75,57.59,62.54,66.90,71.00,
 74.81,78.90,82.08,91.68,100.71,110.47,121.50,132.23,152.08,171.44,
 187.20,202.78,217.89,232.50,246.33,288.00,332.44,392.10,464.92,550.00,
 726.60,940.00};
static float alpha05_nx064_nz25_fwhm450[32] = {
 37.47,41.55,44.94,49.11,53.43,57.24,63.76,69.44,74.28,78.92,
 83.42,87.29,91.33,102.41,111.71,123.00,137.05,149.08,171.40,190.42,
 208.41,225.78,243.00,258.83,273.50,320.17,372.18,437.18,522.00,610.80,
 811.25,1044.00};
static float alpha05_nx064_nz25_fwhm475[32] = {
 41.00,45.18,49.32,53.54,58.47,62.57,70.09,76.22,82.21,87.39,
 92.06,96.89,101.37,113.06,123.47,136.75,151.71,164.80,188.69,209.33,
 230.20,248.33,267.00,285.22,303.17,358.12,413.50,483.80,575.67,679.00,
 900.40,1154.00};
static float alpha05_nx064_nz25_fwhm500[32] = {
 44.31,49.15,53.24,58.04,63.10,67.81,75.83,83.33,89.93,95.62,
 101.25,106.13,110.79,124.73,135.92,150.00,166.36,181.36,206.45,230.40,
 252.38,273.11,294.14,315.50,336.33,397.17,453.75,533.70,636.50,745.20,
 977.83,1263.25};
static float *alpha05_nx064_nz25[21] = {
 alpha05_nx064_nz25_fwhm000, alpha05_nx064_nz25_fwhm025, alpha05_nx064_nz25_fwhm050, 
 alpha05_nx064_nz25_fwhm075, alpha05_nx064_nz25_fwhm100, alpha05_nx064_nz25_fwhm125, 
 alpha05_nx064_nz25_fwhm150, alpha05_nx064_nz25_fwhm175, alpha05_nx064_nz25_fwhm200, 
 alpha05_nx064_nz25_fwhm225, alpha05_nx064_nz25_fwhm250, alpha05_nx064_nz25_fwhm275, 
 alpha05_nx064_nz25_fwhm300, alpha05_nx064_nz25_fwhm325, alpha05_nx064_nz25_fwhm350, 
 alpha05_nx064_nz25_fwhm375, alpha05_nx064_nz25_fwhm400, alpha05_nx064_nz25_fwhm425, 
 alpha05_nx064_nz25_fwhm450, alpha05_nx064_nz25_fwhm475, alpha05_nx064_nz25_fwhm500} ;

static float alpha10_nx064_nz25_fwhm000[32] = {
 1.90,1.90,1.91,1.91,1.91,1.92,1.93,1.95,1.97,2.03,
 2.25,2.38,2.50,2.69,2.78,2.85,2.89,2.92,2.96,3.21,
 3.54,3.71,3.81,3.88,3.93,4.37,4.75,4.98,5.72,6.09,
 7.26,8.36};
static float alpha10_nx064_nz25_fwhm025[32] = {
 1.90,1.90,1.91,1.91,1.91,1.92,1.93,1.95,1.97,2.03,
 2.25,2.38,2.50,2.69,2.78,2.85,2.89,2.92,2.96,3.21,
 3.54,3.71,3.81,3.88,3.93,4.37,4.75,4.98,5.72,6.09,
 7.26,8.36};
static float alpha10_nx064_nz25_fwhm050[32] = {
 1.90,1.91,1.91,1.91,1.91,1.92,1.94,1.96,1.98,2.14,
 2.32,2.45,2.55,2.72,2.80,2.86,2.90,2.93,2.98,3.32,
 3.61,3.76,3.84,3.90,3.95,4.49,4.81,5.10,5.80,6.32,
 7.49,8.65};
static float alpha10_nx064_nz25_fwhm075[32] = {
 1.91,1.91,1.91,1.92,1.93,1.94,1.97,2.01,2.29,2.46,
 2.58,2.66,2.71,2.81,2.86,2.90,2.94,2.97,3.38,3.67,
 3.81,3.90,3.96,4.09,4.39,4.83,5.05,5.76,6.39,6.95,
 8.30,9.76};
static float alpha10_nx064_nz25_fwhm100[32] = {
 1.92,1.92,1.94,1.95,1.98,2.07,2.43,2.60,2.71,2.77,
 2.81,2.85,2.87,2.92,2.96,3.08,3.47,3.67,3.86,3.97,
 4.36,4.64,4.81,4.92,5.06,5.79,6.34,6.96,7.89,8.85,
 10.79,12.88};
static float alpha10_nx064_nz25_fwhm125[32] = {
 1.97,2.03,2.31,2.51,2.65,2.73,2.83,2.89,2.93,2.96,
 2.99,3.20,3.37,3.66,3.81,3.94,4.24,4.58,4.92,5.41,
 5.77,6.00,6.51,6.81,7.03,7.99,8.96,10.22,11.77,13.34,
 16.76,20.64};
static float alpha10_nx064_nz25_fwhm150[32] = {
 2.68,2.79,2.86,2.93,3.00,3.25,3.60,3.78,3.91,4.02,
 4.28,4.47,4.62,4.91,5.33,5.77,6.20,6.70,7.49,8.18,
 8.86,9.58,10.24,10.89,11.53,13.31,15.00,17.47,20.54,23.62,
 30.60,38.77};
static float alpha10_nx064_nz25_fwhm175[32] = {
 3.44,3.72,3.89,4.09,4.50,4.75,5.12,5.57,5.88,6.25,
 6.58,6.79,7.00,7.79,8.43,9.22,10.05,10.88,12.38,13.72,
 14.89,16.20,17.45,18.55,19.71,23.00,26.50,31.03,37.13,43.71,
 57.57,75.30};
static float alpha10_nx064_nz25_fwhm200[32] = {
 4.85,5.32,5.75,6.20,6.69,7.07,7.88,8.57,9.10,9.62,
 10.08,10.57,10.96,12.14,13.21,14.48,15.94,17.27,19.75,21.94,
 24.14,26.15,28.12,30.14,32.01,37.91,43.52,51.61,61.90,72.71,
 98.62,129.22};
static float alpha10_nx064_nz25_fwhm225[32] = {
 6.92,7.69,8.27,8.84,9.56,10.18,11.24,12.18,13.06,13.86,
 14.59,15.26,15.95,17.68,19.19,21.07,23.25,25.17,28.90,32.22,
 35.49,38.53,41.51,44.39,47.25,56.04,64.38,76.39,92.15,108.75,
 146.76,193.76};
static float alpha10_nx064_nz25_fwhm250[32] = {
 9.15,10.01,10.77,11.63,12.65,13.50,14.99,16.32,17.50,18.62,
 19.57,20.51,21.42,23.86,26.08,28.45,31.50,34.23,38.99,43.67,
 47.91,51.97,56.05,60.12,63.96,75.70,87.90,103.62,124.82,148.29,
 199.25,262.12};
static float alpha10_nx064_nz25_fwhm275[32] = {
 11.38,12.55,13.54,14.74,16.10,17.17,19.18,20.81,22.46,23.72,
 25.04,26.17,27.34,30.33,33.08,36.44,40.21,43.46,49.63,55.41,
 61.03,66.71,72.36,77.49,82.48,97.26,112.55,132.92,160.40,189.14,
 254.17,336.93};
static float alpha10_nx064_nz25_fwhm300[32] = {
 13.88,15.36,16.66,17.98,19.58,20.90,23.45,25.51,27.24,28.99,
 30.61,32.03,33.58,37.34,40.83,44.58,49.17,53.39,61.44,68.77,
 75.85,82.57,88.82,95.32,101.95,119.85,138.11,164.11,197.33,232.28,
 311.53,409.40};
static float alpha10_nx064_nz25_fwhm325[32] = {
 16.34,18.16,19.65,21.39,23.26,24.84,27.88,30.29,32.48,34.58,
 36.40,38.13,39.91,44.34,48.40,53.42,59.28,64.52,73.93,82.60,
 91.02,99.27,106.58,114.43,121.86,143.72,166.00,196.33,235.70,275.69,
 370.33,487.71};
static float alpha10_nx064_nz25_fwhm350[32] = {
 18.87,20.99,22.70,24.67,26.77,28.73,32.11,35.18,37.79,40.26,
 42.43,44.49,46.40,51.89,56.62,62.44,69.35,75.43,86.89,96.57,
 106.30,115.85,124.68,133.87,142.60,169.15,195.15,230.30,276.96,322.31,
 429.60,566.22};
static float alpha10_nx064_nz25_fwhm375[32] = {
 21.30,23.56,25.56,27.96,30.47,32.68,36.68,39.97,43.09,45.94,
 48.54,50.88,53.26,59.61,65.24,72.26,80.08,86.48,99.46,111.39,
 122.56,133.69,143.81,154.33,164.89,195.00,225.35,265.85,314.95,371.20,
 496.75,646.29};
static float alpha10_nx064_nz25_fwhm400[32] = {
 23.45,26.25,28.47,31.00,33.83,36.49,40.87,45.13,48.62,51.93,
 54.85,57.50,60.27,67.44,73.94,81.66,90.15,98.33,113.27,127.03,
 139.40,151.67,164.11,176.21,188.45,222.19,256.45,300.53,358.73,420.60,
 559.82,726.25};
static float alpha10_nx064_nz25_fwhm425[32] = {
 25.79,28.74,31.35,34.23,37.55,40.56,45.67,50.23,54.23,58.09,
 61.29,64.37,67.44,75.16,82.27,91.21,100.92,110.08,126.76,142.35,
 156.64,171.48,185.97,199.35,212.52,250.64,288.23,337.67,402.42,473.46,
 625.14,813.36};
static float alpha10_nx064_nz25_fwhm450[32] = {
 27.82,31.21,34.14,37.33,41.14,44.40,50.20,55.63,60.08,63.78,
 67.59,71.10,74.35,83.40,91.79,101.41,112.32,122.37,141.29,158.41,
 175.33,192.18,207.61,221.60,236.69,278.65,321.07,375.71,446.31,524.60,
 696.40,899.33};
static float alpha10_nx064_nz25_fwhm475[32] = {
 29.68,33.37,36.51,40.72,44.81,48.53,54.98,60.52,65.47,69.87,
 73.92,78.18,81.95,91.67,100.75,111.78,123.85,135.18,156.23,175.71,
 194.75,212.48,228.75,244.29,260.92,308.15,354.55,414.33,493.00,577.25,
 771.25,986.00};
static float alpha10_nx064_nz25_fwhm500[32] = {
 31.46,35.83,39.68,43.81,48.33,52.36,59.52,65.71,71.17,76.18,
 80.57,84.77,88.87,100.21,109.85,121.83,136.15,148.19,171.87,193.37,
 213.58,232.86,251.44,269.27,286.41,338.53,388.40,455.60,544.00,636.43,
 844.20,1074.33};
static float *alpha10_nx064_nz25[21] = {
 alpha10_nx064_nz25_fwhm000, alpha10_nx064_nz25_fwhm025, alpha10_nx064_nz25_fwhm050, 
 alpha10_nx064_nz25_fwhm075, alpha10_nx064_nz25_fwhm100, alpha10_nx064_nz25_fwhm125, 
 alpha10_nx064_nz25_fwhm150, alpha10_nx064_nz25_fwhm175, alpha10_nx064_nz25_fwhm200, 
 alpha10_nx064_nz25_fwhm225, alpha10_nx064_nz25_fwhm250, alpha10_nx064_nz25_fwhm275, 
 alpha10_nx064_nz25_fwhm300, alpha10_nx064_nz25_fwhm325, alpha10_nx064_nz25_fwhm350, 
 alpha10_nx064_nz25_fwhm375, alpha10_nx064_nz25_fwhm400, alpha10_nx064_nz25_fwhm425, 
 alpha10_nx064_nz25_fwhm450, alpha10_nx064_nz25_fwhm475, alpha10_nx064_nz25_fwhm500} ;

static float **nx064_nz25[3] = {
  alpha01_nx064_nz25 , alpha05_nx064_nz25 , alpha10_nx064_nz25 };

static float alpha01_nx064_nz26_fwhm000[32] = {
 1.99,2.00,2.00,2.07,2.40,2.59,2.75,2.84,2.89,2.92,
 2.94,2.95,2.96,2.98,2.99,3.00,3.42,3.69,3.88,3.95,
 3.99,4.40,4.65,4.78,4.88,5.10,5.75,6.18,6.90,7.68,
 9.01,10.51};
static float alpha01_nx064_nz26_fwhm025[32] = {
 1.99,2.00,2.00,2.07,2.40,2.59,2.75,2.84,2.89,2.92,
 2.94,2.95,2.96,2.98,2.99,3.00,3.42,3.69,3.88,3.95,
 3.99,4.40,4.65,4.78,4.88,5.10,5.75,6.18,6.90,7.68,
 9.01,10.51};
static float alpha01_nx064_nz26_fwhm050[32] = {
 1.99,2.00,2.00,2.20,2.49,2.63,2.78,2.85,2.90,2.93,
 2.94,2.96,2.96,2.98,2.99,3.05,3.54,3.74,3.91,3.97,
 4.10,4.52,4.71,4.84,4.92,5.36,5.84,6.46,6.96,7.82,
 9.32,10.83};
static float alpha01_nx064_nz26_fwhm075[32] = {
 2.00,2.05,2.36,2.56,2.71,2.78,2.88,2.92,2.94,2.96,
 2.97,2.98,2.98,2.99,3.24,3.61,3.82,3.91,3.98,4.41,
 4.69,4.84,4.94,4.99,5.34,5.88,6.42,6.95,7.85,8.73,
 10.48,12.19};
static float alpha01_nx064_nz26_fwhm100[32] = {
 2.51,2.69,2.78,2.85,2.90,2.93,2.96,2.98,2.99,3.00,
 3.18,3.42,3.56,3.78,3.89,3.96,4.19,4.54,4.86,4.99,
 5.45,5.75,5.92,6.21,6.54,7.16,7.88,8.78,9.89,11.23,
 13.63,16.39};
static float alpha01_nx064_nz26_fwhm125[32] = {
 2.89,2.94,2.96,2.99,3.03,3.33,3.68,3.80,3.88,3.94,
 3.97,4.00,4.25,4.68,4.89,5.01,5.53,5.78,6.32,6.91,
 7.36,7.84,8.22,8.75,8.98,10.35,11.67,13.18,15.08,17.37,
 21.78,26.73};
static float alpha01_nx064_nz26_fwhm150[32] = {
 3.60,3.81,3.90,4.00,4.39,4.63,4.89,5.05,5.45,5.67,
 5.83,5.95,6.07,6.72,7.18,7.80,8.41,8.91,9.92,10.85,
 11.78,12.68,13.60,14.29,15.02,17.61,19.87,23.28,27.39,31.23,
 41.78,52.67};
static float alpha01_nx064_nz26_fwhm175[32] = {
 5.20,5.64,5.88,6.17,6.72,6.94,7.66,8.00,8.56,8.89,
 9.26,9.65,9.92,10.84,11.69,12.84,13.82,14.87,16.98,19.03,
 21.00,22.33,24.07,25.66,27.23,31.80,36.75,42.79,51.25,59.86,
 78.64,104.89};
static float alpha01_nx064_nz26_fwhm200[32] = {
 7.89,8.49,8.93,9.55,9.99,10.78,11.75,12.69,13.44,14.27,
 14.93,15.50,15.89,17.55,18.97,21.00,23.07,24.61,28.18,31.00,
 33.93,36.68,39.35,41.95,44.47,52.64,60.06,72.38,86.78,102.60,
 140.50,187.56};
static float alpha01_nx064_nz26_fwhm225[32] = {
 11.57,12.49,13.35,14.19,15.04,16.03,17.46,18.82,19.98,20.86,
 21.93,22.73,23.81,26.36,28.32,31.14,33.71,36.26,41.67,46.10,
 50.53,54.69,59.00,63.67,66.73,79.92,92.60,110.18,133.62,155.33,
 209.00,279.67};
static float alpha01_nx064_nz26_fwhm250[32] = {
 15.50,16.89,17.97,18.95,20.67,21.82,23.88,25.84,27.62,29.09,
 30.32,31.61,32.73,36.40,39.32,42.75,46.88,50.53,57.33,64.00,
 70.15,76.83,81.88,88.08,92.92,109.11,127.43,151.40,179.67,213.20,
 294.00,388.67};
static float alpha01_nx064_nz26_fwhm275[32] = {
 20.24,21.67,23.21,24.74,26.71,28.52,31.38,33.67,35.73,37.50,
 39.18,40.94,42.36,47.00,51.43,56.14,61.00,66.00,74.86,83.20,
 91.33,98.60,105.00,111.89,119.50,142.14,163.50,193.50,231.67,281.17,
 379.50,505.33};
static float alpha01_nx064_nz26_fwhm300[32] = {
 25.25,27.00,29.00,31.39,33.38,35.38,38.39,40.95,43.56,46.46,
 49.00,51.38,53.25,58.50,62.89,68.50,74.88,81.18,93.14,102.25,
 112.60,122.38,131.25,141.40,149.00,175.71,203.50,242.00,296.00,342.83,
 473.50,614.50};
static float alpha01_nx064_nz26_fwhm325[32] = {
 30.44,32.76,34.86,36.96,39.38,42.17,46.59,50.35,53.10,56.10,
 58.78,61.27,63.75,70.20,77.09,84.08,90.50,99.43,113.00,127.00,
 138.00,146.67,159.00,170.45,180.73,216.50,247.00,296.50,354.50,416.00,
 558.00,733.00};
static float alpha01_nx064_nz26_fwhm350[32] = {
 35.69,38.26,40.60,43.73,47.29,50.57,55.00,58.92,63.25,66.86,
 69.56,72.71,76.00,83.70,91.17,100.30,109.60,118.57,133.33,148.50,
 162.40,176.14,192.00,205.00,219.50,257.80,294.50,350.00,411.50,492.25,
 659.33,861.00};
static float alpha01_nx064_nz26_fwhm375[32] = {
 41.35,44.88,48.08,50.84,54.50,58.00,63.71,69.17,73.67,78.44,
 82.09,85.47,88.88,98.12,105.50,116.20,127.20,137.75,156.67,175.00,
 193.25,210.25,226.00,238.88,255.50,299.50,343.50,408.00,485.00,564.00,
 753.00,973.67};
static float alpha01_nx064_nz26_fwhm400[32] = {
 47.46,50.85,54.44,58.53,63.00,66.64,73.57,78.90,84.50,89.44,
 94.15,98.10,102.62,112.83,122.25,134.00,146.29,159.12,179.67,201.50,
 220.80,239.50,260.00,276.00,293.67,345.25,397.33,462.00,546.75,645.00,
 853.67,1123.00};
static float alpha01_nx064_nz26_fwhm425[32] = {
 53.33,58.29,61.86,66.31,70.94,76.29,83.80,90.71,96.12,101.50,
 106.57,110.80,116.67,128.29,139.00,151.60,166.75,180.00,204.86,229.00,
 252.67,275.00,292.33,315.00,335.00,387.75,453.00,527.00,623.00,730.67,
 963.50,1262.00};
static float alpha01_nx064_nz26_fwhm450[32] = {
 59.60,65.00,70.12,74.57,80.50,85.40,93.00,101.00,107.75,113.50,
 120.80,126.17,130.86,141.80,156.00,171.00,188.00,204.33,230.00,259.25,
 285.33,306.33,332.50,357.00,375.50,442.00,508.50,587.00,705.00,817.00,
 1091.00,1404.00};
static float alpha01_nx064_nz26_fwhm475[32] = {
 65.60,71.64,77.33,82.25,89.38,94.33,103.75,111.75,120.50,127.50,
 134.00,139.50,144.67,160.00,173.67,190.29,209.80,227.00,260.00,290.00,
 320.33,343.50,367.50,394.00,423.00,495.00,565.00,658.50,785.50,910.00,
 1201.00,1561.00};
static float alpha01_nx064_nz26_fwhm500[32] = {
 72.67,79.67,85.20,90.67,98.14,103.00,114.80,124.00,132.75,139.60,
 146.44,152.50,158.83,176.20,192.14,209.50,231.00,251.25,287.00,320.00,
 350.67,381.00,413.00,441.25,470.00,546.50,620.50,728.00,868.00,1009.00,
 1329.00,1725.00};
static float *alpha01_nx064_nz26[21] = {
 alpha01_nx064_nz26_fwhm000, alpha01_nx064_nz26_fwhm025, alpha01_nx064_nz26_fwhm050, 
 alpha01_nx064_nz26_fwhm075, alpha01_nx064_nz26_fwhm100, alpha01_nx064_nz26_fwhm125, 
 alpha01_nx064_nz26_fwhm150, alpha01_nx064_nz26_fwhm175, alpha01_nx064_nz26_fwhm200, 
 alpha01_nx064_nz26_fwhm225, alpha01_nx064_nz26_fwhm250, alpha01_nx064_nz26_fwhm275, 
 alpha01_nx064_nz26_fwhm300, alpha01_nx064_nz26_fwhm325, alpha01_nx064_nz26_fwhm350, 
 alpha01_nx064_nz26_fwhm375, alpha01_nx064_nz26_fwhm400, alpha01_nx064_nz26_fwhm425, 
 alpha01_nx064_nz26_fwhm450, alpha01_nx064_nz26_fwhm475, alpha01_nx064_nz26_fwhm500} ;

static float alpha05_nx064_nz26_fwhm000[32] = {
 1.95,1.96,1.96,1.96,1.97,1.97,1.99,2.18,2.41,2.57,
 2.66,2.73,2.77,2.86,2.90,2.93,2.96,2.98,3.31,3.65,
 3.80,3.89,3.94,3.98,4.15,4.73,4.94,5.53,5.96,6.69,
 7.82,8.97};
static float alpha05_nx064_nz26_fwhm025[32] = {
 1.95,1.96,1.96,1.96,1.97,1.97,1.99,2.18,2.41,2.57,
 2.66,2.73,2.77,2.86,2.90,2.93,2.96,2.98,3.31,3.65,
 3.80,3.89,3.94,3.98,4.15,4.73,4.94,5.53,5.96,6.69,
 7.82,8.97};
static float alpha05_nx064_nz26_fwhm050[32] = {
 1.95,1.96,1.96,1.96,1.97,1.98,1.99,2.25,2.48,2.61,
 2.70,2.75,2.80,2.87,2.91,2.94,2.96,2.98,3.43,3.70,
 3.84,3.91,3.96,3.99,4.34,4.80,4.97,5.66,6.09,6.81,
 7.95,9.30};
static float alpha05_nx064_nz26_fwhm075[32] = {
 1.96,1.96,1.97,1.97,1.98,1.99,2.36,2.57,2.68,2.76,
 2.81,2.84,2.87,2.91,2.94,2.97,3.04,3.40,3.73,3.88,
 3.95,4.00,4.36,4.61,4.76,4.98,5.64,6.05,6.84,7.58,
 8.96,10.57};
static float alpha05_nx064_nz26_fwhm100[32] = {
 1.97,1.98,1.99,2.20,2.45,2.60,2.75,2.82,2.87,2.90,
 2.92,2.94,2.96,2.99,3.27,3.60,3.79,3.88,3.99,4.49,
 4.76,4.90,4.99,5.39,5.67,6.18,6.81,7.66,8.61,9.62,
 11.72,13.87};
static float alpha05_nx064_nz26_fwhm125[32] = {
 2.37,2.58,2.70,2.79,2.86,2.90,2.96,2.99,3.19,3.42,
 3.56,3.68,3.76,3.89,3.98,4.43,4.73,4.90,5.45,5.86,
 6.27,6.70,6.94,7.45,7.78,8.78,9.80,11.22,12.86,14.63,
 18.32,22.56};
static float alpha05_nx064_nz26_fwhm150[32] = {
 2.89,2.96,3.03,3.37,3.60,3.74,3.92,4.08,4.45,4.65,
 4.81,4.91,4.99,5.56,5.88,6.37,6.90,7.46,8.29,9.03,
 9.82,10.60,11.25,11.91,12.63,14.67,16.69,19.15,22.62,26.07,
 34.13,43.21};
static float alpha05_nx064_nz26_fwhm175[32] = {
 3.92,4.23,4.54,4.82,5.03,5.45,5.90,6.37,6.75,7.02,
 7.46,7.77,7.99,8.76,9.51,10.30,11.22,12.00,13.78,15.42,
 16.74,18.22,19.48,20.77,22.09,25.79,29.48,34.92,41.44,48.31,
 63.94,84.03};
static float alpha05_nx064_nz26_fwhm200[32] = {
 5.87,6.38,6.80,7.31,7.86,8.37,9.05,9.80,10.42,10.91,
 11.55,11.99,12.54,13.81,14.92,16.46,18.09,19.68,22.35,24.88,
 27.27,29.51,31.68,33.94,36.07,42.46,48.99,57.79,69.34,81.93,
 111.48,146.68};
static float alpha05_nx064_nz26_fwhm225[32] = {
 8.41,9.06,9.76,10.43,11.27,11.97,13.10,14.19,15.18,15.96,
 16.88,17.65,18.35,20.17,21.91,24.05,26.46,28.78,32.85,36.70,
 40.20,43.77,46.87,50.24,53.28,63.45,72.78,86.26,104.03,124.19,
 167.75,223.43};
static float alpha05_nx064_nz26_fwhm250[32] = {
 11.12,12.24,13.05,14.09,15.15,16.05,17.78,19.28,20.57,21.71,
 22.84,23.99,24.79,27.56,30.00,32.80,35.99,39.06,44.54,49.60,
 54.65,59.48,63.85,68.74,73.13,86.69,99.97,118.31,143.04,169.00,
 229.43,303.29};
static float alpha05_nx064_nz26_fwhm275[32] = {
 14.15,15.49,16.49,17.88,19.37,20.57,22.76,24.68,26.33,27.90,
 29.27,30.58,31.78,35.33,38.26,41.95,46.65,50.45,57.69,64.37,
 70.82,76.82,82.54,88.77,94.82,112.11,129.19,153.00,182.29,216.41,
 296.00,387.00};
static float alpha05_nx064_nz26_fwhm300[32] = {
 17.27,18.84,20.35,21.87,23.65,25.36,28.02,30.48,32.41,34.32,
 35.93,37.63,39.30,43.73,47.66,52.29,57.55,62.52,71.58,80.60,
 88.27,96.32,104.03,111.10,118.29,139.21,160.61,188.18,225.12,266.44,
 358.67,471.70};
static float alpha05_nx064_nz26_fwhm325[32] = {
 20.46,22.49,24.34,26.32,28.60,30.48,33.81,36.47,38.96,41.32,
 43.45,45.47,47.43,52.52,57.16,63.15,69.50,75.93,86.83,97.30,
 106.95,116.07,124.12,133.25,142.86,167.63,191.48,225.64,269.53,316.83,
 427.60,567.75};
static float alpha05_nx064_nz26_fwhm350[32] = {
 24.13,26.48,28.46,30.80,33.38,35.51,39.47,42.73,45.68,48.38,
 50.84,53.22,55.52,61.71,66.89,74.21,81.66,88.90,102.07,114.07,
 124.94,136.22,147.21,157.06,166.06,195.67,224.69,262.88,315.57,373.50,
 501.62,662.20};
static float alpha05_nx064_nz26_fwhm375[32] = {
 27.45,30.28,32.40,35.11,38.13,40.91,45.16,48.93,52.64,56.06,
 58.89,61.83,63.98,71.30,77.92,85.54,94.50,102.90,118.19,132.25,
 146.20,157.63,169.73,181.94,193.80,226.45,259.67,304.12,367.69,433.25,
 578.83,764.43};
static float alpha05_nx064_nz26_fwhm400[32] = {
 30.74,33.53,36.30,39.48,43.10,46.11,51.44,56.24,60.38,63.86,
 67.06,70.45,73.36,81.64,89.15,98.03,108.27,117.70,134.95,151.47,
 165.94,181.36,194.80,208.19,220.43,257.80,295.38,350.00,420.60,493.67,
 656.40,858.00};
static float alpha05_nx064_nz26_fwhm425[32] = {
 34.12,37.75,40.76,44.36,48.04,51.70,58.32,63.38,67.90,72.00,
 75.76,79.23,82.82,93.00,100.65,110.86,123.00,133.94,153.38,171.22,
 188.14,204.27,218.53,233.27,249.75,292.14,336.71,394.91,473.25,555.50,
 734.00,964.25};
static float alpha05_nx064_nz26_fwhm450[32] = {
 37.64,41.47,45.34,49.29,53.93,58.22,64.38,70.40,75.65,80.50,
 84.55,88.84,92.83,102.70,112.53,124.50,137.36,148.64,171.11,191.53,
 209.69,227.21,242.68,260.31,277.88,327.44,375.40,437.50,529.30,617.20,
 822.20,1065.00};
static float alpha05_nx064_nz26_fwhm475[32] = {
 41.05,45.42,49.56,54.15,59.23,63.19,70.73,77.30,83.80,88.79,
 93.79,97.75,102.25,114.17,125.07,137.53,151.31,165.11,190.23,211.41,
 231.40,252.00,272.18,290.70,309.00,362.00,413.00,489.33,582.83,683.33,
 913.50,1180.50};
static float alpha05_nx064_nz26_fwhm500[32] = {
 44.59,49.92,53.81,58.46,64.22,68.96,77.62,84.95,91.67,96.96,
 102.38,107.32,112.00,125.00,136.33,150.17,166.40,181.17,208.64,231.79,
 255.33,276.50,298.89,319.50,339.60,398.50,455.62,540.00,642.67,752.00,
 999.50,1294.00};
static float *alpha05_nx064_nz26[21] = {
 alpha05_nx064_nz26_fwhm000, alpha05_nx064_nz26_fwhm025, alpha05_nx064_nz26_fwhm050, 
 alpha05_nx064_nz26_fwhm075, alpha05_nx064_nz26_fwhm100, alpha05_nx064_nz26_fwhm125, 
 alpha05_nx064_nz26_fwhm150, alpha05_nx064_nz26_fwhm175, alpha05_nx064_nz26_fwhm200, 
 alpha05_nx064_nz26_fwhm225, alpha05_nx064_nz26_fwhm250, alpha05_nx064_nz26_fwhm275, 
 alpha05_nx064_nz26_fwhm300, alpha05_nx064_nz26_fwhm325, alpha05_nx064_nz26_fwhm350, 
 alpha05_nx064_nz26_fwhm375, alpha05_nx064_nz26_fwhm400, alpha05_nx064_nz26_fwhm425, 
 alpha05_nx064_nz26_fwhm450, alpha05_nx064_nz26_fwhm475, alpha05_nx064_nz26_fwhm500} ;

static float alpha10_nx064_nz26_fwhm000[32] = {
 1.90,1.91,1.91,1.91,1.92,1.92,1.94,1.96,1.98,2.13,
 2.32,2.45,2.54,2.71,2.79,2.85,2.89,2.92,2.97,3.26,
 3.57,3.73,3.82,3.88,3.93,4.38,4.76,4.98,5.71,6.12,
 7.27,8.48};
static float alpha10_nx064_nz26_fwhm025[32] = {
 1.90,1.91,1.91,1.91,1.92,1.92,1.94,1.96,1.98,2.13,
 2.32,2.45,2.54,2.71,2.79,2.85,2.89,2.92,2.97,3.26,
 3.57,3.73,3.82,3.88,3.93,4.38,4.76,4.98,5.71,6.12,
 7.27,8.48};
static float alpha10_nx064_nz26_fwhm050[32] = {
 1.90,1.91,1.91,1.91,1.92,1.92,1.94,1.96,2.00,2.22,
 2.39,2.50,2.59,2.73,2.81,2.86,2.90,2.93,2.98,3.37,
 3.63,3.77,3.85,3.91,3.96,4.51,4.81,5.14,5.80,6.35,
 7.50,8.71};
static float alpha10_nx064_nz26_fwhm075[32] = {
 1.91,1.91,1.91,1.92,1.93,1.94,1.98,2.13,2.35,2.51,
 2.61,2.68,2.73,2.82,2.86,2.90,2.94,2.98,3.41,3.69,
 3.82,3.90,3.96,4.14,4.43,4.83,5.12,5.78,6.41,6.95,
 8.41,9.80};
static float alpha10_nx064_nz26_fwhm100[32] = {
 1.92,1.93,1.94,1.96,1.99,2.20,2.49,2.64,2.72,2.78,
 2.82,2.85,2.88,2.92,2.96,3.14,3.51,3.69,3.88,3.98,
 4.39,4.66,4.82,4.93,5.13,5.81,6.33,6.98,7.92,8.88,
 10.84,12.89};
static float alpha10_nx064_nz26_fwhm125[32] = {
 1.98,2.14,2.37,2.55,2.68,2.76,2.85,2.90,2.94,2.98,
 3.06,3.28,3.43,3.69,3.84,3.96,4.30,4.61,4.93,5.44,
 5.81,6.06,6.51,6.83,7.09,7.99,8.97,10.30,11.87,13.51,
 16.83,20.76};
static float alpha10_nx064_nz26_fwhm150[32] = {
 2.69,2.81,2.88,2.95,3.03,3.30,3.64,3.81,3.93,4.05,
 4.35,4.53,4.67,4.94,5.39,5.78,6.25,6.74,7.57,8.27,
 8.93,9.66,10.29,10.86,11.53,13.36,15.17,17.50,20.72,23.87,
 31.07,39.24};
static float alpha10_nx064_nz26_fwhm175[32] = {
 3.46,3.73,3.89,4.17,4.54,4.79,5.20,5.65,5.91,6.28,
 6.61,6.87,7.08,7.83,8.50,9.21,10.07,10.90,12.42,13.79,
 15.08,16.41,17.63,18.81,19.95,23.31,26.73,31.43,37.41,43.74,
 57.53,75.69};
static float alpha10_nx064_nz26_fwhm200[32] = {
 4.92,5.40,5.82,6.27,6.76,7.20,7.94,8.60,9.13,9.64,
 10.07,10.60,10.97,12.11,13.24,14.60,16.02,17.44,19.94,22.12,
 24.28,26.33,28.35,30.32,32.31,38.25,43.84,51.78,62.26,73.16,
 99.31,130.12};
static float alpha10_nx064_nz26_fwhm225[32] = {
 6.95,7.68,8.28,8.89,9.62,10.20,11.40,12.36,13.23,13.96,
 14.76,15.47,16.02,17.72,19.25,21.18,23.43,25.36,28.97,32.46,
 35.79,38.96,41.80,44.77,47.58,56.51,65.10,76.88,92.68,109.93,
 149.51,195.72};
static float alpha10_nx064_nz26_fwhm250[32] = {
 9.28,10.22,11.01,11.91,12.90,13.72,15.14,16.44,17.63,18.68,
 19.72,20.65,21.49,23.74,25.97,28.51,31.46,34.22,39.27,43.93,
 48.30,52.56,56.89,61.09,64.77,76.80,88.57,105.22,126.50,149.53,
 203.00,267.12};
static float alpha10_nx064_nz26_fwhm275[32] = {
 11.66,12.79,13.83,15.00,16.21,17.36,19.17,20.88,22.28,23.66,
 24.93,26.03,27.08,30.27,33.11,36.63,40.43,43.88,50.34,56.31,
 62.16,67.71,72.95,77.86,82.86,98.69,114.52,135.03,163.14,192.93,
 258.93,340.55};
static float alpha10_nx064_nz26_fwhm300[32] = {
 14.00,15.42,16.62,17.97,19.60,20.95,23.57,25.62,27.38,28.96,
 30.70,32.21,33.59,37.60,40.88,44.98,49.73,54.20,62.29,69.59,
 76.39,83.09,89.59,96.32,103.00,121.49,140.90,167.48,200.39,234.39,
 316.50,413.31};
static float alpha10_nx064_nz26_fwhm325[32] = {
 16.41,18.21,19.66,21.38,23.23,24.84,27.75,30.32,32.49,34.69,
 36.60,38.27,39.82,44.68,49.05,54.04,59.77,64.94,74.53,83.45,
 92.02,100.61,108.44,116.29,123.81,146.68,168.91,199.52,238.14,278.59,
 374.35,492.38};
static float alpha10_nx064_nz26_fwhm350[32] = {
 18.94,20.95,22.65,24.69,26.83,28.74,32.28,35.29,38.01,40.27,
 42.56,44.61,46.88,52.42,57.29,63.16,70.09,76.33,87.78,98.29,
 108.43,118.52,127.57,136.54,145.33,172.00,197.29,231.21,277.05,326.30,
 439.44,572.75};
static float alpha10_nx064_nz26_fwhm375[32] = {
 21.36,23.68,25.70,28.01,30.81,33.11,36.98,40.29,43.40,46.43,
 49.30,51.57,53.92,60.12,66.02,72.84,80.57,88.05,101.37,113.97,
 125.47,136.37,146.54,157.58,168.04,197.10,226.88,268.00,322.12,376.47,
 505.50,656.75};
static float alpha10_nx064_nz26_fwhm400[32] = {
 23.75,26.49,28.84,31.61,34.54,37.12,41.67,45.86,49.43,52.66,
 55.60,58.47,61.26,68.58,75.06,82.44,91.59,100.40,115.32,129.28,
 142.55,154.85,166.81,178.79,189.66,224.73,257.94,303.83,365.67,428.45,
 568.00,742.67};
static float alpha10_nx064_nz26_fwhm425[32] = {
 26.12,29.29,31.99,35.11,38.43,41.53,46.57,50.92,55.28,58.67,
 62.28,65.46,68.28,76.14,83.38,92.30,103.08,112.44,129.42,145.07,
 159.80,173.48,187.27,201.05,214.25,253.37,291.74,342.75,408.77,480.50,
 636.40,828.38};
static float alpha10_nx064_nz26_fwhm450[32] = {
 28.54,32.03,34.92,38.36,42.26,45.42,51.09,56.13,60.44,64.63,
 68.58,71.87,75.23,84.12,92.60,103.28,114.64,124.41,144.18,160.75,
 177.14,194.15,208.96,223.10,238.47,282.33,325.12,380.67,454.60,529.50,
 707.14,913.50};
static float alpha10_nx064_nz26_fwhm475[32] = {
 30.71,34.57,37.62,41.48,45.64,49.13,55.35,61.25,66.17,70.76,
 75.05,79.20,82.78,92.74,102.70,113.75,126.20,137.86,158.76,177.81,
 196.33,214.05,230.88,247.86,263.56,312.75,358.19,419.77,502.57,587.20,
 781.75,1007.25};
static float alpha10_nx064_nz26_fwhm500[32] = {
 32.48,36.56,40.16,44.56,49.02,53.17,60.73,66.58,72.18,77.43,
 81.55,85.95,90.07,101.67,112.22,124.60,138.29,150.87,173.18,195.92,
 215.43,234.45,253.61,272.69,290.80,343.00,391.78,461.92,550.50,643.20,
 854.80,1098.00};
static float *alpha10_nx064_nz26[21] = {
 alpha10_nx064_nz26_fwhm000, alpha10_nx064_nz26_fwhm025, alpha10_nx064_nz26_fwhm050, 
 alpha10_nx064_nz26_fwhm075, alpha10_nx064_nz26_fwhm100, alpha10_nx064_nz26_fwhm125, 
 alpha10_nx064_nz26_fwhm150, alpha10_nx064_nz26_fwhm175, alpha10_nx064_nz26_fwhm200, 
 alpha10_nx064_nz26_fwhm225, alpha10_nx064_nz26_fwhm250, alpha10_nx064_nz26_fwhm275, 
 alpha10_nx064_nz26_fwhm300, alpha10_nx064_nz26_fwhm325, alpha10_nx064_nz26_fwhm350, 
 alpha10_nx064_nz26_fwhm375, alpha10_nx064_nz26_fwhm400, alpha10_nx064_nz26_fwhm425, 
 alpha10_nx064_nz26_fwhm450, alpha10_nx064_nz26_fwhm475, alpha10_nx064_nz26_fwhm500} ;

static float **nx064_nz26[3] = {
  alpha01_nx064_nz26 , alpha05_nx064_nz26 , alpha10_nx064_nz26 };

static float alpha01_nx064_nz27_fwhm000[32] = {
 1.99,1.99,2.00,2.10,2.37,2.55,2.74,2.83,2.88,2.91,
 2.94,2.95,2.96,2.98,2.99,3.00,3.51,3.70,3.88,3.96,
 3.99,4.32,4.66,4.77,4.89,5.34,5.82,6.27,6.90,7.60,
 8.95,10.60};
static float alpha01_nx064_nz27_fwhm025[32] = {
 1.99,1.99,2.00,2.10,2.37,2.55,2.74,2.83,2.88,2.91,
 2.94,2.95,2.96,2.98,2.99,3.00,3.51,3.70,3.88,3.96,
 3.99,4.32,4.67,4.77,4.89,5.34,5.82,6.27,6.90,7.60,
 8.95,10.60};
static float alpha01_nx064_nz27_fwhm050[32] = {
 1.99,1.99,2.00,2.21,2.43,2.61,2.77,2.85,2.90,2.93,
 2.94,2.96,2.97,2.98,2.99,3.18,3.59,3.75,3.91,3.97,
 4.00,4.52,4.72,4.85,4.93,5.52,5.89,6.47,6.97,7.77,
 9.32,10.87};
static float alpha01_nx064_nz27_fwhm075[32] = {
 2.00,2.00,2.25,2.50,2.68,2.77,2.87,2.91,2.94,2.96,
 2.97,2.98,2.99,3.00,3.36,3.65,3.82,3.90,3.98,4.32,
 4.69,4.86,4.93,4.99,5.41,5.92,6.41,6.98,7.88,8.74,
 10.45,12.25};
static float alpha01_nx064_nz27_fwhm100[32] = {
 2.43,2.64,2.75,2.84,2.90,2.92,2.96,2.98,2.99,3.00,
 3.28,3.40,3.56,3.79,3.89,3.96,4.01,4.48,4.84,4.97,
 5.45,5.78,5.95,6.27,6.58,7.17,7.92,8.91,9.96,11.33,
 13.58,16.45};
static float alpha01_nx064_nz27_fwhm125[32] = {
 2.89,2.94,2.96,2.98,3.00,3.29,3.63,3.80,3.89,3.94,
 3.98,4.00,4.28,4.66,4.85,4.98,5.53,5.80,6.48,6.90,
 7.50,7.91,8.44,8.85,9.26,10.49,11.55,13.34,15.29,17.42,
 22.06,27.31};
static float alpha01_nx064_nz27_fwhm150[32] = {
 3.65,3.80,3.88,3.97,4.22,4.56,4.87,5.00,5.45,5.71,
 5.86,5.98,6.25,6.78,7.20,7.79,8.50,8.99,9.99,11.26,
 12.10,12.89,13.87,14.82,15.52,17.91,20.29,23.89,27.88,32.04,
 41.46,52.84};
static float alpha01_nx064_nz27_fwhm175[32] = {
 5.27,5.72,5.94,6.31,6.77,6.98,7.77,8.40,8.83,9.20,
 9.63,9.92,10.34,11.26,12.06,12.99,14.32,15.43,17.58,19.40,
 21.37,22.80,24.67,26.13,27.69,32.47,36.69,42.67,50.70,58.71,
 79.50,104.00};
static float alpha01_nx064_nz27_fwhm200[32] = {
 8.45,8.90,9.37,9.95,10.75,11.40,12.28,13.16,14.04,14.74,
 15.43,16.00,16.73,18.26,19.88,21.46,23.61,25.71,29.12,32.00,
 34.74,37.60,40.38,42.75,45.44,52.45,60.11,71.75,87.11,102.88,
 137.00,181.83};
static float alpha01_nx064_nz27_fwhm225[32] = {
 11.97,13.00,13.89,14.85,15.75,16.61,18.00,19.64,20.90,22.04,
 23.12,23.97,25.00,27.38,29.38,31.60,34.80,37.62,42.20,46.23,
 50.82,54.13,58.33,63.00,67.31,79.20,90.25,106.80,128.38,151.14,
 212.67,279.00};
static float alpha01_nx064_nz27_fwhm250[32] = {
 16.58,17.94,19.12,20.29,21.54,22.88,25.17,27.00,28.33,29.73,
 31.26,32.33,33.53,36.59,40.26,43.50,47.59,51.00,57.83,63.50,
 69.38,75.20,80.57,86.11,91.00,106.93,124.67,148.00,180.00,216.33,
 295.50,393.00};
static float alpha01_nx064_nz27_fwhm275[32] = {
 21.77,23.05,24.52,26.00,27.88,29.45,32.07,34.64,36.76,38.93,
 40.36,42.14,43.65,48.36,51.67,55.68,60.40,64.62,73.89,82.00,
 89.22,96.71,104.14,111.60,119.25,141.29,163.67,195.00,236.60,279.20,
 381.33,510.00};
static float alpha01_nx064_nz27_fwhm300[32] = {
 26.53,28.72,30.36,31.90,34.27,36.53,40.43,43.33,45.88,48.67,
 50.80,52.29,54.15,59.23,63.50,68.88,74.89,80.67,91.64,102.00,
 112.00,123.33,133.00,142.00,150.00,180.71,205.67,241.57,292.00,346.00,
 469.00,627.50};
static float alpha01_nx064_nz27_fwhm325[32] = {
 31.94,34.60,36.60,39.38,42.36,45.11,49.44,52.50,55.27,57.40,
 60.20,62.43,64.40,71.17,75.91,83.57,91.67,98.14,111.75,125.67,
 138.33,149.20,160.25,172.00,184.75,216.50,248.00,291.00,351.00,418.75,
 568.00,753.50};
static float alpha01_nx064_nz27_fwhm350[32] = {
 37.69,40.80,42.95,46.56,49.50,52.50,57.29,60.75,64.50,68.00,
 70.64,73.50,75.80,83.44,91.57,99.50,109.50,118.50,134.80,151.00,
 164.00,176.25,190.50,202.60,219.00,256.33,294.50,346.00,417.75,491.50,
 667.00,895.50};
static float alpha01_nx064_nz27_fwhm375[32] = {
 43.50,47.14,50.27,53.71,57.22,60.17,66.00,71.08,74.77,78.50,
 81.50,85.40,88.43,98.17,106.71,116.60,128.00,139.75,156.75,172.50,
 188.00,203.80,222.50,239.00,252.67,299.00,346.00,407.50,486.00,569.00,
 779.00,1019.00};
static float alpha01_nx064_nz27_fwhm400[32] = {
 49.69,53.45,57.33,61.14,65.80,69.80,75.80,80.60,85.33,89.83,
 95.00,98.50,103.17,115.20,124.50,135.75,148.20,159.50,177.00,199.00,
 217.67,239.50,256.33,278.40,294.88,342.50,391.50,462.33,558.00,654.00,
 891.00,1148.00};
static float alpha01_nx064_nz27_fwhm425[32] = {
 56.70,60.89,64.86,69.14,74.20,79.00,85.00,92.00,97.83,104.17,
 109.00,114.00,119.00,130.50,140.62,153.00,167.00,178.00,200.67,227.67,
 253.00,275.00,294.50,312.20,330.67,386.50,446.00,528.50,635.00,740.00,
 1003.00,1290.00};
static float alpha01_nx064_nz27_fwhm450[32] = {
 62.50,67.62,72.44,77.67,82.75,88.60,96.40,104.33,111.00,117.50,
 123.17,127.00,131.83,143.86,157.25,169.67,187.20,202.00,232.00,261.33,
 282.67,306.60,326.50,346.67,368.00,437.33,502.00,595.00,713.00,842.00,
 1126.00,1434.00};
static float alpha01_nx064_nz27_fwhm475[32] = {
 69.00,75.33,80.00,86.00,91.71,98.00,107.25,116.00,123.50,129.00,
 135.00,139.67,144.00,160.50,174.25,190.00,208.00,229.50,258.00,287.00,
 313.80,339.00,363.00,389.50,416.33,487.33,565.00,663.00,792.00,927.00,
 1220.00,1590.00};
static float alpha01_nx064_nz27_fwhm500[32] = {
 75.40,82.00,87.00,93.00,100.60,107.33,117.33,126.33,134.00,140.57,
 148.50,155.00,160.00,177.00,194.33,210.33,231.75,251.17,286.00,317.00,
 346.00,374.50,402.67,431.00,463.00,540.33,622.50,740.00,866.50,1025.00,
 1341.00,1766.00};
static float *alpha01_nx064_nz27[21] = {
 alpha01_nx064_nz27_fwhm000, alpha01_nx064_nz27_fwhm025, alpha01_nx064_nz27_fwhm050, 
 alpha01_nx064_nz27_fwhm075, alpha01_nx064_nz27_fwhm100, alpha01_nx064_nz27_fwhm125, 
 alpha01_nx064_nz27_fwhm150, alpha01_nx064_nz27_fwhm175, alpha01_nx064_nz27_fwhm200, 
 alpha01_nx064_nz27_fwhm225, alpha01_nx064_nz27_fwhm250, alpha01_nx064_nz27_fwhm275, 
 alpha01_nx064_nz27_fwhm300, alpha01_nx064_nz27_fwhm325, alpha01_nx064_nz27_fwhm350, 
 alpha01_nx064_nz27_fwhm375, alpha01_nx064_nz27_fwhm400, alpha01_nx064_nz27_fwhm425, 
 alpha01_nx064_nz27_fwhm450, alpha01_nx064_nz27_fwhm475, alpha01_nx064_nz27_fwhm500} ;

static float alpha05_nx064_nz27_fwhm000[32] = {
 1.95,1.95,1.96,1.96,1.97,1.97,1.99,2.13,2.39,2.56,
 2.66,2.73,2.78,2.86,2.90,2.93,2.96,2.98,3.32,3.66,
 3.80,3.88,3.94,3.98,4.18,4.76,4.96,5.56,5.97,6.68,
 7.81,8.98};
static float alpha05_nx064_nz27_fwhm025[32] = {
 1.95,1.95,1.96,1.96,1.97,1.97,1.99,2.13,2.39,2.56,
 2.66,2.73,2.78,2.86,2.90,2.93,2.96,2.98,3.32,3.66,
 3.80,3.88,3.94,3.98,4.18,4.76,4.96,5.56,5.97,6.68,
 7.81,8.98};
static float alpha05_nx064_nz27_fwhm050[32] = {
 1.95,1.95,1.96,1.96,1.97,1.97,1.99,2.24,2.47,2.61,
 2.70,2.76,2.80,2.87,2.91,2.94,2.97,2.99,3.44,3.71,
 3.84,3.91,3.96,4.00,4.33,4.82,4.99,5.68,6.12,6.79,
 7.94,9.34};
static float alpha05_nx064_nz27_fwhm075[32] = {
 1.96,1.96,1.96,1.97,1.98,1.99,2.33,2.56,2.69,2.76,
 2.81,2.85,2.87,2.92,2.95,2.97,3.01,3.38,3.74,3.87,
 3.95,4.00,4.36,4.61,4.78,5.02,5.66,6.06,6.84,7.58,
 8.95,10.63};
static float alpha05_nx064_nz27_fwhm100[32] = {
 1.97,1.98,1.99,2.18,2.45,2.59,2.75,2.83,2.88,2.91,
 2.93,2.94,2.96,2.99,3.30,3.60,3.79,3.88,3.99,4.49,
 4.76,4.91,5.00,5.45,5.69,6.18,6.84,7.69,8.67,9.66,
 11.69,13.94};
static float alpha05_nx064_nz27_fwhm125[32] = {
 2.37,2.58,2.69,2.79,2.86,2.90,2.95,2.99,3.19,3.44,
 3.59,3.69,3.77,3.90,3.98,4.41,4.73,4.89,5.48,5.87,
 6.32,6.73,7.00,7.50,7.80,8.84,9.85,11.20,12.85,14.76,
 18.49,22.70};
static float alpha05_nx064_nz27_fwhm150[32] = {
 2.90,2.96,3.00,3.33,3.58,3.74,3.91,4.13,4.44,4.65,
 4.80,4.91,4.99,5.58,5.91,6.46,6.91,7.46,8.38,9.21,
 9.93,10.72,11.47,12.05,12.81,14.90,16.82,19.55,23.02,26.77,
 34.51,43.43};
static float alpha05_nx064_nz27_fwhm175[32] = {
 3.92,4.27,4.60,4.86,5.11,5.51,5.95,6.49,6.84,7.24,
 7.63,7.90,8.20,8.97,9.77,10.61,11.54,12.41,14.14,15.64,
 17.10,18.47,19.86,21.20,22.55,26.40,30.16,35.62,41.92,48.76,
 64.12,83.84};
static float alpha05_nx064_nz27_fwhm200[32] = {
 6.00,6.63,7.05,7.63,8.16,8.69,9.45,10.14,10.86,11.47,
 11.99,12.54,12.91,14.10,15.36,16.79,18.45,19.93,22.80,25.57,
 27.96,30.37,32.44,34.70,36.81,43.12,49.63,58.48,69.66,82.38,
 110.00,145.32};
static float alpha05_nx064_nz27_fwhm225[32] = {
 8.81,9.57,10.16,10.82,11.67,12.36,13.61,14.71,15.66,16.63,
 17.42,18.15,18.84,20.71,22.43,24.65,27.18,29.47,33.62,37.29,
 40.75,44.26,47.37,50.65,54.24,63.78,72.98,86.47,103.68,123.06,
 167.19,223.50};
static float alpha05_nx064_nz27_fwhm250[32] = {
 11.64,12.68,13.53,14.56,15.72,16.67,18.38,19.83,21.19,22.38,
 23.48,24.46,25.52,28.00,30.34,33.33,36.72,39.66,45.06,50.64,
 55.12,59.84,63.96,68.53,73.17,86.60,100.21,118.41,142.94,168.70,
 229.81,303.85};
static float alpha05_nx064_nz27_fwhm275[32] = {
 14.83,15.99,17.15,18.53,20.00,21.34,23.42,25.33,26.89,28.47,
 29.94,31.25,32.67,35.97,38.92,42.34,46.77,50.66,57.68,64.37,
 70.50,77.15,82.63,88.42,94.24,111.89,129.10,151.86,184.47,217.57,
 292.00,389.00};
static float alpha05_nx064_nz27_fwhm300[32] = {
 18.15,19.73,21.21,23.05,24.59,25.93,28.67,31.11,33.20,35.06,
 36.74,38.23,39.67,43.79,47.50,52.16,57.64,62.05,71.62,79.67,
 87.35,95.07,102.39,109.65,116.95,137.50,159.52,188.90,228.50,268.50,
 364.11,477.20};
static float alpha05_nx064_nz27_fwhm325[32] = {
 21.53,23.39,24.91,27.05,28.97,30.96,33.90,36.55,39.23,41.54,
 43.71,45.81,47.74,53.02,57.27,62.54,69.07,74.89,85.81,95.71,
 105.47,114.08,123.23,132.06,139.91,167.06,192.67,227.46,273.86,320.00,
 434.43,576.75};
static float alpha05_nx064_nz27_fwhm350[32] = {
 24.61,26.87,28.84,31.11,33.58,35.61,39.42,43.05,46.17,48.93,
 51.55,53.84,55.92,61.74,67.00,73.41,81.48,88.62,101.70,113.48,
 124.85,136.36,146.67,157.09,167.11,197.33,226.30,268.00,320.33,378.64,
 512.75,670.20};
static float alpha05_nx064_nz27_fwhm375[32] = {
 28.02,30.79,33.17,35.38,38.23,41.16,45.76,49.53,52.80,55.88,
 58.89,61.74,64.12,71.04,77.59,85.93,94.77,102.90,118.40,132.23,
 145.55,158.26,170.28,181.84,194.38,228.11,262.53,309.71,370.75,435.40,
 592.89,772.50};
static float alpha05_nx064_nz27_fwhm400[32] = {
 31.28,34.07,36.90,39.91,43.33,46.46,51.67,56.53,60.39,63.39,
 66.96,69.76,73.00,82.04,88.90,97.68,107.83,117.78,135.06,151.78,
 166.76,180.69,194.27,209.00,221.73,260.22,300.67,352.40,423.43,501.20,
 670.00,870.25};
static float alpha05_nx064_nz27_fwhm425[32] = {
 34.78,38.50,41.47,45.03,48.62,52.11,58.13,63.25,67.79,71.61,
 75.50,79.21,82.64,91.81,100.15,110.45,121.90,132.95,153.59,170.35,
 187.67,204.67,220.40,235.57,249.93,294.62,336.33,395.45,479.50,566.20,
 757.20,976.29};
static float alpha05_nx064_nz27_fwhm450[32] = {
 38.30,42.28,46.00,49.55,53.79,57.39,64.22,69.67,75.00,79.81,
 84.33,88.39,91.79,102.69,112.18,123.76,136.31,148.80,171.60,191.64,
 210.29,230.15,246.50,263.50,280.19,327.38,376.83,445.00,537.33,628.67,
 840.00,1081.00};
static float alpha05_nx064_nz27_fwhm475[32] = {
 41.67,45.78,49.48,53.79,58.56,62.85,70.43,77.00,82.50,87.59,
 93.00,97.50,101.57,113.57,124.65,136.35,151.00,164.53,189.79,212.50,
 234.00,254.17,273.00,291.73,310.86,364.60,417.22,495.17,594.00,701.60,
 919.25,1193.71};
static float alpha05_nx064_nz27_fwhm500[32] = {
 44.86,49.43,53.25,58.23,63.39,68.58,76.71,83.56,90.30,96.41,
 101.30,106.64,111.95,124.60,135.90,150.69,166.65,181.70,208.00,235.00,
 258.46,279.08,299.60,321.00,341.00,400.43,462.27,544.67,655.00,765.33,
 1009.33,1301.00};
static float *alpha05_nx064_nz27[21] = {
 alpha05_nx064_nz27_fwhm000, alpha05_nx064_nz27_fwhm025, alpha05_nx064_nz27_fwhm050, 
 alpha05_nx064_nz27_fwhm075, alpha05_nx064_nz27_fwhm100, alpha05_nx064_nz27_fwhm125, 
 alpha05_nx064_nz27_fwhm150, alpha05_nx064_nz27_fwhm175, alpha05_nx064_nz27_fwhm200, 
 alpha05_nx064_nz27_fwhm225, alpha05_nx064_nz27_fwhm250, alpha05_nx064_nz27_fwhm275, 
 alpha05_nx064_nz27_fwhm300, alpha05_nx064_nz27_fwhm325, alpha05_nx064_nz27_fwhm350, 
 alpha05_nx064_nz27_fwhm375, alpha05_nx064_nz27_fwhm400, alpha05_nx064_nz27_fwhm425, 
 alpha05_nx064_nz27_fwhm450, alpha05_nx064_nz27_fwhm475, alpha05_nx064_nz27_fwhm500} ;

static float alpha10_nx064_nz27_fwhm000[32] = {
 1.90,1.90,1.91,1.91,1.91,1.92,1.94,1.96,1.98,2.11,
 2.32,2.46,2.55,2.71,2.79,2.85,2.90,2.92,2.97,3.28,
 3.57,3.72,3.82,3.88,3.94,4.42,4.78,5.00,5.73,6.17,
 7.30,8.48};
static float alpha10_nx064_nz27_fwhm025[32] = {
 1.90,1.90,1.91,1.91,1.91,1.92,1.94,1.96,1.98,2.11,
 2.32,2.46,2.55,2.71,2.79,2.85,2.90,2.92,2.97,3.28,
 3.57,3.72,3.82,3.88,3.94,4.42,4.78,5.00,5.73,6.17,
 7.30,8.48};
static float alpha10_nx064_nz27_fwhm050[32] = {
 1.90,1.90,1.91,1.91,1.92,1.92,1.94,1.96,1.99,2.21,
 2.40,2.51,2.59,2.74,2.81,2.86,2.90,2.93,2.99,3.39,
 3.63,3.77,3.85,3.91,3.96,4.53,4.83,5.19,5.82,6.37,
 7.53,8.71};
static float alpha10_nx064_nz27_fwhm075[32] = {
 1.91,1.91,1.91,1.92,1.93,1.94,1.97,2.11,2.37,2.51,
 2.62,2.68,2.73,2.82,2.87,2.91,2.94,2.98,3.44,3.69,
 3.82,3.90,3.96,4.14,4.45,4.85,5.16,5.79,6.42,6.95,
 8.41,9.84};
static float alpha10_nx064_nz27_fwhm100[32] = {
 1.92,1.93,1.94,1.96,1.99,2.17,2.49,2.65,2.73,2.79,
 2.83,2.85,2.88,2.93,2.97,3.15,3.52,3.70,3.88,3.98,
 4.41,4.68,4.83,4.95,5.18,5.82,6.36,7.00,7.95,8.91,
 10.85,12.91};
static float alpha10_nx064_nz27_fwhm125[32] = {
 1.98,2.14,2.36,2.55,2.68,2.76,2.85,2.90,2.94,2.98,
 3.10,3.30,3.45,3.69,3.83,3.95,4.31,4.61,4.94,5.46,
 5.82,6.07,6.57,6.86,7.15,8.10,9.04,10.33,11.83,13.54,
 16.97,20.82};
static float alpha10_nx064_nz27_fwhm150[32] = {
 2.71,2.81,2.88,2.94,3.02,3.32,3.64,3.82,3.93,4.05,
 4.33,4.52,4.67,4.94,5.41,5.83,6.32,6.77,7.61,8.38,
 9.02,9.74,10.40,10.98,11.67,13.50,15.31,17.74,20.91,24.19,
 31.48,39.68};
static float alpha10_nx064_nz27_fwhm175[32] = {
 3.49,3.76,3.92,4.22,4.58,4.81,5.25,5.71,5.98,6.41,
 6.71,6.94,7.23,7.96,8.66,9.44,10.32,11.02,12.58,13.98,
 15.33,16.58,17.91,19.03,20.28,23.76,27.18,31.91,37.91,44.44,
 58.31,75.57};
static float alpha10_nx064_nz27_fwhm200[32] = {
 4.98,5.58,5.94,6.45,6.89,7.37,8.14,8.77,9.34,9.87,
 10.45,10.86,11.33,12.43,13.54,14.89,16.41,17.66,20.13,22.47,
 24.66,26.94,28.88,30.91,32.93,38.80,44.44,52.33,62.58,73.26,
 98.93,129.84};
static float alpha10_nx064_nz27_fwhm225[32] = {
 7.26,7.96,8.53,9.14,9.82,10.50,11.64,12.64,13.54,14.38,
 15.08,15.75,16.39,18.17,19.74,21.62,23.78,25.76,29.42,32.95,
 36.06,39.24,42.35,45.38,48.36,56.81,65.01,77.21,93.16,109.29,
 149.21,197.40};
static float alpha10_nx064_nz27_fwhm250[32] = {
 9.57,10.48,11.26,12.23,13.19,14.15,15.71,16.92,18.08,19.16,
 20.25,21.15,21.95,24.31,26.44,28.97,31.82,34.70,39.85,44.49,
 48.79,53.10,57.29,61.18,65.02,76.41,88.24,104.25,126.89,149.59,
 204.25,269.87};
static float alpha10_nx064_nz27_fwhm275[32] = {
 12.00,13.22,14.21,15.45,16.70,17.86,19.85,21.54,23.06,24.49,
 25.69,26.84,27.96,31.06,33.81,37.06,40.83,44.34,50.82,56.56,
 62.12,67.67,73.24,77.86,83.12,98.47,113.72,134.21,162.45,192.34,
 258.73,341.81};
static float alpha10_nx064_nz27_fwhm300[32] = {
 14.56,15.93,17.16,18.69,20.27,21.72,24.11,26.20,27.88,29.70,
 31.15,32.61,34.02,37.90,41.37,45.51,50.04,54.27,62.69,70.03,
 76.84,83.30,89.70,96.05,102.62,121.62,140.46,166.47,201.43,235.95,
 317.38,418.93};
static float alpha10_nx064_nz27_fwhm325[32] = {
 17.00,18.75,20.28,22.01,23.99,25.59,28.40,30.81,32.89,34.93,
 36.86,38.76,40.43,45.23,49.05,54.36,60.03,65.28,74.62,83.92,
 91.93,100.29,108.22,115.78,122.70,146.39,168.91,200.00,239.26,280.45,
 379.50,501.33};
static float alpha10_nx064_nz27_fwhm350[32] = {
 19.57,21.61,23.29,25.43,27.59,29.56,32.95,35.77,38.51,40.81,
 43.25,45.27,47.35,52.79,57.68,63.51,70.25,76.35,87.53,98.02,
 108.21,117.14,125.98,135.54,144.71,172.26,199.00,234.36,278.90,329.67,
 446.14,584.45};
static float alpha10_nx064_nz27_fwhm375[32] = {
 21.96,24.29,26.24,28.66,31.52,33.71,37.68,41.10,44.12,46.86,
 49.59,51.97,54.40,60.55,66.11,72.80,80.50,87.80,100.82,113.34,
 124.20,135.60,146.69,156.75,167.22,198.47,228.58,269.10,322.43,377.86,
 512.08,670.75};
static float alpha10_nx064_nz27_fwhm400[32] = {
 24.39,27.02,29.29,32.28,35.23,37.88,42.33,46.39,49.78,53.07,
 56.03,58.96,61.36,68.43,74.89,82.67,91.51,99.63,115.15,129.60,
 142.28,154.45,167.43,179.46,191.64,227.13,261.00,307.16,365.88,429.38,
 575.75,752.50};
static float alpha10_nx064_nz27_fwhm425[32] = {
 26.42,29.75,32.51,35.56,39.00,41.93,46.97,51.50,55.48,59.20,
 62.56,65.76,68.48,76.11,83.89,92.86,103.26,112.67,130.35,145.23,
 160.10,175.26,190.00,202.82,216.45,255.81,291.92,344.45,410.78,479.75,
 650.20,837.80};
static float alpha10_nx064_nz27_fwhm450[32] = {
 28.85,32.41,35.52,38.83,42.71,45.96,51.79,56.91,61.15,65.20,
 68.79,72.22,75.87,85.10,93.04,103.38,114.73,125.68,144.64,162.74,
 179.86,195.61,211.55,226.60,240.72,283.65,327.55,383.29,456.30,535.00,
 720.00,921.67};
static float alpha10_nx064_nz27_fwhm475[32] = {
 31.12,34.92,38.32,42.27,46.38,50.00,56.24,61.77,66.93,71.46,
 75.53,79.68,83.39,93.50,102.56,113.81,127.03,137.96,160.41,180.50,
 198.73,216.18,233.29,250.11,266.05,314.21,361.40,422.38,504.60,592.60,
 790.50,1014.43};
static float alpha10_nx064_nz27_fwhm500[32] = {
 32.85,37.04,40.71,45.14,49.72,53.59,60.70,66.89,72.39,77.56,
 82.50,86.74,90.84,102.03,112.19,124.71,138.52,151.93,176.88,197.18,
 217.48,237.33,255.67,274.93,293.00,344.71,397.21,464.81,554.71,654.12,
 864.67,1109.50};
static float *alpha10_nx064_nz27[21] = {
 alpha10_nx064_nz27_fwhm000, alpha10_nx064_nz27_fwhm025, alpha10_nx064_nz27_fwhm050, 
 alpha10_nx064_nz27_fwhm075, alpha10_nx064_nz27_fwhm100, alpha10_nx064_nz27_fwhm125, 
 alpha10_nx064_nz27_fwhm150, alpha10_nx064_nz27_fwhm175, alpha10_nx064_nz27_fwhm200, 
 alpha10_nx064_nz27_fwhm225, alpha10_nx064_nz27_fwhm250, alpha10_nx064_nz27_fwhm275, 
 alpha10_nx064_nz27_fwhm300, alpha10_nx064_nz27_fwhm325, alpha10_nx064_nz27_fwhm350, 
 alpha10_nx064_nz27_fwhm375, alpha10_nx064_nz27_fwhm400, alpha10_nx064_nz27_fwhm425, 
 alpha10_nx064_nz27_fwhm450, alpha10_nx064_nz27_fwhm475, alpha10_nx064_nz27_fwhm500} ;

static float **nx064_nz27[3] = {
  alpha01_nx064_nz27 , alpha05_nx064_nz27 , alpha10_nx064_nz27 };

static float alpha01_nx064_nz28_fwhm000[32] = {
 1.99,1.99,2.00,2.00,2.36,2.56,2.77,2.85,2.89,2.92,
 2.94,2.95,2.96,2.98,2.99,3.00,3.45,3.70,3.90,3.97,
 4.00,4.43,4.68,4.80,4.90,5.22,5.79,6.31,6.92,7.75,
 8.97,10.54};
static float alpha01_nx064_nz28_fwhm025[32] = {
 1.99,1.99,2.00,2.00,2.36,2.56,2.77,2.85,2.89,2.92,
 2.94,2.95,2.96,2.98,2.99,3.00,3.45,3.70,3.90,3.97,
 4.00,4.43,4.68,4.80,4.90,5.22,5.79,6.31,6.92,7.75,
 8.97,10.54};
static float alpha01_nx064_nz28_fwhm050[32] = {
 1.99,1.99,2.00,2.12,2.43,2.62,2.80,2.86,2.90,2.93,
 2.94,2.95,2.96,2.98,2.99,3.08,3.56,3.76,3.92,3.98,
 4.18,4.57,4.76,4.86,4.93,5.47,5.87,6.55,6.98,7.87,
 9.33,10.84};
static float alpha01_nx064_nz28_fwhm075[32] = {
 2.00,2.00,2.26,2.56,2.71,2.79,2.88,2.92,2.94,2.96,
 2.97,2.98,2.98,3.00,3.25,3.63,3.83,3.91,3.99,4.43,
 4.73,4.88,4.94,5.02,5.38,5.91,6.52,7.08,7.95,8.83,
 10.45,12.24};
static float alpha01_nx064_nz28_fwhm100[32] = {
 2.46,2.66,2.78,2.85,2.90,2.93,2.96,2.98,2.99,2.99,
 3.08,3.38,3.55,3.79,3.89,3.97,4.05,4.55,4.88,4.99,
 5.46,5.79,5.95,6.18,6.55,7.29,7.92,8.86,9.93,11.21,
 13.93,16.63};
static float alpha01_nx064_nz28_fwhm125[32] = {
 2.90,2.94,2.96,2.98,3.00,3.29,3.62,3.78,3.87,3.93,
 3.97,4.02,4.29,4.69,4.90,5.01,5.53,5.86,6.47,6.97,
 7.50,7.86,8.27,8.69,9.00,10.42,11.72,13.50,15.36,17.36,
 21.95,26.94};
static float alpha01_nx064_nz28_fwhm150[32] = {
 3.61,3.79,3.93,4.06,4.50,4.66,4.88,5.00,5.50,5.77,
 5.91,6.03,6.32,6.82,7.17,7.79,8.36,8.90,10.12,11.10,
 11.99,12.80,13.81,14.65,15.50,17.98,20.34,23.55,27.49,31.58,
 41.15,51.91};
static float alpha01_nx064_nz28_fwhm175[32] = {
 5.32,5.64,5.86,6.22,6.74,7.08,7.74,8.26,8.77,9.13,
 9.64,9.97,10.31,11.12,11.91,12.94,14.18,15.39,17.56,18.99,
 20.96,22.70,23.95,25.85,27.70,32.11,36.80,43.29,50.85,59.28,
 80.08,104.00};
static float alpha01_nx064_nz28_fwhm200[32] = {
 8.11,8.76,9.33,9.89,10.54,10.96,12.05,12.94,13.76,14.74,
 15.45,16.14,16.59,18.42,19.59,21.35,23.16,24.97,28.74,31.46,
 34.40,37.24,40.00,42.93,45.61,53.29,60.36,71.69,86.83,103.12,
 140.00,183.00};
static float alpha01_nx064_nz28_fwhm225[32] = {
 11.80,12.78,13.58,14.48,15.55,16.33,17.89,19.38,20.65,21.61,
 22.35,23.44,24.35,26.93,28.88,31.43,34.37,36.78,42.27,47.27,
 51.70,56.05,60.11,63.67,67.75,80.10,91.29,110.83,131.00,154.60,
 213.67,282.00};
static float alpha01_nx064_nz28_fwhm250[32] = {
 15.96,17.20,18.31,19.72,21.11,22.48,24.33,26.35,27.83,29.25,
 30.95,32.45,33.60,36.70,40.00,44.22,48.20,52.12,58.67,64.70,
 70.73,76.69,82.11,88.20,92.92,110.57,127.00,149.67,181.00,217.25,
 297.75,399.33};
static float alpha01_nx064_nz28_fwhm275[32] = {
 20.63,22.38,23.93,25.75,27.38,28.90,32.00,34.65,37.00,38.79,
 40.74,42.75,43.95,48.74,52.25,57.27,62.38,66.78,76.53,84.71,
 93.25,100.00,107.33,114.00,120.43,145.00,165.00,198.80,239.50,288.00,
 388.00,509.50};
static float alpha01_nx064_nz28_fwhm300[32] = {
 26.06,28.29,30.36,32.37,34.70,36.85,40.55,43.17,46.33,48.36,
 50.53,52.86,55.18,60.65,65.37,71.00,77.75,84.44,94.91,105.20,
 114.38,123.33,135.00,146.25,154.33,183.00,213.67,251.33,299.80,349.67,
 482.50,629.00};
static float alpha01_nx064_nz28_fwhm325[32] = {
 32.39,34.93,37.00,39.44,41.81,44.25,48.89,52.33,56.00,59.83,
 62.42,64.30,66.67,73.67,78.40,85.33,93.33,100.20,114.17,127.70,
 143.00,153.00,165.25,177.50,189.25,224.00,255.50,302.40,362.00,429.50,
 572.50,749.00};
static float alpha01_nx064_nz28_fwhm350[32] = {
 38.38,41.13,43.67,46.40,49.80,52.45,56.84,61.81,66.08,69.80,
 72.67,75.78,78.40,86.12,92.86,100.86,111.88,122.25,137.60,155.29,
 169.50,183.25,198.33,212.50,225.20,262.33,301.17,356.00,430.00,506.25,
 672.50,898.00};
static float alpha01_nx064_nz28_fwhm375[32] = {
 43.86,47.22,49.92,53.25,56.50,60.73,66.46,72.11,76.25,80.54,
 84.75,88.14,91.50,101.33,109.67,121.00,131.20,143.40,161.62,180.50,
 197.00,213.25,227.00,245.00,259.86,304.25,349.00,419.00,496.00,578.67,
 777.00,1063.00};
static float alpha01_nx064_nz28_fwhm400[32] = {
 50.18,53.44,56.57,61.22,64.86,68.71,76.83,82.29,88.12,93.83,
 98.00,102.33,106.80,117.60,127.40,138.40,151.14,163.50,185.17,206.00,
 224.50,242.57,262.40,278.00,294.00,348.67,405.00,473.50,558.00,662.50,
 916.50,1191.00};
static float alpha01_nx064_nz28_fwhm425[32] = {
 55.80,60.60,64.14,69.30,75.12,79.43,88.00,94.33,101.50,107.50,
 112.50,117.40,121.50,134.00,144.50,157.33,173.00,187.83,211.00,235.00,
 254.50,275.50,296.00,318.00,340.33,401.00,456.00,530.50,637.00,762.00,
 1023.50,1344.00};
static float alpha01_nx064_nz28_fwhm450[32] = {
 63.20,68.29,73.00,78.38,84.40,89.67,98.62,107.00,114.75,120.00,
 126.25,131.20,135.67,151.00,163.00,178.33,196.33,210.50,237.67,265.33,
 286.33,313.50,337.50,359.00,383.00,444.50,514.50,604.33,729.00,869.33,
 1147.00,1475.00};
static float alpha01_nx064_nz28_fwhm475[32] = {
 70.33,77.00,82.11,88.50,95.00,100.83,111.00,119.00,127.50,134.00,
 140.75,146.25,151.60,166.88,182.75,199.33,216.86,236.00,264.00,294.67,
 322.50,351.17,377.00,400.50,428.00,503.60,575.00,682.67,817.00,947.50,
 1257.00,1614.33};
static float alpha01_nx064_nz28_fwhm500[32] = {
 78.33,84.75,91.00,98.40,105.38,112.00,121.75,131.33,138.71,147.67,
 155.25,160.50,168.00,185.75,202.00,221.00,243.00,260.25,292.40,327.50,
 357.00,389.50,419.00,443.00,473.33,560.00,643.25,745.00,895.00,1042.50,
 1369.50,1755.00};
static float *alpha01_nx064_nz28[21] = {
 alpha01_nx064_nz28_fwhm000, alpha01_nx064_nz28_fwhm025, alpha01_nx064_nz28_fwhm050, 
 alpha01_nx064_nz28_fwhm075, alpha01_nx064_nz28_fwhm100, alpha01_nx064_nz28_fwhm125, 
 alpha01_nx064_nz28_fwhm150, alpha01_nx064_nz28_fwhm175, alpha01_nx064_nz28_fwhm200, 
 alpha01_nx064_nz28_fwhm225, alpha01_nx064_nz28_fwhm250, alpha01_nx064_nz28_fwhm275, 
 alpha01_nx064_nz28_fwhm300, alpha01_nx064_nz28_fwhm325, alpha01_nx064_nz28_fwhm350, 
 alpha01_nx064_nz28_fwhm375, alpha01_nx064_nz28_fwhm400, alpha01_nx064_nz28_fwhm425, 
 alpha01_nx064_nz28_fwhm450, alpha01_nx064_nz28_fwhm475, alpha01_nx064_nz28_fwhm500} ;

static float alpha05_nx064_nz28_fwhm000[32] = {
 1.95,1.95,1.96,1.96,1.97,1.97,1.99,2.22,2.43,2.59,
 2.67,2.73,2.78,2.86,2.91,2.94,2.96,2.98,3.38,3.69,
 3.82,3.90,3.95,3.99,4.25,4.76,4.95,5.59,5.99,6.75,
 7.85,9.03};
static float alpha05_nx064_nz28_fwhm025[32] = {
 1.95,1.95,1.96,1.96,1.97,1.97,1.99,2.22,2.43,2.59,
 2.67,2.73,2.78,2.86,2.91,2.94,2.96,2.98,3.38,3.69,
 3.82,3.90,3.95,3.99,4.25,4.76,4.95,5.59,5.99,6.75,
 7.85,9.03};
static float alpha05_nx064_nz28_fwhm050[32] = {
 1.95,1.95,1.96,1.96,1.97,1.98,2.00,2.30,2.51,2.63,
 2.70,2.76,2.80,2.88,2.91,2.94,2.97,2.99,3.48,3.74,
 3.85,3.92,3.97,4.08,4.40,4.82,4.99,5.71,6.19,6.86,
 7.97,9.40};
static float alpha05_nx064_nz28_fwhm075[32] = {
 1.96,1.96,1.96,1.97,1.98,2.00,2.37,2.58,2.70,2.77,
 2.81,2.85,2.87,2.92,2.95,2.97,3.06,3.44,3.76,3.89,
 3.96,4.12,4.45,4.66,4.79,5.00,5.68,6.13,6.88,7.68,
 9.01,10.62};
static float alpha05_nx064_nz28_fwhm100[32] = {
 1.97,1.98,1.99,2.22,2.46,2.61,2.75,2.83,2.87,2.90,
 2.92,2.94,2.96,2.99,3.32,3.62,3.79,3.90,4.05,4.55,
 4.78,4.92,5.03,5.44,5.68,6.31,6.88,7.71,8.70,9.69,
 11.73,14.00};
static float alpha05_nx064_nz28_fwhm125[32] = {
 2.40,2.60,2.71,2.80,2.86,2.90,2.95,2.98,3.11,3.36,
 3.56,3.67,3.76,3.90,3.99,4.44,4.75,4.92,5.51,5.90,
 6.33,6.75,6.99,7.48,7.82,8.88,9.91,11.15,13.00,14.81,
 18.56,22.77};
static float alpha05_nx064_nz28_fwhm150[32] = {
 2.90,2.95,2.99,3.33,3.62,3.77,3.94,4.15,4.51,4.73,
 4.85,4.95,5.10,5.64,5.93,6.45,6.93,7.48,8.36,9.17,
 9.94,10.73,11.44,12.04,12.82,14.73,16.75,19.50,22.77,26.48,
 34.22,43.27};
static float alpha05_nx064_nz28_fwhm175[32] = {
 3.99,4.37,4.65,4.88,5.18,5.54,5.92,6.47,6.84,7.17,
 7.57,7.85,8.13,8.92,9.67,10.51,11.46,12.30,13.98,15.57,
 16.99,18.44,19.75,21.06,22.28,26.17,30.06,35.30,41.83,49.22,
 65.36,85.00};
static float alpha05_nx064_nz28_fwhm200[32] = {
 5.93,6.47,6.90,7.44,7.99,8.51,9.34,10.00,10.68,11.25,
 11.77,12.23,12.75,14.02,15.21,16.62,18.23,19.62,22.46,24.93,
 27.50,29.87,32.22,34.28,36.80,42.99,49.40,58.68,70.12,83.08,
 111.74,149.20};
static float alpha05_nx064_nz28_fwhm225[32] = {
 8.66,9.36,9.91,10.73,11.53,12.18,13.46,14.47,15.47,16.36,
 17.07,17.83,18.52,20.47,22.17,24.38,26.80,29.11,33.29,37.11,
 40.94,44.59,47.93,51.00,54.53,64.13,73.41,87.44,105.27,124.83,
 169.05,224.54};
static float alpha05_nx064_nz28_fwhm250[32] = {
 11.54,12.53,13.32,14.43,15.50,16.39,18.22,19.80,20.98,22.15,
 23.20,24.29,25.26,27.87,30.44,33.47,36.80,39.94,45.51,50.95,
 55.85,60.65,65.15,69.56,74.19,87.48,101.17,119.36,143.50,169.76,
 232.86,312.62};
static float alpha05_nx064_nz28_fwhm275[32] = {
 14.70,15.89,17.09,18.49,19.87,21.11,23.41,25.40,27.08,28.82,
 30.13,31.47,32.71,36.33,39.51,43.38,47.52,51.69,59.17,65.58,
 71.59,77.17,83.34,89.32,95.12,112.07,129.96,153.27,183.93,218.94,
 300.11,399.55};
static float alpha05_nx064_nz28_fwhm300[32] = {
 18.00,19.66,21.10,22.71,24.53,26.28,29.15,31.52,33.68,35.51,
 37.31,38.91,40.68,45.00,49.00,54.00,59.41,64.30,72.74,80.86,
 88.86,96.85,103.93,110.92,118.47,139.77,161.67,191.23,230.00,272.08,
 372.43,491.83};
static float alpha05_nx064_nz28_fwhm325[32] = {
 21.64,23.52,25.43,27.39,29.48,31.45,34.80,37.78,40.57,42.84,
 45.03,47.00,48.93,54.29,59.02,64.68,71.36,76.86,87.85,97.79,
 106.70,116.44,125.76,134.12,142.56,167.65,194.71,230.73,277.33,325.62,
 446.29,583.78};
static float alpha05_nx064_nz28_fwhm350[32] = {
 25.19,27.46,29.55,31.97,34.59,37.02,40.98,44.40,47.50,50.02,
 52.70,54.84,57.15,63.29,68.88,76.06,83.11,90.17,103.20,114.52,
 126.39,137.78,148.17,158.23,168.00,199.21,229.83,270.58,324.67,385.00,
 521.25,684.00};
static float alpha05_nx064_nz28_fwhm375[32] = {
 28.66,31.48,33.90,36.79,39.67,42.30,46.73,50.72,54.75,57.92,
 60.71,63.44,66.12,73.24,79.52,87.67,96.20,104.16,119.65,133.44,
 147.00,159.00,171.67,183.60,195.69,231.12,264.82,312.50,377.88,443.75,
 597.50,785.40};
static float alpha05_nx064_nz28_fwhm400[32] = {
 32.32,35.61,38.14,41.36,44.53,47.69,53.41,57.82,61.57,65.71,
 69.20,72.34,75.55,83.29,91.27,99.68,109.37,118.20,136.59,152.75,
 168.00,183.00,196.94,210.73,224.29,264.40,304.78,360.62,431.43,509.71,
 685.50,897.20};
static float alpha05_nx064_nz28_fwhm425[32] = {
 35.90,39.54,42.67,46.00,50.03,53.37,59.19,64.52,69.65,73.52,
 77.20,81.04,84.80,94.40,102.35,111.83,123.22,134.22,154.42,172.88,
 190.29,206.85,224.12,239.83,254.64,298.71,342.67,406.30,491.00,574.44,
 770.25,1003.50};
static float alpha05_nx064_nz28_fwhm450[32] = {
 39.40,43.28,46.81,50.53,54.92,58.81,65.41,71.37,76.71,81.59,
 86.00,90.21,93.93,104.64,113.44,124.77,139.00,151.50,173.64,194.00,
 213.00,232.88,250.30,267.67,285.00,333.45,383.67,455.67,550.40,645.00,
 856.89,1106.83};
static float alpha05_nx064_nz28_fwhm475[32] = {
 42.52,47.33,51.26,55.47,59.85,64.24,71.73,78.55,84.47,90.00,
 94.70,98.90,103.05,115.06,125.64,140.33,154.47,168.80,193.38,216.30,
 238.00,258.08,276.67,295.60,315.50,369.71,429.50,512.00,611.14,715.25,
 947.00,1212.40};
static float alpha05_nx064_nz28_fwhm500[32] = {
 46.12,51.05,55.35,60.26,64.85,69.77,79.13,85.74,92.38,97.76,
 103.25,109.24,114.27,127.16,139.50,153.93,170.62,185.11,213.38,239.75,
 262.62,283.60,307.17,329.00,348.88,414.17,475.75,563.20,669.00,787.67,
 1036.00,1321.33};
static float *alpha05_nx064_nz28[21] = {
 alpha05_nx064_nz28_fwhm000, alpha05_nx064_nz28_fwhm025, alpha05_nx064_nz28_fwhm050, 
 alpha05_nx064_nz28_fwhm075, alpha05_nx064_nz28_fwhm100, alpha05_nx064_nz28_fwhm125, 
 alpha05_nx064_nz28_fwhm150, alpha05_nx064_nz28_fwhm175, alpha05_nx064_nz28_fwhm200, 
 alpha05_nx064_nz28_fwhm225, alpha05_nx064_nz28_fwhm250, alpha05_nx064_nz28_fwhm275, 
 alpha05_nx064_nz28_fwhm300, alpha05_nx064_nz28_fwhm325, alpha05_nx064_nz28_fwhm350, 
 alpha05_nx064_nz28_fwhm375, alpha05_nx064_nz28_fwhm400, alpha05_nx064_nz28_fwhm425, 
 alpha05_nx064_nz28_fwhm450, alpha05_nx064_nz28_fwhm475, alpha05_nx064_nz28_fwhm500} ;

static float alpha10_nx064_nz28_fwhm000[32] = {
 1.90,1.90,1.91,1.91,1.91,1.92,1.94,1.96,1.99,2.18,
 2.34,2.46,2.55,2.72,2.80,2.86,2.90,2.92,2.98,3.35,
 3.60,3.75,3.84,3.90,3.95,4.44,4.78,5.02,5.76,6.25,
 7.36,8.55};
static float alpha10_nx064_nz28_fwhm025[32] = {
 1.90,1.90,1.91,1.91,1.91,1.92,1.94,1.96,1.99,2.18,
 2.34,2.46,2.55,2.72,2.80,2.86,2.90,2.92,2.98,3.35,
 3.60,3.75,3.84,3.90,3.95,4.44,4.78,5.02,5.76,6.25,
 7.36,8.55};
static float alpha10_nx064_nz28_fwhm050[32] = {
 1.90,1.90,1.91,1.91,1.92,1.92,1.95,1.97,2.01,2.26,
 2.41,2.51,2.60,2.74,2.82,2.87,2.90,2.93,2.99,3.44,
 3.66,3.79,3.87,3.92,3.97,4.55,4.84,5.24,5.85,6.45,
 7.58,8.76};
static float alpha10_nx064_nz28_fwhm075[32] = {
 1.90,1.91,1.91,1.92,1.93,1.95,1.98,2.16,2.39,2.53,
 2.62,2.69,2.74,2.82,2.87,2.91,2.95,2.99,3.48,3.71,
 3.84,3.92,3.98,4.22,4.47,4.85,5.18,5.81,6.51,7.03,
 8.52,9.87};
static float alpha10_nx064_nz28_fwhm100[32] = {
 1.92,1.93,1.94,1.96,1.99,2.21,2.50,2.65,2.73,2.79,
 2.83,2.86,2.88,2.93,2.97,3.18,3.52,3.72,3.90,4.00,
 4.46,4.71,4.85,4.95,5.17,5.85,6.46,7.08,7.98,8.93,
 10.86,12.91};
static float alpha10_nx064_nz28_fwhm125[32] = {
 1.98,2.17,2.40,2.57,2.70,2.77,2.85,2.90,2.94,2.97,
 3.04,3.25,3.42,3.70,3.85,3.96,4.36,4.66,4.96,5.50,
 5.83,6.17,6.59,6.86,7.17,8.14,9.08,10.29,11.92,13.59,
 16.98,20.96};
static float alpha10_nx064_nz28_fwhm150[32] = {
 2.72,2.81,2.88,2.94,3.04,3.35,3.67,3.83,3.95,4.19,
 4.43,4.59,4.73,4.98,5.46,5.84,6.36,6.79,7.61,8.39,
 9.01,9.75,10.39,10.97,11.68,13.53,15.33,17.75,20.83,24.04,
 31.27,39.52};
static float alpha10_nx064_nz28_fwhm175[32] = {
 3.55,3.80,3.96,4.32,4.65,4.85,5.29,5.71,5.99,6.41,
 6.71,6.94,7.25,7.95,8.67,9.44,10.32,11.05,12.62,13.90,
 15.19,16.43,17.68,18.84,20.05,23.56,27.08,31.74,37.79,44.24,
 59.17,76.70};
static float alpha10_nx064_nz28_fwhm200[32] = {
 5.03,5.55,5.88,6.40,6.89,7.35,8.14,8.79,9.36,9.88,
 10.38,10.80,11.26,12.43,13.49,14.74,16.08,17.44,19.95,22.40,
 24.58,26.66,28.73,30.68,32.67,38.77,44.64,52.78,63.49,74.75,
 100.45,132.73};
static float alpha10_nx064_nz28_fwhm225[32] = {
 7.26,7.91,8.51,9.12,9.86,10.50,11.52,12.49,13.33,14.13,
 14.84,15.59,16.19,17.91,19.46,21.43,23.66,25.72,29.58,32.85,
 36.23,39.39,42.39,45.31,48.30,57.19,66.05,78.44,94.05,110.94,
 151.25,198.88};
static float alpha10_nx064_nz28_fwhm250[32] = {
 9.61,10.42,11.16,12.00,12.97,13.89,15.40,16.74,17.94,19.04,
 19.97,20.89,21.79,24.24,26.47,29.11,32.19,34.86,39.84,44.54,
 48.96,53.58,57.64,61.95,66.16,77.93,89.53,105.30,126.83,151.31,
 204.80,274.33};
static float alpha10_nx064_nz28_fwhm275[32] = {
 11.98,13.10,14.12,15.25,16.56,17.72,19.69,21.34,22.86,24.24,
 25.55,26.70,27.87,31.06,33.91,37.20,40.98,44.62,51.29,57.30,
 63.23,68.71,73.81,79.34,84.49,99.33,114.48,135.52,164.03,193.73,
 263.70,350.06};
static float alpha10_nx064_nz28_fwhm300[32] = {
 14.49,15.95,17.19,18.69,20.35,21.56,24.06,26.17,28.11,29.79,
 31.53,33.07,34.53,38.57,41.99,46.10,50.73,55.14,63.34,70.71,
 77.77,84.37,90.79,97.44,103.70,122.68,141.93,167.71,202.07,237.15,
 323.33,427.77};
static float alpha10_nx064_nz28_fwhm325[32] = {
 17.08,18.77,20.32,22.02,23.95,25.80,28.80,31.32,33.78,35.94,
 38.10,39.93,41.70,45.97,50.27,55.23,61.18,66.14,75.69,84.77,
 93.15,101.22,109.05,116.78,124.57,146.60,169.19,200.08,240.95,286.07,
 385.40,508.75};
static float alpha10_nx064_nz28_fwhm350[32] = {
 19.70,21.75,23.61,25.73,28.13,30.18,33.69,36.66,39.39,41.72,
 44.03,46.17,48.27,53.80,58.68,64.68,71.44,77.61,88.46,99.37,
 109.17,118.68,128.34,136.90,145.50,172.33,198.89,235.26,284.29,335.74,
 452.38,595.00};
static float alpha10_nx064_nz28_fwhm375[32] = {
 22.18,24.91,26.85,29.36,31.96,34.18,38.30,41.93,45.19,47.93,
 50.51,52.99,55.37,61.82,67.72,74.52,82.19,89.25,102.33,114.50,
 125.80,136.47,147.57,157.94,168.40,198.93,230.53,272.79,329.15,385.87,
 521.50,678.57};
static float alpha10_nx064_nz28_fwhm400[32] = {
 25.09,27.58,29.94,32.95,36.12,38.65,43.43,47.28,50.80,54.24,
 57.31,60.11,62.81,70.39,76.72,84.33,92.98,101.18,115.70,129.95,
 143.53,156.47,168.37,180.38,192.64,227.35,263.16,311.50,373.69,441.92,
 591.78,765.29};
static float alpha10_nx064_nz28_fwhm425[32] = {
 27.23,30.68,33.43,36.60,39.91,43.00,48.23,52.88,57.03,60.50,
 63.93,67.30,70.36,78.35,85.40,94.34,104.32,114.18,131.38,146.86,
 161.64,176.42,190.64,203.38,216.69,255.72,297.14,351.38,422.45,497.12,
 663.29,861.11};
static float alpha10_nx064_nz28_fwhm450[32] = {
 29.97,33.59,36.66,40.12,44.01,47.53,53.27,58.49,62.69,66.80,
 70.56,73.96,77.55,86.73,94.71,104.83,116.50,127.57,146.65,164.35,
 181.44,196.38,211.64,226.60,241.56,287.40,332.41,392.69,472.25,554.60,
 736.00,954.33};
static float alpha10_nx064_nz28_fwhm475[32] = {
 32.30,36.48,39.67,43.45,47.66,51.47,57.96,63.51,68.52,72.98,
 77.39,81.12,84.81,94.86,103.88,115.77,128.81,140.80,161.82,182.05,
 199.78,216.73,232.89,250.75,268.81,318.77,368.22,435.91,521.75,613.11,
 808.50,1041.20};
static float alpha10_nx064_nz28_fwhm500[32] = {
 34.36,38.53,42.33,46.64,51.19,55.51,62.65,68.83,74.43,79.24,
 83.70,87.91,92.36,103.63,114.24,127.31,141.59,154.83,178.00,198.50,
 218.92,238.62,257.77,278.69,296.73,351.69,404.83,478.50,572.10,675.75,
 886.00,1135.40};
static float *alpha10_nx064_nz28[21] = {
 alpha10_nx064_nz28_fwhm000, alpha10_nx064_nz28_fwhm025, alpha10_nx064_nz28_fwhm050, 
 alpha10_nx064_nz28_fwhm075, alpha10_nx064_nz28_fwhm100, alpha10_nx064_nz28_fwhm125, 
 alpha10_nx064_nz28_fwhm150, alpha10_nx064_nz28_fwhm175, alpha10_nx064_nz28_fwhm200, 
 alpha10_nx064_nz28_fwhm225, alpha10_nx064_nz28_fwhm250, alpha10_nx064_nz28_fwhm275, 
 alpha10_nx064_nz28_fwhm300, alpha10_nx064_nz28_fwhm325, alpha10_nx064_nz28_fwhm350, 
 alpha10_nx064_nz28_fwhm375, alpha10_nx064_nz28_fwhm400, alpha10_nx064_nz28_fwhm425, 
 alpha10_nx064_nz28_fwhm450, alpha10_nx064_nz28_fwhm475, alpha10_nx064_nz28_fwhm500} ;

static float **nx064_nz28[3] = {
  alpha01_nx064_nz28 , alpha05_nx064_nz28 , alpha10_nx064_nz28 };

static float alpha01_nx064_nz29_fwhm000[32] = {
 1.99,1.99,2.00,2.13,2.37,2.57,2.77,2.85,2.90,2.93,
 2.94,2.95,2.96,2.98,2.99,3.07,3.53,3.72,3.91,3.96,
 4.00,4.49,4.72,4.84,4.91,5.37,5.84,6.42,6.95,7.68,
 8.99,10.60};
static float alpha01_nx064_nz29_fwhm025[32] = {
 1.99,1.99,2.00,2.13,2.37,2.57,2.77,2.85,2.90,2.93,
 2.94,2.95,2.96,2.98,2.99,3.07,3.53,3.72,3.91,3.96,
 4.00,4.49,4.72,4.84,4.91,5.37,5.84,6.42,6.95,7.68,
 8.99,10.60};
static float alpha01_nx064_nz29_fwhm050[32] = {
 1.99,2.00,2.00,2.20,2.46,2.63,2.80,2.87,2.91,2.93,
 2.95,2.96,2.97,2.99,3.00,3.26,3.62,3.78,3.92,3.97,
 4.25,4.58,4.79,4.88,4.94,5.53,5.91,6.55,6.99,7.85,
 9.37,10.86};
static float alpha01_nx064_nz29_fwhm075[32] = {
 2.00,2.00,2.36,2.58,2.71,2.80,2.89,2.93,2.95,2.96,
 2.97,2.98,2.99,3.00,3.41,3.69,3.85,3.92,3.99,4.45,
 4.74,4.88,4.95,5.13,5.44,5.95,6.54,7.02,7.91,8.85,
 10.51,12.44};
static float alpha01_nx064_nz29_fwhm100[32] = {
 2.50,2.69,2.78,2.85,2.91,2.94,2.96,2.98,2.99,3.00,
 3.29,3.47,3.60,3.82,3.90,3.96,4.19,4.57,4.89,5.10,
 5.58,5.85,5.97,6.28,6.65,7.34,7.95,8.94,10.07,11.31,
 13.94,16.49};
static float alpha01_nx064_nz29_fwhm125[32] = {
 2.90,2.94,2.96,2.98,3.00,3.32,3.68,3.81,3.90,3.95,
 3.99,4.15,4.38,4.75,4.93,5.15,5.64,5.89,6.49,6.96,
 7.59,7.92,8.40,8.89,9.23,10.50,11.82,13.38,15.36,17.34,
 22.50,27.29};
static float alpha01_nx064_nz29_fwhm150[32] = {
 3.64,3.83,3.93,3.99,4.36,4.61,4.88,5.11,5.53,5.75,
 5.86,5.99,6.35,6.82,7.33,7.88,8.61,8.98,10.04,11.35,
 12.28,13.12,13.96,14.78,15.51,18.00,20.32,23.58,27.94,32.14,
 42.26,53.91};
static float alpha01_nx064_nz29_fwhm175[32] = {
 5.34,5.72,5.92,6.36,6.77,7.08,7.93,8.47,8.84,9.23,
 9.71,10.05,10.47,11.27,12.18,13.27,14.32,15.59,17.50,19.51,
 21.50,23.19,24.65,26.26,27.78,32.41,37.22,43.53,52.00,60.85,
 80.47,106.00};
static float alpha01_nx064_nz29_fwhm200[32] = {
 8.49,9.00,9.59,10.30,10.97,11.63,12.56,13.37,13.91,14.68,
 15.32,16.08,16.97,18.38,19.80,21.68,23.77,25.22,28.77,31.82,
 35.07,38.43,41.38,44.06,47.00,54.73,63.61,73.62,88.25,104.33,
 141.14,189.75};
static float alpha01_nx064_nz29_fwhm225[32] = {
 12.41,13.07,13.89,14.79,15.82,16.71,18.40,19.79,20.93,22.17,
 23.23,24.27,25.19,27.62,29.54,32.56,35.67,38.59,43.63,48.57,
 52.81,57.33,60.92,64.50,68.85,80.80,93.62,113.17,134.40,159.00,
 211.80,286.00};
static float alpha01_nx064_nz29_fwhm250[32] = {
 16.65,17.82,18.78,20.15,21.93,23.07,25.06,27.31,28.86,30.47,
 32.41,33.45,34.57,37.61,40.50,44.64,48.83,52.53,59.44,65.83,
 72.33,78.00,84.29,88.29,95.00,111.38,129.83,153.56,181.83,214.90,
 292.80,394.00};
static float alpha01_nx064_nz29_fwhm275[32] = {
 21.48,22.97,24.67,26.46,28.12,30.25,33.19,35.38,37.43,39.31,
 41.20,43.05,44.47,49.28,53.20,57.59,63.33,68.12,76.57,85.86,
 93.43,100.83,108.38,117.14,124.00,145.33,166.50,196.67,234.50,275.50,
 385.67,511.00};
static float alpha01_nx064_nz29_fwhm300[32] = {
 26.96,29.25,31.11,33.14,35.43,37.26,40.71,43.82,46.77,49.00,
 51.54,53.82,56.18,61.33,65.83,71.80,78.17,84.42,95.60,106.27,
 117.80,127.75,136.88,145.43,154.50,180.00,205.00,241.75,288.57,342.00,
 474.25,649.00};
static float alpha01_nx064_nz29_fwhm325[32] = {
 32.00,34.89,37.74,39.94,43.20,45.46,49.75,53.38,56.40,59.54,
 62.14,64.82,67.67,74.00,80.45,86.82,95.70,103.30,116.78,130.75,
 142.80,153.50,164.25,176.50,186.67,217.25,247.00,291.00,355.60,430.67,
 575.50,794.00};
static float alpha01_nx064_nz29_fwhm350[32] = {
 38.33,41.55,43.80,47.33,50.85,54.29,59.18,63.40,67.00,71.00,
 74.88,77.80,80.40,88.60,95.50,103.83,114.00,121.89,139.75,155.25,
 169.75,180.80,196.40,207.67,220.40,252.67,293.00,347.00,422.80,498.67,
 687.00,927.00};
static float alpha01_nx064_nz29_fwhm375[32] = {
 44.55,48.62,51.83,55.75,60.33,62.89,69.71,74.38,78.80,83.38,
 87.00,89.88,93.71,102.78,111.14,121.75,131.60,143.80,162.50,181.00,
 197.57,211.80,225.00,238.33,253.75,298.50,343.50,406.00,493.33,577.00,
 790.00,1042.00};
static float alpha01_nx064_nz29_fwhm400[32] = {
 52.17,56.75,60.20,65.12,68.83,73.40,78.80,85.07,90.00,94.71,
 98.50,103.17,107.33,117.50,127.00,138.88,152.00,165.50,186.50,207.60,
 225.33,242.20,258.25,274.83,290.50,341.67,397.25,471.00,564.00,672.00,
 912.00,1181.50};
static float alpha01_nx064_nz29_fwhm425[32] = {
 58.45,63.45,67.50,72.20,76.83,81.70,88.90,95.71,101.40,107.29,
 112.25,116.25,120.86,134.00,144.33,158.83,174.00,186.33,210.33,233.83,
 254.33,273.00,288.67,309.00,330.25,390.00,450.00,537.50,638.00,751.00,
 1009.50,1340.00};
static float alpha01_nx064_nz29_fwhm450[32] = {
 65.08,69.83,74.83,80.50,85.00,90.67,99.00,106.14,112.25,118.60,
 124.50,130.67,136.22,150.80,164.20,178.00,192.00,208.00,236.38,259.75,
 281.33,303.75,325.00,349.00,370.00,442.00,506.67,598.00,717.00,850.50,
 1146.00,1488.00};
static float alpha01_nx064_nz29_fwhm475[32] = {
 71.12,76.67,82.12,87.56,94.20,99.38,108.57,116.33,125.00,133.60,
 140.50,146.57,152.50,168.33,181.25,196.80,216.00,230.33,258.67,285.50,
 314.00,340.00,365.00,389.00,420.00,488.50,560.00,662.00,797.00,938.67,
 1260.00,1664.50};
static float alpha01_nx064_nz29_fwhm500[32] = {
 77.00,83.86,89.50,96.25,102.40,109.00,120.50,131.00,140.33,146.75,
 155.33,162.67,168.25,185.00,197.67,216.00,234.75,252.00,284.50,317.00,
 347.00,378.50,405.00,436.33,460.33,540.00,627.00,735.00,879.67,1025.00,
 1396.00,1815.50};
static float *alpha01_nx064_nz29[21] = {
 alpha01_nx064_nz29_fwhm000, alpha01_nx064_nz29_fwhm025, alpha01_nx064_nz29_fwhm050, 
 alpha01_nx064_nz29_fwhm075, alpha01_nx064_nz29_fwhm100, alpha01_nx064_nz29_fwhm125, 
 alpha01_nx064_nz29_fwhm150, alpha01_nx064_nz29_fwhm175, alpha01_nx064_nz29_fwhm200, 
 alpha01_nx064_nz29_fwhm225, alpha01_nx064_nz29_fwhm250, alpha01_nx064_nz29_fwhm275, 
 alpha01_nx064_nz29_fwhm300, alpha01_nx064_nz29_fwhm325, alpha01_nx064_nz29_fwhm350, 
 alpha01_nx064_nz29_fwhm375, alpha01_nx064_nz29_fwhm400, alpha01_nx064_nz29_fwhm425, 
 alpha01_nx064_nz29_fwhm450, alpha01_nx064_nz29_fwhm475, alpha01_nx064_nz29_fwhm500} ;

static float alpha05_nx064_nz29_fwhm000[32] = {
 1.95,1.95,1.96,1.96,1.97,1.97,1.99,2.22,2.46,2.60,
 2.69,2.75,2.79,2.87,2.91,2.94,2.96,2.98,3.39,3.68,
 3.82,3.91,3.96,3.99,4.26,4.78,4.97,5.63,6.00,6.75,
 7.87,9.14};
static float alpha05_nx064_nz29_fwhm025[32] = {
 1.95,1.95,1.96,1.96,1.97,1.97,1.99,2.22,2.46,2.60,
 2.69,2.75,2.79,2.87,2.91,2.94,2.96,2.98,3.39,3.68,
 3.82,3.91,3.96,3.99,4.26,4.78,4.97,5.63,6.00,6.75,
 7.87,9.14};
static float alpha05_nx064_nz29_fwhm050[32] = {
 1.95,1.96,1.96,1.96,1.97,1.98,2.00,2.32,2.52,2.65,
 2.72,2.77,2.81,2.88,2.92,2.95,2.97,2.99,3.49,3.73,
 3.86,3.93,3.97,4.12,4.40,4.84,5.01,5.73,6.23,6.86,
 8.01,9.47};
static float alpha05_nx064_nz29_fwhm075[32] = {
 1.96,1.96,1.97,1.97,1.98,2.00,2.40,2.60,2.71,2.77,
 2.82,2.85,2.88,2.92,2.95,2.98,3.08,3.47,3.76,3.89,
 3.96,4.10,4.46,4.68,4.80,5.10,5.71,6.16,6.90,7.68,
 9.05,10.75};
static float alpha05_nx064_nz29_fwhm100[32] = {
 1.97,1.98,1.99,2.23,2.49,2.63,2.77,2.84,2.88,2.91,
 2.93,2.95,2.96,2.99,3.33,3.64,3.81,3.90,4.07,4.57,
 4.80,4.95,5.16,5.51,5.74,6.32,6.91,7.77,8.77,9.78,
 11.86,14.21};
static float alpha05_nx064_nz29_fwhm125[32] = {
 2.42,2.61,2.71,2.80,2.86,2.91,2.96,2.99,3.22,3.46,
 3.60,3.70,3.77,3.92,4.00,4.51,4.78,4.95,5.55,5.92,
 6.40,6.79,7.10,7.59,7.84,8.93,9.96,11.26,13.04,14.80,
 18.73,22.88};
static float alpha05_nx064_nz29_fwhm150[32] = {
 2.90,2.96,3.05,3.40,3.63,3.77,3.94,4.22,4.56,4.74,
 4.87,4.96,5.15,5.66,5.93,6.54,6.99,7.60,8.47,9.30,
 10.07,10.84,11.61,12.29,12.93,14.93,16.82,19.75,23.21,26.81,
 34.77,44.43};
static float alpha05_nx064_nz29_fwhm175[32] = {
 3.99,4.41,4.68,4.90,5.22,5.58,5.99,6.55,6.87,7.29,
 7.65,7.89,8.23,8.98,9.78,10.67,11.63,12.56,14.02,15.63,
 17.11,18.58,19.89,21.15,22.51,26.53,30.37,35.44,42.66,49.98,
 66.43,85.88};
static float alpha05_nx064_nz29_fwhm200[32] = {
 5.98,6.61,6.98,7.59,8.09,8.60,9.41,10.16,10.81,11.41,
 11.92,12.49,12.92,14.26,15.45,16.82,18.42,20.03,22.72,25.32,
 27.86,30.37,32.64,34.97,37.12,43.77,50.53,59.21,71.22,84.30,
 113.41,150.32};
static float alpha05_nx064_nz29_fwhm225[32] = {
 8.76,9.50,10.05,10.84,11.72,12.41,13.64,14.66,15.64,16.49,
 17.30,18.02,18.80,20.75,22.51,24.66,27.27,29.53,33.73,37.50,
 41.45,44.77,48.21,51.62,54.89,64.59,74.33,88.50,106.22,126.25,
 171.85,227.22};
static float alpha05_nx064_nz29_fwhm250[32] = {
 11.68,12.67,13.61,14.60,15.70,16.66,18.32,19.77,21.21,22.46,
 23.54,24.64,25.58,28.36,30.89,33.72,37.15,40.17,45.96,51.36,
 56.19,60.84,65.20,69.98,74.38,88.37,101.47,120.04,146.29,171.60,
 233.93,310.08};
static float alpha05_nx064_nz29_fwhm275[32] = {
 14.76,16.11,17.31,18.64,19.96,21.26,23.58,25.65,27.38,28.99,
 30.46,31.69,32.96,36.49,39.85,43.63,47.75,51.63,59.11,65.52,
 72.29,78.24,84.36,90.62,96.33,113.19,130.00,154.50,187.62,222.36,
 297.75,398.00};
static float alpha05_nx064_nz29_fwhm300[32] = {
 18.06,19.75,21.25,22.76,24.80,26.49,29.20,31.48,33.71,35.57,
 37.48,39.21,40.70,45.22,48.89,53.63,59.18,63.97,73.35,81.13,
 89.43,96.97,104.82,111.87,118.59,139.75,162.88,192.57,230.25,272.29,
 367.00,489.80};
static float alpha05_nx064_nz29_fwhm325[32] = {
 21.62,23.62,25.35,27.11,29.25,31.05,34.50,37.53,40.22,42.52,
 44.70,46.74,48.57,53.98,58.83,64.78,71.44,76.76,87.73,98.19,
 107.81,116.08,124.73,133.88,143.10,169.25,197.00,231.20,275.54,324.25,
 440.14,587.00};
static float alpha05_nx064_nz29_fwhm350[32] = {
 24.93,27.47,29.28,31.69,34.44,36.70,40.58,44.16,46.98,49.75,
 52.37,55.16,57.34,63.80,69.29,76.08,83.89,90.33,103.43,115.64,
 126.08,136.23,147.20,158.28,169.20,200.12,230.07,270.42,321.50,381.38,
 517.83,691.00};
static float alpha05_nx064_nz29_fwhm375[32] = {
 28.51,31.24,33.60,36.31,39.46,42.16,47.19,51.08,54.72,58.13,
 61.05,63.85,66.41,73.69,80.00,87.76,96.79,104.57,119.96,133.11,
 146.37,159.43,171.80,184.15,196.45,230.78,265.33,311.23,373.00,440.55,
 599.00,796.60};
static float alpha05_nx064_nz29_fwhm400[32] = {
 32.08,35.31,38.12,41.20,45.19,48.08,53.27,58.18,62.39,66.25,
 69.53,72.80,75.83,83.90,91.19,99.90,110.33,119.79,137.06,153.27,
 167.83,182.55,196.25,209.80,223.73,263.10,301.14,356.67,424.00,503.67,
 688.00,893.29};
static float alpha05_nx064_nz29_fwhm425[32] = {
 35.83,39.44,42.43,46.10,50.12,53.84,59.54,65.44,70.00,74.36,
 77.96,81.50,85.00,94.24,102.64,112.52,124.47,135.55,155.10,172.74,
 189.00,206.00,220.50,236.00,252.91,296.31,340.50,401.00,484.00,574.57,
 772.50,998.25};
static float alpha05_nx064_nz29_fwhm450[32] = {
 39.17,43.37,46.66,51.00,55.92,59.92,67.28,72.88,77.82,82.53,
 86.95,90.75,94.26,104.93,115.00,126.26,139.60,152.26,173.08,192.67,
 212.20,230.17,248.75,266.00,282.43,330.50,380.67,452.71,543.78,643.57,
 857.33,1116.00};
static float alpha05_nx064_nz29_fwhm475[32] = {
 42.88,47.60,51.76,56.64,61.45,65.47,73.62,80.11,85.78,91.31,
 95.61,100.16,104.47,116.06,127.44,141.17,155.45,168.38,192.18,213.75,
 235.80,256.88,277.12,295.14,312.33,367.40,425.55,504.22,604.00,710.50,
 945.50,1228.67};
static float alpha05_nx064_nz29_fwhm500[32] = {
 46.96,52.22,56.27,60.96,66.57,71.36,80.06,87.21,93.64,99.87,
 105.00,109.68,115.09,128.38,140.36,153.65,170.00,184.38,210.77,235.90,
 259.20,282.09,303.50,324.38,344.22,406.27,470.17,555.80,664.67,783.00,
 1039.25,1347.00};
static float *alpha05_nx064_nz29[21] = {
 alpha05_nx064_nz29_fwhm000, alpha05_nx064_nz29_fwhm025, alpha05_nx064_nz29_fwhm050, 
 alpha05_nx064_nz29_fwhm075, alpha05_nx064_nz29_fwhm100, alpha05_nx064_nz29_fwhm125, 
 alpha05_nx064_nz29_fwhm150, alpha05_nx064_nz29_fwhm175, alpha05_nx064_nz29_fwhm200, 
 alpha05_nx064_nz29_fwhm225, alpha05_nx064_nz29_fwhm250, alpha05_nx064_nz29_fwhm275, 
 alpha05_nx064_nz29_fwhm300, alpha05_nx064_nz29_fwhm325, alpha05_nx064_nz29_fwhm350, 
 alpha05_nx064_nz29_fwhm375, alpha05_nx064_nz29_fwhm400, alpha05_nx064_nz29_fwhm425, 
 alpha05_nx064_nz29_fwhm450, alpha05_nx064_nz29_fwhm475, alpha05_nx064_nz29_fwhm500} ;

static float alpha10_nx064_nz29_fwhm000[32] = {
 1.90,1.90,1.91,1.91,1.91,1.92,1.94,1.96,1.99,2.20,
 2.38,2.50,2.58,2.73,2.81,2.86,2.90,2.92,2.98,3.34,
 3.61,3.75,3.84,3.90,3.95,4.46,4.80,5.10,5.78,6.28,
 7.38,8.60};
static float alpha10_nx064_nz29_fwhm025[32] = {
 1.90,1.90,1.91,1.91,1.91,1.92,1.94,1.96,1.99,2.20,
 2.38,2.50,2.58,2.73,2.81,2.86,2.90,2.92,2.98,3.34,
 3.61,3.75,3.84,3.90,3.95,4.46,4.80,5.10,5.78,6.28,
 7.38,8.60};
static float alpha10_nx064_nz29_fwhm050[32] = {
 1.90,1.90,1.91,1.91,1.92,1.92,1.94,1.97,2.04,2.29,
 2.44,2.54,2.62,2.75,2.82,2.87,2.91,2.93,2.99,3.43,
 3.67,3.79,3.87,3.93,3.97,4.57,4.86,5.29,5.86,6.47,
 7.61,8.81};
static float alpha10_nx064_nz29_fwhm075[32] = {
 1.91,1.91,1.91,1.92,1.93,1.95,1.98,2.19,2.41,2.54,
 2.64,2.70,2.75,2.83,2.88,2.91,2.95,2.99,3.48,3.72,
 3.84,3.92,3.98,4.26,4.50,4.87,5.25,5.82,6.52,7.02,
 8.54,9.94};
static float alpha10_nx064_nz29_fwhm100[32] = {
 1.92,1.93,1.94,1.96,2.00,2.25,2.52,2.66,2.74,2.80,
 2.83,2.86,2.88,2.93,2.97,3.23,3.56,3.72,3.90,4.02,
 4.47,4.72,4.87,4.97,5.27,5.86,6.48,7.14,8.09,9.00,
 10.95,13.10};
static float alpha10_nx064_nz29_fwhm125[32] = {
 1.98,2.20,2.41,2.58,2.70,2.77,2.86,2.91,2.95,2.98,
 3.11,3.30,3.44,3.72,3.86,3.98,4.38,4.68,4.97,5.55,
 5.87,6.22,6.65,6.92,7.27,8.25,9.22,10.43,11.98,13.65,
 17.22,20.93};
static float alpha10_nx064_nz29_fwhm150[32] = {
 2.72,2.83,2.89,2.96,3.11,3.37,3.68,3.85,3.97,4.20,
 4.45,4.61,4.74,4.99,5.47,5.87,6.41,6.85,7.71,8.48,
 9.16,9.85,10.53,11.14,11.79,13.69,15.46,17.91,21.00,24.36,
 31.62,40.31};
static float alpha10_nx064_nz29_fwhm175[32] = {
 3.57,3.82,3.98,4.36,4.65,4.87,5.33,5.75,6.00,6.46,
 6.75,6.96,7.30,7.98,8.72,9.50,10.39,11.22,12.68,14.06,
 15.39,16.62,17.83,19.11,20.25,23.84,27.47,32.11,38.27,44.99,
 59.83,78.06};
static float alpha10_nx064_nz29_fwhm200[32] = {
 5.06,5.60,5.94,6.49,6.94,7.45,8.18,8.86,9.50,9.99,
 10.53,10.95,11.43,12.61,13.61,14.85,16.38,17.73,20.30,22.62,
 24.85,26.97,29.14,31.02,32.93,38.94,44.77,52.99,63.89,75.47,
 101.34,132.85};
static float alpha10_nx064_nz29_fwhm225[32] = {
 7.31,7.97,8.57,9.19,9.95,10.62,11.78,12.71,13.57,14.34,
 14.99,15.68,16.30,18.04,19.66,21.62,23.85,25.92,29.66,33.25,
 36.46,39.58,42.55,45.55,48.53,57.34,66.52,78.84,94.90,112.02,
 152.17,201.67};
static float alpha10_nx064_nz29_fwhm250[32] = {
 9.66,10.59,11.31,12.24,13.30,14.17,15.61,16.87,18.05,19.13,
 20.15,20.97,21.92,24.40,26.65,29.40,32.44,35.16,40.27,44.95,
 49.48,53.73,57.83,61.96,66.05,78.16,90.52,106.96,128.60,151.89,
 207.46,273.54};
static float alpha10_nx064_nz29_fwhm275[32] = {
 12.09,13.31,14.24,15.41,16.68,17.80,19.82,21.55,23.13,24.60,
 25.89,26.97,28.19,31.27,34.16,37.69,41.49,45.07,51.65,57.67,
 63.51,68.69,74.08,79.66,84.68,99.86,115.11,136.27,164.43,194.85,
 263.00,347.82};
static float alpha10_nx064_nz29_fwhm300[32] = {
 14.67,16.04,17.26,18.80,20.45,21.81,24.33,26.54,28.48,30.13,
 31.87,33.29,34.66,38.53,42.06,46.33,51.01,55.65,63.63,70.94,
 78.14,84.95,91.41,97.86,103.95,123.04,141.93,167.67,202.11,239.18,
 321.92,429.70};
static float alpha10_nx064_nz29_fwhm325[32] = {
 17.25,19.13,20.64,22.35,24.48,26.22,29.04,31.40,33.68,35.77,
 37.78,39.47,41.33,46.17,50.60,55.62,61.20,66.49,76.29,85.23,
 93.47,101.47,108.87,116.76,124.56,147.03,169.83,201.43,241.87,286.08,
 385.71,511.40};
static float alpha10_nx064_nz29_fwhm350[32] = {
 19.91,21.97,23.66,25.91,28.16,30.18,33.52,36.57,39.17,41.76,
 44.18,46.42,48.49,54.04,58.86,64.97,71.68,77.96,89.12,99.39,
 109.29,119.06,128.56,137.67,146.87,172.14,200.04,236.17,284.50,333.95,
 453.08,595.50};
static float alpha10_nx064_nz29_fwhm375[32] = {
 22.37,24.87,27.02,29.29,31.86,34.31,38.14,42.06,45.25,48.17,
 50.76,53.07,55.33,61.82,67.48,74.68,82.39,89.29,102.88,114.63,
 126.41,137.56,148.42,159.16,169.00,199.43,231.18,273.50,326.31,385.42,
 515.95,685.00};
static float alpha10_nx064_nz29_fwhm400[32] = {
 24.85,27.72,30.04,32.74,35.85,38.58,43.20,47.20,50.95,54.11,
 57.32,60.05,63.08,69.90,76.36,84.36,93.82,101.91,116.83,131.10,
 144.14,156.51,168.59,180.42,192.48,228.73,264.10,311.47,371.50,438.47,
 590.25,773.67};
static float alpha10_nx064_nz29_fwhm425[32] = {
 27.34,30.51,33.33,36.36,39.60,42.74,48.06,52.88,56.88,60.52,
 64.26,67.33,70.14,78.67,86.39,94.85,105.56,114.69,131.67,147.18,
 162.41,175.96,190.00,203.73,217.15,257.85,296.47,349.33,421.00,492.71,
 661.29,866.62};
static float alpha10_nx064_nz29_fwhm450[32] = {
 29.53,33.34,36.33,39.87,43.52,46.97,52.95,58.33,62.84,67.22,
 70.67,74.56,78.02,87.42,95.89,106.17,117.29,127.50,147.00,163.96,
 180.54,196.71,212.32,226.94,241.50,287.31,331.24,389.45,468.50,550.44,
 737.20,956.33};
static float alpha10_nx064_nz29_fwhm475[32] = {
 31.95,35.96,39.20,42.88,47.40,50.96,57.86,63.66,68.80,73.42,
 78.11,82.00,86.10,96.78,105.72,117.10,129.41,141.25,162.25,180.96,
 199.45,216.75,233.50,251.42,268.41,317.12,367.38,433.60,518.27,610.00,
 813.33,1049.50};
static float alpha10_nx064_nz29_fwhm500[32] = {
 33.77,38.18,41.95,46.02,51.15,54.91,62.85,69.12,75.05,80.24,
 84.97,90.03,94.13,105.27,115.39,127.74,141.72,154.30,177.05,199.10,
 219.53,238.77,257.50,277.00,294.59,350.56,405.50,476.89,570.33,672.75,
 891.14,1145.40};
static float *alpha10_nx064_nz29[21] = {
 alpha10_nx064_nz29_fwhm000, alpha10_nx064_nz29_fwhm025, alpha10_nx064_nz29_fwhm050, 
 alpha10_nx064_nz29_fwhm075, alpha10_nx064_nz29_fwhm100, alpha10_nx064_nz29_fwhm125, 
 alpha10_nx064_nz29_fwhm150, alpha10_nx064_nz29_fwhm175, alpha10_nx064_nz29_fwhm200, 
 alpha10_nx064_nz29_fwhm225, alpha10_nx064_nz29_fwhm250, alpha10_nx064_nz29_fwhm275, 
 alpha10_nx064_nz29_fwhm300, alpha10_nx064_nz29_fwhm325, alpha10_nx064_nz29_fwhm350, 
 alpha10_nx064_nz29_fwhm375, alpha10_nx064_nz29_fwhm400, alpha10_nx064_nz29_fwhm425, 
 alpha10_nx064_nz29_fwhm450, alpha10_nx064_nz29_fwhm475, alpha10_nx064_nz29_fwhm500} ;

static float **nx064_nz29[3] = {
  alpha01_nx064_nz29 , alpha05_nx064_nz29 , alpha10_nx064_nz29 };

static float alpha01_nx064_nz30_fwhm000[32] = {
 1.99,1.99,2.00,2.18,2.45,2.62,2.78,2.85,2.90,2.92,
 2.94,2.95,2.96,2.98,2.99,3.00,3.53,3.74,3.90,3.96,
 4.00,4.43,4.67,4.81,4.90,5.31,5.85,6.47,6.95,7.72,
 9.27,10.68};
static float alpha01_nx064_nz30_fwhm025[32] = {
 1.99,1.99,2.00,2.18,2.45,2.62,2.78,2.85,2.90,2.92,
 2.94,2.95,2.96,2.98,2.99,3.00,3.53,3.74,3.90,3.96,
 4.00,4.43,4.67,4.81,4.90,5.31,5.85,6.47,6.95,7.72,
 9.27,10.68};
static float alpha01_nx064_nz30_fwhm050[32] = {
 1.99,2.00,2.00,2.29,2.52,2.66,2.81,2.87,2.91,2.93,
 2.95,2.96,2.97,2.98,2.99,3.18,3.62,3.79,3.92,3.97,
 4.13,4.55,4.74,4.85,4.94,5.49,5.94,6.59,7.17,7.88,
 9.55,10.89};
static float alpha01_nx064_nz30_fwhm075[32] = {
 2.00,2.15,2.40,2.60,2.72,2.81,2.89,2.92,2.95,2.96,
 2.97,2.98,2.98,3.00,3.39,3.68,3.84,3.91,3.98,4.37,
 4.71,4.87,4.95,4.99,5.49,5.96,6.61,7.12,7.93,8.87,
 10.62,12.48};
static float alpha01_nx064_nz30_fwhm100[32] = {
 2.54,2.70,2.79,2.86,2.91,2.93,2.96,2.98,2.99,3.00,
 3.28,3.44,3.58,3.81,3.89,3.95,4.01,4.52,4.86,4.99,
 5.60,5.83,5.98,6.38,6.70,7.41,7.93,8.94,10.06,11.48,
 14.17,16.93};
static float alpha01_nx064_nz30_fwhm125[32] = {
 2.89,2.93,2.96,2.97,2.99,3.20,3.61,3.79,3.88,3.93,
 3.97,4.08,4.34,4.72,4.92,5.23,5.69,5.91,6.58,6.97,
 7.52,7.87,8.27,8.76,9.13,10.58,11.79,13.63,15.81,17.54,
 22.31,27.62};
static float alpha01_nx064_nz30_fwhm150[32] = {
 3.60,3.80,3.90,3.98,4.35,4.62,4.90,5.09,5.54,5.78,
 5.92,6.01,6.28,6.77,7.08,7.79,8.41,8.92,10.18,11.15,
 12.12,12.95,13.80,14.71,15.83,18.07,20.59,23.75,28.08,32.30,
 41.76,53.50};
static float alpha01_nx064_nz30_fwhm175[32] = {
 5.18,5.66,5.93,6.32,6.76,7.11,7.75,8.09,8.60,8.91,
 9.33,9.80,10.10,11.10,11.92,12.93,14.34,15.70,17.76,19.49,
 21.03,22.97,24.82,26.46,27.77,32.41,36.92,43.26,51.13,60.07,
 80.00,105.33};
static float alpha01_nx064_nz30_fwhm200[32] = {
 8.30,8.88,9.29,9.82,10.54,11.12,12.37,13.13,13.87,14.68,
 15.35,16.06,16.62,18.32,19.92,21.53,23.45,25.32,28.95,32.50,
 35.19,37.62,40.32,43.05,45.55,53.48,61.89,72.59,87.30,103.60,
 139.00,182.50};
static float alpha01_nx064_nz30_fwhm225[32] = {
 12.12,12.87,13.77,14.70,15.68,16.61,18.27,19.71,20.82,22.08,
 23.14,24.11,24.93,27.46,29.57,32.55,35.22,37.89,42.52,46.67,
 51.60,56.23,60.40,64.54,68.50,80.00,92.75,111.71,132.25,155.00,
 210.33,283.33};
static float alpha01_nx064_nz30_fwhm250[32] = {
 16.62,17.89,19.17,20.45,22.14,23.67,25.65,27.56,29.00,30.47,
 31.65,33.26,34.50,37.56,40.78,44.06,48.67,52.25,59.27,66.88,
 71.89,77.33,82.60,87.91,93.17,112.33,127.67,148.42,180.44,213.22,
 298.00,387.00};
static float alpha01_nx064_nz30_fwhm275[32] = {
 22.30,23.97,25.33,26.89,28.62,30.06,32.91,35.33,37.46,39.67,
 41.32,42.74,44.69,49.00,53.07,57.20,62.82,67.62,77.38,85.50,
 92.59,100.20,107.12,114.29,121.50,142.83,166.33,196.12,232.71,278.00,
 380.00,514.25};
static float alpha01_nx064_nz30_fwhm300[32] = {
 27.17,29.50,31.57,33.50,35.73,37.58,41.27,44.07,46.33,48.50,
 50.73,53.40,55.17,60.86,65.55,71.14,77.69,84.20,95.86,107.14,
 115.44,124.40,133.00,142.50,151.00,179.83,205.29,242.20,294.00,343.67,
 481.00,652.00};
static float alpha01_nx064_nz30_fwhm325[32] = {
 32.75,35.45,37.62,40.06,42.79,44.79,48.65,52.12,55.50,58.18,
 61.38,64.18,66.56,73.38,79.12,86.54,95.40,103.00,116.43,128.25,
 140.75,151.25,161.50,172.50,183.25,216.00,251.00,294.75,354.00,418.80,
 578.00,794.00};
static float alpha01_nx064_nz30_fwhm350[32] = {
 38.33,41.08,44.00,46.12,49.09,52.35,57.70,62.17,65.75,69.67,
 73.00,76.25,79.33,88.00,95.12,103.29,113.00,121.00,137.00,153.43,
 165.83,177.00,189.83,205.00,220.60,258.20,297.25,348.75,418.33,499.00,
 710.00,934.50};
static float alpha01_nx064_nz30_fwhm375[32] = {
 44.30,47.50,50.18,53.31,57.50,61.73,67.60,72.60,77.75,82.50,
 85.80,89.40,93.33,101.50,111.11,120.14,130.57,140.33,160.33,176.40,
 190.75,209.75,223.50,239.57,254.00,301.00,346.00,408.00,494.00,595.00,
 826.00,1084.00};
static float alpha01_nx064_nz30_fwhm400[32] = {
 49.94,53.90,57.08,62.00,66.33,70.60,78.00,84.00,90.00,94.20,
 98.17,101.83,105.33,117.00,125.80,135.91,149.67,161.17,182.00,201.83,
 224.00,240.00,257.80,274.40,292.00,346.75,400.33,473.50,578.00,695.00,
 932.50,1229.50};
static float alpha01_nx064_nz30_fwhm425[32] = {
 56.22,60.00,64.78,70.33,75.70,81.00,90.00,94.60,101.14,106.00,
 111.33,115.50,119.60,130.82,141.33,153.83,168.40,181.22,207.00,231.60,
 253.17,272.33,293.00,312.33,332.33,394.33,458.00,547.00,662.00,784.00,
 1049.00,1375.00};
static float alpha01_nx064_nz30_fwhm450[32] = {
 62.86,68.42,72.80,79.20,85.00,90.71,99.00,106.25,112.67,118.40,
 124.14,128.75,133.11,145.80,157.00,173.00,188.50,204.50,233.33,259.50,
 282.80,308.00,331.67,360.50,379.00,450.33,513.67,619.00,751.00,882.50,
 1165.00,1529.00};
static float alpha01_nx064_nz30_fwhm475[32] = {
 69.00,76.75,81.75,88.00,95.20,101.12,109.25,117.17,126.00,130.25,
 136.71,141.50,146.25,162.33,175.25,192.00,211.00,230.00,257.50,288.00,
 319.33,349.33,377.50,405.50,427.00,499.50,581.00,682.00,837.00,978.00,
 1279.00,1676.00};
static float alpha01_nx064_nz30_fwhm500[32] = {
 77.50,84.67,91.33,97.00,103.33,109.30,121.00,129.00,137.00,142.50,
 149.71,157.33,164.00,178.83,193.50,212.67,234.00,255.00,290.00,322.00,
 358.00,390.00,419.00,448.00,473.00,550.60,646.25,765.33,914.00,1071.50,
 1397.67,1847.00};
static float *alpha01_nx064_nz30[21] = {
 alpha01_nx064_nz30_fwhm000, alpha01_nx064_nz30_fwhm025, alpha01_nx064_nz30_fwhm050, 
 alpha01_nx064_nz30_fwhm075, alpha01_nx064_nz30_fwhm100, alpha01_nx064_nz30_fwhm125, 
 alpha01_nx064_nz30_fwhm150, alpha01_nx064_nz30_fwhm175, alpha01_nx064_nz30_fwhm200, 
 alpha01_nx064_nz30_fwhm225, alpha01_nx064_nz30_fwhm250, alpha01_nx064_nz30_fwhm275, 
 alpha01_nx064_nz30_fwhm300, alpha01_nx064_nz30_fwhm325, alpha01_nx064_nz30_fwhm350, 
 alpha01_nx064_nz30_fwhm375, alpha01_nx064_nz30_fwhm400, alpha01_nx064_nz30_fwhm425, 
 alpha01_nx064_nz30_fwhm450, alpha01_nx064_nz30_fwhm475, alpha01_nx064_nz30_fwhm500} ;

static float alpha05_nx064_nz30_fwhm000[32] = {
 1.95,1.95,1.96,1.96,1.97,1.98,1.99,2.26,2.47,2.60,
 2.69,2.75,2.79,2.87,2.91,2.94,2.96,2.99,3.40,3.68,
 3.83,3.91,3.95,3.99,4.27,4.78,4.97,5.67,6.03,6.75,
 7.89,9.13};
static float alpha05_nx064_nz30_fwhm025[32] = {
 1.95,1.95,1.96,1.96,1.97,1.98,1.99,2.26,2.47,2.60,
 2.69,2.75,2.79,2.87,2.91,2.94,2.96,2.99,3.40,3.68,
 3.83,3.91,3.95,3.99,4.27,4.78,4.97,5.67,6.03,6.75,
 7.89,9.13};
static float alpha05_nx064_nz30_fwhm050[32] = {
 1.95,1.96,1.96,1.96,1.97,1.98,2.02,2.34,2.53,2.65,
 2.72,2.77,2.81,2.88,2.92,2.94,2.97,2.99,3.48,3.74,
 3.86,3.93,3.97,4.09,4.41,4.83,5.05,5.76,6.27,6.84,
 8.01,9.46};
static float alpha05_nx064_nz30_fwhm075[32] = {
 1.96,1.96,1.97,1.97,1.99,2.03,2.42,2.60,2.71,2.78,
 2.83,2.86,2.88,2.92,2.95,2.98,3.13,3.45,3.77,3.89,
 3.96,4.09,4.48,4.67,4.81,5.17,5.74,6.19,6.89,7.72,
 9.09,10.77};
static float alpha05_nx064_nz30_fwhm100[32] = {
 1.97,1.98,2.00,2.28,2.50,2.63,2.77,2.84,2.88,2.91,
 2.93,2.95,2.96,3.00,3.33,3.63,3.81,3.90,4.04,4.58,
 4.81,4.94,5.23,5.56,5.76,6.35,6.92,7.77,8.75,9.82,
 11.92,14.28};
static float alpha05_nx064_nz30_fwhm125[32] = {
 2.42,2.62,2.73,2.80,2.86,2.90,2.95,2.99,3.22,3.45,
 3.60,3.71,3.79,3.92,4.00,4.51,4.79,4.94,5.57,5.92,
 6.42,6.78,7.05,7.53,7.86,8.91,9.98,11.40,13.12,14.91,
 18.74,23.13};
static float alpha05_nx064_nz30_fwhm150[32] = {
 2.90,2.96,3.01,3.36,3.61,3.77,3.94,4.20,4.52,4.72,
 4.86,4.96,5.09,5.66,5.95,6.50,6.93,7.55,8.39,9.18,
 9.98,10.77,11.54,12.26,12.91,14.94,17.06,19.77,23.20,26.94,
 34.86,44.26};
static float alpha05_nx064_nz30_fwhm175[32] = {
 3.96,4.33,4.64,4.89,5.24,5.56,5.96,6.48,6.82,7.20,
 7.55,7.83,8.14,8.88,9.65,10.57,11.60,12.56,14.29,15.78,
 17.24,18.55,19.94,21.37,22.62,26.43,30.23,35.57,42.43,49.62,
 65.88,85.47};
static float alpha05_nx064_nz30_fwhm200[32] = {
 5.97,6.53,6.89,7.45,8.01,8.57,9.35,10.15,10.75,11.37,
 11.91,12.48,12.93,14.35,15.52,16.99,18.54,20.13,22.87,25.66,
 28.00,30.67,32.96,35.08,37.38,43.78,50.17,58.98,70.76,83.53,
 112.91,149.30};
static float alpha05_nx064_nz30_fwhm225[32] = {
 8.69,9.46,10.10,10.85,11.75,12.47,13.76,14.80,15.83,16.68,
 17.47,18.33,19.05,21.09,22.80,24.94,27.36,29.70,33.98,37.79,
 41.30,45.14,48.55,51.76,54.91,64.54,74.44,88.02,105.89,126.12,
 170.42,226.15};
static float alpha05_nx064_nz30_fwhm250[32] = {
 11.74,12.78,13.69,14.79,15.87,16.89,18.63,20.17,21.42,22.69,
 23.82,24.70,25.65,28.49,30.96,34.01,37.47,40.46,46.21,51.41,
 56.16,60.95,65.40,69.93,74.20,88.03,101.70,120.05,144.38,171.84,
 236.73,309.15};
static float alpha05_nx064_nz30_fwhm275[32] = {
 15.06,16.38,17.64,18.91,20.45,21.70,23.81,25.62,27.55,29.04,
 30.45,31.78,33.15,36.66,40.08,44.05,48.22,52.18,59.41,65.70,
 71.72,78.03,84.25,90.36,96.27,113.04,131.00,154.21,188.10,221.79,
 301.36,406.33};
static float alpha05_nx064_nz30_fwhm300[32] = {
 18.46,20.20,21.51,23.10,24.91,26.55,29.23,31.73,34.04,35.98,
 37.84,39.68,41.21,45.49,49.70,54.04,59.38,64.66,73.26,81.91,
 89.85,96.92,104.45,111.88,119.46,140.40,161.75,192.92,233.19,275.56,
 376.88,503.33};
static float alpha05_nx064_nz30_fwhm325[32] = {
 21.90,23.82,25.71,27.51,29.79,32.02,35.32,38.33,40.67,43.35,
 45.35,47.44,49.28,54.46,59.31,64.80,71.55,77.23,88.11,98.42,
 108.18,116.92,126.16,134.82,143.74,170.05,196.00,233.50,281.29,331.00,
 451.44,604.25};
static float alpha05_nx064_nz30_fwhm350[32] = {
 25.41,27.82,29.97,32.39,34.86,37.24,41.06,44.73,47.80,50.69,
 53.31,55.80,58.24,64.17,69.76,76.32,83.74,90.54,103.56,115.78,
 127.64,138.13,148.31,159.45,169.55,199.69,232.06,275.77,329.91,391.44,
 537.00,705.25};
static float alpha05_nx064_nz30_fwhm375[32] = {
 29.15,31.89,34.24,36.99,40.09,42.75,47.52,51.55,55.43,58.66,
 61.49,64.19,66.89,74.06,80.57,87.89,96.74,105.27,120.00,134.62,
 147.33,160.67,172.42,185.06,197.08,233.00,271.89,320.44,384.80,458.25,
 619.67,810.17};
static float alpha05_nx064_nz30_fwhm400[32] = {
 33.02,35.91,38.73,42.08,45.74,48.71,53.95,58.62,62.41,66.11,
 69.52,72.83,75.58,84.26,91.41,99.95,109.64,119.77,137.35,153.62,
 168.54,183.50,197.64,212.38,226.17,270.40,309.57,366.38,441.40,524.75,
 708.50,923.75};
static float alpha05_nx064_nz30_fwhm425[32] = {
 36.85,40.52,43.66,47.07,50.96,54.26,60.06,65.23,69.79,73.90,
 77.96,81.83,85.57,94.26,101.90,112.60,124.38,134.67,155.80,173.69,
 190.93,208.93,225.18,242.18,257.87,303.64,351.22,415.29,496.14,588.40,
 793.33,1033.83};
static float alpha05_nx064_nz30_fwhm450[32] = {
 40.41,44.20,47.83,51.94,55.77,59.41,66.18,72.26,77.68,81.92,
 86.76,90.83,94.50,104.44,114.53,125.78,138.88,151.73,174.30,196.36,
 214.50,234.56,252.64,269.22,287.75,340.00,393.80,465.50,556.83,658.50,
 882.00,1145.00};
static float alpha05_nx064_nz30_fwhm475[32] = {
 43.88,48.30,51.93,56.25,60.86,65.34,72.93,80.03,85.78,90.95,
 95.73,100.22,104.06,116.24,127.64,140.32,154.83,169.56,195.64,216.74,
 238.71,259.89,280.83,302.62,321.55,380.33,441.00,515.40,619.33,727.00,
 973.67,1259.67};
static float alpha05_nx064_nz30_fwhm500[32] = {
 46.93,51.62,56.07,60.97,66.47,71.44,79.88,86.96,93.45,99.33,
 105.17,109.86,114.75,128.50,140.32,154.85,171.75,187.46,214.60,239.50,
 263.30,286.25,311.12,332.67,356.25,421.75,484.12,570.75,682.83,801.75,
 1073.25,1387.50};
static float *alpha05_nx064_nz30[21] = {
 alpha05_nx064_nz30_fwhm000, alpha05_nx064_nz30_fwhm025, alpha05_nx064_nz30_fwhm050, 
 alpha05_nx064_nz30_fwhm075, alpha05_nx064_nz30_fwhm100, alpha05_nx064_nz30_fwhm125, 
 alpha05_nx064_nz30_fwhm150, alpha05_nx064_nz30_fwhm175, alpha05_nx064_nz30_fwhm200, 
 alpha05_nx064_nz30_fwhm225, alpha05_nx064_nz30_fwhm250, alpha05_nx064_nz30_fwhm275, 
 alpha05_nx064_nz30_fwhm300, alpha05_nx064_nz30_fwhm325, alpha05_nx064_nz30_fwhm350, 
 alpha05_nx064_nz30_fwhm375, alpha05_nx064_nz30_fwhm400, alpha05_nx064_nz30_fwhm425, 
 alpha05_nx064_nz30_fwhm450, alpha05_nx064_nz30_fwhm475, alpha05_nx064_nz30_fwhm500} ;

static float alpha10_nx064_nz30_fwhm000[32] = {
 1.90,1.90,1.91,1.91,1.92,1.92,1.94,1.97,1.99,2.21,
 2.37,2.49,2.58,2.73,2.81,2.86,2.90,2.93,2.98,3.34,
 3.63,3.76,3.84,3.90,3.95,4.47,4.81,5.17,5.80,6.28,
 7.41,8.60};
static float alpha10_nx064_nz30_fwhm025[32] = {
 1.90,1.90,1.91,1.91,1.92,1.92,1.94,1.97,1.99,2.21,
 2.37,2.49,2.58,2.73,2.81,2.86,2.90,2.93,2.98,3.34,
 3.63,3.76,3.84,3.90,3.95,4.47,4.81,5.17,5.80,6.28,
 7.41,8.60};
static float alpha10_nx064_nz30_fwhm050[32] = {
 1.90,1.90,1.91,1.91,1.92,1.93,1.95,1.97,2.06,2.29,
 2.44,2.54,2.62,2.76,2.82,2.87,2.91,2.94,2.99,3.45,
 3.68,3.80,3.87,3.93,3.97,4.57,4.86,5.36,5.87,6.45,
 7.63,8.80};
static float alpha10_nx064_nz30_fwhm075[32] = {
 1.91,1.91,1.92,1.92,1.93,1.95,1.98,2.20,2.42,2.55,
 2.64,2.71,2.75,2.83,2.88,2.91,2.95,2.99,3.50,3.73,
 3.85,3.92,3.99,4.27,4.52,4.88,5.30,5.84,6.52,7.09,
 8.57,9.95};
static float alpha10_nx064_nz30_fwhm100[32] = {
 1.92,1.93,1.95,1.97,2.00,2.24,2.54,2.67,2.75,2.80,
 2.84,2.86,2.88,2.93,2.97,3.23,3.56,3.73,3.90,4.06,
 4.49,4.73,4.89,4.99,5.32,5.88,6.50,7.19,8.00,9.03,
 10.99,13.23};
static float alpha10_nx064_nz30_fwhm125[32] = {
 1.98,2.22,2.44,2.59,2.70,2.77,2.86,2.91,2.95,2.98,
 3.14,3.34,3.48,3.73,3.86,3.98,4.41,4.69,4.97,5.56,
 5.88,6.22,6.63,6.90,7.31,8.26,9.21,10.49,12.02,13.72,
 17.24,21.23};
static float alpha10_nx064_nz30_fwhm150[32] = {
 2.73,2.83,2.89,2.95,3.07,3.38,3.68,3.85,3.96,4.18,
 4.43,4.61,4.73,4.99,5.49,5.87,6.42,6.84,7.67,8.43,
 9.13,9.82,10.53,11.16,11.80,13.67,15.53,17.97,21.11,24.50,
 31.70,40.32};
static float alpha10_nx064_nz30_fwhm175[32] = {
 3.53,3.79,3.95,4.30,4.64,4.86,5.31,5.73,6.00,6.44,
 6.73,6.95,7.28,7.98,8.69,9.46,10.37,11.21,12.82,14.19,
 15.53,16.78,17.97,19.23,20.44,24.00,27.48,32.22,38.58,44.86,
 59.49,77.21};
static float alpha10_nx064_nz30_fwhm200[32] = {
 5.02,5.60,5.93,6.45,6.94,7.46,8.18,8.86,9.44,9.96,
 10.56,10.94,11.41,12.64,13.72,15.06,16.48,17.82,20.31,22.74,
 25.12,27.16,29.25,31.27,33.32,39.23,45.14,53.18,63.91,75.16,
 100.68,133.76};
static float alpha10_nx064_nz30_fwhm225[32] = {
 7.33,7.94,8.55,9.17,9.91,10.60,11.76,12.73,13.71,14.52,
 15.18,15.87,16.62,18.34,19.98,21.92,24.18,26.24,29.92,33.43,
 36.85,39.96,43.07,46.15,49.16,57.70,66.49,78.32,94.67,112.00,
 152.14,203.69};
static float alpha10_nx064_nz30_fwhm250[32] = {
 9.59,10.59,11.42,12.37,13.39,14.26,15.80,17.05,18.40,19.46,
 20.40,21.41,22.27,24.77,26.95,29.69,32.82,35.65,40.78,45.44,
 49.66,53.86,58.02,62.11,66.27,78.07,90.00,106.56,129.09,152.64,
 209.00,275.00};
static float alpha10_nx064_nz30_fwhm275[32] = {
 12.21,13.38,14.44,15.51,16.86,17.96,20.08,21.75,23.35,24.82,
 26.20,27.39,28.52,31.61,34.65,38.08,42.00,45.67,51.96,57.93,
 63.53,69.09,74.32,79.48,84.41,99.62,115.53,137.18,165.51,195.41,
 267.58,354.05};
static float alpha10_nx064_nz30_fwhm300[32] = {
 14.66,16.20,17.48,18.89,20.64,22.03,24.70,26.76,28.69,30.39,
 32.01,33.53,35.05,38.84,42.45,46.81,51.42,55.81,63.50,71.02,
 78.37,85.07,91.40,98.30,104.56,123.53,142.88,169.75,204.00,242.22,
 329.47,437.12};
static float alpha10_nx064_nz30_fwhm325[32] = {
 17.36,19.12,20.62,22.45,24.53,26.35,29.27,31.79,34.03,36.19,
 38.28,40.19,42.01,46.59,50.71,56.01,61.51,66.91,76.56,85.29,
 93.91,102.02,110.02,118.03,125.56,148.43,172.12,203.57,245.25,290.85,
 394.88,521.60};
static float alpha10_nx064_nz30_fwhm350[32] = {
 20.15,22.13,23.93,26.07,28.46,30.57,34.16,37.19,39.84,42.38,
 44.75,46.95,49.19,54.69,59.64,65.34,71.86,78.05,89.57,100.60,
 110.38,119.69,129.32,138.69,147.51,175.37,202.72,238.89,288.13,341.67,
 463.57,613.38};
static float alpha10_nx064_nz30_fwhm375[32] = {
 22.61,25.15,27.40,29.94,32.58,34.90,39.10,42.59,45.88,48.58,
 51.17,53.78,56.29,62.80,67.88,75.20,82.75,90.16,103.71,116.00,
 127.38,138.52,149.29,160.37,170.32,203.10,234.30,277.73,334.27,395.27,
 532.89,704.90};
static float alpha10_nx064_nz30_fwhm400[32] = {
 25.35,28.31,31.02,33.73,36.58,39.21,44.00,47.97,51.45,54.86,
 58.09,60.81,63.33,70.80,77.37,85.36,94.70,102.66,118.03,131.91,
 144.42,157.91,170.21,182.91,195.62,233.20,268.31,317.50,383.70,452.62,
 606.00,794.00};
static float alpha10_nx064_nz30_fwhm425[32] = {
 27.97,31.10,33.96,37.19,40.64,43.68,48.92,53.22,57.26,61.07,
 65.00,68.17,71.25,79.17,86.96,96.20,106.33,115.73,132.52,148.30,
 163.50,178.38,192.62,207.38,221.08,262.42,303.80,360.80,432.67,508.64,
 683.29,885.29};
static float alpha10_nx064_nz30_fwhm450[32] = {
 30.54,34.23,37.03,40.52,44.43,47.68,53.45,58.65,63.51,67.84,
 71.67,75.30,78.56,88.30,96.97,106.79,117.90,128.18,147.95,165.71,
 183.37,199.86,216.85,233.07,249.00,295.25,340.70,403.00,484.17,567.25,
 759.75,978.62};
static float alpha10_nx064_nz30_fwhm475[32] = {
 32.74,36.56,39.96,44.13,48.33,51.78,58.69,64.33,69.79,74.44,
 78.80,83.23,86.76,97.42,106.33,117.36,129.76,141.43,163.74,184.14,
 204.10,223.40,241.53,258.24,275.00,327.27,377.31,446.25,534.43,626.40,
 832.20,1071.67};
static float alpha10_nx064_nz30_fwhm500[32] = {
 35.13,39.40,43.19,47.44,52.27,56.41,63.54,69.89,75.83,80.98,
 85.78,90.38,94.67,106.03,116.12,127.69,142.14,155.83,179.91,203.00,
 224.83,245.83,264.57,283.92,304.21,359.31,412.86,490.87,588.40,685.33,
 910.33,1170.33};
static float *alpha10_nx064_nz30[21] = {
 alpha10_nx064_nz30_fwhm000, alpha10_nx064_nz30_fwhm025, alpha10_nx064_nz30_fwhm050, 
 alpha10_nx064_nz30_fwhm075, alpha10_nx064_nz30_fwhm100, alpha10_nx064_nz30_fwhm125, 
 alpha10_nx064_nz30_fwhm150, alpha10_nx064_nz30_fwhm175, alpha10_nx064_nz30_fwhm200, 
 alpha10_nx064_nz30_fwhm225, alpha10_nx064_nz30_fwhm250, alpha10_nx064_nz30_fwhm275, 
 alpha10_nx064_nz30_fwhm300, alpha10_nx064_nz30_fwhm325, alpha10_nx064_nz30_fwhm350, 
 alpha10_nx064_nz30_fwhm375, alpha10_nx064_nz30_fwhm400, alpha10_nx064_nz30_fwhm425, 
 alpha10_nx064_nz30_fwhm450, alpha10_nx064_nz30_fwhm475, alpha10_nx064_nz30_fwhm500} ;

static float **nx064_nz30[3] = {
  alpha01_nx064_nz30 , alpha05_nx064_nz30 , alpha10_nx064_nz30 };

static float ***nx064[30] = {
nx064_nz01,nx064_nz02,nx064_nz03,nx064_nz04,nx064_nz05,nx064_nz06,nx064_nz07,nx064_nz08,nx064_nz09,nx064_nz10,nx064_nz11,nx064_nz12,nx064_nz13,nx064_nz14,nx064_nz15,nx064_nz16,nx064_nz17,nx064_nz18,nx064_nz19,nx064_nz20,nx064_nz21,nx064_nz22,nx064_nz23,nx064_nz24,nx064_nz25,nx064_nz26,nx064_nz27,nx064_nz28,nx064_nz29,nx064_nz30
};

static float pval[32] = {
 0.0001,0.00013,0.00016,0.0002,0.00025,0.0003,0.0004,0.0005,0.0006,
 0.0007,0.0008,0.0009,0.001,0.0013,0.0016,0.002,0.0025,0.003,0.004,
 0.005,0.006,0.007,0.008,0.009,0.01,0.013,0.016,0.02,0.025,0.03,0.04,0.05};

static float fwhm[21] = {
 0,0.25,0.5,0.75,1,1.25,1.5,1.75,2,2.25,2.5,
 2.75,3,3.25,3.5,3.75,4,4.25,4.5,4.75,5 };
#endif
