/** automatically generated by AFNI program quotize **/
static char *readme_env[] = {
   "###########################################\n" ,
   "###  Intro: Unix env vars used by AFNI  ###\n" ,
   "###########################################\n" ,
   "\n" ,
   "The AFNI program allows you to use several Unix environment variables\n" ,
   "to influence its behavior. The mechanics of setting an environment\n" ,
   "variable depend on which shell you are using. To set an environment\n" ,
   "variable named \"FRED\" to the string \"Elvis\":\n" ,
   "\n" ,
   "   csh or tcsh:  setenv FRED Elvis\n" ,
   "   bash or ksh:  FRED=Elvis ; export FRED\n" ,
   "\n" ,
   "Normally, these commands would go in your .cshrc or .profile files,\n" ,
   "so that they would be invoked when you login. If in doubt, consult\n" ,
   "your local Unix guru. If you don't have one, well....\n" ,
   "\n" ,
   "You don't NEED to set any of these variables -- AFNI will still work\n" ,
   "correctly. But they are an easy way to set up certain defaults to\n" ,
   "make AFNI a little easier on your neocortex and hippocampus.\n" ,
   "\n" ,
   "N.B.: Changes to environment variables AFTER you start a program will\n" ,
   "      not be seen by that program, since each running program gets\n" ,
   "      a private copy of the entire set of environment variables when\n" ,
   "      it starts. This is a standard Unix feature, and is not specific\n" ,
   "      to AFNI. Some variables can be set internally in AFNI using\n" ,
   "      the \"Edit Environment\" control from the \"Datamode->Misc\" menu\n" ,
   "      or from the image window Button-3 popup menu. Such variables\n" ,
   "      are marked with \"(editable)\" in the descriptions below.\n" ,
   "\n" ,
   "N.B.: Some variables below are described as being of \"YES/NO\" type.\n" ,
   "      This means that they should either be set to the value \"YES\"\n" ,
   "      or to the value \"NO\".\n" ,
   "\n" ,
   "N.B.: You can now set environment variables on the 'afni' command\n" ,
   "      line; for example:\n" ,
   "         afni -DAFNI_SESSTRAIL=3 -DAFNI_FUNC_ALPHA=YES\n" ,
   "      This may be useful for a 'one time' situation, or as an alias.\n" ,
   "      You can also use this '-Dname=val' option in 1dplot and 3dDeconvolve.\n" ,
   "      [RWCox: 22 Mar 2005]\n" ,
   "      And now you can use this feature on most program command lines.\n" ,
   "      [RWCox: 13 Dec 2007]\n" ,
   "\n" ,
   "N.B.: At the end of this file is a list of several environment variables\n" ,
   "      that affect the program 3dDeconvolve, rather than the interactive\n" ,
   "      AFNI program itself.\n" ,
   "\n" ,
   "N.B.: If you set an AFNI environment variable on the command line, or\n" ,
   "      in a shell startup file (e.g., ~/.cshrc), and also have that\n" ,
   "      variable in your ~/.afnirc file, you will get a warning telling\n" ,
   "      you that the value in the ~/.afnirc file is being ignored.\n" ,
   "      To turn off these warnings, set environment variable\n" ,
   "      AFNI_ENVIRON_WARNINGS to NO.\n" ,
   "\n" ,
   "N.B.: You can allow the .afnirc file to re-set existing environment\n" ,
   "      variables by setting environment variable AFNI_ENVIRON_RESET to YES.\n" ,
   "\n" ,
   "#################################################\n" ,
   "###  Setting env variables in file ~/.afnirc  ###\n" ,
   "#################################################\n" ,
   "\n" ,
   "As of June, 1999, you can now set environment variables for an interactive\n" ,
   "AFNI run in the setup (~/.afnirc) file. This is provided as a convenience.\n" ,
   "An example:\n" ,
   "\n" ,
   "   ***ENVIRONMENT\n" ,
   "     AFNI_HINTS = YES\n" ,
   "     AFNI_SESSTRAIL = 3\n" ,
   "\n" ,
   "Note that the spaces around the \"=\" sign are required. See README.setup\n" ,
   "for more information about the possible contents of .afnirc besides the\n" ,
   "environment variables.\n" ,
   "\n" ,
   "A few other programs in the AFNI package also read the ***ENVIRONMENT\n" ,
   "section of the .afnirc file. This is needed so that environment settings\n" ,
   "that affect those programs (e.g., AFNI_COMPRESSOR for auto-compression of\n" ,
   "output datasets) can be properly initialized in .afnirc.\n" ,
   "\n" ,
   "At the same time, the routine in AFNI that initializes certain internal\n" ,
   "constants from X11 resources (usually in your .Xdefaults or .Xresources\n" ,
   "file, and described in file AFNI.Xdefaults) has been modified to also\n" ,
   "allow the same constants to be set from Unix environment variables.\n" ,
   "For example, the gap (in pixels) between sub-graphs is set by the\n" ,
   "X11 resource \"AFNI*graph_ggap\", and can now be set by the environment\n" ,
   "variables \"AFNI_graph_ggap\" or \"AFNI_GRAPH_GGAP\", as in:\n" ,
   "\n" ,
   "  AFNI_graph_ggap = 6   // this is a comment\n" ,
   "\n" ,
   "If an X11 resource is actually set, it will take priority over the\n" ,
   "environment variable. Some of the variables that can be set in this\n" ,
   "way are:\n" ,
   "\n" ,
   "   AFNI_ncolors             = number of gray levels to use\n" ,
   "   AFNI_gamma               = gamma correction for image intensities\n" ,
   "   AFNI_graph_boxes_thick   = 0=thin lines, 1=thick lines, for graph boxes\n" ,
   "   AFNI_graph_grid_thick    = ditto for the graph vertical grid lines\n" ,
   "   AFNI_graph_data_thick    = ditto for the data graphs\n" ,
   "   AFNI_graph_ideal_thick   = ditto for the ideal graphs\n" ,
   "   AFNI_graph_ort_thick     = ditto for the ort graphs\n" ,
   "   AFNI_graph_dplot_thick   = ditto for the dplot graphs\n" ,
   "   AFNI_graph_ggap          = initial spacing between graph boxes\n" ,
   "   AFNI_graph_matrix        = initial number of sub-graphs\n" ,
   "   AFNI_fim_polort          = polynomial detrending order for FIM\n" ,
   "   AFNI_fim_ignore          = how many pts to ignore at start when doing FIM\n" ,
   "   AFNI_montage_periodic    = True allows periodic montage wraparound\n" ,
   "   AFNI_purge               = True allows automatic dataset memory purge\n" ,
   "   AFNI_resam_vox           = dimension of voxel (mm) for resampled datasets\n" ,
   "   AFNI_resam_anat          = One of NN, Li, Cu, Bk for Anat resampling mode\n" ,
   "   AFNI_resam_func          = ditto for Func resampling mode\n" ,
   "   AFNI_resam_thr           = ditto for Threshold resampling mode\n" ,
   "   AFNI_pbar_posfunc        = True will start color pbar as all positive\n" ,
   "   AFNI_pbar_sgn_pane_count = # of panes to start signed color pbar with\n" ,
   "   AFNI_pbar_pos_pane_count = # of panes to start positive color pbar with\n" ,
   "\n" ,
   "Some other such variables are described in file AFNI.Xdefaults. Note that\n" ,
   "values that actually affect the way the X11/Motif interface appears, such as\n" ,
   "AFNI*troughColor, must be set via the X11 mechanism and cannot be set using\n" ,
   "Unix environment variables. This is because they are interpreted by the\n" ,
   "Motif graphics library when it starts and not by any actual AFNI code.\n" ,
   "\n" ,
   "The following example is from my own .afnirc file on the Linux system on\n" ,
   "which I do most of the AFNI development. The first ones (in lower case)\n" ,
   "are described in AFNI.Xdefaults. The later ones (all upper case) are\n" ,
   "documented in this file. (You can tell from this file that I like to\n" ,
   "have things line up. You would never be able to tell this from the\n" ,
   "piles of paper in my office, though.) And the file is:\n" ,
   "\n" ,
   " ***ENVIRONMENT\n" ,
   "   AFNI_ncolors             = 60      // number of gray levels\n" ,
   "   AFNI_gamma               = 1.5     // adjust for proper display\n" ,
   "   AFNI_purge               = True    // purge datasets from memory when not used\n" ,
   "   AFNI_chooser_doubleclick = Apply   // like Apply button; could also be Set\n" ,
   "   AFNI_chooser_listmax     = 25      // max nonscrolling items in chooser lists\n" ,
   "   AFNI_graph_width         = 512     // initial width of graph window (pixels)\n" ,
   "   AFNI_graph_height        = 384     // initial height of graph window\n" ,
   "   AFNI_graph_data_thick    = 1       // graph time series with thick lines\n" ,
   "   AFNI_fim_ignore          = 2       // default value for FIM ignore\n" ,
   "   AFNI_graph_ggap          = 7       // gap between sub-graphs (pixels)\n" ,
   "   AFNI_pbar_hide           = True    // hide color pbar when it changes size\n" ,
   "   AFNI_hotcolor            = Violet  // color to use on Done and Set buttons\n" ,
   "   AFNI_SESSTRAIL           = 2       // see below for these ...\n" ,
   "   AFNI_RENDER_ANGLE_DELTA  = 4.0     //                       |\n" ,
   "   AFNI_RENDER_CUTOUT_DELTA = 4.0     //                       |\n" ,
   "   AFNI_FIM_BKTHR           = 25.0    //                       |\n" ,
   "   AFNI_SPLASHTIME          = 3.0     //                       v\n" ,
   "\n" ,
   "###################################\n" ,
   "###  Env vars: the looong list  ###\n" ,
   "###################################\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_MESSAGE_PREFIX\n" ,
   "-----------------------------\n" ,
   "Most AFNI programs output various messages prefixed by '++', '**', and\n" ,
   "divers variations. If you are running several programs at once, you can\n" ,
   "prepend a string to these prefixes to distinguish them in the output\n" ,
   "terminal stream. For example, a csh script might look like so:\n" ,
   "  foreach fred ( 1 2 3 4 )\n" ,
   "    setenv AFNI_MESSAGE_PREFIX case$fred\n" ,
   "    run_some_program -option $fred ... |& tee out${fred}.txt &\n" ,
   "  end\n" ,
   "  wait\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_MESSAGE_COLORIZE   [22 Feb 2016]\n" ,
   "-------------------------------\n" ,
   "When AFNI programs print WARNING or ERROR messages, they normally\n" ,
   "print the 'WARNING' or 'ERROR' label using inverted colors, to aid in\n" ,
   "picking out these messages from other text on the screen. To turn\n" ,
   "this feature off, set this environment variable to 'NO'.\n" ,
   "\n" ,
   "-----------------------\n" ,
   "Variable: AFNI_FONTSIZE   [06 Nov 2018]\n" ,
   "-----------------------\n" ,
   "This variable can be used to set the AFNI controller font sizes.\n" ,
   "It is a convenient way to avoid using the '-XXXfontsize' option.\n" ,
   "The values this variable can take are:\n" ,
   "   MINUS ==> smaller than normal fonts\n" ,
   "   PLUS  ==> larger than normal fonts\n" ,
   "   BIG   ==> much larger than normal fonts\n" ,
   "\n" ,
   "------------------------------------\n" ,
   "Variable: AFNI_DONT_SORT_ENVIRONMENT\n" ,
   "------------------------------------\n" ,
   "If this YES/NO variable is YES, then the Edit Environment controls\n" ,
   "will NOT be sorted alphabetically. The default action is to sort them\n" ,
   "alphabetically. If they are unsorted, the editable environment\n" ,
   "variables will appear in the control panel in the order in which they\n" ,
   "were added to the code (that is, in an order that makes no real\n" ,
   "sense).\n" ,
   "\n" ,
   "---------------------\n" ,
   "Variable: AFNI_ORIENT (editable)\n" ,
   "---------------------\n" ,
   "This is a string used to control the display of coordinates in the AFNI\n" ,
   "main control window. The string must be 3 letters, one each from the\n" ,
   "pairs {R,L} {A,P} {I,S}. The first letter in the string gives the\n" ,
   "orientation of the x-axis, the second the orientation of the y-axis,\n" ,
   "the third the z-axis:\n" ,
   "\n" ,
   "   R = right-to-left           L = left-to-right\n" ,
   "   A = anterior-to-posterior   P = posterior-to-anterior\n" ,
   "   I = inferior-to-superior    S = superior-to-inferior\n" ,
   "\n" ,
   "If AFNI_ORIENT is undefined, the default is RAI. This is the order\n" ,
   "used by DICOM, and means\n" ,
   "\n" ,
   "   the -x axis is Right,    the +x axis is Left,\n" ,
   "   the -y axis is Anterior, the +y axis is Posterior,\n" ,
   "   the -z axis is Inferior, the +z axis is Superior.\n" ,
   "\n" ,
   "As a special case, using the code 'flipped' is equivalent to 'LPI',\n" ,
   "which is the orientation used in many neuroscience journals.\n" ,
   "\n" ,
   "This variable is also recognized by program 3dclust, which will report\n" ,
   "the cluster coordinates in the (x,y,z) order given by AFNI_ORIENT.\n" ,
   "Both AFNI and 3dclust also recognize the command line switch\n" ,
   "\"-orient string\", where string is a 3 letter code that can be used\n" ,
   "to override the value of AFNI_ORIENT.\n" ,
   "\n" ,
   "The plugin \"Coord Order\" (plug_coord.c) allows you to interactively\n" ,
   "change the orientation of the variable display within AFNI.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_PLUGINPATH\n" ,
   "-------------------------\n" ,
   "This variable should be the directory in which AFNI should search for\n" ,
   "plugins, executable files, atlases, templates and atlas definition\n" ,
   "files. See the atlas environment variable section below for more\n" ,
   "details. If there is more than one appropriate directory, they can be\n" ,
   "separated by colons, as in\n" ,
   "\n" ,
   "   setenv AFNI_PLUGINPATH /directory/one:/directory/two\n" ,
   "\n" ,
   "If this variable is not set, then AFNI will use the PATH variable\n" ,
   "instead. This will waste time, since most directories in the PATH\n" ,
   "will not have plugins. On some systems, using the PATH has been\n" ,
   "known to cause problems when AFNI starts. I believe this is due to\n" ,
   "bugs in the system library routines (e.g., dlopen) used to manage\n" ,
   "dynamically loaded shared objects. Take care to remove any slow or\n" ,
   "non-existent directories from the PATH because these problems will cause\n" ,
   "searches to fail or become excessively slow.\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_NOPLUGINS\n" ,
   "------------------------\n" ,
   "If this YES/NO variable is set to YES, then AFNI will not try to\n" ,
   "read plugins when it starts up. The command line switch \"-noplugins\"\n" ,
   "will have the same effect.\n" ,
   "\n" ,
   "--------------------------------\n" ,
   "Variable: AFNI_ALLOW_ALL_PLUGINS\n" ,
   "--------------------------------\n" ,
   "Setting this variable to YES will allow all defined plugins to\n" ,
   "be loaded. Otherwise, little-used plugins must be allowed one\n" ,
   "at a time, using the next set of variable names.\n" ,
   "\n" ,
   "-------------------------------------\n" ,
   "Variables: AFNI_ALLOW_somename_PLUGIN\n" ,
   "-------------------------------------\n" ,
   "Some plugins distributed with AFNI are not commonly used, and are\n" ,
   "disabled by default. If you wish to turn one of these plugins\n" ,
   "back on, set the corresponding environment variable to YES.\n" ,
   "The list of these plugins is:\n" ,
   "  --- somename ---     --- name in menu ---\n" ,
   "  2DREGISTRATION       2D Registration\n" ,
   "  3DCLUSTER            3D Cluster\n" ,
   "  3DCORRELATION        3D Correlation\n" ,
   "  3DDUMP98             3D Dump98\n" ,
   "  3DEDIT               3D Edit\n" ,
   "  3DEXTRACT            3D+t Extract\n" ,
   "  3DREGISTRATION       3D Registration\n" ,
   "  3DSTATISTIC          3D+t Statistic\n" ,
   "  4DDUMP               4D Dump\n" ,
   "  ASL                  ASL a3/d3\n" ,
   "  BRIKCOMPRESSOR       BRIK Compressor\n" ,
   "  COORDORDER           Coord Order\n" ,
   "  DATASETCOPY          Dataset Copy\n" ,
   "  DATASETDUP           Dataset Dup\n" ,
   "  DATASETRENAME        Dataset Rename\n" ,
   "  DECONVOLVE           Deconvolution\n" ,
   "  DSETZEROPAD          Dset Zeropad\n" ,
   "  FOURIER              Fourier\n" ,
   "  GYRUSFINDER          Gyrus Finder\n" ,
   "  HEMISUBTRACT         Hemi-subtract\n" ,
   "  HILBERTDELAY98       Hilbert Delay98\n" ,
   "  HISTOGRAMBFIT        Histogram: BFit\n" ,
   "  L1FIT                L1_Fit & Dtr\n" ,
   "  L2FIT                LSqFit & Dtr\n" ,
   "  MASKCALC             maskcalc\n" ,
   "  PERMUTATIONTEST      Permutation Test\n" ,
   "  POWERSPECTRUM        Power Spectrum\n" ,
   "  REORDER              Reorder\n" ,
   "  RETROICOR            RETROICOR\n" ,
   "  ROIAVERAGE           ROI Average\n" ,
   "  ROIPLOT              ROI Plot\n" ,
   "  SINGLETRIALAVG       SingleTrial Avg\n" ,
   "  THRESHOLD            Threshold\n" ,
   "  TSGENERATE           TS Generate\n" ,
   "  WAVELETS             Wavelets\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_YESPLUGOUTS\n" ,
   "--------------------------\n" ,
   "If this YES/NO variable is set to YES, then AFNI will try to listen\n" ,
   "for plugouts when it starts. The command line switch \"-yesplugouts\"\n" ,
   "will have the same effect. (Plugouts are an experimental feature\n" ,
   "that allow external programs to exchange data with AFNI.)  It is now\n" ,
   "also possible to start plugout listening from the Datamode->Misc menu.\n" ,
   "\n" ,
   "---------------------\n" ,
   "Variable: AFNI_TSPATH\n" ,
   "---------------------\n" ,
   "This variable should be set to any directory which you want to have\n" ,
   "AFNI scan for timeseries files (*.1D -- see the AFNI manual). If\n" ,
   "more than one directory is desired, then colons can be used to\n" ,
   "separate them, as in AFNI_PLUGINPATH. Note that timeseries files\n" ,
   "are read from all session directories, so directories provided by\n" ,
   "AFNI_TSPATH are designed to contain extra timeseries files that\n" ,
   "you want loaded no matter what AFNI sessions and datasets are being\n" ,
   "viewed.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_TCSV_VIEWNUM\n" ,
   "---------------------------\n" ,
   "This numeric value sets the number of preview lines for the AFNI\n" ,
   "*.tsv/*.csv (TCSV) file chooser. If you don't set this to a\n" ,
   "positive value, then the default number of preview lines is 4.\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_MODELPATH\n" ,
   "------------------------\n" ,
   "This variable should be set to the directory from which you want AFNI\n" ,
   "timeseries models to be loaded. These models are similar to plugins,\n" ,
   "and are used by programs 3dNLfim, 3dTSgen, and the plugin plug_nlfit\n" ,
   "(menu label \"NLfit & NLerr\") -- see documentation file 3dNLfim.ps.\n" ,
   "If AFNI_MODELPATH is not given, then AFNI_PLUGINPATH will be used\n" ,
   "instead.\n" ,
   "\n" ,
   "-----------------------------------------\n" ,
   "Variable: AFNI_IMSIZE_* (or MCW_IMSIZE_*)\n" ,
   "-----------------------------------------\n" ,
   "These variables (named AFNI_IMSIZE_1 to AFNI_IMSIZE_99) allow you\n" ,
   "to control how the AFNI programs read binary image files. The use of\n" ,
   "these is somewhat complicated, and is explained in detail at the end\n" ,
   "of the auxiliary programs manual (afni_aux.ps), in the section on \"3D:\"\n" ,
   "file specifications, and is also explained in the AFNI FAQ list.\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_SESSTRAIL (editable)\n" ,
   "------------------------\n" ,
   "This variable controls the number of directory levels shown when\n" ,
   "choosing between session directories with the \"Switch Session\"\n" ,
   "button. This variable should be set to a nonnegative integer.\n" ,
   "If a session directory name were\n" ,
   "   this/is/a/directory/name/\n" ,
   "then the \"Switch Session\" chooser would display the following:\n" ,
   "\n" ,
   "   AFNI_SESSTRAIL    Display\n" ,
   "   --------------    -------\n" ,
   "            0        name/\n" ,
   "            1        directory/name/\n" ,
   "            2        a/directory/name/\n" ,
   "            3        is/a/directory/name/\n" ,
   "            4        this/is/a/directory/name/\n" ,
   "\n" ,
   "That is, AFNI_SESSTRAIL determines how many trailing levels of\n" ,
   "the directory name are used for the display. If AFNI_SESSTRAIL\n" ,
   "is not set, then it is equivalent to setting it to 0 (which\n" ,
   "was the old method).\n" ,
   "\n" ,
   "--------------------\n" ,
   "Variable: AFNI_HINTS\n" ,
   "--------------------\n" ,
   "This is a string controlling whether or not the popup \"hints\" are\n" ,
   "displayed when AFNI starts. If the string is \"NO\", then the hints\n" ,
   "are disabled when AFNI starts, otherwise they are enabled. In\n" ,
   "either case, they can be turned off and on interactively from the\n" ,
   "Define Datamode->Misc menu.\n" ,
   "\n" ,
   "Hints can be permanently disabled by setting the C macro\n" ,
   "DONT_USE_HINTS in machdep.h and recompiling AFNI. They can also\n" ,
   "be disabled at runtime by setting AFNI_HINTS to \"KILL\".\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_COMPRESSOR (cf. AFNI_AUTOGZIP) (editable)\n" ,
   "-------------------------\n" ,
   "This variable is used to control automatic compression of .BRIK files\n" ,
   "on output. The legal values are \"COMPRESS\", \"GZIP\", \"BZIP2\", \"PIGZ\",\n" ,
   "which respectively invoke programs \"compress\", \"gzip\",\"bzip2\" and\n" ,
   "\"pigz\" (these must be in your path for compression to work). If\n" ,
   "AFNI_COMPRESSOR is equal to one of these, then all AFNI programs will\n" ,
   "automatically pass .BRIK data through the appropriate compression\n" ,
   "program as it is written to disk. Note that this will slow down\n" ,
   "dataset write operations. Note also that compressed datasets cannot\n" ,
   "be mapped directly from disk into memory ('mmap'), but must occupy\n" ,
   "actual memory (RAM) and swap space. For more details, see file\n" ,
   "README.compression.\n" ,
   "\n" ,
   "Note that compressed (.BRIK.Z, .BRIK.gz, and .BRIK.bz2) datasets will\n" ,
   "automatically be uncompressed on input, no matter what the setting of\n" ,
   "this variable. AFNI_COMPRESSOR only controls how the datasets are\n" ,
   "written.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_DONT_USE_PIGZ\n" ,
   "----------------------------\n" ,
   "On some systems, the multi-threaded version of gzip -- program pigz --\n" ,
   "can fail randomly. To prevent the use of pigz even if it is found,\n" ,
   "set this variable to YES. Note that if you explicitly set\n" ,
   "AFNI_COMPRESSOR to PIGZ, then AFNI_DONT_USE_PIGZ will be ignored. The\n" ,
   "purpose of AFNI_DONT_USE_PIGZ is to prevent the automatic use of the\n" ,
   "pigz program in cases where you don't provide AFNI_COMPRESSOR\n" ,
   "explicitly.\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_BYTEORDER\n" ,
   "------------------------\n" ,
   "This variable is used to control the byte order for output files.\n" ,
   "If you use it, the two legal values are \"LSB_FIRST\" and \"MSB_FIRST\".\n" ,
   "If you don't use it, the default order on your CPU will be used.\n" ,
   "The main purpose of this would be if you were using a mixture of\n" ,
   "CPU types reading shared disks (i.e., using NFS). If the majority\n" ,
   "of the systems were MSB_FIRST (e.g., SGI, HP, Sun), but there were\n" ,
   "a few LSB_FIRST systems (e.g., Intel, DEC Alpha), then you might\n" ,
   "want to do 'setenv AFNI_BYTEORDER MSB_FIRST' on all of the MSB_FIRST\n" ,
   "systems to make sure that the datasets that they write out are\n" ,
   "readable by the other computers.\n" ,
   "\n" ,
   "Note that AFNI programs can now check the .HEAD file for the byte\n" ,
   "order of a dataset, and will swap the bytes on input, if needed.\n" ,
   "If you wish to mark all of the datasets on a given system as\n" ,
   "being in a particular order, the following command should work:\n" ,
   "\n" ,
   " find /top/dir -name \\*.HEAD -exec 3drefit -byteorder NATIVE_ORDER {} \\;\n" ,
   "\n" ,
   "Here, '/top/dir' is the name of the top level directory under\n" ,
   "which you wish to search for AFNI datasets. The string NATIVE_ORDER\n" ,
   "means to set all datasets to the CPU default order, which is probably\n" ,
   "what you are using now. (You can use the program 'byteorder' to\n" ,
   "find out the native byte ordering of your CPU.)\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_BYTEORDER_INPUT\n" ,
   "------------------------------\n" ,
   "This variable is used to control the byte order for input files.\n" ,
   "If you use it, the two legal values are \"LSB_FIRST\" and \"MSB_FIRST\".\n" ,
   "The value of this variable is only used for old datasets that do\n" ,
   "not have the byte order encoded in their headers. If this variable\n" ,
   "is not present, then the CPU native byte order is used. If this\n" ,
   "variable is present, and its value differs from the native byte\n" ,
   "order, then 2 byte dataset BRIKs (short) are 2-swapped (as in\n" ,
   "\"ab\" -> \"ba\") when they are read from disk, and 4 byte datasets\n" ,
   "(float, complex) are 4-swapped (\"abcd\" -> \"dcba\").\n" ,
   "\n" ,
   "[per the request of John Koger]\n" ,
   "\n" ,
   "---------------------\n" ,
   "Variable: AFNI_NOMMAP\n" ,
   "---------------------\n" ,
   "This YES/NO variable can be used to turn off the mmap feature by which\n" ,
   "AFNI can load datasets into memory using the map-file-to-memory\n" ,
   "functionality of Unix. (Dataset .BRIK files will only be mmap-ed if\n" ,
   "they are not compressed and are in the native byte order of the CPU.)\n" ,
   "On some systems, mmap doesn't seem to work very well (e.g., Linux kernel\n" ,
   "version 1.2.13). You can disable mmap by 'setenv AFNI_NOMMAP YES'.\n" ,
   "\n" ,
   "The penalty for disabling mmap is that all datasets must be loaded\n" ,
   "into actual RAM. AFNI does not have the ability to load a dataset\n" ,
   "only partially, so if a 20 Megabyte .BRIK file is accessed, all of it\n" ,
   "will be loaded into RAM. With mmap, the Unix operating system will\n" ,
   "decide how much of the file to load. In this way, it is possible to\n" ,
   "deal with more files than you have swap space on your computer (since\n" ,
   ".BRIK files are mmap-ed in readonly mode, so they don't take up swap\n" ,
   "space, which is for saving modified memory pages).\n" ,
   "\n" ,
   "The moral of the story: buy more memory, it's cheap. At the time\n" ,
   "I write this line [Aug 1998], I have a PC with 384 MB of RAM, and\n" ,
   "it is great to use with AFNI.\n" ,
   "\n" ,
   "[Feb 2004] I now have a Mac G5 with 8 GB of RAM, and it is even\n" ,
   "greater!  [Oct 2010] Now I have 32 GB of RAM (more than Ziad - ha!),\n" ,
   "and it's nice!\n" ,
   "\n" ,
   "----------------------\n" ,
   "Variable: AFNI_PSPRINT (editable)\n" ,
   "----------------------\n" ,
   "This variable is used to define a command that will print the\n" ,
   "standard input (stdin) to a PostScript printer. If it is defined,\n" ,
   "the \"->printer\" button on the timeseries \"Plot\" windows will work.\n" ,
   "For some Unix systems, the following should work:\n" ,
   "  setenv AFNI_PSPRINT \"lp -\"\n" ,
   "For others, this may work\n" ,
   "  setenv AFNI_PSPRINT \"lpr -\"\n" ,
   "It all depends on the printer software setup you have. To send the\n" ,
   "output into GhostView\n" ,
   "  setenv AFNI_PSPRINT \"ghostview -landscape -\"\n" ,
   "\n" ,
   "In the (very far distant) future, other windows (e.g., image and graph\n" ,
   "displays) may get the ability to print to a PostScript file or printer.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_LEFT_IS_LEFT (editable)\n" ,
   "---------------------------\n" ,
   "Setting this YES/NO variable to YES tells AFNI to display images with\n" ,
   "the left side of the subject on the left side of the window. The\n" ,
   "default mode is to display the right side of the subject on the left\n" ,
   "side of the window - the radiology convention. This setting affects\n" ,
   "the coronal and axial image and graph viewers.\n" ,
   "\n" ,
   "--------------------------------\n" ,
   "Variable: AFNI_LEFT_IS_POSTERIOR (editable)\n" ,
   "--------------------------------\n" ,
   "Setting this YES/NO variable to YES tells AFNI to display images with\n" ,
   "the posterior side of the subject on the left side of the window. The\n" ,
   "default mode is to display the anterior side of the subject on the\n" ,
   "left side of the window. This setting affects the sagittal image and\n" ,
   "graph viewers.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_ALWAYS_LOCK\n" ,
   "--------------------------\n" ,
   "Setting this YES/NO variable to YES tells AFNI to start up with all\n" ,
   "the controller windows locked together. If you mostly use multiple\n" ,
   "controllers to view datasets in unison, then this will be useful.\n" ,
   "Notice that the Time Lock feature is not automatically enabled\n" ,
   "by this -- you must still actuate it manually from the Lock menu\n" ,
   "on the Define Datamode panel.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_TIME_LOCK\n" ,
   "--------------------------\n" ,
   "Setting this YES/NO variable to YES tells AFNI to start up with\n" ,
   "Time lock turned on. The Time Lock feature can be set manually\n" ,
   "from the Lock menu on the Define Datamode panel.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_ZOOM_LOCK\n" ,
   "--------------------------\n" ,
   "Setting this YES/NO variable to YES tells AFNI to start up with\n" ,
   "Zoom lock turned on. The Zoom Lock feature can be set manually\n" ,
   "from the Lock menu on the Define Datamode panel.\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variables: AFNI_RENDER_* (editable)\n" ,
   "------------------------\n" ,
   "These variables set some defaults in the \"Render Dataset\" (volume\n" ,
   "rendering) plugin. The first two variables are\n" ,
   "\n" ,
   "  AFNI_RENDER_ANGLE_DELTA  = stepsize for viewing angles, in degrees\n" ,
   "  AFNI_RENDER_CUTOUT_DELTA = stepsize for cutout dimensions, in mm\n" ,
   "\n" ,
   "These stepsizes control how much the control parameters change when\n" ,
   "one of their up- or down-arrows is pressed. Both of these stepsize\n" ,
   "values default to 5.0.\n" ,
   "\n" ,
   "The third variable is\n" ,
   "\n" ,
   "  AFNI_RENDER_PRECALC_MODE = \"Low\", \"Medium\", or \"High\"\n" ,
   "\n" ,
   "This is used to set the initial precalculation mode for the renderer\n" ,
   "(this mode can be altered interactively, unlike the stepsizes).\n" ,
   "\n" ,
   "The fourth variable is\n" ,
   "\n" ,
   "  AFNI_RENDER_SHOWTHRU_FAC = some number between 0.0 and 1.0\n" ,
   "\n" ,
   "This is used to control the way in which the \"ShowThru\" Color Opacity\n" ,
   "option renders images. See the rendering plugin Help window for more\n" ,
   "information.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_NOREALPATH\n" ,
   "-------------------------\n" ,
   "Normally, when AFNI reads a list of session directories, it converts\n" ,
   "their names to the \"real path\" form, which follows symbolic links, and\n" ,
   "removes '/./' and '/../' components. These converted names are used\n" ,
   "for display purposes in the \"Switch Session\" chooser and in other\n" ,
   "places. If you wish to have the names NOT converted to the \"real path\"\n" ,
   "format, set this YES/NO environment variable to YES, as in\n" ,
   "\n" ,
   "   setenv AFNI_NOREALPATH YES\n" ,
   "\n" ,
   "(For more information on the \"real path\" conversion, see the Unix\n" ,
   "man page for the realpath() function.)  Note that if you use this\n" ,
   "feature, then the effect of AFNI_SESSTRAIL will be limited to what\n" ,
   "you type on the command line, since it is the realpath() function\n" ,
   "that provides the higher level hierarchies of the session names.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_NO_MCW_MALLOC\n" ,
   "----------------------------\n" ,
   "AFNI uses a set of \"wrapper\" macros and functions to let itself keep\n" ,
   "track of the memory allocated and freed by the C malloc() library.\n" ,
   "This is useful for debugging purposes (see the last items on the 'Misc'\n" ,
   "menu in the AFNI 'Define Datamode' control panel), but carries a small\n" ,
   "overhead (both in memory and speed). Setting this YES/NO environment\n" ,
   "variable to YES provides one way to disable this facility, as in\n" ,
   "\n" ,
   "   setenv AFNI_NO_MCW_MALLOC YES\n" ,
   "\n" ,
   "Another way to permanently disable this capability (so that it isn't\n" ,
   "even compiled) is outlined in the file machdep.h. Also, the interactive\n" ,
   "AFNI program takes the command line switch \"-nomall\", which will turn\n" ,
   "off these functions for the given run.\n" ,
   "\n" ,
   "N.B.: Setting this variable in the .afnirc file will have no effect,\n" ,
   "      since the decision whether to use the routines in mcw_malloc.c\n" ,
   "      is made at the very start of the program, before .afnirc is\n" ,
   "      scanned. Therefore, to use this variable, you must set it\n" ,
   "      externally, perhaps in your .cshrc or .profile initialization\n" ,
   "      file.\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_FIM_BKTHR\n" ,
   "------------------------\n" ,
   "This sets the threshold for the elimination of the background voxels\n" ,
   "during the interactive FIM calculations. The average intensity of\n" ,
   "all voxels in the first 3D volume used in the correlation is calculated.\n" ,
   "Voxels with intensity below 0.01 * AFNI_FIM_BKTHR * (this average)\n" ,
   "will not have the correlation computed. The default value is 10.0, but\n" ,
   "values as large as 50.0 may be useful. This parameter may be changed\n" ,
   "interactively from the FIM->Edit Ideal submenu in a graph viewer.\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_FLOATSCAN (editable)\n" ,
   "------------------------\n" ,
   "If this YES/NO variable is set to YES, then floating point bricks\n" ,
   "are checked for illegal values (NaN and Infinity) when they are\n" ,
   "read into an AFNI program -- illegal values will be replaced by\n" ,
   "zeros. If a dataset brick contains such illegal values that go\n" ,
   "undetected, AFNI programs will probably fail miserably, and have\n" ,
   "been known to go into nearly-infinite loops.\n" ,
   "\n" ,
   "Setting this variable implies setting AFNI_NOMMAP to YES, since\n" ,
   "only in-memory bricks can be altered (mmap-ed bricks are readonly).\n" ,
   "\n" ,
   "The command line program 'float_scan' can be used to check and\n" ,
   "patch floating point files.\n" ,
   "\n" ,
   "[14 Sep 1999] The program to3d will scan input float and complex\n" ,
   "files for illegal values, and patch illegal input numbers with\n" ,
   "zeros in the output dataset. If this behavior is not desired for\n" ,
   "some bizarre reason, the '-nofloatscan' command line option to\n" ,
   "to3d must be used.\n" ,
   "\n" ,
   "-----------------------\n" ,
   "Variable: AFNI_NOSPLASH\n" ,
   "-----------------------\n" ,
   "If this YES/NO variable is set to YES, then the AFNI splash screen\n" ,
   "will not be displayed when the program starts. I'm not sure WHY\n" ,
   "you would want to disable this thing of beauty (which is a joy\n" ,
   "forever), but if your soul is thusly degraded, so be it.\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_SPLASH_XY\n" ,
   "------------------------\n" ,
   "If set, this variable should be in the form \"100:37\" (two integers\n" ,
   "separated by a colon). These values specify the (x,y) screen location\n" ,
   "where the splash window's upper left corner will be placed. If not\n" ,
   "set, x will be set to center the splash window on the display and\n" ,
   "y will be 100.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_SPLASHTIME\n" ,
   "-------------------------\n" ,
   "The value of this variable determines how long the AFNI splash screen\n" ,
   "will stay popped up, in seconds (default value = 5.0). The splash\n" ,
   "screen will always stay up until the first AFNI controller window is\n" ,
   "ready for use. If the time from program start to this ready condition\n" ,
   "is less than AFNI_SPLASHTIME, the splash screen will stay up until\n" ,
   "AFNI_SPLASHTIME has elapsed; otherwise, the splash screen will be\n" ,
   "removed as soon as AFNI is ready to go. By setting AFNI_SPLASHTIME\n" ,
   "to 0.0, you can have the splash screen removed as soon as possible\n" ,
   "(and the fade-out feature will be disabled).\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_SPLASH_ANIMATE\n" ,
   "-----------------------------\n" ,
   "If this variable is NO, then the splash screen animation will be disabled.\n" ,
   "Otherwise, it will run.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_SPLASH_MELT\n" ,
   "--------------------------\n" ,
   "If this variable is YES, then the splash screen will close via 'melting'.\n" ,
   "\n" ,
   "--------------------------------\n" ,
   "Variable: AFNI_FIM_PERCENT_LIMIT (editable)\n" ,
   "--------------------------------\n" ,
   "This sets an upper limit on the % Change that the FIM+ computation\n" ,
   "will compute. For example\n" ,
   "\n" ,
   "  setenv AFNI_FIM_PERCENT_LIMIT 50\n" ,
   "\n" ,
   "means that computed values over 50% will be set to 50%, and values\n" ,
   "below -50% will be set to -50%. This can be useful to avoid scaling\n" ,
   "problems that arise when some spurious voxels with tiny baselines have\n" ,
   "huge percent changes. This limit applies to all 3 possible percentages\n" ,
   "that FIM and FIM+ can compute: % from baseline, % from average, and\n" ,
   "% from top.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_NOTES_DLINES\n" ,
   "---------------------------\n" ,
   "This sets the upper limit on the number of lines displayed in the\n" ,
   "Notes plugin, for each note. If not present, the limit is 9 lines\n" ,
   "shown per note at once. To see a note longer than this limit, you'll\n" ,
   "have to use the vertical scrollbar.\n" ,
   "\n" ,
   "-----------------------\n" ,
   "Variable: AFNI_FIM_MASK\n" ,
   "-----------------------\n" ,
   "This chooses the default subset of values computed with the FIM+\n" ,
   "button in a graph window. The mask should be the sum of the desired\n" ,
   "values from this list:\n" ,
   "\n" ,
   "    1 = Fit Coef\n" ,
   "    2 = Best Index\n" ,
   "    4 = % Change\n" ,
   "    8 = Baseline\n" ,
   "   16 = Correlation\n" ,
   "   32 = % From Ave\n" ,
   "   64 = Average\n" ,
   "  128 = % From Top\n" ,
   "  256 = Topline\n" ,
   "  512 = Sigma Resid\n" ,
   "\n" ,
   "If you don't set this variable, the default mask is 23 = 1+2+4+16.\n" ,
   "\n" ,
   "-----------------------------------\n" ,
   "Variable: AFNI_NO_BYTEORDER_WARNING\n" ,
   "-----------------------------------\n" ,
   "If this YES/NO variable is set to YES, then AFNI program will not\n" ,
   "warn you when reading in a dataset that does not contain a byte\n" ,
   "order flag. The default is to issue such a warning. Only older\n" ,
   "versions of AFNI create datasets that don't have the byte order\n" ,
   "flag. (See also the variable AFNI_BYTEORDER, described far above.)\n" ,
   "The purpose of this warning is to alert you to possible problems\n" ,
   "when you move datasets between computers with different CPU types.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_PCOR_DENEPS\n" ,
   "--------------------------\n" ,
   "The correlation coefficient calculated in FIM is calculated as the\n" ,
   "ratio of two quantities. If the denominator is negative or zero,\n" ,
   "then this value is meaningless and may even cause the program to\n" ,
   "crash. Mathematically, the denominator cannot be zero or negative,\n" ,
   "but this could arise due to finite precision arithmetic on the computer\n" ,
   "(i.e., roundoff error accumulation). To avoid this problem, the routine\n" ,
   "that computes the correlation coefficient compares the denominator to a\n" ,
   "value (called DENEPS) - if the denominator is less than DENEPS, then\n" ,
   "the correlation coefficient for that voxel is set to zero.\n" ,
   "\n" ,
   "The denominator that is being computed is proportional to the variance\n" ,
   "of the time series. If the voxel time series data is very small, then\n" ,
   "the variance will be really small - so much so that the DENEPS test\n" ,
   "will be failed, even though it shouldn't be. This problem has arisen\n" ,
   "when people input time series whose typical value is 0.001 or smaller.\n" ,
   "It never occurred to me that people would input data this small to the\n" ,
   "AFNI FIM routines. To get around this difficulty, set this environment\n" ,
   "variable to a value for DENEPS; for example\n" ,
   "  setenv AFNI_PCOR_DENEPS 0.0\n" ,
   "will turn off the checking entirely. Or you could do\n" ,
   "  setenv AFNI_PCOR_DENEPS 1.e-10\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_ENFORCE_ASPECT (editable)\n" ,
   "-----------------------------\n" ,
   "Some X11 window managers do no enforce the aspect ratio (width to height\n" ,
   "proportion) request that the image display module makes. This means that\n" ,
   "image windows can become undesirably distorted when manually resized.\n" ,
   "Setting this YES/NO variable to YES will make AFNI itself enforce the\n" ,
   "aspect ratio whenever an image window is resized.\n" ,
   "** NOTICE **\n" ,
   "  As of 10 May 2018, this variable no longer has any effect. The\n" ,
   "  enforcement never worked well, and so you now have to manage this\n" ,
   "  problem manually. To fix the aspect ratio of an image viewer\n" ,
   "  window, Left-click in the image intensity bar (right of the image)\n" ,
   "  or press the 'a' key while the mouse cursor is over the image.\n" ,
   "\n" ,
   "----------------------------------------\n" ,
   "Variables: AFNI_<plug_filename>_butcolor\n" ,
   "----------------------------------------\n" ,
   "These variables (one for each AFNI plugin) let you set the menu button\n" ,
   "colors for the Plugins menu item. For example\n" ,
   "  setenv AFNI_plug_power_butcolor red3\n" ,
   "will make the \"Power Spectrum\" button appear in a dark red color. The\n" ,
   "format of the variable is exemplified above: the <plug_filename> is\n" ,
   "replaced by the filename of the plugin (after removing the suffix).\n" ,
   "Note that it is possible for the plugin author to hardcode the menu\n" ,
   "button for his/her plugin, in which case the corresponding environment\n" ,
   "variable will have no effect.\n" ,
   "\n" ,
   "Colors are specified as described in file README.setup. If you are\n" ,
   "using an X11 PseudoColor visual, then you should be economical with\n" ,
   "color usage!\n" ,
   "\n" ,
   "The purpose of this feature is to let you highlight the plugins that\n" ,
   "you use most frequently. The size of the of plugin menu is growing,\n" ,
   "and it is easy to misplace what you most use in the list.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_MARKERS_NOQUAL (editable)\n" ,
   "-----------------------------\n" ,
   "If this YES/NO variable is set to YES, then the interactive AFNI\n" ,
   "program behaves as if the \"-noqual\" command line option had been\n" ,
   "included. This feature was added at the request of Dr. Michael\n" ,
   "S. Beauchamp, who has a very rare neurological disorder called\n" ,
   "\"noqaulagnosia\".\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_ENABLE_MARKERS\n" ,
   "-----------------------------\n" ,
   "As of 28 Apr 2010, the AFNI Talairach 'Define Markers' panel will no\n" ,
   "longer be visible by default. To use this old feature, you must set\n" ,
   "this variable to YES before running AFNI.\n" ,
   "\n" ,
   "----------------------\n" ,
   "Variable: AFNI_OPTIONS\n" ,
   "----------------------\n" ,
   "In the spirit of the previous variable, this variable can be used to\n" ,
   "set up command line options that will always be passed to the\n" ,
   "interactive AFNI program. If more than one option is needed, then\n" ,
   "they should be separated by spaces, and the whole value of the\n" ,
   "variable will need to be placed in quotes. For example\n" ,
   "\n" ,
   "   setenv AFNI_OPTIONS \"-noqual -ncolors 60\"\n" ,
   "\n" ,
   "Note that the AFNI command line option \"-nomall\" cannot be specified\n" ,
   "this way (cf. the discussion under variable AFNI_NO_MCW_MALLOC).\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_NO_SIDES_LABELS (editable)\n" ,
   "------------------------------\n" ,
   "As of 01 Dec 1999, the interactive AFNI program now displays a label\n" ,
   "beneath each image window showing which side of the image is on the\n" ,
   "left edge of the window. This label is based on the anatomical\n" ,
   "directions encoded in the anatomical dataset .HEAD file, usually when\n" ,
   "to3d was used to create the file. If you do NOT want these labels\n" ,
   "displayed (why not?), set this YES/NO environment variable to YES.\n" ,
   "\n" ,
   "----------------------------------\n" ,
   "Variable: AFNI_NO_ADOPTION_WARNING\n" ,
   "----------------------------------\n" ,
   "\n" ,
   "AFNI now can print a warning when it forces a dataset to have an\n" ,
   "anatomy parent dataset (the \"forced adoption\" function). This happens\n" ,
   "when there a dataset does not have an anatomy parent encoded into its\n" ,
   ".HEAD file (either via to3d or 3drefit), and there is more than one\n" ,
   "anatomical dataset in the directory that has Talairach transformation\n" ,
   "markers attached. If you wish to enable this warning, set this YES/NO\n" ,
   "variable to NO. For more information on this subject, please see\n" ,
   "https://afni.nimh.nih.gov/afni/afni_faq.shtml#AnatParent .\n" ,
   "\n" ,
   "-----------------------------------\n" ,
   "Variable: AFNI_NO_NEGATIVES_WARNING\n" ,
   "-----------------------------------\n" ,
   "If this YES/NO variable is set to YES, then to3d will skip the usual\n" ,
   "warning that it pops up in a message window when it discovers negative\n" ,
   "values in the input short images. (The warning will still be printed\n" ,
   "to stdout.)\n" ,
   "\n" ,
   "-----------------------------------\n" ,
   "Variable: AFNI_NO_OBLIQUE_WARNING\n" ,
   "-----------------------------------\n" ,
   "If this YES/NO variable is set to YES, then the AFNI GUI will skip the\n" ,
   "usual warning that it pops up in a message window when an oblique\n" ,
   "dataset is selected. (The warning will still be printed to stdout.)\n" ,
   "\n" ,
   "-----------------------------------\n" ,
   "Variable: AFNI_ONE_OBLIQUE_WARNING\n" ,
   "-----------------------------------\n" ,
   "If this YES/NO variable is set to YES, then the AFNI GUI will pop up a\n" ,
   "warning just ONCE when an oblique dataset is encountered.\n" ,
   "\n" ,
   "\n" ,
   "----------------------\n" ,
   "Variable: AFNI_NO_XDBE\n" ,
   "----------------------\n" ,
   "If this YES/NO variable is set to YES, then the X11 Double Buffer\n" ,
   "Extension (XDBE) will not be used, even if the X11 server supports it.\n" ,
   "This is needed when the X11 server says that it supports it, but actually\n" ,
   "does not implement it correctly - this is a problem on the Xsgi server\n" ,
   "running under IRIX 6.5.3 on R4400 machines.\n" ,
   "\n" ,
   "----------------------------------------------------\n" ,
   "Variable: AFNI_VIEW_ANAT_BRICK, AFNI_VIEW_FUNC_BRICK (editable)\n" ,
   "----------------------------------------------------\n" ,
   "One of the (very few) confusing parts of AFNI is the \"warp-on-demand\"\n" ,
   "viewing of transformed datasets (e.g., in the +tlrc coordinate system).\n" ,
   "This allows you to look at slices taken from transformed volumes without\n" ,
   "actually computing and storing the entire transformed dataset. This\n" ,
   "viewing mode is controlled by from the \"Define Datamode\" control panel.\n" ,
   "When an anatomical dataset has a +tlrc.BRIK file, then you can choose\n" ,
   "between \"View Anat Data Brick\" and \"Warp Anat on Demand\"; when there\n" ,
   "is no +tlrc.BRIK file for the dataset, then only \"Warp Anat on Demand\"\n" ,
   "is possible.\n" ,
   "\n" ,
   "If you switch the Talairach view when the current anat dataset does\n" ,
   "not have a +tlrc.BRIK file, then the \"Warp Anat on Demand\" mode will\n" ,
   "be turned on. If you then switch to a dataset that does have a\n" ,
   "+tlrc.BRIK file, \"Warp Anat on Demand\" will still be turned on,\n" ,
   "although the \"View Anat Data Brick\" option will be enabled.\n" ,
   "\n" ,
   "If you set the YES/NO variable AFNI_VIEW_ANAT_BRICK to YES,\n" ,
   "then \"View Anat Data Brick\" will be turned on whenever possible after\n" ,
   "switching datasets. Similarly, setting AFNI_VIEW_FUNC_BRICK to YES\n" ,
   "will engage \"View Func Data Brick\" whenever possible (when the BRIK\n" ,
   "file exists and its grid spacing matches the anatomical grid spacing).\n" ,
   "Note that switching any dataset (func or anat) triggers the same\n" ,
   "routine, and will set either or both \"View Brick\" modes on. When\n" ,
   "these environment variables are present, the only way to switch to\n" ,
   "\"Warp\" mode when \"View Brick\" mode is possible is to do it manually\n" ,
   "(by clicking on the toggle button) when you want this.\n" ,
   "\n" ,
   "When you use one of the drawing plugins (\"Draw Dataset\" or \"Gyrus\n" ,
   "Finder\"), you must operate directly on the dataset BRIK. For this\n" ,
   "reason, it is important to be in \"View Data Brick\" mode on these\n" ,
   "occasions. Setting these variables is one way to ensure that this\n" ,
   "will happen whenever possible.\n" ,
   "\n" ,
   "When AFNI is in \"Warp Anat on Demand\" mode, the word \"{warp}\" will\n" ,
   "appear in the windows' titlebars. This provides a reminder of the\n" ,
   "viewing mode you are using (warped from a brick, or data directly\n" ,
   "extracted from a brick), since the \"Define Datamode\" control panel\n" ,
   "will not always be open.\n" ,
   "\n" ,
   "08 Aug 2003: I have modified the way these variables are treated in\n" ,
   "AFNI so that they now default to the \"YES\" behavior. If you don't\n" ,
   "want this, you have to explicitly set them to \"NO\" from this day forth.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_RECENTER_VIEWING (editable)\n" ,
   "-------------------------------\n" ,
   "If this variable is set to YES, then AFNI's viewers will reset the\n" ,
   "crosshair coordinate to the center of the dataset whenever a new\n" ,
   "dataset or sub-brick is chosen. The only real reason to use this\n" ,
   "feature is if you are scanning through a collection of datasets with\n" ,
   "wildly different coordinates, so that the usual method of matching\n" ,
   "(x,y,z) coordinates at such times gives useless results.\n" ,
   "\n" ,
   "----------------\n" ,
   "Variable: TMPDIR\n" ,
   "----------------\n" ,
   "This variable specifies the directory where temporary files are to be\n" ,
   "written. It is not unique to AFNI, but is used by many Unix programs.\n" ,
   "You must have permission to write into this directory. If you want to\n" ,
   "use the current directory, setting TMPDIR to \".\" would work. If TMPDIR\n" ,
   "is not defined, directory /tmp will be used. On some systems, this\n" ,
   "directory may not have enough space for the creation of large temporary\n" ,
   "datasets. On most Unix systems, you can tell the size of various disk\n" ,
   "partitions using a command like \"df -k\" (on HPUX, \"bdf\" works).\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_GRAYSCALE_BOT\n" ,
   "----------------------------\n" ,
   "This variable sets the darkest level shown in a grayscale image window.\n" ,
   "The default value is 55 (a leftover from Andrzej Jesmanowicz). You can\n" ,
   "set this value to anything from 0 to 254.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_SYSTEM_AFNIRC\n" ,
   "----------------------------\n" ,
   "If this variable is set, it is the name of a file to be read like the\n" ,
   "user's .afnirc file (see README.setup). The purpose is to allow a\n" ,
   "system-wide setup file to be used. To do this, you would create such\n" ,
   "a file in a useful place - perhaps where you store the AFNI binaries.\n" ,
   "Then each user account should have the equivalent of\n" ,
   "\n" ,
   "   setenv AFNI_SYSTEM_AFNIRC /place/where/setup/is/stored/.afnirc\n" ,
   "\n" ,
   "defined in its .cshrc (.bashrc, etc.) file. Note that it doesn't make\n" ,
   "sense to define this variable in the user's .afnirc file, since that\n" ,
   "file won't be read until AFTER this file is read. Also note that use\n" ,
   "of the -skip_afnirc option will cause both the system and user setup\n" ,
   "files to be skipped.\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_PBAR_IMXY (editable)\n" ,
   "------------------------\n" ,
   "This variable determines the size of the image saved when the\n" ,
   "\"Save to PPM\" button is selected for a color pbar. It should be\n" ,
   "in the format\n" ,
   "  setenv AFNI_PBAR_IMXY 20x256\n" ,
   "which means to set the x-size (horizontal) to 20 pixels and the\n" ,
   "y-size (vertical) to 256 pixels. These values are the default,\n" ,
   "by the way.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_LAYOUT_FILE\n" ,
   "--------------------------\n" ,
   "If defined, this variable is the name of a file to read at startup\n" ,
   "to define the \"layout\" of AFNI windows at the program start. If\n" ,
   "this name starts with a '/' character, then it is an absolute path;\n" ,
   "otherwise, it is taken to be a path relative to the user's home\n" ,
   "directory ($HOME). If the AFNI command line switch \"-layout\" is\n" ,
   "used, it will override this specification.\n" ,
   "\n" ,
   "The simplest way to produce a layout file is to use the \"Save Layout\"\n" ,
   "button on the Datamode->Misc menu. You can then edit this file;\n" ,
   "the format should be fairly self-explanatory. The structure of the\n" ,
   "file is similar to the .afnirc file (cf. README.setup). In fact,\n" ,
   "the layout file can be included into .afnirc (since it is just another\n" ,
   "*** section) and then setting AFNI_LAYOUT_FILE = .afnirc in the\n" ,
   "***ENVIRONMENT section should work.\n" ,
   "\n" ,
   "A sample layout file:\n" ,
   "\n" ,
   "***LAYOUT\n" ,
   " A               geom=+73+1106                 // start controller A\n" ,
   " A.sagittalimage geom=320x320+59+159 ifrac=0.8 // and Sagittal image\n" ,
   " A.sagittalgraph geom=570x440+490+147 matrix=9 // and Sagittal graph\n" ,
   " B                                             // start controller B\n" ,
   " B.plugin.ROI_Average                          // start a plugin\n" ,
   "\n" ,
   "Each window to be opened has a separate command line in this file.\n" ,
   "The \"geom=\" qualifiers specify the size and position of the windows.\n" ,
   "For images, \"ifrac=\" can be used to specify the fraction of the window\n" ,
   "occupied by the image (if \"ifrac=1.0\", then no control widgets will be\n" ,
   "visible). For graphs, \"matrix=\" can be used to control the initial\n" ,
   "number of sub-graphs displayed. For plugins, the label on the button\n" ,
   "that starts the plugin is used after the \".plugin.\" string (blanks\n" ,
   "should be filled with underscores \"_\"). In the example above, the last\n" ,
   "two windows to be opened do not have a \"geom=\" qualifier, so their\n" ,
   "placement will be chosen by the window manager.\n" ,
   "\n" ,
   "If you add \"slow\" after the \"***LAYOUT\", then each window operation\n" ,
   "will be paused for 1 second to let you watch the layout operations\n" ,
   "proceed gradually. Otherwise, they will be executed as fast as\n" ,
   "possible (which still may not be all that fast).\n" ,
   "\n" ,
   "Using layouts with a window manager that requires user placement\n" ,
   "of new windows (e.g., twm) is a futile and frustrating exercise.\n" ,
   "\n" ,
   "If you do NOT have any layout file defined, then AFNI will choose\n" ,
   "a layout for you that includes opening image viewers. Some people\n" ,
   "find this very annoying. The simplest way to avoid this annoyance\n" ,
   "is to set AFNI_LAYOUT_FILE to a name of a file that doesn't exist\n" ,
   "(e.g., 'ElvisIsAliveOnPlanetZork'). The reason for this default\n" ,
   "layout behavior (added Dec 2010) is that we received complaints\n" ,
   "that novice users were finding AFNI too confusing on startup.\n" ,
   "(Hard to believe, but true.)\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_tsplotgeom\n" ,
   "-------------------------\n" ,
   "Related to the above, if you set this environment variable (in the\n" ,
   "***ENVIRONMENT section, not in the ***LAYOUT section), it is used\n" ,
   "to set the geometry of the plotting windows used for time series\n" ,
   "plots, histograms, etc. -- all the graphs except the dataset plots.\n" ,
   "Its format should be something like \"550x350\"; this example sets\n" ,
   "the width to 550 pixels and the height to 350 pixels. If you don't\n" ,
   "set this, the default is \"200x200\", which is quite small on a high\n" ,
   "resolution display.\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_FIM_IDEAL\n" ,
   "------------------------\n" ,
   "This variable specifies the filename of the initial FIM ideal timeseries.\n" ,
   "The main use of this would be to be able to initialize the Realtime\n" ,
   "plugin without direct user intervention.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_FIM_SAVEREF\n" ,
   "--------------------------\n" ,
   "When you run the interactive AFNI 'fim' (from the graph viewer FIM menu),\n" ,
   "the program saves the reference time series (and ort time series, if any)\n" ,
   "in the new functional dataset header, with the attribute name\n" ,
   "AFNI_FIM_REF (or AFNI_FIM_ORT). If you do NOT want this information saved,\n" ,
   "then set this variable to NO. Two sample ways to use this information is\n" ,
   "the command below:\n" ,
   "  1dplot \"`3dAttribute -ssep ' ' AFNI_FIM_REF r1_time@1+orig`\"\n" ,
   "  1dcat  \"`3dAttribute -ssep ' ' AFNI_FIM_REF r1_time@1+orig`\" > ref.1D\n" ,
   "The 3 different styles of Unix quotes must be used exactly as shown here!\n" ,
   "\n" ,
   "----------------------------------\n" ,
   "Variable: AFNI_PLUGINS_ALPHABETIZE\n" ,
   "----------------------------------\n" ,
   "If this YES/NO variable is set to NO, then the plugin buttons will\n" ,
   "not be alphabetized on the menu,  and they will appear in the\n" ,
   "order which AFNI chooses. Otherwise, the plugin menu buttons will\n" ,
   "be alphabetized by default. Alphabetizing is done without regard to\n" ,
   "case (using the C library routine strcasecmp).\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_VOLREG_EDGING\n" ,
   "----------------------------\n" ,
   "This variable affects the operation of 3dvolreg, the volume registration\n" ,
   "plugin, and the 3D registration code in the realtime acquisition plugin.\n" ,
   "It determines the size of the region around the edges of the base volume\n" ,
   "where the default weight will be set to zero. Call the value of this\n" ,
   "variable 'ee'. If 'ee' is a plain number (e.g., 5), then it is a voxel\n" ,
   "count, giving the thickness along each face of the 3D brick. If 'ee' is\n" ,
   "of the form '5%', then it is a fraction of of each brick size. For\n" ,
   "example, '5%' of a 256x256x124 volume means that 13 voxels on each side\n" ,
   "of the xy-axes will get zero weight, and 6 along the z-axis. '5%' is\n" ,
   "the default value used by the 3D registration routines (in mri_3dalign.c)\n" ,
   "if no other value is specified.\n" ,
   "\n" ,
   "--------------------\n" ,
   "Variable: AFNI_TRACE\n" ,
   "--------------------\n" ,
   "This variable controls the initial setting of the tracing (debugging)\n" ,
   "code when AFNI programs startup. If it is set to 'y', then tracing\n" ,
   "is turned on and set to the LOW mode (like -trace in AFNI). If it is\n" ,
   "set to 'Y', then tracing is turned on and set to the HIGH mode (like\n" ,
   "-TRACE in AFNI). Anything else, and tracing is turned off.\n" ,
   "\n" ,
   "N.B.: You can't set this variable in .afnirc and expect it to have\n" ,
   "      any effect (and why would you want to?), since it is read from\n" ,
   "      the environment BEFORE the .afnirc file is read in.\n" ,
   "\n" ,
   "N.B.: At this moment (26 Jan 2001), only the AFNI program itself is\n" ,
   "      configured for tracing. As time goes on, the entire AFNI\n" ,
   "      programming library and suite of programs will be revamped for\n" ,
   "      this purpose. The goal is to make it easier to find bugs, and\n" ,
   "      localize crashes.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_TRACE_FILE\n" ,
   "-------------------------\n" ,
   "If this variable is set, then the output from the AFNI function tracing\n" ,
   "macros will be written to a file with that name, rather than to stdout.\n" ,
   "This variable cannot be set in .afnirc; the intention is to provide a\n" ,
   "way to get 'clean' tracing output (not mixed up with other program junk)\n" ,
   "that can be fed to Ziad Saad's AnalyzeTrace function.\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_ROTA_ZPAD\n" ,
   "------------------------\n" ,
   "This variable controls the amount of zero-padding used during 3D rotations\n" ,
   "in 3drotate, 3dvolreg, etc. It provides a default value for the \"-zpad\"\n" ,
   "options of these programs. If zero-padding is used, then this many voxels\n" ,
   "are padded out on each edge (all 6 faces) of a 3D brick before rotation.\n" ,
   "After the rotation, these perimeter values (whatever they might be) will\n" ,
   "be stripped off. If \"-zpad\" is used on the command line, it overrides\n" ,
   "this value. Zero padding during rotation is useful to avoid edge effects,\n" ,
   "the worst of which is the loss of data off the edge of the volume during\n" ,
   "the 4 shearing stages.\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_TO3D_ZPAD\n" ,
   "------------------------\n" ,
   "This variable sets the number of slices added on each z-face in datasets\n" ,
   "created by program to3d. It provides a default value for the \"-zpad\" option\n" ,
   "of that program. It can be set to an integer, meaning a slice count, or\n" ,
   "a number of millimeters, meaning a minimum distance to pad:\n" ,
   "   setenv AFNI_TO3D_ZPAD 2\n" ,
   "   setenv AFNI_TO3D_ZPAD 16mm\n" ,
   "If \"-zpad\" is used on the to3d command line, it overrides this value.\n" ,
   "If neither is present, no zero padding is used. Note well that this\n" ,
   "padding is only in the z-direction, unlike that of AFNI_ROTA_ZPAD.\n" ,
   "\n" ,
   "-----------------------------------------------------------------\n" ,
   "Variables: AFNI_OPEN_AXIAL, AFNI_OPEN_SAGITTAL, AFNI_OPEN_CORONAL\n" ,
   "-----------------------------------------------------------------\n" ,
   "When the AFNI GUI starts, by default it opens all 3 image viewer\n" ,
   "windows. If you do NOT want a particular one of these, set the\n" ,
   "corresponding variable named above to NO. For finer control over\n" ,
   "AFNI startup, see the AFNI_STARTUP_SCRIPT variable and README.driver.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_IMAGE_MINFRAC (editable)\n" ,
   "----------------------------\n" ,
   "This variable sets the minimum size of an image window when it is first\n" ,
   "opened, in terms of a fraction of the overall screen area. By default,\n" ,
   "this value is set to 0.02; you can override this by (for example)\n" ,
   "   setenv AFNI_IMAGE_MINFRAC 0.05\n" ,
   "If you set this value to 0.0, then there will be no minimum. This is\n" ,
   "the old behavior, where the initial window size is always 1 screen pixel\n" ,
   "per data pixel, and can lead to image windows that are hard to resize or\n" ,
   "otherwise use (when the dataset is small). The largest value I recommend\n" ,
   "for AFNI_IMAGE_MINFRAC is 0.1; however, you can set it to as large as 0.9\n" ,
   "if you are completely crazy, but I'm not responsible for the results --\n" ,
   "don't even think of complaining or commenting to me about problems that\n" ,
   "arise if you try this!\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_IMAGE_MAXFRAC\n" ,
   "----------------------------\n" ,
   "This variable sets the maximum size of an image window, as a fraction\n" ,
   "of the width and height of the screen. The default value is 0.9.\n" ,
   "This lets you prevent image windows from auto-resizing to be too big\n" ,
   "when you change datasets. Note that if you have turned on\n" ,
   "AFNI_ENFORCE_ASPECT, then this feature will prevent you from resizing\n" ,
   "a window to be larger than the AFNI_IMAGE_MAXFRAC fraction of the\n" ,
   "screen dimensions.\n" ,
   "\n" ,
   "-----------------------\n" ,
   "Variable: AFNI_AUTOGZIP (cf. AFNI_COMPRESSOR) (editable)\n" ,
   "-----------------------\n" ,
   "If this YES/NO variable is set to YES, then when AFNI programs write a\n" ,
   "dataset .BRIK file to disk, they will test to see if the data is easily\n" ,
   "compressible (at least 80%). If so, then the GZIP compression will be\n" ,
   "used. (For this to work, the gzip program must be in your path.) This\n" ,
   "can be useful if you are dealing with mask datasets, which are usually\n" ,
   "highly compressible, but don't want the overhead of trying to compress\n" ,
   "and decompress arbitrary MRI datasets.\n" ,
   "\n" ,
   "A command line method to carry out compression of datasets that will\n" ,
   "compress well is to use a csh script like the following:\n" ,
   "\n" ,
   "  #!/bin/csh\n" ,
   "  foreach fred ( `find . -name \\*.BRIK -print` )\n" ,
   "    ent16 -%50 < $fred\n" ,
   "    if( $status == 1 ) gzip -1v $fred\n" ,
   "  end\n" ,
   "\n" ,
   "This will only gzip .BRIK files that the program ent16 estimates will\n" ,
   "compress by at least 50%. Note that ent16's estimate of compression\n" ,
   "may be high or low relative to what gzip actually does.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_DONT_MOVE_MENUS (editable)\n" ,
   "------------------------------\n" ,
   "If this YES/NO variable is set to YES, then the functions that try\n" ,
   "to move popup menus to \"good\" locations on screens will be skipped.\n" ,
   "This seems to be necessary on some Solaris systems, where the menus\n" ,
   "can end up being moved to bizarre locations.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_IMAGE_DATASETS\n" ,
   "-----------------------------\n" ,
   "If this YES/NO variable is not set to NO, then 2D image files\n" ,
   "(*.png and *.jpg) will be read as datasets when the interactive\n" ,
   "AFNI program starts. That is, you have to set this variable explicitly\n" ,
   "to NO if you do not want image files read into the AFNI GUI at\n" ,
   "startup. Image files can be opened using the Axial image viewer.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_MINC_DATASETS\n" ,
   "----------------------------\n" ,
   "If this YES/NO variable is not set to NO, then MINC-format files\n" ,
   "with name suffix .mnc will be read into the interactive AFNI\n" ,
   "program at startup, along with standard .HEAD/.BRIK datasets.\n" ,
   "That is, you have to set this variable explicitly to NO if you\n" ,
   "don't want MINC-format files to be automatically recognized by\n" ,
   "the interactive AFNI program. This variable does not affect\n" ,
   "the ability of command line programs (3dSomething) to read\n" ,
   ".mnc input files.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_MINC_FLOATIZE\n" ,
   "----------------------------\n" ,
   "If this YES/NO variable is set to YES, then when MINC-format files\n" ,
   "are read in as datasets, their values will be scaled to floats.\n" ,
   "Otherwise, their values will be scaled to the same data type as\n" ,
   "stored in the file. In some cases, the latter behavior is not\n" ,
   "good; for example, if a byte-valued file (intrinsic range 0..255)\n" ,
   "is scaled to the range 0..0.5 in the MINC header, then after\n" ,
   "conversion back to bytes, the resulting AFNI dataset values will\n" ,
   "all be zero. Setting AFNI_MINC_FLOATIZE to YES will cause the\n" ,
   "scaled values to be stored as floats.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_MINC_SLICESCALE\n" ,
   "------------------------------\n" ,
   "If this YES/NO variable is set to NO, then AFNI will not use the\n" ,
   "image-min and image-max scaling when reading data from MINC files.\n" ,
   "Normally, you want this scaling, since MINC files are scaled separately\n" ,
   "in each slice. However, if the image-min and image-max values in the\n" ,
   "MINC file are damaged, then you can turn off the scaling this way.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_ANALYZE_SCALE\n" ,
   "----------------------------\n" ,
   "If this YES/NO variable is set to NO, then the \"funused1\" entry\n" ,
   "in the Mayo Analyze .hdr file will not be used as a scale factor\n" ,
   "for the images contained in the corresponding .img file. Otherwise,\n" ,
   "if funused1 is positive and not equal to 1.0, all the image data\n" ,
   "in the .img file will be scaled by this value.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_ANALYZE_FLOATIZE\n" ,
   "-------------------------------\n" ,
   "If this YES/NO variable is set to YES, then Mayo Analyze files\n" ,
   "will be scaled to floats on input. Otherwise, they will be read\n" ,
   "in the format in which they are stored in the .img file. Conversion\n" ,
   "to floats can be useful if the scaling factor is such that the image\n" ,
   "native format can't hold the scaled values; for example, if short\n" ,
   "values in the image range from -1000..1000 and the scale factor\n" ,
   "is 0.0001, then the scaled values range from -0.1..0.1, which would\n" ,
   "be truncated to 0 in the scaled image if it is not \"floatized\".\n" ,
   "(Conversion to floats will only be done to byte, short, and int\n" ,
   "image types.)\n" ,
   "\n" ,
   "---------------------------------\n" ,
   "Variable: AFNI_ANALYZE_ORIGINATOR\n" ,
   "---------------------------------\n" ,
   "If this YES/NO variable is set to YES, then AFNI will attempt\n" ,
   "to read and use the ORIGINATOR field in a Mayo Analyze file\n" ,
   "to set the origin of the pixel space in AFNI. This origin\n" ,
   "can be used directly by several programs--the main AFNI viewer,\n" ,
   "and all of the 3dxxxx programs, including especially 3dcopy,\n" ,
   "which is the preferred way to convert an Analyze format file\n" ,
   "to an AFNI native file.\n" ,
   "This variable will also force 3dAFNItoANALYZE to write the\n" ,
   "ORIGINATOR field into the output Analyze file based on the\n" ,
   "input AFNI file's origin information.\n" ,
   "The ORIGINATOR field should be compatible with SPM in most\n" ,
   "cases, but please verify this.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_START_SMALL\n" ,
   "--------------------------\n" ,
   "If this YES/NO variable is set to YES, then when AFNI starts, it will\n" ,
   "look for the smallest dataset in the first session, and choose this\n" ,
   "as its starting point. This can be useful if you also use the layout\n" ,
   "feature to pop open an image window on startup; in that case, if the\n" ,
   "default starting dataset (the first alphabetical) is huge, you won't\n" ,
   "see anything while the program reads all of into memory before displaying\n" ,
   "the first image.\n" ,
   "\n" ,
   "The old behavior of this variable was to set the smallest dataset\n" ,
   "marked as 'Anatomical' to be the underlay, and the smallest dataset\n" ,
   "marked as 'Functional' to be the overlay. The new behavior just\n" ,
   "sets both the underlay and overlay to be the smallest dataset.\n" ,
   "If you want the old behavior, set this variable to the string 'OLD'.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_MENU_COLSIZE\n" ,
   "---------------------------\n" ,
   "This numerical variable sets the maximum number of entries in a popup\n" ,
   "menu column (e.g., like the sub-brick menus for bucket datasets). The\n" ,
   "default value is 20, but you may want to make this larger (say 40). When\n" ,
   "you have a menu with a huge number of entries, the menu can become so\n" ,
   "wide that it doesn't fit on the screen. Letting the columns be longer\n" ,
   "will make the menus be narrower across the screen.\n" ,
   "\n" ,
   "Another way to get a handle on such huge menus is to Button-3 (right)\n" ,
   "click on the label to the left of the menu. This will popup a one-\n" ,
   "column scrollable list chooser that is equivalent to the menu. In\n" ,
   "this way, it is still possible to use menus that have hundreds of\n" ,
   "entries. The maximum number of entries shown at one time in a\n" ,
   "scrollable list chooser is given by variable AFNI_chooser_listmax if\n" ,
   "it exists, otherwise by AFNI_MENU_COLSIZE.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_GLOBAL_SESSION\n" ,
   "-----------------------------\n" ,
   "This variable, if it exists, is the name of a directory that contains\n" ,
   "\"global\" datasets - ones that you want to be visible in each \"Switch\n" ,
   "Underlay\" or \"Switch Overlay\" menu. Pointers to the datasets read\n" ,
   "from this directory will be appended to the dataset list for each\n" ,
   "directory read from the command line. In the \"Switch\" choosers, these\n" ,
   "datasets are marked with the character 'G' at the right, and they\n" ,
   "appear last in the list.\n" ,
   "\n" ,
   "It really only makes sense to put +tlrc (i.e., in a template\n" ,
   "space) datasets in the global session directory, since only they\n" ,
   "can be presumed to be aligned with other datasets. Also, it is probably\n" ,
   "best if you make sure each global anatomical dataset has itself\n" ,
   "as the anatomy parent; this can be enforced by issuing the command\n" ,
   "  3drefit -apar SELF *.HEAD *.nii *.nii.gz\n" ,
   "in the global session directory.\n" ,
   "\n" ,
   "In my [RWC's] global session directory, there is one file:\n" ,
   "  MNI152_2009_template_SSW.nii.gz\n" ,
   "which I copied there from the AFNI binaries download. In this way,\n" ,
   "I always have available the human template which I use most often.\n" ,
   "\n" ,
   "When you Switch Sessions and are viewing a global dataset, it is\n" ,
   "likely that you will NOT be viewing the same dataset after the Switch\n" ,
   "Session. You will have to then Switch Underlay and/or Switch Overlay\n" ,
   "to get back to the same global dataset(s).\n" ,
   "\n" ,
   "If you start AFNI and there are no datasets in the sessions given on\n" ,
   "the command line, then the directory specified by this variable\n" ,
   "becomes the default session. If there are no datasets there, either,\n" ,
   "then AFNI makes up a dummy dataset (AFNI cannot operate without at\n" ,
   "least one dataset present).\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_DISP_SCROLLBARS (editable)\n" ,
   "------------------------------\n" ,
   "If this YES/NO variable is set to YES, then the 'Disp' control window\n" ,
   "(on the image viewers) will have scrollbars attached. This window has\n" ,
   "grown larger over the years, and for some people with pitifully small\n" ,
   "displays (e.g., laptops), it is now taller than their screens. If\n" ,
   "activated, this option will prevent the Disp window from being so tall\n" ,
   "and will attach scrollbars so you can access all of its contents.\n" ,
   "\n" ,
   "Note: If you change this value interactively, via Edit Environment,\n" ,
   "the change will only affect Disp windows opened after you 'Set' the\n" ,
   "variable. That is, already opened Disp windows won't suddenly get\n" ,
   "scrollbars if you change this to YES.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_GRAPH_TEXTLIMIT (editable)\n" ,
   "------------------------------\n" ,
   "This numerical variable sets the upper limit on the number of rows\n" ,
   "shown in the Button-3 popup in a sub-graph. If the number of rows in\n" ,
   "the popup would be more than this value, a text window with scrollbars\n" ,
   "is used instead of a \"spring-loaded\" menu pane. If you set this value\n" ,
   "to 1, then the text window will always be used. Note that a text\n" ,
   "window does not automatically popdown, but must be explicitly\n" ,
   "dismissed by the user pressing the \"Quit\" button.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_GRAPH_BASELINE\n" ,
   "-----------------------------\n" ,
   "This variable should be set to one of the strings \"Individual\", \"Common\",\n" ,
   "or \"Global\", corresponding to the choices on the Opt->Baseline menu in\n" ,
   "a graph window. (Actually, only the first letter of the string will be\n" ,
   "used.)  This variable will determine the initial setting of the Baseline\n" ,
   "menu when a graph window opens.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_GRAPH_GLOBALBASE\n" ,
   "-------------------------------\n" ,
   "Normally, the global baseline for a graph window is set to the\n" ,
   "smallest value found in the entire 3D+time dataset. This variable\n" ,
   "lets you specify a numerical value to be used for this purpose\n" ,
   "instead. Probably the most common setting (for those who want to use\n" ,
   "this feature at all, which means Mike Beauchamp) would be\n" ,
   "  setenv AFNI_GRAPH_GLOBALBASE 0\n" ,
   "Of course, you can always change the global baseline from the\n" ,
   "Opt->Baseline menu.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_GRAPH_CX2R (editable)\n" ,
   "-------------------------\n" ,
   "This variable determines how the AFNI time series graphing window\n" ,
   "displays complex-valued datasets. The possible values are ABS, PHASE,\n" ,
   "REAL, and IMAG. (Actually, only the first letter matters to the\n" ,
   "program.)  The default method is ABS. (If you edit this method\n" ,
   "interactively, the graph won't automatically be redrawn -- you'll have\n" ,
   "to force a graph window redraw to see the effects.)\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_GRAPH_BOXLAB --- THIS VARIABLE HAS BEEN REMOVED [11 Jan 2021]\n" ,
   "---------------------------\n" ,
   "Formerly, this variable determined how the AFNI grapher displays sub-brick\n" ,
   "labels on top of the Box graphs (from the 'Colors, Etc.' menu, or via\n" ,
   "the 'B' keypress).\n" ,
   "Now, the choice of if and where the labels appear is made directly in\n" ,
   "the graph viewer menus.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_GRAPH_FONT\n" ,
   "-------------------------\n" ,
   "This variable is the name of a font to use for text overlays in the\n" ,
   "AFNI time series graph viewers. If this variable is not set, the\n" ,
   "program has a list of fonts to try to load. If none of those can\n" ,
   "be loaded (something I've never seen happen), text may not display.\n" ,
   "For best results, this should be a fixed width font. To see a full\n" ,
   "list of all X11 fonts available, use the system command 'xlsfonts'\n" ,
   "(you probably want to pipe this output through 'more'). The first\n" ,
   "default font is currently [Apr 2011] set to\n" ,
   "  -adobe-courier-bold-r-normal--12-120-75-75-m-70-iso8859-1\n" ,
   "For a font that is larger than the default, try 9x15bold or even\n" ,
   "10x20, as in the command\n" ,
   "  afni -DAFNI_GRAPH_FONT=9x15bold\n" ,
   "The entire list of fonts that will be tried can be found in the\n" ,
   "source code file display.h, in the string array tfont_hopefuls[].\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_GRAPH_FADE\n" ,
   "-------------------------\n" ,
   "If this variable is set to YES, then the 'threshold fade' feature\n" ,
   "of the AFNI graph window is turned on for all graph viewers when\n" ,
   "they open. Otherwise, you have to turn this feature on via the\n" ,
   "'F' key or the toggle control in the Opt menu.\n" ,
   "\n" ,
   "---------------------------------\n" ,
   "Variable: AFNI_GRAPH_ALLOW_SHIFTN\n" ,
   "---------------------------------\n" ,
   "If set to YES, this variable allows the use of the following keystroke\n" ,
   "sequence in the AFNI graph viewer:\n" ,
   "  shift-N\n" ,
   "  digit [digit ...]\n" ,
   "  <Enter>\n" ,
   "The result is to immediately shift the graph matrix count (number of\n" ,
   "sub-graphs) to the decimal integer expressed by the digits. For example:\n" ,
   "  N7<Enter>\n" ,
   "will set the graph window to show a 7x7 matrix of sub-graphs. By default,\n" ,
   "this is disabled, since it confuses some beginners -- until you press\n" ,
   "the <Enter> key, the graph window will be unresponsive to other keys.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_AdptMeanWidth1D\n" ,
   "------------------------------\n" ,
   "This variable lets you add a new Adaptive Mean filter to the 'Tran 1D'\n" ,
   "transformations menu in the AFNI graph viewer. The built in adaptive\n" ,
   "mean filter widths are 9 time points (plus/minus 4 about each value)\n" ,
   "and 19 time points (plus/minus 9). If you define this variable to\n" ,
   "be an odd integer larger than 9, not equal to 19, and less than 100,\n" ,
   "then a new function labeled 'AdptMeanXX' will appear in the 'Tran 1D'\n" ,
   "menu, where 'XX' is the width you choose here. This transformation\n" ,
   "is mainly for 'fun' -- to smooth out a time series to see structure\n" ,
   "obscured by noise. You can combine this function with the |FFT|\n" ,
   "function using the 'Edit 1Dchain' item in the Datamode->Misc menu.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_VALUE_LABEL (editable)\n" ,
   "--------------------------\n" ,
   "If this YES/NO variable is set to YES, then the data value label on\n" ,
   "the Define Overlay control panel will be turned on when only 1 or 2\n" ,
   "image viewer windows are open. This will consume more CPU time and\n" ,
   "redrawing time than the default, which is that this label is only\n" ,
   "turned on when all 3 image viewer windows are open. If you are\n" ,
   "operating X11 remotely over a slow connection, this option should not\n" ,
   "be turned on.\n" ,
   "\n" ,
   "--------------------------------\n" ,
   "Variable: AFNI_SUMA_BOXCOLOR_xxx\n" ,
   "--------------------------------\n" ,
   "This string defines the color used for overlaying surface nodes\n" ,
   "transmitted from SUMA to AFNI. This applies to surface number 'xxx',\n" ,
   "for xxx=001, 002, etc. If this is set to \"none\", then these boxes (at\n" ,
   "each node near a slice) won't be plotted.\n" ,
   "**NOTE** This variable, and the immediately following AFNI_SUMA_something\n" ,
   "         variables, can be set interactively from the 'Control Surface'\n" ,
   "         chooser window in the AFNI GUI.\n" ,
   "**NOTE** The colors allowed for surface display in AFNI are chosen via\n" ,
   "         AFNI's color chooser menu. So no matter what color you specify\n" ,
   "         in one of these AFNI_SUMA_something variables, it will be mapped\n" ,
   "         to be the closest color on the color chooser menu.\n" ,
   "\n" ,
   "---------------------------------\n" ,
   "Variable: AFNI_SUMA_LINECOLOR_xxx\n" ,
   "---------------------------------\n" ,
   "This string defines the color used for overlaying surfaces transmitted\n" ,
   "from SUMA to AFNI. This applies to surface number 'xxx', for xxx=001,\n" ,
   "002, etc. If this is set to \"none\", then these lines (intersections\n" ,
   "of surfaces with slices) won't be plotted.\n" ,
   "\n" ,
   "In the special case that xxx=DEF, then the supplied color becomes\n" ,
   "'default' for all lines. Individual line colors can still be set by\n" ,
   "additional variables with xxx=001, 002, etc. being set.\n" ,
   "\n" ,
   "---------------------------------------\n" ,
   "Variable: AFNI_SUMA_LINECOLOR_FORCE_xxx\n" ,
   "---------------------------------------\n" ,
   "\n" ,
   "This variable is similar to AFNI_SUMA_LINECOLOR_xxx (again, for\n" ,
   "xxx=001 etc.), except for one detail. When SUMA sends a surface to\n" ,
   "AFNI for display, it can also send a color. If that happens, then\n" ,
   "AFNI_SUMA_LINECOLOR_xxx will have no effect. But\n" ,
   "AFNI_SUMA_LINECOLOR_FORCE_xxx will over-ride the choice SUMA makes and\n" ,
   "forces the color for surface number 'xxx' to be this color.\n" ,
   "\n" ,
   "The special usage of xxx=DEF (see AFNI_SUMA_LINECOLOR_xxx) also\n" ,
   "applies here.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_SUMA_BOXSIZE\n" ,
   "---------------------------\n" ,
   "This variable defines the size of the boxes drawn at each surface node\n" ,
   "transmitted from SUMA. The default is 0.25, which means that each box\n" ,
   "is plus and minus 1/4 of a voxel size about the node location. If you\n" ,
   "want a larger box, you could try\n" ,
   "   setenv AFNI_SUMA_BOXSIZE 0.5\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_SUMA_LINESIZE\n" ,
   "----------------------------\n" ,
   "This variable sets the thickness of the lines used when drawing a\n" ,
   "surface intersection overlay. The units are the width of the entire\n" ,
   "image; reasonable values are in the range 0..0.01; 0 means to draw the\n" ,
   "thinnest line possible. Since this is editable, you can experiment\n" ,
   "with it to see what looks good.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_NIML_START\n" ,
   "-------------------------\n" ,
   "If this YES/NO variable is set to YES, then NIML listening will be\n" ,
   "engaged from when AFNI starts. You can also enable NIML from the\n" ,
   "command line with the option \"-niml\", and from the Datamode->Misc menu\n" ,
   "item \"Start NIML\".\n" ,
   "\n" ,
   "NIML is the mechanism by which AFNI talks to other programs - it is\n" ,
   "the successor to plugouts. At this moment (Mar 2002), the only\n" ,
   "external NIML program is SUMA - the surface mapper.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_KEEP_PANNING (editable)\n" ,
   "---------------------------\n" ,
   "If this YES/NO variable is set to YES, then when the Zoom pan gets\n" ,
   "turned on in the AFNI image viewer, it will stay on until it is\n" ,
   "explicitly turned off. (The default behavior is to turn panning off\n" ,
   "after the user releases the mouse button.)\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_IMAGE_LABEL_MODE\n" ,
   "-------------------------------\n" ,
   "This integer determines the placement of the image coordinate labels\n" ,
   "drawn in the AFNI image viewer windows. The possible values are\n" ,
   "   0  =  Labels are off\n" ,
   "   1  =  Labels in upper left\n" ,
   "   2  =  Labels in upper right\n" ,
   "   3  =  Labels in lower left\n" ,
   "   4  =  Labels in lower right\n" ,
   "   5  =  Labels in upper middle\n" ,
   "   6  =  Labels in lower middle\n" ,
   "You can also control the placement and size of the labels from the\n" ,
   "Button-3 (right-click) popup menu attached to the intensity bar to the\n" ,
   "right of the image sub-window.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_IMAGE_LABEL_SIZE\n" ,
   "-------------------------------\n" ,
   "This integer determines the size of the image coordinate labels:\n" ,
   "   0  =  Small\n" ,
   "   1  =  Medium\n" ,
   "   2  =  Large\n" ,
   "   3  =  Huge\n" ,
   "   4  =  Enormous\n" ,
   "\n" ,
   "--------------------------------\n" ,
   "Variable: AFNI_IMAGE_LABEL_COLOR (editable)\n" ,
   "--------------------------------\n" ,
   "This variable controls the color of the image coordinate labels.\n" ,
   "\n" ,
   "----------------------------------\n" ,
   "Variable: AFNI_IMAGE_LABEL_SETBACK (editable)\n" ,
   "----------------------------------\n" ,
   "This variable, a floating point value between 0 and 0.1, determines\n" ,
   "how far from the edge an image coordinate label will be drawn. The\n" ,
   "units are fractions of the image width/height.\n" ,
   "\n" ,
   "---------------------------------\n" ,
   "Variable: AFNI_IMAGE_LABEL_STRING (editable)\n" ,
   "---------------------------------\n" ,
   "This value of this variable is a string that is appended to the\n" ,
   "automatically generated image slice viewer overlay label -- the\n" ,
   "viewing of this label is controlled from the right-click popup menu\n" ,
   "attached to the intensity bar to the right of the image itself. This\n" ,
   "variable applies to any slice image viewer window into which the user\n" ,
   "has not specifically set a string for this purpose from the GUI menu\n" ,
   "item 'Label Append String'.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_IMAGE_LABEL_IJK (editable)\n" ,
   "------------------------------\n" ,
   "If this variable is YES, then the image label will be based on the\n" ,
   "slice index rather than the spatial (mm) coordinate. This variable can\n" ,
   "be set in the EditEnv AFNI GUI plugin (that is what 'editable' means).\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_CROSSHAIR_LINES (editable) -- THIS VARIABLE IS NOW UNUSED\n" ,
   "------------------------------\n" ,
   "If this YES/NO variable is set to YES, then the image crosshairs will\n" ,
   "be drawn using lines rather than pixels. By default (this is the\n" ,
   "original AFNI way), crosshair lines are drawn the same way as\n" ,
   "functional overlays: by putting color pixels on top of the image. The\n" ,
   "new way draws lines on top of the image instead. The difference is\n" ,
   "quite visible when the image is zoomed; overlay by pixels shows the\n" ,
   "crosshair lines as fat blobs, but the lines are drawn as thin as\n" ,
   "possible, no matter what the image window size and zoom factor.\n" ,
   "\n" ,
   "Good points about crosshairs drawn with lines:\n" ,
   " - They are less obtrusive than pixel overlay, especially if you zoom\n" ,
   "     or enlarge the image a lot\n" ,
   " - When doing a montage with Spacing=1, they'll look better in the\n" ,
   "     orthogonal slices.\n" ,
   "Good points about crosshairs drawn with pixel overlay:\n" ,
   " - Pixel overlays can be rendered as translucent (on X11 TrueColor\n" ,
   "     displays); geometrical overlays are always solid color.\n" ,
   "\n" ,
   "So you have to decide what you need most. You can change this item\n" ,
   "using the \"Edit Environment\" pseudo-plugin on the Datamode->Misc menu,\n" ,
   "so you can play with it interactively to get the features you want.\n" ,
   "\n" ,
   "----------------------------------\n" ,
   "Variable: AFNI_CROSSHAIR_THICKNESS\n" ,
   "----------------------------------\n" ,
   "This numeric variable lets you set the thickness of the lines used to\n" ,
   "draw the image viewer crosshairs. The default value is 0, which means\n" ,
   "thin lines. The units are fractions of the image size, and the legal\n" ,
   "range is 0 .. 0.05 (which will be very thick lines, I assure you).\n" ,
   "This variable was introduced in March 2015 for Corianne (if there is\n" ,
   "such a person).\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_CROSSHAIRS_OFF\n" ,
   "-----------------------------\n" ,
   "Set this variable to YES to turn off crosshairs for AFNI startup.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_CROP_ZOOMSAVE (editable)\n" ,
   "----------------------------\n" ,
   "When saving a zoomed image, the default is to save the entire zoomed\n" ,
   "image, not just the part you see. If this YES/NO variable is set to\n" ,
   "YES, then only the visible part will be saved.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_CROP_AUTOCENTER\n" ,
   "------------------------------\n" ,
   "If this variable is set to YES, then the image viewer windows will\n" ,
   "automatically re-center the cropping sub-window (if cropping is\n" ,
   "active) around the crosshair position -- as far as possible. You can\n" ,
   "also set this crop autocenter capability individually for each image\n" ,
   "viewer window from the intensity bar right-click popup menu.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variables: AFNI_TLRC_BBOX_*\n" ,
   "---------------------------\n" ,
   "These variables let you choose the size of the \"Talairach Box\", into\n" ,
   "which +tlrc datasets are transformed. If defined, they should be\n" ,
   "positive values, in mm. The 5 variables (any or all of which may be\n" ,
   "used) are:\n" ,
   "\n" ,
   "  AFNI_TLRC_BBOX_LAT = distance from midline to maximum left/right\n" ,
   "                        position [default=80]\n" ,
   "  AFNI_TLRC_BBOX_ANT = distance from AC to most anterior point in box\n" ,
   "                        [default=80]\n" ,
   "  AFNI_TLRC_BBOX_POS = distance from AC to most posterior point in box\n" ,
   "                        [default=110]\n" ,
   "  AFNI_TLRC_BBOX_INF = distance from AC-PC line to most inferior point\n" ,
   "                        in box [default=55 for small box, 65 for big\n" ,
   "                        box]\n" ,
   "  AFNI_TLRC_BBOX_SUP = distance from AC-PC line to most superior point\n" ,
   "                        in box [default=85]\n" ,
   "\n" ,
   "For example, \"setenv AFNI_TLRC_BBOX_INF 100\" lets you define the +tlrc\n" ,
   "box to extend 100 mm below the AC-PC line. Please note that virtually\n" ,
   "all the 3d* analysis programs (3dANOVA, etc.) do voxel-by-voxel\n" ,
   "analyses. This fact means that you will be unable to compare datasets\n" ,
   "created in +tlrc coordinates with different box sizes. Also, you will\n" ,
   "be unable to overlay regions from the Talairach Daemon database onto\n" ,
   "odd-sized +tlrc datasets. Therefore, I recommend that these variables\n" ,
   "be used only when strictly needed, and with caution.\n" ,
   "\n" ,
   "Lastly, try hard not to mix TLRC datasets created with various box\n" ,
   "sizes in the same session. Strange things may happen.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variables: AFNI_ACPC_BBOX_*\n" ,
   "---------------------------\n" ,
   "The variables let you choose the size of the \"ACPC Box\", into which\n" ,
   "+acpc datasets are transformed. If defined, they should be positive\n" ,
   "values, in mm. The 6 variables (any or all of which may be used) are:\n" ,
   "\n" ,
   "  AFNI_ACPC_BBOX_LAT = distance from midline to maximum left/right\n" ,
   "                        position [default=95]\n" ,
   "  AFNI_ACPC_BBOX_ANT = distance from AC to most anterior point in box\n" ,
   "                        [default=95]\n" ,
   "  AFNI_ACPC_BBOX_POS = distance from AC to most posterior point in box\n" ,
   "                        [default=140]\n" ,
   "  AFNI_ACPC_BBOX_INF = distance from AC-PC line to most inferior point\n" ,
   "                        in box [default=70]\n" ,
   "  AFNI_ACPC_BBOX_SUP = distance from AC-PC line to most superior point\n" ,
   "                        in box [default=100]\n" ,
   "\n" ,
   "Check example and heed ALL warnings for variables AFNI_TLRC_BBOX_*\n" ,
   "above.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_TTRR_SETUP\n" ,
   "-------------------------\n" ,
   "Name of a file to be loaded to define Talairach Atlas Colors, when the\n" ,
   "Atlas Colors control panel is first created. Format is the same as a\n" ,
   "file created from this control panel's \"Save\" button. This filename\n" ,
   "should be an absolute path (e.g., /home/yourname/.afni_ttcolors),\n" ,
   "since otherwise it will be read relative to the directory in which you\n" ,
   "start AFNI.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_LOAD_PRINTSIZE\n" ,
   "-----------------------------\n" ,
   "AFNI will print (to stderr) a warning that it is loading a large\n" ,
   "dataset from disk. This value determines the meaning of \"large\". For\n" ,
   "example, setting this variable to \"40M\" means that loading a dataset\n" ,
   "larger than 40 Megabytes will trigger the warning. If not given, the\n" ,
   "default value is 100 Megabytes. The purpose of the warning is just to\n" ,
   "let the user know that it may be several seconds before the dataset is\n" ,
   "loaded (e.g., before the images appear). If you don't want this\n" ,
   "warning at all, set this variable to the string \"0\".\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_ANALYZE_DATASETS\n" ,
   "-------------------------------\n" ,
   "If this YES/NO variable is not set to NO, then ANALYZE-format files\n" ,
   "with name suffix .hdr will be read into the interactive AFNI program\n" ,
   "at startup, along with standard .HEAD/.BRIK datasets. That is, you\n" ,
   "have to set this variable explicitly to NO if you don't want\n" ,
   "ANALYZE-format files to be automatically recognized by the interactive\n" ,
   "AFNI program. This variable does not affect the ability of command\n" ,
   "line programs (3dSomething) to read .hdr input files.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_ANALYZE_ORIENT\n" ,
   "-----------------------------\n" ,
   "ANALYZE .hdr files do not contain reliable information about the\n" ,
   "orientation of the data volumes. By default, AFNI assumes that these\n" ,
   "datasets are oriented in LPI order. You can set this variable to a\n" ,
   "different default order. See AFNI_ORIENT for details on the 3 letter\n" ,
   "format for this.\n" ,
   "\n" ,
   "---------------------------------\n" ,
   "Variable: AFNI_ANALYZE_AUTOCENTER\n" ,
   "---------------------------------\n" ,
   "ANALYZE .hdr files do not contain information about the origin of\n" ,
   "coordinates. The default AFNI approach mirrors that of FSL - the\n" ,
   "outermost corner of the first voxel in the dataset is set to (0,0,0).\n" ,
   "If you set this variable (AFNI_ANALYZE_AUTOCENTER) to YES, then\n" ,
   "instead (0,0,0) will be set to the center of the 3D ANALYZE array.\n" ,
   "This is the default that would be applied if you read the ANALYZE\n" ,
   "array into program to3d.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_VERSION_CHECK\n" ,
   "----------------------------\n" ,
   "If this YES/NO variable is set to NO, then AFNI will not try to check\n" ,
   "if its version is up-to-date when it starts. Otherwise, it will try\n" ,
   "to check the program version with the AFNI web server.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_MOTD_CHECK\n" ,
   "-------------------------\n" ,
   "Similarly, if this YES/NO variable is set to NO, then AFNI will not\n" ,
   "display and fetch the AFNI \"Message of the Day\" at startup. You can\n" ,
   "always check the MOTD by using the Datamode->Misc menu.\n" ,
   "\n" ,
   "-----------------------------------\n" ,
   "Variable: AFNI_SLICE_SPACING_IS_GAP\n" ,
   "-----------------------------------\n" ,
   "This YES/NO variable is designed to patch a flaw in some DICOM files,\n" ,
   "where the \"Spacing Between Slices\" attribute is erroneously set to the\n" ,
   "gap between the slices, rather than the center-to-center slice\n" ,
   "distance specified in the DICOM standard. If this variable is set to\n" ,
   "YES, then the \"Slice Thickness\" attribute will always be added to\n" ,
   "\"Spacing Between Slices\" to get the z voxel size (assuming both\n" ,
   "attributes are present in the DICOM file).\n" ,
   "\n" ,
   "To check if a DICOM file has this problem, you can read it into to3d\n" ,
   "with the command \"to3d suspect_file_name\". A warning will be printed\n" ,
   "to the terminal window if attribute \"Spacing Between Slices\" is less\n" ,
   "than attribute \"Slice Thickness\". Another way to check is with a\n" ,
   "command like so\n" ,
   "\n" ,
   "  dicom_hdr suspect_file_name | grep \"Slice\"\n" ,
   "\n" ,
   "then check if the \"Spacing Between Slices\" and \"Slice Thickness\"\n" ,
   "values are correct for the given acquisition. We have only seen this\n" ,
   "problem in GE generated DICOM files, but that doesn't mean it won't\n" ,
   "occur elsewhere.\n" ,
   "\n" ,
   "If this variable is set to NO, then this patchup will never be made.\n" ,
   "The z voxel size will be set to \"Spacing Between Slices\" if present,\n" ,
   "otherwise to \"Slice Thickness\". This may be needed for some Phillips\n" ,
   "pulse sequences, which can report \"Spacing Between Slices\" < \"Slice\n" ,
   "Thickness\". In such a case, if this variable is not set, the wrong z\n" ,
   "voxel size will be assigned!\n" ,
   "\n" ,
   "If this variable is not set at all, AND if \"Spacing Between Slices\" is\n" ,
   "less less than 0.99 times \"Slice Thickness\", it will be treated as a\n" ,
   "gap; that is, the z voxel size will again be set to \"Spacing Between\n" ,
   "Slices\" + \"Slice Thickness\" if \"Spacing Between Slices\" < 0.99*\"Slice\n" ,
   "Thickness\". Otherwise, the z voxel size will be set to the larger of\n" ,
   "\"Spacing Between Slices\" and \"Slice Thickness\".\n" ,
   "\n" ,
   "N.B.: \"YES\", \"NO\", and \"not set\" have 3 different sets of behavior!\n" ,
   "      In the summary below, if a variable isn't set, treat it as zero:\n" ,
   "\n" ,
   "  YES     => dz = Thickness + Spacing\n" ,
   "  NO      => dz = Spacing if present, otherwise Thickness\n" ,
   "  not set => if( Spacing > 0 && Spacing < 0.99*Thickness )\n" ,
   "               dz = Thickness + Spacing\n" ,
   "             else\n" ,
   "               dz = MAX( Thickness , Spacing )\n" ,
   "\n" ,
   "If neither variable is set, then dz=1 mm, which is probably wrong.\n" ,
   "\n" ,
   "Sorry about this complexity, but the situation with various\n" ,
   "manufacturers is complicated, murky, and confusingly maddening.\n" ,
   "\n" ,
   "---------------------------------------------------\n" ,
   "Variables: AFNI_DICOM_RESCALE and AFNI_DICOM_WINDOW\n" ,
   "---------------------------------------------------\n" ,
   "DICOM image files can contain rescaling and windowing \"tags\". If\n" ,
   "present, these values indicate to affinely modify the values stored in\n" ,
   "the file. As far as I can tell, \"rescale\" means that the values\n" ,
   "should always be modified, whereas \"window\" means the values should be\n" ,
   "modified for display purposes. If both are present, the rescale comes\n" ,
   "before window. These two YES/NO environment variables control whether\n" ,
   "the AFNI image input functions (used in to3d) should apply the rescale\n" ,
   "and window tags.\n" ,
   "\n" ,
   "It is my impression from the laconic, terse, and opaque DICOM manual\n" ,
   "that window tags are intended for display purposes only, and that they\n" ,
   "aren't needed for signal processing. But you'll have to examine your\n" ,
   "own data to decide whether to use these options -- manufacturers seem\n" ,
   "to differ. Plus, I don't have that much experience with DICOM data\n" ,
   "from many different sources.\n" ,
   "\n" ,
   "---------------------------------------------------\n" ,
   "Variable: AFNI_DICOM_VERBOSE\n" ,
   "---------------------------------------------------\n" ,
   "Set this YES/NO variable to YES to output extra details when reading\n" ,
   "DICOM images.\n" ,
   "\n" ,
   "---------------------------------------------------\n" ,
   "Variable: AFNI_DICOM_USE_LAST_ELEMENT\n" ,
   "---------------------------------------------------\n" ,
   "Set this YES/NO variable to YES to force the DICOM reading routines to\n" ,
   "set each DICOM element based on the last occurrence, not necessarily\n" ,
   "the first.\n" ,
   "\n" ,
   "-----------------------\n" ,
   "Variable: IDCODE_PREFIX\n" ,
   "-----------------------\n" ,
   "AFNI stores with each dataset a unique string, called an \"idcode\". An\n" ,
   "example is \"XYZ_MoNLqdNOwMNEYmKSBytfJg\". You can alter the first\n" ,
   "three characters of the idcode with this variable. For example,\n" ,
   "  setenv IDCODE_PREFIX RWC\n" ,
   "sets the first 3 characters of newly generated idcodes to be the\n" ,
   "initials of AFNI's author. I find this a handy way to \"brand\" my\n" ,
   "datasets. Of course, there are only 17576 possible 3 letter\n" ,
   "combinations (140608 if you allow for case), so you should claim your\n" ,
   "prefix soon!!!\n" ,
   "\n" ,
   "Idcodes are used to store links between datasets. For example, when\n" ,
   "SUMA sends a surface to AFNI, it identifies the dataset to which the\n" ,
   "surface is to be associated with the dataset's idcode. Similarly,\n" ,
   "when AFNI sends a color overlay to SUMA, it uses the surface idcode to\n" ,
   "indicate which surface family the overlay is to be mapped onto.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_AGIF_DELAY\n" ,
   "-------------------------\n" ,
   "This is the time delay between frames when writing an animated GIF\n" ,
   "file from an image viewer window. The units are 100ths of seconds\n" ,
   "(centi-seconds!); the default value is 20 (= 5 frames per second).\n" ,
   "Note that this value is NOT editable in the Edit Environment control\n" ,
   "panel, so you have to set it up prior to starting AFNI (e.g., by using\n" ,
   "an option like '-DAFNI_AGIF_DELAY=10' on the command line when\n" ,
   "starting AFNI).\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_MPEG_FRAMERATE\n" ,
   "-----------------------------\n" ,
   "This value sets the frame rate (per second) of the MPEG-1 output\n" ,
   "animation from the image viewer window. The legal values allowed by\n" ,
   "MPEG-1 are 24, 25, 30, 50, and 60; 24 (the slowest) is the default.\n" ,
   "Note that the MPEG-1 standard does NOT allow arbitrary framerates,\n" ,
   "only these listed. To further slow down an MPEG-1 animation in AFNI,\n" ,
   "use the AFNI_ANIM_DUP variable, described below.\n" ,
   "\n" ,
   "-----------------------\n" ,
   "Variable: AFNI_ANIM_DUP (editable)\n" ,
   "-----------------------\n" ,
   "This value sets the frame duplication factor for AGIF or MPEG\n" ,
   "animation output. If this value 'd' is between 1 and 99, then each\n" ,
   "frame (image) will be written out 'd' times before being incorporated\n" ,
   "into the movie file. Note that AFNI_AGIF_DELAY can be used to slow\n" ,
   "down an AGIF file more efficiently, but that there is no other way\n" ,
   "(within AFNI) to slow down an MPEG file. (Some MPEG movie players\n" ,
   "will let you slow down the animation, but that's outside of AFNI's\n" ,
   "control.)\n" ,
   "\n" ,
   "You can control this variable directly from the Edit Environment\n" ,
   "control panel, or set its internal value in AFNI (or other image\n" ,
   "viewers) from the right-click popup menu attached to the intensity\n" ,
   "grayscale bar just to the right of the image sub-window in the viewer.\n" ,
   "Note that the duplication factor must be greater than 1 for any\n" ,
   "slowdown to occur. For example, if you want 6 frames per second in an\n" ,
   "MPEG file, then a duplication factor of 4 would work (24 fps / 4 = 6\n" ,
   "fps).\n" ,
   "\n" ,
   "For MPEG-1 files, AFNI will set up the frame temporal encoding pattern\n" ,
   "so that there is very little .mpg file size overhead for this frame\n" ,
   "duplication. The same is NOT true for animated GIF files, since these\n" ,
   "files do not have any compression along the time axis. Therefore, you\n" ,
   "should use AFNI_AGIF_DELAY to control the frame rate of animated GIF\n" ,
   "files, and not this frame duplication factor.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_STARTUP_SOUND\n" ,
   "----------------------------\n" ,
   "If this variable is set to YES, then when the AFNI GUI starts, a\n" ,
   "pair of notes will be played (softly). For this to happen, it is\n" ,
   "also necessary that\n" ,
   " a) the 'sox' sound software package be installed\n" ,
   " b) that the X11 display is local, not remote\n" ,
   " c) that no '-com' options are on the command line\n" ,
   "You can also try using the 'Play startup sound' button on the\n" ,
   "right-click popup menu attached to the logo space to the right\n" ,
   "of the GUI 'done' button. For that button to work, conditions\n" ,
   "a) and b) above must be true. On a Mac, you can install 'sox'\n" ,
   "using the 'brew' package (e.g.).\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_SOUND_PLAYER\n" ,
   "---------------------------\n" ,
   "The 'p' and 'P' keys in the AFNI graph viewer can be used to generate\n" ,
   "sound from the graph data time series. However, AFNI itself does not\n" ,
   "play sound - it uses an external player program. By default, AFNI can\n" ,
   "use any one of these programs:\n" ,
   "  play (part of sox) ; afplay (Mac) ; mplayer ; aplay (Linux)\n" ,
   "and it will search your path to find one of these (in that order).\n" ,
   "If you have some other player program you want to use, you can provide\n" ,
   "the full path to that program in this variable, as in '/usr/bin/afplay'.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_MUSIC_SIZE\n" ,
   "-------------------------\n" ,
   "This variable is the length of the random music sequence generated by\n" ,
   "the 'Play random music' button. The default value is 99; if you want\n" ,
   "it to be longer, increase this value. There are about 7 notes per\n" ,
   "seconds normally, so setting this value to 420 is about 1 minute.\n" ,
   "Music can only be played if a sound player program is installed on\n" ,
   "your computer, as described under AFNI_SOUND_PLAYER above.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_STARTUP_SCRIPT\n" ,
   "-----------------------------\n" ,
   "If this is set, this is the name of an AFNI Script to run when AFNI\n" ,
   "first starts. (See the file README.driver for information about AFNI\n" ,
   "Scripts.)  If this is not set, it defaults to \".afni.startup_script\".\n" ,
   "The program first tries to read this filename from the current working\n" ,
   "directory; if that fails, then it tries to read from your home\n" ,
   "directory. No error message is given if neither file can be read.\n" ,
   "\n" ,
   "You can save a file \".afni.startup_script\" that will recreate the\n" ,
   "window layout you currently have. Use the \"Datamode->Misc->Save\n" ,
   "Layout\" button and press \"Set\" on the popup control without entering\n" ,
   "any filename. Instead of a Layout file (cf. AFNI_LAYOUT_FILE above),\n" ,
   "you'll get a Script file if you leave the filename blank or enter any\n" ,
   "filename with the string \"script\" included (e.g., \"coolstuff.script\").\n" ,
   "\n" ,
   "The capabilities of Script files are expanded from time to time. Not\n" ,
   "all features of the AFNI window setup are currently save-able this\n" ,
   "way.\n" ,
   "\n" ,
   "You can load a Script file interactively during an AFNI run by using\n" ,
   "the button \"Datamode->Misc->Run Script\". As a 'secret' option, if you\n" ,
   "enter a line containing a blank in the filename dialog, that line\n" ,
   "will be executed as a single command, rather than be used as a script\n" ,
   "filename.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_DEFAULT_OPACITY\n" ,
   "------------------------------\n" ,
   "This should be set to an integer from 1..9, and controls the default\n" ,
   "opacity setting for the color overlay in image viewer windows.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_DEFAULT_IMSAVE\n" ,
   "-----------------------------\n" ,
   "This should be set to the suffix of the image format to which you want\n" ,
   "to save from an image viewer. The suffixes AFNI knows about (as of 23\n" ,
   "Jan 2003) are\n" ,
   " ppm = Portable PixMap format                            = cat\n" ,
   " jpg = Joint Photographics Experts Group (JPEG) format   = cjpeg\n" ,
   " gif = Compuserve Graphics Interchange File (GIF) format = ppmtogif\n" ,
   " tif = Tagged Image File Format (TIFF)                   = ppm2tiff\n" ,
   "                                                           or pnmtotiff\n" ,
   " bmp = Windows Bitmap (BMP) format                       = ppmtobmp\n" ,
   " eps = Encapsulated PostScript format                    = pnmtops\n" ,
   " pdf = Portable Document Format                          = epstopdf\n" ,
   " png = Portable Network Graphics format                  = pnmtopng\n" ,
   "The third column is the name of the external filter program that AFNI\n" ,
   "uses to write the format. If a filter is not present on your system,\n" ,
   "then that option is not available. Most of these filters are part of\n" ,
   "the netpbm package, which can be installed on MacOS X by using the\n" ,
   "brew package (for example).\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_IMSAVE_WARNINGS\n" ,
   "------------------------------\n" ,
   "If this variable is not set, then if the program cannot find one\n" ,
   "of the output filter programs listed above, then a warning message\n" ,
   "will be printed to the terminal. However, if you set this variable\n" ,
   "to NO, then such warning messages will NOT be printed out. The\n" ,
   "purpose of this variable is to let you silence these messages\n" ,
   "once you get sick of seeing them.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_IMSAVE_DEBUG\n" ,
   "---------------------------\n" ,
   "If this variable is set to YES, then when you save an image from the\n" ,
   "image viewer, the various steps will be printed to the terminal\n" ,
   "as the process happens. As the variable name is implied, this\n" ,
   "capability is here for debugging, and has not actually been used\n" ,
   "for years (at least by the AFNI Imperial Command Team).\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variables: AFNI_COLORSCALE_xx  for xx=01, 02, ..., 99\n" ,
   "-----------------------------\n" ,
   "These variables let you name files to be read it at AFNI startup to\n" ,
   "define \"continuous\" colorscales for the \"**\" mode of the color pbar.\n" ,
   "These files will be looked for in the current directory when you start\n" ,
   "AFNI, or in your home directory (if they aren't in the current\n" ,
   "directory). A sample file:\n" ,
   "\n" ,
   "  Yellow-Red-Blue\n" ,
   "  1.0 #ffff00\n" ,
   "  0.7 #ffaa00\n" ,
   "  0.5 #ff0000\n" ,
   "  0.3 #aa00aa\n" ,
   "  0.0 #0000ff\n" ,
   "\n" ,
   "The first line is the name of this colorscale, to go in the colorscale\n" ,
   "popup chooser. The succeeding lines each have a number and a color\n" ,
   "definition. The numbers should be decreasing, and indicate the\n" ,
   "location on the colorscale. The largest number corresponds to the top\n" ,
   "of the colorscale and the smallest to the bottom - intermediate\n" ,
   "numbers denote intermediate locations. The colors at each location\n" ,
   "are specified using X11 notation (cf. \"man XParseColor\"). In this\n" ,
   "example, I'm using hexadecimal colors, in the form #rrggbb, where each\n" ,
   "hex pair ranges from 00 to ff. Another color format is\n" ,
   "\"rgbi:rf/gf/bf\", where each value rf,gf,bf is a number between 0.0 and\n" ,
   "1.0 (inclusive); for example, yellow would be \"rgbi:1.0/1.0/0.0\".\n" ,
   "\n" ,
   "Colors are interpolated (linearly in RGB space) between the break\n" ,
   "locations given in the file. There are actually 128 color locations\n" ,
   "on a colorscale.\n" ,
   "\n" ,
   "An alternative format for the file is to omit the numbers indicating\n" ,
   "the break locations. In this case, the break locations will be taken\n" ,
   "to be equally spaced. For example:\n" ,
   "\n" ,
   "  Yellow-Red-Blue\n" ,
   "   #ffff00\n" ,
   "   #ffaa00\n" ,
   "   #ff0000\n" ,
   "   #aa00aa\n" ,
   "   #0000ff\n" ,
   "\n" ,
   "This example is not exactly the same as the other one, since the\n" ,
   "breakpoints are evenly spaced now (as if they had been given as 1.0,\n" ,
   "0.75, 0.5, 0.25, and 0.0). With this format, if you want to manually\n" ,
   "specify all 128 colors, you can do so, 1 color per line, remembering\n" ,
   "that the first line of the file is taken to be the colorscale title\n" ,
   "(no blanks allowed in the title!).\n" ,
   "\n" ,
   "---------------------------------\n" ,
   "Variable: AFNI_COLORSCALE_DEFAULT\n" ,
   "---------------------------------\n" ,
   "If set, this is the name of the default colorscale to use in setup.\n" ,
   "As a special case, if you DO NOT want a colorscale to be setup by\n" ,
   "default at all, then set this variable to the string \"NO\".\n" ,
   "\n" ,
   "N.B.: This variable only applies if you are using AFNI with a\n" ,
   "TrueColor X11 visual. If you are using a PseudoColor visual, then\n" ,
   "this variable is ignored!\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_RESCAN_METHOD\n" ,
   "----------------------------\n" ,
   "On 28 Dec 2002, I modified the way that the \"Rescan\" operation in AFNI\n" ,
   "works when re-reading datasets from sessions. The old way would purge\n" ,
   "and replace all datasets; the new way just adds datasets that didn't\n" ,
   "exist before. There are some differences between these methods:\n" ,
   "  \"Replace\" will detect changes to a dataset, so if you add a brick\n" ,
   "    using 3dTcat -glueto (for example), this will be reflected in\n" ,
   "    AFNI.\n" ,
   "  \"Replace\" will cause troubles if you are using a dataset in a\n" ,
   "    plugin; the two main examples are volume rendering and the drawing\n" ,
   "    plugin. This problem will occur even if you didn't do anything to\n" ,
   "    the dataset on disk, since the internal pointer to the dataset\n" ,
   "    will have been changed by the rescan, but the plugins won't know\n" ,
   "    that.\n" ,
   "  \"Add\" will not detect changes to a dataset on disk, but it also\n" ,
   "    won't affect the pointers to the existing datasets.\n" ,
   "You can choose to use the \"Replace\" method (the old style) by setting\n" ,
   "this environment variable to the string \"REPLACE\".\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_OLD_PPMTOBMP\n" ,
   "---------------------------\n" ,
   "The old (before 21 Feb 2003) usage of netpbm program \"ppmtobmp\" was to\n" ,
   "write a color image quantized to 255 colors. The new usage is to\n" ,
   "write a 24-bit image, which is thus not color-quantized. If you want\n" ,
   "the old behavior, set this environment variable to YES. This setting\n" ,
   "(YES) will be necessary if you have an older version of ppmtobmp in\n" ,
   "your path, which doesn't support the \"-bpp\" option.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_1DPLOT_COLOR_xx\n" ,
   "------------------------------\n" ,
   "This variable lets you set the colors used in the 1dplot program (and\n" ,
   "other similar graphs). Here, \"xx\" is a number from \"01\" to \"19\". The\n" ,
   "value of the environment variable must be in the form \"rgbi:rf/gf/bf\",\n" ,
   "where each color intensity (rf, gf, bf) is a number between 0.0 and\n" ,
   "1.0. For example, \"rgbi:1.0/1.0/0.0\" is yellow. By default, the\n" ,
   "first 4 colors are defined as the equivalents of\n" ,
   "  setenv AFNI_1DPLOT_COLOR_01 rgbi:0.0/0.0/0.0\n" ,
   "  setenv AFNI_1DPLOT_COLOR_02 rgbi:0.9/0.0/0.0\n" ,
   "  setenv AFNI_1DPLOT_COLOR_03 rgbi:0.0/0.7/0.0\n" ,
   "  setenv AFNI_1DPLOT_COLOR_04 rgbi:0.0/0.0/0.9\n" ,
   "which are black, red, green, and blue, respectively. You can alter\n" ,
   "these colors, or leave them unchanged and start defining colors at 05.\n" ,
   "The largest color number you define will be the last color index used;\n" ,
   "if more line colors are needed, they will cycle back to color 01. If\n" ,
   "you leave a gap in the numbering (e.g., you define color 07 but not 05\n" ,
   "or 06), then the undefined colors will be fuliginous.\n" ,
   "\n" ,
   "[Dec 2007] You can now specify the colors by using the special names\n" ,
   "'green', 'red', 'blue', 'gold', 'pink', and 'purple'. Also, by using\n" ,
   "3 or 6 digit hexadecimal notation as in '#8888aa' for a blueish-gray\n" ,
   "color (6 digits) or '#0ac' for a cyanish color (3 digits). These are\n" ,
   "intended to make life a little simpler.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_1DPLOT_THIK (editable)\n" ,
   "--------------------------\n" ,
   "This numeric variable lets you control the thickness of lines drawn in\n" ,
   "the 1dplot-style windows. The units are in terms of the width of the\n" ,
   "entire plot, so that a value of 0.005 is 'reasonable'; 0.01 will be\n" ,
   "fairly thick lines, and 0.02 will be too thick for most purposes.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_1DPLOT_IMSIZE\n" ,
   "----------------------------\n" ,
   "This numeric variable sets the image size (in pixels across the\n" ,
   "screen) of images saved via the '-png' or '-jpg' options of 1dplot, or\n" ,
   "images saved when giving the '.png' or '.jpg' from 1dplot-style\n" ,
   "graphs. The default value is 1024. Values over 2048 may give odd\n" ,
   "looking results, and will be palpably slower to render.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_1DPLOT_BOXSIZE\n" ,
   "-----------------------------\n" ,
   "This variable sets the size of the boxes that are plotted with the\n" ,
   "1dplot '-box' option. The units are in terms of the width of the\n" ,
   "entire plot; a value of 0.006 is the default. The largest allowed\n" ,
   "value is 0.02 and the smallest is 0.001.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_1DPLOT_RENDEROLD\n" ,
   "-------------------------------\n" ,
   "On 30 Apr 2012, a new method of rendering the 1dplot graph into an X11\n" ,
   "window was introduced -- this method uses 'anti-aliasing' to produce\n" ,
   "smoother lines and characters. If you want the old coarser-looking\n" ,
   "rendering method, set this variable to YES.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_1DPLOT_RANBOX\n" ,
   "----------------------------\n" ,
   "When using '-noline' in 1dplot (to get a cloud of points without\n" ,
   "lines), and when there are multiple time series being plotted with\n" ,
   "option '-one', the normal state of affairs is that later time series\n" ,
   "boxes get plotted on top of earlier boxes. If there are a lot of\n" ,
   "points, then the earlier boxes get completely obscured. Setting\n" ,
   "this variable to YES means that the boxes will be plotted in a\n" ,
   "pseudo-random order, so that each color/shape of box has a chance\n" ,
   "to be seen in the cloud of data.\n" ,
   "\n" ,
   "---------------------------------\n" ,
   "Variable: AFNI_SIEMENS_INTERLEAVE\n" ,
   "---------------------------------\n" ,
   "The old (pre-DICOM) Siemens .ima image mosaic format sometimes stores\n" ,
   "the multi-slice EPI data in correct spatial order and sometimes in\n" ,
   "correct time acquisition order. In the latter case, the images are\n" ,
   "stored in a spatially-interleaved fashion. As far as I know, there is\n" ,
   "no way to tell this from the .ima file header itself. Therefore, if\n" ,
   "you have a problem with such files, set this variable to YES to\n" ,
   "un-interleave the images when to3d reads them. One way to tell if the\n" ,
   "images need to be un-interleaved is to do\n" ,
   "  afni -im fred.ima\n" ,
   "then look at the images in an Axial image viewer. If the slices make\n" ,
   "up a single coherent volume, then they are NOT interleaved. If the\n" ,
   "slices look like they make up 2 separate brain volumes, then they need\n" ,
   "to be un-interleaved, and you need to set this variable to YES.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_TRY_DICOM_LAST\n" ,
   "-----------------------------\n" ,
   "When to3d tries to read an image file, it guesses the format from the\n" ,
   "filename. However, this doesn't always work. In particular, DICOM\n" ,
   "files don't have any fixed filename suffix or prefix. If all else\n" ,
   "fails, to3d normally tries to read a file as a DICOM file, and as a\n" ,
   "last resort, as a flat binary file. However, if a file is NOT a DICOM\n" ,
   "file, the DICOM reading function will print out a lot of error\n" ,
   "messages, since there is also no standard internal marker in all DICOM\n" ,
   "files that identify them. Most people don't like all these messages\n" ,
   "(perhaps hundreds per file), even if the program then successfully\n" ,
   "reads their flat binary files.\n" ,
   "\n" ,
   "If this YES/NO variable is set to YES, then the normal last-resort\n" ,
   "order of reading described above is reversed. If to3d can't read the\n" ,
   "file any other way, it will try it as a flat binary file. If that\n" ,
   "fails, then DICOM will be the ultimate resort, instead of being the\n" ,
   "penultimate resort that it is by default. This may help elide some\n" ,
   "error messages. However, if you have a DICOM file that is exactly\n" ,
   "131072 bytes long (for example), then it will be interpreted as a\n" ,
   "headerless 256x256 image of shorts, instead of whatever it really is.\n" ,
   "So only set this variable to YES if necessary!\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_THRESH_BIGSTEP\n" ,
   "-----------------------------\n" ,
   "The AFNI threshold sliders (in the Define Overlay control panels and\n" ,
   "the Render Dataset plugins) are divided into 10000 steps from bottom\n" ,
   "to top. If you click in the trough or use the PageUp/PageDown keys,\n" ,
   "the default action is to move the slider 10 of the steps at once.\n" ,
   "(The up and down arrow keys move 1 step at a time.)  You can change\n" ,
   "this big step from the default of 10 to any value between 1 and 1000\n" ,
   "by setting this environment variable; for example\n" ,
   "  setenv AFNI_THRESH_BIGSTEP 100\n" ,
   "will move the slider 1% of its height per PageUp/PageDown key or mouse\n" ,
   "click.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_THRESH_AUTO (editable)\n" ,
   "--------------------------\n" ,
   "If this YES/NO variable is set to YES, then whenever you switch\n" ,
   "overlay datasets, the function threshold slider will automatically\n" ,
   "change to some value that MIGHT be appropriate for the values in the\n" ,
   "new dataset. [This is for Ziad!]\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_THRESH_TOP_EXPON\n" ,
   "-------------------------------\n" ,
   "This variable defines the maximum value for the '**' setting underneath\n" ,
   "the Overlay threshold slider. By default, this value is 5, but you\n" ,
   "can change that to 4 or 6 with this variable. [This is for Phil Kohn]\n" ,
   "\n" ,
   "--------------------------------\n" ,
   "Variable: AFNI_THRESH_INIT_EXPON\n" ,
   "--------------------------------\n" ,
   "This variable defines the initial power-of-ten scale for the '**'\n" ,
   "setting. By default, this value is 1 (thresholds run from 0 to 10),\n" ,
   "but you can change this to a value from 0 to 'TOP_EXPON'.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_OLD_SHORT_THRESH\n" ,
   "-------------------------------\n" ,
   "When thresholding a dataset with a sub-brick that is stored as shorts\n" ,
   "(16 bit integers), the AFNI GUI uses floats, but the 3dmerge and\n" ,
   "Clusterize functions use shorts. The difference is that the\n" ,
   "user-supplied threshold in the latter case is rounded to the nearest\n" ,
   "short. Thus, a threshold of 2.2 would become 2, and then a value of 2\n" ,
   "would pass the 'greater than or equal to threshold' test -- which is\n" ,
   "probably not what the user meant. Again, this would happen in 3dmerge\n" ,
   "and Clusterize, but NOT in the AFNI GUI without Clusterize. This\n" ,
   "inconsistency has been fixed, and both sets of places now threshold\n" ,
   "using floats. However, IF you want to stick with the old method for\n" ,
   "some grotesquely un-imaginable reason, you need to set this variable\n" ,
   "to YES.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_SNAPFILE_PREFIX\n" ,
   "------------------------------\n" ,
   "Image files saved with the \"snapfile\" (or \"record to file\") by default\n" ,
   "have filenames of the form \"S_000001.ppm\". The prefix \"S\" can be\n" ,
   "altered by setting this environment variable; for example,\n" ,
   "  setenv AFNI_SNAPFILE_PREFIX Elvis\n" ,
   "will save snapfiles with names like \"Elvis_000666.ppm\". You can view\n" ,
   "snapfiles with the \"aiv\" (\"AFNI Image Viewer\") utility, the \"xv\"\n" ,
   "program, or many other Unix utilities.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_STARTUP_WARNINGS\n" ,
   "-------------------------------\n" ,
   "When the interactive AFNI program starts, it may pop up warnings about\n" ,
   "the programming environment for which it was compiled. At this time,\n" ,
   "there are two such warning messages possible:\n" ,
   "  LessTiff: AFNI will work with LessTif, but works better with Motif.\n" ,
   "  Button-3: On Solaris 2.8, Button-3 popup menus don't work quite\n" ,
   "            properly.\n" ,
   "If you are tired of seeing these messages, set AFNI_STARTUP_WARNINGS\n" ,
   "to NO.\n" ,
   "\n" ,
   "----------------------\n" ,
   "Variable: AFNI_1D_TIME\n" ,
   "----------------------\n" ,
   "If this YES/NO variable is set to YES, then when a multicolumn .1D\n" ,
   "file is read in as an AFNI dataset, the column variable is taken to be\n" ,
   "time, and a time-dependent dataset is created. The default is to\n" ,
   "create a bucket dataset. Note that each row is taken to be a separate\n" ,
   "'voxel'.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_1D_TRANOUT\n" ,
   "-------------------------\n" ,
   "If this variable is set to YES, it affects the way 1D datasets are\n" ,
   "written out from 3d* programs that are being used to process 1D files\n" ,
   "as AFNI dataset. If this variable is YES, AND if the output dataset\n" ,
   "prefix ends in '.1D' or is the string '-' (meaning standard output),\n" ,
   "then the output 1D file will be transposed and written so that the\n" ,
   "time axis goes down the columns instead of across them. If this\n" ,
   "variable is NO, then the standard AFNI 1D-to-3D dataset convention is\n" ,
   "followed: each row is a single voxel time series. Example:\n" ,
   "  3dDetrend -polort 1 -prefix - 1D:'3 4 5 4 3'\\'\n" ,
   "will write to the screen\n" ,
   "           -0.8\n" ,
   "            0.2\n" ,
   "            1.2\n" ,
   "            0.2\n" ,
   "           -0.8\n" ,
   "if AFNI_1D_TRANOUT is YES, but will write\n" ,
   " -0.8 0.2 1.2 0.2 -0.8\n" ,
   "to stdout if AFNI_1D_TRANOUT is NO.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_1D_TIME_TR\n" ,
   "-------------------------\n" ,
   "If this is set, and AFNI_1D_TIME is YES, then this determines the TR\n" ,
   "(in seconds) of a .1D file read in as an AFNI dataset.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_1D_ZERO_TEXT\n" ,
   "---------------------------\n" ,
   "If this is set to 'YES', then non-commented text gets set to 0\n" ,
   "instead of causing a read failure. The default setting is 'No'\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_3D_BINARY\n" ,
   "------------------------\n" ,
   "If this is set to YES, then .3D files are written by AFNI programs in\n" ,
   "binary, rather than the default text mode. Binary files will be more\n" ,
   "compact (usually) and faster to read in.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_MAX_OPTMENU (editable)\n" ,
   "--------------------------\n" ,
   "This variable (default=255) sets the maximum number of entries allowed\n" ,
   "in an AFNI \"option menu\" -- these are the buttons that popup a menu\n" ,
   "of values from which to choose, and which also let you popup a text\n" ,
   "list chooser by right-clicking in the menu's label. (Example: the\n" ,
   "sub-brick option menus \"Anat\", \"Func\", \"Thr\" on the \"Define Overlay\"\n" ,
   "control panel.)\n" ,
   "\n" ,
   "Some computer systems may crash when an option menu gets too big.\n" ,
   "That's why there is a default limit in AFNI of 255 entries. However,\n" ,
   "if you have a bucket dataset with more than 255 sub-bricks, this makes\n" ,
   "it impossible to view the later data volumes. If this problem arises,\n" ,
   "you can try setting this environment variable to a larger limit (e.g.,\n" ,
   "99999 would take care of all currently imaginable cases).\n" ,
   "\n" ,
   "---------------------------------\n" ,
   "Variable: AFNI_VALUE_LABEL_DTABLE\n" ,
   "---------------------------------\n" ,
   "This variable sets a filename that holds a default value-label table\n" ,
   "for the Draw Dataset plugin. A sample file is shown below:\n" ,
   "\n" ,
   "   <VALUE_LABEL_DTABLE\n" ,
   "     ni_type=\"2*String\"\n" ,
   "     ni_dimen=\"3\" >\n" ,
   "    \"1\" \"elvis\"\n" ,
   "    \"2\" \"presley\"\n" ,
   "    \"3\" \"memphis\"\n" ,
   "   </VALUE_LABEL_DTABLE>\n" ,
   "\n" ,
   "The 'ni_dimen' attribute is the number of value-label pairs; in the\n" ,
   "  above example it is 3.\n" ,
   "Each value-label pair is shown on a separate line. The values and\n" ,
   "  labels are strings, enclosed in quote characters. There should be\n" ,
   "  exactly as many value-label pairs as specified in 'ni_dimen'.\n" ,
   "If you really want to put a double quote character \" in a label,\n" ,
   "  you can enclose the label in single forward quotes ' instead.\n" ,
   "When you 'Save' a drawn dataset from the Draw Dataset plugin, the\n" ,
   "  .HEAD file attribute VALUE_LABEL_DTABLE will contain a table in\n" ,
   "  exactly this XML-based format.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_STROKE_THRESHOLD (editable)\n" ,
   "-------------------------------\n" ,
   "If you press Button-1 in an image window, and then move it left or\n" ,
   "right (\"stroke it\") before releasing the button, the grayscale mapping\n" ,
   "changes in the same way as if you pressed the 'c' button up and the\n" ,
   "'b' button down. This variable sets the threshold for the stroking\n" ,
   "movement size in pixels; a movement of this number of pixels\n" ,
   "rightwards corresponds to one press of 'c' up and 'b' down, while a\n" ,
   "leftwards movement is like one press of 'c' down and 'b' up. Larger\n" ,
   "movements make larger adjustments.\n" ,
   "\n" ,
   "A larger threshold makes the stroking less sensitive; a smaller\n" ,
   "threshold makes it more sensitive. The value you choose will depend\n" ,
   "on your personal taste. The default is 32 pixels, which is the flavor\n" ,
   "I prefer. If you set this variable to 0, then the stroking function\n" ,
   "is disabled.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_STROKE_AUTOPLOT (editable)\n" ,
   "-------------------------------\n" ,
   "If this variable is set to YES, then the graymap-versus-data value\n" ,
   "plot (manually controlled by \"Display Graymap Plot\") is automatically\n" ,
   "popped up when the grayscale mapping is altered by using the stroking\n" ,
   "feature described above. When the stroke is finished, the plot will\n" ,
   "pop down. N.B.: when the 'Draw Dataset' plugin is active, this option\n" ,
   "is disabled temporarily.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_IMAGE_MINTOMAX (editable)\n" ,
   "-----------------------------\n" ,
   "If this variable is set to YES, then image viewer windows will be set\n" ,
   "to the \"Min-to-Max\" state rather than the default \"2%-to-98%\" state\n" ,
   "when they are opened. If you set this in the \"Edit Environment\"\n" ,
   "control, it only affects image viewer windows opened after that point.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_IMAGE_CLIPPED (editable)\n" ,
   "----------------------------\n" ,
   "If this variable is set to YES, then image viewer windows will be set\n" ,
   "to the \"Clipped\" state rather than the default \"2%-to-98%\" state\n" ,
   "when they are opened. If you set this in the \"Edit Environment\"\n" ,
   "control, it only affects image viewer windows opened after that point.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_IMAGE_CLIPBOT (editable)\n" ,
   "----------------------------\n" ,
   "In the \"Clipped\" mode, the top level of the grayscale image is\n" ,
   "computed as 3.11 times the 'cliplevel' as computed by the 3dClipLevel\n" ,
   "algorithm. The bottom level is then a fraction of this top level --\n" ,
   "by default, the fraction is 0.25, but you can change this default by\n" ,
   "setting this variable to a value between 0.0 and 0.5 (inclusive). You\n" ,
   "can also use variable AFNI_IMAGE_CLIPTOP to scale the default top\n" ,
   "level -- this variable can take values between 0.6 and 1.9 (inclusive)\n" ,
   "-- the default is 1.0.\n" ,
   "\n" ,
   "--------------------------------\n" ,
   "Variable: AFNI_IMAGE_GLOBALRANGE (editable)\n" ,
   "--------------------------------\n" ,
   "AFNI_IMAGE_GLOBALRANGE can be set to SLICE (default), VOLUME\n" ,
   "(SUBBRICK), or DSET. The GUI applies the lookup table to color the\n" ,
   "underlay with the range determined from the slice, sub-brick or the\n" ,
   "whole multi-sub-brick dataset,respectively, depending on this\n" ,
   "variable. Besides the .afnirc file, the GUI allows changes from the\n" ,
   "environment plugin menu, the right-click menu on the image viewer\n" ,
   "colorbar or by typing Control-m in an image viewer. The Control-m\n" ,
   "cycles among the global range types.\n" ,
   "\n" ,
   "Previous YES/NO definitions for this variable correspond to VOLUME and\n" ,
   "SLICE respectively and will continue to work as before. The lower\n" ,
   "right corner of the image viewer shows the current range setting:\n" ,
   "(2%-98%/Min2Max, Vol, Dset)\n" ,
   "\n" ,
   "If this variable is set to YES/VOLUME/SUBBRICK, then the image\n" ,
   "viewer windows will be set to scale the bottom gray level to the\n" ,
   "minimum value in the 3D volume and the top gray level to the maximum\n" ,
   "value in the 3D volume. Setting the variable to DSET similarly sets\n" ,
   "the minimum and maximum based on the range of the whole dataset.\n" ,
   "\n" ,
   "This setting overrides the \"Min-to-Max\" and \"2%-to-98%\" settings in\n" ,
   "the \"Disp\" control panel. This setting also applies to all image\n" ,
   "viewers. If you set this in the \"Edit Environment\" control, it will\n" ,
   "apply to all open image viewers immediately, as well as to any image\n" ,
   "viewers opened later.\n" ,
   "  It is important to realize that if you use the 'Display Range'\n" ,
   "popup to set the bot-top range for the grayscale, these settings\n" ,
   "will override the global range UNTIL you switch datasets or switch\n" ,
   "sub-bricks within a dataset. At that point, the global range for\n" ,
   "the new volume will be enforced. This change can be confusing.\n" ,
   "Therefore, the info label beneath the slider shows the source of\n" ,
   "the bot-top grayscale values:\n" ,
   "  [2%-98%]  = from the 2% to 98% points on the slice histogram\n" ,
   "  [Min2Max] = from the 0% to 100% points on the slice histogram\n" ,
   "  [Vol]     = set from the entire volume min and max values\n" ,
   "  [Dset]    = set from the min and max across all subbricks of a dataset\n" ,
   "  [User]    = set by the user from 'Display Range'\n" ,
   "  absent    = not applicable (e.g., underlay image is RGB)\n" ,
   "The popup 'hint' for the grayscale bar shows the current values\n" ,
   "of the bot-top range, if you want to know what numbers correspond\n" ,
   "to the image at which you are gazing so fondly.\n" ,
   "  Finally, note that when a montage is built, the number-to-grayscale\n" ,
   "algorithm is applied to each slice separately, and then the montage\n" ,
   "is assembled. For [2%-98%] and [Min2Max], this fact means that each\n" ,
   "slice will (probably) have a separate grayscale conversion range.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_DRAW_UNDOSIZE (editable)\n" ,
   "----------------------------\n" ,
   "This variable sets the size (in units of Megabytes) of the Undo/Redo\n" ,
   "buffer in the Draw Dataset plugin. The default value is 6. If you\n" ,
   "are short on memory, you could set this to 1. If you are running out\n" ,
   "of undo levels, you could set this to a larger value; however, this\n" ,
   "would only be needed if you are drawing huge 3D swaths of data at a\n" ,
   "time (e.g., using the 3D sphere option with a large radius).\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_DRAW_THRESH\n" ,
   "----------------------------\n" ,
   "This variable controls the clipping threshold for converting atlas\n" ,
   "regions into ROIs in the Draw Dataset plugin. The default value is 49\n" ,
   "percent unless set by this variable as a percentage greater than 0.0\n" ,
   "and at most 100.0 percent\n" ,
   "\n" ,
   "---------------------\n" ,
   "Variable: AFNI_SPEECH (editable)\n" ,
   "---------------------\n" ,
   "If this YES/NO variable is set to NO, then the AFNI speech synthesis\n" ,
   "is disabled. At the current time (Nov 2003), only the Mac OS X 10.3\n" ,
   "version of AFNI uses speech synthesis in any way. And that's just\n" ,
   "for fun.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_IMAGE_ZEROCOLOR\n" ,
   "------------------------------\n" ,
   "This variable, if set to the string name of one of the colors in the\n" ,
   "color chooser menus (e.g., \"Black\"), will result in voxels whose value\n" ,
   "is 0 being set to this color in the slice viewing windows (except when\n" ,
   "viewing RGB images). The main function is to avoid having to use the\n" ,
   "\"Choose Zero Color\" menu all the time, especially when you use the\n" ,
   "\"Swap\" feature to invert the grayscale map (e.g., to make a T2\n" ,
   "weighted image look sort of like a T1 weighted image).\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_MPEG_DATASETS\n" ,
   "----------------------------\n" ,
   "This variable can be used to allow MPEG files to be read in as AFNI\n" ,
   "datasets. Such datasets are inherently 3 dimensional. How they will\n" ,
   "be organized inside AFNI depends on the setting of this variable. The\n" ,
   "options are:\n" ,
   "  SPACE = the frame sequence number will be the z-axis\n" ,
   "  TIME  = the frame sequence number will be the time axis\n" ,
   "  NO    = MPEG files won't be read as AFNI datasets\n" ,
   "          (they can still be read as images into to3d, aiv, etc.)\n" ,
   "If this variable is NOT set to anything, then it is the same as NO.\n" ,
   "\n" ,
   "MPEG filenames input to AFNI programs (as sources of images or as\n" ,
   "datasets) must end in \".mpg\", \".MPG\", \".mpeg\", or \".MPEG\". MPEG\n" ,
   "datasets will be read so that the individual images are displayed in an\n" ,
   "Axial image window.\n" ,
   "\n" ,
   "Note that decoding a long .mpg file that happens to be in your\n" ,
   "directory can slow down the AFNI startup considerably!\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_MPEG_GRAYIZE\n" ,
   "---------------------------\n" ,
   "If this YES/NO variable is set to YES, then MPEG files read into AFNI,\n" ,
   "to3d, or aiv will be converted to grayscale, even if the images in\n" ,
   "the movie are in color.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_VIDEO_DELAY (editable)\n" ,
   "--------------------------\n" ,
   "This is the number of milliseconds the AFNI waits between drawing new\n" ,
   "images when the 'V' or 'v' keys are pressed in an image (or graph)\n" ,
   "window. The default value is 1, which is faster than video can be\n" ,
   "displayed anyway. Set this to a larger value (e.g, 100) to slow down\n" ,
   "the image redraw rate.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_IMAGE_ENTROPY (editable)\n" ,
   "----------------------------\n" ,
   "If this numeric variable is set, this is the entropy of an image below\n" ,
   "which the 2%-98% image scaling will be disabled, and min-to-max will\n" ,
   "be used instead. The units are bits/byte; a useful threshold seems to\n" ,
   "be in the range (0.2,0.5). For images that only have a few values\n" ,
   "different from 0, the 2%-98% scaling can produce weird artifacts. Such\n" ,
   "images will also have a very low entropy. Since this variable can be\n" ,
   "changed interactively from the Edit Environment controls, you can play\n" ,
   "with it to see how it affects your images.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_LOGO16 (etc.)\n" ,
   "----------------------------\n" ,
   "If this variable is set to YES, then the 'AFNI' background logo used in\n" ,
   "the controller and image windows will be enabled. By default, it is off.\n" ,
   "You can control the colors of this logo by the following variables:\n" ,
   "  AFNI_LOGO16_FOREGROUND_x\n" ,
   "  AFNI_LOGO16_BACKGROUND_x\n" ,
   "where 'x' is 'A', 'B', 'C', etc., for the various controller labels.\n" ,
   "If AFNI_LOGO16_BACKGROUND_x isn't set, then AFNI_LOGO16_BACKGROUND\n" ,
   "(with no suffix) is checked as an alternate. The values of these\n" ,
   "variables should be the names of one of the labels on the color chooser\n" ,
   "menus (e.g., the \"Xhairs Color\" menu). You can use these variables to\n" ,
   "make the windows for the various controllers somewhat distinct in\n" ,
   "appearance. If these color variables are not set at all, then AFNI\n" ,
   "uses some colors of my choosing for this purpose.\n" ,
   "\n" ,
   "----------------------------------\n" ,
   "Variable: AFNI_COLORIZE_CONTROLLER\n" ,
   "----------------------------------\n" ,
   "If this variable is set to YES, then the background of the AFNI\n" ,
   "controllers and image viewers will be colorized. The default state is\n" ,
   "that they are not colorized.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_THRESH_LOCK (editable)\n" ,
   "--------------------------\n" ,
   "This variable can be used to lock the Define Overlay threshold sliders\n" ,
   "together. There are three possibilities:\n" ,
   "  NO (the default) => each controller's slider is independent\n" ,
   "  VALUE            => the numerical value on each slider will be the same\n" ,
   "  P-VALUE          => the p-value for each slider will be the same\n" ,
   "This locking only applies to AFNI controllers that are Lock-ed together\n" ,
   "(cf. AFNI_ALWAYS_LOCK and the Define Datamode->Lock menu). If p-values\n" ,
   "are locked, this lock will also only apply to controllers whose current\n" ,
   "Threshold sub-brick has a known statistical distribution.\n" ,
   "\n" ,
   "When you drag a locked threshold slider, the other one will only change\n" ,
   "when you release the mouse button -- they won't slide in tandem, but will\n" ,
   "just jump to the final value.\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_PBAR_LOCK (editable)\n" ,
   "------------------------\n" ,
   "If this variable is set to YES, then the Define Overlay color bars\n" ,
   "(the \"pbars\") of AFNI controllers that are Lock-ed together will be\n" ,
   "coordinated. Changes to one locked pbar will be reflected in the\n" ,
   "others immediately.\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_PBAR_AUTO  (or AFNI_CMAP_AUTO)\n" ,
   "------------------------\n" ,
   "If this variable is set to NO, then the automatic color bar switching\n" ,
   "(that was introduced by Ziad Saad) will be turned off.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_PBAR_THREE\n" ,
   "-------------------------\n" ,
   "If this variable is set to YES, then the 'continuous' colorscale color\n" ,
   "bar in the AFNI GUI will have 3 panes rather than 1. The middle pane\n" ,
   "will have the continuously variable colorscale loaded. The upper and\n" ,
   "lower panes will have the upper and lower colors loaded, OR they can\n" ,
   "be turned off. The sashes that controls the position and size of the\n" ,
   "middle pane can be moved to separately set the top and bottom of the\n" ,
   "color-ization scale (rather than make bottom = -top or bottom = 0, as\n" ,
   "with the 1 pane color bar).\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_PBAR_TICK (editable)\n" ,
   "------------------------\n" ,
   "If this variable is set to NO, then the tick marks in the continuous\n" ,
   "colorscale bar in the AFNI GUI will not have tick marks added on the\n" ,
   "left and right edges. You can also set the number of tick marks this\n" ,
   "way, if you don't want the default number (9). The maximum number\n" ,
   "of tick marks allowed is 63, which should be enough.\n" ,
   "* If this variable is NOT set to NO (or 0), then 9 tick marks will\n" ,
   "  be drawn in the image window intensity bar as well (dividing it\n" ,
   "  into 10 intervals). For this bar, the number of tick marks is\n" ,
   "  fixed: it is either 0 or 9.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_PBAR_FULLRANGE  [03 Jun 2014]\n" ,
   "-----------------------------\n" ,
   "If this variable is set to YES, then the color pbar in Define Overlay\n" ,
   "will reflect the range set by the user for the colorization process.\n" ,
   "At some point, this feature will become the default, and then you'll\n" ,
   "have to set this variable to NO to get the old behavior -- where the\n" ,
   "range set by the user is shown only at the bottom right of the Define\n" ,
   "Overlay panel, and it then multiplies the independently set top value\n" ,
   "of the pbar to get the colorization scale. In the new method, the top\n" ,
   "value of the pbar cannot be set by the user independently of the range\n" ,
   "(or autorange) parameter. The intention of this change is to make the\n" ,
   "number -> colors process somewhat more blatant. This variable's value\n" ,
   "must be set at startup (e.g., in .afnirc), and changing it later will\n" ,
   "have no effect. Also note that if this variable is YES, then setting\n" ,
   "AFNI_PBAR_LOCK to YES will imply AFNI_RANGE_LOCK is YES as well.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_RANGE_LOCK (editable)\n" ,
   "-------------------------\n" ,
   "If this variable is set to YES, then the OLay range values of\n" ,
   "different AFNI controllers that are Lock-ed together will be\n" ,
   "coordinated. Changes in one controller will be reflected in\n" ,
   "the others immediately.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_OPACITY_LOCK\n" ,
   "---------------------------\n" ,
   "This variable controls if changing the overlay opacity in one\n" ,
   "image viewer window (the 1-9 arrows at the viewer right edge)\n" ,
   "changes the opacity in all viewer windows. The default value\n" ,
   "is YES, but you can set this to NO if you don't like it.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_IMAGE_ZOOM_NN (editable)\n" ,
   "----------------------------\n" ,
   "If this variable is set to YES, then image viewer windows will use\n" ,
   "nearest neighbor interpolation for zooming. The default is linear\n" ,
   "interpolation, which produces smoother-looking images. However, some\n" ,
   "people want to see the actual data values represented in the window,\n" ,
   "not some fancy-schmancy interpolated values designed to look good but\n" ,
   "in fact making a mockery of a sham of a mockery of a travesty of two\n" ,
   "mockeries of a sham of reality.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_DISABLE_CURSORS\n" ,
   "------------------------------\n" ,
   "If this variable is set to YES, then AFNI will not try to change the\n" ,
   "X11 cursor shape. This feature is available because it seems that\n" ,
   "sometimes particular X11 installations choices of cursor and AFNI's\n" ,
   "choices don't work together well. If you have unpleasant cursors in\n" ,
   "AFNI (e.g., an X), try setting this variable to YES.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_SLAVE_FUNCTIME (editable)\n" ,
   "-----------------------------\n" ,
   "When the underlay and overlay datasets both are time-dependent,\n" ,
   "switching the time index will change both the underlay and overlay\n" ,
   "sub-bricks. If you want the time index control to change ONLY the\n" ,
   "underlay sub-brick, then set this variable to NO.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_SLAVE_THROLAY\n" ,
   "----------------------------\n" ,
   "This variable allows you to control the INITIAL setting of the widgets\n" ,
   "that slave (or not) the threshold index to the overlay index. (These\n" ,
   "widgets are on the 'Index' right-click popup chooser and on the\n" ,
   "threshold slider right-click popup menu.)  The values you can set for\n" ,
   "this variable, and their effects, are listed below (not case\n" ,
   "sensitive):\n" ,
   "  'OLay'    *or*  '=='  *or*  '0'  ==> threshold index = overlay index\n" ,
   "  'OLay+1'  *or*  '+1'  *or*  '1'  ==> threshold index = overlay index + 1\n" ,
   "  ANYTHING ELSE                    ==> threshold index is free and wild\n" ,
   "This variable replaces the 2 variables listed below. Again, this only\n" ,
   "controls the INITIAL setting of the widgets -- you can change them in\n" ,
   "the AFNI GUI later at any time. Setting this variable after AFNI\n" ,
   "starts (e.g., from plugout_drive) will have little discernible effect.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_FUNC_ALPHA\n" ,
   "-------------------------\n" ,
   "Setting this string to YES will turn on Alpha fading of the functional\n" ,
   "overlay -- it is the same as setting the 'A' button on top of the\n" ,
   "threshold slider to the on stated.\n" ,
   "\n" ,
   "If Alpha is turned on, then the opacity of the overlay ranges from 1\n" ,
   "for above-threshold pixels down to 0. Note that the alpha (opacity)\n" ,
   "level at the pixel-wise level also is scaled by the global\n" ,
   "opacity '1-9' control on the right side of the image viewer,\n" ,
   "where '9' means that above-threshold pixels will be 100% opaque, and\n" ,
   "'6' means they will be 6/9=67% opaque -- and lower opacity pixels will\n" ,
   "be have their opacity scaled down by the same factor.\n" ,
   "\n" ,
   "The variable-opacity overlay usually looks better (less blocky) if you\n" ,
   "open 'Define Datamode' and set the resampling modes for the OLay and\n" ,
   "Stat to 'Li' (linear) rather than the default 'NN' (you can also do\n" ,
   "this via variables AFNI_resam_func and AFNI_resam_thr).\n" ,
   "\n" ,
   "Please note that the Alpha features described above only apply if the\n" ,
   "color scale is in the 'continuous' mode ('**'), not in the discrete\n" ,
   "panes mode. Sorry about this, but that's the situation for the nonce.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_FUNC_BOXED\n" ,
   "-------------------------\n" ,
   "Setting this string to YES will turn on outlining/boxing for the above\n" ,
   "threshold pixels in a functional image overlay. The outline is done over\n" ,
   "the pixels immediately OUTSIDE the above-threshold regions, in the\n" ,
   "overlay image as interpolated to the underlay resolution. If the\n" ,
   "underlay is on a coarse matrix (e.g., native EPI), these outlines\n" ,
   "will look blocky -- you can alter the underlay display grid dimension\n" ,
   "in 'Define Datamode' using the control 'Warp ULay on Demand', and then\n" ,
   "alter the way the datasets are interpolated to the underlay grid using\n" ,
   "'Resam Mode' menus. In this way, you can make blocky-looking EPI results\n" ,
   "fictionally look as if they are beautiful and high resolution.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_FUNC_BOXED_COLOR (editable)\n" ,
   "-------------------------------\n" ,
   "Defines the color used for the boxed outline of above threshold\n" ,
   "regions, when Boxed ('B' button above threshold slided) is turned on.\n" ,
   "See AFNI_FUNC_BOXED for more information. The default color is\n" ,
   "black, which a few people find harsh. This variable replaces the former\n" ,
   "AFNI_EDGIZE_COLOR, which now has no effect. Colors can be set via X11\n" ,
   "names (e.g., \"yellow\", \"hotpink\", \"#1188ff\").\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_SLAVE_THRTIME     *** THIS VARIABLE IS NO LONGER USED ***\n" ,
   "----------------------------\n" ,
   "When the underlay and overlay datasets both are time-dependent,\n" ,
   "switching the time index will change both the underlay and overlay\n" ,
   "sub-bricks, but NOT the threshold sub-brick. If you want the time\n" ,
   "index control to change the threshold sub-brick, then set this\n" ,
   "variable to YES.\n" ,
   "\n" ,
   "--------------------------------\n" ,
   "Variable: AFNI_SLAVE_BUCKETS_TOO  *** THIS VARIABLE IS NO LONGER USED ***\n" ,
   "--------------------------------\n" ,
   "Set this to YES if you want to make changing the time index in the\n" ,
   "underlay dataset change the sub-brick index in the overlay dataset\n" ,
   "even when the overlay is a 'bucket' dataset without a time axis.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_CLICK_MESSAGE\n" ,
   "----------------------------\n" ,
   "If this variable is set to NO, then the string\n" ,
   "  [---------------]\n" ,
   "  [ Click in Text ]\n" ,
   "  [ to Pop Down!! ]\n" ,
   "will NOT be appended to the very first popup message window that AFNI\n" ,
   "creates. This message was added because some people do not realize\n" ,
   "that the way to get rid of these popups (before they vanish on their\n" ,
   "own after 30 seconds) is to click in them. You know who you are.\n" ,
   "However, if you are advanced enough to read this file, then you\n" ,
   "probably aren't one of THEM.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_X11_REDECORATE (editable)\n" ,
   "-----------------------------\n" ,
   "By default, AFNI tries to change some of the \"decorations\" (control\n" ,
   "buttons) on some of the windows it creates (e.g., removing resize\n" ,
   "handles). If you don't want this to happen, set this variable to NO.\n" ,
   "This variable only has an effect on windows created AFTER it is set,\n" ,
   "so if you change this interactively in the Edit Environment plugin, it\n" ,
   "will not affect existing windows. Normally, you would want to set\n" ,
   "this in your .afnirc file.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_IMAGE_SAVESQUARE\n" ,
   "-------------------------------\n" ,
   "YES/NO: Forces images (from the image view \"Save\" button) to be saved\n" ,
   "with square pixels, even if they are stored with nonsquare pixels.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_BUCKET_LABELSIZE\n" ,
   "-------------------------------\n" ,
   "THIS VARIABLE HAS BEEN REMOVED FROM AFNI.\n" ,
   "\n" ,
   "Formerly, it was used to set the width of the \"ULay\", \"OLay\", and\n" ,
   "\"Thr\" menu choosers on the \"Define Overlay\" control panel. As of 03\n" ,
   "May 2005, AFNI now calculates the default width based on the longest\n" ,
   "sub-brick label input for each dataset.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_MAX_1DSIZE\n" ,
   "-------------------------\n" ,
   "Sets the maximum size (in bytes) of each 1D file that will be\n" ,
   "automatically loaded when AFNI starts. The default is 123 Kbytes.\n" ,
   "The intention is to prevent loading of very large files that are not\n" ,
   "intended to be used for graphing/FIMming purposes. If you set this to\n" ,
   "0, you get the default size. If you set this to 1, no 1D files will\n" ,
   "be read at the AFNI GUI startup.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_TITLE_LABEL2 (editable)\n" ,
   "---------------------------\n" ,
   "If this YES/NO variable is YES, then the AFNI window titlebars will\n" ,
   "show the 'label2' field from the AFNI dataset .HEAD file, rather than\n" ,
   "the dataset filename. If the label2 field is set to a nontrivial\n" ,
   "value, that is. You can set the label2 field with the 3drefit\n" ,
   "command.\n" ,
   "\n" ,
   "----------------------------------\n" ,
   "Variable: AFNI_SKIP_ONETIME_POPUPS\n" ,
   "----------------------------------\n" ,
   "Some AFNI popup messages are 'onetime' -- that is, they show up only\n" ,
   "once for each user. This capability is there to announce changes that\n" ,
   "should be noticed. Each onetime message is logged into a file named\n" ,
   ".afni.recordings in the user's home directory, and if a record of such\n" ,
   "a message is found therein, it will not be shown again. To skip\n" ,
   "showing these messages at all, even once, set this variable to YES.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_SHOW_SURF_POPUPS\n" ,
   "-------------------------------\n" ,
   "If this YES/NO variable is set to YES, then when AFNI receives surface\n" ,
   "nodes, triangles or normals from suma, a popup message will be\n" ,
   "displayed. Otherwise, the message will be send to stderr (on the\n" ,
   "terminal window).\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_KILL_SURF_POPUPS\n" ,
   "-------------------------------\n" ,
   "If this YES/NO variable is set to YES, then when AFNI receives surface\n" ,
   "nodes, triangles or normals from suma, no messages will be displayed,\n" ,
   "either in a popup or stderr. Note that if errors occur, popups will\n" ,
   "still be shown; this just turns off the normal information messages.\n" ,
   "N.B.: If AFNI_SHOW_SURF_POPUPS is YES, then it wins over\n" ,
   "      AFNI_KILL_SURF_POPUPS being YES. If neither is set, then\n" ,
   "      messages are displayed to stderr.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_EDGIZE_OVERLAY ** This variable is no longer used **\n" ,
   "-----------------------------\n" ,
   "It has been replaced by AFNI_FUNC_BOXED.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_NIFTI_DEBUG (editable)\n" ,
   "--------------------------\n" ,
   "This integral variable determines the debug level used by the nifti_io\n" ,
   "library functions. If set to 0, only errors are reported by the\n" ,
   "library. The maximum debug level used is currently 4. Note that if\n" ,
   "this is changed from within AFNI, a 'Rescan: This' operation should\n" ,
   "probably be performed, which will force a re-reading of the datasets\n" ,
   "and so force an elicitation of the NIfTI debug messages (for .nii\n" ,
   "files, that is).\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_NIFTI_TYPE_WARN\n" ,
   "------------------------------\n" ,
   "AFNI converts 'byte' NIFTI data types to 'short', and 'int' to\n" ,
   "'float'. Programs that do so will issue a warning each time such a\n" ,
   "conversion is carried out. When this variable is set to NO, as it is\n" ,
   "now by default, each program would issue just one warning at the first\n" ,
   "occurrence of a type conversion. Set this variable to YES if you want\n" ,
   "to see all conversion warnings.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_DEBUG_PLUG_VOL2SURF\n" ,
   "--------------------------\n" ,
   "Use this integer variable to initialize the debug level in\n" ,
   "plug_vol2surf. The current set of acceptable values is {0..5}.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_NIFTI_NOEXT\n" ,
   "--------------------------\n" ,
   "When writing a '.nii' (or '.nii.gz') file from an AFNI program,\n" ,
   "normally a NIfTI-1.1 extension field with some extra AFNI header\n" ,
   "information is written into the output file. If you set this variable\n" ,
   "to YES, then this extension is not written, which will make the output\n" ,
   "be a 'pure' NIfTI-1.1 file. Only use this if absolutely necessary.\n" ,
   "You can also use the 'nifti_tool' program to strip extension data from\n" ,
   "a NIfTI-1.1 dataset file.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_OVERLAY_ZERO (editable)\n" ,
   "---------------------------\n" ,
   "If set to YES, this variable indicates that voxels in the overlay\n" ,
   "dataset that have the numerical value of 0 will get colored when the\n" ,
   "Inten color scale on the Define Datamode panel indicates that 0 has a\n" ,
   "color that isn't \"none\". The default way that AFNI works is NOT to\n" ,
   "colorize voxels that are 0, even if they should otherwise get a color.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: NIML_TRUSTHOST_xx\n" ,
   "---------------------------\n" ,
   "These environment variables ('xx' = '01', '02', ..., '99') set the\n" ,
   "names and/or addresses of external computer hosts to trust with NIML\n" ,
   "TCP/IP connections, which are how AFNI and SUMA communicate. Should\n" ,
   "only be necessary to use these if you are using AFNI and SUMA on\n" ,
   "different machines. Connections from machines not on the trusted list\n" ,
   "will be rejected, for the sake of security. The 'localhost' or\n" ,
   "127.0.0.1 address and local class B network 192.168.0.* addresses are\n" ,
   "always trusted.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_DONT_LOGFILE\n" ,
   "---------------------------\n" ,
   "Most AFNI programs write a copy of their command line to a file in\n" ,
   "your home directory named \".afni.log\". If you do NOT want the log to\n" ,
   "be kept, set this environment variable to YES. The purpose of the log\n" ,
   "is for you to be able to look back and see what AFNI commands you used\n" ,
   "in the past. However, if you are doing a vast number of commands\n" ,
   "inside a script, the log file might eventually become gigantic (the\n" ,
   "Kevin Murphy effect).\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_ECHO_COMMANDLINE\n" ,
   "-------------------------------\n" ,
   "If this is YES, then the command line logger will also echo the\n" ,
   "command line of each AFNI program to stderr, as it starts up. This\n" ,
   "feature is explicitly for Daniel Handwerker, and may well eventually\n" ,
   "be considered his ultimate claim to fame in the Macrocosmic All.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_WRITE_NIML\n" ,
   "-------------------------\n" ,
   "If this variable is set to YES, then AFNI .HEAD files will be written\n" ,
   "in the new NIML (XML subset) format, rather than the 'classic' format.\n" ,
   "The volumetric image data is still in the pure binary .BRIK file, not\n" ,
   "XML-ified in any way. At present (Jun 2005) this format is\n" ,
   "experimental, but will someday soon become the default.\n" ,
   "\n" ,
   "---------------------------------\n" ,
   "Variable: AFNI_ALLOW_MILLISECONDS\n" ,
   "---------------------------------\n" ,
   "The TR value (time step) in 3D+time datasets created with to3d can be\n" ,
   "flagged as being in units of milliseconds (ms) or seconds (s). This\n" ,
   "situation is unfortunate, as some AFNI programs assume that the units\n" ,
   "are always s, which doesn't work well when the TR is actually in ms.\n" ,
   "On 15 Aug 2005, AFNI dataset I/O was modified to only write out TR in\n" ,
   "s units, and to convert ms units to s units on input. If you\n" ,
   "absolutely need to store TR in ms, then you must set this environment\n" ,
   "variable to YES. I strongly recommend against such a setting, but\n" ,
   "recall the AFNI philosophy: \"provide mechanism, not policy\" -- in\n" ,
   "other words, if you want to shoot yourself in the foot, go right\n" ,
   "ahead. This variable is just the safety on the revolver.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_AUTO_RESCAN\n" ,
   "--------------------------\n" ,
   "If this YES/NO variable is set to YES, then the interactive AFNI\n" ,
   "program will rescan all session directories every 15 seconds for new\n" ,
   "datasets. Basically, this is just a way for you to avoid pressing the\n" ,
   "'Rescan' buttons. Note that if AFNI_AUTO_RESCAN is enabled, then the\n" ,
   "rescan method will be 'Add', not 'Replace', no matter what you set\n" ,
   "variable AFNI_RESCAN_METHOD to.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_RESCAN_AT_SWITCH\n" ,
   "-------------------------------\n" ,
   "If this YES/NO variable is set to YES, then the interactive AFNI\n" ,
   "program will rescan all session directories every time you click on\n" ,
   "either of the 'Overlay' or 'Underlay' buttons. Basically, this is just\n" ,
   "another way for you to avoid pressing the 'Rescan' buttons. (Unlike\n" ,
   "with AFNI_AUTO_RESCAN, the AFNI_RESCAN_METHOD settings are respected.)\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_ALL_DATASETS  [02 Jun 2016]\n" ,
   "---------------------------\n" ,
   "By default, AFNI creates a session (internal to the program) that\n" ,
   "contains all the input datasets -- if you input more than one session\n" ,
   "directory, that is. This session is called 'All_Datasets' in the\n" ,
   "'DataDir Switch' popup chooser, and should be the last session listed\n" ,
   "in that list. If you do NOT want this session created, then set\n" ,
   "AFNI_ALL_DATASETS to NO.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_WEB_BROWSER\n" ,
   "--------------------------\n" ,
   "This variable should be set to the full executable path to a Web\n" ,
   "browser, as in\n" ,
   "  setenv AFNI_WEB_BROWSER /usr/bin/mozilla\n" ,
   "If it is not set, AFNI will scan your path to see if it can find a\n" ,
   "browser, looking for \"firefox\", \"mozilla\", \"netscape\", and \"opera\" (in\n" ,
   "that order). If a browser is found, or set, then the 'hidden' popup\n" ,
   "menu (in the blank square to the right of the 'done' button) will have\n" ,
   "a menu item to open it.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_SELENIUM\n" ,
   "--------------------------\n" ,
   "If this YES/NO variable is set to YES, then the Selenium webdriver\n" ,
   "will be used to open a browser window in the places where AFNI uses\n" ,
   "webpages (whereami, help,...) The AFNI_WEB_BROWSER should be set to\n" ,
   "the browser of choice (Chrome,Firefox,Safari). The default browser\n" ,
   "will be chrome if the AFNI_WEB_BROWSER variable is not set. If\n" ,
   "AFNI_SELENIUM is not set or set to NO, AFNI will open the standard\n" ,
   "browser using a system command. Selenium may be installed with \"pip\n" ,
   "install -U selenium\" on a Mac or \"sudo yum install selenium\" on\n" ,
   "Linux. If you need to get pip, it is available from\n" ,
   "https://pypi.python.org/pypi/pip .\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_WEB_DOWNLOADER\n" ,
   "-----------------------------\n" ,
   "This variable should be set to the full executable path to a Web\n" ,
   "downloader, as in\n" ,
   "  setenv AFNI_WEB_DOWNLOADER /usr/bin/curl\n" ,
   "If it is not set, AFNI will scan your path to see if it can find a\n" ,
   "downloader, looking for \"curl\" and \"wget\" (in that order).\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_JPEG_COMPRESS\n" ,
   "----------------------------\n" ,
   "This variable determines the compression quality of JPEG files saved\n" ,
   "in the AFNI GUI and 3dDeconvolve. Its value can be set to an integer\n" ,
   "from 1 to 100. If not set, the default value is 95%.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_NLFIM_METHOD\n" ,
   "---------------------------\n" ,
   "Can be used to set the optimization method using in the NLfit plugin\n" ,
   "(not in 3dNLfim). The methods available are\n" ,
   "  SIMPLEX (the default)\n" ,
   "  POWELL  (the NEWUOA method)\n" ,
   "  BOTH    (use both methods, choose the 'best' result)\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_OVERLAY_ONTOP\n" ,
   "----------------------------\n" ,
   "If this variable is set to YES, then the 'Overlay' button will be\n" ,
   "above the 'Underlay' button on the AFNI control panel. The default,\n" ,
   "from the olden days, is to have the 'Underlay' button above the\n" ,
   "'Overlay' button, which some people find confusing.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_DATASET_BROWSE (editable)\n" ,
   "-----------------------------\n" ,
   "If this variable is set to YES, then when you 'browse' through a\n" ,
   "dataset chooser ('Overlay' or 'Underlay' list) with the mouse or arrow\n" ,
   "keys, then as a dataset is selected in the list, AFNI will immediately\n" ,
   "switch to viewing that dataset. This can be convenient for scrolling\n" ,
   "through datasets, but can also consume memory and CPU time very\n" ,
   "quickly.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_DISABLE_TEAROFF\n" ,
   "------------------------------\n" ,
   "If this variable is set to YES, then the AFNI GUI will not allow popup\n" ,
   "or popdown menus to be 'torn off'. The default is to enable tear off\n" ,
   "for most menus, but this may cause bad things on some platforms (like\n" ,
   "program death).\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_PLUGOUT_TCP_BASE (BETTER USE AFNI_PORT_OFFSET)\n" ,
   "-------------------------------\n" ,
   "This integer will override the base TCP port used by afni to listen for\n" ,
   "plugouts. This allows multiple instances of afni on one machine, where\n" ,
   "each can listen for plugouts. Valid port numbers are 1024..65535.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_PORT_OFFSET\n" ,
   "--------------------------\n" ,
   "This integer provides an offset for the range of port numbers used by\n" ,
   "AFNI and its ilk. This allows multiple instances of communicating\n" ,
   "programs on one machine. Valid port offset numbers are 1024..65000.\n" ,
   "See related options -np in afni -help. See also AFNI_PORT_BLOC.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_PORT_BLOC\n" ,
   "--------------------------\n" ,
   "This integer selects a bloc of port numbers to be used by\n" ,
   "AFNI and its ilk. Much like AFNI_PORT_OFFSET, it allows multiple instances\n" ,
   "of communicating programs on one machine. However it is easier to use.\n" ,
   "Acceptable integer values range from 0 to a couple of thousands.\n" ,
   "See related option -npb, -max_port_bloc in afni -help.\n" ,
   "This environment variable takes precedence over AFNI_PORT_OFFSET.\n" ,
   "\n" ,
   "-----------------------------------\n" ,
   "Variable: AFNI_IMAGE_TICK_DIV_IN_MM (editable)\n" ,
   "-----------------------------------\n" ,
   "If this YES/NO variable is set to YES, then the Tick Div. value in an\n" ,
   "image window will be interpreted as a separation distance, in mm, as\n" ,
   "opposed to the number of tick divisions along each edge. In the YES\n" ,
   "case, a larger value would produce fewer ticks, as they would be\n" ,
   "farther apart. In the NO case, a larger value will produce more tick\n" ,
   "marks. Tick marks are controlled from the Button 3 popup menu\n" ,
   "attached to the grayscale intensity bar in an image viewer.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_IMAGRA_CLOSER\n" ,
   "----------------------------\n" ,
   "If this YES/NO variable is set to YES, then when you click in an\n" ,
   "'Image' or 'Graph' button for a viewer window that is already open (so\n" ,
   "the button is displayed in inverted colors), then the corresponding\n" ,
   "viewer window will close. The default action is to try to raise the\n" ,
   "viewer window to the front, but some window managers (I'm looking at\n" ,
   "you, FC5) don't allow this action. So this provides a way to kill the\n" ,
   "window, at least, if you've lost it in desktop hell somewhere.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_DECONFLICT\n" ,
   "-------------------------\n" ,
   "When AFNI programs write datasets to disk, they will check whether the\n" ,
   "output filename already exists. If it does, the AFNI programs will act\n" ,
   "based on the possible values of AFNI_DECONFLICT as follows:\n" ,
   "    NO/<none>   : do not modify the name or overwrite the file, but\n" ,
   "                  inform the user of the conflict, and exit\n" ,
   "    YES         : modify the filename, as stated below\n" ,
   "    OVERWRITE   : do not modify the filename, overwrite the dataset\n" ,
   "If AFNI_DECONFLICT is YES, then the filename will be changed to one that\n" ,
   "does not conflict with any existing file. For example 'fred+orig' could\n" ,
   "be changed to 'fred_AA1+orig'.\n" ,
   "\n" ,
   "The default behavior is as 'NO', not to deconflict, but to exit.\n" ,
   "Some programs supply their own default.\n" ,
   "\n" ,
   "---------------------------------------\n" ,
   "Variable:  AFNI_GUI_WRITE_AS_DECONFLICT\n" ,
   "---------------------------------------\n" ,
   "When you use the 'Write' buttons under 'Define Datamode' Panel, the\n" ,
   "default is to overwrite existing datasets. However, if\n" ,
   "AFNI_GUI_WRITE_AS_DECONFLICT is set to YES, then the decision follows\n" ,
   "the value of AFNI_DECONFLICT\n" ,
   "\n" ,
   "The default value for this variable is NO, which means interactive\n" ,
   "'Write' operates in overwrite mode.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_SEE_OVERLAY\n" ,
   "--------------------------\n" ,
   "If this variable is set to YES, then the 'See Overlay' button will be\n" ,
   "turned on when a new AFNI controller is opened.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_INDEX_SCROLLREV\n" ,
   "------------------------------\n" ,
   "If this variable is set to YES, then the default direction of image\n" ,
   "slice and time index scrolling will be reversed in the image and graph\n" ,
   "viewers, respectively.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_CLUSTER_PREFIX\n" ,
   "-----------------------------\n" ,
   "This variable sets the prefix for 'Save' timeseries 1D files from the\n" ,
   "'Clusterize' report panel. The default string is \"Clust\". The value\n" ,
   "of this variable will be loaded into the cluster Rpt window text entry\n" ,
   "field, and the prefix can be edited there by the users when it comes\n" ,
   "time to save files.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_CLUSTER_SCROLL\n" ,
   "-----------------------------\n" ,
   "If this variable is NO, then the 'Clusterize' report will not be given\n" ,
   "scrollbars. The default is to give it scroll bars (i.e., YES).\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_CLUSTER_EBAR\n" ,
   "---------------------------\n" ,
   "If this variable is YES, then the Clusterize 'Mean' and 'Medn' Plot\n" ,
   "graphs will have error bars plotted.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_CLUSTER_REPMAX  (editable)\n" ,
   "-----------------------------\n" ,
   "This numeric variable (between 10 and 9999, inclusive) sets the\n" ,
   "maximum number of clusters that will be reported in a 'Clusterize'\n" ,
   "report panel, if scroll bars are turned off by\n" ,
   "AFNI_CLUSTER_SCROLL. The default value is 15. If scroll bars are\n" ,
   "turned on, then the maximum number of clusters shown defaults to 999,\n" ,
   "but can be increased to 9999 if you are completely mad, or are named\n" ,
   "Shruti. If scroll bars are turned off, then you probably don't want\n" ,
   "to make this very big, since the report window would become taller\n" ,
   "than your monitor, and that would be hard to deal with.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_CLUSTER_WAMIMAX (editable)\n" ,
   "------------------------------\n" ,
   "This variable should be set to a number indicating the maximum number\n" ,
   "of clusters to get a 'whereami' report when the 'WamI' button is\n" ,
   "pressed. Since the querying the diverse atlas datasets is slow,\n" ,
   "increasing this value much past its default value of 20 is not usually\n" ,
   "a good plan.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_CLUSTERIZE_OLD\n" ,
   "-----------------------------\n" ,
   "As of Halloween 2018, the 'Clusterize' control panel in the AFNI GUI\n" ,
   "uses program 3dClusterize for outputting tables and masks. One good\n" ,
   "point of this program is that it can do bi-sided clustering, as the\n" ,
   "GUI does. The older program 3dclust cannot do this type of clustering.\n" ,
   "However, if for some bizarre deranged maniacal reason (e.g., testing)\n" ,
   "you want to use 3dclust for these reporting purposes, then set this\n" ,
   "variable to YES. Note that the internal clustering of the AFNI GUI\n" ,
   "does not use either program - the external program is used only for\n" ,
   "the purpose of mask saving. If you use bi-sided clustering, then\n" ,
   "to get the saved mask have the same results as the AFNI GUI, you\n" ,
   "should NOT set this variable to YES.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_STRLIST_INDEX\n" ,
   "----------------------------\n" ,
   "If this variable is set to NO, then the new [12 Oct 2007] 'Index'\n" ,
   "selector at the bottom of a string-list chooser (e.g., the 'Overlay'\n" ,
   "button popup window) will NOT be shown.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_HISTOG_MAXDSET\n" ,
   "-----------------------------\n" ,
   "If this variable is set to a numeric value between 4 and 9\n" ,
   "(inclusive), then the number of Source datasets in the 'Histogram:\n" ,
   "Multi' plugin will be set to this value. The default number of Source\n" ,
   "datasets is 3 -- this variable allows you to increase that setting.\n" ,
   "\n" ,
   "--------------------------------\n" ,
   "Variable: AFNI_HISTOG_CUMULATIVE (editable)\n" ,
   "--------------------------------\n" ,
   "This YES/NO variable lets you control if the 'Histogram: Multi' plugin\n" ,
   "plots the cumulative distribution as well as the density histogram.\n" ,
   "Mostly this was added to subserve the nefarious conspiracies of the\n" ,
   "dreaded Dr Cox, but if you find it useful ....\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_SIGQUIT_DELAY\n" ,
   "----------------------------\n" ,
   "This numeric variable (between 1 and 30) sets the number of seconds\n" ,
   "AFNI will delay before exiting after a SIGQUIT signal is delivered to\n" ,
   "the process. The default delay is 5 seconds. If you deliver a\n" ,
   "SIGALRM signal, AFNI will exit immediately. If you don't know what\n" ,
   "Unix signals are, then don't pay any attention to this subject!\n" ,
   "\n" ,
   "--------------------------------\n" ,
   "Variable: AFNI_NEVER_SAY_GOODBYE\n" ,
   "--------------------------------\n" ,
   "If this variable is set to YES, then the AFNI 'goodbye' messages won't\n" ,
   "be printed when the program exits. For the grumpy people out there\n" ,
   "(you know who I'm talking about, don't you, Daniel?).\n" ,
   "\n" ,
   "--------------------------------\n" ,
   "Variable: AFNI_NEWSESSION_SWITCH\n" ,
   "--------------------------------\n" ,
   "If this variable is set to NO, then AFNI will not automatically switch\n" ,
   "to a new session after that session is read in using the 'Read Sess'\n" ,
   "button on the Datamode control panel.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_FLASH_VIEWSWITCH\n" ,
   "-------------------------------\n" ,
   "If you switch sessions, underlay, or overlay, it can happen that the\n" ,
   "coordinate system might be forced to switch from +orig to +tlrc\n" ,
   "(for example) because there is no dataset to view in the +orig system.\n" ,
   "If you set this variable to YES, AFNI flashes the view switch buttons\n" ,
   "on and off a few times to let you know this is happening\n" ,
   "(this is the Adam Thomas feature).\n" ,
   "  ** Formerly, this feature was on by default, but now you have **\n" ,
   "  ** to explicitly turn it on (this is the Ziad Saad fixup).   **\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_SHELL_GLOB\n" ,
   "-------------------------\n" ,
   "'Globbing' is the Unix jargon for filename wildcard expansion. AFNI\n" ,
   "programs do globbing at various points, using an adaptation of a\n" ,
   "function from the csh shell. This function has been reported to fail\n" ,
   "on Mac OS X Server 10.5 on network mounted directories. If you set\n" ,
   "this variable to YES, then globbing will instead be done using the\n" ,
   "shell directly (via popen and ls). You should only set this variable\n" ,
   "if you really need it, and understand the issue!  [For Graham Wideman]\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_GLOB_SELECTORS\n" ,
   "-----------------------------\n" ,
   "If this variable is 'YES', then internal wildcard expansion (in AFNI\n" ,
   "programs that support this capability) will NOT use the '[]' , '{}' ,\n" ,
   "or '<>' selectors. Note that '[]' is a standard shell wildcard, so\n" ,
   "using this variable will restrict your wildcard-ing. On the other\n" ,
   "hand, it lets you do something like\n" ,
   "  3dTcat -prefix ALL_rest0.nii -relabel -verb 'rest_*.nii[0]'\n" ,
   "which will create a dataset from the #0 sub-brick of every dataset\n" ,
   "that matches the wildcard 'rest_*.nii'.\n" ,
   "\n" ,
   "----------------------------------\n" ,
   "Variable: AFNI_IGNORE_BRICK_FLTFAC\n" ,
   "----------------------------------\n" ,
   "Under some very rare circumstances, you might want to ignore the brick\n" ,
   "scaling factors. Set this variable to YES to do so. WARNING: this is\n" ,
   "dangerous, so be sure to unset this variable when you are done.\n" ,
   "Sample usage:\n" ,
   "  3dBrickStat -DAFNI_IGNORE_BRICK_FLTFAC=YES -max fred+orig\n" ,
   "\n" ,
   "----------------------------------------\n" ,
   "Variable: AFNI_ALLOW_ARBITRARY_FILENAMES\n" ,
   "----------------------------------------\n" ,
   "Normally, AFNI checks output filenames for 'bad' characters, which are\n" ,
   "defined as control characters and ASCII characters that will cause\n" ,
   "trouble on the Unix command line ('*', '$', etc.). 'Bad' filenames\n" ,
   "will not be allowed by most AFNI programs. If, for some reason, you\n" ,
   "want to use such filenames, set this variable to YES. Don't blame\n" ,
   "me if you get into trouble with such filenames!\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_INSTACORR_FDR (editable)\n" ,
   "----------------------------\n" ,
   "If you want AFNI's InstaCorr feature to compute the FDR curve for the\n" ,
   "on-the-fly correlation coefficient sub-brick created interactively,\n" ,
   "then set this variable to YES. Since the FDR computations are the\n" ,
   "slowest part of the operation, the default (if this variable is not\n" ,
   "YES) is that FDR curves are NOT computed.\n" ,
   "\n" ,
   "---------------------------------\n" ,
   "Variable: AFNI_INSTACORR_SEEDBLUR\n" ,
   "---------------------------------\n" ,
   "The InstaCorr controls let you use extra spatial smoothing when\n" ,
   "selecting the seed voxel time series. By default, this extra\n" ,
   "smoothing is a flat average over a sphere of the chosen radius:\n" ,
   "\"SeedRad\". However, if this environment variable is set to YES, then\n" ,
   "the extra smoothing is done by Gaussian blurring with the chosen FWHM:\n" ,
   "\"SeedBlur\". This variable cannot be set interactively, but can be set\n" ,
   "on the AFNI command line with the usual -DAFNI_INSTACORR_SEEDBLUR=YES\n" ,
   "method.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_INSTACORR_JUMP (editable)\n" ,
   "-----------------------------\n" ,
   "When using the Shift+Ctrl+Click method to set the InstaCorr seed, the\n" ,
   "usual operation is to jump the crosshairs focus point to the location\n" ,
   "where the click happened, and then do the InstaCorr seed set. If you\n" ,
   "set this environment variable to NO (the default value is YES), then\n" ,
   "the crosshair jumping will not happen, but the seed will be set at\n" ,
   "the clicked point.\n" ,
   "One use case for this setting is when you have setup a Montage layout\n" ,
   "and don't want it to automatically jump to a new slice when you set\n" ,
   "the InstaCorr seed -- you like the layout of what you are seeing, and\n" ,
   "don't want it to change underneath you just because you are moving\n" ,
   "the seed location. [For Phil Kohn, Sep 2021]\n" ,
   "\n" ,
   "--------------------------------\n" ,
   "Variable: AFNI_INSTACORR_XYZ_LPI\n" ,
   "--------------------------------\n" ,
   "In 3dGroupInCorr's batch mode, the XYZ method of operation sets the\n" ,
   "seed coordinates using AFNI's standard RAI (DICOM) order. If you\n" ,
   "set this variable to YES, then the coordinates given will be\n" ,
   "interpreted as being in LPI (AKA 'neurological') order; that is,\n" ,
   "the given x and y values will be negated before being used inside\n" ,
   "3dGroupInCorr to pick the seed voxel.\n" ,
   "\n" ,
   "----------------------------------\n" ,
   "Variable: AFNI_BLUR_INTS_AS_OLD\n" ,
   "----------------------------------\n" ,
   "As of 15 June 2009, the FIR (finite implulse response) method is\n" ,
   "applid to byte and short data. Previously, 3dmerge had used FIR only\n" ,
   "on float data, meaning shorts and floats would be applied via Fourier\n" ,
   "interpolation. Setting AFNI_BLUR_INTS_AS_OLD to YES will revert to\n" ,
   "the Fourier method for such data.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_IMAGE_CROPSTEP (editable)\n" ,
   "-----------------------------\n" ,
   "Numeric value sets the size of the panning step using in the image\n" ,
   "viewer, when you are adjusting the cropping region using the\n" ,
   "Shift+Arrow keys on the keyboard. Defaults to 1. Legal values are\n" ,
   "-9..9 (inclusive). Positive values means pressing Shift+LeftArrow\n" ,
   "causes the image in the crop window to appear to move to the left;\n" ,
   "negative values cause the crop window to move in the opposite\n" ,
   "direction, so the visible part of the image appears to move to the\n" ,
   "right. (Mutatis mutandum for the other directions, of course.)\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_IMAGE_COLORANGLE (editable) ** OBSOLETE **/\n" ,
   "-------------------------------\n" ,
   "This value, a number between 90 and 360 (inclusive) describes the\n" ,
   "amount of the AJJ color circle used by the 'Colr' button in an\n" ,
   "AFNI image viewer. If no value is given, the default is 240.\n" ,
   "Changing this number to 360 means the color circle is continuous\n" ,
   "from top to bottom -- an effect that is obvious if you use the 'r'\n" ,
   "arrow buttons (on the right of the image viewer) to rotate the\n" ,
   "color circle. The default value of 240 is purely for historical\n" ,
   "reasons, dating back to the old FD program from Medieval Times.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_IMAGE_COLORSCALE\n" ,
   "-------------------------------\n" ,
   "This variable defines the colorscale used by the 'Colr' button\n" ,
   "at the top right of the AFNI image viwer window to colorize\n" ,
   "the Underlay image -- the Overlay colorization is controlled\n" ,
   "from the colorscale on the 'Define Overlay' control pane.\n" ,
   "At this time [Oct 2019], only the following four color scales\n" ,
   "can be used for this purpose:\n" ,
   "   magma  plasma  viridis  googleturbo\n" ,
   "If you do not define AFNI_IMAGE_COLORSCALE, or you define it\n" ,
   "to something besides one of these names (case insensitive),\n" ,
   "then 'googleturbo' is used.\n" ,
   "  https://ai.googleblog.com/2019/08/turbo-improved-rainbow-colormap-for.html\n" ,
   "Note that the color scale can be modified somewhat by using the\n" ,
   "'g' (gamma) arrow buttons on the right edge of the image viewer.\n" ,
   "\n" ,
   "It is possible to change this image viewer underlay colorscale by\n" ,
   "changing this environment variable interactively, using the driving\n" ,
   "feature of the AFNI GUI (e.g., program plugout_drive).\n" ,
   "\n" ,
   "--------------------------------------\n" ,
   "Variable: AFNI_IMAGE_SCROLLWHEEL_TMASK\n" ,
   "--------------------------------------\n" ,
   "This variable lets you control which keyboard modifier keys are\n" ,
   "checked when the mouse scroll wheel is used inside the image.\n" ,
   "If one (or more) of the selected keys is pressed while the\n" ,
   "scroll wheel is moved, then the AFNI controller 'Define Overlay'\n" ,
   "threshold slider moves -- otherwise (the normal case), the image\n" ,
   "slice slider moves. The value of this variable should be contain\n" ,
   "one or more of these strings (NOT case sensitive):\n" ,
   "  Shift           = Shift key pressed\n" ,
   "  Ctrl or Control = Control key pressed\n" ,
   "  Mod1            = Alt key pressed (Linux)\n" ,
   "  Mod2            = Command key pressed (Mac)\n" ,
   "If you do NOT set this variable, it is like setting it to the\n" ,
   "value 'Mod1+Mod2' (so that Alt and Command work on Linux and\n" ,
   "Mac OS X, respectively). However, some Linux systems seem to\n" ,
   "always have the Mod2 mask set for the scroll wheel, and so\n" ,
   "the wheel ALWAYS change the threshold slider and not the slice.\n" ,
   "To prevent this sad thing from happening, set this variable to\n" ,
   "just 'Mod1'. Furthermore, if you include the string 'Debug'\n" ,
   "in this variable, when the scroll wheel is used over the image\n" ,
   "sub-window, some information will be printed out about what the\n" ,
   "program detects, which might help you set things up correctly.\n" ,
   "On my Mac, I get the following output when using the scroll wheel\n" ,
   "twice -- once with no key pressed and once with the Command key:\n" ,
   "  ++ Scrollwheel (imag): button=5 ; state mask=0x\n" ,
   "   +   (mask: shift=1x ctrl=4x mod1=8x mod2=10x mod3=20x mod4=40x mod5=80x)\n" ,
   "   +   change slice\n" ,
   "  ++ Scrollwheel (imag): button=5 ; state mask=10x\n" ,
   "   +   (mask: shift=1x ctrl=4x mod1=8x mod2=10x mod3=20x mod4=40x mod5=80x)\n" ,
   "   +   change threshold\n" ,
   "The second use shows that the 'state mask' (which shows the modifier\n" ,
   "keys) was hexadecimal '10x', which corresponds to the 'mod2' value.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_DUMMY_DATASET\n" ,
   "----------------------------\n" ,
   "The old 'frivolous' AFNI dummy dataset was replaced with a\n" ,
   "low-resolution edition of the N27 dataset on 12 Feb 2010. If for some\n" ,
   "absurd reason you want the old dummy dataset back, then set this\n" ,
   "variable to OLD. (Recall that the dummy dataset is only created if\n" ,
   "you start the AFNI GUI without any input datasets at all -- AFNI is so\n" ,
   "constructed that it needs SOME dataset present to be able to operate:\n" ,
   "hence, the dummy dataset concept.)\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_DONT_COMMAIZE\n" ,
   "----------------------------\n" ,
   "When AFNI programs print out informative (and fun) messages about the\n" ,
   "size of files, memory space, etc., by default commas are inserted,\n" ,
   "as in \"8,765,432\". If you want these numbers printed as \"8765432\"\n" ,
   "(for whatever hideous and twisted reason), set this variable to YES.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_FILE_COORDS_x\n" ,
   "----------------------------\n" ,
   "If this variable is set (where 'x' is A, B, C, ...), then for AFNI\n" ,
   "controller 'x', whenever the crosshair viewpoint changes, the DICOM\n" ,
   "order (x,y,z) coordinates and the dataset 3D index (i,j,k) will be\n" ,
   "written to the file whose name is given by the value of this variable.\n" ,
   "As a special case, if the filename is 'stdout', then the coordinates\n" ,
   "are written to standard output. A sample command\n" ,
   "\n" ,
   "  afni -DAFNI_FILE_COORDS_A=stdout\n" ,
   "\n" ,
   "If the file already exists when afni starts, it will be over-written;\n" ,
   "that is, it is opened in \"w\" mode.\n" ,
   "\n" ,
   "This feature may be referred to as the Jen Evans special.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_AUTORANGE_POWER -- this variable is now obsolete\n" ,
   "------------------------------\n" ,
   "If this variable is set to a value between 0 and 1 (exclusive),\n" ,
   "then the functional overlay 'autoRange' value will be set to\n" ,
   "the largest value in the dataset raised to this power. By default,\n" ,
   "the autoRange value is computed as if this power is 1.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_AUTORANGE_PERC - experimental at this moment\n" ,
   "-----------------------------\n" ,
   "If this variable is set to a value P between 2 and 99 (inclusive),\n" ,
   "then it indicates that the functional overlay 'autoRange' value\n" ,
   "will be set the P-th percentile point on the cumulative histogram\n" ,
   "of the absolute values of the nonzero entries in the Overlay\n" ,
   "dataset sub-brick being viewed. To be less confusing, if P=95\n" ,
   "(for example), then the nonzero absolute values are tabulated\n" ,
   "into histogram bins from smallest (percentile=0) to largest\n" ,
   "(percentile=100), and the value at the 95th percentile will\n" ,
   "be chosen -- so that only 5 percent of the values in the\n" ,
   "dataset are larger than this autoRange value. The reason for\n" ,
   "doing this is to avoid allowing a few large values to distort\n" ,
   "the overlay color scale.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_IDEAL_COLORS (editable)\n" ,
   "---------------------------\n" ,
   "This variable, if set, allows you to specify the set of colors used\n" ,
   "for the FIM Ideal overlay in the graph viewer window. Separate color\n" ,
   "names by colons, as in \"red:green:blue\". The first column in the\n" ,
   "Ideal 1D file gets the first color; the second column gets the second\n" ,
   "color, and so on. The variable AFNI_ORT_COLORS can similarly be used\n" ,
   "to specify the colors for the FIM Ort overlay.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_DONT_USE_HTMLWIN\n" ,
   "-------------------------------\n" ,
   "If this variable is set to NO, then the 'AFNI Tips' button will not\n" ,
   "use the HTML window to display the requested information -- a plain\n" ,
   "text window will be used. You should only need to use this variable\n" ,
   "if the AFNI Tips window crashes on your system.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_UNFONTIZE_HTML\n" ,
   "-----------------------------\n" ,
   "If this variable is set to YES, then font-changing HTML tags will be\n" ,
   "deleted before opening the 'AFNI Tips' HTML window. Try this first\n" ,
   "to avoid crashes, before using the previous variable to turn off the\n" ,
   "HTML tips entirely.\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variable: AFNI_USE_FGETS\n" ,
   "------------------------\n" ,
   "The function fgets() is the Unix standard for reading text lines from\n" ,
   "a file. However, it assumes that the text file lines end in the Unix\n" ,
   "standard end-of-line character (ASCII 0xA). Files created on\n" ,
   "Microsoft platforms use a different end-of-line character (ASCII 0xD).\n" ,
   "The result is that Microsoft-ized text files don't work well with\n" ,
   "fgets(). AFNI uses its own function, cleverly called afni_fgets(), to\n" ,
   "read text lines, to avoid this problem. However, this function is 4-5\n" ,
   "times slower than the system fgets() function, so if speed if crucial\n" ,
   "-- as when reading a giant 1D file -- then set AFNI_USE_FGETS to YES\n" ,
   "to make AFNI programs use the system fgets() function. The best way\n" ,
   "to do this would be on the command line, as in the simple example\n" ,
   "below:\n" ,
   "  1dcat -DAFNI_USE_FGETS=YES bigfileA.1D bigfileB.1D > bigfileAB.1D\n" ,
   "In such an example, you won't see a 4-5 times speedup, since actually\n" ,
   "most of the time is spent decoding the text in the file into numbers\n" ,
   "and then writing them back out -- you'll probably see a speedup of\n" ,
   "about 1.2-1.4 instead -- not trivial, but not exhilarating.\n" ,
   "\n" ,
   "------------------------\n" ,
   "Variables: AFNI_WSINC5_*\n" ,
   "------------------------\n" ,
   "These variables affect the way the '3dAllineate -final wsinc5' windowed\n" ,
   "since interpolation option works. See the output of the command\n" ,
   "  3dAllineate -HELP\n" ,
   "for the details. You can control the width of the sinc window, the\n" ,
   "tapering function, and a couple of other useless options.\n" ,
   "** N.B.: You can turn off the message that the wsinc5 code prints out\n" ,
   "detailing the parameter setup by setting AFNI_WSINC5_SILENT to YES.\n" ,
   "\n" ,
   "--------------------------------\n" ,
   "Variable: AFNI_3dAllineate_final\n" ,
   "--------------------------------\n" ,
   "The default '-final' option for 3dAllineate is 'cubic'. You can change\n" ,
   "this default to any other legitimate value, such as 'wsinc5' or 'NN'.\n" ,
   "This variable is provided to allow you to force the final interpolation\n" ,
   "mode into a script that doesn't allow any easy way to affect it, such\n" ,
   "as that generated by afni_proc.py.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_INDEX_STEP\n" ,
   "-------------------------\n" ,
   "This numeric variable (between 1 and 9, inclusive) sets the step size\n" ,
   "used when you press the up/down arrows on the 'Index' control in the\n" ,
   "left column of the main AFNI controller. Setting this value to 2 (say)\n" ,
   "let's you scroll through an image time series seeing alternate time\n" ,
   "points. This feature can be useful when looking at datasets where\n" ,
   "sub-bricks alternate in type -- for example, from 3dttest++, where the\n" ,
   "even-numbered volumes are effect size estimates, and the odd-numbered\n" ,
   "volumes are the corresponding t-statistics. (This value can also be\n" ,
   "set interactively from a popup chooser activated by right-clicking\n" ,
   "on the 'Index' label to the left of the up/down arrows.)\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_SCATPLOT_LINES\n" ,
   "-----------------------------\n" ,
   "The ScatterPlot plugin lets you graph the data in one sub-brick along\n" ,
   "the x-axis and the data in another sub-brick along the y-axis. It also\n" ,
   "computes some straight line y=ax+b fits to the graph. By default, it\n" ,
   "does 2 different fits, with least sum of squares (L2) and least sum\n" ,
   "of absolutes (L1) criteria. The L2 line is plotted in red (and thus\n" ,
   "corresponds to the Pearson R also shown in red), and the L1 line is\n" ,
   "plotted in blue (and corresponds to the Spearman rho shown in blue).\n" ,
   "With this variable, you can turn off the plotting of either or both\n" ,
   "of these lines, which are often very nearly the same. If the value\n" ,
   "of this variable contains the string 'NOL1', then the L1 line won't\n" ,
   "be shown, and if the value of this variable contains 'NOL2', then\n" ,
   "the L2 line won't be shown. Thus, if the value of this variable is\n" ,
   "'NOL1+NOL2', neither line will be plotted.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_SCATPLOT_FRAC\n" ,
   "----------------------------\n" ,
   "This variable lets you choose the size of the boxes plotted in the\n" ,
   "ScatterPlot plugin. The units are fractions of the plot width,\n" ,
   "so the reasonable range for this value is 0.0 to 0.01 (not inclusive).\n" ,
   "If this variable is not set, or the value is outside of this range,\n" ,
   "then the size of the boxes is set based on the number of points\n" ,
   "being plotted. The only reason for using this variable is if you\n" ,
   "wish to create a sequence of scatterplots and ensure that the points\n" ,
   "plotted in different graphs have a uniform size of boxes.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_GIFTI_VERB\n" ,
   "-------------------------\n" ,
   "This integer sets the verbose level in the gifti I/O library routines.\n" ,
   "Level 1 is the default, 0 is \"quiet\", and values go up to 7.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_DATASETN_NMAX\n" ,
   "----------------------------\n" ,
   "This numeric variable, if set, lets you expand the number of dataset\n" ,
   "lines in the 'Dataset#N' plugin from the default of 9 up to a max of 49.\n" ,
   "(This one is for Shruti.)\n" ,
   "\n" ,
   "---------------------------------\n" ,
   "Variable: AFNI_WRITE_1D_AS_PREFIX\n" ,
   "---------------------------------\n" ,
   "If this variable is set to YES, then 1D formatted files will be\n" ,
   "written to the file based on the given prefix, rather than to an\n" ,
   "automatic 1D file. This allows writing surface files to NIfTI format,\n" ,
   "for example.\n" ,
   "\n" ,
   "-----------------------------------\n" ,
   "Variable: AFNI_PATH_SPACES_OK\n" ,
   "-----------------------------------\n" ,
   "If this variable is set to YES, dataset names with spaces in them will\n" ,
   "go through \"normal\" reading routines, rather than using\n" ,
   "THD_open_tcat() to try to combine multiple datasets.\n" ,
   "\n" ,
   "----------------------\n" ,
   "Variable: AFNI_CREEPTO\n" ,
   "----------------------\n" ,
   "If set to YES, then the AFNI GUI 'Jump to (xyz)' behavior is altered to\n" ,
   "move the crosshairs to the chosen location incrementally, rather than\n" ,
   "in one big jump. The reasons for using this feature are (a) to help\n" ,
   "get a feel for the transit, and (b) just plain fun.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_HISTORY_NAME\n" ,
   "---------------------------\n" ,
   "The value of this variable will alter the 'username@machine' listing\n" ,
   "in the history notes generated by AFNI programs. If this variable\n" ,
   "is NOT set, then your user login name and machine ID are put in the\n" ,
   "header; otherwise, the value of this string is used. You can set this\n" ,
   "string to the null string '' if you wish to hide your identity totally.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_INCLUDE_HISTORY\n" ,
   "---------------------------\n" ,
   "If this variable is set to YES, output datasets will have a\n" ,
   "HISTORY_NOTE which can be seen via 3dinfo, for example. If set to NO,\n" ,
   "output datasets will not have any HISTORY. This is one method for\n" ,
   "making datasets anonymous.\n" ,
   "\n" ,
   "---------------------------------------------------------\n" ,
   "Variables: AFNI_XCLUSTSIM_GLOBAL and AFNI_XCLUSTSIM_LOCAL\n" ,
   "---------------------------------------------------------\n" ,
   "These variables control the setting of the 'global' and 'local' ETAC\n" ,
   "calculations, and are equivalent to using the '-ETAC_global' and\n" ,
   "'-ETAC_local' command line switches to 3dttest++. If you set a\n" ,
   "variable to YES, then that commands the relevant ETAC thresholds\n" ,
   "to be calculated; if you set a variable to NO, it turns off the\n" ,
   "relevant calculation. If you do not set a variable, and you do\n" ,
   "not use the 3dttest++ command line option, you will get whatever\n" ,
   "the default ETAC method(s) are enabled.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_CLUSTSIM_MEGA\n" ,
   "----------------------------\n" ,
   "Set this variable to YES to force the use of the '-MEGA' option\n" ,
   "in 3dClustSim. The primary reason for this usage is to force\n" ,
   "'3dttest -Clustsim' to use '-MEGA' rather than the default '-LOTS'.\n" ,
   "\n" ,
   "=============================================\n" ,
   "| Robert W Cox, PhD                         |\n" ,
   "| Scientific and Statistical Computing Core |\n" ,
   "| National Institute of Mental Health       |\n" ,
   "| National Institutes of Health             |\n" ,
   "| Department of Health & Human Services     |\n" ,
   "| United States of America                  |\n" ,
   "| Earth, United Federation of Planets       |\n" ,
   "| Alpha Quadrant, Milky Way Galaxy          |\n" ,
   "| Local Group, Virgo Supercluster           |\n" ,
   "=============================================\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_LINKRBRAIN\n" ,
   "-------------------------\n" ,
   "If you do NOT want to see the 'linkRbrain' button in the Clusterize\n" ,
   "GUI, then set this variable to NO.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_LINKRBRAIN_SITE\n" ,
   "------------------------------\n" ,
   "This variable sets the name of the linkRbrain server to use. The default\n" ,
   "server is 'linkrbrain.eu'.\n" ,
   "\n" ,
   "#########################################\n" ,
   "###  Vars for realtime functionality  ###\n" ,
   "#########################################\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variables: AFNI_REALTIME_*\n" ,
   "--------------------------\n" ,
   "This set of variables allows you to control the initial setup of the\n" ,
   "realtime data acquisition plugin (menu item \"RT Options\"). Normally,\n" ,
   "this plugin is active only if AFNI is started with the \"-rt\" command\n" ,
   "line option. (It will consume CPU time continually as it polls for\n" ,
   "an incoming data connection, which is why you don't want it running\n" ,
   "by default.)  The following variables can be used to initialize the\n" ,
   "plugin's options:\n" ,
   "\n" ,
   "AFNI_REALTIME_Activate = This is a YES/NO variable, and allows you\n" ,
   "                         to have the realtime plugin active without\n" ,
   "                         using the \"-rt\" command line option. If\n" ,
   "                         this variable is set to YES, then you can\n" ,
   "                         disable the realtime plugin with \"-nort\".\n" ,
   "\n" ,
   "The variables below are used to set the initial status of the widgets\n" ,
   "in the realtime plugin's control window. Each one has the same name as\n" ,
   "the labels in the control window, with blanks replaced by underscores.\n" ,
   "The values to set for these variables are exact copies of the inputs\n" ,
   "you would specify interactively (again, with blanks replaced by\n" ,
   "underscores). For details as to the meaning of these options, see\n" ,
   "the plugin's Help window.\n" ,
   "\n" ,
   "AFNI_REALTIME_Images_Only  = \"No\" or \"Yes\"\n" ,
   "AFNI_REALTIME_Root         = name for datasets to be created\n" ,
   "AFNI_REALTIME_Update       = an integer from 0 to 19\n" ,
   "AFNI_REALTIME_Function     = \"None\" or \"FIM\" (cf. AFNI_FIM_IDEAL below)\n" ,
   "AFNI_REALTIME_Verbose      = \"No\", \"Yes\", or \"Very\"\n" ,
   "AFNI_REALTIME_Registration = \"None\", \"2D:_realtime\", \"2D:_at_end\",\n" ,
   "                             \"3D:_realtime\", \"3D:_at_end\",\n" ,
   "                             or \"3D:_estimate\"\n" ,
   "AFNI_REALTIME_Resampling   = \"Cubic\", \"Quintic\", \"Heptic\", \"Fourier\",\n" ,
   "                             or \"Hept+Four\"\n" ,
   "AFNI_REALTIME_Reg_Base_Mode= \"Current_Run\", \"Current_Run_Keep\", or\n" ,
   "                             \"External_Dataset\"\n" ,
   "AFNI_REALTIME_Base_Image   = an integer from 0 to 9999\n" ,
   "AFNI_REALTIME_Graph        = \"No\", \"Yes\", or \"Realtime\"\n" ,
   "AFNI_REALTIME_NR           = an integer from 5 to 9999\n" ,
   "AFNI_REALTIME_YR           = a floating point number from 0.1 to 10.0\n" ,
   "\n" ,
   "AFNI_REALTIME_External_Dataset = name of dataset to use as external\n" ,
   "                                 basis for registration\n" ,
   "        * if this variable is set, then the plugin assumes that\n" ,
   "          AFNI_REALTIME_Reg_Base_Mode is \"External_Dataset\"\n" ,
   "        * but AFNI_REALTIME_Base_Image is ignored\n" ,
   "        * instead, you can use a sub-brick selector here, if desired;\n" ,
   "          for example: setenv AFNI_REALTIME_External_Dataset 'X+orig[3]'\n" ,
   "        * to be brutally clear, you can give the name of a dataset that is\n" ,
   "          NOT in the current directory -- unlike when using the plugin GUI\n" ,
   "        * the plugin GUI will NOT show the choice of external dataset given\n" ,
   "          via this environment variable!\n" ,
   "\n" ,
   "AFNI_REALTIME_Mask_Vals  = String (one of the listed strings)\n" ,
   "\n" ,
   "        This allows the user to set the \"Vals to Send\" field from the RT\n" ,
   "        plugin's \"Mask\" line. It determines what data are sent to the remote\n" ,
   "        MP program (e.g. serial_helper).\n" ,
   "\n" ,
   "        Sending data requires '3D realtime registration'.\n" ,
   "\n" ,
   "        Valid strings are:\n" ,
   "\n" ,
   "            None             - send nothing\n" ,
   "            Motion_Only      - send only the 6 registration parameters\n" ,
   "            ROI_means        - send mean EPI value per mask ROI (value) per TR\n" ,
   "                               (in addition to motion)\n" ,
   "            All_Data         - (heavy) send each voxel value (in mask) per TR\n" ,
   "                               (in addition to motion)\n" ,
   "            All_Data_light   - send each voxel value (in mask) per TR\n" ,
   "                               (no extras)\n" ,
   "            ROIs_and_data    - a mix of ROI_means and All_Data (light)\n" ,
   "                               (the \"Javier special\" method)\n" ,
   "                               1. for non-1 ROIs, send ROI means\n" ,
   "                               2. for ROI-1, send all voxel data\n" ,
   "                               (non-1 means come before ROI-1 data)\n" ,
   "\n" ,
   "AFNI_REALTIME_Mask_Dset  = String (the name of a dataset)\n" ,
   "\n" ,
   "        This option allows the user to set the Mask dataset, used to\n" ,
   "        send ROI and motion data to a program listening at a socket.\n" ,
   "        This environment variable overrides the variable set in the\n" ,
   "        plugin interface, allowing it to change per run.\n" ,
   "\n" ,
   "        Set the variable to None to either clear the mask or to allow\n" ,
   "        the interface mask to apply. Note that this can be done via a\n" ,
   "        drive afni command, allowing changes after afni is already\n" ,
   "        running, e.g. plugout_drive -com 'SETENV\n" ,
   "        AFNI_REALTIME_MASK_DSET None' -quit\n" ,
   "\n" ,
   "AFNI_REALTIME_WRITEMODE = Number\n" ,
   "        This variable controls writing individual volumes as they are acquired\n" ,
   "        by the realtime plugin. Valid Numbers and their effects are:\n" ,
   "            0 = Off        : do nothing [default]\n" ,
   "            1 = Acquired   : write each volume as it is acquired\n" ,
   "            2 = Registered : write each registered volume\n" ,
   "            3 = Merged     : write each merged volume (merged across channels)\n" ,
   "\n" ,
   "\n" ,
   "N.B.: The following internal controls can only be set using these environment\n" ,
   "       variables (there is no GUI to set these values):\n" ,
   "\n" ,
   "AFNI_REALTIME_volreg_maxite      = an integer >= 1 [default = 9]\n" ,
   "AFNI_REALTIME_volreg_maxite_est  = an integer >= 1 [default = 1]\n" ,
   "AFNI_REALTIME_volreg_graphgeom   = something like 320x320+59+159\n" ,
   "\n" ,
   "AFNI_REALTIME_reset_output_index = YES/NO\n" ,
   "\n" ,
   "        By default, output files will be named with a prefix,\n" ,
   "        PREFIX__NNN, where PREFIX is given by the AFNI_REALTIME_Root\n" ,
   "        variable or the Root in the interface, and where NNN\n" ,
   "        increments per run.\n" ,
   "\n" ,
   "        If this variable is set to YES, then the plugin will try to\n" ,
   "        use NNN=001 each run.\n" ,
   "\n" ,
   "AFNI_REALTIME_CHILDWAIT = max wait time (in sec) for child info process\n" ,
   "        [default = 66.6]; not needed if child info process is not used\n" ,
   "\n" ,
   "AFNI_REALTIME_WRITEWAIT = if the image data pauses for this number of\n" ,
   "        seconds, then the datasets being constructed will be written\n" ,
   "        to disk [default=37.954]; since this output may take several\n" ,
   "        seconds, you may need to adjust this if you are in fact doing\n" ,
   "        imaging with a very long TR.\n" ,
   "        Note that after this wait, the plugin can still receive image\n" ,
   "        data -- even if the image source program is silent for a very\n" ,
   "        long time, AFNI will still be waiting patiently for data.\n" ,
   "\n" ,
   "AFNI_GRAPH_AUTOGRID = By default, if the number of time points in an\n" ,
   "        AFNI graph viewer changes, the density of vertical grid lines\n" ,
   "        changes. If you don't want this to happen, set this variable\n" ,
   "        to NO.\n" ,
   "\n" ,
   "AFNI_REALTIME_MP_HOST_PORT = HOST:PORT\n" ,
   "\n" ,
   "        When this variable is set, the realtime plugin will attempt to\n" ,
   "        open a tcp socket to the corresponding host and port, and will\n" ,
   "        send the six registration correction parameters for each 3D\n" ,
   "        volume received by the plugin. This applies only to the case\n" ,
   "        of graphing 3D registration. The socket will be opened at the\n" ,
   "        start of each run, and will be closed at the end. A simple\n" ,
   "        example of what to set this variable to is localhost:53214.\n" ,
   "        See 'serial_helper -help' for more details.\n" ,
   "\n" ,
   "AFNI_REALTIME_SEND_VER   = Y/N\n" ,
   "\n" ,
   "        If AFNI_REALTIME_MP_HOST_PORT is set, the RT plugin has 3 choices\n" ,
   "        of what to send to that port (possibly to serial_helper):\n" ,
   "            0. the motion parameters\n" ,
   "            1. motion params, along with average EPI values over each ROI\n" ,
   "               in the mask dataset (if set)\n" ,
   "            2. motion params, along with all voxel values over the mask\n" ,
   "               dataset (including index, i,j,k and x,y,z values)\n" ,
   "        If AFNI_REALTIME_SEND_VER is set to YES, then the plugin will\n" ,
   "        offset the last byte of the communication HELLO string by the\n" ,
   "        version number (0, 1 or 2). In the case of versions 1 or 2,\n" ,
   "        the plugin will send the number of ROIs/voxels in a 4-byte int\n" ,
   "        after the HELLO string.\n" ,
   "\n" ,
   "AFNI_REALTIME_SHOW_TIMES = Y/N\n" ,
   "\n" ,
   "        If set, the RT plugin will output CPU times whenever motion\n" ,
   "        parameters are sent to the remote program, allowing evaluation\n" ,
   "        of timing. The times are modulo one hour, and are at a\n" ,
   "        millisecond resolution.\n" ,
   "\n" ,
   "AFNI_REALTIME_MAX_CONTROLLERS = Number\n" ,
   "\n" ,
   "        If set, this is the maximum number of controllers that AFNI will\n" ,
   "         open for multi-channel acquisition display. If more channels\n" ,
   "         than this are sent, only the first ones will be displayed.\n" ,
   "     ** If this variable is not set, its value defaults to 2.\n" ,
   "\n" ,
   "AFNI_REALTIME_DATAMODE = Number\n" ,
   "\n" ,
   "        If set, this variable controls the initial setting of the\n" ,
   "        \"DataWriting\" control, where 0=Off, 1=Acquired, etc. If not\n" ,
   "        set, the default value is 0.\n" ,
   "\n" ,
   "AFNI_REALTIME_CHMERMODE = Number\n" ,
   "\n" ,
   "        If set, this variable controls the initial setting of the\n" ,
   "        \"ChannelMerge\" control, where:\n" ,
   "            0=none,  1=sum,  2=L1 norm,  3=L2norm.  4=T2* est,  5=Opt Comb\n" ,
   "        If not set, the default value is 0.\n" ,
   "\n" ,
   "AFNI_REALTIME_CM_REG_MODE = Number\n" ,
   "\n" ,
   "        If set, this variable controls the ChannelMerge registration mode.\n" ,
   "        Here: 0=none            : no merge registration\n" ,
   "              1=reg_merge       : register merged dastaset\n" ,
   "              2=reg_chan        : apply merge xform to all channels\n" ,
   "        The default is 0.\n" ,
   "\n" ,
   "AFNI_REALTIME_MRG_CHANLIST = String\n" ,
   "\n" ,
   "        If set, this variable specifies a list of 0-based channels to\n" ,
   "        merge, rather than using all channels. The format is akin to\n" ,
   "        sub-brick selection. For example '0..$' means all and\n" ,
   "        '0,5..7' means 0,5,6,7.\n" ,
   "\n" ,
   "\n" ,
   "For detailed information about how the realtime plugin works, read the\n" ,
   "file README.realtime.\n" ,
   "\n" ,
   "Also see \"Dimon -help\" (example E \"for testing complete real-time system\").\n" ,
   "Also see \"serial_helper -help\".\n" ,
   "Also see program rtfeedme.c and \"rtfeedme -help\".\n" ,
   "\n" ,
   "###################################\n" ,
   "###  Vars specific to NIML I/O  ###\n" ,
   "###################################\n" ,
   "\n" ,
   "-----------------------------------\n" ,
   "Variable: AFNI_NIML_DEBUG\n" ,
   "-----------------------------------\n" ,
   "This integer sets the debugging level in some niml I/O routines,\n" ,
   "particularly those in thd_niml.c. Currently used values range from 0\n" ,
   "to 3.\n" ,
   "\n" ,
   "-----------------------------------\n" ,
   "Variable: AFNI_NSD_ADD_NODES\n" ,
   "-----------------------------------\n" ,
   "If this YES/NO variable is set to YES, then when a NI_SURF_DSET\n" ,
   "dataset is written to disk, if it has no node list attribute, a\n" ,
   "default list will be created.\n" ,
   "\n" ,
   "-----------------------------------\n" ,
   "Variable: AFNI_NSD_TO_FLOAT\n" ,
   "-----------------------------------\n" ,
   "If this YES/NO variable is set to NO, then any necessary conversion of\n" ,
   "NI_SURF_DSET datasets to type float will be blocked. Otherwise, all such\n" ,
   "datasets will be written as float.\n" ,
   "\n" ,
   "-----------------------------------\n" ,
   "Variable: AFNI_NIML_TEXT_DATA\n" ,
   "-----------------------------------\n" ,
   "If this YES/NO variable is set to YES, then NI_SURF_DSET datasets will\n" ,
   "be written with data in text format. Otherwise, data will be in\n" ,
   "binary.\n" ,
   "\n" ,
   "-----------------------------\n" ,
   "Variable: AFNI_SIMPLE_HISTORY\n" ,
   "-----------------------------\n" ,
   "A few programs (particularly 3dcalc) create a complicated history note\n" ,
   "in the output dataset header, by including the history of all inputs.\n" ,
   "This history can become inordinately long and pointless when 3calc is\n" ,
   "run in a long chain of calculations. Setting this variable to YES\n" ,
   "will turn off this cumulation of all histories, and may make your\n" ,
   "dataset headers more manageable.\n" ,
   "\n" ,
   "-------------------------------------------\n" ,
   "Variable: AFNI_NIML_BUFSIZE or NIML_BUFSIZE\n" ,
   "-------------------------------------------\n" ,
   "This variable sets the number of bytes used as a memory buffer for\n" ,
   "NIML dataset input. If you are inputting gigantic headers or gigantic\n" ,
   "String data components (I'm looking at YOU, Ziad), then you may want\n" ,
   "to increase this past its default size of 255*1024=261120.\n" ,
   "\n" ,
   "###############################\n" ,
   "###  Vars for 3dDeconvolve  ###\n" ,
   "###############################\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_INDEX_PREFIX\n" ,
   "---------------------------\n" ,
   "3dDeconvolve and 3dREMLfit create statistics datasets that have sub-brick\n" ,
   "labels of the form 'NAME#0_Coef', where 'NAME' is the task name set up\n" ,
   "when running the program. This environment variable lets you replace\n" ,
   "'#' character with another character; for example (in tcsh):\n" ,
   "   setenv AFNI_INDEX_PREFIX _\n" ,
   "which will create labels of the form 'NAME_0_Coef' instead. The single\n" ,
   "character value you supply must be a printable character - not a space,\n" ,
   "not a control character, and not the '~' character (which is special).\n" ,
   "\n" ,
   "Please note that in the future, the default '#' may be replaced by\n" ,
   "some other character in the AFNI setup. When that happens, datasets\n" ,
   "created after that date will not be exactly compatible (as far as\n" ,
   "the sub-brick labels) with datasets created earlier. The purpose of this\n" ,
   "environment variable is to allow you to make these programs backward\n" ,
   "compatible, if necessary. [11 Jul 2019]\n" ,
   "\n" ,
   "-----------------------------------\n" ,
   "Variable: AFNI_3dDeconvolve_GOFORIT\n" ,
   "-----------------------------------\n" ,
   "If this variable is set to YES, then 3dDeconvolve behaves as if you\n" ,
   "used the '-GOFORIT' option on the command line -- that is, it will\n" ,
   "continue to run even if it detects serious non-fatal problems with the\n" ,
   "problem setup.\n" ,
   "\n" ,
   "--------------------------------\n" ,
   "Variable: AFNI_3dDeconvolve_NIML\n" ,
   "--------------------------------\n" ,
   "3dDeconvolve outputs the regression matrix 'X' into a file formatted in\n" ,
   "the 'NIML' .1D format -- with an XML-style header in '#' comments at the\n" ,
   "start of the file. If you DON'T want this format, just plain numbers,\n" ,
   "set this variable to NO.\n" ,
   "\n" ,
   "----------------------------------\n" ,
   "Variable: AFNI_3dDeconvolve_extend\n" ,
   "----------------------------------\n" ,
   "If you input a stimulus time series (via the -stim_file option) to\n" ,
   "3dDeconvolve that is shorter than needed for the regression analysis,\n" ,
   "the program will normally print a warning message and extend the time\n" ,
   "series with zero values to the needed length. If you would rather\n" ,
   "have the program stop if it detects this problem (the behavior before\n" ,
   "22 Oct 2003), then set this environment variable to NO.\n" ,
   "\n" ,
   "---------------------------------\n" ,
   "Variable: AFNI_3dDeconvolve_nodup\n" ,
   "---------------------------------\n" ,
   "If this variable is set to YES, then if the 3dDeconvolve program\n" ,
   "detects duplicate input stimulus filenames or duplicate regressors,\n" ,
   "the program will fail (with an error message) rather than attempt to\n" ,
   "continue.\n" ,
   "\n" ,
   "-----------------------------------------\n" ,
   "Variable: AFNI_3dDeconvolve_nodata_extras\n" ,
   "-----------------------------------------\n" ,
   "When using the -nodata option in 3dDeconvolve, the default printout\n" ,
   "gives the 'normalized standard deviation' for each stimulus parameter.\n" ,
   "If you set this variable to YES, then the printout will include the\n" ,
   "-polort baseline parameters as well, and also the L2 norm of each\n" ,
   "column in the regression matrix.\n" ,
   "\n" ,
   "-----------------------------------\n" ,
   "Variable: AFNI_3dDeconvolve_oneline\n" ,
   "-----------------------------------\n" ,
   "3dDeconvolve outputs a command line for running the cognate 3dREMLfit\n" ,
   "program. By default, this command line is line broken with '\\'\n" ,
   "characters for printing beauty. If you want this command line\n" ,
   "to be all on one physical output line, for convenience in automatic\n" ,
   "extraction (e.g., via grep), then set this variable to YES before\n" ,
   "running the program.\n" ,
   "\n" ,
   "----------------------------------\n" ,
   "Variable: AFNI_3dDeconvolve_rawAM2\n" ,
   "----------------------------------\n" ,
   "Normally, when you use the -stim_times_AM2 option, the regression\n" ,
   "against the covariates is 'centered' around the mean of the values\n" ,
   "given. If you want the regression to proceed directly with the\n" ,
   "covariate values as given, set this option to YES. Please do NOT do\n" ,
   "this unless you understand what this means!!!\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable: AFNI_XJPEG_COLOR\n" ,
   "--------------------------\n" ,
   "Determines the color of the lines drawn between the column boxes in\n" ,
   "the output from the -xjpeg option to 3dDeconvolve. The color format\n" ,
   "is \"rgbi:rf/gf/bf\", where each value rf,gf,bf is a number between 0.0\n" ,
   "and 1.0 (inclusive); for example, yellow would be \"rgbi:1.0/1.0/0.0\".\n" ,
   "As a special case, if this value is the string \"none\" or \"NONE\", then\n" ,
   "these lines will not be drawn.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_XJPEG_IMXY\n" ,
   "-------------------------\n" ,
   "This variable determines the size of the image saved when via the\n" ,
   "-xjpeg option to 3dDeconvolve. It should be in the format AxB, where\n" ,
   "'A' is the number of pixels the image is to be wide (across the matrix\n" ,
   "rows) and 'B' is the number of pixels high (down the columns); for\n" ,
   "example:\n" ,
   "  setenv AFNI_XJPEG_IMXY 768x1024\n" ,
   "which means to set the x-size (horizontal) to 768 pixels and the\n" ,
   "y-size (vertical) to 1024 pixels. These values are the default, by\n" ,
   "the way.\n" ,
   "\n" ,
   "If the first value 'A' is negative and less than -1, its absolute\n" ,
   "value is the number of pixels across PER ROW. If the second value 'B'\n" ,
   "is negative, its absolute value is the number of pixels down PER ROW.\n" ,
   "(Usually there are many fewer columns than rows.)\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_XSAVE_TEXT\n" ,
   "-------------------------\n" ,
   "If this YES/NO variable is set to YES, then the .xsave file created by\n" ,
   "the \"-xsave\" option to 3dDeconvolve will be saved in text format. The\n" ,
   "default is a binary format, which preserves the full accuracy of the\n" ,
   "matrices stored therein. However, if you want to look at the .xsave\n" ,
   "file yourself, the binary format is hard to grok. Note that the two\n" ,
   "forms are not quite equivalent, since the binary format stores the\n" ,
   "exact matrices used internally in the program, whereas the ASCII format\n" ,
   "stores only a decimal approximation of these matrices.\n" ,
   "\n" ,
   "---------------------------\n" ,
   "Variable: AFNI_GLTSYM_PRINT\n" ,
   "---------------------------\n" ,
   "If this YES/NO variable is set to YES, then the GLT matrices generated\n" ,
   "in 3dDeconvolve by the \"-gltsym\" option will be printed to the screen\n" ,
   "when the program starts up.\n" ,
   "\n" ,
   "-----------------------\n" ,
   "Variable: AFNI_FLOATIZE\n" ,
   "-----------------------\n" ,
   "If this YES/NO variable is set to YES, then 3dDeconvolve and 3dcalc\n" ,
   "will write their outputs in floating point format (unless they are\n" ,
   "forced to do otherwise with the '-datum short' type of option). In\n" ,
   "the future, other programs may also be affected by this variable.\n" ,
   "Later [18 Nov 2008]: Now 3dANOVA, 3dANOVA2, and 3dANOVA3 will also\n" ,
   "use this flag to determine if their outputs should be written in\n" ,
   "float format. For example:\n" ,
   "  3dANOVA -DAFNI_FLOATIZE=YES ... other options ...\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_AUTOMATIC_FDR\n" ,
   "----------------------------\n" ,
   "If this variable is set to NO, then the automatic computation of FDR\n" ,
   "curves into headers output by 3dDeconvolve, 3dANOVA, 3dttest, and\n" ,
   "3dNLfim will NOT be done. Otherwise, the automatic FDR-ization of\n" ,
   "these datasets will performed when the datasets are written to disk.\n" ,
   "(You can always use '3drefit -addFDR' to add FDR curves to a dataset\n" ,
   "header, for those sub-bricks marked as statistical parameters.)\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_DONT_ADJUST_FDR\n" ,
   "------------------------------\n" ,
   "If this variable is set to YES, then the adjustment of FDR q-values\n" ,
   "downwards by allowing for the estimate of the number of true\n" ,
   "negatives (e.g., as discussed by Storey, Benjamini, and others)\n" ,
   "will NOT be carried out. As of 26 Mar 2009, this adjustment of\n" ,
   "q-values is the default in AFNI programs. If you want the old\n" ,
   "behavior, set this variable to YES.\n" ,
   "\n" ,
   "----------------------------------\n" ,
   "Variable: AFNI_NON_INDEPENDENT_FDR\n" ,
   "----------------------------------\n" ,
   "If this variable is set to YES, then the FDR calculation is made using\n" ,
   "the non-independent assumption, as in the '-cdep' option for program\n" ,
   "3dFDR. This setting will affect the calculation of FDR curves via\n" ,
   "program 3drefit, et cetera.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_SKIP_SATCHECK\n" ,
   "----------------------------\n" ,
   "If you want 3dDeconvolve to check the input dataset time series for\n" ,
   "initial saturation transients (a somewhat time consuming process),\n" ,
   "set this variable to NO. You can also use program 3dSatCheck for\n" ,
   "this purpose. Or just look at your data (please!).\n" ,
   "\n" ,
   "###########################################\n" ,
   "###  ATLAS and WHEREAMI env variables   ###\n" ,
   "###########################################\n" ,
   "\n" ,
   "N.B.: These variables control how AFNI and whereami make use of\n" ,
   "      various atlases and template spaces. The variables may also\n" ,
   "      affect how other AFNI programs use atlases as input datasets.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_ATLAS_LIST\n" ,
   "-------------------------\n" ,
   "This list contains the names of the atlases that should be queried\n" ,
   "when no specific atlas has been requested. For example, the afni GUI\n" ,
   "and whereami, by default, do not load all the atlases specified in the\n" ,
   "AFNI_atlas_spaces.niml file. If this variable is not set, the\n" ,
   "TT_Daemon atlas and the cytoarchitectonic Eickhoff-Zilles in MNI_ANAT\n" ,
   "space are loaded. If the variable is set to a list like\n" ,
   "\"TT_Daemon,DD_Desai_PM\", then only these two atlases are loaded. The\n" ,
   "list of atlas names may be separated by commas or semicolons. A\n" ,
   "special case of \"ALL\" may be set, and all the available atlases will\n" ,
   "be loaded.\n" ,
   "\n" ,
   "----------------------------------\n" ,
   "Variable: AFNI_TEMPLATE_SPACE_LIST\n" ,
   "----------------------------------\n" ,
   "This list contains the names of the template spaces that are shown\n" ,
   "when whereami reports the coordinates among various spaces. By\n" ,
   "default, the list contains \"TLRC,MNI,MNI_ANAT\". As with\n" ,
   "AFNI_ATLAS_LIST, this list may also be set to \"ALL\".\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_ATLAS_COLORS (editable)\n" ,
   "----------------------------\n" ,
   "This variable sets which atlas to use in the AFNI GUI for \"Atlas\n" ,
   "Colors\", \"Go to Atlas location\", \"Draw Dataset\" and \"Renderer\"\n" ,
   "functions.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_JUMPTO_SPACE (editable)\n" ,
   "----------------------------\n" ,
   "This variable sets which space to use in the AFNI GUI for \"Jump to\n" ,
   "(spacename)\" function where this would default to \"MNI\". Choose a\n" ,
   "valid spacename from the current list of spaces in \"whereami\n" ,
   "-show_spaces\". The jump function transforms the user input coordinates\n" ,
   "from that space to the space of the dataset.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable: AFNI_ATLAS_PATH\n" ,
   "----------------------------\n" ,
   "This variable sets which directory or directories to search for AFNI\n" ,
   "atlas datasets that have been defined in the AFNI_atlas_spaces.niml or\n" ,
   "CustomAtlases.niml file. For all afni programs and scripts that use\n" ,
   "atlas and template datasets, the program will preferentially use (in\n" ,
   "order) the file path included in the dataset filename definition, the\n" ,
   "AFNI_ATLAS_PATH, the AFNI_PLUGINPATH or the standard PATH values.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_PLUGINPATH\n" ,
   "-------------------------\n" ,
   "Described above, this variable is used for several purposes. For\n" ,
   "whereami, this variable sets the directory to load atlases and NIML\n" ,
   "files if not in the current directory. If this variable does not exist\n" ,
   "or the referred file does not exist, then the atlas is searched in the\n" ,
   "user's current PATH setting. If this is set, atlases will be found\n" ,
   "more quickly than searching all the directories of the entire\n" ,
   "PATH. Searches of the PATH variable for whereami usage stop at the\n" ,
   "first occurrence of the searched file, so placing the AFNI directory\n" ,
   "earlier in the PATH will dramatically increase the speed that the file\n" ,
   "is found.\n" ,
   "\n" ,
   "----------------------------------\n" ,
   "Variable: AFNI_WHEREAMI_DEC_PLACES (editable)\n" ,
   "----------------------------------\n" ,
   "Sets precision for whereami output. Higher field data and animal\n" ,
   "atlases require higher precision. The default value used for focus\n" ,
   "point among template spaces is still 0 decimal places (closest mm),\n" ,
   "but animal data requires three decimal places. Value may range from 0\n" ,
   "to 10.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_WAMI_DEBUG\n" ,
   "-------------------------\n" ,
   "This variable controls the output of detailed messages about various\n" ,
   "tasks involved in loading atlases, transformations and composing query\n" ,
   "results. By default, this information is not shown. This integer sets\n" ,
   "the debugging level in whereami routines. Currently used values range\n" ,
   "from 0 to 3.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_TTATLAS_DATASET\n" ,
   "------------------------------\n" ,
   "This variable may also specify the default location of AFNI atlases. This\n" ,
   "variable is maintained mostly for backward compatibility. By default, this\n" ,
   "is not set.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_WHEREAMI_NO_WARN\n" ,
   "-------------------------------\n" ,
   "Turns off warnings about various whereami features - like queries that\n" ,
   "have reached their limit of returned results. By default, warnings are\n" ,
   "displayed only the first time a particular message is encountered.\n" ,
   "\n" ,
   "--------------------------------\n" ,
   "Variable: AFNI_WHEREAMI_MAX_FIND (editable)\n" ,
   "--------------------------------\n" ,
   "By default, only the first nine structures are displayed within a\n" ,
   "particular atlas. You may increase or decrease this to show more or\n" ,
   "fewer structures in the whereami results.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_WHEREAMI_MAX_SEARCH_RAD (editable)\n" ,
   "-------------------------------\n" ,
   "\n" ,
   "By default, whereami searches a radius of 7.5 mm. Set a radius up to\n" ,
   "9.5 mm.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_WHEREAMI_PROB_MIN\n" ,
   "-------------------------------\n" ,
   "Minimum probability AFNI considers in probabilistic atlases\n" ,
   "\n" ,
   "--------------------------------\n" ,
   "Variable: AFNI_DEFAULT_STD_SPACE\n" ,
   "--------------------------------\n" ,
   "The default template space is assumed to be TLRC. This is used for\n" ,
   "coordinate input to whereami, the whereami GUI and for TLRC view\n" ,
   "datasets without a template space explicitly set in the dataset\n" ,
   "header.\n" ,
   "\n" ,
   "--------------------------------\n" ,
   "Variable: AFNI_NIFTI_VIEW\n" ,
   "--------------------------------\n" ,
   "The default view extension used for output when creating AFNI format\n" ,
   "datasets from NIFTI datasets. This variable is only applicable for\n" ,
   "sform and qform codes that do not have clearly defined views\n" ,
   "(sform/qform code = 2). Set to \"tlrc\" or \"orig\". See also\n" ,
   "AFNI_DEFAULT_STD_SPACE and AFNI_NIFTI_PRIORITY. Note sform/qform code=5\n" ,
   "can be used for spaces other than MNI or TLRC including MNI_ANAT or D99\n" ,
   "spaces.\n" ,
   "If unset, the default is 'orig'.\n" ,
   "\n" ,
   "--------------------------------\n" ,
   "Variable: AFNI_NIFTI_PRIORITY\n" ,
   "--------------------------------\n" ,
   "Sets preference for NIFTI files to use sform or qform codes and\n" ,
   "matrices to determine space, origin and orientation. Set to 'S' or 'Q'\n" ,
   "for sform or qform respectively. If not set, NIFTI files are read\n" ,
   "using the non-zero form code or the sform code if both are set.\n" ,
   "\n" ,
   "-------------------------------------------\n" ,
   "Variable: AFNI_SUPP_ATLAS, AFNI_LOCAL_ATLAS\n" ,
   "-------------------------------------------\n" ,
   "These variables allow the addition of more atlas definitions to the\n" ,
   "global list of atlases, templates, spaces and transformations. The\n" ,
   "variable should be set to the name of a NIML file with the same format\n" ,
   "of the AFNI_atlas_spaces.niml file. These can be customized by site\n" ,
   "(supplemental) or by subject (local) and follow the same search order\n" ,
   "as the AFNI_atlas_spaces.niml file. In order to be included in default\n" ,
   "searches, additional atlases or template spaces would also need to be\n" ,
   "added to AFNI_ATLAS_SPACE_LIST and the AFNI_TEMPLATE_SPACE_LIST,\n" ,
   "unless those are set to \"ALL\".\n" ,
   "\n" ,
   "-------------------------------------------\n" ,
   "Variable: AFNI_SUPP_ATLAS_DIR\n" ,
   "-------------------------------------------\n" ,
   "Allows the addition of atlas definitions to the global list of\n" ,
   "atlases, templates,spaces and transformations. The variable should be\n" ,
   "set to the name of a directory that contains a SessionAtlases.niml\n" ,
   "file with the same format as the AFNI_atlas_spaces.niml file. Also see\n" ,
   "AFNI_SUPP_ATLAS, AFNI_LOCAL_ATLAS, AFNI_ATLAS_SPACE_LIST,\n" ,
   "AFNI_TEMPLATE_SPACE_LIST.\n" ,
   "\n" ,
   "------------------------------\n" ,
   "Variable: AFNI_TTATLAS_CAUTION (editable)\n" ,
   "------------------------------\n" ,
   "If this YES/NO variable is set to NO, then the warning about the\n" ,
   "potential errors in the \"Where am I?\" popup will not appear. (This is\n" ,
   "purely for cosmetic purposes, Ziad.)\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_TTATLAS_FONTSIZE (editable)\n" ,
   "-------------------------------\n" ,
   "If this variable is not set, the default font size is used in the\n" ,
   "'Where am I?'  popup window.\n" ,
   "If this variable is set to 'BIG', then a larger font size is used.\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable: AFNI_ATLAS_NAME_TYPE\n" ,
   "-------------------------------\n" ,
   "Atlas region labels can be shown as either as a short name or with a\n" ,
   "longer, more descriptive name. Note that most atlases have only the\n" ,
   "short name available. The whereami GUI and command line can show either\n" ,
   "or both labels with this variable set to \"longname\", \"both\" or \"name\",\n" ,
   "where \"name\" is only the short, standard version. The overlay panel\n" ,
   "and image viewers can show this label too. The names are separated by\n" ,
   "a vertical pipe symbol if both are in the atlas header.\n" ,
   "The default is to show both names if they are available.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_WEBBY_WAMI\n" ,
   "-------------------------\n" ,
   "When set to YES, the Where Am I GUI becomes 'web-enabled', i.e. the\n" ,
   "report becomes clickable to open web pages from the output. Most\n" ,
   "features are still experimental. See AFNI_NEUROSYNTH and AFNI_SUMSDB\n" ,
   "below for examples. The default value is 'NO'.\n" ,
   "\n" ,
   "-------------------------\n" ,
   "Variable: AFNI_NEUROSYNTH\n" ,
   "-------------------------\n" ,
   "When set to YES, provides link for MNI coordinate in Where Am I GUI to\n" ,
   "the Neurosynth site. Requires AFNI_WEBBY_WAMI to also be set to\n" ,
   "YES. The default value is 'NO'.\n" ,
   "\n" ,
   "---------------------\n" ,
   "Variable: AFNI_SUMSDB\n" ,
   "---------------------\n" ,
   "When set to YES, provides link for MNI coordinate in Where Am I GUI to\n" ,
   "the SumsDB site. Requires AFNI_WEBBY_WAMI to also be set to YES. The\n" ,
   "default value is 'NO'.\n" ,
   "\n" ,
   "#####################################################\n" ,
   "###  Interacting with other progs and miscellany  ###\n" ,
   "#####################################################\n" ,
   "\n" ,
   "-------------------------------\n" ,
   "Variable:  AFNI_NO_OPTION_HINT\n" ,
   "-------------------------------\n" ,
   "If this variable is set, do NOT make suggestions if a program parsing\n" ,
   "error is encountered.\n" ,
   "\n" ,
   "--------------------------\n" ,
   "Variable:  AFNI_GUI_EDITOR\n" ,
   "--------------------------\n" ,
   "Set this variable to your favorite GUI text editor.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable:  AFNI_IMAGE_VIEWER\n" ,
   "----------------------------\n" ,
   "Set this variable to your favorite image viewer.\n" ,
   "\n" ,
   "----------------------------\n" ,
   "Variable:  AFNI_PDF_VIEWER\n" ,
   "----------------------------\n" ,
   "Set this variable to your favorite pdf viewer.\n" ,
   "\n" ,
   "------------------------------------\n" ,
   "Variable:  AFNI_LOG_BEST_PROG_OPTION\n" ,
   "------------------------------------\n" ,
   "If set to YES, allow approximate searching functions to log their\n" ,
   "behavior in a file named ~/.afni/help/aps.log.txt\n" ,
   "\n" ,
   "------------------------------------\n" ,
   "Variable:  AFNI_HISTDB_SCRIPT\n" ,
   "------------------------------------\n" ,
   "If set to a non-empty string, an attribute called HISTDB_SCRIPT is\n" ,
   "added to the header of AFNI datasets at write time. The value of the\n" ,
   "attribute is that of the variable AFNI_HISTDB_SCRIPT.\n" ,
   "At the moment, this variable is solely for Tom Ross's nefarious\n" ,
   "history databasing schemes.\n" ,
   "\n" ,
   "------------------------------------\n" ,
   "Variable:  AFNI_ICORR_UBER_USER\n" ,
   "------------------------------------\n" ,
   "If set to YES, enable distance measures that are not ready for prime\n" ,
   "time in the instacorr interface.\n" ,
   "\n" ,
   "------------------------------------\n" ,
   "Variable:  AFNI_SKIP_TCSV_SCAN\n" ,
   "------------------------------------\n" ,
   "If set to YES, do not scan for CSV files at afni startup (default: not\n" ,
   "set, so effectively doing the scan), which is the same as using option\n" ,
   "-notcsv.\n" ,
   "\n" ,
   NULL } ;
#define NUM_readme_env 4527
