/**************************************************************************
  The format of these 90x90 images is simple:
    90*90*3 = 24300 numbers forming the RGB triples for the 8100 pixels.
  To create another such thing, create an ASCII PPM formatted file
  of the appropriate size.  Then convert it to comma separated values
  and add the appropriate C declaration wrapper.

  These logos are used in the RGB_TO_PIXMAP macro in afni_widg.c, and
  provide the various logos that can appear in the 'picture' widget
  that is the backdrop for the big blank area to the right of the
  AFNI GUI 'done' button.
**************************************************************************/

#define lll_width  90
#define lll_height 90

/** The updated AFNI Sunburst logo image **/

static unsigned char lll_rgb[] = {
  227,186,42,209,168,24,210,173,22,201,165,13,230,191,40,217,177,26,
  207,167,18,212,171,27,213,174,28,197,162,21,186,127,14,187,140,36,
  176,132,7,213,163,34,229,179,51,213,165,23,222,175,33,211,158,30,
  199,146,18,203,160,29,211,168,37,205,162,31,215,172,41,210,169,25,
  205,164,20,200,149,31,181,171,39,184,203,61,206,187,58,191,148,17,
  209,166,35,208,163,29,199,149,28,163,111,6,224,181,52,215,176,26,
  237,210,59,198,167,36,186,131,14,203,148,31,212,164,31,210,182,42,
  219,222,56,225,211,72,182,136,25,209,187,68,176,170,37,205,168,46,
  213,197,66,236,197,75,192,141,60,190,146,23,215,195,40,196,173,38,
  179,136,6,195,152,21,205,156,36,207,177,52,190,175,59,229,221,76,
  235,232,62,191,185,29,208,201,47,206,179,42,202,155,25,207,160,30,
  200,173,36,183,174,19,216,185,37,224,184,37,221,180,34,204,187,35,
  198,204,44,204,199,43,223,195,46,206,174,39,199,189,47,174,145,19,
  222,171,53,215,159,34,206,173,21,222,197,48,203,178,28,251,221,89,
  193,163,34,213,185,44,202,176,27,201,176,31,198,161,34,190,135,16,
  214,208,52,196,190,34,203,180,30,207,162,19,226,171,32,238,187,46,
  213,161,23,200,147,19,225,173,43,219,178,34,179,138,0,173,118,2,
  189,134,19,216,174,43,194,151,20,200,145,28,201,146,29,233,188,69,
  200,155,37,193,160,37,208,198,67,204,187,47,190,151,18,215,164,23,
  226,175,34,235,189,58,187,161,24,172,217,56,188,192,45,201,154,24,
  215,162,34,203,150,22,210,157,29,201,148,20,219,166,38,230,178,49,
  237,211,52,211,185,27,198,151,24,179,108,10,206,145,35,200,162,26,
  213,196,56,178,193,42,192,137,20,211,180,55,153,122,0,200,169,44,
  213,198,43,225,186,59,193,120,26,210,163,40,180,178,16,207,201,60,
  220,193,44,209,182,33,193,163,35,216,185,60,175,128,29,244,211,86,
  223,220,59,204,208,53,203,207,53,221,209,68,181,149,14,211,173,45,
  202,189,32,206,201,45,204,178,29,195,152,21,206,163,32,208,165,34,
  226,183,52,213,187,50,204,169,35,180,149,24,252,221,96,189,147,35,
  205,154,45,192,173,32,211,175,21,204,158,11,231,202,68,219,206,85,
  163,151,33,197,185,53,206,181,44,213,165,39,194,137,30,183,127,20,
  227,221,65,174,168,12,209,204,48,216,193,43,196,150,8,209,158,17,
  223,171,33,197,144,16,202,150,21,190,149,5,218,177,33,223,171,35,
  208,156,21,166,149,9,207,191,51,183,128,11,215,160,43,193,151,12,
  252,210,71,184,154,11,205,198,47,211,194,54,185,146,14,201,150,9,
  231,180,39,224,178,48,208,182,45,200,173,37,212,178,44,202,153,24,
  212,159,31,204,151,23,211,158,30,208,155,27,211,158,30,226,173,44,
  218,192,33,230,204,46,183,136,9,198,126,29,191,129,20,205,167,30,
  206,186,47,202,168,34,215,160,43,199,168,43,155,124,0,204,173,48,
  226,211,56,209,169,43,209,139,25,219,175,31,192,169,15,187,161,27,
  233,206,57,215,188,39,195,164,36,213,182,57,184,136,37,245,213,88,
  227,225,55,218,225,48,206,209,38,209,176,41,198,146,18,221,183,54,
  213,200,44,212,186,37,195,146,5,200,157,26,199,156,25,215,172,41,
  210,167,36,202,153,24,193,181,39,240,209,84,182,151,26,199,149,40,
  169,154,33,161,159,34,202,183,44,206,181,27,228,219,79,160,152,13,
  182,173,32,187,165,28,224,177,47,209,145,25,210,153,46,189,133,25,
  232,193,48,247,229,77,218,206,52,190,176,22,208,178,30,203,162,18,
  206,164,20,209,158,17,210,159,18,215,164,23,224,173,32,217,178,23,
  233,194,39,219,155,32,193,125,24,207,151,40,179,123,11,174,130,6,
  225,185,36,255,229,80,180,174,18,190,196,44,176,158,35,210,155,37,
  208,157,17,225,174,33,207,156,15,208,151,24,212,155,29,211,157,33,
  210,159,19,210,166,12,202,160,26,198,153,35,212,156,39,224,149,39,
  228,188,28,228,203,56,208,164,42,192,144,42,206,153,25,208,155,27,
  214,181,47,213,158,31,218,151,47,196,156,22,157,139,0,234,215,78,
  224,211,45,225,187,51,217,153,29,232,168,44,220,163,37,163,125,0,
  221,199,29,231,183,61,196,144,36,209,177,62,179,167,33,209,203,48,
  210,220,39,213,227,52,211,198,51,214,171,40,205,162,31,212,189,38,
  216,174,30,201,152,23,196,168,32,208,174,28,229,195,49,217,174,43,
  198,155,24,198,166,19,183,204,60,221,180,58,199,150,31,194,165,35,
  153,152,34,173,168,35,161,156,22,214,214,79,176,156,28,204,167,34,
  200,163,30,190,144,20,213,156,40,207,146,37,183,144,34,190,156,24,
  220,161,23,208,167,23,247,214,67,223,188,42,204,167,22,213,172,28,
  207,165,21,225,174,33,212,161,20,211,160,19,229,178,37,220,181,26,
  202,163,8,198,134,10,201,133,32,178,119,29,219,160,70,182,135,31,
  188,145,15,207,179,30,236,230,74,182,188,36,196,177,54,185,127,28,
  200,145,26,226,175,34,234,183,42,206,168,35,193,155,23,215,165,40,
  226,174,34,225,181,27,215,173,39,210,170,50,204,169,46,165,110,0,
  231,190,31,211,186,38,251,210,68,207,163,41,200,147,19,227,174,46,
  202,169,34,223,168,41,181,114,10,223,183,49,215,197,54,223,204,68,
  236,223,57,223,184,48,220,156,32,203,139,15,226,169,42,201,163,30,
  244,223,53,243,195,73,197,145,37,210,178,62,202,190,57,211,205,50,
  223,224,46,220,213,45,206,177,35,212,169,38,215,172,41,210,187,37,
  219,176,32,224,174,45,216,188,52,210,198,44,212,199,45,194,151,20,
  204,161,30,204,194,41,201,199,63,173,133,11,203,154,35,170,167,29,
  172,156,43,166,140,13,209,183,56,189,169,40,192,153,31,208,152,26,
  215,157,31,222,162,42,187,148,26,161,146,21,177,158,42,185,170,31,
  214,163,13,220,170,20,230,180,37,229,179,38,225,164,27,227,172,32,
  195,152,9,226,171,32,232,177,38,218,167,26,223,172,31,224,178,35,
  209,182,32,222,173,39,182,109,5,197,112,35,164,114,15,171,119,10,
  202,177,35,200,192,34,213,211,32,227,211,72,176,135,26,186,118,31,
  179,110,22,208,158,8,228,178,28,199,175,22,204,197,55,203,179,44,
  223,174,43,234,183,47,225,199,51,209,200,50,203,185,56,177,135,31,
  234,183,48,212,170,0,232,193,38,213,174,21,190,148,5,233,191,48,
  212,182,49,220,188,56,194,146,31,210,165,46,234,227,72,223,216,62,
  245,232,66,216,178,41,197,148,14,197,125,17,206,151,36,216,185,44,
  255,222,59,204,158,46,176,132,39,199,159,49,184,164,15,228,213,51,
  215,198,38,217,181,34,228,173,34,213,165,25,210,181,34,217,193,48,
  190,143,23,221,164,37,210,196,55,199,210,60,192,183,39,195,152,23,
  194,148,41,215,189,68,185,157,39,188,123,18,192,149,18,203,152,43,
  190,155,33,211,168,47,185,142,21,184,132,8,211,159,18,209,170,24,
  216,169,28,200,164,23,204,197,62,140,151,30,151,157,36,234,226,91,
  236,186,35,204,154,4,215,164,21,215,164,23,206,154,14,213,177,31,
  222,198,48,212,175,30,222,184,39,196,145,4,210,159,18,211,165,23,
  208,182,33,252,226,65,235,183,53,197,135,17,178,106,16,175,102,14,
  167,121,2,203,194,53,204,199,35,225,211,53,226,186,58,198,131,26,
  209,142,36,206,156,5,231,181,30,203,180,25,203,197,55,210,203,63,
  191,163,27,212,162,27,219,176,32,230,210,57,201,186,38,185,146,26,
  221,169,31,234,185,32,209,170,15,242,203,48,191,150,6,215,174,30,
  205,178,28,255,234,84,198,156,21,208,166,31,215,209,53,201,195,39,
  194,181,15,215,176,40,204,156,21,189,117,10,202,130,22,209,159,24,
  255,217,83,197,152,34,192,169,53,196,178,44,226,210,52,221,206,43,
  196,177,19,213,175,30,223,170,30,207,177,29,217,206,52,228,204,59,
  202,154,37,206,148,22,216,203,61,173,185,35,217,206,64,209,168,22,
  217,173,51,183,136,25,169,122,11,214,147,43,211,170,37,228,177,29,
  201,166,38,200,156,35,198,154,33,211,157,33,220,169,25,222,176,31,
  217,193,43,200,199,46,156,171,29,143,164,36,200,190,58,252,228,81,
  255,224,75,194,160,10,182,158,8,196,159,14,217,157,19,207,172,26,
  216,216,58,212,206,51,205,198,43,211,180,32,224,178,36,193,142,4,
  228,181,56,232,193,53,255,232,65,202,170,24,184,119,16,185,111,22,
  176,110,13,175,143,27,202,175,51,180,140,20,228,190,55,243,205,57,
  201,146,3,198,152,10,232,203,41,204,192,36,191,199,43,197,202,48,
  205,189,40,195,160,13,205,163,12,221,177,28,209,182,31,204,169,26,
  241,190,49,226,174,36,220,172,32,234,188,33,223,177,27,231,185,35,
  226,197,37,253,241,75,220,181,28,228,189,36,238,234,70,228,206,63,
  243,218,74,185,155,5,234,212,58,212,164,38,205,152,11,202,155,8,
  238,181,56,177,118,3,205,189,55,200,192,36,227,219,58,226,206,52,
  202,166,19,221,174,32,219,168,26,208,203,39,218,207,45,206,178,39,
  205,153,41,199,150,21,187,179,49,153,162,33,177,166,29,212,185,39,
  212,162,46,187,114,12,188,130,23,212,159,38,209,164,33,238,188,43,
  181,133,4,205,146,30,207,148,32,228,170,33,211,167,20,225,188,41,
  209,204,48,185,211,50,150,167,28,166,161,38,204,161,28,210,163,27,
  192,165,16,232,205,56,250,236,83,200,170,22,207,156,15,205,165,20,
  207,196,42,193,218,52,193,216,50,223,199,49,215,171,28,239,187,51,
  181,126,10,199,148,23,245,222,47,253,227,68,207,154,25,215,150,35,
  216,150,35,199,143,35,170,118,9,179,105,13,225,202,65,250,237,74,
  210,177,20,189,144,6,255,238,71,226,204,52,198,194,37,201,203,44,
  208,189,38,234,206,53,229,193,37,223,170,21,217,167,26,227,176,35,
  229,178,37,220,169,29,230,178,43,230,181,26,246,196,45,235,185,34,
  233,186,34,246,222,62,255,217,62,221,182,27,238,235,66,202,173,35,
  209,179,44,230,204,48,247,236,58,217,182,31,255,220,65,232,193,38,
  218,155,25,197,131,20,192,157,29,234,206,56,225,201,46,232,193,48,
  217,163,23,230,179,38,235,184,42,215,214,46,224,206,44,231,186,37,
  192,124,5,196,151,19,174,169,42,151,159,39,192,180,47,208,167,33,
  203,132,32,194,115,16,211,155,47,201,171,35,192,161,26,200,147,19,
  214,161,33,220,154,41,219,153,40,201,155,24,199,173,35,210,204,50,
  210,204,48,205,203,43,190,171,30,195,153,32,203,150,22,214,162,34,
  203,181,34,198,175,29,191,173,26,250,227,84,239,212,65,185,150,4,
  204,156,14,215,175,31,233,194,49,196,169,20,220,182,37,196,152,8,
  199,145,17,197,145,16,212,179,17,221,183,22,233,178,36,228,166,32,
  203,141,7,215,145,35,200,133,21,207,121,25,200,188,50,216,232,61,
  248,239,69,209,168,28,252,230,70,235,197,54,210,181,38,203,199,48,
  202,181,30,254,237,75,253,227,63,217,166,18,236,166,28,241,171,33,
  230,179,35,205,154,10,218,163,24,245,200,45,241,205,43,236,190,38,
  243,185,31,229,186,27,236,197,42,234,195,40,244,236,74,214,180,48,
  203,168,35,253,234,78,246,234,51,220,183,22,237,192,39,238,202,46,
  227,167,42,200,131,20,193,141,18,245,198,55,227,182,34,228,174,34,
  231,170,32,239,184,41,238,186,40,221,208,41,223,200,35,239,182,24,
  247,173,41,221,180,48,176,168,36,161,172,42,198,191,41,220,160,27,
  210,122,34,198,116,14,181,136,22,211,201,59,224,209,59,221,164,35,
  216,161,24,229,162,40,174,113,2,173,144,22,156,150,20,187,196,39,
  197,182,29,220,177,24,222,167,20,211,153,19,215,166,29,232,185,38,
  189,190,44,199,201,55,224,191,57,192,153,21,234,202,60,250,223,75,
  198,163,17,195,154,10,212,172,28,255,234,85,232,205,56,255,229,71,
  221,170,19,224,173,32,227,176,35,199,137,0,197,135,0,227,165,28,
  227,165,28,217,153,29,212,148,24,209,141,28,189,148,27,185,181,37,
  226,221,57,236,216,65,227,207,56,234,192,60,247,204,73,207,169,40,
  210,172,28,254,236,59,255,244,68,233,194,44,240,177,31,243,181,34,
  230,180,29,232,182,31,235,190,37,254,231,71,245,228,48,232,191,39,
  242,193,39,235,186,32,255,218,63,235,196,41,255,243,89,193,152,28,
  189,145,15,227,208,50,242,218,58,238,194,41,235,181,31,229,195,39,
  207,167,45,198,137,22,204,148,26,245,194,52,229,178,33,230,179,38,
  228,174,31,228,168,20,240,183,32,233,188,25,238,193,30,245,186,32,
  213,151,19,205,158,28,196,171,34,203,166,23,223,165,24,205,152,21,
  201,162,53,178,162,31,173,184,45,208,193,52,211,177,22,216,155,15,
  233,168,47,175,114,0,195,156,33,172,171,26,170,174,27,219,203,54,
  216,178,33,220,157,14,209,158,7,216,183,26,219,191,32,215,189,28,
  144,161,10,172,187,37,239,194,63,199,141,15,213,159,25,232,202,56,
  245,233,81,233,212,59,227,205,52,207,179,27,255,229,78,232,199,43,
  234,183,34,212,161,20,228,174,35,227,164,27,223,159,23,227,164,26,
  244,181,43,255,200,74,216,154,28,204,143,27,193,118,10,168,117,5,
  218,201,60,251,246,92,243,236,82,226,184,49,218,173,41,237,164,45,
  222,167,28,226,209,34,237,227,51,255,235,80,220,177,23,222,177,24,
  236,185,33,231,181,29,214,189,28,229,224,56,251,233,52,220,177,25,
  216,162,31,231,178,43,217,177,26,232,195,43,222,200,50,184,143,21,
  205,161,34,238,215,61,245,221,59,231,185,32,222,168,22,253,218,65,
  176,152,23,189,147,28,205,150,28,220,168,30,229,179,36,219,169,27,
  233,180,35,231,173,24,237,178,27,247,183,27,216,152,0,247,186,37,
  207,144,13,212,145,20,223,175,44,213,197,32,167,123,1,183,140,26,
  189,206,58,166,153,22,206,172,46,214,179,41,225,174,22,252,192,47,
  178,111,20,187,143,41,203,185,45,188,217,44,203,202,39,224,186,39,
  238,182,41,221,165,19,241,210,52,220,204,36,235,225,57,191,174,34,
  174,174,38,164,144,15,211,161,33,196,143,15,209,159,31,222,174,44,
  217,175,39,255,236,82,255,237,83,224,192,32,219,167,13,213,176,30,
  218,195,45,196,161,15,219,162,23,214,159,20,232,177,37,225,172,22,
  209,156,6,222,179,30,255,222,72,217,169,29,209,135,25,186,110,1,
  202,148,31,183,140,9,199,156,25,240,196,54,220,176,33,223,165,27,
  227,165,28,232,187,35,255,252,77,246,247,70,225,199,40,219,172,20,
  221,160,19,227,167,26,224,195,44,215,206,47,234,206,37,192,139,1,
  193,128,12,230,168,31,199,139,14,235,197,64,202,149,18,179,146,29,
  207,160,52,194,151,20,243,210,46,231,174,38,216,159,33,192,155,22,
  191,164,32,189,138,33,186,121,10,231,165,52,221,170,52,205,163,26,
  213,170,17,242,192,41,230,179,27,238,177,33,215,151,26,198,141,15,
  219,162,36,209,154,15,227,173,33,219,170,38,183,107,6,195,129,37,
  194,155,30,206,194,54,208,170,18,234,187,23,231,181,31,211,143,25,
  189,143,24,210,181,51,212,208,49,214,219,49,251,236,73,222,176,23,
  220,170,19,238,202,46,208,181,24,255,235,72,221,188,28,212,176,36,
  200,180,52,205,165,43,205,152,25,205,152,24,214,151,27,207,138,16,
  203,139,15,217,169,43,242,197,69,221,185,44,225,169,35,222,193,45,
  193,218,52,222,208,54,206,169,24,200,165,19,181,146,1,211,178,21,
  229,196,39,218,199,21,255,240,63,239,194,35,220,149,20,224,128,25,
  207,133,23,235,192,61,209,166,35,193,168,20,244,220,70,226,173,33,
  224,162,25,201,146,1,252,222,54,245,236,63,221,213,48,208,181,22,
  220,155,35,216,151,31,223,171,46,188,158,26,255,233,82,206,150,29,
  225,160,44,216,154,17,247,167,48,212,155,29,201,148,16,208,174,58,
  176,130,21,222,179,48,189,152,8,211,151,35,218,161,35,216,179,46,
  194,167,35,197,146,41,185,120,9,228,162,49,177,124,19,194,149,33,
  225,180,40,240,190,39,227,175,26,225,161,37,202,135,30,215,178,45,
  207,170,37,224,189,43,219,184,38,197,125,18,206,109,32,221,136,49,
  212,156,37,222,171,27,233,200,29,250,203,35,203,147,36,189,117,24,
  213,169,37,213,207,51,202,221,36,247,232,69,227,193,36,202,152,1,
  238,188,37,217,181,25,234,208,49,237,204,43,230,177,24,226,171,35,
  255,245,102,243,219,75,208,168,17,202,155,21,213,164,41,213,165,38,
  193,141,16,205,155,27,164,133,0,209,164,43,202,137,24,184,142,21,
  200,195,42,228,210,58,207,177,29,198,171,18,177,169,30,175,155,21,
  213,173,23,235,206,31,225,196,21,246,202,48,231,187,34,228,172,33,
  220,164,25,225,156,44,206,137,25,188,151,12,199,165,24,228,171,42,
  205,141,17,213,145,26,202,144,12,220,185,28,231,210,49,225,203,42,
  214,167,25,223,156,21,234,172,35,237,175,38,230,187,43,220,176,32,
  204,137,31,216,152,25,215,153,16,230,168,31,214,161,33,206,153,25,
  209,145,21,255,196,72,208,144,23,211,146,25,221,172,35,198,168,26,
  193,158,43,195,141,33,208,134,18,216,138,40,187,124,19,222,169,40,
  245,199,48,245,204,43,231,191,33,215,188,46,188,167,42,191,175,49,
  189,176,30,220,193,44,216,189,40,238,181,74,181,124,17,198,138,17,
  221,190,36,233,201,39,239,219,63,183,147,4,176,111,11,210,153,47,
  212,204,48,188,219,45,235,225,66,219,184,38,213,178,32,253,218,72,
  221,170,29,225,165,28,216,176,31,211,184,35,216,175,31,222,181,36,
  242,242,70,241,241,69,255,245,67,223,199,37,181,152,25,162,130,18,
  178,144,28,202,173,37,208,198,56,197,174,46,178,135,14,195,122,30,
  191,112,3,221,166,27,232,208,58,238,215,41,197,193,33,185,162,50,
  204,160,32,224,172,25,237,185,38,204,181,21,222,198,38,216,181,35,
  211,176,30,221,180,58,182,141,20,213,157,42,178,120,6,189,127,6,
  216,152,28,207,126,21,215,134,29,252,194,62,227,186,32,211,170,16,
  222,175,33,228,160,25,232,170,33,218,156,19,209,144,9,215,150,14,
  187,120,14,223,159,33,229,167,30,234,172,35,207,154,26,205,152,24,
  219,155,31,227,163,39,201,133,34,192,124,25,217,143,34,200,145,30,
  197,142,34,222,147,46,212,136,21,211,132,35,172,108,4,237,184,55,
  230,173,33,215,150,19,236,173,40,200,187,40,162,194,51,170,174,42,
  175,182,29,211,184,35,225,198,49,178,121,14,220,163,56,225,191,41,
  226,220,38,212,206,14,211,164,38,167,126,9,207,145,25,221,191,48,
  192,203,55,198,204,58,198,163,31,188,176,22,253,240,87,239,207,60,
  207,156,15,222,162,24,223,183,39,218,191,42,214,173,29,230,190,45,
  219,196,40,242,219,63,248,218,46,255,240,72,251,246,87,190,181,41,
  148,129,9,152,136,12,183,199,62,209,200,45,223,178,35,201,139,30,
  199,132,25,204,118,11,198,134,20,221,182,23,255,239,89,227,201,59,
  191,141,8,222,138,20,202,137,13,227,186,42,219,177,33,220,167,27,
  206,173,27,203,189,48,188,151,18,220,157,33,217,153,29,208,143,28,
  216,150,37,202,136,23,210,144,31,207,143,28,207,154,26,222,169,41,
  198,137,22,195,133,18,196,136,16,210,150,30,228,170,36,238,180,47,
  226,179,34,237,190,45,233,189,29,242,198,37,225,178,32,230,184,38,
  227,180,33,220,170,45,206,143,33,189,127,16,178,120,25,181,125,16,
  212,146,33,211,145,32,208,152,35,211,156,39,200,145,28,218,163,46,
  211,148,37,198,120,20,235,162,60,186,166,38,160,175,34,191,194,43,
  183,165,22,245,211,68,184,123,10,180,119,9,237,201,61,232,207,46,
  228,227,39,231,201,47,180,121,16,211,133,24,209,157,18,207,174,40,
  198,181,41,207,162,33,178,134,4,235,203,56,255,227,80,208,169,35,
  200,162,29,217,184,42,209,182,33,219,192,43,242,215,66,246,218,68,
  215,145,24,197,127,6,188,124,9,226,187,43,212,203,17,231,230,45,
  216,212,50,199,193,45,181,167,22,197,177,26,202,190,36,215,193,51,
  221,149,23,218,132,25,194,130,16,193,123,16,243,201,55,224,224,54,
  246,222,60,201,143,17,217,128,12,210,146,10,228,164,28,218,165,25,
  212,180,33,207,192,51,218,181,48,196,133,9,210,146,22,208,143,27,
  205,139,26,207,141,28,216,150,37,208,145,29,211,158,30,196,143,15,
  183,143,21,204,164,41,212,176,29,219,183,35,237,206,22,240,210,25,
  226,204,31,225,203,30,219,192,47,200,174,28,242,220,46,253,232,59,
  246,225,48,246,221,67,223,189,27,254,221,59,219,166,37,219,161,61,
  180,114,2,201,135,22,211,155,39,203,148,31,206,151,34,206,151,34,
  185,121,10,192,114,14,206,136,33,192,157,33,220,179,57,223,186,28,
  254,199,48,205,148,13,186,103,0,216,180,41,213,204,34,224,229,34,
  228,192,43,177,116,17,211,129,30,225,147,38,216,164,25,200,174,37,
  213,157,30,184,114,14,189,120,19,228,176,35,203,150,10,176,153,14,
  185,167,27,206,183,38,211,184,35,236,209,60,226,199,50,228,200,52,
  206,151,24,222,147,26,217,141,21,205,167,34,202,204,47,208,204,42,
  219,195,37,234,204,46,232,202,45,254,227,78,208,181,32,199,164,30,
  208,153,26,198,132,19,202,136,23,205,120,13,197,153,32,213,191,53,
  172,177,8,242,229,65,242,207,51,210,132,1,195,129,12,199,141,16,
  215,158,32,230,177,49,210,157,29,206,146,30,183,122,7,220,152,51,
  212,147,32,220,161,37,203,150,17,207,158,12,220,179,40,214,172,34,
  223,198,35,236,211,48,236,211,46,246,225,39,242,223,23,225,202,24,
  250,227,53,242,219,45,246,231,66,182,164,21,225,213,35,240,227,50,
  206,193,19,213,200,26,237,224,50,239,226,52,242,218,50,225,197,50,
  226,180,34,238,192,45,225,172,44,171,115,8,222,166,56,228,173,56,
  205,146,31,221,155,42,214,148,35,213,148,27,238,177,35,223,161,24,
  227,165,28,194,149,22,179,130,26,228,178,49,225,200,20,232,207,36,
  208,155,17,210,148,40,211,152,21,223,180,24,225,201,61,176,169,45,
  167,138,21,174,124,19,219,152,32,202,144,18,200,162,29,192,159,24,
  214,180,46,216,174,49,182,136,16,231,183,56,206,155,14,197,146,6,
  217,182,48,188,135,8,218,146,25,197,159,26,156,157,12,172,165,23,
  207,175,35,203,152,2,238,189,38,231,204,55,255,232,83,218,183,50,
  204,149,22,216,150,37,205,139,26,203,141,26,197,128,16,187,142,11,
  204,187,25,175,185,13,213,201,37,237,209,58,220,158,40,191,109,14,
  180,98,3,199,146,18,205,152,24,209,168,45,199,158,36,178,116,13,
  187,122,7,221,164,29,223,173,20,247,203,31,252,217,34,252,218,35,
  239,217,34,233,211,29,213,188,23,255,236,51,255,237,38,251,228,50,
  255,237,42,255,240,46,252,241,53,243,228,63,252,243,44,252,243,44,
  247,234,60,247,234,60,236,223,49,254,242,68,242,221,32,235,211,42,
  227,205,32,254,232,58,237,190,39,231,178,49,207,152,35,170,115,1,
  214,155,40,229,163,50,189,123,10,212,147,26,247,186,44,242,180,43,
  221,159,22,175,169,51,148,138,42,165,134,19,232,176,26,204,179,9,
  221,168,30,215,177,39,230,196,36,213,214,43,163,182,27,161,177,45,
  196,190,66,211,184,71,193,148,20,214,156,30,209,171,38,222,172,43,
  236,181,54,229,167,48,195,127,14,220,156,36,217,166,25,227,175,35,
  223,211,57,244,212,65,213,179,32,206,156,15,218,171,40,196,163,36,
  197,158,35,200,145,28,212,158,38,220,170,22,252,202,53,211,160,19,
  210,159,18,213,160,30,209,156,26,218,144,23,216,142,21,215,137,28,
  202,153,12,225,195,39,255,227,70,248,237,61,255,229,81,203,145,12,
  197,114,10,193,124,3,199,149,20,226,184,56,203,157,48,188,138,17,
  229,180,35,222,184,26,217,193,23,253,232,43,238,218,25,250,230,37,
  243,217,61,186,157,18,235,209,49,255,235,74,252,242,46,252,242,46,
  252,244,37,252,244,37,252,242,46,252,242,46,255,249,42,255,249,42,
  255,245,61,252,240,56,253,243,47,252,242,46,255,247,61,252,241,55,
  235,224,38,249,238,51,245,222,49,225,202,30,214,180,16,225,184,39,
  197,151,19,198,143,24,197,139,36,212,146,33,223,157,44,215,148,28,
  189,162,48,129,137,18,160,167,49,172,135,30,194,138,20,226,164,40,
  213,179,21,248,210,57,229,186,56,182,167,36,170,178,40,195,195,60,
  194,173,45,178,148,24,216,170,31,205,166,33,189,149,17,205,146,29,
  191,126,13,186,129,6,214,163,35,215,161,32,230,170,26,225,167,8,
  211,162,21,249,226,76,246,236,82,209,182,33,198,149,7,209,157,15,
  215,163,27,199,144,27,207,152,35,223,169,43,219,165,39,216,165,24,
  224,173,32,223,173,20,220,170,18,219,145,24,218,144,23,215,137,28,
  205,155,14,222,143,24,217,138,19,213,167,30,255,246,71,245,213,50,
  213,156,21,214,155,29,226,143,25,176,128,13,203,162,24,235,210,36,
  249,230,32,244,224,27,252,232,39,248,231,24,249,229,36,250,230,37,
  254,234,43,234,210,38,249,227,45,254,232,49,252,242,46,252,242,46,
  252,244,37,252,244,37,252,242,46,255,247,51,255,249,42,255,249,42,
  252,240,56,252,240,56,247,237,41,252,242,46,253,245,36,222,214,5,
  252,244,35,252,244,35,255,235,39,255,240,46,255,229,43,238,201,33,
  235,192,46,205,150,30,189,130,28,206,140,27,216,150,37,226,160,39,
  165,138,24,159,146,34,197,183,72,160,126,4,176,116,26,178,135,26,
  246,231,90,223,180,50,164,117,9,212,153,37,213,176,53,189,145,24,
  215,149,36,232,174,38,217,190,24,210,193,53,202,184,44,202,165,40,
  189,147,26,207,173,42,206,178,42,221,183,46,232,168,41,217,149,44,
  194,158,24,190,133,6,176,121,5,252,224,86,247,213,65,229,178,37,
  202,148,16,192,125,21,196,129,24,207,143,19,239,175,51,224,167,28,
  205,169,22,213,184,46,208,182,22,202,161,17,204,160,39,200,150,9,
  220,146,13,220,145,22,198,120,19,213,171,50,239,200,58,220,159,19,
  208,143,25,216,153,22,197,131,22,217,159,28,234,199,41,254,233,44,
  248,228,35,246,231,36,252,242,46,249,237,41,254,234,41,254,234,41,
  254,234,41,254,234,41,247,237,41,251,241,45,255,247,51,244,234,38,
  254,234,41,253,233,40,237,227,31,255,247,51,255,245,61,255,245,61,
  252,240,56,252,240,56,249,239,43,252,242,46,248,238,42,252,242,46,
  252,242,46,252,242,46,252,244,38,247,239,32,253,236,36,253,231,49,
  196,165,13,212,171,38,203,158,30,197,140,33,188,131,23,199,148,29,
  210,183,56,174,149,31,179,131,21,212,158,41,213,182,57,193,151,29,
  209,143,29,192,113,13,204,152,22,214,161,33,227,174,46,220,179,35,
  218,177,34,236,188,26,235,187,25,216,202,33,198,180,33,191,151,20,
  195,190,46,198,203,55,218,178,46,229,160,41,173,116,9,199,140,34,
  205,158,28,219,193,56,182,169,39,200,168,31,217,168,26,240,189,48,
  212,159,21,222,158,32,212,148,23,214,150,26,208,144,20,209,149,33,
  196,156,32,209,180,41,213,187,27,224,187,21,212,171,28,179,175,18,
  201,172,23,205,153,22,184,128,20,182,117,4,207,146,11,246,185,45,
  214,149,31,204,136,38,214,149,29,230,176,21,247,217,35,255,239,45,
  249,229,36,255,241,46,252,242,46,253,242,46,254,234,41,250,230,37,
  249,229,36,249,229,36,233,223,27,247,237,41,252,242,46,250,240,44,
  255,236,43,254,234,41,242,232,36,248,238,42,255,245,61,255,245,61,
  252,240,56,240,228,44,248,238,42,252,242,46,252,242,46,251,241,45,
  247,237,41,252,242,46,252,244,38,252,244,37,255,243,26,255,241,37,
  248,230,43,237,226,40,231,217,33,243,214,68,132,96,0,197,158,55,
  211,149,54,163,115,5,200,129,26,229,153,44,197,144,26,171,102,10,
  198,105,21,205,127,27,204,152,22,228,175,47,220,167,39,235,198,32,
  254,217,51,239,191,29,235,187,25,207,193,24,217,199,52,190,200,51,
  191,206,55,204,204,58,209,169,37,199,130,11,195,138,31,206,151,41,
  191,142,23,204,174,49,202,198,55,215,193,55,211,158,30,219,155,31,
  217,154,25,217,155,18,217,155,19,223,159,35,223,159,35,204,128,18,
  194,118,8,206,145,17,197,157,22,203,163,16,218,181,13,200,183,43,
  171,152,13,196,154,33,214,151,37,229,167,30,214,152,15,229,168,17,
  193,128,3,209,169,20,215,178,9,230,206,26,249,227,48,255,238,49,
  253,233,40,255,244,49,243,233,37,241,230,34,254,234,41,254,234,41,
  253,233,40,255,239,46,252,242,46,243,233,37,251,241,45,255,247,51,
  250,230,37,245,225,32,251,241,45,243,233,37,246,236,40,246,236,40,
  248,238,42,247,237,41,252,242,46,252,242,46,251,241,45,243,233,37,
  252,242,46,252,242,46,252,244,38,252,244,37,252,243,44,252,242,46,
  251,242,41,247,239,32,248,240,30,250,238,53,200,178,58,181,138,54,
  190,132,22,222,145,41,230,156,32,218,144,23,240,162,63,209,116,31,
  200,105,21,187,118,26,212,146,32,219,166,26,245,215,67,231,207,36,
  230,206,35,228,183,29,240,175,27,229,189,32,214,194,31,201,201,46,
  199,180,51,189,142,27,187,132,15,186,131,15,187,130,23,189,134,26,
  255,213,72,239,213,66,229,225,79,192,170,32,185,132,5,206,142,18,
  219,156,27,222,160,23,212,150,14,226,162,38,217,153,29,216,140,30,
  199,123,13,202,138,32,183,140,27,191,147,24,203,162,16,213,173,41,
  205,164,32,195,157,13,208,148,12,222,160,23,217,155,18,187,147,0,
  235,198,28,243,229,50,248,237,38,252,234,31,254,235,34,249,229,34,
  249,229,36,252,238,43,246,236,40,249,237,41,254,234,41,254,234,41,
  254,234,41,249,229,36,250,240,44,252,242,46,252,242,46,243,233,37,
  238,218,25,255,240,47,249,239,43,244,234,38,255,247,51,254,245,49,
  242,232,36,250,240,44,249,239,43,252,242,46,249,239,43,252,242,46,
  249,239,43,246,236,40,252,244,38,252,244,37,247,238,39,250,240,44,
  252,243,43,252,244,37,252,244,37,252,243,44,215,203,24,176,138,18,
  167,107,7,221,144,40,224,150,26,206,131,11,192,114,16,179,108,16,
  186,115,23,175,106,13,212,146,32,221,190,42,221,213,58,227,200,50,
  205,178,29,213,165,34,230,161,36,215,148,22,211,163,31,194,148,29,
  185,118,26,206,139,40,188,133,16,192,137,21,180,123,16,196,139,32,
  238,204,45,227,193,34,217,192,30,253,231,70,239,203,51,205,144,7,
  216,141,13,207,144,11,220,160,9,211,149,12,220,158,21,218,164,43,
  188,130,30,196,142,15,203,148,21,213,158,21,215,157,41,197,156,24,
  207,166,34,237,163,42,238,164,43,219,157,16,185,144,4,223,183,35,
  239,202,33,247,229,25,255,241,37,252,244,37,252,244,37,252,244,37,
  252,244,37,252,244,37,252,244,37,237,229,22,255,248,41,255,249,42,
  252,244,37,255,248,41,255,249,42,255,249,42,255,249,42,255,249,42,
  248,249,49,250,251,51,255,249,42,255,249,42,255,247,51,251,241,45,
  248,238,42,255,247,51,252,242,46,252,243,47,246,234,50,243,231,47,
  252,242,46,252,242,46,252,244,38,250,242,35,251,243,36,252,244,37,
  252,244,37,252,244,37,252,244,38,255,247,51,246,236,40,217,198,26,
  202,155,39,186,127,24,218,137,34,203,114,0,206,112,24,189,132,28,
  198,165,54,228,173,44,175,102,2,207,187,67,216,191,52,212,174,48,
  172,165,28,205,174,35,216,143,18,220,158,22,211,145,36,213,146,38,
  210,144,32,200,138,25,202,159,39,224,206,77,205,200,67,203,177,50,
  208,149,19,225,166,36,219,168,35,206,158,24,212,166,27,217,156,19,
  235,160,32,215,153,19,227,168,16,223,161,24,216,154,17,211,160,16,
  212,158,36,179,145,11,196,162,28,215,162,24,206,149,33,224,141,23,
  212,129,11,228,154,33,224,150,29,192,125,13,224,186,27,239,203,33,
  241,208,16,254,236,32,255,241,37,252,244,37,252,244,37,252,244,37,
  252,244,37,252,244,37,252,244,37,255,249,42,252,244,37,255,249,42,
  252,244,37,255,249,42,255,249,42,255,249,42,255,249,42,255,249,42,
  250,251,51,250,251,51,255,249,42,255,249,42,255,247,51,255,245,49,
  255,245,49,255,247,51,255,247,51,254,245,49,244,232,48,249,237,53,
  252,242,46,252,242,46,247,239,33,252,244,37,252,244,37,252,244,37,
  252,244,37,252,244,37,252,244,38,255,247,51,252,242,46,253,235,52,
  245,206,38,200,144,24,187,102,28,196,125,20,213,145,22,218,164,38,
  208,178,44,211,200,57,207,132,31,180,108,26,171,143,25,161,170,48,
  167,160,44,176,162,37,201,145,34,202,134,33,207,142,25,211,149,17,
  222,160,27,220,162,28,218,178,38,191,171,24,214,190,44,210,168,27,
  205,162,18,219,177,33,206,152,24,211,156,30,229,166,43,207,140,19,
  216,149,27,216,149,26,233,165,42,216,163,35,218,165,37,233,183,32,
  247,197,46,212,185,41,196,164,42,177,158,29,174,156,26,204,162,41,
  218,155,19,228,161,35,196,125,30,197,157,9,250,214,44,239,219,26,
  254,234,41,243,235,28,252,244,37,252,244,37,252,244,37,252,244,37,
  251,243,36,251,243,36,252,244,37,255,249,42,252,244,37,254,246,39,
  255,249,42,255,249,42,255,249,42,255,249,42,250,253,42,250,253,42,
  250,253,42,250,253,42,248,249,49,250,251,51,255,247,51,231,221,25,
  242,245,34,250,253,42,255,249,42,255,249,42,255,247,51,255,247,51,
  252,242,46,244,234,38,248,240,33,252,244,37,252,243,44,252,242,46,
  252,243,43,252,244,37,252,244,37,252,244,37,255,249,42,252,242,46,
  249,239,43,235,190,37,194,121,18,206,153,25,219,166,38,225,167,25,
  222,160,44,231,136,52,190,95,11,178,128,29,168,150,40,176,134,44,
  177,112,30,206,126,37,202,122,33,188,132,19,209,157,23,232,182,32,
  242,192,41,240,189,44,229,178,37,212,161,20,216,165,24,221,170,28,
  250,227,77,246,223,72,226,195,43,252,221,69,224,185,35,239,196,47,
  210,166,22,187,141,11,205,159,29,208,155,27,221,168,40,220,170,19,
  247,197,46,238,187,23,222,167,26,189,150,28,194,155,33,201,160,38,
  235,172,36,196,150,19,183,139,0,255,219,51,248,215,23,237,217,24,
  255,239,46,252,244,37,251,243,36,252,244,37,248,240,33,252,244,37,
  252,244,37,252,244,37,252,244,37,252,244,37,255,249,42,245,237,30,
  255,249,42,255,249,42,255,249,42,255,249,42,250,253,42,250,253,42,
  250,253,42,250,253,42,246,247,47,250,251,51,255,247,51,253,243,47,
  250,253,42,250,253,42,255,249,42,255,249,42,255,247,51,255,247,51,
  252,242,46,248,238,42,252,244,38,255,252,45,247,238,39,250,240,44,
  252,243,43,252,244,37,252,244,37,252,244,37,255,249,42,255,247,51,
  249,239,43,250,229,47,235,185,55,200,147,19,202,149,21,231,148,35,
  205,119,29,168,94,2,196,122,31,200,155,54,176,118,21,188,124,42,
  191,106,31,189,109,20,197,117,28,198,142,29,211,159,25,238,188,38,
  240,190,39,226,176,31,207,156,15,227,176,35,220,169,28,215,164,22,
  252,228,78,255,234,84,210,198,36,179,167,3,186,161,5,178,142,6,
  217,183,59,215,196,57,199,178,40,210,167,39,204,161,33,172,146,7,
  190,164,25,171,153,38,198,179,65,156,123,8,194,165,27,225,172,44,
  230,180,29,211,161,15,239,216,40,243,223,30,247,227,34,247,239,32,
  251,243,36,253,245,38,248,240,33,255,249,42,255,249,42,252,246,30,
  252,246,28,252,246,30,251,241,45,255,248,68,253,242,51,255,250,38,
  255,249,42,255,249,42,255,247,51,255,247,51,255,249,42,255,249,42,
  255,249,42,255,249,42,250,253,42,250,253,42,250,253,42,250,253,42,
  250,253,42,250,253,42,255,247,51,250,240,44,252,244,37,255,249,42,
  255,249,42,255,249,42,252,244,37,252,244,37,246,235,44,248,236,52,
  244,232,49,246,236,42,252,245,33,252,244,37,255,249,42,255,249,42,
  252,244,37,252,241,53,247,232,67,236,217,62,200,151,49,201,120,37,
  183,100,30,203,118,26,236,155,40,208,153,34,201,146,27,200,130,9,
  188,114,15,182,118,31,194,133,27,224,143,12,218,167,27,230,181,40,
  218,167,26,245,194,53,227,176,35,224,175,34,214,173,29,205,162,19,
  206,162,19,223,180,36,219,186,30,221,189,32,208,196,36,169,170,22,
  168,161,28,190,171,32,207,186,46,223,183,36,218,178,30,223,175,59,
  206,158,42,198,162,33,171,134,6,226,193,78,178,149,11,214,161,33,
  221,171,20,253,207,42,240,220,24,255,235,42,245,225,32,252,244,37,
  252,244,37,248,240,33,255,249,42,255,249,42,252,244,37,252,246,30,
  252,246,28,252,246,30,251,241,45,222,210,30,255,246,55,252,245,33,
  252,244,37,252,244,37,255,251,55,255,247,51,255,249,42,255,249,42,
  255,253,46,255,249,42,250,253,42,250,253,42,250,253,42,250,253,42,
  250,253,42,250,253,42,255,247,51,255,245,49,248,240,33,255,249,42,
  255,249,42,255,249,42,255,249,42,252,244,37,255,249,58,217,205,21,
  227,215,32,247,237,43,255,250,38,252,244,37,252,244,37,248,240,33,
  252,244,37,252,244,35,252,241,55,239,223,48,188,142,21,199,115,52,
  192,113,19,187,126,7,214,157,15,235,186,26,243,195,35,221,176,27,
  208,159,32,185,144,32,216,178,46,207,178,30,215,179,33,228,178,37,
  224,173,32,216,165,24,216,165,24,232,183,42,228,187,43,200,159,15,
  191,156,41,211,163,35,215,165,21,214,166,19,224,175,32,194,145,6,
  208,164,24,216,184,39,214,179,36,233,175,34,217,158,17,230,180,27,
  230,180,27,238,177,50,239,178,51,202,166,35,222,187,53,206,161,33,
  225,185,33,251,229,28,254,236,31,254,235,33,254,235,33,252,246,29,
  252,246,29,252,246,29,255,251,34,255,249,41,255,249,42,254,247,39,
  249,241,33,254,247,39,252,244,38,252,243,40,241,232,28,247,239,31,
  252,244,37,255,249,42,251,252,43,251,252,43,251,252,42,251,252,42,
  251,252,42,251,252,42,255,250,42,255,250,42,255,250,42,255,250,42,
  255,248,50,255,252,54,254,246,36,255,249,39,255,249,42,255,249,42,
  255,249,42,255,249,42,255,249,42,255,249,42,255,247,50,255,246,52,
  254,246,48,252,243,39,252,244,36,252,244,37,252,244,37,255,248,46,
  255,248,46,255,249,45,255,248,47,237,226,41,214,194,37,188,113,29,
  226,135,36,223,178,33,231,190,23,255,203,55,252,193,45,255,201,61,
  179,162,10,206,198,43,222,197,44,212,192,41,225,173,33,224,171,24,
  216,166,16,237,183,30,255,202,46,244,193,35,237,204,43,218,184,36,
  169,139,27,197,150,25,201,146,18,215,162,34,223,171,37,222,171,30,
  220,169,28,209,158,17,210,159,18,242,180,43,232,170,33,226,176,25,
  211,161,10,222,158,34,207,143,19,212,159,31,234,181,53,225,184,39,
  255,224,56,254,236,32,254,236,32,254,236,32,254,236,32,252,246,28,
  252,246,28,252,246,28,252,246,28,252,244,36,247,239,32,243,235,28,
  243,235,28,255,249,42,255,249,42,255,249,42,252,244,37,255,249,42,
  255,249,42,255,249,42,250,253,42,250,253,42,250,253,42,250,253,42,
  250,253,42,250,253,42,255,249,42,255,249,42,252,244,37,252,244,37,
  247,237,41,222,212,16,254,243,50,255,252,58,255,249,42,255,249,42,
  255,249,42,255,249,42,255,249,42,255,249,42,255,248,49,253,244,48,
  252,243,43,252,244,37,252,244,37,252,244,37,255,249,42,255,247,63,
  255,250,66,255,245,61,255,245,61,250,238,55,227,212,51,218,169,35,
  197,119,21,237,171,48,249,187,42,196,132,8,189,125,1,208,181,32,
  215,206,51,184,200,49,199,193,49,198,145,5,221,172,31,225,175,26,
  240,190,39,251,196,41,242,184,25,244,188,31,254,203,61,174,117,1,
  201,163,43,209,153,30,223,159,33,221,158,31,227,170,36,211,160,19,
  202,150,9,213,158,15,226,170,29,221,176,32,222,177,31,222,169,23,
  220,169,22,220,151,35,203,134,18,206,140,17,231,164,41,195,152,0,
  254,229,40,254,236,32,254,236,32,255,239,35,254,236,32,252,245,33,
  186,28,225,182,34,212,187,24,228,187,24,229,187,26,227,179,44,199,
  241,233,26,253,246,39,255,249,42,255,250,42,252,250,40,253,251,42,
  108,39,184,108,39,184,108,39,184,108,40,183,108,39,184,108,39,184,
  108,39,184,108,39,184,253,251,42,219,29,119,219,29,119,219,29,119,
  255,249,46,253,246,43,210,198,18,241,229,49,255,252,45,255,249,42,
  219,29,119,219,29,119,219,29,119,255,249,42,42,177,38,42,177,38,
  42,177,38,42,177,38,42,177,38,42,177,38,42,177,38,238,226,45,
  254,240,70,212,79,5,212,78,5,250,240,49,239,225,57,247,221,44,
  181,122,8,190,118,8,216,145,26,201,144,28,221,177,57,199,204,54,
  215,193,52,209,150,43,219,145,31,219,137,13,235,186,51,231,187,41,
  218,172,25,237,189,37,219,171,16,230,180,28,208,152,20,217,161,35,
  200,177,28,208,164,22,208,156,16,208,158,17,229,179,38,219,168,27,
  225,184,42,203,192,49,190,176,34,214,163,33,203,152,22,190,148,15,
  224,183,50,213,159,42,207,153,36,222,158,34,221,157,33,248,200,38,
  254,234,41,254,238,34,254,238,34,255,241,37,254,236,32,186,28,224,
  185,29,221,187,24,229,187,24,229,187,24,229,187,24,229,187,24,229,
  183,39,214,253,245,38,255,249,42,255,250,42,250,253,42,250,253,42,
  108,39,184,108,39,184,108,39,184,108,39,184,108,39,184,108,39,184,
  108,39,184,108,39,184,250,253,42,219,29,119,219,29,119,219,29,119,
  255,249,42,255,248,41,251,241,46,254,245,50,252,244,37,255,249,42,
  219,29,119,219,29,119,219,29,119,255,249,42,42,177,38,42,177,38,
  42,177,38,42,177,38,42,177,38,42,177,38,42,177,38,250,239,48,
  255,241,71,212,79,4,212,79,4,250,240,47,241,227,55,246,224,41,
  225,170,44,214,148,35,224,158,45,223,156,43,201,157,36,179,125,16,
  170,115,8,184,122,21,185,148,17,210,167,36,210,168,37,224,194,49,
  210,181,33,228,200,46,253,228,69,252,224,68,247,218,69,219,190,42,
  189,178,4,236,219,47,253,227,73,254,210,65,205,155,22,218,158,34,
  222,155,36,202,148,31,169,112,0,197,124,25,193,134,30,202,155,48,
  180,130,37,198,169,47,211,169,39,212,156,30,210,156,14,252,219,47,
  254,235,35,254,242,37,254,243,37,255,241,37,187,25,228,187,24,229,
  187,24,228,187,25,228,187,24,228,187,24,229,187,24,229,187,24,229,
  179,35,204,255,248,45,255,249,42,255,250,43,250,251,48,250,251,48,
  108,39,184,108,39,184,108,39,184,108,39,184,108,39,184,108,39,184,
  108,39,184,108,39,184,251,246,38,219,29,119,219,29,119,219,29,119,
  219,29,119,255,251,36,252,244,35,252,244,35,254,248,41,255,249,42,
  219,29,119,219,29,119,219,29,119,255,249,42,42,177,38,42,177,38,
  42,177,38,42,177,38,42,177,38,42,177,38,42,177,38,254,243,59,
  255,244,67,211,79,4,212,79,4,254,246,52,250,236,65,250,234,57,
  228,197,57,181,127,30,185,125,16,192,111,3,204,155,36,207,105,26,
  193,104,20,203,164,46,196,215,56,191,202,52,201,167,33,206,169,27,
  246,224,74,246,236,79,229,221,63,197,190,34,208,196,50,243,219,78,
  175,157,16,181,162,21,209,194,53,195,164,28,184,136,11,194,129,16,
  232,156,46,211,156,39,206,152,34,211,174,50,201,184,53,173,151,26,
  153,128,24,174,148,28,192,148,14,204,151,23,237,187,36,240,218,37,
  254,238,34,252,244,37,252,244,37,255,241,37,185,28,223,187,24,229,
  187,24,229,187,24,229,186,25,227,186,26,226,187,24,229,187,24,229,
  187,25,229,180,36,205,255,249,42,255,250,43,250,251,51,250,251,51,
  108,39,184,108,39,184,108,39,184,248,238,42,248,238,42,253,243,47,
  250,253,42,250,253,42,253,246,39,216,33,115,219,29,119,219,29,119,
  219,29,119,218,31,117,253,246,39,252,244,37,255,249,42,255,249,42,
  219,29,119,219,29,119,219,29,119,255,249,42,254,247,40,254,248,41,
  42,177,38,42,177,38,42,177,38,251,231,38,254,234,41,238,228,33,
  255,247,52,212,79,5,213,80,4,255,247,53,246,232,60,246,233,59,
  236,219,69,157,109,21,183,160,42,193,192,57,203,202,67,195,156,53,
  169,131,28,198,171,58,196,194,53,208,183,46,226,181,51,219,173,33,
  237,210,61,238,229,74,245,239,83,237,229,76,221,194,58,203,156,27,
  186,153,51,178,151,47,155,149,24,171,156,34,192,155,38,210,147,35,
  226,153,43,203,146,30,209,154,31,207,189,45,195,198,47,194,196,49,
  198,197,64,203,171,45,214,168,30,215,162,34,253,205,54,240,218,37,
  255,240,36,252,244,37,252,244,37,254,240,36,187,24,228,186,25,226,
  186,25,227,186,27,224,255,245,65,255,248,54,187,25,228,187,24,229,
  187,24,229,186,27,224,255,249,42,255,250,43,250,251,51,250,251,51,
  108,39,184,108,39,184,108,39,184,253,246,48,255,252,55,251,244,47,
  250,252,45,250,252,45,255,249,39,218,30,118,219,29,119,219,29,119,
  219,29,119,219,29,119,255,249,39,252,245,35,255,248,41,255,249,42,
  219,30,118,219,30,118,218,31,117,255,249,42,253,245,38,254,247,40,
  42,177,38,42,177,38,42,177,38,255,240,47,253,233,40,252,244,36,
  255,249,41,212,79,4,213,79,5,255,247,51,252,240,61,255,243,68,
  246,229,79,152,98,6,183,185,58,209,197,67,223,174,57,173,102,9,
  188,117,24,175,141,42,195,155,44,215,150,31,206,150,28,198,158,14,
  212,187,34,228,215,61,214,202,48,212,194,44,219,172,38,239,179,51,
  186,137,20,177,147,25,179,161,33,170,151,23,171,142,15,195,140,32,
  209,136,44,191,125,13,193,128,1,207,140,17,199,152,22,218,179,47,
  228,189,57,223,172,31,218,167,26,188,135,7,250,200,49,244,222,41,
  255,237,33,252,244,37,252,244,37,185,28,224,187,24,229,187,24,228,
  185,31,218,248,238,45,255,247,54,250,249,61,185,31,218,187,25,228,
  187,25,227,185,28,221,255,249,42,255,250,43,250,251,51,250,251,51,
  108,39,184,108,39,184,108,39,184,250,251,51,250,251,51,250,251,51,
  250,251,51,250,251,51,255,251,33,219,29,119,219,29,119,219,29,119,
  219,29,119,219,29,119,219,29,119,255,251,33,252,244,37,255,249,42,
  219,29,119,219,29,119,219,29,119,255,249,42,255,249,42,255,249,42,
  42,177,38,42,177,38,42,177,38,241,221,28,249,229,36,242,232,36,
  255,250,54,213,79,5,212,78,5,255,247,51,253,243,47,243,230,56,
  244,227,77,203,146,39,174,123,14,176,123,14,174,117,10,191,131,16,
  204,143,29,212,157,41,208,152,36,204,151,24,226,173,45,233,195,43,
  212,176,20,216,179,29,202,164,19,214,173,29,220,169,28,208,156,16,
  227,182,34,212,188,31,210,179,35,195,159,18,204,171,21,219,167,55,
  183,108,36,202,139,28,221,157,31,222,142,24,209,147,25,194,136,10,
  188,130,4,213,162,21,231,180,39,241,189,59,224,176,24,249,227,46,
  255,241,36,247,239,32,252,244,37,186,26,225,187,24,229,187,24,229,
  186,28,224,252,245,33,252,245,32,251,249,60,246,244,57,184,29,221,
  187,25,228,186,26,224,180,43,205,255,250,44,255,255,56,250,251,51,
  108,39,184,108,39,184,108,39,184,250,251,50,250,251,50,250,251,50,
  255,255,55,250,251,50,255,251,33,219,29,119,219,29,119,219,29,119,
  219,29,119,219,29,119,219,29,119,255,251,33,255,249,41,255,249,41,
  219,29,119,219,29,119,219,29,119,255,249,42,255,249,42,255,249,42,
  44,177,37,42,177,38,43,177,38,254,235,41,248,229,35,242,232,36,
  255,245,49,212,78,5,213,79,5,255,247,51,252,242,46,248,235,61,
  244,227,77,194,141,34,213,125,31,204,128,29,194,156,42,209,188,44,
  206,185,39,231,179,43,212,160,24,216,165,19,235,183,38,231,179,30,
  233,179,29,234,179,35,228,171,32,232,177,36,225,174,31,227,175,35,
  177,127,12,200,173,31,198,211,49,184,203,38,210,213,44,214,185,42,
  212,166,49,203,159,35,205,162,37,194,151,23,179,132,26,199,151,32,
  199,151,32,222,170,35,219,167,33,207,165,27,240,198,60,254,231,58,
  255,240,41,247,239,32,246,238,31,187,26,227,187,24,229,187,24,229,
  187,25,229,252,244,37,248,240,33,243,231,46,238,226,42,183,30,216,
  187,24,229,187,24,229,184,30,220,250,251,51,250,251,51,250,251,51,
  108,39,184,108,39,184,108,39,184,250,253,42,250,253,42,250,253,42,
  250,253,42,250,253,42,255,251,33,219,29,119,219,29,119,219,29,119,
  219,29,119,219,29,119,219,29,119,219,29,119,255,251,33,255,251,33,
  219,29,119,219,29,119,219,29,119,255,249,42,255,249,42,255,249,42,
  42,177,38,42,177,38,42,177,38,252,242,46,230,220,24,239,229,33,
  255,245,49,211,78,4,212,79,6,255,247,51,255,247,51,248,235,61,
  235,218,69,162,115,15,171,100,29,185,114,24,215,179,57,212,175,43,
  185,151,0,238,188,37,231,181,30,237,177,29,242,182,34,226,175,24,
  221,171,20,220,168,24,228,173,34,232,181,36,221,177,28,212,165,34,
  209,159,44,196,169,27,204,207,48,203,207,48,206,202,42,212,186,23,
  223,184,18,225,188,23,223,185,24,179,136,8,183,136,31,178,150,24,
  168,140,14,215,160,46,190,134,20,162,117,0,227,182,64,194,167,14,
  255,236,58,252,244,37,246,238,31,184,30,219,187,24,229,187,25,227,
  252,244,37,252,244,37,254,246,39,255,245,59,247,235,51,181,41,205,
  187,24,229,187,24,229,186,29,224,250,251,51,250,251,51,255,255,56,
  108,39,184,108,39,184,108,39,184,108,39,184,108,39,184,108,39,184,
  250,253,42,250,253,42,255,251,33,218,31,116,219,29,119,219,29,119,
  218,30,118,219,29,119,219,29,119,219,29,119,219,29,119,252,246,28,
  219,29,119,219,29,119,219,29,119,247,239,32,255,249,42,255,249,42,
  42,177,38,42,177,38,42,177,38,255,247,51,252,242,46,255,245,49,
  255,245,49,212,79,6,212,79,5,255,247,51,255,247,51,252,239,65,
  245,228,78,168,121,21,174,103,32,200,133,42,205,131,21,213,156,31,
  223,168,23,230,180,29,230,180,29,233,173,25,232,172,24,220,170,19,
  220,170,19,212,171,23,235,199,53,206,174,27,233,207,70,199,170,51,
  239,194,15,239,191,32,212,187,29,209,188,27,207,182,28,205,178,29,
  220,193,40,233,193,32,241,181,27,225,170,17,228,171,38,228,176,42,
  200,148,14,213,167,38,187,138,31,161,115,4,214,168,57,231,204,53,
  255,240,41,247,239,32,186,28,224,187,25,229,187,24,229,186,27,224,
  251,232,32,255,231,45,230,226,32,253,242,57,249,237,53,252,250,54,
  186,26,226,187,24,229,185,29,221,250,253,42,250,250,53,254,252,74,
  108,39,184,108,39,184,108,39,184,108,39,184,108,39,184,108,39,184,
  250,253,42,250,253,42,255,251,33,216,33,114,219,29,119,219,29,119,
  255,251,33,219,29,119,219,29,119,219,29,119,219,29,119,252,246,28,
  219,29,119,219,29,119,219,29,119,246,238,31,255,249,42,253,246,39,
  42,177,38,42,177,38,42,177,38,255,247,51,255,247,51,255,247,51,
  252,242,46,212,79,5,211,79,5,255,247,51,255,247,51,252,239,65,
  232,215,65,250,209,82,230,166,47,214,140,19,244,173,30,214,145,14,
  252,186,34,237,182,32,237,182,32,221,164,25,219,162,23,210,167,23,
  224,183,39,238,215,65,195,184,30,235,228,71,240,242,79,238,238,75,
  236,191,12,231,183,24,236,193,41,241,200,46,251,218,67,240,213,64,
  203,179,31,223,201,55,206,165,23,223,189,29,231,194,54,220,171,16,
  211,162,7,233,166,44,229,158,58,174,128,17,207,161,50,235,211,39,
  255,239,19,252,244,37,187,24,229,187,24,229,187,24,229,187,25,228,
  255,236,58,235,205,39,254,247,74,255,246,63,242,230,46,252,250,54,
  186,28,223,187,24,229,186,29,223,250,253,39,250,254,36,250,251,53,
  108,39,184,108,39,184,108,39,184,108,39,184,108,39,184,108,39,184,
  250,253,42,250,253,42,255,251,33,219,29,119,219,29,119,219,29,119,
  255,251,33,219,29,119,219,29,119,219,29,119,219,29,119,219,29,119,
  219,29,119,219,29,119,219,29,119,255,249,42,255,249,42,255,249,42,
  52,175,33,42,178,39,45,177,35,251,241,45,255,247,51,252,242,46,
  252,242,46,212,78,5,212,78,5,255,247,51,255,247,51,252,239,65,
  243,226,76,245,207,59,217,157,17,242,168,47,244,173,30,204,157,18,
  228,185,25,233,198,42,236,201,45,227,191,45,212,176,30,220,181,36,
  196,155,11,190,154,8,188,156,9,240,212,57,248,232,55,255,240,62,
  234,184,36,240,190,42,237,186,44,221,170,29,237,205,58,224,203,52,
  197,180,30,168,160,14,185,176,30,196,177,38,210,191,52,223,193,45,
  208,157,16,224,171,43,214,161,33,201,145,35,237,208,67,241,219,39,
  246,224,43,251,233,29,187,24,229,187,24,229,187,24,229,187,24,229,
  187,25,227,186,26,225,187,26,226,187,25,227,186,26,226,184,33,214,
  186,26,225,186,28,222,184,31,218,255,249,41,255,251,33,255,251,33,
  108,39,184,108,39,184,108,39,184,253,248,25,253,255,47,250,252,44,
  250,253,42,250,253,42,250,254,36,219,29,119,219,29,119,219,29,119,
  255,251,33,219,29,119,219,29,119,219,29,119,219,29,119,219,29,119,
  219,29,119,219,29,119,219,29,119,255,248,45,255,251,32,255,249,42,
  42,177,38,42,177,38,42,177,38,255,247,40,255,249,42,252,244,37,
  252,244,37,212,78,5,211,79,4,255,245,49,255,247,51,255,244,69,
  216,195,68,251,216,70,248,189,50,231,167,41,231,171,22,213,172,31,
  234,196,34,246,219,48,200,170,19,214,173,29,218,176,32,209,159,18,
  217,166,25,222,171,30,216,166,25,249,203,56,250,216,52,241,207,43,
  220,166,39,210,157,30,213,162,24,225,174,33,222,175,33,217,175,31,
  243,211,60,216,211,43,216,210,45,205,186,47,219,200,61,206,199,44,
  209,181,32,224,171,43,208,155,27,211,159,25,244,219,55,246,224,43,
  255,234,53,251,233,29,187,24,228,187,24,229,187,24,229,187,24,229,
  187,24,229,186,25,228,187,24,229,187,24,229,186,26,225,187,25,228,
  187,26,225,187,25,227,183,39,204,255,249,41,255,251,33,255,251,33,
  108,39,184,108,39,184,108,39,184,255,252,29,250,249,62,250,249,62,
  250,253,42,255,255,47,250,251,53,219,29,119,219,29,119,219,29,119,
  255,251,33,255,251,33,219,29,119,219,29,119,219,29,119,219,29,119,
  219,29,119,219,29,119,219,29,119,252,240,58,255,249,38,255,249,42,
  42,177,38,42,177,38,42,177,38,255,249,42,255,249,42,255,249,42,
  252,244,37,212,78,5,211,80,3,255,247,51,255,247,51,252,239,64,
  195,174,47,235,221,68,254,218,73,250,190,41,251,194,23,238,197,56,
  243,205,44,228,178,19,216,163,24,230,167,30,229,166,29,225,172,32,
  222,171,30,211,171,27,216,183,36,215,186,39,212,191,43,203,181,34,
  183,107,0,209,133,23,189,126,15,204,164,30,213,185,36,254,211,71,
  227,169,33,231,203,48,254,229,57,218,190,31,240,213,54,206,176,33,
  143,110,0,193,126,21,212,145,41,212,157,38,251,228,55,253,231,50,
  214,192,11,248,230,26,187,24,228,187,24,229,187,24,229,187,24,229,
  187,24,229,186,25,228,187,24,229,187,24,229,186,26,225,187,25,228,
  187,26,225,187,25,227,183,39,204,255,249,42,255,249,42,252,244,37,
  108,40,178,108,39,184,108,39,184,255,254,20,251,248,72,250,251,52,
  255,250,33,255,247,53,250,251,51,219,29,119,219,29,119,216,34,114,
  252,246,28,255,251,33,219,29,119,219,29,119,219,29,119,219,29,119,
  219,29,119,219,29,119,219,29,119,179,153,0,241,229,34,254,247,40,
  42,177,38,42,177,38,42,177,38,255,249,42,255,249,42,255,249,42,
  255,249,42,212,79,5,213,81,4,255,245,49,252,242,46,247,232,68,
  250,231,92,250,209,65,239,202,35,255,212,50,242,194,32,241,194,29,
  240,189,46,226,176,27,226,176,26,232,173,35,222,162,24,218,166,26,
  225,174,33,214,181,34,198,192,36,202,210,49,222,227,67,209,213,54,
  196,116,29,186,106,18,210,147,39,249,209,75,239,221,80,207,177,52,
  200,150,32,211,157,31,215,163,20,228,177,26,219,169,18,230,178,43,
  199,145,29,226,162,35,217,153,27,203,148,29,242,219,46,255,236,55,
  238,216,35,254,236,32,187,24,228,187,24,229,187,24,229,187,25,228,
  187,26,226,186,25,228,187,25,228,187,26,227,187,25,229,187,24,229,
  187,24,229,187,25,229,186,25,225,183,32,215,252,244,37,252,244,37,
  109,41,175,108,39,184,108,39,184,255,254,20,250,251,52,250,255,33,
  255,251,34,255,247,53,250,251,51,219,29,119,219,29,119,216,34,114,
  255,251,33,254,249,31,252,246,28,219,29,119,219,29,119,219,29,119,
  219,29,119,219,29,119,219,29,119,233,211,28,242,230,28,255,249,42,
  44,177,37,42,177,38,42,177,38,255,249,42,255,249,42,255,249,42,
  255,249,42,211,81,4,211,80,4,250,240,44,252,242,46,243,232,45,
  237,222,60,238,197,53,240,203,37,220,168,29,232,180,42,222,171,29,
  227,173,53,190,137,10,225,172,44,221,184,39,216,179,34,222,193,45,
  207,180,31,218,193,43,207,201,45,203,207,48,206,189,37,229,209,58,
  222,160,30,203,137,27,183,121,13,237,197,62,233,215,53,251,235,83,
  247,228,92,243,215,79,209,163,32,192,131,9,223,139,45,210,144,31,
  215,149,36,219,155,31,220,156,32,252,211,80,235,221,54,241,230,43,
  252,240,57,247,239,32,187,24,229,187,24,229,187,24,229,255,239,46,
  255,239,46,252,242,46,252,242,46,255,247,51,255,247,51,246,225,43,
  185,27,223,187,25,229,187,24,229,184,29,221,254,236,40,251,229,53,
  108,39,184,108,39,184,108,39,184,245,248,37,250,255,32,250,255,32,
  250,253,42,250,253,43,250,251,51,219,29,119,219,29,119,219,29,119,
  252,246,28,252,246,28,255,249,42,219,29,119,219,29,119,219,29,119,
  219,29,119,219,29,119,219,29,119,252,244,37,252,244,37,254,247,40,
  42,177,38,42,177,38,42,177,38,255,247,51,255,247,51,252,244,37,
  255,249,42,211,81,4,211,80,4,254,242,46,255,229,41,245,223,41,
  252,226,68,254,231,83,242,218,47,216,181,24,210,149,22,231,153,30,
  193,134,26,179,147,24,209,181,37,210,183,34,255,236,87,250,232,77,
  222,202,63,177,155,30,186,167,27,203,182,25,232,193,38,230,190,37,
  218,183,23,212,172,33,231,177,45,243,207,49,240,226,42,252,240,66,
  253,242,88,248,242,98,208,184,46,197,157,32,202,140,42,185,119,6,
  208,142,29,201,137,13,229,165,41,202,160,26,226,204,87,142,123,0,
  251,240,53,252,244,37,187,24,229,187,24,229,187,24,229,254,234,41,
  253,233,40,251,241,45,252,242,46,252,242,46,254,244,48,253,233,50,
  204,182,3,186,26,226,187,25,229,186,26,227,249,229,34,190,167,0,
  108,39,184,108,39,184,108,39,184,250,253,42,250,251,51,255,255,56,
  250,249,61,234,233,45,243,244,44,219,29,119,219,29,119,219,29,119,
  252,246,28,252,246,28,253,245,34,252,246,28,219,29,119,219,29,119,
  219,29,119,219,29,119,219,29,119,252,244,37,255,249,42,255,249,42,
  42,177,38,42,177,38,42,177,38,255,251,55,255,247,51,252,244,37,
  255,249,42,211,79,4,211,80,4,254,242,46,255,222,34,249,224,64,
  255,236,100,203,175,27,252,230,60,252,221,42,215,159,9,208,156,2,
  186,153,16,221,189,66,211,183,39,217,168,27,222,172,31,205,164,17,
  207,164,33,202,157,40,193,152,19,206,166,16,237,198,43,255,218,62,
  219,178,34,204,163,19,222,158,21,224,173,32,236,196,45,238,210,49,
  241,225,69,245,231,100,188,192,54,218,200,58,209,173,36,234,181,54,
  217,163,36,193,142,3,204,153,12,152,105,2,181,159,42,224,194,61,
  247,225,44,255,241,35,187,24,229,187,24,229,187,24,229,254,236,32,
  255,237,33,235,225,29,252,242,46,252,242,46,252,242,46,222,211,25,
  235,223,39,184,30,218,187,24,229,185,28,224,252,242,45,246,234,55,
  108,39,184,108,39,184,108,39,184,255,255,56,255,254,66,255,254,66,
  255,245,61,248,236,52,237,227,31,219,29,119,219,29,119,216,35,114,
  254,248,30,252,246,28,255,239,35,252,246,28,219,29,119,219,29,119,
  219,29,119,219,29,119,218,31,118,252,244,37,255,249,42,255,249,42,
  42,177,38,42,177,38,42,177,38,255,247,53,252,242,48,252,244,37,
  255,249,42,212,78,5,212,79,5,254,243,37,255,224,25,249,224,65,
  207,169,61,221,178,47,221,182,27,244,207,39,253,216,49,250,244,62,
  222,189,37,227,174,46,212,159,31,226,173,45,209,156,28,214,170,39,
  204,161,30,186,142,17,193,149,28,204,159,34,188,135,4,233,182,49,
  233,192,48,225,184,40,219,173,30,211,182,34,209,189,43,205,194,49,
  173,176,30,165,172,34,147,173,29,157,159,30,173,155,33,221,171,22,
  236,186,37,234,183,42,222,171,30,212,169,39,194,175,37,235,208,53,
  249,231,27,255,236,53,187,24,229,187,24,229,187,24,229,254,236,32,
  255,241,37,252,242,46,252,242,46,252,242,46,252,242,46,253,242,56,
  249,237,53,186,26,226,187,24,229,186,25,226,248,242,22,252,243,42,
  108,39,184,108,39,184,108,39,184,255,255,56,255,254,66,250,249,61,
  255,250,66,255,245,61,255,248,52,219,29,119,219,29,119,219,29,119,
  252,246,28,252,246,28,254,236,32,254,236,32,252,246,28,219,29,119,
  219,29,119,219,29,119,219,29,119,252,244,37,46,177,37,42,177,38,
  42,177,38,42,177,38,42,177,38,42,177,38,42,177,38,252,244,37,
  252,244,37,255,247,51,252,242,46,254,243,37,255,225,26,254,233,53,
  161,126,0,228,185,54,206,167,12,243,203,56,220,179,33,229,196,45,
  199,140,19,207,154,26,232,179,51,209,156,28,219,166,38,220,176,45,
  203,160,29,245,201,76,205,161,40,201,154,36,187,131,21,211,153,43,
  213,178,32,231,177,37,229,166,20,250,245,79,201,169,32,178,146,23,
  202,173,47,178,174,31,162,176,27,168,177,29,183,192,44,213,190,44,
  212,169,30,210,159,18,208,157,16,215,187,51,220,192,56,251,225,67,
  254,232,52,255,234,64,187,24,228,187,24,229,187,25,228,252,244,37,
  252,244,37,252,244,37,252,244,37,252,247,24,253,245,41,235,224,38,
  252,240,56,187,26,227,187,24,229,186,26,226,252,246,28,252,246,28,
  108,39,184,108,39,184,108,39,184,255,255,56,255,255,56,250,251,51,
  255,254,66,255,254,66,255,255,56,219,29,119,219,29,119,219,29,119,
  255,249,42,255,247,40,247,239,32,252,244,37,250,242,35,252,244,37,
  219,29,119,219,29,119,219,29,119,255,251,33,45,177,37,42,177,38,
  42,177,38,42,177,38,42,177,38,42,177,38,42,177,38,252,244,37,
  252,244,37,211,79,4,211,79,5,253,243,27,255,223,37,238,223,61,
  215,166,38,232,180,44,252,224,80,248,236,82,222,187,41,216,175,31,
  218,177,33,204,153,12,217,166,25,215,164,23,220,169,28,218,162,23,
  199,161,16,190,154,22,196,149,31,185,138,20,197,150,32,205,157,38,
  227,192,46,228,174,34,220,157,12,252,247,81,247,220,69,238,211,65,
  230,194,46,215,166,17,227,197,41,223,188,35,236,201,48,209,190,20,
  224,185,21,229,178,37,194,143,2,194,142,14,192,141,13,238,212,55,
  245,223,43,239,215,45,186,29,224,186,28,226,186,28,226,252,244,37,
  252,244,37,252,244,37,252,244,37,252,247,24,255,249,44,255,246,60,
  253,241,57,181,42,210,187,24,229,182,39,210,252,246,28,255,250,32,
  108,39,184,108,39,184,108,39,184,255,255,56,255,255,56,250,251,51,
  250,249,61,255,254,66,255,255,56,219,29,119,219,29,119,219,29,119,
  255,249,42,255,249,42,252,244,37,252,244,37,245,237,30,252,244,37,
  219,29,119,219,29,119,219,29,119,255,251,33,47,176,37,42,177,38,
  42,177,38,42,177,38,42,177,38,42,177,38,43,177,38,252,244,37,
  250,242,35,212,78,5,212,78,5,253,243,27,255,223,37,255,242,80,
  204,155,27,252,205,44,234,210,41,238,203,57,234,177,38,220,179,35,
  244,203,59,219,168,27,222,171,30,225,174,33,225,174,33,235,179,40,
  209,171,26,216,195,45,235,215,66,218,199,50,223,203,55,233,211,61,
  239,200,45,210,171,16,220,177,23,232,206,47,253,240,63,223,201,18,
  244,221,43,223,197,38,209,182,24,221,186,40,250,237,83,248,223,40,
  253,229,46,225,194,36,234,180,30,230,189,47,228,161,49,235,195,48,
  244,207,37,249,225,55,250,230,37,245,225,32,255,239,46,252,244,37,
  252,244,37,252,244,37,246,238,31,255,252,29,252,244,39,255,254,60,
  255,245,49,255,245,55,224,212,29,253,242,56,252,244,37,255,249,42,
  250,253,42,250,253,42,255,255,47,255,255,47,255,255,56,250,251,51,
  255,247,51,255,247,51,255,247,51,255,251,32,255,251,33,255,251,33,
  255,249,42,255,249,42,255,249,42,252,244,37,252,244,37,252,244,37,
  255,248,41,243,235,28,255,251,34,255,251,33,255,251,33,253,248,30,
  252,246,28,252,246,28,252,246,28,252,246,28,252,246,28,252,244,37,
  252,244,37,255,249,42,255,249,42,253,241,35,255,226,27,255,242,82,
  216,171,44,241,191,40,218,192,33,240,186,50,210,156,21,215,191,31,
  223,178,25,226,190,44,230,194,48,217,166,25,215,164,23,206,165,21,
  192,151,7,255,236,75,253,243,65,251,254,78,255,249,93,212,206,49,
  232,193,38,227,188,33,234,191,37,234,208,49,229,210,47,247,222,59,
  246,221,59,249,223,64,221,193,35,223,188,42,255,253,99,255,248,79,
  252,245,76,251,242,77,255,227,69,213,172,30,227,161,48,165,121,1,
  209,169,21,234,210,40,255,238,45,244,224,31,253,233,40,247,239,32,
  252,244,37,252,244,37,245,237,30,252,247,24,252,244,39,255,247,53,
  245,235,39,254,245,45,245,236,33,252,244,39,255,249,42,255,249,42,
  250,253,42,255,255,47,250,253,42,250,253,42,250,251,51,247,248,48,
  255,247,51,251,241,45,253,243,47,252,246,27,252,246,28,255,251,33,
  255,249,42,255,249,42,252,244,37,247,239,32,247,239,32,252,244,37,
  255,247,40,255,249,42,255,251,34,252,246,28,252,246,28,252,246,28,
  252,246,28,252,246,28,252,246,28,252,246,28,252,246,28,243,235,28,
  247,239,32,252,244,37,255,249,42,248,236,30,255,226,27,248,235,53,
  242,201,51,245,195,44,198,172,13,231,202,36,219,190,25,253,230,70,
  231,186,33,240,183,44,222,165,26,232,181,40,222,171,30,206,165,21,
  233,192,48,244,199,54,249,218,68,245,229,74,255,250,94,251,245,88,
  215,176,5,227,185,35,238,208,59,211,184,33,235,207,59,193,162,39,
  194,166,57,232,215,78,209,173,39,244,218,59,253,227,68,252,241,52,
  255,246,57,248,236,52,254,242,58,234,208,51,202,172,37,236,187,88,
  185,141,16,231,205,46,247,226,44,249,237,53,247,238,34,252,244,37,
  252,244,37,252,246,28,252,246,28,255,247,50,255,247,51,255,249,53,
  255,248,52,255,248,47,255,249,42,255,249,42,255,249,42,255,249,42,
  255,255,47,250,253,42,250,253,42,255,255,47,250,251,51,250,251,51,
  255,251,33,255,251,33,255,251,33,255,251,33,255,251,33,255,251,33,
  255,251,33,255,251,33,255,251,33,252,246,28,252,246,28,243,237,19,
  249,240,36,252,244,40,252,246,30,252,246,28,252,246,28,252,246,28,
  252,246,28,252,246,28,253,245,28,255,242,28,255,242,28,247,241,23,
  252,246,28,252,242,46,252,242,46,248,236,33,255,225,52,246,198,36,
  235,187,25,240,192,30,255,245,75,255,246,75,255,240,47,255,229,38,
  239,202,33,223,157,21,223,158,22,229,159,25,214,163,22,209,168,35,
  221,161,36,213,149,26,207,150,26,221,168,37,232,193,38,254,217,61,
  248,230,52,218,195,39,192,163,30,251,221,90,189,159,26,215,187,44,
  189,168,14,195,182,23,235,202,50,214,188,29,230,204,45,253,239,71,
  251,237,69,252,240,56,246,234,50,204,178,21,229,199,64,236,188,88,
  174,130,5,238,212,53,212,190,8,250,238,54,247,238,34,252,244,37,
  252,244,37,255,251,33,252,246,28,255,247,50,255,247,51,252,242,46,
  254,246,50,255,251,51,255,248,41,255,248,41,255,252,45,255,249,42,
  250,253,42,250,253,42,250,253,42,250,253,42,250,251,51,250,251,51,
  252,246,28,255,251,33,255,251,33,255,251,33,252,246,28,255,251,33,
  255,251,33,255,251,33,255,251,33,252,246,28,252,246,28,252,246,28,
  252,247,23,252,247,23,252,246,27,252,246,28,252,246,28,252,246,28,
  252,246,28,252,246,28,253,245,28,255,242,28,254,237,23,247,241,23,
  252,246,28,252,242,46,255,246,50,252,240,37,249,211,38,236,188,26,
  242,194,32,238,190,28,198,174,4,240,198,34,255,217,32,252,219,28,
  252,215,46,234,190,47,225,180,37,226,176,35,220,189,42,248,230,89,
  162,125,1,211,170,28,233,199,48,213,178,26,224,185,30,240,203,47,
  254,232,51,247,222,62,255,220,89,205,162,35,238,193,61,243,218,45,
  242,242,31,255,254,64,251,246,73,242,228,61,184,166,19,186,169,16,
  213,196,43,229,204,39,217,193,28,198,155,23,255,216,85,207,160,56,
  190,143,39,252,226,67,237,215,33,233,211,30,255,236,55,252,242,46,
  252,242,46,255,251,33,252,246,28,252,244,37,252,244,38,255,249,42,
  255,248,42,254,246,40,252,244,37,252,244,37,248,240,33,255,248,41,
  255,247,51,255,247,50,255,249,42,255,249,42,252,246,28,252,246,28,
  252,246,28,255,251,33,255,251,33,255,251,33,252,246,28,252,246,28,
  255,251,33,255,251,33,255,251,33,252,246,28,252,246,28,252,246,28,
  252,249,14,252,249,14,255,244,22,255,243,23,255,240,41,255,239,48,
  255,241,43,252,244,37,253,243,37,255,241,37,254,236,32,246,227,33,
  254,235,41,254,235,35,255,233,54,238,232,32,238,206,36,237,188,33,
  255,216,37,255,223,46,238,223,59,246,215,42,229,199,24,242,200,45,
  237,194,40,217,177,33,253,213,69,236,238,85,253,255,102,255,252,94,
  254,241,83,212,190,17,206,167,41,206,170,21,221,181,32,212,171,23,
  254,233,72,231,202,60,204,159,49,235,188,82,185,136,23,255,228,73,
  243,241,44,250,249,58,246,242,69,251,238,71,223,206,59,191,174,22,
  188,171,19,206,178,33,210,182,37,199,156,25,205,162,31,234,192,52,
  218,176,36,235,209,50,250,228,46,243,221,40,241,219,38,241,231,35,
  251,241,45,253,247,29,252,246,28,252,244,36,252,244,37,255,248,41,
  249,242,35,249,241,34,252,244,37,252,244,37,252,244,37,247,239,32,
  255,247,51,252,242,46,255,253,46,255,249,42,252,246,28,252,246,28,
  255,251,33,255,251,33,255,251,33,255,251,33,252,246,28,252,246,28,
  252,246,28,252,246,28,252,246,28,252,246,28,252,246,28,252,246,28,
  252,245,30,251,244,29,250,232,31,255,236,36,255,240,34,255,245,36,
  251,238,30,251,243,36,253,243,37,250,232,28,254,236,32,236,216,23,
  247,227,34,248,229,29,212,189,11,245,215,41,227,171,27,227,175,39,
  250,202,41,255,223,46,255,243,79,255,249,88,249,236,76,220,196,36,
  206,183,23,219,178,34,234,193,49,219,188,26,242,210,49,255,229,59,
  255,232,59,240,228,75,253,244,161,242,227,113,206,163,34,205,162,32,
  197,156,34,217,173,71,224,173,92,152,103,8,222,183,64,245,219,60,
  255,252,61,255,244,63,236,219,45,214,187,45,213,185,47,201,174,30,
  219,193,48,197,170,24,182,149,38,233,187,48,200,155,15,180,131,18,
  202,150,56,182,154,11,251,228,52,222,208,33,250,237,51,197,192,5,
  252,232,34,249,233,30,246,249,25,255,243,37,254,236,32,254,242,43,
  252,243,44,251,245,38,250,246,33,251,246,33,255,241,37,254,237,33,
  255,246,50,246,236,40,255,248,41,252,244,37,252,246,28,252,246,28,
  252,247,25,252,247,25,252,246,28,255,251,33,252,246,28,252,246,28,
  250,248,25,250,248,25,252,246,28,252,246,28,252,246,28,252,246,28,
  242,251,31,251,242,43,240,204,37,223,184,20,236,195,49,181,139,1,
  249,212,55,255,242,41,244,242,26,254,236,32,254,236,32,255,225,36,
  255,229,39,252,232,39,223,199,29,237,182,51,172,110,1,203,137,13,
  203,134,28,215,189,36,246,227,58,226,207,57,250,231,81,227,217,53,
  208,198,33,218,183,37,225,189,43,233,184,25,243,194,35,230,184,15,
  241,197,26,232,187,22,228,179,42,224,172,55,165,116,23,151,102,9,
  216,171,54,174,125,31,149,96,31,185,134,57,200,160,55,208,181,35,
  255,237,65,206,167,13,201,163,11,185,156,21,246,217,81,241,216,54,
  243,217,56,255,237,70,159,127,5,230,202,54,242,214,65,219,190,51,
  200,167,52,185,154,29,196,164,42,215,198,43,213,198,29,224,198,56,
  237,192,35,255,213,55,248,231,46,254,237,33,255,240,36,255,246,49,
  251,241,45,250,236,43,249,226,36,248,225,34,255,243,39,254,236,32,
  248,238,42,209,199,3,255,251,44,252,244,37,248,242,24,252,246,28,
  251,243,38,255,251,46,252,246,28,250,244,26,252,246,28,253,247,29,
  255,234,33,255,241,39,252,246,28,252,246,28,252,246,28,250,244,26,
  254,253,51,225,196,23,240,179,42,212,148,14,204,138,20,175,109,1,
  219,157,28,212,174,3,255,238,39,254,236,32,246,228,24,255,224,35,
  255,230,41,238,217,28,247,224,56,161,117,5,215,170,69,195,144,13,
  180,125,24,175,129,21,217,175,44,217,176,32,223,182,38,223,195,36,
  223,196,37,224,173,32,216,166,25,209,157,19,231,179,41,218,168,20,
  239,189,40,205,154,9,227,174,46,187,133,27,159,109,22,159,109,23,
  185,151,13,204,163,62,157,103,42,157,104,37,129,82,1,179,141,20,
  204,164,22,181,128,0,255,211,65,237,217,68,219,200,50,225,210,35,
  239,226,39,243,226,42,197,172,39,248,238,84,253,247,92,254,250,94,
  196,169,53,220,178,85,153,109,31,211,188,62,190,159,18,245,184,71,
  237,167,47,208,136,17,245,197,50,239,222,20,255,243,48,255,244,61,
  252,226,55,201,159,7,220,178,20,237,209,33,245,226,25,253,235,34,
  247,231,40,244,227,36,251,236,36,253,239,39,245,242,24,248,244,27,
  181,171,0,226,217,17,243,228,30,227,198,15,247,244,35,253,237,32,
  234,190,25,211,167,3,243,229,34,235,222,25,252,240,39,254,243,32,
  250,216,49,218,160,20,208,137,10,215,143,24,186,110,9,194,118,21,
  225,149,43,200,134,5,249,198,50,234,214,28,227,205,29,253,215,34,
  253,216,23,250,222,35,231,200,35,159,124,18,183,157,60,220,188,50,
  207,168,72,171,118,47,202,143,41,204,147,5,224,166,25,185,147,1,
  216,179,27,215,164,31,212,161,28,226,176,48,206,157,29,232,175,48,
  215,157,30,190,135,10,220,164,49,189,133,29,178,123,34,178,124,35,
  224,188,87,161,122,43,147,94,37,127,72,16,153,96,49,162,107,50,
  118,77,0,232,223,71,253,246,75,255,233,53,254,231,51,230,203,50,
  254,232,57,255,245,73,249,233,85,247,241,85,251,245,89,242,230,116,
  97,53,1,168,116,40,165,113,37,162,112,44,184,115,33,204,126,26,
  224,146,46,233,152,36,225,170,26,248,215,32,253,218,54,214,155,12,
  204,119,4,196,113,9,214,172,38,248,225,64,251,229,47,253,231,49,
  204,180,10,248,224,52,253,233,40,254,234,41,254,233,41,254,234,41,
  254,247,52,236,223,49,219,190,40,194,140,20,243,220,58,251,207,52,
  219,169,18,221,171,20,238,202,45,226,189,32,250,219,56,255,223,39,
  219,176,18,226,159,29,203,139,1,222,158,35,200,133,28,207,140,36,
  213,142,37,204,128,18,208,138,21,230,193,43,161,120,0,204,147,42,
  213,159,33,179,132,22,165,115,26,218,161,73,220,189,72,239,210,72,
  151,113,28,178,137,67,188,132,25,202,138,12,228,164,39,203,152,22,
  219,168,38,229,181,30,219,172,20,210,148,23,216,154,30,212,146,38,
  197,130,26,195,135,23,212,157,40,184,129,13,187,130,24,151,95,0,
  119,76,40,146,101,53,159,104,60,135,77,38,163,108,51,189,139,54,
  186,138,30,205,157,27,205,158,20,173,123,11,178,129,13,177,131,4,
  213,172,21,250,234,79,238,223,61,245,239,85,236,226,69,252,239,92,
  126,86,0,163,111,36,168,116,40,196,137,38,213,134,21,197,119,34,
  197,119,34,194,119,0,213,156,13,251,200,45,177,124,0,254,219,89,
  186,133,23,181,115,17,205,156,41,250,218,79,212,181,20,170,142,0,
  233,199,51,228,195,46,254,233,49,248,223,39,229,190,21,254,217,48,
  248,235,48,210,188,54,164,128,12,228,166,76,189,137,20,230,160,49,
  225,177,29,230,183,35,251,194,61,203,148,14,210,153,12,253,199,43,
  231,183,31,232,165,35,208,147,11,237,175,51,211,145,36,204,138,30,
  219,150,41,189,118,6,217,147,33,226,168,45,188,128,20,193,137,27,
  181,127,4,183,135,24,195,145,46,196,125,53,205,160,31,200,167,31,
  172,130,46,149,110,45,225,171,66,221,159,48,227,160,47,182,109,4,
  203,129,24,172,96,6,204,128,38,211,131,16,215,135,20,233,161,69,
  187,117,30,213,153,46,209,155,33,203,148,29,214,159,40,237,183,62,
  148,117,89,114,64,24,152,96,37,143,89,27,143,91,17,182,134,36,
  205,160,43,184,136,35,136,84,5,154,98,45,167,115,42,235,188,82,
  223,180,51,233,211,89,216,191,92,158,138,22,220,181,50,227,180,74,
  116,61,3,159,105,47,155,101,43,162,103,28,205,127,38,192,123,30,
  193,124,31,215,151,23,207,143,15,214,154,34,203,141,22,209,157,45,
  228,160,57,195,115,14,185,109,6,187,112,11,201,139,49,197,154,58,
  174,113,33,217,156,74,192,149,23,235,192,65,193,152,6,196,156,10,
  197,160,21,232,193,61,234,191,69,211,146,32,200,133,29,186,119,15,
  197,154,28,237,194,69,219,165,44,236,182,60,183,120,0,212,149,20,
  210,145,27,216,151,34,218,164,37,192,139,11,239,179,54,200,136,12,
  249,188,66,236,181,64,232,176,61,188,130,31,174,116,17,188,133,20,
  192,133,41,166,105,25,189,132,29,205,164,22,236,199,34,229,184,69,
  160,106,40,95,62,7,203,153,72,171,115,17,214,139,26,220,142,42,
  217,139,39,222,144,44,216,138,38,225,147,47,228,150,50,191,121,27,
  194,125,32,203,144,34,200,146,25,195,140,26,178,120,17,212,159,37,
  134,103,75,103,53,14,144,92,14,184,133,50,181,130,48,196,147,49,
  203,158,42,236,189,88,147,96,14,160,109,21,155,109,1,157,107,20,
  202,155,47,128,98,15,114,81,19,133,85,16,169,105,21,171,122,36,
  125,68,29,141,83,44,152,94,56,155,93,36,191,112,40,200,131,37,
  198,129,36,210,144,33,220,154,43,211,127,33,197,112,20,192,133,29,
  240,174,71,202,112,24,233,137,58,182,90,8,197,138,31,162,122,9,
  174,116,18,188,129,32,170,121,31,156,107,16,232,189,62,250,206,79,
  213,152,53,208,152,23,167,123,4,196,131,18,206,139,35,193,126,22,
  212,164,60,170,122,19,172,114,16,217,160,59,198,131,21,224,158,48,
  204,135,38,225,157,58,221,166,43,192,139,11,254,195,71,200,136,13,
  197,136,15,174,119,2,166,110,0,206,145,63,208,147,66,216,160,48,
  194,135,44,146,83,21,202,142,61,210,163,59,192,148,22,189,140,45,
  139,83,34,149,118,39,179,125,66,169,111,32,236,159,65,237,160,60,
  203,125,25,214,135,35,213,134,33,232,155,54,221,144,44,250,181,87,
  196,126,33,190,128,31,190,131,30,191,132,33,189,132,28,205,152,29,
  156,133,82,116,76,11,184,136,38,193,143,56,115,63,0,195,145,57,
  197,149,47,151,100,20,160,106,46,195,132,63,171,111,22,235,181,105,
  136,93,14,115,61,0,162,108,48,141,88,22,165,112,46,133,94,17,
  166,127,50,122,68,7,130,76,15,168,104,43,163,102,19,203,136,32,
  198,131,27,200,134,21,191,125,12,203,127,17,217,141,31,191,123,14,
  225,156,64,169,95,8,195,117,17,208,132,33,215,155,55,209,168,62,
  166,110,25,180,104,26,194,146,47,207,163,43,215,171,50,210,166,45,
  206,159,52,174,124,39,180,130,43,254,217,106,228,161,57,185,118,14,
  182,124,25,167,105,29,172,125,44,165,102,7,200,123,17,189,112,6,
  200,120,31,209,129,40,183,122,32,196,140,30,229,165,57,190,123,19,
  199,132,26,193,127,14,242,177,63,217,161,50,150,91,1,211,149,67,
  196,135,52,183,133,48,103,49,0,210,155,100,120,65,10,194,144,60,
  149,98,15,143,88,32,151,96,40,135,86,19,186,118,37,192,127,29,
  197,109,19,197,108,7,215,126,25,201,134,30,220,153,49,193,119,27,
  184,105,36,179,107,42,175,111,22,185,125,21,185,127,27,197,139,38,
  145,109,22,183,129,30,218,168,63,189,139,52,160,108,35,220,170,82,
  156,108,6,145,94,13,145,90,31,169,106,37,155,96,6,148,81,10,
  181,166,77,162,111,29,141,91,9,140,87,21,195,142,76,178,142,46,
  232,196,99,214,163,81,122,71,0,165,100,39,176,116,33,186,119,15,
  198,131,27,204,138,25,201,135,22,243,168,58,202,126,16,212,144,35,
  199,130,38,192,118,31,225,147,47,225,150,46,214,157,35,247,209,81,
  172,116,31,198,122,43,220,176,56,190,149,8,239,195,74,183,139,18,
  180,133,26,164,114,29,193,143,56,211,165,54,183,116,12,199,132,28,
  175,117,18,195,133,57,172,129,27,200,140,24,204,123,40,166,86,3,
  184,104,15,185,105,16,186,125,35,189,133,22,188,124,16,200,133,29,
  202,135,28,223,157,44,200,136,21,239,183,72,187,128,38,163,102,19,
  182,121,38,234,184,99,148,94,30,159,105,40,136,83,18,165,111,49,
  109,55,0,156,101,45,125,70,14,121,72,5,177,110,28,178,109,31,
  197,106,36,185,92,13,207,114,35,180,113,9,192,125,21,205,147,67,
  128,69,11,151,97,45,149,102,28,208,160,71,165,104,24,179,118,38,
  189,121,23,202,134,37,184,115,1,217,163,57,190,143,55,109,56,0,
  115,59,11,133,78,22,144,92,17,195,134,51,191,130,47,211,162,67,
  255,250,161,202,150,74,197,145,69,189,131,34,210,152,55,187,140,30,
  169,120,34,205,143,67,195,138,38,231,174,67,190,133,26,196,154,42,
  196,134,28,210,127,28,197,136,30,228,162,58,203,136,32,199,133,21,
  207,141,28,222,157,36,225,162,32,226,162,31,217,162,30,225,187,68,
  165,89,3,192,151,48,239,196,69,220,180,32,234,189,71,180,131,36,
  179,121,24,173,115,18,175,117,18,181,123,23,178,109,16,193,124,31,
  166,105,22,162,101,18,164,117,36,211,147,52,186,106,17,182,102,13,
  173,102,22,241,170,90,168,113,31,177,127,27,196,134,23,186,117,25,
  192,125,45,170,113,11,177,122,7,223,165,68,169,111,14,170,112,15,
  180,122,25,185,126,34,157,94,23,169,107,34,146,84,11,162,99,32,
  199,136,69,151,96,40,161,106,50,149,102,24,140,71,3,186,117,22,
  175,103,29,153,86,7,193,127,48,173,111,38,179,117,44,165,112,36,
  218,166,90,168,116,41,158,106,32,192,138,63,166,103,35,178,115,60,
  193,128,10,189,124,6,195,126,7,179,125,19,170,123,35,164,110,44,
  142,87,33,181,130,53,173,123,29,175,114,31,168,107,24,182,133,38,
  239,229,140,186,134,58,161,109,33,196,138,41,194,136,39,222,176,65,
  193,143,57,205,147,48,197,143,21,195,138,31,209,152,45,210,168,56,
  201,139,33,211,128,29,193,132,26,231,165,61,187,120,16,186,120,8,
  185,119,6,219,156,25,233,173,22,234,173,25,213,158,26,198,159,41,
  187,111,20,203,162,59,241,198,70,212,172,24,187,142,23,231,183,87,
  193,135,38,231,173,76,189,135,13,210,156,35,183,114,21,193,124,31,
  173,112,29,163,102,19,140,90,31,173,106,31,191,111,22,201,121,32,
  189,118,38,164,93,13,185,112,37,201,129,36,217,150,40,209,140,48,
  146,78,7,188,127,47,186,128,30,187,129,32,206,148,51,173,115,18,
  180,122,25,162,103,11,172,109,38,142,80,7,179,117,44,157,97,9,
  166,106,18,131,76,20,115,60,4,161,114,36,189,120,50,189,120,25,
  182,110,36,176,127,63,159,109,44,156,94,21,191,129,56,197,144,68,
  183,131,55,107,53,0,136,80,29,159,102,47,178,117,33,179,125,15,
  167,110,3,190,133,26,191,130,24,187,125,19,201,142,40,189,131,31,
  176,119,18,188,131,24,201,144,39,196,125,45,239,168,88,176,114,41,
  185,145,65,175,113,40,173,111,38,154,101,35,175,122,56,251,205,129,
  160,108,32,185,114,34,195,128,24,180,127,41,180,127,41,242,210,105,
  190,136,38,196,125,18,207,154,62,199,161,64,164,107,15,179,96,21,
  189,122,29,235,185,58,209,158,17,236,186,48,197,152,38,175,126,33,
  181,123,26,172,115,17,232,187,70,211,169,32,228,184,62,177,129,28,
  200,152,48,187,142,23,197,154,25,227,163,41,212,145,41,189,122,18,
  165,114,15,196,145,46,164,94,9,191,121,36,196,118,18,198,120,20,
  183,116,12,201,134,30,207,119,23,212,122,26,206,126,15,204,126,26,
  196,114,35,189,109,23,192,115,11,200,122,22,195,117,17,228,170,70,
  132,72,0,186,123,56,128,65,0,140,75,20,119,54,1,201,130,50,
  184,113,33,173,112,34,181,119,41,212,141,61,180,109,29,185,114,34,
  175,104,24,121,68,2,114,61,0,142,96,21,188,125,38,172,109,23,
  178,117,34,219,160,91,135,78,20,171,111,47,178,107,27,187,115,35,
  186,129,22,192,135,28,171,126,15,200,158,46,184,135,18,193,139,17,
  187,132,15,197,140,33,178,120,15,185,114,34,220,149,69,176,94,28,
  122,60,0,158,96,23,144,82,9,158,105,39,134,81,15,182,130,54,
  152,100,24,180,109,29,183,116,12,183,109,30,199,124,46,248,215,110,
  188,134,36,197,126,20,182,129,37,186,165,79,160,123,43,204,124,53,
  197,130,37,202,152,25,224,173,32,235,186,48,216,171,57,158,109,16,
  216,158,61,184,127,29,248,203,87,208,166,29,216,175,32,180,136,14,
  197,153,30,197,148,56,180,134,27,190,123,23,174,107,3,179,112,8,
  186,114,22,194,121,29,187,120,15,187,120,14,200,122,22,223,145,45,
  207,140,36,207,140,36,205,117,20,207,117,21,202,122,11,208,130,31,
  215,133,54,214,134,47,202,125,21,188,110,10,180,102,2,177,118,29,
  201,146,29,192,132,44,176,116,28,189,127,50,165,103,26,192,121,41,
  184,113,33,191,133,34,181,123,24,179,108,28,205,134,54,174,103,23,
  177,106,26,155,102,36,154,101,35,155,109,34,179,117,29,174,111,26,
  170,109,26,171,101,24,189,114,41,191,117,42,188,117,37,198,127,45,
  167,119,19,160,112,12,205,150,44,188,131,24,197,142,28,198,143,26,
  224,169,52,190,132,34,176,115,35,172,113,23,223,167,56,174,106,8,
  177,106,28,159,106,37,179,126,57,207,155,76,153,81,8,187,126,43,
  183,122,39,214,164,77,143,117,22,177,121,48,202,138,26,224,196,55,
  242,191,78,176,118,21,194,136,39,192,120,46,197,124,52,192,118,34,
  185,131,23,180,140,15,184,138,27,171,123,26,243,202,60,166,116,27,
  196,138,41,184,126,29,226,168,68,209,155,32,181,117,13,185,121,16,
  193,136,32,169,108,27,193,122,42,193,122,42,190,122,41,222,158,55,
  184,115,22,178,109,16,188,132,23,167,107,20,196,126,36,182,112,23,
  187,117,28,159,89,0,165,84,7,192,110,34,195,124,36,189,120,27,
  157,87,4,167,94,25,180,109,38,192,131,48,183,122,39,147,94,28,
  135,82,16,198,137,54,190,129,46,201,140,57,160,99,16,187,116,36,
  213,142,62,176,117,24,162,103,10,178,107,27,159,88,8,195,125,41,
  178,107,24,199,122,54,160,105,29,172,130,31,200,138,46,167,95,14,
  186,115,35,177,106,26,180,109,29,195,122,38,202,122,33,189,109,19,
  193,145,45,175,127,27,208,153,47,183,126,19,186,130,17,185,130,13,
  216,161,44,167,109,11,188,127,47,172,113,23,205,149,38,193,125,27,
  199,128,50,204,155,63,183,134,43,183,135,34,169,100,6,199,138,55,
  216,155,72,205,155,68,143,117,22,171,118,23,253,199,64,238,178,48,
  213,180,61,158,100,3,194,136,39,196,128,33,207,138,44,220,151,35,
  207,152,46,143,98,2,190,140,52,157,106,28,232,191,50,245,195,106,
  176,118,21,169,111,14,230,172,72,218,164,41,226,184,72,167,124,12,
  220,163,59,190,129,48,164,93,13,159,88,8,143,97,9,196,154,43,
  199,130,37,181,112,19,198,138,53,142,78,15,155,82,14,158,85,16,
  172,99,31,172,99,30,184,103,27,167,85,9,191,120,32,168,99,6,
  178,108,24,170,97,28,173,102,31,167,106,23,189,128,45,149,96,30,
  150,97,31,201,140,57,190,129,46,152,91,8,146,85,2,177,106,26,
  192,121,41,198,135,64,176,113,41,217,146,66,173,102,22,173,106,1,
  191,124,19,186,109,41,170,115,40,255,209,132,161,95,24,170,98,20,
  193,122,42,193,122,42,171,100,20,197,125,41,203,123,34,192,112,22,
  187,129,32,175,117,20,213,146,53,187,118,25,206,138,40,193,126,23,
  185,113,13,171,97,15,216,159,90,196,140,63,245,175,64,188,119,26,
  225,156,63,169,98,14,207,140,35,200,157,26,216,148,46,193,143,56,
  224,173,87,169,108,25,153,92,9,168,120,10,249,223,106,174,118,0,
  225,187,81,143,92,8,236,189,85,185,118,23,183,114,21,255,212,114,
  162,114,16,147,106,9,197,149,61,255,205,112,204,161,36,204,157,51,
  191,120,40,200,129,49,192,135,29,249,200,52,232,202,69,153,120,7,
  141,89,11,217,169,69,203,110,15,200,133,29,187,152,48,162,127,24,
  165,123,11,176,113,8,194,133,55,151,86,30,136,72,10,144,80,18,
  119,71,7,162,96,19,186,115,33,172,101,21,175,106,16,194,125,32,
  184,118,33,134,72,0,200,136,62,182,100,24,190,108,32,178,126,49,
  165,114,36,164,116,16,212,164,64,225,158,54,185,118,14,198,127,47,
  178,131,43,150,98,22,161,109,33,168,103,45,163,106,2,193,139,18,
  210,152,53,181,97,7,183,117,40,235,197,124,196,140,73,173,89,16,
  186,118,37,208,150,68,185,126,31,216,158,48,190,123,19,184,115,12,
  169,111,14,210,152,55,190,123,30,183,114,21,185,115,30,181,110,30,
  175,99,22,174,97,38,225,165,117,196,140,63,222,151,41,202,133,40,
  192,123,30,197,130,25,236,173,45,194,151,20,214,147,44,162,112,26,
  229,179,92,173,112,29,161,100,17,215,144,41,214,165,55,216,195,33,
  240,182,97,181,131,47,227,180,76,199,132,37,222,153,60,184,131,33,
  191,143,43,221,180,83,184,137,49,212,146,61,220,151,56,181,108,32,
  171,100,20,212,141,62,190,129,46,223,169,44,234,206,58,131,92,12,
  169,118,39,154,106,7,202,108,14,190,122,19,157,119,37,196,158,77,
  155,113,4,200,137,32,186,128,28,170,108,30,155,91,29,161,97,35,
  141,96,10,196,134,34,191,123,19,226,159,55,199,130,34,219,150,57,
  153,87,2,220,158,85,180,115,42,188,106,30,202,120,44,183,135,35,
  182,134,33,195,147,47,219,171,71,211,147,21,246,182,56,162,91,11,
  185,138,50,145,93,17,162,110,34,136,71,13,184,126,23,209,158,14,
  210,155,34,188,103,13,190,124,47,210,154,65,182,106,25,180,92,18,
  180,112,31,169,111,30,185,127,31,218,160,50,187,120,16,200,131,30,
  145,101,12,191,128,45,186,98,33,164,94,24,129,69,0,185,123,50,
  130,68,0,152,90,17,153,92,19,168,101,22,204,119,29,200,135,21,
  202,136,22,212,148,21,208,144,18,204,137,34,192,125,21,243,186,79,
  185,128,22,166,95,15,167,92,34,177,108,18,232,166,55,219,184,29,
  166,103,2,181,132,39,215,163,89,190,117,52,175,104,21,239,186,88,
  131,76,19,220,181,72,193,147,47,182,115,31,180,137,52,182,110,2,
  185,100,25,172,106,25,156,100,25,154,118,36,220,198,53,131,77,10,
  191,131,57,177,140,59,189,118,38,202,135,31,157,97,10,189,149,77,
  225,190,97,216,166,39,191,124,18,177,107,21,172,122,35,221,171,84,
  180,136,41,231,171,60,196,138,30,209,152,45,168,111,4,203,146,39,
  185,132,29,172,124,26,188,135,38,184,104,15,207,127,38,205,147,50,
  207,149,52,173,122,40,186,142,18,210,169,25,239,198,54,164,109,0,
  186,123,53,174,101,32,176,103,34,164,81,16,202,122,34,235,195,61,
  172,131,0,163,102,20,197,136,53,201,107,35,190,96,24,183,85,14,
  180,98,22,179,123,38,182,132,45,182,133,38,198,136,21,215,133,25,
  153,109,20,250,187,104,184,96,30,154,84,14,117,71,1,166,127,47,
  156,110,32,151,89,16,175,114,40,184,120,20,224,143,31,215,153,17,
  219,157,20,202,135,30,189,122,17,236,165,85,187,116,36,179,126,0,
  221,168,39,189,122,18,172,101,22,177,108,18,209,143,31,202,159,57,
  186,121,27,181,128,58,214,158,108,193,120,57,171,100,17,204,151,53,
  106,51,1,206,167,58,158,113,12,195,127,47,207,160,99,177,100,15,
  196,111,36,180,113,32,244,188,113,189,154,72,211,185,57,171,121,21,
  164,104,30,142,104,24,189,118,38,188,121,17,154,94,7,143,102,30,
  139,104,11,255,212,85,185,119,13,182,112,27,175,125,38,144,94,7,
  223,180,84,219,160,48,202,143,35,189,132,25,227,170,63,205,148,41,
  208,156,44,194,150,29,216,167,51,193,113,24,180,100,11,167,105,32,
  197,135,60,147,93,33,152,104,4,223,182,38,228,187,43,206,152,32,
  178,115,44,173,100,31,176,103,34,161,74,31,182,99,33,216,150,45,
  211,144,40,189,132,26,221,164,57,208,114,42,190,96,24,176,78,7,
  185,103,27,177,121,36,191,141,54,179,130,35,215,152,38,205,123,14,
  174,120,34,207,132,54,183,106,45,168,93,35,147,81,13,173,111,38,
  176,111,45,171,99,26,196,130,18,222,159,29,231,169,38,239,179,31,
  206,142,17,186,125,38,184,122,36,182,130,54,187,118,25,222,167,50,
  191,140,0,223,172,28,188,130,31,195,122,53,198,129,39,189,128,45,
  155,94,11,168,107,11,141,101,66,155,77,1,199,102,27,174,137,48,
  190,143,41,254,200,80,164,109,9,170,108,46,184,148,86,159,87,36,
  198,116,40,192,111,34,200,148,48,213,181,74,204,175,34,190,158,40,
  197,135,62,137,75,4,189,129,42,170,110,22,174,124,31,143,89,26,
  166,140,53,255,226,106,189,110,18,181,99,27,165,108,43,113,76,5,
  164,119,31,194,133,31,191,129,46,202,144,46,180,133,20,139,91,4,
  183,135,34,251,205,106,161,106,28,169,97,14,185,112,30,180,121,57,
  166,128,57,138,86,10,158,106,30,200,164,55,219,164,41,198,131,21,
  178,107,28,172,101,21,176,105,25,145,68,22,194,121,53,190,107,18,
  204,141,46,178,137,23,205,144,37,188,125,30,198,114,26,188,97,30,
  183,113,43,161,117,28,176,138,56,188,145,77,222,172,47,195,121,21,
  184,130,44,188,113,34,162,85,24,143,68,10,154,88,20,153,91,18,
  176,112,40,176,108,12,221,159,25,247,187,41,247,186,40,196,132,7,
  188,121,18,119,76,4,139,95,23,125,73,1,179,110,17,194,139,22,
  207,156,15,232,178,56,120,58,0,189,116,47,182,113,23,182,121,38,
  179,118,35,192,131,35,212,171,137,152,71,13,177,76,24,140,100,32,
  122,71,0,197,130,25,177,102,8,186,106,49,136,100,38,177,105,54,
  182,100,24,184,103,27,151,96,17,180,145,59,196,164,45,217,181,85,
  199,137,64,128,66,0,151,88,22,152,88,23,142,89,23,195,145,60,
  99,73,0,225,184,64,189,110,18,190,107,36,164,107,43,109,71,1,
  228,180,115,195,130,51,191,128,47,188,130,32,199,153,31,162,111,32,
  129,71,34,132,78,20,119,67,0,160,107,38,148,94,25,205,146,83,
  148,110,39,155,103,27,164,112,36,225,180,116,154,91,13,128,50,8,
  168,94,32,175,104,24,177,106,26,140,63,17,177,104,36,194,108,40,
  195,129,54,172,127,35,153,88,3,209,146,51,180,96,8,194,103,36,
  166,96,26,173,129,41,157,119,37,181,138,70,235,184,59,213,139,39,
  173,136,45,190,98,25,160,84,28,139,63,13,184,107,40,161,101,17,
  242,191,100,191,111,22,216,137,47,189,120,25,191,122,27,224,158,52,
  192,121,39,154,99,43,123,68,12,162,108,44,197,129,27,201,137,14,
  234,176,18,164,96,0,127,73,26,186,124,38,181,98,15,235,155,50,
  184,120,29,158,104,6,137,102,74,141,61,15,150,89,35,171,121,68,
  140,77,13,189,104,23,185,102,24,164,95,30,175,104,75,137,75,0,
  190,127,50,164,116,53,169,130,55,123,80,26,178,128,39,155,102,36,
  166,102,40,158,94,32,149,94,37,140,85,28,126,75,14,187,123,17,
  218,164,64,191,153,47,188,126,53,168,106,33,164,95,44,123,73,16,
  149,110,36,185,146,72,172,130,37,191,130,42,184,128,37,129,73,20,
  168,106,94,146,93,23,120,68,10,132,89,34,120,74,39,165,116,66,
  166,100,34,158,96,23,163,101,28,164,99,40,170,105,47,137,72,17,
  148,87,4,182,111,31,177,106,26,153,76,30,185,134,59,165,118,40,
  215,147,76,175,116,53,191,111,54,204,143,60,154,93,10,160,93,0,
  187,116,36,183,123,42,151,100,22,214,157,90,196,145,54,149,113,15,
  184,147,56,181,89,16,171,102,9,224,155,60,185,111,26,170,110,27,
  196,145,54,192,112,23,184,105,17,147,75,1,184,113,38,185,118,12,
  182,111,29,131,76,20,152,97,41,172,122,37,201,136,14,234,170,45,
  182,116,5,151,79,4,149,99,28,136,95,12,142,74,22,184,100,16,
  172,106,36,110,69,18,132,116,93,134,55,8,141,79,26,126,76,23,
  138,75,11,188,102,21,185,102,24,155,92,25,226,175,140,161,118,29,
  196,132,56,208,160,97,192,153,77,128,85,31,135,82,16,182,125,79,
  135,71,9,148,84,22,127,69,32,146,88,51,191,141,80,182,118,11,
  191,134,54,195,154,69,194,132,60,175,113,40,165,95,44,120,71,13,
  123,80,29,211,168,116,198,152,81,212,148,81,161,100,39,143,88,32,
  189,134,79,172,123,29,110,56,12,118,72,38,74,25,11,177,127,77,
  148,82,17,159,97,24,159,97,24,183,122,41,172,111,31,160,92,59,
  159,95,33,212,141,61,180,109,29,198,121,74,170,120,44,198,151,73,
  178,110,39,192,133,69,188,108,52,186,125,42,188,127,44,173,106,11,
  182,111,31,174,115,34,153,102,24,188,130,68,157,102,32,179,139,63,
  183,110,41,179,106,37,176,110,35,204,168,46,190,106,25,212,139,44,
  195,121,27,204,124,35,181,100,13,173,93,32,157,95,48,170,131,55,
  162,123,46,147,108,31,196,161,63,176,127,34,232,170,39,183,114,9,
  151,97,34,147,63,0,170,105,29,147,109,39,164,107,23,186,111,27,
  185,108,23,99,62,33,169,138,136,148,84,24,155,91,29,135,80,15,
  127,74,8,170,119,40,186,92,28,147,93,34,195,171,126,197,126,46,
  179,126,46,159,121,55,199,146,75,140,84,34,131,82,21,250,219,173,
  167,103,41,148,84,22,110,65,22,138,93,50,223,170,104,171,121,33,
  190,127,55,143,101,22,164,102,29,194,132,59,186,142,63,169,89,23,
  110,68,8,143,101,41,147,111,32,187,134,59,192,135,68,135,82,18,
  162,105,27,175,124,41,126,89,22,126,74,33,87,14,0,209,168,104,
  146,109,23,183,110,41,166,93,24,196,117,33,205,147,64,131,75,33,
  152,76,14,165,103,30,143,81,8,225,150,92,163,114,26,169,118,27,
  182,108,45,223,179,148,150,92,27,180,119,36,248,187,104,209,137,67,
  177,104,35,164,94,20,115,83,9,168,92,42,169,104,39,164,112,60,
  183,110,41,182,109,40,248,182,107,245,209,87,181,108,33,189,134,52,
  162,101,18,197,117,28,173,93,5,157,77,16,107,46,2,152,109,56,
  112,69,16,103,61,5,189,151,71,174,122,49,199,132,22,170,101,0,
  188,134,71,161,77,11,168,103,27,185,146,76,220,163,79,192,117,33,
  163,87,3,114,80,31,128,101,79,184,120,59,149,85,23,163,108,43,
  124,71,5,179,128,49,180,86,22,130,76,17,167,143,98,189,118,37,
  174,122,41,143,104,38,179,127,56,138,82,32,160,113,34,196,169,102,
  166,102,40,136,72,10,151,110,46,113,72,8,182,129,63,193,143,55,
  148,85,12,152,110,31,154,92,19,171,109,36,199,155,76,186,107,40,
  112,70,10,238,196,136,172,136,56,178,125,49,211,153,86,141,88,22,
  202,144,76,170,116,52,105,65,12,145,96,34,141,72,17,212,171,107,
  142,104,18,166,93,24,166,93,24,193,114,30,198,140,57,130,74,32,
  149,73,11,184,122,49,157,95,22,205,130,72,198,150,61,160,109,18,
  173,99,36,255,217,186,164,106,40,169,108,25,200,139,56,199,128,57,
  160,87,18,163,93,19,182,149,76,145,69,19,153,88,23,141,90,38,
  162,114,37,159,93,22,185,119,50,240,186,74,194,135,68,208,176,102,
  174,95,29,187,109,19,182,87,4,149,75,12,112,74,19,134,91,37,
  112,66,31,219,175,128,99,55,6,236,182,120,220,148,70,180,97,16,
  198,154,106,159,94,32,180,116,30,160,113,37,228,163,73,187,112,29,
  150,94,22,134,94,49,153,113,70,234,166,89,169,99,21,169,101,36,
  125,74,8,183,140,63,182,87,33,129,75,26,145,97,38,198,134,42,
  161,126,50,175,105,58,171,99,34,162,87,44,184,119,37,238,193,106,
  179,118,37,139,75,14,176,137,61,124,81,27,131,88,29,192,153,72,
  155,113,43,153,113,42,146,95,19,225,150,82,165,123,29,188,108,43,
  145,83,20,230,168,106,143,104,33,200,148,65,174,109,35,118,65,9,
  236,199,149,127,82,35,123,67,21,177,92,37,137,65,5,198,152,90,
  174,112,34,218,146,69,185,110,53,161,86,25,179,109,27,130,67,7,
  178,115,48,158,88,7,204,153,85,168,93,35,185,112,51,152,98,28,
  163,92,13,254,204,164,167,99,43,164,84,7,173,93,17,168,94,24,
  172,99,30,173,110,42,152,122,49,182,97,38,157,92,28,152,101,51,
  162,116,38,165,100,28,157,89,35,211,152,61,161,101,42,164,133,60,
  176,95,30,200,122,33,192,96,14,177,103,40,112,77,20,141,98,43,
  98,52,18,129,85,38,113,69,22,188,137,57,214,145,50,189,105,27,
  215,171,125,141,78,16,185,122,34,189,142,64,194,129,37,182,108,24,
  144,89,19,144,88,31,142,86,30,221,151,73,175,104,24,167,98,33,
  143,92,26,229,187,110,176,81,28,92,37,0,137,87,26,190,127,34,
  131,97,22,216,143,99,166,92,28,158,81,38,206,139,58,241,195,107,
  175,114,32,148,84,23,167,124,69,119,73,39,123,81,22,139,101,20,
  203,163,93,116,76,6,135,84,8,214,138,70,172,131,35,179,99,35,
  147,83,21,175,111,49,140,98,43,154,99,34,169,102,32,118,64,12,
  175,140,92,87,43,2,118,59,14,184,95,42,137,65,6,166,119,57,
  175,111,34,183,112,34,185,110,53,151,76,17,172,101,19,155,90,29,
  153,90,23,167,96,14,226,176,109,154,79,21,200,125,67,174,119,52,
  185,115,35,207,154,113,196,127,71,212,130,54,171,89,13,180,106,36,
  173,100,31,162,100,33,133,103,30,180,94,35,173,108,43,127,76,26,
  163,113,44,156,99,32,177,115,41,118,68,5,106,63,18,144,69,20,
  155,87,16,188,107,22,202,102,27,130,60,9,194,147,95,146,90,34,
  92,48,9,131,77,34,123,71,13,220,164,69,184,104,28,172,106,29,
  163,121,66,158,100,43,149,91,28,211,169,93,188,125,50,179,98,35,
  160,100,36,135,88,26,138,77,20,220,158,73,174,112,25,169,99,27,
  153,86,16,198,133,62,174,95,30,173,108,45,140,93,21,182,136,42,
  171,116,40,208,152,95,159,94,30,154,88,30,197,133,59,173,116,39,
  189,123,38,147,94,26,92,48,2,118,73,32,99,63,11,117,82,24,
  183,140,87,116,73,20,149,98,25,209,153,64,174,124,47,165,106,36,
  145,90,25,181,126,61,140,90,47,165,101,48,154,84,18,123,70,15,
  130,88,39,111,60,33,107,54,2,174,97,26,148,71,24,137,83,24,
  187,114,40,178,100,24,168,104,43,143,85,21,167,93,28,163,99,36,
  164,100,38,162,96,28,209,165,97,179,130,63,153,88,27,163,102,30,
  187,107,38,222,171,108,115,55,5,164,114,29,180,89,18,169,103,36,
  161,96,32,145,89,24,159,135,59,150,68,10,177,102,43,115,59,0,
  162,109,43,153,100,34,188,143,65,120,88,39,167,147,108,169,97,48,
  153,104,30,172,103,32,186,99,34,152,84,22,177,129,61,154,96,24,
  114,74,16,154,100,42,162,111,31,173,114,20,197,112,47,121,59,0,
  136,94,35,115,60,5,145,90,34,255,224,164,170,108,56,160,92,32,
  152,108,39,139,100,39,135,74,20,190,127,55,170,108,34,170,100,30,
  183,110,41,161,88,19,158,85,16,167,96,29,218,157,86,183,124,34,
  187,123,47,165,117,54,148,84,22,154,90,28,202,140,67,167,105,32,
  197,127,58,144,92,38,110,66,19,110,66,19,101,68,17,121,88,37,
  134,90,43,136,92,45,115,60,6,188,137,58,132,77,22,141,86,31,
  135,82,16,241,188,122,142,90,47,190,123,70,160,89,23,139,85,31,
  121,84,37,166,126,117,100,60,14,167,95,18,158,80,40,178,120,62,
  171,96,22,158,80,6,152,91,30,123,69,5,173,97,39,158,94,32,
  151,87,25,154,90,28,122,82,13,148,110,39,147,87,24,163,99,26,
  177,92,27,166,113,44,146,90,42,208,168,98,175,79,28,156,91,30,
  148,84,22,153,100,35,143,123,46,167,86,30,168,90,33,121,64,1
};

/** The *original* AFNI Sunburst logo image **/
/*
static unsigned char lll_rgb[] = {
  177,161,25,205,186,48,239,219,72,253,233,87,237,214,74,218,195,59,
  205,186,48,194,179,33,189,174,25,204,189,35,215,199,41,200,185,34,
  186,171,23,178,167,15,225,212,39,251,241,53,218,209,31,181,173,10,
  186,178,14,180,168,11,188,173,16,205,187,25,205,187,23,194,176,16,
  194,176,16,195,174,18,194,173,16,205,183,23,197,179,18,212,193,26,
  223,200,32,171,151,6,174,154,6,207,187,11,213,193,11,218,194,16,
  210,182,13,197,170,6,194,167,4,215,187,16,208,181,13,205,178,13,
  210,183,21,208,186,25,207,182,29,174,152,16,166,145,20,212,189,53,
  239,213,67,207,182,40,183,158,19,215,188,33,244,214,44,239,209,39,
  229,199,30,222,193,27,215,186,22,210,181,21,197,171,12,200,181,12,
  181,163,2,178,160,4,213,194,24,232,213,38,200,182,20,165,149,4,
  181,164,15,197,176,26,213,192,37,237,215,55,253,234,71,255,238,74,
  236,217,48,205,187,21,204,186,21,227,204,35,230,207,37,223,200,34,
  225,202,34,223,204,34,218,199,29,212,193,24,218,199,27,223,203,29,
  225,206,30,234,216,33,244,226,42,239,221,39,217,200,29,205,189,25,
  153,136,11,171,153,23,205,186,46,234,217,66,248,231,75,250,232,73,
  241,224,68,230,212,51,205,187,33,202,185,33,215,197,41,220,202,44,
  223,205,43,188,173,16,217,200,31,243,225,44,232,214,35,210,192,21,
  205,188,19,191,175,10,191,173,12,205,186,19,204,186,19,194,176,12,
  200,181,18,207,185,23,200,178,18,197,175,18,194,173,16,218,195,29,
  223,200,32,183,162,11,172,151,2,200,176,6,212,192,9,222,197,18,
  217,189,16,208,180,11,208,180,11,232,203,24,222,193,20,225,197,23,
  229,201,30,208,182,23,200,175,22,184,161,19,178,156,25,218,194,57,
  207,183,46,215,190,46,197,172,28,222,190,36,244,214,44,244,214,42,
  223,193,27,207,178,17,195,167,10,197,171,14,186,161,8,186,168,4,
  191,174,4,200,181,12,225,205,27,222,202,29,192,174,16,171,151,6,
  178,158,11,195,174,22,218,197,40,237,219,55,251,232,68,255,236,67,
  239,220,44,199,180,12,197,178,12,217,197,24,220,201,27,217,193,24,
  213,194,24,204,185,17,215,196,22,232,212,33,225,205,27,230,210,30,
  212,192,17,223,205,25,244,226,40,234,216,36,208,191,23,204,188,23,
  183,167,28,189,174,33,197,181,38,212,195,45,234,217,57,250,231,65,
  251,233,66,241,223,54,215,197,37,204,183,31,205,184,31,215,197,39,
  243,220,54,204,186,25,215,196,28,218,199,27,220,203,27,217,199,22,
  210,192,17,204,185,13,200,181,10,205,186,15,208,189,17,212,193,22,
  222,202,29,225,202,32,210,188,24,189,168,12,189,168,12,220,197,29,
  220,197,27,197,174,12,181,159,0,194,171,2,217,197,14,234,209,24,
  229,204,21,223,195,21,213,189,13,220,196,16,213,189,11,229,204,23,
  236,211,31,199,173,14,189,168,14,200,175,26,189,166,33,234,209,68,
  178,155,27,217,191,46,207,181,34,208,180,25,241,211,39,241,211,39,
  225,195,27,204,175,13,181,156,2,192,166,10,191,166,10,188,169,2,
  208,188,13,212,192,17,215,196,22,208,189,19,204,186,19,197,179,18,
  200,178,20,213,191,30,241,218,51,246,223,57,241,219,54,250,226,55,
  236,216,36,204,185,11,197,178,8,208,189,15,212,192,17,213,194,18,
  207,188,15,189,170,4,212,192,17,244,223,37,220,200,20,223,203,21,
  210,190,15,210,192,15,225,215,27,222,212,29,205,192,21,197,184,18,
  213,198,45,212,197,43,207,192,36,210,194,34,217,200,33,229,212,37,
  230,212,37,229,210,37,225,202,36,212,186,28,202,181,23,200,178,20,
  199,177,20,236,216,38,223,199,29,210,190,17,205,186,11,200,180,4,
  208,188,9,212,192,9,208,190,7,215,196,13,218,200,16,220,200,20,
  225,205,27,229,210,35,218,199,29,194,176,16,184,166,8,202,184,15,
  218,198,20,205,186,11,194,174,2,200,176,4,222,197,18,237,208,29,
  244,214,32,236,210,26,217,193,16,236,210,24,225,200,16,241,215,27,
  246,216,35,204,178,15,195,170,16,215,188,35,204,177,45,241,210,80,
  199,172,44,220,194,51,195,169,24,199,174,20,218,191,27,223,195,27,
  217,193,22,195,173,10,192,166,8,197,174,12,220,197,25,223,203,25,
  223,203,23,217,197,20,213,194,18,207,188,17,208,189,17,217,193,24,
  210,187,21,217,195,29,227,204,35,225,202,34,212,190,28,222,200,32,
  229,209,28,210,190,13,217,197,16,217,197,16,212,192,15,191,172,4,
  204,185,11,191,172,4,208,189,15,227,206,23,220,200,20,213,193,15,
  207,189,11,210,200,15,212,205,20,208,200,19,188,179,8,177,168,4,
  217,205,44,217,201,40,212,199,32,210,201,26,217,203,24,229,211,28,
  225,207,25,218,198,22,220,197,27,218,195,27,200,177,16,189,168,10,
  186,165,10,217,195,29,225,202,32,227,207,30,225,205,25,223,203,23,
  220,200,18,218,198,14,218,199,11,220,201,9,222,201,14,225,205,23,
  229,209,30,229,206,35,222,203,32,202,180,21,191,169,12,199,176,12,
  213,194,20,212,192,15,204,185,9,202,183,7,217,197,16,241,216,32,
  250,224,35,234,213,26,217,193,16,239,218,27,225,204,16,243,218,30,
  246,221,35,208,181,17,204,178,19,222,194,38,199,172,44,246,215,84,
  207,180,48,218,192,46,186,162,17,194,172,14,197,174,12,204,185,15,
  195,176,10,188,170,6,186,164,6,199,176,14,234,211,36,243,219,42,
  234,210,33,215,196,22,210,190,17,210,190,17,212,193,20,215,196,20,
  207,188,17,212,193,20,222,202,27,223,203,27,212,189,22,218,194,24,
  220,200,20,218,198,16,227,206,23,225,205,21,210,190,13,189,170,4,
  215,196,18,208,189,15,215,195,16,232,211,26,234,214,29,220,202,18,
  220,202,18,222,212,23,222,214,25,207,197,17,188,179,6,181,172,4,
  215,202,37,212,199,30,213,204,28,217,207,24,227,212,25,239,224,27,
  229,210,21,222,203,18,217,197,18,218,198,20,204,185,13,192,174,10,
  181,160,4,180,159,6,195,173,14,222,198,29,230,207,35,223,199,27,
  208,189,17,208,189,15,217,196,11,215,196,5,217,196,9,223,203,21,
  223,203,25,220,197,29,218,195,31,210,188,26,204,182,21,204,182,19,
  213,194,20,215,195,16,208,188,9,202,183,9,205,186,9,232,211,28,
  251,230,41,236,215,29,207,187,11,220,200,16,217,197,16,234,213,26,
  239,218,34,205,182,17,202,177,21,215,190,35,180,157,29,236,204,71,
  212,187,49,217,193,42,175,152,11,194,172,12,194,175,8,195,176,8,
  194,175,8,184,166,4,177,156,2,191,169,10,222,200,32,230,207,37,
  232,209,38,222,200,32,220,197,27,217,193,24,207,188,17,202,183,11,
  199,179,8,210,190,13,229,208,23,237,216,29,223,203,21,223,203,21,
  217,197,16,222,201,18,229,208,23,229,208,23,207,187,11,191,172,4,
  229,209,26,234,214,29,227,206,25,236,215,29,243,222,32,220,200,18,
  227,208,21,223,213,25,229,221,30,212,202,17,195,185,10,194,181,10,
  227,218,37,223,214,32,220,211,25,218,208,18,225,214,16,234,223,19,
  225,210,14,220,201,7,212,193,3,213,195,7,210,190,7,212,192,11,
  205,186,11,200,181,10,205,186,17,212,189,22,207,184,21,205,183,21,
  199,177,18,204,182,17,213,193,11,212,194,5,210,190,7,212,192,13,
  210,190,15,205,182,17,205,183,21,217,195,29,222,200,32,220,197,27,
  213,194,20,210,190,13,205,186,9,191,172,2,189,170,2,223,203,23,
  246,225,37,227,206,25,195,175,4,200,180,6,195,175,2,217,197,16,
  230,210,28,210,191,21,208,189,23,208,183,30,163,141,15,212,184,49,
  215,190,46,213,188,35,166,144,7,195,176,10,215,196,18,220,200,20,
  208,189,15,194,172,12,197,175,16,207,185,23,200,174,20,202,177,25,
  222,196,36,229,202,37,227,204,35,222,198,27,217,197,22,218,198,18,
  213,193,13,223,202,14,236,215,22,244,224,22,229,209,14,227,208,14,
  223,202,16,217,197,16,213,193,15,217,197,16,205,186,9,199,179,8,
  225,205,23,232,211,28,218,198,18,225,207,23,248,229,38,222,201,20,
  210,192,11,217,203,18,218,208,20,204,191,11,194,181,6,197,184,10,
  237,227,43,237,227,36,230,220,28,225,215,21,220,209,11,218,207,7,
  217,207,5,217,202,3,215,195,0,213,193,0,207,188,0,208,190,5,
  212,192,9,234,213,26,220,200,20,207,188,17,205,182,17,218,195,29,
  223,200,32,215,192,24,208,188,13,212,192,9,208,188,9,204,185,7,
  207,187,11,212,192,15,212,192,17,217,197,22,220,200,22,217,197,20,
  208,188,13,205,186,11,208,188,11,202,183,9,197,177,6,225,205,25,
  232,211,28,212,192,15,186,167,2,186,167,2,188,171,0,208,190,13,
  225,205,25,210,191,21,200,181,18,180,160,13,157,136,8,200,175,36,
  212,188,37,202,181,23,175,154,4,197,177,6,222,201,18,225,205,21,
  230,210,28,212,189,22,191,169,12,197,172,20,194,169,18,197,172,20,
  223,197,36,241,217,46,239,215,41,220,201,25,212,192,17,223,202,18,
  218,198,14,218,199,9,222,202,9,229,210,10,223,203,7,229,209,12,
  225,204,16,218,198,16,225,205,21,230,209,23,218,198,18,200,181,10,
  205,186,15,234,216,31,230,210,26,207,187,11,210,190,15,199,181,8,
  200,182,8,208,194,15,199,189,10,183,174,2,180,167,2,200,183,12,
  232,222,40,232,222,35,232,221,28,239,228,29,232,221,19,220,209,9,
  215,205,5,217,198,3,218,198,0,215,195,0,213,194,3,212,194,5,
  210,192,5,243,221,27,220,200,18,202,183,11,204,185,15,212,189,22,
  223,199,29,217,195,27,218,194,24,230,210,28,222,202,23,207,187,11,
  212,192,13,225,204,18,225,204,16,218,197,11,212,192,9,208,188,9,
  208,188,9,213,193,13,223,203,21,218,198,18,197,177,6,210,190,15,
  222,202,23,220,200,20,199,179,8,188,169,2,191,172,2,212,192,13,
  227,206,25,213,194,22,195,177,14,162,140,5,171,148,12,205,179,35,
  215,190,35,202,180,19,205,186,11,213,193,11,223,202,18,215,195,16,
  234,214,31,222,198,27,188,167,12,195,170,20,210,185,30,225,198,36,
  241,213,44,246,222,45,234,214,33,202,183,13,199,179,6,220,200,14,
  217,196,9,217,198,9,217,198,5,223,203,7,220,201,5,229,210,10,
  225,204,16,215,194,13,223,203,21,223,203,21,212,192,13,192,173,6,
  174,157,2,215,196,20,239,219,32,208,188,13,192,173,4,195,178,6,
  208,190,13,202,185,13,186,177,8,175,166,2,175,166,2,205,192,21,
  197,188,20,212,203,26,223,213,29,230,220,30,239,228,29,239,229,27,
  229,214,19,223,204,14,223,204,14,223,202,14,225,204,16,229,208,19,
  227,206,21,227,206,23,210,190,15,189,170,4,184,166,4,184,162,4,
  207,184,19,213,190,26,222,200,34,250,226,55,225,202,32,195,176,8,
  202,183,5,229,209,12,223,203,7,223,203,5,220,201,3,222,202,7,
  225,204,16,237,216,27,237,216,29,215,195,16,186,167,2,180,158,0,
  199,176,8,230,210,26,239,218,29,194,174,2,200,180,4,215,194,13,
  229,208,23,225,201,25,199,176,12,186,161,10,195,171,22,217,191,35,
  230,203,37,222,198,27,225,205,23,229,208,21,230,209,21,217,197,16,
  217,197,22,207,184,19,188,163,12,208,183,28,236,209,43,243,219,42,
  234,214,31,229,209,26,217,197,16,199,179,4,200,180,2,217,196,9,
  222,203,12,225,206,12,223,204,12,218,199,7,213,194,5,222,203,12,
  212,192,9,205,186,9,197,177,4,197,177,4,180,162,2,162,143,2,
  192,173,6,197,178,8,208,188,13,208,188,13,212,192,15,208,190,11,
  215,197,16,191,178,10,168,161,2,183,175,10,210,201,26,229,219,37,
  194,182,26,212,195,32,229,215,39,218,209,29,220,207,27,232,218,31,
  222,204,23,217,197,22,217,195,27,218,195,27,223,199,29,229,205,30,
  223,199,27,213,190,22,205,182,17,192,170,12,172,151,2,177,156,4,
  200,178,18,204,182,23,218,193,38,241,215,54,212,190,28,184,166,6,
  181,162,0,207,189,3,222,202,3,217,197,0,213,193,0,218,199,5,
  223,204,14,234,213,26,234,214,29,222,201,18,195,176,6,186,164,2,
  197,178,8,215,196,18,230,210,26,204,185,9,204,185,7,218,198,16,
  230,209,23,230,206,28,213,190,22,213,187,24,223,197,34,220,193,33,
  225,202,32,217,197,22,207,187,11,207,187,9,222,201,18,213,193,15,
  192,173,8,177,156,2,184,163,10,212,190,26,230,207,37,227,206,25,
  223,202,16,217,196,11,213,193,9,220,201,11,217,198,9,210,192,5,
  215,196,7,220,201,11,222,201,14,217,196,9,213,193,9,202,183,5,
  197,177,2,192,173,2,197,177,4,199,179,6,183,165,2,188,170,6,
  227,206,25,204,185,11,188,169,2,210,190,13,215,195,16,197,177,4,
  217,199,18,183,174,8,157,149,2,191,182,14,237,227,43,243,233,47,
  202,187,37,222,206,45,229,212,46,215,199,33,204,188,23,208,191,23,
  218,201,29,218,196,35,218,193,40,218,193,38,215,190,35,213,187,30,
  217,195,31,225,202,34,237,214,43,223,200,32,186,165,10,166,146,2,
  172,149,6,199,174,20,227,202,44,239,213,53,217,195,33,202,184,17,
  200,182,10,210,192,7,217,198,5,213,194,3,208,190,3,215,196,7,
  220,202,14,225,207,23,225,205,25,227,206,23,220,202,20,210,190,15,
  200,181,10,195,176,8,215,196,18,210,190,13,208,188,11,218,198,16,
  230,209,23,234,214,31,223,203,27,229,210,33,234,210,38,213,190,26,
  213,190,22,205,186,13,192,173,2,186,167,2,205,186,9,210,190,15,
  184,166,6,168,147,0,192,170,12,215,192,26,230,211,33,232,211,24,
  225,205,9,215,196,5,210,192,3,213,194,5,220,201,7,227,208,14,
  225,206,14,222,201,14,227,206,19,225,204,18,230,209,23,207,187,11,
  192,173,2,195,175,2,212,192,13,222,201,20,220,200,18,213,193,15,
  208,189,15,189,170,4,189,170,2,222,201,20,236,215,29,218,200,18,
  218,200,18,180,168,4,153,145,0,191,182,14,239,230,44,239,230,44,
  194,179,35,220,205,51,229,213,55,200,185,34,181,167,19,207,192,32,
  230,211,46,239,213,55,241,213,58,230,205,49,218,193,40,210,185,30,
  208,185,23,217,195,29,243,223,44,251,230,48,220,197,27,189,167,8,
  183,162,6,215,196,26,220,201,33,205,187,25,213,194,28,223,204,32,
  215,198,24,208,191,15,227,208,25,227,208,21,217,199,18,215,197,18,
  217,199,20,220,203,25,218,198,22,222,204,23,232,213,26,220,202,22,
  207,190,17,212,195,20,230,212,30,223,205,23,215,197,16,218,200,18,
  230,212,28,237,219,34,225,208,30,230,210,35,223,203,29,204,182,17,
  207,188,17,210,190,15,208,188,13,195,176,6,210,190,15,227,207,28,
  202,180,15,186,164,6,212,189,22,225,202,30,222,202,23,225,206,14,
  225,205,7,225,205,7,220,201,5,215,196,3,222,202,9,229,209,14,
  212,192,7,195,175,2,195,175,4,207,187,11,225,205,25,208,189,15,
  194,174,2,200,180,4,220,200,18,237,216,29,241,220,32,218,198,20,
  191,172,4,195,176,6,205,186,11,218,198,18,229,208,23,230,209,23,
  208,190,13,180,167,2,165,156,0,192,179,10,223,209,27,225,212,30,
  188,173,38,205,189,46,218,202,53,220,205,51,212,195,41,217,200,44,
  236,214,55,243,216,56,234,208,50,229,203,42,229,202,39,222,200,32,
  199,176,12,183,165,4,220,200,20,250,229,38,236,215,26,222,201,20,
  218,198,18,223,203,21,207,188,17,175,159,2,199,182,16,230,212,37,
  220,203,33,207,190,25,248,230,50,248,230,50,239,222,44,227,210,37,
  227,210,35,237,220,41,227,209,32,217,203,22,220,210,22,205,192,17,
  207,194,17,222,208,27,232,218,33,213,204,20,208,198,17,212,202,17,
  222,208,25,227,213,30,217,204,27,232,214,35,222,202,27,195,176,10,
  204,185,15,225,205,25,232,211,28,215,196,20,222,202,25,229,206,33,
  202,180,17,192,170,10,222,202,27,237,217,34,218,198,18,207,189,3,
  215,196,3,230,210,7,241,221,15,244,224,18,232,212,12,217,198,7,
  192,174,0,174,156,0,175,157,0,194,175,6,208,189,15,199,179,8,
  197,177,6,205,186,9,222,201,20,237,216,29,227,206,23,220,200,20,
  212,192,15,205,186,13,208,188,13,222,201,20,227,206,23,223,205,21,
  207,189,11,184,167,2,175,159,0,194,177,6,212,194,15,213,195,15,
  199,183,46,204,188,47,217,201,53,230,213,60,234,216,59,223,206,52,
  222,201,47,212,188,37,212,186,28,225,202,34,243,218,39,241,221,37,
  213,193,15,191,172,2,213,193,9,237,216,22,234,214,19,222,203,12,
  215,196,9,223,204,14,208,190,11,181,168,2,199,182,14,234,216,40,
  248,229,55,225,207,43,237,219,57,241,223,61,237,219,55,225,207,43,
  229,211,42,251,233,53,239,221,41,218,209,27,220,211,25,205,196,17,
  205,196,17,208,198,19,213,204,22,213,204,22,217,207,22,218,208,22,
  225,215,27,220,210,27,215,205,26,239,230,44,232,214,35,188,170,6,
  199,180,10,237,212,31,244,219,37,225,201,25,227,203,28,208,185,19,
  192,170,12,191,169,8,212,193,20,241,220,34,234,213,24,217,198,7,
  210,191,0,230,210,7,250,229,20,244,224,18,234,214,12,229,209,12,
  202,184,3,186,167,0,189,170,2,208,188,11,205,186,11,192,173,4,
  192,173,2,217,197,16,225,205,21,234,213,26,222,201,20,222,201,20,
  212,192,15,188,169,4,184,165,2,207,187,11,220,202,20,227,208,23,
  222,203,18,205,188,9,188,171,0,195,177,4,210,190,11,210,190,11,
  174,161,27,194,180,39,202,188,43,192,176,37,188,172,32,222,202,54,
  223,199,52,212,190,34,222,200,32,237,214,41,250,230,48,251,230,48,
  236,216,34,217,197,18,225,205,21,234,213,22,225,204,16,223,204,12,
  230,210,14,229,209,14,215,200,13,194,184,8,195,186,16,212,195,32,
  229,213,51,241,225,68,218,203,53,229,212,60,230,213,60,223,206,50,
  229,212,46,250,232,55,250,232,50,236,218,36,229,215,28,218,204,22,
  207,194,17,205,192,15,215,201,20,222,208,25,220,206,22,222,204,23,
  227,208,25,220,206,22,218,204,22,225,207,27,207,188,17,184,162,2,
  204,181,13,241,212,32,241,212,34,220,192,22,230,202,28,215,188,20,
  204,181,13,202,179,11,212,192,15,234,214,29,229,208,21,218,199,7,
  212,197,0,230,214,7,246,225,15,237,221,12,227,207,7,227,208,10,
  215,196,7,210,192,7,212,192,11,207,187,9,199,179,4,186,167,2,
  195,176,6,222,201,20,234,214,29,234,214,29,218,198,18,208,188,11,
  205,186,11,188,169,2,181,163,2,194,175,4,212,192,11,220,200,16,
  225,204,18,225,204,16,223,202,16,208,188,7,200,180,4,210,190,9,
  186,172,32,178,165,29,172,158,25,165,150,20,178,163,29,195,176,39,
  225,201,54,241,215,54,244,216,49,246,223,50,243,215,44,232,208,35,
  227,203,32,230,210,30,234,214,31,229,208,23,217,197,16,218,198,14,
  237,216,22,243,223,27,241,226,29,230,220,30,204,195,19,186,174,15,
  210,194,38,232,217,61,191,177,37,204,188,43,210,194,45,217,200,44,
  220,204,40,232,213,42,250,232,50,251,232,43,237,218,29,223,205,21,
  217,199,18,213,195,15,208,190,13,210,192,13,210,192,13,204,185,9,
  202,185,11,204,187,9,207,189,11,200,180,8,189,162,2,186,158,2,
  213,183,15,237,206,29,232,201,24,212,182,13,227,196,23,213,183,15,
  199,170,6,194,167,4,208,181,13,225,201,21,215,194,13,212,194,5,
  218,199,3,230,214,7,230,214,5,218,198,0,222,202,5,234,215,15,
  227,208,14,229,208,19,223,202,18,200,180,6,189,170,0,192,173,2,
  202,183,11,229,209,26,241,220,32,230,210,26,208,188,13,202,183,9,
  215,195,16,222,201,20,225,205,21,236,215,26,236,215,26,227,206,21,
  227,206,19,239,217,24,244,222,27,218,198,14,197,177,2,204,185,7,
  239,223,67,202,188,43,175,160,28,195,179,41,210,191,51,200,181,44,
  204,181,41,215,190,41,227,201,41,232,206,47,232,206,45,232,205,40,
  236,209,43,239,215,41,234,210,33,225,205,25,212,192,15,212,192,15,
  232,211,24,246,226,32,250,231,38,248,237,40,217,208,27,189,177,14,
  195,180,24,215,199,41,192,177,31,212,195,41,218,200,44,215,197,37,
  215,197,31,230,210,37,244,224,42,248,222,35,236,210,26,223,198,18,
  217,193,16,213,189,13,215,190,13,222,197,18,212,188,11,207,183,9,
  207,183,9,217,193,16,222,197,18,205,178,9,199,169,2,195,162,2,
  213,179,13,232,197,24,230,190,21,210,172,9,220,181,14,210,176,9,
  199,165,2,191,162,0,191,162,2,205,176,7,207,179,5,215,194,5,
  229,209,7,236,216,10,227,207,5,215,195,0,210,191,0,215,196,7,
  230,211,17,232,211,24,223,203,21,200,180,8,189,170,0,200,180,6,
  215,196,18,227,206,25,229,209,26,218,198,20,202,183,11,194,174,2,
  208,188,11,236,215,29,253,234,41,251,232,38,232,211,24,222,201,18,
  225,204,18,236,215,22,237,216,22,220,200,14,205,185,7,208,188,9,
  251,239,78,239,224,70,220,204,58,207,191,50,194,175,41,199,180,44,
  178,157,27,183,159,26,207,182,36,213,187,37,207,183,32,212,187,34,
  220,195,38,223,197,34,229,206,35,225,202,32,213,190,22,205,186,15,
  217,197,20,234,214,29,241,222,34,246,232,40,236,222,36,222,205,32,
  208,191,25,207,190,27,202,186,27,220,204,40,236,217,45,234,214,40,
  223,203,29,227,207,30,232,207,28,230,201,23,227,196,19,220,189,14,
  215,184,11,217,186,11,225,193,16,232,200,21,223,192,16,212,181,9,
  205,176,7,212,181,9,229,198,19,225,193,16,217,182,11,210,171,7,
  215,176,9,225,185,16,229,189,19,217,177,11,227,186,16,215,176,11,
  204,166,5,200,162,2,205,171,5,205,171,5,202,171,0,212,187,3,
  244,222,18,243,222,15,218,197,3,207,186,0,207,188,0,207,187,5,
  220,200,14,218,198,16,200,180,8,191,172,2,199,179,8,225,205,23,
  227,206,23,223,203,21,215,195,16,212,192,13,205,186,9,202,183,9,
  215,195,16,239,218,29,248,226,35,229,208,23,220,200,18,230,209,23,
  232,211,24,222,201,14,210,192,5,212,192,7,222,201,14,217,197,14,
  230,214,58,241,225,68,237,222,67,210,196,51,189,170,36,171,153,24,
  168,148,21,178,155,24,199,174,34,213,187,41,204,178,33,192,169,24,
  195,171,24,205,180,25,212,186,28,215,192,28,215,192,26,208,185,19,
  207,188,17,215,196,22,217,199,24,229,216,33,234,220,38,239,225,41,
  229,216,35,207,194,21,181,169,8,189,173,12,192,176,12,194,177,12,
  183,165,4,183,165,6,208,185,15,229,200,21,232,200,19,223,192,14,
  222,191,14,229,198,17,225,193,14,208,178,7,200,170,2,199,169,0,
  204,174,3,212,181,7,227,195,16,229,198,17,220,184,11,215,176,9,
  213,174,9,210,171,7,212,173,9,212,173,9,227,186,16,225,185,16,
  215,176,9,204,166,3,199,165,2,195,161,0,207,177,3,218,188,7,
  232,210,12,232,210,12,220,199,5,212,190,0,195,175,0,191,172,4,
  222,201,16,220,200,18,192,173,4,194,175,6,207,188,13,227,206,25,
  232,211,26,222,201,20,200,180,6,191,172,2,197,177,4,223,203,21,
  246,225,35,241,220,32,230,209,23,218,198,18,227,206,23,236,215,29,
  230,209,23,218,197,11,208,188,5,215,194,9,225,204,16,212,192,9,
  194,180,32,202,188,41,229,214,58,251,235,78,246,229,72,212,195,47,
  166,145,17,156,135,8,172,149,16,204,178,33,218,193,42,202,178,29,
  186,162,17,192,167,16,199,174,20,215,192,28,234,210,38,236,212,38,
  218,195,27,207,188,19,200,183,18,204,191,23,202,193,21,212,203,26,
  207,198,23,202,193,17,194,185,12,191,182,8,189,176,6,189,172,6,
  195,178,10,202,184,15,208,189,17,222,193,18,234,202,22,222,191,14,
  208,178,7,217,186,11,215,184,9,200,170,2,200,170,4,204,174,5,
  215,184,11,222,191,14,227,196,19,227,195,16,220,188,11,208,178,5,
  200,170,2,194,164,0,199,169,0,191,162,0,197,168,4,202,173,5,
  204,174,5,205,175,5,208,178,7,200,170,2,210,181,5,212,187,3,
  202,181,0,208,188,3,218,197,5,207,187,3,194,174,0,204,185,11,
  232,211,26,208,189,15,174,157,2,204,185,15,230,210,30,236,215,31,
  230,210,26,218,198,18,204,185,9,204,185,9,213,193,15,227,206,23,
  239,218,29,230,209,23,236,215,29,243,224,37,237,218,31,217,197,16,
  212,192,11,220,199,11,225,206,14,223,202,14,217,196,11,200,180,4,
  202,190,35,191,179,29,189,175,29,207,192,40,223,206,52,239,222,63,
  218,194,46,200,176,32,199,175,28,213,189,37,220,195,40,218,192,35,
  215,190,31,205,183,21,213,190,26,225,202,32,246,221,42,248,223,45,
  227,207,30,207,188,19,202,186,23,208,196,30,199,190,20,186,178,12,
  197,188,16,220,210,27,180,173,2,178,169,0,178,169,0,178,169,2,
  192,179,10,200,183,16,191,174,8,194,175,4,208,180,9,204,176,5,
  194,167,2,204,177,7,217,188,11,220,191,14,223,194,16,222,193,14,
  223,194,16,222,193,14,225,195,16,230,200,21,229,204,19,215,194,11,
  207,187,7,202,183,7,204,185,7,194,175,4,177,159,0,180,162,2,
  192,172,0,202,183,5,208,188,9,207,187,7,200,180,2,197,177,0,
  189,170,0,199,179,0,212,191,3,205,185,3,204,185,7,217,197,16,
  212,192,17,186,164,6,181,160,4,222,198,27,246,225,40,251,230,43,
  223,203,23,208,188,11,218,198,18,236,215,29,225,205,21,197,177,6,
  189,170,4,200,180,8,225,205,21,236,217,29,222,201,20,191,172,4,
  199,179,6,207,187,5,225,206,14,220,200,14,217,197,14,205,185,7,
  184,173,19,174,163,16,166,152,12,166,152,12,189,172,25,204,187,35,
  217,196,42,222,200,40,223,197,38,239,216,48,251,231,53,248,224,48,
  229,206,33,208,189,17,200,181,10,205,186,15,222,202,23,225,205,27,
  212,193,20,204,185,17,217,200,31,225,208,43,202,190,27,174,165,7,
  178,170,8,207,199,17,189,181,4,184,176,2,181,173,0,177,169,0,
  178,169,2,183,174,6,189,176,8,205,188,13,220,200,18,220,200,18,
  213,193,15,222,201,20,232,211,24,230,209,23,230,209,23,230,209,23,
  234,214,29,239,218,29,237,216,29,241,219,29,237,222,29,225,214,18,
  217,207,16,210,202,13,217,209,18,215,207,18,202,195,11,204,197,13,
  202,193,9,199,189,6,186,176,0,181,171,0,186,176,0,183,166,0,
  188,169,0,197,177,2,212,192,9,223,202,16,207,187,11,189,170,6,
  184,163,6,195,173,12,234,210,38,243,219,42,223,199,27,208,189,17,
  213,194,18,207,187,11,208,188,13,212,192,15,204,185,9,191,172,2,
  191,172,4,195,176,6,207,187,9,210,190,11,213,193,13,208,188,11,
  195,175,4,200,180,0,215,196,9,220,200,14,222,201,16,204,185,7,
  168,157,9,183,172,19,197,182,30,204,188,33,197,180,30,208,191,36,
  189,172,23,181,160,11,197,175,14,220,197,27,237,217,36,225,205,25,
  205,186,11,210,190,15,204,185,9,202,183,9,213,193,15,218,198,20,
  207,188,13,205,186,15,222,203,34,230,213,46,200,184,24,169,158,4,
  163,154,0,183,176,4,195,187,6,194,186,4,186,178,0,181,173,0,
  181,171,0,184,175,4,195,185,10,213,204,20,225,211,25,223,209,23,
  218,204,20,223,209,23,230,216,28,229,215,26,227,212,25,230,216,28,
  237,223,34,248,234,38,251,237,41,253,242,41,241,233,32,227,227,23,
  223,223,23,222,222,23,229,229,26,229,229,28,218,218,22,220,220,22,
  215,215,20,210,206,15,194,190,8,186,178,4,194,186,6,195,177,4,
  191,174,2,195,177,4,210,192,11,222,203,20,222,202,23,205,186,17,
  174,154,4,178,158,8,202,180,21,218,195,29,229,206,35,210,187,19,
  223,203,25,237,216,31,222,202,23,200,180,8,202,183,11,220,200,18,
  223,203,21,222,201,18,213,193,13,208,188,9,218,198,16,234,213,24,
  210,190,11,200,180,2,213,193,9,217,197,14,213,193,13,202,183,7,
  200,187,28,225,213,48,241,224,58,225,209,50,199,183,30,186,170,23,
  192,176,24,195,177,16,204,185,13,213,194,18,227,206,23,217,197,16,
  208,188,9,232,211,21,215,194,11,210,190,9,220,200,16,229,208,23,
  220,200,20,218,198,20,229,206,37,248,225,55,243,223,49,229,212,35,
  208,191,17,189,179,2,195,185,4,192,184,2,192,182,0,194,186,0,
  204,195,9,215,205,18,217,207,22,223,215,25,232,224,31,223,215,25,
  212,205,20,213,206,20,227,219,28,234,226,33,236,228,34,234,226,33,
  234,226,33,234,226,33,236,228,34,241,233,37,237,237,34,232,234,26,
  232,234,29,234,236,29,237,239,34,239,241,37,230,232,31,228,230,30,
  234,236,34,230,230,30,222,223,25,213,213,20,210,202,17,194,184,8,
  184,167,2,188,171,4,204,187,13,213,196,18,215,196,22,205,186,19,
  165,145,2,160,141,2,181,160,8,186,165,12,212,186,24,237,209,36,
  232,208,33,223,203,25,212,192,17,208,189,15,222,201,20,220,200,20,
  208,188,11,213,193,13,204,185,7,195,175,2,192,173,2,208,188,9,
  205,185,7,205,185,3,215,194,9,213,193,11,205,186,9,199,179,6,
  177,165,16,191,179,27,212,197,41,223,208,50,220,202,44,229,211,49,
  229,210,46,212,193,24,194,175,4,191,172,2,205,185,7,210,190,9,
  208,188,7,217,198,9,217,196,9,213,193,9,210,190,9,210,190,11,
  205,186,9,199,179,8,199,173,14,210,184,24,225,198,32,229,209,30,
  217,197,18,184,167,2,186,172,0,192,182,0,205,195,5,217,206,11,
  230,219,21,241,230,29,241,231,32,244,236,37,246,242,40,237,233,36,
  227,223,30,225,221,30,236,232,34,239,235,39,237,233,36,234,230,33,
  230,226,30,223,219,27,222,218,27,229,229,30,236,236,34,230,232,28,
  230,232,28,228,230,28,235,237,34,244,246,40,242,244,42,246,248,43,
  246,248,45,237,239,39,232,232,33,225,225,30,215,211,22,197,187,10,
  178,165,2,168,156,0,177,161,2,191,174,8,191,175,12,180,163,8,
  175,154,7,192,167,16,192,167,16,172,148,4,191,166,12,229,201,30,
  220,197,25,194,175,8,189,170,6,199,180,10,204,185,13,212,192,15,
  227,206,23,241,219,29,234,213,24,220,200,14,204,184,5,205,185,5,
  217,196,11,222,201,14,213,193,9,207,187,9,194,175,4,181,162,0,
  195,184,30,186,175,27,189,174,27,207,192,38,225,209,50,237,219,55,
  225,207,43,210,191,21,191,172,2,197,177,4,213,193,9,217,196,11,
  213,193,9,207,189,3,223,204,14,225,204,16,207,187,7,194,174,2,
  199,179,4,199,175,6,197,170,10,195,167,10,207,180,15,208,181,13,
  208,188,9,191,172,2,195,177,0,208,194,3,225,215,12,243,232,22,
  237,226,19,232,221,19,241,230,27,244,240,37,244,244,40,243,243,39,
  243,243,37,243,243,37,236,236,34,229,229,30,230,230,30,227,227,28,
  230,230,30,229,229,30,227,227,28,229,229,30,230,232,31,226,227,28,
  230,232,31,228,230,30,229,230,33,234,236,36,234,236,36,235,236,38,
  232,232,38,237,237,38,237,237,38,234,230,36,236,228,36,217,207,24,
  183,174,8,172,164,4,178,166,4,175,166,4,180,164,6,189,174,16,
  186,169,15,184,160,13,188,164,14,197,172,18,199,173,16,202,176,17,
  205,182,17,204,185,15,195,176,10,188,170,6,202,183,11,234,214,29,
  250,228,35,244,223,32,241,219,29,225,204,18,222,201,14,215,194,11,
  223,202,14,227,206,19,213,193,11,195,175,4,180,162,0,183,165,4,
  189,178,29,186,172,27,189,174,27,204,189,35,213,196,39,205,189,33,
  208,190,28,208,189,17,204,185,7,208,188,9,218,198,14,210,190,9,
  197,179,2,212,192,9,218,198,14,222,201,16,204,185,7,194,174,0,
  197,173,2,204,177,7,207,178,11,202,174,11,210,180,13,217,189,16,
  212,188,11,200,180,4,205,187,3,212,198,5,229,218,12,244,232,22,
  239,228,20,234,225,17,243,234,25,244,240,35,243,243,37,243,243,37,
  246,246,37,246,246,37,239,239,34,234,234,29,232,232,28,230,230,28,
  232,232,28,232,232,28,232,232,28,230,230,30,230,226,33,229,229,35,
  230,230,35,230,230,35,230,230,35,232,232,35,233,234,36,236,236,38,
  236,236,38,236,236,38,236,232,38,236,232,38,232,228,35,227,223,37,
  215,208,31,208,200,25,199,190,20,168,160,6,149,138,3,181,166,15,
  165,149,5,175,159,13,218,193,38,227,201,41,188,164,16,165,143,4,
  174,154,4,205,182,17,220,201,25,220,200,20,229,209,26,241,219,29,
  239,218,27,236,215,24,237,216,22,236,215,24,232,211,21,234,213,22,
  217,197,14,205,188,9,200,180,4,194,175,4,191,172,6,199,180,10,
  207,192,40,200,185,36,212,197,41,223,207,47,222,205,40,204,186,27,
  194,176,16,194,175,6,195,175,0,204,184,5,207,187,7,189,172,2,
  178,160,0,188,171,2,200,182,8,208,188,11,207,187,9,212,192,9,
  210,182,9,210,182,9,210,180,9,202,173,7,210,180,11,225,196,18,
  225,200,18,218,198,14,220,201,11,222,212,14,232,221,19,239,230,22,
  237,229,22,236,227,19,241,237,25,246,242,35,243,243,37,243,243,37,
  246,246,37,246,246,35,243,243,32,237,237,31,237,237,31,237,237,31,
  237,237,31,237,237,31,236,236,34,236,236,34,234,230,38,234,230,40,
  236,232,41,236,232,38,237,233,38,237,233,38,237,233,38,236,236,36,
  236,236,38,234,230,36,234,230,38,237,233,38,236,232,38,223,223,34,
  232,232,40,239,235,46,220,213,36,186,179,15,168,160,6,153,139,2,
  160,146,5,189,172,19,213,192,35,205,180,27,180,156,11,157,134,2,
  168,145,2,208,185,21,243,218,39,244,224,40,232,211,26,222,201,18,
  222,201,14,222,201,14,220,200,14,220,199,11,215,194,11,217,197,14,
  205,185,7,192,174,2,184,165,2,197,178,8,205,182,17,202,177,19,
  222,206,49,217,202,46,222,206,47,230,214,51,229,212,44,213,196,32,
  208,189,23,205,188,13,204,184,5,215,194,11,215,196,11,202,185,7,
  191,174,2,178,160,0,183,164,0,192,173,2,210,190,11,225,204,18,
  217,193,14,218,190,14,215,186,13,205,176,9,210,180,9,229,200,19,
  237,215,24,232,214,24,230,215,19,234,224,22,236,225,24,237,228,24,
  237,228,24,239,234,24,243,239,30,246,246,35,244,244,40,243,243,39,
  244,244,40,244,244,37,243,243,37,241,241,34,239,239,34,239,239,36,
  239,239,36,239,239,36,239,239,39,237,233,38,237,233,41,237,233,43,
  239,236,44,239,235,41,237,233,38,237,233,38,236,232,38,236,232,38,
  236,232,38,232,228,35,234,230,38,237,233,38,236,232,38,230,230,33,
  223,223,27,227,224,35,234,226,40,227,220,37,202,193,23,154,140,2,
  178,163,8,189,172,14,184,164,12,175,151,6,178,154,6,183,157,8,
  189,164,12,202,180,19,223,200,32,225,206,30,207,188,15,200,181,10,
  212,192,13,208,188,9,204,184,5,199,179,2,191,171,0,191,171,0,
  195,175,0,188,169,0,184,165,2,195,176,8,207,180,19,200,174,18,
  205,189,37,195,184,30,191,175,23,202,186,27,212,195,30,208,191,25,
  220,203,29,223,205,23,212,192,9,218,198,14,227,206,19,227,208,21,
  215,196,13,188,171,0,183,164,0,186,167,0,207,187,9,218,198,14,
  202,183,5,213,189,11,218,189,11,207,179,7,208,180,7,225,204,18,
  239,220,27,241,226,27,241,230,29,239,229,27,236,227,26,232,228,26,
  236,236,29,243,243,32,246,246,35,244,244,40,244,244,42,243,243,42,
  244,244,42,244,244,42,243,243,39,243,243,39,243,243,42,243,243,42,
  243,243,42,243,243,44,243,243,44,241,237,44,243,239,47,243,239,47,
  243,239,47,243,239,44,241,237,44,241,237,41,237,233,38,234,234,36,
  236,236,36,234,234,36,234,234,36,234,234,36,229,229,33,225,225,25,
  220,220,22,234,234,33,243,239,39,241,233,39,218,209,29,202,189,19,
  186,170,8,174,157,4,177,156,4,184,159,8,192,165,12,208,180,21,
  204,178,19,186,165,10,194,172,14,207,184,19,195,173,10,191,172,6,
  199,179,8,197,177,4,195,175,2,199,179,0,192,172,0,195,175,0,
  210,190,7,207,187,9,181,162,0,197,178,10,215,188,24,183,159,10,
  197,185,30,178,167,17,172,160,9,183,171,13,197,181,20,199,182,18,
  207,190,19,205,188,11,197,177,2,199,179,2,213,195,11,225,206,18,
  225,206,18,215,197,16,207,189,9,195,175,2,200,180,4,207,187,9,
  194,175,4,200,180,6,208,184,5,205,181,3,215,194,9,232,211,19,
  244,224,27,248,233,33,246,235,35,239,230,29,237,233,31,232,232,31,
  236,236,34,241,243,37,241,243,37,239,239,39,241,237,44,241,237,41,
  241,237,41,241,237,41,241,237,41,241,237,41,241,237,44,241,237,44,
  241,237,46,241,237,49,239,235,46,237,230,48,237,230,48,239,231,48,
  241,234,49,244,240,47,243,239,47,241,237,44,239,235,39,237,237,38,
  239,239,39,239,239,36,239,239,34,237,237,34,230,230,28,225,227,23,
  232,234,24,250,250,35,246,246,37,236,228,31,222,212,25,239,224,36,
  202,183,13,178,160,2,189,163,6,207,180,17,210,181,19,218,191,27,
  200,174,16,172,151,2,168,148,2,181,160,8,188,167,10,184,163,6,
  181,163,2,189,170,2,202,183,7,208,188,7,213,194,5,210,191,0,
  223,203,9,212,194,5,197,177,4,205,186,11,207,180,19,180,156,9,
  229,217,49,225,212,43,220,207,38,215,201,28,220,203,31,218,201,29,
  210,192,19,202,185,9,202,183,5,195,175,0,195,177,2,194,177,6,
  197,180,8,220,202,18,227,208,23,197,177,6,186,167,0,215,194,13,
  217,197,14,194,174,2,194,174,0,207,187,3,225,206,14,239,219,22,
  244,229,30,243,232,32,243,235,35,236,236,34,239,239,34,235,237,34,
  234,236,34,237,239,36,236,237,38,236,236,41,237,233,43,237,233,43,
  236,232,43,236,232,41,237,233,41,237,233,43,236,232,43,237,233,43,
  237,234,46,237,230,46,236,228,45,232,225,47,230,222,46,234,227,50,
  237,229,50,241,233,51,244,236,49,244,240,47,243,243,42,243,243,39,
  244,244,37,243,243,32,244,244,32,244,244,32,239,239,27,235,237,24,
  241,243,27,239,239,27,241,237,32,239,230,29,239,229,32,234,220,29,
  220,202,20,207,188,15,197,174,10,205,178,15,213,184,18,208,179,17,
  192,167,12,175,154,4,165,145,0,168,148,2,175,154,2,171,150,0,
  168,147,0,186,168,4,207,187,9,218,199,9,227,208,12,222,202,5,
  225,205,7,225,205,7,223,204,12,225,204,18,223,195,27,222,196,34,
  239,226,58,243,230,54,244,231,52,227,218,37,210,194,24,202,186,17,
  194,177,8,194,176,2,199,181,2,197,179,2,189,172,2,178,160,0,
  180,162,0,194,175,4,194,175,4,178,160,2,174,156,0,202,183,5,
  217,197,14,208,190,7,208,190,5,218,199,7,232,213,17,241,226,25,
  241,230,27,239,231,32,237,233,34,237,237,34,237,239,39,236,237,38,
  236,237,38,233,239,39,236,237,38,234,234,43,236,232,45,234,226,45,
  236,232,45,236,232,43,237,234,46,237,234,46,237,234,46,236,228,45,
  236,229,48,236,229,48,232,225,47,237,230,53,236,229,55,239,232,63,
  243,236,59,243,235,56,248,240,55,250,246,50,243,239,42,244,244,37,
  248,248,33,246,246,28,246,248,25,246,248,25,243,243,22,239,241,22,
  241,243,27,237,237,27,237,233,29,241,233,32,248,237,35,243,229,35,
  243,225,35,234,214,31,212,188,17,204,178,15,191,163,8,181,154,4,
  180,155,2,186,164,6,184,163,6,178,157,4,174,153,0,165,145,0,
  160,140,0,180,162,2,205,186,9,229,209,14,236,216,15,236,216,12,
  239,218,12,223,208,5,213,194,3,225,204,16,243,218,37,237,210,43,
  207,195,38,218,206,40,227,214,39,227,214,35,212,199,22,189,172,6,
  172,156,0,177,161,0,192,174,2,213,195,13,222,201,18,212,192,11,
  199,179,4,194,175,4,194,174,2,180,162,0,177,159,0,199,181,2,
  210,192,9,223,204,14,237,221,17,241,230,20,248,237,25,244,235,27,
  237,229,29,236,232,29,236,236,34,236,236,36,236,237,38,236,237,41,
  232,237,41,232,237,43,235,236,45,232,232,47,236,228,45,236,229,48,
  236,228,45,236,228,45,237,230,46,237,230,46,237,230,48,236,229,48,
  237,230,48,236,228,50,236,228,50,241,233,58,243,236,64,243,235,69,
  244,236,66,246,239,60,248,241,58,246,242,50,243,239,42,243,243,37,
  246,246,30,246,248,25,246,248,23,248,250,20,242,244,18,237,239,22,
  239,241,25,239,239,27,237,237,27,241,236,29,243,232,32,241,231,32,
  250,231,38,241,220,34,218,198,22,191,165,8,166,142,0,168,144,0,
  180,155,2,205,182,17,220,197,27,212,189,22,186,164,6,172,155,2,
  186,168,6,199,179,4,207,187,7,223,204,12,234,215,15,236,216,12,
  237,216,12,223,208,3,210,192,3,225,204,16,246,225,40,241,213,44,
  169,158,14,181,170,17,195,183,20,205,192,21,204,191,17,194,181,8,
  188,171,4,192,175,6,207,189,9,222,203,18,222,201,18,213,193,13,
  213,193,15,217,197,16,200,180,6,191,172,2,191,174,4,194,176,0,
  207,189,7,236,217,22,244,232,22,244,235,22,246,237,25,239,230,24,
  229,229,23,230,230,26,232,234,33,236,237,38,236,237,38,236,237,43,
  232,237,43,232,237,46,235,236,45,232,232,49,236,228,50,236,228,50,
  236,229,48,236,229,48,236,228,45,236,228,45,237,230,48,236,229,48,
  237,230,48,237,230,48,237,230,48,241,234,54,243,236,64,237,228,64,
  237,228,60,241,233,58,237,229,50,236,232,43,241,237,39,243,243,37,
  246,246,30,244,246,25,246,248,23,248,250,20,242,244,18,237,239,20,
  239,241,25,241,241,27,237,237,27,239,235,29,239,230,29,237,227,29,
  244,225,35,241,222,32,223,203,25,191,173,8,168,144,0,168,147,0,
  183,161,4,208,185,19,225,202,30,229,209,30,207,188,17,199,180,10,
  220,200,20,220,200,16,222,201,16,225,204,14,218,199,9,220,201,7,
  232,212,12,225,205,9,215,196,9,222,203,18,229,210,33,225,199,39,
  157,143,8,163,152,7,180,168,11,191,182,14,204,191,17,207,194,15,
  199,181,8,200,182,4,210,192,9,217,199,16,212,192,11,207,187,9,
  213,193,15,217,197,16,189,170,4,192,173,4,204,187,7,186,169,2,
  215,196,11,237,226,24,236,227,19,239,235,20,243,238,22,237,237,24,
  190,27,226,190,27,226,190,27,226,190,27,226,190,27,226,190,27,226,
  235,236,45,235,236,45,233,234,47,232,232,49,236,228,50,106,28,221,
  106,28,221,106,28,221,106,28,221,106,28,221,106,28,221,106,28,221,
  106,28,221,236,229,48,216,30,114,216,30,114,216,30,114,230,223,56,
  230,223,51,229,221,46,220,213,38,227,224,35,216,30,114,216,30,114,
  216,30,114,244,244,27,246,246,25,29,183,49,29,183,49,29,183,49,
  29,183,49,29,183,49,29,183,49,29,183,49,241,232,27,237,227,27,
  234,64,25,234,64,25,234,215,26,212,194,15,197,178,10,181,163,2,
  181,160,4,192,170,12,199,176,14,213,194,22,223,203,25,222,202,23,
  232,211,26,227,206,23,222,201,16,223,202,18,227,206,19,223,202,16,
  218,200,14,227,208,21,230,212,30,217,198,27,194,177,20,194,174,26,
  199,184,34,191,179,25,186,174,17,188,180,14,207,194,19,212,198,17,
  199,181,8,191,174,4,191,174,2,192,174,2,204,185,7,218,198,16,
  220,200,18,208,188,13,186,168,4,191,172,4,205,187,7,202,185,7,
  229,214,19,241,231,25,234,225,17,236,236,17,237,237,22,190,27,226,
  190,27,226,190,27,226,190,27,226,190,27,226,190,27,226,190,27,226,
  190,27,226,235,236,48,232,232,49,236,228,52,236,228,52,106,28,221,
  106,28,221,106,28,221,106,28,221,106,28,221,106,28,221,106,28,221,
  106,28,221,237,230,48,216,30,114,216,30,114,216,30,114,227,220,46,
  225,218,41,222,214,38,215,212,31,222,222,32,216,30,114,216,30,114,
  216,30,114,241,241,27,243,243,30,29,183,49,29,183,49,29,183,49,
  29,183,49,29,183,49,29,183,49,29,183,49,241,233,25,239,231,27,
  234,64,25,234,64,25,246,231,35,237,218,31,230,212,26,197,178,10,
  175,158,4,183,162,8,186,165,10,192,170,12,215,196,22,223,203,25,
  212,192,17,215,196,18,220,200,20,223,203,23,232,211,28,234,214,29,
  222,202,27,227,208,37,234,215,45,208,187,34,177,155,20,188,166,31,
  248,236,70,225,213,48,212,199,34,217,204,33,215,201,24,200,186,10,
  202,189,9,207,189,9,204,187,7,192,174,2,189,170,2,197,177,6,
  197,178,8,195,176,6,212,192,13,205,186,9,204,187,7,236,217,24,
  236,221,24,239,229,27,246,237,25,246,246,23,190,27,226,190,27,226,
  190,27,226,190,27,226,190,27,226,190,27,226,190,27,226,190,27,226,
  190,27,226,233,234,45,232,232,47,236,228,50,236,228,52,106,28,221,
  106,28,221,106,28,221,106,28,221,106,28,221,106,28,221,106,28,221,
  106,28,221,241,237,49,216,30,114,216,30,114,216,30,114,216,30,114,
  234,226,45,236,232,43,234,230,40,236,232,38,216,30,114,216,30,114,
  216,30,114,236,236,29,237,237,31,29,183,49,29,183,49,29,183,49,
  29,183,49,29,183,49,29,183,49,29,183,49,236,232,22,234,225,19,
  234,64,25,234,64,25,251,241,36,237,227,29,229,214,23,202,185,11,
  191,173,12,210,188,26,230,207,37,208,185,23,197,175,14,200,181,12,
  184,165,2,200,181,10,217,197,22,213,194,22,218,198,24,227,203,30,
  218,199,31,213,196,39,213,196,47,217,198,53,227,204,62,239,219,72,
  220,205,49,212,200,41,208,196,32,222,209,38,215,198,26,188,175,6,
  189,172,4,195,178,6,197,180,8,191,172,2,183,164,0,180,162,0,
  181,162,0,171,153,0,189,170,4,188,169,2,195,175,4,246,226,32,
  248,233,33,248,237,33,251,243,31,244,244,25,190,27,226,190,27,226,
  190,27,226,190,27,226,190,27,226,190,27,226,190,27,226,190,27,226,
  190,27,226,190,27,226,234,226,45,236,228,50,236,228,52,106,28,221,
  106,28,221,106,28,221,236,228,45,230,226,42,230,227,40,234,230,40,
  236,232,43,241,237,44,216,30,114,216,30,114,216,30,114,216,30,114,
  216,30,114,236,232,41,236,232,41,236,232,38,216,30,114,216,30,114,
  216,30,114,234,234,36,236,236,34,236,236,36,236,236,34,29,183,49,
  29,183,49,29,183,49,237,237,22,237,237,24,234,234,22,230,230,19,
  234,64,25,234,64,25,244,240,32,229,220,23,223,213,21,197,187,8,
  180,162,2,197,179,16,212,190,24,183,162,8,156,137,0,171,150,2,
  199,180,10,217,197,22,223,203,27,225,202,30,237,214,41,250,230,53,
  244,226,57,232,214,58,223,207,63,220,204,60,220,204,60,225,208,61,
  169,155,17,165,152,14,177,162,16,184,172,17,194,178,16,199,186,14,
  197,180,12,197,180,10,210,190,17,220,200,20,223,203,21,213,193,15,
  200,180,8,172,154,0,192,173,4,188,169,4,197,177,6,246,227,35,
  251,236,36,250,239,33,251,242,33,248,248,28,190,27,226,190,27,226,
  190,27,226,190,27,226,239,239,34,236,236,36,190,27,226,190,27,226,
  190,27,226,190,27,226,234,226,45,236,228,50,236,228,52,106,28,221,
  106,28,221,106,28,221,236,228,45,230,227,40,230,227,40,234,230,40,
  236,232,38,239,235,39,216,30,114,216,30,114,216,30,114,216,30,114,
  216,30,114,236,232,41,236,232,41,236,232,41,216,30,114,216,30,114,
  216,30,114,236,232,38,236,232,38,236,232,38,237,237,36,29,183,49,
  29,183,49,29,183,49,236,236,24,237,237,27,237,237,22,227,229,19,
  234,64,25,234,64,25,244,244,30,229,225,21,220,212,16,195,185,6,
  174,158,0,191,173,12,223,199,29,208,185,19,175,154,2,175,150,2,
  200,177,10,205,186,17,210,187,19,213,190,24,232,209,40,251,231,58,
  253,236,66,250,232,73,236,219,71,222,207,58,213,199,52,208,193,46,
  168,155,22,165,152,17,160,146,10,153,139,2,169,154,4,191,175,12,
  186,170,6,191,172,6,207,188,13,217,197,18,229,208,23,230,209,23,
  222,201,20,195,176,6,212,192,17,205,186,15,207,188,13,246,227,35,
  248,233,35,246,235,30,248,243,30,190,27,226,190,27,226,190,27,226,
  190,27,226,241,241,32,236,236,34,236,236,36,190,27,226,190,27,226,
  190,27,226,190,27,226,236,229,48,236,228,52,236,229,55,106,28,221,
  106,28,221,106,28,221,236,228,45,230,227,40,230,227,40,234,230,40,
  236,232,38,239,235,39,216,30,114,216,30,114,216,30,114,216,30,114,
  216,30,114,216,30,114,236,232,38,236,232,38,216,30,114,216,30,114,
  216,30,114,236,232,38,236,232,38,236,236,36,239,239,34,29,183,49,
  29,183,49,29,183,49,236,236,24,237,237,27,237,237,22,227,229,19,
  234,64,25,234,64,25,243,243,27,232,228,24,220,212,16,212,202,13,
  191,174,8,189,171,12,225,202,32,215,196,22,180,159,4,174,149,0,
  188,166,4,194,175,10,199,180,12,197,175,14,208,185,23,229,210,39,
  239,220,48,227,209,50,208,193,42,194,180,32,184,169,24,186,171,23,
  149,135,12,171,157,24,184,169,26,180,165,18,175,159,7,180,164,6,
  186,169,4,184,165,2,189,170,2,192,173,4,202,183,7,212,188,13,
  213,193,15,192,173,6,212,193,20,207,188,17,205,186,15,239,220,29,
  241,226,29,243,232,27,246,242,30,190,27,226,190,27,226,190,27,226,
  190,27,226,243,243,35,237,237,34,236,236,36,236,232,38,190,27,226,
  190,27,226,190,27,226,190,27,226,236,228,52,237,229,57,106,28,221,
  106,28,221,106,28,221,234,226,45,227,219,39,230,227,40,234,230,40,
  236,232,38,239,235,39,216,30,114,216,30,114,216,30,114,216,30,114,
  216,30,114,216,30,114,236,232,38,236,232,38,216,30,114,216,30,114,
  216,30,114,234,230,36,234,234,36,236,236,36,237,237,34,29,183,49,
  29,183,49,29,183,49,236,236,24,237,237,27,237,237,22,227,229,19,
  234,64,25,234,64,25,241,241,27,229,224,23,222,214,16,227,217,21,
  197,180,10,175,158,6,202,180,17,199,176,12,178,160,2,180,158,0,
  192,169,6,205,186,15,213,194,22,208,185,19,207,188,19,222,203,32,
  232,215,40,230,213,44,222,205,40,213,197,35,208,192,30,208,192,28,
  122,110,5,160,147,18,212,197,45,232,215,49,227,210,37,229,212,33,
  222,204,25,210,190,13,204,185,9,191,172,2,186,167,0,191,168,2,
  194,175,8,180,158,2,194,176,12,188,170,8,189,171,8,229,211,26,
  241,226,29,246,235,30,244,239,27,190,27,226,190,27,226,190,27,226,
  190,27,226,241,241,32,239,239,34,236,236,36,234,230,38,190,27,226,
  190,27,226,190,27,226,190,27,226,237,230,55,239,232,60,106,28,221,
  106,28,221,106,28,221,236,229,48,229,222,42,230,227,40,234,230,40,
  236,232,38,239,235,39,216,30,114,216,30,114,216,30,114,216,30,114,
  216,30,114,216,30,114,216,30,114,236,232,38,216,30,114,216,30,114,
  216,30,114,236,232,38,236,232,38,236,236,36,237,237,34,29,183,49,
  29,183,49,29,183,49,239,239,27,241,241,27,239,239,24,229,229,19,
  234,64,25,234,64,25,241,241,27,229,229,23,222,214,16,213,203,13,
  183,167,4,171,154,2,200,181,14,217,197,22,213,194,18,212,188,13,
  220,200,20,234,214,29,239,218,34,229,209,28,215,196,22,215,196,22,
  218,201,27,213,196,26,208,191,23,207,190,23,210,194,24,215,198,26,
  199,185,46,207,193,48,223,208,50,230,213,46,229,212,35,223,205,27,
  222,203,20,223,205,21,227,206,19,213,193,11,204,181,9,199,176,8,
  200,173,10,183,158,4,186,164,6,168,151,2,168,151,0,217,199,20,
  234,219,26,237,226,24,236,232,22,190,27,226,190,27,226,190,27,226,
  232,232,24,234,234,29,234,234,33,236,236,36,234,230,38,190,27,226,
  190,27,226,190,27,226,190,27,226,241,233,58,243,236,64,106,28,221,
  106,28,221,106,28,221,106,28,221,106,28,221,106,28,221,234,230,40,
  236,232,38,239,235,39,216,30,114,216,30,114,216,30,114,216,30,114,
  216,30,114,216,30,114,216,30,114,236,232,41,216,30,114,216,30,114,
  216,30,114,237,233,38,237,233,38,237,237,38,239,239,36,29,183,49,
  29,183,49,29,183,49,244,244,30,244,244,30,244,244,27,234,236,24,
  234,64,25,234,64,25,234,234,24,227,223,21,229,221,21,202,193,9,
  192,175,4,180,162,0,184,165,0,195,176,6,212,192,13,222,201,16,
  232,211,21,225,204,18,225,204,18,222,201,16,217,197,16,215,197,16,
  212,194,17,210,192,21,207,190,21,208,191,21,207,190,21,204,188,21,
  237,222,67,232,217,61,220,204,44,217,204,35,215,198,24,212,194,17,
  208,190,11,212,194,13,222,201,18,244,223,32,246,225,37,236,215,31,
  210,186,15,205,182,15,200,177,14,175,158,4,166,149,0,217,199,18,
  243,228,32,239,228,24,190,27,226,190,27,226,190,27,226,190,27,226,
  230,230,23,234,234,29,236,236,34,234,234,36,237,233,38,236,232,43,
  190,27,226,190,27,226,190,27,226,241,233,58,244,237,64,106,28,221,
  106,28,221,106,28,221,106,28,221,106,28,221,106,28,221,236,232,41,
  236,232,38,237,233,38,216,30,114,216,30,114,216,30,114,237,233,41,
  216,30,114,216,30,114,216,30,114,237,233,43,216,30,114,216,30,114,
  216,30,114,241,237,44,243,239,42,241,237,41,241,241,39,29,183,49,
  29,183,49,29,183,49,246,246,30,244,244,30,243,243,27,237,237,24,
  234,64,25,234,64,25,230,230,21,227,223,21,229,221,21,208,198,11,
  202,185,7,200,180,6,199,179,4,205,185,7,213,193,11,222,201,12,
  232,211,17,229,208,19,227,205,16,217,196,11,217,199,14,215,196,13,
  199,181,6,195,178,12,208,191,25,223,206,36,227,210,39,218,201,35,
  220,205,53,217,205,48,217,205,40,210,197,28,217,203,24,236,217,31,
  227,208,23,202,183,9,195,176,6,225,201,21,246,221,35,229,204,23,
  197,174,6,220,196,22,208,189,17,178,161,6,169,152,0,217,199,18,
  244,225,32,244,228,27,190,27,226,190,27,226,190,27,226,190,27,226,
  229,229,23,232,232,28,236,236,34,236,232,36,239,235,41,237,233,43,
  190,27,226,190,27,226,190,27,226,241,233,58,244,236,61,106,28,221,
  106,28,221,106,28,221,106,28,221,106,28,221,106,28,221,236,232,38,
  236,232,38,239,235,39,216,30,114,216,30,114,216,30,114,236,232,41,
  216,30,114,216,30,114,216,30,114,216,30,114,216,30,114,216,30,114,
  216,30,114,248,244,48,246,242,45,243,239,42,244,244,42,29,183,49,
  29,183,49,29,183,49,244,244,30,244,244,30,244,244,27,237,237,24,
  234,64,25,234,64,25,234,234,24,227,223,21,229,221,21,220,210,14,
  215,196,11,218,199,11,215,196,7,217,198,9,215,196,9,222,200,9,
  227,206,14,225,206,14,225,206,14,217,198,9,215,196,9,210,192,9,
  191,174,2,197,180,16,223,207,41,244,231,57,250,236,60,248,231,62,
  223,208,52,213,198,41,202,187,29,207,194,27,210,194,24,215,198,24,
  229,211,30,217,197,22,188,170,10,192,173,8,220,200,20,218,194,18,
  195,172,4,210,186,13,213,189,15,183,165,4,177,159,0,220,200,18,
  237,218,29,241,226,27,190,27,226,190,27,226,190,27,226,190,27,226,
  190,27,226,190,27,226,190,27,226,190,27,226,190,27,226,190,27,226,
  190,27,226,190,27,226,190,27,226,243,235,56,244,237,59,106,28,221,
  106,28,221,106,28,221,239,231,48,229,225,39,230,227,40,234,230,38,
  236,232,38,241,237,41,216,30,114,216,30,114,216,30,114,237,233,38,
  216,30,114,216,30,114,216,30,114,216,30,114,216,30,114,216,30,114,
  216,30,114,243,239,44,239,239,41,236,236,38,243,243,39,29,183,49,
  29,183,49,29,183,49,244,244,30,246,246,30,244,244,27,237,239,24,
  234,64,25,234,64,25,234,234,24,225,221,21,230,221,21,222,212,16,
  220,201,11,229,209,14,230,210,14,230,210,14,225,206,12,227,206,12,
  232,210,14,227,208,14,223,202,14,222,201,14,218,200,14,213,195,11,
  202,185,11,202,190,21,234,221,50,253,244,64,255,246,72,253,244,71,
  166,152,17,174,160,18,186,171,21,204,188,29,222,205,36,237,219,43,
  239,222,44,225,206,36,217,198,29,215,196,22,217,197,20,213,193,15,
  200,176,4,188,165,2,194,171,4,183,161,0,184,165,2,223,203,21,
  236,215,26,239,220,27,190,27,226,190,27,226,190,27,226,190,27,226,
  190,27,226,190,27,226,190,27,226,190,27,226,190,27,226,190,27,226,
  190,27,226,190,27,226,190,27,226,244,236,54,243,235,56,106,28,221,
  106,28,221,106,28,221,241,234,49,230,227,40,232,228,38,232,228,38,
  236,232,38,241,237,41,216,30,114,216,30,114,216,30,114,236,232,36,
  236,232,36,216,30,114,216,30,114,216,30,114,216,30,114,216,30,114,
  216,30,114,232,232,33,229,229,30,230,230,30,241,241,34,29,183,49,
  29,183,49,29,183,49,244,244,30,246,246,30,244,244,27,237,239,24,
  234,64,25,234,64,25,230,230,21,229,225,21,230,221,21,213,203,11,
  208,190,3,222,202,7,232,212,14,234,215,17,229,209,14,229,207,14,
  234,212,19,227,206,19,222,201,14,220,200,16,215,195,16,212,194,15,
  208,191,17,208,198,25,218,211,40,229,220,46,229,220,51,223,215,50,
  180,166,29,188,174,31,191,176,29,207,192,38,205,187,33,194,179,28,
  197,180,28,210,192,32,227,208,39,225,206,32,213,194,20,208,188,11,
  202,183,5,174,153,2,194,174,2,191,168,2,194,171,2,222,201,18,
  230,209,23,237,218,27,190,27,226,190,27,226,190,27,226,190,27,226,
  190,27,226,190,27,226,190,27,226,190,27,226,190,27,226,190,27,226,
  190,27,226,190,27,226,190,27,226,190,27,226,241,233,51,106,28,221,
  106,28,221,106,28,221,241,237,46,236,232,41,234,230,38,234,230,38,
  237,233,41,237,233,41,216,30,114,216,30,114,216,30,114,237,237,31,
  239,239,32,216,30,114,216,30,114,216,30,114,216,30,114,216,30,114,
  216,30,114,225,225,25,223,223,23,227,227,23,235,237,29,29,183,49,
  29,183,49,29,183,49,244,244,30,246,246,30,241,241,27,234,234,22,
  234,64,25,234,64,25,230,230,21,230,225,23,229,221,21,205,195,7,
  200,186,0,222,202,9,234,215,17,236,216,19,227,208,14,223,202,14,
  229,208,19,222,201,20,222,201,20,222,202,23,217,197,22,215,196,22,
  212,195,24,204,197,25,195,192,24,195,188,24,197,190,28,199,190,30,
  197,183,40,192,178,35,191,177,31,199,184,36,234,216,61,253,241,84,
  243,228,71,227,210,53,213,196,37,200,182,22,205,186,17,205,186,13,
  222,201,14,213,193,9,234,208,19,218,193,11,205,181,7,234,209,24,
  253,231,36,255,236,39,190,27,226,190,27,226,190,27,226,246,246,35,
  243,243,35,239,239,34,243,243,37,243,243,39,243,239,42,244,240,42,
  190,27,226,190,27,226,190,27,226,190,27,226,237,230,48,106,28,221,
  106,28,221,106,28,221,239,236,44,241,237,44,241,237,44,239,235,41,
  237,233,41,232,228,38,216,30,114,216,30,114,216,30,114,243,243,32,
  243,243,32,244,244,32,216,30,114,216,30,114,216,30,114,216,30,114,
  216,30,114,244,244,32,244,244,32,244,244,30,246,248,30,29,183,49,
  29,183,49,29,183,49,246,246,30,246,246,30,239,239,24,228,230,19,
  234,64,25,234,64,25,239,239,27,234,230,24,230,221,21,202,193,7,
  199,185,0,220,201,7,229,209,12,220,199,11,202,183,5,192,169,2,
  199,175,6,208,189,15,225,205,27,234,214,33,234,214,38,230,210,37,
  220,203,31,212,205,30,216,217,31,212,213,30,205,205,29,205,198,31,
  199,184,38,212,195,43,227,211,55,237,221,64,244,227,69,246,228,74,
  253,238,84,255,243,87,241,224,68,210,192,38,192,171,18,181,160,4,
  191,172,2,197,173,2,222,193,12,204,176,5,191,164,0,222,193,16,
  244,218,32,253,232,44,190,27,226,190,27,226,190,27,226,246,246,35,
  244,244,35,244,244,37,244,244,37,244,244,37,243,243,37,243,243,37,
  244,244,40,190,27,226,190,27,226,190,27,226,236,232,43,106,28,221,
  106,28,221,106,28,221,237,233,43,243,239,44,241,237,44,239,235,41,
  236,232,38,232,228,35,216,30,114,216,30,114,216,30,114,244,246,28,
  244,246,28,244,246,30,216,30,114,216,30,114,216,30,114,216,30,114,
  216,30,114,246,248,30,246,248,30,246,248,28,246,248,28,29,183,49,
  29,183,49,29,183,49,246,248,28,248,250,28,239,241,25,227,229,17,
  234,64,25,234,64,25,237,239,27,232,232,24,227,223,21,207,199,9,
  210,200,3,229,210,10,236,216,15,222,202,9,192,173,2,184,161,0,
  200,176,8,217,193,22,234,214,33,246,225,42,248,230,45,237,219,38,
  215,205,26,202,202,19,217,222,27,229,230,35,216,217,29,192,192,20,
  225,208,45,218,202,42,202,187,35,199,184,34,223,208,56,243,228,69,
  250,234,78,241,227,78,230,213,67,213,196,47,204,187,31,215,196,28,
  217,193,18,194,171,2,210,186,5,199,171,2,188,161,0,223,194,14,
  244,214,32,253,232,44,190,27,226,190,27,226,190,27,226,244,246,37,
  246,246,37,246,246,37,242,244,35,243,243,37,243,243,35,241,243,32,
  246,246,35,190,27,226,190,27,226,190,27,226,236,232,38,106,28,221,
  106,28,221,106,28,221,237,233,43,243,239,44,241,237,44,237,233,41,
  232,228,35,232,232,35,216,30,114,216,30,114,216,30,114,246,248,28,
  244,246,28,244,246,28,216,30,114,216,30,114,216,30,114,216,30,114,
  216,30,114,246,248,28,246,246,28,246,248,28,246,246,28,29,183,49,
  29,183,49,29,183,49,246,248,28,248,250,28,242,244,25,230,232,19,
  234,64,25,234,64,25,235,237,24,230,230,23,223,223,21,200,192,8,
  207,196,0,225,205,5,234,214,12,225,203,9,205,185,3,200,176,4,
  213,189,13,222,202,23,220,201,25,213,196,22,197,184,12,183,174,6,
  174,167,4,177,178,4,196,205,15,212,217,24,224,225,34,232,232,42,
  217,200,37,204,188,31,199,183,30,202,187,33,212,197,43,218,203,51,
  200,188,40,181,167,29,175,164,25,180,165,20,192,177,22,215,198,26,
  223,203,23,205,185,5,220,199,9,208,188,5,191,168,0,230,209,19,
  248,227,33,253,234,41,190,27,226,190,27,226,190,27,226,243,239,37,
  244,240,40,244,240,40,241,237,37,244,240,40,243,239,37,243,243,35,
  244,240,37,190,27,226,190,27,226,190,27,226,236,232,38,106,28,221,
  106,28,221,106,28,221,237,233,43,243,239,47,241,237,44,239,235,41,
  234,230,38,232,228,35,216,30,114,216,30,114,216,30,114,246,246,30,
  244,244,30,244,244,30,246,246,30,216,30,114,216,30,114,216,30,114,
  216,30,114,246,246,30,244,244,30,29,183,49,29,183,49,29,183,49,
  29,183,49,29,183,49,29,183,49,29,183,49,244,244,27,237,237,22,
  241,241,27,237,237,27,236,236,26,229,220,23,223,215,21,191,183,6,
  197,183,0,222,202,9,237,217,17,236,214,17,223,201,9,208,188,3,
  204,184,3,204,184,5,205,186,9,205,188,13,186,170,6,177,169,6,
  183,176,10,180,181,6,185,194,8,192,197,12,216,217,29,243,243,52,
  181,166,13,197,181,24,222,205,40,230,217,51,213,201,41,205,193,39,
  189,181,31,178,170,25,165,159,19,168,161,16,175,166,14,186,174,15,
  202,186,17,213,195,15,232,211,24,212,192,9,192,172,0,225,204,16,
  237,215,24,248,229,35,190,27,226,190,27,226,190,27,226,248,239,40,
  250,241,40,248,239,40,246,238,40,246,238,40,246,238,40,244,236,37,
  246,238,40,190,27,226,190,27,226,190,27,226,236,232,38,106,28,221,
  106,28,221,106,28,221,239,236,44,241,237,44,239,236,44,237,233,41,
  234,230,38,234,230,36,216,30,114,216,30,114,216,30,114,246,242,30,
  246,242,30,246,242,30,246,242,30,246,242,30,216,30,114,216,30,114,
  216,30,114,246,242,30,246,242,30,29,183,49,29,183,49,29,183,49,
  29,183,49,29,183,49,29,183,49,29,183,49,244,244,32,239,239,27,
  234,64,25,234,64,25,237,229,29,227,219,21,220,212,18,192,182,6,
  192,174,2,223,204,16,244,222,27,243,221,22,232,210,12,212,191,3,
  202,181,0,208,188,3,217,198,9,222,203,16,215,197,18,207,197,17,
  199,191,16,185,186,12,176,181,6,180,181,8,194,195,18,213,205,30,
  205,192,27,199,186,24,202,190,29,215,202,39,220,212,47,229,216,53,
  229,220,55,215,208,52,195,191,41,188,181,32,191,185,31,207,199,36,
  218,206,38,217,200,29,232,214,33,208,191,15,189,172,2,205,187,7,
  223,204,18,243,224,30,190,27,226,190,27,226,190,27,226,248,239,40,
  244,236,37,244,236,40,248,239,40,248,239,40,248,239,40,248,239,40,
  250,242,43,190,27,226,190,27,226,190,27,226,234,230,38,106,28,221,
  106,28,221,106,28,221,239,236,44,239,236,44,237,233,43,237,233,41,
  234,230,38,234,230,36,216,30,114,216,30,114,216,30,114,248,240,33,
  248,240,33,248,240,33,248,240,33,248,240,33,216,30,114,216,30,114,
  216,30,114,248,240,33,248,240,33,29,183,49,29,183,49,29,183,49,
  29,183,49,29,183,49,29,183,49,29,183,49,243,243,32,237,237,29,
  234,64,25,234,64,25,236,227,26,232,224,24,218,208,16,202,193,7,
  210,192,13,230,210,26,237,216,27,232,211,17,222,200,7,212,190,0,
  208,189,0,218,199,3,223,203,5,223,203,7,215,200,9,197,187,6,
  169,162,4,156,157,5,167,168,4,176,177,9,188,188,17,202,195,25,
  223,210,38,204,188,27,192,180,25,207,195,38,230,218,58,229,221,58,
  241,232,70,232,225,70,207,208,57,205,205,56,223,216,65,239,232,72,
  237,228,64,223,210,47,234,218,50,220,203,33,189,173,10,188,171,2,
  222,207,20,236,221,26,232,224,26,230,226,28,236,232,31,236,232,31,
  230,226,28,234,230,31,241,237,37,244,240,40,244,240,40,244,240,40,
  246,242,40,244,240,40,237,233,36,232,228,35,232,228,38,234,230,38,
  237,233,41,241,237,44,239,236,44,237,233,43,236,232,41,236,232,38,
  234,230,38,236,232,38,232,228,35,239,239,39,244,240,37,244,244,32,
  244,244,32,244,244,30,244,244,30,244,244,30,244,244,30,244,244,30,
  244,244,30,244,244,30,244,244,32,244,244,32,244,244,32,248,244,33,
  243,239,30,246,241,32,244,244,30,246,246,30,243,243,27,237,237,24,
  248,248,30,234,234,24,232,232,24,243,239,32,215,207,16,204,195,9,
  212,194,15,212,192,17,213,193,13,217,196,11,217,198,9,223,201,5,
  220,201,3,210,191,0,200,182,0,200,186,0,212,198,3,229,218,14,
  243,232,27,250,250,53,243,244,57,218,218,40,200,193,26,199,190,22,
  225,212,41,212,197,37,202,187,35,208,193,44,215,200,52,199,185,44,
  202,194,49,197,194,54,198,199,56,217,217,70,239,233,84,246,239,84,
  241,232,75,234,218,61,243,231,64,232,215,47,195,182,16,181,168,2,
  208,194,9,222,212,16,220,212,20,229,229,28,234,234,29,232,232,28,
  230,230,28,229,229,28,243,243,37,243,243,37,243,243,37,246,246,40,
  243,243,37,246,246,40,236,232,34,232,228,35,232,228,35,237,233,41,
  239,236,44,241,237,44,244,240,47,237,229,41,237,233,41,239,235,41,
  234,230,38,236,232,36,234,230,36,239,239,39,244,244,35,244,246,30,
  246,246,30,246,246,30,246,248,28,246,246,28,246,248,28,244,246,28,
  243,243,27,246,248,30,246,246,30,243,243,30,244,244,32,248,248,33,
  243,243,27,246,246,30,248,248,30,246,248,28,244,246,28,242,244,27,
  246,248,30,232,232,21,232,232,24,241,237,27,204,200,9,200,192,8,
  225,211,21,227,208,23,229,208,21,225,204,18,215,194,13,217,196,11,
  220,200,14,213,193,11,210,192,11,212,194,11,218,199,11,227,213,19,
  234,224,29,241,233,51,244,237,59,236,228,52,218,209,38,210,201,30,
  225,209,48,215,200,46,208,193,46,192,178,39,178,163,34,166,154,29,
  150,138,21,136,131,17,156,157,29,194,194,55,227,221,78,250,243,90,
  248,240,87,237,229,72,243,235,69,232,219,49,202,190,21,186,176,2,
  188,178,0,205,195,7,212,208,13,223,223,23,225,227,25,232,234,29,
  237,239,32,232,234,29,239,241,32,241,243,35,241,243,35,244,246,37,
  241,241,34,244,246,37,234,234,31,229,225,30,234,230,36,236,228,38,
  237,229,41,241,233,44,243,235,44,237,229,41,237,229,41,239,231,41,
  237,233,38,239,235,39,239,235,39,239,235,36,243,243,35,242,244,30,
  242,244,27,244,246,28,244,246,25,244,246,25,244,246,25,246,248,25,
  244,246,25,248,250,28,248,250,30,244,246,30,246,248,30,244,244,30,
  243,243,27,244,244,27,246,248,28,244,246,25,246,248,28,251,253,31,
  248,250,30,239,239,24,232,232,21,220,220,16,192,192,4,197,189,6,
  218,204,16,241,222,27,251,230,36,244,223,35,229,209,28,218,198,24,
  218,195,27,217,198,27,213,194,28,212,190,26,204,186,21,202,184,21,
  204,188,25,213,204,37,227,218,46,234,225,50,222,209,38,213,196,28,
  237,219,64,229,209,62,215,200,59,200,185,52,183,166,44,178,162,43,
  177,164,43,177,170,41,177,177,39,177,177,41,186,183,47,208,202,61,
  227,219,71,230,221,69,227,219,60,220,211,44,199,190,20,183,174,4,
  175,168,0,199,191,4,205,201,9,215,215,20,225,225,25,230,230,30,
  227,229,28,230,230,30,246,246,37,243,243,35,246,246,37,244,246,35,
  243,243,35,246,246,35,236,236,31,229,225,30,237,233,36,236,232,36,
  239,235,39,244,236,42,241,233,41,241,233,41,237,229,38,237,233,38,
  241,237,39,234,230,36,239,235,36,241,241,37,244,244,37,242,244,30,
  244,246,30,249,251,31,249,251,31,248,250,28,246,248,25,244,246,25,
  246,248,28,244,246,25,244,246,30,246,248,33,244,246,32,250,250,30,
  246,246,28,244,244,27,246,248,28,248,250,30,248,250,30,242,244,25,
  227,229,19,235,237,24,232,232,24,210,206,13,191,187,4,189,181,2,
  204,190,5,236,217,24,251,230,36,253,232,44,248,228,48,230,204,42,
  215,190,39,212,188,43,210,184,42,204,179,41,178,157,27,165,145,19,
  171,150,21,178,162,22,188,173,23,197,181,26,195,177,20,184,167,12,
  250,233,83,248,225,85,230,208,74,199,179,56,191,172,54,222,202,76,
  243,227,90,241,233,87,234,231,78,218,212,66,191,185,50,181,174,44,
  194,187,51,205,195,54,195,184,41,184,173,26,178,170,17,189,180,14,
  192,183,12,195,185,8,204,197,13,208,204,19,222,218,27,229,225,30,
  229,225,30,234,230,33,243,239,39,244,240,40,243,239,37,243,243,37,
  246,246,37,244,244,37,236,236,31,229,225,28,236,232,34,234,230,36,
  241,237,39,246,242,42,239,235,39,237,233,38,237,233,38,237,233,36,
  241,237,37,234,230,33,236,232,34,244,240,37,244,244,37,244,244,35,
  246,246,35,246,246,32,244,244,27,243,243,27,246,246,28,244,244,27,
  246,246,30,243,243,30,243,243,32,244,244,35,243,243,32,241,237,27,
  244,239,27,248,244,28,244,244,27,243,243,27,246,246,30,241,241,27,
  218,218,16,234,230,26,237,233,29,212,204,15,195,187,6,205,196,11,
  223,204,18,230,209,23,234,214,29,239,218,36,241,221,44,230,207,42,
  229,203,46,244,218,61,246,225,72,243,223,76,227,202,62,215,191,54,
  215,191,54,205,188,39,205,187,33,215,197,37,227,204,39,212,190,26,
  244,219,83,222,200,72,202,180,59,174,154,42,186,166,51,222,202,76,
  236,218,88,244,233,88,251,245,91,241,233,85,204,197,60,175,168,42,
  178,169,45,188,175,51,172,160,35,160,150,23,165,155,19,178,167,22,
  199,187,28,200,187,24,197,188,16,207,199,19,227,217,30,232,224,35,
  234,226,33,244,236,42,244,236,40,248,239,40,246,238,40,248,239,40,
  253,245,44,246,238,35,243,235,35,234,226,31,234,230,33,243,239,39,
  243,239,39,243,239,39,243,239,42,236,232,36,236,232,36,236,232,34,
  239,235,36,241,237,34,237,233,34,243,239,37,250,241,40,248,239,35,
  250,241,35,250,241,35,246,237,30,246,237,30,251,247,33,250,241,33,
  251,242,33,251,243,36,251,243,36,248,240,38,248,239,35,251,242,33,
  251,243,31,250,241,30,253,244,33,253,244,33,246,237,30,227,219,21,
  210,202,11,230,222,26,244,234,35,220,210,20,205,196,13,230,212,30,
  241,221,37,232,212,31,225,205,27,222,202,27,217,197,24,208,189,21,
  208,189,25,229,207,42,250,231,60,255,237,72,255,236,74,250,224,70,
  236,209,59,217,193,42,199,178,26,194,170,20,210,185,30,212,186,26,
  189,163,50,197,171,58,146,125,25,113,97,6,149,130,27,184,165,50,
  218,197,72,230,215,79,210,202,63,186,174,51,174,162,44,184,172,54,
  218,204,79,236,223,97,189,176,59,180,166,47,199,184,56,172,158,35,
  163,149,25,146,132,12,150,137,2,186,174,12,212,199,26,195,182,16,
  197,184,16,237,223,38,251,241,46,243,233,37,243,233,37,253,242,41,
  251,240,43,234,224,29,244,234,37,234,226,31,225,221,25,246,242,40,
  232,228,31,220,216,25,241,233,39,237,229,36,237,233,36,218,214,22,
  210,202,17,241,237,34,237,233,34,246,241,37,246,236,40,234,224,29,
  230,220,26,239,228,29,243,232,32,244,233,30,246,235,30,236,225,24,
  223,212,18,213,203,15,192,182,4,168,159,0,160,152,0,191,181,2,
  236,226,22,251,243,36,237,226,24,218,208,14,230,219,21,246,235,32,
  236,226,29,204,195,11,181,168,2,183,167,6,174,159,4,178,161,6,
  204,186,23,227,204,37,232,213,38,223,203,27,218,200,20,220,202,16,
  212,194,9,202,185,5,210,190,13,230,210,26,234,214,33,220,201,27,
  204,186,21,200,175,26,168,146,11,143,122,0,171,146,7,205,177,19,
  199,172,58,184,158,48,133,110,16,97,78,1,120,101,10,143,125,23,
  168,148,37,183,163,44,189,175,48,210,196,66,225,210,79,227,212,82,
  215,199,78,222,208,87,169,153,50,172,155,49,230,210,88,229,209,81,
  189,173,50,159,142,24,150,136,8,166,150,7,177,160,11,165,149,4,
  178,163,6,222,204,27,237,219,34,236,217,31,237,218,31,237,222,31,
  234,216,29,220,206,22,239,225,34,227,217,28,220,212,25,237,229,34,
  217,209,22,205,198,17,230,222,30,239,231,34,243,235,37,212,205,20,
  194,186,8,230,222,30,234,226,33,244,236,42,250,235,45,229,211,30,
  227,209,28,244,225,37,253,233,38,251,236,36,246,231,32,230,215,23,
  220,206,18,208,190,13,191,174,6,165,150,0,163,148,0,180,163,0,
  199,182,10,220,206,18,232,218,24,237,222,29,236,221,26,246,231,35,
  230,212,28,192,175,8,181,165,4,199,181,20,183,166,13,147,130,2,
  153,132,5,189,166,25,208,187,30,207,188,19,215,195,16,225,206,14,
  220,201,9,207,189,5,200,182,2,208,190,9,210,190,15,199,180,10,
  191,166,10,195,168,18,168,144,7,140,113,0,153,127,2,174,149,6,
  189,163,53,156,133,32,115,95,9,87,69,0,92,74,0,111,93,4,
  146,127,21,181,161,40,220,201,64,244,228,86,236,218,81,218,200,72,
  212,193,73,246,225,101,215,196,80,225,204,88,250,230,108,204,184,68,
  127,110,16,123,106,9,142,126,8,156,138,8,165,146,9,151,136,2,
  156,140,2,189,171,8,210,190,17,227,208,25,229,210,23,207,190,13,
  191,174,6,200,183,12,234,216,33,236,226,38,222,212,29,227,217,30,
  222,212,27,229,220,33,241,231,39,234,224,33,246,235,42,218,209,27,
  200,190,16,223,214,32,212,203,24,208,195,21,207,190,23,205,187,21,
  212,193,24,222,202,27,222,202,27,227,206,25,236,217,31,217,199,20,
  200,182,10,188,171,4,177,159,2,157,141,0,165,148,0,166,149,0,
  162,145,0,184,166,4,204,185,13,205,188,13,200,182,10,218,198,22,
  192,174,12,160,144,2,162,143,4,181,161,17,172,150,14,132,114,3,
  136,116,0,171,150,18,194,174,24,202,184,19,210,192,15,222,203,16,
  222,203,14,215,196,9,213,195,11,215,196,18,212,192,17,204,181,15,
  202,177,19,204,173,23,177,145,9,157,126,2,162,130,5,163,131,4,
  99,77,2,93,72,1,92,72,1,105,85,3,133,110,12,159,134,26,
  159,136,23,180,158,36,213,191,60,188,168,44,150,131,21,160,142,31,
  197,178,58,195,175,61,213,192,77,251,234,113,251,231,106,183,161,52,
  127,107,12,123,106,7,128,109,3,154,133,8,188,165,25,175,152,13,
  156,134,2,169,145,0,194,175,8,212,192,15,217,197,20,192,173,6,
  172,154,0,175,158,4,192,176,14,199,182,20,180,168,13,184,169,15,
  199,183,22,220,206,33,225,211,36,207,190,25,236,218,45,239,222,46,
  227,210,39,222,205,38,189,174,18,165,149,4,169,149,7,186,162,17,
  210,185,30,225,198,36,199,177,20,191,169,12,217,195,27,195,173,10,
  181,160,4,183,162,6,180,159,4,165,142,2,174,154,6,175,151,4,
  163,141,4,183,162,8,192,170,12,177,160,4,163,143,0,175,154,4,
  168,145,4,149,128,2,160,138,8,186,162,27,160,138,13,123,104,0,
  131,111,0,159,137,8,180,157,15,186,165,12,189,170,6,194,175,4,
  195,175,4,199,179,4,199,179,6,200,177,10,210,183,19,212,186,24,
  207,179,25,199,169,26,188,156,21,175,144,14,159,129,7,138,111,2,
  110,85,7,98,74,2,115,90,9,138,114,18,136,112,13,143,119,15,
  147,122,14,144,124,13,147,129,17,125,109,7,118,101,0,140,123,16,
  180,161,45,162,144,38,178,156,50,205,182,72,205,182,70,146,123,27,
  116,95,7,111,93,3,111,89,0,139,118,3,183,159,21,186,162,19,
  165,143,4,174,150,4,197,170,10,197,170,10,195,168,8,186,164,4,
  177,156,2,163,143,0,163,143,0,172,152,9,153,138,5,135,121,0,
  153,139,7,178,162,17,171,155,12,172,156,13,200,182,28,202,185,31,
  195,178,26,195,178,28,174,155,16,149,128,3,153,131,5,177,153,18,
  197,172,30,217,190,37,210,183,30,192,168,18,197,170,18,184,158,10,
  178,154,4,183,159,8,186,161,10,184,160,10,186,160,12,189,163,14,
  184,160,13,184,158,13,175,150,9,174,150,7,175,151,7,165,141,4,
  162,139,7,163,140,10,194,170,32,213,184,47,162,137,18,118,95,0,
  122,98,0,150,127,3,165,142,5,168,145,2,171,150,0,168,151,0,
  165,145,0,175,150,0,177,152,0,171,147,0,174,149,6,184,158,13,
  192,163,22,177,146,16,184,152,24,188,156,27,154,125,10,122,92,0,
  95,72,3,88,64,1,122,95,10,177,147,38,184,152,39,183,153,35,
  184,155,35,156,132,19,119,102,3,116,99,3,142,122,13,143,124,15,
  143,124,19,128,111,15,99,81,8,99,81,9,115,95,12,102,83,4,
  99,80,0,104,84,0,104,83,0,120,97,0,160,134,8,183,158,17,
  183,154,13,194,167,16,207,179,19,192,164,8,189,161,6,189,164,8,
  181,156,6,162,139,0,163,141,4,172,150,13,159,139,12,122,104,0,
  131,113,3,151,130,5,146,126,2,165,143,12,168,146,14,153,133,8,
  146,126,5,165,143,14,168,145,16,157,135,11,146,118,3,144,116,5,
  159,129,10,181,150,20,195,163,26,200,166,26,199,165,22,180,150,9,
  177,149,8,186,161,14,204,173,21,207,179,25,184,158,13,174,149,6,
  165,141,4,147,119,2,143,118,0,172,145,11,180,152,17,147,119,2,
  149,122,5,165,136,14,204,171,41,210,178,47,157,129,16,113,90,0,
  124,99,0,153,128,4,172,147,9,180,154,8,188,163,10,188,162,6,
  181,156,4,188,161,8,188,161,10,171,143,6,163,133,5,174,144,13,
  191,159,25,181,150,26,202,170,41,217,183,48,175,144,21,135,106,3,
  124,94,0,118,89,0,157,129,15,191,160,35,157,126,16,133,104,4,
  142,113,9,132,107,4,110,89,0,138,115,7,171,147,28,157,136,19,
  116,95,4,99,80,1,97,78,2,104,84,5,115,93,6,125,102,8,
  119,96,4,115,93,4,123,99,4,131,105,3,159,130,7,183,151,17,
  191,158,18,192,158,14,189,159,10,189,158,6,197,165,10,202,170,15,
  191,163,8,171,145,2,168,143,4,178,154,17,178,155,24,156,134,10,
  139,118,2,151,130,7,174,151,18,181,157,22,166,143,14,154,132,7,
  154,132,8,168,142,16,171,145,18,171,142,19,171,140,19,144,113,5,
  151,120,7,163,132,10,162,131,10,160,129,8,151,121,2,165,134,2,
  172,140,4,192,159,16,202,167,19,208,172,23,194,160,14,168,137,4,
  181,149,10,189,156,16,171,139,7,159,130,4,178,146,17,166,135,12,
  159,129,10,144,115,3,146,115,5,144,113,6,143,113,5,140,110,3,
  133,103,0,140,113,0,159,130,4,174,146,6,175,149,4,178,148,4,
  186,156,10,189,156,14,177,146,13,168,136,12,163,133,14,163,130,15,
  169,136,19,174,141,25,159,130,16,162,133,18,157,129,15,157,128,13,
  162,130,5,153,123,2,174,142,13,186,154,25,150,118,6,125,95,0,
  120,90,0,120,93,0,131,106,3,151,124,11,151,128,13,151,128,13,
  151,125,14,135,111,9,144,118,16,169,142,33,184,156,43,178,150,38,
  147,118,15,166,135,24,191,159,33,175,143,16,180,148,17,186,152,17,
  189,154,14,186,151,10,186,152,8,199,163,12,204,168,13,200,164,12,
  207,171,17,202,171,17,200,168,16,208,178,32,204,178,33,184,160,21,
  162,136,7,175,147,14,204,178,31,188,159,21,166,139,7,150,125,2,
  154,126,4,163,134,10,151,123,5,146,118,3,151,120,7,160,125,12,
  163,126,10,166,128,10,197,159,26,210,174,30,162,130,2,157,125,0,
  162,129,0,174,139,2,174,139,2,191,156,8,207,171,17,195,160,10,
  191,157,12,200,163,18,184,150,12,162,130,2,168,136,7,157,123,5,
  144,110,2,138,104,0,139,105,0,142,108,2,153,121,7,149,113,3,
  142,107,0,140,109,0,156,126,4,168,135,4,160,128,2,159,127,0,
  162,131,4,163,132,7,163,130,12,156,121,11,142,110,8,133,102,4,
  142,109,9,150,116,12,153,125,13,160,128,16,160,131,15,160,130,13,
  192,156,12,178,144,6,184,150,12,189,155,18,156,122,2,133,101,0,
  123,93,0,135,106,2,163,133,15,169,140,17,153,125,8,163,135,15,
  181,152,28,147,121,11,163,135,23,188,158,40,204,169,49,188,152,38,
  150,117,14,171,135,24,199,162,32,171,138,9,171,138,7,175,142,9,
  183,149,10,178,143,4,184,148,6,184,148,4,183,146,2,177,142,2,
  199,161,10,210,173,19,210,177,21,212,181,30,205,175,27,184,155,15,
  165,138,4,172,144,7,192,163,18,184,155,13,166,139,4,153,123,0,
  156,126,0,165,134,4,166,135,5,177,146,15,197,160,28,191,151,25,
  171,132,12,156,120,4,162,127,5,183,149,13,188,153,14,175,141,4,
  169,135,0,169,135,0,184,148,4,202,166,13,199,163,10,183,149,4,
  175,141,4,183,149,6,166,133,2,149,116,0,165,129,2,172,136,9,
  156,120,4,143,108,0,147,111,0,166,128,9,192,152,24,174,135,14,
  154,118,5,147,112,2,159,125,5,163,128,4,156,121,0,153,119,0,
  153,117,4,168,131,14,177,139,24,163,128,22,140,105,10,123,90,3,
  129,95,4,135,104,5,149,118,8,154,125,10,160,130,13,160,130,10,
  192,153,14,186,148,12,181,143,8,180,146,8,184,149,10,165,132,2,
  162,130,5,166,135,9,157,127,8,160,129,8,160,131,7,157,129,7,
  150,122,6,153,124,7,143,115,5,142,112,6,150,116,12,153,119,14,
  147,114,9,168,131,17,174,138,14,157,124,4,154,117,0,166,126,2,
  183,145,10,181,140,8,180,142,6,165,126,2,162,123,0,168,131,2,
  189,153,8,210,171,19,205,169,17,191,157,12,181,152,10,166,138,2,
  160,130,2,166,138,2,177,148,6,183,154,10,168,140,2,165,133,0,
  178,146,8,194,160,18,194,160,18,178,145,9,159,125,5,156,120,4,
  163,125,4,180,139,11,194,155,18,186,147,10,208,170,21,200,162,14,
  192,155,8,186,149,2,195,157,8,207,168,13,189,152,4,166,132,0,
  165,132,0,184,148,6,177,142,4,160,129,4,178,144,8,189,151,16,
  172,135,7,153,120,2,156,122,2,177,138,13,200,158,26,183,143,17,
  169,131,11,166,127,9,177,138,13,181,140,13,171,131,7,153,116,0,
  144,110,3,163,126,14,180,142,29,178,138,31,153,114,19,128,93,6,
  123,88,2,132,100,0,151,120,7,165,134,12,171,140,16,166,135,12,
  174,133,7,181,140,10,169,129,4,169,132,2,204,167,19,184,149,8,
  188,153,12,188,150,16,149,116,3,151,121,2,159,128,4,146,117,2,
  129,100,0,159,129,7,142,114,3,132,100,0,138,105,3,157,121,11,
  168,130,17,178,139,22,180,141,17,166,130,5,165,126,2,177,136,9,
  177,137,8,174,133,4,183,141,8,178,136,4,172,131,2,180,141,4,
  194,157,12,213,175,24,205,168,19,188,155,12,178,146,8,168,136,2,
  174,145,4,180,147,6,184,151,10,197,162,16,178,145,6,171,139,2,
  181,148,8,189,156,14,192,159,16,189,154,14,174,141,9,154,118,4,
  162,124,5,188,150,14,192,153,16,188,149,12,194,158,14,189,153,10,
  180,145,4,186,150,6,197,159,10,200,162,10,192,154,6,172,138,2,
  181,146,6,200,163,16,191,155,12,184,149,10,199,162,18,195,159,18,
  181,147,11,168,133,6,160,124,0,166,130,4,178,142,13,177,140,11,
  172,133,11,169,130,7,177,138,13,184,143,13,177,136,9,151,114,0,
  135,101,0,146,111,5,163,124,17,166,124,22,150,113,14,136,98,7,
  131,96,3,139,105,0,157,124,7,175,140,16,175,140,18,165,130,10,
  175,135,9,180,139,11,163,125,4,162,123,0,204,160,23,194,155,16,
  200,159,18,205,166,27,178,141,11,174,141,9,174,140,7,160,129,4,
  146,116,0,157,127,4,142,110,0,140,106,0,146,111,3,171,134,18,
  177,140,22,171,131,14,160,122,7,159,121,2,168,129,7,180,140,13,
  181,140,11,178,135,9,166,126,4,168,128,2,169,129,2,174,132,2,
  180,142,6,192,152,12,188,153,12,171,138,4,165,132,2,160,129,0,
  169,138,4,183,150,11,192,159,16,202,168,21,188,155,14,174,142,4,
  174,140,4,175,141,6,171,138,4,178,144,9,186,151,15,186,148,15,
  175,138,9,172,135,7,184,147,15,202,163,25,172,139,6,181,147,10,
  192,156,14,200,163,18,195,159,14,199,162,16,197,160,16,180,146,8,
  181,147,10,197,161,20,183,149,10,168,135,4,194,158,16,213,176,28,
  208,171,25,192,154,18,177,140,9,168,133,6,166,127,5,165,126,5,
  160,122,2,162,123,0,172,132,4,181,140,10,180,139,8,151,114,0,
  131,98,0,140,105,2,159,122,12,171,130,21,162,126,18,153,115,14,
  140,106,5,153,117,5,169,134,11,186,147,23,183,144,21,172,134,14,
  184,143,13,174,134,6,162,123,0,171,132,6,199,157,24,194,153,24,
  194,153,24,207,164,29,171,135,7,171,138,7,197,161,20,175,141,6,
  163,131,2,174,140,7,191,154,23,183,144,19,159,122,8,172,132,14,
  171,131,12,160,122,7,153,114,0,177,138,15,194,152,24,177,136,13,
  172,132,11,186,144,19,156,118,5,177,135,9,180,137,11,168,129,4,
  163,125,4,174,134,6,184,146,13,194,160,22,186,152,19,172,140,11,
  163,131,5,174,141,11,186,153,15,184,152,15,194,160,22,162,128,7,
  144,112,0,175,143,13,180,148,17,184,147,17,181,141,15,159,122,4,
  156,123,4,165,126,5,159,125,4,166,130,5,172,136,9,150,114,3,
  143,109,3,160,126,5,178,140,9,181,147,11,169,137,6,147,115,2,
  150,117,3,175,142,11,168,136,6,147,114,0,154,123,2,163,131,4,
  168,135,4,166,134,4,166,133,5,163,129,7,159,125,5,162,125,7,
  174,133,7,171,130,2,163,124,2,162,123,2,171,130,2,177,136,6,
  166,127,5,157,119,5,151,114,4,150,114,6,151,115,8,168,130,17,
  169,131,17,160,123,8,162,128,7,175,136,14,175,137,16,171,133,14,
  180,137,11,166,126,4,162,123,4,174,133,11,186,146,21,174,134,16,
  168,129,12,181,141,19,150,114,3,159,122,5,205,168,21,186,152,8,
  189,154,12,188,153,14,212,172,30,197,158,20,168,133,6,172,133,9,
  171,133,11,156,118,5,149,112,2,171,132,12,204,162,31,191,150,23,
  168,128,9,197,154,26,199,155,26,195,152,24,178,137,13,150,113,3,
  144,108,3,171,131,12,192,151,22,194,161,26,181,148,20,163,132,9,
  150,120,2,160,129,8,178,146,18,177,144,16,159,128,8,147,118,3,
  136,106,0,162,128,10,163,129,10,150,118,5,149,117,2,159,129,7,
  172,140,14,168,137,11,147,115,3,142,108,2,166,132,9,162,131,7,
  162,131,7,178,146,15,169,138,11,154,121,5,166,135,9,146,114,3,
  139,109,2,168,137,11,174,142,13,162,130,5,153,120,4,135,102,0,
  151,119,4,166,135,9,172,140,13,165,131,9,154,121,5,157,121,7,
  160,121,4,168,129,6,175,134,7,174,133,4,177,136,6,178,137,8,
  165,126,2,157,119,0,154,117,0,156,118,4,156,120,5,163,126,10,
  157,121,7,162,124,5,160,122,5,168,130,9,172,134,13,180,141,18,
  163,124,10,162,124,9,163,125,9,162,124,9,156,116,7,139,99,3,
  146,108,5,163,126,14,136,102,3,153,117,5,207,169,17,199,161,10,
  218,178,22,208,170,21,225,182,32,200,163,16,181,142,6,180,139,8,
  177,138,13,151,115,7,139,104,0,162,125,10,199,158,30,194,154,28,
  174,136,16,181,142,20,171,131,12,174,134,14,157,119,5,139,104,0,
  151,114,5,195,153,28,200,159,30,180,144,20,162,132,12,143,115,3,
  136,108,0,143,115,3,166,136,14,200,167,36,136,107,5,135,106,2,
  153,124,8,147,116,6,153,124,8,146,118,6,147,116,5,168,137,14,
  163,133,12,156,126,8,166,136,14,171,141,18,150,121,5,160,130,10,
  172,141,18,183,150,22,181,149,22,174,143,18,178,147,22,154,125,7,
  133,106,0,159,128,8,184,152,23,180,148,20,160,131,12,127,96,0,
  153,124,7,180,148,20,195,162,30,175,144,18,147,116,5,139,106,2,
  146,110,0,157,120,4,169,131,9,178,138,13,188,147,16,175,135,9,
  157,119,0,162,123,0,163,124,2,163,125,4,157,119,0,154,117,2,
  159,122,4,163,125,4,163,125,4,165,126,4,171,131,7,186,145,17,
  147,111,6,151,115,7,156,119,8,150,114,8,138,103,0,128,93,0,
  135,99,2,151,112,8,133,98,2,156,120,5,215,176,20,215,175,16,
  232,193,24,212,172,13,212,172,15,192,154,6,181,145,2,200,156,18,
  191,150,23,162,124,12,143,108,3,156,118,5,199,156,30,188,148,27,
  166,127,12,183,142,22,154,117,7,168,129,14,162,126,12,139,105,3,
  135,102,2,146,111,6,165,129,14,163,127,15,149,117,6,146,118,5,
  142,114,3,139,108,0,149,117,6,212,175,47,136,105,7,131,100,3,
  162,130,17,146,116,8,156,124,13,146,116,8,139,111,3,166,135,15,
  159,130,12,153,124,8,171,140,19,204,167,39,204,171,39,189,158,31,
  177,147,24,166,135,15,138,108,3,136,107,5,171,140,19,172,141,19,
  146,117,3,149,120,6,184,152,26,189,157,29,168,138,16,154,125,10,
  168,138,16,197,161,34,217,179,46,192,156,31,147,116,6,142,108,3,
  140,106,0,144,108,2,165,127,7,184,144,17,189,148,18,172,133,9,
  156,118,0,157,119,0,162,123,2,166,127,5,160,123,4,156,119,2,
  169,130,7,181,140,13,183,141,11,166,127,4,157,120,2,162,124,4,
  138,104,3,147,112,8,146,111,6,131,99,2,120,87,0,127,93,2,
  138,104,3,157,120,10,147,111,3,178,137,8,232,192,31,217,177,18,
  220,180,20,191,154,6,188,151,6,172,138,2,178,143,4,220,178,31,
  220,177,40,188,147,25,159,121,7,146,110,3,178,138,20,180,140,22,
  168,127,17,166,126,17,113,80,0,138,105,5,154,118,11,149,114,8,
  143,109,5,154,118,11,156,121,10,143,110,5,138,108,3,153,121,11,
  156,124,13,143,113,6,133,102,4,213,176,49,165,133,19,135,104,5,
  132,101,4,143,111,8,159,125,18,124,95,7,119,90,0,156,124,13,
  183,149,30,184,150,30,156,124,13,149,118,9,162,129,22,174,141,25,
  172,139,23,159,127,15,150,118,9,162,130,17,163,131,18,175,145,25,
  177,147,24,154,125,11,168,138,19,169,139,19,149,121,8,149,121,8,
  156,127,13,186,151,28,213,176,47,199,163,38,153,119,11,146,112,6,
  140,107,2,133,97,0,153,116,5,180,141,17,189,148,21,177,138,13,
  163,125,4,160,122,2,156,119,2,156,119,2,159,122,5,160,121,5,
  157,119,5,175,134,7,202,162,19,186,148,12,162,123,0,153,116,0,
  136,103,6,142,109,8,138,105,5,122,91,0,124,93,0,133,100,3,
  144,109,6,165,126,9,168,128,2,202,165,17,243,202,39,213,175,22,
  205,161,23,166,127,4,168,129,4,157,119,0,175,138,6,227,185,35,
  244,198,52,210,166,34,168,129,11,150,111,5,166,125,14,171,130,19,
  163,123,18,159,118,18,116,82,2,135,98,7,153,115,14,151,117,13,
  150,115,11,178,141,25,147,114,11,128,97,0,138,106,5,166,131,22,
  175,140,27,157,123,16,127,97,4,186,150,36,178,143,31,132,102,8,
  109,81,0,136,105,7,154,121,17,140,108,12,131,100,4,147,116,9,
  169,136,22,186,149,34,175,143,27,146,114,11,120,92,2,149,116,11,
  175,140,27,171,138,24,165,130,20,163,131,20,151,118,13,178,145,29,
  197,166,40,157,129,16,149,121,11,157,126,15,142,112,6,125,96,2,
  127,97,2,157,123,16,204,168,43,200,164,40,166,133,20,163,128,17,
  149,114,8,128,93,0,139,105,3,169,130,11,184,144,19,178,140,17,
  166,128,7,159,122,4,151,114,2,147,110,0,159,121,7,165,126,10,
  151,114,4,171,132,6,205,164,21,192,153,14,166,130,2,159,120,0,
  147,110,12,175,138,27,138,103,9,102,71,0,124,91,3,136,102,3,
  138,104,3,159,122,4,180,142,8,210,169,24,227,181,37,205,162,29,
  194,154,32,125,88,0,113,80,2,120,85,0,154,118,4,202,160,25,
  223,178,38,174,135,18,147,111,3,143,102,2,150,109,8,184,139,30,
  189,144,36,154,114,17,114,81,3,139,102,12,140,103,12,132,95,6,
  135,103,5,154,119,14,139,107,7,122,91,0,123,94,2,129,99,4,
  138,106,7,142,110,9,138,106,7,174,139,30,181,146,35,142,111,13,
  115,87,2,120,91,2,122,92,3,131,100,8,140,109,12,156,122,16,
  188,152,38,191,155,39,166,132,24,147,115,14,118,89,0,154,121,16,
  177,142,31,139,107,7,172,137,28,205,168,50,165,131,24,132,102,7,
  138,109,7,136,107,7,144,112,13,149,119,14,138,106,7,122,92,0,
  123,93,0,136,105,7,174,139,28,146,114,14,128,98,4,151,118,13,
  153,117,10,139,101,0,143,108,3,156,119,8,162,124,10,165,126,10,
  163,125,9,168,129,11,165,126,10,156,119,7,151,114,4,147,111,3,
  138,103,0,151,115,2,181,140,11,197,154,20,189,148,16,175,134,7,
  132,95,6,172,130,25,154,116,13,132,97,3,166,126,17,162,122,15,
  154,117,8,162,124,10,178,139,15,192,152,24,188,147,25,180,142,26,
  171,129,26,108,73,0,116,82,4,140,101,7,184,144,24,210,167,38,
  199,157,34,147,108,12,128,91,2,131,93,0,132,94,3,157,117,18,
  156,116,19,118,81,3,97,64,0,122,86,4,120,85,4,108,75,0,
  132,98,6,157,122,19,136,104,9,119,89,0,127,97,3,129,99,4,
  133,101,8,135,105,9,125,94,3,123,93,5,139,107,12,124,94,5,
  108,78,0,108,78,0,106,77,0,120,91,6,153,119,19,175,140,30,
  180,145,35,160,126,21,147,115,14,144,112,13,109,81,0,131,101,8,
  149,117,14,120,91,3,162,128,23,181,146,35,131,101,10,127,98,6,
  140,109,12,119,91,3,102,76,0,113,86,3,133,103,8,123,94,3,
  123,94,3,125,96,4,162,129,25,123,93,4,109,82,2,153,120,17,
  160,124,16,140,103,2,139,102,2,151,115,7,163,126,14,157,119,8,
  143,108,2,150,114,5,162,124,12,163,125,12,150,114,5,142,106,0,
  146,110,3,153,116,4,157,119,4,168,128,9,171,133,11,169,129,9,
  108,72,3,154,113,13,163,121,17,160,117,13,178,133,24,163,120,15,
  159,116,12,181,140,28,181,137,28,153,114,11,150,110,11,147,108,12,
  129,90,8,125,90,7,140,102,13,175,132,28,204,160,41,168,125,22,
  114,79,5,122,85,8,143,105,11,135,97,5,135,98,6,146,107,12,
  135,97,9,105,70,2,98,64,0,116,82,3,113,80,3,105,73,0,
  123,88,3,150,111,17,128,93,8,118,89,3,138,106,10,143,111,15,
  138,106,10,124,94,3,113,84,0,104,75,0,119,90,2,110,83,2,
  95,67,0,103,75,0,103,73,0,129,96,15,171,136,33,183,148,37,
  159,126,21,142,111,12,139,108,10,138,107,10,115,86,0,114,86,2,
  124,94,3,111,84,2,153,120,17,153,119,19,115,87,3,131,102,10,
  153,120,23,116,88,6,87,61,0,93,67,0,128,98,8,136,104,11,
  132,101,8,128,98,7,162,128,25,118,89,5,103,75,0,143,111,15,
  154,119,14,146,108,5,151,113,10,160,120,13,165,124,15,146,108,6,
  127,90,0,144,106,5,162,121,13,168,130,16,157,117,11,143,106,5,
  140,103,3,143,108,3,144,108,3,147,111,5,150,114,6,156,119,8,
  120,82,3,144,104,11,162,120,18,177,133,27,175,131,25,144,104,6,
  159,117,16,188,144,36,174,131,28,133,95,4,123,87,3,123,86,7,
  105,69,3,96,59,3,115,77,5,146,105,18,188,144,38,174,132,30,
  124,89,7,140,99,19,156,116,21,142,103,9,151,112,16,156,117,21,
  127,92,7,106,72,0,118,84,5,142,104,16,127,91,8,113,76,0,
  125,88,4,142,103,13,116,83,6,110,79,2,136,104,11,143,111,15,
  133,102,10,116,88,2,114,85,0,122,92,4,143,111,16,133,102,11,
  110,81,3,110,79,3,105,75,2,144,109,24,175,141,39,149,116,18,
  133,101,8,154,121,21,149,116,17,119,90,3,129,98,8,113,84,0,
  119,90,2,118,89,3,162,128,26,146,114,17,132,102,10,149,117,21,
  147,115,21,127,97,9,108,80,2,106,78,2,125,96,8,157,124,26,
  149,117,20,133,102,10,165,131,29,122,91,7,114,84,4,140,108,12,
  150,115,12,160,121,15,175,134,23,172,131,21,159,119,13,138,101,3,
  127,90,0,146,109,8,174,132,21,180,139,26,172,131,21,154,112,11,
  133,95,3,129,91,0,142,102,6,147,107,9,143,103,6,142,102,6,
  133,96,11,146,107,18,166,125,30,177,134,34,166,126,27,147,107,15,
  146,108,14,184,140,35,177,135,31,114,79,0,116,78,6,116,79,10,
  85,51,2,111,72,14,116,78,13,149,106,24,183,140,39,174,131,30,
  135,97,10,144,104,19,146,107,17,133,96,7,147,108,15,146,108,15,
  122,88,4,113,79,0,129,92,8,160,120,26,154,115,24,131,95,10,
  129,90,8,133,94,11,105,71,5,104,73,0,138,107,13,140,108,14,
  127,97,6,120,91,2,129,98,6,140,108,13,166,132,30,154,122,25,
  129,100,11,123,92,10,105,76,3,131,98,19,162,128,35,128,99,11,
  123,94,8,174,137,37,163,127,31,104,75,4,132,99,11,122,93,7,
  133,102,12,122,93,7,168,132,34,160,124,29,144,113,21,138,105,17,
  120,90,8,124,93,10,131,99,12,129,97,11,125,96,9,160,124,29,
  153,115,23,136,103,13,175,137,37,131,98,11,120,89,5,142,109,13,
  149,114,11,166,126,17,181,140,28,183,141,28,166,126,17,140,104,5,
  132,94,3,150,112,8,169,128,19,177,136,25,169,126,21,157,116,15,
  138,100,5,132,94,3,140,102,9,146,107,11,142,103,9,131,94,3,
  135,99,22,119,84,11,125,91,13,150,113,27,153,116,30,139,103,20,
  140,104,19,171,130,30,172,129,26,119,84,2,122,83,9,120,81,15,
  84,51,3,95,57,9,109,70,10,135,95,17,171,129,31,166,124,22,
  128,90,4,140,103,16,133,97,10,132,96,8,159,119,24,156,117,21,
  133,96,7,118,84,2,114,81,3,153,113,19,160,119,24,139,101,13,
  138,98,13,135,94,13,103,68,4,95,66,0,131,101,10,138,107,13,
  122,92,3,124,94,4,139,107,12,133,102,10,163,129,28,153,120,23,
  131,101,11,124,93,10,105,76,4,110,80,6,140,105,21,144,109,24,
  129,96,15,159,122,32,168,130,39,118,87,10,125,92,12,125,92,12,
  139,104,20,120,88,9,166,128,37,174,135,42,125,92,12,113,81,4,
  99,70,0,110,79,3,120,88,8,120,86,6,124,90,9,153,116,25,
  144,107,18,128,93,8,159,120,26,129,95,10,119,85,4,162,122,25,
  165,125,20,159,119,13,159,119,13,169,128,19,171,130,21,151,110,11,
  142,102,5,143,103,6,153,112,11,160,118,16,151,111,13,151,111,13,
  147,108,11,140,101,7,133,96,6,127,90,3,131,92,4,140,102,10,
  96,65,5,110,79,14,125,92,22,110,80,11,100,71,6,127,95,21,
  131,97,20,157,119,29,171,129,31,113,78,2,128,89,13,125,86,15,
  74,42,2,92,56,0,108,72,5,149,108,20,188,144,38,166,124,22,
  115,81,2,123,85,12,139,103,16,140,108,14,159,126,26,146,111,17,
  127,91,4,124,89,3,127,91,4,163,122,23,151,111,17,132,94,8,
  144,100,16,142,99,18,116,77,6,114,82,5,149,117,20,162,128,26,
  132,102,10,122,92,2,135,104,9,123,93,5,159,125,24,151,119,22,
  119,90,5,103,74,3,98,68,1,88,61,1,135,102,22,171,134,43,
  140,106,23,138,104,21,151,116,31,131,98,18,120,88,11,133,100,19,
  142,108,25,135,101,19,156,120,33,168,131,41,119,87,11,115,83,7,
  100,70,0,113,80,5,124,89,9,114,82,3,129,95,11,146,109,19,
  142,104,16,125,91,7,150,112,21,149,112,20,115,82,5,128,93,8,
  146,106,8,143,105,3,149,111,8,174,133,23,180,138,27,149,108,9,
  135,96,3,136,97,3,150,110,11,153,112,13,139,100,5,146,106,9,
  143,104,8,163,122,22,153,113,16,127,90,3,123,87,2,147,108,12,
  91,65,3,99,72,8,116,88,20,115,87,20,95,69,9,116,88,24,
  138,108,36,124,93,19,138,104,21,139,104,23,140,105,24,124,92,19,
  103,71,10,108,74,8,142,107,26,172,134,40,169,130,36,133,99,15,
  113,81,6,118,86,13,116,85,10,122,94,10,154,122,28,147,115,21,
  120,88,4,116,82,0,122,88,4,160,119,20,160,118,21,147,105,17,
  144,100,16,128,87,8,129,89,11,136,100,15,154,122,27,165,131,30,
  127,98,11,104,78,0,124,94,5,122,95,7,169,135,33,162,129,30,
  116,88,5,96,68,0,103,74,2,91,63,0,109,79,7,132,99,19,
  122,91,14,129,97,19,140,107,26,144,110,28,132,99,22,133,100,22,
  139,105,27,147,113,30,131,98,19,129,97,19,110,80,8,118,85,9,
  98,64,0,118,85,9,151,113,25,132,96,12,144,106,18,143,106,16,
  139,101,13,124,88,4,129,92,7,147,109,17,120,85,6,136,98,11,
  166,123,19,154,112,10,136,97,2,151,110,10,162,120,17,143,104,8,
  131,94,3,135,97,5,159,118,18,157,116,16,138,100,5,140,100,5,
  129,91,3,146,106,8,154,113,14,129,92,3,127,91,2,159,118,18,
  132,108,23,128,105,24,140,115,37,149,123,48,120,98,33,127,103,40,
  124,103,38,97,76,15,96,74,10,135,108,36,138,111,38,118,93,25,
  138,109,38,122,94,27,147,118,45,154,123,48,143,113,39,114,87,20,
  111,83,19,103,77,13,82,60,2,88,66,2,127,101,18,136,107,20,
  111,84,5,105,76,0,122,87,3,149,109,12,157,117,19,146,106,15,
  143,102,16,124,84,7,140,101,20,151,116,31,147,118,30,140,111,23,
  111,85,7,98,74,0,119,90,6,114,88,5,139,110,19,129,101,13,
  102,77,3,103,76,2,109,78,3,105,76,4,108,78,5,110,79,5,
  118,87,10,127,95,17,122,91,14,103,75,9,103,74,5,113,82,11,
  131,98,21,147,113,31,146,112,30,129,97,19,110,79,6,114,81,5,
  93,60,0,119,82,11,171,127,36,140,100,16,144,105,16,151,111,20,
  132,94,8,118,83,2,124,88,3,142,103,13,127,90,4,139,100,10,
  175,130,25,175,131,23,144,104,6,138,98,5,144,105,9,136,97,7,
  114,77,0,116,80,3,143,104,13,154,112,17,133,94,4,124,86,0,
  122,82,0,139,99,3,151,116,10,131,98,0,138,105,5,156,121,16,
  162,139,41,135,115,30,135,116,36,138,119,43,105,86,27,97,79,26,
  96,78,26,90,74,24,96,79,29,99,82,32,129,110,53,143,123,65,
  133,112,56,124,102,49,116,94,42,115,94,42,109,89,36,102,81,30,
  95,74,24,80,61,12,68,52,3,80,62,4,122,98,22,128,102,20,
  115,89,7,103,78,2,139,108,10,133,101,6,143,110,11,142,104,12,
  136,100,13,135,100,14,154,118,31,143,112,35,127,101,30,125,99,27,
  108,85,15,105,83,12,125,101,20,102,81,5,100,78,4,88,67,1,
  103,80,5,129,103,19,108,82,6,105,80,4,113,82,5,118,86,8,
  138,104,21,133,100,19,106,76,5,85,57,3,139,104,24,156,120,36,
  154,118,34,144,109,26,114,82,8,97,69,4,103,73,3,114,81,5,
  87,53,0,116,80,10,172,129,37,149,108,21,129,92,8,146,107,17,
  128,92,7,127,91,7,128,92,7,129,92,7,127,91,6,122,86,3,
  154,114,16,172,130,25,150,109,12,140,101,7,143,105,12,122,88,4,
  96,67,0,99,69,0,131,96,10,151,113,20,127,92,6,114,79,0,
  120,85,0,156,116,11,162,124,13,146,111,5,150,114,9,151,116,11
} ;
*/

/** "AFNI Version Check!" logo **/

static unsigned char vvv_rgb[] = {
  211,173,74,215,175,77,204,162,64,185,143,45,186,146,50,226,183,89,
  227,184,89,220,173,81,213,164,71,202,149,57,205,151,61,199,146,54,
  198,147,56,198,149,56,177,131,37,187,142,49,206,163,69,230,189,99,
  198,161,72,184,149,57,194,161,68,230,197,104,230,200,104,206,176,78,
  205,175,77,213,180,83,217,183,85,205,167,70,211,171,75,211,169,71,
  201,159,59,197,155,53,207,162,61,203,155,55,211,163,63,217,167,68,
  209,159,60,212,162,63,214,166,66,213,168,67,211,168,66,210,171,68,
  211,174,70,221,184,80,247,210,106,206,171,69,218,184,84,216,184,85,
  225,192,95,196,163,66,207,173,76,213,175,78,221,181,83,223,181,81,
  218,173,72,221,176,75,204,160,61,212,170,70,204,162,64,186,148,49,
  211,173,74,221,186,84,213,178,74,225,187,78,218,178,65,208,167,51,
  208,163,46,215,169,49,216,174,53,211,185,66,217,192,76,227,189,78,
  216,157,53,208,149,45,207,156,49,207,167,56,194,171,55,184,175,54,
  192,180,60,207,180,65,217,175,65,217,155,54,191,138,36,194,145,43,
  202,153,51,207,158,56,212,163,61,216,167,65,219,170,68,187,138,36,
  209,173,77,215,176,81,198,158,63,174,134,39,185,147,50,215,175,79,
  221,178,83,222,176,82,221,172,79,209,154,63,211,156,65,205,150,59,
  202,147,56,201,146,55,189,136,44,199,148,56,212,167,74,221,182,91,
  222,188,98,200,169,78,187,156,63,206,177,83,220,192,95,210,182,85,
  204,176,77,201,171,73,215,181,84,218,180,83,223,180,85,222,180,82,
  209,163,65,201,156,55,211,161,62,207,155,56,210,158,59,213,161,62,
  206,154,55,212,160,61,216,166,67,214,169,68,210,167,65,206,169,65,
  210,173,69,205,168,64,226,191,87,203,169,69,216,184,85,218,188,90,
  211,181,85,189,159,63,200,167,72,213,177,81,223,185,88,222,182,84,
  217,173,74,223,178,77,214,170,71,216,172,73,205,163,65,186,146,48,
  200,162,61,209,174,72,209,174,70,220,182,73,218,178,65,210,167,52,
  207,160,42,214,165,44,220,176,53,210,185,66,212,189,73,222,184,73,
  221,159,56,215,153,50,211,158,52,208,168,57,193,170,54,184,178,56,
  191,181,60,202,177,61,209,167,57,204,142,39,189,137,35,193,150,46,
  208,163,60,217,174,70,214,171,67,208,163,60,202,159,55,199,154,51,
  214,177,86,221,182,91,209,168,78,188,147,55,198,160,63,209,169,71,
  209,167,69,210,164,68,214,165,70,210,155,62,212,156,63,212,153,61,
  210,151,59,207,148,56,204,148,55,209,154,61,212,163,70,208,171,80,
  229,200,108,214,188,95,192,166,71,197,173,77,210,186,90,217,191,94,
  205,177,80,190,160,62,209,175,78,228,190,93,230,187,92,227,183,86,
  216,168,70,206,156,57,215,163,64,210,156,58,212,158,60,214,160,62,
  202,148,50,214,162,63,225,175,76,224,179,78,216,173,71,207,170,66,
  209,174,70,196,161,59,206,173,70,198,166,65,213,180,83,223,193,97,
  200,170,74,193,164,70,196,163,68,214,179,85,223,187,91,219,179,81,
  211,167,68,219,175,76,223,177,79,216,172,73,206,164,64,190,151,50,
  192,154,53,201,166,64,211,177,70,214,176,65,215,174,60,211,166,49,
  212,163,44,218,168,45,218,174,49,208,184,62,207,185,66,216,179,65,
  225,164,58,223,160,55,216,162,54,208,168,55,192,170,51,187,183,58,
  193,185,61,202,177,59,206,164,52,201,139,36,192,145,41,193,156,49,
  208,170,63,218,181,74,217,180,73,208,170,63,199,162,55,206,168,61,
  222,189,96,228,193,101,222,185,94,208,169,76,212,170,72,210,167,65,
  200,155,54,198,150,50,202,152,55,208,154,58,214,158,63,216,160,65,
  216,157,63,211,152,60,210,151,59,209,150,58,200,149,57,206,166,78,
  220,189,99,221,190,99,209,180,88,212,183,89,212,186,91,225,197,100,
  207,177,79,184,151,54,205,171,73,233,195,96,230,190,92,227,185,85,
  213,167,69,204,154,55,216,164,65,213,161,62,216,162,64,219,165,67,
  201,149,48,216,167,65,234,186,84,235,192,88,225,184,79,208,174,67,
  212,178,71,212,177,73,210,175,73,201,167,69,210,176,79,223,190,95,
  186,153,60,190,157,64,198,163,69,218,182,86,227,189,92,218,179,78,
  206,165,60,216,173,71,223,179,80,213,169,70,205,163,65,194,154,56,
  190,152,51,203,165,64,220,183,77,211,171,60,211,168,55,210,163,47,
  215,166,47,223,171,49,218,170,46,213,178,60,210,177,62,216,173,61,
  226,168,61,225,167,60,218,166,57,208,168,55,191,164,47,194,182,62,
  201,184,66,207,177,63,208,166,58,203,146,43,198,157,51,195,163,54,
  202,168,60,210,176,68,219,182,75,216,178,71,211,173,66,203,166,59,
  231,203,106,216,186,90,204,174,78,213,175,78,207,158,55,217,162,59,
  212,159,55,206,153,49,201,149,47,204,152,51,209,157,56,210,158,59,
  209,155,57,204,148,53,200,141,47,206,147,55,208,153,63,205,159,74,
  223,183,98,221,181,96,226,189,101,224,187,98,213,176,85,214,178,84,
  207,173,76,200,164,67,194,159,59,208,173,71,227,190,86,239,202,98,
  228,189,86,212,170,68,206,161,58,212,167,64,212,164,62,208,160,58,
  208,161,57,216,172,67,229,186,81,232,194,87,222,186,76,206,174,63,
  214,182,73,220,183,77,209,170,69,215,175,79,214,174,79,213,174,79,
  194,155,62,201,162,69,196,156,60,213,173,75,229,190,87,224,183,77,
  206,166,53,219,178,70,229,187,87,219,177,79,209,169,73,199,159,63,
  193,151,53,197,155,55,207,164,62,210,166,59,213,165,54,215,165,50,
  216,166,45,217,167,44,219,167,45,221,169,57,219,167,58,225,171,63,
  218,164,56,202,151,42,202,155,47,211,171,60,197,161,49,199,169,59,
  197,163,55,198,159,54,203,158,57,203,154,52,194,160,52,198,168,56,
  208,176,65,214,178,68,206,163,58,206,162,57,208,164,59,213,170,66,
  216,188,89,208,178,80,198,168,70,202,164,65,208,157,52,215,161,53,
  214,161,55,211,160,53,207,158,53,207,160,56,216,168,66,217,169,67,
  219,169,70,218,166,67,207,151,56,202,146,51,199,144,54,174,126,42,
  218,173,92,232,187,104,239,197,111,229,188,100,170,138,68,168,6,41,
  168,6,41,168,6,41,168,6,41,141,116,47,219,182,78,225,188,84,
  236,199,95,217,180,76,204,163,58,209,166,62,208,163,60,206,161,58,
  212,165,61,145,116,45,22,168,6,22,168,6,22,168,6,22,168,6,
  22,168,6,22,168,6,22,168,6,22,168,6,22,168,6,22,168,6,
  22,168,6,22,168,6,22,168,6,71,57,24,228,185,81,225,183,75,
  136,109,33,6,22,168,6,22,168,6,22,168,69,55,23,215,172,77,
  219,175,80,220,174,78,222,177,76,216,167,62,216,168,58,218,168,53,
  172,132,40,6,22,168,6,22,168,6,22,168,196,144,49,221,164,57,
  214,163,54,199,153,42,66,51,15,135,6,168,135,6,168,135,6,168,
  68,54,19,204,161,59,208,162,64,207,163,64,194,162,53,201,174,61,
  210,176,66,206,170,60,213,169,64,217,168,65,213,164,61,196,148,46,
  206,166,71,216,173,79,220,175,82,216,172,75,217,175,73,201,164,57,
  198,164,56,202,168,60,204,172,63,202,172,62,195,162,55,201,167,60,
  213,176,70,225,186,81,227,184,80,213,168,65,201,155,57,196,153,61,
  188,147,59,194,153,65,197,156,68,182,141,51,41,32,11,168,6,41,
  168,6,41,168,6,41,168,6,41,93,74,30,224,180,83,235,193,95,
  237,198,97,226,188,87,210,167,65,208,163,62,207,159,59,206,156,57,
  216,164,63,97,74,29,22,168,6,22,168,6,22,168,6,22,168,6,
  22,168,6,22,168,6,22,168,6,22,168,6,22,168,6,22,168,6,
  22,168,6,22,168,6,22,168,6,96,73,30,224,175,73,224,175,72,
  95,74,25,6,22,168,6,22,168,6,22,168,6,22,168,178,134,53,
  192,143,51,199,150,57,212,162,67,205,156,53,209,160,55,214,166,55,
  145,113,36,6,22,168,6,22,168,6,22,168,198,156,44,196,153,41,
  213,166,58,207,160,52,46,36,11,135,6,168,135,6,168,135,6,168,
  129,100,31,194,151,49,196,154,52,203,164,61,203,169,61,204,170,60,
  210,172,63,216,175,67,213,164,61,209,157,55,205,156,53,198,149,47,
  202,155,63,214,165,73,225,174,83,224,178,84,223,188,86,198,170,61,
  191,165,55,191,165,55,192,168,58,193,169,59,204,178,68,206,180,70,
  213,183,73,220,188,79,220,182,75,209,168,62,198,156,54,189,150,55,
  189,150,59,206,167,74,216,177,84,111,89,37,168,6,41,168,6,41,
  168,6,41,168,6,41,168,6,41,68,52,21,219,170,77,228,182,88,
  222,182,84,219,181,80,213,169,70,209,163,65,208,160,60,207,155,56,
  212,158,58,71,53,19,22,168,6,22,168,6,22,168,6,46,35,11,
  69,53,17,71,53,18,69,51,15,70,52,17,68,49,16,69,50,17,
  67,48,16,74,55,23,69,51,19,169,125,49,219,163,66,212,157,57,
  69,51,17,6,22,168,6,22,168,6,22,168,6,22,168,111,83,32,
  195,144,53,206,155,64,219,168,76,199,150,48,205,158,54,213,166,58,
  73,57,20,6,22,168,6,22,168,68,56,18,189,158,42,190,154,42,
  213,171,63,214,167,61,135,6,168,135,6,168,135,6,168,135,6,168,
  147,112,32,189,148,43,188,149,44,195,161,54,210,173,66,202,164,55,
  210,169,61,228,186,78,201,152,49,192,140,38,198,149,46,221,172,70,
  193,144,52,200,149,58,212,158,68,212,166,72,223,189,89,200,176,70,
  191,168,62,188,165,59,187,166,57,189,167,56,188,166,55,190,166,56,
  197,169,59,203,173,63,207,171,61,205,164,56,198,159,54,201,163,64,
  187,151,55,195,159,63,187,152,68,172,24,44,168,6,41,168,6,41,
  168,6,41,168,6,41,168,6,41,168,6,41,204,150,60,205,156,64,
  212,169,74,214,176,77,213,169,70,208,162,64,209,159,62,209,155,57,
  211,156,56,22,168,6,22,168,6,22,168,6,22,168,6,165,123,42,
  212,158,52,209,152,45,205,147,39,222,163,59,218,159,57,218,159,59,
  205,145,47,218,158,60,221,161,65,227,167,71,223,163,67,212,152,54,
  6,22,168,6,22,168,6,22,168,6,22,168,6,22,168,27,35,154,
  204,149,59,213,158,68,214,161,69,198,148,49,208,159,57,216,169,63,
  50,39,15,6,22,168,6,22,168,90,78,25,186,164,45,189,159,45,
  215,174,66,168,133,50,135,6,168,135,6,168,135,6,168,135,6,168,
  192,147,44,193,152,47,191,154,47,199,165,57,215,177,68,208,167,59,
  214,172,64,228,184,77,193,144,41,188,136,34,198,149,46,221,173,71,
  188,141,49,189,138,47,195,141,51,194,147,55,212,178,80,205,180,79,
  200,177,73,195,172,68,190,167,61,189,167,58,189,165,55,196,170,60,
  204,174,64,209,177,68,217,179,70,221,180,72,222,181,75,209,174,72,
  193,157,60,183,147,50,85,68,25,168,6,41,168,6,41,44,34,13,
  168,6,41,168,6,41,168,6,41,168,6,41,175,125,47,194,140,50,
  209,166,71,214,176,77,211,167,68,207,159,61,211,158,62,213,157,60,
  192,139,52,22,168,6,22,168,6,22,168,6,22,168,6,212,153,51,
  210,151,47,213,152,45,206,146,36,225,164,57,225,164,58,226,164,61,
  210,148,47,219,157,58,227,164,67,229,166,69,223,160,63,192,136,52,
  6,22,168,6,22,168,6,22,168,6,22,168,6,22,168,6,22,168,
  166,122,52,217,160,71,212,157,66,199,149,52,209,159,60,218,169,66,
  6,22,168,6,22,168,6,22,168,134,120,41,188,172,51,190,167,51,
  212,174,65,141,112,42,135,6,168,135,6,168,135,6,168,44,32,10,
  197,152,49,201,160,54,196,162,52,206,174,63,220,179,71,226,182,75,
  225,178,72,212,165,59,192,143,40,199,150,47,207,158,55,216,168,66,
  192,147,54,186,139,47,184,135,43,181,136,43,201,165,69,210,182,83,
  211,183,83,205,177,77,196,171,68,194,167,62,193,165,58,200,169,61,
  206,172,64,208,171,64,207,165,57,210,166,57,212,169,64,192,155,51,
  207,172,72,180,146,58,168,6,41,168,6,41,171,22,43,184,135,43,
  168,6,41,168,6,41,168,6,41,168,6,41,134,94,37,199,144,54,
  213,169,72,218,179,78,208,164,65,204,156,58,209,157,58,215,159,62,
  147,105,41,22,168,6,22,168,6,22,168,6,50,36,14,209,147,46,
  205,143,40,223,161,52,209,147,36,218,156,47,221,158,52,227,164,59,
  216,153,50,226,163,60,218,154,56,216,152,54,213,149,52,141,99,34,
  6,22,168,6,22,168,6,22,168,6,22,168,6,22,168,6,22,168,
  66,46,16,198,139,49,195,138,48,200,147,51,209,156,60,169,130,51,
  6,22,168,6,22,168,6,22,168,182,164,58,192,178,56,194,173,56,
  210,173,66,69,55,20,135,6,168,135,6,168,135,6,168,65,48,14,
  201,154,50,205,164,56,200,167,54,213,180,67,223,181,73,244,195,90,
  233,184,79,194,145,40,195,146,43,215,166,63,214,167,63,224,176,74,
  201,162,67,197,154,60,187,142,49,188,143,50,183,142,50,192,156,60,
  206,170,73,225,191,93,232,200,99,192,159,56,198,165,60,194,160,53,
  192,154,47,196,155,49,211,164,58,213,164,59,211,164,60,199,160,57,
  207,169,68,47,39,16,168,6,41,168,6,41,129,99,35,201,150,58,
  171,21,42,168,6,41,168,6,41,168,6,41,113,79,30,209,154,63,
  191,147,48,194,155,52,213,168,67,218,168,69,216,162,62,209,154,54,
  93,66,21,22,168,6,22,168,6,22,168,6,69,48,15,211,149,46,
  210,149,43,222,160,51,227,165,54,238,176,67,232,170,61,224,161,55,
  221,158,52,222,159,54,223,160,57,218,154,54,211,147,49,92,63,20,
  6,22,168,6,22,168,49,34,13,6,22,168,6,22,168,6,22,168,
  6,22,168,191,138,56,208,152,59,219,165,69,230,177,81,144,111,43,
  6,22,168,6,22,168,6,22,168,200,178,59,197,181,60,199,178,61,
  203,169,61,48,38,15,135,6,168,135,6,168,135,6,168,124,89,22,
  223,176,72,224,183,75,216,180,68,225,192,77,227,180,72,213,162,57,
  194,143,38,188,139,34,212,165,61,218,171,67,217,173,68,224,179,76,
  208,174,77,201,165,69,194,154,59,199,154,61,203,152,61,192,141,49,
  190,141,48,199,153,59,216,172,75,227,183,84,225,183,83,219,175,76,
  208,163,62,199,151,51,197,145,44,206,152,52,209,159,60,206,160,62,
  139,110,45,168,6,41,168,6,41,46,35,14,204,155,60,199,146,52,
  68,50,19,168,6,41,168,6,41,168,6,41,70,49,19,202,146,51,
  202,157,54,202,161,55,203,156,50,201,152,47,204,151,45,211,157,51,
  74,54,19,22,168,6,22,168,6,22,168,6,135,102,42,241,185,76,
  238,182,73,243,185,77,236,178,68,228,170,60,235,178,65,243,186,73,
  246,189,76,245,188,75,244,186,76,241,183,75,241,183,76,80,61,26,
  6,22,168,6,22,168,72,51,16,48,34,10,6,22,168,6,22,168,
  6,22,168,99,72,29,221,161,65,218,160,63,211,153,56,67,48,15,
  6,22,168,6,22,168,66,51,15,206,170,56,202,173,56,205,173,62,
  222,183,80,135,6,168,135,6,168,135,6,168,135,6,168,165,128,48,
  218,174,67,234,192,80,235,195,81,215,174,58,198,147,40,200,147,43,
  201,150,45,199,152,46,201,160,54,203,165,58,207,169,62,194,155,50,
  204,168,72,200,161,66,195,155,60,206,159,67,203,148,57,200,145,52,
  197,144,50,198,148,53,204,155,60,213,169,72,226,182,83,226,182,83,
  221,177,78,212,166,68,193,143,46,191,141,44,192,142,45,202,153,58,
  173,24,44,168,6,41,168,6,41,164,125,51,206,156,61,193,138,45,
  114,84,32,168,6,41,168,6,41,168,6,41,173,23,43,193,139,39,
  208,161,55,207,165,55,210,163,55,208,160,50,214,162,53,224,170,62,
  22,168,6,22,168,6,22,168,6,22,168,6,159,124,48,234,183,68,
  232,180,68,241,187,78,237,183,74,225,172,60,230,177,63,240,187,73,
  246,193,77,246,193,77,235,182,68,235,182,70,239,185,76,6,22,168,
  6,22,168,6,22,168,152,112,39,151,111,36,6,22,168,6,22,168,
  6,22,168,30,38,156,217,157,59,221,161,63,213,153,55,46,33,10,
  6,22,168,6,22,168,89,66,18,205,162,50,205,165,52,210,170,59,
  170,137,58,135,6,168,135,6,168,135,6,168,135,6,168,223,180,76,
  213,171,63,231,188,76,233,190,75,199,152,36,193,141,32,198,145,41,
  205,154,49,209,162,56,208,170,63,206,169,62,202,168,60,182,148,41,
  212,172,77,206,163,69,200,155,62,208,157,65,195,139,46,199,143,48,
  200,146,50,197,147,50,197,151,53,209,167,69,193,151,53,206,166,68,
  225,185,87,235,193,95,208,164,67,189,145,50,178,132,38,106,78,27,
  168,6,41,168,6,41,96,72,31,209,156,64,204,151,57,203,149,53,
  140,104,40,168,6,41,168,6,41,168,6,41,168,6,41,203,150,48,
  205,158,50,208,165,53,217,171,59,219,171,60,225,173,61,207,159,60,
  22,168,6,22,168,6,22,168,6,22,168,6,22,168,6,22,168,6,
  22,168,6,22,168,6,22,168,6,22,168,6,22,168,6,22,168,6,
  161,129,51,241,195,75,230,184,64,228,181,63,207,166,62,6,22,168,
  6,22,168,6,22,168,187,144,53,238,181,65,32,40,156,6,22,168,
  6,22,168,6,22,168,139,98,32,229,167,68,227,165,66,6,22,168,
  6,22,168,6,22,168,141,100,31,213,156,49,215,163,54,220,169,62,
  141,111,45,135,6,168,135,6,168,135,6,168,39,31,9,222,183,78,
  212,170,62,227,184,71,232,185,69,196,145,28,210,158,49,209,158,53,
  211,162,57,214,170,63,206,172,64,194,162,53,184,154,44,172,141,33,
  226,179,87,220,171,79,205,154,63,205,152,60,211,152,58,203,147,50,
  199,146,50,193,143,46,189,143,45,201,161,63,199,161,62,205,169,72,
  215,179,82,220,184,88,208,169,74,198,159,64,174,135,53,168,6,41,
  168,6,41,168,6,41,185,134,55,205,150,59,202,147,54,212,158,62,
  208,154,56,168,6,41,168,6,41,168,6,41,168,6,41,168,128,44,
  216,170,58,217,174,59,231,184,68,237,187,74,239,188,73,159,125,49,
  22,168,6,22,168,6,22,168,6,22,168,6,22,168,6,22,168,6,
  22,168,6,22,168,6,22,168,6,22,168,6,22,168,6,22,168,6,
  188,155,61,238,197,73,237,196,72,234,193,69,157,129,49,6,22,168,
  6,22,168,6,22,168,243,191,71,245,189,68,109,84,31,6,22,168,
  6,22,168,6,22,168,46,32,10,227,163,65,177,127,51,6,22,168,
  6,22,168,6,22,168,191,132,39,222,158,52,227,164,59,228,169,65,
  70,54,22,135,6,168,135,6,168,135,6,168,59,50,16,212,178,71,
  213,172,64,225,179,67,231,181,66,209,154,38,215,161,53,212,161,56,
  211,164,58,214,172,64,208,176,67,195,167,57,184,158,47,187,161,51,
  229,175,85,226,171,81,210,155,65,205,148,58,221,163,66,209,155,55,
  205,155,56,198,150,50,188,144,45,191,156,56,213,179,81,208,176,77,
  203,170,73,199,169,73,207,174,79,210,177,82,72,59,29,168,6,41,
  168,6,41,109,77,28,205,145,57,207,150,60,211,155,62,214,160,64,
  202,148,50,168,6,41,168,6,41,168,6,41,168,6,41,147,113,41,
  234,189,74,233,188,71,239,192,74,245,195,80,245,194,77,106,83,31,
  22,168,6,22,168,6,22,168,6,47,172,14,81,67,26,81,68,26,
  81,69,28,78,64,28,82,68,33,80,66,29,79,66,28,82,68,29,
  245,205,83,236,196,72,231,192,65,231,192,65,104,86,30,6,22,168,
  6,22,168,51,42,15,243,193,70,245,191,67,217,169,61,6,22,168,
  6,22,168,6,22,168,6,22,168,199,142,53,147,104,37,6,22,168,
  6,22,168,6,22,168,218,146,44,232,159,56,232,160,58,227,162,62,
  47,37,15,135,6,168,135,6,168,135,6,168,128,111,44,198,165,58,
  211,173,64,216,170,58,221,170,53,219,160,44,214,160,52,215,164,59,
  216,169,63,216,175,67,211,181,71,206,180,69,202,179,67,205,181,71,
  211,161,62,212,163,61,214,164,65,214,167,63,211,163,55,207,163,54,
  199,157,47,197,156,48,199,161,54,196,158,57,190,152,53,197,157,61,
  202,159,65,199,154,63,210,155,72,183,139,74,168,6,41,168,6,41,
  168,6,41,71,52,22,70,51,21,70,52,20,67,49,16,67,50,14,
  71,55,18,175,26,45,168,6,41,168,6,41,168,6,41,78,63,25,
  234,189,74,235,190,73,235,190,73,234,187,73,231,184,68,76,60,22,
  22,168,6,22,168,6,22,168,6,162,132,54,245,200,83,242,200,82,
  242,200,82,244,203,85,237,196,78,242,202,81,244,204,83,239,199,77,
  238,198,76,242,202,80,239,199,75,238,198,74,78,65,24,6,22,168,
  6,22,168,79,65,24,237,189,63,244,195,67,249,200,72,55,44,15,
  6,22,168,6,22,168,6,22,168,107,82,32,81,62,26,6,22,168,
  6,22,168,68,49,17,215,151,61,224,153,65,212,142,54,225,161,73,
  135,6,168,135,6,168,135,6,168,135,6,168,153,135,60,181,152,52,
  183,145,44,197,152,49,220,167,65,245,181,83,240,177,84,198,139,49,
  182,129,35,205,159,61,199,161,54,197,159,50,219,179,68,196,152,43,
  205,156,53,206,159,55,208,161,57,207,163,56,205,162,50,204,162,50,
  197,157,46,193,155,46,195,157,50,190,151,48,194,152,52,200,156,61,
  202,155,63,199,148,59,206,143,63,175,24,46,168,6,41,168,6,41,
  168,6,41,168,6,41,168,6,41,168,6,41,168,6,41,168,6,41,
  168,6,41,168,6,41,168,6,41,168,6,41,168,6,41,53,42,16,
  236,191,74,236,191,74,238,193,76,239,194,79,239,194,77,22,168,6,
  22,168,6,22,168,6,22,168,6,190,155,64,244,199,84,242,197,82,
  239,197,79,244,202,82,237,197,75,242,202,80,245,205,83,241,201,79,
  240,200,78,243,203,81,242,202,80,240,200,78,6,22,168,6,22,168,
  6,22,168,156,129,46,245,197,71,246,197,69,247,198,69,166,133,46,
  6,22,168,6,22,168,6,22,168,34,42,158,55,43,18,6,22,168,
  6,22,168,93,69,25,208,149,59,216,150,63,236,170,84,162,116,47,
  135,6,168,135,6,168,135,6,168,135,6,168,203,179,83,194,161,64,
  188,150,51,193,147,49,211,157,59,251,188,93,219,155,67,199,139,51,
  192,139,47,206,157,62,205,164,58,201,159,51,208,161,53,203,152,43,
  202,153,50,203,156,52,205,158,54,205,158,52,212,168,59,213,171,61,
  207,167,56,202,164,55,204,166,59,196,157,54,197,155,55,201,157,62,
  202,153,61,197,143,55,110,75,29,168,6,41,168,6,41,168,6,41,
  168,6,41,168,6,41,168,6,41,168,6,41,168,6,41,168,6,41,
  168,6,41,168,6,41,168,6,41,168,6,41,168,6,41,168,6,41,
  240,195,76,240,195,76,239,194,75,240,195,78,215,174,69,22,168,6,
  22,168,6,22,168,6,22,168,6,244,199,80,244,199,82,239,194,77,
  236,194,74,242,200,79,236,196,74,240,200,78,244,204,82,243,203,81,
  242,202,80,244,204,82,244,204,82,215,179,70,6,22,168,6,22,168,
  6,22,168,181,149,52,252,204,78,249,200,72,245,196,67,251,202,71,
  34,42,157,6,22,168,6,22,168,6,22,168,6,22,168,6,22,168,
  6,22,168,143,108,40,207,151,56,210,146,56,223,159,71,138,100,40,
  135,6,168,135,6,168,135,6,168,42,35,14,184,153,60,211,175,79,
  215,173,75,207,159,61,203,149,51,220,160,64,201,140,51,204,144,56,
  207,154,60,208,162,64,208,170,61,204,164,53,199,156,44,211,163,53,
  206,154,52,204,155,52,204,155,52,203,156,50,213,169,60,217,177,66,
  214,174,63,211,173,64,212,174,67,204,165,62,201,159,59,202,158,61,
  203,154,61,176,128,48,171,21,42,168,6,41,168,6,41,193,142,63,
  215,160,67,211,157,59,197,144,42,201,150,43,218,168,57,232,185,67,
  235,189,69,211,172,64,168,6,41,168,6,41,168,6,41,168,6,41,
  217,178,70,242,198,77,236,192,71,235,191,70,157,128,47,22,168,6,
  22,168,6,22,168,6,47,172,14,244,200,79,244,200,79,240,196,75,
  236,194,73,236,196,74,234,194,72,237,197,75,241,201,79,242,202,80,
  242,202,80,242,202,80,243,203,81,160,133,52,6,22,168,6,22,168,
  6,22,168,233,192,68,251,203,77,249,200,72,247,198,69,250,201,70,
  112,90,32,6,22,168,6,22,168,6,22,168,6,22,168,6,22,168,
  6,22,168,200,154,57,225,172,70,213,155,58,175,116,22,72,54,23,
  135,6,168,135,6,168,135,6,168,63,50,19,177,136,44,214,171,76,
  220,174,78,208,158,61,191,139,40,188,132,35,202,143,51,208,151,61,
  213,163,66,215,172,70,209,173,63,209,171,60,211,169,57,222,176,65,
  207,154,52,203,151,49,199,150,47,197,150,44,201,157,48,207,166,58,
  206,165,57,205,167,60,208,170,63,204,162,60,205,161,62,205,159,63,
  205,156,61,91,67,26,168,6,41,168,6,41,95,68,29,219,162,72,
  212,158,60,211,158,56,202,151,44,209,159,48,222,172,59,234,188,68,
  236,192,67,239,195,70,168,6,41,168,6,41,168,6,41,168,6,41,
  160,133,50,238,197,73,233,192,68,232,191,67,104,86,30,22,168,6,
  22,168,6,22,168,6,80,66,25,242,201,77,242,201,77,240,199,75,
  239,198,74,233,193,69,233,193,69,234,194,70,237,197,73,241,201,77,
  241,201,77,238,198,74,240,200,76,107,89,34,6,22,168,6,22,168,
  54,45,17,236,195,69,242,197,70,247,199,71,249,202,72,246,199,67,
  219,177,60,6,22,168,6,22,168,6,22,168,6,22,168,6,22,168,
  6,22,168,237,187,72,248,198,87,232,180,78,170,118,17,46,34,12,
  135,6,168,135,6,168,135,6,168,126,93,32,206,155,64,205,154,62,
  204,154,59,195,142,46,183,131,32,191,137,39,209,153,58,207,153,57,
  210,162,62,216,175,70,203,169,59,209,176,63,227,190,76,222,179,66,
  204,151,49,200,147,45,195,143,41,190,143,39,193,151,43,200,159,51,
  199,158,50,199,161,54,205,167,60,205,162,58,207,164,62,206,160,62,
  162,123,47,168,6,41,168,6,41,173,23,44,214,155,63,213,157,62,
  208,155,53,213,162,55,211,161,50,218,171,55,228,181,63,239,195,70,
  240,197,69,242,199,71,54,45,16,168,6,41,168,6,41,168,6,41,
  105,86,30,234,193,65,235,194,66,237,196,70,80,66,23,22,168,6,
  22,168,6,22,168,6,134,111,41,242,201,73,242,201,75,240,199,73,
  239,198,72,232,193,66,234,194,70,232,192,68,236,196,72,241,201,77,
  241,201,77,236,196,72,239,199,75,79,66,25,6,22,168,6,22,168,
  81,67,26,238,197,71,239,194,67,246,198,70,249,202,72,244,197,67,
  243,196,64,56,45,16,6,22,168,6,22,168,6,22,168,6,22,168,
  81,65,24,241,192,71,250,203,85,253,207,96,216,169,63,135,6,168,
  135,6,168,135,6,168,135,6,168,154,108,37,222,163,73,211,152,60,
  212,156,61,205,151,53,190,138,39,189,140,38,204,150,52,201,149,50,
  203,158,55,211,173,66,201,169,56,210,178,65,230,194,80,213,172,58,
  206,153,51,201,149,47,197,145,43,191,144,40,196,155,49,196,157,52,
  192,153,48,195,154,49,203,160,56,205,160,57,209,161,59,208,159,57,
  46,35,13,168,6,41,168,6,41,141,103,39,208,153,53,213,162,55,
  230,180,69,237,190,74,231,185,65,235,189,67,242,199,71,237,194,63,
  233,193,61,231,191,59,77,65,20,168,6,41,168,6,41,168,6,41,
  78,65,21,235,195,64,238,198,67,238,198,67,22,168,6,22,168,6,
  22,168,6,22,168,6,162,135,48,243,203,72,241,201,70,235,195,64,
  233,193,62,238,199,70,242,203,76,236,197,70,238,199,72,245,206,79,
  244,205,78,236,197,70,243,204,77,6,22,168,6,22,168,6,22,168,
  159,133,48,233,192,64,249,206,76,245,200,71,239,194,65,242,198,67,
  244,200,69,161,132,43,6,22,168,6,22,168,6,22,168,6,22,168,
  113,93,33,255,212,77,246,203,72,235,197,74,179,149,56,135,6,168,
  135,6,168,135,6,168,135,6,168,239,165,76,229,153,65,210,141,50,
  207,144,51,195,137,40,179,127,28,198,150,48,172,118,18,202,150,49,
  216,172,67,208,171,64,223,196,83,222,192,78,204,172,59,203,165,54,
  216,163,61,214,162,60,209,157,55,201,154,50,181,140,35,204,165,62,
  202,163,58,199,158,53,200,157,53,202,154,52,211,163,61,137,104,35,
  168,6,41,168,6,41,48,36,13,209,156,54,215,162,58,223,172,63,
  229,182,66,234,187,69,238,192,70,238,194,69,238,195,65,242,202,70,
  242,202,68,241,201,67,161,136,46,168,6,41,168,6,41,168,6,41,
  168,6,41,238,200,67,245,207,74,215,182,63,22,168,6,22,168,6,
  22,168,6,22,168,6,245,207,74,244,206,73,244,206,73,241,203,70,
  240,201,70,244,205,76,243,204,75,244,205,76,245,206,77,243,204,75,
  238,199,70,234,195,66,219,184,69,6,22,168,6,22,168,6,22,168,
  159,133,47,238,197,69,244,201,71,247,203,72,250,206,75,252,208,77,
  250,206,75,248,204,73,33,42,157,6,22,168,6,22,168,6,22,168,
  165,136,44,247,204,66,244,205,68,236,201,71,157,133,51,135,6,168,
  135,6,168,135,6,168,47,31,10,227,152,59,231,154,64,199,128,36,
  192,126,32,193,135,38,197,143,45,191,143,41,211,158,56,203,150,48,
  193,149,44,213,176,69,200,174,63,210,183,70,195,163,52,191,153,44,
  211,159,57,210,161,58,207,158,55,200,155,52,187,148,45,199,162,58,
  196,157,54,195,153,51,200,155,52,206,157,54,204,155,52,161,120,41,
  139,105,37,141,107,37,183,136,42,210,157,51,217,166,57,224,176,65,
  231,184,66,236,190,70,238,194,71,239,196,68,239,196,66,243,203,69,
  240,202,67,239,201,66,214,180,60,161,136,48,159,134,46,157,133,45,
  157,131,43,240,202,69,244,206,73,215,182,63,160,135,46,161,135,47,
  162,137,48,162,137,48,244,206,73,244,206,73,244,206,73,242,204,71,
  241,202,71,243,204,75,240,201,72,240,201,72,243,204,75,245,206,77,
  245,206,77,244,205,76,217,182,68,163,137,51,162,136,50,161,135,49,
  235,196,67,234,194,63,237,194,63,239,195,64,241,197,66,242,198,67,
  241,197,66,240,196,65,187,152,50,165,135,47,165,135,45,165,136,44,
  220,182,59,247,204,65,244,205,66,241,207,73,185,158,56,159,132,49,
  153,115,40,143,101,31,165,112,33,217,143,48,204,127,35,199,128,36,
  201,135,41,207,147,51,214,160,62,224,175,73,221,166,65,206,153,51,
  188,141,37,200,161,56,192,166,56,208,180,71,196,163,56,198,160,53,
  209,160,57,210,163,59,211,164,60,207,164,60,194,156,55,202,164,63,
  200,161,58,201,159,57,206,161,58,203,154,51,201,149,47,209,156,52,
  211,158,54,203,150,44,204,153,44,216,165,56,224,174,63,228,181,67,
  233,188,69,237,193,70,240,196,71,241,198,70,239,199,68,243,203,69,
  239,201,66,237,199,66,237,200,67,241,204,72,239,204,74,237,202,72,
  238,201,69,240,203,71,242,205,73,240,203,71,240,203,71,242,205,73,
  240,203,71,241,204,72,242,205,73,243,206,74,243,206,74,242,205,73,
  242,205,73,245,206,77,241,202,73,237,198,69,241,202,73,244,205,76,
  247,208,79,247,208,79,245,206,77,244,205,76,243,204,75,241,202,73,
  236,197,68,235,195,64,243,200,69,242,200,66,241,198,67,241,198,68,
  241,198,68,242,199,69,242,199,69,245,202,71,245,203,69,245,203,67,
  245,203,65,245,204,64,243,204,65,244,211,72,238,204,70,239,200,71,
  243,190,74,232,172,62,215,150,46,208,139,38,195,122,27,208,139,46,
  212,147,53,216,153,58,218,160,63,226,172,72,230,172,73,209,154,54,
  183,134,32,189,147,45,185,157,50,207,175,72,195,162,59,203,164,61,
  210,163,59,213,169,64,218,174,69,218,177,72,201,166,64,208,173,73,
  209,170,69,212,170,68,213,168,65,201,149,47,206,153,49,214,161,55,
  210,157,51,198,146,37,213,163,50,227,177,64,228,181,67,232,185,69,
  236,191,72,239,195,72,241,197,72,240,199,71,240,200,69,242,204,71,
  239,201,66,235,198,65,235,198,66,241,204,74,240,205,77,240,205,77,
  241,204,74,242,205,73,241,204,72,241,204,72,242,205,73,243,206,74,
  239,202,70,240,203,71,241,204,72,243,206,74,243,206,74,243,206,74,
  243,206,74,246,207,78,243,204,75,238,199,70,240,201,72,241,202,73,
  241,202,73,239,200,71,246,207,78,246,207,78,245,206,77,244,205,76,
  242,203,74,241,202,71,247,207,73,247,205,71,245,203,69,242,199,69,
  244,201,73,246,203,75,248,205,77,245,202,72,245,202,71,245,203,69,
  245,203,67,245,203,65,243,204,65,243,207,67,239,203,65,240,202,69,
  249,199,78,240,185,69,222,164,54,211,148,43,205,140,40,219,153,57,
  223,158,64,221,158,63,216,156,60,211,153,54,226,163,66,209,149,53,
  182,130,31,185,143,43,184,152,51,203,171,72,188,152,55,200,158,60,
  207,164,59,212,171,65,219,178,72,222,183,78,210,176,76,208,173,73,
  204,165,64,206,163,61,209,164,61,204,152,50,213,160,56,215,161,55,
  206,154,45,197,145,35,224,174,59,232,185,69,228,181,65,236,189,73,
  238,193,74,240,196,73,239,198,72,241,200,72,241,201,70,242,204,71,
  238,201,68,235,198,66,235,198,66,239,204,76,240,205,79,240,205,79,
  242,205,75,241,204,74,240,203,73,241,204,74,243,206,76,244,207,77,
  239,202,72,240,203,73,241,204,74,243,206,76,243,206,76,243,206,76,
  243,206,76,240,201,70,239,200,69,240,201,70,242,203,72,241,202,71,
  238,199,68,235,196,65,244,205,74,244,205,74,244,205,74,245,206,75,
  246,207,76,247,209,76,244,205,68,242,203,66,238,198,64,235,195,64,
  236,195,67,239,198,72,241,200,74,242,201,75,242,201,73,242,202,71,
  242,202,70,242,202,68,242,203,64,237,200,59,239,202,61,242,203,66,
  243,198,73,239,190,71,229,178,63,222,168,59,205,148,43,217,154,57,
  223,160,63,227,164,69,225,162,67,212,149,52,208,142,48,201,138,45,
  184,130,34,189,145,48,183,149,51,196,162,65,175,139,43,190,145,52,
  200,159,53,199,161,54,202,165,58,205,171,64,198,164,64,195,160,60,
  186,146,48,186,142,43,199,151,51,222,169,65,218,164,58,212,158,50,
  213,159,50,221,169,57,232,183,65,231,184,66,232,187,68,239,194,77,
  237,195,75,238,196,75,238,197,73,239,198,72,239,200,71,241,204,72,
  239,202,70,236,201,71,237,202,74,239,204,78,235,201,77,233,199,75,
  237,202,76,235,200,72,238,203,75,242,207,79,242,207,79,239,204,76,
  240,205,77,240,205,77,241,206,78,241,206,78,241,206,78,239,204,76,
  240,203,73,237,198,67,237,198,67,240,201,70,245,206,75,247,208,77,
  247,208,77,245,206,75,244,205,74,242,203,72,241,202,71,241,202,71,
  242,203,72,243,205,72,165,139,47,164,138,45,163,137,45,188,157,55,
  241,200,74,241,200,76,242,200,79,241,199,78,241,199,78,241,200,76,
  241,200,74,241,200,72,241,201,67,238,200,57,244,206,61,245,206,66,
  238,200,67,241,202,75,239,199,78,233,190,75,220,174,63,216,163,61,
  210,152,52,203,140,43,196,132,35,196,125,33,200,129,39,209,142,53,
  205,146,56,205,156,64,179,142,51,193,156,67,176,135,47,184,134,49,
  203,160,55,200,159,53,180,143,49,6,168,9,6,168,9,6,168,9,
  66,52,19,199,153,55,205,157,57,219,168,63,219,166,60,215,163,53,
  222,170,58,237,186,71,232,186,64,43,66,13,6,168,9,6,168,9,
  237,196,72,237,196,72,238,197,71,239,198,70,239,200,71,240,203,73,
  240,203,73,239,201,74,239,204,76,239,204,78,235,200,74,231,196,70,
  235,200,72,234,199,71,238,203,75,243,208,80,242,207,79,237,202,74,
  241,206,78,241,206,78,242,207,79,241,206,78,241,206,78,238,203,75,
  239,202,72,248,209,80,245,206,77,240,201,72,243,204,75,245,206,77,
  246,207,78,246,207,78,251,212,83,248,209,80,245,206,77,243,204,75,
  243,204,75,243,204,73,168,28,6,168,28,6,168,28,6,134,111,40,
  240,199,73,240,199,75,240,198,77,241,199,78,241,199,78,241,200,76,
  243,199,76,243,199,74,243,200,69,245,204,64,248,207,65,247,205,67,
  243,204,73,246,208,81,240,201,80,230,189,75,234,190,81,233,181,80,
  218,162,65,202,142,46,195,130,38,205,136,45,212,141,49,223,157,61,
  218,157,64,215,162,68,187,144,50,203,162,70,190,145,54,188,138,49,
  206,159,55,214,165,62,218,169,66,6,168,9,6,168,9,6,168,9,
  6,168,9,214,166,66,210,162,62,216,167,64,212,164,56,219,171,60,
  229,182,66,236,190,70,186,152,51,6,168,9,6,168,9,134,111,37,
  236,198,65,235,197,64,236,197,66,239,200,71,243,204,75,245,206,79,
  243,204,77,241,202,75,240,202,75,239,202,72,235,198,68,232,195,65,
  227,190,60,235,198,68,236,199,69,235,198,68,240,203,73,244,207,77,
  242,205,75,241,204,74,241,204,74,241,204,74,240,203,73,239,202,72,
  239,202,72,242,203,76,242,203,76,243,204,77,243,204,77,243,204,77,
  243,204,77,243,204,77,243,204,77,247,208,81,245,206,79,241,202,75,
  243,204,77,192,162,62,168,28,6,168,28,6,168,28,6,161,135,50,
  241,201,77,241,200,76,241,200,76,231,187,64,228,184,61,229,185,62,
  233,187,65,236,190,68,232,187,60,246,202,69,244,202,66,244,202,68,
  245,204,76,244,204,82,240,199,81,237,195,83,240,196,89,227,174,78,
  195,139,46,191,129,42,208,143,59,183,116,29,203,138,36,213,151,42,
  222,161,55,223,166,61,221,169,67,212,163,61,203,153,54,186,136,37,
  209,160,57,216,164,62,218,166,64,6,168,9,6,168,9,6,168,9,
  6,168,9,213,165,63,222,174,72,213,166,60,216,169,61,222,177,62,
  231,186,67,237,193,68,47,61,13,6,168,9,6,168,9,241,202,62,
  239,201,64,240,202,67,241,203,70,243,204,73,245,206,79,245,205,81,
  242,202,78,240,201,74,239,200,73,240,201,70,238,199,68,236,197,66,
  232,195,65,239,202,72,240,203,73,239,202,72,243,206,76,247,210,80,
  246,209,79,246,209,79,245,208,78,245,208,78,244,207,77,244,207,77,
  243,205,78,243,203,79,243,203,79,243,203,79,244,204,80,244,204,80,
  244,204,80,244,204,80,246,206,82,248,208,84,247,207,83,244,204,80,
  239,199,75,213,177,67,165,138,55,165,138,55,164,137,55,245,205,81,
  245,205,81,246,205,81,245,204,80,242,198,75,240,194,72,241,195,73,
  244,198,76,246,200,78,245,197,73,246,201,72,245,201,70,244,201,71,
  245,204,80,245,203,82,241,200,84,238,196,84,242,198,93,238,185,91,
  206,151,60,191,131,45,199,137,54,207,141,54,212,149,44,218,158,44,
  222,162,50,220,162,52,223,169,63,221,168,64,215,164,59,193,144,39,
  211,163,61,215,166,64,213,164,62,69,53,19,6,168,9,6,168,9,
  6,168,9,187,145,53,228,181,77,208,161,53,222,176,65,228,183,66,
  235,191,70,160,131,46,6,168,9,6,168,9,159,133,38,239,200,60,
  241,203,66,242,204,69,243,205,72,243,204,73,243,204,77,244,204,80,
  241,201,77,237,198,71,237,198,71,241,202,71,241,202,71,241,202,71,
  236,199,69,242,204,77,240,202,75,239,201,74,244,206,79,246,208,81,
  243,205,78,242,204,77,242,204,77,242,204,77,241,203,76,240,202,75,
  240,202,75,242,202,78,242,202,78,241,201,77,241,201,77,241,201,77,
  241,201,77,241,201,77,243,203,79,243,203,79,245,205,81,246,206,82,
  240,200,76,237,197,73,244,204,80,243,203,79,243,203,79,242,202,78,
  242,202,78,242,201,77,242,201,77,244,200,77,243,197,75,243,197,75,
  245,199,77,246,200,78,246,198,74,246,201,72,245,200,71,243,200,70,
  245,204,80,245,203,83,242,201,85,239,197,85,237,193,86,241,188,92,
  214,159,66,190,130,42,187,125,40,220,156,66,213,151,48,220,162,52,
  228,170,60,230,174,65,233,178,75,227,174,70,219,167,65,199,150,47,
  205,162,58,208,165,61,209,168,63,70,55,20,6,168,9,6,168,9,
  6,168,9,140,109,37,207,161,50,213,168,53,230,185,68,234,190,69,
  238,194,69,6,168,9,6,168,9,47,61,12,234,196,53,235,196,56,
  240,202,65,242,204,69,243,204,73,215,180,65,159,133,48,80,67,26,
  79,66,25,78,65,23,157,131,46,243,204,75,245,206,75,246,207,76,
  239,201,74,243,205,78,239,201,74,159,134,49,163,137,53,162,137,52,
  218,184,71,218,184,71,110,93,36,109,92,35,244,206,79,243,205,78,
  243,205,78,243,204,77,161,135,49,108,90,33,80,67,25,80,67,24,
  80,67,25,107,89,32,157,131,45,204,169,56,228,189,60,234,195,68,
  244,205,78,82,69,26,82,69,27,82,69,26,137,115,45,245,206,79,
  245,206,77,245,204,78,245,204,76,247,204,76,247,202,77,164,134,49,
  81,66,25,81,66,24,83,67,25,138,111,42,217,177,66,242,198,73,
  243,201,80,245,203,83,243,202,86,242,201,87,190,156,71,78,62,28,
  79,62,28,77,59,26,215,156,62,193,135,38,183,140,59,100,76,29,
  68,51,16,62,45,11,155,117,37,215,167,67,221,176,75,216,171,70,
  200,159,54,202,163,58,207,168,63,139,113,42,6,168,9,6,168,9,
  6,168,9,120,94,32,203,157,45,225,180,61,232,188,67,236,192,67,
  133,109,37,6,168,9,6,168,9,184,152,41,235,197,54,239,200,60,
  243,205,70,245,207,74,136,115,42,6,28,168,6,28,168,6,28,168,
  6,28,168,6,28,168,6,28,168,81,68,25,245,206,77,245,206,77,
  244,206,79,246,208,81,161,136,51,149,6,168,149,6,168,149,6,168,
  136,115,44,149,6,168,149,6,168,81,68,26,242,204,77,241,203,76,
  161,135,51,168,6,47,168,6,47,168,6,47,168,6,47,168,6,47,
  168,6,47,168,6,47,168,6,47,182,151,51,229,190,61,230,191,62,
  238,199,70,168,28,6,168,28,6,168,28,6,163,137,51,243,204,75,
  243,204,75,243,202,74,243,202,74,111,92,34,52,168,6,52,168,6,
  52,168,6,52,168,6,52,168,6,52,168,6,52,168,6,108,88,33,
  243,201,80,245,203,83,244,203,85,243,202,86,81,67,30,6,20,168,
  6,20,168,6,20,168,204,155,66,11,21,142,6,20,168,6,20,168,
  6,20,168,6,20,168,6,20,168,175,139,64,225,181,84,220,176,79,
  193,156,52,195,160,56,200,165,61,136,111,41,6,168,9,6,168,9,
  6,168,9,71,56,18,208,163,48,230,186,65,235,191,68,238,195,67,
  6,168,9,6,168,9,47,61,12,239,198,56,238,200,57,241,202,63,
  243,205,70,81,69,24,6,28,168,6,28,168,6,28,168,159,132,51,
  132,110,42,6,28,168,6,28,168,6,28,168,163,137,51,242,203,74,
  244,206,79,246,208,83,135,114,44,149,6,168,149,6,168,149,6,168,
  149,6,168,149,6,168,149,6,168,133,112,42,239,201,76,186,156,59,
  168,6,47,168,6,47,168,6,47,82,69,26,164,138,51,163,137,50,
  136,114,41,81,68,25,168,6,47,240,201,70,237,198,67,234,195,64,
  157,131,44,168,28,6,168,28,6,168,28,6,188,158,55,240,201,70,
  239,200,69,214,178,61,54,55,14,52,168,6,52,168,6,52,168,6,
  133,108,36,159,129,43,55,47,16,52,168,6,52,168,6,52,168,6,
  161,133,53,245,203,83,245,204,86,243,204,87,47,41,39,6,20,168,
  6,20,168,6,20,168,6,20,168,6,20,168,11,21,142,6,20,168,
  6,20,168,6,20,168,6,20,168,145,114,51,205,161,66,202,159,64,
  191,154,50,192,157,53,196,163,58,176,146,51,6,168,9,6,168,9,
  6,168,9,69,54,16,213,168,51,229,185,62,238,194,69,134,110,38,
  6,168,9,6,168,9,188,156,47,242,201,59,241,203,60,240,201,62,
  107,90,30,6,28,168,6,28,168,6,28,168,212,176,66,238,198,76,
  237,197,75,79,66,25,6,28,168,6,28,168,81,68,26,240,201,74,
  241,203,78,242,204,79,80,67,25,149,6,168,149,6,168,149,6,168,
  82,69,27,217,183,72,244,206,81,217,183,72,243,205,80,63,43,20,
  168,6,47,168,6,47,58,45,18,244,206,73,242,203,72,241,203,70,
  240,201,70,240,202,69,240,202,69,244,205,74,244,206,73,240,201,70,
  133,111,38,168,28,6,168,28,6,168,28,6,245,206,75,244,205,74,
  244,206,73,81,68,24,52,168,6,52,168,6,52,168,6,218,179,62,
  240,195,66,239,195,64,247,199,71,52,168,6,52,168,6,52,168,6,
  55,48,17,244,204,82,245,205,84,244,205,86,6,20,168,6,20,168,
  6,20,168,6,20,168,78,61,26,190,143,53,216,168,68,145,114,49,
  6,20,168,6,20,168,6,20,168,123,93,31,176,133,39,177,134,40,
  190,152,51,187,154,51,188,156,53,193,158,54,6,168,9,6,168,9,
  6,168,9,6,168,9,213,168,49,236,192,67,214,175,61,6,168,9,
  6,168,9,80,66,21,241,200,60,240,199,57,238,199,59,215,181,59,
  6,28,168,6,28,168,6,28,168,105,88,31,235,195,71,239,199,78,
  244,204,83,83,69,29,6,28,168,6,28,168,80,67,25,243,204,77,
  242,204,79,241,203,80,149,6,168,149,6,168,149,6,168,57,46,23,
  248,210,87,242,204,81,237,199,76,238,200,77,242,204,81,168,6,47,
  168,6,47,168,6,47,168,6,47,187,158,52,239,201,68,239,201,66,
  238,200,67,236,198,63,240,202,67,240,202,69,240,202,67,240,202,69,
  80,67,23,168,28,6,168,28,6,63,45,15,242,204,71,242,204,71,
  135,114,39,52,168,6,52,168,6,52,168,6,165,135,48,245,201,68,
  244,200,69,244,200,67,246,199,69,81,65,23,52,168,6,52,168,6,
  52,168,6,246,206,84,247,207,85,193,162,68,6,20,168,6,20,168,
  6,20,168,78,63,26,244,196,88,200,151,48,203,158,57,136,107,42,
  6,20,168,6,20,168,6,20,168,158,118,37,179,136,42,176,133,39,
  198,160,59,190,157,54,187,155,52,189,156,51,6,168,9,6,168,9,
  6,168,9,6,168,9,220,175,56,230,186,61,107,88,30,6,168,9,
  6,168,9,214,176,55,239,198,58,239,198,58,237,198,59,106,89,27,
  6,28,168,6,28,168,6,28,168,134,112,43,161,134,53,161,134,53,
  162,135,55,54,46,23,6,28,168,6,28,168,81,68,27,245,205,81,
  242,204,81,241,203,80,149,6,168,149,6,168,149,6,168,162,137,55,
  238,200,77,235,197,74,232,194,71,232,194,71,234,196,73,168,6,47,
  168,6,47,168,6,47,168,6,47,168,6,47,63,42,18,135,114,39,
  242,204,69,241,203,68,242,204,69,242,204,69,242,204,69,242,204,69,
  168,28,6,168,28,6,168,28,6,81,68,23,242,204,69,242,204,69,
  54,56,14,52,168,6,52,168,6,52,168,6,245,201,68,245,201,68,
  245,201,68,244,200,67,246,199,67,80,65,21,52,168,6,52,168,6,
  52,168,6,243,203,79,243,205,80,161,137,55,6,20,168,6,20,168,
  6,20,168,234,191,79,240,194,83,181,134,28,188,142,44,81,62,18,
  6,20,168,6,20,168,6,20,168,200,155,64,184,141,49,184,141,47,
  221,179,79,219,181,80,216,183,80,216,181,79,69,54,21,6,168,9,
  6,168,9,6,168,9,178,143,52,208,169,58,6,168,9,6,168,9,
  108,89,30,242,200,66,242,200,66,243,201,67,241,201,67,47,42,35,
  6,28,168,6,28,168,6,28,168,6,28,168,6,28,168,6,28,168,
  6,28,168,6,28,168,6,28,168,6,28,168,137,115,46,243,203,79,
  242,204,81,163,137,55,149,6,168,149,6,168,149,6,168,183,153,57,
  242,204,81,246,208,85,250,212,89,248,210,87,243,205,82,161,135,53,
  168,6,47,168,6,47,168,6,47,168,6,47,168,6,47,168,6,47,
  168,6,47,157,132,41,242,204,67,242,204,67,242,204,67,242,204,67,
  168,28,6,168,28,6,168,28,6,135,114,38,242,204,67,214,180,58,
  52,168,6,52,168,6,52,168,6,81,67,22,246,202,67,247,203,68,
  246,202,67,242,198,63,238,192,57,81,65,20,52,168,6,52,168,6,
  52,168,6,244,207,75,245,208,78,81,70,27,6,20,168,6,20,168,
  6,20,168,240,200,87,245,203,93,201,157,52,205,159,61,73,57,25,
  6,20,168,6,20,168,67,51,20,187,140,48,181,134,42,190,144,50,
  213,169,72,213,173,75,210,175,75,211,173,74,93,74,30,6,168,9,
  6,168,9,6,168,9,146,116,39,106,87,32,6,168,9,6,168,9,
  214,175,60,239,196,65,240,197,66,242,199,69,241,201,70,6,28,168,
  6,28,168,6,28,168,6,28,168,80,67,26,82,68,28,83,70,31,
  82,68,29,80,67,27,81,67,27,82,69,28,190,158,62,240,200,76,
  242,204,81,136,115,47,149,6,168,149,6,168,149,6,168,233,194,73,
  240,201,80,244,205,84,248,209,88,246,207,86,241,202,81,240,201,80,
  215,182,70,110,93,33,168,6,47,168,6,47,168,6,47,168,6,47,
  168,6,47,168,6,47,161,136,43,241,204,64,241,204,64,161,136,43,
  168,28,6,168,28,6,168,28,6,162,137,44,242,205,65,160,135,42,
  52,168,6,52,168,6,52,168,6,163,135,43,247,204,66,247,204,66,
  245,202,64,241,198,60,235,189,52,52,168,6,52,168,6,52,168,6,
  81,68,22,243,207,71,244,207,75,50,44,29,6,20,168,6,20,168,
  78,66,27,237,197,86,241,200,92,226,181,78,192,146,48,6,20,168,
  6,20,168,6,20,168,79,57,15,177,128,35,183,134,41,175,126,31,
  199,153,57,197,155,57,191,153,54,189,149,51,139,108,45,6,168,9,
  6,168,9,6,168,9,31,90,11,6,168,9,6,168,9,106,87,30,
  236,193,65,235,192,62,236,193,65,238,195,67,238,197,69,6,28,168,
  6,28,168,6,28,168,78,65,24,237,197,75,240,199,81,244,203,87,
  243,202,86,242,201,83,243,202,84,244,204,82,241,201,77,239,199,75,
  241,202,81,82,69,29,149,6,168,149,6,168,66,39,37,235,196,75,
  243,204,83,244,205,84,245,206,85,244,205,84,242,203,82,242,203,82,
  244,206,81,240,202,67,239,202,62,134,114,36,168,6,47,168,6,47,
  168,6,47,168,6,47,80,68,21,240,203,63,240,203,63,134,113,35,
  168,28,6,168,28,6,168,28,6,243,206,66,242,205,65,159,135,41,
  52,168,6,52,168,6,52,168,6,165,137,45,248,205,67,247,204,66,
  244,201,63,241,198,60,158,127,35,52,168,6,52,168,6,52,168,6,
  134,112,35,240,204,66,241,204,71,6,20,168,6,20,168,6,20,168,
  130,110,46,228,190,81,232,191,85,229,186,82,175,133,45,6,20,168,
  6,20,168,6,20,168,123,89,28,186,135,43,186,136,41,189,139,42,
  199,150,55,194,150,53,188,148,50,186,143,48,139,108,47,6,168,9,
  6,168,9,6,168,9,6,168,9,6,168,9,6,168,9,240,197,69,
  237,194,66,236,193,65,237,193,68,240,196,71,239,198,72,6,28,168,
  6,28,168,6,28,168,6,28,168,238,198,76,237,196,78,233,192,76,
  237,196,80,242,201,83,245,204,86,243,203,81,242,202,78,242,202,78,
  241,202,81,149,6,168,149,6,168,149,6,168,79,66,26,239,200,79,
  248,209,88,246,207,86,243,204,83,243,204,83,245,206,85,248,209,88,
  247,209,84,238,200,65,238,201,60,242,205,64,218,185,60,168,6,47,
  168,6,47,168,6,47,80,68,21,241,204,63,241,204,63,80,68,21,
  168,28,6,168,28,6,168,28,6,243,206,65,241,204,63,159,135,41,
  52,168,6,52,168,6,52,168,6,136,114,36,246,203,64,245,202,63,
  244,201,62,244,201,62,52,168,6,52,168,6,52,168,6,52,168,6,
  239,200,60,239,203,63,188,160,54,6,20,168,6,20,168,6,20,168,
  155,131,55,230,192,83,228,190,83,221,178,76,139,107,41,6,20,168,
  6,20,168,6,20,168,184,137,55,208,155,61,204,151,57,212,159,63,
  206,158,58,204,161,59,201,159,57,199,155,56,213,164,71,6,168,9,
  6,168,9,6,168,9,6,168,9,6,168,9,136,113,42,243,203,72,
  242,199,68,240,197,66,242,199,71,245,201,76,246,202,77,106,89,30,
  6,28,168,6,28,168,6,28,168,80,67,26,210,174,67,224,183,67,
  232,191,75,215,179,74,164,137,58,135,113,46,243,203,81,245,205,83,
  241,202,81,149,6,168,149,6,168,149,6,168,159,133,55,243,204,87,
  248,209,92,242,203,86,237,198,79,185,155,62,135,113,47,220,185,77,
  247,208,81,243,205,70,242,205,65,243,206,66,163,137,45,168,6,47,
  168,6,47,168,6,47,190,161,52,244,205,65,243,206,65,58,46,15,
  168,28,6,168,28,6,82,69,22,244,205,66,242,203,64,239,200,61,
  52,168,6,52,168,6,52,168,6,55,48,14,243,201,63,243,201,63,
  244,202,64,82,68,22,52,168,6,52,168,6,52,168,6,188,155,44,
  242,203,64,243,205,68,162,137,49,6,20,168,6,20,168,6,20,168,
  237,199,88,236,198,89,233,194,89,216,172,73,89,67,25,6,20,168,
  6,20,168,6,20,168,218,165,71,225,172,76,228,176,77,211,157,57,
  206,163,50,211,168,56,209,165,56,204,157,51,210,161,59,6,168,9,
  6,168,9,6,168,9,6,168,9,6,168,9,237,201,65,235,200,56,
  236,198,51,238,200,53,244,200,65,242,194,68,237,192,65,218,182,65,
  6,28,168,6,28,168,6,28,168,6,28,168,6,28,168,6,28,168,
  6,28,168,6,28,168,6,28,168,158,131,50,242,202,80,247,207,85,
  162,135,55,149,6,168,149,6,168,149,6,168,193,160,76,246,203,98,
  243,200,95,243,201,93,243,201,91,109,91,40,168,6,47,168,6,47,
  168,6,47,82,68,24,82,68,23,58,44,16,168,6,47,168,6,47,
  168,6,47,162,134,45,246,204,68,246,204,66,246,205,65,168,28,6,
  168,28,6,168,28,6,139,113,38,248,201,69,244,200,69,242,198,67,
  161,131,44,52,168,6,52,168,6,52,168,6,52,168,6,79,66,23,
  52,168,6,52,168,6,52,168,6,52,168,6,162,133,49,239,195,70,
  241,200,72,246,205,77,82,69,26,6,20,168,6,20,168,6,20,168,
  239,199,86,233,195,86,233,195,88,200,157,62,57,40,12,6,20,168,
  6,20,168,16,23,126,211,158,62,215,162,60,216,164,55,211,158,46,
  207,166,52,210,168,56,209,167,57,206,162,55,210,161,59,23,110,10,
  6,168,9,6,168,9,6,168,9,121,100,31,237,201,65,236,201,59,
  238,200,55,239,201,56,244,200,65,244,196,70,239,194,67,248,208,76,
  206,171,54,50,44,28,6,28,168,6,28,168,6,28,168,6,28,168,
  6,28,168,6,28,168,54,46,23,187,155,60,242,202,78,246,206,82,
  136,114,46,149,6,168,149,6,168,149,6,168,250,208,96,248,206,96,
  242,200,90,243,201,89,243,202,88,109,90,38,168,6,47,168,6,47,
  168,6,47,168,6,47,168,6,47,168,6,47,168,6,47,81,67,22,
  190,157,52,243,201,65,246,204,66,246,204,66,192,160,51,168,28,6,
  168,28,6,168,28,6,166,135,44,248,202,67,244,200,67,242,198,65,
  241,197,64,161,133,43,52,168,6,52,168,6,52,168,6,52,168,6,
  52,168,6,52,168,6,108,91,32,222,183,69,245,202,74,242,199,71,
  242,202,71,246,206,75,54,45,21,6,20,168,6,20,168,81,68,29,
  237,197,83,235,197,86,237,199,92,213,171,73,6,20,168,6,20,168,
  6,20,168,66,49,18,209,157,56,211,160,55,211,160,51,210,158,46,
  205,165,52,208,166,56,208,166,58,206,162,55,214,165,63,162,123,48,
  134,102,37,133,101,35,135,107,37,226,188,65,236,199,66,237,202,60,
  239,201,56,240,202,57,244,200,65,245,197,69,242,197,70,241,201,70,
  228,189,60,233,194,67,209,174,63,155,128,47,158,131,51,155,128,49,
  159,131,53,243,203,82,245,205,83,242,202,78,242,203,76,244,205,76,
  191,161,62,161,135,50,161,134,53,165,137,59,251,210,94,250,209,93,
  242,201,87,242,201,85,242,201,83,243,203,82,243,203,81,190,160,61,
  163,137,49,164,136,47,164,136,45,191,158,52,244,202,66,244,202,64,
  243,201,63,243,201,63,246,205,65,246,205,65,219,182,56,164,137,42,
  164,137,41,164,137,42,249,203,66,249,203,66,245,201,66,243,199,64,
  243,199,64,243,201,67,243,201,67,188,157,54,159,134,45,160,135,46,
  189,158,56,244,205,74,242,203,72,248,205,75,245,202,72,242,199,69,
  241,201,70,243,203,71,164,137,50,165,139,51,156,130,45,184,154,61,
  235,196,79,237,199,88,242,204,95,227,185,83,143,111,49,141,107,48,
  139,105,43,183,139,54,212,160,58,213,162,53,213,163,52,215,164,49,
  202,165,51,205,165,54,205,164,56,202,160,52,210,161,59,206,156,59,
  200,152,54,199,151,53,203,160,56,226,187,66,235,198,66,236,200,60,
  240,202,59,241,203,60,244,200,65,246,198,70,244,199,72,233,192,64,
  235,195,71,227,187,65,229,189,67,240,200,79,246,205,87,233,192,74,
  237,197,76,243,203,81,245,205,81,244,205,76,242,203,72,242,203,72,
  243,204,73,240,201,70,240,201,74,245,205,81,249,209,87,249,209,87,
  241,201,80,242,202,80,242,202,80,242,202,78,243,204,77,244,205,74,
  244,206,73,246,204,70,246,204,68,245,203,65,244,202,64,244,203,63,
  243,202,62,243,202,60,246,205,63,246,205,63,246,205,61,246,205,61,
  246,205,61,246,205,61,250,204,66,250,204,66,246,203,65,245,202,64,
  246,203,65,245,203,67,246,204,68,241,201,67,239,201,66,241,203,68,
  243,205,72,244,206,73,241,203,70,246,203,72,244,201,70,242,199,68,
  238,198,66,240,200,66,244,204,72,246,206,74,244,205,76,240,201,80,
  238,199,80,237,200,86,237,199,88,221,180,75,215,169,71,212,163,68,
  206,158,60,204,156,54,208,160,50,211,161,50,211,161,46,218,167,50,
  205,167,56,206,168,57,206,165,57,201,159,51,210,161,58,206,156,59,
  203,154,59,205,156,61,210,167,65,227,188,69,232,195,65,235,199,61,
  240,201,61,241,203,60,242,198,63,245,197,69,245,200,73,233,192,66,
  242,202,80,230,190,69,232,192,71,248,207,89,252,211,93,236,195,77,
  238,198,77,242,202,80,244,205,78,244,205,74,242,204,71,240,202,67,
  241,203,68,240,202,67,239,201,68,240,201,70,243,204,75,246,207,80,
  241,202,75,241,202,75,241,202,73,242,203,74,242,203,72,243,205,72,
  243,205,70,246,204,68,246,204,68,245,203,65,244,203,63,244,203,61,
  243,202,60,243,202,58,246,206,59,246,205,61,246,205,61,246,205,61,
  246,206,59,246,205,61,250,205,64,249,204,63,246,203,64,245,202,63,
  246,203,65,246,204,66,246,204,66,241,202,65,239,201,66,241,203,68,
  244,206,73,245,207,74,240,202,69,245,202,71,245,203,69,243,201,67,
  237,197,63,238,198,64,242,202,68,246,206,72,245,206,75,241,203,80,
  241,202,81,240,203,88,236,199,85,220,179,71,213,168,65,211,163,61,
  207,160,56,206,159,53,212,164,53,215,165,50,215,166,48,224,173,55,
  211,173,64,214,176,67,211,170,62,203,161,53,213,164,61,208,158,61,
  209,160,65,216,167,72,221,177,78,230,191,74,230,192,65,233,197,61,
  239,200,60,240,202,59,240,196,61,244,196,68,245,200,75,238,197,73,
  240,200,78,239,199,78,241,200,82,245,204,88,248,207,91,240,199,81,
  240,200,78,241,201,77,243,204,77,243,205,72,241,203,68,239,201,64,
  238,201,61,241,204,64,239,201,64,235,197,62,235,197,62,242,204,71,
  240,202,69,241,203,70,241,203,70,241,203,70,242,204,71,243,205,70,
  243,205,70,246,204,68,246,204,68,245,203,65,244,203,63,244,203,61,
  243,202,58,243,203,56,246,206,57,246,206,59,246,206,59,246,206,59,
  246,205,61,246,205,61,247,202,59,246,201,58,243,200,59,243,200,59,
  244,201,62,244,203,63,244,202,64,240,201,64,240,202,67,242,204,69,
  245,207,74,245,207,74,239,201,68,246,204,70,247,205,69,246,204,68,
  237,198,61,238,199,62,243,204,67,247,207,73,239,201,68,238,200,75,
  243,205,82,244,207,90,240,203,88,225,185,74,212,170,62,210,166,59,
  210,163,55,211,165,54,218,173,56,220,173,55,220,174,54,228,179,60,
  218,177,71,209,166,61,198,154,47,194,147,41,208,159,54,197,147,50,
  214,165,70,229,180,87,240,196,99,219,179,66,225,187,64,230,193,61,
  237,198,59,240,201,61,242,198,63,245,198,68,244,199,72,244,203,79,
  224,184,63,228,188,67,241,200,84,250,209,93,249,208,92,242,201,83,
  242,202,80,242,202,78,243,204,75,244,206,71,243,205,70,242,205,65,
  246,209,68,241,204,61,238,201,60,243,206,65,245,208,67,243,206,66,
  242,205,65,244,206,69,246,208,71,248,210,75,247,209,74,243,205,72,
  241,203,70,249,206,75,247,204,73,247,205,67,248,207,67,248,207,63,
  247,207,60,245,205,56,241,201,52,242,202,53,245,205,58,248,207,63,
  247,206,64,244,203,61,245,200,57,239,194,49,239,197,53,239,196,55,
  229,186,45,235,194,54,252,210,72,243,203,69,244,206,73,246,207,76,
  247,208,77,248,209,80,248,209,78,244,202,68,243,201,65,243,201,63,
  242,203,64,243,204,65,245,206,69,246,207,70,239,201,68,241,203,76,
  235,197,74,235,199,79,240,203,86,220,180,67,213,171,59,215,172,59,
  218,175,62,221,178,63,219,177,57,224,180,59,228,184,61,220,174,54,
  214,171,67,208,164,59,201,152,47,197,148,43,212,161,56,201,151,54,
  210,161,68,219,170,78,229,185,90,227,187,76,227,188,67,231,194,64,
  238,199,62,240,201,62,241,197,62,244,197,67,242,197,70,240,199,75,
  225,185,63,228,188,67,238,197,79,244,203,87,244,203,87,246,205,87,
  245,205,83,244,204,80,244,205,78,244,206,73,242,204,69,240,202,65,
  239,202,61,241,204,63,242,205,62,240,203,60,238,201,58,237,200,59,
  242,205,65,243,205,68,245,207,70,246,208,73,246,208,75,240,201,72,
  238,199,70,255,212,84,253,210,80,247,205,69,244,203,63,240,199,57,
  237,197,50,234,194,45,238,198,49,239,199,52,241,200,56,244,203,61,
  243,201,63,240,199,59,253,208,65,246,201,56,243,201,57,231,188,47,
  213,170,31,210,168,30,220,178,42,243,203,71,244,205,74,246,207,78,
  165,139,54,165,139,55,165,139,53,191,158,55,244,202,66,244,202,66,
  242,203,66,243,204,67,244,205,68,245,205,71,239,201,68,241,203,78,
  233,195,72,233,196,79,237,200,85,216,176,63,215,173,61,218,175,62,
  220,177,64,221,178,63,219,177,57,223,179,58,226,182,61,214,168,48,
  216,171,68,215,166,63,213,160,56,212,159,55,214,163,58,207,157,60,
  209,160,67,215,166,74,223,179,84,237,196,88,230,191,72,233,195,68,
  239,199,65,240,201,62,240,196,61,242,195,63,241,196,67,241,200,74,
  236,196,74,238,198,77,242,202,81,245,204,86,245,204,86,246,205,87,
  163,136,55,160,6,168,160,6,168,160,6,168,217,183,65,242,204,69,
  236,198,61,242,205,65,246,209,68,240,203,62,234,197,56,234,197,57,
  241,203,66,242,204,67,243,205,72,244,205,74,243,204,75,239,199,75,
  237,197,73,248,204,81,248,205,77,248,206,72,246,204,66,244,203,63,
  243,202,58,242,202,53,244,204,55,244,204,57,246,205,63,248,207,67,
  246,204,70,243,201,65,250,205,64,246,201,58,246,203,62,238,195,56,
  221,178,40,216,174,38,223,181,47,243,203,72,244,205,78,246,207,80,
  226,34,175,226,34,175,226,34,175,165,136,49,246,204,70,245,203,69,
  242,202,68,242,202,68,243,203,69,243,203,69,239,200,69,240,202,79,
  232,193,72,231,194,79,235,198,84,213,173,62,220,178,68,221,179,69,
  220,178,66,215,174,60,208,166,48,207,165,45,207,165,45,208,163,44,
  212,162,63,214,161,59,217,159,59,220,163,60,214,161,57,212,162,65,
  214,165,72,225,176,84,228,183,90,238,197,91,232,193,76,157,131,48,
  80,67,23,80,67,21,6,20,168,6,20,168,6,20,168,6,20,168,
  6,20,168,50,43,30,81,67,27,135,112,45,243,202,84,241,200,82,
  106,89,34,160,6,168,160,6,168,160,6,168,246,207,76,244,206,73,
  240,202,67,243,205,70,243,206,66,240,203,63,238,201,61,239,202,62,
  238,200,63,239,201,68,241,202,71,242,203,76,243,203,79,241,200,82,
  241,200,82,245,200,81,247,203,80,251,208,78,251,209,75,249,208,68,
  249,208,66,250,210,63,248,208,61,247,206,62,248,207,67,250,208,72,
  248,205,74,245,203,69,246,200,62,245,200,59,245,202,61,246,203,65,
  237,193,58,236,194,60,242,199,68,243,202,74,244,204,80,164,137,56,
  226,34,175,226,34,175,226,34,175,194,161,61,248,205,74,246,203,72,
  242,202,70,242,202,68,242,202,70,243,203,71,238,199,70,239,200,79,
  232,193,74,154,129,53,29,23,183,29,23,183,29,23,183,222,180,72,
  220,178,70,213,171,59,205,162,47,204,162,44,201,159,41,199,154,37,
  197,145,46,200,142,42,207,143,45,212,150,49,206,152,46,210,160,63,
  214,165,72,234,184,95,232,187,96,153,125,55,6,20,168,6,20,168,
  6,20,168,6,20,168,6,20,168,6,20,168,6,20,168,6,20,168,
  6,20,168,6,20,168,6,20,168,6,20,168,236,196,75,243,202,84,
  79,65,26,160,6,168,160,6,168,81,68,26,241,202,75,237,198,69,
  245,206,75,239,200,69,232,194,59,236,198,63,241,203,66,243,205,68,
  236,198,65,237,198,67,239,200,73,242,202,80,244,203,85,246,205,91,
  246,205,91,249,204,89,253,208,89,254,211,83,249,206,75,244,202,64,
  242,201,61,242,201,57,244,203,59,242,201,61,242,200,62,244,202,68,
  243,200,72,242,199,69,251,205,68,248,202,64,244,201,62,240,196,61,
  237,193,60,237,194,64,242,199,71,243,202,78,244,204,83,137,114,48,
  226,34,175,226,34,175,226,34,175,249,205,80,248,205,75,247,204,74,
  243,203,72,243,203,71,243,203,72,243,203,72,238,199,72,240,201,82,
  233,194,77,104,87,37,29,23,183,29,23,183,29,23,183,224,183,78,
  223,182,77,213,172,64,209,167,55,209,166,53,204,161,46,196,151,36,
  197,141,44,199,136,39,205,137,40,210,145,45,198,144,38,204,154,57,
  205,156,63,229,179,90,75,60,29,6,20,168,6,20,168,6,20,168,
  6,20,168,47,41,35,133,108,33,161,129,41,161,131,44,157,131,43,
  106,88,30,47,41,35,6,20,168,79,65,24,238,198,77,248,207,89,
  160,6,168,160,6,168,160,6,168,106,89,34,234,194,70,229,190,63,
  245,206,79,236,197,68,225,187,54,232,194,61,240,202,67,244,206,73,
  239,200,69,240,201,74,241,201,79,243,202,84,246,205,91,250,208,98,
  250,208,98,236,190,79,242,197,82,249,205,80,246,203,73,243,201,65,
  243,202,62,245,204,62,244,203,61,242,200,62,242,200,64,245,202,71,
  246,202,79,244,201,73,252,206,71,249,203,65,244,201,63,240,196,63,
  241,197,66,242,199,71,245,201,76,243,201,80,244,203,85,82,68,30,
  226,34,175,226,34,175,59,46,24,249,205,82,248,205,77,247,204,76,
  243,203,72,244,204,73,244,204,73,245,204,76,240,200,76,241,202,83,
  233,193,79,77,65,28,29,23,183,29,23,183,76,62,29,234,192,92,
  229,187,85,212,171,66,200,158,48,196,153,41,187,144,31,208,162,50,
  226,172,72,220,163,60,219,156,53,219,158,52,208,155,49,208,158,59,
  188,139,44,67,51,20,6,20,168,6,20,168,6,20,168,6,20,168,
  186,154,54,237,197,63,238,195,57,241,198,60,243,201,63,242,203,66,
  232,194,59,232,194,61,210,175,59,188,158,59,244,204,80,215,179,71,
  160,6,168,160,6,168,160,6,168,164,137,56,244,204,80,239,199,75,
  245,206,77,247,208,77,243,204,73,239,200,69,239,200,69,245,206,77,
  252,212,88,250,211,90,249,210,93,248,208,94,248,208,97,248,207,101,
  250,207,102,229,186,74,240,195,80,251,207,84,247,204,74,244,202,68,
  246,204,66,249,208,68,239,198,58,237,195,57,238,196,62,241,198,68,
  245,201,80,245,201,76,250,206,73,251,208,70,250,208,72,246,203,72,
  244,201,71,238,195,67,230,189,63,243,201,81,244,203,85,226,34,175,
  226,34,175,226,34,175,83,69,30,246,202,81,246,203,75,246,203,75,
  245,205,74,246,206,75,247,207,76,248,207,79,247,206,82,244,203,87,
  233,191,79,29,23,183,29,23,183,29,23,183,93,75,31,222,180,82,
  226,184,84,218,176,74,232,189,85,235,192,87,229,187,79,211,167,60,
  194,154,41,196,155,39,210,168,48,227,182,63,213,167,55,200,153,49,
  142,112,43,6,20,168,6,20,168,6,20,168,6,20,168,206,168,63,
  233,192,66,237,197,65,242,201,59,240,199,55,236,198,53,235,198,58,
  238,200,65,240,202,67,241,203,70,241,203,70,240,201,70,162,136,50,
  160,6,168,160,6,168,160,6,168,214,179,64,234,195,68,190,159,57,
  109,92,30,80,67,21,80,67,22,191,160,57,249,208,80,247,207,83,
  245,206,87,249,212,95,250,213,99,245,208,94,216,184,85,164,141,68,
  82,70,32,81,67,28,82,67,26,165,136,49,247,204,73,248,206,70,
  248,206,68,248,207,67,239,198,58,240,198,60,237,195,61,234,191,61,
  242,198,73,165,137,51,109,91,31,71,81,30,71,81,30,71,80,30,
  134,112,39,161,134,47,239,200,71,241,201,77,242,202,80,226,34,175,
  226,34,175,226,34,175,165,139,58,246,202,77,244,201,71,243,200,69,
  161,133,43,81,67,22,82,68,23,221,183,64,255,213,83,248,206,86,
  228,185,72,29,23,183,29,23,183,29,23,183,172,140,59,205,167,60,
  210,172,65,205,166,61,244,202,100,231,189,89,229,187,87,205,161,62,
  204,171,55,202,170,49,202,168,44,203,167,44,206,165,51,198,154,47,
  6,20,168,6,20,168,6,20,168,6,20,168,205,166,67,230,188,70,
  231,190,66,232,192,60,236,198,53,236,199,49,236,198,51,231,194,54,
  235,197,62,238,200,65,240,202,67,240,202,67,240,202,69,105,88,29,
  160,6,168,160,6,168,160,6,168,217,182,68,79,66,23,160,6,168,
  160,6,168,160,6,168,160,6,168,160,6,168,221,186,71,248,208,86,
  245,208,91,249,212,97,247,211,97,134,114,51,12,168,6,12,168,6,
  12,168,6,12,168,6,12,168,6,12,168,6,83,69,24,247,205,67,
  247,205,67,247,206,66,243,202,62,242,200,64,215,177,58,107,88,29,
  168,17,6,168,17,6,168,17,6,168,17,6,168,17,6,168,17,6,
  168,17,6,168,17,6,244,205,74,242,203,76,161,135,51,226,34,175,
  226,34,175,226,34,175,192,161,64,244,201,73,244,201,70,162,134,45,
  226,34,175,226,34,175,82,68,22,247,205,67,253,211,77,247,203,82,
  152,122,45,29,23,183,29,23,183,29,23,183,205,164,56,202,165,51,
  218,180,69,210,172,63,223,181,79,208,166,68,210,166,69,192,148,51,
  215,182,67,214,182,63,205,173,52,195,160,40,206,165,51,110,86,26,
  6,20,168,6,20,168,6,20,168,106,86,38,231,187,78,230,187,72,
  228,186,65,227,187,56,231,193,50,235,197,50,237,199,52,229,192,51,
  233,195,58,236,198,61,238,200,63,240,202,65,241,203,68,77,65,20,
  160,6,168,160,6,168,67,39,35,160,6,168,160,6,168,160,6,168,
  160,6,168,160,6,168,160,6,168,160,6,168,165,139,53,248,208,86,
  245,208,91,248,211,96,81,69,31,12,168,6,12,168,6,12,168,6,
  167,144,65,138,115,46,12,168,6,12,168,6,12,168,6,165,137,45,
  246,204,66,246,205,65,246,205,65,190,157,51,168,17,6,168,17,6,
  168,17,6,168,17,6,168,17,6,71,81,30,71,81,30,168,17,6,
  168,17,6,66,87,33,241,202,71,243,204,75,135,114,42,226,34,175,
  226,34,175,226,34,175,243,204,75,242,199,68,215,178,59,226,34,175,
  226,34,175,82,68,21,245,204,62,244,203,63,250,208,72,243,199,76,
  152,122,44,29,23,183,29,23,183,68,53,20,206,164,56,216,176,63,
  242,202,91,229,188,80,215,172,70,200,157,55,207,161,63,192,146,48,
  210,177,64,212,179,63,207,174,58,202,167,49,209,167,55,20,26,109,
  6,20,168,6,20,168,6,20,168,197,158,62,231,187,78,230,187,74,
  227,185,64,225,184,56,228,190,47,235,197,52,240,202,55,232,195,54,
  234,197,57,236,199,59,238,201,61,239,201,64,240,202,67,160,6,168,
  160,6,168,160,6,168,160,6,168,160,6,168,178,147,50,235,196,65,
  134,112,35,160,6,168,160,6,168,160,6,168,163,137,51,245,207,84,
  242,205,88,110,93,42,12,168,6,12,168,6,12,168,6,218,189,85,
  248,212,92,249,208,84,84,69,26,12,168,6,12,168,6,82,68,22,
  245,203,65,245,204,64,218,182,57,168,17,6,168,17,6,168,17,6,
  168,17,6,184,153,51,241,201,69,240,202,67,240,202,67,239,201,66,
  239,201,66,187,157,52,239,201,68,243,205,72,81,68,24,226,34,175,
  226,34,175,67,44,28,240,202,69,214,176,57,226,34,175,226,34,175,
  226,34,175,245,204,62,243,202,60,242,201,61,248,206,70,241,197,72,
  128,103,37,29,23,183,29,23,183,116,91,35,217,175,65,228,188,74,
  252,212,99,237,195,85,217,174,69,207,162,59,216,171,68,208,163,60,
  234,201,94,219,187,78,216,184,75,229,195,85,213,173,62,6,20,168,
  6,20,168,6,20,168,6,20,168,225,182,78,219,177,69,223,181,69,
  227,186,68,228,188,64,229,191,54,234,197,56,240,203,60,241,204,61,
  239,202,59,238,201,58,238,201,60,238,201,61,212,178,56,160,6,168,
  160,6,168,160,6,168,78,65,24,236,196,74,227,187,66,235,195,71,
  159,132,43,160,6,168,160,6,168,160,6,168,188,158,59,243,205,82,
  210,178,71,12,168,6,12,168,6,12,168,6,107,91,38,237,202,82,
  234,198,75,245,204,76,82,68,24,12,168,6,12,168,6,81,67,21,
  243,201,63,243,202,62,168,17,6,168,17,6,168,17,6,168,17,6,
  217,179,62,242,199,68,241,201,67,240,202,67,241,203,68,241,203,66,
  242,204,67,242,204,67,242,205,65,242,205,64,226,34,175,226,34,175,
  226,34,175,80,67,20,213,179,52,226,34,175,226,34,175,226,34,175,
  217,181,53,243,202,58,243,202,58,243,202,60,244,203,63,236,193,63,
  78,63,22,29,23,183,29,23,183,169,132,48,222,179,66,213,172,56,
  219,176,63,203,160,47,217,173,64,213,166,58,221,174,66,222,174,66,
  245,214,108,224,193,87,222,191,85,242,209,102,149,123,51,6,20,168,
  6,20,168,6,20,168,69,55,21,211,169,67,207,166,60,216,176,65,
  225,186,69,229,191,68,228,192,56,231,195,55,235,200,58,239,202,59,
  237,200,57,236,199,56,236,199,58,237,200,60,159,134,43,160,6,168,
  160,6,168,160,6,168,207,171,61,237,197,76,230,189,71,239,199,75,
  133,111,36,160,6,168,160,6,168,160,6,168,241,203,76,245,207,82,
  108,91,38,12,168,6,12,168,6,12,168,6,131,111,43,157,133,51,
  156,131,46,161,134,47,51,55,14,12,168,6,12,168,6,81,67,21,
  243,201,63,190,157,49,168,17,6,168,17,6,168,17,6,110,91,30,
  243,201,67,244,202,68,237,197,63,237,197,63,238,199,62,239,200,63,
  239,200,61,240,201,62,240,201,61,241,203,60,226,34,175,226,34,175,
  226,34,175,160,135,37,80,67,18,226,34,175,226,34,175,215,178,52,
  241,200,56,242,201,57,243,202,58,244,203,61,240,199,59,232,189,58,
  78,63,22,29,23,183,29,23,183,216,170,58,223,180,67,214,171,56,
  221,176,61,207,161,49,223,177,66,215,167,57,219,171,61,220,169,60,
  232,200,97,213,181,78,215,183,80,244,211,106,157,132,59,6,20,168,
  6,20,168,6,20,168,64,50,16,184,142,42,200,159,54,211,170,62,
  224,184,70,230,191,70,227,190,58,229,193,57,232,196,56,235,198,55,
  234,197,54,233,196,53,235,198,57,237,200,60,107,90,29,160,6,168,
  160,6,168,160,6,168,231,191,67,235,195,74,229,189,68,238,198,74,
  80,68,23,160,6,168,160,6,168,62,43,29,243,205,78,248,210,85,
  54,49,19,12,168,6,12,168,6,12,168,6,12,168,6,12,168,6,
  12,168,6,12,168,6,12,168,6,12,168,6,12,168,6,135,111,35,
  242,200,62,135,111,35,168,17,6,168,17,6,168,17,6,187,155,48,
  240,198,62,243,201,65,241,201,67,241,201,67,242,203,66,243,204,65,
  244,205,66,244,205,65,245,207,64,160,135,38,226,34,175,226,34,175,
  226,34,175,67,44,25,226,34,175,226,34,175,226,34,175,240,199,55,
  240,199,55,241,200,56,244,203,59,245,204,62,237,195,57,229,186,55,
  29,23,183,29,23,183,73,58,18,215,170,55,221,178,63,215,172,57,
  226,181,66,213,168,53,224,178,66,211,163,52,212,164,53,221,171,60,
  225,196,94,227,198,96,230,201,99,234,202,99,153,129,57,6,20,168,
  6,20,168,6,20,168,11,22,142,212,173,72,197,158,55,216,178,71,
  213,175,64,215,178,61,232,197,67,221,187,53,237,201,63,235,198,57,
  235,198,57,235,198,57,235,198,58,236,199,59,79,67,21,160,6,168,
  160,6,168,79,66,24,234,194,70,243,203,81,246,206,84,242,202,78,
  160,6,168,160,6,168,160,6,168,80,68,24,244,206,79,245,207,82,
  12,168,6,12,168,6,12,168,6,12,168,6,79,66,24,80,67,24,
  79,66,22,79,66,20,80,66,20,79,65,19,79,65,19,187,154,46,
  240,198,62,66,85,31,168,17,6,168,17,6,168,17,6,234,192,54,
  236,194,56,237,195,57,245,203,67,244,202,66,243,201,65,243,201,63,
  241,199,61,238,197,57,234,193,51,136,113,33,226,34,175,226,34,175,
  226,34,175,163,136,36,226,34,175,226,34,175,226,34,175,135,112,33,
  231,190,48,236,195,53,241,200,58,240,199,59,245,203,65,237,194,63,
  29,23,183,29,23,183,124,99,32,218,173,56,216,173,58,210,169,55,
  224,181,68,225,182,69,234,191,76,243,198,83,215,170,55,211,164,50,
  227,198,96,234,205,103,234,205,105,235,203,100,181,152,69,6,20,168,
  6,20,168,6,20,168,6,20,168,155,119,32,181,142,41,211,172,67,
  212,174,65,203,166,51,230,195,69,224,189,59,228,194,58,231,194,54,
  232,195,55,233,196,56,234,197,57,236,198,61,160,6,168,160,6,168,
  160,6,168,104,87,29,231,192,65,243,203,79,237,197,73,226,188,61,
  160,6,168,160,6,168,160,6,168,157,132,47,238,200,75,238,200,77,
  12,168,6,12,168,6,12,168,6,79,66,24,238,201,71,244,206,73,
  242,202,68,241,199,61,240,199,59,239,197,59,239,197,59,240,198,60,
  241,199,63,71,80,28,168,17,6,168,17,6,168,17,6,239,197,59,
  241,200,60,241,200,60,237,195,57,238,196,60,239,197,61,244,202,64,
  244,203,63,243,202,60,242,201,59,83,69,21,226,34,175,226,34,175,
  76,43,33,241,201,52,226,34,175,226,34,175,226,34,175,85,41,43,
  241,200,60,235,194,54,237,195,57,246,204,66,237,195,59,203,165,49,
  76,62,19,74,60,18,168,133,37,212,170,52,238,197,83,234,192,80,
  243,201,89,240,199,85,239,196,81,241,198,83,216,171,56,208,163,48,
  211,184,81,218,191,88,217,189,89,213,184,80,227,193,85,6,20,168,
  6,20,168,6,20,168,6,20,168,31,29,69,177,138,37,214,175,72,
  220,182,75,203,166,52,232,196,73,234,199,71,230,196,63,234,196,61,
  235,197,60,237,199,62,239,201,64,214,180,60,160,6,168,160,6,168,
  160,6,168,155,129,41,232,193,64,243,204,77,233,194,67,144,119,33,
  160,6,168,160,6,168,160,6,168,181,154,54,234,199,73,233,197,74,
  12,168,6,12,168,6,12,168,6,12,168,6,239,201,68,245,206,69,
  242,203,64,243,202,60,242,201,59,240,199,59,240,198,60,241,199,61,
  242,200,64,71,80,29,168,17,6,168,17,6,168,17,6,135,112,34,
  243,202,60,244,203,61,236,193,55,237,194,56,240,197,59,244,201,62,
  245,202,63,246,203,62,246,203,62,226,34,175,226,34,175,226,34,175,
  79,65,17,240,198,52,133,110,30,226,34,175,226,34,175,226,34,175,
  194,161,53,234,192,54,234,192,56,249,207,73,240,197,66,230,187,59,
  217,173,48,212,168,45,216,172,49,214,172,54,213,173,60,214,174,63,
  223,183,72,223,183,70,230,189,75,233,192,76,215,172,57,207,164,49,
  203,179,71,198,174,68,196,171,68,199,170,66,212,178,70,112,92,32,
  6,20,168,6,20,168,6,20,168,6,20,168,25,28,94,138,113,45,
  220,183,79,225,189,79,211,176,56,219,185,61,152,129,45,103,87,29,
  6,20,168,157,131,43,236,197,66,157,131,43,160,6,168,160,6,168,
  160,6,168,215,182,63,237,199,64,240,202,67,242,204,69,134,113,39,
  160,6,168,160,6,168,160,6,168,232,198,72,240,206,80,247,212,86,
  107,90,34,12,168,6,12,168,6,12,168,6,80,67,21,216,180,55,
  239,198,56,246,206,59,218,182,52,162,135,40,135,112,34,242,200,62,
  243,201,65,190,157,52,168,17,6,168,17,6,168,17,6,168,17,6,
  135,112,31,242,202,55,242,199,58,244,201,60,192,158,48,134,110,33,
  214,175,52,242,199,60,245,202,63,226,34,175,226,34,175,226,34,175,
  162,133,41,241,198,60,217,179,56,226,34,175,226,34,175,226,34,175,
  77,62,19,241,198,68,241,198,70,231,188,60,204,165,53,153,124,42,
  141,111,31,139,110,29,201,162,54,218,177,59,226,190,80,227,193,86,
  220,186,79,212,175,68,209,173,59,208,171,56,208,171,56,221,181,67,
  205,181,71,193,169,61,184,160,54,182,155,48,193,161,52,197,160,53,
  67,55,20,6,20,168,6,20,168,6,20,168,6,20,168,6,20,168,
  6,20,168,6,20,168,6,20,168,6,20,168,6,20,168,6,20,168,
  6,20,168,213,178,63,239,200,71,79,66,23,160,6,168,160,6,168,
  160,6,168,241,203,68,234,196,59,235,198,58,242,205,65,81,69,23,
  160,6,168,160,6,168,83,33,61,227,193,67,235,201,75,244,209,83,
  209,175,62,12,168,6,12,168,6,12,168,6,12,168,6,12,168,6,
  12,168,6,12,168,6,12,168,6,12,168,6,161,134,41,241,199,61,
  242,200,66,242,200,66,76,76,27,168,17,6,168,17,6,168,17,6,
  168,17,6,168,17,6,168,17,6,168,17,6,168,17,6,168,17,6,
  237,194,55,241,198,59,164,135,43,226,34,175,226,34,175,226,34,175,
  164,135,46,243,199,66,240,196,63,104,85,25,226,34,175,226,34,175,
  226,34,175,215,176,62,239,195,70,221,177,54,147,117,35,29,23,183,
  29,23,183,29,23,183,204,165,57,227,186,70,235,201,93,240,207,102,
  228,195,90,214,182,73,200,167,54,189,156,41,197,162,46,196,161,45,
  197,173,63,194,170,62,189,167,58,189,162,55,194,162,53,191,154,47,
  202,165,61,131,106,40,14,23,134,6,20,168,6,20,168,6,20,168,
  6,20,168,6,20,168,6,20,168,6,20,168,6,20,168,75,63,22,
  130,108,39,237,198,71,240,201,74,62,42,28,160,6,168,160,6,168,
  79,66,21,238,200,63,234,197,57,238,201,60,241,204,63,160,6,168,
  160,6,168,160,6,168,74,64,22,223,189,63,229,195,69,236,201,75,
  235,197,70,214,179,62,51,55,15,12,168,6,12,168,6,12,168,6,
  12,168,6,12,168,6,12,168,6,51,55,12,188,156,47,240,198,60,
  240,198,64,241,199,65,244,202,66,110,91,30,168,17,6,168,17,6,
  168,17,6,168,17,6,168,17,6,168,17,6,168,17,6,104,84,22,
  230,184,46,234,188,51,134,108,32,226,34,175,226,34,175,226,34,175,
  245,198,68,245,198,68,237,192,63,184,151,48,226,34,175,226,34,175,
  226,34,175,106,86,30,231,187,64,217,173,52,101,81,27,29,23,183,
  29,23,183,29,23,183,218,173,54,223,182,68,232,198,91,245,213,112,
  239,208,102,233,202,94,222,190,77,205,174,58,216,183,68,206,173,58,
  198,170,61,213,187,76,225,199,86,231,204,91,214,182,71,190,156,49,
  199,164,62,198,162,65,193,157,63,178,141,50,123,98,37,123,99,35,
  140,115,49,145,121,50,149,125,48,206,173,69,208,169,50,212,171,53,
  220,180,59,226,186,64,230,190,66,154,128,43,155,129,43,155,130,41,
  184,155,49,237,199,62,237,199,62,244,207,67,240,203,63,154,130,38,
  152,129,40,155,133,45,202,171,57,225,190,64,228,193,67,232,194,69,
  241,202,71,245,205,71,245,206,69,214,179,54,161,133,40,162,135,40,
  159,132,37,163,137,41,243,205,60,242,199,61,241,197,62,242,195,63,
  240,196,65,241,197,66,239,197,63,240,198,62,241,199,61,187,155,46,
  160,130,33,159,129,32,163,131,37,219,177,54,245,197,61,227,178,47,
  222,173,44,224,175,47,179,140,42,137,104,22,137,104,22,149,116,34,
  241,191,68,245,195,72,239,191,65,238,195,64,152,125,36,153,124,37,
  158,131,45,179,147,49,221,179,58,216,174,54,177,144,52,138,109,34,
  129,101,25,148,115,27,194,152,40,204,163,55,207,172,68,227,195,92,
  229,196,91,229,197,88,221,188,75,202,166,52,213,178,62,209,172,57,
  214,180,73,232,201,85,226,196,74,227,197,75,222,190,77,177,145,42,
  218,186,85,198,168,72,208,177,86,189,155,66,193,159,70,203,168,78,
  177,141,47,182,144,45,209,167,59,211,169,57,199,156,44,232,188,79,
  220,177,65,223,180,65,232,190,70,235,194,70,230,189,63,242,202,70,
  234,194,62,232,192,58,238,198,64,236,196,64,235,195,63,239,199,67,
  234,196,59,239,201,66,228,187,59,244,203,79,232,191,67,219,178,52,
  236,197,58,237,196,54,235,195,48,235,195,48,235,194,50,241,199,61,
  240,201,64,234,196,61,242,204,71,238,190,62,234,183,58,241,187,63,
  244,192,70,243,193,70,244,201,71,228,188,56,232,193,56,255,217,79,
  242,189,51,249,196,58,251,199,64,255,205,74,234,183,55,227,175,57,
  216,163,49,200,146,38,210,156,50,195,141,35,202,148,42,238,184,76,
  245,192,80,235,182,66,244,194,71,236,194,60,237,199,62,234,194,60,
  224,185,56,232,193,66,235,195,73,231,190,74,232,192,79,203,164,59,
  174,135,34,206,166,68,197,159,62,213,175,78,197,162,60,208,174,67,
  203,166,59,189,151,42,208,167,53,229,186,71,218,173,56,211,164,46,
  220,183,79,213,177,63,222,188,64,219,188,63,225,193,82,171,142,40,
  212,182,84,213,184,92,228,198,110,201,171,85,228,193,109,225,189,103,
  184,147,58,185,146,51,228,183,80,220,173,67,188,141,35,209,161,59,
  192,145,41,194,150,41,210,164,52,221,179,61,230,186,65,243,199,74,
  243,202,74,247,204,76,238,197,71,210,169,45,222,178,55,241,197,72,
  230,188,54,237,195,59,239,195,70,240,196,75,230,186,65,230,186,61,
  246,204,66,246,205,61,246,206,57,244,204,55,240,199,55,230,188,54,
  225,185,54,237,200,70,237,199,72,238,188,67,248,191,75,255,199,83,
  253,196,80,241,189,71,229,188,62,236,195,67,239,199,67,245,198,66,
  242,184,51,255,200,67,248,193,64,245,192,64,229,175,53,217,161,52,
  211,154,49,203,145,46,206,148,51,187,129,32,198,140,43,212,154,54,
  221,164,57,239,183,72,242,192,71,239,196,65,233,195,60,230,192,59,
  228,190,63,226,188,65,222,183,64,218,178,65,196,158,49,204,166,67,
  197,158,63,203,166,75,211,174,85,170,133,42,189,151,52,210,171,66,
  211,170,64,199,157,49,202,154,43,223,173,60,216,167,49,222,171,53,
  218,180,83,201,164,58,225,189,75,232,199,86,225,193,92,210,181,89,
  232,202,114,248,217,134,241,210,130,194,161,84,133,97,21,173,136,56,
  167,126,44,160,115,30,185,136,44,205,152,58,196,143,49,199,145,57,
  195,141,51,201,148,54,212,159,63,220,168,67,222,170,68,227,176,71,
  217,166,61,203,152,47,194,143,38,199,147,46,212,160,59,221,172,67,
  238,193,74,223,179,56,232,186,74,213,167,56,218,172,61,236,190,78,
  242,198,73,241,198,67,240,198,64,237,195,61,234,191,60,228,184,63,
  225,183,65,236,197,78,221,182,65,219,167,57,239,181,73,249,191,84,
  239,180,76,222,168,60,190,147,34,204,161,46,221,179,59,218,169,50,
  246,186,66,237,177,55,244,188,65,220,166,44,219,164,47,198,141,34,
  204,147,44,216,158,59,203,145,48,205,146,52,209,151,54,219,161,61,
  203,146,41,189,132,25,224,173,58,210,163,47,188,146,28,187,146,28,
  221,179,67,208,166,56,198,157,51,204,162,60,187,147,49,202,161,69,
  219,179,91,195,155,68,225,185,100,175,135,50,169,125,36,199,154,61,
  199,155,58,204,158,60,200,149,44,216,163,57,222,168,60,215,161,52,
  176,137,42,184,146,45,191,154,47,201,167,60,228,198,102,230,203,116,
  233,205,122,232,203,125,219,190,114,192,158,86,156,119,48,182,142,70,
  167,123,48,171,124,46,214,159,76,216,159,72,191,134,47,187,129,47,
  189,133,48,198,142,55,210,155,65,218,163,72,221,166,73,222,167,74,
  217,162,69,209,154,61,201,146,55,212,157,67,227,171,84,236,183,89,
  244,196,86,218,173,56,216,169,63,209,161,59,226,178,76,239,192,88,
  246,201,84,241,197,74,235,191,66,230,186,61,229,185,64,240,194,83,
  242,198,89,199,159,48,187,147,36,186,133,29,200,141,41,207,148,48,
  207,147,49,202,147,47,200,156,51,227,183,76,226,183,71,191,141,30,
  227,165,54,244,183,68,241,184,68,218,163,46,218,163,47,201,144,39,
  209,151,51,222,164,67,210,151,57,201,142,48,207,149,52,218,160,61,
  203,146,43,193,136,29,225,173,63,209,161,53,180,136,29,174,130,23,
  199,156,52,181,137,38,171,129,31,179,136,42,159,116,24,194,152,66,
  230,188,104,220,179,97,224,183,103,190,148,66,181,135,50,201,154,66,
  189,139,50,202,151,60,205,151,53,216,158,59,222,165,62,230,173,68,
  165,126,35,194,155,60,193,155,54,195,161,63,227,195,108,222,193,113,
  212,183,105,201,171,98,199,169,97,190,155,87,140,101,34,165,125,56,
  159,112,42,166,116,43,192,135,58,200,139,59,189,128,48,201,140,60,
  195,134,53,195,137,53,204,143,60,210,153,66,217,157,71,199,139,53,
  213,156,69,222,161,78,207,149,65,191,133,51,213,152,72,227,171,84,
  220,171,68,203,156,48,193,145,47,199,150,57,216,167,74,224,175,80,
  234,187,79,228,183,68,219,174,57,212,167,50,212,166,54,225,177,75,
  228,183,82,208,167,62,200,159,54,204,150,52,210,149,56,212,151,60,
  218,157,66,222,166,73,212,166,68,222,177,76,215,170,67,193,141,39,
  208,145,42,223,160,54,231,174,61,218,162,49,214,158,47,206,149,46,
  212,154,55,219,160,66,214,155,61,202,143,51,211,152,58,204,146,47,
  195,138,35,209,152,47,204,150,44,207,157,58,183,137,41,177,131,35,
  197,150,58,183,138,47,179,133,45,188,144,57,174,129,44,191,149,67,
  221,178,99,209,166,88,198,157,78,175,132,54,197,150,70,210,159,78,
  183,131,48,202,148,62,205,148,58,208,147,54,213,153,57,215,155,57,
  179,139,52,205,165,77,211,172,79,190,155,65,207,174,93,188,159,83,
  184,154,82,175,145,75,186,155,88,160,125,61,133,93,31,162,118,53,
  161,112,46,172,119,51,176,116,44,197,135,62,210,146,72,198,135,56,
  194,132,49,192,131,48,195,133,50,196,135,52,197,135,52,187,125,42,
  208,147,64,222,159,79,207,146,65,179,117,40,190,127,50,197,139,55,
  190,140,43,199,151,49,184,135,43,189,139,52,194,144,57,195,145,56,
  221,173,73,219,172,66,215,168,60,212,165,57,210,163,59,212,163,70,
  212,165,73,206,164,66,201,159,61,206,151,60,203,141,54,194,132,47,
  195,133,50,199,141,57,210,163,73,198,151,59,198,152,58,212,159,65,
  201,136,42,203,139,41,216,158,51,216,160,51,206,149,42,209,151,52,
  210,152,55,207,148,54,214,155,63,207,148,56,214,155,61,210,152,55,
  205,147,47,217,160,57,186,131,30,197,146,55,185,135,50,185,135,50,
  200,152,68,194,148,63,194,147,65,203,156,76,188,142,64,187,141,66,
  204,160,85,170,126,53,170,126,53,123,76,4,200,151,75,212,160,84,
  180,127,49,204,149,69,203,142,59,199,137,50,209,145,55,199,135,45,
  181,140,58,187,147,62,199,159,72,158,120,37,184,150,76,161,128,59,
  166,136,66,166,132,68,183,149,85,122,84,22,167,126,64,167,123,60,
  147,97,34,166,112,48,188,127,60,197,134,65,199,135,63,194,131,51,
  208,146,61,216,154,69,220,158,73,218,156,71,214,152,67,202,140,57,
  215,152,72,222,159,79,214,151,71,198,135,56,192,129,52,183,122,41,
  182,129,35,213,165,67,194,144,59,191,140,59,182,131,50,178,127,44,
  189,140,47,191,143,45,195,147,45,196,148,46,195,146,51,187,137,52,
  181,133,48,219,176,84,214,171,77,216,160,73,206,144,61,188,125,45,
  180,117,38,180,121,43,204,156,72,198,150,65,199,152,64,216,162,74,
  199,133,47,216,151,59,204,145,45,213,156,53,198,140,40,209,151,54,
  206,147,53,197,138,46,211,152,60,201,142,52,209,150,58,230,171,77,
  229,171,72,218,160,60,194,138,41,190,138,54,185,134,55,186,135,56,
  192,143,66,186,137,60,185,136,60,188,140,64,190,142,68,213,166,94,
  243,196,126,191,147,76,201,157,86,101,54,0,192,142,71,208,156,83,
  180,123,52,207,149,75,202,141,61,199,134,52,210,145,61,211,145,59,
  188,147,68,186,144,68,139,97,23,157,117,45,153,114,47,184,146,83,
  157,119,56,186,148,85,159,121,58,162,122,60,166,125,63,159,113,51,
  149,99,36,147,93,29,162,102,39,195,131,67,214,150,78,203,141,56,
  202,138,48,209,145,55,200,136,48,200,136,48,214,150,63,213,148,64,
  214,149,65,208,143,59,195,131,44,193,129,42,201,137,50,203,143,55,
  206,153,61,202,153,61,200,149,68,182,130,55,191,139,66,182,130,55,
  212,162,77,204,154,65,190,141,49,199,149,60,219,169,84,202,150,75,
  165,116,40,187,142,57,182,138,49,226,169,88,215,152,75,217,153,79,
  185,121,49,175,115,42,178,129,53,142,93,16,181,132,53,165,110,30,
  214,147,69,212,145,64,207,146,57,202,143,49,205,146,54,195,136,46,
  187,128,38,206,146,58,234,175,85,204,145,55,195,136,46,187,128,36,
  197,138,44,203,145,48,211,154,64,170,114,37,172,118,48,189,135,65,
  181,128,58,164,111,41,145,92,24,141,91,22,185,134,68,167,118,51,
  189,142,74,188,140,74,158,110,44,148,99,33,188,137,72,147,93,29,
  155,100,35,169,112,45,206,143,72,200,136,62,204,138,62,207,141,63,
  159,118,39,162,120,46,147,104,35,193,150,82,183,142,76,147,108,43,
  142,103,38,171,132,67,149,110,45,219,180,113,184,143,77,167,122,55,
  171,123,57,157,106,40,178,121,54,175,116,50,188,128,55,199,137,52,
  201,140,49,208,147,56,206,145,56,197,136,47,210,148,61,209,147,60,
  204,142,55,188,126,39,169,108,19,175,114,23,193,132,39,203,144,52,
  211,158,66,209,160,68,203,152,73,182,130,57,183,131,58,182,130,55,
  218,167,84,200,150,63,183,133,44,210,160,73,205,154,71,204,151,81,
  163,113,40,191,146,61,194,150,61,233,176,95,207,144,67,229,165,91,
  206,142,70,209,149,77,182,133,57,164,115,39,219,170,93,191,135,58,
  186,118,43,173,106,27,205,143,58,187,127,39,177,117,29,191,131,43,
  197,137,49,206,146,60,217,157,69,196,137,47,192,133,43,197,138,46,
  211,152,60,211,152,58,219,162,73,176,119,42,174,120,48,177,123,51,
  201,147,77,192,139,69,162,109,41,127,77,8,157,106,40,159,110,44,
  191,142,76,201,151,88,175,125,62,143,93,30,200,149,86,161,107,45,
  172,117,53,166,108,44,177,117,47,173,109,37,190,126,52,208,145,68,
  145,103,27,142,100,28,167,124,56,184,140,77,161,115,53,145,100,35,
  168,124,59,193,152,86,166,125,59,216,176,107,212,169,100,180,135,67,
  181,134,64,141,92,23,176,122,52,173,116,49,198,140,66,193,132,49,
  196,135,46,201,141,53,211,149,62,198,138,52,218,156,73,209,147,64,
  209,149,63,202,140,53,188,129,39,193,134,40,208,148,52,213,157,60,
  199,149,54,205,156,64,209,158,79,190,138,63,180,128,55,182,130,55,
  208,157,74,201,151,64,196,146,57,229,179,92,184,133,52,203,150,82,
  180,130,57,194,150,63,191,148,56,207,151,68,187,124,47,204,140,66,
  208,144,72,214,154,82,190,141,65,183,134,58,210,161,84,199,143,66,
  188,120,45,178,111,33,191,128,48,178,117,34,172,111,28,194,133,50,
  200,140,54,197,137,51,192,132,46,195,135,47,193,134,44,201,142,52,
  212,153,63,205,146,54,223,166,77,195,138,59,191,135,61,167,113,39,
  188,134,62,196,142,70,185,132,62,151,98,30,135,85,16,140,89,23,
  185,136,70,186,136,73,142,92,29,148,98,35,168,118,57,156,104,44,
  167,113,51,162,107,42,189,130,60,180,117,46,208,146,73,193,131,56,
  191,149,73,196,154,82,252,208,145,211,165,105,200,150,87,161,112,46,
  160,112,46,180,135,67,180,137,68,245,203,131,137,95,21,150,108,34,
  206,162,89,198,151,79,206,156,83,168,115,45,167,111,36,200,141,61,
  194,133,50,191,133,51,211,150,70,193,134,54,224,162,85,201,140,60,
  207,149,67,212,152,66,205,148,59,210,154,59,220,162,65,219,165,67,
  197,147,50,203,154,61,207,156,75,195,143,67,181,129,54,192,140,65,
  207,156,73,205,155,68,203,153,64,231,181,94,173,122,41,191,138,70,
  181,131,58,184,140,53,183,140,46,197,141,56,192,129,50,170,107,30,
  182,118,44,164,104,31,167,118,41,186,137,60,175,126,49,204,148,71,
  196,128,53,186,118,43,166,103,24,185,124,44,200,139,58,187,126,45,
  185,124,41,196,136,50,208,148,62,202,142,54,199,139,51,201,142,52,
  205,146,56,197,138,48,226,169,80,201,144,63,206,151,71,179,123,46,
  185,132,56,189,135,61,201,149,76,177,125,52,172,119,49,144,93,27,
  169,118,53,168,118,55,145,95,32,174,124,61,136,86,25,153,103,42,
  153,103,40,155,104,39,195,138,69,171,112,42,196,136,63,162,103,27,
  194,153,74,193,150,81,239,195,134,166,120,60,170,119,56,199,146,80,
  197,147,78,211,164,94,201,157,84,190,148,72,163,121,45,175,134,55,
  197,154,76,171,128,50,191,143,67,197,148,72,208,156,80,218,161,84,
  197,138,60,187,128,52,209,149,76,187,127,54,223,163,91,180,120,47,
  190,131,53,197,139,57,196,139,52,204,148,55,211,155,58,211,157,59,
  209,159,60,207,158,63,198,147,64,192,140,64,178,126,50,203,151,75,
  211,161,76,203,153,64,197,147,58,218,168,81,190,139,58,200,147,77,
  191,142,66,190,146,57,188,145,50,199,143,56,204,141,61,169,106,27,
  190,127,50,161,102,26,159,110,33,193,144,67,158,109,30,207,151,74,
  191,123,48,181,113,38,171,108,31,186,124,47,194,132,55,182,121,41,
  191,130,49,203,142,59,209,149,63,201,141,53,193,133,45,188,128,40,
  193,134,44,191,132,42,215,158,69,186,130,45,208,153,70,191,136,54,
  199,146,68,183,130,54,199,146,70,177,125,50,186,134,61,166,116,47,
  168,117,51,180,131,65,188,138,75,163,113,50,144,95,36,166,118,56,
  165,117,55,168,119,53,197,143,73,170,113,42,182,124,50,161,101,28,
  172,131,52,191,148,79,222,178,117,187,138,80,192,138,74,193,138,71,
  166,113,43,180,132,58,187,141,64,202,161,81,165,124,44,191,153,72,
  201,160,80,183,140,61,180,134,56,192,146,68,184,135,58,232,176,102,
  202,143,73,186,127,59,212,153,85,183,124,56,222,163,97,178,119,49,
  190,132,59,201,144,65,203,147,64,209,154,63,213,159,63,211,159,60,
  214,164,65,208,159,64,192,142,57,191,140,61,172,120,44,198,146,70,
  207,157,72,203,153,64,197,147,58,206,156,67,209,158,75,209,156,86,
  208,159,83,205,162,70,205,163,65,205,150,60,201,139,56,188,125,45,
  211,148,71,190,131,53,184,135,56,190,141,62,139,90,11,178,122,45,
  196,128,53,210,142,67,189,125,51,189,127,52,181,119,44,186,125,45,
  205,144,63,205,144,61,192,132,46,194,134,48,181,121,33,175,115,27,
  189,129,41,198,138,50,201,144,55,172,116,29,193,139,53,175,120,37,
  197,142,60,164,111,31,182,129,51,161,108,32,150,98,25,163,113,44,
  170,119,53,182,131,66,187,136,71,140,92,28,145,99,39,144,98,36,
  172,124,62,181,132,66,209,155,85,206,149,78,208,152,77,175,117,43,
  184,131,61,187,133,69,157,103,43,172,120,63,180,130,77,165,119,60,
  185,139,79,136,91,26,157,112,44,176,129,57,168,122,47,163,117,40,
  188,140,66,193,143,70,177,124,56,209,156,90,157,106,40,255,206,139,
  208,159,90,186,136,65,207,157,84,174,124,51,204,152,77,150,97,21,
  170,114,37,199,144,64,183,128,46,205,149,66,222,164,82,204,150,64,
  197,150,58,192,147,56,139,92,10,198,151,71,179,132,52,188,140,58,
  209,162,70,199,153,57,198,152,56,212,166,72,197,150,62,199,147,74,
  191,138,62,203,146,59,213,154,64,214,155,65,211,151,63,206,149,60,
  192,135,46,174,118,31,196,142,54,190,136,48,185,129,42,202,142,56,
  195,129,43,197,131,47,195,129,45,199,133,49,203,137,51,199,133,46,
  198,133,43,201,136,44,205,140,48,201,136,44,206,141,49,180,115,23,
  181,116,26,204,138,51,202,140,55,198,140,58,192,137,57,199,145,71,
  148,95,27,162,111,45,168,117,51,150,100,29,152,103,27,150,98,22,
  167,114,38,191,134,63,190,131,65,194,134,74,182,128,64,198,147,81,
  201,151,82,192,142,71,187,135,60,189,137,61,204,151,73,150,97,19,
  163,106,37,173,115,51,158,100,37,160,105,48,155,108,52,167,122,65,
  186,141,82,155,111,48,171,126,61,194,147,77,170,122,50,185,137,65,
  190,140,69,176,123,55,183,130,64,193,138,74,160,109,44,237,190,122,
  186,139,67,181,135,60,212,164,88,171,123,47,202,153,76,175,124,45,
  178,125,45,199,146,66,198,143,61,207,152,70,214,157,78,202,147,65,
  226,179,91,203,159,70,145,100,19,202,155,77,197,150,70,187,140,58,
  203,157,63,206,160,62,210,164,66,218,172,78,189,142,54,206,154,81,
  217,161,87,209,147,64,215,151,63,194,135,45,186,129,40,189,134,43,
  188,133,43,182,127,36,197,142,51,193,136,47,191,134,44,202,142,54,
  197,133,46,200,134,48,208,140,57,207,139,56,206,138,53,200,133,44,
  199,132,41,201,134,43,203,137,43,193,126,35,217,150,59,202,135,46,
  194,127,40,203,135,50,195,130,48,185,126,46,179,126,48,195,141,69,
  187,136,73,204,153,90,191,142,76,159,110,41,166,117,41,166,113,33,
  180,125,45,201,143,70,203,142,75,217,153,92,193,135,71,191,138,70,
  201,148,78,191,139,66,178,126,50,183,131,55,178,127,48,176,125,46,
  180,124,50,183,126,55,182,125,56,168,115,49,160,112,48,181,135,73,
  181,136,71,166,121,56,172,124,58,203,154,87,170,121,52,214,165,96,
  211,161,92,169,119,50,185,135,66,192,139,71,194,144,75,221,174,102,
  189,141,67,181,133,59,204,156,80,163,115,39,200,151,74,186,137,58,
  180,129,50,194,143,64,203,150,70,201,148,68,198,142,65,189,136,56,
  222,176,90,202,158,71,159,112,32,189,142,64,198,151,73,179,132,50,
  194,150,55,197,153,56,194,148,50,206,160,66,177,130,42,198,148,75,
  209,155,81,189,128,47,197,133,46,171,111,23,166,109,22,176,121,31,
  183,127,40,178,124,34,188,134,44,185,129,42,191,134,45,194,134,48,
  198,133,49,200,135,51,217,150,72,212,145,67,206,139,60,203,137,53,
  205,139,53,208,142,56,209,143,56,205,139,53,216,150,64,204,138,54,
  202,135,54,214,147,68,210,144,66,200,141,61,178,125,47,172,118,44,
  178,127,62,208,157,94,200,151,84,174,126,54,200,151,74,189,137,54,
  183,128,46,186,128,54,179,119,49,185,121,60,198,140,76,174,119,52,
  193,139,69,182,128,56,175,122,46,196,143,67,178,125,47,191,138,60,
  200,144,69,180,124,49,183,127,52,163,109,35,193,145,71,204,155,86,
  175,126,57,166,117,50,160,111,44,196,147,80,170,121,55,216,167,100,
  228,177,111,174,124,55,178,130,58,208,158,85,224,176,102,211,163,87,
  214,166,90,178,130,54,184,136,60,163,115,39,195,146,69,181,132,55,
  184,135,58,195,146,69,200,151,74,196,147,70,187,135,59,173,124,45,
  207,161,75,209,165,78,186,139,61,170,122,46,181,134,56,164,117,35,
  198,153,60,187,143,46,166,120,24,193,147,53,182,134,49,187,137,66,
  175,121,49,191,130,50,201,139,56,193,132,49,197,141,56,211,157,71,
  211,157,71,198,144,58,184,130,44,182,126,41,195,139,54,186,125,42,
  197,135,52,199,134,54,192,126,52,184,117,46,177,109,36,182,115,37,
  188,123,43,193,126,47,193,128,46,193,128,48,185,118,39,177,111,33,
  189,121,46,202,136,62,188,124,50,202,145,66,176,123,43,153,100,24,
  151,100,34,187,136,71,193,144,75,189,141,67,188,139,60,194,142,58,
  191,136,53,199,142,65,203,143,71,216,152,90,209,152,85,171,116,49,
  193,139,69,180,126,54,170,117,41,208,155,79,188,135,57,184,131,53,
  215,160,80,178,123,41,186,131,48,175,123,39,211,160,77,220,171,92,
  181,132,56,177,127,56,170,120,51,197,146,81,183,133,70,189,140,74,
  206,157,90,165,116,47,170,124,47,218,171,93,209,162,82,198,151,71,
  218,169,92,169,120,43,179,132,54,189,142,64,185,137,61,175,127,51,
  200,154,77,208,162,85,198,152,75,196,150,73,182,136,59,162,116,38,
  213,167,82,226,180,95,211,164,86,171,123,47,185,137,61,161,114,34,
  208,163,70,200,156,59,173,129,32,209,165,70,198,152,66,185,137,65,
  161,108,38,166,107,31,179,116,37,175,116,36,188,131,50,205,150,68,
  197,142,60,172,120,37,191,139,56,187,132,50,205,148,67,175,116,36,
  190,127,48,187,123,49,179,114,46,173,108,42,168,101,33,175,108,37,
  181,117,43,188,122,46,187,124,47,189,126,49,185,119,45,183,119,47,
  188,121,51,187,122,54,171,108,37,174,117,38,171,119,36,165,112,34,
  163,113,44,184,133,67,187,139,67,198,150,74,199,151,69,205,153,67,
  190,136,50,190,133,54,188,128,55,183,119,55,214,157,90,180,125,58,
  201,147,77,194,140,68,166,113,37,196,143,67,182,129,51,186,133,55
} ;

/** SUMABUCKS logo **/

static unsigned char sbuck_rgb[] = {
  247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,
  247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,
  247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,
  247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,
  247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,
  247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,
  247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,
  247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,
  247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,
  247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,
  247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,
  247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,
  247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,
  247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,
  247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,
  247,232,17,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,11,9,76,21,31,69,9,34,46,15,56,42,4,54,32,
  4,55,32,12,62,40,32,76,56,51,88,71,67,100,85,77,106,94,
  88,113,103,97,119,109,97,119,109,96,119,109,97,119,109,89,114,103,
  78,106,94,66,99,84,51,87,70,31,75,55,9,60,38,3,55,31,
  4,53,33,15,54,42,13,37,54,28,38,78,15,12,82,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,247,232,17,
  247,232,17,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,15,12,82,17,31,66,
  6,40,41,4,52,32,4,55,32,26,70,50,62,96,81,100,121,112,
  138,149,145,154,158,157,158,161,161,158,162,161,154,158,157,141,149,146,
  131,143,139,122,137,131,121,136,130,121,136,130,121,137,131,131,143,139,
  141,149,146,153,158,157,158,162,161,158,161,160,153,158,156,135,145,141,
  95,117,108,58,93,79,23,68,48,4,55,32,5,52,33,21,53,54,
  19,29,69,9,5,78,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,247,232,17,
  247,232,17,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,21,23,79,11,35,48,4,52,33,6,56,35,
  35,77,59,85,111,101,132,144,140,155,160,158,156,159,158,133,144,140,
  97,119,110,66,98,84,41,82,65,21,68,48,11,61,39,6,58,35,
  3,56,32,2,56,31,2,56,31,2,56,31,2,56,32,4,56,32,
  7,58,35,12,61,39,23,70,49,43,83,65,69,100,87,101,123,114,
  134,145,141,156,160,159,154,159,157,129,142,137,82,109,98,32,75,57,
  5,56,33,5,51,33,19,40,61,14,14,75,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,247,232,17,
  247,232,17,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,13,7,85,
  10,14,68,10,40,41,6,56,34,15,63,42,73,103,91,131,143,138,
  156,160,159,141,150,147,99,121,112,55,90,74,18,66,45,5,57,33,
  1,56,31,0,57,31,1,57,31,2,56,30,1,57,31,1,57,31,
  1,57,31,1,56,30,0,57,31,0,57,30,1,56,31,1,57,31,
  1,57,31,1,57,31,0,57,31,1,56,31,1,57,31,1,56,32,
  5,57,34,22,67,47,58,93,78,102,123,115,141,151,148,156,160,158,
  126,140,135,67,100,87,13,61,41,4,52,33,25,53,58,20,23,79,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,247,232,17,
  247,232,17,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,15,16,77,28,57,60,
  4,53,31,24,68,50,90,115,106,148,155,153,150,156,154,101,122,114,
  44,84,68,9,59,37,1,57,31,1,56,31,2,56,31,1,57,31,
  0,57,31,1,57,31,0,57,31,1,57,30,13,62,41,35,76,59,
  42,82,65,42,82,65,41,82,65,37,78,60,21,67,47,8,60,37,
  2,56,32,1,57,31,0,57,31,1,56,31,1,56,31,2,56,31,
  1,57,30,1,57,30,1,57,31,1,57,31,9,60,38,47,85,69,
  102,122,115,150,156,154,145,154,151,86,113,103,21,66,47,6,53,33,
  16,41,52,15,14,78,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,247,232,17,
  247,232,17,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,5,80,16,35,59,3,52,31,19,66,46,
  90,117,107,152,157,155,144,152,149,79,107,96,18,66,45,1,57,31,
  1,56,31,1,56,31,1,57,31,1,57,30,0,57,30,1,56,31,
  0,57,31,1,57,32,0,57,32,1,56,31,80,108,97,159,162,162,
  160,162,162,160,162,161,159,161,161,159,162,161,157,160,159,143,151,148,
  113,131,124,24,69,49,1,56,31,0,57,31,1,57,31,12,62,39,
  7,59,36,1,56,32,1,57,31,1,57,31,1,56,31,0,57,31,
  1,56,31,19,66,45,79,107,95,142,152,149,149,156,154,86,113,103,
  17,64,44,7,55,35,18,33,62,13,8,83,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,247,232,17,
  247,232,17,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,5,84,24,29,78,6,43,37,9,58,36,72,102,89,147,154,152,
  146,154,152,76,105,93,12,62,41,1,57,31,1,56,31,0,57,31,
  1,57,30,2,56,31,19,65,45,64,96,83,25,71,51,1,57,31,
  0,57,31,1,56,31,1,57,31,1,57,31,76,103,92,161,162,161,
  162,161,161,160,161,161,150,155,154,157,160,159,161,162,161,161,161,161,
  161,161,161,109,128,121,2,56,33,1,56,31,2,56,31,111,129,122,
  138,148,144,97,119,110,44,85,68,2,57,31,0,57,31,1,56,31,
  1,56,31,1,57,31,1,56,31,12,61,39,75,104,92,145,153,150,
  145,152,149,67,99,86,7,57,35,7,43,36,26,30,83,10,5,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,247,232,17,
  247,232,17,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,17,13,87,
  26,44,67,5,53,33,32,75,56,126,139,134,155,160,159,95,119,109,
  17,65,44,1,57,31,1,57,31,1,57,31,1,57,30,14,61,39,
  55,91,75,111,129,121,150,157,155,161,161,161,125,141,135,10,59,37,
  1,57,30,1,57,31,1,57,31,1,56,32,67,99,85,161,162,162,
  162,161,162,155,160,159,26,66,49,24,70,49,122,136,130,162,161,162,
  161,162,162,142,151,147,2,56,32,1,57,30,16,64,43,154,158,157,
  161,162,162,161,162,161,104,125,116,1,56,31,0,58,30,2,56,32,
  5,57,35,1,56,31,1,57,30,1,57,30,1,57,31,16,64,42,
  93,117,107,154,159,158,120,136,130,29,72,53,5,52,33,17,32,61,
  11,5,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,247,232,17,
  247,232,17,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,15,11,84,15,44,48,
  4,57,33,73,102,91,151,158,156,131,143,137,40,81,63,1,56,32,
  2,56,32,1,57,31,1,57,31,1,57,31,1,55,31,116,134,127,
  160,161,161,161,161,161,162,161,162,162,161,162,161,161,161,94,117,107,
  2,56,32,1,57,30,1,57,30,0,57,32,62,95,81,162,162,161,
  161,162,162,159,161,161,49,83,70,45,83,68,139,148,145,162,162,162,
  161,162,162,96,120,111,2,56,32,1,56,31,65,97,84,161,162,162,
  162,162,162,159,162,161,48,85,69,1,57,31,1,57,30,29,72,53,
  130,145,138,65,99,85,10,60,38,1,57,31,1,56,31,1,57,30,
  1,57,31,37,77,60,127,141,136,151,157,155,68,98,86,4,56,33,
  9,36,44,15,11,83,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,247,232,17,
  247,232,17,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,13,13,76,5,43,37,13,62,41,
  108,127,119,157,161,159,92,116,107,10,59,37,0,57,30,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,2,56,31,118,133,127,
  161,161,162,161,161,161,143,150,148,161,161,161,160,161,162,158,161,160,
  55,90,75,1,57,31,1,56,30,0,57,31,54,91,75,162,162,161,
  162,161,162,161,161,162,159,162,161,160,162,161,162,161,162,160,162,162,
  147,153,151,17,63,44,1,57,31,3,55,31,119,136,129,162,162,162,
  162,162,161,142,151,148,9,59,37,1,57,31,1,56,31,80,108,97,
  161,161,161,161,161,161,140,151,147,16,66,44,1,57,31,1,56,32,
  1,57,31,1,57,30,7,58,35,86,111,100,156,160,159,104,125,117,
  11,61,38,20,59,50,9,8,73,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,247,232,17,
  247,232,17,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,26,29,84,5,48,35,23,69,49,131,142,139,
  148,155,153,54,91,75,2,56,31,1,56,31,1,56,31,12,62,38,
  1,57,31,1,57,31,1,57,31,1,57,31,1,56,30,112,130,122,
  159,161,161,160,161,161,76,101,92,127,140,135,162,161,161,161,161,161,
  149,155,152,25,68,50,1,57,31,0,57,31,45,85,69,161,162,162,
  161,162,161,161,161,161,124,137,131,116,132,125,153,157,155,161,161,161,
  161,161,162,111,131,123,2,56,32,20,68,47,157,161,160,161,162,162,
  162,162,161,95,118,109,1,56,31,1,57,31,7,59,36,136,147,143,
  161,161,161,161,161,162,128,141,136,3,55,32,0,57,30,1,57,31,
  1,56,31,1,57,31,0,57,31,2,56,31,49,87,71,146,153,150,
  128,142,136,22,68,48,4,47,35,17,19,80,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,247,232,17,
  247,232,17,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,33,37,88,11,54,39,34,76,58,142,151,148,136,147,142,
  31,74,55,1,56,32,1,57,30,2,57,32,67,99,85,143,153,149,
  31,74,55,0,57,31,1,57,31,1,57,31,1,56,31,107,127,118,
  162,161,162,161,161,161,71,102,89,28,71,51,148,154,152,162,161,162,
  161,162,162,124,139,133,7,59,35,2,56,31,38,81,64,161,161,162,
  161,161,162,160,161,160,46,86,69,1,56,32,54,88,73,161,161,161,
  160,162,162,159,161,160,32,76,57,70,101,88,161,161,161,161,162,161,
  160,162,160,46,84,67,1,56,31,1,56,31,51,87,72,160,162,161,
  162,161,162,160,161,162,66,98,84,0,57,32,1,57,30,1,56,30,
  1,56,31,0,57,31,1,56,31,0,57,31,1,56,31,26,72,51,
  132,144,139,141,150,146,33,74,57,9,53,38,20,22,81,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,247,232,17,
  247,232,17,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  31,35,87,11,56,40,41,81,63,148,154,151,126,140,134,19,66,46,
  1,56,31,1,57,31,5,58,34,92,116,105,159,161,160,160,162,161,
  137,145,142,15,63,42,1,57,30,0,57,31,1,56,31,102,123,113,
  161,161,161,160,161,161,94,115,107,73,102,89,141,148,145,161,162,162,
  161,162,161,161,161,161,88,114,103,2,56,32,35,77,58,161,161,161,
  161,162,162,160,161,160,77,104,92,33,76,58,97,119,110,162,161,162,
  162,162,162,160,161,161,47,83,69,108,127,119,160,161,161,161,161,162,
  146,153,150,9,60,38,0,57,31,3,57,34,120,136,129,161,162,162,
  161,162,162,145,153,150,11,61,38,1,56,31,2,56,33,25,72,52,
  42,83,66,35,78,60,12,61,41,1,56,33,1,56,31,1,57,31,
  15,63,43,120,136,130,145,153,150,36,79,62,5,48,37,18,19,81,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,247,232,17,
  247,232,17,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,23,25,83,
  12,55,40,34,77,58,147,153,152,119,135,129,14,63,41,1,56,31,
  1,57,31,1,57,31,8,60,37,137,148,144,161,161,162,161,162,162,
  161,161,162,115,133,125,6,58,35,1,57,31,2,56,31,97,119,109,
  161,162,161,162,162,162,160,161,161,160,161,161,161,161,162,161,161,161,
  161,162,161,161,161,161,158,160,160,51,87,72,27,73,52,157,161,160,
  161,161,161,160,161,161,161,161,161,160,162,161,161,161,162,161,162,161,
  161,161,161,153,158,156,20,67,46,123,137,132,161,161,161,161,162,161,
  115,132,125,3,55,31,2,56,30,46,84,68,159,161,160,161,161,162,
  161,161,161,82,110,98,1,57,31,30,74,55,120,136,130,156,160,159,
  161,161,161,160,161,161,148,156,153,95,117,108,16,64,44,1,57,31,
  1,56,30,11,60,39,114,131,124,148,153,151,34,77,59,10,53,39,
  16,17,79,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,247,232,17,
  247,232,17,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,9,8,73,6,47,36,
  30,73,55,146,153,151,123,137,132,13,63,41,1,57,31,1,56,32,
  33,75,57,39,81,63,1,56,32,67,97,83,161,161,161,162,162,162,
  161,162,161,160,161,160,90,114,104,2,56,32,2,56,31,90,115,104,
  162,161,161,162,162,162,161,162,162,156,159,157,128,140,134,79,106,94,
  127,140,135,160,161,161,161,161,162,145,153,149,45,81,66,155,160,159,
  159,162,162,158,162,161,158,162,162,159,162,162,159,161,162,155,161,159,
  126,139,133,49,86,69,1,57,31,72,103,90,160,162,161,160,161,160,
  145,152,149,46,85,69,19,66,46,125,139,134,161,161,161,161,161,161,
  146,155,151,16,64,43,32,73,55,147,154,152,161,161,161,162,162,162,
  161,162,162,161,162,162,162,162,162,161,162,161,135,147,142,27,71,52,
  1,56,31,1,57,31,9,61,39,116,134,127,145,153,150,30,72,55,
  10,52,39,9,8,73,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,247,232,17,
  247,232,17,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,6,81,6,43,38,22,68,48,
  139,149,146,128,141,136,14,63,41,1,56,31,2,56,32,54,90,74,
  149,155,152,152,157,155,65,97,83,10,59,38,135,145,139,160,162,161,
  150,153,152,161,162,161,159,160,160,62,96,81,1,57,31,85,111,100,
  161,161,162,162,161,162,127,139,133,30,72,52,4,57,32,0,57,31,
  22,68,48,135,148,143,140,148,144,111,129,121,47,85,69,39,81,62,
  41,81,63,31,74,56,30,74,56,30,73,56,31,73,56,22,68,48,
  4,57,33,0,57,31,2,56,31,6,58,36,116,133,126,161,161,161,
  161,161,162,159,161,160,153,158,156,161,161,161,161,161,162,160,161,161,
  77,105,94,2,57,33,118,134,127,161,161,161,162,161,161,160,162,161,
  142,151,147,137,145,142,147,153,151,161,162,162,161,161,161,121,137,131,
  6,58,36,1,57,30,1,56,31,12,61,40,123,138,132,138,148,144,
  19,65,45,18,53,48,11,7,81,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,247,232,17,
  247,232,17,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,4,84,11,6,84,7,32,42,10,61,40,126,140,135,
  139,149,146,20,67,47,1,56,31,1,56,31,58,94,78,156,159,157,
  160,161,162,161,161,161,157,161,159,89,115,104,64,95,82,160,161,161,
  139,146,143,127,138,133,161,161,161,153,158,155,40,78,60,80,108,96,
  161,161,161,161,161,162,113,131,123,1,56,31,0,57,31,0,57,31,
  1,57,31,12,61,39,6,58,35,2,55,32,1,56,31,1,57,31,
  1,57,31,1,57,31,1,57,30,1,57,31,1,56,31,1,57,31,
  1,57,32,1,57,31,1,57,30,0,58,31,10,61,38,94,119,109,
  153,158,156,161,162,162,161,161,162,161,161,161,161,161,161,133,146,141,
  11,60,39,26,71,52,157,161,160,161,162,161,161,161,161,103,124,114,
  10,61,38,2,56,32,10,61,39,91,116,106,160,161,161,159,161,161,
  57,92,77,1,57,31,0,57,31,1,57,31,18,65,44,135,147,142,
  123,138,132,9,60,38,15,40,53,11,5,84,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,247,232,17,
  247,232,17,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,10,5,84,18,32,63,3,56,32,101,122,114,151,156,155,
  33,75,57,1,56,30,0,57,31,1,57,31,23,69,49,141,151,147,
  162,161,162,161,161,162,162,161,161,161,161,161,121,134,130,143,149,148,
  158,161,160,78,101,91,142,150,146,160,162,161,141,150,145,95,116,108,
  160,162,161,160,162,161,110,129,122,2,55,31,1,56,31,1,56,31,
  1,57,30,1,57,30,1,57,31,1,56,31,2,56,32,8,60,36,
  13,63,40,22,70,49,25,71,52,24,72,52,19,67,46,12,62,39,
  6,58,34,2,56,32,1,56,31,2,56,31,1,57,31,1,56,32,
  24,69,49,66,99,85,103,123,115,106,124,116,74,105,92,15,65,43,
  1,56,31,54,91,75,161,161,162,161,161,161,141,150,147,11,59,37,
  1,57,31,1,57,30,1,56,31,6,57,35,124,138,132,158,161,161,
  88,114,103,1,56,31,2,56,31,1,56,31,0,57,31,30,73,54,
  149,156,153,96,120,110,4,55,32,21,34,68,10,4,84,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,247,232,17,
  247,232,17,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  10,4,84,32,36,87,5,53,33,65,97,85,157,161,159,59,93,78,
  1,56,31,0,57,30,38,80,62,22,67,47,2,56,31,42,81,64,
  153,157,156,161,161,161,157,159,159,151,154,153,160,161,161,161,161,161,
  160,161,162,135,146,142,43,79,63,153,158,155,161,161,160,156,158,158,
  143,151,147,74,103,89,11,61,39,0,57,31,1,56,31,1,57,32,
  6,57,35,28,72,53,67,98,86,97,120,110,127,140,135,144,152,149,
  156,160,155,160,162,156,160,162,156,160,162,155,160,162,155,153,158,153,
  141,149,146,121,136,129,89,114,104,57,93,78,19,66,46,3,56,33,
  1,57,31,1,57,31,1,56,31,2,56,32,1,57,31,1,57,31,
  1,56,31,54,91,75,161,161,162,160,162,162,107,125,118,1,57,31,
  1,57,31,1,57,31,0,57,31,1,56,31,52,91,74,57,91,77,
  4,57,34,1,57,31,9,60,38,2,57,33,0,57,31,1,56,32,
  55,91,76,155,160,159,60,93,79,3,50,31,17,18,78,10,4,84,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,247,232,17,
  247,232,17,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  11,6,82,5,40,36,26,72,52,151,156,155,94,118,108,1,56,31,
  1,57,31,20,65,45,144,152,149,148,155,152,70,101,87,6,58,35,
  65,97,83,159,161,160,161,161,161,119,132,127,130,140,135,161,161,161,
  162,161,162,160,161,161,65,97,83,62,95,81,145,153,148,66,97,84,
  12,62,39,1,56,30,1,56,31,3,56,32,20,67,46,84,111,100,
  135,145,141,160,162,158,159,160,150,156,153,127,152,145,98,150,140,78,
  144,133,60,143,132,51,141,131,47,144,132,49,146,135,54,145,138,63,
  144,140,79,149,145,104,157,155,133,159,161,152,156,160,158,123,137,132,
  68,101,88,10,60,38,1,56,31,0,57,31,1,57,30,1,57,30,
  1,57,32,26,71,51,157,161,160,160,161,162,125,139,133,2,56,32,
  1,57,30,0,57,31,1,57,31,1,57,31,0,57,31,1,57,31,
  1,56,31,35,76,59,134,146,141,65,97,83,2,56,32,0,57,31,
  2,56,31,93,117,108,147,154,152,24,68,48,5,37,39,10,5,81,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,247,232,17,
  247,232,17,10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,
  21,37,66,6,57,35,119,134,128,132,145,141,11,61,39,0,57,31,
  4,55,31,112,129,122,160,162,162,162,161,162,160,162,161,118,135,128,
  28,68,51,97,119,110,160,162,161,159,161,160,80,104,94,106,125,117,
  159,162,160,160,161,161,139,148,143,7,59,36,14,64,41,2,56,32,
  2,56,33,2,56,31,23,70,48,97,120,112,153,158,156,161,160,151,
  153,150,111,145,137,65,136,124,28,141,126,12,145,129,10,145,131,10,
  144,130,9,146,132,15,149,135,16,150,134,15,150,135,15,145,134,9,
  139,130,10,133,126,12,134,126,16,135,130,36,142,138,74,154,153,123,
  160,162,153,145,152,149,78,107,94,12,61,38,1,56,32,2,56,33,
  1,56,31,3,57,33,114,131,124,160,161,161,160,161,161,69,99,86,
  2,56,32,1,57,32,1,57,31,1,56,31,0,57,31,4,56,33,
  64,98,83,152,158,155,161,161,161,152,158,156,35,77,59,2,56,32,
  0,57,30,10,61,39,135,146,142,112,130,123,5,56,34,15,26,65,
  10,4,84,10,4,84,10,4,84,10,4,84,10,4,84,247,232,17,
  247,232,17,10,4,84,10,4,84,10,4,84,10,4,84,9,8,73,
  3,50,31,63,96,82,156,160,159,41,81,65,1,56,31,1,56,31,
  14,65,43,122,138,132,161,161,162,161,162,162,161,161,161,160,162,161,
  149,155,152,62,92,79,119,133,126,160,162,161,155,159,158,46,83,67,
  80,106,93,157,161,159,112,130,122,6,59,35,1,57,30,1,56,31,
  9,60,38,85,111,99,153,158,156,159,158,144,144,138,85,136,131,35,
  141,133,13,139,132,11,138,130,14,143,134,16,145,135,19,146,136,16,
  147,138,19,150,140,22,157,147,20,158,149,22,155,149,21,148,145,16,
  141,140,15,141,138,13,144,142,16,142,142,15,138,137,14,136,136,18,
  137,137,46,148,146,102,159,161,152,142,152,148,62,94,80,4,56,33,
  1,57,31,1,57,30,18,67,46,139,149,145,161,161,161,160,161,161,
  110,130,123,57,94,78,2,57,32,1,57,31,11,61,39,101,123,114,
  160,161,161,161,161,161,162,161,162,161,161,162,92,118,107,1,57,32,
  1,57,30,1,56,30,44,82,67,154,160,159,55,91,75,5,49,32,
  11,8,81,10,4,84,10,4,84,10,4,84,10,4,84,247,232,17,
  247,232,17,10,4,84,10,4,84,10,4,84,10,4,84,20,46,56,
  15,63,42,142,151,147,99,122,113,2,55,31,0,57,31,1,57,31,
  1,57,32,4,55,33,61,94,80,143,152,148,161,162,161,162,162,162,
  161,161,161,158,160,159,98,117,110,141,148,145,161,161,162,145,154,150,
  25,70,50,32,76,57,3,57,34,1,56,30,1,57,32,37,78,59,
  135,146,141,160,160,152,148,145,95,135,132,28,137,131,12,141,138,18,
  147,140,18,144,135,13,135,131,13,140,136,15,149,143,19,150,144,21,
  148,141,19,150,144,20,150,145,21,152,145,24,153,147,24,151,149,22,
  146,148,16,148,149,18,148,151,19,148,152,21,146,146,16,147,148,19,
  146,147,20,141,141,16,140,139,43,153,151,114,160,161,156,113,131,124,
  18,67,44,1,57,31,1,56,31,23,68,48,122,137,130,159,162,161,
  160,162,161,78,106,93,1,56,32,29,72,55,131,143,138,161,162,162,
  162,161,162,160,162,161,158,161,159,85,111,100,4,57,34,1,56,31,
  1,57,32,1,56,31,1,56,31,101,122,114,136,147,143,11,60,39,
  29,50,68,10,4,84,10,4,84,10,4,84,10,4,84,247,232,17,
  247,232,17,10,4,84,10,4,84,10,4,84,21,23,81,6,57,34,
  83,111,100,148,154,153,20,67,47,1,57,30,1,56,32,1,57,31,
  1,56,31,0,57,30,2,56,30,17,64,44,104,125,117,160,161,159,
  161,162,161,160,162,162,160,161,161,109,125,119,150,155,153,152,157,154,
  43,84,65,0,57,30,1,57,31,2,56,32,67,98,86,153,158,156,
  156,155,129,143,136,48,145,136,15,149,145,18,154,146,19,155,150,21,
  155,153,27,149,150,23,147,145,20,147,145,21,149,148,22,149,147,25,
  150,146,23,145,142,16,141,141,17,142,143,18,147,148,18,146,148,18,
  145,147,18,144,147,18,150,150,19,154,153,25,154,154,25,155,155,26,
  153,153,24,147,149,20,146,145,19,140,135,19,137,133,65,157,156,142,
  141,150,147,40,79,63,1,57,30,1,57,31,4,57,33,44,83,66,
  78,107,95,9,58,37,58,93,78,149,156,154,161,161,162,162,161,162,
  162,162,162,160,161,160,90,111,102,18,66,45,5,57,33,2,56,31,
  1,56,32,1,57,31,1,56,30,23,68,48,150,156,154,74,103,92,
  9,55,37,15,14,80,10,4,84,10,4,84,10,4,84,247,232,17,
  247,232,17,10,4,84,10,4,84,10,4,84,20,47,57,18,66,46,
  148,155,153,81,109,97,1,57,32,1,57,31,19,65,45,75,106,92,
  11,60,37,1,57,30,1,56,31,1,57,32,4,56,34,65,97,83,
  152,157,154,161,161,162,160,161,161,127,139,133,50,86,71,37,78,60,
  1,56,33,1,57,30,3,57,32,86,113,103,158,161,155,150,145,101,
  136,128,23,148,142,16,154,146,13,149,143,13,152,146,17,156,152,21,
  155,154,24,155,154,23,154,154,24,153,152,22,149,148,19,146,146,18,
  147,146,18,146,145,17,146,147,18,147,145,18,146,146,20,146,145,20,
  146,146,17,145,146,18,147,148,21,149,149,24,151,150,22,150,151,21,
  151,150,22,149,150,24,149,147,24,148,144,22,137,131,20,127,123,34,
  152,151,123,152,157,154,52,91,75,1,56,33,1,56,31,1,57,30,
  7,60,37,93,117,107,157,161,159,162,161,162,161,162,162,161,161,162,
  161,161,161,161,161,162,158,161,161,155,158,158,149,154,152,132,145,140,
  85,112,101,3,56,32,1,57,31,1,56,32,88,113,103,143,152,149,
  14,62,41,19,39,61,10,4,84,10,4,84,10,4,84,247,232,17,
  247,232,17,10,4,84,10,4,84,18,19,80,5,54,33,81,109,98,
  145,153,150,14,64,42,1,57,31,2,56,32,89,113,103,159,162,160,
  136,147,142,56,90,75,4,57,33,1,57,30,1,57,31,2,56,31,
  43,80,65,156,159,158,161,161,162,133,143,137,1,54,31,1,57,31,
  1,57,31,3,57,32,90,115,105,159,161,155,148,142,84,134,124,16,
  140,131,13,149,143,16,156,145,14,150,143,14,154,148,20,154,152,21,
  155,155,23,154,155,22,156,156,24,154,154,21,151,151,20,149,149,20,
  149,148,20,149,148,19,150,150,21,150,147,20,149,146,22,147,145,24,
  148,147,24,148,147,21,148,147,24,149,148,24,150,150,23,151,150,22,
  150,149,24,150,148,23,150,147,27,149,146,21,141,141,22,141,139,22,
  134,131,32,150,150,114,155,159,156,56,91,75,1,57,31,1,57,31,
  14,64,43,140,149,146,160,161,161,161,161,161,155,159,158,111,128,123,
  160,161,161,161,161,161,161,161,161,162,162,161,161,162,161,161,161,162,
  156,160,159,32,75,58,1,57,31,1,57,30,19,66,46,149,156,154,
  71,101,89,7,51,36,12,9,81,10,4,84,10,4,84,247,232,17,
  247,232,17,10,4,84,10,4,84,19,40,62,11,60,39,142,151,148,
  85,111,100,1,56,31,1,56,31,20,67,46,149,156,154,161,161,162,
  162,161,161,160,161,160,121,136,129,44,83,64,5,57,33,1,56,31,
  27,71,53,154,158,157,161,161,161,102,122,113,2,56,31,0,57,31,
  2,57,31,83,111,100,160,161,156,153,147,82,143,131,13,143,135,13,
  146,139,11,152,143,16,152,145,15,150,145,16,153,151,21,155,154,22,
  155,155,25,153,154,25,154,156,23,155,156,22,153,153,23,151,151,19,
  153,152,21,151,151,19,152,152,21,151,149,24,150,149,21,150,148,26,
  150,149,30,151,150,25,150,148,25,150,148,25,150,149,25,150,148,24,
  148,147,23,149,146,22,150,149,25,148,148,25,144,143,20,145,145,22,
  147,142,26,139,134,30,151,149,108,155,159,155,45,85,69,2,56,31,
  1,57,32,43,82,66,154,159,157,136,147,142,44,80,66,112,129,123,
  161,161,161,160,161,162,153,158,157,145,152,150,151,157,155,158,160,159,
  159,162,161,111,129,121,3,57,33,1,56,30,1,56,32,94,118,109,
  135,146,142,8,58,36,16,28,62,10,4,84,10,4,84,247,232,17,
  247,232,17,10,4,84,15,10,85,10,52,37,58,92,79,153,158,157,
  23,70,50,1,57,31,0,57,31,37,81,61,142,151,147,161,161,161,
  161,162,161,161,162,161,162,161,161,157,160,159,116,132,126,60,94,79,
  121,136,129,160,162,161,157,160,160,40,80,63,1,57,30,2,56,33,
  64,96,83,159,161,157,153,145,88,150,137,19,152,142,15,151,143,16,
  151,144,16,150,145,14,149,145,16,152,151,19,155,155,20,155,155,20,
  156,155,26,156,154,29,156,154,28,156,154,25,156,154,26,154,153,26,
  155,154,27,154,153,26,155,154,28,153,152,28,153,151,27,154,150,29,
  153,150,30,154,152,29,153,151,29,152,149,23,151,148,25,151,149,22,
  149,149,21,150,148,23,150,149,22,147,145,26,144,144,20,142,142,16,
  151,148,21,151,147,26,140,136,31,151,150,117,149,154,152,29,72,53,
  1,56,31,1,57,31,51,90,73,15,64,43,41,82,65,157,160,158,
  161,161,161,160,161,161,65,96,82,10,60,37,15,64,42,20,67,46,
  28,73,54,38,81,62,3,58,33,1,56,31,1,56,31,31,75,57,
  155,160,158,48,87,71,5,41,37,11,5,85,10,4,84,247,232,17,
  247,232,17,10,4,84,13,21,66,4,54,33,117,133,127,114,130,124,
  2,56,32,1,57,31,1,57,31,1,56,31,14,63,41,87,112,101,
  152,157,155,161,162,161,161,162,162,162,162,162,162,161,162,160,162,161,
  161,161,161,161,161,161,108,128,119,4,56,34,1,57,30,36,77,60,
  153,158,155,153,149,107,141,130,15,152,140,14,156,148,19,154,148,20,
  150,147,18,148,149,18,147,149,19,153,153,21,155,155,22,152,151,21,
  154,152,27,154,153,26,152,151,26,154,152,26,154,152,29,152,151,26,
  154,152,29,153,150,28,154,151,29,151,149,30,151,147,31,151,147,29,
  153,150,31,156,151,30,156,151,30,154,151,28,150,149,25,151,150,23,
  150,150,23,150,151,19,150,150,20,146,145,20,145,146,17,149,150,17,
  157,155,22,152,150,21,144,138,17,144,138,35,156,155,133,130,143,138,
  10,61,37,0,57,31,2,56,32,4,57,33,118,135,128,161,161,162,
  161,161,161,119,136,130,5,56,34,1,57,31,1,57,32,0,57,30,
  1,57,31,0,57,30,1,57,31,0,57,31,1,57,31,3,57,33,
  122,137,130,108,127,120,5,54,33,20,22,78,10,4,84,247,232,17,
  247,232,17,10,4,84,12,39,50,23,69,50,153,159,157,57,92,77,
  1,57,31,1,56,31,25,72,52,35,77,58,1,57,31,1,56,31,
  26,71,50,107,126,117,157,160,159,162,162,162,162,161,161,161,161,162,
  161,161,162,127,142,136,18,64,44,1,56,30,9,60,37,131,144,139,
  158,156,137,138,128,25,148,136,11,155,143,19,155,146,20,154,149,21,
  151,150,19,150,150,19,150,150,21,150,151,20,151,151,20,151,150,26,
  151,149,28,151,147,28,151,149,29,151,150,26,151,149,27,150,148,28,
  151,149,26,151,149,29,150,147,31,149,146,31,148,143,30,149,143,32,
  151,147,30,155,150,32,156,151,29,155,152,28,154,154,24,154,155,24,
  155,154,22,155,155,20,153,155,21,152,151,20,151,151,19,153,153,22,
  153,151,21,152,148,21,153,144,19,150,141,17,140,133,51,160,160,152,
  90,116,106,2,56,32,1,57,31,23,71,50,155,160,158,161,161,162,
  156,159,158,35,76,58,1,56,31,1,57,31,1,56,30,1,57,30,
  1,56,31,1,56,31,1,56,31,1,56,31,1,56,31,1,57,31,
  66,98,85,150,157,154,17,64,44,19,39,61,10,4,84,247,232,17,
  247,232,17,16,11,87,5,49,32,70,101,89,149,155,153,15,62,40,
  1,57,31,14,63,42,135,146,142,153,158,155,57,95,79,1,56,31,
  1,57,32,7,58,36,50,82,69,114,131,124,151,157,155,144,152,149,
  86,111,100,12,62,39,2,56,30,1,57,32,81,108,97,160,161,153,
  146,137,55,144,133,10,153,142,12,155,145,18,151,146,21,151,150,19,
  150,151,20,150,151,23,150,150,23,150,151,23,150,151,22,150,149,28,
  149,146,30,149,146,26,150,145,31,150,147,29,151,148,30,151,148,30,
  150,146,30,150,146,31,149,145,31,148,144,32,150,146,31,152,146,37,
  153,149,37,154,150,38,157,153,32,158,154,30,156,153,25,155,156,22,
  156,157,18,157,158,19,157,158,20,155,155,20,152,154,19,152,154,21,
  151,150,19,154,150,20,155,149,22,155,147,20,155,143,25,150,144,87,
  156,160,156,37,78,59,1,57,31,4,56,33,112,130,123,161,161,162,
  99,120,111,1,57,31,1,57,32,1,57,31,1,57,31,27,71,52,
  92,115,105,97,120,111,71,102,89,10,61,39,1,56,31,2,56,30,
  19,66,46,153,158,156,61,94,80,9,47,41,11,5,84,247,232,17,
  247,232,17,16,22,70,3,54,31,118,134,128,110,129,121,2,57,31,
  1,56,32,92,115,106,161,161,161,136,147,143,18,64,44,2,56,32,
  67,99,86,141,151,148,156,161,159,132,142,138,64,92,80,9,58,36,
  0,57,30,1,57,32,1,57,31,22,68,48,151,156,153,157,154,109,
  154,142,20,155,147,20,155,149,21,148,147,20,150,148,20,150,150,20,
  149,150,23,150,150,26,150,151,25,150,151,26,150,150,29,150,148,29,
  149,146,31,150,145,31,149,146,28,150,145,28,150,145,32,149,146,32,
  150,145,31,150,146,32,150,145,31,151,147,35,153,149,38,156,150,40,
  154,148,42,154,150,36,156,152,29,156,152,29,156,153,28,155,155,24,
  155,157,19,156,159,18,158,159,18,155,155,21,151,154,19,151,153,19,
  151,151,20,152,150,20,154,147,21,153,147,20,154,145,21,148,138,30,
  157,155,133,118,135,129,3,57,34,1,57,31,34,75,58,144,154,150,
  26,70,52,18,63,43,13,62,40,1,57,30,22,68,48,145,154,152,
  161,161,161,161,161,162,161,161,162,123,138,133,12,61,39,1,57,30,
  2,56,33,120,135,130,108,128,119,4,54,33,16,16,77,247,232,17,
  247,232,17,9,28,56,13,62,40,151,157,155,66,98,85,1,57,31,
  12,62,40,148,155,152,160,161,161,54,90,74,1,57,32,59,94,79,
  160,162,162,162,162,162,162,162,162,161,162,162,151,158,156,20,67,47,
  1,57,31,1,57,31,1,56,32,93,117,108,161,161,149,152,145,42,
  154,146,18,154,152,20,153,149,22,138,108,53,136,97,65,138,100,69,
  139,100,70,138,101,69,146,126,48,150,151,27,151,149,30,147,146,28,
  147,137,43,120,99,66,120,98,72,120,98,72,120,98,72,120,99,71,
  121,98,72,124,105,64,151,132,39,146,100,45,147,101,50,148,126,46,
  149,143,37,150,145,38,147,142,27,149,135,34,147,103,38,148,105,40,
  153,135,29,156,158,20,114,145,22,103,141,24,100,140,25,102,139,25,
  101,138,25,101,138,24,135,143,19,152,144,22,152,111,19,150,109,20,
  144,135,66,159,161,157,44,84,67,2,56,30,2,56,32,35,79,60,
  84,111,101,157,162,161,85,114,103,1,56,31,82,110,99,161,161,162,
  161,161,161,161,161,161,161,161,161,161,161,161,78,107,95,2,56,31,
  1,56,31,76,105,94,146,154,150,9,58,37,17,29,65,247,232,17,
  247,232,17,11,44,44,47,85,69,158,162,160,26,72,52,1,56,31,
  35,77,58,160,161,161,154,158,158,18,67,46,6,57,34,134,145,141,
  160,162,162,162,162,162,161,162,162,162,161,162,162,161,162,69,101,87,
  1,57,30,1,57,31,16,65,43,150,155,151,156,153,104,152,145,20,
  150,147,17,152,151,21,141,106,63,120,32,128,119,16,146,120,16,144,
  121,15,146,118,17,142,127,53,111,146,127,49,149,150,29,148,147,29,
  138,124,61,68,22,126,69,19,139,69,18,142,69,19,139,69,19,141,
  69,19,141,78,37,119,146,111,52,138,21,70,140,19,74,142,92,45,
  145,140,28,143,137,25,138,136,22,142,113,39,137,21,69,140,20,72,
  147,96,45,153,155,23,45,121,28,18,115,32,18,116,32,19,115,31,
  18,115,33,18,115,33,111,137,24,154,143,24,145,54,12,147,61,15,
  147,134,28,156,154,128,112,130,123,1,57,31,1,57,30,2,55,32,
  121,136,130,161,161,162,56,92,77,1,56,31,104,125,116,160,161,162,
  161,162,162,102,122,114,93,116,107,161,162,162,140,149,146,8,60,37,
  1,57,31,37,79,60,158,161,159,37,79,61,17,43,53,247,232,17,
  247,232,17,4,51,31,85,111,100,141,150,146,7,59,36,2,56,31,
  35,77,59,159,162,161,157,160,159,53,87,73,90,115,105,159,162,161,
  161,161,161,156,159,157,96,117,109,152,157,156,161,161,161,93,116,106,
  1,56,31,1,56,31,67,99,87,161,161,153,149,145,52,152,146,20,
  154,150,19,142,106,63,122,34,126,119,16,145,120,16,144,119,16,146,
  119,17,144,120,16,145,119,17,141,141,101,74,150,149,31,149,145,31,
  139,124,62,68,21,129,69,19,139,69,20,136,68,20,136,70,19,136,
  68,20,137,79,37,115,147,112,51,137,21,73,141,19,73,140,49,60,
  144,119,39,145,143,26,143,143,26,145,116,36,138,21,69,139,20,72,
  146,93,44,149,153,22,44,122,26,18,115,32,20,115,34,18,115,33,
  19,115,33,20,115,31,106,138,22,153,140,22,145,53,14,149,61,15,
  157,145,24,149,144,78,154,159,156,24,69,49,1,56,31,3,55,32,
  132,145,140,161,162,162,56,91,77,2,56,31,102,123,114,161,161,161,
  160,162,161,25,69,51,7,59,37,143,151,148,160,162,161,30,75,56,
  1,57,31,10,61,39,148,155,152,74,103,91,4,44,33,247,232,17,
  247,232,17,3,55,31,115,131,126,114,131,124,2,56,31,1,57,31,
  16,64,43,152,157,154,161,161,160,159,160,160,160,161,161,161,161,161,
  157,160,159,53,89,72,2,56,32,128,140,134,161,161,161,87,113,102,
  1,57,31,3,55,32,118,134,128,160,158,129,155,146,26,157,151,21,
  159,154,22,137,79,89,120,16,144,120,16,146,120,16,143,117,20,131,
  117,19,136,120,16,144,119,16,145,124,40,121,145,122,54,146,144,32,
  138,123,63,68,21,128,69,19,139,97,63,101,124,107,62,124,107,60,
  125,109,61,131,116,57,148,116,45,138,21,71,140,20,74,139,20,74,
  139,46,60,149,130,39,151,148,27,147,117,37,137,22,69,139,20,72,
  147,94,43,148,151,21,122,142,24,103,140,28,25,115,30,19,115,32,
  60,127,30,116,141,25,137,146,19,152,141,22,144,54,14,149,62,16,
  155,148,21,141,138,34,159,160,147,75,103,92,1,56,31,2,56,32,
  117,134,127,161,161,162,95,118,108,2,56,32,93,118,108,162,161,161,
  158,162,161,26,72,53,2,56,31,112,128,124,160,162,161,50,88,72,
  0,57,32,2,56,32,122,136,131,106,125,117,6,53,31,247,232,17,
  247,232,17,3,55,32,141,150,147,86,111,101,1,57,31,1,57,31,
  2,56,32,108,128,121,161,161,161,161,161,161,160,161,162,160,162,161,
  90,115,105,2,56,31,19,66,44,153,158,156,161,161,161,55,92,76,
  1,56,30,16,64,43,153,157,154,158,153,90,159,150,22,159,152,23,
  158,152,29,136,75,97,120,16,145,118,17,144,121,35,116,153,124,63,
  144,93,85,120,17,138,119,16,145,120,16,141,143,115,62,149,145,33,
  139,124,61,69,22,127,69,18,140,107,81,83,145,143,28,145,144,22,
  149,145,27,150,148,26,149,117,38,138,20,71,140,19,74,140,19,74,
  137,23,68,150,117,45,149,147,30,148,119,41,138,21,68,139,20,72,
  144,92,43,149,149,20,150,147,19,134,148,26,27,115,28,19,115,33,
  74,132,27,151,153,19,151,148,15,152,143,22,144,54,12,149,62,16,
  154,147,20,143,139,18,149,148,113,123,137,130,2,56,32,2,56,30,
  72,103,91,161,161,161,156,159,158,101,120,112,147,153,151,161,161,161,
  159,161,162,44,83,67,2,56,31,114,129,123,159,161,160,47,86,69,
  1,57,31,1,56,32,92,115,105,135,147,143,4,54,32,247,232,17,
  247,232,17,13,64,41,155,159,158,60,93,80,1,56,32,0,57,31,
  2,56,31,20,67,46,122,137,132,158,161,160,156,160,159,110,128,121,
  12,61,39,2,57,32,99,121,112,161,162,161,141,151,147,10,61,39,
  1,57,30,48,87,71,161,161,155,154,148,53,156,145,16,158,151,20,
  141,102,64,120,23,133,119,16,145,119,19,135,154,130,58,152,151,22,
  146,118,56,119,28,127,120,16,145,119,17,142,142,103,75,149,143,37,
  138,122,64,68,22,128,69,18,141,109,83,83,147,144,25,145,144,25,
  148,146,24,149,147,25,148,116,35,138,20,71,140,19,74,140,19,74,
  140,20,73,135,35,56,151,138,30,146,118,38,138,21,68,140,20,71,
  145,92,43,149,148,20,151,150,20,135,151,28,26,115,28,18,116,33,
  73,130,27,149,151,19,151,152,19,149,140,20,143,54,11,148,62,16,
  154,148,20,146,140,14,140,138,72,152,157,154,15,64,43,1,57,30,
  14,62,41,140,150,146,161,161,161,160,161,161,161,161,161,160,162,162,
  157,160,159,21,68,48,1,57,30,74,106,91,87,114,102,17,67,45,
  0,57,31,1,56,31,65,98,83,153,158,157,11,60,38,247,232,17,
  247,232,17,31,74,55,157,161,161,39,80,63,1,56,31,1,56,31,
  1,57,31,1,57,31,5,58,36,29,72,54,25,70,49,3,56,32,
  3,57,33,85,113,101,160,160,161,159,161,161,62,95,81,1,56,31,
  1,56,31,83,109,98,159,158,142,149,138,30,156,145,16,155,148,17,
  141,94,76,118,17,143,119,16,146,118,19,135,157,143,40,151,150,19,
  151,148,26,140,92,77,120,17,143,119,16,145,118,25,126,147,128,52,
  139,125,63,68,22,125,69,19,141,108,81,83,145,140,27,145,143,27,
  150,148,26,149,147,24,148,117,40,138,20,71,140,19,74,140,19,74,
  140,19,74,137,24,68,149,115,38,148,116,42,138,21,70,139,20,72,
  144,92,42,147,147,21,150,150,20,134,149,26,27,115,28,19,115,33,
  76,131,28,151,150,19,151,151,18,152,142,23,144,54,13,148,63,15,
  152,148,19,143,139,12,137,134,43,159,161,157,42,82,65,1,57,30,
  1,57,31,46,84,68,152,157,154,161,161,161,161,161,161,160,161,160,
  94,119,108,2,56,32,1,57,31,1,56,32,2,56,32,1,56,31,
  1,57,31,0,56,31,42,83,65,158,161,160,29,74,53,247,232,17,
  247,232,17,48,85,69,158,162,161,21,68,48,1,57,31,1,57,31,
  0,57,31,1,57,31,1,57,31,1,57,31,1,56,31,1,57,31,
  3,57,33,62,97,81,139,150,145,82,111,100,3,56,33,1,56,30,
  1,56,31,111,128,121,152,150,121,142,130,16,152,144,16,154,149,21,
  139,91,78,119,17,142,120,16,142,126,54,105,153,144,33,151,150,20,
  151,150,20,140,94,71,119,17,146,120,16,145,119,21,135,149,128,54,
  142,126,70,68,21,129,69,19,139,96,61,106,121,101,69,120,102,64,
  146,139,37,150,149,26,146,116,37,139,20,71,140,19,74,141,19,74,
  140,19,74,140,19,73,135,36,61,149,116,42,138,22,69,139,20,72,
  146,94,44,149,148,25,150,149,23,136,151,28,27,115,27,18,116,31,
  77,132,27,155,154,20,153,155,19,152,143,22,144,54,12,148,62,16,
  151,148,20,144,141,15,134,128,24,157,157,143,72,103,89,1,57,31,
  1,57,31,1,56,31,31,76,56,102,123,116,113,130,124,79,108,96,
  6,59,35,1,56,30,1,57,31,1,56,31,1,57,31,1,57,31,
  1,57,31,1,57,32,22,68,48,158,162,162,46,86,68,247,232,17,
  247,232,17,61,96,80,156,160,158,11,61,39,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,56,31,8,61,36,2,56,32,1,57,31,1,57,31,
  3,55,32,131,143,139,141,137,98,138,124,12,150,143,18,148,126,37,
  127,58,105,119,16,145,117,19,136,146,118,55,150,149,20,151,149,21,
  151,149,19,144,118,49,127,44,117,119,16,145,118,22,134,150,130,55,
  143,128,69,69,21,128,69,19,139,69,19,137,68,20,136,69,23,121,
  140,128,54,150,148,25,148,116,39,139,21,71,139,20,74,142,54,60,
  139,37,64,140,19,74,136,34,62,149,115,41,137,22,70,139,20,72,
  145,93,46,151,149,24,152,150,25,135,150,26,27,115,29,18,116,32,
  77,134,26,156,157,19,155,155,20,154,147,24,144,55,12,147,61,15,
  148,143,19,145,141,16,135,130,19,153,152,129,96,118,109,1,57,32,
  1,57,31,1,57,31,1,57,31,2,57,31,2,56,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,0,57,31,12,60,38,153,159,157,62,97,83,247,232,17,
  247,232,17,71,103,89,147,154,152,9,59,36,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,56,31,1,57,31,1,57,31,1,57,31,
  7,59,36,143,151,149,134,130,81,137,125,14,155,145,18,145,103,59,
  119,18,139,119,16,146,118,18,138,143,117,58,150,145,25,152,147,26,
  152,146,27,152,147,34,134,79,89,120,16,146,118,22,134,150,130,59,
  143,129,65,68,22,126,70,18,140,69,19,138,68,20,133,69,23,119,
  138,127,57,149,148,24,148,116,37,138,21,71,140,19,74,146,95,46,
  139,56,53,140,19,76,139,25,70,142,61,60,139,20,71,140,20,72,
  148,95,50,154,153,26,155,153,27,137,152,28,27,115,28,18,116,33,
  77,134,28,156,157,19,155,155,20,155,147,24,144,54,12,147,61,16,
  147,143,18,145,141,16,140,135,16,147,145,113,114,132,125,1,56,32,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,7,59,36,143,151,148,76,104,93,247,232,17,
  247,232,17,78,107,95,140,149,147,6,58,34,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  13,63,41,151,156,153,134,128,71,138,124,11,154,141,16,145,103,60,
  119,18,138,120,16,145,120,16,143,125,50,110,128,59,100,127,60,101,
  128,59,101,128,60,103,124,36,126,119,16,146,118,21,134,151,130,58,
  140,126,61,68,22,126,70,18,140,97,61,107,120,101,70,122,104,60,
  146,138,35,150,147,24,146,116,36,137,21,71,140,19,73,146,95,45,
  137,59,51,139,20,71,139,20,74,138,20,75,141,19,74,140,20,73,
  148,97,48,153,152,27,152,152,24,137,153,27,27,115,27,18,116,33,
  76,133,27,155,156,19,155,156,20,154,146,24,144,55,12,147,61,16,
  147,143,18,145,141,16,143,137,14,149,148,109,129,141,136,2,56,32,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,3,58,33,135,146,142,86,111,101,247,232,17,
  247,232,17,86,112,101,135,145,143,5,57,33,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,0,57,31,
  18,67,45,156,159,157,133,127,66,138,126,12,150,140,14,145,100,62,
  119,17,141,120,16,146,119,16,145,119,16,144,121,15,145,119,16,145,
  119,16,144,119,16,144,119,16,144,119,16,145,119,21,135,154,129,61,
  146,129,67,68,22,127,70,18,141,110,83,85,146,144,29,148,144,24,
  146,145,25,150,148,25,151,118,40,139,20,71,139,20,72,143,97,44,
  147,123,37,138,37,65,141,19,73,141,19,74,140,19,75,139,21,72,
  145,94,46,146,147,19,146,147,18,135,153,27,27,115,28,18,116,33,
  77,134,28,156,157,20,156,155,20,156,147,25,145,54,12,148,60,15,
  146,141,18,146,143,15,141,135,13,151,150,109,140,148,144,2,56,32,
  0,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,56,32,130,140,136,94,118,109,247,232,17,
  247,232,17,85,112,100,135,145,143,5,57,34,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,0,57,31,
  17,65,44,154,158,156,138,131,69,139,128,17,148,136,13,145,101,60,
  119,17,141,120,16,145,120,24,132,120,28,127,121,27,127,120,28,126,
  119,28,127,120,28,126,120,21,137,121,15,145,119,16,144,119,37,110,
  142,118,78,70,22,127,69,18,140,111,85,85,152,149,27,150,147,26,
  150,146,25,151,148,26,146,116,36,139,21,70,139,20,73,143,97,40,
  151,148,26,137,53,52,140,20,73,139,20,74,141,19,74,139,20,71,
  142,89,41,141,142,12,146,145,18,133,149,26,27,115,28,19,115,33,
  76,133,27,155,156,20,155,155,20,153,143,22,144,54,13,147,61,16,
  148,144,18,146,140,15,137,132,12,147,147,109,136,145,141,2,56,32,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,2,56,32,130,141,136,94,117,110,247,232,17,
  247,232,17,78,107,95,142,150,148,6,59,35,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,0,57,31,
  12,61,39,148,154,152,145,136,78,144,129,13,160,145,27,146,107,64,
  119,17,141,119,18,138,147,107,73,157,153,32,158,150,34,159,152,31,
  158,150,34,159,149,35,137,94,77,121,26,131,119,16,146,117,27,121,
  142,117,80,69,21,128,69,18,140,109,82,83,152,148,28,155,151,29,
  151,149,26,149,147,27,146,114,35,139,20,71,140,20,73,146,101,41,
  151,154,19,154,144,34,138,29,63,139,20,74,140,19,74,138,20,74,
  147,96,44,154,155,19,154,156,20,137,155,26,26,116,26,19,115,32,
  77,134,27,158,158,19,149,153,19,154,141,20,146,53,12,147,63,15,
  154,149,17,149,143,16,136,132,14,144,143,108,125,139,132,1,56,32,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,4,58,34,135,147,142,87,111,102,247,232,17,
  247,232,17,71,102,88,148,154,152,9,60,37,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,0,57,31,
  5,57,34,139,149,146,144,137,90,142,123,12,155,140,21,146,107,69,
  118,17,140,118,18,140,146,109,67,156,156,19,156,155,20,156,155,21,
  156,155,22,155,155,20,158,153,29,132,65,102,120,16,144,116,28,121,
  142,117,79,69,22,126,69,19,139,109,84,83,153,149,27,153,151,27,
  151,150,26,150,149,24,146,114,34,139,20,71,140,20,73,147,102,42,
  154,158,19,152,149,26,138,29,64,139,19,75,141,19,74,140,20,71,
  147,99,44,156,158,19,155,158,18,139,155,26,28,115,27,19,115,32,
  78,134,27,159,158,18,154,156,17,149,141,19,144,54,12,147,62,16,
  151,148,20,147,144,15,135,132,19,145,144,115,107,126,118,1,56,32,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,8,59,36,144,153,150,77,104,93,247,232,17,
  247,232,17,61,95,79,156,160,159,11,61,40,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,0,57,30,
  2,56,32,123,139,132,149,145,111,142,124,13,156,143,20,146,107,67,
  119,17,140,119,17,140,146,110,65,157,155,21,155,154,25,154,153,22,
  156,154,26,154,154,20,157,154,23,131,65,99,120,16,145,116,27,122,
  143,118,72,69,22,126,69,19,140,108,83,83,152,150,30,152,151,29,
  152,150,27,148,145,23,146,114,34,138,21,71,140,20,73,146,101,42,
  154,157,19,154,152,23,142,74,50,139,21,70,140,19,74,139,20,73,
  148,98,43,153,157,20,110,144,23,89,138,30,24,115,29,17,116,34,
  55,126,29,102,141,24,137,152,23,151,147,20,145,94,16,148,97,17,
  149,146,18,146,141,13,129,126,17,154,153,135,88,113,103,1,57,32,
  1,57,30,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,0,57,31,13,60,39,154,160,158,63,96,82,247,232,17,
  247,232,17,47,84,68,158,162,162,24,70,50,1,57,31,1,57,31,
  1,56,31,1,57,31,1,57,31,1,57,31,1,57,31,46,87,71,
  7,58,35,1,56,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,30,99,121,112,156,154,133,144,131,18,152,141,19,146,105,64,
  118,18,141,119,17,140,145,109,66,157,153,24,158,152,29,154,150,22,
  155,153,27,156,152,23,158,151,26,132,64,100,120,16,145,116,28,121,
  143,117,73,69,22,126,69,19,139,111,84,84,151,149,31,152,151,29,
  152,150,28,148,145,26,145,114,34,138,21,71,140,19,74,147,100,42,
  155,155,20,156,156,19,154,147,26,141,75,52,140,20,71,139,20,73,
  147,97,42,151,156,23,45,122,28,18,116,32,18,116,32,18,116,33,
  18,115,33,19,115,32,109,144,23,153,148,23,147,102,15,150,104,17,
  150,145,16,142,138,11,126,121,27,157,157,150,62,95,80,1,57,30,
  1,57,31,1,57,31,0,57,31,1,56,32,1,57,31,18,67,46,
  34,78,60,1,57,31,1,57,31,0,57,31,1,57,31,1,57,31,
  0,57,31,1,57,31,26,70,51,158,162,160,46,85,69,247,232,17,
  247,232,17,30,74,54,157,161,161,42,83,66,1,57,31,0,57,31,
  0,57,31,1,57,31,1,57,31,1,57,31,3,56,33,119,135,128,
  49,86,70,1,56,31,1,57,30,1,57,31,1,57,31,1,56,31,
  1,57,31,70,101,88,160,160,150,137,127,32,146,135,15,145,103,60,
  118,19,135,118,18,135,147,108,67,157,150,24,157,151,28,155,150,23,
  157,153,28,156,152,25,158,152,29,131,65,98,119,17,140,116,28,118,
  140,115,74,68,23,122,68,20,137,110,85,83,152,150,27,151,148,28,
  149,149,24,149,146,27,145,114,34,136,22,67,138,21,70,145,100,40,
  155,154,20,156,153,22,155,155,20,148,123,34,135,24,65,137,22,69,
  147,97,43,155,155,24,47,121,27,20,115,30,20,115,31,20,115,31,
  20,114,32,20,115,30,110,143,24,156,147,26,143,55,11,147,61,13,
  154,141,16,142,138,14,131,126,51,158,161,159,30,74,55,0,57,31,
  1,57,31,1,56,31,1,57,31,1,57,30,1,57,31,76,105,93,
  93,117,106,2,56,32,1,57,31,1,57,31,1,57,31,1,56,31,
  1,56,31,0,57,31,45,85,68,158,161,159,29,73,54,247,232,17,
  247,232,17,13,62,40,154,159,157,65,97,84,1,57,31,1,56,31,
  1,57,31,6,59,36,10,61,38,11,61,39,32,73,56,156,161,159,
  105,124,116,14,64,42,16,63,41,14,63,42,2,57,32,1,57,31,
  1,56,31,32,77,58,160,161,159,137,129,61,144,131,12,151,133,28,
  144,114,54,146,115,53,150,138,35,149,147,19,151,147,21,155,150,23,
  157,153,24,155,152,25,158,154,26,152,132,43,147,118,55,144,117,48,
  147,137,37,128,114,55,131,116,61,141,133,44,150,150,28,150,149,28,
  150,146,23,150,146,22,149,140,28,145,115,34,147,118,33,152,140,29,
  155,155,21,156,154,21,154,155,21,154,146,25,148,121,34,149,120,34,
  152,142,26,155,156,20,127,150,21,123,149,24,123,148,25,121,147,24,
  122,147,25,123,148,25,146,150,22,152,152,19,153,130,19,147,125,17,
  151,146,18,146,141,17,137,136,86,142,150,146,8,59,37,1,57,31,
  1,57,31,3,58,34,12,60,38,11,60,38,11,60,40,134,145,141,
  141,152,148,19,64,45,15,63,42,15,63,42,7,58,35,1,57,31,
  1,57,31,1,57,31,70,101,88,153,158,156,10,60,39,247,232,17,
  247,232,17,4,54,32,139,149,146,90,115,105,1,57,31,1,57,31,
  0,57,31,24,71,51,120,139,132,146,154,151,150,156,154,161,161,161,
  159,161,160,153,158,156,149,158,155,75,107,93,3,58,32,0,57,31,
  1,56,31,8,59,37,142,151,147,146,143,104,133,126,12,141,135,11,
  143,140,16,146,146,17,148,148,19,147,147,17,147,146,18,154,154,25,
  154,155,21,155,154,25,155,155,23,156,154,26,152,151,22,148,145,18,
  149,147,22,150,149,27,152,150,26,154,151,31,152,148,29,150,148,25,
  151,148,25,150,146,27,147,148,23,149,149,24,152,153,19,155,155,22,
  157,157,19,155,156,19,154,158,19,155,158,18,154,159,17,154,157,18,
  156,155,20,156,157,19,156,153,19,156,156,19,156,156,19,156,156,20,
  158,157,20,156,157,18,155,158,17,154,156,19,156,156,19,151,146,14,
  148,149,18,140,137,24,149,149,127,103,123,115,2,56,32,0,57,31,
  0,57,31,7,61,37,96,122,111,146,154,151,147,154,151,161,162,161,
  160,161,161,154,159,157,152,159,155,105,130,120,12,63,41,0,57,31,
  1,56,31,1,57,31,98,120,111,133,145,140,4,54,32,247,232,17,
  247,232,17,3,55,31,113,130,124,120,135,130,3,55,31,0,56,30,
  1,56,31,0,57,31,16,64,43,115,132,125,161,162,162,161,161,162,
  161,161,161,152,157,156,59,93,78,2,57,32,1,57,31,1,57,31,
  1,57,31,1,56,31,99,122,112,158,158,145,122,119,22,131,126,9,
  139,136,13,145,145,17,145,146,17,149,150,20,148,150,19,152,154,19,
  154,155,19,153,154,23,155,155,23,156,155,23,151,151,20,145,142,23,
  149,146,23,150,147,25,152,148,25,156,150,30,153,147,24,151,146,28,
  152,147,21,151,148,26,150,149,26,152,150,25,154,153,22,155,155,23,
  153,154,18,155,156,19,156,158,18,156,155,20,155,157,19,154,157,19,
  157,158,18,158,159,19,156,156,19,155,158,19,155,156,19,155,156,20,
  155,156,19,156,157,19,155,158,19,158,159,18,155,156,19,150,151,19,
  144,144,16,131,131,42,158,160,157,53,89,73,1,57,31,1,57,31,
  1,57,31,1,56,31,5,57,34,82,110,99,158,160,160,161,162,161,
  162,161,162,159,161,161,92,117,108,7,59,36,0,57,31,1,56,31,
  0,57,31,3,57,31,129,141,137,103,124,115,7,53,33,247,232,17,
  247,232,17,3,50,29,81,108,97,146,154,151,9,61,38,1,57,30,
  1,57,31,1,57,31,1,56,31,32,73,56,160,162,162,162,161,162,
  161,161,161,110,127,120,1,57,31,1,57,30,1,57,31,1,57,31,
  1,57,31,1,56,31,44,83,65,160,161,159,133,131,70,128,122,8,
  132,130,10,140,139,14,144,144,16,145,145,18,146,146,18,154,154,25,
  156,154,25,156,155,24,155,156,23,154,155,24,150,151,20,146,145,18,
  151,148,20,152,146,23,154,148,25,154,149,26,153,148,24,152,146,26,
  151,148,24,150,149,26,151,147,19,152,151,22,154,154,22,154,156,20,
  155,156,20,157,157,20,158,159,17,159,157,18,157,157,19,155,157,19,
  156,157,20,155,156,18,155,157,19,155,156,20,158,157,19,155,155,19,
  154,155,18,156,157,19,156,158,17,156,156,20,144,144,13,150,151,20,
  143,142,20,138,137,95,143,152,148,11,60,39,1,57,31,1,57,31,
  1,57,31,1,57,32,1,56,30,4,57,34,142,148,146,160,162,162,
  161,162,162,149,155,152,9,58,38,2,56,30,0,57,31,1,57,31,
  2,56,31,14,63,41,151,158,157,70,101,87,6,44,36,247,232,17,
  247,232,17,14,48,38,45,84,66,158,161,161,35,78,60,1,56,31,
  0,57,31,1,56,31,1,56,30,73,104,91,159,161,160,111,129,122,
  144,153,151,142,152,148,5,56,34,0,56,31,1,56,32,1,57,31,
  1,57,31,1,57,31,6,58,35,130,143,137,155,154,130,127,119,16,
  129,125,8,139,134,13,145,141,15,148,144,19,151,148,23,155,151,27,
  156,153,25,155,152,21,157,154,26,156,153,24,154,150,20,148,144,18,
  151,148,20,152,149,23,155,153,26,153,152,25,151,149,23,150,148,22,
  151,148,21,154,150,25,151,148,21,153,150,23,156,153,26,156,154,21,
  157,155,21,156,155,21,156,154,20,154,152,22,157,157,20,157,154,20,
  157,155,20,156,155,21,157,155,21,156,153,21,156,152,21,157,153,21,
  157,155,21,157,153,21,156,155,19,152,149,19,141,137,12,148,145,18,
  139,137,35,156,157,146,84,111,100,1,57,31,1,57,31,1,57,31,
  1,57,31,1,56,32,1,56,30,29,73,54,159,162,161,132,144,141,
  127,140,135,160,162,161,34,77,59,1,57,31,0,57,31,0,57,31,
  1,57,31,43,83,66,158,161,161,35,78,59,13,39,40,247,232,17,
  247,232,17,8,28,39,12,61,39,150,157,155,76,105,93,1,56,31,
  1,57,30,1,57,31,2,57,33,88,116,105,40,79,63,1,56,31,
  16,63,43,104,127,118,26,73,54,1,56,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,59,94,82,160,161,158,132,127,68,
  118,110,7,134,126,14,136,129,17,138,131,18,151,145,27,157,151,27,
  155,150,25,157,152,26,159,154,27,156,150,23,154,147,24,151,145,22,
  147,144,20,154,151,26,149,148,22,151,148,24,152,147,22,150,149,24,
  146,142,20,146,141,17,150,150,20,152,151,21,156,153,26,154,150,25,
  152,148,20,156,149,20,156,148,17,156,151,20,157,151,19,152,145,18,
  148,144,16,142,138,15,136,129,15,132,127,14,143,138,13,157,150,20,
  157,151,19,153,145,16,150,145,17,150,144,18,142,135,14,137,131,16,
  139,138,91,149,156,154,19,65,45,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,32,65,100,86,77,106,94,7,57,35,
  5,57,34,76,106,93,65,101,86,1,56,31,1,57,31,1,56,30,
  1,57,31,85,111,100,145,154,151,7,57,35,6,18,37,247,232,17,
  247,232,17,12,19,48,4,54,31,115,133,126,120,135,130,2,56,31,
  1,57,31,0,57,31,1,57,32,4,57,34,1,57,32,1,57,31,
  1,57,31,2,57,32,6,60,35,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,7,58,35,130,142,138,154,153,139,
  106,98,17,117,107,8,116,105,8,117,109,6,141,133,17,154,144,25,
  152,142,22,153,144,23,154,145,22,147,139,17,151,140,24,147,142,18,
  142,138,16,149,147,23,138,136,16,141,137,16,150,145,22,152,148,23,
  139,134,14,132,126,8,148,143,20,152,147,25,157,151,28,151,142,21,
  146,137,16,152,142,17,158,148,19,157,149,20,152,145,16,144,136,13,
  136,127,9,126,115,6,108,99,3,105,97,3,119,111,5,139,130,11,
  148,140,14,148,140,17,147,139,15,154,145,17,146,137,16,120,113,34,
  158,157,151,83,112,100,2,56,31,0,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,6,58,35,1,57,32,1,57,31,
  1,57,31,1,56,31,7,60,36,1,57,31,1,57,31,1,57,30,
  3,57,33,127,139,135,106,125,117,6,55,34,16,19,53,247,232,17,
  247,232,17,12,10,51,13,55,38,67,99,86,152,158,156,19,67,45,
  1,56,31,1,56,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,56,31,43,83,68,158,160,159,
  134,132,98,103,93,6,103,92,4,103,92,3,127,113,9,139,127,14,
  146,134,15,143,131,14,133,121,9,131,121,8,146,135,19,149,143,26,
  142,135,18,145,137,20,140,135,18,147,139,22,152,144,25,155,148,28,
  139,132,18,129,124,10,142,135,21,138,132,15,138,131,16,138,125,16,
  138,126,19,143,132,21,146,135,16,149,137,15,148,136,17,136,124,10,
  127,115,6,119,108,6,102,93,3,103,94,2,107,97,4,115,103,4,
  128,118,8,135,126,10,134,124,12,143,130,13,125,114,15,141,139,114,
  139,149,145,12,62,42,1,56,31,0,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,56,31,
  24,70,50,154,160,158,58,92,78,11,49,38,9,7,51,247,232,17,
  247,232,17,6,4,46,22,48,53,22,68,49,154,158,157,67,98,85,
  1,57,31,0,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,32,1,57,30,2,56,32,95,119,110,
  161,160,155,126,117,60,111,96,9,100,87,2,111,97,5,126,113,5,
  137,124,12,132,119,8,119,105,4,113,102,3,122,112,5,127,118,14,
  120,111,9,123,113,11,131,125,18,142,133,24,137,127,18,146,136,22,
  147,137,27,141,133,22,136,126,22,117,108,10,108,98,4,116,101,6,
  129,115,17,138,124,21,130,115,11,130,115,9,135,122,14,121,109,5,
  117,104,3,116,102,4,105,92,3,110,97,4,111,96,7,109,93,3,
  119,106,5,122,106,5,111,97,3,112,101,7,122,118,74,158,161,157,
  52,88,73,0,57,30,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,32,
  73,103,91,150,156,154,16,64,44,12,31,41,6,4,46,247,232,17,
  247,232,17,6,4,46,16,25,48,3,54,32,117,132,126,121,136,130,
  3,57,32,2,56,30,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,0,57,31,2,56,32,1,57,30,10,61,40,
  130,143,138,157,156,146,120,110,42,107,95,6,111,96,4,124,110,5,
  126,110,9,121,106,4,118,102,5,107,95,5,105,92,3,110,97,5,
  97,86,3,91,81,3,103,94,9,112,101,10,111,99,8,123,111,16,
  129,116,19,123,112,15,122,108,15,106,93,11,97,84,5,108,90,9,
  119,104,13,134,117,23,130,113,19,125,108,13,121,104,9,116,99,4,
  115,100,5,120,104,6,118,101,8,119,104,5,118,102,6,114,98,6,
  111,96,5,109,94,4,109,97,6,108,100,46,157,159,154,93,116,108,
  2,56,31,1,56,33,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,5,57,34,
  126,140,136,106,126,117,6,53,32,8,11,43,6,4,46,247,232,17,
  247,232,17,6,4,46,9,8,49,7,48,34,56,92,77,156,160,159,
  31,75,56,2,56,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,0,57,31,1,56,31,
  1,57,31,1,57,31,1,57,31,1,56,31,1,57,31,1,57,31,
  28,72,53,146,154,151,154,153,135,120,104,30,122,103,10,127,110,10,
  120,104,6,122,105,5,120,103,5,106,93,4,104,90,5,110,94,6,
  100,87,8,83,71,3,89,77,6,96,83,4,104,90,6,105,94,5,
  97,85,5,95,83,5,106,91,6,106,91,6,96,83,5,94,74,3,
  99,80,5,112,93,11,119,100,13,121,100,14,117,97,10,115,95,7,
  116,99,5,126,107,12,131,112,17,118,101,7,110,93,4,105,88,5,
  96,80,4,101,86,5,112,100,39,154,154,146,122,137,131,7,59,36,
  0,57,31,1,57,31,1,57,30,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,0,57,31,1,57,31,36,78,60,
  156,160,159,46,85,70,11,46,39,8,6,48,6,4,46,247,232,17,
  247,232,17,6,4,46,6,4,46,15,35,47,10,59,38,140,149,146,
  96,119,111,2,56,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,56,32,1,56,32,
  1,57,31,1,57,30,1,57,31,0,57,31,1,57,31,1,57,30,
  1,57,31,42,81,63,152,157,155,153,150,132,121,105,30,122,99,9,
  121,101,5,127,105,8,126,108,7,118,100,7,114,97,5,120,102,14,
  118,103,14,101,88,6,96,82,6,108,93,11,117,100,14,107,92,7,
  98,84,5,100,83,7,107,89,10,103,87,9,104,87,10,99,78,6,
  99,77,5,102,83,6,109,89,9,109,88,8,101,81,5,104,84,6,
  111,93,5,121,100,10,126,105,12,123,103,10,114,94,6,119,97,6,
  117,95,8,107,95,39,153,150,142,134,145,141,17,65,42,1,57,31,
  1,57,31,1,57,32,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,2,56,32,101,122,114,
  133,145,140,7,57,35,15,28,45,6,4,46,6,4,46,247,232,17,
  247,232,17,6,4,46,6,4,46,13,15,51,4,50,30,76,106,94,
  151,157,156,22,69,48,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,56,31,
  19,66,46,60,94,81,77,104,93,70,100,88,42,83,65,5,58,35,
  0,57,32,2,56,32,43,84,67,149,155,152,155,152,135,123,106,40,
  124,100,8,123,98,10,124,103,11,128,109,10,128,109,8,132,113,21,
  129,110,18,113,97,8,106,89,5,119,102,13,123,102,15,109,91,8,
  97,82,5,101,80,5,103,84,6,99,81,5,106,84,6,111,87,11,
  105,82,8,103,80,5,115,93,13,121,101,13,107,88,5,106,84,7,
  107,85,6,113,90,7,122,100,5,129,105,6,118,99,9,117,96,10,
  119,107,50,154,153,146,131,144,140,21,68,47,1,57,31,1,57,31,
  3,56,32,1,56,32,1,56,30,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,23,69,50,152,158,156,
  67,99,86,7,49,33,12,12,50,6,4,46,6,4,46,247,232,17,
  247,232,17,6,4,46,6,4,46,6,4,46,10,35,39,16,64,43,
  146,153,151,93,117,107,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,5,57,34,77,108,95,
  152,156,155,160,161,161,161,161,161,159,162,161,159,161,161,123,138,132,
  30,72,54,1,56,30,1,57,32,38,77,59,141,150,148,158,157,148,
  125,113,64,107,86,10,118,95,6,129,106,12,132,111,11,126,106,14,
  121,101,11,109,91,7,106,88,5,112,94,5,117,97,8,110,92,8,
  101,83,6,107,87,5,115,95,8,115,94,9,113,89,10,110,87,12,
  106,82,7,107,81,6,116,91,8,120,95,7,123,100,10,117,96,7,
  115,91,7,118,95,10,128,104,7,123,99,9,105,86,13,122,112,76,
  157,158,152,121,136,131,17,65,42,1,57,32,0,57,31,10,59,39,
  103,125,116,62,95,82,2,56,32,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,94,118,108,141,150,147,
  12,60,40,15,35,44,6,4,46,6,4,46,6,4,46,247,232,17,
  247,232,17,6,4,46,6,4,46,6,4,46,13,16,50,5,54,32,
  80,108,97,153,157,156,28,72,53,1,57,31,1,56,31,1,57,31,
  1,57,31,1,57,31,1,57,31,2,56,31,80,110,98,159,161,161,
  161,161,162,160,162,161,161,161,161,161,162,162,162,161,161,161,162,161,
  146,154,150,30,73,56,1,56,31,0,57,31,20,67,46,120,135,130,
  160,161,158,139,130,104,119,99,30,129,104,12,131,106,13,122,100,9,
  113,93,7,105,89,4,109,89,7,114,93,6,119,99,9,115,94,7,
  108,89,6,113,93,6,120,101,9,122,99,10,113,90,7,103,80,5,
  101,78,3,113,92,7,123,98,10,120,96,9,125,101,10,120,98,7,
  119,95,6,122,99,9,127,103,10,115,99,33,137,132,114,157,161,157,
  94,117,108,8,59,35,1,57,32,0,57,31,13,63,41,119,134,128,
  160,161,162,148,155,153,23,70,50,0,57,31,1,56,31,1,56,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,56,32,1,57,30,26,71,51,152,158,156,70,101,89,
  8,53,36,14,15,53,6,4,46,6,4,46,6,4,46,247,232,17,
  247,232,17,6,4,46,6,4,46,6,4,46,8,6,48,14,38,41,
  13,62,41,140,149,146,110,128,122,2,56,31,1,57,31,0,57,31,
  0,57,31,1,56,32,1,57,30,15,65,43,149,156,153,159,162,161,
  162,161,161,155,158,156,90,114,105,68,100,87,102,122,114,156,161,160,
  161,161,161,124,139,133,2,56,32,1,57,31,1,57,31,6,58,36,
  78,107,96,153,157,154,158,157,147,135,124,79,117,97,19,111,92,8,
  107,85,7,104,83,5,111,91,9,119,98,9,127,105,8,120,100,8,
  111,90,7,114,91,7,113,91,7,114,92,5,116,94,8,116,90,9,
  114,88,8,112,87,6,121,94,9,123,100,13,114,92,9,117,93,10,
  120,100,10,117,97,25,134,125,90,157,157,151,141,149,147,54,89,75,
  2,56,31,1,57,31,1,56,31,18,65,44,128,141,135,161,161,161,
  146,153,152,39,81,63,1,56,31,1,56,31,0,57,31,0,57,31,
  1,57,31,1,56,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,56,31,1,56,31,2,57,32,108,127,120,135,146,142,10,59,39,
  27,47,55,6,4,46,6,4,46,6,4,46,6,4,46,247,232,17,
  247,232,17,6,4,46,6,4,46,6,4,46,6,4,46,12,13,50,
  3,49,31,61,94,80,157,161,160,52,88,73,2,56,30,1,57,31,
  1,56,31,1,57,32,1,57,31,56,92,77,161,162,161,161,162,162,
  157,160,159,47,85,69,1,56,32,1,57,31,1,56,32,59,92,79,
  159,161,161,160,161,161,29,75,56,1,57,31,0,57,31,1,57,29,
  1,57,33,25,71,50,105,125,118,158,160,159,157,155,144,137,129,93,
  113,98,31,105,86,10,105,86,6,114,94,7,119,97,6,121,99,11,
  105,86,7,96,75,5,112,91,8,114,92,8,114,94,9,107,85,4,
  103,80,3,103,80,5,103,80,7,107,85,7,101,79,10,100,86,36,
  129,122,96,158,157,150,150,156,154,84,110,100,11,62,40,1,57,30,
  1,56,30,1,57,31,23,70,50,136,146,142,160,162,161,142,151,148,
  31,74,56,1,57,31,35,76,59,43,84,67,1,57,32,1,57,30,
  1,57,30,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,30,50,87,71,156,161,160,53,88,73,13,55,39,
  6,5,44,6,4,46,6,4,46,6,4,46,6,4,46,247,232,17,
  247,232,17,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  9,25,41,5,56,34,117,133,126,140,149,145,15,64,42,1,57,31,
  1,56,31,1,57,31,0,57,31,77,105,94,161,162,162,162,161,162,
  116,132,126,2,56,33,2,56,30,1,57,30,1,57,31,3,56,33,
  109,129,121,100,123,113,21,69,47,2,56,32,1,56,33,0,56,32,
  2,56,31,2,56,31,2,57,32,30,74,56,98,122,111,147,155,152,
  160,161,156,145,142,127,125,116,85,110,97,43,100,85,18,99,80,10,
  94,74,8,90,71,6,100,79,7,100,80,8,94,75,8,98,78,8,
  102,83,11,103,87,24,102,90,47,122,115,87,148,145,134,159,161,159,
  138,148,144,83,110,100,18,64,44,2,56,31,2,56,30,1,57,32,
  0,57,32,30,75,56,142,151,147,161,161,162,160,161,161,54,88,73,
  1,57,31,54,89,75,151,156,155,150,156,154,37,78,61,1,56,31,
  0,57,31,1,57,31,1,57,31,1,57,31,1,57,31,1,56,32,
  0,57,30,12,62,40,138,148,144,109,128,120,5,55,34,9,21,43,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,247,232,17,
  247,232,17,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,5,46,9,43,37,28,71,52,149,156,154,104,124,116,3,56,32,
  1,57,31,1,57,30,1,57,31,70,101,89,161,162,162,162,161,162,
  89,114,105,1,56,32,0,57,31,0,57,31,1,56,31,1,56,31,
  5,59,35,2,56,32,23,68,49,68,100,86,83,110,100,74,103,90,
  37,79,62,4,57,33,1,56,31,1,56,31,2,56,32,12,62,41,
  60,93,80,110,128,122,148,155,153,160,160,158,158,158,151,154,152,143,
  140,137,123,139,136,116,140,136,115,140,137,115,137,134,115,141,139,125,
  154,153,144,158,159,155,160,161,160,141,149,146,97,120,112,45,85,67,
  6,58,34,1,56,32,0,57,30,1,57,31,2,56,32,19,66,46,
  35,78,59,28,74,54,149,155,152,161,161,161,160,161,161,141,149,146,
  85,110,100,157,160,158,161,161,161,117,134,126,14,64,43,1,57,32,
  2,57,32,1,56,31,1,57,31,1,57,31,1,57,31,1,57,32,
  2,56,32,100,121,113,148,154,152,23,68,48,16,48,44,10,9,49,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,247,232,17,
  247,232,17,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,21,27,55,3,51,31,64,97,84,158,161,160,66,97,84,
  1,57,32,1,56,30,1,57,31,38,80,62,160,161,160,162,162,162,
  123,137,132,5,58,35,1,57,30,1,57,32,0,57,31,2,56,31,
  6,58,36,89,113,102,153,159,157,161,161,161,161,161,162,161,162,162,
  158,161,160,123,139,133,31,75,57,2,56,32,1,56,31,1,57,31,
  1,57,31,1,57,31,8,60,36,33,77,57,64,97,83,91,115,104,
  111,130,122,128,140,135,132,142,138,131,142,138,124,139,132,105,126,118,
  85,111,100,57,91,76,24,71,50,7,57,35,2,56,31,2,56,30,
  1,57,31,0,57,31,1,56,32,16,64,43,83,110,99,148,155,153,
  141,150,147,14,63,42,56,91,76,159,161,160,160,161,161,161,161,161,
  161,161,161,159,162,161,96,120,110,8,59,36,2,55,32,54,89,74,
  122,138,131,20,67,47,1,57,31,1,57,31,1,57,31,1,56,32,
  59,93,79,156,160,159,57,91,77,10,55,36,22,26,58,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,247,232,17,
  247,232,17,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,10,25,41,5,56,32,102,123,114,151,158,157,
  38,78,62,1,56,31,1,57,30,4,56,33,118,135,128,161,162,162,
  160,161,161,94,117,107,11,60,38,1,56,32,1,57,30,3,56,32,
  94,119,110,160,161,161,161,161,162,160,162,161,160,162,161,160,162,161,
  160,161,161,160,161,161,146,153,151,32,75,57,1,57,31,1,57,30,
  1,57,31,1,57,31,1,56,32,1,56,32,1,57,32,1,56,31,
  2,56,32,3,56,32,3,55,32,3,56,32,3,56,32,1,56,32,
  1,57,32,1,57,32,0,57,32,1,56,32,1,57,31,0,57,31,
  1,57,31,21,67,46,85,111,101,145,153,151,161,161,161,158,161,160,
  121,136,130,26,73,52,2,57,33,88,114,103,160,161,161,161,161,161,
  161,162,162,142,150,147,13,60,40,4,58,33,82,109,96,156,160,159,
  160,161,162,104,127,117,2,56,32,1,56,30,1,57,30,32,75,56,
  149,156,154,97,120,111,5,55,32,17,30,49,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,247,232,17,
  247,232,17,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,4,32,31,11,61,40,129,141,137,
  142,151,148,22,68,48,0,57,31,1,57,31,22,69,49,137,146,142,
  160,161,161,160,161,161,140,150,146,104,125,116,9,61,37,40,80,63,
  159,161,160,161,162,162,161,161,162,129,142,136,37,78,60,21,68,49,
  74,104,92,158,160,158,161,161,161,118,134,128,3,57,33,1,56,31,
  10,61,38,13,62,40,2,56,31,1,56,31,1,57,30,1,57,31,
  0,57,31,0,57,31,0,57,31,0,57,30,0,57,31,1,57,31,
  1,56,31,2,56,31,2,56,31,2,56,31,1,56,31,10,62,39,
  96,119,109,151,156,154,160,161,161,158,161,160,118,133,127,45,84,67,
  4,58,34,1,57,32,1,56,31,6,58,35,120,135,129,161,162,162,
  161,162,162,160,161,161,101,121,112,108,128,119,160,161,161,161,161,161,
  123,139,132,17,65,44,1,57,31,0,57,31,17,65,45,139,148,144,
  125,139,133,10,60,39,11,36,42,7,5,47,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,247,232,17,
  247,232,17,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,14,14,52,9,46,35,22,68,49,
  141,151,148,131,144,138,16,65,42,1,56,31,1,56,31,19,66,46,
  100,123,114,152,157,155,160,161,161,95,118,108,1,56,32,94,118,109,
  162,161,162,160,162,162,145,153,150,21,67,47,1,57,31,1,56,31,
  3,56,32,125,139,133,161,161,161,157,160,159,30,74,54,1,57,31,
  83,111,100,149,156,154,131,143,138,102,122,114,73,103,91,45,84,67,
  20,66,45,5,59,35,1,56,31,12,62,40,25,68,49,43,83,66,
  62,96,82,84,111,100,105,124,117,126,139,134,76,106,95,6,57,35,
  139,148,144,161,161,162,161,161,161,102,122,113,4,56,34,1,57,32,
  23,68,47,65,99,85,1,56,32,2,57,31,20,65,46,141,151,148,
  162,161,161,160,162,161,161,161,161,161,161,162,160,161,161,112,130,123,
  12,62,40,1,57,30,1,56,30,12,62,40,125,138,134,140,150,146,
  21,68,48,16,51,43,7,6,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,247,232,17,
  247,232,17,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,9,12,46,5,48,33,
  34,76,57,148,154,152,124,138,132,14,64,41,1,57,31,1,57,31,
  2,56,31,17,65,44,40,83,65,13,65,42,2,56,31,116,133,126,
  161,161,162,160,161,161,85,112,100,1,57,31,1,56,31,1,57,31,
  2,56,31,104,123,115,161,161,161,160,161,161,60,94,80,2,57,32,
  123,137,131,162,161,162,162,161,162,162,161,162,160,162,162,160,161,161,
  156,159,158,121,137,129,4,56,33,126,142,136,158,161,160,159,162,161,
  161,162,161,162,162,162,161,162,162,161,162,161,117,134,128,2,55,32,
  81,108,97,161,162,162,162,162,162,143,152,149,50,85,71,100,122,112,
  152,157,156,157,160,160,35,77,59,1,57,30,0,57,31,42,81,65,
  155,158,157,161,162,161,161,161,161,159,160,160,95,119,110,8,58,36,
  1,57,30,0,57,30,11,61,40,117,134,127,148,154,151,32,75,56,
  4,45,32,5,8,41,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,247,232,17,
  247,232,17,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,23,29,60,
  10,55,38,42,81,63,149,156,154,126,140,134,18,65,44,0,57,31,
  1,57,30,1,56,30,1,56,32,1,57,31,2,56,32,114,131,125,
  162,161,161,160,162,162,59,92,78,1,56,31,1,57,31,0,57,31,
  3,56,33,123,137,131,161,161,161,161,161,162,61,95,81,13,61,40,
  152,158,157,160,162,162,161,162,162,158,160,160,161,161,161,160,162,161,
  160,162,162,120,136,130,3,55,32,126,141,135,160,161,161,160,162,162,
  161,161,161,158,161,159,150,157,155,137,148,144,102,124,115,4,57,33,
  23,71,51,156,159,158,162,161,162,161,161,162,160,161,161,161,161,161,
  155,159,158,109,128,120,26,74,54,1,57,31,0,57,31,2,56,31,
  70,103,89,160,161,161,154,158,157,69,101,87,3,56,33,1,57,31,
  1,56,31,14,63,41,119,136,129,150,156,153,41,81,64,11,56,40,
  17,21,54,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,247,232,17,
  247,232,17,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  5,13,36,5,52,31,38,79,61,147,153,151,131,143,139,23,68,49,
  1,56,32,0,57,31,1,57,31,1,57,30,2,56,32,81,109,98,
  159,162,161,161,161,162,82,109,98,2,56,31,2,56,31,1,56,32,
  48,85,70,157,160,159,161,161,161,159,160,160,32,76,58,45,83,67,
  160,161,162,161,162,162,158,161,161,36,75,59,43,83,66,70,101,88,
  98,119,111,76,105,93,3,56,32,116,133,127,161,161,162,161,162,161,
  98,119,111,27,71,52,11,60,38,3,55,32,1,56,32,1,57,31,
  2,56,31,114,132,125,161,161,161,161,162,161,160,161,160,101,122,113,
  29,73,53,2,56,31,1,57,32,11,61,39,4,58,33,1,56,30,
  3,57,33,86,114,102,40,80,63,1,56,32,1,57,31,0,57,31,
  20,67,47,127,140,135,145,154,150,39,79,62,5,52,33,11,18,43,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,247,232,17,
  247,232,17,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,31,38,64,10,55,39,33,76,58,141,151,148,141,150,147,
  36,76,60,1,56,32,0,57,31,1,56,31,0,57,32,22,67,48,
  153,157,155,161,161,162,153,158,156,67,98,83,27,73,52,61,95,81,
  149,155,153,161,161,162,161,162,162,122,138,132,4,57,34,83,110,98,
  162,161,162,161,162,162,145,153,150,22,67,48,5,56,32,1,57,32,
  1,56,31,0,57,31,1,56,31,107,126,118,162,161,162,162,161,161,
  101,120,112,8,57,35,25,69,49,42,81,65,30,75,56,0,57,31,
  1,57,31,53,91,75,160,162,161,161,161,162,161,162,162,63,95,82,
  2,56,31,24,69,48,90,114,103,146,154,152,58,94,80,1,56,32,
  1,56,31,1,56,32,1,57,31,1,57,31,2,56,31,34,76,57,
  138,149,145,141,150,147,31,75,57,12,56,40,26,33,61,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,247,232,17,
  247,232,17,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,22,28,59,8,52,37,22,69,49,131,142,138,
  151,157,156,62,94,80,2,56,31,1,57,31,1,56,31,1,56,31,
  63,95,81,156,160,159,161,161,161,160,162,161,159,161,161,161,161,161,
  162,161,161,161,161,161,150,155,153,32,75,56,2,57,32,122,137,131,
  161,162,161,161,162,162,161,161,162,158,161,161,145,153,149,118,134,126,
  53,90,74,1,56,31,0,57,31,98,119,110,161,161,162,161,162,161,
  157,160,159,155,161,159,159,162,161,160,161,161,104,125,117,2,56,31,
  0,57,31,9,60,37,143,151,148,161,161,162,161,162,162,135,146,141,
  109,128,120,156,160,159,161,162,162,160,161,161,120,139,133,2,56,33,
  1,57,31,1,57,31,0,57,31,2,56,31,59,94,79,151,157,154,
  127,142,135,22,68,48,4,47,32,18,23,54,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,247,232,17,
  247,232,17,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,8,11,46,10,47,36,12,61,41,
  105,126,118,159,161,160,99,122,113,13,61,40,1,57,30,1,57,30,
  1,56,33,44,83,66,134,145,141,160,162,161,162,161,161,161,162,161,
  160,162,161,130,144,139,36,77,60,1,57,31,13,62,40,152,157,155,
  161,162,162,161,161,162,160,162,161,161,161,161,161,161,162,161,161,161,
  70,102,89,1,56,31,1,57,31,87,113,102,161,162,162,161,161,161,
  161,162,161,162,161,161,161,162,161,159,161,160,124,141,135,3,57,32,
  1,57,31,2,56,31,87,114,103,161,162,162,162,162,162,161,161,162,
  162,161,162,160,162,161,146,153,151,78,106,95,12,60,39,1,56,32,
  1,57,31,1,56,31,12,61,40,99,121,112,156,162,160,101,124,116,
  11,60,39,21,60,47,6,8,41,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,247,232,17,
  247,232,17,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,15,16,52,8,36,36,
  5,56,33,69,100,89,151,157,156,138,147,143,45,85,67,2,55,31,
  1,57,30,1,57,31,4,57,34,39,80,62,64,99,84,66,100,86,
  44,84,67,6,58,35,1,56,31,1,57,30,44,84,66,160,162,161,
  161,161,162,161,161,161,71,102,89,60,96,81,87,112,102,112,130,122,
  41,82,64,1,57,31,1,57,31,76,105,94,161,162,162,162,162,162,
  157,159,159,70,101,88,46,86,69,25,70,51,7,57,36,1,57,31,
  1,57,32,0,57,30,30,74,55,157,159,158,162,161,162,159,162,161,
  137,148,143,72,104,90,11,60,39,1,57,32,0,57,31,1,57,31,
  2,56,31,46,85,69,136,147,143,149,155,154,66,96,84,5,55,33,
  20,47,47,17,18,55,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,247,232,17,
  247,232,17,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,9,7,50,
  17,35,48,5,54,33,33,74,55,122,138,132,157,160,160,103,124,116,
  22,68,49,1,56,32,1,57,31,1,56,30,1,57,31,1,56,32,
  1,56,31,1,57,31,1,56,30,1,56,31,84,110,99,161,162,161,
  161,162,161,153,160,158,13,60,38,1,57,30,1,56,31,1,56,32,
  1,56,31,0,57,31,1,57,31,67,98,85,161,161,162,161,162,162,
  154,158,156,10,60,39,1,57,31,1,57,30,1,57,31,0,57,31,
  1,56,31,1,57,30,3,56,32,117,136,129,118,135,128,56,91,76,
  7,58,36,1,56,31,1,57,30,1,57,31,2,56,32,23,69,50,
  105,125,118,157,160,160,119,135,128,29,73,53,4,50,31,15,31,43,
  7,5,47,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,247,232,17,
  247,232,17,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  7,5,47,18,25,52,7,44,34,7,58,35,69,100,87,145,153,150,
  151,156,154,85,111,100,17,65,44,2,56,31,1,56,31,1,57,31,
  0,57,31,0,57,31,1,57,31,1,56,32,101,123,114,157,161,160,
  161,161,161,121,136,130,2,56,32,1,57,31,0,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,57,92,77,160,162,161,161,162,162,
  156,159,158,16,65,44,0,57,31,1,56,31,0,57,31,1,57,31,
  1,57,31,0,57,31,1,57,31,9,61,39,3,57,33,1,56,31,
  1,56,31,1,56,31,2,56,31,18,66,44,87,113,103,151,157,155,
  143,151,148,63,96,83,7,56,34,12,48,38,20,25,54,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,247,232,17,
  247,232,17,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,11,10,50,18,37,48,6,53,34,17,64,44,
  89,115,104,152,157,155,147,155,153,90,115,105,27,71,52,2,56,32,
  0,57,31,2,56,31,1,57,31,1,56,32,5,57,35,31,75,57,
  68,100,87,51,88,71,0,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,47,86,70,159,161,161,159,162,161,
  151,159,157,21,70,49,0,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,0,57,31,1,57,31,1,56,32,1,56,31,1,57,31,
  3,57,32,29,74,54,93,116,107,149,156,154,150,156,154,85,112,101,
  15,63,42,6,50,33,10,26,40,8,7,47,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,247,232,17,
  247,232,17,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,10,12,49,15,42,43,
  5,57,33,22,69,49,90,115,105,148,154,152,154,159,158,119,134,128,
  61,94,80,15,64,42,2,56,31,1,56,31,1,57,30,1,57,31,
  1,57,31,1,57,31,0,57,30,0,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,11,62,39,39,78,61,27,71,51,
  19,65,45,4,57,33,1,57,31,0,57,31,1,57,31,1,57,31,
  1,56,31,1,56,31,1,56,32,2,56,31,18,66,45,66,98,85,
  121,137,131,155,160,159,146,153,150,86,111,101,20,66,46,6,54,33,
  12,36,40,16,18,54,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,247,232,17,
  247,232,17,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,8,6,49,
  14,19,51,17,45,46,3,52,31,15,63,42,67,99,85,126,139,134,
  156,160,158,148,156,154,114,130,124,67,99,87,29,73,53,7,59,36,
  2,56,32,1,57,31,1,57,31,1,57,31,1,57,31,1,57,31,
  1,57,31,1,57,31,1,57,31,1,57,31,1,57,32,2,56,30,
  1,57,32,1,57,30,1,57,31,1,57,31,1,56,31,2,56,31,
  8,60,37,33,76,57,73,103,91,119,135,129,151,157,155,155,159,158,
  123,137,132,63,96,81,14,62,41,6,53,34,11,36,39,8,12,44,
  8,6,49,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,247,232,17,
  247,232,17,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,11,15,47,17,38,50,7,48,32,5,54,32,
  31,74,56,81,109,97,128,141,136,154,159,157,158,161,160,141,149,147,
  115,132,126,84,110,100,56,92,77,33,76,58,13,62,40,7,59,36,
  3,57,33,2,56,31,2,56,31,2,56,31,2,56,31,4,56,33,
  8,59,36,13,62,40,35,78,59,59,92,78,89,113,103,119,135,129,
  144,151,149,159,162,161,154,158,157,124,138,133,76,106,94,27,72,53,
  4,54,32,14,54,40,13,32,45,17,19,54,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,247,232,17,
  247,232,17,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,11,11,50,20,31,53,
  14,41,45,9,53,35,4,55,31,22,68,48,59,93,79,97,119,111,
  125,139,134,151,156,154,158,161,160,158,162,161,156,160,159,143,150,147,
  132,143,139,123,138,132,122,136,129,121,136,130,123,137,132,133,143,140,
  144,151,148,156,160,159,159,161,161,157,160,159,149,156,154,123,137,131,
  92,116,106,54,91,76,19,66,46,3,54,31,7,50,34,8,34,39,
  10,18,44,6,4,45,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,247,232,17,
  247,232,17,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,13,13,51,12,21,45,12,33,45,11,47,38,4,51,31,
  3,54,32,9,58,36,31,73,54,50,87,70,72,102,89,89,114,105,
  103,123,115,113,129,123,115,131,125,115,131,124,113,129,122,102,123,113,
  88,114,103,71,101,88,48,85,68,27,72,52,7,57,35,3,55,31,
  4,50,30,9,41,36,16,35,48,15,21,48,9,7,49,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,
  6,4,46,6,4,46,6,4,46,6,4,46,6,4,46,247,232,17,
  247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,
  247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,
  247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,
  247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,
  247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,
  247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,
  247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,
  247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,
  247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,
  247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,
  247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,
  247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,
  247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,
  247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,
  247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,247,232,17,
} ;
  
  /** rhdd "logo" **/
  
static unsigned char rhdda_rgb[] = {
  119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,
  119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,
  119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,
  119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,
  119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,
  119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,
  119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,
  119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,
  119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,
  119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,
  119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,
  119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,
  119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,
  119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,
  119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  10,16,180,21,21,94,21,23,113,12,16,128,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,13,8,96,16,21,164,20,23,102,30,31,71,
  61,54,54,117,62,53,106,64,59,68,68,68,49,49,49,27,27,27,
  19,22,96,18,22,117,16,22,186,11,17,181,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,10,15,176,
  18,23,164,39,39,107,50,51,76,55,55,55,49,48,48,69,62,62,
  94,75,75,100,44,43,100,38,38,81,61,59,71,70,70,66,66,66,
  48,48,48,47,47,47,60,60,60,51,51,51,33,35,67,20,22,78,
  13,15,72,16,20,158,12,11,125,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,10,15,158,23,27,146,26,28,68,45,43,56,
  68,62,61,77,71,70,60,60,60,53,52,52,71,65,65,85,77,77,
  134,90,90,150,70,70,152,76,76,142,80,80,71,66,65,66,66,64,
  72,72,72,54,54,54,47,47,47,64,64,64,69,69,69,55,55,55,
  44,43,43,47,45,45,53,54,75,38,39,73,21,22,58,15,20,138,
  11,16,167,8,14,162,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,18,174,
  23,26,122,47,46,58,56,56,60,52,52,52,59,56,56,77,70,68,
  77,72,71,59,59,59,54,52,52,73,66,66,78,72,72,97,68,65,
  128,55,46,122,48,39,117,49,40,120,53,44,110,62,54,56,53,52,
  58,58,56,75,75,74,60,60,60,47,47,47,56,56,56,73,73,73,
  62,62,62,49,48,48,51,50,50,66,65,65,59,59,59,45,45,45,
  42,42,47,53,54,58,44,45,56,25,28,94,13,18,142,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,11,17,175,14,17,108,22,25,96,30,29,29,56,51,49,
  73,67,65,68,67,67,58,57,57,62,59,58,80,72,70,75,71,70,
  58,58,58,54,53,53,76,67,67,77,72,72,80,74,72,130,74,61,
  136,76,62,138,76,62,140,77,63,145,80,65,149,74,58,121,77,70,
  56,54,54,52,52,50,72,72,71,67,67,67,49,49,49,50,50,50,
  69,69,69,66,66,66,52,52,52,48,47,46,62,61,61,65,65,65,
  52,52,52,45,45,45,67,67,67,69,69,69,46,46,46,14,20,179,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,8,13,149,16,19,120,
  32,33,78,51,51,51,52,52,52,49,48,48,68,62,60,76,70,69,
  69,68,67,57,56,56,64,60,59,80,72,70,75,71,70,58,58,58,
  55,54,54,79,69,69,75,70,70,65,65,65,106,62,59,130,52,46,
  130,49,43,136,42,35,135,37,31,134,37,31,134,38,33,132,42,38,
  98,69,68,55,55,55,48,48,47,66,65,64,72,72,72,55,55,55,
  46,46,46,64,64,64,70,70,70,57,57,57,47,47,46,57,56,55,
  67,66,66,57,57,57,46,46,46,58,58,58,71,71,71,42,43,70,
  12,17,180,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,13,16,97,25,25,49,38,36,36,68,58,58,
  71,69,69,63,63,63,53,52,51,69,63,62,76,70,69,69,68,68,
  55,55,55,65,61,61,80,73,71,74,70,70,56,56,56,56,54,54,
  78,69,69,75,71,71,61,61,61,87,67,66,138,60,58,147,52,50,
  146,53,51,149,52,51,151,50,49,152,51,50,153,58,53,157,55,47,
  157,60,48,114,96,89,61,61,61,47,47,47,59,58,57,73,73,73,
  61,61,61,47,47,47,56,56,56,72,72,72,62,62,62,49,49,49,
  51,50,50,66,65,65,61,61,61,48,48,48,51,51,51,70,70,70,
  36,37,67,9,15,185,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,11,17,175,38,39,47,53,49,49,78,67,67,74,71,71,
  62,62,62,54,53,52,71,65,63,76,71,70,68,67,67,56,55,55,
  66,62,61,82,73,71,71,69,69,55,54,54,58,55,55,79,70,70,
  73,70,70,60,60,60,61,54,52,136,55,39,143,44,27,136,47,30,
  127,51,33,124,54,35,130,54,33,130,51,35,129,48,36,129,46,37,
  127,43,38,115,56,54,93,83,82,66,66,66,50,50,50,51,51,50,
  72,72,71,67,67,67,50,50,50,49,49,49,70,70,70,66,66,66,
  52,52,52,47,47,46,62,61,61,65,65,65,53,53,53,45,45,45,
  60,60,60,26,27,55,12,9,111,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,21,23,87,50,46,46,79,69,69,72,70,70,60,60,60,
  55,53,52,73,66,64,76,71,70,66,66,65,56,55,55,68,63,62,
  83,74,72,69,68,67,54,54,54,60,57,57,80,70,70,72,70,70,
  58,58,58,55,54,54,101,55,54,133,48,48,137,56,56,145,57,57,
  152,56,56,152,60,60,153,64,64,151,63,63,145,65,65,139,75,75,
  137,77,77,136,79,79,131,92,88,87,80,79,69,69,69,55,55,55,
  48,48,47,65,65,63,72,72,71,56,56,56,46,46,46,63,63,63,
  70,70,70,57,57,57,47,47,47,57,56,55,66,66,65,57,57,57,
  46,46,46,48,48,48,15,19,110,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,15,102,47,43,43,77,67,67,72,70,70,59,59,59,55,53,52,
  73,66,65,75,70,70,65,64,64,56,55,55,69,64,63,81,73,72,
  69,67,66,54,53,53,61,58,58,81,71,71,71,69,69,58,58,58,
  57,56,55,84,75,74,127,84,84,134,74,74,133,66,66,131,61,61,
  128,57,57,118,56,56,116,62,62,119,65,65,120,62,62,120,59,59,
  126,51,51,129,43,43,126,41,41,119,46,46,75,66,66,70,70,70,
  60,60,60,48,48,48,59,58,56,73,73,72,61,61,61,47,47,47,
  56,56,56,71,71,71,61,61,61,49,49,49,51,50,50,65,65,65,
  61,61,61,48,48,48,32,32,32,9,13,108,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  40,36,44,74,65,65,72,70,70,58,58,58,57,54,53,74,67,66,
  74,70,69,65,64,64,56,55,55,70,65,64,81,74,72,67,66,66,
  53,53,53,63,59,59,81,72,72,70,68,68,57,57,57,56,55,55,
  82,74,73,116,77,77,136,41,41,139,41,41,140,42,42,137,54,54,
  141,60,60,145,64,64,147,69,69,149,74,74,150,66,65,145,63,61,
  140,65,62,135,65,61,131,65,60,132,69,64,107,66,62,60,56,56,
  69,69,69,66,66,66,50,50,50,52,51,50,71,71,70,67,67,67,
  50,50,50,49,49,49,70,70,70,66,66,66,53,53,53,48,47,47,
  61,61,60,65,65,65,51,51,51,28,28,31,9,13,110,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,18,20,102,
  66,61,61,70,69,69,57,57,57,59,56,54,75,68,66,74,70,69,
  63,63,63,57,55,55,72,67,66,81,73,72,65,65,65,52,52,52,
  65,60,60,81,72,72,68,67,67,56,56,56,58,56,56,81,74,74,
  100,87,86,133,71,65,131,67,61,133,73,67,133,67,60,133,59,52,
  134,51,43,136,42,33,129,37,28,127,38,30,128,41,33,127,43,37,
  126,48,42,135,47,41,138,46,41,138,48,43,136,49,46,102,59,57,
  52,50,50,64,64,64,69,69,69,55,55,55,48,47,46,65,64,63,
  72,72,72,56,56,56,46,46,46,62,62,62,70,70,70,58,58,58,
  48,47,47,56,55,54,66,66,66,56,56,56,30,31,50,10,14,136,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,10,15,155,42,41,43,
  67,66,66,55,55,55,60,56,55,76,69,68,73,70,69,61,61,61,
  59,57,56,73,67,66,81,74,72,64,63,63,53,52,52,68,62,62,
  79,71,71,68,67,67,55,55,55,62,59,58,79,73,73,81,76,76,
  119,65,62,137,50,45,138,52,48,139,55,51,140,53,50,141,52,49,
  137,56,54,140,57,54,144,56,54,148,57,55,153,58,56,159,49,47,
  161,46,43,162,43,41,162,41,39,158,42,40,151,47,46,144,50,49,
  90,66,66,49,49,49,58,58,58,70,70,70,61,61,61,48,48,48,
  57,57,55,73,73,72,62,62,62,47,47,47,56,56,56,71,71,71,
  62,62,62,50,50,50,52,50,50,64,64,64,58,58,58,30,30,52,
  10,15,176,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,28,29,78,64,64,64,
  55,55,54,61,57,56,76,69,68,73,70,70,60,60,60,59,57,56,
  75,68,67,79,73,72,62,61,61,53,52,52,69,63,63,80,72,72,
  67,67,67,54,54,54,63,60,59,80,74,73,74,73,73,115,68,67,
  161,42,40,164,36,34,160,34,32,153,37,36,145,41,40,140,41,40,
  133,40,39,134,37,36,139,32,30,139,29,29,138,30,29,136,31,30,
  130,34,34,123,42,42,126,44,44,128,47,47,130,51,51,133,52,52,
  133,54,54,84,71,71,51,51,51,52,52,52,68,68,68,66,66,66,
  51,51,51,52,51,50,69,69,68,68,68,68,51,51,51,49,49,49,
  68,68,68,67,67,67,54,54,54,48,47,47,61,60,60,59,59,59,
  26,27,52,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,10,14,117,48,48,50,53,53,52,
  63,59,57,77,70,69,71,69,69,60,59,59,60,57,57,78,70,68,
  78,72,71,61,60,60,53,52,52,71,64,64,79,72,72,65,65,65,
  54,54,54,64,61,60,81,75,75,71,71,71,78,64,64,124,39,38,
  122,43,43,122,47,47,127,50,50,130,54,53,133,57,57,142,52,52,
  146,49,49,145,50,50,147,50,50,148,49,49,147,58,58,147,71,71,
  151,76,76,154,82,82,156,89,89,157,88,88,150,78,78,140,81,81,
  131,82,82,111,95,95,68,67,67,55,55,55,48,48,48,64,64,64,
  70,70,70,56,56,56,48,47,47,64,64,62,72,72,72,56,56,56,
  47,47,47,62,62,62,71,71,71,57,57,57,48,48,48,55,54,53,
  60,59,60,18,21,103,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,9,15,166,34,34,34,49,49,49,67,61,60,
  76,70,68,71,69,69,58,58,58,61,59,58,79,71,70,76,71,70,
  60,60,60,54,52,52,74,66,66,77,71,71,64,64,64,54,54,54,
  67,62,62,81,76,75,69,69,69,59,58,58,119,78,78,141,80,80,
  142,84,84,143,87,87,149,89,89,148,77,77,142,74,74,135,75,75,
  128,76,76,118,81,81,120,90,90,122,87,87,122,77,77,121,67,67,
  123,54,54,117,45,45,112,43,43,118,44,44,124,45,45,129,50,50,
  137,52,52,147,49,49,130,80,74,79,75,71,59,59,59,48,48,48,
  57,57,57,71,71,71,61,61,61,48,48,48,56,56,54,73,73,73,
  63,63,63,48,48,48,54,54,54,72,72,72,63,63,63,50,50,50,
  50,49,48,52,51,51,18,23,150,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,15,18,98,44,44,43,66,61,59,76,70,69,
  71,69,69,57,57,57,63,60,59,78,71,70,77,72,71,59,59,59,
  55,53,53,76,68,68,76,71,71,63,63,63,53,53,53,70,65,64,
  79,75,75,68,68,68,54,54,54,73,51,51,118,63,63,124,58,58,
  127,47,47,121,43,43,125,43,43,130,44,44,133,46,46,136,54,54,
  145,54,54,147,57,57,148,61,61,149,63,63,147,59,59,141,65,64,
  137,68,67,136,69,67,135,70,68,139,74,72,143,68,65,144,60,56,
  141,58,53,139,56,51,132,58,50,111,66,59,72,68,68,62,62,62,
  51,51,51,51,51,51,68,68,68,66,66,66,51,51,51,51,51,49,
  70,69,68,68,68,68,51,51,51,49,49,49,67,67,67,68,68,68,
  54,54,54,47,46,46,34,34,50,11,16,166,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,10,16,173,36,36,50,66,60,59,76,70,68,71,70,70,
  56,55,55,63,60,59,80,72,70,75,71,70,57,57,57,55,53,53,
  77,68,68,76,71,71,62,62,62,52,52,52,73,67,66,79,75,75,
  68,68,68,52,52,52,72,65,65,138,70,70,145,64,63,139,68,66,
  135,68,66,131,69,65,131,72,68,137,73,69,139,63,58,139,58,52,
  140,53,46,136,49,41,127,49,42,127,55,49,126,56,50,125,56,50,
  125,55,49,133,48,41,133,43,36,133,42,36,135,42,37,136,43,37,
  133,50,46,135,55,51,140,57,54,140,60,57,111,72,71,64,63,63,
  65,65,65,55,55,55,49,49,49,63,63,63,70,70,70,56,56,56,
  48,48,47,63,63,61,73,73,73,56,56,56,47,47,47,61,61,61,
  71,71,71,58,58,58,45,45,45,24,24,38,9,14,171,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,27,29,90,65,59,57,77,71,70,69,68,68,55,55,55,
  65,61,60,82,73,71,74,71,71,55,54,54,57,54,54,78,69,69,
  75,71,71,60,60,60,53,52,52,74,68,67,79,75,75,67,67,67,
  51,51,51,67,61,61,110,83,81,125,46,39,126,49,43,126,52,46,
  133,50,44,138,46,40,138,46,41,139,46,41,139,46,41,136,50,46,
  132,58,55,137,59,57,140,61,59,145,64,61,149,63,60,154,54,50,
  152,54,50,151,53,50,150,52,49,148,53,50,148,60,56,150,56,50,
  151,51,44,152,46,37,154,41,30,150,36,26,142,40,30,81,57,53,
  57,57,57,67,67,67,59,59,59,48,48,48,57,57,57,70,70,70,
  62,62,62,48,48,48,55,55,53,74,74,73,63,63,63,48,48,48,
  53,53,53,72,72,72,63,63,63,46,46,46,20,20,45,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  13,17,131,59,54,54,75,70,69,67,66,66,56,55,55,66,62,61,
  83,74,72,71,69,68,55,55,55,59,56,56,80,70,70,74,71,71,
  59,59,59,55,54,54,75,69,68,78,76,76,64,64,64,52,52,52,
  69,63,63,99,92,92,141,75,73,149,62,59,155,54,50,156,51,45,
  156,50,44,154,50,43,151,49,44,147,56,50,145,58,51,143,54,46,
  143,49,41,146,44,34,147,38,27,142,35,25,139,38,28,135,41,31,
  130,46,36,127,50,40,133,51,39,133,52,41,133,53,44,134,53,44,
  134,51,43,127,55,50,130,57,52,135,57,52,140,58,53,139,68,64,
  80,67,67,52,52,52,66,66,66,62,62,62,51,51,51,51,51,51,
  68,68,68,67,67,67,52,52,52,50,50,48,70,70,68,69,69,69,
  52,52,52,48,48,48,67,67,67,68,68,68,49,49,49,21,23,59,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  34,33,64,70,66,65,66,65,65,56,55,55,68,63,63,82,73,72,
  70,68,67,55,54,54,59,56,56,81,71,71,72,70,70,59,59,59,
  55,54,54,78,71,70,76,75,74,64,64,64,52,51,51,72,66,66,
  86,82,82,124,83,77,139,39,29,138,39,29,136,41,31,133,43,34,
  126,50,41,130,53,43,132,55,45,133,57,49,134,58,51,139,54,47,
  136,54,48,136,55,50,140,55,50,144,55,50,146,63,59,152,69,64,
  158,71,67,159,77,72,161,82,79,159,81,78,153,78,75,145,86,84,
  141,89,86,136,91,89,136,94,93,142,96,94,141,83,81,138,77,76,
  120,74,73,67,58,56,48,48,48,62,62,62,65,65,65,55,55,55,
  48,48,48,63,63,63,70,70,70,56,56,56,48,48,47,63,62,61,
  73,73,73,57,57,57,46,46,46,60,60,60,71,71,71,52,52,52,
  17,20,91,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,23,27,145,
  62,59,58,66,65,65,56,55,55,69,64,63,81,73,72,69,67,67,
  53,53,53,61,57,57,80,71,71,71,69,69,58,58,58,54,54,53,
  79,72,71,76,74,74,63,63,63,49,49,49,77,69,69,82,80,80,
  98,80,79,144,55,50,149,53,47,150,58,53,151,72,68,157,77,73,
  160,84,80,163,91,88,163,94,92,157,84,82,147,87,85,138,89,88,
  130,91,89,124,92,91,130,99,97,134,89,88,133,77,77,133,69,68,
  131,60,59,121,58,57,118,62,61,121,65,64,123,65,64,125,64,64,
  132,57,56,137,48,48,135,45,45,138,45,44,141,44,43,142,48,48,
  142,60,60,130,85,84,65,65,65,47,47,47,56,56,56,68,68,68,
  58,58,58,48,48,48,56,56,56,71,71,71,62,62,62,48,48,48,
  55,55,54,74,74,73,63,63,63,48,48,48,53,53,53,71,71,71,
  54,54,54,19,24,166,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,48,49,82,
  62,62,62,57,55,55,71,66,64,82,74,72,67,66,66,53,52,52,
  64,59,59,80,71,71,70,69,69,56,56,56,58,56,55,79,72,71,
  75,74,74,62,62,62,51,50,50,78,71,71,81,79,79,72,69,68,
  108,89,89,124,96,96,129,97,96,128,84,84,127,73,73,127,60,60,
  121,50,50,113,48,47,118,50,50,123,52,51,128,53,53,134,55,55,
  146,49,49,146,50,49,147,51,51,147,52,52,145,52,52,140,64,64,
  140,70,69,143,72,72,145,75,75,150,79,79,151,68,68,146,64,64,
  139,65,65,132,65,65,125,67,67,124,74,74,127,75,75,128,65,65,
  128,57,57,128,47,47,106,61,61,64,64,64,49,49,49,50,50,50,
  67,67,67,63,63,63,51,51,51,50,50,50,68,68,68,67,67,67,
  52,52,51,49,49,48,70,70,69,70,70,70,52,52,52,47,47,47,
  67,67,67,48,48,55,11,16,161,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,28,29,68,55,55,55,
  57,56,55,71,66,65,82,74,72,65,64,64,53,52,52,65,61,61,
  81,72,72,69,68,68,56,56,56,60,58,57,79,73,72,75,74,74,
  60,60,60,54,52,52,78,72,72,80,79,79,66,65,65,107,69,67,
  147,55,55,150,59,59,150,62,62,149,59,59,142,64,64,138,70,70,
  137,72,72,137,73,73,140,77,77,145,73,73,144,62,62,140,60,60,
  135,59,59,129,58,58,122,63,63,125,69,69,125,64,64,124,58,58,
  125,50,50,128,40,40,122,35,35,123,36,36,126,38,38,129,40,40,
  130,47,47,139,47,47,143,48,48,143,51,51,143,54,54,144,51,51,
  140,55,55,137,59,59,138,63,63,113,91,89,70,69,69,53,53,53,
  47,47,47,62,62,62,65,65,65,56,56,56,48,48,48,62,62,62,
  70,70,70,56,56,56,48,47,47,62,62,60,73,73,73,57,57,57,
  46,46,46,58,58,58,44,45,57,9,14,156,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,14,19,154,47,47,49,57,55,54,
  74,67,66,80,74,72,63,63,62,53,52,52,67,62,62,81,72,72,
  67,66,66,55,55,55,61,58,57,81,74,74,73,72,72,59,59,59,
  54,52,52,80,73,73,80,79,79,62,62,62,69,52,52,127,56,56,
  132,50,50,122,50,50,122,57,57,107,52,63,86,41,59,88,35,53,
  118,38,48,130,38,38,128,37,37,131,38,38,104,36,55,80,30,59,
  84,30,58,87,29,57,87,30,58,85,31,59,100,38,59,146,54,54,
  112,47,61,17,15,40,123,53,66,142,58,58,146,60,60,116,47,58,
  99,40,58,146,42,45,149,39,40,104,38,53,93,41,59,95,39,57,
  96,34,52,98,29,47,102,25,44,131,37,41,103,66,64,73,72,72,
  57,57,57,48,48,48,56,56,56,67,67,67,59,59,59,49,49,49,
  56,56,56,70,70,70,62,62,62,49,49,48,55,55,54,72,72,72,
  64,64,64,48,48,48,48,48,48,23,24,63,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,10,16,186,28,29,57,55,53,52,75,68,67,
  79,73,71,63,62,62,53,52,52,69,63,63,79,72,72,66,66,66,
  54,54,54,62,59,58,80,74,74,72,72,72,58,58,58,53,51,51,
  83,76,76,78,77,77,61,61,61,56,52,52,116,48,48,134,53,53,
  139,57,57,143,61,61,144,64,66,62,30,58,17,15,40,17,15,40,
  102,42,59,142,55,55,141,54,54,143,59,59,63,31,58,17,15,40,
  17,15,40,17,15,40,17,15,40,17,15,40,80,28,53,129,41,41,
  62,27,57,17,15,40,59,22,41,134,33,34,133,33,35,17,15,40,
  17,15,40,123,46,48,126,48,54,39,21,48,17,15,40,17,15,40,
  17,15,40,17,15,40,26,17,43,142,46,56,148,50,49,97,70,67,
  74,73,73,62,62,62,50,50,50,50,50,50,66,66,66,63,63,63,
  51,51,51,50,50,50,68,68,68,68,68,68,51,51,51,50,50,49,
  69,69,67,70,70,70,51,51,51,39,39,39,13,15,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,19,20,71,53,50,50,76,69,68,79,73,71,
  61,61,61,53,52,52,72,65,65,78,71,71,65,65,65,54,54,54,
  65,61,61,80,75,74,70,70,70,57,57,57,57,54,54,84,77,77,
  76,75,75,59,59,59,55,52,52,103,66,62,139,51,51,141,45,45,
  143,37,37,143,27,27,115,24,38,24,16,44,41,21,53,17,15,40,
  93,33,49,134,38,38,136,40,40,131,40,46,37,19,44,23,17,41,
  124,45,60,127,49,59,130,52,62,132,54,64,140,58,61,150,52,51,
  25,17,41,17,15,40,51,25,51,152,52,48,145,57,53,17,15,40,
  58,30,50,149,64,40,150,63,34,135,61,46,120,52,56,17,15,40,
  17,15,40,105,50,59,100,52,59,128,68,34,128,64,35,115,55,38,
  67,57,55,70,70,70,68,68,68,53,53,53,47,47,47,61,61,61,
  66,66,66,56,56,56,47,47,47,62,62,62,70,70,70,57,57,57,
  47,47,46,62,62,60,73,73,72,58,58,58,38,38,38,12,14,70,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,11,17,163,44,42,41,75,67,66,77,72,71,59,59,59,
  54,53,53,73,66,66,79,72,72,64,64,64,53,53,53,68,63,63,
  79,74,74,70,70,70,55,55,55,60,56,56,83,78,78,74,74,74,
  58,58,58,58,54,54,89,80,79,128,71,67,138,46,46,136,48,48,
  133,52,52,136,52,53,17,15,40,25,17,44,110,46,74,17,15,40,
  111,41,50,159,56,39,159,56,38,139,50,48,31,19,47,47,25,55,
  141,65,40,141,64,35,146,63,29,146,55,25,142,52,25,129,49,42,
  23,17,41,42,21,53,27,19,44,117,58,41,109,53,44,17,15,40,
  69,31,47,127,48,43,124,50,47,129,51,47,108,44,59,17,15,40,
  76,36,61,150,62,57,151,67,61,152,73,65,151,74,66,147,73,63,
  118,79,74,55,53,53,63,62,62,71,71,71,58,58,58,47,47,47,
  56,56,56,66,66,66,60,60,60,49,49,49,56,56,56,70,70,70,
  63,63,63,49,49,49,55,55,53,72,72,71,64,63,63,38,38,38,
  12,15,89,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,23,23,40,73,66,64,76,72,71,58,57,57,55,53,53,
  74,66,66,77,72,72,62,62,62,53,53,53,69,64,63,80,75,75,
  68,68,68,54,54,54,62,58,58,84,79,79,74,74,74,57,57,57,
  60,56,56,88,80,79,128,106,95,148,65,41,142,63,38,136,64,38,
  130,65,37,123,58,40,24,16,42,66,30,51,115,45,53,17,15,40,
  90,39,47,120,55,40,124,58,42,96,46,47,17,15,40,46,22,51,
  84,29,45,79,32,50,79,35,54,109,44,55,141,56,48,101,47,54,
  18,15,40,85,45,65,34,22,51,127,67,75,118,59,74,17,15,40,
  100,60,77,129,83,76,123,83,77,127,87,82,78,51,65,17,15,40,
  89,44,62,129,60,55,121,56,52,115,59,56,118,63,61,119,62,59,
  119,59,57,96,66,65,60,58,58,59,57,57,72,72,72,63,63,63,
  50,50,50,50,50,50,65,65,65,63,63,63,52,52,52,51,51,51,
  67,67,67,67,67,67,52,52,52,50,50,49,68,67,66,69,69,68,
  40,40,49,12,17,149,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  10,14,125,66,58,56,72,69,68,57,57,57,56,53,53,77,68,68,
  76,72,72,61,61,61,54,53,53,71,66,65,79,76,75,67,67,67,
  53,53,53,63,58,58,85,80,80,72,72,72,55,55,55,60,56,56,
  88,79,79,89,81,80,119,60,57,127,57,52,131,59,55,141,53,49,
  142,52,48,17,15,40,26,18,46,123,48,56,121,54,70,17,15,40,
  105,57,69,150,86,78,153,92,84,102,57,76,17,15,40,19,15,41,
  20,15,41,20,15,41,20,16,41,76,51,63,125,74,71,79,43,62,
  22,16,43,110,42,61,40,21,45,78,38,55,63,33,47,18,15,40,
  104,48,55,136,49,46,137,46,43,137,45,43,68,28,56,17,15,40,
  101,44,53,137,61,59,141,64,62,144,68,66,147,72,70,149,67,65,
  148,61,58,123,77,76,92,80,79,59,56,56,83,47,46,119,108,108,
  95,88,88,67,64,62,51,50,50,61,61,61,66,66,66,56,56,56,
  48,48,48,62,62,62,70,70,70,57,57,57,47,47,47,62,61,60,
  71,71,70,39,39,45,9,14,155,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  43,42,60,69,66,66,56,56,56,57,54,54,81,71,71,73,69,69,
  60,60,60,53,53,53,75,68,67,78,75,75,65,65,65,53,53,53,
  67,61,61,85,81,81,70,70,70,55,54,54,63,58,58,88,80,79,
  76,76,75,118,96,93,146,88,79,145,77,67,139,75,66,133,74,67,
  122,73,77,17,15,40,35,25,50,100,68,83,90,52,79,17,15,40,
  90,36,51,115,42,39,114,41,39,48,23,42,17,15,40,102,47,77,
  118,54,72,124,52,69,127,51,68,140,53,57,144,53,51,70,31,62,
  24,18,42,131,62,68,17,15,40,17,15,40,62,32,59,17,15,40,
  141,54,58,145,57,52,141,58,51,133,61,55,29,20,42,30,19,46,
  126,54,59,134,52,44,138,43,34,133,37,28,130,37,28,130,39,31,
  129,66,60,123,96,95,94,81,80,61,58,58,86,42,42,149,132,132,
  138,110,110,111,90,89,80,71,71,54,48,48,99,74,70,106,103,102,
  74,70,70,54,53,53,57,57,57,70,70,70,63,63,63,49,49,49,
  54,54,52,69,69,68,34,35,79,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,18,22,130,
  58,58,58,54,54,54,58,55,55,79,70,70,73,70,70,60,60,60,
  54,53,53,77,70,69,76,74,74,66,66,66,51,51,51,71,64,64,
  84,81,81,68,68,68,54,54,54,67,61,61,87,80,80,76,75,75,
  86,73,72,120,42,39,126,42,40,130,43,41,132,48,46,135,53,52,
  90,34,61,17,15,40,17,15,40,17,15,40,17,15,40,17,15,40,
  99,47,62,137,66,62,135,65,65,49,28,54,17,15,40,133,53,54,
  145,54,48,144,52,45,137,52,44,133,58,50,129,59,57,36,23,45,
  17,15,40,133,47,39,91,32,47,17,15,40,42,21,55,45,21,42,
  129,44,41,128,50,45,135,50,45,129,48,56,27,18,43,34,20,43,
  140,50,50,137,55,52,140,55,53,144,55,53,148,55,53,148,69,66,
  144,115,113,124,98,97,95,81,80,62,59,59,84,41,41,149,131,131,
  139,110,110,111,90,90,81,72,72,57,49,48,118,68,61,150,135,135,
  128,101,101,96,82,82,64,60,60,67,55,53,101,90,86,86,82,82,
  61,60,59,50,50,49,61,61,60,25,27,87,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,50,51,80,
  52,52,52,60,56,56,80,70,70,73,70,70,59,59,59,54,53,53,
  77,70,69,77,75,75,64,64,64,50,49,49,74,66,66,83,80,80,
  68,68,68,52,52,52,79,67,66,118,95,87,128,113,112,112,92,91,
  88,74,73,127,59,55,137,68,63,141,65,60,144,58,51,137,52,55,
  38,22,50,17,15,40,105,32,41,102,35,43,92,36,53,17,15,40,
  93,38,51,133,44,37,125,39,38,32,19,50,17,15,40,131,41,39,
  128,50,46,132,53,49,136,56,52,138,59,56,130,56,66,17,15,40,
  72,31,56,146,54,52,118,43,53,27,17,46,17,15,40,17,15,40,
  160,52,43,162,49,38,163,47,33,132,40,45,22,17,44,17,15,40,
  138,50,38,132,50,38,129,51,37,136,48,31,137,45,29,132,68,61,
  148,132,130,125,99,98,96,82,81,63,59,59,81,40,40,148,130,130,
  139,112,112,112,91,90,82,73,72,56,50,49,116,65,57,151,137,137,
  129,100,100,100,83,83,68,63,62,72,38,33,143,109,97,139,116,116,
  111,94,92,79,72,71,54,51,51,60,48,46,18,23,171,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,22,23,63,48,48,48,
  60,57,57,82,71,71,72,71,71,57,57,57,55,54,54,78,72,71,
  76,75,75,64,64,64,50,49,49,75,68,68,86,83,83,76,75,75,
  64,62,61,57,39,39,139,19,17,162,116,97,144,118,118,119,95,94,
  87,77,76,77,51,48,130,38,32,136,44,39,136,44,39,100,39,44,
  18,15,40,96,42,65,139,59,57,142,62,60,133,54,63,17,15,40,
  109,40,54,155,52,48,128,45,56,17,15,40,62,28,48,154,55,47,
  156,51,40,158,48,34,160,43,27,155,39,25,113,34,37,18,15,41,
  89,36,50,124,50,37,121,49,45,28,18,43,17,15,40,89,38,48,
  131,49,34,87,37,50,26,17,38,23,16,39,17,15,40,20,16,41,
  22,17,40,89,42,57,147,62,51,148,62,52,144,56,46,105,40,34,
  149,133,131,126,100,98,97,83,81,63,60,60,79,39,39,148,129,129,
  140,112,112,114,91,91,83,73,73,56,51,50,114,61,54,152,138,138,
  130,101,101,101,84,84,69,64,63,70,38,34,142,106,94,143,118,118,
  116,95,93,86,77,75,58,52,52,53,33,49,14,19,180,119,25,13,
  119,25,13,12,7,71,12,7,71,16,20,147,41,40,40,62,58,58,
  84,73,73,68,68,68,56,56,56,58,56,55,80,73,72,75,75,75,
  61,61,61,53,47,47,104,76,75,125,117,117,130,110,108,105,88,86,
  74,68,68,59,41,41,139,15,13,162,113,93,144,119,119,120,96,95,
  88,78,77,59,54,54,110,32,30,153,54,47,149,57,48,113,45,43,
  26,23,43,143,44,34,151,40,24,146,39,24,130,39,36,43,19,36,
  100,40,44,125,53,37,109,47,57,17,15,40,86,43,55,129,56,41,
  128,54,42,121,57,48,126,58,49,131,60,50,104,43,56,17,15,40,
  133,59,66,153,68,58,153,71,62,55,43,61,17,15,40,120,69,76,
  139,83,78,71,46,65,23,21,42,26,20,40,30,19,39,34,18,38,
  39,17,37,105,55,69,118,75,73,115,79,79,95,60,58,90,35,30,
  150,134,132,127,100,99,98,83,82,64,61,61,77,38,38,148,128,128,
  140,114,114,114,91,91,84,74,73,56,51,51,111,57,50,152,139,139,
  130,102,102,102,85,85,69,65,64,68,38,35,141,104,90,143,119,119,
  117,96,93,87,77,75,52,49,49,16,16,66,12,7,71,119,25,13,
  119,25,13,12,7,71,9,15,186,34,34,64,62,57,57,80,72,72,
  69,68,68,55,55,55,59,57,56,82,75,74,83,80,80,75,72,72,
  57,56,56,84,32,32,164,41,32,156,142,141,135,108,106,106,88,87,
  75,68,68,59,42,42,137,15,14,163,109,89,145,121,121,121,96,95,
  88,78,78,60,55,55,98,24,22,151,42,17,129,60,46,135,57,44,
  131,58,47,132,58,48,136,58,48,140,59,49,142,68,59,149,71,61,
  153,74,64,155,78,69,155,82,75,153,77,70,145,78,72,137,83,78,
  133,84,80,128,85,82,130,89,86,136,87,84,135,75,72,132,70,67,
  129,66,63,122,63,61,113,66,65,117,72,71,119,69,68,120,65,64,
  122,60,58,128,49,48,123,44,43,125,43,42,129,44,43,133,45,44,
  135,53,52,142,56,55,146,58,57,121,51,50,61,44,43,88,32,27,
  150,135,133,128,100,99,98,84,82,64,61,61,75,36,36,147,127,127,
  141,114,114,115,92,92,85,75,74,56,52,52,109,54,46,153,141,141,
  131,102,102,102,85,85,71,65,64,67,38,36,140,101,87,144,120,120,
  118,96,93,86,76,75,40,39,47,11,13,153,12,7,71,119,25,13,
  119,25,13,12,7,71,16,18,66,60,55,55,79,71,71,68,67,67,
  56,56,56,68,50,47,119,96,95,126,111,111,120,100,98,93,80,80,
  62,60,60,86,27,27,164,37,29,156,140,139,136,108,107,107,89,88,
  76,69,69,59,43,43,134,15,14,163,106,85,146,122,122,122,97,95,
  89,79,78,61,56,56,96,25,23,163,47,15,150,109,101,132,83,79,
  121,85,82,117,86,84,125,89,88,127,79,77,127,69,68,127,61,59,
  125,54,52,114,53,52,114,58,57,117,61,60,119,61,60,121,60,59,
  131,52,51,134,46,45,133,44,43,136,43,42,139,43,42,138,50,49,
  140,59,59,145,63,62,147,67,67,149,72,72,150,71,70,148,63,62,
  141,64,64,137,64,64,133,63,63,131,65,64,136,70,68,139,63,59,
  140,57,51,141,52,45,139,48,41,90,63,63,57,48,47,86,29,24,
  150,136,134,128,101,100,99,84,83,65,62,62,73,35,35,147,126,126,
  141,115,115,116,92,92,86,75,74,55,53,53,106,50,43,154,142,142,
  131,103,103,103,85,85,71,66,65,65,39,37,139,98,84,144,121,121,
  118,96,93,80,72,70,19,23,140,12,7,71,12,7,71,119,25,13,
  119,25,13,10,15,153,51,45,46,81,72,72,77,74,74,68,66,66,
  57,48,48,122,19,17,166,98,98,148,129,129,124,100,97,95,81,80,
  63,60,60,84,28,28,162,35,27,157,139,137,136,109,108,108,89,88,
  77,69,69,58,44,44,131,16,15,164,102,81,146,123,123,122,97,96,
  90,79,79,61,57,56,94,26,24,162,45,15,153,135,128,129,70,69,
  143,47,46,144,49,47,144,50,49,144,50,50,142,52,51,137,63,63,
  139,66,66,142,68,68,145,71,70,149,72,72,150,62,60,147,60,58,
  142,61,58,137,61,59,131,62,60,132,71,68,133,70,66,134,63,57,
  134,56,48,136,48,39,132,41,32,126,40,32,126,44,35,127,47,38,
  126,52,42,130,54,44,138,52,41,138,52,41,137,53,43,138,52,43,
  136,53,45,130,60,54,105,67,64,81,72,72,57,49,48,84,26,21,
  151,137,135,130,102,100,100,85,83,65,62,62,70,34,34,147,125,125,
  142,116,116,117,93,93,87,76,75,55,54,53,103,47,39,155,144,144,
  132,103,103,104,86,86,72,67,66,63,39,38,138,96,80,145,122,122,
  115,95,94,47,48,92,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,33,33,89,117,103,94,126,105,105,110,93,91,82,75,73,
  59,49,49,121,17,17,166,94,94,148,130,130,125,100,98,96,81,81,
  63,61,61,82,29,29,161,33,26,157,138,135,137,110,109,109,90,89,
  78,70,70,58,44,44,129,16,15,164,98,77,147,124,124,123,97,96,
  91,80,79,62,57,57,92,27,25,161,43,15,154,136,126,135,101,100,
  135,64,63,134,57,52,130,62,57,130,67,62,130,63,56,129,58,51,
  131,52,43,133,45,35,128,40,31,128,42,33,129,44,35,129,48,39,
  129,55,45,137,55,45,139,56,46,139,58,49,140,59,50,141,55,48,
  136,59,53,136,61,56,140,61,55,144,61,56,148,62,58,155,57,51,
  158,50,45,158,48,43,158,47,42,156,45,41,151,48,45,147,52,50,
  145,48,45,143,56,53,112,90,88,82,73,73,57,50,49,84,26,21,
  149,134,133,130,102,101,101,85,84,66,63,63,69,34,34,146,122,122,
  142,117,117,118,94,94,87,76,76,55,54,54,101,44,37,155,144,144,
  133,104,104,104,86,86,73,67,67,61,39,39,137,93,77,145,123,123,
  90,80,89,15,21,183,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,20,24,143,111,105,95,138,111,111,113,93,91,83,76,74,
  59,49,49,119,17,17,166,90,90,149,132,132,126,101,99,97,82,82,
  64,61,61,80,30,30,160,32,24,158,136,133,137,111,110,110,91,89,
  79,71,71,58,46,46,126,16,16,164,94,74,147,126,126,124,98,97,
  92,81,80,62,58,58,90,28,26,160,41,15,155,135,124,134,106,106,
  108,80,78,125,55,47,140,62,53,141,64,57,145,60,53,144,58,51,
  142,60,54,145,59,53,147,58,52,149,59,54,153,58,54,157,50,45,
  159,46,41,160,42,38,159,38,35,153,39,36,146,44,42,142,44,42,
  137,43,40,134,41,39,140,35,33,141,31,29,139,31,29,137,32,30,
  135,33,32,127,41,39,127,44,43,131,46,45,132,49,49,133,52,52,
  136,50,50,130,90,89,113,94,91,83,73,73,58,50,50,83,27,21,
  147,131,130,131,103,102,102,85,84,67,64,64,68,35,35,144,119,119,
  142,118,118,118,94,94,88,77,76,56,55,55,99,44,36,155,143,142,
  134,105,105,105,87,87,74,68,67,61,40,40,134,90,73,135,124,123,
  35,37,110,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,30,33,138,111,98,98,112,92,91,84,76,74,
  59,50,50,116,17,17,166,86,86,150,133,133,127,101,99,97,82,82,
  66,62,62,78,31,31,159,30,23,158,134,131,138,111,110,110,91,90,
  80,71,71,58,46,46,124,17,16,164,90,70,148,127,127,125,98,97,
  93,81,80,63,59,59,88,28,27,159,39,14,155,134,121,135,107,107,
  107,89,88,100,62,60,151,31,28,148,34,32,140,38,36,133,40,38,
  126,42,40,129,39,37,134,34,33,135,33,31,135,33,32,136,33,32,
  130,39,37,124,46,46,128,49,49,131,54,53,133,57,57,138,57,56,
  146,49,49,145,49,49,147,48,48,149,47,47,150,50,49,150,65,64,
  154,72,71,157,79,79,160,87,87,162,93,93,157,83,83,146,82,82,
  148,101,101,142,114,114,114,94,92,84,74,74,58,51,51,82,28,22,
  146,128,127,131,104,102,103,86,85,68,64,64,67,36,36,142,115,115,
  143,119,119,119,94,94,89,77,77,57,56,55,97,43,36,154,141,140,
  134,105,105,107,87,87,75,69,67,60,41,40,131,85,69,86,85,95,
  10,15,173,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,40,41,99,101,90,88,84,76,75,
  59,52,52,114,18,18,166,81,81,150,134,134,127,102,99,98,83,82,
  66,63,63,76,32,32,157,28,22,159,133,130,138,112,111,111,92,90,
  81,72,72,57,47,47,121,17,16,165,86,66,148,128,128,125,99,98,
  94,82,80,63,59,59,86,29,28,158,36,14,156,134,118,136,108,108,
  108,90,89,78,69,68,92,42,41,134,52,51,142,59,58,153,54,53,
  156,54,54,156,58,57,156,61,60,153,60,60,148,71,71,146,80,80,
  146,84,84,147,86,86,152,91,91,153,84,84,148,74,74,141,77,77,
  133,79,79,124,83,83,119,90,90,125,96,96,124,85,85,123,74,74,
  123,62,62,121,49,49,111,44,44,114,44,44,121,46,46,128,50,44,
  151,116,98,143,118,118,115,94,92,85,74,74,58,52,52,81,28,23,
  144,126,125,132,105,104,103,86,85,69,65,65,67,37,37,140,112,112,
  144,121,121,120,94,94,90,78,77,58,56,56,94,43,36,154,139,138,
  135,106,106,107,88,87,76,69,68,60,41,41,102,70,50,13,17,133,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,9,15,170,48,47,64,79,74,73,
  58,52,52,111,19,19,166,77,77,151,136,136,129,102,100,99,83,83,
  67,63,63,74,32,32,156,27,21,160,132,128,139,113,112,112,92,91,
  82,72,72,57,48,48,118,17,17,165,83,62,149,129,129,126,100,99,
  95,82,81,64,60,60,84,30,29,157,34,14,157,133,115,136,109,108,
  109,90,89,77,70,69,67,43,43,138,48,48,139,73,73,133,72,72,
  127,71,71,117,74,74,121,82,82,123,79,79,123,72,72,123,64,64,
  127,52,52,122,45,45,122,44,44,127,44,44,131,45,45,134,52,52,
  141,55,55,148,55,55,149,59,59,150,63,63,149,61,61,144,61,61,
  138,68,68,136,70,70,135,71,71,137,73,73,142,74,74,135,47,42,
  145,108,90,144,120,120,116,95,93,85,75,75,59,53,52,81,28,23,
  142,123,122,133,106,104,104,87,86,70,66,65,66,38,38,138,108,108,
  144,122,122,121,95,95,91,78,78,58,57,57,92,42,36,153,137,135,
  135,107,107,108,88,88,77,70,69,53,42,41,29,20,36,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,13,18,155,46,45,45,
  54,49,49,108,19,19,166,73,73,151,137,137,129,102,101,100,84,83,
  68,64,64,72,34,34,154,25,19,160,130,126,140,114,113,113,93,91,
  83,73,73,57,49,49,116,18,17,165,79,58,149,131,131,127,100,99,
  95,83,82,65,61,61,82,31,30,156,32,13,157,132,112,137,110,109,
  110,90,89,78,71,71,63,44,44,126,16,16,143,60,60,139,58,58,
  147,60,60,149,65,65,151,70,70,152,71,71,148,64,64,141,67,67,
  135,69,69,131,69,69,129,70,70,134,75,75,137,66,66,138,58,58,
  137,52,52,136,47,47,127,45,45,123,51,51,124,54,54,123,53,53,
  123,52,52,128,46,46,132,39,39,131,37,37,124,34,34,81,33,29,
  141,105,87,144,121,120,117,95,93,86,76,75,59,54,53,80,29,24,
  140,120,119,134,106,105,105,87,86,71,66,66,65,39,39,136,105,105,
  144,123,123,122,95,95,92,79,78,59,57,57,90,42,35,153,135,133,
  136,108,108,109,89,89,77,69,68,37,36,35,9,13,124,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,11,15,98,
  39,35,35,102,17,17,166,69,69,152,138,138,130,103,101,100,84,84,
  69,65,65,70,35,35,153,23,18,160,128,124,140,115,114,114,93,92,
  83,74,74,57,50,50,113,18,18,165,75,54,150,132,132,128,100,99,
  96,84,82,66,61,61,79,32,30,156,30,13,158,131,110,138,110,110,
  111,90,90,79,72,71,62,45,45,126,16,16,166,106,106,136,83,83,
  134,44,44,130,38,38,121,38,38,122,43,43,123,46,46,123,48,48,
  126,48,48,136,42,42,137,40,40,137,40,40,139,40,40,139,41,41,
  134,52,52,137,56,56,141,59,59,143,62,62,147,66,66,151,57,57,
  150,53,53,147,53,53,145,52,52,145,51,51,92,54,54,67,39,35,
  139,102,84,145,122,122,117,96,94,87,76,76,60,54,54,79,29,24,
  138,117,116,134,107,106,105,87,87,72,67,67,64,40,40,134,101,101,
  145,124,124,122,96,96,93,79,79,60,58,58,88,41,35,152,133,131,
  137,109,109,109,89,89,72,65,64,20,20,50,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,15,99,76,20,20,163,66,66,153,140,140,130,104,101,101,85,84,
  70,65,65,68,36,36,152,21,17,161,127,122,141,115,115,115,94,92,
  84,74,74,57,51,51,110,19,19,166,71,50,150,133,133,128,100,100,
  97,84,83,66,62,62,77,33,31,154,27,13,158,130,107,138,111,111,
  111,91,91,80,72,71,62,46,46,123,16,16,167,108,108,138,119,119,
  127,64,64,138,59,59,141,60,60,146,62,62,151,57,57,155,48,48,
  153,47,47,151,47,47,148,46,46,143,50,50,142,56,56,141,52,52,
  140,45,45,141,38,38,145,30,30,140,25,25,137,27,27,134,30,30,
  131,33,33,126,39,39,131,39,39,116,44,44,71,63,63,65,40,37,
  138,99,80,146,123,123,118,96,94,88,77,76,60,55,54,78,30,25,
  137,114,113,135,108,106,106,88,87,73,68,67,63,41,41,133,98,98,
  145,126,126,123,96,96,93,80,79,61,59,58,85,41,35,152,132,129,
  137,110,110,109,89,89,53,51,55,10,16,165,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,23,17,97,128,76,76,152,140,140,131,104,102,102,85,85,
  70,66,66,66,37,37,150,19,15,161,126,120,141,116,116,115,95,92,
  85,74,74,56,52,52,107,19,19,166,68,46,151,134,134,129,101,101,
  98,85,83,67,63,63,75,33,32,153,25,13,159,130,104,139,112,112,
  112,91,91,81,73,72,61,47,47,121,17,17,168,105,105,146,128,128,
  129,86,86,135,35,35,138,29,29,136,28,28,135,30,30,133,32,32,
  128,38,38,128,43,43,133,43,43,134,46,46,134,49,49,137,48,48,
  138,46,46,134,50,50,137,51,51,141,51,51,145,54,54,149,63,63,
  157,63,63,159,68,68,152,68,68,106,74,74,71,66,66,64,41,37,
  136,96,77,146,124,124,119,96,95,89,78,77,61,56,55,78,30,25,
  135,111,110,136,109,107,107,88,88,74,68,68,62,42,42,131,95,95,
  146,127,127,124,96,96,94,80,80,62,60,59,83,41,35,151,130,127,
  137,111,111,96,83,83,21,24,117,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,9,111,44,43,97,137,128,127,131,104,101,103,86,85,
  72,67,67,64,38,38,149,18,14,162,124,118,142,117,117,116,95,93,
  86,75,75,56,53,53,105,20,19,166,64,42,151,136,136,130,101,101,
  99,85,84,68,63,63,73,34,33,153,23,12,159,129,101,139,113,112,
  113,92,91,81,74,73,61,48,48,119,17,17,168,101,101,147,129,129,
  124,97,97,104,64,64,146,48,48,149,49,49,151,62,62,156,70,70,
  160,76,76,162,83,83,165,90,90,161,84,84,153,82,82,144,88,88,
  137,90,90,130,92,92,131,97,96,137,97,96,137,84,82,136,77,74,
  134,70,66,128,65,61,116,83,81,104,86,86,72,66,66,63,41,38,
  135,93,73,147,125,125,120,97,95,90,78,77,61,56,56,77,31,26,
  133,109,107,136,110,108,108,89,88,75,69,69,62,43,43,129,91,91,
  147,128,128,125,96,96,95,81,80,63,60,60,81,40,35,151,128,125,
  133,113,112,51,50,89,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,9,15,182,59,61,118,127,108,104,103,86,86,
  72,67,67,62,39,39,148,16,12,163,122,116,142,118,118,117,96,93,
  87,76,76,56,54,54,102,20,20,166,60,38,152,137,137,131,102,101,
  100,86,84,68,64,64,71,35,34,152,20,12,160,128,98,140,114,113,
  114,92,92,82,74,73,60,48,48,117,17,17,168,97,97,148,130,130,
  126,99,99,98,81,81,114,85,83,131,91,89,130,81,78,130,71,67,
  128,60,55,118,55,51,118,57,53,123,60,55,126,61,56,130,63,59,
  140,58,53,145,54,48,145,54,49,146,55,50,146,54,50,143,60,57,
  141,70,67,141,77,74,130,103,101,105,86,86,73,67,67,61,42,40,
  133,90,70,147,126,126,120,97,95,91,79,78,61,57,57,76,31,26,
  131,105,105,137,111,109,109,89,88,76,70,69,61,44,44,127,88,88,
  147,130,130,125,97,97,96,81,81,64,61,60,78,40,35,149,126,123,
  99,94,98,13,18,154,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,9,15,179,71,69,89,100,86,84,
  73,68,67,61,40,40,146,15,12,163,121,114,143,119,119,118,96,94,
  88,76,76,56,54,54,100,20,20,166,56,35,152,138,138,132,102,102,
  101,86,85,69,65,65,69,36,35,150,18,12,160,127,96,141,115,114,
  114,93,93,84,75,74,59,49,49,114,18,18,168,94,94,148,131,131,
  126,99,99,98,83,83,70,60,59,124,47,42,146,63,59,139,73,70,
  137,76,73,137,77,74,138,80,77,144,82,79,145,71,67,141,67,63,
  136,67,62,130,67,62,121,69,64,122,77,72,123,76,71,123,69,64,
  124,66,61,143,126,125,134,108,106,106,87,87,74,67,67,60,42,40,
  132,87,66,148,127,127,122,97,96,92,79,79,62,58,58,75,32,27,
  130,103,102,138,111,109,109,90,89,77,70,70,60,45,45,125,84,84,
  147,131,131,126,97,97,97,82,81,64,62,61,76,39,35,133,112,108,
  38,42,163,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,16,22,181,73,70,89,
  71,66,66,61,41,41,144,16,13,164,117,110,143,120,120,119,97,94,
  89,77,77,57,55,55,98,21,21,166,54,33,153,138,137,133,103,103,
  102,87,85,69,65,65,67,37,36,149,17,12,161,126,93,141,115,115,
  115,93,93,84,76,74,59,50,50,112,18,18,169,90,90,149,132,132,
  127,100,100,99,83,83,65,62,62,83,42,38,130,57,49,122,62,56,
  125,56,50,130,48,41,126,44,38,128,44,38,131,45,39,133,47,42,
  133,55,50,141,57,51,143,59,55,144,62,58,145,64,61,146,59,56,
  142,60,51,155,142,141,134,109,106,107,88,88,75,68,68,59,43,41,
  130,84,63,148,129,129,122,97,97,92,80,79,62,58,58,75,32,27,
  128,100,99,138,112,110,110,90,89,78,71,70,59,45,45,123,81,81,
  148,132,132,127,98,98,98,82,82,65,62,62,67,38,33,67,54,82,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,21,25,128,
  56,54,54,59,40,40,141,16,13,164,113,107,144,121,121,119,97,94,
  89,77,77,57,56,56,96,22,22,165,52,32,153,137,136,133,103,103,
  102,87,85,70,66,66,66,38,37,147,17,12,162,123,89,142,116,116,
  116,93,93,85,76,75,59,51,51,110,19,19,169,86,86,149,134,134,
  128,100,100,100,84,84,65,62,62,74,35,31,154,25,15,149,62,59,
  142,62,59,140,60,58,138,59,57,138,61,59,142,62,60,145,53,51,
  147,46,45,148,40,39,146,35,34,138,35,34,134,41,40,132,38,38,
  118,34,26,155,143,142,135,109,107,108,88,88,75,69,69,57,43,42,
  129,81,59,149,130,130,123,98,97,93,81,79,63,59,59,74,33,27,
  126,97,97,139,113,111,111,90,90,79,72,71,58,46,46,121,77,77,
  148,133,133,127,98,98,99,83,82,65,62,62,47,36,35,13,15,131,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  24,27,115,49,32,32,138,15,12,164,110,103,145,123,123,120,97,95,
  90,78,78,58,57,57,93,23,23,164,49,30,154,136,134,134,104,104,
  103,88,86,71,66,66,66,39,38,145,17,13,162,120,85,142,117,117,
  117,94,94,86,77,75,60,52,52,108,20,20,168,82,82,150,135,135,
  129,101,101,101,84,84,66,63,63,73,36,32,155,22,12,156,125,124,
  122,44,43,131,41,40,136,39,39,136,40,40,135,42,41,135,42,41,
  132,46,45,127,54,53,132,55,54,137,57,55,141,60,58,100,45,44,
  90,32,24,155,143,142,136,110,107,109,88,88,77,69,69,56,44,43,
  127,79,56,150,131,131,124,98,97,95,81,80,63,60,60,73,34,28,
  124,94,94,140,114,112,112,91,90,80,72,71,57,47,47,120,74,74,
  149,135,135,128,99,99,100,83,83,63,60,59,19,20,47,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  9,15,185,23,18,49,123,23,21,164,106,99,145,124,124,121,98,96,
  91,78,78,59,57,57,91,24,24,163,47,29,154,136,132,134,105,105,
  104,88,87,72,67,67,65,40,39,143,17,13,162,116,82,143,119,118,
  118,94,94,87,77,76,60,53,53,106,21,21,167,77,77,151,137,137,
  129,101,101,102,85,85,67,64,64,72,37,33,153,22,12,161,138,137,
  142,92,91,157,59,46,160,59,40,157,60,40,151,66,46,147,68,47,
  145,66,42,143,64,38,147,62,32,149,57,26,139,52,26,68,54,51,
  87,32,25,155,141,139,136,111,108,110,89,89,77,70,70,56,44,44,
  125,76,53,150,131,131,125,99,98,95,82,81,64,61,61,73,34,29,
  123,91,91,140,115,113,113,91,90,81,73,72,57,48,48,118,70,70,
  150,136,136,129,99,99,99,83,82,56,54,69,11,17,176,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,10,16,186,57,30,54,149,108,101,145,125,125,122,98,96,
  92,79,79,60,58,58,89,25,25,162,45,27,155,135,131,135,106,106,
  105,88,87,73,68,67,65,41,40,140,17,13,162,112,78,143,120,119,
  119,95,95,88,77,76,61,53,53,103,22,22,166,73,73,152,138,138,
  130,102,102,103,85,85,68,64,64,71,37,34,151,22,12,162,135,134,
  139,113,112,116,70,59,122,55,40,126,57,43,127,58,47,129,58,49,
  134,51,45,133,49,46,132,49,47,136,49,47,93,62,61,60,58,57,
  85,32,26,154,138,136,137,112,109,110,90,90,78,71,71,56,45,45,
  123,73,52,150,132,131,126,100,98,96,82,81,65,61,61,72,35,30,
  121,88,87,141,116,114,114,92,91,82,74,72,56,49,49,116,68,68,
  150,136,136,130,99,99,95,81,81,28,30,110,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,17,184,81,78,102,140,121,120,122,98,96,
  92,79,79,61,58,58,87,26,26,161,42,26,155,134,129,136,106,106,
  105,89,87,74,68,68,64,42,41,138,17,14,163,109,74,144,121,120,
  119,95,95,89,78,77,61,54,54,101,23,23,165,69,69,152,139,139,
  131,103,103,103,86,86,69,65,65,70,38,35,149,23,12,162,131,130,
  140,114,114,114,91,89,129,69,68,157,87,86,151,77,75,141,78,77,
  132,79,78,123,80,79,116,80,80,122,83,83,93,78,78,61,59,58,
  83,33,27,153,135,133,137,113,110,111,90,90,79,71,71,56,46,46,
  121,71,50,151,132,130,126,100,99,97,83,82,66,62,62,71,36,31,
  119,85,84,141,117,115,115,92,92,83,74,73,57,50,50,113,65,65,
  150,137,137,128,99,99,61,56,56,10,16,170,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,16,21,167,93,87,91,121,99,97,
  93,80,79,62,59,59,84,27,27,160,40,24,156,133,127,136,107,107,
  107,89,88,75,69,69,63,43,42,135,18,14,163,105,71,145,122,121,
  120,96,96,89,79,78,62,55,55,99,23,23,164,64,64,153,141,141,
  132,104,104,104,87,87,70,65,65,69,39,36,147,23,13,163,128,127,
  140,116,115,116,95,93,93,69,69,104,37,36,121,44,42,126,48,46,
  132,52,50,144,49,45,140,53,49,122,88,87,94,80,79,62,60,59,
  81,34,28,152,132,130,138,114,111,112,90,90,80,72,72,56,47,47,
  118,69,48,151,132,130,127,101,100,98,84,82,67,62,62,70,36,31,
  117,82,81,142,118,116,115,93,92,84,74,73,57,50,50,111,63,63,
  150,136,136,109,96,96,19,23,126,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,23,27,133,93,85,85,
  92,79,79,62,60,60,82,28,28,159,38,23,156,132,126,137,108,108,
  107,90,88,75,69,69,62,44,43,133,18,14,163,102,67,145,124,123,
  121,96,96,90,79,78,62,56,56,96,24,24,164,60,60,154,142,142,
  132,104,104,105,87,87,71,66,66,68,39,37,145,23,13,163,124,123,
  141,117,116,117,95,93,88,76,76,79,54,50,141,69,59,147,64,54,
  145,61,52,142,61,53,140,96,91,125,97,97,94,80,80,63,60,59,
  79,34,29,151,130,126,138,115,112,113,91,90,81,72,72,57,47,47,
  116,66,46,151,132,130,128,102,100,98,84,82,67,63,63,69,37,33,
  116,79,77,143,119,117,116,93,93,84,75,74,58,51,51,108,60,60,
  144,135,135,50,51,92,12,11,125,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,30,31,68,
  81,73,73,62,59,59,80,29,29,159,35,21,157,132,124,137,109,109,
  108,90,88,76,70,70,62,44,43,131,18,15,164,98,63,145,124,124,
  122,96,96,91,80,78,63,57,57,94,25,25,163,56,56,155,143,143,
  133,105,105,106,87,87,72,67,67,67,40,38,143,24,13,164,121,120,
  141,118,117,118,96,94,89,77,77,58,53,52,110,28,23,134,42,32,
  130,51,42,133,82,77,145,127,126,126,98,98,95,81,80,64,60,60,
  78,35,30,150,127,123,139,116,113,114,91,91,82,73,73,56,48,48,
  113,64,44,151,132,129,129,102,101,99,84,83,68,64,64,68,38,34,
  114,76,74,143,120,118,117,94,93,85,75,75,58,52,52,104,57,57,
  101,99,100,11,17,159,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,13,8,96,
  35,35,69,56,55,55,77,30,30,157,33,20,157,131,122,138,109,109,
  109,91,89,77,71,71,62,45,45,128,19,15,164,95,60,146,126,125,
  122,97,97,92,80,79,63,57,57,91,26,26,162,51,51,155,145,145,
  134,106,106,106,87,87,73,67,67,66,41,38,141,24,13,164,118,116,
  142,119,118,118,96,94,90,77,77,58,53,53,102,27,21,157,59,38,
  158,60,50,155,96,91,149,134,133,127,99,99,96,81,81,64,61,61,
  76,35,31,149,124,119,140,117,114,114,92,92,83,74,74,57,49,49,
  111,61,42,151,132,129,129,103,102,100,85,83,69,64,64,67,38,35,
  113,72,70,144,121,119,117,94,93,86,76,75,58,52,52,80,44,44,
  30,32,118,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  10,16,173,29,29,35,69,25,25,156,30,18,158,130,121,139,110,110,
  110,91,89,78,71,71,61,46,45,126,19,15,164,91,56,147,127,126,
  123,97,97,93,81,80,63,58,58,89,26,26,161,47,47,156,146,146,
  135,106,106,107,88,88,74,67,67,65,42,40,139,24,14,164,114,112,
  142,120,119,119,97,95,90,78,78,58,54,54,99,33,28,151,66,43,
  109,75,70,118,75,71,138,123,122,123,96,96,96,81,81,65,62,61,
  74,36,32,148,121,116,140,118,115,116,93,92,83,74,74,57,49,49,
  108,59,41,152,132,128,130,103,103,101,85,84,70,65,65,65,39,36,
  111,69,67,144,123,121,118,95,94,87,77,76,56,52,52,34,29,39,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,10,14,133,48,28,33,150,34,22,158,129,119,139,111,111,
  111,91,90,79,72,72,60,47,46,124,19,16,165,87,52,147,128,127,
  124,98,98,94,81,80,64,59,59,87,27,27,160,42,42,157,147,147,
  135,107,107,108,89,89,75,69,69,64,43,41,137,25,14,165,111,109,
  143,121,120,115,94,92,81,71,71,58,56,56,61,53,52,55,54,54,
  47,47,47,50,50,50,58,56,56,64,60,60,63,59,59,61,59,59,
  71,42,39,141,116,111,138,116,114,115,92,92,84,74,74,57,50,50,
  106,57,39,152,132,128,131,104,103,102,86,84,71,65,65,65,40,37,
  109,66,64,145,124,121,119,95,94,88,77,76,47,46,46,12,15,104,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,15,135,96,44,33,155,129,118,140,111,111,
  112,92,90,80,73,72,60,48,47,122,19,16,165,84,48,147,129,128,
  125,99,98,94,82,80,64,59,59,84,28,28,160,38,38,157,149,149,
  135,108,108,108,89,89,76,69,69,62,42,41,132,36,26,136,93,91,
  91,83,82,62,58,57,50,50,50,47,47,47,46,46,46,45,45,45,
  45,45,45,46,46,46,47,47,47,47,47,47,48,48,48,49,49,49,
  50,49,49,63,61,60,72,67,67,73,65,64,66,62,62,59,51,51,
  102,58,43,150,132,128,131,104,103,102,86,85,71,66,66,63,40,38,
  107,63,60,145,125,122,120,95,95,85,75,74,32,33,68,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,24,27,142,119,114,113,139,112,111,
  113,92,91,81,73,73,59,49,48,119,19,17,165,81,44,148,130,129,
  126,99,99,96,83,81,65,60,60,82,29,29,159,34,34,158,150,150,
  134,107,107,103,85,85,69,64,64,61,55,54,64,54,52,53,51,51,
  48,48,48,48,48,48,49,49,49,49,49,49,50,50,50,50,50,50,
  49,49,49,48,48,48,47,47,47,46,46,46,47,47,47,47,47,47,
  48,48,48,48,48,48,48,48,48,47,47,47,48,48,48,50,49,49,
  61,57,57,69,67,66,82,71,70,76,68,67,66,61,61,61,40,37,
  105,59,57,145,125,123,120,95,94,69,63,64,12,17,143,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,31,32,80,120,105,103,
  113,92,90,82,74,73,58,50,49,117,19,17,166,77,41,149,132,131,
  127,99,99,96,83,82,65,60,60,79,31,31,145,38,38,119,114,114,
  77,68,68,53,51,51,47,47,47,47,47,47,47,47,47,48,48,48,
  48,48,48,48,48,48,47,47,47,48,48,48,48,48,48,48,48,48,
  49,49,49,49,49,49,49,49,49,48,48,48,47,47,47,47,47,47,
  47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,46,46,46,
  46,46,46,46,46,46,47,47,47,48,48,48,50,50,50,56,54,54,
  67,55,55,86,77,76,75,63,63,28,30,116,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,44,44,91,
  107,95,93,82,74,73,58,50,50,115,19,17,166,74,37,149,132,131,
  125,98,98,85,75,74,59,56,54,61,50,48,62,50,50,50,50,50,
  48,48,48,48,48,48,47,47,47,47,47,47,46,46,46,46,46,46,
  47,47,47,47,47,47,47,47,47,48,48,48,47,47,47,47,47,47,
  47,47,47,47,47,47,47,47,47,48,48,48,48,48,48,48,48,48,
  47,47,47,46,46,46,46,46,46,47,47,47,48,48,48,48,48,48,
  48,48,48,48,48,48,47,47,47,46,46,46,46,46,46,39,39,39,
  29,30,63,17,21,138,11,16,157,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  57,57,96,78,71,71,57,51,50,111,19,17,148,64,42,102,94,94,
  66,61,61,50,50,50,49,49,49,48,48,48,48,48,48,47,47,47,
  47,47,47,47,47,47,48,48,48,48,48,48,47,47,47,47,47,47,
  46,46,46,45,45,45,46,46,46,47,47,47,48,48,48,49,49,49,
  49,49,49,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
  49,49,49,48,48,48,48,48,48,47,47,47,46,46,46,46,46,46,
  46,46,46,45,45,45,32,32,32,23,23,40,13,16,95,11,17,172,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  13,12,125,45,44,58,49,49,49,56,54,53,49,47,47,46,46,46,
  45,45,45,45,45,45,46,46,46,47,47,47,48,48,48,49,49,49,
  49,49,49,48,48,48,48,48,48,49,49,49,49,49,49,49,49,49,
  49,49,49,48,48,48,47,47,47,46,46,46,46,46,46,46,46,46,
  46,46,46,47,47,47,48,48,48,48,48,48,48,48,48,48,48,48,
  49,49,49,49,49,49,49,49,49,48,48,48,45,45,45,35,35,45,
  24,26,66,12,16,118,8,14,160,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,8,96,11,16,140,14,17,101,24,27,103,34,35,75,
  35,36,41,40,40,40,45,45,45,46,46,46,46,46,46,47,47,47,
  48,48,48,48,48,48,49,49,49,49,49,49,48,48,48,48,48,48,
  48,48,48,49,49,49,49,49,49,49,49,49,49,49,49,48,48,48,
  47,47,47,47,47,47,48,48,48,48,48,48,48,48,48,48,48,48,
  46,46,46,41,41,41,29,30,55,19,22,89,12,16,141,9,15,179,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  10,15,169,12,18,164,20,24,151,25,27,89,28,28,33,33,33,33,
  41,41,41,45,45,45,47,47,47,48,48,48,49,49,49,49,49,49,
  48,48,48,47,47,47,47,47,47,47,47,47,47,47,47,48,48,48,
  47,47,47,46,46,46,45,45,45,42,42,42,36,36,36,26,27,71,
  18,20,83,14,19,161,12,9,111,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,9,14,180,10,16,186,
  13,18,162,16,19,104,22,26,110,26,27,54,32,32,32,42,42,42,
  47,47,47,49,49,49,49,49,49,48,48,48,48,48,48,47,47,47,
  46,46,46,41,41,41,30,32,96,17,20,105,12,17,180,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,9,13,126,
  16,19,127,19,21,65,25,26,48,38,38,61,36,36,59,22,26,117,
  11,15,128,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,
  12,7,71,12,7,71,12,7,71,12,7,71,12,7,71,119,25,13,
  119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,
  119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,
  119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,
  119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,
  119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,
  119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,
  119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,
  119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,
  119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,
  119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,
  119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,
  119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,
  119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,
  119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,
  119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,119,25,13,
} ;

  /** burst "logo" **/
  
static unsigned char burst_rgb[] = {
  60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,
  60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,
  60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,
  60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,
  60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,
  60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,
  60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,
  60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,
  60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,
  60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,
  60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,
  60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,
  60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,
  60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,
  60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,
  60,135,14,17,7,68,19,7,67,19,7,67,19,7,67,19,7,67,
  19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,
  19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,
  19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,
  19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,
  19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,
  19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,
  19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,
  19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,
  19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,
  19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,
  19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,
  19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,
  19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,
  19,7,67,19,7,67,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,22,7,65,22,7,65,
  22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,
  22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,
  22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,
  22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,
  22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,
  22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,
  22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,
  22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,
  22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,
  22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,
  22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,
  22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,
  22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,
  22,7,65,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,25,8,64,
  25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,
  25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,
  25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,
  25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,
  25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,
  25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,
  25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,
  25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,
  25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,
  25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,
  25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,
  25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,
  25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,
  28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,
  28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,
  28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,
  28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,
  28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,
  28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,
  28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,
  28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,
  28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,
  28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,
  28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,
  28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,
  30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,
  30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,
  30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,
  30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,
  30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,
  30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,
  30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,
  30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,
  30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,
  30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,
  30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,
  30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,
  33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,
  33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,
  33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,
  33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,
  33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,
  33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,
  33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,
  33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,
  33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,
  33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,
  33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,
  33,8,60,33,8,60,33,8,60,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,36,8,58,36,8,58,36,8,58,
  36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,
  36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,
  36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,
  36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,
  36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,
  36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,
  36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,
  36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,
  36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,
  36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,
  36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,
  36,8,58,36,8,58,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,39,9,57,39,9,57,
  39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,
  39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,
  39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,
  39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,
  39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,
  39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,
  39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,
  39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,
  39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,
  39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,
  39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,
  39,9,57,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,41,9,56,
  41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,
  41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,
  41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,
  41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,
  41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,
  41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,
  41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,
  41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,
  41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,
  41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,
  41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,
  44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,
  44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,
  44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,
  44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,
  44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,
  44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,
  44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,
  44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,
  44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,
  44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,
  47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,
  47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,
  47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,
  47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,
  47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,
  47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,
  47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,
  47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,
  47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,
  47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,
  50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,
  50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,
  50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,
  50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,
  50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,
  50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,
  50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,
  50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,
  50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,
  50,9,51,50,9,51,50,9,51,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,52,10,50,52,10,50,52,10,50,
  52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,
  52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,
  52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,
  52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,
  52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,
  52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,
  52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,
  52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,
  52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,
  52,10,50,52,10,50,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,55,10,48,55,10,48,
  55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,
  55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,
  55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,
  55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,
  55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,
  55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,
  55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,
  55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,
  55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,
  55,10,48,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,58,10,47,
  58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,
  58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,
  58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,
  58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,
  58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,
  58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,
  58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,
  58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,
  58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,
  61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,
  61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,
  61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,
  61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,
  61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,
  61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,
  61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,
  61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,
  63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,
  63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,
  63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,
  63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,
  63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,
  63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,
  63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,
  63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,66,11,43,66,11,43,66,11,43,66,11,43,
  66,11,43,66,11,43,66,11,43,66,11,43,66,11,43,66,11,43,
  66,11,43,66,11,43,66,11,43,66,11,43,66,11,43,66,11,43,
  66,11,43,66,11,43,66,11,43,66,11,43,66,11,43,66,11,43,
  66,11,43,66,11,43,66,11,43,66,11,43,66,11,43,66,11,43,
  66,11,43,66,11,43,66,11,43,66,11,43,66,11,43,66,11,43,
  66,11,43,66,11,43,66,11,43,66,11,43,66,11,43,66,11,43,
  66,11,43,66,11,43,66,11,43,66,11,43,66,11,43,66,11,43,
  66,11,43,66,11,43,66,11,43,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,69,11,41,69,11,41,69,11,41,
  69,11,41,69,11,41,69,11,41,69,11,41,69,11,41,69,11,41,
  69,11,41,69,11,41,69,11,41,69,11,41,69,11,41,69,11,41,
  69,11,41,69,11,41,69,11,41,69,11,41,69,11,41,69,11,41,
  69,11,41,69,11,41,69,11,41,69,11,41,69,11,41,69,11,41,
  69,11,41,69,11,41,69,11,41,69,11,41,69,11,41,69,11,41,
  69,11,41,69,11,41,69,11,41,69,11,41,69,11,41,69,11,41,
  69,11,41,69,11,41,69,11,41,69,11,41,69,11,41,69,11,41,
  69,11,41,69,11,41,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,72,11,40,72,11,40,
  72,11,40,72,11,40,72,11,40,72,11,40,72,11,40,72,11,40,
  72,11,40,72,11,40,72,11,40,72,11,40,72,11,40,72,11,40,
  72,11,40,72,11,40,72,11,40,72,11,40,72,11,40,72,11,40,
  72,11,40,72,11,40,72,11,40,72,11,40,72,11,40,72,11,40,
  72,11,40,72,11,40,72,11,40,72,11,40,72,11,40,72,11,40,
  72,11,40,72,11,40,72,11,40,72,11,40,72,11,40,72,11,40,
  72,11,40,72,11,40,72,11,40,72,11,40,72,11,40,72,11,40,
  72,11,40,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,74,11,39,
  74,11,39,74,11,39,74,11,39,74,11,39,74,11,39,74,11,39,
  74,11,39,74,11,39,74,11,39,74,11,39,74,11,39,74,11,39,
  74,11,39,74,11,39,74,11,39,74,11,39,74,11,39,74,11,39,
  74,11,39,74,11,39,74,11,39,74,11,39,74,11,39,74,11,39,
  74,11,39,74,11,39,74,11,39,74,11,39,74,11,39,74,11,39,
  74,11,39,74,11,39,74,11,39,74,11,39,74,11,39,74,11,39,
  74,11,39,74,11,39,74,11,39,74,11,39,74,11,39,74,11,39,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  77,11,37,77,11,37,77,11,37,77,11,37,77,11,37,77,11,37,
  77,11,37,77,11,37,77,11,37,77,11,37,77,11,37,77,11,37,
  77,11,37,77,11,37,77,11,37,77,11,37,77,11,37,77,11,37,
  77,11,37,77,11,37,77,11,37,77,11,37,77,11,37,77,11,37,
  77,11,37,77,11,37,77,11,37,77,11,37,77,11,37,77,11,37,
  77,11,37,77,11,37,77,11,37,77,11,37,77,11,37,77,11,37,
  77,11,37,77,11,37,77,11,37,77,11,37,77,11,37,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,80,12,36,80,12,36,80,12,36,80,12,36,80,12,36,
  80,12,36,80,12,36,80,12,36,80,12,36,80,12,36,80,12,36,
  80,12,36,80,12,36,80,12,36,80,12,36,80,12,36,80,12,36,
  80,12,36,80,12,36,80,12,36,80,12,36,80,12,36,80,12,36,
  80,12,36,80,12,36,80,12,36,80,12,36,80,12,36,80,12,36,
  80,12,36,80,12,36,80,12,36,80,12,36,80,12,36,80,12,36,
  80,12,36,80,12,36,80,12,36,80,12,36,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,82,12,34,82,12,34,82,12,34,82,12,34,
  82,12,34,82,12,34,82,12,34,82,12,34,82,12,34,82,12,34,
  82,12,34,82,12,34,82,12,34,82,12,34,82,12,34,82,12,34,
  82,12,34,82,12,34,82,12,34,82,12,34,82,12,34,82,12,34,
  82,12,34,82,12,34,82,12,34,82,12,34,82,12,34,82,12,34,
  82,12,34,82,12,34,82,12,34,82,12,34,82,12,34,82,12,34,
  82,12,34,82,12,34,82,12,34,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,85,12,33,85,12,33,85,12,33,
  85,12,33,85,12,33,85,12,33,85,12,33,85,12,33,85,12,33,
  85,12,33,85,12,33,85,12,33,85,12,33,85,12,33,85,12,33,
  85,12,33,85,12,33,85,12,33,85,12,33,85,12,33,85,12,33,
  85,12,33,85,12,33,85,12,33,85,12,33,85,12,33,85,12,33,
  85,12,33,85,12,33,85,12,33,85,12,33,85,12,33,85,12,33,
  85,12,33,85,12,33,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,88,12,32,88,12,32,
  88,12,32,88,12,32,88,12,32,88,12,32,88,12,32,88,12,32,
  88,12,32,88,12,32,88,12,32,88,12,32,88,12,32,88,12,32,
  88,12,32,88,12,32,88,12,32,88,12,32,88,12,32,88,12,32,
  88,12,32,88,12,32,88,12,32,88,12,32,88,12,32,88,12,32,
  88,12,32,88,12,32,88,12,32,88,12,32,88,12,32,88,12,32,
  88,12,32,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,91,12,30,
  91,12,30,91,12,30,91,12,30,91,12,30,91,12,30,91,12,30,
  91,12,30,91,12,30,91,12,30,91,12,30,91,12,30,91,12,30,
  91,12,30,91,12,30,91,12,30,91,12,30,91,12,30,91,12,30,
  91,12,30,91,12,30,91,12,30,91,12,30,91,12,30,91,12,30,
  91,12,30,91,12,30,91,12,30,91,12,30,91,12,30,91,12,30,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,93,13,29,
  93,13,29,93,13,29,93,13,29,93,13,29,93,13,29,93,13,29,
  93,13,29,93,13,29,93,13,29,93,13,29,93,13,29,93,13,29,
  93,13,29,93,13,29,93,13,29,93,13,29,93,13,29,93,13,29,
  93,13,29,93,13,29,93,13,29,93,13,29,93,13,29,93,13,29,
  93,13,29,93,13,29,93,13,29,93,13,29,93,13,29,93,13,29,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,93,13,29,
  96,13,27,96,13,27,96,13,27,96,13,27,96,13,27,96,13,27,
  96,13,27,96,13,27,96,13,27,96,13,27,96,13,27,96,13,27,
  96,13,27,96,13,27,96,13,27,96,13,27,96,13,27,96,13,27,
  96,13,27,96,13,27,96,13,27,96,13,27,96,13,27,96,13,27,
  96,13,27,96,13,27,96,13,27,96,13,27,96,13,27,93,13,29,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,93,13,29,
  96,13,27,99,13,26,99,13,26,99,13,26,99,13,26,99,13,26,
  99,13,26,99,13,26,99,13,26,99,13,26,99,13,26,99,13,26,
  99,13,26,99,13,26,99,13,26,99,13,26,99,13,26,99,13,26,
  99,13,26,99,13,26,99,13,26,99,13,26,99,13,26,99,13,26,
  99,13,26,99,13,26,99,13,26,99,13,26,96,13,27,93,13,29,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,93,13,29,
  96,13,27,99,13,26,102,13,24,102,13,24,102,13,24,102,13,24,
  102,13,24,102,13,24,102,13,24,102,13,24,102,13,24,102,13,24,
  102,13,24,102,13,24,102,13,24,102,13,24,102,13,24,102,13,24,
  102,13,24,102,13,24,102,13,24,102,13,24,102,13,24,102,13,24,
  102,13,24,102,13,24,102,13,24,99,13,26,96,13,27,93,13,29,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,93,13,29,
  96,13,27,99,13,26,102,13,24,104,13,23,104,13,23,104,13,23,
  104,13,23,104,13,23,104,13,23,104,13,23,104,13,23,104,13,23,
  104,13,23,104,13,23,104,13,23,104,13,23,104,13,23,104,13,23,
  104,13,23,104,13,23,104,13,23,104,13,23,104,13,23,104,13,23,
  104,13,23,104,13,23,102,13,24,99,13,26,96,13,27,93,13,29,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,93,13,29,
  96,13,27,99,13,26,102,13,24,104,13,23,107,14,22,107,14,22,
  107,14,22,107,14,22,107,14,22,107,14,22,107,14,22,107,14,22,
  107,14,22,107,14,22,107,14,22,107,14,22,107,14,22,107,14,22,
  107,14,22,107,14,22,107,14,22,107,14,22,107,14,22,107,14,22,
  107,14,22,104,13,23,102,13,24,99,13,26,96,13,27,93,13,29,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,93,13,29,
  96,13,27,99,13,26,102,13,24,104,13,23,107,14,22,110,14,20,
  110,14,20,110,14,20,110,14,20,110,14,20,110,14,20,110,14,20,
  110,14,20,110,14,20,110,14,20,110,14,20,110,14,20,110,14,20,
  110,14,20,110,14,20,110,14,20,110,14,20,110,14,20,110,14,20,
  107,14,22,104,13,23,102,13,24,99,13,26,96,13,27,93,13,29,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,93,13,29,
  96,13,27,99,13,26,102,13,24,104,13,23,107,14,22,110,14,20,
  113,14,19,113,14,19,113,14,19,113,14,19,113,14,19,113,14,19,
  113,14,19,113,14,19,113,14,19,113,14,19,113,14,19,113,14,19,
  113,14,19,113,14,19,113,14,19,113,14,19,113,14,19,110,14,20,
  107,14,22,104,13,23,102,13,24,99,13,26,96,13,27,93,13,29,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,93,13,29,
  96,13,27,99,13,26,102,13,24,104,13,23,107,14,22,110,14,20,
  113,14,19,115,14,17,115,14,17,115,14,17,115,14,17,115,14,17,
  115,14,17,115,14,17,115,14,17,115,14,17,115,14,17,115,14,17,
  115,14,17,115,14,17,115,14,17,115,14,17,113,14,19,110,14,20,
  107,14,22,104,13,23,102,13,24,99,13,26,96,13,27,93,13,29,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,93,13,29,
  96,13,27,99,13,26,102,13,24,104,13,23,107,14,22,110,14,20,
  113,14,19,115,14,17,118,14,16,118,14,16,118,14,16,118,14,16,
  118,14,16,118,14,16,118,14,16,118,14,16,118,14,16,118,14,16,
  118,14,16,118,14,16,118,14,16,115,14,17,113,14,19,110,14,20,
  107,14,22,104,13,23,102,13,24,99,13,26,96,13,27,93,13,29,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,93,13,29,
  96,13,27,99,13,26,102,13,24,104,13,23,107,14,22,110,14,20,
  113,14,19,115,14,17,118,14,16,121,15,15,121,15,15,121,15,15,
  121,15,15,121,15,15,121,15,15,121,15,15,121,15,15,121,15,15,
  121,15,15,121,15,15,118,14,16,115,14,17,113,14,19,110,14,20,
  107,14,22,104,13,23,102,13,24,99,13,26,96,13,27,93,13,29,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,93,13,29,
  96,13,27,99,13,26,102,13,24,104,13,23,107,14,22,110,14,20,
  113,14,19,115,14,17,118,14,16,121,15,15,124,15,13,124,15,13,
  124,15,13,124,15,13,124,15,13,124,15,13,124,15,13,124,15,13,
  124,15,13,121,15,15,118,14,16,115,14,17,113,14,19,110,14,20,
  107,14,22,104,13,23,102,13,24,99,13,26,96,13,27,93,13,29,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,93,13,29,
  96,13,27,99,13,26,102,13,24,104,13,23,107,14,22,110,14,20,
  113,14,19,115,14,17,118,14,16,121,15,15,124,15,13,126,15,12,
  126,15,12,126,15,12,126,15,12,126,15,12,126,15,12,126,15,12,
  124,15,13,121,15,15,118,14,16,115,14,17,113,14,19,110,14,20,
  107,14,22,104,13,23,102,13,24,99,13,26,96,13,27,93,13,29,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,93,13,29,
  96,13,27,99,13,26,102,13,24,104,13,23,107,14,22,110,14,20,
  113,14,19,115,14,17,118,14,16,121,15,15,124,15,13,126,15,12,
  129,15,10,129,15,10,129,15,10,129,15,10,129,15,10,126,15,12,
  124,15,13,121,15,15,118,14,16,115,14,17,113,14,19,110,14,20,
  107,14,22,104,13,23,102,13,24,99,13,26,96,13,27,93,13,29,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,93,13,29,
  96,13,27,99,13,26,102,13,24,104,13,23,107,14,22,110,14,20,
  113,14,19,115,14,17,118,14,16,121,15,15,124,15,13,126,15,12,
  129,15,10,132,15,9,132,15,9,132,15,9,129,15,10,126,15,12,
  124,15,13,121,15,15,118,14,16,115,14,17,113,14,19,110,14,20,
  107,14,22,104,13,23,102,13,24,99,13,26,96,13,27,93,13,29,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,93,13,29,
  96,13,27,99,13,26,102,13,24,104,13,23,107,14,22,110,14,20,
  113,14,19,115,14,17,118,14,16,121,15,15,124,15,13,126,15,12,
  129,15,10,132,15,9,135,16,8,132,15,9,129,15,10,126,15,12,
  124,15,13,121,15,15,118,14,16,115,14,17,113,14,19,110,14,20,
  107,14,22,104,13,23,102,13,24,99,13,26,96,13,27,93,13,29,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,93,13,29,
  96,13,27,99,13,26,102,13,24,104,13,23,107,14,22,110,14,20,
  113,14,19,115,14,17,118,14,16,121,15,15,124,15,13,126,15,12,
  129,15,10,132,15,9,132,15,9,132,15,9,129,15,10,126,15,12,
  124,15,13,121,15,15,118,14,16,115,14,17,113,14,19,110,14,20,
  107,14,22,104,13,23,102,13,24,99,13,26,96,13,27,93,13,29,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,93,13,29,
  96,13,27,99,13,26,102,13,24,104,13,23,107,14,22,110,14,20,
  113,14,19,115,14,17,118,14,16,121,15,15,124,15,13,126,15,12,
  129,15,10,129,15,10,129,15,10,129,15,10,129,15,10,126,15,12,
  124,15,13,121,15,15,118,14,16,115,14,17,113,14,19,110,14,20,
  107,14,22,104,13,23,102,13,24,99,13,26,96,13,27,93,13,29,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,93,13,29,
  96,13,27,99,13,26,102,13,24,104,13,23,107,14,22,110,14,20,
  113,14,19,115,14,17,118,14,16,121,15,15,124,15,13,126,15,12,
  126,15,12,126,15,12,126,15,12,126,15,12,126,15,12,126,15,12,
  124,15,13,121,15,15,118,14,16,115,14,17,113,14,19,110,14,20,
  107,14,22,104,13,23,102,13,24,99,13,26,96,13,27,93,13,29,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,93,13,29,
  96,13,27,99,13,26,102,13,24,104,13,23,107,14,22,110,14,20,
  113,14,19,115,14,17,118,14,16,121,15,15,124,15,13,124,15,13,
  124,15,13,124,15,13,124,15,13,124,15,13,124,15,13,124,15,13,
  124,15,13,121,15,15,118,14,16,115,14,17,113,14,19,110,14,20,
  107,14,22,104,13,23,102,13,24,99,13,26,96,13,27,93,13,29,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,93,13,29,
  96,13,27,99,13,26,102,13,24,104,13,23,107,14,22,110,14,20,
  113,14,19,115,14,17,118,14,16,121,15,15,121,15,15,121,15,15,
  121,15,15,121,15,15,121,15,15,121,15,15,121,15,15,121,15,15,
  121,15,15,121,15,15,118,14,16,115,14,17,113,14,19,110,14,20,
  107,14,22,104,13,23,102,13,24,99,13,26,96,13,27,93,13,29,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,93,13,29,
  96,13,27,99,13,26,102,13,24,104,13,23,107,14,22,110,14,20,
  113,14,19,115,14,17,118,14,16,118,14,16,118,14,16,118,14,16,
  118,14,16,118,14,16,118,14,16,118,14,16,118,14,16,118,14,16,
  118,14,16,118,14,16,118,14,16,115,14,17,113,14,19,110,14,20,
  107,14,22,104,13,23,102,13,24,99,13,26,96,13,27,93,13,29,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,93,13,29,
  96,13,27,99,13,26,102,13,24,104,13,23,107,14,22,110,14,20,
  113,14,19,115,14,17,115,14,17,115,14,17,115,14,17,115,14,17,
  115,14,17,115,14,17,115,14,17,115,14,17,115,14,17,115,14,17,
  115,14,17,115,14,17,115,14,17,115,14,17,113,14,19,110,14,20,
  107,14,22,104,13,23,102,13,24,99,13,26,96,13,27,93,13,29,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,93,13,29,
  96,13,27,99,13,26,102,13,24,104,13,23,107,14,22,110,14,20,
  113,14,19,113,14,19,113,14,19,113,14,19,113,14,19,113,14,19,
  113,14,19,113,14,19,113,14,19,113,14,19,113,14,19,113,14,19,
  113,14,19,113,14,19,113,14,19,113,14,19,113,14,19,110,14,20,
  107,14,22,104,13,23,102,13,24,99,13,26,96,13,27,93,13,29,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,93,13,29,
  96,13,27,99,13,26,102,13,24,104,13,23,107,14,22,110,14,20,
  110,14,20,110,14,20,110,14,20,110,14,20,110,14,20,110,14,20,
  110,14,20,110,14,20,110,14,20,110,14,20,110,14,20,110,14,20,
  110,14,20,110,14,20,110,14,20,110,14,20,110,14,20,110,14,20,
  107,14,22,104,13,23,102,13,24,99,13,26,96,13,27,93,13,29,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,93,13,29,
  96,13,27,99,13,26,102,13,24,104,13,23,107,14,22,107,14,22,
  107,14,22,107,14,22,107,14,22,107,14,22,107,14,22,107,14,22,
  107,14,22,107,14,22,107,14,22,107,14,22,107,14,22,107,14,22,
  107,14,22,107,14,22,107,14,22,107,14,22,107,14,22,107,14,22,
  107,14,22,104,13,23,102,13,24,99,13,26,96,13,27,93,13,29,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,93,13,29,
  96,13,27,99,13,26,102,13,24,104,13,23,104,13,23,104,13,23,
  104,13,23,104,13,23,104,13,23,104,13,23,104,13,23,104,13,23,
  104,13,23,104,13,23,104,13,23,104,13,23,104,13,23,104,13,23,
  104,13,23,104,13,23,104,13,23,104,13,23,104,13,23,104,13,23,
  104,13,23,104,13,23,102,13,24,99,13,26,96,13,27,93,13,29,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,93,13,29,
  96,13,27,99,13,26,102,13,24,102,13,24,102,13,24,102,13,24,
  102,13,24,102,13,24,102,13,24,102,13,24,102,13,24,102,13,24,
  102,13,24,102,13,24,102,13,24,102,13,24,102,13,24,102,13,24,
  102,13,24,102,13,24,102,13,24,102,13,24,102,13,24,102,13,24,
  102,13,24,102,13,24,102,13,24,99,13,26,96,13,27,93,13,29,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,93,13,29,
  96,13,27,99,13,26,99,13,26,99,13,26,99,13,26,99,13,26,
  99,13,26,99,13,26,99,13,26,99,13,26,99,13,26,99,13,26,
  99,13,26,99,13,26,99,13,26,99,13,26,99,13,26,99,13,26,
  99,13,26,99,13,26,99,13,26,99,13,26,99,13,26,99,13,26,
  99,13,26,99,13,26,99,13,26,99,13,26,96,13,27,93,13,29,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,93,13,29,
  96,13,27,96,13,27,96,13,27,96,13,27,96,13,27,96,13,27,
  96,13,27,96,13,27,96,13,27,96,13,27,96,13,27,96,13,27,
  96,13,27,96,13,27,96,13,27,96,13,27,96,13,27,96,13,27,
  96,13,27,96,13,27,96,13,27,96,13,27,96,13,27,96,13,27,
  96,13,27,96,13,27,96,13,27,96,13,27,96,13,27,93,13,29,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,93,13,29,
  93,13,29,93,13,29,93,13,29,93,13,29,93,13,29,93,13,29,
  93,13,29,93,13,29,93,13,29,93,13,29,93,13,29,93,13,29,
  93,13,29,93,13,29,93,13,29,93,13,29,93,13,29,93,13,29,
  93,13,29,93,13,29,93,13,29,93,13,29,93,13,29,93,13,29,
  93,13,29,93,13,29,93,13,29,93,13,29,93,13,29,93,13,29,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,91,12,30,91,12,30,
  91,12,30,91,12,30,91,12,30,91,12,30,91,12,30,91,12,30,
  91,12,30,91,12,30,91,12,30,91,12,30,91,12,30,91,12,30,
  91,12,30,91,12,30,91,12,30,91,12,30,91,12,30,91,12,30,
  91,12,30,91,12,30,91,12,30,91,12,30,91,12,30,91,12,30,
  91,12,30,91,12,30,91,12,30,91,12,30,91,12,30,91,12,30,
  91,12,30,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,88,12,32,88,12,32,88,12,32,
  88,12,32,88,12,32,88,12,32,88,12,32,88,12,32,88,12,32,
  88,12,32,88,12,32,88,12,32,88,12,32,88,12,32,88,12,32,
  88,12,32,88,12,32,88,12,32,88,12,32,88,12,32,88,12,32,
  88,12,32,88,12,32,88,12,32,88,12,32,88,12,32,88,12,32,
  88,12,32,88,12,32,88,12,32,88,12,32,88,12,32,88,12,32,
  88,12,32,88,12,32,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,85,12,33,85,12,33,85,12,33,85,12,33,
  85,12,33,85,12,33,85,12,33,85,12,33,85,12,33,85,12,33,
  85,12,33,85,12,33,85,12,33,85,12,33,85,12,33,85,12,33,
  85,12,33,85,12,33,85,12,33,85,12,33,85,12,33,85,12,33,
  85,12,33,85,12,33,85,12,33,85,12,33,85,12,33,85,12,33,
  85,12,33,85,12,33,85,12,33,85,12,33,85,12,33,85,12,33,
  85,12,33,85,12,33,85,12,33,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,82,12,34,82,12,34,82,12,34,82,12,34,82,12,34,
  82,12,34,82,12,34,82,12,34,82,12,34,82,12,34,82,12,34,
  82,12,34,82,12,34,82,12,34,82,12,34,82,12,34,82,12,34,
  82,12,34,82,12,34,82,12,34,82,12,34,82,12,34,82,12,34,
  82,12,34,82,12,34,82,12,34,82,12,34,82,12,34,82,12,34,
  82,12,34,82,12,34,82,12,34,82,12,34,82,12,34,82,12,34,
  82,12,34,82,12,34,82,12,34,82,12,34,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  80,12,36,80,12,36,80,12,36,80,12,36,80,12,36,80,12,36,
  80,12,36,80,12,36,80,12,36,80,12,36,80,12,36,80,12,36,
  80,12,36,80,12,36,80,12,36,80,12,36,80,12,36,80,12,36,
  80,12,36,80,12,36,80,12,36,80,12,36,80,12,36,80,12,36,
  80,12,36,80,12,36,80,12,36,80,12,36,80,12,36,80,12,36,
  80,12,36,80,12,36,80,12,36,80,12,36,80,12,36,80,12,36,
  80,12,36,80,12,36,80,12,36,80,12,36,80,12,36,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,77,11,37,
  77,11,37,77,11,37,77,11,37,77,11,37,77,11,37,77,11,37,
  77,11,37,77,11,37,77,11,37,77,11,37,77,11,37,77,11,37,
  77,11,37,77,11,37,77,11,37,77,11,37,77,11,37,77,11,37,
  77,11,37,77,11,37,77,11,37,77,11,37,77,11,37,77,11,37,
  77,11,37,77,11,37,77,11,37,77,11,37,77,11,37,77,11,37,
  77,11,37,77,11,37,77,11,37,77,11,37,77,11,37,77,11,37,
  77,11,37,77,11,37,77,11,37,77,11,37,77,11,37,77,11,37,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,74,11,39,74,11,39,
  74,11,39,74,11,39,74,11,39,74,11,39,74,11,39,74,11,39,
  74,11,39,74,11,39,74,11,39,74,11,39,74,11,39,74,11,39,
  74,11,39,74,11,39,74,11,39,74,11,39,74,11,39,74,11,39,
  74,11,39,74,11,39,74,11,39,74,11,39,74,11,39,74,11,39,
  74,11,39,74,11,39,74,11,39,74,11,39,74,11,39,74,11,39,
  74,11,39,74,11,39,74,11,39,74,11,39,74,11,39,74,11,39,
  74,11,39,74,11,39,74,11,39,74,11,39,74,11,39,74,11,39,
  74,11,39,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,72,11,40,72,11,40,72,11,40,
  72,11,40,72,11,40,72,11,40,72,11,40,72,11,40,72,11,40,
  72,11,40,72,11,40,72,11,40,72,11,40,72,11,40,72,11,40,
  72,11,40,72,11,40,72,11,40,72,11,40,72,11,40,72,11,40,
  72,11,40,72,11,40,72,11,40,72,11,40,72,11,40,72,11,40,
  72,11,40,72,11,40,72,11,40,72,11,40,72,11,40,72,11,40,
  72,11,40,72,11,40,72,11,40,72,11,40,72,11,40,72,11,40,
  72,11,40,72,11,40,72,11,40,72,11,40,72,11,40,72,11,40,
  72,11,40,72,11,40,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,69,11,41,69,11,41,69,11,41,69,11,41,
  69,11,41,69,11,41,69,11,41,69,11,41,69,11,41,69,11,41,
  69,11,41,69,11,41,69,11,41,69,11,41,69,11,41,69,11,41,
  69,11,41,69,11,41,69,11,41,69,11,41,69,11,41,69,11,41,
  69,11,41,69,11,41,69,11,41,69,11,41,69,11,41,69,11,41,
  69,11,41,69,11,41,69,11,41,69,11,41,69,11,41,69,11,41,
  69,11,41,69,11,41,69,11,41,69,11,41,69,11,41,69,11,41,
  69,11,41,69,11,41,69,11,41,69,11,41,69,11,41,69,11,41,
  69,11,41,69,11,41,69,11,41,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,66,11,43,66,11,43,66,11,43,66,11,43,66,11,43,
  66,11,43,66,11,43,66,11,43,66,11,43,66,11,43,66,11,43,
  66,11,43,66,11,43,66,11,43,66,11,43,66,11,43,66,11,43,
  66,11,43,66,11,43,66,11,43,66,11,43,66,11,43,66,11,43,
  66,11,43,66,11,43,66,11,43,66,11,43,66,11,43,66,11,43,
  66,11,43,66,11,43,66,11,43,66,11,43,66,11,43,66,11,43,
  66,11,43,66,11,43,66,11,43,66,11,43,66,11,43,66,11,43,
  66,11,43,66,11,43,66,11,43,66,11,43,66,11,43,66,11,43,
  66,11,43,66,11,43,66,11,43,66,11,43,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,
  63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,
  63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,
  63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,
  63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,
  63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,
  63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,
  63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,
  63,10,44,63,10,44,63,10,44,63,10,44,63,10,44,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,61,10,46,
  61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,
  61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,
  61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,
  61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,
  61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,
  61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,
  61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,
  61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,
  61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,61,10,46,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,58,10,47,58,10,47,
  58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,
  58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,
  58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,
  58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,
  58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,
  58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,
  58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,
  58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,
  58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,58,10,47,
  58,10,47,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,55,10,48,55,10,48,55,10,48,
  55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,
  55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,
  55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,
  55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,
  55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,
  55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,
  55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,
  55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,
  55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,55,10,48,
  55,10,48,55,10,48,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,52,10,50,52,10,50,52,10,50,52,10,50,
  52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,
  52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,
  52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,
  52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,
  52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,
  52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,
  52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,
  52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,
  52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,52,10,50,
  52,10,50,52,10,50,52,10,50,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,
  50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,
  50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,
  50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,
  50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,
  50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,
  50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,
  50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,
  50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,
  50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,50,9,51,
  50,9,51,50,9,51,50,9,51,50,9,51,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,
  47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,
  47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,
  47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,
  47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,
  47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,
  47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,
  47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,
  47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,
  47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,
  47,9,53,47,9,53,47,9,53,47,9,53,47,9,53,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,44,9,54,
  44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,
  44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,
  44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,
  44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,
  44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,
  44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,
  44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,
  44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,
  44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,
  44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,
  44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,44,9,54,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,41,9,56,41,9,56,
  41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,
  41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,
  41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,
  41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,
  41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,
  41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,
  41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,
  41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,
  41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,
  41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,
  41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,41,9,56,
  41,9,56,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,39,9,57,39,9,57,39,9,57,
  39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,
  39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,
  39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,
  39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,
  39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,
  39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,
  39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,
  39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,
  39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,
  39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,
  39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,39,9,57,
  39,9,57,39,9,57,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,36,8,58,36,8,58,36,8,58,36,8,58,
  36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,
  36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,
  36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,
  36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,
  36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,
  36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,
  36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,
  36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,
  36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,
  36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,
  36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,36,8,58,
  36,8,58,36,8,58,36,8,58,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,
  33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,
  33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,
  33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,
  33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,
  33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,
  33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,
  33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,
  33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,
  33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,
  33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,
  33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,33,8,60,
  33,8,60,33,8,60,33,8,60,33,8,60,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,
  30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,
  30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,
  30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,
  30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,
  30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,
  30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,
  30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,
  30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,
  30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,
  30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,
  30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,
  30,8,61,30,8,61,30,8,61,30,8,61,30,8,61,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,28,8,63,
  28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,
  28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,
  28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,
  28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,
  28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,
  28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,
  28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,
  28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,
  28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,
  28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,
  28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,
  28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,
  28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,28,8,63,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,25,8,64,25,8,64,
  25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,
  25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,
  25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,
  25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,
  25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,
  25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,
  25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,
  25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,
  25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,
  25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,
  25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,
  25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,
  25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,25,8,64,
  25,8,64,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,22,7,65,22,7,65,22,7,65,
  22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,
  22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,
  22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,
  22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,
  22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,
  22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,
  22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,
  22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,
  22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,
  22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,
  22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,
  22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,
  22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,22,7,65,
  22,7,65,22,7,65,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,19,7,67,19,7,67,19,7,67,19,7,67,
  19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,
  19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,
  19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,
  19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,
  19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,
  19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,
  19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,
  19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,
  19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,
  19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,
  19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,
  19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,
  19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,19,7,67,
  19,7,67,19,7,67,19,7,67,17,7,68,14,7,70,60,135,14,
  60,135,14,17,7,68,17,7,68,17,7,68,17,7,68,17,7,68,
  17,7,68,17,7,68,17,7,68,17,7,68,17,7,68,17,7,68,
  17,7,68,17,7,68,17,7,68,17,7,68,17,7,68,17,7,68,
  17,7,68,17,7,68,17,7,68,17,7,68,17,7,68,17,7,68,
  17,7,68,17,7,68,17,7,68,17,7,68,17,7,68,17,7,68,
  17,7,68,17,7,68,17,7,68,17,7,68,17,7,68,17,7,68,
  17,7,68,17,7,68,17,7,68,17,7,68,17,7,68,17,7,68,
  17,7,68,17,7,68,17,7,68,17,7,68,17,7,68,17,7,68,
  17,7,68,17,7,68,17,7,68,17,7,68,17,7,68,17,7,68,
  17,7,68,17,7,68,17,7,68,17,7,68,17,7,68,17,7,68,
  17,7,68,17,7,68,17,7,68,17,7,68,17,7,68,17,7,68,
  17,7,68,17,7,68,17,7,68,17,7,68,17,7,68,17,7,68,
  17,7,68,17,7,68,17,7,68,17,7,68,17,7,68,17,7,68,
  17,7,68,17,7,68,17,7,68,17,7,68,17,7,68,17,7,68,
  17,7,68,17,7,68,17,7,68,17,7,68,14,7,70,60,135,14,
  60,135,14,14,7,70,14,7,70,14,7,70,14,7,70,14,7,70,
  14,7,70,14,7,70,14,7,70,14,7,70,14,7,70,14,7,70,
  14,7,70,14,7,70,14,7,70,14,7,70,14,7,70,14,7,70,
  14,7,70,14,7,70,14,7,70,14,7,70,14,7,70,14,7,70,
  14,7,70,14,7,70,14,7,70,14,7,70,14,7,70,14,7,70,
  14,7,70,14,7,70,14,7,70,14,7,70,14,7,70,14,7,70,
  14,7,70,14,7,70,14,7,70,14,7,70,14,7,70,14,7,70,
  14,7,70,14,7,70,14,7,70,14,7,70,14,7,70,14,7,70,
  14,7,70,14,7,70,14,7,70,14,7,70,14,7,70,14,7,70,
  14,7,70,14,7,70,14,7,70,14,7,70,14,7,70,14,7,70,
  14,7,70,14,7,70,14,7,70,14,7,70,14,7,70,14,7,70,
  14,7,70,14,7,70,14,7,70,14,7,70,14,7,70,14,7,70,
  14,7,70,14,7,70,14,7,70,14,7,70,14,7,70,14,7,70,
  14,7,70,14,7,70,14,7,70,14,7,70,14,7,70,14,7,70,
  14,7,70,14,7,70,14,7,70,14,7,70,14,7,70,60,135,14,
  60,135,14,11,7,71,11,7,71,11,7,71,11,7,71,11,7,71,
  11,7,71,11,7,71,11,7,71,11,7,71,11,7,71,11,7,71,
  11,7,71,11,7,71,11,7,71,11,7,71,11,7,71,11,7,71,
  11,7,71,11,7,71,11,7,71,11,7,71,11,7,71,11,7,71,
  11,7,71,11,7,71,11,7,71,11,7,71,11,7,71,11,7,71,
  11,7,71,11,7,71,11,7,71,11,7,71,11,7,71,11,7,71,
  11,7,71,11,7,71,11,7,71,11,7,71,11,7,71,11,7,71,
  11,7,71,11,7,71,11,7,71,11,7,71,11,7,71,11,7,71,
  11,7,71,11,7,71,11,7,71,11,7,71,11,7,71,11,7,71,
  11,7,71,11,7,71,11,7,71,11,7,71,11,7,71,11,7,71,
  11,7,71,11,7,71,11,7,71,11,7,71,11,7,71,11,7,71,
  11,7,71,11,7,71,11,7,71,11,7,71,11,7,71,11,7,71,
  11,7,71,11,7,71,11,7,71,11,7,71,11,7,71,11,7,71,
  11,7,71,11,7,71,11,7,71,11,7,71,11,7,71,11,7,71,
  11,7,71,11,7,71,11,7,71,11,7,71,11,7,71,60,135,14,
  60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,
  60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,
  60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,
  60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,
  60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,
  60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,
  60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,
  60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,
  60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,
  60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,
  60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,
  60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,
  60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,
  60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,
  60,135,14,60,135,14,60,135,14,60,135,14,60,135,14,60,135,14
} ;

  /** SSCC "logo" **/
  
static unsigned char sscc_rgb[] = {
  203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,
  203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,
  203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,
  203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,
  203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,
  203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,
  203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,
  203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,
  203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,
  203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,
  203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,
  203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,
  203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,
  203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,
  203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,
  203,9,247,98,76,44,106,86,47,129,106,62,133,118,68,109,99,46,
  104,91,38,98,76,44,98,76,44,106,86,47,72,60,22,106,86,47,
  129,106,62,109,99,46,121,108,52,129,106,62,129,106,62,106,86,47,
  84,72,40,98,76,44,72,60,22,106,86,47,121,108,52,126,113,52,
  132,118,58,124,106,42,116,99,42,116,99,42,119,102,46,98,82,27,
  98,82,27,116,99,42,101,79,29,106,83,43,113,91,50,118,92,51,
  106,86,47,94,73,18,90,66,9,119,97,27,133,113,40,133,113,40,
  111,94,25,107,79,23,100,76,27,79,65,21,76,53,4,76,53,4,
  114,85,42,107,79,29,96,76,26,106,90,36,61,38,3,98,79,36,
  90,66,20,90,66,20,98,79,36,76,53,4,90,66,20,80,58,12,
  113,93,46,123,102,50,113,94,35,126,109,51,106,86,31,106,90,36,
  104,91,38,94,76,34,46,40,17,46,54,44,46,54,44,46,54,44,
  82,82,66,82,82,66,62,66,61,82,82,66,46,54,44,46,54,44,
  46,54,44,62,66,61,82,82,66,82,82,66,62,66,61,46,54,44,
  46,54,44,46,54,44,46,46,27,74,68,39,46,46,27,203,9,247,
  203,9,247,102,76,40,132,109,64,126,109,51,123,102,50,113,94,35,
  126,109,51,113,93,46,98,79,36,106,86,47,78,52,21,79,65,21,
  90,70,17,96,76,26,97,86,31,96,76,26,86,70,14,109,99,46,
  109,99,46,98,79,36,102,85,36,113,93,46,101,79,29,111,91,28,
  118,101,31,102,85,22,98,79,17,106,86,31,98,82,27,92,78,18,
  98,82,27,119,106,48,120,98,47,106,86,47,98,79,36,94,73,36,
  84,62,28,95,73,25,120,98,47,133,109,41,111,91,21,119,97,27,
  118,93,35,111,91,35,111,85,32,107,79,29,95,73,25,89,63,18,
  107,81,43,111,85,32,113,93,46,95,73,25,90,66,20,96,76,26,
  98,79,36,76,53,4,80,58,12,95,73,25,113,93,46,133,118,68,
  133,118,68,135,125,64,126,109,51,102,85,22,119,98,36,119,106,48,
  116,99,42,121,108,52,121,108,52,98,76,44,74,68,39,82,82,66,
  82,82,66,62,66,61,82,82,66,82,82,66,62,66,61,62,66,61,
  62,66,61,62,66,61,62,66,61,62,66,61,46,54,44,46,54,44,
  82,82,66,82,82,66,82,82,66,74,68,39,74,68,39,203,9,247,
  203,9,247,68,42,11,68,42,11,106,86,31,111,91,35,116,99,42,
  134,122,66,106,90,36,86,66,28,68,42,11,113,91,50,133,113,63,
  133,113,63,98,82,27,79,61,7,98,82,27,133,113,63,97,86,31,
  95,76,20,96,76,26,102,85,36,84,63,11,95,76,20,106,85,24,
  111,91,28,124,106,42,127,105,49,106,82,30,113,94,35,119,102,46,
  113,94,35,104,91,38,102,85,36,96,76,26,86,66,28,104,80,41,
  106,86,47,120,98,47,110,87,27,106,83,20,111,94,25,111,91,21,
  98,76,13,98,76,19,106,82,30,114,85,42,100,76,27,90,66,20,
  100,76,27,95,73,25,89,63,18,90,66,20,95,73,25,96,76,26,
  109,99,46,97,86,31,121,108,52,104,91,38,84,63,11,109,99,46,
  132,118,58,119,98,36,102,85,22,116,99,42,102,85,22,106,90,36,
  120,98,47,123,102,50,121,108,52,109,99,46,94,76,34,64,61,30,
  64,61,30,74,68,39,82,82,66,58,53,30,64,61,30,46,54,44,
  46,46,27,46,54,44,46,54,44,62,66,61,82,82,66,82,82,66,
  46,46,27,46,46,27,46,46,27,62,66,61,46,54,44,203,9,247,
  203,9,247,102,76,40,98,79,36,94,73,18,90,66,9,98,79,17,
  113,94,35,90,66,20,90,66,20,106,83,43,98,79,36,80,58,12,
  84,63,11,95,76,20,106,90,36,104,91,38,97,86,31,129,117,53,
  123,112,52,113,94,35,132,118,58,133,113,63,119,102,46,106,86,31,
  102,85,22,90,73,15,90,73,15,106,86,31,116,99,42,123,112,52,
  135,125,64,132,118,58,123,112,52,104,91,38,98,79,36,98,79,36,
  96,76,26,106,86,31,126,109,51,119,98,36,111,94,25,118,101,31,
  119,98,36,113,94,35,111,85,32,114,85,42,95,73,25,100,76,27,
  114,85,42,94,73,18,84,63,11,101,79,29,101,79,29,109,99,46,
  119,102,46,97,86,31,92,78,18,119,102,46,104,91,38,79,61,7,
  109,99,46,134,122,55,135,117,53,106,86,31,116,99,42,120,98,47,
  113,93,46,91,69,25,84,63,11,86,70,14,79,65,21,98,76,44,
  82,82,66,74,68,39,74,68,39,82,82,66,74,68,39,46,46,27,
  46,40,17,64,61,30,82,82,66,74,68,39,46,46,27,64,61,30,
  82,82,66,82,82,66,62,66,61,62,66,61,46,54,44,203,9,247,
  203,9,247,129,106,62,113,93,46,84,63,11,61,38,3,79,61,7,
  119,102,46,106,90,36,79,65,21,78,52,21,86,66,28,96,76,26,
  106,90,36,98,82,27,92,78,18,86,70,14,84,63,11,90,73,15,
  90,73,15,103,88,22,134,122,55,135,125,64,98,82,27,106,86,31,
  95,76,20,113,94,35,113,94,35,111,91,35,104,91,38,102,85,22,
  92,78,18,68,42,11,79,61,7,96,76,26,97,86,31,119,106,48,
  121,108,52,124,106,42,116,99,42,113,94,35,119,102,46,124,106,42,
  106,85,24,106,85,24,90,73,15,98,79,36,98,79,36,100,76,27,
  123,102,50,100,76,27,113,94,35,61,38,3,134,122,66,135,125,64,
  135,131,62,132,118,58,135,131,62,119,106,48,119,102,46,97,86,31,
  92,78,18,124,108,40,135,117,53,106,86,31,95,73,25,106,90,36,
  118,92,51,91,69,25,106,86,47,94,76,34,106,86,47,106,86,47,
  82,82,66,82,82,66,82,82,66,82,82,66,46,40,17,46,46,27,
  58,53,30,74,68,39,82,82,66,82,82,66,82,82,66,82,82,66,
  46,46,27,74,68,39,58,53,30,46,54,44,62,66,61,203,9,247,
  203,9,247,68,42,11,80,58,12,102,85,36,123,102,50,116,99,42,
  98,82,27,95,73,25,104,80,41,86,66,28,89,71,33,80,58,12,
  102,85,36,86,70,14,96,76,26,98,82,27,104,91,38,92,78,18,
  92,78,18,79,61,7,90,69,7,98,79,17,102,85,22,96,76,26,
  94,73,18,90,70,17,95,76,20,101,79,18,102,85,22,97,86,31,
  119,102,46,126,113,52,113,100,43,104,91,38,98,82,27,126,113,52,
  132,118,58,129,117,53,129,117,53,104,91,38,92,78,18,132,118,58,
  135,125,64,119,98,36,98,79,17,61,38,3,95,73,25,133,118,68,
  134,122,66,126,109,51,132,114,49,94,76,12,61,38,3,104,91,38,
  135,131,62,135,125,64,119,102,46,135,125,64,132,118,58,135,125,64,
  104,91,38,124,106,42,106,85,24,84,63,11,84,63,11,89,71,33,
  86,66,28,86,66,28,98,76,44,106,86,47,84,72,40,78,55,31,
  64,61,30,82,82,66,58,53,30,46,46,27,74,68,39,64,61,30,
  74,68,39,84,72,40,84,72,40,133,118,68,84,72,40,58,46,21,
  64,61,30,74,68,39,74,68,39,62,66,61,62,66,61,203,9,247,
  203,9,247,104,91,38,91,69,25,91,69,25,86,70,14,95,76,20,
  84,63,11,91,69,25,113,91,50,118,92,51,106,83,43,102,85,36,
  96,76,26,104,91,38,133,113,63,121,108,52,126,113,52,129,117,53,
  122,113,38,119,108,36,135,128,60,135,117,53,119,106,48,119,102,46,
  120,98,47,113,93,46,106,86,31,94,76,12,90,69,7,104,91,38,
  92,78,18,104,91,38,135,125,64,132,118,58,134,122,66,126,113,52,
  135,128,60,135,128,60,135,131,62,119,102,46,86,70,14,76,53,4,
  92,78,18,103,88,22,116,99,42,90,66,20,89,63,18,95,73,25,
  126,109,51,135,125,64,131,110,48,132,114,49,110,96,29,76,53,4,
  90,73,15,113,94,35,113,100,43,84,63,11,126,113,52,104,91,38,
  126,109,51,115,98,28,135,125,64,126,109,51,96,76,26,79,65,21,
  78,56,17,84,62,28,89,66,40,98,76,44,89,66,40,98,76,44,
  113,91,50,82,82,66,98,76,44,106,86,47,72,60,22,106,86,47,
  98,76,44,98,76,44,106,86,47,94,76,34,113,91,50,113,91,50,
  94,76,34,98,76,44,84,72,40,64,61,30,62,66,61,203,9,247,
  203,9,247,109,99,46,102,85,36,109,99,46,106,90,36,94,73,18,
  123,102,50,102,85,36,76,53,4,80,58,12,80,58,12,95,73,25,
  90,66,20,102,85,36,96,76,26,84,63,11,113,94,35,103,88,22,
  133,125,50,130,117,42,119,105,30,124,106,42,132,118,58,96,76,26,
  123,102,50,133,118,68,133,113,63,132,114,49,132,114,49,104,91,38,
  119,102,46,113,100,43,90,73,15,119,106,48,119,106,48,129,117,53,
  125,116,43,135,128,60,135,128,60,135,125,64,123,112,52,92,78,18,
  76,53,4,106,91,21,135,128,60,123,102,50,95,73,25,76,53,4,
  106,82,30,79,61,7,129,109,40,133,113,40,133,109,41,127,105,49,
  111,91,28,90,69,7,98,79,17,90,69,7,111,91,28,124,106,42,
  135,117,53,124,106,35,110,96,29,127,105,49,126,109,51,113,91,50,
  106,86,47,98,76,44,89,66,40,90,69,37,90,69,37,98,76,44,
  98,76,44,98,76,44,121,108,52,76,53,4,135,131,62,123,112,52,
  119,102,46,97,86,31,86,70,14,86,70,14,92,78,18,92,78,18,
  97,86,31,79,61,23,81,58,29,64,61,30,74,68,39,203,9,247,
  203,9,247,134,122,66,104,91,38,70,54,17,70,54,17,98,79,36,
  106,90,36,90,73,15,106,91,21,118,101,31,94,76,12,94,73,18,
  95,73,25,89,63,18,76,53,4,96,76,26,133,113,63,111,91,35,
  84,63,11,116,99,42,126,109,51,111,91,35,79,61,7,95,76,20,
  135,131,62,124,106,42,124,106,42,119,98,36,126,109,51,86,70,14,
  98,79,36,121,108,52,90,66,20,84,63,11,113,94,35,126,112,38,
  133,125,50,125,116,43,133,125,50,135,128,60,128,122,47,125,116,43,
  135,128,60,128,122,47,111,100,30,84,62,28,132,109,64,129,106,62,
  131,110,48,94,73,10,106,79,16,94,73,10,132,118,58,135,117,53,
  135,117,53,111,94,25,124,106,42,124,106,42,106,85,24,102,85,22,
  116,99,42,110,96,29,106,86,31,113,100,43,106,90,36,91,69,25,
  113,91,50,79,61,23,90,69,37,78,55,31,72,46,23,86,66,28,
  89,71,33,98,79,36,104,91,38,92,78,18,98,82,27,97,86,31,
  98,82,27,119,102,46,113,100,43,90,73,15,110,96,29,135,117,53,
  86,70,14,86,66,28,72,60,22,84,72,40,65,51,20,203,9,247,
  203,9,247,126,113,52,106,90,36,96,76,26,104,91,38,104,91,38,
  97,86,31,111,94,25,119,105,30,111,94,25,94,73,10,94,73,18,
  100,76,27,103,75,27,98,76,19,129,102,47,116,99,42,106,86,31,
  101,79,29,90,70,17,79,61,7,95,73,25,116,99,42,135,117,53,
  90,69,7,106,91,21,129,109,40,119,98,36,113,94,35,119,102,46,
  119,106,48,106,86,47,79,65,21,106,90,36,119,98,36,119,99,29,
  119,99,29,130,117,42,128,122,47,133,125,50,133,125,50,133,125,50,
  128,122,47,128,122,47,92,78,18,61,38,3,90,66,20,129,106,62,
  117,88,31,115,91,26,115,84,24,76,53,4,90,66,9,115,98,28,
  124,106,35,115,98,28,106,91,21,132,114,49,124,106,42,113,94,35,
  132,118,58,129,117,53,134,122,55,119,102,46,79,61,7,90,70,17,
  104,91,38,104,91,38,94,76,34,98,76,44,98,76,44,90,69,37,
  106,86,47,89,71,33,133,118,68,134,122,66,113,100,43,104,91,38,
  97,86,31,113,100,43,135,125,64,113,100,43,119,98,36,135,117,53,
  126,109,51,129,106,62,104,91,38,72,60,22,106,86,47,203,9,247,
  203,9,247,90,73,15,113,100,43,113,100,43,98,82,27,90,70,17,
  113,94,35,134,122,55,130,117,42,119,99,29,102,81,17,107,79,29,
  112,82,34,107,79,29,118,93,35,102,76,20,101,79,18,106,85,24,
  102,85,22,95,76,20,119,106,48,102,85,36,86,70,14,98,79,17,
  135,128,60,118,101,31,124,106,42,124,106,42,132,118,58,133,118,68,
  121,108,52,120,98,47,133,118,68,116,99,42,111,91,28,110,87,19,
  102,81,17,102,81,17,118,101,31,128,122,47,133,125,50,135,128,60,
  128,122,47,135,131,62,111,100,30,118,92,51,61,38,3,100,72,17,
  106,77,19,106,83,20,98,76,13,102,81,17,131,106,43,126,112,38,
  130,117,42,124,108,40,98,79,17,106,91,21,131,110,48,127,105,49,
  134,122,55,134,122,55,135,128,60,123,112,52,90,73,15,97,86,31,
  119,106,48,134,122,66,121,108,52,121,108,52,133,118,68,133,118,68,
  113,93,46,89,71,33,109,99,46,104,91,38,96,76,26,97,86,31,
  97,86,31,79,61,7,90,73,15,119,106,48,126,109,51,126,109,51,
  129,117,53,133,113,63,119,106,48,94,76,34,72,60,22,203,9,247,
  203,9,247,106,86,31,92,78,18,104,91,38,119,102,46,123,112,52,
  129,117,53,130,117,42,119,105,30,118,101,31,98,76,13,102,76,20,
  103,75,27,100,72,17,111,91,28,106,85,24,119,98,36,110,96,29,
  119,98,36,124,106,42,129,117,53,123,102,50,119,106,48,135,131,62,
  124,108,40,123,103,33,98,79,17,79,61,7,95,76,20,61,38,3,
  41,29,11,79,61,7,119,106,48,95,76,20,106,83,20,124,106,35,
  124,106,35,111,94,25,94,76,12,94,76,12,106,91,21,125,116,43,
  134,122,55,135,131,62,119,106,48,76,53,4,107,79,29,61,38,3,
  118,93,35,132,114,49,135,128,60,135,128,60,124,108,40,130,117,42,
  130,117,42,124,108,40,110,96,29,90,69,7,94,76,12,116,99,42,
  124,106,42,125,116,43,129,117,53,124,106,42,90,73,15,113,94,35,
  126,113,52,135,125,64,126,113,52,123,112,52,121,108,52,132,118,58,
  109,99,46,104,91,38,96,76,26,91,69,25,134,122,66,135,125,64,
  135,125,64,121,108,52,121,108,52,113,100,43,102,85,22,119,98,36,
  119,102,46,119,106,48,132,118,58,133,118,68,121,108,52,203,9,247,
  203,9,247,106,91,21,134,122,55,126,113,52,129,117,53,128,122,47,
  128,122,47,126,112,38,119,105,30,111,91,21,94,76,12,84,61,9,
  76,53,4,84,61,9,131,106,43,124,106,42,132,114,49,135,117,53,
  132,114,49,124,106,42,102,85,22,94,73,18,106,85,24,131,110,48,
  135,117,53,106,91,21,90,73,15,119,102,46,106,86,31,113,100,43,
  123,112,52,119,106,48,111,91,28,131,110,48,111,94,25,110,87,27,
  131,106,43,135,128,60,135,117,53,110,96,29,92,78,18,76,53,4,
  92,78,18,129,117,53,126,113,52,120,98,47,90,66,9,79,61,7,
  119,98,36,135,117,53,132,114,49,134,122,55,119,108,36,134,119,43,
  106,85,17,106,91,21,124,108,40,126,109,51,98,79,17,126,113,52,
  113,94,35,103,88,22,124,106,42,135,128,60,119,108,36,92,78,18,
  111,100,30,135,128,60,129,117,53,133,125,50,119,108,36,122,113,38,
  132,118,58,134,122,66,119,102,46,102,85,36,126,113,52,129,117,53,
  126,113,52,134,122,66,119,106,48,126,113,52,95,76,20,113,94,35,
  132,118,58,98,82,27,92,78,18,97,86,31,134,122,66,203,9,247,
  203,9,247,124,108,40,135,131,62,133,125,50,133,125,50,122,113,38,
  119,105,30,111,94,25,106,91,21,115,98,28,118,93,35,119,98,36,
  120,98,47,111,85,32,119,98,36,124,106,42,106,83,20,113,94,35,
  106,85,24,98,79,17,79,61,7,90,69,7,127,105,49,90,69,7,
  90,69,7,111,94,25,135,125,64,119,102,46,113,93,46,132,118,58,
  129,117,53,134,122,55,134,122,55,134,116,46,129,109,40,106,83,20,
  131,110,48,131,110,48,124,106,42,134,122,55,119,98,36,110,96,29,
  126,113,52,135,131,62,135,128,60,135,128,60,124,106,42,90,66,9,
  84,63,11,113,94,35,111,100,30,119,108,36,106,91,21,115,98,28,
  134,116,46,134,116,46,124,108,40,134,122,55,134,122,55,129,117,53,
  98,82,27,79,61,7,113,100,43,123,112,52,132,118,58,129,117,53,
  125,116,43,111,100,30,119,108,36,106,91,21,130,117,42,119,108,36,
  92,78,18,134,122,55,129,117,53,119,106,48,132,118,58,113,100,43,
  119,102,46,119,102,46,126,113,52,113,94,35,96,76,26,96,76,26,
  90,70,17,90,73,15,106,86,31,98,82,27,106,86,31,203,9,247,
  203,9,247,119,105,30,126,112,38,122,113,38,122,113,38,119,105,30,
  122,113,38,130,117,42,135,122,46,94,76,12,101,79,18,106,85,24,
  106,82,30,118,93,35,111,85,32,90,66,9,94,73,18,79,61,7,
  86,70,14,98,82,27,116,99,42,119,98,36,124,106,42,123,103,33,
  134,116,46,98,79,17,61,38,3,84,63,11,106,90,36,104,91,38,
  122,113,38,130,117,42,129,113,38,119,105,30,111,94,25,98,76,13,
  76,53,4,110,87,27,124,106,42,124,106,42,131,110,48,124,106,42,
  126,113,52,135,125,64,135,128,60,135,122,46,135,128,60,126,113,52,
  116,99,42,106,85,24,94,73,10,94,76,12,115,98,28,111,94,25,
  135,122,46,115,98,28,90,69,7,106,85,24,132,118,58,135,125,64,
  134,122,66,106,90,36,90,70,17,113,100,43,98,82,27,79,61,7,
  76,53,4,102,85,22,106,91,21,130,117,42,122,113,38,129,113,38,
  135,122,46,125,116,43,128,122,47,132,114,49,129,117,53,135,128,60,
  134,122,55,119,102,46,126,113,52,97,86,31,90,70,17,96,76,26,
  101,79,29,129,106,62,123,102,50,106,90,36,95,76,20,203,9,247,
  203,9,247,106,91,21,118,101,31,122,113,38,130,117,42,134,119,43,
  134,119,43,119,105,30,102,81,17,90,69,7,98,76,13,101,79,18,
  98,76,19,97,68,21,103,75,27,100,76,27,111,85,32,116,99,42,
  106,86,31,106,90,36,123,102,50,124,106,42,132,114,49,134,122,55,
  129,109,40,119,98,36,135,131,62,102,85,36,102,85,36,110,96,29,
  118,101,31,119,105,30,115,98,28,119,105,30,119,99,29,119,98,36,
  106,82,30,79,61,7,76,53,4,84,63,11,119,102,46,111,91,28,
  79,61,7,76,53,4,79,61,7,94,76,12,90,69,7,90,73,15,
  90,73,15,106,85,24,115,98,28,110,87,19,119,97,27,124,106,35,
  129,113,38,110,96,29,118,101,31,79,61,7,92,78,18,119,106,48,
  133,113,63,129,106,62,121,108,52,98,82,27,134,122,66,134,122,66,
  104,91,38,119,106,48,129,117,53,119,108,36,126,112,38,126,112,38,
  119,108,36,130,117,42,125,116,43,128,122,47,135,122,46,125,116,43,
  129,117,53,123,112,52,104,91,38,113,100,43,96,76,26,96,76,26,
  100,76,27,123,102,50,113,93,46,132,109,64,133,113,63,203,9,247,
  203,9,247,102,81,17,111,91,21,129,106,35,133,113,40,134,122,55,
  126,112,38,98,76,13,102,81,17,129,113,38,135,117,53,104,91,38,
  94,73,18,90,70,17,111,91,35,98,76,19,106,86,31,98,76,19,
  106,85,24,106,85,24,124,106,42,134,122,55,134,122,55,132,114,49,
  131,106,43,98,76,13,102,76,20,132,109,64,132,118,58,125,116,43,
  130,117,42,134,119,43,135,122,46,134,116,46,124,106,42,119,98,36,
  118,93,35,132,114,49,132,114,49,135,117,53,119,98,36,113,94,35,
  110,87,27,106,85,24,111,91,28,94,76,12,94,76,12,111,94,25,
  124,106,35,123,100,35,110,87,19,94,73,10,79,61,7,84,61,9,
  94,73,10,107,79,23,94,73,18,113,94,35,95,76,20,79,61,7,
  134,122,66,135,125,64,135,125,64,135,125,64,135,125,64,135,125,64,
  135,125,64,132,118,58,119,102,46,124,106,42,102,85,22,106,86,31,
  111,85,32,120,98,47,101,79,29,98,79,36,92,78,18,106,91,21,
  103,88,22,98,82,27,95,76,20,106,86,31,101,79,29,120,98,47,
  129,102,47,106,82,30,111,91,35,111,91,35,113,93,46,203,9,247,
  203,9,247,89,63,18,111,94,25,133,113,40,129,113,38,119,98,36,
  111,94,25,133,113,40,124,106,35,134,119,43,125,116,43,9,10,84,
  9,10,84,9,10,84,9,10,84,9,10,84,9,10,84,9,10,84,
  9,10,84,98,79,17,103,88,22,106,91,21,110,96,29,106,91,21,
  102,85,22,118,93,35,133,113,63,89,63,18,76,53,4,106,91,21,
  0,60,0,0,60,0,0,60,0,0,60,0,0,60,0,0,60,0,
  0,60,0,0,60,0,135,122,46,119,108,36,94,73,10,79,61,7,
  84,61,9,76,53,4,79,61,7,124,106,42,135,117,53,134,116,46,
  123,103,33,117,93,25,94,73,10,71,0,0,71,0,0,71,0,0,
  71,0,0,71,0,0,71,0,0,71,0,0,71,0,0,71,0,0,
  103,88,22,125,116,43,125,116,43,126,113,52,129,117,53,132,118,58,
  129,117,53,132,118,58,135,125,64,119,108,36,94,76,12,101,79,18,
  60,0,60,60,0,60,60,0,60,60,0,60,60,0,60,60,0,60,
  60,0,60,60,0,60,60,0,60,100,76,27,111,85,32,118,93,35,
  107,79,29,111,85,32,116,99,42,113,93,46,120,98,47,203,9,247,
  203,9,247,132,109,64,113,93,46,110,87,27,102,81,17,111,91,28,
  135,117,53,135,122,46,135,122,46,9,10,84,9,10,84,9,10,84,
  9,10,84,9,10,84,9,10,84,9,10,84,9,10,84,9,10,84,
  9,10,84,9,10,84,106,91,21,106,91,21,102,81,17,98,79,17,
  98,79,17,127,105,49,129,102,47,118,93,35,0,60,0,0,60,0,
  0,60,0,0,60,0,0,60,0,0,60,0,0,60,0,0,60,0,
  0,60,0,0,60,0,0,60,0,119,108,36,118,101,31,119,98,36,
  106,85,24,106,85,24,119,98,36,131,110,48,123,103,33,111,94,25,
  71,0,0,71,0,0,71,0,0,71,0,0,71,0,0,71,0,0,
  71,0,0,71,0,0,71,0,0,71,0,0,71,0,0,71,0,0,
  71,0,0,71,0,0,119,98,36,119,98,36,124,106,42,127,105,49,
  126,113,52,126,109,51,116,99,42,60,0,60,60,0,60,60,0,60,
  60,0,60,60,0,60,60,0,60,60,0,60,60,0,60,60,0,60,
  60,0,60,60,0,60,60,0,60,60,0,60,60,0,60,111,85,32,
  120,98,47,111,91,35,111,91,35,101,79,29,100,76,27,203,9,247,
  203,9,247,102,76,40,95,73,25,110,87,27,106,91,21,117,93,25,
  129,106,35,124,108,40,9,10,84,9,10,84,9,10,84,9,10,84,
  125,116,43,92,78,18,90,73,15,102,85,22,126,113,52,135,131,62,
  9,10,84,9,10,84,111,100,30,111,100,30,134,122,55,132,114,49,
  110,87,27,76,53,4,61,38,3,0,60,0,0,60,0,0,60,0,
  0,60,0,115,98,28,131,110,48,106,85,24,79,61,7,84,61,9,
  106,83,20,0,60,0,0,60,0,135,122,46,134,122,55,135,125,64,
  135,117,53,119,98,36,119,98,36,119,98,36,115,98,28,71,0,0,
  71,0,0,71,0,0,71,0,0,71,0,0,71,0,0,101,76,13,
  106,85,17,117,93,25,111,91,21,106,85,17,118,101,31,71,0,0,
  71,0,0,71,0,0,106,91,21,90,69,7,90,66,9,107,81,23,
  111,85,32,111,91,35,60,0,60,60,0,60,60,0,60,60,0,60,
  60,0,60,60,0,60,110,87,27,132,114,49,125,116,43,135,122,46,
  124,106,42,116,99,42,60,0,60,60,0,60,60,0,60,106,77,27,
  102,76,20,84,63,11,106,82,30,120,98,47,132,109,64,203,9,247,
  203,9,247,96,76,26,111,91,28,106,85,17,115,98,28,117,93,25,
  98,76,13,9,10,84,9,10,84,9,10,84,9,10,84,119,108,36,
  129,117,53,119,102,46,123,112,52,129,117,53,129,117,53,122,113,38,
  9,10,84,9,10,84,103,88,22,110,96,29,125,116,43,124,106,42,
  132,114,49,120,98,47,0,60,0,0,60,0,0,60,0,0,60,0,
  124,106,42,119,98,36,111,91,28,110,87,27,124,106,42,101,79,18,
  90,69,7,0,60,0,0,60,0,130,117,42,135,117,53,135,117,53,
  119,98,36,101,79,18,111,91,28,111,91,21,71,0,0,71,0,0,
  71,0,0,71,0,0,71,0,0,106,85,17,119,97,27,127,101,32,
  133,113,40,129,106,35,119,105,30,106,85,17,106,85,17,71,0,0,
  71,0,0,71,0,0,123,103,33,135,117,53,131,110,48,102,76,20,
  107,81,23,60,0,60,60,0,60,60,0,60,60,0,60,60,0,60,
  97,68,21,89,63,18,61,38,3,76,53,4,90,73,15,90,69,7,
  106,91,21,106,86,31,60,0,60,60,0,60,60,0,60,100,72,17,
  107,79,23,103,75,27,111,85,32,113,93,46,132,109,64,203,9,247,
  203,9,247,126,109,51,98,79,17,106,91,21,106,85,17,102,81,17,
  90,69,7,9,10,84,9,10,84,9,10,84,9,10,84,98,82,27,
  79,61,7,92,78,18,125,116,43,134,122,55,128,122,47,133,125,50,
  9,10,84,9,10,84,119,108,36,94,73,10,98,79,17,94,76,12,
  113,94,35,129,102,47,0,60,0,0,60,0,0,60,0,0,60,0,
  132,109,64,131,110,48,119,98,36,119,98,36,113,94,35,132,114,49,
  134,122,55,0,60,0,0,60,0,110,96,29,124,108,40,124,106,42,
  110,87,27,79,61,7,124,106,35,133,113,40,71,0,0,71,0,0,
  71,0,0,71,0,0,90,69,7,131,110,48,131,110,48,127,101,32,
  121,94,26,110,87,19,106,85,17,106,85,17,94,76,12,71,0,0,
  71,0,0,71,0,0,135,117,53,135,117,53,124,106,42,106,85,24,
  102,76,20,60,0,60,60,0,60,60,0,60,60,0,60,107,76,43,
  117,87,46,95,73,25,107,79,29,106,90,36,95,76,20,94,76,12,
  102,85,22,94,73,18,60,0,60,60,0,60,60,0,60,131,110,48,
  129,102,47,111,91,35,94,73,18,100,76,27,129,106,62,203,9,247,
  203,9,247,134,122,66,123,112,52,110,96,29,118,101,31,111,85,32,
  80,58,12,9,10,84,9,10,84,9,10,84,9,10,84,53,29,4,
  113,100,43,134,122,55,128,122,47,128,122,47,128,122,47,133,125,50,
  9,10,84,9,10,84,135,128,60,126,112,38,106,91,21,110,96,29,
  90,69,7,76,53,4,0,60,0,0,60,0,0,60,0,0,60,0,
  89,63,18,112,82,34,120,98,47,106,85,24,113,94,35,135,128,60,
  135,128,60,0,60,0,0,60,0,133,125,50,135,117,53,111,91,28,
  94,73,10,124,106,42,131,106,43,71,0,0,71,0,0,71,0,0,
  71,0,0,119,98,36,110,87,27,94,73,10,107,82,19,110,87,19,
  106,85,17,117,93,25,129,106,35,124,106,35,124,106,35,71,0,0,
  71,0,0,71,0,0,124,108,40,129,117,53,126,109,51,113,94,35,
  60,0,60,60,0,60,60,0,60,60,0,60,118,92,51,114,85,42,
  107,79,29,112,82,34,90,66,9,111,85,32,126,113,52,125,116,43,
  110,96,29,90,73,15,60,0,60,60,0,60,60,0,60,129,102,47,
  129,102,47,111,91,35,106,82,30,95,73,25,101,79,29,203,9,247,
  203,9,247,86,66,28,94,76,34,106,90,36,119,106,48,120,98,47,
  133,118,68,9,10,84,9,10,84,9,10,84,9,10,84,9,10,84,
  123,112,52,122,113,38,125,116,43,133,125,50,135,131,62,133,125,50,
  133,125,50,128,122,47,122,113,38,135,122,46,134,122,55,134,122,55,
  127,105,49,132,118,58,0,60,0,0,60,0,0,60,0,0,60,0,
  0,60,0,90,66,20,89,63,18,84,63,11,111,91,28,119,108,36,
  125,116,43,133,125,50,135,122,46,122,113,38,102,81,17,111,91,28,
  106,85,24,94,73,10,131,110,48,71,0,0,71,0,0,71,0,0,
  71,0,0,119,99,29,123,100,35,111,94,25,131,106,43,114,87,24,
  110,87,19,111,91,21,119,97,27,118,101,31,124,106,35,124,106,35,
  135,117,53,125,116,43,118,101,31,110,96,29,103,88,22,97,86,31,
  60,0,60,60,0,60,60,0,60,60,0,60,107,79,23,106,77,19,
  117,87,26,101,76,13,119,97,27,134,119,43,129,113,38,125,116,43,
  124,106,42,111,91,35,113,93,46,94,73,18,97,68,21,100,72,17,
  98,76,19,106,82,30,111,91,35,100,76,27,95,73,25,203,9,247,
  203,9,247,70,54,17,61,38,3,68,42,11,68,42,11,113,91,50,
  133,118,68,9,10,84,9,10,84,9,10,84,9,10,84,9,10,84,
  111,94,25,128,122,47,111,100,30,118,101,31,111,100,30,128,122,47,
  135,128,60,135,131,62,128,122,47,124,106,35,130,117,42,129,113,38,
  111,94,25,110,87,19,0,60,0,0,60,0,0,60,0,0,60,0,
  0,60,0,119,98,36,106,85,24,132,114,49,131,110,48,132,114,49,
  134,122,55,124,106,42,135,117,53,111,85,32,94,73,18,80,58,12,
  61,38,3,89,63,18,71,0,0,71,0,0,71,0,0,71,0,0,
  134,116,46,106,91,21,76,53,4,90,69,7,102,81,17,115,91,26,
  114,87,24,114,87,24,106,79,16,117,88,31,111,91,28,79,61,7,
  102,85,22,119,102,46,119,106,48,126,113,52,113,100,43,60,0,60,
  60,0,60,60,0,60,60,0,60,131,106,43,124,106,42,123,97,31,
  115,84,24,129,106,35,117,93,25,110,87,19,123,103,33,123,103,33,
  111,94,25,98,79,17,98,76,13,94,73,18,101,79,29,94,73,18,
  111,85,32,111,91,35,106,82,30,80,58,12,90,66,20,203,9,247,
  203,9,247,133,118,68,133,118,68,133,118,68,129,106,62,106,86,47,
  53,29,4,53,29,4,9,10,84,9,10,84,9,10,84,9,10,84,
  9,10,84,9,10,84,118,101,31,122,113,38,125,116,43,122,113,38,
  129,117,53,134,122,55,125,116,43,118,101,31,111,94,25,129,113,38,
  123,100,35,106,85,17,101,76,13,0,60,0,0,60,0,0,60,0,
  0,60,0,0,60,0,0,60,0,132,114,49,135,117,53,132,114,49,
  124,106,42,124,106,42,111,91,28,94,73,18,95,73,25,107,79,29,
  123,94,49,114,85,42,71,0,0,71,0,0,71,0,0,71,0,0,
  115,98,28,102,81,17,111,91,21,110,87,19,129,109,40,114,87,24,
  110,84,22,114,87,24,107,82,19,110,87,27,100,72,17,97,68,21,
  106,86,31,132,118,58,132,118,58,119,106,48,127,105,49,60,0,60,
  60,0,60,60,0,60,60,0,60,131,106,43,119,98,36,118,93,35,
  117,88,31,114,87,24,101,76,13,107,82,19,129,109,40,106,85,17,
  106,85,17,111,94,25,101,79,18,107,81,23,127,105,49,133,113,63,
  133,113,63,116,99,42,106,82,30,117,87,46,107,81,43,203,9,247,
  203,9,247,134,122,66,121,108,52,76,53,4,68,42,11,61,38,3,
  79,65,21,109,99,46,9,10,84,9,10,84,9,10,84,9,10,84,
  9,10,84,9,10,84,9,10,84,9,10,84,129,117,53,125,116,43,
  126,113,52,129,117,53,119,108,36,106,91,21,118,101,31,106,91,21,
  118,101,31,119,97,27,131,106,43,0,60,0,0,60,0,0,60,0,
  0,60,0,0,60,0,0,60,0,0,60,0,0,60,0,107,81,23,
  90,66,9,76,53,4,94,73,18,94,73,18,102,76,20,107,81,23,
  106,77,19,111,83,23,71,0,0,71,0,0,71,0,0,71,0,0,
  111,91,21,119,99,29,118,101,31,129,109,40,123,100,35,106,79,16,
  101,76,13,110,84,22,111,83,23,123,94,34,111,85,32,107,79,29,
  89,63,18,95,76,20,106,85,24,98,76,19,111,85,32,60,0,60,
  60,0,60,60,0,60,60,0,60,131,106,43,123,94,34,106,77,19,
  106,77,19,106,77,19,105,76,18,118,93,35,134,122,55,133,113,40,
  134,116,46,135,128,60,127,105,49,106,82,30,120,98,47,132,109,64,
  114,85,42,111,85,32,116,99,42,106,82,30,97,72,31,203,9,247,
  203,9,247,126,113,52,132,118,58,123,112,52,132,118,58,123,112,52,
  113,100,43,97,86,31,126,113,52,9,10,84,9,10,84,9,10,84,
  9,10,84,9,10,84,9,10,84,9,10,84,9,10,84,9,10,84,
  132,118,58,119,106,48,103,88,22,111,94,25,119,108,36,133,125,50,
  135,128,60,129,109,40,131,106,43,119,98,36,0,60,0,0,60,0,
  0,60,0,0,60,0,0,60,0,0,60,0,0,60,0,0,60,0,
  0,60,0,84,63,11,76,53,4,84,61,9,115,91,26,107,82,19,
  123,97,31,127,101,32,71,0,0,71,0,0,71,0,0,71,0,0,
  129,109,40,129,106,35,129,109,40,123,103,33,117,93,25,110,87,19,
  107,82,19,123,97,31,119,98,36,117,88,31,112,82,34,100,72,17,
  90,66,9,102,76,20,107,79,29,118,93,35,117,88,31,60,0,60,
  60,0,60,60,0,60,60,0,60,119,98,36,129,102,47,111,85,32,
  117,88,31,118,93,35,117,88,31,111,85,32,119,98,36,134,119,43,
  134,119,43,119,99,29,101,79,18,111,85,32,114,85,42,98,79,36,
  100,76,27,120,98,47,131,110,48,111,91,35,95,73,25,203,9,247,
  203,9,247,118,101,31,113,94,35,119,106,48,113,94,35,129,117,53,
  132,118,58,126,113,52,129,117,53,132,118,58,113,100,43,9,10,84,
  9,10,84,9,10,84,9,10,84,9,10,84,9,10,84,9,10,84,
  9,10,84,134,122,55,134,122,55,133,125,50,118,101,31,92,78,18,
  106,91,21,94,76,12,101,79,18,98,76,19,118,93,35,106,86,31,
  0,60,0,0,60,0,0,60,0,0,60,0,0,60,0,0,60,0,
  0,60,0,0,60,0,111,85,32,124,106,42,123,97,31,129,103,33,
  129,103,33,127,101,32,71,0,0,71,0,0,71,0,0,71,0,0,
  129,106,35,129,106,35,107,82,19,94,73,10,84,61,9,98,76,13,
  94,73,10,123,97,31,107,81,23,110,87,27,111,85,32,111,85,32,
  111,85,32,112,82,34,123,94,49,114,85,42,112,82,34,60,0,60,
  60,0,60,60,0,60,60,0,60,118,93,35,118,93,35,102,76,20,
  118,93,35,107,79,29,102,76,20,118,93,35,117,88,31,117,93,25,
  106,85,17,90,69,7,106,83,20,127,105,49,132,109,64,113,93,46,
  95,73,25,94,73,18,111,85,32,111,85,32,106,86,31,203,9,247,
  203,9,247,123,112,52,119,106,48,119,106,48,113,94,35,113,100,43,
  119,102,46,104,91,38,113,94,35,90,73,15,76,53,4,96,76,26,
  9,10,84,9,10,84,9,10,84,9,10,84,9,10,84,9,10,84,
  9,10,84,9,10,84,134,122,55,128,122,47,135,128,60,129,117,53,
  111,100,30,106,91,21,106,85,24,98,76,19,84,63,11,100,76,27,
  101,79,29,0,60,0,0,60,0,0,60,0,0,60,0,0,60,0,
  0,60,0,0,60,0,0,60,0,131,110,48,123,100,35,129,103,33,
  129,103,33,127,101,32,71,0,0,71,0,0,71,0,0,71,0,0,
  114,87,24,106,79,16,90,69,7,106,79,16,121,94,26,123,97,31,
  129,103,33,135,117,53,111,83,23,111,83,23,112,82,34,112,82,34,
  107,79,29,117,87,46,114,85,42,106,77,27,107,79,29,60,0,60,
  60,0,60,60,0,60,60,0,60,102,76,20,100,72,17,89,63,18,
  102,76,20,107,79,29,111,85,32,111,85,32,98,76,19,102,81,17,
  106,83,20,111,94,25,131,106,43,127,105,49,116,99,42,118,93,35,
  118,93,35,110,87,27,106,85,24,107,81,23,100,76,27,203,9,247,
  203,9,247,113,100,43,123,112,52,132,118,58,126,113,52,132,118,58,
  123,112,52,97,86,31,98,82,27,92,78,18,90,73,15,104,91,38,
  134,122,66,134,122,66,9,10,84,9,10,84,9,10,84,9,10,84,
  9,10,84,9,10,84,9,10,84,133,125,50,135,128,60,129,117,53,
  110,96,29,102,85,22,106,86,31,106,86,31,84,63,11,98,79,36,
  107,81,43,100,72,33,98,79,36,0,60,0,0,60,0,0,60,0,
  0,60,0,0,60,0,0,60,0,0,60,0,131,106,43,133,109,41,
  133,109,41,129,106,35,71,0,0,71,0,0,71,0,0,71,0,0,
  110,87,19,114,87,24,110,87,19,129,103,33,133,109,41,133,109,41,
  133,109,41,123,97,31,111,83,23,117,88,31,117,88,31,111,85,32,
  107,79,29,117,87,46,114,85,42,107,79,29,114,85,42,60,0,60,
  60,0,60,60,0,60,60,0,60,112,82,34,106,77,27,89,63,18,
  100,72,17,102,76,20,106,77,27,106,77,27,100,72,17,106,85,24,
  111,91,28,119,98,36,131,110,48,119,98,36,113,94,35,110,87,27,
  106,85,24,98,76,13,106,85,24,118,93,35,111,91,35,203,9,247,
  203,9,247,98,82,27,126,113,52,134,122,66,134,122,66,123,112,52,
  126,113,52,113,100,43,113,100,43,132,118,58,135,131,62,132,118,58,
  121,108,52,129,106,62,98,79,36,106,86,31,9,10,84,9,10,84,
  9,10,84,9,10,84,9,10,84,128,122,47,129,117,53,135,131,62,
  135,131,62,135,125,64,132,118,58,123,102,50,102,85,36,107,81,43,
  106,83,43,100,72,33,107,81,43,102,76,40,102,76,40,0,60,0,
  0,60,0,0,60,0,0,60,0,0,60,0,101,79,18,115,91,26,
  121,94,26,121,94,26,71,0,0,71,0,0,71,0,0,71,0,0,
  71,0,0,121,94,26,129,106,35,133,109,41,121,91,27,127,101,32,
  115,91,26,76,53,4,111,83,23,100,72,17,100,72,17,89,63,18,
  84,61,9,80,58,12,80,58,12,89,63,18,100,76,27,60,0,60,
  60,0,60,60,0,60,60,0,60,60,0,60,103,75,27,112,82,34,
  114,85,42,112,82,34,103,75,27,103,75,27,114,85,42,111,85,32,
  106,86,31,111,85,32,107,81,23,106,85,24,124,106,42,135,117,53,
  135,117,53,135,117,53,134,122,55,132,118,58,118,93,35,203,9,247,
  203,9,247,121,108,52,133,113,63,102,85,36,95,73,25,113,100,43,
  9,10,84,9,10,84,9,10,84,135,125,64,126,113,52,119,106,48,
  132,118,58,79,65,21,98,79,36,92,78,18,135,125,64,9,10,84,
  9,10,84,9,10,84,9,10,84,111,100,30,124,106,42,113,94,35,
  124,106,42,0,60,0,0,60,0,0,60,0,111,91,35,102,76,40,
  97,72,31,90,66,20,97,72,31,102,76,40,114,85,42,102,76,40,
  0,60,0,0,60,0,0,60,0,0,60,0,101,76,13,110,84,22,
  117,87,26,121,91,27,117,87,26,71,0,0,71,0,0,71,0,0,
  71,0,0,129,103,33,127,101,32,127,101,32,121,94,26,106,85,17,
  117,93,25,121,94,26,110,84,22,110,87,27,107,81,23,100,72,17,
  71,0,0,71,0,0,106,86,31,111,85,32,117,87,46,103,75,27,
  60,0,60,60,0,60,60,0,60,60,0,60,107,81,23,120,98,47,
  129,102,47,129,102,47,129,102,47,112,82,34,106,77,27,89,63,18,
  95,73,25,111,91,35,107,81,23,60,0,60,60,0,60,123,97,31,
  131,110,48,110,87,27,90,66,9,106,82,30,106,82,30,203,9,247,
  203,9,247,84,63,11,101,79,29,116,99,42,126,109,51,129,117,53,
  9,10,84,9,10,84,9,10,84,123,112,52,92,78,18,76,53,4,
  68,42,11,84,72,40,109,99,46,125,116,43,128,122,47,9,10,84,
  9,10,84,9,10,84,9,10,84,123,94,34,117,88,31,106,77,19,
  94,73,10,0,60,0,0,60,0,0,60,0,107,79,23,107,79,29,
  100,72,17,103,75,27,118,93,35,111,91,35,107,79,29,94,73,18,
  0,60,0,0,60,0,0,60,0,0,60,0,123,97,31,123,97,31,
  110,84,22,107,82,19,111,83,23,71,0,0,71,0,0,71,0,0,
  71,0,0,117,93,25,121,94,26,111,91,21,110,87,19,106,85,17,
  111,91,21,111,91,21,123,97,31,131,106,43,129,102,47,71,0,0,
  71,0,0,71,0,0,123,94,34,131,106,43,129,102,47,112,82,34,
  60,0,60,60,0,60,60,0,60,60,0,60,106,79,16,110,87,19,
  123,97,31,118,93,35,117,88,31,106,77,27,106,77,27,117,87,46,
  117,87,46,114,85,42,60,0,60,60,0,60,60,0,60,114,85,42,
  114,85,42,114,85,42,89,63,18,97,68,21,100,72,33,203,9,247,
  203,9,247,94,73,18,106,85,24,106,85,24,111,91,28,111,100,30,
  9,10,84,9,10,84,9,10,84,104,91,38,129,117,53,119,106,48,
  96,76,26,98,76,44,132,118,58,128,122,47,122,113,38,9,10,84,
  9,10,84,9,10,84,9,10,84,107,79,23,117,88,31,123,94,34,
  129,102,47,0,60,0,0,60,0,0,60,0,111,81,23,107,79,29,
  112,82,34,111,85,32,118,93,35,111,85,32,106,77,27,107,79,29,
  0,60,0,0,60,0,0,60,0,0,60,0,115,91,26,117,93,25,
  107,82,19,107,82,19,107,81,23,115,84,24,71,0,0,71,0,0,
  71,0,0,71,0,0,111,91,21,111,91,21,111,91,21,127,101,32,
  127,101,32,121,94,26,117,93,25,115,91,26,111,85,32,71,0,0,
  71,0,0,71,0,0,120,98,47,117,88,31,102,76,20,97,68,21,
  102,76,20,60,0,60,60,0,60,60,0,60,60,0,60,123,97,31,
  123,97,31,123,94,34,117,88,31,107,79,23,100,72,17,100,72,17,
  103,75,27,112,82,34,60,0,60,60,0,60,60,0,60,117,88,31,
  114,85,42,112,82,34,123,94,49,114,85,42,79,53,20,203,9,247,
  203,9,247,132,114,49,106,91,21,106,85,17,129,109,40,124,108,40,
  9,10,84,9,10,84,9,10,84,119,106,48,126,113,52,113,100,43,
  92,78,18,121,108,52,129,117,53,128,122,47,9,10,84,9,10,84,
  9,10,84,9,10,84,117,88,31,106,77,19,106,77,19,100,72,17,
  94,73,10,0,60,0,0,60,0,0,60,0,106,77,19,117,88,31,
  107,79,29,111,85,32,118,93,35,107,81,23,107,79,23,0,60,0,
  0,60,0,0,60,0,0,60,0,114,87,24,121,94,26,110,87,19,
  114,87,24,115,84,24,115,84,24,117,87,26,71,0,0,71,0,0,
  71,0,0,71,0,0,71,0,0,121,94,26,121,94,26,121,94,26,
  119,99,29,127,101,32,115,91,26,117,88,31,107,79,23,71,0,0,
  71,0,0,71,0,0,123,94,49,107,79,29,90,66,9,119,98,36,
  131,106,43,60,0,60,60,0,60,60,0,60,60,0,60,60,0,60,
  106,79,16,111,83,23,115,84,24,117,87,26,117,88,31,117,88,31,
  117,88,31,117,88,31,60,0,60,60,0,60,60,0,60,107,79,29,
  112,82,34,112,82,34,117,87,46,123,94,49,114,85,42,203,9,247,
  203,9,247,135,122,46,135,122,46,129,106,35,129,106,35,115,98,28,
  9,10,84,9,10,84,9,10,84,134,122,55,132,118,58,116,99,42,
  106,86,31,125,116,43,135,128,60,9,10,84,9,10,84,9,10,84,
  9,10,84,9,10,84,101,76,13,117,88,31,117,88,31,117,88,31,
  115,84,24,0,60,0,0,60,0,0,60,0,115,84,24,100,72,17,
  118,93,35,123,94,34,117,88,31,107,81,23,0,60,0,0,60,0,
  0,60,0,0,60,0,0,60,0,114,87,24,123,97,31,127,101,32,
  121,94,26,111,83,23,100,72,17,106,79,16,106,79,16,71,0,0,
  71,0,0,71,0,0,71,0,0,71,0,0,71,0,0,127,101,32,
  117,93,25,115,91,26,98,76,13,107,79,23,111,85,32,71,0,0,
  71,0,0,71,0,0,95,73,25,103,75,27,107,79,29,123,94,34,
  131,106,43,131,106,43,60,0,60,60,0,60,60,0,60,60,0,60,
  60,0,60,60,0,60,117,87,26,121,91,27,117,88,31,112,82,34,
  112,82,34,117,88,31,60,0,60,60,0,60,60,0,60,112,82,34,
  112,82,34,102,76,20,89,63,18,117,87,46,132,109,64,203,9,247,
  203,9,247,134,119,43,129,113,38,134,119,43,129,113,38,135,122,46,
  9,10,84,9,10,84,9,10,84,9,10,84,9,10,84,9,10,84,
  9,10,84,9,10,84,9,10,84,9,10,84,9,10,84,9,10,84,
  124,106,35,107,82,19,106,77,19,123,94,34,123,94,34,111,81,23,
  115,84,24,0,60,0,0,60,0,0,60,0,0,60,0,0,60,0,
  0,60,0,0,60,0,0,60,0,0,60,0,0,60,0,0,60,0,
  0,60,0,115,91,26,127,101,32,127,101,32,106,85,17,121,94,26,
  121,94,26,110,87,27,117,88,31,106,79,16,115,84,24,121,91,27,
  121,91,27,71,0,0,71,0,0,71,0,0,71,0,0,71,0,0,
  71,0,0,71,0,0,71,0,0,71,0,0,71,0,0,71,0,0,
  71,0,0,71,0,0,97,68,21,123,94,49,119,98,36,111,85,32,
  117,88,31,115,91,26,115,91,26,111,83,23,60,0,60,60,0,60,
  60,0,60,60,0,60,60,0,60,60,0,60,60,0,60,60,0,60,
  60,0,60,60,0,60,60,0,60,60,0,60,60,0,60,107,79,23,
  107,79,23,107,79,29,106,77,27,97,68,21,97,68,21,203,9,247,
  203,9,247,119,105,30,119,105,30,117,93,25,106,85,17,111,91,21,
  119,105,30,9,10,84,9,10,84,9,10,84,9,10,84,9,10,84,
  9,10,84,9,10,84,9,10,84,9,10,84,94,76,12,124,108,40,
  131,110,48,101,79,18,117,88,31,111,81,23,117,87,26,117,88,31,
  123,94,34,105,76,18,0,60,0,0,60,0,0,60,0,0,60,0,
  0,60,0,0,60,0,0,60,0,0,60,0,0,60,0,115,91,26,
  106,79,16,114,87,24,117,93,25,127,101,32,119,97,27,127,101,32,
  123,97,31,107,81,23,110,87,27,121,91,27,131,110,48,131,106,43,
  118,93,35,117,88,31,105,76,18,71,0,0,71,0,0,71,0,0,
  71,0,0,71,0,0,71,0,0,71,0,0,71,0,0,71,0,0,
  102,76,20,100,72,17,100,72,17,129,102,47,107,79,23,100,72,17,
  102,76,20,107,81,23,111,83,23,111,81,23,115,84,24,115,84,24,
  60,0,60,60,0,60,60,0,60,60,0,60,60,0,60,60,0,60,
  60,0,60,60,0,60,60,0,60,111,81,23,111,81,23,115,84,24,
  117,87,26,118,93,35,117,88,31,111,85,32,103,75,27,203,9,247,
  203,9,247,106,85,17,119,105,30,119,105,30,119,105,30,119,97,27,
  119,97,27,119,97,27,119,97,27,110,87,19,106,83,20,98,76,13,
  121,94,26,121,94,26,119,97,27,102,81,17,111,91,28,119,106,48,
  98,76,19,111,91,35,107,79,29,105,76,18,105,76,18,106,77,19,
  100,72,17,117,88,31,123,94,34,117,87,26,105,76,18,106,79,16,
  129,103,33,129,103,33,110,84,22,107,82,19,114,87,24,115,91,26,
  114,87,24,117,93,25,121,94,26,129,103,33,119,97,27,129,103,33,
  129,106,35,101,76,13,102,76,20,133,109,41,131,110,48,131,106,43,
  117,88,31,105,76,18,100,72,17,106,77,27,102,76,20,100,72,17,
  103,75,27,106,77,27,106,77,27,111,85,32,107,81,23,107,79,23,
  107,81,23,100,72,17,117,88,31,123,94,34,100,72,17,106,77,27,
  107,79,29,106,77,27,103,75,27,112,82,34,117,88,31,111,83,23,
  101,76,13,107,82,19,121,91,27,129,103,33,133,109,41,117,87,26,
  115,84,24,115,84,24,117,88,31,115,84,24,117,87,26,117,87,26,
  117,88,31,107,81,23,117,88,31,119,98,36,106,77,27,203,9,247,
  203,9,247,106,85,17,119,99,29,119,105,30,134,119,43,130,117,42,
  133,113,40,129,109,40,129,109,40,106,79,16,110,84,22,98,76,13,
  115,84,24,101,76,13,110,87,19,106,83,20,134,122,66,111,91,35,
  98,76,19,111,85,32,100,72,17,117,88,31,117,88,31,123,97,31,
  115,84,24,117,88,31,111,81,23,115,84,24,117,88,31,114,87,24,
  134,116,46,114,87,24,101,76,13,129,103,33,121,94,26,121,91,27,
  123,97,31,117,93,25,127,101,32,129,103,33,121,94,26,129,103,33,
  110,87,19,98,76,13,131,110,48,131,106,43,121,91,27,107,82,19,
  106,77,19,107,79,23,106,77,27,106,77,27,89,63,18,111,85,32,
  118,93,35,120,98,47,119,98,36,111,85,32,102,76,20,102,76,20,
  107,81,23,101,76,13,131,106,43,115,84,24,100,72,17,102,76,20,
  107,79,29,107,79,29,107,79,29,106,77,27,117,88,31,117,88,31,
  111,83,23,117,87,26,121,94,26,127,101,32,129,106,35,117,87,26,
  115,84,24,115,84,24,123,94,34,117,88,31,117,88,31,114,87,24,
  115,84,24,107,81,23,110,87,27,118,93,35,89,63,18,203,9,247,
  203,9,247,130,117,42,126,112,38,122,113,38,106,91,21,129,117,53,
  135,128,60,134,122,55,111,91,28,106,77,19,105,76,18,105,76,18,
  106,77,19,103,88,22,103,88,22,132,114,49,131,110,48,106,83,20,
  117,87,26,117,88,31,115,84,24,117,87,26,121,91,27,117,87,26,
  121,91,27,121,91,27,111,81,23,123,94,34,115,84,24,129,106,35,
  129,106,35,110,87,19,121,91,27,123,97,31,121,94,26,121,91,27,
  121,91,27,117,87,26,123,97,31,131,106,43,121,91,27,111,91,21,
  106,85,17,123,103,33,133,113,40,124,106,42,110,84,22,110,84,22,
  106,77,19,94,73,10,101,76,13,90,66,9,94,73,10,123,94,34,
  111,83,23,102,76,20,100,72,17,102,76,20,100,72,17,103,75,27,
  111,85,32,121,91,27,131,106,43,105,76,18,100,72,17,112,82,34,
  112,82,34,97,68,21,114,85,42,106,77,27,111,85,32,112,82,34,
  117,88,31,123,94,34,129,106,35,133,109,41,133,109,41,107,82,19,
  121,91,27,117,88,31,117,87,46,112,82,34,106,82,30,98,76,19,
  107,79,23,107,79,23,106,77,27,106,77,27,106,77,27,203,9,247,
  203,9,247,134,116,46,130,117,42,128,122,47,125,116,43,134,122,55,
  111,100,30,124,106,42,119,98,36,101,79,18,105,76,18,106,77,19,
  106,77,19,106,91,21,124,108,40,134,122,55,102,81,17,119,97,27,
  121,91,27,123,94,34,123,97,31,123,94,34,117,87,26,111,83,23,
  123,94,34,117,87,26,107,82,19,117,87,26,123,94,34,129,109,40,
  119,97,27,114,87,24,123,97,31,121,94,26,121,91,27,115,84,24,
  115,84,24,115,84,24,117,87,26,127,101,32,106,79,16,107,82,19,
  124,106,35,134,116,46,124,108,40,115,91,26,110,84,22,111,83,23,
  106,77,19,105,76,18,105,76,18,107,81,23,118,93,35,117,87,26,
  90,66,9,111,83,23,102,76,20,97,68,21,103,75,27,114,85,42,
  102,76,20,123,94,34,123,94,34,100,72,17,90,66,9,106,77,27,
  100,72,17,100,72,17,102,76,20,107,79,29,102,76,20,100,72,17,
  111,83,23,123,94,34,131,106,43,133,109,41,129,106,35,106,79,16,
  121,91,27,111,81,23,117,87,46,112,82,34,89,63,18,100,76,27,
  98,76,19,102,76,20,107,79,29,95,73,25,89,63,18,203,9,247,
  203,9,247,118,101,31,135,122,46,134,116,46,135,122,46,135,128,60,
  129,117,53,126,109,51,94,73,10,106,77,19,94,73,10,105,76,18,
  115,91,26,118,101,31,135,117,53,106,91,21,106,91,21,111,94,25,
  123,97,31,129,106,35,131,106,43,123,97,31,121,91,27,114,87,24,
  123,97,31,114,87,24,115,91,26,121,91,27,131,106,43,129,106,35,
  121,94,26,121,94,26,127,101,32,129,106,35,133,109,41,121,94,26,
  123,97,31,121,91,27,121,91,27,107,82,19,110,84,22,118,93,35,
  132,114,49,119,98,36,106,85,24,117,88,31,110,84,22,106,77,19,
  111,83,23,119,98,36,105,76,18,107,81,23,110,87,27,98,76,13,
  111,83,23,111,85,32,100,72,17,102,76,20,102,76,20,107,79,29,
  107,79,29,123,94,34,100,72,17,100,72,17,102,76,20,118,93,35,
  129,102,47,111,85,32,106,77,27,107,79,29,107,81,23,102,76,20,
  110,87,27,106,79,16,123,103,33,129,106,35,117,93,25,117,93,25,
  127,101,32,131,106,43,123,94,49,90,66,20,78,56,17,91,69,25,
  90,66,20,112,82,34,103,75,27,100,76,27,107,79,29,203,9,247,
  203,9,247,111,91,21,115,98,28,111,91,21,124,108,40,111,100,30,
  106,85,24,124,106,42,98,76,13,98,76,13,106,77,19,107,82,19,
  107,82,19,134,116,46,133,113,40,110,87,19,119,99,29,115,98,28,
  124,106,35,123,100,35,117,93,25,114,87,24,123,97,31,121,94,26,
  121,94,26,110,87,19,129,106,35,123,97,31,133,109,41,129,103,33,
  123,97,31,127,101,32,123,97,31,133,109,41,133,109,41,101,76,13,
  101,76,13,117,93,25,110,87,19,119,98,36,98,76,13,132,114,49,
  127,105,49,102,76,20,90,66,9,110,87,27,107,81,23,111,83,23,
  131,106,43,131,110,48,106,77,19,117,88,31,123,94,34,90,69,7,
  117,88,31,107,79,23,102,76,20,89,63,18,76,53,4,89,63,18,
  129,102,47,111,85,32,102,76,20,100,72,17,100,72,17,123,94,49,
  123,94,49,97,68,21,111,91,35,106,82,30,106,82,30,90,66,9,
  90,69,7,106,85,24,124,106,42,118,101,31,101,76,13,129,103,33,
  123,97,31,131,110,48,95,73,25,79,53,20,89,71,33,98,76,44,
  94,73,36,100,76,27,101,79,29,101,79,29,98,79,36,203,9,247,
  203,9,247,134,116,46,124,106,35,119,99,29,129,109,40,119,98,36,
  124,106,42,110,87,27,94,73,10,101,79,18,98,76,13,101,76,13,
  131,110,48,133,109,41,111,91,21,111,91,21,111,91,21,123,103,33,
  134,116,46,115,98,28,119,99,29,129,106,35,133,109,41,129,103,33,
  119,97,27,111,91,21,111,91,21,133,109,41,133,109,41,123,97,31,
  121,94,26,129,106,35,123,103,33,123,100,35,111,91,21,106,85,17,
  129,109,40,134,116,46,115,98,28,102,85,22,132,114,49,133,113,63,
  111,91,35,84,61,9,106,82,30,106,77,19,107,81,23,119,98,36,
  119,98,36,117,88,31,107,79,23,119,98,36,114,87,24,106,79,16,
  117,88,31,118,93,35,111,85,32,84,61,9,76,53,4,123,94,49,
  114,85,42,100,76,27,90,66,20,97,68,21,114,85,42,129,102,47,
  111,85,32,106,82,30,111,85,32,106,86,31,94,73,18,90,73,15,
  106,85,24,102,85,22,129,109,40,106,85,17,119,97,27,127,101,32,
  119,97,27,111,85,32,76,53,4,86,66,28,94,73,36,68,42,11,
  89,71,33,96,76,26,98,79,36,97,72,31,91,69,25,203,9,247,
  203,9,247,123,97,31,133,109,41,123,97,31,114,87,24,119,98,36,
  131,110,48,127,105,49,110,87,27,94,73,10,98,79,17,124,106,42,
  129,109,40,121,94,26,117,93,25,117,93,25,111,91,21,134,119,43,
  129,113,38,118,101,31,126,112,38,133,113,40,119,105,30,119,97,27,
  119,97,27,123,103,33,119,99,29,134,119,43,119,97,27,123,97,31,
  129,103,33,129,106,35,119,99,29,115,98,28,106,91,21,126,112,38,
  134,116,46,122,113,38,111,100,30,119,102,46,132,118,58,120,98,47,
  61,38,3,80,58,12,100,76,27,111,83,23,119,98,36,119,98,36,
  110,87,27,111,83,23,118,93,35,114,87,24,114,87,24,107,82,19,
  123,94,34,120,98,47,100,72,17,84,61,9,103,75,27,123,94,49,
  97,68,21,79,53,20,89,63,18,90,66,20,123,102,50,106,86,31,
  106,82,30,111,85,32,111,91,35,90,70,17,68,42,11,102,85,22,
  84,63,11,124,106,42,124,106,42,98,79,17,124,106,35,119,97,27,
  119,98,36,89,63,18,80,58,12,94,73,36,79,61,23,70,54,17,
  113,91,50,98,79,36,104,80,41,91,69,25,78,52,21,203,9,247,
  203,9,247,123,97,31,135,117,53,129,103,33,107,82,19,98,76,13,
  117,88,31,124,106,42,94,76,12,94,76,12,111,91,28,134,122,55,
  123,100,35,110,87,19,121,94,26,119,99,29,129,113,38,134,119,43,
  122,113,38,119,108,36,129,113,38,119,99,29,111,94,25,111,94,25,
  119,99,29,124,106,35,129,113,38,134,119,43,119,99,29,123,97,31,
  129,103,33,123,100,35,124,106,35,111,91,21,130,117,42,135,128,60,
  122,113,38,119,108,36,122,113,38,135,131,62,119,106,48,90,66,20,
  61,38,3,97,72,31,114,85,42,119,98,36,119,98,36,111,83,23,
  105,76,18,131,110,48,90,66,9,123,94,34,90,66,9,110,84,22,
  131,110,48,118,93,35,90,66,9,97,68,21,129,102,47,76,53,4,
  95,73,25,68,42,11,79,61,23,118,92,51,123,102,50,106,86,31,
  94,73,18,90,70,17,95,76,20,98,82,27,98,82,27,90,73,15,
  113,94,35,131,110,48,106,91,21,106,91,21,124,108,40,124,106,42,
  106,82,30,76,53,4,86,66,28,79,61,23,68,42,11,79,65,21,
  98,82,27,102,85,36,86,66,28,84,62,28,89,71,33,203,9,247,
  203,9,247,135,117,53,124,106,35,106,79,16,98,76,13,110,84,22,
  131,106,43,90,66,9,98,76,19,101,79,18,119,98,36,134,122,55,
  123,100,35,110,87,19,117,93,25,123,103,33,135,122,46,129,113,38,
  119,105,30,126,112,38,129,113,38,123,103,33,119,105,30,119,99,29,
  119,97,27,134,119,43,135,122,46,111,91,21,106,85,17,127,101,32,
  123,100,35,115,98,28,133,113,40,126,112,38,134,122,55,128,122,47,
  119,108,36,122,113,38,135,131,62,119,102,46,106,90,36,53,29,4,
  80,58,12,97,72,31,111,85,32,119,98,36,110,87,27,101,76,13,
  114,87,24,123,97,31,90,66,9,101,76,13,106,79,16,123,97,31,
  123,100,35,94,73,10,102,76,20,129,102,47,95,73,25,102,76,40,
  79,53,20,78,56,17,86,66,28,133,118,68,96,76,26,95,73,25,
  79,61,7,96,76,26,123,102,50,126,109,51,92,78,18,102,85,22,
  124,106,42,124,106,42,90,69,7,115,98,28,119,98,36,111,91,35,
  79,61,7,80,58,12,118,92,51,106,86,47,68,42,11,102,85,36,
  96,76,26,98,79,36,61,38,3,70,54,17,98,76,44,203,9,247,
  203,9,247,124,106,42,106,86,31,79,61,7,106,86,31,129,106,35,
  111,83,23,102,76,20,97,68,21,107,79,29,118,93,35,111,83,23,
  101,76,13,118,101,31,129,113,38,134,119,43,134,119,43,119,105,30,
  119,105,30,129,113,38,129,113,38,127,101,32,121,94,26,123,103,33,
  123,103,33,134,119,43,119,105,30,106,85,17,122,113,38,122,113,38,
  124,106,35,119,108,36,124,106,35,134,116,46,125,116,43,119,108,36,
  103,88,22,129,113,38,133,125,50,113,94,35,98,79,36,61,38,3,
  98,79,36,119,98,36,129,106,35,121,91,27,111,83,23,94,73,10,
  123,97,31,94,73,10,101,76,13,90,66,9,90,69,7,111,94,25,
  111,94,25,90,69,7,94,73,18,120,98,47,106,83,43,86,66,28,
  61,38,3,84,63,11,102,85,36,123,102,50,95,73,25,90,70,17,
  90,70,17,106,90,36,106,90,36,104,91,38,86,70,14,123,112,52,
  132,118,58,111,91,28,98,76,13,127,105,49,113,94,35,98,79,17,
  79,61,7,106,86,31,121,108,52,113,93,46,80,58,12,98,79,36,
  91,69,25,72,46,23,61,35,11,98,76,44,68,42,11,203,9,247,
  203,9,247,124,106,35,90,69,7,106,85,24,135,117,53,123,97,31,
  107,81,23,102,76,20,97,68,21,114,85,42,102,76,20,107,79,23,
  106,85,17,115,98,28,134,119,43,134,119,43,119,105,30,115,98,28,
  126,112,38,129,113,38,124,106,35,123,97,31,123,97,31,119,97,27,
  133,113,40,133,113,40,115,98,28,115,98,28,129,113,38,119,105,30,
  119,105,30,129,113,38,135,122,46,130,117,42,124,106,35,106,91,21,
  118,101,31,133,125,50,119,108,36,98,82,27,53,29,4,78,52,21,
  106,82,30,119,98,36,123,97,31,106,77,19,105,76,18,101,76,13,
  131,106,43,111,83,23,117,88,31,84,61,9,106,77,19,111,91,28,
  94,76,12,90,66,9,120,98,47,111,91,35,106,82,30,80,58,12,
  97,72,31,95,76,20,119,102,46,113,94,35,84,63,11,94,73,18,
  98,82,27,106,86,31,104,91,38,84,63,11,103,88,22,129,117,53,
  119,108,36,90,69,7,119,98,36,131,110,48,119,98,36,98,79,17,
  113,94,35,116,99,42,126,109,51,96,76,26,84,63,11,98,79,36,
  61,38,3,61,35,11,81,58,29,89,66,40,53,21,3,203,9,247,
  203,9,247,121,94,26,101,76,13,121,94,26,106,79,16,118,93,35,
  107,81,23,89,63,18,123,102,50,103,75,27,84,61,9,106,83,20,
  110,87,19,129,113,38,135,122,46,129,113,38,111,94,25,131,110,48,
  132,114,49,119,98,36,111,91,28,123,97,31,123,97,31,129,106,35,
  135,122,46,129,106,35,119,105,30,130,117,42,129,113,38,119,105,30,
  129,113,38,130,117,42,134,119,43,129,113,38,111,91,21,115,98,28,
  133,125,50,125,116,43,97,86,31,70,54,17,37,17,1,104,80,41,
  129,106,62,127,105,49,102,76,20,100,72,17,107,81,23,120,98,47,
  107,81,23,111,85,32,90,66,9,90,66,9,111,91,35,100,76,27,
  80,58,12,101,79,29,123,102,50,111,85,32,76,53,4,84,61,9,
  90,66,9,119,98,36,124,106,42,98,79,17,90,73,15,76,53,4,
  126,109,51,102,85,22,79,61,7,103,88,22,122,113,38,130,117,42,
  106,91,21,102,81,17,133,113,40,118,101,31,124,106,35,111,91,28,
  90,73,15,106,86,31,84,63,11,80,58,12,98,79,36,76,53,4,
  61,38,3,68,42,11,98,76,44,86,66,28,60,41,12,203,9,247,
  203,9,247,123,97,31,129,103,33,101,76,13,123,97,31,100,76,27,
  76,53,4,90,66,20,123,102,50,100,76,27,90,66,9,119,98,36,
  123,103,33,129,113,38,129,113,38,111,94,25,94,76,12,126,109,51,
  101,79,29,95,76,20,119,102,46,114,87,24,114,87,24,133,109,41,
  133,113,40,111,91,21,111,94,25,134,119,43,115,98,28,129,113,38,
  134,119,43,134,119,43,129,113,38,110,87,19,111,91,21,129,113,38,
  124,108,40,104,91,38,91,69,25,37,17,1,98,76,44,129,106,62,
  101,79,29,95,73,25,76,53,4,111,85,32,106,86,31,111,85,32,
  120,98,47,94,73,18,76,53,4,106,86,31,95,73,25,91,69,25,
  68,42,11,106,82,30,89,63,18,76,53,4,90,66,9,84,61,9,
  119,98,36,132,114,49,113,94,35,90,69,7,102,81,17,129,109,40,
  79,61,7,118,101,31,94,76,12,122,113,38,130,117,42,119,105,30,
  94,76,12,115,98,28,117,93,25,134,116,46,98,76,13,76,53,4,
  94,73,18,84,61,9,111,91,35,90,66,20,90,66,20,68,42,11,
  78,56,17,78,52,21,90,69,37,78,52,21,79,61,23,203,9,247,
  203,9,247,131,106,43,123,97,31,131,106,43,117,88,31,84,63,11,
  80,58,12,114,89,46,91,69,25,90,66,20,90,66,9,111,94,25,
  134,119,43,129,113,38,119,105,30,79,61,7,96,76,26,84,63,11,
  90,70,17,96,76,26,113,94,35,115,91,26,110,87,19,119,97,27,
  106,85,17,111,94,25,129,113,38,119,105,30,119,105,30,129,113,38,
  134,119,43,129,113,38,117,93,25,119,97,27,129,109,40,134,116,46,
  132,118,58,98,76,44,37,17,1,60,41,12,78,52,21,94,69,36,
  86,66,28,61,38,3,102,76,40,101,79,29,80,58,12,90,66,20,
  95,73,25,80,58,12,113,93,46,106,90,36,95,73,25,68,42,11,
  78,56,17,90,66,20,100,76,27,90,66,9,90,66,9,90,69,7,
  135,117,53,119,98,36,102,85,22,94,76,12,94,73,10,119,98,36,
  110,96,29,94,76,12,103,88,22,125,116,43,135,122,46,92,78,18,
  106,85,17,126,112,38,123,103,33,129,106,35,94,73,10,101,79,18,
  107,79,23,102,76,20,100,76,27,90,66,20,89,63,18,80,58,12,
  91,69,25,102,76,40,89,71,33,84,62,28,79,61,23,203,9,247,
  203,9,247,116,99,42,101,79,29,123,102,50,89,63,18,53,29,4,
  61,38,3,94,73,36,79,61,23,90,66,20,101,79,29,135,117,53,
  130,117,42,134,119,43,90,69,7,84,63,11,98,79,36,79,65,21,
  61,38,3,119,102,46,124,106,35,123,97,31,110,87,19,133,109,41,
  117,93,25,133,113,40,134,119,43,119,105,30,129,113,38,119,97,27,
  133,113,40,119,97,27,111,91,21,107,82,19,111,91,28,134,122,66,
  100,76,27,60,41,12,53,21,3,58,46,21,98,76,44,72,46,23,
  61,38,3,79,53,20,94,69,36,61,38,3,97,72,31,98,79,36,
  79,65,21,96,76,26,118,92,51,91,69,25,80,58,12,90,66,20,
  89,63,18,95,73,25,76,53,4,94,73,18,94,73,18,127,105,49,
  119,98,36,98,76,19,95,76,20,79,61,7,127,105,49,111,85,32,
  106,86,31,95,76,20,124,106,42,129,117,53,122,113,38,90,69,7,
  118,101,31,129,109,40,131,106,43,106,83,20,110,84,22,107,81,23,
  110,87,27,107,81,23,103,75,27,111,85,32,97,68,21,97,68,21,
  107,81,43,89,71,33,79,61,23,86,66,28,89,71,33,203,9,247,
  203,9,247,98,79,36,98,76,44,78,52,21,53,21,3,70,54,17,
  106,86,47,90,69,37,78,56,17,79,65,21,133,113,63,124,106,42,
  118,101,31,94,76,12,76,53,4,91,69,25,61,38,3,79,61,23,
  106,90,36,119,98,36,110,87,19,121,91,27,114,87,24,123,100,35,
  119,99,29,124,106,35,129,113,38,119,105,30,98,76,13,94,73,10,
  115,91,26,115,91,26,117,88,31,107,79,23,106,77,27,95,73,25,
  97,72,31,46,40,17,37,17,1,78,55,31,72,46,23,78,52,21,
  60,41,12,107,76,43,37,17,1,78,52,21,78,52,21,78,56,17,
  53,21,3,98,79,36,79,65,21,79,65,21,61,38,3,94,73,18,
  111,85,32,106,82,30,89,63,18,89,63,18,94,73,18,133,113,63,
  100,76,27,95,76,20,84,63,11,96,76,26,126,109,51,120,98,47,
  95,76,20,96,76,26,106,86,31,119,102,46,102,85,22,79,61,7,
  106,85,24,131,110,48,124,106,42,106,85,24,110,87,27,102,76,20,
  100,72,17,107,79,23,111,91,35,103,75,27,89,63,18,97,72,31,
  107,81,43,86,66,28,86,66,28,102,76,40,98,79,36,203,9,247,
  203,9,247,90,69,37,89,66,40,20,8,1,37,17,1,90,69,37,
  84,62,28,84,62,28,53,29,4,52,46,19,64,61,30,52,46,19,
  38,39,12,41,29,11,38,39,12,31,32,10,40,35,16,41,29,11,
  111,85,32,119,98,36,76,53,4,110,87,19,117,93,25,101,81,18,
  65,51,20,52,46,19,64,61,30,53,39,13,53,39,13,86,66,28,
  111,83,23,100,72,17,53,39,13,53,39,13,52,46,19,58,53,30,
  26,16,9,20,8,1,35,34,21,40,35,16,38,24,9,38,24,9,
  113,91,50,61,35,11,50,34,15,41,29,11,52,51,23,37,17,1,
  52,46,19,38,39,12,38,39,12,41,29,11,68,47,15,94,73,18,
  116,99,42,84,63,11,89,63,18,68,42,11,80,58,12,76,53,4,
  96,76,26,89,71,33,41,29,11,64,61,30,52,51,23,46,40,17,
  38,39,12,41,29,11,64,61,30,52,51,23,38,39,12,53,39,13,
  79,61,7,119,102,46,106,82,30,52,46,19,46,40,17,52,46,19,
  52,51,23,52,46,19,52,46,19,52,46,19,46,40,17,46,40,17,
  90,66,20,60,41,12,68,42,11,86,66,28,78,56,17,203,9,247,
  203,9,247,81,58,29,37,17,1,37,17,1,72,46,23,86,66,28,
  94,73,36,68,42,11,78,56,17,81,58,29,41,29,11,46,40,17,
  33,35,13,26,25,10,32,35,23,26,25,10,33,35,13,37,37,19,
  102,85,36,89,63,18,76,53,4,102,81,17,119,98,36,102,85,22,
  60,41,12,58,53,30,42,45,22,38,39,12,70,54,17,91,69,25,
  101,79,18,79,61,7,79,65,21,53,39,13,35,34,21,26,25,10,
  20,8,1,22,17,7,33,29,21,38,24,9,58,46,21,58,46,21,
  79,65,21,76,53,4,66,45,15,52,46,19,31,32,10,26,25,10,
  31,32,10,31,32,10,37,37,19,31,32,10,65,51,20,106,83,20,
  119,98,36,98,76,19,90,66,20,80,58,12,84,63,11,111,91,35,
  90,70,17,72,60,22,53,39,13,41,29,11,46,46,27,33,35,13,
  33,35,13,26,25,10,37,37,19,38,39,24,41,29,11,70,54,17,
  80,58,12,95,73,25,101,79,29,65,51,20,58,53,30,33,35,13,
  33,35,13,37,37,19,31,32,10,30,29,13,40,35,16,52,46,19,
  98,76,44,78,52,21,98,76,44,61,35,11,72,41,20,203,9,247,
  203,9,247,20,8,1,41,29,11,58,46,21,78,55,31,90,69,37,
  78,52,21,60,41,12,89,71,33,90,66,20,76,53,4,78,56,17,
  37,17,1,32,35,23,26,25,10,33,35,13,31,32,10,44,51,28,
  46,40,17,76,53,4,76,53,4,119,99,29,111,94,25,119,98,36,
  98,76,13,82,68,21,31,32,10,61,47,18,102,81,17,110,87,27,
  79,61,7,111,91,28,79,61,7,79,61,23,33,35,13,21,14,5,
  22,17,7,32,35,23,30,29,13,61,47,18,79,65,21,90,66,20,
  84,63,11,127,105,49,90,70,17,53,39,13,31,32,10,26,25,10,
  31,32,10,37,37,19,44,51,28,31,32,10,61,47,18,106,83,20,
  124,106,35,111,85,32,111,91,35,89,63,18,94,73,18,127,105,49,
  95,76,20,89,71,33,78,56,17,61,38,3,40,35,16,33,35,13,
  37,37,19,26,25,10,31,32,10,46,40,17,91,69,25,91,69,25,
  79,65,21,95,73,25,98,79,36,90,66,20,70,54,17,38,39,12,
  33,35,13,31,32,10,33,32,18,32,35,23,66,57,27,72,46,23,
  53,29,4,61,35,11,72,46,23,72,46,23,98,76,44,203,9,247,
  203,9,247,53,21,3,72,46,23,84,62,28,84,62,28,81,58,29,
  68,42,11,78,52,21,106,86,47,53,21,3,106,83,43,53,29,4,
  42,45,22,26,25,10,32,35,23,33,35,13,38,42,21,38,42,21,
  26,25,10,80,58,12,106,82,30,123,100,35,84,61,9,132,114,49,
  110,87,27,79,61,7,52,46,19,70,54,17,119,99,29,79,61,7,
  111,91,28,94,73,10,119,98,36,79,61,23,31,32,10,26,25,10,
  30,31,21,26,25,10,40,35,16,72,60,22,84,63,11,79,61,7,
  116,99,42,124,106,42,119,98,36,66,45,15,33,35,13,46,40,17,
  37,37,19,37,37,19,44,51,28,42,45,22,38,39,12,106,86,31,
  123,100,35,101,79,18,107,79,23,94,73,18,107,79,23,119,98,36,
  98,76,19,70,54,17,70,54,17,66,45,15,40,35,16,31,32,10,
  33,35,13,33,35,13,31,32,10,40,35,16,98,79,36,90,66,20,
  91,69,25,104,80,41,98,79,36,79,61,23,60,41,12,33,35,13,
  35,34,21,26,25,10,32,35,23,32,35,23,41,29,11,53,21,3,
  76,47,27,72,46,23,53,29,4,78,55,31,90,62,37,203,9,247,
  203,9,247,70,54,17,78,52,21,86,66,28,98,76,44,72,46,23,
  68,42,11,84,62,28,113,91,50,53,29,4,106,86,47,53,29,4,
  46,46,27,26,25,10,35,34,21,31,32,10,44,51,28,31,32,10,
  26,25,10,60,41,12,120,98,47,101,76,13,102,81,17,131,110,48,
  127,105,49,80,58,12,52,46,19,98,79,17,106,85,17,90,69,7,
  111,91,28,106,85,24,106,86,31,70,54,17,31,32,10,33,32,18,
  33,32,18,26,25,10,42,45,22,79,65,21,90,73,15,94,76,12,
  124,106,35,131,106,43,119,98,36,70,54,17,31,32,10,66,45,15,
  46,40,17,38,42,21,44,51,28,37,37,19,38,39,12,96,76,26,
  119,97,27,94,73,10,98,76,19,107,79,23,111,85,32,118,93,35,
  102,85,22,72,60,22,60,41,12,61,38,3,40,35,16,31,32,10,
  35,34,21,31,32,10,33,35,13,38,39,12,101,79,29,84,63,11,
  89,71,33,94,73,36,90,69,37,81,58,29,60,41,12,33,32,18,
  30,31,21,26,27,15,32,35,23,26,27,15,37,17,1,72,46,23,
  89,66,40,61,35,11,67,38,18,89,66,40,98,76,44,203,9,247,
  203,9,247,98,79,36,84,62,28,89,71,33,79,61,23,72,46,23,
  90,62,37,94,73,36,118,92,51,86,66,28,114,89,46,102,76,40,
  38,24,9,37,37,19,30,29,13,38,42,21,38,39,12,31,32,10,
  25,23,11,72,60,22,111,85,32,123,103,33,124,108,40,132,114,49,
  98,76,19,80,58,12,52,51,23,87,69,10,119,97,27,90,69,7,
  111,91,28,131,110,48,76,53,4,78,56,17,31,32,10,33,32,18,
  33,35,13,31,32,10,46,40,17,89,71,33,79,61,7,98,76,13,
  124,106,35,129,106,35,110,87,19,66,45,15,38,39,12,79,61,23,
  53,39,13,44,51,28,42,45,22,38,39,12,42,45,22,79,65,21,
  94,76,12,90,69,7,84,61,9,111,91,35,116,99,42,119,98,36,
  86,70,14,86,66,28,53,29,4,70,51,18,46,46,27,33,32,18,
  31,32,10,26,25,10,31,32,10,46,46,27,84,63,11,86,66,28,
  89,71,33,90,69,37,84,62,28,72,46,23,66,57,27,30,29,13,
  26,25,10,26,27,15,33,29,21,20,8,1,50,34,15,76,47,27,
  78,55,31,89,66,40,78,52,21,98,76,44,53,29,4,203,9,247,
  203,9,247,95,73,25,123,102,50,68,42,11,61,38,3,89,71,33,
  89,71,33,89,71,33,113,91,50,98,79,36,120,98,47,70,54,17,
  53,39,13,53,39,13,33,35,13,44,51,28,42,45,22,31,32,10,
  31,32,10,64,61,30,80,58,12,123,100,35,134,122,55,119,98,36,
  98,76,19,84,63,11,52,46,19,87,69,10,134,116,46,90,69,7,
  111,91,28,126,109,51,80,58,12,68,42,11,26,25,10,31,32,10,
  31,32,10,38,39,12,50,56,30,76,53,4,90,69,7,110,87,19,
  133,109,41,119,99,29,98,76,13,68,47,15,38,39,12,80,58,12,
  72,60,22,44,51,28,38,42,21,38,39,12,44,51,28,52,51,23,
  79,61,7,94,73,18,90,70,17,94,73,18,111,91,35,101,79,29,
  95,73,25,79,61,23,53,29,4,79,53,20,40,35,16,30,29,13,
  21,14,5,33,32,18,33,32,18,46,46,27,78,56,17,98,79,36,
  89,71,33,78,56,17,68,42,11,90,62,37,66,57,27,35,34,21,
  46,54,44,46,54,44,22,17,7,21,20,10,60,45,25,90,62,37,
  89,66,40,78,55,31,98,76,44,53,29,4,72,46,23,203,9,247,
  203,9,247,89,63,18,120,98,47,61,38,3,90,66,20,98,79,36,
  79,65,21,113,93,46,96,76,26,116,99,42,95,76,20,84,63,11,
  61,44,14,68,47,15,64,61,30,44,51,28,50,56,30,42,45,22,
  38,42,21,38,39,12,79,65,21,133,113,40,124,106,35,101,79,18,
  116,99,42,90,66,20,46,40,17,101,81,18,134,119,43,94,73,10,
  124,106,42,126,109,51,90,66,20,66,45,15,31,32,10,31,32,10,
  33,35,13,44,51,28,52,46,19,78,56,17,101,76,13,123,97,31,
  133,109,41,110,87,19,94,73,10,68,47,15,38,39,12,80,58,12,
  93,83,34,42,45,22,33,35,13,31,32,10,38,39,12,38,39,12,
  61,44,14,96,76,26,98,79,36,91,69,25,106,83,43,80,58,12,
  106,83,43,65,51,20,72,46,23,98,79,36,38,39,24,32,35,23,
  32,35,23,33,32,18,38,39,24,38,39,24,68,42,11,90,69,37,
  78,56,17,78,52,21,90,69,37,84,62,28,66,57,27,46,54,44,
  38,39,24,38,39,24,22,17,7,25,23,11,66,57,27,90,62,37,
  78,55,31,98,76,44,72,46,23,53,29,4,72,46,23,203,9,247,
  203,9,247,89,63,18,95,73,25,80,58,12,102,85,36,84,63,11,
  101,79,29,111,91,35,113,94,35,113,94,35,90,73,15,113,93,46,
  60,41,12,102,85,36,79,65,21,44,51,28,44,51,28,42,45,22,
  38,39,12,38,39,12,74,68,39,119,108,36,119,99,29,111,91,28,
  94,73,18,90,66,20,46,40,17,115,103,39,111,91,21,102,81,17,
  131,106,43,111,91,35,78,56,17,61,44,14,31,32,10,37,37,19,
  38,42,21,44,51,28,46,40,17,80,58,12,107,79,23,131,106,43,
  129,103,33,101,76,13,106,79,16,70,54,17,38,39,12,98,76,19,
  93,83,34,38,39,12,31,32,10,31,32,10,38,39,12,31,32,10,
  46,40,17,89,63,18,107,81,43,100,72,33,84,62,28,86,66,28,
  68,42,11,60,41,12,84,62,28,79,53,20,33,32,18,32,35,23,
  32,35,23,30,29,13,32,35,23,33,32,18,72,46,23,72,46,23,
  60,41,12,84,62,28,106,83,43,118,92,51,93,83,34,38,39,24,
  32,35,23,26,25,10,26,25,10,33,29,21,66,57,27,89,66,40,
  113,91,50,113,91,50,129,106,62,133,118,68,133,118,68,203,9,247,
  203,9,247,89,63,18,98,76,19,100,76,27,94,73,18,76,53,4,
  131,110,48,101,79,18,106,86,31,98,79,17,126,109,51,119,106,48,
  53,39,13,113,94,35,84,63,11,89,71,33,50,56,30,38,39,12,
  38,39,12,42,45,22,50,56,30,72,60,22,98,79,17,98,76,13,
  110,87,27,76,53,4,64,61,30,111,100,30,79,61,7,129,109,40,
  120,98,47,89,63,18,79,53,20,72,60,22,37,37,19,38,42,21,
  44,51,28,38,42,21,38,39,12,79,65,21,107,81,23,131,106,43,
  117,88,31,111,83,23,101,76,13,68,47,15,52,46,19,98,82,27,
  91,69,25,38,39,12,26,25,10,26,25,10,31,32,10,31,32,10,
  33,35,13,89,71,33,91,69,25,78,52,21,86,66,28,86,66,28,
  37,17,1,65,51,20,98,76,44,61,44,14,46,46,27,33,29,21,
  30,26,14,38,39,24,38,39,24,38,39,24,70,54,17,53,29,4,
  94,73,36,113,91,50,129,106,62,98,79,36,84,72,40,30,29,13,
  33,32,18,33,32,18,32,35,23,30,31,21,74,68,39,113,91,50,
  98,76,44,132,109,64,129,106,62,94,69,36,98,76,44,203,9,247,
  203,9,247,94,73,18,101,79,29,107,81,23,102,76,20,111,85,32,
  101,79,18,124,106,42,110,87,27,116,99,42,132,118,58,102,85,36,
  65,51,20,96,76,26,113,94,35,93,83,34,42,45,22,38,42,21,
  42,45,22,44,51,28,44,51,28,42,45,22,90,73,15,102,81,17,
  94,73,10,98,82,27,50,56,30,106,86,31,76,53,4,115,98,28,
  113,94,35,61,38,3,89,63,18,78,56,17,37,37,19,42,45,22,
  50,56,30,38,39,12,38,39,12,82,68,21,115,91,26,123,94,34,
  90,66,9,111,85,32,100,72,17,70,54,17,52,51,23,101,79,29,
  95,76,20,53,39,13,33,35,13,31,32,10,21,14,5,31,32,10,
  37,37,19,79,65,21,84,62,28,86,66,28,78,52,21,53,29,4,
  68,42,11,98,76,44,60,41,12,79,61,23,40,35,16,26,27,15,
  33,29,21,30,26,14,32,35,23,58,53,30,133,118,68,102,76,40,
  132,109,64,132,109,64,123,102,50,113,91,50,84,72,40,38,39,24,
  46,46,27,38,39,24,32,35,23,32,35,23,84,72,40,113,91,50,
  118,92,51,84,72,40,86,66,28,106,86,47,132,109,64,203,9,247,
  203,9,247,98,76,19,98,76,19,98,76,19,94,73,18,119,98,36,
  111,91,28,101,79,18,124,106,42,134,122,55,124,106,42,79,61,7,
  84,72,40,86,70,14,127,105,49,93,83,34,38,39,12,38,39,12,
  44,51,28,44,51,28,42,45,22,38,42,21,94,76,12,106,83,20,
  90,69,7,104,91,38,58,53,30,80,58,12,131,106,43,111,94,25,
  119,98,36,76,53,4,89,63,18,91,69,25,38,42,21,42,45,22,
  42,45,22,38,39,12,38,39,12,96,76,26,129,103,33,107,82,19,
  111,83,23,100,72,17,101,76,13,72,60,22,50,56,30,91,69,25,
  79,61,7,53,39,13,26,25,10,31,32,10,22,17,7,26,25,10,
  33,32,18,61,35,11,68,42,11,72,46,23,53,29,4,61,35,11,
  81,58,29,60,41,12,72,46,23,92,59,28,40,35,16,30,26,14,
  30,26,14,38,39,24,38,39,24,46,46,27,102,76,40,102,76,40,
  129,106,62,118,92,51,107,81,43,118,92,51,84,65,35,38,39,24,
  38,39,24,38,39,24,38,39,24,46,54,44,98,76,44,89,66,40,
  84,72,40,98,76,44,84,62,28,106,86,47,118,92,51,203,9,247,
  203,9,247,110,87,27,107,79,23,101,79,18,98,76,19,110,87,27,
  119,98,36,94,76,12,119,98,36,125,116,43,111,100,30,79,61,7,
  70,54,17,106,91,21,119,98,36,111,91,28,65,51,20,52,51,23,
  50,56,30,42,45,22,31,32,10,38,39,12,78,56,17,101,76,13,
  118,101,31,106,86,31,52,46,19,87,69,10,129,109,40,133,113,40,
  94,73,10,102,81,17,106,85,24,95,73,25,42,45,22,44,51,28,
  38,39,12,38,39,12,46,40,17,98,82,27,129,106,35,107,82,19,
  94,73,10,100,72,17,118,93,35,70,54,17,52,51,23,80,58,12,
  80,58,12,61,38,3,30,29,13,26,25,10,26,27,15,22,17,7,
  25,23,11,41,29,11,61,35,11,61,35,11,68,42,11,78,52,21,
  72,46,23,53,29,4,98,76,44,72,46,23,46,40,17,33,29,21,
  33,29,21,38,39,24,38,39,24,46,40,17,114,85,42,99,64,33,
  68,42,11,66,57,27,99,64,33,102,76,40,72,46,23,33,29,21,
  38,39,24,46,54,44,46,46,27,32,35,23,74,68,39,113,91,50,
  106,86,47,106,86,47,133,118,68,113,91,50,90,62,37,203,9,247,
  203,9,247,98,76,13,98,79,17,94,73,10,106,83,20,131,106,43,
  106,83,20,106,91,21,132,114,49,119,108,36,106,91,21,79,61,7,
  61,47,18,106,91,21,135,117,53,94,76,12,103,88,22,64,61,30,
  50,56,30,38,39,12,31,32,10,42,45,22,38,39,12,94,73,18,
  124,106,35,109,99,46,31,32,10,111,91,35,134,122,55,106,85,17,
  94,73,10,94,73,10,118,101,31,98,82,27,44,51,28,38,39,12,
  38,39,12,38,39,12,52,46,19,102,85,36,115,91,26,90,66,9,
  107,81,23,100,72,17,119,98,36,65,51,20,37,37,19,78,56,17,
  86,66,28,61,38,3,26,16,9,33,29,21,29,22,13,21,14,5,
  26,27,15,26,16,9,67,38,18,90,62,37,53,29,4,81,58,29,
  53,21,3,81,58,29,98,76,44,70,51,18,46,46,27,32,35,23,
  46,46,27,33,29,21,38,39,24,46,46,27,114,89,46,98,76,44,
  46,46,27,35,34,21,60,45,25,102,76,40,66,57,27,35,34,21,
  32,35,23,38,39,24,38,39,24,32,35,23,60,45,25,58,46,21,
  58,46,21,74,68,39,98,76,44,89,66,40,106,86,47,203,9,247,
  203,9,247,98,76,13,98,76,13,90,69,7,131,110,48,129,109,40,
  94,73,10,134,116,46,124,106,35,111,100,30,90,69,7,98,82,27,
  70,54,17,111,94,25,123,103,33,79,61,7,127,101,32,89,71,33,
  44,51,28,31,32,10,38,39,12,38,39,12,31,32,10,78,56,17,
  129,106,35,84,63,11,46,40,17,123,112,52,111,91,28,98,79,17,
  110,87,27,102,81,17,111,91,21,106,86,31,42,45,22,31,32,10,
  38,39,12,38,42,21,50,56,30,98,79,36,103,75,27,97,68,21,
  97,68,21,112,82,34,97,68,21,65,51,20,40,35,16,68,42,11,
  68,42,11,72,41,20,50,34,15,27,19,12,27,19,12,27,19,12,
  22,17,7,20,8,1,53,39,13,53,29,4,90,69,37,104,80,41,
  133,118,68,94,69,36,86,66,28,92,59,28,46,46,27,46,46,27,
  38,39,24,46,46,27,38,39,24,38,39,24,94,69,36,60,41,12,
  21,14,5,33,29,21,38,39,24,81,58,29,84,72,40,38,39,24,
  30,31,21,25,23,11,25,23,11,22,17,7,46,40,17,58,46,21,
  58,53,30,64,61,30,106,86,47,113,91,50,118,92,51,203,9,247,
  203,9,247,98,76,13,90,69,7,119,99,29,133,109,41,98,76,13,
  123,103,33,124,108,40,134,116,46,94,76,12,94,76,12,103,88,22,
  79,65,21,119,108,36,111,94,25,110,96,29,134,122,55,129,106,35,
  52,46,19,31,32,10,38,42,21,31,32,10,38,39,12,52,51,23,
  102,85,36,61,38,3,58,53,30,119,106,48,106,85,24,95,73,25,
  98,76,19,102,81,17,123,100,35,104,91,38,31,32,10,31,32,10,
  31,32,10,31,32,10,41,29,11,90,69,37,80,58,12,80,58,12,
  53,29,4,97,72,31,86,66,28,58,46,21,37,37,19,61,35,11,
  68,42,11,55,27,10,90,62,37,38,39,24,27,19,12,26,27,15,
  29,22,13,22,17,7,37,17,1,91,69,25,113,91,50,123,102,50,
  78,56,17,102,76,40,118,92,51,97,72,31,46,46,27,32,35,23,
  38,39,24,26,27,15,26,25,10,38,39,24,65,51,20,60,45,25,
  38,39,24,30,31,21,32,35,23,102,76,40,64,61,30,21,20,10,
  21,14,5,21,20,10,26,27,15,26,27,15,46,46,27,46,46,27,
  46,40,17,58,53,30,82,82,66,78,55,31,76,47,27,203,9,247,
  203,9,247,106,85,17,111,94,25,135,117,53,129,109,40,98,76,13,
  129,113,38,124,106,35,124,106,35,102,81,17,118,101,31,115,103,39,
  89,71,33,111,100,30,106,85,17,118,101,31,124,106,42,111,91,28,
  68,42,11,37,37,19,31,32,10,31,32,10,42,45,22,50,56,30,
  61,47,18,82,68,21,58,53,30,113,100,43,84,63,11,95,73,25,
  90,70,17,101,79,18,129,109,40,90,70,17,26,25,10,31,32,10,
  22,17,7,26,25,10,33,32,18,72,60,22,79,53,20,68,42,11,
  68,42,11,72,41,20,89,55,26,58,46,21,33,32,18,53,29,4,
  53,29,4,67,38,18,55,27,10,27,19,12,27,19,12,22,17,7,
  26,25,10,38,39,24,64,61,30,106,86,47,113,93,46,123,102,50,
  120,98,47,100,72,33,89,55,26,89,55,26,46,46,27,30,31,21,
  26,25,10,26,27,15,32,35,23,30,31,21,106,86,47,74,68,39,
  22,17,7,26,25,10,38,24,9,58,46,21,38,24,9,26,27,15,
  21,20,10,21,20,10,21,20,10,21,20,10,33,35,13,41,29,11,
  41,29,11,46,46,27,74,68,39,78,55,31,89,66,40,203,9,247,
  203,9,247,106,85,17,134,116,46,135,122,46,102,81,17,119,97,27,
  129,106,35,123,100,35,98,79,17,90,69,7,103,88,22,115,103,39,
  82,68,21,110,96,29,98,79,17,124,106,42,119,106,48,96,76,26,
  82,68,21,31,32,10,26,25,10,31,32,10,44,51,28,44,51,28,
  26,25,10,79,61,23,64,61,30,91,69,25,53,29,4,78,52,21,
  94,73,36,78,52,21,102,76,40,84,65,35,22,17,7,26,25,10,
  20,8,1,29,22,13,33,32,18,58,46,21,72,46,23,61,35,11,
  61,35,11,68,42,11,53,29,4,58,46,21,21,14,5,61,35,11,
  53,29,4,68,42,11,68,42,11,53,29,4,26,25,10,44,51,28,
  46,54,44,38,39,24,46,46,27,84,65,35,107,81,43,106,83,43,
  94,73,36,98,76,44,98,76,44,70,54,17,30,29,13,26,27,15,
  32,35,23,32,35,23,38,39,24,38,39,24,84,72,40,65,51,20,
  66,45,15,61,44,14,61,35,11,60,41,12,38,24,9,21,20,10,
  21,20,10,21,20,10,26,27,15,25,23,11,33,35,13,46,40,17,
  58,46,21,72,46,23,78,55,31,72,46,23,84,48,31,203,9,247,
  203,9,247,106,91,21,134,122,55,106,91,21,111,91,21,133,113,40,
  123,100,35,110,87,27,84,63,11,95,76,20,135,128,60,111,100,30,
  70,54,17,101,79,29,95,76,20,106,86,31,113,93,46,84,63,11,
  68,42,11,22,17,7,26,25,10,26,25,10,22,17,7,26,25,10,
  31,32,10,74,68,39,64,61,30,68,47,15,37,17,1,65,51,20,
  53,29,4,60,41,12,53,21,3,72,46,23,33,29,21,33,29,21,
  27,19,12,32,35,23,35,34,21,41,29,11,78,52,21,81,58,29,
  78,56,17,106,86,47,68,42,11,52,46,19,46,54,44,79,61,23,
  79,53,20,132,109,64,123,94,49,94,69,36,35,34,21,37,37,19,
  37,37,19,46,54,44,35,34,21,58,53,30,114,85,42,106,83,43,
  86,66,28,46,40,17,58,46,21,64,61,30,30,26,14,26,27,15,
  26,27,15,32,35,23,26,27,15,46,46,27,106,86,47,84,72,40,
  84,62,28,58,46,21,65,51,20,65,51,20,60,45,25,26,27,15,
  26,27,15,26,27,15,26,27,15,26,27,15,50,34,15,72,46,23,
  76,47,27,76,47,27,72,46,23,72,46,23,67,38,18,203,9,247,
  203,9,247,98,79,17,106,85,24,106,86,31,132,114,49,123,103,33,
  106,83,20,100,76,27,76,53,4,133,113,63,126,113,52,109,99,46,
  60,41,12,61,38,3,68,42,11,104,80,41,76,53,4,61,38,3,
  61,38,3,38,24,9,32,35,23,22,17,7,26,25,10,21,14,5,
  37,37,19,46,46,27,38,42,21,37,17,1,68,42,11,72,46,23,
  53,29,4,60,41,12,129,106,62,81,58,29,30,26,14,35,34,21,
  46,54,44,33,29,21,46,46,27,84,72,40,102,76,40,113,91,50,
  132,109,64,91,69,25,132,109,64,84,72,40,40,35,16,84,62,28,
  114,85,42,107,76,43,100,72,33,107,81,43,46,54,44,46,54,44,
  46,46,27,35,34,21,46,46,27,60,45,25,100,72,33,78,52,21,
  60,41,12,64,61,30,64,61,30,41,29,11,21,14,5,32,35,23,
  21,20,10,32,35,23,32,35,23,40,35,16,68,42,11,72,46,23,
  78,52,21,90,62,37,84,62,28,68,42,11,53,39,13,27,19,12,
  27,19,12,21,20,10,21,20,10,29,22,13,50,34,15,67,38,18,
  72,41,20,67,38,18,67,38,18,76,47,27,71,35,18,203,9,247,
  203,9,247,90,70,17,84,63,11,80,58,12,84,63,11,110,87,27,
  90,66,20,86,66,28,53,29,4,106,83,43,129,106,62,98,79,36,
  37,17,1,67,38,18,78,55,31,84,62,28,61,38,3,78,56,17,
  78,56,17,86,66,28,37,37,19,30,31,21,21,14,5,32,35,23,
  21,14,5,29,22,13,22,17,7,66,57,27,98,76,44,90,62,37,
  113,91,50,89,66,40,78,52,21,78,55,31,32,35,23,32,35,23,
  33,29,21,46,46,27,46,46,27,65,51,20,114,85,42,117,87,46,
  100,72,33,132,109,64,106,82,30,61,47,18,46,54,44,68,47,15,
  97,68,21,100,72,33,117,87,46,117,98,59,46,54,44,33,29,21,
  46,46,27,33,29,21,26,16,9,80,42,23,72,41,20,61,35,11,
  65,51,20,58,46,21,58,46,21,65,51,20,38,39,24,21,20,10,
  25,23,11,22,17,7,27,19,12,41,29,11,80,42,23,90,62,37,
  89,55,26,95,63,41,90,62,37,95,63,41,76,47,27,29,22,13,
  29,22,13,29,22,13,29,22,13,26,16,9,62,30,13,72,41,20,
  80,42,23,84,48,31,95,63,41,84,48,31,76,47,27,203,9,247,
  203,9,247,98,79,36,89,71,33,79,61,23,78,52,21,80,58,12,
  84,62,28,53,21,3,53,21,3,129,106,62,68,42,11,84,65,35,
  20,8,1,76,47,27,98,76,44,118,92,51,81,58,29,86,66,28,
  129,106,62,114,89,46,38,24,9,30,26,14,30,26,14,29,22,13,
  30,26,14,38,39,24,32,35,23,90,62,37,81,58,29,90,62,37,
  78,52,21,100,72,33,81,58,29,58,46,21,33,29,21,26,27,15,
  33,29,21,26,25,10,30,29,13,84,72,40,106,83,43,95,73,25,
  107,79,29,103,75,27,117,87,46,65,51,20,38,39,24,106,86,47,
  118,92,51,100,72,33,79,53,20,78,56,17,35,34,21,26,27,15,
  27,19,12,21,20,10,38,24,9,62,30,13,62,30,13,61,35,11,
  65,51,20,58,53,30,58,53,30,53,39,13,30,29,13,26,27,15,
  29,22,13,29,22,13,35,34,21,40,35,16,95,63,41,89,55,26,
  90,62,37,90,62,37,95,63,41,95,63,41,72,46,23,27,19,12,
  30,26,14,33,29,21,29,22,13,33,29,21,76,47,27,95,63,41,
  95,63,41,90,62,37,84,48,31,84,48,31,84,48,31,203,9,247,
  203,9,247,68,42,11,78,52,21,79,61,23,84,62,28,90,69,37,
  60,41,12,37,17,1,98,76,44,72,46,23,113,91,50,20,8,1,
  60,45,25,122,101,60,95,63,41,90,62,37,89,55,26,118,92,51,
  107,81,43,68,42,11,53,29,4,35,34,21,30,26,14,32,35,23,
  32,35,23,30,26,14,29,22,13,76,47,27,76,47,27,72,41,20,
  72,41,20,72,41,20,68,42,11,60,45,25,29,22,13,32,35,23,
  26,27,15,29,22,13,35,34,21,58,46,21,78,56,17,89,71,33,
  80,58,12,98,79,36,98,79,36,50,34,15,29,22,13,61,44,14,
  82,47,19,78,52,21,89,55,26,82,47,19,38,24,9,20,8,1,
  20,8,1,21,14,5,55,27,10,67,38,18,72,41,20,72,46,23,
  64,61,30,64,61,30,58,53,30,66,57,27,38,39,24,26,27,15,
  32,35,23,33,29,21,27,19,12,40,35,16,89,55,26,89,55,26,
  82,47,19,80,42,23,82,47,19,82,47,19,67,38,18,33,29,21,
  29,22,13,30,26,14,27,19,12,26,16,9,62,30,13,72,41,20,
  71,35,18,72,41,20,84,48,31,76,47,27,72,41,20,203,9,247,
  203,9,247,84,62,28,78,52,21,86,66,28,98,76,44,84,72,40,
  37,17,1,81,58,29,113,91,50,118,92,51,37,17,1,113,91,50,
  72,46,23,94,73,36,68,42,11,68,42,11,100,72,33,89,55,26,
  53,21,3,89,55,26,102,76,40,50,34,15,29,22,13,22,17,7,
  29,22,13,26,16,9,26,16,9,62,30,13,72,41,20,80,42,23,
  61,35,11,61,35,11,81,58,29,58,46,21,32,35,23,26,27,15,
  26,27,15,25,23,11,21,14,5,46,40,17,84,72,40,94,76,34,
  129,106,62,86,66,28,41,29,11,38,24,9,25,23,11,53,39,13,
  78,55,31,72,46,23,53,21,3,37,17,1,20,8,1,21,14,5,
  21,14,5,22,17,7,55,27,10,90,62,37,78,55,31,72,46,23,
  64,61,30,58,53,30,74,68,39,64,61,30,33,32,18,26,27,15,
  27,19,12,35,34,21,38,39,24,41,29,11,71,35,18,80,42,23,
  71,35,18,80,42,23,72,41,20,80,42,23,72,46,23,27,19,12,
  21,14,5,21,14,5,26,16,9,29,22,13,60,45,25,90,62,37,
  90,62,37,84,48,31,72,41,20,71,35,18,71,35,18,203,9,247,
  203,9,247,78,52,21,94,73,36,104,80,41,90,69,37,37,17,1,
  60,41,12,94,76,34,68,42,11,78,56,17,102,76,40,78,52,21,
  61,47,18,68,42,11,82,47,19,97,68,21,89,63,18,68,42,11,
  89,55,26,90,62,37,80,42,23,67,38,18,26,16,9,33,29,21,
  21,14,5,27,19,12,29,22,13,67,38,18,82,47,19,80,42,23,
  80,42,23,95,63,41,90,62,37,72,46,23,22,17,7,21,20,10,
  26,27,15,26,27,15,32,35,23,64,61,30,98,76,44,98,76,44,
  46,40,17,41,29,11,64,61,30,38,39,24,26,27,15,66,57,27,
  64,61,30,46,40,17,58,46,21,72,46,23,60,41,12,33,32,18,
  32,35,23,52,51,23,114,89,46,95,63,41,90,69,37,86,66,28,
  84,72,40,74,68,39,84,72,40,66,57,27,30,26,14,29,22,13,
  33,29,21,29,22,13,26,16,9,38,24,9,80,42,23,82,47,19,
  95,63,41,107,76,43,95,63,41,95,63,41,78,55,31,35,34,21,
  30,26,14,21,14,5,22,17,7,21,20,10,55,27,10,62,30,13,
  55,27,10,71,35,18,72,41,20,80,42,23,84,48,31,203,9,247,
  203,9,247,58,46,21,98,76,44,78,55,31,20,8,1,53,29,4,
  113,91,50,86,66,28,102,76,40,107,76,43,107,76,43,78,52,21,
  38,24,9,80,58,12,97,68,21,82,47,19,53,21,3,89,55,26,
  89,55,26,89,55,26,89,55,26,89,55,26,27,19,12,27,19,12,
  33,29,21,29,22,13,35,34,21,84,48,31,82,47,19,76,47,27,
  114,85,42,98,76,44,72,46,23,60,45,25,30,31,21,30,31,21,
  26,27,15,30,31,21,25,23,11,31,32,10,58,46,21,58,46,21,
  46,40,17,65,51,20,64,61,30,58,53,30,32,35,23,46,46,27,
  58,46,21,74,68,39,74,68,39,64,61,30,84,72,40,58,53,30,
  30,31,21,46,40,17,58,46,21,84,72,40,72,60,22,86,66,28,
  70,54,17,89,66,40,89,66,40,55,27,10,35,34,21,32,35,23,
  22,17,7,30,26,14,27,19,12,38,24,9,61,35,11,95,63,41,
  89,55,26,82,47,19,89,55,26,82,47,19,78,55,31,35,34,21,
  33,29,21,26,16,9,27,19,12,26,16,9,62,30,13,76,47,27,
  89,55,26,84,48,31,84,48,31,84,48,31,72,41,20,203,9,247,
  203,9,247,41,29,11,58,46,21,37,17,1,37,17,1,60,41,12,
  107,81,43,102,76,40,102,76,40,97,72,31,97,68,21,78,56,17,
  53,39,13,80,58,12,53,21,3,82,47,19,82,47,19,82,47,19,
  72,41,20,95,63,41,82,47,19,72,41,20,50,34,15,35,34,21,
  26,16,9,21,14,5,32,35,23,84,48,31,53,21,3,72,46,23,
  90,62,37,61,35,11,78,55,31,78,55,31,33,29,21,22,17,7,
  22,17,7,22,17,7,21,20,10,41,29,11,64,61,30,74,68,39,
  84,72,40,84,72,40,84,72,40,42,45,22,32,35,23,52,51,23,
  64,61,30,64,61,30,58,46,21,46,40,17,58,53,30,40,35,16,
  26,27,15,52,51,23,64,61,30,72,60,22,84,72,40,70,54,17,
  98,76,44,98,76,44,72,46,23,55,27,10,33,29,21,32,35,23,
  32,35,23,21,20,10,21,14,5,21,14,5,53,21,3,72,41,20,
  95,63,41,90,62,37,89,55,26,89,55,26,67,38,18,33,29,21,
  29,22,13,30,26,14,30,26,14,30,26,14,60,45,25,76,47,27,
  84,48,31,71,35,18,76,47,27,71,35,18,76,47,27,203,9,247,
  203,9,247,78,55,31,20,8,1,53,29,4,113,91,50,113,91,50,
  107,81,43,97,72,31,86,66,28,100,72,33,97,72,31,81,58,29,
  50,34,15,61,35,11,79,53,20,90,62,37,68,42,11,82,47,19,
  95,63,41,89,55,26,89,55,26,80,42,23,53,21,3,27,19,12,
  21,14,5,21,14,5,29,22,13,37,17,1,60,41,12,60,41,12,
  58,46,21,64,61,30,78,55,31,50,34,15,21,14,5,32,35,23,
  32,35,23,46,46,27,46,46,27,58,46,21,61,35,11,78,55,31,
  78,55,31,72,46,23,60,41,12,33,32,18,30,31,21,58,53,30,
  84,72,40,58,46,21,46,40,17,58,46,21,72,46,23,58,53,30,
  38,39,24,74,68,39,84,72,40,72,60,22,72,60,22,98,76,44,
  70,54,17,78,52,21,61,35,11,67,38,18,29,22,13,21,14,5,
  21,14,5,21,20,10,29,22,13,40,35,16,84,48,31,95,63,41,
  80,42,23,90,62,37,82,47,19,89,55,26,55,27,10,27,19,12,
  22,17,7,27,19,12,22,17,7,26,16,9,50,34,15,72,41,20,
  84,48,31,67,38,18,84,48,31,67,38,18,90,62,37,203,9,247,
  203,9,247,37,17,1,89,66,40,132,109,64,84,62,28,94,73,36,
  107,81,43,94,69,36,86,66,28,78,55,31,67,38,18,60,45,25,
  35,34,21,60,45,25,76,47,27,78,55,31,95,63,41,89,55,26,
  82,47,19,71,35,18,80,42,23,84,48,31,99,64,33,40,35,16,
  22,17,7,20,8,1,25,23,11,60,45,25,58,53,30,58,46,21,
  58,53,30,66,57,27,53,39,13,46,40,17,32,35,23,32,35,23,
  33,29,21,27,19,12,27,19,12,41,29,11,60,45,25,55,27,10,
  71,35,18,67,38,18,60,45,25,38,39,24,32,35,23,30,29,13,
  41,29,11,76,47,27,78,55,31,74,68,39,64,61,30,64,61,30,
  46,40,17,66,57,27,81,58,29,84,72,40,98,76,44,84,72,40,
  98,76,44,76,47,27,50,34,15,41,29,11,26,16,9,29,22,13,
  30,26,14,27,19,12,21,20,10,27,19,12,38,24,9,72,41,20,
  95,63,41,72,41,20,82,47,19,61,35,11,50,34,15,27,19,12,
  30,26,14,29,22,13,29,22,13,29,22,13,38,24,9,38,24,9,
  62,30,13,55,27,10,62,30,13,62,30,13,67,38,18,203,9,247,
  203,9,247,118,92,51,133,118,68,61,35,11,81,58,29,98,76,44,
  90,62,37,86,66,28,100,72,33,60,45,25,46,46,27,38,39,24,
  33,29,21,33,32,18,38,24,9,50,34,15,53,21,3,72,41,20,
  72,41,20,72,41,20,90,62,37,84,48,31,72,41,20,50,34,15,
  30,26,14,21,14,5,38,39,24,40,35,16,58,46,21,64,61,30,
  58,46,21,89,71,33,38,39,24,33,29,21,21,14,5,21,14,5,
  46,46,27,46,46,27,29,22,13,21,14,5,27,19,12,38,24,9,
  53,21,3,53,21,3,26,16,9,22,17,7,30,26,14,33,29,21,
  46,46,27,78,55,31,89,66,40,65,51,20,78,52,21,81,58,29,
  37,17,1,60,41,12,106,86,47,113,91,50,106,86,47,81,58,29,
  78,55,31,55,27,10,26,16,9,26,16,9,26,16,9,26,16,9,
  26,16,9,30,26,14,35,34,21,29,22,13,26,16,9,41,29,11,
  84,48,31,76,47,27,76,47,27,30,26,14,26,16,9,30,26,14,
  25,23,11,22,17,7,22,17,7,29,22,13,29,22,13,27,19,12,
  72,41,20,62,30,13,67,38,18,53,21,3,76,47,27,203,9,247,
  203,9,247,98,76,44,72,46,23,90,62,37,106,86,47,84,62,28,
  84,62,28,98,76,44,82,47,19,82,47,19,68,42,11,71,35,18,
  80,42,23,82,47,19,89,55,26,95,63,41,95,63,41,76,47,27,
  71,35,18,84,48,31,71,35,18,72,41,20,67,38,18,72,46,23,
  64,61,30,58,46,21,37,17,1,58,46,21,58,53,30,46,40,17,
  46,40,17,41,29,11,72,46,23,89,66,40,113,91,50,89,55,26,
  90,62,37,71,35,18,84,48,31,82,47,19,71,35,18,53,21,3,
  71,35,18,53,21,3,71,35,18,61,35,11,61,35,11,68,42,11,
  84,62,28,81,58,29,78,52,21,98,76,44,90,62,37,94,69,36,
  94,69,36,90,69,37,61,35,11,81,58,29,78,52,21,61,35,11,
  61,35,11,67,38,18,67,38,18,76,47,27,84,48,31,55,27,10,
  76,47,27,98,76,44,90,62,37,72,41,20,62,30,13,72,41,20,
  89,55,26,81,58,29,82,47,19,68,42,11,129,106,62,133,118,68,
  133,118,68,133,118,68,133,118,68,133,118,68,132,109,64,129,106,62,
  129,106,62,106,86,47,113,91,50,98,76,44,129,106,62,203,9,247,
  203,9,247,79,53,20,79,53,20,86,66,28,94,69,36,81,58,29,
  90,62,37,53,29,4,53,21,3,61,35,11,53,21,3,62,30,13,
  95,63,41,107,76,43,107,76,43,76,47,27,53,21,3,76,47,27,
  84,48,31,76,47,27,84,48,31,72,46,23,72,46,23,58,46,21,
  58,46,21,46,40,17,58,53,30,58,46,21,58,46,21,72,46,23,
  76,47,27,95,63,41,84,48,31,71,35,18,72,41,20,72,41,20,
  71,35,18,72,41,20,62,30,13,71,35,18,72,41,20,80,42,23,
  72,41,20,53,21,3,80,42,23,81,58,29,90,62,37,81,58,29,
  81,58,29,90,62,37,98,76,44,95,63,41,90,62,37,86,66,28,
  79,53,20,82,47,19,95,63,41,68,42,11,76,47,27,95,63,41,
  106,86,47,84,48,31,72,41,20,62,30,13,55,27,10,72,41,20,
  72,41,20,53,29,4,84,48,31,80,42,23,68,42,11,82,47,19,
  84,62,28,113,91,50,113,91,50,118,92,51,133,118,68,104,91,38,
  106,83,43,113,93,46,118,92,51,106,86,47,106,86,47,118,92,51,
  113,91,50,89,71,33,94,73,36,90,69,37,106,86,47,203,9,247,
  203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,
  203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,
  203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,
  203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,
  203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,
  203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,
  203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,
  203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,
  203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,
  203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,
  203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,
  203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,
  203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,
  203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,
  203,9,247,203,9,247,203,9,247,203,9,247,203,9,247,203,9,247
} ;

  /** Earth "logo" **/
  
static unsigned char earth_rgb[] = {
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,1,
  1,0,2,1,0,2,1,1,1,0,1,0,0,1,0,1,0,1,
  3,1,1,2,2,2,2,3,4,1,3,5,2,4,8,2,4,10,
  6,9,13,3,6,8,3,5,7,2,4,8,3,4,7,2,3,5,
  2,2,3,2,3,4,1,1,2,1,1,3,0,1,2,0,2,2,
  0,1,2,0,1,1,0,1,1,0,1,1,0,1,0,0,1,0,
  0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,
  0,0,1,0,1,1,0,1,0,0,2,1,1,5,4,2,8,11,
  4,12,13,11,19,21,38,44,47,63,68,73,66,72,82,48,54,67,
  68,74,86,70,76,87,64,70,80,71,78,84,66,76,80,39,51,53,
  13,27,28,19,31,31,14,22,21,9,15,14,6,9,7,5,5,3,
  2,3,6,1,2,5,1,1,3,1,0,1,2,0,0,2,0,0,
  2,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,2,0,1,2,0,1,1,1,3,
  2,2,4,5,9,9,13,18,16,43,47,46,56,62,65,67,76,82,
  103,108,113,119,122,128,122,122,131,126,124,135,118,117,128,125,125,135,
  120,120,130,123,123,134,119,119,129,116,116,127,115,118,127,97,104,112,
  45,55,60,32,47,53,21,41,47,21,42,46,27,44,48,28,41,45,
  23,33,32,17,25,22,11,16,11,5,8,3,2,2,1,2,1,1,
  2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,1,0,2,5,2,7,10,11,19,22,
  20,30,33,51,62,65,97,104,106,133,133,136,131,132,136,128,132,137,
  133,130,138,123,121,129,114,112,122,113,110,121,116,114,123,119,118,126,
  116,115,125,116,115,126,109,107,120,99,97,109,114,113,124,114,115,124,
  114,114,123,90,96,104,51,67,76,20,46,53,15,43,51,17,42,52,
  21,43,46,21,40,41,28,43,41,31,44,40,19,29,25,11,19,16,
  3,8,6,2,4,3,2,2,2,1,1,1,1,1,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,2,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
  0,1,3,0,3,7,6,11,16,17,32,36,25,40,40,35,48,46,
  37,49,49,42,51,56,111,116,121,134,135,139,134,134,138,133,135,139,
  135,134,139,133,133,138,133,134,139,131,132,137,131,133,139,125,127,135,
  121,124,132,113,115,126,109,111,124,113,114,126,119,121,131,119,120,130,
  119,120,129,120,121,127,83,92,96,29,48,53,26,48,56,16,41,50,
  18,44,53,25,47,54,26,45,50,24,43,45,24,42,43,25,42,39,
  31,46,36,22,30,20,17,20,13,5,6,4,1,2,1,0,1,1,
  1,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,2,0,0,0,0,1,0,0,0,0,0,1,3,1,3,6,
  9,15,16,23,32,30,32,43,39,47,59,53,40,48,36,68,71,59,
  62,62,60,110,109,112,136,135,137,136,135,137,138,137,139,133,133,135,
  132,132,135,133,132,136,139,138,140,140,139,141,136,135,140,127,126,132,
  125,126,130,118,119,125,120,121,130,119,118,127,120,118,128,121,119,128,
  122,120,129,124,119,129,109,113,122,51,66,77,24,43,54,15,43,51,
  16,43,51,18,40,48,21,41,47,22,44,47,28,50,52,26,46,45,
  26,44,34,45,58,40,48,54,35,33,39,27,14,19,11,4,6,3,
  2,3,2,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  2,0,0,1,0,0,0,2,1,0,3,2,5,13,15,21,34,33,
  39,50,40,39,48,32,35,45,28,43,50,28,62,68,47,56,62,50,
  46,55,56,127,133,136,132,132,133,131,131,132,132,131,132,114,113,115,
  137,135,138,139,138,140,139,138,138,133,133,131,141,139,139,139,137,139,
  135,134,135,132,131,134,123,123,130,116,117,126,113,114,123,113,114,124,
  112,112,123,113,112,123,91,99,109,31,46,57,29,46,55,18,42,48,
  15,42,52,16,42,52,17,42,51,16,42,49,16,41,47,18,41,48,
  21,42,49,34,51,45,45,56,36,42,53,30,41,51,30,37,44,29,
  18,24,16,4,6,4,1,2,1,0,0,2,1,0,1,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,0,0,2,3,2,8,11,21,34,35,27,45,43,39,55,45,
  51,60,41,47,54,35,42,50,35,53,60,37,54,63,45,30,43,37,
  20,39,46,61,74,81,76,80,80,85,87,88,120,119,120,115,112,114,
  131,129,132,139,137,138,124,122,120,125,125,119,135,134,129,133,131,126,
  132,129,125,136,134,133,121,120,124,86,90,100,77,84,94,64,74,86,
  47,60,73,47,63,72,23,47,51,16,39,44,37,50,56,45,59,61,
  19,42,53,15,41,52,14,42,52,15,42,52,15,42,52,15,42,55,
  17,42,56,23,42,46,38,52,44,42,57,35,40,55,28,41,54,28,
  44,56,35,41,50,34,12,20,10,1,4,2,0,1,1,1,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,2,3,7,14,18,16,30,36,21,42,46,24,43,48,51,62,60,
  57,62,42,61,67,41,51,59,37,51,52,30,54,57,39,43,52,44,
  23,41,43,48,57,57,82,79,72,97,91,86,106,99,95,123,116,113,
  127,123,125,110,108,108,110,108,104,82,80,72,92,90,82,110,106,99,
  119,115,109,100,97,95,135,132,135,122,121,123,130,132,136,100,109,113,
  64,79,84,28,44,55,17,39,54,13,37,50,15,34,44,14,35,41,
  18,38,48,16,40,50,15,42,51,15,41,52,19,41,50,26,44,50,
  29,45,48,38,48,48,43,48,45,38,53,39,43,59,36,41,57,25,
  44,59,27,44,60,31,42,57,34,29,38,29,6,12,9,0,3,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,0,0,1,0,2,0,0,1,0,1,2,5,9,
  7,23,29,15,29,40,13,29,43,11,36,47,24,44,47,81,88,80,
  48,50,34,50,53,31,43,51,28,44,45,28,50,50,32,56,61,49,
  31,46,47,56,60,60,91,82,75,103,100,98,137,135,135,120,117,119,
  99,94,92,81,83,75,79,77,68,90,87,79,102,105,101,90,91,91,
  133,130,129,141,140,139,137,142,141,141,141,143,141,141,143,130,130,132,
  127,127,130,73,84,88,21,45,51,15,41,50,11,34,44,14,32,42,
  12,34,43,14,38,47,14,39,49,16,41,52,19,41,48,62,76,73,
  55,60,47,51,53,41,37,43,37,28,43,40,35,49,38,47,59,36,
  47,62,29,49,65,32,47,62,30,44,57,28,38,49,30,14,22,13,
  2,5,6,1,2,4,0,1,2,1,0,0,1,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,0,0,1,0,0,0,1,2,4,11,15,13,26,34,
  13,31,41,13,35,47,11,35,46,14,35,43,49,60,58,55,56,45,
  48,47,32,51,52,35,42,50,32,38,48,35,48,53,38,66,66,56,
  57,57,58,88,83,80,95,84,74,98,91,86,116,111,109,88,82,80,
  107,100,98,79,82,76,113,117,114,73,83,83,32,50,53,46,59,63,
  120,124,126,138,139,141,130,131,132,131,130,133,131,131,134,134,133,137,
  130,130,133,117,123,127,62,78,84,20,44,52,8,33,43,11,33,43,
  14,36,44,13,37,46,12,36,46,11,36,47,11,38,48,40,58,60,
  80,82,68,56,54,39,44,49,41,47,52,50,40,48,32,46,57,44,
  42,60,39,42,64,30,48,67,34,44,62,27,48,62,32,42,54,31,
  20,28,18,7,12,13,1,2,8,0,0,2,0,1,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,0,1,1,1,5,6,15,21,12,29,38,10,32,42,
  12,32,44,8,34,45,12,37,45,26,39,40,63,65,56,50,48,33,
  54,52,39,44,45,32,47,51,37,44,45,37,52,51,40,54,54,42,
  59,60,52,72,72,65,60,56,50,125,122,121,93,91,92,98,98,97,
  111,103,96,59,59,51,59,63,63,24,41,46,14,40,47,14,35,44,
  22,37,44,93,98,105,129,127,132,128,128,132,127,128,132,133,133,137,
  137,137,141,136,136,141,115,122,128,31,50,58,11,37,46,11,37,46,
  14,37,45,13,37,46,9,34,43,10,35,46,9,36,50,23,45,53,
  61,70,63,79,81,68,46,49,39,35,48,38,47,62,45,40,51,47,
  47,55,49,50,64,41,39,57,28,48,65,32,51,68,33,47,63,29,
  36,49,25,26,34,27,9,14,17,2,4,7,1,1,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,2,5,7,16,25,12,29,40,11,32,44,11,34,44,
  11,35,44,15,37,48,27,41,47,53,57,50,53,53,36,48,50,34,
  45,46,34,52,53,41,48,48,35,51,48,36,56,54,39,60,59,43,
  60,59,44,85,84,74,103,101,96,84,80,80,88,86,86,127,127,124,
  88,78,62,93,88,73,85,81,75,66,73,75,18,36,42,19,37,45,
  20,39,48,53,64,72,126,128,135,128,129,134,128,130,135,128,130,134,
  135,137,141,135,134,138,97,99,105,50,65,73,15,38,48,13,38,47,
  22,44,53,12,35,44,10,35,44,10,35,46,16,40,52,16,41,54,
  21,46,53,63,77,74,55,58,46,37,52,35,33,49,48,33,48,42,
  43,54,46,45,55,44,44,55,33,44,58,32,43,59,28,49,67,33,
  45,62,31,35,48,25,38,47,37,23,28,30,4,5,9,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,
  0,3,5,7,18,27,12,30,42,11,31,43,13,34,46,13,34,45,
  12,37,47,26,41,46,49,52,49,61,57,46,58,59,42,45,51,33,
  44,50,34,46,47,33,53,51,37,57,57,41,55,56,38,64,64,45,
  73,67,51,80,74,61,86,80,70,93,85,75,75,69,60,113,111,103,
  87,82,69,71,66,54,92,81,74,94,89,84,100,104,101,90,97,100,
  27,44,52,28,44,56,76,79,87,130,131,137,128,130,136,129,131,137,
  132,134,140,140,138,143,116,117,121,63,78,83,19,41,49,15,39,48,
  15,37,48,14,37,48,12,36,46,9,35,44,13,36,47,15,40,53,
  15,46,59,23,46,51,52,56,46,57,63,46,40,49,50,27,44,48,
  27,49,47,34,49,45,65,68,45,66,69,46,52,66,40,45,61,34,
  47,63,35,48,60,30,44,54,28,44,53,46,20,27,32,3,5,6,
  3,1,0,1,0,0,0,1,3,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,2,3,
  7,20,27,11,30,43,11,32,44,12,33,46,12,35,48,14,37,49,
  30,47,51,42,51,42,61,61,42,75,73,53,51,57,35,59,69,45,
  71,76,55,67,68,51,56,56,41,67,65,46,76,77,54,81,80,57,
  62,57,37,68,58,45,70,57,46,80,68,54,84,75,64,73,68,62,
  111,108,106,91,93,86,62,58,52,86,82,77,97,96,91,109,112,109,
  20,40,44,23,47,57,44,52,56,126,127,135,132,132,140,131,131,139,
  131,131,137,135,135,140,113,119,125,52,70,75,14,39,46,15,39,48,
  16,43,50,15,41,49,14,39,48,13,38,47,12,35,47,13,37,49,
  13,42,53,21,46,55,75,83,79,79,78,72,44,49,43,43,58,47,
  26,46,46,29,48,56,57,63,44,66,65,43,74,81,56,63,70,47,
  47,56,34,46,56,33,56,67,40,56,64,46,39,50,51,20,31,38,
  9,12,16,1,0,2,1,0,1,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,1,0,0,0,2,3,9,19,25,
  12,32,43,12,33,46,11,32,45,11,35,49,12,37,50,18,41,51,
  65,69,63,59,59,45,62,63,40,72,79,52,55,70,39,70,81,50,
  80,80,56,62,62,41,56,61,40,77,77,49,89,89,59,85,83,57,
  80,75,55,84,78,65,82,75,65,80,74,62,64,61,53,70,71,69,
  84,76,76,95,96,87,58,54,44,85,79,75,101,97,96,107,110,107,
  26,46,50,19,43,50,55,62,63,124,125,136,132,132,141,132,131,138,
  131,131,137,117,125,132,29,48,56,17,42,50,16,42,53,25,48,61,
  43,57,63,57,74,80,21,42,51,14,39,50,12,38,51,15,39,50,
  15,42,54,19,46,57,62,76,78,105,106,108,63,69,61,47,63,41,
  35,55,41,24,47,51,41,57,55,72,77,61,81,79,55,88,84,60,
  68,66,46,40,49,33,40,55,33,66,71,48,73,75,61,47,54,51,
  15,21,30,1,2,9,2,0,1,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,2,3,6,16,23,11,31,43,
  11,34,48,12,35,47,11,35,47,12,37,50,19,41,50,36,52,55,
  78,78,70,64,62,51,72,74,55,75,87,59,66,80,48,69,77,48,
  70,75,49,68,72,47,65,68,44,80,79,50,88,87,61,87,90,74,
  54,61,55,42,54,54,27,41,39,58,71,66,41,56,53,29,45,47,
  68,68,69,76,75,63,65,55,39,54,45,37,104,102,102,101,105,107,
  20,39,46,26,45,54,73,74,75,126,126,137,135,133,142,130,131,137,
  112,120,127,57,76,85,14,41,50,13,39,50,17,43,56,33,55,69,
  80,82,92,89,96,106,25,43,54,16,43,54,14,44,56,24,47,59,
  17,41,54,17,46,60,23,46,52,44,59,62,64,80,77,29,45,48,
  39,59,47,38,62,47,24,45,53,56,66,52,76,69,47,90,82,59,
  89,81,59,55,60,43,38,53,31,47,57,36,65,66,45,83,81,60,
  69,69,59,14,16,15,0,2,4,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,5,11,16,14,32,43,10,35,49,
  12,36,48,13,36,46,12,37,49,11,36,47,27,44,48,66,74,68,
  42,48,32,79,82,65,68,73,49,67,82,43,76,85,52,62,67,44,
  63,75,48,55,64,35,75,75,48,85,81,57,83,83,66,32,42,41,
  18,41,52,14,42,56,16,41,51,29,50,55,26,46,50,24,43,50,
  18,38,45,54,61,57,81,73,62,81,82,76,75,90,90,34,52,55,
  14,42,50,15,40,48,63,67,68,130,130,139,136,136,141,122,127,131,
  29,45,55,15,40,52,11,37,47,12,38,49,15,40,52,17,43,55,
  23,47,54,19,44,52,12,37,47,15,39,52,15,42,56,19,44,55,
  20,43,56,17,47,61,18,47,55,17,47,55,20,47,60,23,47,49,
  38,58,49,38,58,49,30,50,57,60,73,56,72,66,45,88,83,61,
  104,97,70,70,71,47,40,53,28,41,59,44,35,54,47,51,68,51,
  75,83,58,69,72,57,5,9,11,0,0,1,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,
  1,1,0,1,1,2,4,6,9,10,29,40,12,34,47,11,35,48,
  12,38,47,11,37,46,12,38,50,15,41,49,34,53,49,43,52,37,
  51,56,37,63,71,47,65,77,46,74,90,51,66,81,43,67,78,45,
  68,76,45,79,85,52,83,87,54,72,70,49,55,68,46,18,40,46,
  15,41,54,16,43,46,15,42,54,16,41,51,35,50,45,69,71,59,
  43,52,48,21,40,46,60,71,72,44,56,59,17,40,48,13,39,45,
  11,37,45,16,36,45,49,60,67,131,131,136,140,137,141,109,113,117,
  22,41,51,11,36,49,12,36,48,13,37,49,14,40,51,15,42,53,
  14,38,50,13,37,49,13,38,50,14,41,52,16,42,53,13,40,53,
  18,45,56,26,48,50,25,49,46,18,48,56,16,47,64,18,48,58,
  30,51,53,43,65,46,63,75,58,62,67,41,72,79,49,76,73,50,
  89,88,60,86,84,54,55,61,36,33,54,41,35,61,58,17,43,48,
  30,48,48,102,100,86,69,67,55,9,10,18,1,2,4,1,1,0,
  1,0,1,1,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,
  2,0,1,1,3,8,11,26,33,11,33,44,10,32,46,12,36,50,
  12,36,50,12,39,51,14,40,46,32,48,42,33,46,31,35,46,27,
  53,60,36,72,77,52,72,78,51,75,81,52,70,78,49,70,80,54,
  60,68,44,73,79,54,71,75,47,79,79,51,55,66,41,22,43,46,
  15,40,56,15,43,51,15,41,54,25,46,52,61,68,56,70,62,44,
  80,71,59,38,52,56,20,40,44,17,42,46,12,41,50,13,35,46,
  12,35,47,13,35,46,21,39,47,90,96,102,115,117,122,90,98,104,
  16,37,47,11,36,49,13,36,48,14,38,50,14,40,52,14,40,52,
  14,38,50,13,36,49,13,38,50,16,43,55,17,43,54,15,41,53,
  17,43,56,25,47,54,31,49,48,27,50,49,20,48,54,20,51,53,
  21,47,61,36,58,42,56,66,34,73,76,45,77,79,51,79,75,55,
  83,80,54,107,101,73,98,94,68,70,76,58,33,52,48,13,43,53,
  29,48,50,93,87,67,103,95,73,61,62,56,5,5,6,0,0,3,
  0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,1,0,
  2,1,4,6,16,24,9,35,46,9,34,44,11,35,48,13,36,50,
  15,38,51,15,40,48,28,48,44,48,57,38,63,70,45,43,55,32,
  74,79,54,77,80,56,72,72,50,84,82,62,76,79,56,61,70,48,
  53,62,44,66,75,53,66,71,44,76,80,45,84,89,62,50,61,55,
  18,40,48,14,42,52,15,41,51,30,46,45,73,74,55,88,75,52,
  85,80,56,32,46,38,34,48,44,42,57,59,18,40,52,14,35,50,
  13,34,49,12,35,47,10,35,43,21,36,43,36,48,56,55,69,78,
  15,37,48,12,36,49,12,36,48,14,38,50,13,39,51,11,38,49,
  13,36,48,12,36,48,13,39,51,15,42,53,16,44,56,17,41,52,
  14,39,52,20,46,57,37,49,45,42,62,43,30,53,52,25,54,48,
  19,47,56,41,59,52,58,64,44,68,68,49,67,63,41,77,78,51,
  78,79,53,91,86,59,103,96,69,109,105,81,55,65,55,17,43,49,
  45,59,56,94,83,59,122,108,81,113,106,87,40,36,33,0,1,6,
  0,2,2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,2,0,1,1,1,2,
  2,9,11,12,32,41,9,34,49,9,35,47,10,34,47,12,36,47,
  16,39,45,28,45,42,39,49,36,64,71,50,59,67,41,54,64,39,
  69,72,49,79,79,57,79,78,59,80,79,61,77,78,55,65,73,48,
  36,49,28,59,71,46,65,73,41,73,81,46,83,82,55,68,68,51,
  37,51,46,16,42,46,23,48,52,35,50,41,79,80,55,102,91,67,
  87,85,58,77,80,60,96,91,70,67,70,60,18,40,47,12,37,48,
  13,33,48,12,34,45,9,35,42,11,34,41,14,34,44,14,34,46,
  13,34,47,12,35,48,13,36,48,15,39,52,12,38,50,11,37,49,
  12,36,48,12,36,48,14,40,52,15,42,53,16,44,58,15,39,47,
  14,39,49,20,49,57,74,82,69,40,59,46,42,63,48,52,78,38,
  40,62,52,49,60,51,63,69,47,61,63,46,71,67,48,71,78,49,
  57,66,38,78,82,54,73,74,46,87,87,60,62,66,45,42,57,48,
  44,51,39,108,94,69,115,101,77,132,115,92,100,91,81,13,12,13,
  0,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,0,0,0,0,0,0,0,1,0,0,3,0,1,1,2,5,
  9,26,33,9,35,45,11,34,47,10,35,45,11,36,48,14,36,45,
  25,41,39,44,50,40,62,63,49,56,60,41,59,66,42,68,73,49,
  66,65,46,82,80,60,82,79,58,84,82,61,78,79,55,69,76,51,
  53,67,43,61,74,47,74,83,50,73,81,49,86,83,56,77,75,47,
  52,63,51,22,43,44,38,53,44,74,82,60,79,83,54,82,75,51,
  81,73,50,90,81,61,105,95,69,85,90,71,17,43,43,12,40,49,
  13,35,44,12,35,42,9,35,42,10,33,43,11,33,43,11,33,45,
  11,34,45,12,36,48,11,36,48,13,39,50,11,38,49,11,38,48,
  12,36,48,12,35,48,12,36,49,14,39,51,15,42,54,13,39,48,
  17,45,55,20,48,54,63,76,65,58,78,60,33,54,49,52,76,53,
  37,58,44,62,74,55,69,78,43,65,71,43,61,62,41,56,63,42,
  54,63,37,61,72,41,73,82,54,73,77,53,63,66,42,56,62,48,
  48,55,36,96,92,70,104,89,69,113,100,85,120,105,90,54,45,41,
  4,2,6,0,1,2,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,0,0,1,0,0,0,0,1,0,0,2,1,1,7,13,18,
  15,36,49,9,35,49,10,34,44,10,35,44,10,35,46,27,45,50,
  44,50,42,66,62,50,76,71,59,70,71,50,76,79,55,76,78,55,
  66,66,48,82,80,59,80,76,51,85,83,58,79,79,56,72,79,54,
  63,77,48,62,78,44,65,77,42,70,79,49,78,79,56,73,76,52,
  41,57,47,31,48,46,64,66,48,77,76,46,69,73,45,80,77,51,
  75,76,48,86,81,59,94,88,63,100,98,78,57,67,62,21,41,47,
  17,39,50,13,36,48,10,35,45,12,32,43,12,32,43,11,32,43,
  10,33,44,11,36,46,12,36,47,14,38,49,13,37,48,12,36,47,
  13,36,48,12,36,48,12,35,48,14,37,49,15,39,49,10,36,48,
  13,43,55,19,45,53,31,52,54,30,52,55,22,48,55,28,56,57,
  26,49,40,66,81,56,68,81,44,69,82,46,68,79,50,62,69,46,
  68,78,52,43,55,48,52,66,60,52,63,49,64,69,48,51,63,48,
  39,51,50,66,67,48,63,63,47,49,57,57,118,109,94,116,99,89,
  31,25,26,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,2,4,15,30,38,
  13,37,49,10,35,48,11,35,45,8,36,48,14,36,43,41,52,49,
  58,58,45,80,72,58,79,71,57,91,90,69,87,89,65,91,93,70,
  67,71,49,69,70,47,89,87,62,93,92,66,77,80,54,61,72,41,
  64,82,44,64,82,43,65,81,46,67,79,44,75,79,54,73,76,57,
  57,67,51,61,68,54,91,89,67,81,80,51,79,80,54,76,77,48,
  80,82,50,84,82,53,83,80,46,85,85,53,92,91,70,58,64,56,
  19,40,50,13,40,54,13,35,43,11,32,43,11,32,43,11,32,43,
  12,34,44,12,33,45,14,34,46,15,36,48,14,35,47,15,36,48,
  13,36,48,12,35,48,12,35,48,12,35,48,13,35,46,11,34,46,
  9,36,50,12,40,53,17,43,54,17,48,63,18,49,59,21,47,63,
  48,68,64,72,87,55,69,81,45,67,82,44,72,83,48,68,71,43,
  64,68,56,61,73,58,43,61,57,30,50,56,34,52,51,61,71,60,
  45,53,53,35,54,53,31,50,51,25,51,61,54,59,51,113,95,82,
  90,80,74,4,5,3,0,0,0,0,0,0,0,0,0,0,0,0,
  1,0,0,0,0,0,0,0,0,0,1,0,5,13,17,13,36,47,
  13,39,52,11,36,49,12,35,46,10,36,50,22,38,41,65,69,58,
  79,75,59,83,75,60,102,96,78,94,92,70,96,93,70,99,94,74,
  70,71,48,81,80,58,90,87,64,87,88,59,74,83,51,63,79,44,
  62,81,43,53,73,44,39,56,40,66,77,46,73,81,45,72,76,47,
  77,82,52,89,89,60,89,90,60,68,72,43,98,96,73,85,87,56,
  89,91,60,83,86,56,86,95,55,74,88,47,84,90,59,88,95,78,
  24,46,47,15,42,51,15,38,43,11,34,44,10,32,43,12,33,43,
  11,31,43,13,33,45,13,33,45,9,29,41,8,28,40,14,34,47,
  17,40,52,12,35,48,12,35,47,12,36,48,13,36,48,13,35,47,
  10,34,47,8,35,47,13,40,52,11,42,51,14,43,52,18,42,61,
  24,44,57,40,55,51,71,80,61,75,81,50,74,77,48,59,62,45,
  23,46,41,31,52,53,42,57,56,65,75,68,61,73,70,28,45,58,
  32,53,47,30,51,51,18,46,66,12,45,60,28,47,51,99,87,78,
  122,105,93,42,39,35,2,2,2,1,1,1,0,0,0,0,0,0,
  2,0,0,1,0,0,0,0,0,0,2,1,14,30,36,10,37,50,
  10,38,51,10,36,48,12,35,47,13,36,49,46,57,54,71,69,54,
  88,82,67,94,88,73,103,99,79,95,92,69,104,98,76,92,82,64,
  103,97,74,100,94,72,90,87,64,77,79,50,75,86,52,71,89,53,
  53,71,38,38,57,42,25,43,50,48,65,49,60,79,41,67,84,45,
  78,89,53,104,106,71,75,83,48,61,72,40,90,89,66,85,90,59,
  47,66,37,51,70,42,65,83,45,70,86,48,58,70,48,68,81,74,
  21,41,47,16,42,54,16,42,54,13,37,47,12,35,45,11,32,43,
  12,31,43,11,32,43,10,32,43,13,36,47,11,33,45,11,34,45,
  14,38,50,15,38,50,13,37,49,12,36,48,12,36,48,12,37,48,
  11,35,45,10,35,45,10,36,45,11,35,45,12,34,50,12,36,44,
  11,36,47,14,39,58,32,50,48,68,72,47,73,77,55,39,53,52,
  16,44,52,21,47,54,21,46,56,17,43,57,28,52,61,34,56,65,
  17,42,63,18,43,53,23,46,55,17,45,59,21,49,61,83,79,76,
  116,95,81,98,89,82,7,7,7,1,1,1,0,0,0,0,0,0,
  1,0,1,0,0,3,4,1,0,4,12,16,12,39,52,12,38,51,
  11,37,50,10,36,49,11,36,49,15,37,49,57,66,53,88,77,64,
  86,75,65,79,74,54,114,109,86,92,93,64,80,83,54,84,84,59,
  99,94,67,101,102,70,86,89,54,94,93,60,93,97,66,83,97,55,
  68,83,41,58,75,43,38,57,43,53,68,48,56,76,37,69,89,42,
  85,99,61,75,80,50,71,73,42,68,75,42,78,88,59,56,69,46,
  41,62,50,28,53,50,33,60,58,17,41,44,39,52,50,81,85,81,
  34,48,58,16,43,56,16,43,54,13,37,51,12,37,50,11,34,46,
  11,32,44,10,32,44,9,32,44,11,35,46,12,35,47,12,35,47,
  13,36,48,14,38,50,14,38,50,12,36,48,12,37,49,10,35,47,
  10,36,47,10,36,48,11,36,48,13,35,48,12,38,46,11,37,50,
  14,37,54,19,41,52,31,54,56,61,68,53,83,77,57,37,55,53,
  14,45,60,23,46,56,37,56,64,19,45,59,31,58,65,51,60,70,
  15,42,57,16,44,58,18,43,61,16,44,64,26,48,50,76,81,70,
  92,77,69,107,91,87,36,30,29,1,1,4,0,0,2,1,0,0,
  0,0,1,0,0,2,2,2,2,10,24,31,11,38,52,11,36,49,
  11,36,49,11,37,50,11,37,50,16,39,51,76,81,69,95,84,70,
  101,91,76,118,110,87,109,107,78,74,83,47,89,94,59,107,100,70,
  103,99,65,103,106,68,92,99,58,107,110,74,107,113,66,83,97,55,
  67,86,50,47,64,44,54,66,46,41,51,51,57,71,52,69,87,48,
  80,96,52,78,88,49,75,83,50,67,77,47,59,71,40,64,79,44,
  49,70,42,26,46,53,21,42,60,21,45,47,85,97,79,112,106,84,
  96,97,88,25,48,51,13,45,58,14,41,54,13,40,53,16,42,53,
  9,34,45,10,33,44,11,34,45,11,34,45,11,35,46,13,36,47,
  13,36,49,14,37,50,13,37,49,14,38,50,12,37,49,11,36,48,
  11,36,48,11,37,49,12,37,49,10,35,45,11,38,48,15,40,54,
  26,48,52,54,67,55,81,86,72,85,81,60,84,78,59,37,53,58,
  28,47,64,19,43,60,20,47,62,20,48,60,27,54,61,34,54,68,
  15,47,63,16,44,56,20,45,57,39,61,64,92,88,87,112,95,90,
  65,63,58,67,68,64,71,66,64,3,3,4,0,0,1,1,0,0,
  0,0,1,2,0,1,2,5,10,15,35,46,12,38,51,11,37,50,
  10,36,49,11,36,49,11,36,50,17,39,49,75,73,60,109,100,83,
  92,86,68,127,120,98,92,92,68,77,86,58,101,103,74,122,112,84,
  114,112,73,102,107,64,94,104,59,98,105,65,110,118,77,75,90,49,
  53,70,50,55,69,43,75,84,49,49,58,45,69,82,59,71,88,52,
  85,101,58,95,110,63,81,96,51,73,89,53,47,64,30,63,82,41,
  54,75,43,38,56,50,26,47,53,21,44,56,21,45,52,56,70,67,
  66,76,75,24,47,53,14,43,60,15,43,57,15,42,54,16,43,54,
  11,37,48,10,35,45,11,34,45,11,34,45,11,34,45,12,36,47,
  12,37,49,13,38,50,14,39,51,15,40,52,14,40,52,14,39,51,
  12,38,50,11,36,48,12,38,50,11,37,48,12,38,51,19,44,58,
  26,48,46,50,61,36,88,86,61,83,79,52,59,64,40,25,47,51,
  26,55,68,13,46,61,19,45,58,48,56,63,56,61,66,21,49,62,
  18,51,69,18,46,57,34,57,64,124,114,105,127,108,94,122,103,88,
  96,87,77,69,66,61,87,85,83,22,22,22,1,1,1,2,1,1,
  0,1,2,2,0,0,6,15,24,13,38,52,12,37,49,11,37,50,
  11,36,49,11,37,50,13,39,52,29,46,51,102,92,77,100,93,74,
  69,68,51,90,86,65,91,91,69,78,78,55,89,88,60,110,108,74,
  120,118,78,97,103,58,88,100,55,97,107,68,89,104,66,64,82,41,
  65,74,46,82,91,62,79,89,62,82,90,70,66,78,53,56,71,39,
  68,84,45,70,86,41,70,87,41,59,79,41,50,71,44,42,65,45,
  48,70,44,59,80,64,37,61,49,21,51,47,13,46,56,17,44,59,
  16,42,55,15,44,55,18,43,58,15,41,55,13,39,51,10,35,47,
  10,33,44,11,34,45,12,36,47,12,35,47,12,35,46,13,36,47,
  13,39,50,14,40,52,15,42,53,14,41,52,15,41,52,14,39,51,
  13,39,51,11,37,49,10,35,48,13,36,51,10,36,47,13,38,52,
  17,39,47,38,53,40,71,70,52,85,80,57,79,84,57,49,63,60,
  17,48,60,19,48,53,43,56,52,89,79,69,100,84,79,36,59,64,
  22,49,66,22,47,60,25,50,58,116,103,97,130,114,101,128,110,94,
  123,104,91,95,87,80,65,65,62,54,54,53,1,0,0,1,1,1,
  1,1,1,2,0,2,11,27,37,10,37,52,15,37,52,13,37,51,
  11,36,49,12,38,50,12,38,50,36,52,55,99,94,82,103,97,80,
  77,74,54,84,83,62,96,96,67,84,84,54,103,103,72,117,122,85,
  115,117,76,89,103,58,80,98,52,98,113,72,76,97,52,64,83,39,
  88,95,54,102,104,79,75,83,59,67,78,49,63,81,49,70,90,52,
  75,91,47,84,97,47,72,89,48,46,69,49,22,48,45,24,50,53,
  30,55,50,23,46,52,19,43,56,16,42,58,13,40,53,13,38,48,
  12,39,50,15,45,55,18,44,54,13,37,49,11,35,46,12,35,47,
  11,34,45,12,35,45,12,36,46,12,36,46,13,37,48,12,36,47,
  11,38,50,14,41,53,15,42,54,13,40,52,14,40,52,14,40,53,
  13,39,52,11,37,49,9,35,47,11,34,51,11,36,48,9,35,48,
  13,38,52,31,48,41,67,65,48,75,64,47,67,66,44,59,68,63,
  19,45,53,59,71,60,108,106,90,110,99,83,122,107,95,78,80,76,
  72,74,73,78,79,78,83,87,87,118,114,107,129,114,107,132,111,102,
  126,106,94,115,103,92,87,85,81,60,64,65,3,4,6,2,1,1,
  2,2,1,1,3,8,15,38,47,11,38,52,14,35,53,12,36,50,
  14,38,52,13,38,50,13,37,48,47,63,68,79,80,72,76,72,57,
  92,82,62,96,91,75,90,91,62,97,103,67,109,111,80,107,113,77,
  96,107,66,70,94,49,69,92,46,70,89,42,76,99,52,83,102,54,
  93,104,63,89,96,63,86,99,58,74,95,49,63,86,39,72,93,49,
  69,87,49,74,90,55,59,79,58,21,47,50,18,46,61,19,45,59,
  16,41,53,13,38,50,12,36,48,11,33,46,11,35,47,9,35,45,
  9,35,45,12,38,48,16,41,52,13,36,47,32,54,64,80,97,105,
  123,135,141,146,157,162,165,175,178,158,168,173,126,139,145,72,92,100,
  36,60,71,16,43,55,15,43,55,15,43,55,15,42,55,13,39,52,
  14,40,53,12,38,51,10,36,49,10,37,50,11,37,50,12,39,52,
  13,39,52,25,46,49,57,65,57,67,66,50,68,70,59,34,45,56,
  41,60,58,94,91,67,129,115,98,135,124,114,134,124,113,127,113,104,
  122,104,89,126,106,91,125,104,94,130,116,105,128,112,103,128,111,101,
  128,110,95,131,110,96,87,77,73,57,60,65,15,20,24,1,1,1,
  2,2,2,6,13,20,15,39,50,13,38,53,13,38,53,11,38,51,
  12,37,50,14,38,50,24,44,56,41,56,61,77,79,68,65,65,50,
  98,88,70,104,97,83,95,97,69,98,106,69,110,114,78,98,108,63,
  63,83,41,61,88,45,68,89,47,70,89,43,72,94,46,76,98,49,
  79,99,54,71,92,52,60,86,38,63,92,43,68,88,43,76,92,59,
  59,80,64,30,54,55,21,46,55,19,47,57,17,46,59,13,38,55,
  13,37,50,12,35,49,11,33,47,13,34,48,12,35,48,10,35,47,
  9,35,47,11,36,48,47,69,79,148,159,164,211,216,218,204,209,212,
  193,199,203,188,195,198,186,193,196,206,212,214,211,215,217,209,214,217,
  201,207,210,151,163,169,65,87,97,19,46,59,18,45,57,13,39,52,
  13,39,52,12,38,51,12,38,51,10,36,49,11,37,50,12,38,51,
  10,36,49,16,43,55,21,44,56,32,48,50,34,46,42,55,63,69,
  69,68,58,122,107,84,128,111,94,139,127,115,139,128,117,135,123,112,
  129,112,98,117,97,83,108,89,77,105,90,77,121,106,95,132,116,105,
  125,108,94,132,112,99,120,104,99,88,83,85,31,32,35,0,2,2,
  2,2,3,11,27,35,14,39,55,14,38,54,12,37,52,12,38,52,
  14,39,52,14,38,51,25,46,58,61,74,78,63,65,51,56,61,46,
  91,81,65,99,89,75,85,88,58,95,104,64,97,102,63,93,105,57,
  66,90,45,51,75,35,76,91,55,71,88,48,64,87,43,69,92,46,
  59,85,40,49,77,36,53,85,35,64,93,42,69,90,54,55,72,59,
  23,48,52,13,41,56,10,38,52,10,38,48,13,41,50,13,40,51,
  12,38,52,13,38,52,11,35,49,11,34,49,12,35,49,10,35,48,
  18,43,55,110,125,132,184,191,195,178,186,190,174,183,187,175,183,187,
  174,183,187,180,188,192,178,186,191,189,196,200,194,200,203,206,211,214,
  206,212,215,216,221,223,213,218,220,147,160,165,39,64,76,16,42,55,
  13,39,52,12,38,51,11,37,50,12,38,51,13,39,52,16,42,55,
  14,40,53,10,38,45,12,41,54,17,43,61,35,51,47,73,76,55,
  120,109,91,131,112,95,136,121,103,135,125,110,140,130,119,135,124,113,
  130,114,102,119,100,87,120,103,88,124,109,95,114,100,88,136,122,110,
  130,115,102,126,110,96,124,105,95,110,95,91,59,53,52,1,2,2,
  2,2,5,13,36,45,14,39,58,15,38,55,13,38,52,15,38,52,
  15,40,53,16,42,54,17,42,52,51,64,69,55,58,42,58,65,50,
  94,84,70,91,80,65,91,96,61,87,99,56,92,98,59,92,105,58,
  68,90,42,63,82,43,64,74,43,60,77,41,69,94,54,60,86,43,
  55,83,41,48,76,38,55,85,37,66,91,39,52,76,49,29,52,54,
  15,41,56,13,41,55,13,40,53,12,37,54,12,38,55,13,41,54,
  13,42,55,13,42,55,13,40,54,11,37,51,10,36,50,18,42,56,
  116,131,139,159,169,174,161,171,176,168,177,182,187,195,198,188,195,199,
  184,192,196,193,199,202,178,186,191,174,182,187,174,182,187,189,196,200,
  212,217,219,218,222,224,217,221,223,214,219,221,188,196,199,61,83,95,
  15,41,54,13,39,52,11,37,50,9,35,48,13,39,52,17,43,56,
  14,40,53,16,39,53,13,38,55,23,51,59,45,60,47,82,76,57,
  100,87,70,128,111,99,134,124,107,137,129,112,140,130,118,137,127,114,
  129,114,102,125,107,94,128,111,95,124,110,94,123,109,96,115,102,90,
  126,113,100,127,114,96,131,114,97,113,93,81,94,81,76,8,7,5,
  1,5,8,17,39,52,12,40,57,13,39,55,11,42,57,11,41,54,
  13,40,54,14,39,53,28,50,63,42,60,72,46,58,42,68,66,54,
  82,75,60,69,69,55,82,92,51,77,96,51,91,98,58,58,81,44,
  50,73,36,47,66,33,52,70,37,55,79,37,68,91,46,59,88,38,
  47,78,33,55,75,41,58,84,40,67,91,49,48,74,56,22,50,58,
  15,44,60,15,43,58,14,42,56,14,41,56,13,41,56,13,41,56,
  13,41,54,13,41,54,13,41,54,12,39,52,15,41,54,97,114,123,
  145,157,163,157,168,173,142,154,160,146,157,164,151,162,168,177,186,190,
  191,198,202,169,178,183,159,169,174,152,162,168,174,183,187,197,204,207,
  218,222,224,218,222,224,208,213,216,195,201,205,195,202,205,194,200,204,
  39,63,74,11,36,49,12,36,50,12,39,52,14,41,54,13,41,54,
  15,42,55,16,40,55,15,40,54,41,62,55,69,75,48,73,70,51,
  118,98,85,139,125,111,136,127,114,137,126,117,129,114,103,133,117,104,
  137,122,112,122,106,96,118,100,88,137,127,106,131,117,101,114,106,91,
  116,106,90,134,117,100,134,118,101,126,106,92,100,82,72,24,20,19,
  4,10,13,18,41,56,14,41,59,14,41,56,11,41,57,11,41,56,
  13,41,55,15,41,55,23,47,60,38,59,70,48,62,45,67,67,54,
  86,83,69,64,67,51,84,88,50,94,111,75,89,99,69,49,72,44,
  50,77,44,36,58,29,46,65,36,53,73,37,75,93,48,59,80,39,
  48,74,40,51,75,42,43,71,47,33,61,54,26,54,61,18,47,67,
  15,42,62,15,42,58,12,40,55,12,41,55,14,42,56,14,43,57,
  14,41,54,13,40,53,13,40,53,10,38,51,53,75,86,136,149,155,
  143,156,162,125,139,146,130,144,151,139,152,158,150,162,167,165,175,180,
  169,178,183,143,155,161,140,152,159,145,157,164,140,153,159,171,181,185,
  204,210,212,200,206,209,206,212,214,177,186,190,152,164,170,177,186,190,
  153,164,169,17,43,55,11,36,50,12,39,52,16,43,56,17,44,58,
  12,40,53,16,42,57,17,44,60,51,71,67,59,63,39,72,69,53,
  117,102,89,134,122,108,133,123,111,127,113,104,116,97,86,126,110,97,
  115,100,90,107,92,83,121,104,93,138,129,112,128,118,105,98,92,79,
  108,101,87,140,126,111,135,119,106,131,111,98,101,83,69,40,35,31,
  10,18,24,15,41,58,14,42,60,14,41,56,16,45,61,13,42,58,
  13,42,57,14,43,57,17,44,57,30,56,69,42,61,45,71,74,61,
  91,89,74,75,83,61,86,95,59,61,85,72,42,67,71,29,60,69,
  30,60,57,26,54,48,47,71,56,58,80,50,75,95,49,70,88,47,
  54,75,52,33,61,53,26,55,67,21,54,69,16,46,64,14,42,60,
  14,40,54,13,41,52,13,41,55,12,41,55,13,41,55,13,41,56,
  13,40,53,12,39,52,13,40,53,17,44,57,95,113,121,143,155,162,
  116,131,139,116,131,139,127,141,149,130,144,151,143,155,161,164,174,179,
  165,174,179,139,151,158,134,147,154,141,154,161,138,151,158,145,159,165,
  170,180,184,157,168,173,201,208,211,209,215,217,154,166,172,166,176,181,
  200,206,210,90,108,118,12,38,52,13,40,53,14,41,54,16,43,56,
  13,41,54,16,43,57,16,44,61,27,46,47,67,68,48,97,89,75,
  131,117,104,132,120,107,134,121,109,128,112,102,126,108,97,116,99,88,
  110,96,87,122,106,99,128,110,101,134,125,112,134,123,113,79,74,62,
  94,88,74,137,123,109,138,125,112,133,114,100,107,88,72,55,49,41,
  10,20,28,15,41,60,14,43,61,16,43,57,16,45,61,14,43,60,
  14,43,59,16,46,60,13,44,58,19,53,70,35,60,47,62,67,53,
  75,71,53,86,94,73,99,107,83,40,66,71,19,55,75,21,58,81,
  24,57,84,22,57,82,21,54,72,29,58,65,47,74,64,54,74,45,
  46,68,53,23,56,73,23,56,75,17,49,66,17,45,61,15,40,55,
  14,40,53,14,41,55,13,41,55,11,40,54,13,42,56,14,42,56,
  14,41,54,13,41,54,11,39,52,40,65,76,105,122,130,124,138,145,
  120,135,142,116,131,139,125,139,146,135,148,155,155,165,171,164,173,179,
  175,183,188,141,153,160,134,147,154,143,156,162,139,154,160,134,149,156,
  134,148,155,131,146,153,146,159,165,185,193,197,199,206,209,196,204,207,
  184,192,197,182,190,195,27,52,66,13,40,53,12,39,52,13,40,53,
  17,44,57,16,43,56,21,47,63,40,55,57,83,77,59,130,115,102,
  132,116,105,127,111,100,130,116,103,137,124,111,129,114,101,114,98,88,
  118,102,95,116,100,94,132,115,106,134,123,110,135,121,111,124,117,104,
  116,107,91,126,114,97,130,120,104,129,111,95,113,92,76,65,58,51,
  13,28,39,13,42,61,14,43,61,16,43,59,15,44,61,16,45,62,
  16,45,61,18,48,63,17,47,63,20,55,74,48,69,56,68,69,55,
  95,90,74,69,75,54,69,81,76,29,56,69,16,51,69,17,55,71,
  18,56,69,17,55,71,16,54,71,21,57,72,26,58,70,51,69,51,
  39,64,52,21,57,79,21,56,68,14,45,61,16,44,62,15,41,59,
  14,40,59,13,40,58,13,41,56,14,42,57,16,44,60,15,43,59,
  12,39,53,13,40,54,13,40,54,56,79,90,103,120,128,118,133,141,
  121,135,143,125,140,147,126,140,147,134,148,155,135,148,155,162,173,178,
  167,177,182,146,158,165,157,169,174,166,177,182,136,151,158,126,142,149,
  129,144,151,127,143,149,137,152,158,160,171,176,159,171,176,168,178,183,
  176,185,189,190,197,201,81,100,111,13,39,54,13,40,54,14,42,55,
  15,44,57,19,50,62,37,52,61,83,83,78,105,91,76,126,107,96,
  123,106,94,110,94,82,128,115,103,141,132,119,127,114,102,116,99,89,
  125,108,100,117,100,93,135,117,110,137,126,116,137,124,113,139,128,114,
  134,121,106,139,126,110,136,122,105,129,109,93,102,82,68,78,66,58,
  15,33,45,14,44,63,15,44,61,16,44,61,16,47,64,16,45,60,
  17,46,62,17,46,62,16,45,62,23,54,71,54,67,49,81,77,57,
  84,85,69,52,68,43,35,62,69,18,53,69,16,50,69,14,53,71,
  15,51,69,17,53,71,18,54,71,18,53,71,25,60,73,66,81,60,
  43,69,57,22,57,74,22,55,70,12,43,60,13,43,61,15,44,62,
  13,40,59,12,40,57,13,41,58,14,42,59,14,42,59,14,42,58,
  12,39,54,11,38,52,14,40,55,122,136,66,191,198,56,191,198,57,
  152,163,69,124,139,146,95,105,115,102,113,123,145,158,164,116,127,133,
  93,102,117,133,147,154,60,131,91,160,173,172,149,161,167,119,135,136,
  56,127,88,139,152,158,150,162,168,98,145,150,74,137,145,141,153,160,
  165,175,180,146,123,116,102,105,99,13,39,54,13,40,55,13,42,56,
  17,46,60,16,49,61,67,68,72,101,88,77,114,96,86,132,113,105,
  133,118,106,115,101,89,130,117,105,140,131,118,138,127,114,135,121,110,
  131,116,106,133,117,107,131,115,105,136,126,115,138,127,119,138,126,118,
  135,124,112,140,127,110,125,107,89,125,105,88,98,81,66,87,76,63,
  16,35,46,15,46,64,15,44,61,15,45,61,15,47,64,16,46,62,
  16,46,63,18,48,65,17,48,65,19,51,66,62,74,56,73,71,43,
  59,69,46,47,73,52,23,56,68,14,53,71,15,51,71,15,53,70,
  16,53,70,18,54,71,17,53,71,20,56,74,25,60,73,52,71,56,
  43,71,65,27,57,74,20,51,67,14,45,62,14,44,61,14,43,60,
  13,40,59,13,40,58,13,41,58,13,41,58,13,41,58,14,42,58,
  14,41,56,11,38,53,21,47,61,171,180,54,122,137,90,125,139,98,
  123,137,60,142,154,160,100,105,126,106,111,132,154,165,171,102,113,126,
  97,100,129,167,178,183,37,146,90,111,161,136,177,186,191,84,142,115,
  48,143,94,152,163,169,196,203,206,53,145,161,34,138,156,137,150,154,
  175,184,188,165,121,119,160,150,145,25,49,64,13,40,55,13,42,56,
  14,43,57,20,49,60,99,94,98,120,106,96,120,103,96,131,113,106,
  125,106,99,126,108,99,137,122,110,137,125,111,138,128,114,133,122,111,
  131,118,106,136,122,109,131,118,104,116,103,88,140,129,126,138,129,127,
  139,131,117,137,124,105,126,106,88,120,101,82,89,76,58,79,71,56,
  15,35,46,14,47,65,15,46,62,17,48,64,16,49,67,16,47,65,
  17,49,66,16,48,65,18,50,68,18,52,68,39,58,53,57,64,40,
  76,85,59,46,67,46,23,57,69,14,53,72,18,54,73,22,59,77,
  24,60,78,29,65,83,19,55,73,17,53,71,27,62,79,34,59,57,
  28,60,67,30,57,74,21,54,68,13,45,62,13,43,61,13,42,60,
  12,40,58,12,40,58,13,41,58,13,40,57,12,40,57,14,41,58,
  12,39,54,10,37,52,25,51,65,171,180,56,108,124,92,120,135,108,
  123,137,124,162,172,178,110,114,136,103,109,130,150,162,168,96,107,121,
  98,101,130,176,185,189,55,119,79,48,140,90,190,197,198,51,127,82,
  53,138,91,164,174,179,176,185,184,56,136,144,67,145,155,128,147,146,
  179,187,191,163,125,122,167,156,151,46,69,82,14,41,56,15,44,58,
  15,45,59,24,49,57,121,112,111,122,106,95,127,112,104,125,109,101,
  125,107,98,130,114,103,126,112,100,133,121,108,135,125,113,127,115,104,
  125,112,99,138,124,110,131,117,101,117,102,88,137,126,119,136,127,121,
  135,124,109,129,113,95,111,93,76,102,87,69,83,71,55,81,71,58,
  15,36,47,15,49,66,16,48,64,16,48,64,15,49,67,17,49,66,
  16,49,66,16,48,66,17,50,68,18,55,74,27,55,65,55,71,59,
  85,88,63,71,82,59,28,58,68,19,57,75,24,58,77,26,62,77,
  25,60,74,26,60,78,21,57,75,20,55,71,22,57,76,27,56,67,
  23,59,74,26,53,70,22,57,69,13,44,61,13,43,60,13,42,60,
  12,40,58,13,41,58,13,41,58,13,41,58,13,41,58,12,40,56,
  12,39,54,11,38,53,23,49,63,165,174,58,255,255,55,255,255,56,
  201,207,60,147,159,166,107,112,134,97,103,124,139,152,159,104,115,128,
  98,101,130,166,177,182,67,125,89,72,153,111,103,144,119,56,122,81,
  54,148,98,187,194,199,125,159,161,86,151,160,113,163,168,99,155,162,
  179,188,192,153,148,143,172,161,155,56,77,90,14,41,55,14,43,57,
  17,46,60,41,62,67,124,109,103,124,108,94,127,113,103,135,122,110,
  136,123,109,134,122,109,133,123,112,139,131,119,136,125,115,129,115,104,
  130,114,102,140,124,109,135,118,102,137,121,109,138,128,114,131,120,105,
  116,98,84,109,91,77,94,79,65,91,77,62,85,71,59,95,81,73,
  16,38,50,14,48,66,16,50,66,15,49,65,15,49,68,17,49,68,
  17,50,69,15,50,68,17,52,69,18,52,70,17,49,68,25,47,53,
  77,82,63,72,81,53,38,66,66,24,61,83,27,60,72,62,87,65,
  87,105,77,43,71,81,20,55,71,46,74,75,58,78,68,51,78,69,
  26,60,71,29,58,74,27,60,72,20,52,65,14,42,60,15,40,60,
  15,42,57,12,40,55,12,40,57,12,40,57,11,39,56,12,40,57,
  11,39,56,11,39,56,19,46,62,64,85,91,81,101,102,112,129,128,
  128,143,72,137,150,157,100,106,129,103,110,130,146,159,166,111,122,134,
  107,109,137,189,198,201,69,128,91,139,171,155,25,150,86,124,149,129,
  59,153,102,229,232,234,89,157,168,23,145,171,20,148,178,51,145,164,
  192,199,203,175,183,181,180,188,185,50,74,86,12,41,55,14,43,57,
  17,46,60,56,68,72,123,109,99,127,114,101,115,109,98,137,131,114,
  142,134,115,139,130,120,139,130,126,139,132,126,137,129,118,134,121,108,
  134,120,105,134,119,103,130,113,97,133,119,101,137,119,103,130,110,97,
  107,89,77,98,82,68,85,70,55,85,74,60,81,69,54,91,77,60,
  15,35,47,15,48,67,16,49,65,17,50,67,15,50,69,18,50,68,
  17,51,69,16,51,69,16,52,69,18,53,69,17,52,71,22,52,64,
  44,64,58,57,73,52,50,77,37,48,79,61,41,71,52,77,102,62,
  78,98,63,34,62,69,14,48,69,19,49,66,27,48,72,29,59,57,
  49,81,65,29,57,71,19,57,77,21,58,75,16,47,66,14,41,61,
  15,42,58,14,42,57,13,41,58,12,40,57,13,40,57,11,39,56,
  11,39,56,11,39,56,17,44,61,108,125,61,85,104,99,102,120,113,
  126,141,68,125,140,148,96,103,125,87,95,113,130,144,143,95,105,116,
  103,106,135,184,193,197,70,128,93,179,189,189,62,137,94,161,172,165,
  57,151,100,217,221,222,35,137,154,79,151,162,85,156,168,31,142,165,
  187,194,191,168,131,128,152,124,117,33,59,72,12,41,55,14,43,57,
  17,45,59,72,85,90,129,120,109,129,117,103,118,111,99,137,132,117,
  138,132,118,138,130,122,138,130,125,140,131,124,136,125,112,123,109,95,
  127,111,96,132,116,99,130,113,96,137,122,101,136,118,99,115,95,80,
  103,86,71,90,75,62,79,66,53,74,66,50,77,70,49,92,84,59,
  15,33,46,15,47,66,17,48,65,18,50,67,17,51,70,18,51,70,
  16,50,68,17,53,70,17,53,70,19,54,70,16,54,73,17,54,71,
  19,51,60,41,67,68,59,82,64,64,87,46,65,87,48,68,95,42,
  64,87,74,21,48,66,17,52,70,18,52,67,18,52,68,18,51,72,
  37,57,64,72,88,72,37,61,66,16,52,69,21,53,71,20,48,66,
  14,42,58,13,41,58,13,40,57,13,41,58,13,41,58,12,40,57,
  13,40,57,12,40,57,23,50,66,159,170,63,218,223,57,218,222,55,
  181,189,60,120,136,144,113,123,136,62,51,122,63,52,122,63,52,122,
  112,120,137,175,185,189,72,123,89,198,205,208,188,196,197,162,172,167,
  61,142,97,170,182,178,68,138,142,208,213,216,207,212,215,85,150,156,
  161,185,183,161,129,123,139,106,103,14,42,56,12,41,55,14,43,57,
  16,45,59,31,50,58,124,124,115,124,114,97,123,115,101,132,123,109,
  143,135,125,137,127,117,139,127,118,137,124,113,128,112,99,133,116,100,
  131,114,98,134,117,100,125,109,90,120,103,82,118,103,82,99,85,67,
  94,80,64,77,64,51,71,62,48,70,67,45,75,75,46,83,83,51,
  14,32,45,15,45,65,17,47,64,18,49,66,17,51,70,18,51,70,
  19,52,70,18,54,71,17,53,71,20,54,71,17,53,72,16,53,73,
  18,52,71,15,50,67,31,58,72,70,87,66,75,95,47,66,94,52,
  28,58,64,16,47,70,16,50,63,16,50,61,17,50,65,13,45,63,
  20,45,65,44,64,63,42,68,67,25,55,66,19,47,59,24,52,64,
  18,49,65,13,42,60,14,41,58,14,41,58,13,41,58,13,41,58,
  12,40,57,12,40,57,16,44,60,56,79,91,72,93,102,89,108,116,
  101,119,127,115,131,141,133,147,155,120,136,140,132,147,150,134,149,152,
  138,153,159,173,184,188,180,189,190,195,202,205,198,205,208,210,215,217,
  193,200,200,208,214,215,199,206,206,208,214,216,217,221,223,214,219,219,
  230,233,233,205,210,211,118,133,140,13,41,55,15,43,57,16,44,59,
  15,44,58,17,44,55,86,96,92,141,134,115,132,119,101,125,108,94,
  134,116,103,126,109,95,125,108,94,122,105,91,127,108,94,129,109,94,
  129,111,94,120,104,85,111,97,77,103,88,69,84,74,54,77,71,52,
  74,67,50,72,63,49,66,61,43,64,66,39,71,76,44,76,81,48,
  15,31,43,14,44,63,16,46,63,18,48,65,17,50,68,17,50,68,
  17,51,69,17,52,71,18,52,72,18,52,70,18,52,72,18,52,72,
  18,52,73,14,51,71,15,50,64,45,67,67,74,94,55,62,82,44,
  43,74,60,31,63,70,29,62,76,25,57,74,24,53,69,23,54,69,
  26,60,71,26,60,67,24,59,73,32,61,71,54,72,68,61,76,68,
  27,53,57,12,42,58,11,38,55,9,38,54,12,42,59,13,41,61,
  13,41,58,13,41,58,14,42,60,38,63,78,84,104,115,94,113,124,
  110,127,137,128,143,152,119,135,144,139,153,161,142,156,163,138,153,160,
  132,147,155,154,166,172,192,200,203,209,215,217,208,213,216,209,214,217,
  211,216,218,212,217,219,209,214,217,207,212,215,215,220,222,220,224,226,
  212,216,219,191,199,202,62,84,96,13,43,58,15,45,60,16,46,62,
  15,43,59,14,46,60,67,78,78,137,122,104,124,108,87,122,101,84,
  113,93,77,116,96,80,113,93,77,116,97,81,120,100,86,118,98,82,
  112,96,76,101,87,66,95,84,61,93,82,62,83,72,55,71,66,45,
  62,59,46,66,62,43,63,61,41,62,65,37,73,81,47,61,69,40,
  10,23,32,15,43,60,15,44,62,18,47,63,16,48,66,17,48,66,
  16,48,67,16,50,69,17,51,71,16,51,70,17,51,71,17,51,71,
  16,50,69,16,51,70,17,52,70,16,46,55,49,73,60,73,91,59,
  66,87,50,61,90,54,34,66,69,27,60,78,25,58,69,24,57,69,
  22,55,63,21,53,63,22,53,69,32,61,77,52,69,68,65,77,68,
  56,80,82,29,58,70,28,55,66,24,56,64,17,49,60,11,40,56,
  13,42,57,15,43,60,13,41,59,17,45,60,88,108,119,114,130,141,
  127,141,151,144,157,165,117,133,143,145,158,166,147,160,167,141,155,163,
  132,147,156,154,166,172,207,212,215,221,225,227,216,221,223,209,215,217,
  211,216,219,210,215,218,209,214,217,213,217,220,222,225,228,214,219,222,
  202,208,211,147,159,166,20,47,61,14,42,58,16,45,60,15,43,58,
  16,44,59,15,46,59,65,70,69,122,102,82,110,96,74,112,95,80,
  90,77,61,93,76,62,110,90,77,108,89,76,94,78,60,100,86,67,
  99,86,71,92,80,65,89,77,62,92,82,68,83,68,58,67,64,41,
  58,61,44,60,62,36,66,67,46,67,71,42,74,82,47,51,59,37,
  11,21,28,15,43,60,14,44,63,17,47,62,16,47,64,17,47,65,
  17,49,66,16,50,67,18,51,70,19,53,73,18,52,71,16,51,70,
  17,51,70,16,50,70,16,51,71,17,51,70,19,50,60,44,71,68,
  80,95,54,72,94,47,49,78,59,25,60,70,21,55,74,22,53,70,
  18,50,63,17,49,64,16,47,65,18,46,65,20,48,63,17,46,57,
  15,43,57,22,50,63,24,53,64,26,59,68,27,59,68,27,56,67,
  13,42,55,12,40,57,13,41,59,14,42,59,35,61,76,113,129,140,
  136,150,159,134,148,157,104,121,133,125,141,150,145,158,166,161,172,179,
  181,190,195,194,202,206,229,232,234,236,238,240,223,227,229,216,221,223,
  211,216,218,211,216,218,206,211,214,216,220,223,218,222,225,207,212,215,
  184,192,196,54,76,88,18,45,59,18,43,55,20,45,58,15,41,54,
  14,41,54,20,45,56,82,88,83,106,93,73,84,72,53,81,70,57,
  73,67,51,77,66,53,96,80,68,97,81,69,82,73,55,81,75,56,
  82,72,59,81,72,57,84,76,55,92,78,61,87,71,58,67,65,45,
  60,66,43,63,66,39,67,69,44,66,70,40,76,83,49,49,54,35,
  6,13,16,17,44,60,13,45,63,15,45,61,15,45,61,17,47,63,
  16,47,64,17,49,66,18,51,69,18,52,71,17,51,71,18,52,71,
  18,52,71,19,53,72,16,52,72,15,52,74,17,51,72,15,46,63,
  63,81,68,67,92,49,47,74,68,29,60,82,21,54,70,18,49,67,
  18,49,67,14,45,63,15,46,64,19,48,62,15,48,64,14,48,65,
  17,48,62,17,45,60,16,46,64,16,46,66,24,54,71,32,59,75,
  22,51,63,14,42,58,14,42,60,13,41,59,15,43,61,74,95,108,
  137,151,160,148,161,169,133,147,156,136,150,158,152,164,171,161,172,179,
  193,200,204,211,216,219,226,229,231,228,231,233,226,230,231,218,222,224,
  203,208,212,204,210,213,208,213,216,214,218,221,208,213,216,204,210,213,
  103,120,129,15,41,55,14,40,54,30,53,63,27,50,62,13,39,51,
  13,40,55,17,43,58,40,56,56,73,76,57,69,65,47,67,65,47,
  59,61,43,69,65,48,85,76,61,90,79,65,80,73,59,74,69,53,
  69,64,43,75,76,52,73,79,55,83,78,60,81,74,59,66,69,57,
  59,65,41,64,66,43,62,66,39,67,71,42,76,81,51,39,42,30,
  3,7,9,17,42,58,13,45,64,15,44,60,15,44,60,17,46,62,
  16,46,63,16,47,64,18,49,67,18,51,70,16,51,70,17,51,70,
  16,50,70,18,52,70,17,53,71,15,52,71,16,52,71,20,53,71,
  30,60,63,47,79,51,32,60,63,22,51,71,19,52,63,18,49,66,
  16,47,65,15,47,64,15,46,62,17,46,63,16,45,63,15,44,64,
  15,44,62,15,44,60,14,45,62,17,48,67,23,53,68,29,56,69,
  29,57,67,18,47,61,15,43,62,15,43,62,13,41,59,18,46,63,
  72,93,106,134,148,157,158,169,177,148,161,168,164,175,181,175,185,190,
  185,193,198,202,209,212,220,224,226,223,226,229,225,229,230,221,225,227,
  206,211,214,208,213,216,208,213,216,212,217,220,215,219,222,132,145,153,
  15,41,56,12,39,54,13,39,54,15,39,50,14,39,52,13,40,54,
  11,41,57,14,43,65,25,54,61,46,63,50,51,57,38,56,63,38,
  55,64,40,64,66,44,82,78,58,88,81,62,82,73,57,82,73,53,
  77,73,49,69,76,66,35,51,60,44,60,70,45,59,65,40,57,57,
  46,62,32,59,65,39,69,74,48,68,72,46,74,77,53,24,24,18,
  3,2,3,16,39,54,15,44,61,16,44,57,13,44,60,15,44,60,
  17,46,63,17,47,63,19,48,64,18,49,64,18,50,66,17,50,67,
  16,49,67,17,51,69,16,52,71,16,52,71,17,53,72,18,53,73,
  23,56,68,43,77,48,42,70,71,20,52,72,16,52,69,17,52,69,
  14,52,67,15,51,65,18,49,64,28,53,70,32,62,70,20,53,68,
  16,48,65,16,47,57,15,44,62,17,48,66,20,55,66,16,51,66,
  30,58,66,20,49,65,16,47,62,15,45,62,15,43,63,13,42,60,
  15,43,61,58,80,95,119,134,144,136,150,159,157,169,176,171,181,187,
  179,188,194,185,193,198,202,208,211,220,224,227,216,221,223,208,214,217,
  213,218,221,214,219,221,215,220,222,211,216,219,112,128,136,15,41,54,
  13,38,52,14,39,53,14,39,53,13,38,53,13,39,53,13,40,54,
  14,42,56,15,44,59,20,51,67,25,54,67,36,58,55,43,58,36,
  44,58,36,56,62,38,83,80,58,92,86,66,94,85,62,82,76,53,
  73,77,67,30,48,55,18,46,64,19,49,63,21,49,70,32,56,60,
  45,60,37,51,63,35,69,73,48,76,72,45,70,71,54,9,9,9,
  2,1,2,13,29,41,17,44,61,15,44,59,14,44,60,15,44,61,
  16,45,61,17,46,62,18,47,64,18,48,63,17,48,64,16,48,65,
  17,49,67,16,50,68,16,51,70,17,52,70,17,51,70,18,53,72,
  20,55,72,25,55,63,44,73,67,28,56,63,33,62,65,26,57,72,
  17,52,68,30,62,68,47,72,66,55,79,69,52,73,59,50,70,71,
  31,58,75,25,57,74,18,50,69,17,49,67,19,52,64,20,51,68,
  25,52,65,26,55,75,19,51,67,17,48,64,16,45,64,13,43,61,
  14,43,60,17,44,63,36,60,77,86,107,119,126,141,151,144,157,166,
  155,168,175,172,182,188,189,196,201,203,209,213,220,224,226,212,217,220,
  214,219,221,221,225,227,174,184,188,70,92,104,14,42,56,12,38,53,
  13,39,53,13,39,53,13,39,54,12,38,54,13,39,56,14,41,57,
  15,43,58,15,45,58,18,49,65,18,50,68,26,54,64,34,55,52,
  57,61,39,65,65,44,83,78,58,101,90,70,89,86,72,67,78,75,
  40,58,63,18,44,57,15,47,64,16,47,66,19,48,66,34,57,53,
  46,58,33,58,67,40,67,71,44,77,73,47,69,70,53,3,4,3,
  2,1,1,10,18,25,18,44,60,14,44,61,16,44,60,15,44,61,
  15,44,61,16,45,61,17,46,63,15,44,59,21,50,66,17,47,65,
  18,49,67,18,50,68,17,51,69,16,50,68,18,52,69,19,53,70,
  18,56,70,24,56,72,30,58,59,49,79,57,41,69,61,47,74,77,
  39,63,71,55,76,65,68,87,51,78,94,74,82,92,69,84,96,74,
  51,72,62,35,65,70,25,58,70,27,59,72,28,60,68,29,59,74,
  29,57,71,23,53,74,19,52,69,17,49,64,16,47,65,15,45,63,
  14,44,62,15,44,61,15,43,61,16,45,62,38,64,80,80,102,114,
  124,140,150,152,165,172,169,179,185,179,188,194,179,188,193,173,183,189,
  141,154,163,73,94,107,16,44,60,11,39,55,13,40,56,13,40,56,
  13,40,56,13,40,56,13,40,56,14,40,57,14,41,58,15,44,61,
  17,47,63,16,45,59,13,43,59,13,44,63,15,46,64,20,50,65,
  36,60,65,67,70,59,82,76,60,73,81,78,25,48,59,19,46,62,
  14,43,59,15,46,63,14,46,63,15,46,66,19,48,65,46,69,63,
  49,61,38,55,65,39,60,64,39,76,71,49,47,47,35,2,2,1,
  2,1,1,4,7,10,21,46,62,14,45,65,16,44,59,15,44,61,
  15,44,61,15,44,60,16,45,61,18,45,61,18,46,63,18,47,65,
  19,49,67,19,51,68,19,52,69,18,51,68,17,50,67,24,57,75,
  21,53,75,18,50,72,19,51,70,20,53,64,19,51,66,66,89,94,
  95,105,84,79,87,56,70,84,60,80,92,68,80,90,67,78,91,56,
  74,88,54,76,91,67,65,82,66,67,84,74,81,99,89,58,78,77,
  42,71,79,23,55,71,17,51,66,17,50,65,17,48,67,15,47,64,
  14,45,62,13,43,60,15,44,61,13,42,60,14,43,60,13,42,59,
  16,45,62,23,50,67,34,60,75,41,66,81,34,60,75,22,49,66,
  15,43,61,16,44,62,12,40,58,13,41,59,15,43,60,14,42,58,
  13,42,58,14,42,58,14,42,59,14,42,60,15,43,60,15,45,62,
  13,44,61,14,44,61,14,45,61,14,44,60,15,45,62,14,45,63,
  11,47,66,26,49,56,36,54,56,20,49,60,13,47,66,14,45,65,
  14,44,63,15,43,62,15,43,61,16,45,60,17,46,66,28,54,57,
  39,57,38,45,59,33,70,73,52,77,70,55,32,32,26,3,3,3,
  1,1,2,2,2,3,16,36,50,13,45,64,16,44,60,16,45,63,
  16,45,62,16,45,62,17,46,63,17,45,62,17,45,62,17,46,63,
  16,46,63,17,48,66,19,51,69,20,52,68,17,51,67,18,52,68,
  19,51,66,17,50,61,19,51,65,15,48,66,17,50,68,33,56,63,
  123,120,108,74,80,56,56,72,47,97,105,75,81,92,63,91,103,65,
  78,91,51,80,93,52,103,109,73,120,122,95,115,117,96,119,126,112,
  40,66,66,24,57,69,17,53,69,20,52,69,20,51,69,18,51,67,
  17,46,61,15,43,59,13,43,61,14,43,61,14,43,60,14,43,61,
  13,42,60,14,43,61,15,44,61,18,47,64,17,46,63,15,44,61,
  14,43,61,15,44,61,13,42,60,14,43,61,13,42,60,14,43,60,
  14,43,60,15,44,61,15,44,62,15,44,62,16,45,63,16,46,64,
  17,48,66,16,46,64,15,44,61,15,44,59,15,44,59,15,44,60,
  14,44,60,10,44,61,11,46,64,14,47,61,16,46,61,17,45,63,
  15,43,60,15,43,60,16,43,60,16,44,58,16,44,63,18,47,59,
  34,58,44,50,63,35,73,73,54,70,66,53,10,10,7,1,2,2,
  0,1,1,1,0,0,9,22,32,16,45,62,16,45,62,17,46,64,
  18,47,64,18,47,65,16,45,63,17,46,63,16,45,61,16,45,62,
  16,45,62,17,46,63,20,49,65,20,51,65,18,50,65,17,49,67,
  17,48,66,17,48,65,20,51,69,20,51,68,18,49,70,33,58,64,
  132,129,117,87,97,72,83,95,67,81,85,56,83,96,60,91,98,61,
  93,98,63,84,98,62,85,99,63,97,103,70,111,113,88,106,112,93,
  89,102,83,68,90,86,28,59,72,21,56,75,21,57,76,25,59,78,
  21,52,70,16,47,64,14,45,62,15,44,62,14,43,61,15,44,61,
  15,44,61,14,43,61,12,42,60,15,45,63,13,43,61,13,43,61,
  11,41,59,16,47,64,19,49,67,16,47,64,15,45,62,15,45,62,
  16,46,63,15,45,62,14,44,62,14,44,61,15,45,63,17,47,65,
  18,48,66,15,44,61,16,45,61,15,44,61,15,44,60,15,44,60,
  14,44,61,14,44,61,14,44,61,15,44,62,16,44,62,16,44,61,
  15,43,60,14,42,59,14,42,60,14,42,60,15,43,58,17,47,64,
  35,58,51,63,70,43,74,72,51,50,49,38,2,2,0,1,2,1,
  0,1,0,0,0,0,4,10,16,21,45,58,16,46,63,18,47,64,
  18,47,65,18,47,65,16,45,63,17,46,63,16,45,61,16,45,61,
  16,45,61,17,45,59,21,49,59,40,68,79,19,48,62,19,48,67,
  18,48,64,15,48,65,16,50,69,16,50,68,18,49,67,36,55,60,
  95,98,83,77,84,57,92,98,64,114,108,77,102,111,74,90,98,62,
  86,88,58,75,87,59,72,92,59,68,85,43,78,90,53,97,106,78,
  96,105,68,115,124,102,58,76,71,29,60,63,31,63,71,29,58,74,
  22,57,76,16,51,70,16,49,64,16,47,64,16,46,64,15,46,63,
  15,46,63,15,45,62,14,44,62,14,45,62,14,44,62,14,44,62,
  14,45,62,16,46,63,15,45,62,18,48,65,15,45,63,16,46,64,
  15,45,63,16,46,64,15,45,63,14,44,62,14,44,62,15,45,63,
  15,45,62,14,44,61,15,44,61,14,43,60,13,42,58,14,43,60,
  15,43,61,15,42,61,16,42,61,15,42,60,15,42,60,14,42,59,
  15,43,60,15,43,60,15,42,60,14,43,59,15,43,58,14,43,63,
  44,61,61,74,76,53,68,66,47,29,27,22,1,1,0,1,2,1,
  0,1,0,0,0,1,0,1,3,19,36,46,16,46,64,18,47,65,
  18,47,64,18,47,65,17,46,64,15,44,61,16,45,61,15,44,61,
  15,44,61,17,44,59,17,44,55,19,47,57,20,49,63,19,48,65,
  18,48,62,14,48,64,15,48,65,19,48,61,41,64,70,111,117,110,
  70,81,59,78,89,59,91,99,61,120,113,82,104,108,72,96,103,67,
  80,91,58,54,75,45,55,79,49,65,89,51,67,84,45,94,102,69,
  95,102,71,83,92,61,82,96,64,81,100,70,85,100,83,82,96,91,
  48,69,70,31,60,70,20,55,71,19,51,68,18,49,66,16,48,65,
  17,48,65,16,47,64,15,45,63,15,45,63,14,44,62,15,45,63,
  15,45,63,17,47,65,18,48,66,19,49,67,16,46,64,18,48,66,
  17,47,65,17,48,65,16,46,64,15,45,63,15,45,63,14,44,62,
  14,44,62,13,43,60,15,44,60,16,45,62,16,45,62,16,45,61,
  15,43,61,15,43,61,14,42,60,14,42,60,15,43,61,15,43,60,
  15,43,60,14,42,59,13,41,59,13,42,59,14,44,58,18,46,65,
  51,62,62,74,72,49,69,67,50,14,11,10,1,0,1,0,1,0,
  1,0,0,0,0,2,3,1,1,9,19,27,16,46,64,18,47,65,
  18,47,64,18,47,64,16,45,63,16,45,61,16,45,62,15,44,61,
  15,44,61,15,43,60,16,44,60,16,45,58,14,45,58,15,46,60,
  17,48,61,16,49,64,21,52,66,35,57,63,112,124,117,102,97,78,
  77,92,61,87,104,71,74,90,51,73,89,52,98,110,72,92,94,59,
  89,97,63,67,88,53,62,86,56,69,94,65,72,89,56,95,101,65,
  118,113,86,89,98,59,83,104,57,66,87,40,100,110,74,124,123,95,
  113,114,94,54,73,71,24,61,78,25,58,75,21,53,70,17,49,66,
  16,49,65,15,46,64,17,47,65,18,48,66,16,47,64,15,45,63,
  16,46,64,17,47,65,17,47,65,17,48,65,18,49,66,17,47,65,
  18,48,66,18,48,66,17,47,65,16,46,64,17,47,65,16,46,64,
  14,44,62,14,44,61,12,41,57,18,47,63,17,46,62,19,48,65,
  15,46,63,14,45,62,15,45,63,14,45,62,14,43,60,15,43,60,
  15,43,60,13,41,58,12,40,57,13,41,59,13,43,58,18,45,61,
  61,69,64,77,72,48,52,49,37,4,1,2,1,0,3,0,0,1,
  0,0,0,2,0,0,2,1,1,1,5,8,18,41,51,14,49,64,
  16,46,64,19,44,63,15,45,60,14,43,59,15,43,60,17,45,62,
  16,44,61,16,43,61,15,43,60,15,43,60,16,44,60,17,45,62,
  16,43,60,15,43,56,17,44,60,64,79,80,115,117,100,71,79,53,
  62,81,41,69,90,47,82,98,59,74,90,48,68,86,43,75,94,51,
  80,97,55,80,95,56,74,90,52,79,99,59,78,96,54,95,107,66,
  76,88,58,70,91,51,76,94,52,70,87,49,67,86,46,79,89,57,
  99,105,77,70,88,66,29,60,73,26,59,77,24,57,79,17,50,66,
  17,48,62,17,46,64,17,47,64,16,46,64,16,47,65,16,47,65,
  16,46,64,17,47,65,17,47,65,17,48,65,19,50,67,18,50,67,
  20,52,68,14,46,63,17,49,66,17,48,65,16,47,64,13,44,61,
  11,42,59,15,44,62,15,44,62,15,44,62,15,44,61,15,44,61,
  17,47,65,15,45,62,15,45,62,14,44,61,14,43,60,15,43,60,
  14,42,59,14,42,59,12,40,56,15,39,55,11,42,61,30,51,56,
  65,67,53,81,75,57,23,18,14,2,1,2,0,0,3,0,0,0,
  0,1,0,1,0,0,1,1,1,0,2,4,10,22,30,17,47,59,
  16,46,63,19,44,63,15,45,60,15,43,60,15,43,60,15,43,60,
  18,45,63,15,43,60,15,43,60,15,43,60,15,43,60,16,44,61,
  13,45,57,12,45,56,12,44,65,43,60,70,91,95,81,84,93,64,
  67,85,44,70,91,44,73,92,45,70,88,42,65,85,39,72,91,48,
  87,100,60,91,102,65,85,100,62,70,84,45,83,96,57,92,103,65,
  68,85,52,55,78,38,63,79,39,87,99,64,67,86,46,62,78,40,
  79,91,55,78,97,66,52,79,77,20,61,81,25,63,86,25,60,74,
  17,50,61,17,47,63,16,47,63,16,47,62,18,47,62,18,47,62,
  15,45,63,16,46,64,15,45,63,16,46,63,13,43,61,14,46,63,
  16,47,64,14,45,62,16,47,64,15,45,62,14,44,61,12,42,59,
  14,44,61,13,43,60,13,43,60,15,45,62,16,46,63,17,46,64,
  17,47,65,18,48,65,14,44,62,15,45,62,14,43,60,15,43,59,
  13,41,57,11,39,54,12,39,55,12,37,54,15,40,55,50,60,59,
  78,72,55,66,58,47,6,2,1,2,1,2,0,0,1,0,1,0,
  0,1,0,0,1,0,1,0,0,1,0,1,2,4,7,20,41,49,
  16,47,61,17,44,61,16,44,58,15,43,60,15,43,60,15,43,60,
  16,44,61,17,44,62,16,44,61,15,43,60,15,43,60,15,43,60,
  16,43,60,14,41,53,13,40,54,70,85,80,87,90,65,83,91,60,
  76,92,51,64,85,37,61,84,33,66,89,38,67,89,40,64,82,40,
  91,101,62,94,105,67,76,91,52,96,108,70,93,102,65,87,96,60,
  67,85,48,63,85,46,72,85,49,92,102,69,64,81,41,74,93,50,
  66,84,41,67,87,48,54,78,54,38,66,67,31,58,67,28,59,68,
  23,59,76,18,54,76,15,50,68,14,49,66,14,48,65,14,47,64,
  14,44,62,15,45,63,15,45,62,14,45,62,15,45,63,14,44,61,
  13,43,60,13,43,60,12,42,59,12,41,59,12,40,58,13,42,59,
  15,44,61,14,43,61,14,45,62,14,45,62,16,47,64,16,47,64,
  17,48,65,15,45,63,14,44,62,14,44,61,15,44,60,15,43,58,
  14,42,57,11,39,54,10,39,53,12,39,55,22,40,49,72,70,62,
  90,79,64,25,20,16,2,1,1,2,0,1,0,0,0,0,1,0,
  0,1,0,0,0,0,0,0,1,0,0,0,1,1,1,9,21,25,
  17,47,59,16,45,61,17,45,58,14,43,59,15,43,60,16,44,61,
  16,44,61,16,44,61,16,44,61,15,43,60,15,43,60,15,43,60,
  16,42,61,13,41,52,13,40,53,53,67,61,82,87,57,88,95,62,
  80,93,55,76,96,53,64,89,42,63,88,39,64,88,40,65,87,40,
  79,95,51,77,95,49,73,93,47,98,111,69,87,97,57,95,106,67,
  82,97,59,65,84,46,71,83,49,65,77,44,74,90,53,80,97,53,
  70,91,44,70,94,50,61,86,43,80,100,68,78,93,70,82,98,80,
  60,82,76,32,56,64,28,54,63,25,53,64,23,53,67,23,55,70,
  17,47,65,17,47,65,18,48,66,16,46,64,17,46,64,16,45,62,
  15,44,62,15,44,61,13,42,60,13,40,59,14,42,60,14,42,60,
  15,43,61,14,44,61,13,44,61,14,46,63,16,48,65,17,49,65,
  18,48,65,16,46,64,15,45,62,15,45,63,13,42,58,12,40,54,
  10,39,52,10,38,52,9,38,52,9,36,52,43,54,59,82,72,61,
  74,64,56,2,1,1,0,0,0,2,0,0,1,0,0,0,1,0,
  1,0,0,0,0,0,0,0,0,0,1,0,2,1,0,2,5,8,
  15,39,51,14,47,61,17,44,58,15,43,58,14,42,58,14,42,58,
  15,43,59,15,43,60,17,45,61,15,43,59,15,43,59,14,42,58,
  12,43,57,11,42,55,11,41,58,17,40,50,72,82,69,80,87,58,
  63,79,43,59,82,39,59,86,42,60,86,36,57,82,39,58,82,38,
  65,85,38,67,89,39,61,84,34,72,91,43,75,92,47,73,91,48,
  89,105,60,81,98,57,89,104,66,77,91,55,64,80,42,75,95,52,
  69,93,48,66,93,46,67,93,41,70,96,45,78,98,51,82,96,52,
  100,112,74,81,94,68,87,99,79,89,99,82,88,101,89,53,69,63,
  25,53,64,19,52,72,17,47,68,20,50,66,19,50,67,16,45,63,
  15,44,62,15,43,61,14,42,60,14,42,60,14,41,59,15,43,60,
  15,43,61,14,44,61,15,46,62,16,47,64,17,48,65,17,48,65,
  16,47,64,15,45,62,13,43,60,13,42,60,12,40,55,11,39,52,
  11,38,51,10,37,50,9,37,50,10,38,53,50,56,57,87,77,68,
  23,19,16,0,1,2,0,1,0,1,0,0,1,0,0,0,0,1,
  0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,2,1,3,
  6,15,23,16,47,57,14,44,59,13,41,56,14,43,57,15,44,58,
  14,43,57,15,43,57,14,42,57,14,42,57,14,42,57,13,41,56,
  13,42,56,13,41,56,12,41,55,11,39,54,30,50,55,77,86,67,
  70,83,46,59,85,44,55,83,39,58,85,33,51,77,36,52,78,37,
  65,87,41,64,86,37,69,93,42,66,89,38,67,90,41,68,90,45,
  65,86,39,67,87,40,71,91,46,67,86,42,72,93,47,61,86,40,
  58,85,39,59,86,37,70,96,44,59,90,38,64,93,43,65,90,42,
  82,104,57,84,103,58,97,109,64,106,108,64,123,120,83,123,122,92,
  86,96,79,75,92,87,24,53,65,15,46,65,15,44,62,15,44,61,
  14,43,60,15,42,61,15,41,60,14,41,58,14,42,59,14,42,59,
  14,42,59,16,44,61,16,45,62,16,45,62,18,47,64,19,48,64,
  15,46,61,13,43,59,14,43,59,16,44,60,11,38,53,12,38,52,
  11,37,51,10,36,50,11,37,51,17,44,56,74,77,75,63,56,52,
  3,2,2,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,
  1,2,2,12,29,35,15,45,63,14,42,57,14,42,56,13,41,55,
  14,43,57,14,42,56,14,42,56,15,42,56,14,41,55,14,42,55,
  13,40,55,13,40,54,13,40,54,13,40,55,12,42,57,57,69,62,
  82,85,54,62,84,50,59,82,40,58,84,38,53,82,36,48,76,36,
  57,83,37,60,85,35,60,84,35,62,86,36,67,91,41,67,90,43,
  64,89,43,61,85,37,59,85,34,60,87,36,61,87,36,64,90,40,
  57,86,38,57,84,36,65,90,40,63,90,41,66,90,43,67,88,44,
  76,93,52,76,90,50,92,99,59,110,106,66,125,112,76,133,117,85,
  130,114,83,131,120,88,36,61,60,12,47,66,18,43,60,14,43,60,
  15,43,61,15,42,60,15,41,60,13,41,58,13,41,58,13,40,57,
  13,41,58,14,42,59,14,43,60,16,45,62,16,45,62,16,45,62,
  14,45,59,15,45,59,14,42,57,13,40,56,12,38,53,12,38,52,
  11,37,51,10,36,50,13,39,52,25,43,52,75,75,73,10,6,5,
  2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,
  1,1,0,3,6,10,18,39,50,15,43,57,14,42,56,13,42,56,
  12,40,55,12,40,53,13,39,52,12,39,52,13,39,52,13,39,52,
  13,39,52,11,38,51,11,37,50,11,38,51,10,38,55,21,42,50,
  73,79,67,64,71,43,68,84,48,56,78,39,56,83,35,51,79,40,
  55,82,39,60,85,34,60,85,37,62,87,36,62,88,36,62,87,37,
  61,86,37,59,86,34,61,90,40,55,85,40,59,87,43,60,88,40,
  54,84,37,57,86,39,63,88,39,69,87,41,77,91,49,78,87,50,
  81,87,53,93,94,64,98,93,65,115,105,78,118,102,76,129,110,86,
  133,112,87,121,112,92,41,65,70,12,46,62,15,43,57,14,43,61,
  14,42,60,14,41,60,15,41,60,13,40,57,13,41,58,13,40,57,
  14,42,59,14,43,59,15,44,61,16,45,62,20,49,65,16,45,61,
  14,44,58,13,42,56,15,42,56,13,39,54,13,39,53,12,38,51,
  10,36,50,13,39,53,12,37,50,51,60,65,28,25,24,3,1,1,
  0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,1,1,0,
  1,2,1,4,2,4,8,15,17,16,43,55,14,42,56,13,42,56,
  13,42,55,14,40,53,13,39,52,13,38,51,12,38,51,12,38,51,
  13,38,51,12,38,51,11,37,50,11,37,50,14,37,48,10,38,56,
  35,51,56,92,87,60,68,77,47,59,74,42,60,83,36,55,80,42,
  62,85,44,59,83,32,57,82,35,60,86,35,61,87,35,60,85,35,
  61,87,33,62,89,35,62,91,44,50,79,45,58,85,51,53,80,39,
  53,82,41,55,84,38,60,86,37,67,85,40,69,84,42,68,79,43,
  77,84,52,95,90,61,112,99,72,110,98,71,116,105,78,122,111,82,
  125,122,85,68,85,76,19,46,58,14,43,61,13,43,61,13,43,60,
  13,41,59,14,40,59,14,40,59,13,41,57,13,41,58,13,41,58,
  14,42,59,14,42,59,15,44,60,15,44,61,18,47,64,13,42,59,
  14,42,56,13,41,54,12,39,52,12,38,52,11,37,50,9,35,49,
  12,38,52,14,40,54,14,38,51,44,47,49,6,2,1,2,0,1,
  0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,1,1,12,24,30,17,43,55,11,44,59,
  13,42,54,14,41,52,14,40,53,14,40,53,13,39,52,12,38,51,
  13,38,51,13,38,51,12,38,51,12,38,51,14,37,50,11,36,51,
  12,36,46,64,70,62,107,97,72,105,96,66,84,92,59,57,78,42,
  66,86,43,68,84,39,66,83,39,63,84,38,63,86,40,67,90,44,
  55,84,39,56,84,35,60,87,38,58,87,41,53,83,43,46,76,40,
  52,81,45,57,83,43,60,82,38,68,83,41,74,84,46,85,87,56,
  78,78,50,109,86,67,111,93,75,111,99,73,111,104,65,109,111,79,
  58,76,75,18,45,56,14,45,62,15,44,61,16,43,59,13,41,58,
  12,40,57,13,41,58,13,41,58,12,41,55,13,42,56,12,41,55,
  14,43,57,15,43,58,16,45,59,17,45,60,14,43,57,15,44,58,
  13,42,55,13,41,54,11,38,51,12,38,52,10,36,49,10,36,50,
  14,42,56,14,37,49,22,39,47,0,0,1,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,1,4,6,16,34,40,13,41,53,
  13,42,56,15,42,56,14,40,53,14,40,53,13,39,52,13,39,52,
  13,38,51,13,38,51,12,38,51,12,38,51,12,38,49,11,38,51,
  14,42,55,25,42,46,86,90,83,102,96,75,99,92,65,92,93,64,
  58,77,43,54,79,45,65,81,49,78,89,55,70,84,45,65,86,42,
  61,83,36,68,87,41,60,78,34,61,81,39,54,77,42,49,73,43,
  51,75,43,57,80,41,65,84,40,65,81,39,67,78,40,79,81,50,
  71,74,45,109,89,69,104,89,68,94,87,54,100,100,68,72,85,77,
  20,45,56,14,43,60,14,44,63,15,42,59,16,42,58,13,41,58,
  15,43,60,13,40,57,13,41,57,12,41,55,13,42,56,13,42,56,
  15,43,57,16,44,59,15,44,58,14,43,57,14,43,57,16,44,58,
  13,42,55,11,38,51,11,37,51,10,36,49,12,36,51,11,38,53,
  9,39,49,17,37,44,7,10,16,0,0,1,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,1,1,1,2,6,7,17,35,41,
  15,41,54,14,41,56,16,42,55,16,42,55,14,40,53,13,39,52,
  13,38,51,13,38,51,12,38,51,12,37,50,13,38,49,13,40,52,
  11,39,54,13,37,51,15,35,46,41,57,59,101,98,91,110,98,78,
  82,82,53,58,76,42,59,80,45,69,84,47,64,82,37,62,85,35,
  67,83,35,82,94,51,83,94,55,70,83,45,67,82,48,62,79,49,
  62,80,48,60,78,40,70,85,42,67,84,41,69,80,42,72,73,42,
  70,76,46,101,88,66,93,84,59,88,84,50,76,84,61,23,49,62,
  15,45,63,13,44,63,14,43,62,17,43,60,17,42,59,14,42,59,
  13,41,58,12,40,57,12,40,56,12,41,55,13,41,55,13,41,55,
  14,42,56,16,44,58,15,43,57,13,41,55,14,43,57,13,41,56,
  13,40,53,11,38,51,11,36,50,13,37,51,14,37,53,12,37,51,
  11,35,41,4,11,14,3,0,2,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,1,1,1,0,2,0,2,9,11,
  18,37,48,15,41,55,15,41,54,15,41,54,14,40,53,14,40,53,
  13,39,52,13,38,51,12,38,51,12,38,51,15,41,54,13,38,50,
  13,37,50,13,37,51,12,36,51,11,37,52,24,38,46,90,88,83,
  100,89,69,93,89,62,75,82,53,60,75,39,66,82,40,62,75,32,
  68,84,39,73,86,45,69,80,42,67,80,39,71,84,43,70,81,45,
  66,80,44,67,81,42,69,81,39,69,83,41,76,82,45,74,72,42,
  66,71,42,91,83,58,98,93,68,96,92,64,75,83,68,19,50,66,
  15,46,63,16,47,63,15,44,60,15,43,61,15,43,60,14,42,59,
  14,41,58,12,40,57,11,39,56,11,40,54,12,40,54,13,41,55,
  14,43,57,14,43,57,14,43,57,14,42,56,14,43,57,12,41,55,
  12,38,52,13,38,52,13,37,51,14,37,52,11,37,50,12,34,44,
  6,14,19,1,1,3,1,0,1,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,2,
  4,11,15,17,35,45,14,40,52,13,41,54,13,40,54,14,40,52,
  14,40,53,13,39,52,14,40,53,16,42,55,12,38,51,11,36,48,
  13,36,48,12,36,47,11,36,48,12,35,48,14,39,50,30,43,49,
  96,90,81,115,105,87,85,78,61,64,67,43,70,78,49,75,76,47,
  71,79,43,69,82,38,61,76,38,64,78,40,71,84,40,73,85,44,
  70,81,42,72,79,44,74,77,44,73,80,43,69,72,36,71,71,38,
  63,68,38,72,69,45,82,77,52,86,82,57,51,65,55,21,54,66,
  15,46,62,16,46,61,15,45,60,14,44,61,15,44,60,15,42,58,
  13,41,57,14,41,57,13,40,56,12,40,55,13,40,55,14,42,57,
  15,42,57,15,44,58,15,43,58,13,42,56,14,41,55,13,40,53,
  13,39,51,13,37,52,14,38,53,11,37,50,10,35,42,6,18,21,
  1,1,4,3,0,1,1,0,1,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,1,1,4,11,15,16,36,44,14,39,51,12,40,53,13,40,52,
  15,40,53,15,40,53,15,40,53,12,38,51,13,39,51,11,38,49,
  11,38,49,11,38,49,11,37,49,12,37,50,11,38,49,19,33,43,
  109,104,97,94,83,64,109,97,83,72,67,49,48,53,30,57,58,35,
  62,64,37,71,84,39,60,75,41,62,75,44,71,83,42,69,82,39,
  75,87,45,71,78,43,75,76,47,71,73,43,68,71,38,65,68,36,
  66,69,41,65,67,39,74,73,42,65,72,52,33,57,63,21,52,72,
  20,49,67,18,47,64,17,46,63,16,45,62,15,43,59,15,42,57,
  13,40,54,13,40,54,13,39,54,12,39,54,14,40,56,14,40,56,
  13,40,55,14,42,57,16,45,59,16,43,57,15,42,55,13,39,52,
  11,37,50,11,38,51,14,38,51,12,33,42,5,18,20,1,4,4,
  1,1,1,2,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,2,5,10,15,15,30,38,14,38,49,11,40,53,
  14,40,53,14,39,52,13,39,52,12,38,51,12,38,50,12,38,50,
  12,39,50,11,38,49,11,38,49,12,39,51,12,37,49,18,33,45,
  98,90,87,100,79,63,101,82,67,80,70,54,50,52,33,49,49,32,
  47,50,27,67,77,42,63,75,44,66,76,48,85,93,57,72,83,42,
  65,79,38,66,79,41,66,76,44,66,71,39,62,67,36,58,63,35,
  63,68,43,53,59,33,61,70,46,34,56,52,16,50,66,17,47,67,
  14,42,59,14,42,59,13,42,58,13,42,58,13,41,57,14,41,55,
  12,39,54,12,39,54,13,40,55,13,40,54,13,40,55,14,41,55,
  14,41,55,14,42,56,15,42,56,14,40,54,14,40,53,13,38,50,
  12,37,51,10,38,48,11,32,38,7,13,17,2,1,4,1,1,1,
  1,1,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,1,1,1,1,2,1,5,8,14,29,37,15,37,48,
  13,39,52,14,39,52,14,39,52,13,39,52,12,38,50,11,38,49,
  11,38,49,11,38,49,11,38,49,10,38,49,12,36,48,11,33,44,
  76,73,70,92,70,56,94,75,61,73,63,47,57,59,41,58,57,41,
  52,54,33,64,68,42,78,83,53,73,78,49,69,74,43,81,88,53,
  71,84,47,64,79,43,59,72,40,56,65,36,56,67,45,36,50,34,
  29,47,36,32,53,48,26,47,49,20,48,59,13,48,63,17,46,55,
  16,43,58,15,43,58,14,41,57,13,40,56,13,39,55,13,39,54,
  11,38,53,12,38,53,13,40,54,13,40,53,13,40,53,13,41,53,
  14,41,53,15,42,55,15,42,55,12,37,50,12,37,49,13,37,48,
  13,34,46,12,29,36,3,10,11,2,1,2,3,0,0,2,0,0,
  0,1,0,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,1,0,0,1,1,1,4,9,11,22,31,
  13,36,48,13,38,51,11,37,50,12,38,51,13,38,51,11,38,49,
  11,38,49,12,39,50,10,37,48,10,39,49,13,36,49,8,36,46,
  80,84,80,121,104,91,102,89,76,77,69,55,58,58,41,57,54,37,
  62,62,41,63,61,40,82,80,51,95,94,64,61,63,35,79,85,55,
  74,83,51,56,67,36,57,66,39,47,58,44,31,47,45,26,49,58,
  20,49,64,15,49,63,16,47,59,19,45,61,14,43,63,15,41,56,
  14,41,55,14,40,55,13,39,54,13,39,54,13,39,54,13,39,54,
  13,39,54,12,39,53,11,38,52,12,39,52,13,40,52,14,41,53,
  14,41,54,13,40,53,13,39,52,14,39,51,14,37,48,11,33,43,
  10,27,34,2,6,11,3,0,1,1,0,0,1,1,0,1,0,0,
  0,1,0,1,0,1,3,0,2,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
  7,14,18,14,33,41,10,38,49,12,38,51,13,37,49,13,37,48,
  13,37,49,13,38,49,12,37,49,10,36,49,11,37,46,12,34,46,
  78,76,74,110,95,79,101,87,74,96,84,70,74,67,51,77,65,50,
  64,56,39,77,72,53,70,67,43,91,91,56,77,81,48,64,68,43,
  69,70,46,63,63,38,63,64,39,43,60,50,24,48,64,16,48,59,
  15,46,56,16,44,61,16,44,57,16,43,57,12,39,54,13,40,54,
  13,40,54,14,41,56,15,42,56,14,41,55,15,41,55,13,39,52,
  12,38,52,12,38,51,12,38,52,13,39,53,14,39,52,14,39,51,
  13,39,50,11,38,49,11,38,49,12,37,49,14,31,41,11,20,26,
  0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,2,3,8,11,10,24,32,13,34,44,12,37,48,11,36,49,
  12,37,49,13,37,49,12,36,47,12,36,48,11,37,46,13,37,52,
  51,57,59,118,111,98,93,79,70,101,86,75,91,83,66,93,81,64,
  84,71,61,69,64,50,48,48,27,90,83,59,101,92,68,71,64,43,
  75,65,47,63,56,41,65,65,50,24,48,47,19,47,65,13,45,57,
  14,43,53,14,40,56,13,40,53,12,39,52,13,40,53,20,47,60,
  21,49,62,18,45,58,15,42,55,13,40,53,13,40,53,11,37,49,
  12,38,50,13,39,51,13,38,51,12,37,49,13,39,52,12,39,52,
  11,38,52,13,37,49,14,35,44,13,29,37,4,10,15,2,3,4,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,0,2,0,1,1,2,5,5,15,19,11,30,38,13,34,45,
  13,35,46,12,35,48,13,36,49,13,36,48,12,37,47,9,36,53,
  24,40,43,62,62,51,81,69,62,78,62,52,74,63,47,97,84,67,
  93,78,62,74,70,45,77,78,47,96,89,62,93,83,56,96,81,60,
  85,67,61,60,62,65,30,56,61,15,44,55,13,41,57,12,41,54,
  13,40,52,14,39,53,13,38,51,12,37,50,11,37,50,12,38,51,
  14,40,52,11,37,50,11,37,50,13,39,51,11,36,49,12,36,49,
  13,37,49,12,37,49,13,38,49,14,37,47,13,38,51,12,37,52,
  13,34,47,15,31,41,9,19,25,1,4,7,1,1,1,2,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,0,1,1,0,0,1,1,0,1,2,2,1,5,7,9,19,24,
  15,30,38,14,34,46,12,36,50,14,36,49,14,36,47,11,36,52,
  25,42,42,50,54,38,68,58,48,80,62,53,85,73,60,75,62,48,
  93,83,61,98,91,59,98,96,59,94,96,64,82,82,64,85,89,83,
  39,61,59,17,46,55,16,41,59,14,38,54,13,37,48,12,37,48,
  11,36,49,10,35,48,10,35,47,10,35,47,11,36,48,11,35,47,
  11,35,48,11,35,47,11,36,48,11,36,48,11,35,47,11,35,46,
  12,36,47,12,36,47,12,36,47,14,36,46,11,35,48,14,34,47,
  13,24,32,4,7,13,1,1,4,2,1,1,2,0,0,1,0,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,0,2,0,0,0,0,1,0,1,0,0,1,1,0,0,2,2,
  1,5,9,7,19,28,11,31,42,11,35,49,13,35,48,12,35,49,
  23,42,44,58,68,58,61,56,47,86,70,60,80,63,53,84,68,59,
  83,73,55,98,88,68,94,92,71,83,92,74,31,53,48,20,47,55,
  14,41,51,10,38,49,10,37,49,12,34,48,11,34,43,11,34,45,
  10,34,47,9,35,46,9,35,46,10,35,45,10,34,44,10,34,44,
  11,33,44,12,34,46,12,34,45,12,34,45,12,34,45,10,34,44,
  11,34,44,11,32,43,13,33,45,13,31,40,11,25,35,3,9,16,
  0,1,3,0,0,1,1,0,1,2,0,0,1,0,0,0,0,2,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,2,0,2,5,1,6,10,8,18,23,14,27,36,14,32,44,
  14,38,48,30,45,50,94,93,91,79,68,61,80,61,54,90,71,67,
  54,58,63,39,50,59,27,45,57,18,45,55,16,43,54,12,37,49,
  9,33,46,10,33,45,10,33,45,9,33,44,10,34,45,10,34,45,
  10,34,45,11,33,44,12,32,44,12,32,44,12,32,44,11,32,43,
  10,32,43,11,32,43,11,31,43,11,31,43,11,32,42,11,32,41,
  14,32,41,15,29,39,12,22,31,3,10,14,0,1,5,0,0,2,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,2,
  1,0,2,1,0,1,1,0,1,2,1,1,1,2,5,6,11,17,
  10,22,29,19,32,39,32,38,41,60,58,55,68,60,55,67,59,55,
  32,45,56,23,42,56,20,43,57,15,40,52,10,34,45,9,31,43,
  10,31,43,11,31,43,11,30,43,10,32,44,9,32,44,10,32,44,
  10,33,44,11,32,43,12,31,42,11,30,43,9,30,43,10,30,44,
  10,31,44,11,31,43,11,30,42,13,30,42,14,29,38,11,23,28,
  7,14,18,2,5,7,0,1,3,2,1,1,2,1,1,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,
  0,1,0,1,0,0,2,0,0,0,1,3,0,1,1,1,1,0,
  2,1,0,2,4,6,7,14,16,14,21,21,26,32,28,51,56,53,
  23,43,52,18,44,55,16,45,56,17,44,54,17,41,51,15,36,47,
  13,34,45,11,31,42,11,30,42,10,30,43,9,30,42,10,31,44,
  11,32,44,11,33,44,10,32,42,9,30,39,11,30,39,12,31,39,
  15,31,39,14,27,34,13,22,29,6,12,18,1,4,7,0,1,3,
  0,1,1,0,0,0,1,0,0,2,0,0,1,0,0,0,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,
  0,1,0,0,1,0,0,0,0,1,0,0,1,1,0,0,2,0,
  0,1,2,3,1,4,4,2,5,2,2,5,2,4,6,3,5,6,
  10,13,16,7,17,22,10,25,31,15,28,34,16,33,41,12,36,45,
  14,36,46,14,36,46,12,33,43,11,32,44,13,33,46,13,34,46,
  13,34,46,14,33,46,14,27,39,16,26,34,10,17,22,6,11,14,
  4,8,11,1,3,5,1,1,2,2,0,0,3,0,0,2,1,0,
  2,0,0,0,0,0,0,1,0,0,0,2,0,1,2,0,1,1,
  0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
} ;

  /** NIH "logo" **/
  
static unsigned char nih_rgb[] = {
  10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,
  10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,
  10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,
  10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,
  10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,
  10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,
  10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,
  10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,10,31,137,
  10,31,95,10,31,168,10,31,168,10,31,168,10,31,153,10,31,168,
  10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,
  10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,
  10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,
  10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,
  10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,
  10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,
  10,31,168,31,140,61,5,98,140,4,65,145,5,88,140,3,144,68,
  3,145,52,3,145,46,3,145,90,3,139,137,3,96,144,3,102,145,
  3,104,145,3,106,145,3,104,145,3,117,145,3,121,145,3,123,141,
  3,124,139,3,143,113,3,145,88,10,145,50,11,145,42,10,145,45,
  3,145,73,32,145,35,88,145,3,143,66,4,145,10,8,145,21,5,
  108,126,4,88,145,4,48,145,7,56,145,6,91,143,3,142,111,5,
  145,48,9,145,34,10,145,33,12,145,13,21,145,19,18,145,14,19,
  145,100,3,129,94,4,126,74,6,145,23,18,145,9,21,118,3,24,
  88,19,15,145,22,19,144,93,5,127,135,3,78,44,3,67,26,2,
  145,87,3,136,76,3,135,85,3,119,109,3,136,80,3,109,119,3,
  25,145,20,6,145,61,5,145,87,40,145,18,80,145,3,123,116,3,
  100,125,3,66,145,4,45,145,14,19,145,12,60,145,5,59,145,6,
  23,145,33,10,145,37,6,145,43,6,145,74,3,133,133,3,107,145,
  3,86,145,3,81,145,3,91,145,3,126,138,3,143,133,3,145,108,
  3,145,66,3,145,54,3,145,86,3,130,137,7,113,144,17,68,145,
  10,31,168,74,140,25,25,129,47,14,96,100,3,104,145,3,142,64,
  3,145,51,3,145,54,3,145,93,3,145,134,3,127,144,3,117,145,
  4,108,145,4,93,145,3,95,143,3,130,136,3,132,133,3,137,118,
  3,125,145,3,134,129,3,145,89,3,145,59,3,145,70,3,144,95,
  3,140,118,31,142,58,88,143,3,144,34,8,145,3,12,145,48,8,
  142,77,5,82,83,3,119,141,3,122,142,3,133,120,5,143,50,16,
  140,22,21,145,4,24,145,11,21,145,3,24,145,20,18,145,39,11,
  145,117,3,125,131,3,118,140,3,145,64,9,145,3,24,109,3,24,
  97,3,24,145,3,24,123,75,13,95,132,3,68,37,3,70,16,3,
  132,14,3,145,41,5,93,117,3,136,82,3,141,68,3,106,109,3,
  35,140,30,28,144,22,28,145,19,43,145,3,76,145,3,103,138,3,
  80,136,9,20,145,34,4,145,50,7,145,28,45,145,7,56,145,7,
  22,145,13,13,145,7,12,145,15,7,145,55,3,136,140,3,135,145,
  3,134,138,3,127,137,3,132,135,3,138,135,3,144,139,3,145,101,
  3,145,58,3,145,60,3,145,96,3,123,141,13,102,134,10,31,168,
  10,31,168,56,142,41,36,145,20,16,144,50,3,116,141,3,142,96,
  3,145,80,3,145,78,3,145,102,3,145,119,4,145,126,3,128,139,
  9,56,145,17,15,145,9,65,139,3,143,102,3,141,107,3,137,130,
  3,138,124,3,142,102,4,145,75,4,145,62,3,145,59,3,142,78,
  3,116,145,10,114,115,57,128,55,141,26,12,145,9,22,145,83,7,
  139,107,3,63,67,3,138,130,3,128,137,3,133,102,7,123,129,4,
  119,112,7,145,3,24,146,4,25,147,5,26,147,11,23,150,37,16,
  158,84,16,96,141,7,61,143,10,130,92,6,145,3,24,100,3,24,
  106,3,24,145,3,24,145,48,16,130,66,3,84,35,8,112,10,9,
  94,5,16,145,19,13,145,49,3,145,48,5,145,92,3,70,37,3,
  89,132,3,65,141,3,86,142,3,92,145,3,107,145,3,120,143,3,
  54,145,3,26,145,3,18,145,12,32,145,4,55,145,7,16,145,36,
  3,145,65,5,145,59,3,145,79,3,138,123,3,130,144,3,136,145,
  3,143,135,3,145,98,3,145,109,3,145,126,3,145,137,3,145,120,
  3,145,69,3,145,64,3,138,99,3,133,140,9,135,132,10,31,168,
  10,31,168,110,58,27,61,145,3,72,145,3,26,145,18,3,145,94,
  3,144,92,3,143,103,3,145,99,6,145,44,46,145,5,20,145,62,
  6,68,145,13,32,145,6,121,145,3,139,120,3,137,129,3,145,94,
  3,145,96,3,145,82,18,145,43,16,145,43,3,145,85,3,144,120,
  3,129,143,3,137,134,42,145,82,138,87,4,145,48,6,130,108,3,
  132,124,3,58,73,3,98,125,3,100,145,3,111,145,3,131,73,3,
  145,23,5,146,44,15,170,28,49,190,49,69,197,55,76,198,59,76,
  193,104,56,118,126,18,86,129,17,132,107,6,145,3,24,93,3,24,
  114,3,24,145,3,24,145,5,23,97,36,13,111,6,23,145,3,24,
  73,3,18,145,6,18,145,42,3,145,98,3,145,117,3,74,59,3,
  139,119,3,138,111,3,139,106,3,139,137,3,145,122,3,100,143,3,
  109,145,3,101,145,3,69,145,3,63,145,3,57,145,6,34,145,30,
  3,145,100,3,134,119,3,129,142,3,105,145,3,94,145,3,101,145,
  3,127,128,3,145,81,3,145,92,3,142,120,3,131,145,3,139,138,
  3,142,122,3,143,119,3,145,84,3,145,71,6,145,68,10,31,168,
  10,31,168,76,103,58,81,145,11,108,145,3,103,142,3,48,145,9,
  16,145,52,3,145,108,3,145,83,5,145,29,12,145,10,6,145,36,
  3,122,135,3,121,131,3,144,104,3,144,124,3,142,121,3,121,140,
  3,131,127,3,145,59,20,145,25,17,145,46,14,142,98,27,121,78,
  3,88,80,3,145,120,5,145,104,66,139,21,139,127,3,121,105,5,
  131,106,3,91,88,3,77,90,3,89,141,3,114,127,3,135,71,5,
  145,11,13,158,28,29,198,56,77,202,60,81,200,58,79,199,64,78,
  165,151,58,164,90,35,173,49,46,172,67,39,158,16,37,105,40,50,
  148,53,74,178,36,57,175,33,54,81,16,26,148,9,25,146,18,19,
  73,42,5,116,93,5,145,106,3,145,131,3,112,111,3,77,89,3,
  54,143,3,86,145,3,130,144,3,93,140,11,49,83,24,17,75,31,
  60,98,13,80,145,3,60,145,3,56,145,3,16,145,22,3,140,76,
  3,103,139,3,120,143,3,138,144,3,127,145,3,99,145,3,78,145,
  3,116,129,3,145,82,3,145,80,3,144,92,3,131,140,3,139,133,
  3,125,144,3,131,128,3,145,96,3,145,76,14,132,56,10,31,168,
  10,31,168,36,65,140,8,133,100,59,142,43,113,139,3,98,145,3,
  76,145,6,63,145,19,44,145,15,4,145,35,3,145,61,3,140,87,
  3,143,114,3,145,120,3,144,88,3,144,121,3,125,143,3,99,145,
  3,135,115,7,145,41,43,145,8,45,145,19,12,145,74,24,78,35,
  24,73,22,38,79,21,27,145,16,36,144,11,62,143,4,92,133,7,
  145,35,7,138,40,7,76,29,13,134,79,3,135,68,5,167,37,36,
  193,60,59,200,59,79,207,65,86,205,64,84,212,71,91,207,70,86,
  192,91,75,167,47,46,178,49,53,174,44,48,193,51,72,113,48,58,
  167,71,92,210,69,88,179,74,63,92,31,33,174,34,45,159,44,26,
  113,92,10,104,80,5,145,103,3,145,119,3,80,76,3,105,120,3,
  89,145,3,107,145,3,113,144,3,31,68,16,32,125,40,23,145,54,
  50,120,14,50,75,3,43,124,11,15,145,26,5,145,41,3,124,114,
  3,104,145,3,84,143,3,69,145,3,78,145,3,57,145,3,59,145,
  3,86,144,3,134,101,3,145,103,3,145,122,3,145,119,3,145,113,
  3,140,125,3,133,135,3,125,137,3,142,97,3,144,83,10,31,168,
  10,31,168,80,21,142,3,109,145,4,138,93,21,145,33,61,145,7,
  84,145,4,109,145,3,107,145,3,33,145,16,3,145,86,3,125,127,
  3,142,120,3,145,114,3,145,85,3,133,131,3,118,142,3,119,142,
  3,135,106,17,145,11,92,145,3,94,145,14,41,145,18,52,94,7,
  113,120,3,89,103,3,55,73,3,127,140,3,129,132,3,138,57,11,
  148,6,27,148,6,27,71,8,14,160,49,20,160,47,24,206,68,81,
  219,84,92,212,71,91,217,75,96,222,81,101,222,80,101,210,68,89,
  203,61,82,172,71,48,168,115,38,174,88,41,196,54,66,106,41,50,
  176,76,90,214,87,80,147,106,62,115,63,51,202,72,66,187,45,65,
  169,40,55,94,44,35,149,89,9,147,77,5,70,40,8,133,109,3,
  139,75,9,131,68,6,87,52,9,97,63,4,145,104,3,129,121,3,
  142,142,3,129,145,3,34,73,7,8,142,34,5,145,45,3,114,121,
  3,56,145,3,76,145,3,78,145,3,108,145,3,56,145,3,102,144,
  3,113,117,3,140,96,3,145,106,3,145,123,3,145,135,4,145,97,
  6,145,42,5,140,87,3,138,129,3,135,137,11,131,127,10,31,168,
  10,31,168,56,38,114,8,130,89,3,145,63,3,145,48,3,145,37,
  30,145,27,103,145,3,124,145,3,109,132,7,41,145,24,13,145,79,
  3,145,105,3,145,104,6,145,78,14,145,41,11,143,56,3,141,103,
  7,138,74,17,145,8,51,145,13,69,145,16,125,143,5,108,101,3,
  116,52,10,145,46,14,107,62,14,71,32,8,141,31,14,159,29,34,
  191,49,70,198,56,77,107,43,52,134,31,51,179,37,58,209,68,88,
  209,68,88,208,67,87,207,66,86,209,67,88,210,69,89,208,67,87,
  210,69,89,191,80,68,167,126,43,156,145,32,207,108,68,101,36,46,
  190,82,102,227,90,105,119,70,57,150,95,84,209,81,79,214,73,92,
  209,67,88,106,42,51,183,62,82,160,53,42,74,34,10,145,46,14,
  145,3,19,145,3,19,96,3,22,92,4,21,145,37,14,145,70,4,
  145,96,3,142,121,3,93,106,3,46,97,3,22,145,16,3,127,92,
  3,79,145,3,119,145,3,135,145,3,139,128,3,115,145,3,145,135,
  3,128,136,3,145,97,3,145,96,3,145,128,3,145,125,3,145,107,
  5,145,51,4,145,72,3,145,108,3,145,127,3,144,131,10,31,168,
  10,31,168,61,76,57,57,145,5,63,145,6,50,145,14,31,145,30,
  28,145,44,106,145,3,120,145,3,144,99,3,141,122,3,99,139,12,
  13,145,76,3,145,96,15,145,73,46,145,31,52,145,16,9,145,50,
  3,145,79,7,145,40,33,145,52,97,135,18,141,100,3,129,28,7,
  98,6,23,145,26,13,145,47,10,114,40,7,70,10,11,149,54,75,
  209,68,88,208,67,87,141,65,85,105,35,50,182,40,61,210,68,89,
  214,72,93,208,66,87,195,54,74,195,53,74,199,57,78,202,60,81,
  214,72,93,201,59,80,190,51,69,175,40,53,201,71,86,99,34,44,
  196,72,93,217,77,98,112,48,56,194,93,113,217,75,93,211,70,89,
  220,79,98,140,75,81,151,96,88,133,65,66,111,42,50,160,18,39,
  145,18,19,145,3,24,145,3,23,70,7,11,107,58,4,141,104,3,
  144,105,3,145,100,3,92,106,3,45,100,3,18,145,7,4,76,44,
  3,97,107,3,130,145,3,140,145,3,144,101,3,145,88,3,137,96,
  3,144,78,3,145,70,3,145,71,3,137,112,3,137,109,3,141,118,
  3,144,103,3,145,96,3,145,121,3,145,126,12,126,138,10,31,168,
  10,31,168,96,138,14,74,145,3,59,145,10,18,145,31,8,145,26,
  9,145,48,25,145,51,24,145,52,135,92,6,145,31,13,138,68,7,
  46,145,33,12,145,73,3,145,71,3,145,34,11,88,47,4,115,63,
  17,145,52,50,145,23,69,145,23,101,144,3,128,100,3,145,17,5,
  86,7,20,145,57,11,133,111,3,132,57,16,89,28,27,96,32,41,
  141,63,84,209,68,88,175,62,83,87,22,32,181,40,60,198,62,83,
  168,80,91,133,74,75,98,34,43,115,36,57,193,51,72,204,62,83,
  218,76,97,202,61,81,195,53,74,174,33,53,173,32,52,109,45,54,
  206,69,89,192,74,94,127,63,72,228,106,126,240,98,119,230,88,109,
  226,86,104,180,85,86,103,53,41,96,40,34,158,104,73,207,129,71,
  143,36,42,146,4,25,145,4,21,144,75,7,65,74,3,91,102,3,
  124,130,3,91,136,3,73,132,3,23,145,9,13,145,34,10,143,20,
  3,74,74,3,93,92,3,143,96,17,145,66,11,145,61,3,141,121,
  3,128,112,3,145,75,3,145,64,3,143,76,3,142,79,3,141,113,
  3,141,130,3,141,130,3,136,142,3,144,133,10,137,131,10,31,168,
  10,31,168,94,89,26,48,145,3,34,145,11,16,145,7,29,145,3,
  28,145,12,8,145,37,6,145,45,76,140,25,142,56,5,144,61,4,
  124,132,3,92,139,11,13,145,45,3,145,74,3,145,89,3,71,45,
  23,120,62,91,145,3,106,141,3,112,142,3,132,56,8,145,7,19,
  75,20,16,130,63,6,80,75,6,98,56,40,169,68,88,169,67,88,
  101,37,46,131,61,76,188,48,69,93,29,38,100,39,45,99,44,45,
  123,66,70,149,67,88,178,54,74,192,51,71,199,58,78,209,67,88,
  217,76,96,208,66,87,194,52,73,180,38,59,191,49,70,191,50,70,
  204,62,83,210,68,89,226,97,118,247,106,126,241,100,120,218,76,97,
  207,65,86,200,64,78,92,73,28,92,67,28,195,67,75,167,70,78,
  106,42,51,160,18,39,148,18,24,144,105,4,119,145,3,58,76,3,
  76,98,3,72,145,3,20,145,14,3,145,42,7,144,85,30,145,8,
  31,145,30,12,71,34,12,90,49,23,145,49,14,136,87,3,94,122,
  3,134,120,3,113,121,3,129,95,3,145,63,3,142,72,3,131,113,
  3,88,145,3,115,141,3,117,145,3,127,142,10,124,132,10,31,168,
  10,31,168,38,140,37,61,145,3,49,145,3,32,145,6,30,145,4,
  72,145,3,92,129,3,91,116,11,96,143,4,133,93,11,142,67,6,
  145,60,3,139,95,3,62,145,22,3,145,84,3,145,103,3,145,113,
  14,69,35,111,117,3,141,103,3,138,78,9,140,60,14,145,51,13,
  70,27,10,65,63,3,130,128,29,207,105,76,208,67,87,210,68,89,
  178,60,80,91,26,36,132,55,76,156,71,92,174,94,82,188,168,86,
  180,216,90,196,92,82,192,50,71,196,54,75,214,72,93,228,87,107,
  214,72,93,204,62,83,187,46,66,192,50,71,213,72,92,212,71,91,
  210,68,89,225,83,104,243,101,122,227,86,106,217,76,96,202,60,81,
  183,42,62,191,96,59,150,105,74,117,70,58,219,78,96,161,66,87,
  116,52,61,176,35,55,170,40,47,151,104,13,135,135,3,125,144,3,
  65,69,3,102,136,3,44,145,21,3,145,86,3,145,51,21,145,46,
  34,112,32,4,73,38,22,90,45,9,80,34,3,139,77,3,100,145,
  3,114,141,3,145,131,3,145,87,3,145,70,3,134,120,3,117,129,
  12,31,145,9,56,145,3,64,145,3,126,140,11,116,135,10,31,168,
  10,31,168,60,104,52,49,145,6,56,145,3,37,145,8,54,145,3,
  112,136,3,143,98,3,145,82,3,126,141,3,122,145,3,127,130,4,
  145,24,8,145,30,8,144,46,11,99,97,7,45,133,11,15,145,44,
  18,139,43,29,67,9,125,91,3,145,44,9,145,27,9,133,74,3,
  38,80,8,74,154,49,138,195,53,197,132,66,209,75,80,206,64,85,
  190,48,69,178,36,57,201,59,80,215,73,94,224,83,103,223,83,102,
  206,68,86,199,59,78,190,48,69,198,56,77,226,85,105,233,92,112,
  210,68,89,194,52,73,176,34,55,200,58,79,214,73,93,224,83,103,
  237,96,116,246,105,125,225,83,104,195,53,74,189,48,68,176,34,55,
  187,45,66,212,71,91,218,111,88,241,106,119,235,93,114,199,74,94,
  101,36,46,179,61,81,194,62,70,182,138,40,143,144,13,125,144,4,
  83,89,3,98,108,3,79,145,3,6,145,36,72,145,13,37,128,20,
  15,70,14,3,144,72,3,145,83,3,116,94,3,72,58,3,99,145,
  3,128,137,3,145,110,3,145,78,3,145,75,3,145,96,6,114,108,
  33,5,145,39,9,145,4,109,130,3,130,127,8,115,129,10,31,168,
  10,31,168,81,96,44,39,145,33,25,145,62,13,145,16,52,145,3,
  81,145,3,120,135,3,133,131,3,125,144,3,133,104,3,138,86,4,
  142,10,16,145,3,22,145,3,24,145,11,22,133,44,15,3,137,102,
  3,128,125,14,131,93,48,62,12,126,97,3,145,76,5,143,99,3,
  83,100,27,111,148,49,150,182,47,201,144,61,207,115,66,204,97,72,
  189,48,68,182,40,61,205,63,84,218,76,97,226,84,105,213,71,92,
  205,64,84,199,57,78,210,68,89,220,79,99,233,91,112,224,82,103,
  206,64,85,192,50,71,177,35,56,183,42,62,209,67,88,220,78,99,
  244,103,123,247,106,126,230,89,109,214,73,93,200,58,79,184,43,63,
  188,46,67,213,71,92,216,88,92,223,84,102,236,95,115,237,95,116,
  158,75,95,107,43,52,167,82,89,177,155,59,104,174,33,93,164,22,
  34,76,17,71,140,3,73,145,3,62,145,6,55,140,10,14,69,15,
  10,130,80,3,145,91,3,145,94,3,145,94,3,129,78,3,138,89,
  3,128,121,3,145,103,3,145,71,3,145,57,3,145,54,3,141,69,
  9,96,128,7,100,139,3,144,104,3,145,82,5,131,66,10,31,168,
  10,31,168,32,76,102,3,145,104,10,145,66,6,145,53,10,145,42,
  31,145,18,83,145,6,114,145,3,117,145,3,103,145,3,65,71,3,
  67,14,6,71,3,15,86,3,24,110,3,24,142,5,24,50,137,33,
  18,145,55,16,136,86,60,134,39,57,59,3,132,56,5,155,107,13,
  128,118,57,125,127,59,188,184,59,196,157,56,189,157,48,184,144,45,
  186,73,59,199,57,78,206,65,85,220,79,99,218,76,97,204,62,83,
  202,60,81,200,58,79,225,83,104,235,93,114,231,90,110,225,84,104,
  203,61,82,191,49,70,183,41,62,172,31,51,191,49,70,214,73,93,
  242,101,121,252,111,131,246,105,125,239,98,118,215,73,94,206,64,85,
  199,58,78,186,44,65,193,52,72,213,75,92,238,101,116,238,96,117,
  231,90,110,182,85,105,118,53,63,113,57,57,94,121,56,46,93,31,
  54,110,63,84,150,8,66,144,3,127,130,3,52,67,5,14,114,23,
  10,145,51,27,145,39,10,145,51,12,145,57,16,143,68,40,144,16,
  11,97,62,3,145,86,3,145,76,3,145,76,3,145,31,3,145,81,
  3,145,113,3,145,124,3,139,127,3,145,48,10,140,56,10,31,168,
  10,31,168,53,127,37,3,145,60,3,145,62,3,145,72,3,145,66,
  3,145,63,29,145,23,69,145,3,98,145,3,81,145,3,90,127,3,
  67,40,4,110,40,8,141,15,15,110,4,24,83,4,24,68,24,13,
  77,48,13,93,100,4,78,140,3,86,89,3,74,21,15,153,89,39,
  151,109,62,155,129,69,211,155,69,207,88,80,202,103,73,195,78,66,
  193,52,72,202,60,81,208,66,87,224,83,103,228,86,107,215,73,94,
  213,72,92,220,78,99,246,105,125,239,98,118,217,76,96,212,71,91,
  207,65,86,181,40,60,173,31,52,180,38,59,203,61,82,213,72,92,
  240,99,119,245,104,124,246,105,125,254,112,133,227,85,106,216,74,95,
  205,63,84,179,37,58,180,38,59,205,73,82,229,99,106,217,75,96,
  216,74,95,216,74,95,208,66,87,185,72,90,151,106,58,111,159,43,
  94,179,42,73,182,46,134,143,12,76,26,6,98,75,5,82,118,4,
  74,145,3,104,141,3,93,136,3,105,138,3,60,130,4,42,70,3,
  22,112,39,3,144,100,3,145,84,3,139,115,3,144,77,3,145,88,
  3,145,119,3,143,128,3,143,133,3,145,85,8,137,64,10,31,168,
  10,31,168,10,128,98,3,145,61,11,145,34,8,145,41,3,145,65,
  3,145,60,5,145,38,23,145,16,70,145,3,91,145,3,80,145,3,
  108,123,3,68,59,3,144,86,3,145,28,10,145,8,19,145,3,24,
  144,3,24,110,5,17,69,58,7,56,56,8,80,21,23,98,34,43,
  193,62,58,209,114,67,212,91,78,223,81,102,210,68,89,202,60,81,
  188,47,67,195,54,74,214,73,93,242,101,121,247,106,126,241,100,120,
  239,98,118,239,98,118,238,97,117,223,82,102,210,69,89,213,72,92,
  213,71,92,181,39,60,184,42,63,192,50,71,205,63,84,213,72,92,
  239,97,118,245,104,124,251,110,130,254,112,133,246,105,125,226,85,105,
  205,63,84,199,58,78,194,52,73,216,74,95,230,89,109,203,61,82,
  194,52,73,192,50,71,194,52,73,202,62,80,218,130,76,197,180,74,
  154,202,68,130,193,67,90,52,26,93,66,4,145,63,6,125,108,4,
  91,145,3,134,133,3,101,144,3,100,115,3,41,68,20,3,125,39,
  3,143,81,3,102,116,3,88,98,3,122,129,3,133,95,3,119,132,
  3,136,117,3,126,127,3,121,139,3,141,130,3,144,117,10,31,168,
  10,31,168,88,71,59,3,145,58,5,145,90,20,145,37,5,145,56,
  3,145,58,3,145,62,62,125,34,58,143,3,59,145,3,98,145,3,
  94,145,3,113,118,3,71,44,7,145,4,22,145,3,24,145,3,24,
  145,3,24,145,3,24,142,58,15,153,64,21,170,73,73,187,93,73,
  188,51,64,195,75,67,197,56,75,215,78,90,233,111,99,204,71,81,
  196,54,75,196,54,75,210,69,89,224,82,103,239,98,118,243,102,122,
  245,104,124,242,101,121,221,79,100,208,67,87,203,61,82,202,61,81,
  183,41,62,168,26,47,182,40,61,210,69,89,214,72,93,216,74,95,
  225,83,104,224,82,103,242,100,121,250,109,129,251,109,130,231,90,110,
  209,68,88,203,62,82,204,62,83,227,85,106,236,95,115,208,66,87,
  200,59,79,201,59,80,203,61,82,214,75,92,222,155,87,213,167,77,
  204,86,78,115,59,56,98,64,38,137,161,28,127,151,12,46,143,26,
  64,145,3,65,144,8,17,101,35,11,70,21,15,142,50,3,145,20,
  3,142,88,3,116,127,3,57,70,3,121,141,3,144,39,3,133,90,
  3,143,64,3,141,74,3,139,100,3,145,70,19,142,65,10,31,168,
  10,31,168,74,80,38,16,145,26,30,145,31,36,145,28,4,145,107,
  3,145,81,3,145,70,16,145,53,82,133,5,17,145,9,39,145,18,
  77,145,3,110,113,4,118,23,18,73,3,17,145,3,24,145,3,24,
  145,3,24,145,3,24,152,10,31,182,40,61,208,82,89,210,102,92,
  202,60,81,190,48,69,181,40,60,207,107,74,222,164,81,224,113,88,
  198,57,77,188,46,67,202,61,81,207,65,86,222,81,101,244,103,123,
  247,106,126,240,99,119,217,75,96,208,67,87,196,55,75,188,46,67,
  181,40,60,161,19,40,179,37,58,197,55,76,213,71,92,218,76,97,
  212,70,91,206,65,85,220,78,99,250,109,129,249,108,128,227,86,106,
  211,70,90,199,57,78,221,80,100,222,80,101,239,98,118,237,96,116,
  227,85,106,222,81,101,231,90,110,229,87,108,218,76,97,213,102,86,
  201,74,78,171,62,62,166,119,47,47,167,82,44,164,115,17,154,85,
  15,145,38,10,91,31,3,77,30,12,145,25,60,145,18,74,145,6,
  14,137,60,3,119,130,3,122,127,6,77,55,8,145,28,12,145,28,
  34,145,13,21,145,16,23,145,35,3,145,91,10,134,83,10,31,168,
  10,31,168,56,128,47,21,145,9,39,145,4,20,145,33,6,145,47,
  4,145,54,3,145,51,3,93,46,21,76,24,4,77,53,4,90,80,
  81,124,43,141,75,10,145,3,23,116,3,24,74,3,19,145,3,24,
  145,3,24,146,4,25,177,35,56,202,60,81,216,75,95,218,76,97,
  218,76,97,199,57,78,189,48,68,194,86,61,203,117,62,223,114,82,
  204,74,76,198,56,77,189,47,68,195,53,74,203,61,82,237,95,116,
  242,100,121,240,99,119,218,76,97,204,62,83,201,59,80,196,54,75,
  207,65,86,177,35,56,174,32,53,184,43,63,196,54,75,202,60,81,
  190,48,69,185,43,64,211,69,90,239,98,118,249,107,128,233,92,112,
  208,66,87,198,56,77,209,68,88,209,67,88,215,73,94,220,79,99,
  228,87,107,237,96,116,233,92,112,215,73,94,208,66,87,203,95,75,
  176,146,51,171,169,48,138,163,34,31,165,140,27,162,165,32,171,153,
  25,91,73,3,84,58,3,145,31,3,145,51,4,145,28,14,145,14,
  10,145,70,4,145,106,6,145,85,27,69,8,20,112,26,20,145,27,
  56,145,3,46,145,4,36,145,34,3,145,117,7,131,128,10,31,168,
  10,31,168,70,108,45,41,145,3,45,145,20,114,143,3,103,143,3,
  50,125,16,12,71,21,3,111,45,39,145,27,9,141,123,23,107,87,
  43,66,21,70,54,5,145,5,22,145,3,24,112,3,24,71,3,16,
  145,3,24,175,33,54,204,62,83,200,58,79,200,58,79,199,57,78,
  229,88,108,217,75,96,203,61,82,193,51,72,201,65,78,209,113,67,
  224,96,92,216,84,88,199,58,78,197,55,76,205,63,84,239,97,118,
  252,110,131,250,108,129,238,96,117,224,83,103,212,70,91,206,65,85,
  201,59,80,195,53,74,182,41,61,174,33,53,179,37,58,186,45,65,
  186,44,65,194,52,73,205,63,84,233,92,112,252,110,131,239,97,118,
  219,77,98,206,64,85,188,46,67,202,60,81,197,56,76,196,54,75,
  215,73,94,218,77,97,212,70,91,207,66,86,196,54,75,196,144,69,
  160,205,64,127,205,69,75,190,145,35,159,174,36,150,170,26,77,89,
  27,101,94,13,155,143,40,145,84,40,145,60,11,145,44,3,145,94,
  3,145,75,22,141,14,25,78,3,40,75,3,18,74,18,24,145,23,
  26,145,30,13,145,48,3,145,83,3,131,124,3,119,139,10,31,168,
  10,31,168,57,131,51,8,145,46,5,145,60,50,136,43,124,127,5,
  53,67,3,32,145,29,3,145,43,55,145,13,56,145,12,69,144,6,
  125,105,3,85,58,3,68,33,10,145,15,21,145,26,17,107,3,24,
  89,10,31,198,56,77,210,69,89,205,63,84,196,54,75,196,54,75,
  225,83,104,231,89,110,218,76,97,200,58,79,188,46,67,197,57,74,
  211,70,89,227,86,105,232,90,111,226,84,105,233,91,112,238,97,117,
  247,106,126,245,104,124,251,110,130,246,105,125,221,79,100,207,66,86,
  207,66,86,200,58,79,190,48,69,177,36,56,198,56,77,202,60,81,
  206,64,85,210,69,89,215,74,94,253,111,132,251,109,130,245,103,124,
  221,79,100,209,68,88,202,60,81,211,69,90,201,59,80,192,51,71,
  198,56,77,207,65,86,202,60,81,194,52,73,200,59,79,174,138,88,
  83,215,138,72,210,186,71,190,213,73,151,215,57,139,173,46,111,120,
  33,174,160,46,167,110,95,149,21,82,145,12,3,145,67,3,141,132,
  3,96,86,4,69,25,19,110,16,40,145,3,5,124,49,3,83,48,
  3,145,70,3,144,88,3,136,132,3,103,144,3,65,145,10,31,168,
  10,31,168,37,108,90,3,145,84,3,145,68,3,145,62,20,95,36,
  89,106,16,53,145,19,63,145,11,77,145,8,94,145,3,66,145,3,
  88,144,3,126,143,3,77,78,4,96,40,16,145,37,15,164,23,43,
  195,60,73,206,130,74,220,109,94,218,76,97,214,72,93,220,78,99,
  234,92,113,226,85,105,212,70,91,198,57,77,190,49,69,201,59,80,
  204,63,83,212,70,91,239,98,118,232,91,111,235,94,114,238,97,117,
  244,103,123,239,97,118,244,103,123,243,102,122,237,96,116,233,92,112,
  215,74,94,180,61,81,98,34,43,131,48,68,211,70,90,213,71,92,
  213,71,92,212,71,91,227,86,106,254,112,133,251,109,130,238,96,117,
  211,70,90,201,59,80,208,67,87,220,78,99,216,74,95,207,66,86,
  182,40,61,191,57,67,195,53,74,197,55,76,212,71,91,216,96,106,
  142,201,130,78,218,193,73,211,197,80,181,184,82,190,180,92,214,154,
  102,212,147,133,185,52,141,165,26,106,150,10,37,134,16,5,73,32,
  4,85,59,24,145,34,47,145,5,91,145,3,9,145,48,3,88,49,
  3,117,59,3,145,57,4,145,90,3,136,132,7,106,121,10,31,168,
  10,31,168,49,110,83,3,145,44,4,145,39,51,145,20,38,70,12,
  71,138,6,112,106,3,104,125,3,112,135,4,106,144,3,97,145,3,
  97,144,3,117,141,3,145,118,3,70,40,4,147,60,10,167,26,46,
  180,77,54,186,192,58,207,156,72,216,105,88,232,91,111,236,95,115,
  237,96,116,230,89,109,219,77,98,197,55,76,196,54,75,212,70,91,
  219,78,98,229,88,108,239,98,118,237,96,116,240,99,119,244,103,123,
  240,99,119,230,89,109,218,77,97,212,71,91,215,73,94,220,78,99,
  152,72,93,100,35,45,87,22,31,92,27,37,117,52,62,197,76,97,
  224,82,103,233,91,112,246,105,125,254,112,133,254,112,133,243,102,122,
  220,79,99,206,64,85,213,72,92,224,83,103,230,88,109,210,68,89,
  189,102,65,196,120,60,202,71,67,217,81,90,224,82,103,249,112,125,
  220,152,111,150,226,116,109,233,135,164,236,95,170,234,92,168,218,78,
  209,199,73,164,213,71,111,176,34,65,99,12,32,70,3,45,120,3,
  36,145,25,86,145,3,126,142,3,130,137,10,11,131,110,3,140,81,
  3,137,75,3,145,68,9,145,28,3,145,85,33,124,41,10,31,168,
  10,31,168,88,120,37,3,145,34,5,145,26,89,145,3,46,68,3,
  63,145,3,107,120,3,105,126,3,137,83,9,133,133,3,131,144,3,
  145,95,9,145,62,14,145,108,5,72,37,10,172,108,35,204,62,83,
  200,71,76,182,105,59,194,113,52,200,94,68,206,64,85,207,65,86,
  228,87,107,228,86,107,215,73,94,195,53,74,189,47,68,205,64,84,
  234,93,113,247,106,126,254,112,133,241,100,120,239,98,118,245,103,124,
  239,98,118,216,75,95,199,57,78,190,48,69,194,55,75,119,55,64,
  95,31,40,92,28,37,83,19,28,93,28,38,99,35,44,112,48,57,
  194,111,132,253,112,133,253,111,132,254,112,133,251,110,130,248,107,127,
  231,90,110,209,68,88,222,80,101,235,93,114,244,103,123,228,86,107,
  213,102,84,221,111,79,215,96,74,230,110,89,237,96,116,242,126,114,
  227,201,100,238,217,103,182,243,102,212,248,106,229,184,113,222,166,109,
  204,161,96,144,166,71,55,94,30,59,101,31,60,145,3,128,134,3,
  128,128,3,113,141,3,89,143,6,37,128,98,3,65,145,16,68,141,
  3,90,95,3,116,107,3,145,56,3,145,67,88,121,33,10,31,168,
  10,31,168,14,144,57,3,145,66,3,145,70,24,145,36,10,78,29,
  8,122,56,12,142,67,6,143,98,54,144,47,129,145,3,139,108,3,
  145,40,14,145,18,21,145,97,5,78,58,14,192,150,54,209,83,84,
  210,77,86,202,68,79,197,56,75,189,47,67,186,44,65,190,48,69,
  207,65,86,233,91,112,229,88,108,202,61,81,195,54,74,201,60,80,
  213,71,92,223,81,102,245,103,124,245,104,124,246,105,125,242,101,121,
  244,103,123,223,82,102,203,61,82,166,59,80,97,32,42,90,26,35,
  85,21,30,74,10,19,76,12,21,92,27,37,100,36,45,144,79,89,
  226,88,108,237,96,116,249,107,128,254,112,133,252,110,131,249,107,128,
  248,107,127,239,98,118,246,105,125,246,105,125,248,107,127,250,109,129,
  244,103,123,244,147,111,245,104,123,247,107,125,248,107,127,247,149,113,
  239,181,103,199,193,84,216,126,87,215,80,94,225,85,104,231,90,110,
  228,94,108,183,154,80,136,144,69,108,182,45,105,122,3,145,92,3,
  135,107,3,58,140,10,35,145,25,3,101,99,3,44,76,4,45,69,
  3,80,96,3,129,139,3,145,119,3,145,101,23,134,58,10,31,168,
  10,31,168,34,74,117,3,126,132,3,125,135,3,141,103,3,128,79,
  3,73,47,3,144,122,3,144,127,14,145,65,95,145,5,133,108,3,
  144,68,11,144,41,14,126,83,4,91,54,10,186,107,44,219,99,90,
  227,90,105,224,101,91,211,71,88,205,64,84,192,50,71,191,49,70,
  201,59,80,237,95,116,238,97,117,223,81,102,209,68,88,197,55,76,
  198,56,77,206,65,85,231,89,110,251,109,130,251,109,130,242,100,121,
  241,99,120,228,101,121,136,71,81,96,31,41,94,29,39,95,31,40,
  87,23,32,77,12,22,77,13,22,98,33,43,179,74,95,216,74,95,
  227,86,106,235,94,114,204,108,129,207,112,133,252,112,133,253,111,132,
  253,111,132,253,111,132,252,110,131,252,111,131,249,108,128,253,111,132,
  254,112,133,253,114,130,254,113,132,249,114,119,247,106,126,235,102,108,
  218,99,83,211,85,82,194,55,72,197,56,76,199,57,78,206,66,84,
  206,79,80,205,76,77,207,132,67,145,164,53,48,152,31,119,109,3,
  92,121,6,32,81,8,10,69,23,3,77,53,3,125,91,3,122,128,
  3,123,129,3,133,133,3,145,110,3,145,103,16,134,75,10,31,168,
  10,31,168,31,112,76,3,138,118,3,131,129,3,132,102,3,145,117,
  6,98,62,8,74,46,3,138,92,9,145,47,24,145,13,65,136,6,
  123,142,3,143,112,6,74,36,6,147,24,16,180,51,53,211,70,90,
  215,74,94,228,121,91,235,106,105,224,87,102,210,69,89,210,69,89,
  217,75,96,237,96,116,245,104,124,237,96,116,220,78,99,203,61,82,
  186,45,65,193,51,72,217,76,96,248,107,127,244,103,123,247,106,126,
  201,104,124,126,61,71,101,36,46,93,29,38,91,26,36,94,30,39,
  94,30,39,87,22,31,109,35,54,191,49,70,209,67,88,211,69,90,
  231,90,110,162,97,107,116,51,61,119,55,64,173,109,118,243,112,133,
  252,111,131,248,107,127,252,110,131,252,110,131,251,109,130,248,107,127,
  252,110,131,249,107,128,253,112,131,246,107,123,239,97,118,216,75,95,
  203,63,81,201,66,74,184,42,63,192,51,71,184,42,63,182,63,57,
  185,159,47,184,122,66,110,177,92,76,170,76,22,163,66,42,88,3,
  20,73,13,42,110,14,22,145,33,38,145,24,45,145,10,17,141,50,
  9,145,51,11,145,45,9,145,47,10,145,53,38,134,26,10,31,168,
  10,31,168,87,91,30,62,86,25,35,103,76,29,145,23,81,136,11,
  42,143,60,49,111,22,8,69,26,23,86,7,21,113,27,47,123,13,
  89,92,3,70,52,3,126,21,25,163,21,42,170,28,49,193,51,72,
  200,58,79,203,87,67,237,143,95,249,137,112,239,98,117,244,103,123,
  238,97,117,242,101,121,245,104,124,232,91,111,223,81,102,209,68,88,
  199,57,78,202,61,81,222,81,101,250,109,129,241,108,128,168,102,113,
  118,53,63,107,43,52,98,34,43,97,32,42,92,28,37,99,35,44,
  100,36,45,149,51,72,177,35,56,197,55,76,207,66,86,202,74,95,
  133,68,78,112,47,57,112,47,57,116,51,61,116,51,61,144,79,89,
  223,109,129,249,107,128,252,111,131,250,109,129,250,109,129,243,102,122,
  235,94,114,237,95,116,244,103,123,241,100,120,225,83,104,209,67,88,
  211,70,90,214,72,93,209,68,88,216,74,95,210,92,90,180,183,65,
  121,194,53,57,184,83,47,187,168,39,180,159,36,132,105,20,77,23,
  11,145,34,34,145,22,20,145,55,88,145,24,95,145,3,75,145,3,
  61,145,3,63,145,3,60,145,3,62,145,3,52,143,13,10,31,168,
  10,31,168,51,81,81,35,121,76,20,91,60,56,134,29,64,145,23,
  60,145,24,100,145,3,51,145,44,30,114,30,50,89,3,64,81,3,
  101,89,3,145,81,3,150,12,26,190,49,69,197,56,76,185,44,64,
  175,34,54,185,63,55,206,90,73,218,90,91,236,95,115,237,96,116,
  240,98,119,224,82,103,214,73,93,216,74,95,216,74,95,208,66,87,
  197,55,76,203,61,82,219,77,98,220,107,128,139,75,84,112,47,57,
  111,46,56,101,36,45,91,26,36,90,25,35,89,25,34,111,47,56,
  187,64,84,186,44,65,178,36,57,198,57,77,167,69,90,113,49,58,
  108,44,53,107,43,52,111,47,56,107,43,52,113,49,58,113,49,58,
  154,90,99,248,110,131,252,111,131,254,112,133,247,106,126,231,90,110,
  210,68,89,227,85,106,240,99,119,241,100,120,232,91,111,214,72,93,
  219,77,98,228,86,107,234,92,113,222,81,101,204,93,82,188,189,67,
  157,194,66,72,196,86,52,184,103,50,184,106,44,102,55,30,121,33,
  14,145,34,26,145,31,68,145,12,111,144,3,115,145,3,82,145,3,
  62,145,3,49,145,7,40,145,17,39,145,9,41,145,4,10,31,168,
  10,31,168,39,119,103,3,127,142,3,96,100,21,73,31,32,71,16,
  70,89,8,75,134,37,26,145,75,102,144,8,125,143,3,140,120,3,
  145,54,3,145,83,3,161,33,37,203,61,82,207,66,86,201,60,80,
  194,52,73,182,41,61,202,60,81,207,65,86,234,92,113,237,96,116,
  231,90,110,210,68,89,203,61,82,205,64,84,204,63,83,193,51,72,
  192,50,71,206,64,85,177,85,106,118,54,63,110,46,55,114,50,59,
  115,50,60,103,39,48,93,29,38,97,32,42,135,64,80,201,59,80,
  191,50,70,173,32,52,174,33,53,121,47,66,96,31,41,98,34,43,
  99,35,44,97,32,42,98,34,43,94,30,39,106,41,50,178,104,123,
  237,111,132,165,101,110,165,100,110,241,112,133,247,106,126,221,79,100,
  203,61,82,219,77,98,234,93,113,240,99,119,238,97,117,225,83,104,
  231,91,108,226,95,99,245,109,118,235,94,106,221,129,83,211,134,74,
  217,159,76,193,132,71,174,115,54,163,97,45,94,63,38,146,104,46,
  132,126,9,133,117,4,112,133,3,109,143,3,89,145,3,64,145,4,
  21,145,38,6,145,67,3,134,101,3,144,58,25,141,30,10,31,168,
  10,31,168,43,137,59,3,108,112,3,123,145,3,131,114,3,137,115,
  44,103,79,40,76,38,10,68,40,89,81,8,135,124,3,145,84,10,
  145,100,3,145,122,3,183,123,46,211,104,83,221,85,98,203,67,79,
  200,58,77,187,46,66,202,60,81,211,69,90,232,90,111,236,94,115,
  219,78,98,201,60,80,191,50,70,197,55,76,201,59,80,205,64,84,
  207,65,86,139,74,84,109,45,54,114,49,59,113,49,58,113,49,58,
  115,50,60,111,46,56,114,50,59,179,87,108,213,71,92,199,57,78,
  197,55,76,175,45,66,95,30,39,78,14,23,84,20,29,91,26,36,
  94,30,39,95,30,40,95,30,40,114,50,59,195,67,88,209,95,115,
  133,69,78,113,49,58,116,51,61,134,70,79,214,105,125,222,80,101,
  203,61,82,215,74,94,216,74,95,233,92,112,240,99,119,227,85,106,
  225,86,102,220,90,86,243,119,111,250,109,127,235,131,102,217,100,89,
  222,150,81,206,74,82,200,58,79,185,44,64,136,46,59,115,71,44,
  152,94,10,93,131,3,69,141,4,81,145,17,66,145,20,28,145,36,
  3,145,106,3,112,112,3,54,75,3,64,69,14,124,115,10,31,168,
  10,31,168,64,93,60,3,101,104,3,105,145,3,101,145,3,102,145,
  3,121,144,3,141,141,3,143,115,84,103,8,45,76,3,43,68,3,
  85,112,3,116,133,4,187,146,45,212,168,71,220,119,90,210,123,69,
  200,82,66,191,49,70,199,57,78,213,71,92,241,100,120,238,97,117,
  212,70,91,198,56,77,198,56,77,208,66,87,210,69,89,191,76,97,
  124,59,68,110,46,55,114,50,59,116,51,61,115,51,60,112,48,57,
  114,50,59,142,78,87,219,106,126,242,101,121,212,70,91,204,63,83,
  149,61,82,95,31,40,87,22,32,84,20,29,83,19,28,84,20,29,
  84,20,29,89,25,34,144,60,81,210,69,89,166,69,90,118,53,62,
  116,51,61,115,51,60,116,51,61,115,51,60,119,55,64,177,95,115,
  199,58,78,210,69,89,211,69,90,216,74,95,219,77,98,220,78,99,
  222,80,100,223,83,98,241,125,108,244,105,122,244,122,119,239,178,98,
  232,173,91,213,94,87,205,63,84,193,52,72,202,64,84,98,48,34,
  143,115,24,69,141,3,21,145,38,3,145,91,3,127,122,42,90,47,
  3,69,47,3,84,70,3,113,123,3,123,144,3,127,129,10,31,168,
  10,31,168,12,81,88,3,127,123,3,137,141,3,129,110,3,139,89,
  27,142,74,64,145,67,70,145,62,131,123,5,145,118,3,117,90,5,
  145,90,4,159,108,17,197,88,63,208,112,76,223,127,91,206,106,74,
  200,86,71,185,44,64,201,59,80,209,67,88,236,95,115,239,98,118,
  226,84,105,210,68,89,210,68,89,228,87,107,169,102,114,116,51,60,
  114,50,59,113,49,58,114,50,59,116,51,61,115,51,60,116,52,61,
  175,110,120,241,109,129,238,97,117,234,93,113,205,77,97,125,60,70,
  96,32,41,95,31,40,89,25,34,89,25,34,99,35,44,97,33,42,
  104,40,49,178,61,82,209,67,88,216,74,95,191,89,110,126,62,71,
  116,51,61,116,51,61,116,51,61,115,50,60,115,50,60,109,45,54,
  135,71,80,201,59,80,201,59,80,210,68,89,216,75,95,211,70,90,
  222,80,101,234,92,113,249,108,128,247,106,126,235,141,122,215,202,92,
  214,123,82,212,100,81,203,70,81,204,62,83,207,77,80,170,118,70,
  82,77,22,50,85,3,23,90,54,20,75,37,3,73,31,14,107,44,
  16,145,45,17,145,46,4,145,106,3,136,114,3,98,85,10,31,168,
  10,31,168,50,50,28,15,145,65,22,145,37,49,145,10,34,145,5,
  114,138,4,144,113,3,145,104,3,145,69,10,145,116,3,145,40,7,
  145,8,13,145,10,15,193,51,70,204,62,83,217,75,96,208,66,87,
  197,55,76,190,49,69,204,62,83,211,69,90,237,96,116,245,104,124,
  248,107,127,240,99,119,223,101,121,139,75,84,115,50,60,111,47,56,
  114,50,59,114,50,59,114,50,59,116,51,61,126,62,71,208,110,131,
  251,111,132,250,109,129,250,110,131,189,107,127,115,51,60,107,43,52,
  103,39,48,100,35,45,97,33,42,91,26,36,95,31,40,132,68,77,
  214,78,98,193,75,96,228,86,107,244,103,123,248,107,127,232,112,133,
  145,80,90,116,51,61,116,51,61,115,51,60,116,51,61,114,49,59,
  104,39,49,111,47,56,183,66,87,215,74,94,215,73,94,224,83,103,
  246,105,125,249,108,128,244,103,123,235,93,114,233,102,110,214,92,90,
  204,62,83,209,79,82,222,82,100,215,87,90,196,138,69,214,140,73,
  144,177,45,102,119,8,96,111,7,95,141,7,108,145,8,94,145,8,
  72,145,3,63,145,3,15,145,56,5,145,80,10,80,51,10,31,168,
  10,31,168,45,25,34,31,69,3,46,85,3,106,109,3,118,140,3,
  139,126,3,144,108,3,144,108,3,134,119,3,139,114,3,145,88,4,
  145,3,14,147,5,23,199,57,78,212,70,91,212,71,91,215,73,94,
  204,62,83,194,53,73,204,63,83,207,65,86,217,75,96,222,80,101,
  233,92,112,184,93,113,114,50,59,112,47,57,106,41,51,102,38,47,
  106,41,51,109,44,54,117,53,62,157,92,101,235,107,127,249,107,128,
  253,111,132,233,110,131,154,90,99,115,50,60,112,47,57,109,45,54,
  106,41,51,97,33,42,95,31,40,95,30,39,163,62,83,213,72,92,
  152,88,97,106,42,51,130,66,75,211,107,127,244,103,123,250,108,129,
  248,110,130,180,112,125,122,57,67,116,51,61,116,51,61,116,51,61,
  111,46,56,112,47,57,110,45,55,161,95,106,231,90,110,248,107,127,
  254,112,133,253,111,132,250,108,129,238,97,117,239,98,118,226,84,105,
  205,63,84,202,64,78,224,97,89,214,129,79,180,201,66,156,195,67,
  89,186,46,27,150,53,26,145,80,77,145,36,122,145,3,135,129,4,
  135,94,4,116,110,3,101,101,7,92,116,15,57,47,11,10,31,168,
  10,31,163,24,48,67,88,134,22,106,96,3,72,90,5,52,79,3,
  48,67,3,45,70,3,75,86,3,66,108,3,83,133,3,128,119,3,
  145,34,15,154,12,33,187,45,66,199,57,78,199,57,78,215,73,94,
  209,68,88,194,52,73,186,45,65,197,55,76,198,56,77,204,62,83,
  136,62,81,103,38,48,105,41,50,102,38,47,100,36,45,95,31,40,
  97,33,42,111,47,56,188,106,127,248,109,130,251,110,130,246,105,125,
  205,108,129,130,65,74,115,51,60,112,48,57,111,47,56,108,44,53,
  107,43,52,99,35,44,122,57,67,188,49,69,181,42,63,116,51,60,
  102,37,46,107,43,52,107,42,51,111,46,55,176,100,120,244,109,130,
  254,112,133,252,111,132,214,112,133,137,72,82,115,50,60,112,48,57,
  115,51,60,114,50,59,114,50,59,116,51,61,139,75,84,218,109,130,
  252,110,131,250,108,129,252,111,131,247,106,126,244,103,123,243,103,122,
  221,88,98,206,75,84,218,86,91,217,91,90,213,161,72,190,165,69,
  167,156,47,79,141,30,34,142,72,98,145,3,134,142,3,143,69,7,
  145,31,10,144,34,9,145,6,23,138,8,23,66,13,18,10,31,168,
  10,31,135,44,65,80,84,133,18,122,94,3,109,101,14,66,145,5,
  66,145,3,99,145,3,111,120,3,77,97,3,63,80,3,129,125,3,
  145,52,14,163,21,42,201,59,80,206,64,85,201,60,80,211,69,90,
  202,60,81,191,50,70,192,50,71,197,55,76,186,61,82,112,48,57,
  91,26,36,95,30,40,97,32,42,96,31,41,96,32,41,91,26,35,
  125,61,70,211,91,111,248,106,127,251,110,130,242,109,130,174,109,118,
  119,54,64,114,50,59,110,46,55,110,46,55,109,44,54,107,43,52,
  106,42,51,150,72,93,214,72,93,194,52,73,111,47,56,100,35,45,
  108,44,53,114,49,59,103,38,48,101,36,46,107,43,52,148,84,93,
  230,112,133,253,112,132,253,111,132,237,112,132,160,96,105,116,51,61,
  114,50,59,114,50,59,115,50,60,115,50,60,114,49,59,118,53,62,
  186,106,127,249,112,133,247,105,126,248,161,117,249,118,126,241,114,118,
  238,218,97,225,186,95,224,103,100,219,101,92,212,109,79,208,66,87,
  184,59,57,151,47,22,144,58,13,119,133,3,117,78,3,98,74,3,
  86,63,3,74,53,3,66,40,5,71,48,5,65,36,9,10,31,157,
  10,31,106,92,54,59,139,123,3,140,129,3,145,86,3,113,111,3,
  90,134,3,144,131,3,143,134,3,140,136,3,145,118,3,145,108,3,
  180,120,39,210,114,75,211,77,87,215,88,86,212,76,85,210,69,88,
  208,67,87,194,52,73,208,66,87,157,70,91,100,35,45,95,31,40,
  93,29,38,89,24,34,90,26,35,89,25,34,91,26,36,148,60,81,
  234,95,115,246,105,125,247,106,126,223,112,133,144,79,89,115,51,60,
  109,45,54,100,35,45,97,33,42,98,34,43,98,34,43,111,47,56,
  185,74,95,200,58,79,188,47,67,203,62,82,206,73,94,135,71,80,
  113,49,58,113,49,58,109,45,54,103,38,48,110,46,55,112,48,57,
  129,64,74,199,107,127,252,112,133,254,112,133,249,112,133,196,112,133,
  123,58,68,116,51,61,116,51,61,115,50,60,113,48,58,110,46,55,
  113,48,58,149,84,93,235,108,129,253,117,131,242,102,121,248,107,127,
  248,114,126,238,100,117,237,96,115,221,93,96,210,101,76,215,74,94,
  167,45,60,77,16,19,68,7,12,63,53,9,86,16,21,105,30,12,
  125,42,3,145,47,3,114,141,7,69,143,12,74,92,23,10,31,134,
  10,31,105,138,61,15,137,135,3,140,137,3,145,58,9,145,26,15,
  139,61,9,145,70,6,145,39,14,123,85,8,100,42,9,146,43,9,
  192,86,55,217,110,79,217,153,82,237,192,101,207,160,91,200,102,73,
  195,54,73,196,55,75,127,62,72,101,36,46,107,43,52,106,41,51,
  100,36,45,96,31,41,94,30,39,106,41,51,186,65,86,230,88,109,
  249,107,128,250,110,131,189,110,130,123,59,68,116,51,61,112,48,57,
  103,39,48,96,31,41,91,26,36,92,27,37,127,62,72,208,66,87,
  208,66,87,191,50,70,179,38,58,204,62,83,217,76,96,237,96,116,
  172,107,117,118,53,63,111,47,56,110,45,55,113,49,58,114,50,59,
  114,49,59,114,50,59,164,100,109,241,111,131,252,110,131,251,110,130,
  225,109,129,144,80,89,117,52,62,115,51,60,109,44,54,103,39,48,
  102,37,47,104,39,49,124,60,69,211,108,128,244,103,123,228,86,107,
  225,84,104,215,74,94,214,72,93,209,70,87,203,67,80,194,65,56,
  172,100,40,147,142,29,116,131,16,43,145,6,103,120,7,136,67,6,
  145,36,3,144,53,3,133,59,5,51,126,17,69,119,23,10,31,111,
  10,31,168,129,97,9,103,145,3,123,144,3,134,131,4,138,109,3,
  127,76,7,80,59,7,66,16,9,80,38,4,120,9,20,149,7,28,
  198,57,77,212,76,89,213,139,82,226,220,97,195,219,102,197,120,66,
  200,81,70,114,50,59,104,40,49,107,43,52,113,49,58,112,47,57,
  109,45,54,109,45,54,142,78,87,227,90,111,235,94,114,247,105,126,
  231,104,124,154,90,99,116,51,61,115,50,60,115,51,60,110,46,55,
  98,34,43,89,24,34,91,27,36,156,49,70,199,57,78,197,56,76,
  204,62,83,192,50,71,190,49,69,196,54,75,211,69,90,221,80,100,
  226,85,105,197,89,109,126,62,71,117,52,62,114,50,59,116,51,61,
  116,51,61,116,51,61,115,50,60,136,71,81,218,110,131,252,111,131,
  250,109,129,246,112,132,177,112,122,118,54,63,102,38,47,96,32,41,
  97,32,42,101,37,46,104,39,49,119,54,64,200,98,118,216,75,95,
  219,78,98,205,63,84,201,59,80,201,59,80,207,68,84,214,99,72,
  182,175,69,98,175,34,64,154,13,21,145,11,68,145,4,104,138,3,
  137,97,3,141,109,3,145,50,3,145,76,3,131,113,4,10,28,90,
  10,31,168,123,79,11,116,141,3,95,145,3,43,102,8,30,72,4,
  25,67,2,42,82,3,104,114,3,145,31,7,145,6,22,148,6,27,
  173,31,52,187,45,66,208,66,87,218,76,97,232,90,111,229,87,108,
  130,66,75,110,46,55,109,45,54,109,45,54,112,47,57,110,46,55,
  119,55,64,182,102,122,244,104,124,249,108,128,250,109,129,205,107,127,
  130,65,74,113,49,58,116,51,61,116,51,61,116,51,61,107,42,52,
  95,31,40,115,50,60,196,64,85,212,70,91,207,65,86,208,66,87,
  209,67,88,199,57,78,195,54,74,198,56,77,199,57,78,210,68,89,
  213,71,92,215,73,94,221,87,107,156,91,100,118,53,63,116,51,61,
  116,51,61,116,51,61,116,51,61,116,51,61,122,58,67,187,112,132,
  246,112,132,254,112,133,253,112,132,201,98,119,116,52,61,91,26,36,
  87,22,31,98,34,43,103,46,45,104,55,44,104,77,49,201,136,77,
  199,57,69,197,55,76,210,68,89,213,71,92,221,98,88,218,116,76,
  216,133,92,129,188,57,111,140,26,101,141,5,118,144,3,107,145,3,
  87,145,3,118,128,3,145,110,3,145,70,3,145,85,6,10,31,142,
  10,31,167,105,20,33,79,31,3,68,41,3,60,99,3,17,142,17,
  68,112,7,81,98,3,119,108,3,145,17,11,145,3,24,163,21,42,
  203,61,82,200,58,79,194,52,73,209,67,88,214,73,93,165,82,102,
  102,38,47,101,37,46,102,37,46,102,38,47,106,42,51,130,66,75,
  212,97,117,242,100,121,243,101,122,243,108,129,172,106,117,119,55,64,
  116,51,61,115,51,60,116,51,61,113,49,58,114,50,59,109,45,54,
  154,75,95,201,59,80,202,60,81,206,64,85,203,61,82,203,61,82,
  201,59,80,198,57,77,184,42,63,186,44,65,179,38,58,203,62,82,
  211,70,90,209,68,88,217,75,96,244,106,126,189,112,132,123,58,68,
  115,51,60,114,50,59,116,51,61,116,51,61,114,50,59,117,53,62,
  155,90,100,231,110,131,252,110,131,227,85,106,210,69,89,129,49,69,
  85,21,30,88,23,33,93,29,37,89,80,33,70,78,33,110,107,43,
  177,139,42,203,92,66,217,93,88,217,92,88,239,118,107,240,215,99,
  217,96,91,122,87,59,94,50,33,81,31,12,84,67,4,85,83,3,
  85,90,3,90,95,3,101,92,3,107,92,3,106,104,8,10,31,133,
  9,19,81,56,31,20,135,40,3,145,27,10,122,81,12,112,109,8,
  121,45,16,101,30,9,145,19,15,145,5,20,145,56,9,168,47,41,
  217,75,96,219,77,98,210,68,89,194,52,73,193,52,72,104,39,49,
  96,32,41,97,32,42,89,25,34,93,29,38,137,73,82,216,75,95,
  221,80,100,224,82,103,218,86,107,138,74,83,114,50,59,113,49,58,
  114,50,59,116,51,61,115,51,60,114,50,59,126,61,70,198,97,118,
  216,74,95,200,59,79,195,53,74,195,53,74,199,57,78,199,57,78,
  200,59,79,180,38,59,169,27,48,178,37,57,175,33,54,187,45,66,
  204,63,83,202,60,81,208,66,87,231,90,110,248,107,127,223,112,133,
  135,70,80,113,49,58,115,51,60,115,51,60,114,50,59,116,51,61,
  115,51,60,129,65,74,205,109,130,226,84,105,213,71,92,197,56,76,
  168,79,100,104,40,49,102,38,47,92,32,35,87,29,26,79,32,18,
  173,44,55,205,103,67,216,157,75,227,174,86,243,202,104,219,225,87,
  218,191,80,112,101,47,119,126,45,136,72,6,132,64,3,115,106,3,
  66,65,3,91,98,3,102,89,3,95,83,3,75,61,19,10,21,84,
  10,31,119,61,52,20,76,53,3,121,97,3,132,89,6,137,90,8,
  126,33,18,102,9,23,145,8,22,145,21,17,145,30,16,164,55,35,
  222,131,93,221,143,91,225,137,96,223,82,102,168,74,93,91,42,33,
  89,25,34,89,24,34,83,19,28,112,47,57,192,51,71,200,58,79,
  201,59,80,172,64,85,105,41,50,106,42,51,114,50,59,113,49,58,
  115,50,60,114,50,59,115,50,60,152,88,97,234,109,130,234,93,113,
  217,75,96,199,58,78,198,56,77,193,52,72,190,48,69,191,49,70,
  203,61,82,196,54,75,182,40,61,166,24,45,164,23,43,175,33,54,
  199,57,78,203,62,82,204,63,83,216,74,95,230,88,109,248,106,127,
  245,112,133,169,104,114,119,54,64,116,51,61,114,50,59,112,48,57,
  115,51,60,116,51,61,115,51,60,162,91,107,216,74,95,204,63,83,
  208,67,87,158,87,103,107,43,52,101,37,46,98,33,43,90,26,35,
  130,66,75,232,101,109,238,192,99,235,211,95,219,226,91,198,216,74,
  202,212,71,85,100,37,106,172,34,95,144,6,143,74,4,139,98,3,
  66,61,14,128,120,11,128,120,3,145,36,15,140,27,15,10,27,89,
  10,31,168,144,26,34,141,35,12,95,36,8,64,68,3,69,93,3,
  60,86,41,91,72,9,144,76,7,144,66,8,145,56,10,150,24,25,
  196,87,71,196,117,71,210,107,84,232,90,111,142,78,87,104,39,49,
  100,36,45,100,35,45,105,41,50,201,86,107,216,74,95,213,71,92,
  144,59,80,84,19,28,86,22,31,98,33,43,107,43,52,113,49,58,
  116,51,61,123,59,68,184,105,125,247,109,129,248,107,127,241,100,120,
  223,82,102,196,54,75,182,40,61,182,40,61,194,53,73,202,60,81,
  213,71,92,210,69,89,198,56,77,172,31,51,175,33,54,180,38,59,
  188,47,67,192,51,71,197,56,76,209,68,88,209,67,88,232,90,111,
  254,112,133,251,110,131,201,110,130,130,66,75,115,51,60,114,50,59,
  115,51,60,114,50,59,116,51,61,108,44,53,133,69,78,219,77,98,
  202,60,81,208,66,87,117,53,62,109,45,54,107,43,52,100,35,45,
  118,54,63,223,82,102,209,157,70,198,181,67,131,215,74,111,212,71,
  162,198,56,48,89,25,87,163,22,43,145,13,129,109,4,132,84,3,
  25,75,43,36,145,55,107,135,3,120,92,10,133,36,9,10,31,96,
  10,31,168,130,22,34,145,52,11,144,96,8,120,145,3,52,123,49,
  12,84,62,19,71,19,51,99,3,95,137,3,134,133,3,149,74,16,
  202,71,71,198,57,77,191,50,70,202,60,81,115,50,60,111,46,56,
  108,44,53,110,46,55,134,70,79,238,100,120,235,94,114,192,95,115,
  109,44,53,93,29,38,89,25,34,94,30,39,104,39,49,113,48,58,
  138,74,83,216,104,124,244,103,123,250,109,129,250,109,129,240,99,119,
  229,88,108,200,59,79,195,53,74,201,59,80,212,70,91,210,68,89,
  212,71,91,211,70,90,207,65,86,183,41,62,205,63,84,203,62,82,
  206,64,85,205,64,84,204,62,83,203,61,82,200,58,79,229,87,108,
  254,112,133,253,111,132,252,111,131,230,111,132,154,89,99,115,51,60,
  115,50,60,114,50,59,115,50,60,113,49,58,104,40,49,151,74,95,
  199,57,78,202,61,81,157,93,102,115,50,60,114,50,59,110,46,55,
  113,48,57,200,74,93,201,59,66,193,136,54,153,180,48,177,160,39,
  182,159,42,100,88,36,191,170,50,153,159,19,142,142,3,98,142,3,
  47,72,3,80,145,3,23,145,32,55,145,15,74,130,11,10,31,103,
  10,31,168,75,120,17,94,140,3,109,143,3,119,145,3,77,145,15,
  94,143,15,53,142,10,69,108,6,64,52,3,87,76,8,164,72,36,
  205,64,83,204,68,78,200,61,77,197,64,71,105,43,49,109,45,54,
  109,45,54,111,47,56,150,86,95,220,78,99,214,72,93,140,75,84,
  108,44,53,105,40,50,104,40,49,101,37,46,109,45,54,126,61,70,
  181,103,123,193,107,127,194,109,129,193,105,125,192,104,124,190,100,120,
  192,103,123,184,86,106,184,86,107,184,86,107,184,86,107,182,80,101,
  178,73,93,180,77,98,178,71,92,168,50,70,180,77,97,175,66,86,
  184,86,107,183,85,105,182,81,101,179,76,96,182,81,101,190,100,120,
  194,109,129,196,112,133,196,112,133,196,111,132,189,110,130,132,68,77,
  112,47,57,114,50,59,113,49,58,109,45,54,98,34,43,111,46,56,
  215,74,94,232,91,111,188,105,125,112,48,57,115,51,60,111,46,56,
  107,42,52,186,75,92,209,67,76,188,70,52,167,130,26,168,92,34,
  205,158,65,105,90,41,202,189,66,74,163,22,101,144,3,44,145,10,
  20,71,18,33,145,30,10,145,44,14,145,33,21,120,72,10,31,111,
  10,31,168,30,141,54,34,145,18,32,145,36,31,145,52,66,145,23,
  45,144,45,82,141,3,118,138,3,145,54,4,135,11,21,152,10,31,
  211,105,84,217,120,84,223,115,93,189,188,84,104,71,54,112,47,57,
  111,46,56,105,41,50,144,67,87,199,58,78,187,45,66,119,50,64,
  99,35,44,111,47,56,112,48,57,109,45,54,112,48,57,116,51,61,
  116,52,61,116,51,61,113,49,58,114,50,59,114,49,59,114,50,59,
  114,50,59,114,49,59,104,40,49,100,36,45,96,32,41,96,31,41,
  95,31,40,97,32,41,92,28,37,91,26,36,97,33,42,101,36,46,
  109,45,54,111,47,56,111,46,56,112,47,57,115,50,60,113,49,58,
  113,49,58,116,52,61,115,51,60,116,51,61,114,50,59,113,49,58,
  114,50,59,114,50,59,114,50,59,108,44,53,111,46,56,114,49,58,
  232,101,121,246,104,125,195,115,126,111,53,54,107,50,50,99,42,42,
  96,34,39,174,113,61,183,72,47,181,88,54,183,148,42,169,115,39,
  181,189,82,82,100,45,136,205,87,28,158,63,9,144,90,8,142,109,
  3,72,51,3,145,98,5,145,73,8,145,80,9,113,92,10,31,118,
  10,31,168,10,134,96,3,145,79,42,144,36,3,135,92,3,145,94,
  15,145,80,114,135,3,123,107,3,88,27,11,72,3,17,171,29,50,
  211,70,90,212,73,91,220,159,81,208,176,74,108,65,51,100,43,42,
  101,47,41,98,34,43,126,55,71,188,46,67,198,56,77,146,57,78,
  89,25,34,103,39,48,111,47,56,112,48,57,111,46,56,114,49,59,
  113,49,58,114,50,59,111,47,56,110,46,55,111,46,56,113,49,58,
  114,50,59,106,41,50,94,30,39,96,31,40,91,26,35,87,23,32,
  90,26,35,91,27,36,86,22,31,87,23,32,95,30,40,96,32,41,
  98,33,43,97,32,42,102,38,47,107,43,52,111,46,56,113,49,58,
  116,51,61,114,50,59,111,47,56,114,50,59,114,50,59,114,50,59,
  114,50,59,113,49,58,112,48,57,110,45,55,112,48,57,135,70,80,
  242,102,123,239,98,118,172,123,102,101,71,36,97,58,36,91,71,26,
  83,49,19,166,166,46,141,198,66,137,213,75,145,210,72,159,188,46,
  72,197,151,57,120,114,70,193,203,33,135,175,4,128,143,3,113,144,
  3,125,128,3,142,132,6,145,68,26,145,6,29,105,14,10,31,126,
  10,31,168,12,68,142,3,145,101,12,145,53,30,136,50,60,102,46,
  28,77,13,55,65,3,89,69,3,71,20,10,74,3,19,150,8,29,
  207,65,86,214,92,89,198,112,60,191,82,59,106,56,47,89,25,33,
  88,29,29,86,25,26,103,39,48,203,62,82,208,67,87,204,62,83,
  102,38,47,96,31,41,105,41,50,114,50,59,114,50,59,109,45,54,
  110,46,55,113,49,58,114,50,59,112,48,57,112,48,57,114,50,59,
  114,50,59,104,40,49,94,29,39,94,30,39,90,25,35,86,21,30,
  86,22,31,85,20,30,80,15,25,79,15,24,88,23,33,93,29,38,
  94,29,39,91,26,35,94,30,39,96,31,40,97,33,42,106,42,51,
  112,47,57,114,50,59,114,50,59,115,50,60,116,51,61,115,50,60,
  112,48,57,111,47,56,110,46,55,103,38,48,103,39,48,182,74,94,
  222,81,101,217,75,96,127,63,70,95,43,36,90,32,32,86,62,23,
  96,73,31,206,192,68,215,181,73,222,165,86,212,175,70,200,196,58,
  76,201,147,136,191,164,104,155,143,45,138,144,5,109,145,3,111,145,
  3,140,139,3,143,91,41,145,24,69,145,3,39,145,7,10,31,168,
  10,31,168,32,98,87,19,86,35,25,70,9,59,77,3,85,106,3,
  113,136,3,143,114,3,137,117,3,72,29,4,145,29,14,147,30,18,
  169,58,41,177,66,49,191,104,55,194,109,57,136,101,58,88,23,30,
  85,24,27,88,32,28,94,30,39,167,74,95,231,89,110,212,70,91,
  188,53,73,120,56,65,103,38,48,112,47,57,112,48,57,110,45,55,
  112,48,57,114,50,59,113,49,58,114,50,59,116,51,61,108,44,53,
  102,38,47,96,32,41,92,28,37,91,27,36,89,25,34,87,23,32,
  88,23,33,92,27,37,88,24,33,82,18,27,89,25,34,88,24,33,
  91,27,36,92,28,37,93,29,38,90,25,35,91,26,36,92,28,37,
  96,32,41,109,45,54,113,49,58,115,50,60,115,51,60,114,50,59,
  114,50,59,110,46,55,104,40,49,108,44,53,169,55,76,196,54,75,
  199,57,78,190,57,78,90,25,34,86,22,31,91,27,36,97,36,41,
  115,54,60,221,176,80,230,122,88,240,192,100,197,207,72,191,200,60,
  100,154,118,92,104,45,107,121,61,76,126,79,7,146,94,3,128,135,
  3,133,145,3,141,122,19,145,46,29,145,5,12,138,25,10,31,168,
  10,31,168,60,64,31,59,126,5,69,145,3,120,142,3,87,144,3,
  87,144,5,46,139,27,25,71,16,66,127,15,39,129,33,41,130,32,
  65,149,38,89,168,52,174,174,62,203,163,68,188,121,87,104,39,48,
  99,35,44,96,32,41,100,36,45,111,46,56,210,90,111,216,74,95,
  200,58,79,190,48,69,202,60,81,205,79,99,210,88,109,213,95,115,
  218,108,128,218,108,128,218,108,128,219,110,130,219,109,130,203,75,95,
  198,61,82,195,56,77,193,53,73,182,40,61,193,51,72,196,58,79,
  201,68,89,203,75,95,200,67,88,192,50,71,201,69,90,195,55,76,
  196,57,78,198,61,82,199,66,86,197,60,81,197,60,81,198,61,82,
  200,67,87,213,95,116,217,104,124,219,109,130,220,112,132,220,112,132,
  218,106,126,215,100,120,211,82,103,210,69,89,208,66,87,214,76,92,
  208,77,82,114,53,57,91,27,36,87,22,32,98,33,43,106,41,51,
  171,104,116,245,167,104,242,175,103,231,219,106,163,228,87,111,193,88,
  55,106,68,161,182,79,152,207,74,124,192,65,13,147,57,7,141,93,
  9,99,83,3,81,57,7,113,44,18,145,17,10,134,32,10,31,168,
  10,31,168,67,120,33,66,145,3,77,145,3,105,145,3,102,145,11,
  46,145,28,16,74,24,5,130,43,5,145,47,3,145,96,6,147,120,
  36,177,127,51,191,104,119,200,65,178,194,64,202,125,84,135,71,80,
  113,48,58,110,46,55,112,48,57,112,48,57,119,54,64,198,98,118,
  207,66,86,189,47,68,188,46,67,205,63,84,210,68,89,241,100,120,
  244,103,123,243,102,122,249,107,128,251,110,130,240,99,119,203,62,82,
  193,52,72,200,58,79,199,57,78,194,53,73,199,57,78,206,64,85,
  211,70,90,210,69,89,206,64,85,199,58,78,209,67,88,206,64,85,
  200,59,79,203,61,82,203,61,82,203,61,82,209,67,88,205,63,84,
  207,65,86,233,92,112,251,109,130,248,107,127,252,110,131,252,111,131,
  249,108,128,249,108,128,242,101,121,237,96,116,233,91,112,214,119,105,
  130,85,65,107,55,43,98,34,43,95,30,40,96,31,41,114,50,59,
  233,108,128,235,171,94,189,221,83,153,226,85,109,222,84,85,145,91,
  90,147,102,152,207,67,109,206,121,141,174,40,11,145,31,27,79,61,
  33,68,39,3,120,62,31,85,21,6,87,47,14,133,55,10,31,168,
  10,31,168,84,57,63,25,145,24,30,145,23,90,145,3,13,145,56,
  10,77,40,28,122,21,23,145,19,27,145,28,3,145,67,3,145,71,
  56,149,65,123,152,52,179,162,55,201,77,78,202,60,81,194,70,90,
  105,41,50,107,43,52,106,41,51,107,42,51,109,45,54,112,48,57,
  138,74,83,172,69,89,195,65,86,205,75,95,204,74,94,217,103,123,
  218,103,124,216,101,121,221,110,131,222,112,133,217,102,122,197,58,78,
  194,52,73,201,66,87,202,69,89,202,67,88,197,58,79,197,58,79,
  200,63,84,199,61,82,199,61,82,189,47,68,194,53,73,184,42,63,
  195,53,74,200,64,84,199,61,82,197,56,77,200,62,83,200,64,84,
  197,58,79,200,63,84,217,102,123,220,108,128,220,108,128,222,112,133,
  220,109,129,219,107,127,218,109,129,198,106,127,157,93,102,121,60,64,
  116,66,52,115,71,51,111,46,56,102,38,47,103,39,48,180,124,118,
  246,153,113,217,194,78,152,203,64,125,215,78,92,217,90,47,108,59,
  63,182,135,92,199,100,65,189,89,19,161,77,3,132,91,3,68,52,
  3,145,81,3,145,107,3,139,82,3,62,60,13,94,106,10,31,168,
  10,31,168,17,99,95,3,135,96,3,127,117,6,137,64,3,78,27,
  12,112,37,28,145,15,52,135,12,60,133,10,6,145,32,84,123,14,
  143,51,10,171,42,45,193,71,64,180,38,59,185,44,64,207,66,86,
  164,76,96,103,43,45,96,36,37,95,32,37,100,36,43,106,45,46,
  107,45,51,107,43,52,105,41,50,108,44,53,109,44,54,115,51,60,
  112,48,57,112,48,57,115,51,60,117,53,62,115,51,60,105,40,50,
  101,37,46,104,40,49,102,37,47,96,32,41,94,29,39,92,27,37,
  93,28,38,94,30,39,93,29,38,83,18,28,90,26,35,89,24,34,
  89,25,34,91,26,36,87,23,32,84,19,29,91,27,36,96,32,41,
  92,28,37,95,31,40,111,47,56,114,50,59,115,51,60,112,48,57,
  116,51,61,115,51,60,116,52,61,112,47,57,111,47,56,108,44,53,
  111,53,50,112,69,48,114,50,59,112,56,54,152,108,89,240,158,101,
  224,155,83,202,110,71,175,152,39,168,146,40,80,186,62,28,92,64,
  52,192,163,48,189,163,39,181,122,16,158,126,4,71,70,3,109,118,
  3,135,135,3,145,120,3,131,123,3,65,92,12,70,137,10,31,168,
  10,31,168,10,90,137,3,105,145,3,104,145,3,62,82,3,100,77,
  16,145,52,64,139,8,116,119,3,138,99,3,60,106,7,45,81,5,
  72,50,12,183,94,48,202,65,80,181,40,60,176,35,55,206,64,85,
  222,96,95,158,126,86,95,58,31,91,44,30,91,28,35,96,33,40,
  109,46,53,111,57,53,111,47,56,112,48,57,111,47,56,110,45,55,
  114,49,59,111,47,56,112,48,57,115,50,60,115,50,60,112,48,57,
  114,49,59,113,49,58,104,40,49,98,34,43,95,30,40,92,28,37,
  93,29,38,92,28,37,93,29,38,89,24,34,97,32,42,97,33,42,
  98,34,43,98,34,43,96,32,41,95,30,40,94,29,39,98,34,43,
  99,34,44,96,32,41,114,50,59,114,50,59,114,50,59,113,49,58,
  114,50,59,113,49,58,114,50,59,103,39,48,94,30,39,94,30,39,
  97,33,42,107,45,50,112,57,55,148,104,86,234,184,101,248,193,107,
  242,211,101,223,117,93,210,136,72,203,155,64,166,196,55,38,103,77,
  61,165,153,69,204,132,59,198,134,26,116,61,5,79,40,3,142,87,
  3,143,85,3,145,97,3,112,138,3,72,79,13,124,125,10,31,168,
  10,31,168,17,112,90,3,108,142,17,53,87,3,50,83,20,141,90,
  52,123,21,78,79,3,69,56,3,61,62,3,57,92,3,56,129,3,
  98,154,16,150,177,43,183,133,73,180,61,61,175,57,55,179,164,71,
  179,193,85,210,219,93,176,144,66,102,58,40,87,26,30,91,33,29,
  101,46,39,111,66,48,112,57,54,115,50,60,114,50,59,112,48,57,
  113,49,58,111,46,56,112,48,57,114,50,59,112,48,57,110,46,55,
  113,49,58,113,49,58,110,45,55,106,41,51,103,39,48,102,38,47,
  99,35,44,95,31,40,92,28,37,87,23,32,93,29,38,99,35,44,
  103,38,48,104,40,49,104,40,49,111,46,56,108,44,53,106,41,50,
  101,36,46,110,45,55,113,49,58,115,50,60,114,50,59,115,50,60,
  115,50,60,111,46,56,109,45,54,94,30,39,80,15,25,93,32,36,
  100,45,40,111,57,57,173,110,117,236,94,115,232,167,95,230,187,89,
  239,212,98,236,113,112,232,190,93,225,217,92,211,196,80,136,152,91,
  69,102,50,103,136,70,81,126,65,48,76,14,43,140,13,10,145,36,
  3,145,49,3,145,83,3,139,135,3,79,81,4,138,131,10,31,168,
  10,31,168,83,67,60,3,128,93,2,62,45,20,59,50,69,66,9,
  82,82,3,91,114,3,72,145,3,69,145,3,53,145,3,53,145,3,
  85,153,12,118,169,27,163,151,49,145,185,43,167,197,55,143,208,66,
  127,220,91,193,209,110,217,126,95,213,87,88,147,54,68,103,44,43,
  97,42,32,93,81,34,98,77,41,109,45,53,108,44,53,110,46,55,
  112,48,57,112,48,57,111,47,56,112,48,57,112,48,57,114,50,59,
  113,49,58,108,44,53,95,30,40,92,28,37,94,30,39,97,32,42,
  96,31,40,92,28,37,89,25,34,83,18,28,95,30,40,95,30,40,
  96,32,41,94,30,39,94,30,39,102,38,47,109,44,54,113,49,58,
  112,48,57,114,50,59,114,50,59,115,50,60,115,50,60,115,50,60,
  102,38,47,98,34,43,100,35,45,94,30,39,91,26,36,110,62,52,
  151,144,90,207,218,101,219,136,90,202,61,81,197,107,62,191,118,52,
  195,181,54,200,198,64,192,208,67,203,226,85,220,224,99,216,173,102,
  165,162,82,116,102,57,82,107,48,121,145,12,59,145,3,14,145,21,
  3,145,40,3,120,79,3,71,66,3,133,139,27,140,91,10,31,168,
  10,31,168,40,110,65,3,145,61,3,103,60,46,138,32,120,144,3,
  90,145,3,26,145,41,7,145,75,25,145,20,55,145,3,91,145,3,
  108,145,3,104,149,7,107,176,68,68,186,83,59,182,102,71,192,122,
  68,204,151,104,221,178,210,137,94,214,78,87,198,56,77,189,47,68,
  188,54,70,172,82,80,158,66,86,153,61,82,155,65,86,160,75,96,
  173,105,118,175,109,120,176,110,121,176,112,121,176,111,121,173,104,118,
  170,97,115,162,80,100,149,52,73,148,51,71,152,58,78,153,60,81,
  155,66,86,154,63,83,155,65,85,146,44,65,153,60,81,155,65,86,
  149,53,73,145,42,63,152,58,79,156,68,88,166,89,109,176,111,121,
  176,110,121,175,109,120,175,109,120,175,109,120,172,103,117,162,82,102,
  152,60,80,151,55,76,154,60,81,163,54,75,186,58,79,220,78,99,
  234,186,102,229,207,97,208,89,82,206,64,85,202,94,73,184,135,47,
  153,170,36,158,177,41,108,199,57,119,209,68,180,236,94,192,237,95,
  148,215,73,108,200,76,123,172,54,3,145,46,3,145,64,3,145,60,
  3,92,63,4,90,48,48,137,47,3,145,121,36,128,75,10,31,168,
  10,31,168,41,89,83,3,145,72,3,145,70,23,145,29,55,145,3,
  30,145,9,4,145,83,3,142,122,5,143,97,8,145,52,69,145,18,
  64,145,45,48,153,71,65,194,164,46,161,179,39,128,177,46,142,188,
  51,175,192,71,210,180,110,223,140,161,147,106,207,66,85,202,60,81,
  188,47,67,183,42,62,185,44,64,183,41,62,188,46,67,206,64,85,
  232,91,111,238,97,117,251,110,130,251,109,130,252,110,131,251,109,130,
  248,106,127,231,90,110,216,74,95,216,75,95,218,76,97,215,74,94,
  221,80,100,212,70,91,203,61,82,184,43,63,178,37,57,185,43,64,
  194,52,73,199,57,78,204,62,83,210,69,89,228,87,107,248,107,127,
  250,109,129,252,111,131,252,110,131,249,107,128,247,105,126,225,84,104,
  198,56,77,196,54,75,204,62,83,200,59,79,207,66,86,209,68,88,
  226,93,103,235,104,111,229,88,108,219,78,98,219,96,93,205,97,81,
  162,159,63,175,157,52,147,198,64,134,206,65,144,217,76,112,222,103,
  87,216,107,109,188,60,132,150,32,72,136,23,6,144,71,3,145,73,
  4,145,85,5,145,62,9,145,60,3,145,91,16,128,92,10,31,168,
  10,31,168,31,96,76,12,145,51,11,145,46,26,145,23,52,145,3,
  30,145,5,9,145,35,3,144,76,5,144,84,4,145,63,53,145,35,
  36,145,79,10,152,132,53,188,185,62,144,204,57,150,199,61,174,199,
  70,187,193,118,224,138,185,246,112,217,215,105,223,88,101,214,72,93,
  202,60,81,192,51,71,198,56,77,196,54,75,176,34,55,199,57,78,
  229,87,108,243,101,122,250,109,129,251,110,130,251,109,130,249,108,128,
  251,110,130,246,105,125,248,107,127,244,102,123,239,98,118,234,93,113,
  219,77,98,213,71,92,208,67,87,186,45,65,180,38,59,186,44,65,
  194,52,73,200,58,79,206,64,85,221,79,100,234,92,113,239,98,118,
  245,104,124,248,115,121,250,114,125,242,126,108,243,110,118,224,82,103,
  204,62,83,214,72,93,210,69,89,215,73,94,207,65,86,204,62,83,
  213,72,92,228,86,107,222,81,101,226,85,105,236,105,112,233,103,109,
  206,64,83,183,119,65,171,189,79,123,203,100,103,206,113,128,205,71,
  69,204,100,84,184,57,79,161,25,136,133,3,75,144,16,30,145,38,
  40,145,17,24,145,53,3,145,69,3,145,97,4,120,129,10,31,168,
  10,31,168,83,123,13,59,145,3,36,145,17,63,145,16,49,145,4,
  20,145,31,7,145,79,4,145,86,8,145,34,5,145,57,3,145,81,
  3,145,80,3,145,106,23,165,151,74,205,214,75,204,217,102,216,170,
  143,214,96,185,213,75,206,199,76,216,133,84,231,89,110,230,88,109,
  204,62,83,204,62,83,207,65,86,200,59,79,183,41,62,202,60,81,
  234,93,113,247,106,126,246,105,125,250,108,129,247,106,126,246,105,125,
  247,105,126,239,98,118,235,94,114,225,84,104,213,72,92,208,66,87,
  203,61,82,215,74,94,212,70,91,190,49,69,212,70,91,211,69,90,
  202,60,81,192,51,71,208,66,87,220,78,99,209,68,88,213,71,92,
  237,96,116,246,105,125,240,129,100,231,132,90,223,121,87,229,121,96,
  205,63,84,198,57,77,209,67,88,228,86,107,207,65,86,190,49,69,
  199,58,78,203,61,82,201,59,80,207,65,86,212,70,91,238,96,117,
  225,83,104,213,118,82,76,190,169,50,188,188,54,194,137,38,177,75,
  36,177,77,33,175,75,15,155,53,38,145,24,42,145,21,53,145,7,
  27,145,5,15,145,14,3,145,84,3,145,97,11,129,114,10,31,168,
  10,31,168,83,111,21,50,145,3,23,145,19,18,145,16,4,145,85,
  3,135,133,3,125,138,11,136,70,60,145,5,52,145,9,19,145,14,
  3,145,37,3,145,42,24,166,77,69,210,188,67,209,204,112,202,106,
  183,172,64,198,94,68,200,87,72,204,86,78,223,82,102,232,91,111,
  220,79,99,219,77,98,217,76,96,201,60,80,194,52,73,200,59,79,
  225,84,104,222,81,101,217,76,96,241,100,120,245,104,124,248,107,127,
  249,107,128,239,98,118,209,67,88,204,62,83,197,55,76,198,56,77,
  201,59,80,210,69,89,208,66,87,187,45,66,207,65,86,211,69,90,
  201,59,80,192,51,71,190,48,69,200,58,79,196,54,75,203,62,82,
  221,80,100,246,105,125,240,99,119,227,104,93,202,131,62,206,93,75,
  199,57,78,200,58,79,215,73,94,233,92,112,216,74,95,202,60,81,
  200,58,79,202,60,81,203,61,82,210,69,89,214,72,93,236,94,115,
  234,93,113,157,136,71,116,202,60,75,195,92,78,206,72,164,177,52,
  47,174,78,9,150,77,3,145,75,3,145,89,52,145,8,43,145,3,
  12,145,25,10,145,30,5,145,52,3,141,116,8,135,123,10,31,168,
  10,31,168,35,79,89,7,145,57,4,141,70,3,137,80,3,116,144,
  3,118,136,3,130,130,3,139,104,13,145,35,13,145,41,6,145,37,
  12,145,37,36,130,19,46,100,27,62,105,52,102,126,66,154,164,62,
  189,137,66,207,76,83,219,121,89,227,170,89,236,125,109,242,101,121,
  240,98,119,242,101,121,230,88,109,202,60,81,187,45,66,197,56,76,
  208,66,87,208,67,87,208,66,87,243,101,122,251,110,130,250,109,129,
  250,109,129,241,100,120,209,67,88,204,62,83,196,55,75,194,53,73,
  195,53,74,199,57,78,187,46,66,177,35,56,206,64,85,221,79,100,
  217,76,96,209,68,88,201,59,80,192,50,71,192,50,71,205,63,84,
  218,76,97,239,97,118,241,99,120,222,91,97,199,95,63,199,63,76,
  191,50,70,209,80,84,214,72,93,227,142,111,247,106,126,226,103,99,
  229,97,107,236,95,115,230,88,109,234,93,113,243,102,122,248,116,122,
  219,185,100,103,104,49,96,126,62,165,213,75,105,214,73,167,212,74,
  123,180,77,10,152,67,3,145,62,17,145,52,36,145,20,13,145,88,
  4,145,58,3,145,79,3,145,86,3,144,94,20,126,108,10,31,168,
  10,31,168,34,122,62,3,121,122,3,113,136,3,139,78,3,111,141,
  3,104,141,3,120,139,3,140,102,27,145,45,90,144,17,89,145,11,
  52,79,7,55,68,3,82,104,6,131,121,44,127,109,60,100,65,38,
  146,99,78,205,189,88,200,187,85,201,194,81,233,141,100,239,98,118,
  211,69,90,223,82,102,223,82,102,200,58,79,191,49,70,187,45,66,
  200,58,79,201,60,80,213,71,92,239,98,118,245,104,124,249,108,128,
  249,108,128,242,101,121,212,70,91,208,66,87,211,69,90,207,66,86,
  200,58,79,196,54,75,185,44,64,173,32,52,180,38,59,211,69,90,
  220,79,99,225,83,104,212,70,91,209,67,88,213,71,92,215,74,94,
  234,93,113,243,102,122,242,101,121,238,96,117,216,75,93,207,65,86,
  210,75,82,206,104,67,209,74,75,216,74,94,241,102,116,224,164,106,
  236,135,114,240,98,116,226,84,105,224,82,103,225,84,103,217,106,83,
  217,187,75,203,195,92,99,126,62,98,123,59,145,203,69,107,210,69,
  75,175,50,5,146,49,3,145,57,3,145,59,14,145,24,14,145,37,
  3,145,70,3,145,96,3,145,101,3,145,114,22,135,88,10,31,168,
  10,31,168,20,85,120,3,145,125,3,141,113,3,132,129,3,136,125,
  3,140,101,3,140,107,5,145,66,37,145,22,89,143,11,60,68,3,
  93,95,3,128,135,3,97,143,3,145,67,24,188,91,54,202,129,81,
  110,91,48,112,153,74,119,203,72,149,184,71,218,103,92,228,87,107,
  204,62,83,204,62,83,206,65,85,200,58,79,189,49,68,181,42,59,
  180,38,59,194,52,73,220,79,99,244,103,123,247,106,126,244,102,123,
  247,106,126,233,91,112,205,63,84,207,65,86,214,73,93,205,64,84,
  205,64,84,197,55,76,188,47,67,174,33,53,175,33,54,196,54,75,
  207,65,86,221,80,100,231,90,110,226,85,105,222,81,101,233,92,112,
  247,106,126,246,105,125,236,95,115,247,109,124,238,102,115,236,94,115,
  207,130,69,185,102,43,184,76,43,197,80,63,221,84,93,213,185,97,
  201,195,89,193,157,75,194,66,71,202,64,79,201,62,77,196,78,66,
  195,96,55,206,131,65,205,212,88,97,122,58,76,104,39,151,184,56,
  78,166,30,6,145,50,3,145,63,3,145,65,3,145,63,3,145,62,
  3,145,66,3,145,75,3,145,108,3,145,121,10,136,116,10,31,168,
  10,31,168,22,90,116,3,145,125,3,145,101,3,145,46,3,145,93,
  3,145,79,3,145,95,14,145,66,55,145,14,29,75,30,39,106,34,
  41,145,14,60,145,10,29,145,20,30,145,6,139,176,45,193,184,69,
  154,178,68,59,97,35,77,199,79,92,204,70,189,170,87,218,77,97,
  201,59,80,189,47,68,198,56,77,196,54,75,205,69,82,207,84,81,
  184,43,63,198,56,77,227,85,106,244,103,123,247,106,126,248,106,127,
  244,103,123,234,92,113,203,61,82,196,54,75,199,58,78,197,55,76,
  190,48,69,181,39,60,177,36,56,177,35,56,173,31,52,195,53,74,
  200,58,79,204,62,83,230,89,109,243,102,122,246,105,125,250,109,129,
  248,107,127,239,98,118,244,145,113,247,198,109,248,198,108,251,166,120,
  212,168,71,199,156,57,196,147,54,188,124,47,205,72,74,194,201,89,
  122,229,135,111,193,133,110,202,82,183,165,71,198,78,77,181,39,60,
  185,43,64,210,68,87,229,146,89,171,175,75,70,93,29,75,83,19,
  120,147,6,51,145,20,22,145,29,3,145,65,3,145,66,9,145,44,
  3,145,85,3,145,76,8,145,71,3,145,114,3,144,113,10,31,168,
  10,31,168,38,87,119,3,138,104,3,145,78,3,145,50,3,145,61,
  3,145,68,3,145,102,3,136,109,4,126,82,3,78,40,3,145,82,
  4,145,90,5,145,90,8,145,72,9,145,25,52,147,15,118,183,42,
  113,185,44,61,99,39,96,169,82,117,203,62,153,192,67,189,146,69,
  195,63,71,198,57,77,206,64,85,210,68,89,217,75,96,203,61,82,
  183,41,62,203,61,82,229,88,108,238,97,117,244,102,123,251,109,130,
  250,108,129,235,94,114,207,65,86,203,61,82,185,43,64,176,34,55,
  175,34,54,166,25,45,163,22,42,159,18,38,163,22,42,190,48,69,
  199,57,78,205,63,84,234,93,113,248,107,127,245,104,124,244,103,123,
  244,103,123,237,96,116,241,104,119,246,142,112,249,194,108,253,212,111,
  211,229,95,161,216,76,190,208,71,204,170,62,201,124,59,215,178,81,
  126,231,161,81,210,168,74,204,184,90,227,148,185,111,93,197,55,76,
  182,41,61,211,69,90,208,109,86,107,85,46,133,136,59,109,117,16,
  64,71,4,78,133,3,68,145,3,33,145,6,5,145,38,10,145,81,
  12,145,74,3,125,106,4,99,127,3,127,138,21,127,103,10,31,168,
  10,31,168,99,16,123,18,33,142,5,103,99,3,145,86,3,145,54,
  3,145,67,3,145,116,3,132,132,3,83,87,3,107,86,3,145,100,
  3,145,90,3,145,82,28,145,30,33,145,18,62,145,11,56,164,35,
  107,179,38,89,110,45,147,160,66,170,204,64,174,192,58,186,171,53,
  184,71,56,207,65,86,210,69,89,222,81,101,224,83,103,197,55,76,
  190,77,63,207,65,86,238,97,117,244,103,123,241,99,120,237,96,116,
  242,101,121,245,104,124,229,88,108,217,76,96,206,65,85,207,65,86,
  198,56,77,179,37,58,164,22,43,157,15,36,164,22,43,192,50,71,
  205,63,84,211,69,90,231,90,110,237,96,116,246,105,125,225,83,104,
  226,84,105,239,98,118,238,97,117,244,106,122,243,124,110,242,177,101,
  195,241,103,129,244,121,141,231,90,187,151,64,195,73,65,217,120,80,
  207,220,106,132,230,126,74,132,107,81,143,111,126,188,87,194,97,73,
  181,58,56,208,78,76,118,58,57,130,113,68,163,177,43,129,145,3,
  123,96,3,67,61,3,104,115,3,41,145,6,20,145,11,40,145,14,
  25,145,10,3,135,66,17,142,45,3,142,84,19,132,58,10,31,168,
  10,31,168,97,24,110,14,19,145,6,96,133,3,143,99,3,145,63,
  3,145,72,3,145,127,3,132,139,3,81,80,3,118,60,4,145,57,
  6,145,72,3,145,71,23,145,35,31,145,47,39,145,33,30,167,64,
  84,182,54,87,94,30,170,169,53,178,190,49,147,140,44,172,148,43,
  186,68,58,210,68,89,226,85,105,230,89,109,212,71,91,189,55,66,
  199,89,71,218,118,87,244,102,123,243,102,122,226,84,105,210,69,89,
  213,71,92,236,95,115,247,106,126,239,98,118,222,80,101,214,72,93,
  209,67,88,205,63,84,190,49,69,168,26,47,177,35,56,204,62,83,
  213,72,92,219,98,102,205,181,103,232,112,114,229,98,107,205,63,84,
  206,64,85,227,86,106,230,88,109,235,94,114,241,109,118,241,164,103,
  213,231,105,195,205,106,191,161,84,199,142,66,187,68,58,203,101,75,
  192,179,95,107,120,64,119,176,121,44,106,80,55,118,87,102,187,91,
  161,164,46,117,95,55,118,77,53,187,131,50,131,146,12,98,145,3,
  127,101,5,112,123,3,53,66,3,42,142,4,47,145,3,52,145,3,
  48,145,5,24,145,33,4,145,63,3,145,80,9,134,63,10,31,168,
  10,31,168,40,77,129,3,54,145,3,107,127,3,139,83,3,145,63,
  3,136,90,3,130,137,3,128,139,3,93,119,3,90,61,6,145,63,
  28,145,34,19,145,46,32,145,29,19,145,23,4,145,67,3,145,61,
  24,110,37,63,98,33,164,195,53,170,186,60,89,90,30,98,80,35,
  143,89,85,226,85,106,235,94,114,236,95,108,219,77,88,194,128,56,
  214,155,77,236,122,108,249,108,128,239,98,118,218,76,97,200,58,79,
  198,56,77,220,79,99,237,96,116,240,99,119,243,102,122,240,99,119,
  230,88,109,210,68,89,200,59,79,178,36,57,203,61,82,214,73,93,
  234,92,113,242,101,121,226,141,116,211,157,104,207,105,81,199,57,78,
  206,65,85,226,85,105,246,104,125,242,100,121,236,97,113,226,105,94,
  205,192,78,226,138,87,230,116,100,214,76,93,189,127,54,129,132,69,
  98,111,50,157,171,102,112,221,131,65,198,158,44,108,89,38,103,77,
  57,122,64,91,96,39,160,117,19,158,80,17,128,99,8,36,145,36,
  14,145,33,24,145,17,39,145,7,21,145,7,25,145,4,37,145,3,
  53,145,3,37,145,20,9,145,33,9,145,31,14,145,31,10,31,168,
  10,31,168,19,115,123,3,136,142,3,141,125,3,145,66,3,145,62,
  3,145,64,3,144,89,3,134,102,3,143,85,26,75,23,43,139,35,
  4,145,85,4,142,112,5,138,77,23,145,3,14,145,58,13,123,12,
  23,71,9,123,156,38,172,194,56,96,112,47,123,133,68,199,186,95,
  126,62,67,117,52,61,192,74,92,241,137,105,235,126,97,207,95,69,
  216,101,79,228,93,99,250,109,126,244,103,123,232,91,111,205,63,84,
  200,58,79,206,64,85,223,81,102,236,95,115,243,102,122,237,95,116,
  226,85,105,210,69,89,199,57,78,178,37,57,202,60,81,217,75,96,
  230,89,109,220,84,98,221,90,97,219,78,98,210,68,89,196,54,75,
  210,68,89,240,98,119,243,102,122,238,97,117,213,78,85,204,98,62,
  179,182,58,223,95,99,242,103,119,184,94,82,91,105,42,102,123,59,
  165,210,116,169,238,96,107,219,110,65,207,137,62,204,128,52,117,65,
  33,97,68,61,156,103,98,150,13,133,76,4,144,44,7,128,135,4,
  17,144,56,3,145,54,4,145,43,13,145,12,4,145,40,32,145,24,
  67,145,3,58,145,4,14,145,62,3,139,138,7,142,132,10,31,168,
  10,31,168,24,87,116,3,141,125,3,139,129,3,132,124,3,144,82,
  3,145,70,3,145,75,3,141,82,3,138,111,3,142,75,3,75,47,
  3,117,120,3,127,144,3,129,120,6,145,22,13,96,8,25,69,3,
  88,124,5,176,144,40,138,131,60,100,98,41,216,168,97,239,116,110,
  211,69,88,141,54,75,97,40,40,160,99,94,235,107,108,239,97,104,
  238,108,109,236,97,106,248,108,123,234,93,110,222,81,99,206,64,85,
  199,57,78,206,64,85,221,79,100,227,85,106,235,93,114,238,97,117,
  225,84,104,208,66,87,203,61,82,178,37,57,201,59,80,216,74,95,
  214,72,93,202,62,80,204,67,82,210,68,89,199,57,78,206,64,85,
  225,84,104,240,99,119,239,97,118,217,75,96,205,79,73,195,77,53,
  202,140,66,223,113,98,157,93,102,113,57,52,109,112,49,142,149,91,
  118,239,158,104,232,125,99,236,158,96,228,100,105,209,88,79,203,107,
  65,129,108,22,86,61,42,144,36,104,129,10,145,71,4,145,111,3,
  106,141,11,95,145,13,38,145,45,30,145,30,60,145,13,70,145,5,
  83,145,3,73,145,3,14,144,73,3,141,144,14,131,142,10,31,168,
  10,31,168,37,137,43,4,145,78,3,145,106,3,143,121,3,144,112,
  3,145,89,3,145,103,3,140,117,3,139,117,3,137,127,3,142,111,
  3,76,80,3,62,71,3,60,70,3,68,27,8,89,21,57,145,3,
  84,140,3,164,147,41,98,72,34,163,134,76,219,91,89,215,75,88,
  201,60,79,187,45,62,176,47,66,105,52,47,150,111,76,226,103,88,
  236,101,110,245,104,121,245,104,124,223,82,98,210,71,84,198,71,70,
  198,82,65,215,76,93,228,86,107,224,82,103,225,131,94,225,169,96,
  229,152,106,215,74,94,205,63,84,187,45,66,200,58,79,212,71,91,
  204,62,83,202,60,81,196,54,75,190,48,69,199,57,78,219,77,98,
  237,95,116,242,101,121,217,76,96,200,60,78,184,57,57,189,105,47,
  191,99,82,124,65,67,132,74,75,207,172,94,164,173,82,79,99,42,
  90,187,104,79,210,69,73,209,119,77,215,156,88,210,99,88,201,82,
  56,198,131,24,120,99,3,70,49,24,131,71,105,136,8,140,114,3,
  127,142,3,78,145,3,32,145,32,10,145,38,21,145,30,21,145,37,
  29,134,33,41,128,24,5,143,117,3,143,110,15,141,99,10,31,168,
  10,31,168,33,134,34,6,145,23,4,145,73,3,145,128,3,145,132,
  3,145,117,3,144,101,3,131,110,3,105,141,3,72,145,3,115,145,
  3,110,145,3,105,145,3,80,141,3,140,70,13,145,28,44,145,10,
  90,139,3,82,81,16,102,90,38,103,84,39,171,118,64,205,80,70,
  202,69,71,198,93,62,197,89,65,194,113,58,193,92,59,202,106,63,
  207,96,79,223,83,101,243,102,122,227,85,102,210,81,76,187,85,46,
  199,116,57,219,99,84,235,93,114,226,85,105,209,98,79,196,177,69,
  210,199,82,222,84,101,205,64,84,198,56,77,191,49,70,202,61,81,
  197,56,76,179,38,58,168,27,47,186,45,65,208,80,76,229,94,99,
  239,98,118,228,87,107,205,63,84,190,64,64,137,114,36,190,161,50,
  195,197,72,164,154,92,230,207,94,173,214,73,136,197,56,98,123,63,
  61,99,35,49,186,51,51,184,127,58,184,170,57,188,184,46,183,162,
  29,171,96,9,151,118,3,124,109,3,64,57,5,121,48,85,145,3,
  116,145,3,98,145,3,74,145,4,19,145,28,4,145,55,3,143,73,
  3,85,144,3,42,145,3,118,120,19,145,25,30,137,22,10,31,168,
  10,31,168,53,78,127,3,145,103,3,145,107,3,145,121,3,145,125,
  3,145,108,3,107,126,3,77,145,3,58,145,3,41,145,3,80,145,
  3,60,145,3,64,145,3,85,145,3,132,101,3,145,62,3,145,35,
  21,102,17,59,81,3,106,168,36,108,157,74,67,102,47,102,133,79,
  171,196,62,173,211,70,181,211,69,184,202,64,202,185,60,198,160,56,
  186,125,45,193,120,51,169,133,90,160,95,101,215,78,84,194,81,56,
  189,83,49,214,76,89,237,95,116,239,97,118,216,74,95,209,74,85,
  211,95,80,224,82,103,220,79,99,208,67,87,176,34,55,179,37,58,
  178,36,57,181,39,60,188,57,55,189,48,68,210,105,76,231,129,95,
  230,96,113,212,88,81,196,72,65,176,157,60,59,97,33,103,162,54,
  107,206,64,169,223,83,145,219,83,74,197,87,48,189,119,90,197,78,
  52,101,40,61,136,82,51,184,137,40,116,182,35,132,177,32,172,121,
  14,156,74,3,145,122,3,137,129,3,131,122,3,145,59,3,145,28,
  51,145,6,78,145,3,88,145,3,89,145,3,93,139,3,46,140,49,
  3,94,138,3,67,145,3,104,124,18,145,27,50,142,6,10,31,168,
  10,31,168,33,76,139,3,137,139,3,143,122,3,141,129,3,145,87,
  3,145,87,3,141,101,3,121,129,3,77,145,3,95,145,3,108,145,
  3,126,143,3,122,141,3,120,132,3,144,59,4,145,32,45,142,5,
  23,69,5,55,145,7,18,145,27,8,149,67,75,188,86,77,118,64,
  99,110,45,133,200,82,110,222,80,182,219,79,205,213,79,208,198,66,
  193,138,51,182,148,56,122,104,65,149,85,91,218,77,90,196,56,73,
  182,45,59,203,61,82,233,91,112,230,99,120,233,103,118,221,99,93,
  212,81,87,191,187,78,186,193,85,203,87,82,183,41,62,173,32,52,
  197,56,73,206,66,79,201,66,74,185,122,56,192,175,76,99,104,51,
  112,109,60,187,145,55,201,129,60,183,174,69,107,126,62,49,106,45,
  63,202,137,84,219,183,64,205,170,83,194,114,55,193,164,76,207,119,
  73,169,93,32,97,53,59,175,169,63,159,204,56,185,184,24,165,123,
  3,143,115,3,139,128,3,142,125,3,145,58,5,145,25,3,145,39,
  6,145,56,10,145,81,21,145,45,87,145,3,128,136,3,112,143,5,
  31,144,52,8,127,111,3,121,141,3,136,108,21,129,75,10,31,168,
  10,31,168,40,94,99,3,139,137,3,139,141,3,130,137,3,144,90,
  3,145,84,3,145,84,3,129,117,3,97,145,3,97,145,3,107,145,
  3,129,142,3,126,137,7,132,91,16,145,31,34,145,15,42,76,3,
  81,112,3,106,145,3,89,145,3,74,145,8,132,136,8,153,161,24,
  152,150,65,174,201,74,176,196,68,200,184,64,221,203,79,218,194,76,
  207,107,71,206,89,83,106,51,52,179,93,112,215,73,93,198,63,75,
  189,47,68,208,66,87,237,95,116,153,88,97,148,95,90,234,201,96,
  124,109,71,115,96,55,116,90,57,113,52,57,103,39,48,101,36,46,
  108,50,50,123,81,60,212,107,74,198,155,71,172,181,86,75,104,40,
  69,96,34,137,150,53,210,194,70,196,186,73,191,142,54,74,68,19,
  97,170,138,73,208,205,57,188,195,60,200,184,73,212,162,76,210,123,
  68,206,120,62,127,95,44,107,87,62,201,158,47,183,167,9,144,135,
  3,138,129,7,80,141,3,125,145,11,144,72,27,145,6,6,145,31,
  3,145,87,3,140,126,3,142,95,19,145,40,69,145,4,85,145,3,
  61,145,3,22,141,53,3,131,136,3,112,145,13,90,145,10,31,168,
  10,31,168,60,73,72,3,145,96,3,145,124,3,144,136,3,145,123,
  3,145,110,3,145,97,3,142,127,3,125,145,3,105,145,3,118,140,
  3,145,93,3,145,83,10,145,69,32,145,22,54,145,10,38,114,4,
  28,145,5,47,145,3,85,145,3,110,145,3,130,143,3,127,145,3,
  131,147,25,149,192,68,151,193,65,190,152,58,213,176,72,236,158,96,
  223,103,82,197,93,89,114,50,58,206,88,100,218,91,90,199,121,61,
  190,107,60,210,69,89,234,94,115,120,56,65,155,95,87,212,184,80,
  65,116,56,124,120,64,175,137,70,172,79,66,163,31,52,171,42,63,
  183,59,80,194,72,92,215,146,94,190,220,80,161,163,86,120,126,64,
  159,153,65,90,102,39,205,160,89,214,158,73,195,78,63,126,74,54,
  85,115,81,71,175,211,60,171,202,74,213,170,67,209,126,65,201,107,
  63,201,127,65,206,153,35,98,86,49,133,127,18,153,140,4,129,125,
  9,51,145,25,6,145,5,109,145,5,138,129,8,145,79,3,145,117,
  3,145,114,3,145,100,3,145,95,3,136,117,5,127,93,29,141,43,
  55,145,4,43,145,11,4,142,128,3,100,144,30,49,144,10,31,168,
  10,31,168,91,110,27,3,145,60,3,145,87,3,145,135,3,135,135,
  3,141,129,3,143,124,3,143,130,3,137,145,3,142,139,4,145,101,
  8,145,35,11,145,19,17,145,24,66,145,7,60,145,3,10,145,33,
  6,145,47,23,145,26,80,145,3,106,143,3,81,145,3,58,145,3,
  36,145,3,70,150,27,106,157,44,200,163,68,210,137,69,226,148,84,
  211,189,97,169,124,102,116,56,53,207,95,71,203,105,61,158,129,46,
  163,100,57,211,69,90,206,82,102,99,34,44,186,78,76,213,149,72,
  108,111,50,160,147,67,203,160,61,184,78,52,176,34,55,185,43,64,
  203,62,82,200,58,79,204,117,87,214,127,82,154,127,93,144,144,84,
  228,221,96,127,129,68,125,92,63,206,136,68,186,45,57,194,58,64,
  85,101,41,76,165,163,67,192,202,73,211,165,65,207,119,55,197,110,
  55,196,158,57,191,170,30,145,153,4,68,55,3,140,110,3,128,122,
  3,76,145,5,69,145,4,110,145,3,110,145,3,139,139,3,145,127,
  3,145,104,3,145,47,3,145,45,3,130,93,3,111,145,8,115,96,
  27,145,21,36,145,9,5,145,89,3,112,141,8,86,136,10,31,168,
  10,31,168,71,102,37,3,145,59,3,145,96,3,139,136,3,133,135,
  3,112,142,3,100,144,3,103,144,3,120,145,3,142,123,7,145,67,
  10,145,22,10,145,22,35,145,17,64,145,3,65,145,3,17,145,24,
  28,145,28,62,142,12,131,95,3,120,110,3,64,145,3,41,145,8,
  14,145,61,9,145,46,13,146,39,116,140,38,184,90,42,197,166,71,
  219,156,82,130,93,66,111,66,47,100,61,36,116,84,52,124,128,33,
  173,147,47,209,70,85,176,98,111,103,39,48,196,55,74,189,61,64,
  97,92,45,147,142,52,188,162,46,188,82,58,179,74,47,180,38,59,
  194,87,59,198,73,70,206,90,77,203,187,64,130,139,77,125,159,91,
  139,221,79,170,197,67,94,67,35,147,82,62,192,59,56,206,119,65,
  122,142,77,60,121,90,77,219,175,71,212,127,56,198,100,42,179,89,
  13,154,118,7,143,120,3,128,140,3,129,125,3,125,141,3,115,145,
  3,101,145,3,106,145,3,112,145,3,116,145,3,123,143,3,145,136,
  3,145,103,3,145,43,3,145,54,3,135,108,3,61,145,4,65,143,
  4,125,112,4,145,76,3,145,66,3,144,101,10,135,121,10,31,168,
  10,31,168,18,126,73,3,145,87,3,145,79,3,137,131,3,103,144,
  3,66,145,3,63,145,3,69,145,3,110,145,3,140,123,3,145,104,
  3,145,76,14,145,57,41,145,23,78,145,3,83,145,3,54,145,3,
  45,145,3,61,145,3,105,135,3,132,112,3,98,141,3,54,145,11,
  11,145,50,23,145,23,54,145,3,124,128,3,121,125,9,184,159,51,
  159,187,65,80,93,37,160,148,84,186,181,71,148,147,63,115,109,35,
  99,90,35,104,77,42,116,64,56,127,63,72,197,72,68,171,39,46,
  105,48,47,123,89,30,172,112,31,186,94,58,182,83,57,175,104,48,
  170,83,46,203,91,71,204,143,65,173,208,78,94,130,69,104,172,110,
  76,212,93,80,199,63,104,137,66,82,59,25,182,112,52,200,151,63,
  159,196,70,44,101,53,82,172,98,81,195,80,51,154,24,36,141,19,
  4,86,47,3,80,65,3,118,142,3,115,145,3,114,145,3,106,145,
  3,100,145,3,94,145,3,66,145,3,59,145,3,101,140,3,145,132,
  3,142,116,3,145,53,3,145,43,3,145,67,20,42,141,12,29,145,
  7,71,145,3,113,138,3,144,82,3,145,79,20,131,66,10,31,168,
  10,31,168,55,71,112,3,141,93,3,140,77,3,133,141,3,90,145,
  3,72,145,3,87,145,3,115,136,3,137,116,3,144,120,3,133,131,
  3,104,124,3,132,121,19,145,84,38,145,7,59,145,11,58,145,13,
  11,145,19,36,145,56,52,145,8,60,145,3,83,145,3,68,145,3,
  52,145,7,14,145,23,49,145,11,106,140,3,104,135,3,100,136,3,
  152,148,22,75,79,19,179,192,60,171,209,67,170,202,60,170,148,34,
  186,157,47,186,107,78,108,52,51,157,77,97,201,63,79,178,49,50,
  102,40,46,85,29,25,93,45,29,94,63,30,96,70,31,95,75,31,
  90,62,26,155,130,45,190,183,68,151,214,103,67,126,86,89,148,87,
  80,142,77,44,108,57,19,83,32,33,75,15,90,101,36,180,201,59,
  140,203,61,80,125,49,59,99,34,65,141,15,48,84,3,37,78,13,
  5,131,80,3,139,117,5,97,145,3,108,145,3,102,145,3,87,144,
  3,77,145,3,56,145,3,51,145,3,54,145,3,92,145,3,130,142,
  3,124,142,3,139,115,3,144,105,3,145,96,3,111,142,7,50,145,
  5,42,145,3,62,145,3,133,117,3,142,90,21,142,29,10,31,168,
  10,31,168,3,79,139,3,94,145,3,95,145,3,89,145,3,64,145,
  3,51,145,3,68,145,3,105,140,3,144,122,3,142,133,3,90,142,
  3,35,145,3,77,143,26,144,59,25,145,41,3,145,90,3,145,115,
  3,145,119,3,145,125,10,145,51,22,145,3,73,145,3,70,145,3,
  48,145,10,22,145,15,36,145,11,31,145,13,36,145,13,47,145,3,
  111,123,3,76,65,3,128,132,9,115,176,35,109,173,31,133,169,34,
  175,152,45,204,92,79,102,37,47,187,66,87,172,42,48,181,80,50,
  102,26,46,139,64,72,195,81,61,188,119,46,187,140,46,177,162,46,
  183,156,42,191,134,49,158,178,90,141,193,133,71,118,63,66,117,53,
  79,139,77,63,169,103,49,191,95,34,176,98,39,79,23,113,126,22,
  97,145,3,80,145,3,48,71,3,62,78,3,72,132,3,23,142,47,
  3,122,126,4,96,145,13,20,145,4,77,145,3,92,143,3,92,142,
  3,53,145,3,48,145,3,43,145,3,64,145,3,116,145,3,122,145,
  3,115,145,3,108,145,3,122,140,3,145,106,3,123,124,3,94,141,
  3,60,145,3,50,145,3,114,145,3,122,145,18,120,77,10,31,168,
  10,31,168,15,69,137,3,57,145,3,37,145,3,73,145,3,56,145,
  3,53,145,3,57,145,3,57,145,3,113,144,3,114,145,3,105,145,
  3,123,131,4,143,94,27,145,11,40,145,26,41,145,44,3,145,90,
  3,145,101,3,145,102,3,145,122,7,145,90,6,145,64,6,145,58,
  5,145,55,3,145,73,4,145,68,3,145,48,3,145,60,17,145,21,
  93,89,3,102,92,3,136,126,3,124,138,3,118,145,3,114,124,4,
  152,82,10,157,65,46,88,25,31,167,27,43,162,42,32,167,71,34,
  109,75,45,132,56,49,188,71,54,192,113,50,181,134,39,160,170,41,
  185,142,45,176,124,34,185,154,43,193,179,51,78,101,39,126,202,76,
  117,210,68,87,207,77,60,202,135,23,164,105,8,135,39,19,70,3,
  80,145,3,117,145,3,129,145,3,110,145,3,70,145,3,9,133,75,
  3,95,145,3,88,145,3,93,145,3,112,145,3,115,145,3,89,145,
  3,50,145,3,52,145,3,63,145,3,89,145,3,128,145,3,135,144,
  3,117,145,3,104,145,3,110,143,3,139,99,3,145,86,3,133,111,
  3,70,145,11,35,145,4,103,145,3,118,145,16,125,108,10,31,168,
  10,31,168,56,77,120,3,107,144,3,79,145,3,75,145,3,99,145,
  3,80,145,3,70,145,3,46,145,3,95,145,3,125,145,3,136,139,
  3,144,91,5,145,58,24,145,35,30,145,18,26,145,37,22,145,28,
  31,145,43,3,145,91,3,145,119,3,145,136,3,138,137,3,135,136,
  3,143,100,3,145,76,3,145,78,6,145,78,14,145,63,8,145,39,
  90,107,3,144,130,3,122,140,3,99,142,3,82,145,16,93,134,6,
  100,113,3,99,69,3,95,36,5,145,52,5,145,93,3,146,107,4,
  97,86,7,114,99,8,153,100,13,158,159,29,145,161,28,172,187,45,
  185,130,48,186,123,47,173,160,44,148,184,52,71,92,38,98,205,90,
  75,206,111,70,195,85,13,155,48,5,147,102,3,145,90,7,121,79,
  32,145,18,95,145,3,116,145,3,81,145,3,35,145,13,6,131,114,
  3,130,123,3,123,145,3,124,145,3,119,145,3,116,145,3,79,145,
  3,63,145,3,64,145,3,71,145,3,91,145,3,141,144,3,141,144,
  3,105,145,11,79,145,7,90,145,3,135,111,3,144,116,3,138,135,
  3,95,145,13,41,145,4,94,145,3,133,139,4,138,110,10,31,168,
  10,31,168,9,111,94,3,82,145,3,56,145,3,90,145,3,108,145,
  3,110,145,3,97,145,3,74,145,3,115,145,3,141,114,3,144,102,
  3,145,86,3,145,82,8,145,55,8,145,29,11,145,26,39,145,9,
  41,145,11,10,145,65,3,144,112,3,144,133,3,135,140,3,143,124,
  3,143,74,3,145,61,3,145,62,7,145,72,16,145,49,3,145,46,
  94,143,3,91,140,3,90,144,3,79,145,3,50,145,18,122,109,10,
  145,44,12,83,43,3,123,61,3,145,56,3,145,108,3,145,90,3,
  97,73,3,95,82,3,145,113,3,133,142,3,126,145,3,136,149,9,
  70,149,29,82,148,32,76,156,23,42,157,33,17,81,47,21,163,105,
  19,161,90,10,151,106,3,143,98,3,145,117,3,145,125,3,145,107,
  20,145,40,84,145,3,78,145,3,34,145,24,3,144,67,3,125,138,
  3,122,145,3,117,145,3,124,145,3,136,145,3,98,145,3,74,145,
  3,91,145,3,71,145,3,67,145,3,77,145,3,121,145,3,129,145,
  3,78,145,12,30,145,11,37,145,6,103,135,3,139,128,3,119,142,
  3,95,145,3,76,145,3,117,145,3,136,138,5,144,111,10,31,168,
  10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,
  10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,
  10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,
  10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,
  10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,
  10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,
  10,31,168,10,31,150,10,31,168,10,31,168,10,31,168,10,31,168,
  10,31,109,6,16,78,8,18,80,10,21,83,10,22,85,10,24,86,
  10,27,90,10,31,94,10,31,168,10,31,168,10,31,151,10,31,168,
  10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,
  10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,
  10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,
  10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,
  10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,
  10,31,168,10,31,168,10,31,168,10,31,168,10,31,168,10,31,168
} ;

  /** NIH 2012 new logo **/

static unsigned char nih2012_rgb[] = {
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,
 13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,
 170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,
 13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,
 170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,
 13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,
 170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,
 13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,
 170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,
 13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,
 170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,
 13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,
 170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,
 13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,
 170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,
 13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,
 170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,
 13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,
 170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,
 13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,
 170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,
 13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,13,232,28,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,
 13,43,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,
 13,43,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,13,232,28,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,
 13,43,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,
 170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 13,232,28,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,
 170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,
 170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,
 207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,154,11,237,154,11,
 237,154,11,237,154,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,
 237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,
 13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,
 170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,
 207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,154,11,237,154,11,237,154,11,
 237,154,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,
 237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,
 13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,
 170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,207,247,7,
 207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,154,11,237,154,11,237,154,11,237,154,11,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,
 13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,
 170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,207,247,7,207,247,7,
 207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,
 207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,154,11,237,154,11,237,154,11,237,154,11,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,
 13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,
 170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,207,247,7,207,247,7,207,247,7,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,
 207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,154,11,237,154,11,237,154,11,237,154,11,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,
 13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,
 170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,207,247,7,207,247,7,207,247,7,207,247,7,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,154,11,237,154,11,237,154,11,237,154,11,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,232,28,
 13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,
 170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,207,247,7,207,247,7,207,247,7,207,247,7,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,154,11,237,154,11,237,154,11,237,154,11,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,43,232,
 13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,170,13,232,
 53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,237,154,11,237,154,11,237,154,11,237,154,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,232,28,13,43,232,
 13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,53,53,53,
 53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,237,154,11,237,154,11,237,154,11,237,154,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,
 237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,43,232,13,43,232,
 13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,
 53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,237,154,11,237,154,11,237,154,11,237,154,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,
 237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,232,28,13,43,232,13,43,232,
 13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,
 53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,237,154,11,237,154,11,237,154,11,237,154,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,
 237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,
 13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,
 207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 237,154,11,237,154,11,237,154,11,237,154,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,
 237,53,11,237,53,11,237,53,11,237,53,11,237,53,11,237,53,11,237,53,11,237,53,11,237,53,11,237,53,11,237,53,11,237,53,11,237,53,11,
 237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,
 13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,
 207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,154,11,
 237,154,11,237,154,11,237,154,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,237,53,11,
 237,53,11,237,53,11,237,53,11,237,53,11,237,53,11,237,53,11,237,53,11,237,53,11,237,53,11,237,53,11,237,53,11,237,53,11,237,53,11,
 237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,
 13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,
 207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,154,11,237,154,11,
 237,154,11,237,154,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,237,53,11,237,53,11,
 237,53,11,237,53,11,237,53,11,237,53,11,237,53,11,237,53,11,237,53,11,237,53,11,237,53,11,237,53,11,237,53,11,237,53,11,237,53,11,
 237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,
 13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,154,11,237,154,11,237,154,11,
 237,154,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,
 237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,
 13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,
 207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,154,11,237,154,11,237,154,11,237,154,11,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,
 13,43,232,13,43,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,207,247,7,
 207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,154,11,237,154,11,237,154,11,237,154,11,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,13,232,28,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,
 13,43,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,
 207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,154,11,237,154,11,237,154,11,237,154,11,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,
 170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,154,11,237,154,11,237,154,11,237,154,11,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,
 13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,
 170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,207,247,7,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,154,11,237,154,11,237,154,11,237,154,11,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,43,232,
 13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,170,13,232,
 53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,207,247,7,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,237,154,11,237,154,11,237,154,11,237,154,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,232,28,13,43,232,13,43,232,
 13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,
 53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,237,154,11,237,154,11,237,154,11,237,154,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,
 237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,
 13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,
 53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,237,154,11,237,154,11,237,154,11,237,154,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,
 237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,
 13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,
 53,53,53,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,237,154,11,237,154,11,237,154,11,237,154,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,
 237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,
 13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,
 207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 237,154,11,237,154,11,237,154,11,237,154,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,13,232,28,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,
 13,43,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,207,247,7,
 207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,207,247,7,207,247,7,207,247,7,207,247,7,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,154,11,
 237,154,11,237,154,11,237,154,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,237,53,11,237,53,11,237,53,11,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,237,53,11,
 237,53,11,237,53,11,237,53,11,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 13,232,28,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,
 170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,
 13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,
 170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,232,28,
 13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,
 170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,43,232,13,43,232,
 13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,
 170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,
 13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,
 170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,
 13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,
 170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,
 13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,
 170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,
 13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,13,232,28,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,
 170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,
 13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,
 170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,
 13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,
 170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,232,28,13,43,232,
 13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,170,13,232,
 170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,
 13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,
 170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,
 13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,
 170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,
 13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,
 170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,13,232,28,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,
 13,43,232,13,43,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,
 170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,
 170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,
 170,13,232,170,13,232,170,13,232,170,13,232,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
 13,232,28,13,232,28,13,232,28,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,13,43,232,170,13,232,170,13,232,
 170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,170,13,232,
 170,13,232,170,13,232,170,13,232,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
} ;

/* 02 Sep 2008: Cox Sun logo */

#if 0
static unsigned char csun_rgb[] = {
  193,199,213,173,179,191,185,189,200,199,204,210,180,181,183,191,192,194,
  199,198,203,178,177,182,197,197,197,199,200,192,201,204,187,201,204,183,
  203,208,188,205,209,194,202,208,198,200,205,198,203,208,204,198,203,197,
  200,202,197,204,208,193,206,212,178,205,212,168,203,210,159,200,208,149,
  205,211,139,218,223,143,205,207,124,215,214,121,222,219,104,224,218,94,
  229,219,96,230,221,100,226,226,104,213,217,97,220,224,111,218,223,107,
  212,218,94,216,223,94,217,224,94,217,224,94,217,222,94,223,228,100,
  205,211,87,216,224,103,213,221,110,208,220,112,214,228,117,197,214,100,
  206,219,105,210,224,110,210,230,115,202,222,109,202,213,108,210,222,112,
  210,225,108,211,222,104,224,223,115,219,215,107,224,227,110,222,227,111,
  227,225,122,220,220,132,215,216,148,204,213,158,194,210,165,193,210,176,
  197,209,187,201,207,195,203,204,196,202,202,194,202,202,192,200,202,189,
  193,199,187,195,206,189,198,210,186,196,211,182,195,208,180,196,210,175,
  200,212,166,200,212,164,201,209,170,205,213,172,199,212,159,198,211,165,
  185,196,179,187,199,199,189,199,209,182,195,204,169,185,182,171,188,178,
  184,191,210,186,193,209,189,198,207,201,209,212,203,209,209,193,198,194,
  188,190,187,199,201,196,197,198,190,201,203,190,205,208,189,206,210,187,
  206,209,188,205,210,190,205,209,195,202,208,198,200,205,198,202,208,198,
  207,211,197,209,212,191,208,212,177,205,210,169,209,212,167,213,216,161,
  220,224,148,217,221,134,214,217,128,216,216,116,231,229,116,219,215,90,
  226,221,93,225,222,93,225,227,104,215,220,102,218,224,114,223,229,121,
  219,226,114,217,222,106,213,219,97,213,217,96,216,219,102,220,220,106,
  212,215,102,217,220,113,210,214,117,210,215,121,208,218,121,204,214,115,
  212,220,121,206,217,115,211,228,124,196,212,105,203,215,105,212,222,110,
  208,223,106,212,225,109,218,224,116,217,221,111,218,227,112,214,223,106,
  222,226,113,216,221,121,213,217,140,209,217,158,204,217,171,201,215,179,
  202,212,185,203,211,187,206,211,188,207,210,189,205,207,193,203,207,193,
  196,204,189,197,209,189,199,212,184,198,212,179,196,210,177,197,209,171,
  199,211,161,201,211,161,208,216,177,202,210,171,207,216,171,201,212,172,
  194,205,188,178,189,185,177,188,194,178,189,195,192,207,202,193,209,199,
  160,171,199,178,191,210,187,202,209,183,198,195,192,203,197,198,208,197,
  198,207,190,192,200,177,191,196,173,199,203,180,205,209,186,208,210,188,
  207,210,183,206,210,185,207,210,191,206,210,195,203,212,195,203,213,189,
  204,211,180,206,210,175,210,212,175,210,210,172,212,209,174,216,214,165,
  214,216,133,222,227,125,220,223,120,214,218,108,217,217,103,226,228,103,
  226,229,90,216,220,81,217,226,97,208,217,102,204,210,110,211,216,126,
  212,216,131,208,211,120,212,215,108,216,218,109,220,215,121,218,213,122,
  225,219,131,226,219,138,218,211,143,217,212,148,207,204,135,213,213,143,
  214,213,146,201,205,131,211,219,134,195,205,108,215,223,111,219,228,111,
  204,218,104,203,220,108,198,214,105,209,227,117,212,232,121,198,217,99,
  209,225,93,221,233,109,215,224,131,204,211,143,209,215,167,205,211,173,
  203,210,168,203,212,165,203,216,162,204,216,170,201,211,187,196,207,191,
  197,209,189,198,211,185,200,214,179,202,214,176,201,212,172,201,210,165,
  201,212,156,203,212,157,206,213,172,200,207,174,207,214,180,202,211,182,
  209,216,200,203,210,203,190,199,198,186,194,196,175,186,180,177,189,179,
  143,159,184,149,166,184,160,177,184,176,192,191,201,217,207,199,213,196,
  197,209,185,202,213,183,192,202,168,198,205,172,204,208,181,206,210,183,
  206,209,180,204,208,181,206,208,187,206,209,190,205,213,192,203,212,185,
  201,207,171,201,207,161,210,212,163,216,214,165,216,212,167,216,214,155,
  219,223,129,217,224,112,217,221,108,222,226,113,212,216,105,219,223,103,
  212,218,82,215,222,84,204,210,84,205,209,96,200,202,103,208,208,120,
  211,209,132,203,200,119,205,203,103,205,201,101,193,186,98,197,186,104,
  206,199,111,214,206,123,210,201,132,210,202,139,201,196,132,212,208,145,
  216,210,150,209,206,139,213,216,135,203,208,114,220,223,116,216,220,107,
  200,210,97,197,214,102,197,218,113,185,210,108,190,215,111,198,223,106,
  208,228,94,212,229,99,208,220,118,206,215,136,210,213,158,208,212,161,
  206,215,150,207,219,147,206,222,149,206,221,162,201,215,182,198,210,190,
  198,210,186,197,210,180,200,212,174,203,214,172,205,213,174,202,211,168,
  203,211,162,206,213,169,208,213,181,205,209,186,203,207,190,200,204,189,
  198,202,188,198,204,192,174,179,172,172,179,171,178,186,173,182,190,177,
  172,192,201,140,159,166,150,167,175,176,191,194,184,200,190,185,199,182,
  201,213,189,203,214,184,201,211,176,204,212,173,205,213,174,205,212,178,
  206,210,183,203,208,186,203,206,185,203,208,188,201,205,188,205,209,186,
  206,210,175,208,212,161,214,217,150,217,220,143,218,218,144,217,219,135,
  221,227,119,207,216,97,213,220,104,212,219,107,219,224,121,213,216,111,
  216,220,100,217,219,94,208,203,85,212,205,91,204,197,90,207,199,100,
  211,201,112,212,202,113,220,212,111,223,214,111,224,213,121,227,217,122,
  224,218,108,231,227,117,226,222,122,217,213,122,209,208,126,217,215,138,
  221,213,138,226,219,138,218,217,124,214,214,116,218,215,122,209,206,109,
  205,208,95,206,216,104,207,227,132,177,202,111,177,201,105,189,212,106,
  194,214,93,202,222,101,207,224,118,206,221,130,206,213,143,208,216,141,
  208,222,125,210,226,127,210,224,147,206,219,163,202,214,176,199,210,180,
  199,210,178,198,209,175,200,211,171,202,213,171,204,211,177,203,208,176,
  204,208,183,206,209,188,204,206,192,200,201,193,206,206,206,210,210,210,
  205,206,198,201,205,190,187,192,172,204,209,187,199,204,182,201,209,186,
  188,207,205,185,203,203,172,187,192,163,177,180,179,192,185,187,200,183,
  192,204,182,202,213,183,202,214,178,202,213,173,201,212,172,202,212,177,
  202,210,186,202,210,189,201,209,188,203,208,186,204,208,185,205,208,179,
  210,212,172,213,217,156,215,221,133,217,225,124,212,220,121,201,209,108,
  211,220,113,206,216,104,202,211,102,203,210,107,212,216,122,215,217,120,
  216,215,107,211,208,93,208,198,85,217,206,91,222,211,93,228,217,101,
  230,219,113,231,220,115,234,223,115,231,219,111,227,214,109,230,218,106,
  217,210,80,227,223,87,226,223,94,216,213,96,216,214,113,222,218,121,
  222,214,113,228,221,114,216,214,101,222,222,112,225,221,124,219,213,115,
  221,215,103,215,215,103,194,208,111,184,203,111,195,212,116,204,221,117,
  202,219,104,212,231,115,199,221,113,177,197,100,201,214,132,205,218,128,
  208,227,111,210,229,114,209,223,136,206,218,152,203,213,161,200,211,168,
  201,212,170,200,211,171,199,209,172,202,209,175,202,208,180,202,207,185,
  203,205,191,202,205,194,205,206,198,202,203,198,210,209,214,203,203,203,
  206,208,195,201,205,182,200,204,177,208,213,183,201,205,178,201,207,181,
  192,203,195,194,205,199,193,203,202,197,206,205,197,206,203,200,210,199,
  201,210,189,202,213,183,200,212,176,198,210,174,197,208,176,199,209,182,
  197,209,185,197,209,187,195,208,188,199,209,184,210,214,179,207,208,164,
  210,213,160,212,218,144,209,222,114,212,228,104,205,222,107,187,202,97,
  206,220,125,204,217,127,192,201,112,210,214,129,209,208,125,206,202,113,
  204,199,95,215,207,96,232,220,112,227,216,100,231,222,91,230,224,88,
  228,221,91,231,223,98,233,222,104,233,221,103,236,222,99,238,226,92,
  223,213,63,231,222,65,229,222,69,220,213,71,218,209,88,223,214,93,
  223,216,76,222,217,73,219,220,82,223,224,94,232,232,112,231,225,111,
  234,220,111,225,214,106,219,223,110,205,215,102,207,210,105,213,216,109,
  206,215,96,204,219,100,191,214,110,191,217,120,198,222,128,201,223,122,
  204,228,108,207,228,107,208,225,119,209,222,134,209,219,148,210,218,159,
  206,215,160,206,213,169,203,210,179,202,207,185,203,207,190,202,208,194,
  203,207,193,200,206,192,204,208,194,203,207,193,206,209,200,199,201,188,
  205,209,184,209,213,180,213,217,182,206,210,177,208,211,182,207,211,184,
  197,203,193,198,205,197,198,203,197,204,211,204,201,206,200,203,211,198,
  200,208,184,200,211,179,203,214,180,201,212,180,200,210,186,198,210,188,
  196,208,184,192,206,180,191,206,177,195,207,169,208,215,161,206,211,145,
  213,219,147,212,222,133,200,218,96,204,225,94,208,227,109,193,212,107,
  187,202,117,203,216,137,204,211,133,203,206,127,213,210,131,209,202,114,
  225,217,110,230,221,104,230,220,109,218,209,90,226,220,80,228,227,77,
  226,224,79,232,226,88,232,223,94,233,223,92,231,219,81,234,222,74,
  224,214,55,230,220,60,232,222,65,226,215,71,218,208,77,224,214,82,
  224,219,65,221,218,61,230,232,89,221,223,90,225,226,98,224,220,97,
  237,221,108,237,222,107,223,223,99,227,229,104,223,217,103,215,212,99,
  210,214,94,208,218,103,193,211,109,200,224,126,193,219,118,193,221,111,
  196,221,101,198,222,98,201,221,106,205,222,118,208,222,134,210,221,143,
  208,218,145,209,217,158,206,212,174,204,208,183,204,209,187,205,213,192,
  204,211,193,202,209,191,201,208,190,199,206,188,199,204,184,207,213,187,
  200,206,172,205,209,172,208,212,175,208,212,177,207,210,181,207,210,183,
  195,198,191,202,208,198,203,206,195,199,205,191,207,211,196,204,212,189,
  202,209,178,202,212,178,198,207,176,197,207,180,201,210,191,198,210,190,
  194,207,177,198,213,174,202,218,171,200,216,154,205,218,138,212,223,131,
  209,220,124,207,223,116,205,224,99,200,220,95,199,216,110,209,224,133,
  202,215,135,197,208,132,217,222,142,215,217,134,223,217,139,229,220,129,
  223,214,95,232,223,94,226,220,100,221,217,91,224,223,79,230,231,78,
  225,225,75,229,229,81,225,222,79,230,225,81,233,226,75,235,226,71,
  236,225,73,228,216,70,228,214,81,237,224,96,229,218,92,229,221,88,
  226,222,73,227,225,80,223,222,96,224,223,107,221,222,103,230,226,103,
  238,224,99,237,224,94,229,226,97,225,224,97,233,225,100,227,218,97,
  220,217,102,207,211,101,204,215,113,198,215,113,188,211,103,194,221,106,
  192,220,101,179,207,88,193,220,105,192,218,108,192,213,108,203,221,121,
  213,228,133,209,221,139,209,215,155,200,206,160,204,211,169,203,211,174,
  204,213,182,200,210,183,198,207,186,200,210,186,200,210,176,202,210,171,
  204,212,171,208,215,174,208,214,178,204,210,176,206,210,183,203,207,182,
  195,202,186,201,208,192,201,208,192,199,206,188,202,210,187,204,210,184,
  203,209,181,206,212,184,208,214,188,197,205,181,195,203,180,197,206,177,
  201,212,170,207,220,164,207,223,152,200,219,130,208,226,124,197,215,105,
  203,220,106,201,219,101,198,216,94,198,213,96,208,220,120,204,213,122,
  210,218,132,211,217,129,217,221,126,225,225,129,224,218,130,228,220,122,
  226,218,94,232,224,91,224,218,94,227,223,97,221,220,78,226,229,78,
  228,231,82,223,223,75,231,230,80,223,219,68,233,228,74,228,221,70,
  230,219,75,235,222,91,220,205,90,233,220,108,231,219,97,233,225,92,
  228,223,80,227,223,90,228,221,114,226,221,121,227,225,112,226,222,97,
  233,224,87,232,223,84,226,226,94,222,223,95,230,222,95,231,223,99,
  227,224,109,222,222,110,209,212,99,210,218,106,202,216,102,204,223,107,
  176,201,81,177,206,87,183,216,101,169,202,89,180,211,94,206,233,120,
  207,226,119,201,215,120,203,211,134,209,214,150,210,218,159,203,211,160,
  199,210,170,200,211,179,205,215,191,203,213,186,201,212,172,200,212,166,
  203,211,170,204,212,175,203,210,179,200,206,180,185,188,167,181,186,166,
  193,207,172,197,210,180,202,212,188,201,210,189,200,210,186,201,209,186,
  204,209,189,206,210,193,200,205,185,205,209,182,207,213,175,206,213,162,
  205,214,151,211,222,143,210,225,124,200,219,104,203,226,109,202,226,106,
  194,214,93,196,214,94,193,206,90,204,212,103,205,207,108,213,213,115,
  218,220,113,223,223,109,223,223,101,227,225,106,229,222,118,225,216,111,
  230,224,100,231,224,94,229,220,99,225,217,93,235,231,97,222,221,81,
  226,225,85,226,225,81,220,219,67,224,221,68,228,222,76,234,227,85,
  227,217,83,229,219,98,220,205,110,226,213,117,217,207,92,231,224,94,
  221,217,83,225,219,97,225,211,122,232,217,132,230,224,114,227,224,93,
  229,227,82,227,227,79,224,227,94,225,230,104,220,220,96,228,226,103,
  228,226,105,227,223,98,217,213,79,220,216,83,217,216,98,192,199,85,
  181,200,75,193,221,98,167,201,88,170,210,96,193,233,111,182,217,97,
  194,220,111,203,221,122,209,219,132,213,220,140,210,216,144,206,214,154,
  203,212,167,203,213,178,195,205,178,192,203,171,192,205,161,194,207,161,
  199,209,174,200,209,182,201,209,188,201,208,192,192,195,184,185,191,181,
  192,209,164,194,211,169,199,212,182,201,213,189,201,210,191,200,209,192,
  201,207,195,201,205,191,203,206,185,206,212,176,212,216,165,212,219,151,
  212,220,135,212,223,121,207,220,104,199,215,90,193,215,91,199,221,97,
  204,222,100,198,211,93,215,222,110,213,212,106,221,216,112,230,223,116,
  225,218,101,227,222,94,227,224,85,221,217,83,226,219,103,224,216,105,
  230,224,100,226,218,93,230,219,103,233,222,106,226,217,96,224,216,91,
  229,224,96,224,217,84,223,216,73,220,212,69,217,204,73,231,216,91,
  225,207,83,233,213,101,214,190,104,228,206,121,219,201,93,227,213,91,
  218,207,83,218,201,93,213,188,106,234,211,131,229,215,108,231,223,98,
  227,225,90,226,228,93,219,221,98,225,228,111,215,216,99,223,224,104,
  224,222,99,227,222,92,239,228,86,232,219,79,220,210,87,210,207,90,
  204,214,91,196,218,94,180,213,98,180,218,105,172,212,97,167,206,91,
  190,219,109,201,224,118,205,222,120,209,220,126,204,213,130,207,217,148,
  205,213,162,204,212,171,200,210,173,196,208,168,197,211,162,200,214,165,
  201,211,174,198,207,178,198,206,183,200,207,191,190,196,184,186,192,182,
  193,211,159,192,210,162,195,211,172,199,212,186,200,208,197,199,205,201,
  200,205,198,199,203,188,208,213,181,206,214,165,211,218,150,215,225,138,
  212,223,118,202,215,97,202,213,93,206,220,97,174,192,72,180,195,76,
  191,202,82,213,218,102,208,206,97,225,217,108,229,218,103,229,217,97,
  230,219,95,235,225,93,225,216,75,223,215,78,214,204,81,234,225,106,
  223,215,91,221,212,91,224,212,100,236,222,117,227,214,110,228,216,108,
  230,217,102,226,212,90,223,208,81,233,213,90,209,182,75,237,206,100,
  226,193,77,222,186,76,216,176,91,227,186,104,216,178,77,221,187,79,
  230,202,95,205,175,77,201,165,81,238,202,118,231,206,103,224,208,97,
  227,219,112,226,221,117,226,218,120,219,211,113,220,217,110,223,224,107,
  224,222,101,229,222,92,243,227,90,233,215,77,228,214,81,220,212,85,
  212,213,93,209,220,102,205,228,112,169,198,88,155,187,90,185,219,122,
  182,216,106,183,214,97,186,213,96,201,223,114,204,219,128,205,215,142,
  201,209,150,204,213,160,207,217,164,203,216,160,203,216,162,204,216,166,
  200,211,168,195,205,168,194,206,170,198,209,177,205,215,188,203,213,188,
  199,215,170,197,212,169,196,210,174,197,210,184,201,209,198,200,207,200,
  200,206,194,201,209,185,203,212,169,208,218,155,207,219,137,203,217,119,
  206,220,107,204,219,100,198,212,98,196,208,98,198,207,100,193,199,91,
  202,205,90,208,207,89,227,217,102,228,216,98,236,222,97,234,220,89,
  236,221,92,228,214,83,234,222,86,210,197,66,225,213,91,224,212,94,
  231,221,100,224,209,90,225,205,93,223,200,98,214,189,97,210,185,92,
  224,200,92,237,212,96,218,189,72,229,195,87,214,174,79,216,172,77,
  236,188,77,203,153,42,224,170,80,205,151,65,230,176,78,208,159,56,
  246,204,106,199,156,62,199,149,60,239,192,102,228,192,96,215,189,94,
  230,214,127,224,209,124,225,203,117,207,187,92,228,217,109,226,221,104,
  227,222,104,229,221,96,228,211,79,228,210,74,222,208,75,226,217,88,
  227,223,100,217,218,98,199,208,89,188,205,93,200,221,130,175,201,110,
  167,200,93,171,209,90,181,217,93,194,225,106,198,220,120,201,217,129,
  205,214,135,209,217,140,205,217,141,202,215,145,202,213,157,201,213,165,
  198,209,166,195,206,164,197,209,169,203,214,180,200,210,183,200,210,185,
  203,212,185,204,212,188,201,209,186,200,207,189,204,211,195,202,209,191,
  200,208,184,205,215,178,206,219,163,207,221,144,193,210,114,183,202,95,
  192,211,103,200,219,114,192,210,111,184,194,105,215,213,130,216,209,118,
  204,198,88,214,205,84,225,214,90,230,217,86,224,211,70,236,221,80,
  233,219,88,235,220,93,217,201,79,225,208,90,213,196,88,226,209,101,
  225,208,94,232,210,91,233,198,82,229,188,82,185,140,55,185,140,55,
  221,180,72,235,194,78,226,182,73,211,162,60,225,170,80,187,128,34,
  233,176,63,214,155,39,222,160,57,197,135,36,251,188,85,200,141,37,
  246,190,93,202,146,51,197,138,38,237,181,86,206,158,74,219,182,104,
  235,211,137,211,188,110,199,163,69,212,178,70,232,211,92,231,219,97,
  227,217,102,224,215,98,220,205,78,225,210,81,230,220,97,227,219,95,
  224,215,86,231,224,92,222,217,91,206,205,89,204,212,111,183,201,102,
  167,198,94,169,209,95,172,218,96,173,214,94,183,215,106,194,217,109,
  207,222,105,208,221,107,208,223,122,206,219,137,206,215,160,205,213,172,
  201,212,170,198,209,169,198,210,174,201,211,184,199,207,192,200,208,197,
  202,206,192,206,210,196,203,207,193,202,206,189,204,212,189,199,210,178,
  196,208,168,204,217,161,210,224,147,207,222,129,195,212,106,183,199,90,
  173,188,83,169,181,83,184,192,106,214,216,133,216,205,126,209,193,105,
  214,201,89,226,212,87,231,217,86,228,215,75,231,220,70,229,219,70,
  236,226,92,234,220,97,220,203,85,221,201,89,223,200,96,211,186,83,
  227,203,95,230,200,86,233,194,73,238,192,81,215,163,77,187,131,46,
  210,156,48,229,173,60,231,174,69,238,180,83,221,164,74,209,151,54,
  217,155,42,225,163,44,227,164,50,207,143,33,218,150,43,207,140,36,
  233,170,67,207,146,40,191,128,22,231,171,73,178,122,45,230,181,112,
  246,207,130,204,168,82,184,140,41,236,198,87,239,215,91,239,221,97,
  226,208,100,214,195,90,217,198,78,217,198,77,226,211,94,231,219,99,
  232,220,86,228,216,78,221,211,79,225,219,97,210,206,106,198,205,110,
  188,213,111,163,200,94,148,196,84,150,199,84,172,212,100,181,214,97,
  196,218,91,200,216,91,201,214,109,202,212,126,203,212,149,204,212,163,
  202,214,168,200,212,172,197,208,174,196,206,179,199,207,192,201,209,198,
  199,204,198,202,207,200,203,207,193,200,205,185,197,207,180,198,213,172,
  199,217,159,199,218,137,203,220,116,214,227,113,214,222,113,208,214,108,
  202,205,102,203,200,103,212,202,115,216,201,116,220,203,111,224,205,102,
  224,205,85,231,212,83,232,213,82,222,209,69,222,217,65,227,226,74,
  227,225,90,230,222,97,230,216,94,221,200,83,206,178,69,223,190,85,
  216,178,77,216,179,72,223,191,70,230,193,76,229,179,82,189,128,35,
  221,152,48,215,144,36,225,157,58,246,186,90,227,177,78,213,166,62,
  204,148,37,234,175,57,224,169,42,230,170,46,223,152,46,217,144,41,
  220,157,41,215,159,38,183,130,16,217,163,63,166,109,32,248,189,113,
  251,191,93,199,147,38,207,164,60,243,213,103,232,212,91,229,208,89,
  218,185,88,217,182,88,220,189,83,229,202,89,240,213,100,233,208,89,
  228,208,73,228,215,74,216,210,70,226,222,97,228,217,125,213,208,124,
  186,197,101,165,193,93,154,200,102,148,200,100,148,197,90,162,204,92,
  183,213,99,195,214,107,206,214,128,209,213,136,208,217,138,204,216,144,
  198,211,155,195,208,164,193,207,171,195,209,176,195,205,178,198,208,183,
  196,206,198,200,208,197,206,210,196,205,210,187,195,207,169,189,206,151,
  193,216,138,205,227,129,208,225,110,205,216,98,205,208,105,204,201,104,
  208,205,102,215,206,105,215,199,104,225,205,108,228,209,104,234,217,99,
  228,209,78,223,205,67,226,208,72,221,208,70,220,213,73,225,221,87,
  229,223,101,231,222,105,226,210,89,236,211,93,222,188,78,219,178,73,
  227,181,85,203,158,57,217,180,65,232,193,74,244,196,86,206,148,41,
  215,147,36,213,141,31,231,163,62,216,158,59,230,187,82,223,182,74,
  208,156,46,216,164,44,226,183,45,242,193,62,231,167,59,216,149,45,
  218,161,45,223,173,52,218,171,53,237,190,84,196,146,59,239,185,97,
  245,185,75,197,142,26,234,193,87,244,213,107,223,191,80,219,182,76,
  198,153,62,198,152,66,225,189,93,239,206,103,239,203,93,227,195,76,
  219,197,62,224,213,69,227,222,76,225,222,89,226,215,110,225,216,123,
  208,208,108,197,213,114,152,184,99,137,180,98,153,198,107,154,195,99,
  161,196,96,195,217,119,211,220,129,213,218,126,209,220,118,206,220,125,
  205,218,148,202,215,162,199,211,171,197,208,174,199,210,176,202,213,179,
  191,208,189,193,206,188,200,207,191,204,213,184,202,216,165,193,215,140,
  188,215,118,191,217,108,193,211,99,195,204,99,206,206,118,203,199,112,
  209,205,105,217,211,101,213,201,89,226,214,96,230,216,94,228,215,84,
  228,216,72,224,213,63,214,202,56,220,206,73,229,212,104,217,198,103,
  226,207,112,229,210,108,242,219,103,235,206,88,220,179,71,216,168,66,
  221,165,70,219,161,64,230,177,71,212,165,51,234,190,67,241,196,69,
  200,144,21,213,154,36,215,161,52,219,172,66,207,169,62,223,185,74,
  201,151,38,208,160,36,223,192,50,232,200,63,233,185,74,193,139,39,
  217,169,67,225,181,74,206,164,46,227,188,69,212,180,71,233,199,91,
  220,178,66,205,162,50,239,202,96,232,190,92,216,155,66,190,124,37,
  204,147,58,213,166,76,230,193,105,237,202,110,211,172,67,219,187,68,
  220,202,68,222,216,70,232,228,77,226,224,77,223,216,84,228,219,98,
  225,220,100,207,205,102,181,189,116,184,202,142,160,190,126,160,193,122,
  186,217,137,200,224,128,208,223,104,211,222,92,207,222,93,207,221,107,
  206,218,132,206,216,153,205,214,171,205,212,178,201,208,174,201,211,176,
  196,214,190,197,211,188,202,206,189,205,210,178,209,221,159,204,224,135,
  190,216,109,180,204,90,185,198,92,199,203,106,212,207,123,205,198,110,
  211,204,97,220,214,92,219,210,83,228,218,87,233,220,90,230,218,84,
  227,216,72,234,223,79,228,216,78,210,194,72,214,191,95,231,205,121,
  213,186,105,222,195,104,216,189,76,224,191,75,229,185,78,216,162,64,
  220,154,67,234,167,80,211,148,51,215,163,53,209,172,42,222,188,54,
  224,181,51,221,177,56,219,176,71,207,168,65,222,190,81,218,182,72,
  211,163,55,225,183,65,232,210,72,224,206,72,216,178,77,201,158,66,
  228,190,93,221,184,78,218,178,65,240,205,87,214,189,70,213,191,71,
  218,187,70,221,188,73,237,205,94,225,182,78,195,128,39,201,130,42,
  227,172,72,235,187,87,235,189,101,196,151,60,207,164,59,220,187,71,
  223,205,81,226,218,83,228,222,72,227,222,68,225,218,68,232,223,82,
  232,220,86,232,220,108,208,197,117,199,198,134,180,194,133,190,215,149,
  190,219,139,176,203,100,191,212,75,204,220,69,213,229,81,215,231,99,
  213,223,124,209,217,140,206,211,153,203,209,163,204,211,167,204,213,170,
  192,206,189,198,207,190,206,204,189,210,207,172,211,217,145,211,223,125,
  206,222,113,203,217,106,205,207,106,211,205,111,210,196,107,210,194,96,
  221,207,85,228,216,82,230,217,77,228,215,77,230,215,88,219,205,80,
  224,214,83,236,225,99,228,213,98,220,202,94,222,197,96,206,177,83,
  218,185,104,220,186,99,221,189,80,234,197,82,225,176,73,203,142,51,
  194,118,43,228,152,77,223,157,70,216,167,62,230,203,74,224,202,65,
  220,191,61,240,207,92,237,203,113,213,181,94,226,202,94,250,220,110,
  209,165,68,219,180,77,231,218,88,227,217,96,232,199,122,214,174,102,
  241,212,108,229,202,87,227,193,93,226,193,90,231,209,89,215,194,67,
  223,198,72,231,206,80,224,196,71,228,192,72,217,161,52,228,172,63,
  228,188,66,232,190,70,204,142,41,208,145,48,226,178,70,221,187,79,
  216,197,94,229,218,102,228,217,75,233,220,62,233,219,61,243,226,76,
  234,217,77,237,217,92,219,198,91,211,196,103,199,198,116,197,210,128,
  177,203,106,181,210,92,194,218,70,204,224,64,212,229,71,214,227,87,
  212,220,108,212,217,125,212,217,135,210,216,144,206,215,152,204,214,154,
  189,203,186,190,202,182,204,204,180,214,211,166,214,218,133,207,216,109,
  203,217,104,211,221,109,214,215,113,213,203,106,212,194,96,224,203,96,
  231,213,87,229,213,76,231,216,75,228,212,77,205,189,67,219,204,85,
  218,204,81,216,201,82,225,206,101,232,208,108,234,205,101,230,196,96,
  213,176,87,195,158,67,210,176,66,219,180,63,219,171,61,241,181,83,
  216,141,60,226,153,76,228,171,84,234,195,92,228,210,82,241,229,93,
  234,215,84,234,211,95,237,212,122,219,195,109,235,217,109,233,211,100,
  192,156,62,205,171,74,233,223,100,220,210,97,200,165,97,227,188,121,
  237,213,103,226,206,85,236,211,108,231,207,99,217,199,71,217,201,64,
  235,216,88,232,208,84,221,192,66,236,198,73,225,176,57,229,180,59,
  224,190,57,208,167,39,222,154,45,226,157,56,209,162,58,212,183,81,
  223,200,107,233,216,112,232,216,79,237,222,69,237,217,66,234,214,67,
  217,198,59,204,185,54,215,195,72,223,206,98,193,186,96,185,191,103,
  180,206,99,189,220,93,195,221,72,201,223,63,205,222,64,207,219,73,
  213,219,95,218,221,116,220,223,132,218,223,143,207,214,147,203,213,153,
  191,213,190,194,210,181,204,210,172,213,218,154,208,219,117,197,211,90,
  187,205,87,192,205,91,208,210,101,204,197,91,216,202,95,231,214,100,
  231,215,93,227,214,84,226,214,80,228,215,87,233,215,103,232,214,104,
  233,217,95,234,215,94,214,190,82,201,169,68,218,183,79,241,202,97,
  230,191,88,236,198,91,229,192,75,221,183,60,212,168,45,225,172,56,
  223,158,54,200,140,44,226,187,94,207,185,83,228,220,95,227,223,87,
  237,225,89,237,222,97,234,215,113,184,168,72,224,213,105,237,225,117,
  205,179,84,210,182,85,230,218,100,208,192,81,199,159,87,210,168,94,
  238,216,104,233,223,92,227,217,94,231,224,94,229,225,76,236,230,84,
  220,208,86,218,195,83,240,200,86,209,162,44,223,174,55,215,171,46,
  220,183,51,216,173,45,239,171,62,211,146,46,196,160,63,215,195,100,
  237,212,122,228,205,103,232,215,85,234,217,77,231,213,77,220,201,70,
  219,205,74,224,211,81,224,215,88,220,212,101,208,202,118,206,210,126,
  197,219,108,181,211,81,183,210,69,195,217,70,208,224,74,215,227,81,
  222,228,94,226,226,112,220,220,134,213,214,148,211,215,164,207,213,169,
  184,210,183,192,213,180,203,215,169,206,213,143,201,214,106,197,213,88,
  194,212,92,198,211,95,205,208,95,198,192,80,219,206,92,227,210,94,
  224,210,87,232,219,89,229,219,85,231,220,94,205,190,87,218,200,102,
  222,202,90,231,205,92,240,206,99,231,189,87,217,172,69,210,163,59,
  227,183,74,231,190,76,230,192,69,218,180,53,226,186,62,234,192,71,
  223,176,62,214,173,67,230,208,107,230,219,114,226,221,104,230,224,100,
  231,222,95,233,221,99,232,218,111,207,196,91,212,208,98,229,223,113,
  237,217,118,227,203,103,227,212,95,215,193,84,219,176,98,218,175,96,
  239,219,104,229,221,88,233,226,93,230,224,86,230,225,82,225,219,81,
  224,215,94,229,208,99,196,152,53,216,163,61,211,162,41,223,180,50,
  238,197,69,212,168,47,200,143,36,215,166,64,227,202,102,236,216,119,
  243,212,119,219,185,87,236,209,94,226,204,82,229,209,88,225,206,85,
  227,214,86,224,215,86,219,214,88,223,219,109,211,205,121,192,191,109,
  191,203,101,178,199,80,190,215,88,201,223,89,211,228,87,215,226,85,
  217,223,87,220,221,104,219,219,133,217,217,157,210,212,173,204,209,179,
  182,210,185,191,215,183,197,210,166,203,213,144,199,212,107,187,203,81,
  187,202,83,192,202,87,202,202,88,207,200,86,226,213,99,230,213,97,
  226,212,87,229,219,85,230,219,75,229,219,87,221,208,114,205,188,108,
  196,169,80,197,161,65,209,161,63,232,178,78,233,175,76,238,181,78,
  210,156,48,216,166,51,237,196,70,221,183,56,215,182,66,226,199,86,
  218,194,84,234,217,109,228,221,114,222,219,114,227,217,120,228,214,117,
  232,219,114,228,216,108,236,223,119,225,216,111,225,226,109,222,221,105,
  229,217,109,240,219,112,236,215,98,232,204,95,222,177,96,216,176,91,
  225,207,95,232,223,92,221,208,70,235,218,88,214,196,84,214,201,89,
  225,220,94,235,220,103,223,182,102,198,146,63,233,183,62,225,177,41,
  218,168,43,196,153,38,212,180,79,225,201,101,234,218,107,240,216,106,
  228,185,83,210,161,66,242,201,109,216,183,86,215,193,84,231,214,96,
  228,213,86,219,206,78,224,218,98,224,220,113,220,214,126,194,189,108,
  208,205,124,211,218,125,210,229,122,188,212,92,200,218,84,217,229,93,
  217,224,94,219,222,109,220,220,134,207,207,147,206,209,178,204,208,191,
  174,198,174,185,206,175,206,217,174,206,216,147,195,208,103,189,203,80,
  190,204,83,203,211,90,200,198,79,211,200,82,230,215,98,234,218,97,
  230,216,93,230,217,87,222,208,75,219,202,84,224,206,122,229,205,133,
  237,200,120,237,190,102,224,168,71,219,160,56,209,151,44,210,153,46,
  201,148,44,207,161,50,220,180,56,220,186,62,209,183,70,204,186,78,
  230,217,112,225,218,112,223,223,113,226,221,117,234,217,125,209,188,97,
  182,168,63,192,180,72,216,202,103,229,220,119,222,221,113,224,222,113,
  235,223,115,220,199,90,224,199,81,228,197,89,183,142,60,203,166,86,
  229,210,108,202,190,72,218,200,72,224,204,83,198,178,83,226,210,114,
  234,224,100,233,219,97,235,200,118,227,181,103,215,173,61,225,181,58,
  199,149,38,237,194,89,230,202,102,231,210,105,220,198,79,219,187,68,
  207,159,51,223,169,73,222,174,89,190,150,63,219,194,93,222,204,92,
  218,201,83,230,215,98,221,209,99,220,209,104,230,220,122,218,208,119,
  213,202,123,201,198,119,172,188,90,196,218,107,209,228,102,205,218,86,
  203,212,83,204,208,95,206,209,120,215,216,156,207,211,178,204,209,189,
  182,200,176,186,201,170,207,216,169,203,213,140,195,208,100,199,211,85,
  198,207,80,206,207,80,207,198,69,220,205,76,232,214,86,231,213,87,
  231,212,92,227,207,94,220,192,93,216,184,99,203,166,95,207,167,95,
  214,166,81,232,178,82,241,182,78,241,185,72,235,185,64,227,182,63,
  216,174,72,202,167,65,225,194,78,238,212,93,229,207,95,230,213,107,
  224,213,108,222,215,111,226,217,116,222,209,107,236,210,113,235,211,105,
  233,219,94,227,217,93,196,182,83,214,200,112,218,211,123,230,223,132,
  230,214,116,209,188,79,226,201,82,220,192,82,192,159,80,220,187,118,
  242,215,136,171,150,57,223,205,97,218,204,97,227,214,122,203,190,94,
  231,212,94,231,209,89,228,200,100,239,213,120,222,199,103,211,185,90,
  237,197,109,245,200,109,225,182,77,217,176,60,215,173,52,200,156,35,
  219,171,60,221,172,70,184,133,41,229,186,92,221,192,92,210,188,86,
  213,198,97,223,207,109,232,212,115,227,205,103,224,209,92,220,208,96,
  195,184,94,199,194,110,205,219,121,192,214,103,182,202,81,184,201,71,
  199,213,78,209,219,97,209,215,127,208,213,149,198,205,161,195,202,168,
  195,211,182,193,209,170,202,216,157,201,214,134,195,211,102,201,215,94,
  204,209,93,199,197,78,207,196,70,225,208,78,233,216,84,229,215,82,
  228,213,86,221,199,88,210,175,93,204,164,94,210,167,99,205,159,82,
  195,142,50,199,142,39,204,143,37,206,149,36,219,168,50,223,178,63,
  236,197,94,233,200,97,239,212,97,220,198,79,218,200,88,222,209,105,
  219,210,117,228,219,128,234,218,122,229,205,105,187,154,57,218,189,85,
  214,199,80,227,216,100,228,212,117,218,199,120,194,180,107,225,209,134,
  229,209,123,200,176,80,212,185,80,216,188,91,217,188,118,237,209,144,
  228,205,125,216,197,103,238,224,117,225,215,104,226,218,117,219,210,105,
  231,215,93,215,196,68,235,221,98,229,217,105,226,214,116,232,211,122,
  238,197,115,211,160,69,210,156,47,218,164,42,226,172,48,234,186,62,
  217,176,58,195,155,44,218,173,72,214,171,76,192,159,64,224,201,108,
  228,212,124,229,213,125,229,206,113,231,206,103,224,206,82,216,205,81,
  216,206,109,216,214,127,196,210,115,173,194,91,175,193,81,191,210,85,
  202,220,82,207,222,93,212,224,122,213,224,148,211,220,165,208,217,172,
  192,210,170,200,218,166,200,221,146,201,222,131,191,212,109,191,206,103,
  206,209,118,198,192,98,215,201,92,227,212,87,225,213,77,222,213,72,
  225,216,77,229,213,91,236,202,113,238,199,124,231,191,119,235,193,111,
  235,186,84,232,178,69,223,160,57,204,138,41,203,140,45,199,141,44,
  205,156,53,236,196,83,236,208,85,241,221,100,228,216,104,164,158,62,
  202,198,125,218,208,137,219,194,102,241,207,107,234,197,106,181,147,60,
  206,184,101,197,179,97,231,209,124,235,212,134,208,187,124,212,188,128,
  207,178,112,197,167,97,230,202,129,190,163,94,219,193,136,227,207,138,
  232,220,120,233,227,105,217,214,85,235,232,103,225,221,98,224,220,95,
  216,213,74,219,219,73,215,217,72,227,224,91,230,217,103,233,204,102,
  215,167,67,205,146,42,219,156,42,228,166,45,239,181,56,234,186,58,
  219,188,61,230,202,79,227,191,79,193,155,58,216,181,100,234,208,133,
  228,213,130,206,195,105,227,207,112,219,196,90,212,194,70,220,208,86,
  213,208,108,209,212,125,192,204,122,197,213,125,193,210,108,183,202,84,
  189,210,71,204,225,84,209,228,103,204,220,121,202,213,147,201,209,158,
  178,193,152,193,210,155,188,210,125,191,216,115,183,205,104,180,194,99,
  200,199,117,193,183,98,217,198,93,230,210,89,229,217,83,229,220,81,
  222,214,79,213,194,74,211,174,85,206,160,83,219,173,95,222,177,86,
  230,182,72,235,183,65,236,178,68,225,163,60,222,159,64,215,156,64,
  214,164,65,233,194,89,239,212,99,234,217,103,228,217,109,235,227,129,
  221,214,136,207,191,114,190,159,68,217,179,82,242,205,116,225,192,113,
  210,182,119,186,160,99,211,183,109,231,203,129,237,208,150,210,180,128,
  200,167,113,207,175,116,236,207,147,195,169,108,202,176,119,235,215,144,
  224,215,112,223,219,96,224,222,87,228,224,90,235,223,103,231,219,101,
  227,222,92,221,222,84,230,232,87,227,223,87,217,205,87,205,179,69,
  209,167,55,203,152,35,221,165,46,222,166,45,218,162,41,227,177,54,
  231,193,66,237,203,79,208,171,54,227,190,86,237,201,117,234,203,123,
  228,204,116,214,194,99,195,169,74,200,173,68,221,200,75,219,204,79,
  216,208,101,212,211,119,204,212,129,181,193,111,183,198,107,202,219,113,
  203,224,95,198,220,85,202,223,94,207,225,115,206,219,140,206,216,153,
  200,205,173,208,218,166,198,217,127,198,220,112,196,215,108,196,206,109,
  211,205,121,209,192,104,229,203,90,235,210,84,232,212,87,230,214,92,
  218,201,85,207,180,77,210,164,79,206,151,71,204,148,61,209,155,55,
  223,172,55,225,175,50,229,180,52,222,172,49,218,167,52,211,164,60,
  203,158,73,242,205,125,210,185,93,230,212,114,218,204,105,229,215,110,
  235,217,107,220,196,88,193,157,63,185,145,57,233,199,109,233,204,124,
  235,206,146,208,179,123,187,154,87,243,208,140,235,205,143,194,163,108,
  234,199,145,191,156,98,228,204,134,204,182,109,212,183,113,225,197,123,
  210,189,108,228,214,115,231,224,94,234,221,93,230,195,103,229,193,109,
  224,204,107,230,218,108,227,213,91,190,178,56,193,182,74,229,217,107,
  228,208,87,224,196,70,227,197,73,228,189,70,226,175,60,231,174,61,
  230,171,55,231,176,59,230,184,64,234,193,77,247,206,101,234,192,90,
  199,156,51,191,148,44,221,181,86,234,199,97,200,173,44,204,182,47,
  225,204,87,218,205,100,210,212,115,201,211,122,203,215,133,191,205,118,
  171,190,83,183,203,88,203,223,110,202,219,115,204,217,129,205,217,135,
  206,209,164,208,217,152,200,216,117,191,210,94,188,205,93,191,198,94,
  202,193,102,208,189,94,229,206,90,231,210,83,230,210,87,232,212,97,
  220,197,93,210,177,84,220,167,91,218,156,79,225,164,73,217,160,55,
  222,169,53,217,167,42,226,177,48,226,179,49,214,170,45,203,163,52,
  211,175,87,239,210,132,201,181,94,199,184,91,218,206,108,211,197,90,
  232,213,93,242,215,98,229,194,94,210,175,85,233,207,114,221,196,114,
  213,180,126,207,171,121,194,158,96,238,203,137,238,204,140,209,174,116,
  166,131,77,225,193,134,225,202,124,225,200,116,228,196,119,182,148,74,
  193,166,87,240,216,126,231,210,101,222,195,90,197,151,74,189,145,74,
  202,177,85,229,215,108,236,216,101,231,216,99,225,217,110,225,218,111,
  226,215,97,231,214,96,230,206,100,231,193,92,210,157,53,195,131,25,
  201,131,20,236,171,55,235,183,61,224,178,56,215,170,55,204,157,49,
  216,163,57,241,189,87,216,170,76,206,169,65,202,173,47,215,191,55,
  222,198,72,226,211,96,215,215,115,211,220,131,196,203,126,184,195,116,
  192,212,117,198,221,115,196,218,107,199,219,108,210,222,120,212,222,123,
  208,217,136,209,220,126,206,219,105,199,210,88,201,211,89,205,208,93,
  206,194,92,210,193,89,223,211,93,230,219,95,228,214,91,226,206,91,
  229,204,103,238,198,113,226,165,100,231,164,96,240,183,94,226,173,69,
  234,182,70,235,183,65,234,175,55,233,179,55,225,179,59,222,185,70,
  216,189,84,223,205,105,229,215,116,231,223,122,225,220,116,226,219,113,
  236,222,115,231,210,101,236,210,100,242,218,112,228,210,112,230,207,127,
  206,166,115,224,179,137,194,159,101,213,182,115,215,180,112,180,145,81,
  191,160,105,230,202,137,239,212,123,237,206,115,231,195,121,175,139,63,
  234,203,110,247,217,121,204,163,84,179,134,66,212,167,99,219,184,100,
  229,211,99,233,224,97,230,219,91,227,217,93,226,219,105,216,209,102,
  204,192,90,207,186,95,207,170,102,195,142,74,189,124,34,212,141,37,
  227,160,47,218,156,37,219,164,38,221,171,48,230,180,69,237,188,86,
  237,188,96,224,177,87,216,174,76,219,182,75,225,194,78,230,206,80,
  232,216,81,225,217,93,218,217,125,214,217,140,204,205,129,208,216,133,
  189,209,114,179,206,99,189,217,96,199,221,95,208,222,101,210,219,102,
  210,220,133,214,224,128,216,223,111,210,214,94,209,210,91,208,205,90,
  207,192,89,211,196,93,219,209,98,218,209,90,232,213,92,238,211,94,
  219,184,80,182,135,47,175,111,39,197,129,56,205,146,56,193,138,35,
  202,148,39,201,146,30,209,146,32,214,154,40,205,157,46,223,187,77,
  224,201,95,232,218,111,228,220,111,222,218,108,222,222,110,228,226,117,
  228,219,116,212,194,94,179,153,56,222,196,103,232,212,126,233,204,136,
  223,174,131,194,145,104,232,202,142,226,199,128,224,190,116,155,121,47,
  198,173,106,231,209,133,225,202,98,239,212,105,204,172,85,198,166,81,
  236,211,111,207,179,82,183,141,69,186,141,76,236,196,124,242,207,123,
  238,214,108,227,207,92,229,212,94,228,216,96,223,214,97,227,220,106,
  230,219,114,230,210,123,235,200,136,228,180,114,228,173,80,211,153,43,
  209,152,36,234,178,55,250,196,70,232,180,60,221,170,61,207,158,63,
  195,149,64,206,164,78,228,189,86,238,201,94,239,206,99,236,213,101,
  227,213,90,216,209,92,226,223,130,214,213,131,208,206,123,186,190,105,
  176,195,105,183,211,109,177,206,87,192,217,90,206,220,97,208,218,96,
  208,217,154,209,213,139,211,206,114,206,197,94,205,197,90,207,194,90,
  205,188,96,213,196,104,226,214,114,230,213,105,234,205,88,223,182,66,
  221,171,60,215,156,54,222,156,62,220,151,60,226,160,64,220,158,55,
  216,156,44,211,151,37,212,148,38,223,161,58,228,179,86,220,183,92,
  204,179,87,229,214,113,233,223,110,222,220,99,223,225,100,224,225,105,
  224,217,110,226,209,119,206,176,106,206,169,114,226,189,137,237,193,148,
  230,171,137,212,159,119,224,199,133,228,210,128,229,199,111,220,190,100,
  229,207,121,233,217,121,210,196,74,223,208,79,229,212,94,231,212,107,
  219,203,107,208,191,99,228,205,112,230,203,112,244,207,126,224,180,105,
  197,148,81,204,157,87,185,149,65,225,200,100,233,218,99,226,218,93,
  222,213,92,226,214,104,236,215,122,220,195,102,209,188,73,224,199,73,
  232,197,71,243,199,74,241,191,70,214,163,48,217,170,66,218,175,80,
  238,198,111,233,196,107,245,208,104,241,204,98,223,189,92,211,182,90,
  209,190,95,223,214,113,216,215,107,209,211,104,216,214,113,200,204,110,
  179,197,115,178,204,117,189,216,111,195,218,104,209,222,114,213,222,115,
  207,215,168,212,216,157,223,216,135,226,213,117,224,211,107,219,201,99,
  214,191,97,223,200,107,220,201,99,219,195,85,230,190,76,242,191,74,
  236,179,64,217,155,44,220,151,48,215,146,45,218,150,51,219,154,52,
  230,169,62,225,164,57,225,160,58,210,150,52,191,141,52,221,181,93,
  235,206,114,228,209,107,233,218,103,235,225,104,226,222,99,224,218,104,
  229,214,113,225,200,120,220,180,129,189,145,108,169,125,90,197,148,115,
  186,125,96,191,138,96,202,175,108,228,210,124,234,209,108,171,147,39,
  231,214,110,231,221,108,224,215,86,220,212,79,207,197,73,229,218,103,
  206,196,99,233,222,130,223,211,109,228,208,111,202,170,87,167,122,55,
  172,115,62,211,154,99,242,195,123,236,203,108,221,205,84,221,214,81,
  227,223,90,232,224,99,235,219,108,222,206,95,211,199,79,233,218,93,
  232,201,76,216,172,49,216,161,42,212,157,41,228,177,68,234,186,84,
  218,175,80,206,164,66,199,159,46,187,147,34,191,153,52,215,182,87,
  223,200,104,227,214,110,223,216,99,220,215,95,218,212,100,209,209,111,
  205,218,139,181,203,121,176,199,95,188,208,95,204,216,106,209,217,108,
  200,211,171,208,215,163,221,220,140,223,217,119,221,211,100,215,195,82,
  215,184,76,228,194,86,223,192,76,232,196,76,225,179,57,213,161,39,
  198,143,26,207,147,35,218,151,47,205,136,35,226,158,57,230,165,65,
  231,168,71,238,178,82,237,173,83,225,166,74,218,169,74,200,161,58,
  231,199,90,228,201,88,215,188,75,202,176,65,196,173,69,180,155,62,
  175,140,59,192,148,83,176,123,81,205,155,120,228,190,153,224,186,149,
  212,159,125,201,150,107,217,182,118,236,210,123,240,217,103,216,198,72,
  212,204,80,221,217,94,207,201,79,233,224,105,198,188,75,221,210,104,
  221,212,107,223,214,113,202,190,92,203,186,98,211,181,108,225,185,123,
  222,171,114,242,191,126,204,158,73,209,176,71,225,209,87,226,222,88,
  224,222,87,228,221,91,221,202,81,208,185,71,237,211,101,221,189,80,
  205,160,45,199,144,25,223,159,36,224,158,36,214,149,31,207,146,31,
  198,140,32,185,132,18,197,149,21,219,176,45,234,196,73,238,203,83,
  233,204,84,234,212,90,227,209,81,198,183,56,222,205,91,215,205,107,
  201,204,125,192,204,120,183,201,89,199,215,90,214,223,98,220,225,99,
  207,221,170,205,215,154,208,212,128,210,208,108,214,206,95,215,198,82,
  218,189,72,232,197,77,221,188,59,219,182,49,215,168,38,221,170,43,
  217,162,45,228,170,62,235,170,70,232,164,67,220,154,57,209,146,49,
  204,148,53,205,150,57,213,157,62,207,155,56,199,156,51,224,188,76,
  208,177,61,217,187,75,207,172,68,207,171,75,237,202,118,242,206,132,
  232,188,127,250,201,145,238,187,134,231,185,135,213,181,132,218,186,137,
  235,192,139,194,150,87,219,188,106,232,209,107,231,211,88,231,217,86,
  231,223,96,228,224,101,218,209,92,224,212,102,234,220,123,224,209,114,
  230,217,115,218,207,101,227,218,113,231,219,121,222,200,117,208,175,104,
  198,154,89,209,162,90,240,201,108,229,201,91,233,222,94,226,222,88,
  220,216,83,222,211,85,220,195,77,231,199,90,245,207,108,205,159,61,
  213,159,51,229,168,53,232,166,44,234,166,41,235,170,44,223,159,36,
  230,167,53,225,168,52,222,173,44,223,180,49,225,190,62,231,202,76,
  235,208,79,228,205,73,226,206,73,224,205,77,230,209,94,217,204,102,
  202,205,116,186,197,101,179,198,73,202,220,84,211,221,86,216,224,87,
  202,219,141,199,212,130,202,207,115,205,205,107,211,208,103,213,203,92,
  213,192,73,222,197,68,225,203,58,225,198,49,239,198,56,246,197,66,
  241,188,74,238,181,78,238,173,81,241,175,88,223,161,74,215,160,69,
  204,158,60,209,166,61,214,172,60,224,187,72,238,209,91,231,206,88,
  244,218,107,238,211,108,241,207,117,230,193,115,216,181,115,216,176,124,
  208,163,122,200,157,106,206,169,89,201,171,83,208,182,107,197,169,95,
  216,180,94,229,197,96,217,201,80,225,215,84,233,215,87,239,221,95,
  228,213,96,229,216,102,231,218,104,230,216,111,219,198,117,220,197,121,
  204,180,90,228,211,105,223,217,95,223,219,96,228,214,107,233,208,118,
  244,208,134,202,166,90,206,182,82,222,210,90,227,223,89,215,209,73,
  217,201,79,214,190,80,203,169,71,211,170,78,197,147,58,213,158,67,
  219,162,59,233,173,61,254,195,75,231,173,47,216,159,28,227,169,44,
  221,164,51,209,155,47,201,155,43,219,182,67,229,202,89,227,206,89,
  232,214,90,227,209,81,228,209,78,228,209,81,221,201,86,224,213,105,
  202,209,105,186,206,91,191,217,81,188,213,67,200,217,76,207,222,81,
  203,222,133,206,220,132,207,216,123,203,207,110,201,201,101,202,195,88,
  214,194,79,235,210,83,230,205,61,221,194,45,225,186,46,208,163,34,
  204,157,43,202,150,49,204,145,53,206,145,56,211,145,59,223,162,73,
  238,186,87,242,198,91,237,196,82,229,192,75,223,194,76,215,192,76,
  208,186,75,213,188,85,197,168,76,190,159,76,218,191,114,220,191,123,
  200,166,105,213,180,109,229,205,107,228,206,104,229,208,119,229,205,117,
  233,203,105,242,219,105,225,216,85,225,219,83,229,214,85,190,171,51,
  208,187,82,229,210,108,230,213,107,231,212,117,182,158,86,219,191,126,
  226,198,124,217,196,103,226,221,103,223,222,96,228,217,102,229,209,110,
  189,158,78,195,164,84,219,203,105,228,221,105,222,219,90,228,219,90,
  235,212,96,204,173,65,191,156,54,226,186,90,234,188,94,221,168,72,
  226,167,67,234,172,69,214,154,44,199,142,26,219,166,38,205,151,25,
  202,147,31,214,160,52,218,170,62,234,193,85,232,201,93,221,198,86,
  232,213,92,228,210,82,229,213,78,229,212,80,227,211,90,219,212,98,
  189,201,89,174,198,78,165,196,59,181,210,70,193,213,79,199,216,84,
  206,220,143,207,222,141,205,220,129,191,202,106,189,197,96,195,190,86,
  221,193,84,231,192,75,216,177,48,205,167,34,209,169,38,214,172,51,
  224,187,73,241,200,94,241,193,91,245,185,87,247,171,77,232,151,59,
  212,142,46,221,159,60,199,141,41,219,170,67,208,171,64,207,179,69,
  216,192,82,233,213,101,210,188,79,210,192,80,225,214,99,229,220,103,
  225,215,94,228,215,100,226,209,101,236,218,118,211,194,102,214,194,105,
  233,206,115,222,200,99,224,214,99,228,222,98,234,220,98,231,211,98,
  195,171,75,203,178,88,232,212,117,226,204,118,217,190,123,179,150,94,
  199,172,117,204,183,116,218,209,116,221,214,110,228,213,112,233,210,116,
  229,201,118,215,188,107,225,210,119,221,212,109,226,216,105,237,222,105,
  221,196,78,211,182,62,233,205,80,237,209,86,204,171,56,217,174,69,
  220,160,62,215,148,57,194,127,38,199,135,37,217,162,43,232,181,54,
  234,178,57,235,178,62,226,169,54,221,169,57,219,175,66,232,196,84,
  242,212,90,229,206,74,228,212,67,219,207,63,218,205,74,216,211,91,
  176,190,77,165,189,77,163,192,73,184,212,93,198,216,106,195,210,105,
  206,217,151,205,217,143,206,219,131,196,208,108,193,200,96,206,202,94,
  215,191,85,226,190,80,230,191,72,229,189,67,238,194,73,241,196,79,
  235,195,82,231,191,80,221,178,66,219,165,57,206,132,33,189,109,14,
  189,119,24,204,139,45,229,168,75,221,171,74,222,184,83,235,207,100,
  235,215,103,234,217,103,229,212,94,229,218,94,229,225,92,225,226,88,
  231,228,85,224,216,83,234,216,106,209,189,94,211,196,105,219,203,116,
  203,178,98,228,206,120,225,211,112,227,217,106,229,214,99,190,172,62,
  226,203,110,232,208,120,237,217,122,228,207,118,219,192,121,230,204,145,
  232,210,153,227,209,145,205,192,113,219,208,116,211,195,97,224,204,107,
  218,195,102,229,208,119,228,213,122,233,220,124,227,214,110,227,209,97,
  227,205,85,225,200,71,228,206,69,226,204,69,229,204,85,230,196,89,
  214,161,69,214,151,71,236,174,101,237,178,98,215,166,61,224,173,58,
  232,172,60,234,167,60,214,145,44,228,164,67,223,170,76,223,183,85,
  211,180,72,213,191,69,219,204,63,221,209,65,225,213,79,220,216,93,
  190,204,93,191,214,106,188,215,100,196,221,104,203,221,111,204,217,111,
  212,219,165,213,218,152,221,221,133,212,213,109,203,203,89,218,215,98,
  217,203,94,231,210,101,232,209,95,227,194,79,234,184,71,243,187,74,
  225,174,59,199,149,34,193,148,29,201,154,40,203,143,45,215,154,63,
  223,168,75,233,183,88,187,138,43,203,161,63,244,215,113,230,209,104,
  234,218,107,228,215,100,238,223,104,233,222,98,228,220,93,223,218,88,
  236,225,97,233,214,94,188,159,59,191,161,73,231,214,134,220,206,133,
  212,189,122,225,201,131,223,203,117,221,203,105,209,195,86,217,203,94,
  202,186,88,226,210,112,223,209,102,202,187,84,218,197,114,233,213,140,
  225,211,136,218,205,127,213,196,114,228,211,121,224,206,104,231,214,106,
  234,220,111,228,214,109,227,211,115,224,208,113,220,202,100,220,203,89,
  223,206,76,223,205,67,228,209,71,234,214,83,231,208,96,242,212,114,
  248,206,124,236,189,119,234,192,132,238,199,134,219,181,96,200,151,59,
  202,132,47,213,131,55,215,131,61,204,126,62,198,143,78,196,159,89,
  214,193,114,226,212,115,217,203,80,222,208,75,228,213,86,224,217,100,
  190,198,95,180,199,94,175,199,79,188,211,81,203,220,88,205,218,86,
  207,212,156,208,211,142,212,211,119,208,205,98,202,202,88,212,211,95,
  213,204,99,222,207,104,225,204,97,220,188,75,208,157,40,201,142,22,
  199,143,22,210,158,36,229,183,61,234,187,71,247,192,92,234,177,87,
  220,167,75,196,147,54,219,168,76,232,188,91,232,198,98,222,199,93,
  233,216,108,228,214,105,223,209,100,210,197,83,217,208,89,227,219,94,
  224,211,81,212,190,71,218,185,90,234,201,122,220,197,127,216,197,131,
  233,208,151,229,203,142,220,198,125,218,200,114,229,216,114,198,185,81,
  197,181,86,219,203,107,224,211,106,223,212,107,204,189,98,215,198,116,
  184,169,88,214,198,120,210,191,114,231,210,129,224,208,113,222,207,104,
  204,192,84,200,188,80,198,182,84,194,178,80,216,198,96,231,215,102,
  229,215,90,232,218,87,237,218,89,231,211,90,224,203,96,204,180,84,
  202,167,83,195,157,82,197,162,98,224,189,123,239,203,119,197,150,62,
  185,113,37,195,112,46,221,136,79,243,170,115,220,170,111,209,178,114,
  211,193,121,214,200,111,207,195,75,227,214,83,235,221,96,217,210,96,
  188,195,100,191,208,112,192,215,99,198,221,91,202,218,85,204,216,80,
  213,220,150,214,221,141,211,217,117,208,214,106,210,216,106,208,209,105,
  220,207,115,219,195,105,218,191,88,224,188,74,225,176,48,232,178,44,
  239,187,52,245,196,67,243,197,75,227,175,63,213,150,47,208,139,46,
  214,148,61,212,148,61,234,168,81,219,160,68,238,193,92,236,203,98,
  226,203,99,211,193,93,210,191,99,222,207,112,228,220,113,232,226,102,
  231,220,78,236,219,87,240,211,117,227,194,123,194,163,99,195,165,105,
  232,201,144,195,171,111,217,199,133,222,210,134,226,212,123,214,197,107,
  231,206,124,200,178,95,222,209,117,208,199,104,218,208,113,229,213,126,
  196,176,103,206,185,118,216,197,129,222,205,135,220,202,128,206,189,109,
  221,204,116,213,197,102,211,197,98,212,200,98,228,217,111,231,219,111,
  228,211,103,234,216,106,229,208,99,205,187,79,196,181,78,207,187,88,
  204,172,73,198,159,64,204,164,77,219,178,88,239,196,94,209,157,56,
  202,134,49,195,123,47,203,138,70,210,160,91,194,160,86,200,175,95,
  216,191,107,220,201,99,223,213,82,219,212,70,219,210,83,211,207,99,
  188,198,112,176,195,113,176,198,97,192,215,101,206,221,104,208,219,101,
  208,214,150,215,223,148,208,219,125,201,214,109,196,209,103,185,192,89,
  208,199,108,211,190,97,225,198,93,226,191,73,234,187,55,243,191,53,
  233,185,49,220,171,42,214,165,47,216,160,51,227,163,57,222,152,54,
  213,144,53,207,137,51,203,129,44,217,150,61,199,147,46,225,186,81,
  217,190,85,207,188,86,215,196,104,235,220,127,226,217,112,227,218,101,
  229,217,83,231,212,84,223,197,102,183,151,78,174,143,79,219,187,130,
  203,174,114,212,188,124,220,205,140,192,180,108,222,207,126,219,201,115,
  199,172,93,233,208,128,230,216,128,222,213,122,191,181,86,230,214,127,
  206,183,113,230,206,142,214,195,129,228,210,144,226,209,140,227,210,138,
  203,184,105,201,181,95,219,200,106,223,210,108,218,207,101,209,201,94,
  213,202,96,222,207,104,228,208,109,225,205,108,221,205,110,233,211,112,
  224,187,81,224,180,71,229,185,80,222,178,71,228,186,68,220,170,57,
  220,157,62,227,161,77,236,179,98,223,176,94,230,199,108,226,200,103,
  232,202,104,227,201,91,215,202,72,219,212,79,222,211,93,203,198,96,
  184,192,109,182,200,114,183,204,99,193,212,94,208,219,97,212,220,98,
  206,206,170,212,216,166,204,216,140,196,213,119,183,206,100,180,198,90,
  203,204,102,215,204,98,219,202,84,228,200,74,236,196,64,228,182,47,
  216,168,40,221,171,50,227,173,64,234,176,69,203,141,32,223,159,53,
  221,155,58,223,154,63,218,144,59,204,134,48,203,149,51,227,186,81,
  215,188,75,226,206,93,227,211,98,228,216,106,228,217,109,230,217,112,
  235,212,108,224,197,94,219,190,88,229,199,109,226,201,135,213,191,133,
  213,193,124,215,195,122,204,186,114,211,195,120,220,205,124,211,193,107,
  212,188,100,234,210,120,221,206,113,212,199,105,223,207,119,226,209,127,
  222,203,127,224,204,133,218,200,126,212,194,118,219,206,127,227,212,131,
  224,206,124,214,189,105,231,201,115,238,213,120,229,216,111,225,222,107,
  223,224,107,222,219,106,234,216,116,234,209,117,221,195,111,218,182,96,
  222,173,70,236,183,69,228,181,65,213,171,50,214,177,45,231,190,64,
  243,185,78,232,166,72,222,157,67,226,170,75,230,187,82,228,192,80,
  215,179,65,221,192,75,220,200,85,220,203,95,224,204,109,211,197,108,
  192,195,108,182,194,94,185,202,74,205,220,77,211,219,71,216,221,69,
  208,209,167,207,212,158,199,211,137,198,219,128,192,219,116,201,223,115,
  208,216,107,219,213,101,225,209,88,219,194,67,225,188,56,221,179,45,
  218,173,44,222,173,54,220,164,55,225,164,58,235,175,65,234,176,66,
  232,174,67,216,154,55,220,154,60,211,147,57,218,168,73,205,166,63,
  226,196,82,230,207,91,226,209,95,236,222,115,228,213,112,174,154,59,
  184,158,65,232,204,107,238,209,107,235,209,114,233,209,139,206,182,122,
  194,169,105,210,187,120,212,193,127,225,208,139,220,202,126,220,202,120,
  227,208,116,235,214,121,224,203,114,217,192,108,224,197,120,229,201,127,
  227,203,131,226,207,131,227,212,129,211,201,114,219,207,123,205,190,107,
  206,185,102,217,192,108,207,180,93,219,194,101,220,208,100,224,221,104,
  219,220,100,223,220,103,228,214,107,196,173,77,214,188,103,235,201,114,
  239,191,91,216,164,55,212,162,49,234,190,69,224,187,55,229,188,60,
  209,155,47,197,136,43,210,146,58,202,146,53,207,165,57,208,176,57,
  222,192,68,226,200,77,227,206,89,230,211,108,225,208,120,205,197,112,
  198,203,109,199,213,100,203,218,77,213,224,68,220,224,67,224,224,64,
  212,217,137,209,217,132,207,220,128,204,224,125,199,223,125,199,220,119,
  209,216,110,219,215,105,222,202,87,230,202,79,226,191,61,225,189,53,
  221,183,48,218,173,46,228,172,61,229,168,62,236,180,71,231,179,67,
  221,174,58,218,168,55,232,178,72,214,162,61,203,165,68,226,194,93,
  222,188,80,226,195,87,228,205,109,229,207,121,222,195,116,187,159,75,
  210,186,86,235,212,106,237,215,114,229,204,114,234,199,131,187,146,90,
  206,166,117,213,181,134,223,205,159,200,187,134,212,192,129,225,206,129,
  231,215,127,234,212,126,213,176,106,216,170,110,187,139,77,202,156,96,
  220,182,119,220,198,123,220,218,118,212,215,112,224,214,129,230,211,132,
  217,196,113,223,203,116,228,213,120,232,220,120,226,216,103,215,206,89,
  214,202,84,225,210,93,223,211,91,231,218,104,227,214,110,227,207,112,
  213,180,87,220,177,83,215,165,70,231,179,77,229,182,66,218,173,56,
  223,173,74,231,181,96,235,183,110,236,190,115,225,195,99,217,195,83,
  220,202,76,220,204,69,221,205,70,222,210,88,215,210,118,168,174,88,
  174,191,89,185,206,85,194,212,66,213,222,67,219,218,68,225,219,71,
  213,219,129,217,226,133,208,223,122,186,205,100,175,198,92,189,208,103,
  207,216,111,218,214,107,227,205,93,235,205,83,231,198,67,225,192,53,
  225,192,53,223,183,51,222,167,50,226,169,56,230,178,66,225,178,64,
  230,188,70,235,193,75,213,168,53,220,178,68,225,190,86,202,169,64,
  217,181,71,223,189,82,221,195,100,224,200,112,227,199,116,180,153,64,
  217,194,92,230,209,104,227,207,112,217,191,107,186,148,77,219,174,115,
  210,166,117,202,167,125,190,171,128,208,196,148,221,200,145,221,197,133,
  207,186,107,199,173,98,195,155,96,231,183,134,191,138,86,198,149,91,
  217,179,117,211,189,113,225,223,120,221,222,118,218,203,122,222,198,126,
  209,183,109,229,208,127,222,209,115,228,217,112,234,218,107,245,225,112,
  217,195,84,219,199,87,229,214,99,227,216,101,226,213,108,231,213,115,
  227,201,108,230,193,102,236,192,97,226,176,77,217,164,58,212,159,53,
  203,153,54,206,159,71,210,163,93,218,178,109,223,192,110,222,200,99,
  223,207,85,220,206,71,229,211,75,226,214,94,200,199,109,175,184,101,
  177,198,93,188,213,85,200,216,66,212,219,63,221,219,72,227,220,77,
  205,211,137,209,218,135,205,219,121,196,216,103,195,219,97,204,225,106,
  210,218,117,211,207,108,223,203,91,238,210,85,232,202,68,229,198,58,
  209,175,39,201,161,29,224,175,46,224,173,48,221,175,55,230,187,72,
  217,174,61,215,175,61,232,195,78,221,185,65,200,158,40,238,195,80,
  226,189,74,225,193,80,230,202,95,215,191,85,229,211,99,220,203,95,
  231,209,108,222,197,105,221,193,110,191,159,82,196,163,86,236,199,128,
  224,184,123,191,156,102,217,198,142,226,210,158,196,178,130,222,196,147,
  203,168,112,203,167,109,225,192,141,221,187,139,179,138,84,223,185,123,
  214,191,121,206,191,110,224,216,118,222,212,117,209,187,112,184,154,92,
  207,174,120,207,178,112,223,204,112,231,210,105,235,202,95,224,191,84,
  223,198,95,232,212,113,235,217,119,225,206,111,232,205,114,230,199,108,
  231,201,105,227,195,92,222,188,78,210,170,59,206,153,51,211,152,52,
  221,163,56,226,172,72,227,181,96,235,191,118,237,194,126,229,192,111,
  223,197,84,214,194,69,222,197,79,228,209,107,201,195,119,202,209,131,
  194,213,108,198,219,90,206,221,68,209,217,56,217,220,67,221,221,73,
  202,207,141,207,216,137,207,222,121,199,220,101,190,215,85,192,214,88,
  203,211,108,214,210,111,223,205,95,231,205,84,225,197,62,212,183,45,
  219,186,53,223,186,54,222,175,45,236,187,59,226,182,61,210,169,53,
  219,178,70,233,196,89,222,190,79,213,178,62,240,191,70,224,174,53,
  228,189,70,217,185,66,223,194,76,219,197,78,226,214,92,234,223,107,
  221,202,100,220,195,103,204,173,90,222,191,108,226,196,110,221,190,108,
  236,202,131,229,198,133,225,205,136,212,194,130,208,185,133,211,183,133,
  214,178,118,230,192,130,209,174,118,215,182,128,196,161,103,224,195,129,
  236,219,141,212,201,111,211,199,101,217,202,107,210,185,105,223,192,127,
  209,174,120,221,190,126,236,213,120,200,175,72,197,157,61,189,146,54,
  228,194,107,204,178,93,211,189,103,237,211,126,214,178,92,196,157,66,
  202,164,63,225,188,81,227,194,79,241,204,90,230,179,74,209,155,49,
  195,142,28,198,151,37,197,155,55,201,164,75,209,170,93,216,180,96,
  225,199,89,229,207,87,231,205,92,226,208,108,192,189,110,188,197,116,
  176,193,87,184,203,75,204,216,68,211,217,65,214,219,77,215,219,83,
  204,211,143,210,219,138,204,220,113,187,207,84,176,198,72,183,203,80,
  199,211,99,214,213,105,217,200,92,229,204,88,226,199,70,232,204,69,
  222,193,63,218,183,57,236,192,69,224,178,58,223,181,63,235,198,84,
  230,193,87,212,178,80,237,204,109,230,192,91,214,163,45,233,182,57,
  217,173,52,226,190,68,225,197,71,229,209,84,220,210,95,218,207,101,
  225,208,104,229,207,105,235,213,111,236,213,111,214,187,84,232,203,109,
  234,207,128,233,207,132,208,186,103,206,181,99,180,150,80,229,196,125,
  223,197,112,222,192,104,207,163,88,244,199,131,205,172,105,234,210,136,
  229,212,122,229,215,116,228,219,114,228,217,112,222,202,107,226,198,114,
  197,164,93,236,207,131,232,214,114,237,215,113,247,205,123,207,156,90,
  209,163,101,201,162,95,216,185,105,229,197,110,219,180,89,200,154,58,
  200,151,48,209,161,53,214,167,59,238,195,83,233,194,75,217,178,57,
  218,182,59,220,189,64,220,192,69,222,200,81,224,203,94,224,203,98,
  228,206,95,225,204,87,231,211,88,222,211,95,203,209,113,195,210,115,
  194,214,101,203,222,96,213,223,88,210,215,86,212,216,105,210,215,112,
  208,215,147,206,218,134,203,220,106,198,217,91,191,213,87,190,210,87,
  198,211,93,211,214,99,215,202,88,227,206,87,228,204,78,223,198,69,
  230,202,76,228,196,73,217,177,55,219,177,56,233,193,72,228,193,77,
  214,181,76,227,194,97,223,189,99,216,178,81,223,173,58,225,173,51,
  221,175,55,229,191,66,233,206,73,223,206,76,222,211,95,223,212,104,
  232,214,106,233,212,107,225,202,100,171,148,46,217,192,91,242,213,119,
  235,204,122,173,142,60,231,206,113,215,191,95,210,177,96,227,196,114,
  224,204,107,230,206,106,197,156,66,217,172,87,238,210,127,223,201,115,
  234,214,119,216,201,100,223,214,111,224,216,109,223,205,97,207,183,83,
  209,183,99,215,188,107,229,206,110,235,209,114,226,185,106,178,130,64,
  215,167,103,185,142,74,229,190,113,214,173,91,221,175,89,223,173,78,
  224,169,66,206,148,41,211,149,46,214,157,50,232,185,69,244,205,86,
  231,195,81,232,203,86,230,205,78,229,211,77,225,212,81,220,211,82,
  225,213,93,225,212,97,225,212,100,212,207,103,199,209,120,178,199,106,
  182,205,91,197,216,90,214,221,89,217,222,96,210,216,110,207,214,118,
  205,214,147,206,218,134,210,227,112,210,230,99,198,219,90,186,205,80,
  194,208,87,214,218,97,205,198,68,226,209,79,231,210,85,235,211,89,
  226,200,79,221,191,67,235,200,72,233,194,63,225,188,58,208,174,51,
  224,194,84,229,200,96,206,173,68,227,189,82,235,189,78,211,161,46,
  228,182,62,214,176,51,218,191,58,220,204,69,225,211,86,225,210,91,
  215,195,82,225,200,99,224,188,104,228,193,112,232,206,119,234,204,118,
  189,141,65,199,152,70,236,207,105,228,207,102,202,177,87,220,194,110,
  205,185,96,222,202,105,236,207,105,214,185,81,225,201,95,217,195,94,
  230,205,113,208,187,96,221,208,114,229,218,113,196,179,61,223,203,88,
  229,212,122,234,211,131,217,185,102,229,191,106,237,199,114,219,182,94,
  200,163,72,223,183,95,189,143,66,213,163,90,208,154,80,218,162,79,
  229,171,71,225,161,55,231,153,53,206,126,29,207,135,37,209,148,55,
  210,162,78,218,179,88,227,194,81,234,210,76,232,218,69,224,218,68,
  225,224,84,223,222,106,222,215,134,210,210,146,194,210,147,172,196,118,
  174,197,89,187,207,76,205,214,73,213,220,82,209,219,97,204,217,103,
  194,203,146,200,212,140,207,219,119,206,221,102,203,222,96,206,223,95,
  206,220,97,211,217,95,213,208,82,225,210,85,226,205,88,226,203,89,
  231,209,90,231,206,80,226,196,62,222,188,52,218,184,51,232,198,72,
  224,195,78,208,178,68,222,190,79,231,195,83,236,193,81,230,185,70,
  214,172,52,232,194,71,219,191,65,233,212,84,223,205,77,222,204,80,
  220,197,83,219,190,88,190,152,67,230,195,114,230,205,121,190,164,79,
  201,155,77,248,202,117,238,209,105,205,184,77,201,181,86,215,195,108,
  223,205,121,229,207,121,218,192,95,239,210,108,210,182,82,220,191,97,
  215,185,99,233,207,122,221,206,113,232,217,116,216,194,83,228,204,94,
  233,214,120,208,183,99,209,163,86,224,175,96,210,171,80,227,191,97,
  197,160,71,223,181,95,232,183,104,213,157,80,211,152,74,215,152,72,
  227,163,75,245,177,80,236,157,54,210,131,26,216,140,42,223,157,63,
  226,170,85,223,178,87,222,184,75,227,200,69,228,213,58,226,221,59,
  226,224,77,219,220,103,215,215,145,204,211,160,184,208,150,179,207,130,
  188,214,104,200,220,87,212,221,78,215,222,82,213,223,98,208,221,105,
  201,208,174,205,212,168,208,215,148,211,220,129,212,225,107,201,216,87,
  192,204,80,196,201,83,215,207,100,210,193,89,230,208,106,234,212,103,
  223,202,85,229,205,79,215,187,52,226,197,61,233,200,69,230,196,72,
  215,183,60,221,188,72,235,201,91,234,198,88,228,189,70,227,188,67,
  233,196,79,209,174,58,203,171,58,227,198,81,223,197,74,219,193,72,
  230,203,90,220,192,85,214,187,80,218,195,93,210,191,97,222,202,115,
  222,196,111,224,197,108,234,209,109,223,202,97,217,202,101,224,209,116,
  203,185,109,230,206,134,197,160,82,231,190,111,225,185,116,186,147,78,
  236,198,123,228,198,112,231,211,114,230,207,111,223,187,103,236,198,115,
  237,209,112,212,177,83,211,154,75,204,143,63,218,171,79,189,147,61,
  212,166,106,205,156,97,237,186,103,236,182,86,210,145,51,215,145,59,
  173,98,31,217,145,69,242,180,69,223,168,42,196,140,21,208,151,35,
  231,176,59,228,178,63,232,195,80,227,199,73,225,205,54,233,219,60,
  233,217,72,226,215,97,213,214,138,182,196,135,160,187,118,159,189,101,
  164,189,71,187,205,69,212,219,79,212,215,82,209,218,103,208,219,114,
  185,194,167,194,202,165,204,208,149,208,214,128,206,217,97,196,210,75,
  192,205,74,201,207,85,216,209,103,214,199,98,227,206,101,228,206,94,
  226,206,83,225,205,74,227,204,64,229,202,63,228,198,68,210,176,53,
  223,188,70,237,201,87,204,168,54,218,183,67,232,196,76,235,199,77,
  218,183,65,207,171,59,224,189,85,229,194,92,234,200,92,234,200,90,
  222,188,81,221,189,80,230,205,87,222,200,88,211,193,93,220,205,112,
  227,214,120,207,193,96,233,215,113,229,212,106,226,214,106,232,218,121,
  209,191,115,237,210,143,167,129,58,236,191,123,213,168,109,206,162,101,
  204,157,87,216,175,95,228,197,107,223,189,102,188,137,71,176,123,53,
  209,168,76,218,174,79,203,142,59,231,166,84,199,144,51,225,173,87,
  195,139,80,220,164,103,224,171,79,236,182,74,231,167,57,235,165,69,
  200,125,58,207,138,69,240,187,83,236,190,68,211,163,39,227,177,54,
  227,175,55,230,184,64,230,196,73,226,202,68,222,202,51,218,199,45,
  223,201,63,231,218,104,196,199,120,157,174,106,168,195,116,187,214,117,
  200,222,95,208,223,82,218,223,81,211,214,83,209,217,105,207,218,114,
  195,206,176,203,212,165,211,218,138,213,221,112,209,220,89,203,216,74,
  204,217,77,215,222,90,223,218,101,219,206,92,216,198,74,226,207,76,
  229,211,77,225,206,67,233,211,65,227,202,58,228,198,66,230,195,79,
  235,200,98,203,166,62,212,173,54,223,185,60,223,191,72,223,190,75,
  215,178,61,231,193,82,231,192,97,217,176,88,219,173,88,206,160,72,
  231,189,91,235,198,91,229,196,81,227,200,87,211,192,90,225,213,113,
  220,211,106,224,217,110,223,215,106,222,212,101,230,217,103,228,211,107,
  217,196,115,227,201,127,203,170,91,228,191,113,221,187,115,234,191,122,
  181,122,52,220,160,90,218,169,102,200,149,84,204,140,78,203,138,70,
  206,151,69,219,168,77,232,177,86,212,156,63,238,178,82,203,138,46,
  212,144,59,228,163,73,235,178,75,224,168,55,231,171,49,224,162,49,
  229,168,79,211,152,72,186,131,48,230,177,83,225,175,64,217,171,59,
  232,190,90,236,202,95,228,206,71,228,211,61,231,211,60,214,196,52,
  207,189,63,211,199,97,190,193,116,168,181,111,150,172,87,183,206,100,
  197,215,79,204,217,67,214,220,72,219,223,86,208,219,97,205,219,106,
  196,211,172,201,214,158,212,219,126,214,222,101,213,224,86,210,222,76,
  210,224,79,217,225,88,220,216,91,215,205,81,212,195,65,229,211,73,
  228,211,71,224,206,62,229,208,65,229,203,64,236,205,78,236,203,87,
  217,184,79,205,168,62,229,189,67,225,186,57,203,168,48,227,192,76,
  234,191,78,234,190,85,211,167,78,219,174,91,204,153,70,220,168,82,
  228,182,88,212,170,68,235,197,88,218,188,78,221,204,98,231,220,112,
  225,218,102,216,209,93,212,206,94,220,208,98,234,211,99,233,204,102,
  214,186,103,230,198,123,235,198,118,196,155,75,229,190,113,204,156,80,
  178,108,36,229,154,86,229,165,104,172,107,51,255,184,125,195,124,58,
  238,179,103,206,154,68,226,176,79,235,182,80,232,170,69,227,160,56,
  192,121,15,209,138,32,236,173,68,213,155,47,224,165,45,218,159,39,
  206,149,44,219,163,70,237,176,96,204,148,63,212,165,57,217,180,66,
  209,180,80,217,195,84,213,196,56,220,205,50,232,217,66,232,215,75,
  227,208,88,213,201,99,203,205,122,168,181,101,190,207,113,197,214,100,
  208,221,81,214,223,72,220,225,79,208,214,80,209,219,104,206,219,113,
  193,211,161,199,214,147,213,220,124,218,224,102,214,222,84,208,217,72,
  202,213,74,202,210,73,210,207,74,208,199,70,222,204,78,224,205,74,
  224,207,65,224,205,64,231,208,78,235,207,82,228,198,76,207,177,53,
  213,185,60,225,196,70,220,180,56,215,174,48,227,190,60,230,190,66,
  211,158,52,225,170,77,238,191,103,211,165,77,220,170,71,231,179,78,
  190,140,45,227,183,88,222,184,83,216,189,84,228,216,106,223,216,99,
  214,203,79,220,208,86,216,206,95,231,209,107,230,188,90,212,161,70,
  228,182,105,232,185,113,199,147,74,214,160,86,221,165,90,185,122,43,
  203,121,39,198,111,32,252,175,107,188,114,53,235,156,97,228,157,95,
  217,163,91,247,201,116,221,176,73,239,189,78,245,188,75,210,147,33,
  221,154,37,225,155,44,197,128,33,229,163,69,211,148,42,221,160,45,
  216,153,40,214,150,44,216,147,54,240,181,87,233,193,82,210,186,64,
  215,200,75,221,208,77,221,206,63,222,206,58,222,208,59,227,210,70,
  234,208,87,216,195,88,198,199,105,200,214,119,190,203,97,208,219,97,
  210,219,78,215,223,76,220,223,90,217,222,104,209,219,122,206,219,131,
  200,218,168,205,220,155,218,225,130,221,226,106,213,219,83,207,216,73,
  204,215,77,205,213,78,211,208,75,206,196,65,226,208,84,211,191,66,
  224,206,72,231,211,78,237,213,87,228,202,79,218,188,66,214,185,57,
  224,200,64,216,189,56,218,182,59,231,189,69,251,206,81,218,167,50,
  204,145,45,216,155,66,216,162,76,220,170,81,227,177,80,216,167,65,
  223,171,72,222,173,78,201,162,67,233,203,105,219,201,91,219,205,83,
  208,189,60,228,207,82,222,199,93,222,186,92,235,175,89,190,123,42,
  199,140,64,233,175,101,216,156,84,200,136,64,218,151,73,221,144,64,
  214,122,39,225,132,52,216,138,66,226,152,89,203,122,67,210,135,78,
  198,144,74,238,192,107,235,187,85,195,145,34,223,171,59,206,149,34,
  210,145,29,240,172,63,216,150,56,197,134,41,223,166,63,221,165,56,
  220,162,52,216,158,50,222,163,61,207,156,51,221,188,72,234,213,86,
  226,213,75,223,212,68,227,213,65,230,216,67,224,212,64,225,207,69,
  230,204,83,216,196,84,182,188,80,167,183,74,198,211,93,204,215,85,
  208,217,74,209,216,76,213,219,97,206,213,110,209,216,138,206,215,148,
  196,212,175,199,212,158,213,217,132,218,220,110,215,218,89,214,221,83,
  215,222,90,213,219,87,211,208,79,205,194,68,216,197,77,213,190,74,
  223,200,88,234,211,95,232,209,81,224,200,66,225,200,71,234,207,76,
  219,193,56,222,195,62,229,199,79,248,206,96,229,167,66,216,148,51,
  208,143,49,209,145,55,204,144,56,225,169,86,219,170,91,230,183,95,
  216,165,60,224,175,70,215,174,84,214,177,88,243,210,103,215,183,64,
  230,197,68,234,198,75,180,134,36,230,172,88,224,148,72,205,127,52,
  218,150,69,211,146,66,231,164,86,203,131,55,214,135,56,232,143,63,
  213,111,36,207,113,41,239,171,100,227,163,101,224,143,96,185,105,56,
  209,149,77,239,188,99,240,186,88,196,144,42,202,159,55,229,181,79,
  201,138,35,232,167,63,242,185,82,204,155,50,212,170,62,230,189,84,
  240,201,100,224,186,85,217,184,71,236,206,86,218,190,65,228,204,72,
  234,213,72,227,211,63,228,215,61,228,217,63,230,216,67,224,208,69,
  214,193,74,204,194,81,178,192,71,184,206,80,189,206,76,207,219,83,
  211,220,79,211,218,86,210,216,108,209,214,130,206,212,152,204,210,162,
  199,210,176,199,209,159,210,215,135,216,222,116,215,224,99,212,222,89,
  205,216,85,194,203,74,197,197,73,200,191,74,202,186,75,225,203,101,
  215,191,93,228,205,99,221,200,72,229,210,71,231,209,72,222,198,62,
  228,205,67,233,207,71,236,204,81,236,193,81,217,151,55,209,135,46,
  214,148,54,215,151,61,213,148,66,212,150,73,238,185,105,212,161,72,
  228,174,68,223,170,64,201,157,68,235,198,110,227,189,88,231,191,78,
  241,199,81,223,173,62,182,128,32,243,178,94,199,119,46,207,127,54,
  221,152,74,227,165,82,230,163,85,209,136,59,210,127,47,246,154,77,
  206,105,35,187,95,28,231,166,98,253,193,133,221,138,98,166,84,37,
  215,149,73,221,167,71,236,181,80,208,157,52,197,152,51,246,198,98,
  225,168,65,203,145,38,239,189,78,232,190,78,195,161,54,214,182,81,
  232,201,108,231,203,106,223,202,87,232,212,87,234,211,83,230,208,73,
  230,212,68,230,216,67,229,218,74,222,214,71,229,217,81,223,212,84,
  206,199,83,208,211,96,192,211,86,191,214,84,203,220,88,204,217,85,
  206,217,87,210,219,104,208,217,126,200,207,140,202,208,162,202,208,172,
  204,208,171,204,211,159,208,216,139,210,222,122,206,221,102,196,215,87,
  188,205,75,184,199,74,191,198,82,196,193,88,205,192,100,213,195,109,
  228,207,118,215,193,91,228,210,82,227,210,70,229,210,69,228,207,66,
  229,208,67,233,207,68,227,189,54,214,164,41,213,152,46,222,158,61,
  221,155,61,214,148,62,217,150,79,240,174,100,216,151,57,215,152,47,
  229,167,68,219,165,69,213,170,78,228,193,101,236,206,110,234,198,101,
  240,187,95,181,122,30,234,181,85,228,171,81,192,116,41,227,153,82,
  225,169,94,207,155,79,211,147,73,232,158,83,191,115,37,238,156,82,
  204,112,49,194,108,47,189,121,58,255,189,134,233,147,112,171,87,41,
  211,140,60,210,151,47,222,169,57,219,167,55,195,141,35,229,175,69,
  244,193,78,217,168,50,201,151,38,231,187,78,234,201,96,211,181,83,
  216,185,95,235,206,112,235,211,101,238,218,97,231,211,86,233,219,84,
  225,219,73,227,222,79,229,223,103,220,212,101,213,202,94,184,182,71,
  182,195,81,177,196,81,173,192,77,186,204,86,198,214,92,203,218,99,
  208,219,114,208,218,129,206,215,150,206,216,166,198,209,169,197,208,174,
  205,208,177,205,211,167,206,215,148,208,221,131,208,226,114,204,225,98,
  199,220,89,197,216,88,194,205,87,202,205,100,191,182,89,210,194,106,
  221,202,107,219,201,93,224,209,80,228,212,73,225,208,66,224,205,64,
  233,212,71,230,203,62,219,180,41,227,178,49,231,178,66,218,159,59,
  214,151,56,230,166,79,228,162,86,209,144,62,212,145,40,224,158,48,
  230,164,67,233,177,84,212,169,77,234,199,109,206,175,84,216,176,88,
  227,168,88,191,129,46,235,182,86,222,168,72,205,134,56,232,162,90,
  227,175,99,208,159,82,211,145,71,235,163,87,192,119,42,227,149,75,
  218,132,71,196,111,54,194,123,61,249,177,119,234,149,108,207,124,72,
  226,154,70,237,176,70,205,153,41,225,174,59,217,161,50,200,146,37,
  228,182,71,237,195,85,225,183,75,202,163,58,223,191,90,226,198,99,
  211,183,84,216,189,84,229,208,91,229,211,83,233,221,87,227,220,80,
  229,226,85,220,216,90,216,206,109,223,213,128,180,173,82,190,195,93,
  184,204,89,165,190,70,182,202,81,196,211,92,203,219,97,204,218,105,
  201,215,118,199,210,134,199,208,153,199,210,168,199,210,176,198,212,179,
  196,202,188,198,203,180,202,208,162,208,216,143,208,223,120,205,224,98,
  198,222,84,196,219,79,187,204,74,178,186,65,203,197,85,204,190,81,
  224,207,93,229,210,90,209,194,67,230,216,83,229,213,74,229,210,71,
  230,204,68,227,194,61,223,186,53,220,179,51,220,171,53,215,163,54,
  222,166,69,229,170,78,218,155,62,210,148,49,222,164,56,239,179,69,
  202,137,37,199,138,45,222,178,91,216,180,94,209,169,81,240,194,106,
  219,158,75,218,156,69,214,159,59,211,153,54,197,130,51,230,162,87,
  238,180,98,206,148,64,218,149,71,228,155,78,190,114,38,222,144,72,
  232,148,84,207,126,63,196,123,55,234,161,93,220,140,79,218,139,72,
  219,147,62,234,171,74,228,175,73,216,168,60,239,192,74,209,163,51,
  210,169,77,240,203,115,239,206,111,206,176,78,208,178,82,221,194,91,
  228,203,84,214,193,65,225,207,73,226,215,73,223,222,69,223,226,75,
  222,217,89,227,214,110,221,199,126,196,177,111,198,195,114,172,182,83,
  167,188,69,188,214,81,192,213,76,199,217,79,201,218,86,201,216,97,
  202,214,116,200,211,133,198,207,152,197,208,166,199,210,176,199,210,180,
  193,205,193,195,204,183,201,207,169,205,214,149,210,221,125,206,224,104,
  199,223,85,195,220,77,192,212,78,198,209,81,209,209,87,198,187,69,
  213,198,79,226,207,87,228,209,91,220,204,82,223,209,76,221,203,65,
  221,193,60,227,194,63,229,199,65,221,186,56,215,174,50,223,176,62,
  225,176,71,213,160,56,231,174,67,207,149,39,219,168,53,204,151,39,
  204,139,39,206,145,54,232,187,104,205,167,84,231,185,97,236,183,91,
  225,166,74,218,155,62,213,153,55,216,156,60,202,138,51,240,176,89,
  237,174,81,203,138,46,225,154,74,230,157,80,190,115,34,235,160,79,
  233,154,77,232,154,79,201,129,57,217,147,75,208,136,54,222,150,65,
  221,151,63,213,150,57,236,184,85,208,166,58,224,185,68,230,194,82,
  211,175,87,220,189,106,229,207,108,226,207,104,213,189,89,211,187,79,
  233,212,85,231,213,75,226,210,71,225,217,72,219,222,69,221,225,79,
  224,218,98,229,213,118,229,205,135,199,180,112,181,181,95,176,189,84,
  178,198,75,188,211,77,195,216,77,200,218,82,200,217,89,199,213,99,
  201,212,116,200,211,133,200,209,152,202,211,168,196,206,172,195,205,178,
  192,208,182,192,207,176,196,207,164,201,211,148,205,218,128,206,223,111,
  203,224,95,200,222,85,198,218,84,198,213,84,196,200,79,204,201,86,
  202,190,80,221,204,98,228,206,107,223,202,95,219,204,77,217,199,63,
  228,200,67,233,203,69,229,201,68,228,200,67,228,193,67,219,179,57,
  219,179,57,210,165,46,229,177,65,217,166,51,233,184,63,215,164,47,
  214,150,52,195,133,46,214,169,88,230,190,105,218,169,76,221,166,65,
  223,165,58,208,146,43,225,161,71,224,163,72,209,151,51,240,182,75,
  225,161,53,221,152,51,232,159,80,243,167,92,191,120,32,229,159,61,
  213,145,36,228,160,61,201,131,59,200,132,59,202,138,38,226,164,55,
  226,161,67,205,146,54,211,163,61,223,185,76,201,169,58,225,197,90,
  229,201,102,217,195,93,223,212,97,228,219,100,230,214,103,225,205,92,
  218,197,72,234,215,84,227,215,81,221,215,79,224,224,90,218,217,91,
  230,220,107,226,212,113,209,193,105,210,201,110,202,206,96,190,204,83,
  164,183,58,188,208,83,197,215,93,201,219,101,204,217,109,201,213,113,
  199,209,122,195,206,130,197,207,147,202,211,166,200,209,178,198,208,184,
  187,204,172,189,206,170,194,209,168,198,213,158,203,217,142,203,218,123,
  200,217,102,196,215,89,187,207,76,183,200,72,194,205,85,199,206,94,
  193,190,87,207,194,98,218,197,108,231,207,109,222,203,83,227,207,74,
  231,207,71,231,205,68,230,203,70,226,199,66,220,190,58,215,182,51,
  223,189,56,232,195,65,222,177,58,227,181,61,221,173,47,220,168,50,
  212,149,52,216,156,70,214,169,88,239,198,110,204,155,50,237,181,68,
  211,153,43,212,150,47,227,164,71,221,160,67,212,158,49,222,167,50,
  222,159,43,227,158,54,231,159,77,230,157,80,209,139,44,224,157,50,
  218,156,37,215,152,46,218,154,80,209,147,72,217,161,50,225,170,53,
  226,168,71,237,183,93,211,169,71,229,196,91,223,195,88,215,191,81,
  226,204,92,230,214,93,221,216,88,223,220,91,229,220,101,232,217,100,
  219,201,77,223,205,77,226,213,83,229,220,91,222,217,91,226,221,103,
  227,218,113,207,199,101,198,193,99,186,184,83,191,196,76,195,206,78,
  201,218,90,195,213,91,201,218,104,199,214,111,198,208,119,199,208,129,
  202,209,141,200,208,148,197,204,153,196,204,163,194,203,176,193,202,181,
  191,206,175,194,209,178,196,213,179,196,214,172,197,214,160,201,214,144,
  201,212,120,198,210,100,191,207,82,205,224,96,189,210,91,178,196,88,
  181,188,92,184,180,91,221,201,115,225,201,105,223,200,84,229,209,78,
  222,205,63,224,206,62,233,209,75,222,195,62,212,186,47,227,200,59,
  228,199,61,231,199,64,221,186,60,222,181,57,230,179,52,218,161,45,
  217,154,57,232,175,88,235,190,105,216,176,78,224,179,52,230,179,51,
  215,158,51,211,151,53,232,174,74,216,159,54,220,167,53,218,163,44,
  215,156,38,220,156,48,216,149,62,214,146,61,226,161,61,234,172,63,
  223,166,53,201,146,45,228,172,95,206,153,73,224,176,68,212,165,51,
  214,166,66,242,198,109,224,188,100,219,190,96,240,216,108,223,202,83,
  220,201,72,229,216,78,222,215,75,222,218,84,220,215,95,223,217,97,
  230,219,91,221,208,77,225,211,86,233,222,96,222,212,81,228,219,98,
  202,198,101,189,189,103,189,195,105,200,208,107,201,206,88,201,208,79,
  205,218,87,199,215,90,197,210,102,193,206,116,193,200,132,197,201,150,
  205,207,168,203,207,174,200,203,172,197,203,175,200,208,185,200,207,189,
  196,209,183,194,208,182,188,206,180,184,203,173,186,202,165,193,206,153,
  203,211,136,205,215,118,203,218,99,188,210,84,164,193,74,175,203,93,
  182,199,105,185,189,102,184,172,86,225,202,108,231,208,96,228,207,80,
  224,211,71,226,214,70,227,203,67,221,195,59,221,198,58,229,206,64,
  233,208,64,231,204,65,221,192,62,227,189,62,225,174,47,228,169,51,
  216,157,55,226,171,78,223,179,84,209,168,60,234,194,60,218,174,41,
  224,171,65,220,164,69,235,180,77,209,155,46,210,159,44,221,168,52,
  196,140,29,225,168,63,205,144,51,219,158,65,216,154,51,224,166,59,
  227,169,70,207,154,62,230,184,98,193,150,58,229,185,78,222,180,68,
  223,184,81,222,189,94,217,190,99,223,201,102,227,207,92,237,220,90,
  233,220,79,226,216,69,232,222,75,228,221,79,224,220,94,223,222,96,
  227,222,92,227,218,89,228,213,96,226,211,96,234,220,97,214,204,89,
  201,200,108,214,222,137,193,207,110,186,199,93,202,209,93,202,208,86,
  199,207,85,205,215,100,185,197,97,191,202,123,199,204,150,202,203,169,
  201,201,177,196,198,177,198,202,177,205,211,185,198,206,183,198,206,183,
  191,202,185,190,203,185,185,204,185,184,203,183,188,204,178,195,207,167,
  204,213,148,209,219,132,194,212,100,169,195,72,158,194,72,160,197,83,
  161,187,86,173,188,95,192,191,101,196,181,86,228,207,100,227,206,89,
  224,211,83,220,208,72,225,204,63,229,206,64,232,210,75,236,214,77,
  232,210,65,219,194,50,232,206,70,223,188,58,225,176,47,221,165,42,
  226,170,57,222,171,62,225,184,70,221,185,65,230,193,63,215,175,51,
  220,178,70,236,188,88,231,179,77,210,157,51,227,176,67,204,156,48,
  199,147,48,238,188,93,209,159,60,214,162,61,209,156,54,229,170,76,
  227,165,88,217,162,82,232,192,96,206,172,65,218,177,69,235,197,88,
  217,186,80,218,197,90,219,205,98,220,209,91,234,220,87,233,221,77,
  234,223,81,225,217,72,231,220,68,229,222,72,228,225,86,222,222,90,
  216,217,87,228,224,101,230,216,111,230,212,112,221,208,104,190,185,85,
  188,193,101,186,197,101,199,213,102,207,222,105,207,219,107,205,214,107,
  191,196,93,165,171,75,180,190,103,163,174,105,200,206,158,198,202,169,
  192,194,170,189,191,167,194,199,169,196,203,170,191,200,169,188,199,169,
  186,199,179,188,203,184,187,204,186,188,205,186,192,206,181,198,210,174,
  203,214,158,204,218,141,188,210,110,180,208,95,171,209,90,164,201,85,
  164,196,87,183,204,103,193,200,105,182,177,83,196,180,82,221,203,95,
  223,208,89,227,214,84,229,211,75,230,211,73,241,221,88,227,207,72,
  219,198,57,225,202,60,222,195,56,218,184,50,227,183,50,228,179,50,
  229,178,53,227,179,55,227,189,62,234,201,72,228,194,71,215,180,64,
  216,182,75,234,196,95,235,187,87,210,161,59,235,190,89,210,166,69,
  198,153,60,233,188,95,220,180,84,226,187,86,206,161,58,227,174,80,
  216,154,81,213,158,78,226,189,83,208,179,61,223,186,69,233,197,83,
  213,189,79,221,208,94,218,214,89,219,217,82,230,222,79,231,221,74,
  229,224,81,223,218,74,230,221,68,231,222,69,231,226,82,221,222,86,
  219,221,94,214,212,99,225,215,120,213,198,113,198,188,101,199,195,104,
  182,188,92,186,197,92,198,211,93,204,219,102,203,220,118,205,218,128,
  205,210,126,192,196,120,183,193,124,166,175,118,188,195,153,194,198,165,
  191,195,162,195,199,164,201,208,167,188,196,157,179,189,154,181,192,160,
  184,204,169,189,206,174,193,208,179,194,207,179,196,207,175,196,208,168,
  195,209,158,191,210,146,186,211,130,179,208,115,176,210,100,175,208,93,
  175,204,88,178,200,91,179,195,96,179,186,93,192,187,95,201,189,89,
  224,209,90,223,208,83,222,208,86,234,218,96,228,210,76,224,204,69,
  223,200,70,230,203,70,204,176,33,224,192,47,220,184,44,232,193,56,
  230,184,46,236,193,55,232,198,62,235,205,73,217,184,68,218,188,78,
  220,195,92,234,205,103,231,187,88,207,158,65,240,203,114,206,171,81,
  199,161,64,229,193,96,221,191,103,234,204,114,213,175,74,228,180,80,
  214,154,68,205,150,60,225,192,79,225,200,73,222,189,56,227,196,69,
  225,205,93,220,213,97,220,225,83,220,226,76,230,225,81,228,223,80,
  224,225,85,220,222,77,227,224,71,228,223,71,222,217,73,226,224,89,
  222,222,100,219,217,114,210,207,126,199,196,125,170,170,96,187,189,105,
  201,204,97,206,214,95,208,218,103,204,217,112,201,216,131,200,213,141,
  198,207,144,194,201,147,196,204,157,184,192,151,189,196,155,198,205,163,
  193,199,151,180,187,135,181,190,137,187,196,149,169,179,144,160,171,141,
  185,207,169,188,208,171,194,208,175,195,206,174,195,205,171,192,204,166,
  187,204,160,183,203,152,191,215,153,184,211,132,184,212,112,189,216,103,
  186,212,89,174,198,78,173,195,86,188,202,104,186,190,96,186,182,82,
  200,190,69,222,208,85,226,214,104,226,213,101,230,212,86,225,205,74,
  231,210,85,221,196,69,212,181,39,225,195,47,219,191,47,228,197,54,
  234,193,49,229,188,44,234,203,63,225,198,65,213,184,64,225,199,88,
  230,212,104,227,204,102,220,180,82,211,168,74,237,206,116,199,173,80,
  200,168,65,229,200,98,214,190,102,229,208,117,226,199,94,228,190,83,
  216,163,67,213,163,64,231,202,84,238,215,83,226,198,55,224,198,61,
  229,212,96,221,216,99,221,227,91,221,229,84,227,226,84,228,225,86,
  224,227,86,221,225,86,225,223,86,227,221,83,228,222,84,226,222,89,
  223,221,102,213,213,115,194,197,126,173,179,117,196,204,129,178,185,92,
  206,209,92,216,220,100,212,220,119,202,214,132,196,211,146,191,205,152,
  191,199,158,195,202,168,189,198,167,197,207,173,198,206,169,198,205,163,
  199,205,157,197,205,154,175,183,134,163,171,132,178,186,162,162,171,152,
  183,207,175,187,206,176,192,205,177,194,203,174,194,203,172,194,205,173,
  189,206,174,185,205,168,188,210,164,193,215,150,195,216,125,195,215,102,
  192,213,86,184,205,74,176,200,76,181,201,86,172,184,82,180,183,78,
  198,194,69,213,205,81,215,206,101,219,207,105,226,209,95,227,207,84,
  230,208,86,221,196,69,233,205,69,212,184,41,227,205,57,226,202,52,
  235,200,54,213,178,36,233,205,69,220,196,64,225,200,71,231,207,85,
  232,214,102,218,197,92,216,184,85,229,195,97,229,206,102,207,186,79,
  204,177,70,231,206,103,217,199,101,226,211,110,233,215,105,228,202,91,
  214,175,70,234,196,87,233,211,92,234,215,84,236,214,68,227,206,63,
  220,206,84,228,220,109,222,222,110,223,224,105,224,224,92,227,226,86,
  222,227,85,222,225,94,220,218,107,220,216,106,224,219,93,224,219,89,
  223,218,98,197,197,99,176,186,123,190,204,143,175,190,97,207,217,104,
  202,206,85,214,218,108,210,216,144,198,208,158,193,204,164,184,198,165,
  185,197,173,197,209,187,198,208,183,189,198,169,196,203,169,191,199,162,
  184,190,154,202,207,175,189,193,170,180,184,169,162,167,161,162,168,166,
  187,205,189,189,206,188,192,204,182,193,203,179,194,204,179,194,207,181,
  192,207,184,190,209,181,187,205,167,194,212,154,199,213,128,199,212,106,
  199,215,90,193,213,80,180,203,71,170,195,68,171,190,75,183,193,78,
  205,210,82,185,186,59,184,177,73,210,197,101,216,199,95,235,215,102,
  229,208,89,231,207,81,229,205,71,211,186,44,229,207,61,229,207,59,
  222,194,50,221,194,53,235,211,75,222,200,65,230,208,71,225,205,74,
  228,209,89,220,200,88,222,198,90,237,213,105,222,205,91,221,206,89,
  210,189,74,229,209,94,229,216,104,228,216,104,229,218,102,226,211,94,
  219,194,78,238,213,95,231,217,95,231,221,89,235,221,73,228,214,65,
  222,210,72,228,219,98,224,219,117,225,222,119,224,223,96,227,228,88,
  223,226,85,224,226,101,220,216,125,219,213,129,223,214,111,205,197,86,
  202,199,92,197,201,106,175,189,112,165,182,104,202,217,114,200,213,97,
  212,219,107,214,219,127,202,209,155,194,204,170,196,207,177,190,202,178,
  185,198,181,191,203,189,192,203,187,197,206,185,195,204,173,191,198,165,
  195,199,172,180,185,163,143,146,137,169,173,172,196,201,205,191,196,202,
  192,203,207,192,204,204,192,204,194,191,204,187,192,205,187,193,206,186,
  191,206,187,191,205,179,195,207,167,197,208,148,201,210,129,204,214,115,
  203,216,102,198,213,88,189,209,78,183,204,73,175,196,69,189,208,80,
  183,199,66,172,181,54,181,174,68,196,181,86,215,196,101,229,207,105,
  230,208,96,233,212,87,215,195,60,223,202,61,228,202,65,232,206,69,
  217,193,57,234,212,75,231,212,74,223,204,65,224,205,64,226,207,68,
  228,207,80,227,207,86,227,213,90,229,218,94,221,207,85,228,214,91,
  219,204,75,227,214,83,233,219,94,228,218,94,222,218,93,222,218,93,
  222,212,88,226,216,92,224,220,95,231,228,97,227,221,75,227,221,63,
  226,218,57,225,217,72,228,220,113,230,222,121,227,223,97,230,229,89,
  226,225,85,227,224,107,220,214,138,219,209,150,222,205,136,198,184,109,
  166,167,87,185,196,104,175,191,82,175,189,75,203,215,107,207,215,116,
  213,221,136,206,216,147,196,205,158,193,205,169,196,212,175,194,209,178,
  188,201,181,189,201,189,199,208,203,188,195,187,198,206,183,201,210,181,
  196,201,178,201,205,188,187,189,184,171,175,178,178,182,191,158,165,173,
  190,195,217,190,198,211,187,201,201,187,203,192,190,204,189,192,205,187,
  192,203,186,193,201,178,195,201,165,199,203,153,203,205,142,199,203,126,
  192,201,108,193,206,98,196,212,88,193,213,80,195,213,79,181,202,63,
  182,205,63,181,199,65,196,200,89,197,192,92,182,170,70,201,187,82,
  222,202,89,227,205,83,223,203,70,230,207,75,234,206,83,226,200,79,
  228,208,85,224,209,80,224,206,72,225,206,67,222,204,60,238,219,80,
  233,210,80,227,207,82,227,217,86,226,219,89,223,212,88,225,211,86,
  226,217,80,228,219,80,223,213,82,226,217,88,225,222,93,223,223,91,
  221,219,84,224,224,92,217,219,96,224,224,100,229,227,90,229,226,73,
  218,214,45,227,221,63,230,221,104,230,223,116,227,224,95,230,226,90,
  228,219,88,230,219,111,221,210,144,219,207,157,206,190,131,183,172,106,
  155,159,83,174,187,97,200,214,103,193,205,93,201,210,117,202,209,132,
  202,211,148,202,212,162,199,211,173,195,209,176,191,206,173,184,198,172,
  183,194,178,190,197,190,191,197,197,198,203,197,197,202,182,198,204,178,
  201,204,183,186,188,174,167,168,163,165,165,167,166,165,170,172,173,178,
  188,188,222,135,141,167,162,179,186,186,205,199,191,208,192,190,203,183,
  200,207,189,196,198,177,201,200,172,200,195,165,199,194,164,175,176,136,
  149,159,98,188,201,119,190,203,95,201,216,89,196,210,71,187,205,57,
  194,217,67,197,222,79,189,209,86,164,178,64,172,179,63,196,193,76,
  197,180,62,203,179,57,215,185,61,227,197,77,230,201,97,228,204,104,
  224,210,105,224,213,98,224,207,77,227,208,69,231,212,73,231,213,77,
  231,212,83,230,215,88,230,219,93,227,217,93,223,213,92,229,219,95,
  226,218,83,227,219,84,225,215,92,231,223,99,227,220,87,226,223,82,
  221,220,76,223,224,88,224,224,110,222,222,112,221,219,98,226,222,86,
  232,227,71,220,217,62,223,220,89,228,226,103,226,223,92,227,220,90,
  231,217,95,228,213,112,212,197,130,190,177,122,166,157,88,189,188,106,
  186,195,106,167,180,90,199,211,129,210,220,149,210,218,159,194,200,152,
  191,199,158,192,202,168,192,205,179,191,205,182,200,214,191,188,196,181,
  142,143,145,155,154,159,201,202,196,199,200,186,185,187,166,185,185,161,
  182,179,160,186,183,168,185,178,170,186,176,174,192,181,177,195,184,180,
  158,158,186,189,194,214,194,211,218,186,207,202,184,201,191,192,204,192,
  198,206,193,197,199,186,205,203,188,197,194,179,190,186,174,153,155,134,
  179,191,153,188,204,142,201,216,125,201,213,101,201,212,82,203,216,76,
  196,215,73,190,214,76,172,198,71,170,194,70,179,196,66,196,206,75,
  195,190,64,214,198,76,215,193,71,201,175,62,197,173,75,211,190,101,
  221,206,115,224,211,109,227,206,87,229,208,81,230,210,85,231,212,91,
  229,213,92,227,215,95,227,216,98,225,219,99,222,215,98,226,220,98,
  224,219,89,227,222,94,223,216,99,228,219,100,226,220,84,229,224,80,
  225,220,74,217,215,80,223,221,110,226,224,121,223,220,107,223,217,93,
  228,223,80,234,229,86,226,225,98,222,222,100,223,221,100,229,222,105,
  232,219,105,227,213,114,194,180,107,191,182,113,162,156,78,185,185,97,
  205,211,115,198,207,118,204,211,144,199,206,155,204,206,169,202,205,174,
  204,208,181,188,196,172,194,206,184,195,206,189,191,200,183,196,202,192,
  192,187,191,186,180,184,187,182,176,173,170,155,184,181,162,192,190,167,
  203,198,178,203,196,178,192,182,170,204,191,182,211,197,186,208,194,183,
  204,203,209,196,201,204,184,201,195,184,205,200,176,194,196,147,162,167,
  179,190,192,197,207,206,185,191,191,179,184,180,147,153,143,187,196,179,
  177,196,168,185,207,161,189,206,136,202,215,125,205,212,106,209,217,98,
  200,211,89,192,208,84,179,199,74,184,207,75,182,205,63,182,204,61,
  193,206,74,187,192,64,201,199,76,215,208,92,209,195,96,210,190,101,
  206,185,102,192,168,80,214,189,89,217,193,87,218,194,94,222,202,103,
  224,209,106,224,213,108,222,215,109,226,222,114,219,218,102,221,221,101,
  222,222,100,227,225,104,225,219,105,226,220,100,227,221,85,231,224,81,
  231,224,81,226,219,86,229,223,111,225,220,116,223,215,106,228,218,103,
  227,217,93,227,221,99,225,222,115,220,220,120,227,225,124,223,220,117,
  213,206,99,203,199,92,171,168,75,188,186,99,205,197,114,207,199,114,
  218,217,124,217,217,131,208,208,146,205,204,160,200,195,166,200,195,173,
  193,193,169,191,193,171,191,196,176,186,194,173,181,186,166,178,181,164,
  191,184,176,190,181,176,198,191,185,178,171,161,199,193,177,195,190,168,
  195,189,165,195,189,167,197,188,171,211,202,185,198,186,170,200,188,172,
  203,199,188,194,196,185,193,205,195,188,204,201,144,158,167,125,138,154,
  185,199,212,182,196,205,157,170,176,159,171,171,187,198,192,184,198,183,
  181,203,182,185,209,175,187,205,153,191,206,137,202,214,130,199,208,115,
  197,207,110,192,205,100,199,213,99,193,213,82,189,211,66,179,201,54,
  169,186,54,185,200,75,189,199,76,198,203,83,214,211,104,209,201,103,
  205,189,102,221,205,117,212,198,101,209,195,98,201,186,95,201,187,98,
  201,191,96,204,195,100,207,198,103,217,212,112,215,211,101,219,216,101,
  222,218,108,225,221,113,227,220,114,227,221,109,225,222,93,227,223,87,
  224,216,81,229,220,93,227,219,110,224,216,115,221,212,107,230,219,113,
  230,220,109,226,217,112,216,213,120,212,212,124,205,203,116,200,197,104,
  184,180,80,178,176,73,187,189,90,189,190,97,214,205,126,214,202,126,
  219,214,130,214,213,133,202,201,145,200,198,160,185,179,157,187,182,163,
  183,182,161,190,194,171,187,195,172,177,186,165,168,176,155,169,172,153,
  199,196,181,199,193,181,205,198,188,204,198,184,193,188,166,185,181,152,
  185,180,148,183,178,146,185,178,150,163,156,130,181,174,148,186,180,156,
  185,173,151,202,195,177,187,190,181,189,198,197,149,157,168,172,180,201,
  178,190,214,123,138,157,148,166,170,186,202,201,192,207,204,182,199,189,
  183,206,186,177,202,172,188,206,168,179,197,149,191,211,152,185,204,140,
  188,203,134,191,202,123,205,216,114,205,215,93,205,216,77,198,209,70,
  194,204,81,197,208,90,187,201,78,190,205,80,204,215,93,193,202,85,
  186,191,88,203,210,107,189,201,93,191,204,98,195,202,107,207,210,119,
  206,205,112,205,199,105,198,187,98,200,187,93,209,196,92,219,206,101,
  222,207,112,218,207,115,224,215,124,225,220,120,221,222,103,221,221,97,
  230,224,102,233,223,108,219,211,110,227,221,123,229,221,123,229,219,121,
  226,217,116,221,213,115,211,207,118,201,199,116,189,186,105,144,139,55,
  187,182,91,202,199,104,171,172,78,211,210,127,221,211,149,214,204,145,
  201,198,129,188,191,124,179,182,135,182,186,153,172,171,151,184,185,167,
  162,167,144,179,189,164,174,188,165,179,194,173,193,206,188,162,173,156,
  154,158,141,161,162,144,204,199,180,139,133,109,178,174,139,209,206,165,
  189,186,141,199,197,149,195,192,149,206,203,162,203,199,162,204,201,166,
  197,177,150,187,172,149,201,195,181,186,187,182,193,192,198,194,196,211,
  119,126,145,166,178,194,194,208,211,188,203,200,183,195,193,192,207,202,
  185,206,191,180,202,181,190,204,181,195,210,181,179,201,162,184,207,161,
  187,203,154,194,206,142,195,205,116,205,215,103,206,215,86,205,215,84,
  209,218,103,189,199,87,191,204,86,192,211,83,175,195,61,172,194,60,
  191,211,88,200,221,104,176,200,80,176,201,84,181,200,93,196,211,110,
  196,204,101,202,207,105,203,200,107,205,199,103,201,194,88,217,208,103,
  220,207,115,211,199,115,224,212,128,225,216,125,221,216,112,225,219,109,
  218,206,98,232,217,116,226,212,123,227,215,129,215,200,117,212,197,112,
  211,197,109,215,204,114,192,187,95,178,174,83,169,167,80,158,156,71,
  206,201,117,210,208,125,212,214,131,213,213,141,197,191,139,195,191,144,
  189,192,135,187,195,138,185,193,152,182,191,160,169,177,156,181,190,171,
  186,198,176,176,190,167,173,192,170,175,197,176,180,199,179,187,205,183,
  191,203,181,176,181,158,195,190,170,198,191,165,187,183,148,195,192,151,
  191,189,141,190,188,140,194,191,146,209,206,163,200,198,159,206,204,166,
  203,176,149,173,149,123,191,176,153,203,194,177,200,189,183,180,172,170,
  176,176,176,200,204,205,198,204,202,194,200,198,168,172,171,195,201,199,
  158,170,166,181,192,186,197,204,196,190,198,183,183,199,173,188,208,173,
  189,205,168,189,206,152,185,202,122,195,212,110,198,213,96,201,214,96,
  204,213,108,204,212,109,195,205,90,184,201,71,186,210,64,196,222,73,
  191,220,80,182,209,76,175,198,66,175,196,67,180,200,79,193,214,95,
  182,203,84,187,210,93,185,205,94,180,198,88,172,187,70,192,200,88,
  191,191,93,181,174,86,198,186,102,198,180,94,199,178,85,213,189,93,
  211,184,93,206,178,94,202,174,101,204,176,111,207,182,118,220,196,132,
  199,177,104,199,183,98,204,197,93,193,191,82,197,195,94,190,189,96,
  210,209,126,200,200,126,201,201,137,185,186,129,195,194,150,201,203,163,
  199,208,161,187,203,158,170,188,150,164,183,153,164,179,158,167,181,164,
  182,199,181,152,171,152,153,176,156,168,193,171,171,195,169,169,192,163,
  169,189,154,194,205,175,178,175,158,192,183,168,176,168,147,180,173,145,
  192,187,155,191,187,152,193,189,154,192,188,153,191,188,157,203,200,169,
  168,137,117,176,149,128,188,167,146,174,157,137,186,167,153,206,189,179,
  192,182,170,191,187,175,200,197,190,210,207,202,198,195,190,198,197,192,
  156,161,157,198,202,201,193,193,191,205,208,201,198,206,191,189,202,182,
  186,202,176,179,197,157,184,206,141,184,208,124,197,217,120,203,219,121,
  203,213,126,201,210,119,203,211,108,201,215,94,197,218,79,195,220,77,
  195,223,87,195,222,91,194,216,82,190,210,77,190,212,78,199,222,90,
  178,205,76,186,215,89,184,212,93,176,204,85,172,196,74,191,211,90,
  187,196,89,173,175,74,190,183,92,184,171,79,185,166,72,205,185,90,
  195,176,82,187,167,80,203,182,103,204,184,111,193,174,105,198,181,111,
  176,162,87,211,201,114,206,203,96,199,199,89,209,209,113,194,196,113,
  199,200,132,196,197,140,191,193,144,174,176,136,180,180,146,186,190,157,
  190,202,166,186,204,166,183,203,166,193,215,177,192,211,179,164,183,153,
  120,135,112,142,160,138,177,199,176,175,198,170,166,190,156,192,214,176,
  184,202,164,184,193,162,195,192,173,190,181,166,188,180,161,190,182,159,
  190,185,156,183,178,146,190,186,151,182,178,141,199,195,157,205,203,164,
  182,153,147,198,171,162,198,174,162,214,191,177,198,170,158,188,162,149,
  151,133,113,178,163,144,195,183,169,199,186,177,185,173,161,200,190,178,
  193,191,179,200,200,190,208,206,194,201,201,191,195,197,192,196,202,198,
  193,205,195,185,203,179,184,207,163,184,209,152,186,211,145,198,218,149,
  198,210,146,202,209,139,200,205,123,210,216,118,202,215,101,206,221,104,
  197,215,105,200,220,107,194,212,90,198,218,87,200,221,82,202,225,85,
  180,203,69,200,222,95,190,212,86,190,212,88,192,212,87,203,222,96,
  190,206,82,187,201,80,190,198,86,188,194,84,174,178,67,198,202,91,
  191,199,88,182,191,82,192,199,93,203,210,104,184,193,88,204,212,111,
  187,194,101,200,207,112,206,214,111,204,211,116,188,194,122,192,195,142,
  205,207,168,196,200,167,186,187,155,182,183,152,193,191,168,204,203,182,
  184,192,169,183,198,169,178,197,152,167,190,136,188,207,151,192,209,155,
  198,210,170,163,174,140,124,138,105,140,154,119,169,184,143,196,208,168,
  205,212,179,196,199,170,202,200,175,203,197,173,199,193,169,184,178,152,
  184,179,149,178,174,137,194,190,145,196,193,140,199,197,138,194,194,132,
  199,170,172,220,192,191,202,177,170,192,165,154,170,138,127,157,128,112,
  167,142,120,203,185,163,204,187,171,207,191,176,196,178,164,205,192,176,
  194,188,172,189,187,172,190,187,172,178,175,166,143,141,142,195,199,202,
  182,191,188,164,181,165,182,207,175,186,213,168,184,210,162,188,208,155,
  196,209,156,200,208,148,201,202,132,210,214,127,205,211,111,207,218,113,
  199,213,115,201,218,114,198,215,100,199,219,88,204,225,84,206,228,85,
  189,211,76,206,227,96,199,220,93,199,220,93,202,221,95,211,230,102,
  198,218,85,197,217,86,198,214,90,196,211,92,183,196,78,202,220,100,
  191,212,95,182,207,87,191,212,91,206,228,104,188,209,88,206,226,111,
  192,209,107,201,217,119,200,212,112,198,208,121,182,190,131,183,187,150,
  196,200,175,196,199,178,185,187,163,174,174,150,185,182,163,202,200,185,
  195,199,184,191,204,178,185,204,158,177,199,137,187,207,138,185,201,136,
  189,198,151,198,206,165,184,194,157,175,186,146,162,171,128,169,176,135,
  182,185,154,183,183,155,202,198,171,201,197,168,205,199,173,200,195,166,
  199,194,162,181,178,137,189,185,137,189,187,128,212,212,142,214,214,140
} ;
#endif
